/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.rm;

import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.rm.RMProject;

public class RMEvent {
    @NotNull
    private final Action action;
    @NotNull
    private final RMProject project;
    @Nullable
    private final String resourcePath;
    @NotNull
    private final Map<String, Object> parameters;

    public RMEvent(@NotNull Action action, @NotNull RMProject project, @Nullable String resourcePath, @NotNull Map<String, Object> parameters) {
        this.action = action;
        this.project = project;
        this.resourcePath = resourcePath;
        this.parameters = parameters;
    }

    public RMEvent(@NotNull Action action, @NotNull RMProject project) {
        this(action, project, null, Map.of());
    }

    public RMEvent(@NotNull Action action, @NotNull RMProject project, @NotNull String resourcePath) {
        this(action, project, resourcePath, Map.of());
    }

    @NotNull
    public Action getAction() {
        return this.action;
    }

    @NotNull
    public RMProject getProject() {
        return this.project;
    }

    @Nullable
    public String getResourcePath() {
        return this.resourcePath;
    }

    @NotNull
    public Map<String, Object> getParameters() {
        return Map.copyOf(this.parameters);
    }

    public static enum Action {
        RESOURCE_DELETE,
        RESOURCE_ADD,
        PROJECT_DELETE,
        PROJECT_ADD,
        PROJECT_UPDATE;

    }
}

