/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.utils.rest;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.Strictness;
import com.google.gson.ToNumberPolicy;
import com.google.gson.ToNumberStrategy;
import java.lang.reflect.Type;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

public class RpcConstants {
    public static final int SC_OK = 200;
    public static final int SC_FORBIDDEN = 403;
    public static final int SC_UNSUPPORTED = 405;
    public static final int SC_NOT_FOUND = 404;
    public static final int SC_SERVER_ERROR = 500;
    public static final DateTimeFormatter ISE_TIMESTAMP_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss'Z'");
    public static final DateTimeFormatter ISE_DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    public static final Gson DEFAULT_GSON = new GsonBuilder().setStrictness(Strictness.LENIENT).setObjectToNumberStrategy((ToNumberStrategy)ToNumberPolicy.LONG_OR_DOUBLE).disableHtmlEscaping().serializeNulls().create();
    public static final Gson COMPACT_GSON = new GsonBuilder().setStrictness(Strictness.LENIENT).setObjectToNumberStrategy((ToNumberStrategy)ToNumberPolicy.LONG_OR_DOUBLE).setDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'").registerTypeAdapter(LocalDate.class, (Object)new LocalDateAdapter()).registerTypeAdapter(LocalDateTime.class, (Object)new LocalDateTimeAdapter()).disableHtmlEscaping().create();

    public static class LocalDateAdapter
    implements JsonSerializer<LocalDate> {
        public JsonElement serialize(LocalDate date, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(date.format(ISE_DATE_FORMATTER));
        }
    }

    public static class LocalDateTimeAdapter
    implements JsonSerializer<LocalDateTime> {
        public JsonElement serialize(LocalDateTime date, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(date.format(ISE_TIMESTAMP_FORMATTER));
        }
    }
}

