/*
 * Decompiled with CFR 0.152.
 */
package org.cugos.wkg;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.cugos.wkg.Coordinate;
import org.cugos.wkg.Dimension;
import org.cugos.wkg.Surface;
import org.cugos.wkg.Triangle;

public class Tin
extends Surface {
    private final List<Triangle> triangles;

    public Tin(List<Triangle> triangles, Dimension dimension) {
        this(triangles, dimension, null);
    }

    public Tin(List<Triangle> triangles, Dimension dimension, String srid) {
        super(dimension, srid);
        this.triangles = Collections.unmodifiableList(triangles);
    }

    public List<Triangle> getTriangles() {
        return this.triangles;
    }

    @Override
    public boolean isEmpty() {
        return this.triangles.isEmpty();
    }

    @Override
    public int getNumberOfCoordinates() {
        int numberOfCoordinates = 0;
        for (Triangle triangle : this.triangles) {
            numberOfCoordinates += triangle.getNumberOfCoordinates();
        }
        return numberOfCoordinates;
    }

    @Override
    public List<Coordinate> getCoordinates() {
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
        for (Triangle triangle : this.triangles) {
            coordinates.addAll(triangle.getCoordinates());
        }
        return Collections.unmodifiableList(coordinates);
    }

    public static Tin createEmpty() {
        return new Tin(new ArrayList<Triangle>(), Dimension.Two, null);
    }
}

