/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.ui.editors.privileges;

import java.util.Arrays;
import java.util.List;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreObjectPrivilege;
import org.jkiss.dbeaver.ext.postgresql.model.PostgrePrivilege;
import org.jkiss.dbeaver.ext.postgresql.model.PostgrePrivilegeGrant;
import org.jkiss.dbeaver.ext.postgresql.model.PostgrePrivilegeOwner;
import org.jkiss.dbeaver.ext.postgresql.model.PostgrePrivilegeType;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreRole;
import org.jkiss.dbeaver.ext.postgresql.ui.editors.privileges.PermissionInfo;
import org.jkiss.dbeaver.ext.postgresql.ui.editors.privileges.PostgresPermissionsEditor;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseFolder;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseItem;
import org.jkiss.dbeaver.model.navigator.DBNUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseNavigatorTreeFilter;

public class ObjectPermissionsEditor
extends PostgresPermissionsEditor<PostgreRole> {
    private PostgrePrivilegeType[] supportedPrivilegeTypes;

    @Override
    protected PostgrePrivilege grantPrivilege(PostgrePrivilegeType privilegeType, PostgreRole role) {
        PostgrePrivilegeOwner databaseObject = (PostgrePrivilegeOwner)this.getDatabaseObject();
        PostgrePrivilegeGrant grant = this.createGrant(databaseObject, role, privilegeType);
        return this.objectToPrivileges.compute(this.getObjectName((DBSObject)role), (key, value) -> {
            if (value != null) {
                value.addPermission(grant);
                return value;
            }
            return new PostgreObjectPrivilege(databaseObject, role.getRoleReference(), List.of(grant));
        });
    }

    @Override
    protected PostgrePrivilege revokePrivilege(PostgrePrivilegeType privilegeType, PostgreRole role) {
        return this.objectToPrivileges.computeIfPresent(this.getObjectName((DBSObject)role), (object, privileges) -> {
            privileges.removePermission(privilegeType);
            return privileges;
        });
    }

    @Override
    protected PostgrePrivilegeType[] getSupportedPrivilegeTypes(DBSObject object) {
        if (this.supportedPrivilegeTypes == null) {
            this.supportedPrivilegeTypes = this.loadSupportedPrivilegeTypes();
        }
        return this.supportedPrivilegeTypes;
    }

    private PostgrePrivilegeType[] loadSupportedPrivilegeTypes() {
        return (PostgrePrivilegeType[])Arrays.stream(((PostgrePrivilegeOwner)this.getDatabaseObject()).getDataSource().getSupportedPrivilegeTypes()).filter(it -> it.isValid() && it.supportsType(((PostgrePrivilegeOwner)this.getDatabaseObject()).getClass())).toArray(PostgrePrivilegeType[]::new);
    }

    @Override
    protected boolean doesSupportObject(DBSObject object) {
        return object instanceof PostgrePrivilegeOwner;
    }

    @Override
    protected PermissionInfo laodPermissionInfo(DBRProgressMonitor monitor) throws DBException {
        return new PermissionInfo(((PostgrePrivilegeOwner)this.getDatabaseObject()).getPrivileges(monitor, false), DBNUtils.getNodeByObject((DBRProgressMonitor)monitor, (DBSObject)((PostgrePrivilegeOwner)this.getDatabaseObject()).getDatabase(), (boolean)true));
    }

    @Override
    protected DatabaseNavigatorTreeFilter navigatorTreeFilter() {
        return new ObjectOwnerFiler();
    }

    private static class ObjectOwnerFiler
    extends DatabaseNavigatorTreeFilter {
        private ObjectOwnerFiler() {
        }

        public boolean select(Object element) {
            if (element instanceof DBNDatabaseFolder) {
                DBNDatabaseFolder item = (DBNDatabaseFolder)element;
                Class childrenClass = item.getChildrenClass();
                return childrenClass != null && PostgreRole.class.isAssignableFrom(childrenClass);
            }
            return this.isLeafObject(element);
        }

        public boolean isLeafObject(Object object) {
            DBNDatabaseItem item;
            return object instanceof DBNDatabaseItem && (item = (DBNDatabaseItem)object).getObject() instanceof PostgreRole;
        }
    }
}

