/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.db2.model;

import java.sql.Date;
import java.sql.ResultSet;
import java.sql.Timestamp;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.db2.DB2Utils;
import org.jkiss.dbeaver.ext.db2.model.DB2DataSource;
import org.jkiss.dbeaver.ext.db2.model.DB2Object;
import org.jkiss.dbeaver.ext.db2.model.DB2Table;
import org.jkiss.dbeaver.ext.db2.model.DB2Tablespace;
import org.jkiss.dbeaver.ext.db2.model.dict.DB2TablePartitionAccessMode;
import org.jkiss.dbeaver.ext.db2.model.dict.DB2TablePartitionStatus;
import org.jkiss.dbeaver.ext.db2.model.dict.DB2YesNo;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.rdb.DBSTable;
import org.jkiss.dbeaver.model.struct.rdb.DBSTablePartition;
import org.jkiss.utils.CommonUtils;

public class DB2TablePartition
extends DB2Object<DB2Table>
implements DBSTablePartition {
    private Integer partitionObjectId;
    private DB2Tablespace tablespace;
    private DB2Tablespace indexTablespace;
    private DB2Tablespace longTablespace;
    private DB2TablePartitionAccessMode accessMode;
    private DB2TablePartitionStatus status;
    private Integer seqNo;
    private Boolean lowInclusive;
    private String lowValue;
    private Boolean highInclusive;
    private String highValue;
    private Timestamp statsTime;
    private Long card;
    private Long nPages;
    private Long fPages;
    private Long overFLow;
    private Date lastUsed;

    public DB2TablePartition(DB2Table db2Table, ResultSet dbResult) throws DBException {
        super(db2Table, JDBCUtils.safeGetString((ResultSet)dbResult, (String)"DATAPARTITIONNAME"), JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"DATAPARTITIONID"), true);
        DB2DataSource db2DataSource = (DB2DataSource)db2Table.getDataSource();
        this.partitionObjectId = JDBCUtils.safeGetInteger((ResultSet)dbResult, (String)"PARTITIONOBJECTID");
        this.accessMode = (DB2TablePartitionAccessMode)CommonUtils.valueOf(DB2TablePartitionAccessMode.class, (String)JDBCUtils.safeGetString((ResultSet)dbResult, (String)"ACCESS_MODE"));
        this.status = (DB2TablePartitionStatus)CommonUtils.valueOf(DB2TablePartitionStatus.class, (String)JDBCUtils.safeGetString((ResultSet)dbResult, (String)"STATUS"));
        this.seqNo = JDBCUtils.safeGetInteger((ResultSet)dbResult, (String)"SEQNO");
        this.lowInclusive = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"LOWINCLUSIVE", (String)DB2YesNo.Y.name());
        this.lowValue = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"LOWVALUE");
        this.highInclusive = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"HIGHINCLUSIVE", (String)DB2YesNo.Y.name());
        this.highValue = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"HIGHVALUE");
        db2DataSource.isAtLeastV9_5();
        Integer tablespaceId = JDBCUtils.safeGetInteger((ResultSet)dbResult, (String)"TBSPACEID");
        this.tablespace = DB2Utils.findTablespaceById((DBRProgressMonitor)new VoidProgressMonitor(), (DB2DataSource)db2Table.getDataSource(), tablespaceId);
        Integer longTablespaceId = JDBCUtils.safeGetInteger((ResultSet)dbResult, (String)"LONG_TBSPACEID");
        this.indexTablespace = DB2Utils.findTablespaceById((DBRProgressMonitor)new VoidProgressMonitor(), (DB2DataSource)db2Table.getDataSource(), longTablespaceId);
        if (db2DataSource.isAtLeastV9_7()) {
            this.statsTime = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"STATS_TIME");
            this.card = JDBCUtils.safeGetLongNullable((ResultSet)dbResult, (String)"CARD");
            this.nPages = JDBCUtils.safeGetLongNullable((ResultSet)dbResult, (String)"NPAGES");
            this.fPages = JDBCUtils.safeGetLongNullable((ResultSet)dbResult, (String)"FPAGES");
            this.overFLow = JDBCUtils.safeGetLongNullable((ResultSet)dbResult, (String)"OVERFLOW");
            this.lastUsed = JDBCUtils.safeGetDate((ResultSet)dbResult, (String)"LASTUSED");
            Integer indexTablespaceId = JDBCUtils.safeGetInteger((ResultSet)dbResult, (String)"INDEX_TBSPACEID");
            this.longTablespace = DB2Utils.findTablespaceById((DBRProgressMonitor)new VoidProgressMonitor(), (DB2DataSource)db2Table.getDataSource(), indexTablespaceId);
        }
    }

    @NotNull
    public DBSTable getParentTable() {
        return (DBSTable)this.parent;
    }

    @Override
    @Property(viewable=true, editable=false, order=1)
    @NotNull
    public String getName() {
        return super.getName();
    }

    @Property(viewable=true, order=2)
    public DB2Table getTable() {
        return (DB2Table)this.parent;
    }

    @Property(viewable=false, order=3)
    public Integer getPartitionObjectId() {
        return this.partitionObjectId;
    }

    @Property(viewable=true, order=4, category="Tablespace")
    public DB2Tablespace getTablespace() {
        return this.tablespace;
    }

    @Property(viewable=false, order=5, category="Tablespace")
    public DB2Tablespace getIndexTablespace() {
        return this.indexTablespace;
    }

    @Property(viewable=false, order=6, category="Tablespace")
    public DB2Tablespace getLongTablespace() {
        return this.longTablespace;
    }

    @Property(viewable=true, order=7)
    public DB2TablePartitionAccessMode getAccessMode() {
        return this.accessMode;
    }

    @Property(viewable=true, order=8)
    public DB2TablePartitionStatus getStatus() {
        return this.status;
    }

    @Property(viewable=true, order=9)
    public Integer getSeqNo() {
        return this.seqNo;
    }

    @Property(viewable=true, order=10)
    public Boolean getLowInclusive() {
        return this.lowInclusive;
    }

    @Property(viewable=true, order=11)
    public String getLowValue() {
        return this.lowValue;
    }

    @Property(viewable=true, order=12)
    public Boolean getHighInclusive() {
        return this.highInclusive;
    }

    @Property(viewable=true, order=13)
    public String getHighValue() {
        return this.highValue;
    }

    @Property(viewable=false, order=20, category="Statistics")
    public Timestamp getStatsTime() {
        return this.statsTime;
    }

    @Property(viewable=false, order=21, category="Statistics")
    public Long getCard() {
        return this.card;
    }

    @Property(viewable=false, order=22, category="Statistics")
    public Long getnPages() {
        return this.nPages;
    }

    @Property(viewable=false, order=23, category="Statistics")
    public Long getfPages() {
        return this.fPages;
    }

    @Property(viewable=false, order=24, category="Statistics")
    public Long getOverFLow() {
        return this.overFLow;
    }

    @Property(viewable=false, order=40)
    public Date getLastUsed() {
        return this.lastUsed;
    }

    public boolean isSubPartition() {
        return false;
    }

    @Nullable
    public DBSTablePartition getPartitionParent() {
        return null;
    }
}

