/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.stream.exporter;

import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDContent;
import org.jkiss.dbeaver.model.data.DBDContentStorage;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.tools.transfer.DTUtils;
import org.jkiss.dbeaver.tools.transfer.stream.IStreamDataExporterSite;
import org.jkiss.dbeaver.tools.transfer.stream.exporter.StreamExporterAbstract;
import org.jkiss.dbeaver.utils.ContentUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class DataExporterMarkdownTable
extends StreamExporterAbstract {
    private static final String PROP_NULL_STRING = "nullString";
    private static final String PROP_FORMAT_NUMBERS = "formatNumbers";
    private static final String PROP_SHOW_HEADER_SEPARATOR = "showHeaderSeparator";
    private static final String PROP_CONFLUENCE_FORMAT = "confluenceFormat";
    private static final String PIPE_ESCAPE = "&#124;";
    private String rowDelimiter;
    private String nullString;
    private boolean showHeaderSeparator;
    private boolean confluenceFormat;
    private DBDAttributeBinding[] columns;
    private final StringBuilder buffer = new StringBuilder();

    @Override
    public void init(IStreamDataExporterSite site) throws DBException {
        super.init(site);
        Object nullStringProp = site.getProperties().get(PROP_NULL_STRING);
        this.nullString = nullStringProp == null ? null : nullStringProp.toString();
        this.rowDelimiter = GeneralUtils.getDefaultLineSeparator();
        this.showHeaderSeparator = CommonUtils.getBoolean((Object)site.getProperties().get(PROP_SHOW_HEADER_SEPARATOR), (boolean)true);
        this.confluenceFormat = CommonUtils.getBoolean((Object)site.getProperties().get(PROP_CONFLUENCE_FORMAT), (boolean)false);
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    @Override
    protected DBDDisplayFormat getValueExportFormat(DBDAttributeBinding column) {
        if (column.getDataKind() == DBPDataKind.NUMERIC && !Boolean.TRUE.equals(this.getSite().getProperties().get(PROP_FORMAT_NUMBERS))) {
            return DBDDisplayFormat.NATIVE;
        }
        return super.getValueExportFormat(column);
    }

    @Override
    public void exportHeader(DBCSession session) throws DBException, IOException {
        this.columns = this.getSite().getAttributes();
        this.printHeader(false);
        if (this.showHeaderSeparator && !this.confluenceFormat) {
            this.printHeader(true);
        }
    }

    private void printHeader(boolean separator) {
        if (this.confluenceFormat) {
            this.writeDelimiter();
        }
        this.writeDelimiter();
        int i = 0;
        int columnsSize = this.columns.length;
        while (i < columnsSize) {
            DBDAttributeBinding column = this.columns[i];
            String colName = column.getLabel();
            if (CommonUtils.isEmpty((String)colName)) {
                colName = column.getName();
            }
            if (!separator) {
                this.writeCellValue(colName);
            } else {
                int k = 0;
                while (k < colName.length()) {
                    this.getWriter().write(45);
                    ++k;
                }
            }
            this.writeDelimiter();
            if (this.confluenceFormat) {
                this.writeDelimiter();
            }
            ++i;
        }
        this.writeRowLimit();
    }

    @Override
    public void exportRow(DBCSession session, DBCResultSet resultSet, Object[] row) throws DBException, IOException {
        this.writeDelimiter();
        int i = 0;
        while (i < row.length && i < this.columns.length) {
            DBDAttributeBinding column = this.columns[i];
            if (DBUtils.isNullValue((Object)row[i])) {
                if (!CommonUtils.isEmpty((String)this.nullString)) {
                    this.getWriter().write(this.nullString);
                }
            } else if (row[i] instanceof DBDContent) {
                DBDContent content = (DBDContent)row[i];
                try {
                    DBDContentStorage cs = content.getContents(session.getProgressMonitor());
                    if (cs == null) {
                        this.writeCellValue("[NULL]");
                    }
                    if (ContentUtils.isTextContent((DBDContent)content)) {
                        this.writeCellValue(cs.getContentReader());
                    }
                    this.getSite().writeBinaryData(cs);
                }
                finally {
                    DTUtils.closeContents(resultSet, content);
                }
            } else {
                this.writeCellValue(super.getValueDisplayString(column, row[i]));
            }
            this.writeDelimiter();
            ++i;
        }
        this.writeRowLimit();
    }

    @Override
    public void exportFooter(DBRProgressMonitor monitor) throws DBException, IOException {
    }

    private void writeCellValue(String value) {
        this.buffer.setLength(0);
        int i = 0;
        while (i < value.length()) {
            char c = value.charAt(i);
            if (c == '|') {
                this.buffer.append(PIPE_ESCAPE);
            } else {
                this.buffer.append(c);
            }
            ++i;
        }
        value = this.buffer.toString();
        this.getWriter().write(value);
    }

    private void writeCellValue(Reader reader) throws IOException {
        try {
            int count;
            char[] buffer = new char[2000];
            block3: while ((count = reader.read(buffer)) > 0) {
                int i = 0;
                while (true) {
                    if (i >= count) continue block3;
                    if (buffer[i] == '|') {
                        this.getWriter().write(PIPE_ESCAPE);
                    } else {
                        this.getWriter().write(buffer[i]);
                    }
                    ++i;
                }
                break;
            }
        }
        finally {
            ContentUtils.close((Closeable)reader);
        }
    }

    private void writeDelimiter() {
        this.getWriter().write(124);
    }

    private void writeRowLimit() {
        this.getWriter().write(this.rowDelimiter);
    }
}

