/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.model.application.ui.menu;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.e4.ui.model.application.ui.menu.InternalItemType;

public enum ItemType implements InternalItemType
{
    PUSH(0, "Push", "Push"),
    CHECK(1, "Check", "Check"),
    RADIO(2, "Radio", "Radio");

    public static final int PUSH_VALUE = 0;
    public static final int CHECK_VALUE = 1;
    public static final int RADIO_VALUE = 2;
    private static final ItemType[] VALUES_ARRAY;
    public static final List<ItemType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ItemType[]{PUSH, CHECK, RADIO};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ItemType get(String literal) {
        ItemType[] itemTypeArray = VALUES_ARRAY;
        int n = VALUES_ARRAY.length;
        int n2 = 0;
        while (n2 < n) {
            ItemType result = itemTypeArray[n2];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++n2;
        }
        return null;
    }

    public static ItemType getByName(String name) {
        ItemType[] itemTypeArray = VALUES_ARRAY;
        int n = VALUES_ARRAY.length;
        int n2 = 0;
        while (n2 < n) {
            ItemType result = itemTypeArray[n2];
            if (result.getName().equals(name)) {
                return result;
            }
            ++n2;
        }
        return null;
    }

    public static ItemType get(int value) {
        switch (value) {
            case 0: {
                return PUSH;
            }
            case 1: {
                return CHECK;
            }
            case 2: {
                return RADIO;
            }
        }
        return null;
    }

    private ItemType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

