/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs;

import java.net.URI;
import java.util.concurrent.Future;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.widgets.LabelFactory;
import org.eclipse.jface.widgets.LinkFactory;
import org.eclipse.jface.widgets.TextFactory;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ui.ShellUtils;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.BlockingPopupDialog;
import org.jkiss.dbeaver.ui.internal.UIMessages;

public class CodeAuthDialog
extends Dialog
implements BlockingPopupDialog {
    private final URI browserUrl;
    private final String userCode;
    private final Future<Void> future;

    public CodeAuthDialog(@NotNull Shell shell, @NotNull URI browserUrl, @NotNull String userCode, @NotNull Future<Void> future) {
        super(shell);
        this.browserUrl = browserUrl;
        this.userCode = userCode;
        this.future = future;
        this.setShellStyle(67680);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.getShell().setText(UIMessages.dialog_auth_code_title);
        ((LabelFactory)LabelFactory.newLabel((int)64).text(UIMessages.dialog_auth_code_browser_label).layoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create())).create((Widget)composite);
        LinkFactory.newLink((int)0).text("<a>" + String.valueOf(this.browserUrl) + "</a>").onSelect(e -> {
            boolean bl = ShellUtils.launchProgram(this.browserUrl.toString());
        }).create((Widget)composite);
        ((LabelFactory)LabelFactory.newLabel((int)64).text(UIMessages.dialog_auth_code_code_label).layoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create())).create((Widget)composite);
        Text userCodeText = (Text)((TextFactory)((TextFactory)TextFactory.newText((int)0x1000008).text(this.userCode).font(JFaceResources.getFont((String)"org.eclipse.jface.headerfont"))).layoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create())).create((Widget)composite);
        userCodeText.addFocusListener(FocusListener.focusGainedAdapter(e -> userCodeText.selectAll()));
        userCodeText.addMouseListener(MouseListener.mouseUpAdapter(e -> userCodeText.selectAll()));
        userCodeText.setFocus();
        UIUtils.asyncExec(() -> composite.layout(true, true));
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 11, UIMessages.dialog_auth_code_copy_and_open_label, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 11) {
            UIUtils.setClipboardContents(this.getShell().getDisplay(), (Transfer)TextTransfer.getInstance(), this.userCode);
            ShellUtils.launchProgram(this.browserUrl.toString());
        } else {
            super.buttonPressed(buttonId);
        }
    }

    protected void cancelPressed() {
        this.future.cancel(false);
        super.cancelPressed();
    }
}

