/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.validator;

import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Text;

public class IntegerValidator
implements VerifyListener {
    private final int minValue;
    private final int maxValue;

    public IntegerValidator(int minValue, int maxValue) {
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    public void verifyText(VerifyEvent e) {
        Object object = e.getSource();
        if (object instanceof Text) {
            Text text = (Text)object;
            String current = text.getText();
            String prospective = current.substring(0, e.start) + e.text + current.substring(e.end);
            this.verifyText(e, prospective);
        } else {
            this.verifyText(e, e.text);
        }
    }

    private void verifyText(VerifyEvent e, String text) {
        if (text.isEmpty()) {
            return;
        }
        try {
            int value = Integer.parseInt(text);
            if (value < this.minValue || value > this.maxValue) {
                e.doit = false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            e.doit = false;
        }
    }
}

