/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.forms;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ui.forms.UIControlBuilderImpl;
import org.jkiss.dbeaver.ui.forms.UIControlFactory;
import org.jkiss.dbeaver.ui.forms.UIPanelBuilder;
import org.jkiss.dbeaver.ui.forms.UIRowBuilder;
import org.jkiss.dbeaver.ui.forms.UIRowBuilderImpl;

final class UIPanelBuilderImpl
extends UIControlBuilderImpl<UIPanelBuilder, Control>
implements UIPanelBuilder {
    private final List<UIRowBuilderImpl> rows = new ArrayList<UIRowBuilderImpl>();
    private final String text;
    private final boolean expandable;
    private final boolean expanded;
    private int indent = 0;
    private int marginLeft = 5;
    private int marginTop = 5;
    private int marginRight = 5;
    private int marginBottom = 5;

    private UIPanelBuilderImpl(@Nullable String text, boolean expandable, boolean expanded) {
        this.text = text;
        this.expandable = expandable;
        this.expanded = expanded;
    }

    @NotNull
    static UIPanelBuilderImpl panel() {
        return new UIPanelBuilderImpl(null, false, false);
    }

    @NotNull
    static UIPanelBuilderImpl group(@NotNull String text) {
        return new UIPanelBuilderImpl(text, false, false);
    }

    @NotNull
    static UIPanelBuilderImpl expandableGroup(@NotNull String text, boolean expanded) {
        return new UIPanelBuilderImpl(text, true, expanded);
    }

    @Override
    @NotNull
    public UIPanelBuilder margins(int horizontal, int vertical) {
        this.marginLeft = this.marginRight = horizontal;
        this.marginTop = this.marginBottom = vertical;
        return this;
    }

    @Override
    @NotNull
    public UIPanelBuilder margins(int left, int top, int right, int bottom) {
        this.marginLeft = left;
        this.marginTop = top;
        this.marginRight = right;
        this.marginBottom = bottom;
        return this;
    }

    @Override
    @NotNull
    public UIPanelBuilder row(@NotNull Consumer<? super UIRowBuilder> handler) {
        UIRowBuilderImpl builder = new UIRowBuilderImpl(this.indent);
        handler.accept(builder);
        if (builder.controls.isEmpty()) {
            throw new IllegalStateException("Row cannot be empty");
        }
        this.rows.add(builder);
        return this;
    }

    @Override
    @NotNull
    public UIPanelBuilder indent(@NotNull Consumer<? super UIPanelBuilder> handler) {
        ++this.indent;
        handler.accept(this);
        --this.indent;
        return this;
    }

    @Override
    @NotNull
    protected Control create(@NotNull DataBindingContext context, @NotNull Composite parent) {
        if (this.rows.isEmpty()) {
            throw new IllegalStateException("Panel cannot be empty");
        }
        Object host = this.expandable ? UIControlFactory.createExpandableComposite(parent) : parent;
        Composite client = this.text != null && !this.expandable ? UIControlFactory.createTitledComposite(host, this.text) : UIControlFactory.createComposite(host);
        int columns = this.rows.stream().mapToInt(row -> row.controls.size()).max().orElseThrow();
        GridLayoutFactory.fillDefaults().numColumns(columns).extendedMargins(this.marginLeft, this.marginRight, this.marginTop, this.marginBottom).applyTo(client);
        for (UIRowBuilderImpl row2 : this.rows) {
            this.buildRow(context, row2, client, columns);
        }
        if (this.expandable) {
            ExpandableComposite composite = (ExpandableComposite)host;
            composite.setClient((Control)client);
            composite.setText(this.text);
            composite.setExpanded(this.expanded, true);
            return composite;
        }
        return client;
    }

    private void buildRow(@NotNull DataBindingContext context, @NotNull UIRowBuilderImpl row, @NotNull Composite parent, int columns) {
        int i = 0;
        while (i < row.controls.size()) {
            UIControlBuilderImpl<?, ?> builder = row.controls.get(i);
            GridData data = new GridData();
            data.horizontalAlignment = builder.alignX;
            data.verticalAlignment = builder.alignY;
            data.grabExcessHorizontalSpace = builder.grow;
            data.grabExcessVerticalSpace = builder.grow;
            Object control = builder.build(context, parent, row);
            if (builder.widthHint != -1 && builder.heightHint != -1) {
                data.widthHint = builder.widthHint;
                data.heightHint = builder.heightHint;
            } else {
                Point size = builder.preferredSize(control);
                if (size != null) {
                    data.widthHint = size.x;
                    data.heightHint = size.y;
                }
            }
            if (i == 0 && row.indent > 0) {
                data.horizontalIndent = LayoutConstants.getIndent() * row.indent;
            }
            if (i == row.controls.size() - 1) {
                data.horizontalSpan = columns - row.controls.size() + 1;
            }
            control.setLayoutData((Object)data);
            ++i;
        }
    }
}

