/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.url;

import java.net.ContentHandler;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.equinox.plurl.PlurlContentHandlerFactory;
import org.eclipse.osgi.internal.framework.EquinoxBundle;
import org.eclipse.osgi.internal.framework.EquinoxContainer;
import org.eclipse.osgi.internal.messages.Msg;
import org.eclipse.osgi.internal.url.ContentHandlerProxy;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class ContentHandlerFactoryImpl
implements PlurlContentHandlerFactory {
    private static final String contentHandlerClazz = "java.net.ContentHandler";
    private final EquinoxContainer container;
    private final BundleContext context;
    private final ServiceTracker<ContentHandler, ContentHandler> contentHandlerTracker;
    private final Map<String, ContentHandlerProxy> proxies;

    public ContentHandlerFactoryImpl(BundleContext context, EquinoxContainer container) {
        this.container = container;
        this.context = context;
        this.proxies = new Hashtable<String, ContentHandlerProxy>(5);
        this.contentHandlerTracker = new ServiceTracker(context, contentHandlerClazz, null);
        this.contentHandlerTracker.open();
    }

    @Override
    public ContentHandler createContentHandler(String contentType) {
        ContentHandlerProxy proxy = this.proxies.get(contentType);
        if (proxy != null) {
            return proxy;
        }
        ServiceReference<ContentHandler>[] serviceReferences = this.contentHandlerTracker.getServiceReferences();
        if (serviceReferences != null) {
            ServiceReference<ContentHandler>[] serviceReferenceArray = serviceReferences;
            int n = serviceReferences.length;
            int n2 = 0;
            while (n2 < n) {
                ServiceReference<ContentHandler> serviceReference = serviceReferenceArray[n2];
                String[] prop = serviceReference.getProperty("url.content.mimetype");
                if (prop instanceof String) {
                    prop = new String[]{(String)prop};
                }
                if (!(prop instanceof String[])) {
                    String message = NLS.bind(Msg.URL_HANDLER_INCORRECT_TYPE, "url.content.mimetype", contentHandlerClazz, serviceReference.getBundle());
                    this.container.getLogServices().log("org.eclipse.osgi", 2, message, null);
                } else {
                    String[] contentHandler;
                    String[] stringArray = contentHandler = (String[])prop;
                    int n3 = contentHandler.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String typename = stringArray[n4];
                        if (typename.equals(contentType)) {
                            proxy = new ContentHandlerProxy(contentType, serviceReference, this.context);
                            this.proxies.put(contentType, proxy);
                            return proxy;
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        proxy = new ContentHandlerProxy(contentType, null, this.context);
        this.proxies.put(contentType, proxy);
        return proxy;
    }

    @Override
    public boolean shouldHandle(Class<?> clazz) {
        Bundle b = FrameworkUtil.getBundle(clazz);
        if (!(b instanceof EquinoxBundle)) {
            return false;
        }
        return this.container.getStorage().getModuleContainer() == ((EquinoxBundle)b).getModule().getContainer();
    }
}

