/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.altibase.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.altibase.model.AltibaseDataSource;
import org.jkiss.dbeaver.ext.altibase.model.AltibaseGlobalObject;
import org.jkiss.dbeaver.ext.altibase.model.AltibaseReplicationItem;
import org.jkiss.dbeaver.ext.altibase.model.AltibaseReplicationReceiver;
import org.jkiss.dbeaver.ext.altibase.model.AltibaseReplicationSender;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.model.DBPObjectStatistics;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBPScriptObject;
import org.jkiss.dbeaver.model.DBPStatefulObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectCache;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectLazy;
import org.jkiss.dbeaver.model.struct.DBSObjectState;
import org.jkiss.utils.CommonUtils;

public class AltibaseReplication
extends AltibaseGlobalObject
implements DBSObjectLazy<AltibaseDataSource>,
DBPRefreshableObject,
DBPScriptObject,
DBPStatefulObject,
DBPObjectStatistics {
    private final SenderCache senderCache = new SenderCache();
    private final ReceiverCache receiverCache = new ReceiverCache();
    private String ddl;
    private String name;
    private String remoteAddr;
    private String remoteConnType;
    private boolean isStarted;
    private String conflictResolution;
    private String mode;
    private String role;
    private int options;
    private String recoverable;
    private int parallelApplierCount;
    private long xsn;
    private Timestamp giveUpTime;
    private long giveUpXsn;
    private Timestamp remoteFaultDetectTime;

    protected AltibaseReplication(GenericStructContainer owner, JDBCResultSet resultSet) {
        super((AltibaseDataSource)owner.getDataSource(), true);
        this.name = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"REPLICATION_NAME");
        this.isStarted = JDBCUtils.safeGetBoolean((ResultSet)resultSet, (String)"IS_STARTED", (String)"1");
        this.conflictResolution = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"CONFLICT_RESOLUTION");
        this.mode = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"REPL_MODE");
        this.role = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"ROLE");
        this.options = JDBCUtils.safeGetInt((ResultSet)resultSet, (String)"OPTIONS");
        this.recoverable = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"RECOVERABLE");
        this.parallelApplierCount = JDBCUtils.safeGetInt((ResultSet)resultSet, (String)"PARALLEL_APPLIER_COUNT");
        this.xsn = JDBCUtils.safeGetLong((ResultSet)resultSet, (String)"XSN");
        this.giveUpTime = JDBCUtils.safeGetTimestamp((ResultSet)resultSet, (String)"GIVE_UP_TIME");
        this.giveUpXsn = JDBCUtils.safeGetLong((ResultSet)resultSet, (String)"GIVE_UP_XSN");
        this.remoteFaultDetectTime = JDBCUtils.safeGetTimestamp((ResultSet)resultSet, (String)"REMOTE_FAULT_DETECT_TIME");
        this.remoteAddr = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"REMOTE_ADDR");
        this.remoteConnType = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"REMOTE_CONN_TYPE");
    }

    @NotNull
    @Association
    public Collection<AltibaseReplicationSender> getReplicationSenders(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.senderCache.getAllObjects(monitor, this);
    }

    @NotNull
    @Association
    public List<AltibaseReplicationReceiver> getReplicationReceivers(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.receiverCache.getAllObjects(monitor, this);
    }

    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    @Property(viewable=true, order=2)
    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    @Property(viewable=true, order=3)
    public String getRemoteConnType() {
        return this.remoteConnType;
    }

    @Property(viewable=true, order=10)
    public boolean getIsStarted() {
        return this.isStarted;
    }

    @Property(viewable=true, order=11)
    public String getConflictResolution() {
        return this.conflictResolution;
    }

    @Property(viewable=true, order=12)
    public String getMode() {
        return this.mode;
    }

    @Property(viewable=true, order=13)
    public String getRole() {
        return this.role;
    }

    @Property(viewable=true, order=14)
    public int getOptions() {
        return this.options;
    }

    @Property(viewable=true, order=15)
    public String getRecoverable() {
        return this.recoverable;
    }

    @Property(viewable=true, order=16)
    public int getParallelApplierCount() {
        return this.parallelApplierCount;
    }

    @Property(viewable=true, order=20)
    public long getXsn() {
        return this.xsn;
    }

    @Property(viewable=true, order=30)
    public Timestamp getGiveUpTime() {
        return this.giveUpTime;
    }

    @Property(viewable=true, order=31)
    public long getGiveUpXsn() {
        return this.giveUpXsn;
    }

    @Property(viewable=true, order=32)
    public Timestamp getRemoteFaultDetectTime() {
        return this.remoteFaultDetectTime;
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.ddl = null;
        return this.getDataSource().getReplicationCache().refreshObject(monitor, (DBSObject)this.getDataSource(), this);
    }

    @Nullable
    public Object getLazyReference(Object propertyId) {
        return null;
    }

    public List<AltibaseReplicationItem> getReplicationItems(DBRProgressMonitor monitor) throws DBException {
        return this.getDataSource().getReplicationCache().getChildren(monitor, (DBSObject)this.getDataSource(), this);
    }

    @NotNull
    public String getObjectDefinitionText(@NotNull DBRProgressMonitor monitor, @NotNull Map<String, Object> options) throws DBException {
        if (CommonUtils.isEmpty((String)this.ddl)) {
            this.ddl = this.getDataSource().getMetaModel().getReplicationDDL(monitor, this, options) + ";";
        }
        return this.ddl;
    }

    @NotNull
    public DBSObjectState getObjectState() {
        return this.isStarted ? DBSObjectState.ACTIVE : DBSObjectState.NORMAL;
    }

    public void refreshObjectState(@NotNull DBRProgressMonitor monitor) throws DBCException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)("Refresh state of replication '" + this.getName() + "'"));){
            try {
                Throwable throwable2 = null;
                Object var6_10 = null;
                try (JDBCPreparedStatement dbStat = session.prepareStatement("SELECT status FROM system_.sys_users_ u, system_.sys_procedures_ p WHERE u.user_id = p.user_id AND u.user_name = ? AND proc_name = ?");){
                    dbStat.setString(1, this.getName());
                    dbStat.executeStatement();
                    Throwable throwable3 = null;
                    Object var9_15 = null;
                    try (JDBCResultSet dbResult = dbStat.getResultSet();){
                        if (dbResult != null && dbResult.next()) {
                            this.isStarted = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (int)1, (String)"1");
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable3 == null) {
                            throwable3 = throwable4;
                        } else if (throwable3 != throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                }
                catch (Throwable throwable5) {
                    if (throwable2 == null) {
                        throwable2 = throwable5;
                    } else if (throwable2 != throwable5) {
                        throwable2.addSuppressed(throwable5);
                    }
                    throw throwable2;
                }
            }
            catch (SQLException e) {
                throw new DBCException((Throwable)e, (DBCExecutionContext)session.getExecutionContext());
            }
        }
        catch (Throwable throwable6) {
            if (throwable == null) {
                throwable = throwable6;
            } else if (throwable != throwable6) {
                throwable.addSuppressed(throwable6);
            }
            throw throwable;
        }
    }

    public boolean hasStatistics() {
        return true;
    }

    public long getStatObjectSize() {
        long gap = 0L;
        if (this.senderCache.getCacheSize() > 0) {
            gap = ((AltibaseReplicationSender)this.senderCache.getCachedObjects().get(0)).getGapSizeInByte();
        }
        return gap;
    }

    static class ReceiverCache
    extends JDBCObjectCache<AltibaseReplication, AltibaseReplicationReceiver> {
        ReceiverCache() {
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull AltibaseReplication owner) throws SQLException {
            JDBCPreparedStatement dbStat = session.prepareStatement("SELECT * from v$repreceiver WHERE rep_name = ?");
            dbStat.setString(1, owner.getName());
            return dbStat;
        }

        protected AltibaseReplicationReceiver fetchObject(@NotNull JDBCSession session, @NotNull AltibaseReplication owner, @NotNull JDBCResultSet resultSet) throws SQLException, DBException {
            return new AltibaseReplicationReceiver(owner, resultSet);
        }
    }

    static class SenderCache
    extends JDBCObjectCache<AltibaseReplication, AltibaseReplicationSender> {
        SenderCache() {
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull AltibaseReplication owner) throws SQLException {
            JDBCPreparedStatement dbStat = session.prepareStatement("SELECT s.*, (g.rep_gap * p.value1) as gap_size_in_byte FROM v$repsender s, v$repgap g,  v$property p WHERE s.rep_name = ? AND s.rep_name = g.rep_name AND p.name = 'REPLICATION_GAP_UNIT'");
            dbStat.setString(1, owner.getName());
            return dbStat;
        }

        protected AltibaseReplicationSender fetchObject(@NotNull JDBCSession session, @NotNull AltibaseReplication owner, @NotNull JDBCResultSet resultSet) throws SQLException, DBException {
            return new AltibaseReplicationSender(owner, resultSet);
        }
    }
}

