/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tasks.ui.wizard;

import org.eclipse.jface.wizard.IWizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.model.task.DBTTaskType;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.tasks.ui.DBTTaskConfigPanel;
import org.jkiss.dbeaver.tasks.ui.DBTTaskConfigPanelProvider;
import org.jkiss.dbeaver.tasks.ui.DBTTaskConfigurator;
import org.jkiss.dbeaver.tasks.ui.internal.TaskUIMessages;
import org.jkiss.dbeaver.tasks.ui.registry.TaskUIRegistry;
import org.jkiss.dbeaver.tasks.ui.wizard.NewTaskConfigurationWizard;
import org.jkiss.dbeaver.tasks.ui.wizard.TaskConfigurationWizard;
import org.jkiss.dbeaver.tasks.ui.wizard.TaskConfigurationWizardDialog;
import org.jkiss.dbeaver.tasks.ui.wizard.TaskConfigurationWizardPageTask;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.ActiveWizardPage;
import org.jkiss.dbeaver.ui.dialogs.IWizardPageNavigable;

class TaskConfigurationWizardPageSettings
extends ActiveWizardPage<TaskConfigurationWizard>
implements IWizardPageNavigable {
    private static final Log log = Log.getLog(TaskConfigurationWizardPageSettings.class);
    private Composite taskSettingsPlaceholder;
    private DBTTaskType curTaskType;
    private DBTTaskConfigPanel taskConfigPanel;

    TaskConfigurationWizardPageSettings(DBTTask task) {
        super(task == null ? TaskUIMessages.task_config_wizard_page_settings_create_task : TaskUIMessages.task_config_wizard_page_settings_edit_task);
        this.setTitle(this.getName());
        this.setPageComplete(true);
    }

    public void setWizard(IWizard newWizard) {
        DBTTaskType taskType = ((TaskConfigurationWizard)newWizard).getTaskType();
        if (taskType != null) {
            this.setTitle(taskType.getName());
        }
        super.setWizard(newWizard);
    }

    public void createControl(Composite parent) {
        this.taskSettingsPlaceholder = new Composite(parent, 0);
        this.taskSettingsPlaceholder.setLayout((Layout)new FillLayout());
        this.setControl((Control)this.taskSettingsPlaceholder);
    }

    protected boolean determinePageCompletion() {
        if (this.taskConfigPanel != null && !this.taskConfigPanel.isComplete()) {
            String errorMessage = this.taskConfigPanel.getErrorMessage();
            if (errorMessage != null) {
                this.setErrorMessage(errorMessage);
            } else {
                this.setErrorMessage(NLS.bind((String)TaskUIMessages.task_configuration_wizard_page_settings_fill_parameters, (Object)this.curTaskType.getName()));
            }
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    public void activatePage() {
        DBTTaskType selectedTaskType = this.getSelectedTaskType();
        if (this.curTaskType == selectedTaskType) {
            return;
        }
        this.curTaskType = selectedTaskType;
        this.createTaskSettingsUI();
        if (this.curTaskType == null) {
            this.setTitle(TaskUIMessages.task_config_wizard_page_settings_title_task_prop);
            this.setDescription(TaskUIMessages.task_config_wizard_page_settings_descr_set_task);
        } else {
            this.setTitle(this.curTaskType.getName());
            this.setDescription(NLS.bind((String)TaskUIMessages.task_config_wizard_page_settings_config, (Object)this.curTaskType.getName()));
        }
        this.updatePageCompletion();
        ((TaskConfigurationWizard)this.getWizard()).getContainer().updateNavigationTree();
    }

    public void deactivatePage() {
        if (this.taskConfigPanel != null && this.taskConfigPanel.isComplete()) {
            this.taskConfigPanel.saveSettings();
        }
    }

    private void createTaskSettingsUI() {
        UIUtils.disposeChildControls((Composite)this.taskSettingsPlaceholder);
        if (this.curTaskType != null && TaskUIRegistry.getInstance().supportsConfigurator(this.curTaskType)) {
            try {
                DBTTaskConfigPanel configPage;
                DBTTaskConfigurator configurator = TaskUIRegistry.getInstance().createConfigurator(this.curTaskType);
                if (configurator instanceof DBTTaskConfigPanelProvider && (configPage = ((DBTTaskConfigPanelProvider)((Object)configurator)).createInputConfigurator(UIUtils.getDefaultRunnableContext(), this.curTaskType)) != null) {
                    this.taskConfigPanel = configPage;
                    TaskConfigurationWizard taskWizard = this.getTaskPage().getTaskWizard();
                    this.taskConfigPanel.createControl(this.taskSettingsPlaceholder, taskWizard, () -> ((TaskConfigurationWizardPageSettings)this).updatePageCompletion());
                    if (((TaskConfigurationWizard)this.getWizard()).getCurrentTask() != null) {
                        this.taskConfigPanel.loadSettings();
                    }
                    this.taskSettingsPlaceholder.layout(true, true);
                }
            }
            catch (Exception e) {
                DBWorkbench.getPlatformUI().showError("Task configurator error", "Error creating task configuration UI", (Throwable)e);
            }
        }
    }

    private TaskConfigurationWizardPageTask getTaskPage() {
        return ((TaskConfigurationWizardDialog)this.getContainer()).getTaskPage();
    }

    public boolean isPageNavigable() {
        return this.getSelectedTaskType() != null;
    }

    public boolean isPageApplicable() {
        if (this.getWizard() instanceof NewTaskConfigurationWizard) {
            return true;
        }
        DBTTaskType selectedTaskType = this.getSelectedTaskType();
        if (selectedTaskType != null && TaskUIRegistry.getInstance().supportsConfigurator(selectedTaskType)) {
            try {
                return TaskUIRegistry.getInstance().createConfigurator(selectedTaskType) instanceof DBTTaskConfigPanelProvider;
            }
            catch (DBCException e) {
                log.debug((Object)e);
                return false;
            }
        }
        return false;
    }

    private DBTTaskType getSelectedTaskType() {
        DBTTask currentTask = ((TaskConfigurationWizard)this.getWizard()).getCurrentTask();
        return currentTask != null ? currentTask.getType() : this.getTaskPage().getSelectedTaskType();
    }
}

