/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.jdbc.cache;

import java.sql.SQLException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPNamedObject2;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectLookup;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCStructCache;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;

public abstract class JDBCStructLookupCache<OWNER extends DBSObject, OBJECT extends DBSObject, CHILD extends DBSObject>
extends JDBCStructCache<OWNER, OBJECT, CHILD>
implements JDBCObjectLookup<OWNER, OBJECT> {
    private final Set<String> missingNames = new HashSet<String>();

    public JDBCStructLookupCache(Object objectNameColumn) {
        super(objectNameColumn);
    }

    @Override
    public OBJECT getObject(@NotNull DBRProgressMonitor monitor, @NotNull OWNER owner, @NotNull String name) throws DBException {
        DBSObject cachedObject = this.getCachedObject(name);
        if (cachedObject != null || monitor.isForceCacheUsage()) {
            return (OBJECT)cachedObject;
        }
        if (this.isFullyCached() || owner.getDataSource() == null || !owner.getDataSource().getContainer().isConnected() || this.missingNames.contains(name)) {
            return null;
        }
        OBJECT object = this.reloadObject(monitor, owner, null, name);
        if (object != null) {
            this.cacheObject((DBSObject)object);
        } else {
            this.missingNames.add(name);
        }
        return object;
    }

    public OBJECT refreshObject(@NotNull DBRProgressMonitor monitor, @NotNull OWNER owner, @NotNull OBJECT oldObject) throws DBException {
        String objectName = oldObject.getName();
        if (oldObject instanceof DBPNamedObject2) {
            DBPNamedObject2 no = (DBPNamedObject2)oldObject;
            if (DBUtils.isQuotedIdentifier((DBPDataSource)oldObject.getDataSource(), (String)objectName)) {
                objectName = DBUtils.getUnQuotedIdentifier((DBPDataSource)oldObject.getDataSource(), (String)objectName);
                no.setName(objectName);
            }
        }
        if (this.isFullyCached()) {
            OBJECT newObject = this.reloadObject(monitor, owner, oldObject, null);
            if (this.isChildrenCached(oldObject)) {
                this.clearChildrenCache(oldObject);
            }
            if (newObject != null) {
                this.deepCopyCachedObject(newObject, oldObject);
            } else {
                this.removeObject(oldObject, false);
            }
            return oldObject;
        }
        this.loadObjects(monitor, owner);
        return (OBJECT)this.getCachedObject(objectName);
    }

    /*
     * Exception decompiling
     */
    protected OBJECT reloadObject(@NotNull DBRProgressMonitor monitor, @NotNull OWNER owner, @Nullable OBJECT object, @Nullable String objectName) throws DBException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK], 4[TRYBLOCK], 5[TRYBLOCK], 6[TRYBLOCK]], but top level block is 29[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    @NotNull
    protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull OWNER owner) throws SQLException {
        return this.prepareLookupStatement(session, (DBSObject)owner, null, null);
    }

    public void setCache(@NotNull List<OBJECT> objects) {
        super.setCache(objects);
        this.missingNames.clear();
    }

    @Override
    public void clearCache() {
        super.clearCache();
        this.missingNames.clear();
    }
}

