/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.runtime.ui.console;

import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.access.DBAPasswordChangeInfo;
import org.jkiss.dbeaver.model.connection.DBPAuthInfo;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.fs.DBNPathBase;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProcessDescriptor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithResult;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithReturn;
import org.jkiss.dbeaver.model.runtime.LoggingProgressMonitor;
import org.jkiss.dbeaver.model.runtime.load.ILoadService;
import org.jkiss.dbeaver.model.runtime.load.ILoadVisualizer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.ui.DBPPlatformUI;
import org.jkiss.dbeaver.utils.GeneralUtils;

public class ConsoleUserInterface
implements DBPPlatformUI {
    private static final Log log = Log.getLog(ConsoleUserInterface.class);

    protected void initialize() {
    }

    @Override
    public DBPPlatformUI.UserResponse showError(@NotNull String title, @Nullable String message, @NotNull IStatus status) {
        System.out.println(title + (String)(message == null ? "" : ": " + message));
        this.printStatus(status, 0);
        return DBPPlatformUI.UserResponse.OK;
    }

    @Override
    public DBPPlatformUI.UserResponse showError(@NotNull String title, @Nullable String message, @NotNull Throwable e) {
        System.out.println(title + (String)(message == null ? "" : ": " + message));
        e.printStackTrace(System.out);
        return DBPPlatformUI.UserResponse.OK;
    }

    @Override
    public DBPPlatformUI.UserResponse showError(@NotNull String title, @Nullable String message) {
        System.out.println(title + (String)(message == null ? "" : ": " + message));
        return DBPPlatformUI.UserResponse.OK;
    }

    @Override
    public void showMessageBox(@NotNull String title, String message, boolean error) {
        System.out.println(title + (String)(message == null ? "" : ": " + message));
    }

    @Override
    public void showNotification(@NotNull String title, @Nullable String message, boolean error, @Nullable Runnable feedback) {
        this.showMessageBox(title, message, error);
    }

    @Override
    public void showWarningNotification(@NotNull String title, @Nullable String message) {
        this.showWarningMessageBox(title, message);
    }

    @Override
    public void showWarningMessageBox(@NotNull String title, @Nullable String message) {
        System.out.println(title + (String)(message == null ? "" : ": " + message));
    }

    @Override
    public boolean confirmAction(String title, String message) {
        return false;
    }

    @Override
    public boolean confirmAction(String title, String message, boolean isWarning) {
        return false;
    }

    @Override
    public boolean confirmAction(@NotNull String title, @NotNull String message, @NotNull String buttonLabel, boolean isWarning) {
        return false;
    }

    @Override
    @NotNull
    public DBPPlatformUI.UserChoiceResponse showUserChoice(@NotNull String title, @Nullable String message, @NotNull List<String> labels, @NotNull List<String> forAllLabels, @Nullable Integer previousChoice, int defaultChoice) {
        return new DBPPlatformUI.UserChoiceResponse(defaultChoice, null);
    }

    @Override
    public DBPPlatformUI.UserResponse showErrorStopRetryIgnore(String task, Throwable error, boolean queue) {
        System.out.println(task);
        error.printStackTrace(System.out);
        return DBPPlatformUI.UserResponse.IGNORE;
    }

    private void printStatus(@NotNull IStatus status, int level) {
        char[] indent = new char[level * 4];
        int i = 0;
        while (i < indent.length) {
            indent[i] = 32;
            ++i;
        }
        if (status.getMessage() != null) {
            System.out.println(String.valueOf((Object)indent) + status.getMessage());
        }
        if (status.getException() != null) {
            status.getException().printStackTrace(System.out);
        }
    }

    @Override
    @Nullable
    public DBPAuthInfo promptUserCredentials(@Nullable String prompt, @Nullable String description, @Nullable String userName, @Nullable String userPassword, boolean passwordOnly, boolean showSavePassword) {
        throw new IllegalStateException("Can not prompt user credentials in non-interactive mode");
    }

    @Override
    @Nullable
    public DBPAuthInfo promptUserCredentials(@Nullable String prompt, @Nullable String description, @NotNull String userNameLabel, @Nullable String userName, @NotNull String passwordLabel, @Nullable String userPassword, boolean passwordOnly, boolean showSavePassword) {
        throw new IllegalStateException("Can not prompt user credentials in non-interactive mode");
    }

    @Override
    @Nullable
    public DBAPasswordChangeInfo promptUserPasswordChange(String prompt, String userName, String oldPassword, boolean userEditable, boolean oldPasswordEditable) {
        throw new IllegalStateException("Can not prompt user password change in non-interactive mode");
    }

    @Override
    public String promptProperty(String prompt, String defValue) {
        return null;
    }

    @Override
    public boolean acceptLicense(String message, String licenseText) {
        return true;
    }

    @Override
    public DBNNode selectObject(@NotNull Object parentShell, String title, DBNNode rootNode, DBNNode selectedNode, Class<?>[] allowedTypes, Class<?>[] resultTypes, Class<?>[] leafTypes) {
        return null;
    }

    @Override
    public void openEntityEditor(@NotNull DBSObject object) {
    }

    @Override
    public void openEntityEditor(@NotNull DBNNode selectedNode, String defaultPageId) {
    }

    @Override
    public void openConnectionEditor(@NotNull DBPDataSourceContainer dataSourceContainer) {
    }

    @Override
    public void executeProcess(@NotNull DBRProcessDescriptor processDescriptor) {
        try {
            processDescriptor.execute();
        }
        catch (DBException e) {
            DBWorkbench.getPlatformUI().showError("Execute process", processDescriptor.getName(), e);
        }
    }

    @Override
    public void executeInMainThread(@NotNull Runnable runnable) {
        runnable.run();
    }

    @Override
    @NotNull
    public <T> Future<T> executeWithProgressBlocking(@NotNull String operationDescription, @NotNull DBRRunnableWithResult<Future<T>> runnable) {
        try {
            runnable.run(new LoggingProgressMonitor());
            return runnable.getResult();
        }
        catch (Exception ex) {
            return CompletableFuture.failedFuture(ex);
        }
    }

    @Override
    public <T> T runWithMonitor(@NotNull DBRRunnableWithReturn<T> runnable) throws DBException {
        return runnable.runTask(new LoggingProgressMonitor(log));
    }

    @Override
    public <T> T runWithProgress(@NotNull DBRRunnableWithReturn<T> runnable) throws DBException {
        return runnable.runTask(new LoggingProgressMonitor(log));
    }

    @Override
    @NotNull
    public <RESULT> Job createLoadingService(final @NotNull ILoadService<RESULT> loadingService, final @NotNull ILoadVisualizer<RESULT> visualizer) {
        return new AbstractJob(loadingService.getServiceName()){

            @Override
            @NotNull
            protected IStatus run(@NotNull DBRProgressMonitor monitor) {
                try {
                    Object result = loadingService.evaluate(monitor);
                    visualizer.completeLoading(result);
                    return Status.OK_STATUS;
                }
                catch (InvocationTargetException e) {
                    return GeneralUtils.makeExceptionStatus(e.getTargetException());
                }
                catch (InterruptedException interruptedException) {
                    return Status.CANCEL_STATUS;
                }
            }
        };
    }

    @Override
    public void copyTextToClipboard(@NotNull String text, boolean htmlFormat) {
    }

    @Override
    public void executeShellProgram(@NotNull String shellCommand) {
        Path filePath = Path.of(shellCommand, new String[0]);
        if (Files.exists(filePath, new LinkOption[0]) && Files.isDirectory(filePath, new LinkOption[0])) {
            System.out.println("Open directory '" + shellCommand + "'");
            return;
        }
        try {
            Runtime.getRuntime().exec(shellCommand);
        }
        catch (Exception e) {
            log.error(e);
        }
    }

    @Override
    public void showInSystemExplorer(@NotNull String path) {
    }

    @Override
    public DBNPathBase openFileSystemSelector(@NotNull String title, boolean folder, int style, boolean binary, String[] filterExt, String defaultValue) {
        return null;
    }

    @Override
    public boolean readAndDispatchEvents() {
        return false;
    }
}

