/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.gbase8s.edit;

import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ext.gbase8s.GBase8sUtils;
import org.jkiss.dbeaver.ext.generic.edit.GenericPrimaryKeyManager;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.generic.model.GenericUniqueKey;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableCheckConstraint;

public class GBase8sUniqueKeyManager
extends GenericPrimaryKeyManager {
    /*
     * Enabled aggressive block sorting
     */
    protected void addObjectCreateActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectCreateCommand command, @NotNull Map<String, Object> options) {
        GenericUniqueKey key = (GenericUniqueKey)command.getObject();
        if (key.getConstraintType() == DBSEntityConstraintType.CHECK && key instanceof DBSTableCheckConstraint) {
            DBSTableCheckConstraint check = (DBSTableCheckConstraint)key;
            if (!GBase8sUtils.isOracleSqlMode(executionContext.getDataSource().getContainer())) {
                String createSql = "ALTER TABLE %s ADD CONSTRAINT CHECK (%s) CONSTRAINT %s".formatted(((GenericTableBase)key.getParentObject()).getFullyQualifiedName(DBPEvaluationContext.DDL), check.getCheckConstraintDefinition(), DBUtils.getQuotedIdentifier((DBSObject)key));
                actions.add((DBEPersistAction)new SQLDatabasePersistAction(ModelMessages.model_jdbc_create_new_constraint, createSql));
                return;
            }
        }
        super.addObjectCreateActions(monitor, executionContext, actions, command, options);
    }

    protected boolean isLegacyConstraintsSyntax(GenericTableBase owner) {
        return !GBase8sUtils.isOracleSqlMode(((GenericStructContainer)owner.getContainer()).getDataSource().getContainer());
    }

    protected boolean isShortNotation(GenericTableBase owner) {
        return false;
    }
}

