/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry.driver;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBFileController;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceProvider;
import org.jkiss.dbeaver.model.app.DBPApplication;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.connection.DBPDriverDependencies;
import org.jkiss.dbeaver.model.connection.DBPDriverLibrary;
import org.jkiss.dbeaver.model.connection.DBPDriverLibraryProvider;
import org.jkiss.dbeaver.model.connection.DBPDriverLoader;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.LoggingProgressMonitor;
import org.jkiss.dbeaver.registry.driver.DriverClassLoader;
import org.jkiss.dbeaver.registry.driver.DriverDependencies;
import org.jkiss.dbeaver.registry.driver.DriverDescriptor;
import org.jkiss.dbeaver.registry.driver.DriverFileInfo;
import org.jkiss.dbeaver.registry.driver.DriverLibraryBundle;
import org.jkiss.dbeaver.registry.driver.DriverLibraryLocal;
import org.jkiss.dbeaver.registry.driver.DriverUtils;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.ui.UIServiceDrivers;
import org.jkiss.dbeaver.utils.VersionUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.IOUtils;

public class DriverLoaderDescriptor
implements DBPDriverLoader {
    public static final String DEFAULT_LOADER_ID = "default";
    private static final Log log = Log.getLog(DriverLoaderDescriptor.class);
    private final DriverDescriptor driver;
    private final List<DBPDriverLibraryProvider> libraryProviders = new ArrayList<DBPDriverLibraryProvider>();
    private final Map<DBPDriverLibrary, List<DriverFileInfo>> resolvedFiles = new HashMap<DBPDriverLibrary, List<DriverFileInfo>>();
    private static ClassLoader rootClassLoader;
    private final String loaderId;
    private Class<?> driverClass;
    private boolean isLoaded;
    private DriverClassLoader classLoader;
    private transient boolean isFailed = false;

    protected DriverLoaderDescriptor(@NotNull String loaderId, @NotNull DriverDescriptor driver) {
        this.loaderId = loaderId;
        this.driver = driver;
    }

    @NotNull
    public DriverDescriptor getDriver() {
        return this.driver;
    }

    public boolean isLoaded() {
        return this.isLoaded;
    }

    public boolean isFailed() {
        return this.isFailed;
    }

    @NotNull
    public String getLoaderId() {
        return this.loaderId;
    }

    @NotNull
    public List<DBPDriverLibraryProvider> getLibraryProviders() {
        return this.libraryProviders;
    }

    @Nullable
    public DriverClassLoader getClassLoader() {
        return this.classLoader;
    }

    @NotNull
    public <T> T getDriverInstance(@NotNull DBRProgressMonitor monitor) throws DBException {
        if (this.driverClass == null) {
            this.loadDriver(monitor);
        }
        return (T)this.createDriverInstance();
    }

    public void resetDriverInstance() {
        this.driverClass = null;
        this.isLoaded = false;
        this.resolvedFiles.clear();
    }

    public void addLibraryProvider(DBPDriverLibraryProvider libraryProvider) {
        this.libraryProviders.add(libraryProvider);
    }

    private Object createDriverInstance() throws DBException {
        try {
            return this.driverClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (InstantiationException ex) {
            throw new DBException("Can't instantiate driver class", (Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            throw new DBException("Illegal access", (Throwable)ex);
        }
        catch (ClassCastException ex) {
            throw new DBException("Bad driver class name specified", (Throwable)ex);
        }
        catch (Throwable ex) {
            throw new DBException("Error during driver instantiation", ex);
        }
    }

    public void loadDriver(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.loadDriver(monitor, false);
    }

    public void loadDriver(@NotNull DBRProgressMonitor monitor, boolean forceReload) throws DBException {
        block6: {
            String licenseText;
            if (this.isLoaded && !forceReload) {
                return;
            }
            this.isLoaded = false;
            DriverLoaderDescriptor.loadGlobalLibraries();
            this.loadLibraries(monitor);
            if (this.driver.isLicenseRequired() && !CommonUtils.isEmpty((String)(licenseText = this.driver.getLicense())) && !this.driver.acceptLicense(licenseText)) {
                throw new DBException("You have to accept driver '" + this.driver.getFullName() + "' license to be able to connect");
            }
            try {
                if (this.driver.isCustomDriverLoader()) break block6;
                try {
                    this.driverClass = Class.forName(this.driver.getDriverClassName(), true, this.classLoader);
                }
                catch (Throwable ex) {
                    throw new DBException("Error creating driver '" + this.driver.getFullName() + "' instance.\nMost likely required jar files are missing.\nYou should configure jars in driver settings.\n\nReason: can't load driver class '" + this.driver.getDriverClassName() + "'", ex);
                }
                this.isLoaded = true;
                this.isFailed = false;
            }
            catch (DBException e) {
                this.isFailed = true;
                throw e;
            }
        }
    }

    private void loadLibraries(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.classLoader = null;
        List<Path> allLibraryFiles = this.validateFilesPresence(monitor);
        LinkedHashSet<URL> libraryURLs = new LinkedHashSet<URL>();
        for (Path file : allLibraryFiles) {
            URL url;
            try {
                url = file.toUri().toURL();
            }
            catch (MalformedURLException e) {
                log.error((Object)e);
                continue;
            }
            libraryURLs.add(url);
        }
        ClassLoader baseClassLoader = rootClassLoader;
        if (baseClassLoader == null) {
            DBPDataSourceProvider dataSourceProvider = this.driver.getDataSourceProvider();
            baseClassLoader = dataSourceProvider.providesDriverClasses() ? dataSourceProvider.getClass().getClassLoader() : DBPDataSource.class.getClassLoader();
        }
        this.classLoader = new DriverClassLoader(this, libraryURLs.toArray(new URL[0]), baseClassLoader);
    }

    private static synchronized void loadGlobalLibraries() {
        if (rootClassLoader == null) {
            ArrayList<URL> libraries = new ArrayList<URL>();
            String[] stringArray = DriverDescriptor.getGlobalLibraries();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String library = stringArray[n2];
                try {
                    libraries.add(new File(library).toURI().toURL());
                }
                catch (Exception e) {
                    log.error((Object)("Can't load global library '" + library + "'"), (Throwable)e);
                }
                ++n2;
            }
            if (libraries.isEmpty()) {
                return;
            }
            rootClassLoader = new URLClassLoader(libraries.toArray(new URL[0]), DriverDescriptor.class.getClassLoader());
        }
    }

    @Nullable
    public static ClassLoader getRootClassLoader() {
        return rootClassLoader;
    }

    public List<Path> getAllLibraryFiles(@NotNull DBRProgressMonitor monitor) {
        return this.validateFilesPresence(monitor);
    }

    public void updateFiles(boolean isExpanded) {
        this.validateFilesPresence((DBRProgressMonitor)new LoggingProgressMonitor(log), true, isExpanded);
    }

    @NotNull
    public List<Path> validateFilesPresence(@NotNull DBRProgressMonitor monitor) {
        return this.validateFilesPresence(monitor, false, false);
    }

    public boolean needsExternalDependencies() {
        for (DBPDriverLibrary library : this.getAllLibraries()) {
            if (library.isDisabled() || library.isOptional() || !library.matchesCurrentPlatform() || library.getType() == DBPDriverLibrary.FileType.license || this.isResolvedLibraryPresent(library)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private List<Path> validateFilesPresence(@NotNull DBRProgressMonitor monitor, boolean resetVersions, boolean isShowExpanded) {
        if (DBWorkbench.isDistributed()) {
            return this.syncDistributedDependencies(monitor);
        }
        DBPApplication application = DBWorkbench.getPlatform().getApplication();
        if (!application.isMultiuser() && !this.downloadDriverLibraries(monitor, resetVersions, isShowExpanded)) {
            return Collections.emptyList();
        }
        ArrayList<Path> result = new ArrayList<Path>();
        for (DBPDriverLibrary library : this.getAllLibraries()) {
            Path localFile;
            if (library.isDisabled() || !library.matchesCurrentPlatform()) continue;
            if (library.isDownloadable()) {
                List<DriverFileInfo> files = this.resolvedFiles.get(library);
                if (files == null) continue;
                for (DriverFileInfo file : files) {
                    if (!IOUtils.isFileFromDefaultFS((Path)file.getFile())) {
                        this.copyLibsFromExternalStorage(library, file.getFile(), result);
                        continue;
                    }
                    if (file.getFile() == null || result.contains(file.getFile())) continue;
                    result.add(file.getFile());
                }
                continue;
            }
            if (library.getType() == DBPDriverLibrary.FileType.license || (localFile = library.getLocalFile()) == null) continue;
            if (IOUtils.isFileFromDefaultFS((Path)localFile)) {
                if (Files.isDirectory(localFile, new LinkOption[0])) {
                    result.addAll(this.readJarsFromDir(localFile));
                }
                if (result.contains(localFile)) continue;
                result.add(localFile);
                continue;
            }
            this.copyLibsFromExternalStorage(library, localFile, result);
        }
        return DriverUtils.extractZipArchives(result);
    }

    private void copyLibsFromExternalStorage(DBPDriverLibrary library, Path localFile, List<Path> result) {
        Path tempDriversDir = DriverDescriptor.getExternalDriversStorageFolder();
        Path driverLibsFolder = Files.isDirectory(localFile, new LinkOption[0]) ? Path.of(library.getPath(), new String[0]) : Path.of(library.getPath(), new String[0]).getParent();
        Path realDriverLibsFolder = tempDriversDir.resolve(driverLibsFolder);
        ArrayList<? extends Path> externalLibraryFiles = new ArrayList<Path>();
        if (Files.isDirectory(localFile, new LinkOption[0])) {
            externalLibraryFiles.addAll(this.readJarsFromDir(localFile));
        } else {
            externalLibraryFiles.add(localFile);
        }
        try {
            for (Path path : externalLibraryFiles) {
                String jarName = path.getFileName().toString();
                Path realLibraryPath = realDriverLibsFolder.resolve(jarName);
                if (!Files.exists(realLibraryPath.getParent(), new LinkOption[0])) {
                    Files.createDirectories(realLibraryPath.getParent(), new FileAttribute[0]);
                }
                if (!Files.exists(realLibraryPath, new LinkOption[0]) || Files.getLastModifiedTime(realLibraryPath, new LinkOption[0]).toInstant().isBefore(Files.getLastModifiedTime(path, new LinkOption[0]).toInstant())) {
                    log.info((Object)("Copy driver library from from external file system " + String.valueOf(path) + " to the temporary location " + String.valueOf(realLibraryPath)));
                    Files.copy(path, realLibraryPath, StandardCopyOption.REPLACE_EXISTING);
                }
                if (result.contains(realLibraryPath)) continue;
                result.add(realLibraryPath);
            }
        }
        catch (Exception exception) {
            log.error((Object)("Error during copy of library file '" + String.valueOf(library) + "'"), (Throwable)exception);
        }
    }

    @NotNull
    private List<DBPDriverLibrary> getAllLibraries() {
        ArrayList<DBPDriverLibrary> libraries = new ArrayList<DBPDriverLibrary>(this.driver.getDriverLibraries());
        if (!this.libraryProviders.isEmpty()) {
            for (DBPDriverLibraryProvider dlp : this.libraryProviders) {
                libraries.addAll(dlp.getDriverLibraries());
            }
        }
        return libraries;
    }

    public boolean downloadDriverLibraries(@NotNull DBRProgressMonitor monitor, boolean resetVersions) {
        return this.downloadDriverLibraries(monitor, resetVersions, false);
    }

    public boolean downloadDriverLibraries(@NotNull DBRProgressMonitor monitor, boolean resetVersions, boolean isShowExpanded) {
        boolean downloadOk;
        DriverDependencies dependencies = this.getDriverDependencies(resetVersions, false);
        if (dependencies == null) {
            return true;
        }
        UIServiceDrivers serviceDrivers = (UIServiceDrivers)DBWorkbench.getService(UIServiceDrivers.class);
        boolean bl = downloadOk = serviceDrivers != null ? serviceDrivers.downloadDriverFiles(monitor, (DBPDriver)this.driver, (DBPDriverDependencies)dependencies, isShowExpanded) : DriverUtils.downloadDriverFiles(monitor, this.driver, dependencies);
        if (!downloadOk) {
            return false;
        }
        if (resetVersions) {
            HashMap tempResolvedFiles = new HashMap();
            this.resolvedFiles.forEach((key, value) -> {
                if (key.isEmbedded()) {
                    tempResolvedFiles.put(key, value);
                }
            });
            this.resetDriverInstance();
            this.resolvedFiles.putAll(tempResolvedFiles);
        }
        for (DBPDriverDependencies.DependencyNode node : dependencies.getLibraryMap()) {
            ArrayList<DriverFileInfo> info = new ArrayList<DriverFileInfo>();
            this.resolvedFiles.put(node.library, info);
            this.collectLibraryFiles(node, info);
        }
        try {
            this.driver.getProviderDescriptor().getRegistry().saveDrivers();
        }
        catch (DBException e) {
            log.error((Object)"Error saving drivers config", (Throwable)e);
        }
        return true;
    }

    public boolean isDriverInstalled() {
        return this.getDriverDependencies(false, true) == null;
    }

    @Nullable
    public DriverDependencies getDriverDependencies(boolean resetVersions, boolean skipLicense) {
        boolean localLibsExists = false;
        ArrayList<DBPDriverLibrary> downloadCandidates = new ArrayList<DBPDriverLibrary>();
        for (DBPDriverLibrary library : this.getAllLibraries()) {
            if (library.isDisabled() || !library.matchesCurrentPlatform() || skipLicense && library.getType() == DBPDriverLibrary.FileType.license) continue;
            if (library.isDownloadable()) {
                boolean allExists = true;
                if (resetVersions) {
                    allExists = false;
                } else {
                    List<DriverFileInfo> files = this.resolvedFiles.get(library);
                    if (files == null) {
                        allExists = false;
                    } else {
                        if (DBWorkbench.isDistributed()) break;
                        for (DriverFileInfo file : files) {
                            if (file.getFile() != null && Files.exists(this.getDriverFilePath(file), new LinkOption[0])) continue;
                            allExists = false;
                            break;
                        }
                    }
                }
                if (allExists) continue;
                downloadCandidates.add(library);
                continue;
            }
            localLibsExists = true;
        }
        if (downloadCandidates.isEmpty() && (localLibsExists || this.driver.getDriverFileSources().isEmpty())) {
            return null;
        }
        return new DriverDependencies(downloadCandidates);
    }

    private boolean isResolvedLibraryPresent(@NotNull DBPDriverLibrary library) {
        if (library.isDownloadable()) {
            List<DriverFileInfo> files = this.resolvedFiles.get(library);
            if (files == null) {
                return false;
            }
            for (DriverFileInfo file : files) {
                if (file.getFile() != null && Files.exists(this.getDriverFilePath(file), new LinkOption[0])) continue;
                return false;
            }
            return true;
        }
        Path localFile = library.getLocalFile();
        return localFile != null && Files.exists(localFile, new LinkOption[0]);
    }

    private Path getDriverFilePath(@NotNull DriverFileInfo file) {
        if (DBWorkbench.isDistributed()) {
            return DriverDescriptor.getExternalDriversStorageFolder().resolve(file.getFile());
        }
        return file.getFile();
    }

    public Map<DBPDriverLibrary, List<DriverFileInfo>> getResolvedFiles() {
        return this.resolvedFiles;
    }

    @NotNull
    private Collection<? extends Path> readJarsFromDir(@NotNull Path localFile) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (Stream<Path> list = Files.list(localFile);){
                return list.filter(p -> {
                    String fileName = p.getFileName().toString();
                    return fileName.endsWith(".jar") || fileName.endsWith(".zip");
                }).collect(Collectors.toList());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            log.error((Object)("Error reading driver directory '" + String.valueOf(localFile) + "'"), (Throwable)e);
            return Collections.emptyList();
        }
    }

    @NotNull
    private List<Path> syncDistributedDependencies(@NotNull DBRProgressMonitor monitor) {
        ArrayList<Path> localFilePaths = new ArrayList<Path>();
        LinkedHashMap<DBPDriverLibrary, List> downloadCandidates = new LinkedHashMap<DBPDriverLibrary, List>();
        Path driverFolder = DriverDescriptor.getExternalDriversStorageFolder();
        block4: for (DBPDriverLibrary library : this.getAllLibraries()) {
            List<DriverFileInfo> files;
            DriverLibraryLocal localLib;
            if (monitor.isCanceled()) break;
            if (library.isDisabled() || !library.matchesCurrentPlatform()) continue;
            if (library instanceof DriverLibraryLocal && (localLib = (DriverLibraryLocal)library).isUseOriginalJar() || library instanceof DriverLibraryBundle) {
                Path localFile = library.getLocalFile();
                if (localFile == null) continue;
                localFilePaths.add(localFile);
                if (Files.isDirectory(localFile, new LinkOption[0])) {
                    localFilePaths.addAll(this.readJarsFromDir(localFile));
                }
            }
            if ((files = this.resolvedFiles.get(library)) == null) continue;
            for (DriverFileInfo depFile : files) {
                if (monitor.isCanceled()) continue block4;
                Path localDriverFile = driverFolder.resolve(depFile.getFile().toString());
                if (DriverLoaderDescriptor.crcNotMatch(depFile, localDriverFile)) {
                    downloadCandidates.computeIfAbsent(library, key -> new ArrayList()).add(depFile);
                    continue;
                }
                localFilePaths.add(localDriverFile);
            }
        }
        if (!downloadCandidates.isEmpty()) {
            DBFileController fileController = DBWorkbench.getPlatform().getFileController();
            for (Map.Entry libEntry : downloadCandidates.entrySet()) {
                if (monitor.isCanceled()) break;
                DBPDriverLibrary library = (DBPDriverLibrary)libEntry.getKey();
                List libFiles = (List)libEntry.getValue();
                monitor.beginTask("Load driver library '" + library.getDisplayName() + "'", libFiles.size());
                for (DriverFileInfo fileInfo : libFiles) {
                    if (monitor.isCanceled()) break;
                    try {
                        try {
                            Path localDriverFile = driverFolder.resolve(fileInfo.getFile().toString());
                            if (!Files.exists(localDriverFile.getParent(), new LinkOption[0])) {
                                Files.createDirectories(localDriverFile.getParent(), new FileAttribute[0]);
                            }
                            monitor.subTask("Load driver file '" + fileInfo.getId() + "'");
                            byte[] fileData = fileController.loadFileData("libraries", DriverUtils.getDistributedLibraryPath(fileInfo.getFile()));
                            Files.write(localDriverFile, fileData, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
                            fileInfo.setFileCRC(DriverUtils.calculateFileCRC(localDriverFile));
                            localFilePaths.add(localDriverFile);
                        }
                        catch (Exception e) {
                            log.error((Object)("Error downloading driver file '" + String.valueOf(fileInfo.getFile()) + "'"), (Throwable)e);
                            monitor.worked(1);
                            continue;
                        }
                    }
                    catch (Throwable throwable) {
                        monitor.worked(1);
                        throw throwable;
                    }
                    monitor.worked(1);
                }
                monitor.done();
            }
        }
        if (!this.libraryProviders.isEmpty()) {
            this.resolvedFiles.putAll(this.driver.getDefaultDriverLoader().resolvedFiles);
        }
        return localFilePaths;
    }

    private static boolean crcNotMatch(@NotNull DriverFileInfo depFile, @NotNull Path localDriverFile) {
        return !Files.exists(localDriverFile, new LinkOption[0]) || depFile.getFileCRC() == 0L || depFile.getFileCRC() != DriverUtils.calculateFileCRC(localDriverFile);
    }

    List<DriverFileInfo> getCachedFiles(@NotNull DBPDriverLibrary library) {
        return this.resolvedFiles.get(library);
    }

    private void checkDriverVersion(@NotNull DBRProgressMonitor monitor) throws IOException {
        for (DBPDriverLibrary library : this.getAllLibraries()) {
            Collection availableVersions = library.getAvailableVersions(monitor);
            if (CommonUtils.isEmpty((Collection)availableVersions)) continue;
            String curVersion = library.getVersion();
            String latestVersion = VersionUtils.findLatestVersion((Collection)availableVersions);
            if (latestVersion == null || latestVersion.equals(curVersion)) continue;
            log.debug((Object)("Update driver " + this.driver.getName() + " " + curVersion + "->" + latestVersion));
        }
    }

    public boolean isLibraryResolved(@NotNull DBPDriverLibrary library) {
        return !library.isDownloadable() || !CommonUtils.isEmpty((Collection)this.resolvedFiles.get(library));
    }

    public Collection<DriverFileInfo> getLibraryFiles(@NotNull DBPDriverLibrary library) {
        return this.resolvedFiles.get(library);
    }

    private void collectLibraryFiles(@NotNull DBPDriverDependencies.DependencyNode node, @NotNull List<DriverFileInfo> files) {
        if (node.duplicate) {
            return;
        }
        files.add(new DriverFileInfo(node.library));
        for (DBPDriverDependencies.DependencyNode sub : node.dependencies) {
            this.collectLibraryFiles(sub, files);
        }
    }

    public void removeLibraryFiles(@NotNull DBPDriverLibrary library) {
        this.resolvedFiles.put(library, new ArrayList());
    }

    public void addLibraryFile(@NotNull DBPDriverLibrary library, @NotNull DriverFileInfo fileInfo) {
        List files = this.resolvedFiles.computeIfAbsent(library, k -> new ArrayList());
        files.add(fileInfo);
    }

    public boolean resolveDriverFiles(@NotNull Path targetFileLocation) {
        List<DBPDriverLibrary> libraries = this.getAllLibraries();
        if (libraries.isEmpty()) {
            return false;
        }
        HashMap<DBPDriverLibrary, List<DriverFileInfo>> tempResolvedFiles = new HashMap<DBPDriverLibrary, List<DriverFileInfo>>(this.resolvedFiles);
        this.resolvedFiles.clear();
        for (DBPDriverLibrary library : libraries) {
            if (library instanceof DriverLibraryLocal && !library.isDownloadable()) {
                Path srcLocalFile;
                ArrayList<DriverFileInfo> libraryFiles = new ArrayList<DriverFileInfo>();
                if (library.isCustom()) {
                    Path customFile = targetFileLocation.resolve(library.getPath());
                    if (Files.exists(customFile, new LinkOption[0])) {
                        customFile = targetFileLocation.relativize(customFile);
                        DriverFileInfo fileInfo = new DriverFileInfo(library.getId(), library.getVersion(), library.getType(), customFile, library.getPath());
                        libraryFiles.add(fileInfo);
                        this.resolvedFiles.put(library, libraryFiles);
                        continue;
                    }
                    log.debug((Object)("Driver library path '" + library.getPath() + "' cannot be resolved at '" + String.valueOf(customFile) + "'. Skipping."));
                }
                if ((srcLocalFile = library.getLocalFile()) == null) {
                    if (library.getType() == DBPDriverLibrary.FileType.license) continue;
                    log.warn((Object)("\t-Driver '" + this.driver.getFullId() + "' library file '" + library.getPath() + "' is missing"));
                    continue;
                }
                if (!Files.exists(srcLocalFile, new LinkOption[0])) {
                    if (library.getType() == DBPDriverLibrary.FileType.license) continue;
                    log.warn((Object)("\tDriver '" + this.driver.getFullId() + "' library file '" + String.valueOf(srcLocalFile.toAbsolutePath()) + "' doesn't exist"));
                    continue;
                }
                String targetPath = library.getPath();
                int divPos = targetPath.indexOf(":");
                if (divPos != -1) {
                    targetPath = targetPath.substring(divPos + 1);
                    while (targetPath.startsWith("/")) {
                        targetPath = targetPath.substring(1);
                    }
                }
                if (Files.isDirectory(srcLocalFile, new LinkOption[0])) {
                    Path targetFolder = targetFileLocation.resolve(targetPath);
                    try {
                        this.resolveDirectories(targetFileLocation, library, srcLocalFile, targetFolder, libraryFiles);
                    }
                    catch (IOException e) {
                        log.error((Object)("Error resolving directory files at '" + String.valueOf(srcLocalFile) + "'"), (Throwable)e);
                    }
                } else {
                    Path trgLocalFile = targetFileLocation.resolve(targetPath);
                    DriverFileInfo fileInfo = this.resolveFile(targetFileLocation, library, srcLocalFile, trgLocalFile);
                    if (fileInfo != null) {
                        libraryFiles.add(fileInfo);
                    }
                }
                if (libraryFiles.isEmpty()) continue;
                this.resolvedFiles.put(library, libraryFiles);
                continue;
            }
            List libraryResolvedFiles = (List)tempResolvedFiles.get(library);
            if (libraryResolvedFiles == null || libraryResolvedFiles.isEmpty()) continue;
            ArrayList<DriverFileInfo> libraryFiles = new ArrayList<DriverFileInfo>();
            for (DriverFileInfo fileInfo : libraryResolvedFiles) {
                try {
                    Path targetFile;
                    Path path = targetFile = IOUtils.isFileFromDefaultFS((Path)targetFileLocation) ? targetFileLocation.resolve(fileInfo.getFile()) : targetFileLocation.resolve(fileInfo.getFileLocation());
                    if (!Files.exists(targetFile, new LinkOption[0])) continue;
                    libraryFiles.add(fileInfo);
                }
                catch (Exception e) {
                    log.error((Object)("Error resolve: " + String.valueOf(targetFileLocation) + " with " + String.valueOf(fileInfo.getFile())));
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            if (libraryFiles.isEmpty()) continue;
            this.resolvedFiles.put(library, libraryFiles);
        }
        if (this.resolvedFiles.isEmpty()) {
            return false;
        }
        this.driver.setModified(true);
        return true;
    }

    private void resolveDirectories(@NotNull Path targetFileLocation, @NotNull DBPDriverLibrary library, @NotNull Path srcLocalFile, @NotNull Path trgLocalFile, @NotNull List<DriverFileInfo> libraryFiles) throws IOException {
        Throwable throwable = null;
        Object var7_8 = null;
        try (Stream<Path> list = Files.list(srcLocalFile);){
            List<Path> srcDirFiles = list.toList();
            for (Path dirFile : srcDirFiles) {
                String fileName = dirFile.getFileName().toString();
                if (fileName.endsWith(".txt")) continue;
                Path trgDirFile = trgLocalFile.resolve(dirFile.getFileName().toString());
                if (Files.isDirectory(dirFile, new LinkOption[0])) {
                    this.resolveDirectories(targetFileLocation, library, dirFile, trgDirFile, libraryFiles);
                    continue;
                }
                DriverFileInfo fileInfo = this.resolveFile(targetFileLocation, library, dirFile, trgDirFile);
                if (fileInfo == null) continue;
                libraryFiles.add(fileInfo);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @NotNull
    private DriverFileInfo resolveFile(@NotNull Path targetFileLocation, @NotNull DBPDriverLibrary library, @NotNull Path srcLocalFile, @NotNull Path trgLocalFile) {
        Path relPath = targetFileLocation.relativize(trgLocalFile);
        DriverFileInfo info = new DriverFileInfo(trgLocalFile.getFileName().toString(), null, library.getType(), relPath, trgLocalFile.toString());
        info.setFileCRC(DriverUtils.calculateFileCRC(srcLocalFile));
        return info;
    }
}

