/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.util.deparser;

import net.sf.jsqlparser.statement.drop.Drop;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.util.deparser.AbstractDeParser;

public class DropDeParser
extends AbstractDeParser<Drop> {
    public DropDeParser(StringBuilder buffer) {
        super(buffer);
    }

    @Override
    public void deParse(Drop drop) {
        this.builder.append("DROP ");
        if (drop.isUsingTemporary()) {
            this.builder.append("TEMPORARY ");
        }
        if (drop.isMaterialized()) {
            this.builder.append("MATERIALIZED ");
        }
        this.builder.append(drop.getType());
        if (drop.isIfExists()) {
            this.builder.append(" IF EXISTS");
        }
        this.builder.append(" ").append(drop.getName());
        if (drop.getType().equals("FUNCTION")) {
            this.builder.append(Drop.formatFuncParams(drop.getParamsByType("FUNCTION")));
        }
        if (drop.getParameters() != null && !drop.getParameters().isEmpty()) {
            this.builder.append(" ").append(PlainSelect.getStringList(drop.getParameters(), false, false));
        }
    }
}

