/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.data.order;

import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.data.messages.DataMessages;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.utils.CommonUtils;

public enum OrderingStrategy {
    SMART(DataMessages.database_resultsets_label_order_mode_smart),
    CLIENT_SIDE(DataMessages.database_resultsets_label_order_mode_always_client),
    SERVER_SIDE(DataMessages.database_resultsets_label_order_mode_always_server);

    private final String text;

    private OrderingStrategy(String text) {
        this.text = text;
    }

    @NotNull
    public static OrderingStrategy get(@NotNull DBPPreferenceStore store) {
        String value = store.getString("resultset.order.mode");
        return (OrderingStrategy)CommonUtils.valueOf(OrderingStrategy.class, (String)value, (Enum)SMART);
    }

    @NotNull
    public String getText() {
        return this.text;
    }
}

