/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.ui.properties;

import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CommandStackEventListener;
import org.eclipse.gef.ui.properties.UndoablePropertySheetEntry;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.views.properties.IPropertySheetEntry;
import org.eclipse.ui.views.properties.PropertySheetPage;

public class UndoablePropertySheetPage
extends PropertySheetPage {
    private final IAction undoHandler;
    private final IAction redoHandler;
    private final CommandStack commandStack;
    private final CommandStackEventListener commandStackEventListener;

    public UndoablePropertySheetPage(CommandStack commandStack, IAction undoAction, IAction redoAction) {
        this.undoHandler = undoAction;
        this.redoHandler = redoAction;
        this.commandStack = commandStack;
        this.commandStackEventListener = event -> {
            if (event.getDetail() == 4 || event.getDetail() == 2) {
                this.refresh();
            }
        };
        commandStack.addCommandStackEventListener(this.commandStackEventListener);
        this.setRootEntry((IPropertySheetEntry)new UndoablePropertySheetEntry(commandStack));
    }

    public void dispose() {
        if (this.commandStack != null) {
            this.commandStack.removeCommandStackEventListener(this.commandStackEventListener);
        }
        super.dispose();
    }

    public void setActionBars(IActionBars actionBars) {
        super.setActionBars(actionBars);
        actionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), this.undoHandler);
        actionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), this.redoHandler);
    }
}

