/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql;

import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.Section;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.css.CSSUtils;
import org.jkiss.dbeaver.ui.editors.sql.QueryProcessor;
import org.jkiss.dbeaver.ui.editors.sql.QueryResultsContainer;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditor;
import org.jkiss.dbeaver.ui.editors.sql.SingleTabQueryResultsContainer;
import org.jkiss.utils.Pair;

class SingleTabQueryProcessor
extends QueryProcessor {
    private static final int SCROLL_SPEED = 10;
    private boolean tabCreated;
    private CTabItem resultsTab;
    private ScrolledComposite tabContentScroller;
    private Composite sectionsContainer;

    SingleTabQueryProcessor(@NotNull SQLEditor owner, boolean makeDefault) {
        super(owner, false, makeDefault);
    }

    Composite getSectionsContainer() {
        return this.sectionsContainer;
    }

    CTabItem getResultsTab() {
        return this.resultsTab;
    }

    public void setResultsTab(CTabItem resultsTab) {
        this.resultsTab = resultsTab;
    }

    @Override
    @NotNull
    protected QueryResultsContainer createQueryResultsContainer(int resultSetNumber, int resultSetIndex, boolean singleQuery, boolean makeDefault) {
        return new SingleTabQueryResultsContainer(this.createSection(makeDefault), this, resultSetNumber, resultSetIndex, singleQuery, makeDefault);
    }

    @Override
    @NotNull
    protected QueryResultsContainer createQueryResultsContainer(int resultSetNumber, int resultSetIndex, @NotNull DBSDataContainer dataContainer, boolean singleQuery) {
        return new SingleTabQueryResultsContainer(this.createSection(false), this, resultSetNumber, resultSetIndex, dataContainer, singleQuery);
    }

    @NotNull
    private Pair<Section, Composite> createSection(boolean makeDefault) {
        if (!this.tabCreated) {
            this.tabCreated = true;
            this.prepareResultSetContainerHost(makeDefault);
        }
        Section section = new Section(this.sectionsContainer, 66);
        section.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Composite contents = UIUtils.createComposite((Composite)section, (int)1);
        section.setClient((Control)contents);
        section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                SingleTabQueryProcessor.this.relayoutContents();
            }
        });
        return new Pair((Object)section, (Object)contents);
    }

    public void relayoutContents() {
        this.tabContentScroller.setMinSize(this.sectionsContainer.computeSize(this.tabContentScroller.getBorderWidth(), -1));
        this.sectionsContainer.layout();
    }

    private void prepareResultSetContainerHost(boolean makeDefault) {
        SQLEditor owner = this.getOwner();
        this.tabContentScroller = new ScrolledComposite((Composite)owner.getResultTabsContainer(), 2560);
        this.tabContentScroller.setExpandHorizontal(true);
        this.tabContentScroller.setExpandVertical(true);
        int tabIndex = owner.obtainDesiredTabIndex(makeDefault);
        this.resultsTab = new CTabItem(owner.getResultTabsContainer(), 0, tabIndex);
        this.resultsTab.setImage(SQLEditor.IMG_DATA_GRID);
        this.resultsTab.setData((Object)this);
        this.resultsTab.setShowClose(true);
        int queryIndex = owner.queryProcessors.indexOf(this);
        this.resultsTab.setText(owner.getResultsTabName(0, queryIndex, null));
        CSSUtils.markConnectionTypeColor((Widget)this.resultsTab);
        this.resultsTab.setControl((Control)this.tabContentScroller);
        this.resultsTab.addDisposeListener(owner.resultTabDisposeListener);
        UIUtils.disposeControlOnItemDispose((CTabItem)this.resultsTab);
        this.sectionsContainer = new Composite((Composite)this.tabContentScroller, 0);
        this.sectionsContainer.setLayout((Layout)new GridLayout(1, false));
        this.sectionsContainer.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.tabContentScroller.setContent((Control)this.sectionsContainer);
        Listener scrollListener = event -> {
            Control underScroll = (Control)event.widget;
            if (underScroll.getShell() == this.tabContentScroller.getShell() && this.tabContentScroller.isVisible() && (event.stateMask & 0x40000) == 262144) {
                Point clickedPoint = underScroll.toDisplay(event.x, event.y);
                if (this.tabContentScroller.getClientArea().contains(this.tabContentScroller.toControl(clickedPoint))) {
                    Control c = underScroll;
                    while (c != null) {
                        if (c == this.tabContentScroller) {
                            Point offset = this.tabContentScroller.getOrigin();
                            offset.y -= event.count * 10;
                            if (offset.y < 0) {
                                offset.y = 0;
                            }
                            this.tabContentScroller.setOrigin(offset);
                            event.doit = false;
                        }
                        c = c.getParent();
                    }
                }
            }
        };
        this.tabContentScroller.getDisplay().addFilter(37, scrollListener);
        this.tabContentScroller.addDisposeListener(e -> this.tabContentScroller.getDisplay().removeFilter(37, scrollListener));
    }
}

