/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.macos.config;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ModelPreferences;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.IObjectPropertyConfigurator;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.macos.CocoaUIService;
import org.jkiss.dbeaver.ui.preferences.PrefPageMiscellaneousAbstract;

public class PrefPageMouseConfigurator
implements IObjectPropertyConfigurator<PrefPageMiscellaneousAbstract, PrefPageMiscellaneousAbstract> {
    private Button tooltipDelayCheck;
    private Text tooltipDelayText;

    public void createControl(@NotNull Composite parent, PrefPageMiscellaneousAbstract object, @NotNull Runnable propertyChangeListener) {
        DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        Composite group = UIUtils.createTitledComposite((Composite)parent, (String)"Mouse pointer", (int)2, (int)768);
        this.tooltipDelayCheck = UIUtils.createCheckbox((Composite)group, (String)"Set tooltip delay (ms)", (boolean)false);
        this.tooltipDelayCheck.setLayoutData((Object)new GridData());
        this.tooltipDelayCheck.setSelection(store.getInt("macos.tooltip.delay") > 0);
        this.tooltipDelayCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PrefPageMouseConfigurator.this.tooltipDelayText.setEnabled(PrefPageMouseConfigurator.this.tooltipDelayCheck.getSelection());
            }
        });
        this.tooltipDelayText = new Text(group, 2048);
        GridData gd = new GridData(32);
        gd.widthHint = UIUtils.getFontHeight((Control)this.tooltipDelayText) * 5;
        this.tooltipDelayText.setLayoutData((Object)gd);
        this.tooltipDelayText.setText(String.valueOf(store.getInt("macos.tooltip.delay")));
        this.tooltipDelayText.setEnabled(false);
    }

    public void loadSettings(@NotNull PrefPageMiscellaneousAbstract prefPageMiscellaneousAbstract) {
        DBPPreferenceStore store = ModelPreferences.getPreferences();
        this.tooltipDelayCheck.setSelection(store.getBoolean("macos.tooltip.delay.enabled"));
        this.tooltipDelayText.setText(store.getString("macos.tooltip.delay"));
        this.tooltipDelayText.setEnabled(this.tooltipDelayCheck.getSelection());
    }

    public void saveSettings(@NotNull PrefPageMiscellaneousAbstract prefPageMiscellaneousAbstract) {
        DBPPreferenceStore store = ModelPreferences.getPreferences();
        store.setValue("macos.tooltip.delay.enabled", this.tooltipDelayCheck.getSelection());
        store.setValue("macos.tooltip.delay", this.tooltipDelayText.getText());
        CocoaUIService.updateTooltipDefaults();
    }

    public void resetSettings(@NotNull PrefPageMiscellaneousAbstract prefPageMiscellaneousAbstract) {
    }

    public boolean isComplete() {
        return true;
    }
}

