
// This is ammo.js, a port of Bullet Physics to JavaScript. zlib licensed.
var AmmoLib = function(Module) {
  Module = Module || {};

var Module;if(!Module)Module=(typeof AmmoLib!=="undefined"?AmmoLib:null)||{};var moduleOverrides={};for(var key in Module){if(Module.hasOwnProperty(key)){moduleOverrides[key]=Module[key]}}var ENVIRONMENT_IS_NODE=typeof process==="object"&&typeof require==="function";var ENVIRONMENT_IS_WEB=typeof window==="object";var ENVIRONMENT_IS_WORKER=typeof importScripts==="function";var ENVIRONMENT_IS_SHELL=!ENVIRONMENT_IS_WEB&&!ENVIRONMENT_IS_NODE&&!ENVIRONMENT_IS_WORKER;if(ENVIRONMENT_IS_NODE){if(!Module["print"])Module["print"]=function print(x){process["stdout"].write(x+"\n")};if(!Module["printErr"])Module["printErr"]=function printErr(x){process["stderr"].write(x+"\n")};var nodeFS=require("fs");var nodePath=require("path");Module["read"]=function read(filename,binary){filename=nodePath["normalize"](filename);var ret=nodeFS["readFileSync"](filename);if(!ret&&filename!=nodePath["resolve"](filename)){filename=path.join(__dirname,"..","src",filename);ret=nodeFS["readFileSync"](filename)}if(ret&&!binary)ret=ret.toString();return ret};Module["readBinary"]=function readBinary(filename){return Module["read"](filename,true)};Module["load"]=function load(f){globalEval(read(f))};if(!Module["thisProgram"]){if(process["argv"].length>1){Module["thisProgram"]=process["argv"][1].replace(/\\/g,"/")}else{Module["thisProgram"]="unknown-program"}}Module["arguments"]=process["argv"].slice(2);if(typeof module!=="undefined"){module["exports"]=Module}process["on"]("uncaughtException",(function(ex){if(!(ex instanceof ExitStatus)){throw ex}}))}else if(ENVIRONMENT_IS_SHELL){if(!Module["print"])Module["print"]=print;if(typeof printErr!="undefined")Module["printErr"]=printErr;if(typeof read!="undefined"){Module["read"]=read}else{Module["read"]=function read(){throw"no read() available (jsc?)"}}Module["readBinary"]=function readBinary(f){if(typeof readbuffer==="function"){return new Uint8Array(readbuffer(f))}var data=read(f,"binary");assert(typeof data==="object");return data};if(typeof scriptArgs!="undefined"){Module["arguments"]=scriptArgs}else if(typeof arguments!="undefined"){Module["arguments"]=arguments}}else if(ENVIRONMENT_IS_WEB||ENVIRONMENT_IS_WORKER){Module["read"]=function read(url){var xhr=new XMLHttpRequest;xhr.open("GET",url,false);xhr.send(null);return xhr.responseText};if(typeof arguments!="undefined"){Module["arguments"]=arguments}if(typeof console!=="undefined"){if(!Module["print"])Module["print"]=function print(x){console.log(x)};if(!Module["printErr"])Module["printErr"]=function printErr(x){console.log(x)}}else{var TRY_USE_DUMP=false;if(!Module["print"])Module["print"]=TRY_USE_DUMP&&typeof dump!=="undefined"?(function(x){dump(x)}):(function(x){})}if(ENVIRONMENT_IS_WORKER){Module["load"]=importScripts}if(typeof Module["setWindowTitle"]==="undefined"){Module["setWindowTitle"]=(function(title){document.title=title})}}else{throw"Unknown runtime environment. Where are we?"}function globalEval(x){throw"NO_DYNAMIC_EXECUTION was set, cannot eval"}if(!Module["load"]&&Module["read"]){Module["load"]=function load(f){globalEval(Module["read"](f))}}if(!Module["print"]){Module["print"]=(function(){})}if(!Module["printErr"]){Module["printErr"]=Module["print"]}if(!Module["arguments"]){Module["arguments"]=[]}if(!Module["thisProgram"]){Module["thisProgram"]="./this.program"}Module.print=Module["print"];Module.printErr=Module["printErr"];Module["preRun"]=[];Module["postRun"]=[];for(var key in moduleOverrides){if(moduleOverrides.hasOwnProperty(key)){Module[key]=moduleOverrides[key]}}var Runtime={setTempRet0:(function(value){tempRet0=value}),getTempRet0:(function(){return tempRet0}),stackSave:(function(){return STACKTOP}),stackRestore:(function(stackTop){STACKTOP=stackTop}),getNativeTypeSize:(function(type){switch(type){case"i1":case"i8":return 1;case"i16":return 2;case"i32":return 4;case"i64":return 8;case"float":return 4;case"double":return 8;default:{if(type[type.length-1]==="*"){return Runtime.QUANTUM_SIZE}else if(type[0]==="i"){var bits=parseInt(type.substr(1));assert(bits%8===0);return bits/8}else{return 0}}}}),getNativeFieldSize:(function(type){return Math.max(Runtime.getNativeTypeSize(type),Runtime.QUANTUM_SIZE)}),STACK_ALIGN:16,getAlignSize:(function(type,size,vararg){if(!vararg&&(type=="i64"||type=="double"))return 8;if(!type)return Math.min(size,8);return Math.min(size||(type?Runtime.getNativeFieldSize(type):0),Runtime.QUANTUM_SIZE)}),dynCall:(function(sig,ptr,args){if(args&&args.length){if(!args.splice)args=Array.prototype.slice.call(args);args.splice(0,0,ptr);return Module["dynCall_"+sig].apply(null,args)}else{return Module["dynCall_"+sig].call(null,ptr)}}),functionPointers:[],addFunction:(function(func){for(var i=0;i<Runtime.functionPointers.length;i++){if(!Runtime.functionPointers[i]){Runtime.functionPointers[i]=func;return 2*(1+i)}}throw"Finished up all reserved function pointers. Use a higher value for RESERVED_FUNCTION_POINTERS."}),removeFunction:(function(index){Runtime.functionPointers[(index-2)/2]=null}),getAsmConst:(function(code,numArgs){if(!Runtime.asmConstCache)Runtime.asmConstCache={};var func=Runtime.asmConstCache[code];if(func)return func;var args=[];for(var i=0;i<numArgs;i++){args.push(String.fromCharCode(36)+i)}var source=Pointer_stringify(code);if(source[0]==='"'){if(source.indexOf('"',1)===source.length-1){source=source.substr(1,source.length-2)}else{abort("invalid EM_ASM input |"+source+"|. Please use EM_ASM(..code..) (no quotes) or EM_ASM({ ..code($0).. }, input) (to input values)")}}abort("NO_DYNAMIC_EXECUTION was set, cannot eval, so EM_ASM is not functional");return Runtime.asmConstCache[code]=evalled}),warnOnce:(function(text){if(!Runtime.warnOnce.shown)Runtime.warnOnce.shown={};if(!Runtime.warnOnce.shown[text]){Runtime.warnOnce.shown[text]=1;Module.printErr(text)}}),funcWrappers:{},getFuncWrapper:(function(func,sig){assert(sig);if(!Runtime.funcWrappers[sig]){Runtime.funcWrappers[sig]={}}var sigCache=Runtime.funcWrappers[sig];if(!sigCache[func]){sigCache[func]=function dynCall_wrapper(){return Runtime.dynCall(sig,func,arguments)}}return sigCache[func]}),getCompilerSetting:(function(name){throw"You must build with -s RETAIN_COMPILER_SETTINGS=1 for Runtime.getCompilerSetting or emscripten_get_compiler_setting to work"}),stackAlloc:(function(size){var ret=STACKTOP;STACKTOP=STACKTOP+size|0;STACKTOP=STACKTOP+15&-16;return ret}),staticAlloc:(function(size){var ret=STATICTOP;STATICTOP=STATICTOP+size|0;STATICTOP=STATICTOP+15&-16;return ret}),dynamicAlloc:(function(size){var ret=DYNAMICTOP;DYNAMICTOP=DYNAMICTOP+size|0;DYNAMICTOP=DYNAMICTOP+15&-16;if(DYNAMICTOP>=TOTAL_MEMORY)enlargeMemory();return ret}),alignMemory:(function(size,quantum){var ret=size=Math.ceil(size/(quantum?quantum:16))*(quantum?quantum:16);return ret}),makeBigInt:(function(low,high,unsigned){var ret=unsigned?+(low>>>0)+ +(high>>>0)*+4294967296:+(low>>>0)+ +(high|0)*+4294967296;return ret}),GLOBAL_BASE:8,QUANTUM_SIZE:4,__dummy__:0};Module["Runtime"]=Runtime;var __THREW__=0;var ABORT=false;var EXITSTATUS=0;var undef=0;var tempValue,tempInt,tempBigInt,tempInt2,tempBigInt2,tempPair,tempBigIntI,tempBigIntR,tempBigIntS,tempBigIntP,tempBigIntD,tempDouble,tempFloat;var tempI64,tempI64b;var tempRet0,tempRet1,tempRet2,tempRet3,tempRet4,tempRet5,tempRet6,tempRet7,tempRet8,tempRet9;function assert(condition,text){if(!condition){abort("Assertion failed: "+text)}}var globalScope=this;function getCFunc(ident){var func=Module["_"+ident];if(!func){abort("NO_DYNAMIC_EXECUTION was set, cannot eval - ccall/cwrap are not functional")}assert(func,"Cannot call unknown function "+ident+" (perhaps LLVM optimizations or closure removed it?)");return func}var cwrap,ccall;((function(){var JSfuncs={"stackSave":(function(){Runtime.stackSave()}),"stackRestore":(function(){Runtime.stackRestore()}),"arrayToC":(function(arr){var ret=Runtime.stackAlloc(arr.length);writeArrayToMemory(arr,ret);return ret}),"stringToC":(function(str){var ret=0;if(str!==null&&str!==undefined&&str!==0){ret=Runtime.stackAlloc((str.length<<2)+1);writeStringToMemory(str,ret)}return ret})};var toC={"string":JSfuncs["stringToC"],"array":JSfuncs["arrayToC"]};ccall=function ccallFunc(ident,returnType,argTypes,args){var func=getCFunc(ident);var cArgs=[];var stack=0;if(args){for(var i=0;i<args.length;i++){var converter=toC[argTypes[i]];if(converter){if(stack===0)stack=Runtime.stackSave();cArgs[i]=converter(args[i])}else{cArgs[i]=args[i]}}}var ret=func.apply(null,cArgs);if(returnType==="string")ret=Pointer_stringify(ret);if(stack!==0)Runtime.stackRestore(stack);return ret};cwrap=function cwrap(ident,returnType,argTypes){return(function(){return ccall(ident,returnType,argTypes,arguments)})}}))();Module["cwrap"]=cwrap;Module["ccall"]=ccall;function setValue(ptr,value,type,noSafe){type=type||"i8";if(type.charAt(type.length-1)==="*")type="i32";switch(type){case"i1":HEAP8[ptr>>0]=value;break;case"i8":HEAP8[ptr>>0]=value;break;case"i16":HEAP16[ptr>>1]=value;break;case"i32":HEAP32[ptr>>2]=value;break;case"i64":tempI64=[value>>>0,(tempDouble=value,+Math_abs(tempDouble)>=+1?tempDouble>+0?(Math_min(+Math_floor(tempDouble/+4294967296),+4294967295)|0)>>>0:~~+Math_ceil((tempDouble- +(~~tempDouble>>>0))/+4294967296)>>>0:0)],HEAP32[ptr>>2]=tempI64[0],HEAP32[ptr+4>>2]=tempI64[1];break;case"float":HEAPF32[ptr>>2]=value;break;case"double":HEAPF64[ptr>>3]=value;break;default:abort("invalid type for setValue: "+type)}}Module["setValue"]=setValue;function getValue(ptr,type,noSafe){type=type||"i8";if(type.charAt(type.length-1)==="*")type="i32";switch(type){case"i1":return HEAP8[ptr>>0];case"i8":return HEAP8[ptr>>0];case"i16":return HEAP16[ptr>>1];case"i32":return HEAP32[ptr>>2];case"i64":return HEAP32[ptr>>2];case"float":return HEAPF32[ptr>>2];case"double":return HEAPF64[ptr>>3];default:abort("invalid type for setValue: "+type)}return null}Module["getValue"]=getValue;var ALLOC_NORMAL=0;var ALLOC_STACK=1;var ALLOC_STATIC=2;var ALLOC_DYNAMIC=3;var ALLOC_NONE=4;Module["ALLOC_NORMAL"]=ALLOC_NORMAL;Module["ALLOC_STACK"]=ALLOC_STACK;Module["ALLOC_STATIC"]=ALLOC_STATIC;Module["ALLOC_DYNAMIC"]=ALLOC_DYNAMIC;Module["ALLOC_NONE"]=ALLOC_NONE;function allocate(slab,types,allocator,ptr){var zeroinit,size;if(typeof slab==="number"){zeroinit=true;size=slab}else{zeroinit=false;size=slab.length}var singleType=typeof types==="string"?types:null;var ret;if(allocator==ALLOC_NONE){ret=ptr}else{ret=[_malloc,Runtime.stackAlloc,Runtime.staticAlloc,Runtime.dynamicAlloc][allocator===undefined?ALLOC_STATIC:allocator](Math.max(size,singleType?1:types.length))}if(zeroinit){var ptr=ret,stop;assert((ret&3)==0);stop=ret+(size&~3);for(;ptr<stop;ptr+=4){HEAP32[ptr>>2]=0}stop=ret+size;while(ptr<stop){HEAP8[ptr++>>0]=0}return ret}if(singleType==="i8"){if(slab.subarray||slab.slice){HEAPU8.set(slab,ret)}else{HEAPU8.set(new Uint8Array(slab),ret)}return ret}var i=0,type,typeSize,previousType;while(i<size){var curr=slab[i];if(typeof curr==="function"){curr=Runtime.getFunctionIndex(curr)}type=singleType||types[i];if(type===0){i++;continue}if(type=="i64")type="i32";setValue(ret+i,curr,type);if(previousType!==type){typeSize=Runtime.getNativeTypeSize(type);previousType=type}i+=typeSize}return ret}Module["allocate"]=allocate;function Pointer_stringify(ptr,length){if(length===0||!ptr)return"";var hasUtf=0;var t;var i=0;while(1){t=HEAPU8[ptr+i>>0];hasUtf|=t;if(t==0&&!length)break;i++;if(length&&i==length)break}if(!length)length=i;var ret="";if(hasUtf<128){var MAX_CHUNK=1024;var curr;while(length>0){curr=String.fromCharCode.apply(String,HEAPU8.subarray(ptr,ptr+Math.min(length,MAX_CHUNK)));ret=ret?ret+curr:curr;ptr+=MAX_CHUNK;length-=MAX_CHUNK}return ret}return Module["UTF8ToString"](ptr)}Module["Pointer_stringify"]=Pointer_stringify;function AsciiToString(ptr){var str="";while(1){var ch=HEAP8[ptr++>>0];if(!ch)return str;str+=String.fromCharCode(ch)}}Module["AsciiToString"]=AsciiToString;function stringToAscii(str,outPtr){return writeAsciiToMemory(str,outPtr,false)}Module["stringToAscii"]=stringToAscii;function UTF8ArrayToString(u8Array,idx){var u0,u1,u2,u3,u4,u5;var str="";while(1){u0=u8Array[idx++];if(!u0)return str;if(!(u0&128)){str+=String.fromCharCode(u0);continue}u1=u8Array[idx++]&63;if((u0&224)==192){str+=String.fromCharCode((u0&31)<<6|u1);continue}u2=u8Array[idx++]&63;if((u0&240)==224){u0=(u0&15)<<12|u1<<6|u2}else{u3=u8Array[idx++]&63;if((u0&248)==240){u0=(u0&7)<<18|u1<<12|u2<<6|u3}else{u4=u8Array[idx++]&63;if((u0&252)==248){u0=(u0&3)<<24|u1<<18|u2<<12|u3<<6|u4}else{u5=u8Array[idx++]&63;u0=(u0&1)<<30|u1<<24|u2<<18|u3<<12|u4<<6|u5}}}if(u0<65536){str+=String.fromCharCode(u0)}else{var ch=u0-65536;str+=String.fromCharCode(55296|ch>>10,56320|ch&1023)}}}Module["UTF8ArrayToString"]=UTF8ArrayToString;function UTF8ToString(ptr){return UTF8ArrayToString(HEAPU8,ptr)}Module["UTF8ToString"]=UTF8ToString;function stringToUTF8Array(str,outU8Array,outIdx,maxBytesToWrite){if(!(maxBytesToWrite>0))return 0;var startIdx=outIdx;var endIdx=outIdx+maxBytesToWrite-1;for(var i=0;i<str.length;++i){var u=str.charCodeAt(i);if(u>=55296&&u<=57343)u=65536+((u&1023)<<10)|str.charCodeAt(++i)&1023;if(u<=127){if(outIdx>=endIdx)break;outU8Array[outIdx++]=u}else if(u<=2047){if(outIdx+1>=endIdx)break;outU8Array[outIdx++]=192|u>>6;outU8Array[outIdx++]=128|u&63}else if(u<=65535){if(outIdx+2>=endIdx)break;outU8Array[outIdx++]=224|u>>12;outU8Array[outIdx++]=128|u>>6&63;outU8Array[outIdx++]=128|u&63}else if(u<=2097151){if(outIdx+3>=endIdx)break;outU8Array[outIdx++]=240|u>>18;outU8Array[outIdx++]=128|u>>12&63;outU8Array[outIdx++]=128|u>>6&63;outU8Array[outIdx++]=128|u&63}else if(u<=67108863){if(outIdx+4>=endIdx)break;outU8Array[outIdx++]=248|u>>24;outU8Array[outIdx++]=128|u>>18&63;outU8Array[outIdx++]=128|u>>12&63;outU8Array[outIdx++]=128|u>>6&63;outU8Array[outIdx++]=128|u&63}else{if(outIdx+5>=endIdx)break;outU8Array[outIdx++]=252|u>>30;outU8Array[outIdx++]=128|u>>24&63;outU8Array[outIdx++]=128|u>>18&63;outU8Array[outIdx++]=128|u>>12&63;outU8Array[outIdx++]=128|u>>6&63;outU8Array[outIdx++]=128|u&63}}outU8Array[outIdx]=0;return outIdx-startIdx}Module["stringToUTF8Array"]=stringToUTF8Array;function stringToUTF8(str,outPtr,maxBytesToWrite){return stringToUTF8Array(str,HEAPU8,outPtr,maxBytesToWrite)}Module["stringToUTF8"]=stringToUTF8;function lengthBytesUTF8(str){var len=0;for(var i=0;i<str.length;++i){var u=str.charCodeAt(i);if(u>=55296&&u<=57343)u=65536+((u&1023)<<10)|str.charCodeAt(++i)&1023;if(u<=127){++len}else if(u<=2047){len+=2}else if(u<=65535){len+=3}else if(u<=2097151){len+=4}else if(u<=67108863){len+=5}else{len+=6}}return len}Module["lengthBytesUTF8"]=lengthBytesUTF8;function UTF16ToString(ptr){var i=0;var str="";while(1){var codeUnit=HEAP16[ptr+i*2>>1];if(codeUnit==0)return str;++i;str+=String.fromCharCode(codeUnit)}}Module["UTF16ToString"]=UTF16ToString;function stringToUTF16(str,outPtr,maxBytesToWrite){if(maxBytesToWrite===undefined){maxBytesToWrite=2147483647}if(maxBytesToWrite<2)return 0;maxBytesToWrite-=2;var startPtr=outPtr;var numCharsToWrite=maxBytesToWrite<str.length*2?maxBytesToWrite/2:str.length;for(var i=0;i<numCharsToWrite;++i){var codeUnit=str.charCodeAt(i);HEAP16[outPtr>>1]=codeUnit;outPtr+=2}HEAP16[outPtr>>1]=0;return outPtr-startPtr}Module["stringToUTF16"]=stringToUTF16;function lengthBytesUTF16(str){return str.length*2}Module["lengthBytesUTF16"]=lengthBytesUTF16;function UTF32ToString(ptr){var i=0;var str="";while(1){var utf32=HEAP32[ptr+i*4>>2];if(utf32==0)return str;++i;if(utf32>=65536){var ch=utf32-65536;str+=String.fromCharCode(55296|ch>>10,56320|ch&1023)}else{str+=String.fromCharCode(utf32)}}}Module["UTF32ToString"]=UTF32ToString;function stringToUTF32(str,outPtr,maxBytesToWrite){if(maxBytesToWrite===undefined){maxBytesToWrite=2147483647}if(maxBytesToWrite<4)return 0;var startPtr=outPtr;var endPtr=startPtr+maxBytesToWrite-4;for(var i=0;i<str.length;++i){var codeUnit=str.charCodeAt(i);if(codeUnit>=55296&&codeUnit<=57343){var trailSurrogate=str.charCodeAt(++i);codeUnit=65536+((codeUnit&1023)<<10)|trailSurrogate&1023}HEAP32[outPtr>>2]=codeUnit;outPtr+=4;if(outPtr+4>endPtr)break}HEAP32[outPtr>>2]=0;return outPtr-startPtr}Module["stringToUTF32"]=stringToUTF32;function lengthBytesUTF32(str){var len=0;for(var i=0;i<str.length;++i){var codeUnit=str.charCodeAt(i);if(codeUnit>=55296&&codeUnit<=57343)++i;len+=4}return len}Module["lengthBytesUTF32"]=lengthBytesUTF32;function demangle(func){var hasLibcxxabi=!!Module["___cxa_demangle"];if(hasLibcxxabi){try{var buf=_malloc(func.length);writeStringToMemory(func.substr(1),buf);var status=_malloc(4);var ret=Module["___cxa_demangle"](buf,0,0,status);if(getValue(status,"i32")===0&&ret){return Pointer_stringify(ret)}}catch(e){}finally{if(buf)_free(buf);if(status)_free(status);if(ret)_free(ret)}}var i=3;var basicTypes={"v":"void","b":"bool","c":"char","s":"short","i":"int","l":"long","f":"float","d":"double","w":"wchar_t","a":"signed char","h":"unsigned char","t":"unsigned short","j":"unsigned int","m":"unsigned long","x":"long long","y":"unsigned long long","z":"..."};var subs=[];var first=true;function dump(x){if(x)Module.print(x);Module.print(func);var pre="";for(var a=0;a<i;a++)pre+=" ";Module.print(pre+"^")}function parseNested(){i++;if(func[i]==="K")i++;var parts=[];while(func[i]!=="E"){if(func[i]==="S"){i++;var next=func.indexOf("_",i);var num=func.substring(i,next)||0;parts.push(subs[num]||"?");i=next+1;continue}if(func[i]==="C"){parts.push(parts[parts.length-1]);i+=2;continue}var size=parseInt(func.substr(i));var pre=size.toString().length;if(!size||!pre){i--;break}var curr=func.substr(i+pre,size);parts.push(curr);subs.push(curr);i+=pre+size}i++;return parts}function parse(rawList,limit,allowVoid){limit=limit||Infinity;var ret="",list=[];function flushList(){return"("+list.join(", ")+")"}var name;if(func[i]==="N"){name=parseNested().join("::");limit--;if(limit===0)return rawList?[name]:name}else{if(func[i]==="K"||first&&func[i]==="L")i++;var size=parseInt(func.substr(i));if(size){var pre=size.toString().length;name=func.substr(i+pre,size);i+=pre+size}}first=false;if(func[i]==="I"){i++;var iList=parse(true);var iRet=parse(true,1,true);ret+=iRet[0]+" "+name+"<"+iList.join(", ")+">"}else{ret=name}paramLoop:while(i<func.length&&limit-->0){var c=func[i++];if(c in basicTypes){list.push(basicTypes[c])}else{switch(c){case"P":list.push(parse(true,1,true)[0]+"*");break;case"R":list.push(parse(true,1,true)[0]+"&");break;case"L":{i++;var end=func.indexOf("E",i);var size=end-i;list.push(func.substr(i,size));i+=size+2;break};case"A":{var size=parseInt(func.substr(i));i+=size.toString().length;if(func[i]!=="_")throw"?";i++;list.push(parse(true,1,true)[0]+" ["+size+"]");break};case"E":break paramLoop;default:ret+="?"+c;break paramLoop}}}if(!allowVoid&&list.length===1&&list[0]==="void")list=[];if(rawList){if(ret){list.push(ret+"?")}return list}else{return ret+flushList()}}var parsed=func;try{if(func=="Object._main"||func=="_main"){return"main()"}if(typeof func==="number")func=Pointer_stringify(func);if(func[0]!=="_")return func;if(func[1]!=="_")return func;if(func[2]!=="Z")return func;switch(func[3]){case"n":return"operator new()";case"d":return"operator delete()"}parsed=parse()}catch(e){parsed+="?"}if(parsed.indexOf("?")>=0&&!hasLibcxxabi){Runtime.warnOnce("warning: a problem occurred in builtin C++ name demangling; build with  -s DEMANGLE_SUPPORT=1  to link in libcxxabi demangling")}return parsed}function demangleAll(text){return text.replace(/__Z[\w\d_]+/g,(function(x){var y=demangle(x);return x===y?x:x+" ["+y+"]"}))}function jsStackTrace(){var err=new Error;if(!err.stack){try{throw new Error(0)}catch(e){err=e}if(!err.stack){return"(no stack trace available)"}}return err.stack.toString()}function stackTrace(){return demangleAll(jsStackTrace())}Module["stackTrace"]=stackTrace;var PAGE_SIZE=4096;function alignMemoryPage(x){return x+4095&-4096}var HEAP;var HEAP8,HEAPU8,HEAP16,HEAPU16,HEAP32,HEAPU32,HEAPF32,HEAPF64;var STATIC_BASE=0,STATICTOP=0,staticSealed=false;var STACK_BASE=0,STACKTOP=0,STACK_MAX=0;var DYNAMIC_BASE=0,DYNAMICTOP=0;function enlargeMemory(){abort("Cannot enlarge memory arrays. Either (1) compile with -s TOTAL_MEMORY=X with X higher than the current value "+TOTAL_MEMORY+", (2) compile with ALLOW_MEMORY_GROWTH which adjusts the size at runtime but prevents some optimizations, or (3) set Module.TOTAL_MEMORY before the program runs.")}var TOTAL_STACK=Module["TOTAL_STACK"]||5242880;var TOTAL_MEMORY=Module["TOTAL_MEMORY"]||67108864;var FAST_MEMORY=Module["FAST_MEMORY"]||2097152;var totalMemory=64*1024;while(totalMemory<TOTAL_MEMORY||totalMemory<2*TOTAL_STACK){if(totalMemory<16*1024*1024){totalMemory*=2}else{totalMemory+=16*1024*1024}}if(totalMemory!==TOTAL_MEMORY){Module.printErr("increasing TOTAL_MEMORY to "+totalMemory+" to be compliant with the asm.js spec (and given that TOTAL_STACK="+TOTAL_STACK+")");TOTAL_MEMORY=totalMemory}assert(typeof Int32Array!=="undefined"&&typeof Float64Array!=="undefined"&&!!(new Int32Array(1))["subarray"]&&!!(new Int32Array(1))["set"],"JS engine does not provide full typed array support");var buffer=new ArrayBuffer(TOTAL_MEMORY);HEAP8=new Int8Array(buffer);HEAP16=new Int16Array(buffer);HEAP32=new Int32Array(buffer);HEAPU8=new Uint8Array(buffer);HEAPU16=new Uint16Array(buffer);HEAPU32=new Uint32Array(buffer);HEAPF32=new Float32Array(buffer);HEAPF64=new Float64Array(buffer);HEAP32[0]=255;assert(HEAPU8[0]===255&&HEAPU8[3]===0,"Typed arrays 2 must be run on a little-endian system");Module["HEAP"]=HEAP;Module["buffer"]=buffer;Module["HEAP8"]=HEAP8;Module["HEAP16"]=HEAP16;Module["HEAP32"]=HEAP32;Module["HEAPU8"]=HEAPU8;Module["HEAPU16"]=HEAPU16;Module["HEAPU32"]=HEAPU32;Module["HEAPF32"]=HEAPF32;Module["HEAPF64"]=HEAPF64;function callRuntimeCallbacks(callbacks){while(callbacks.length>0){var callback=callbacks.shift();if(typeof callback=="function"){callback();continue}var func=callback.func;if(typeof func==="number"){if(callback.arg===undefined){Runtime.dynCall("v",func)}else{Runtime.dynCall("vi",func,[callback.arg])}}else{func(callback.arg===undefined?null:callback.arg)}}}var __ATPRERUN__=[];var __ATINIT__=[];var __ATMAIN__=[];var __ATEXIT__=[];var __ATPOSTRUN__=[];var runtimeInitialized=false;var runtimeExited=false;function preRun(){if(Module["preRun"]){if(typeof Module["preRun"]=="function")Module["preRun"]=[Module["preRun"]];while(Module["preRun"].length){addOnPreRun(Module["preRun"].shift())}}callRuntimeCallbacks(__ATPRERUN__)}function ensureInitRuntime(){if(runtimeInitialized)return;runtimeInitialized=true;callRuntimeCallbacks(__ATINIT__)}function preMain(){callRuntimeCallbacks(__ATMAIN__)}function exitRuntime(){callRuntimeCallbacks(__ATEXIT__);runtimeExited=true}function postRun(){if(Module["postRun"]){if(typeof Module["postRun"]=="function")Module["postRun"]=[Module["postRun"]];while(Module["postRun"].length){addOnPostRun(Module["postRun"].shift())}}callRuntimeCallbacks(__ATPOSTRUN__)}function addOnPreRun(cb){__ATPRERUN__.unshift(cb)}Module["addOnPreRun"]=Module.addOnPreRun=addOnPreRun;function addOnInit(cb){__ATINIT__.unshift(cb)}Module["addOnInit"]=Module.addOnInit=addOnInit;function addOnPreMain(cb){__ATMAIN__.unshift(cb)}Module["addOnPreMain"]=Module.addOnPreMain=addOnPreMain;function addOnExit(cb){__ATEXIT__.unshift(cb)}Module["addOnExit"]=Module.addOnExit=addOnExit;function addOnPostRun(cb){__ATPOSTRUN__.unshift(cb)}Module["addOnPostRun"]=Module.addOnPostRun=addOnPostRun;function intArrayFromString(stringy,dontAddNull,length){var len=length>0?length:lengthBytesUTF8(stringy)+1;var u8array=new Array(len);var numBytesWritten=stringToUTF8Array(stringy,u8array,0,u8array.length);if(dontAddNull)u8array.length=numBytesWritten;return u8array}Module["intArrayFromString"]=intArrayFromString;function intArrayToString(array){var ret=[];for(var i=0;i<array.length;i++){var chr=array[i];if(chr>255){chr&=255}ret.push(String.fromCharCode(chr))}return ret.join("")}Module["intArrayToString"]=intArrayToString;function writeStringToMemory(string,buffer,dontAddNull){var array=intArrayFromString(string,dontAddNull);var i=0;while(i<array.length){var chr=array[i];HEAP8[buffer+i>>0]=chr;i=i+1}}Module["writeStringToMemory"]=writeStringToMemory;function writeArrayToMemory(array,buffer){for(var i=0;i<array.length;i++){HEAP8[buffer++>>0]=array[i]}}Module["writeArrayToMemory"]=writeArrayToMemory;function writeAsciiToMemory(str,buffer,dontAddNull){for(var i=0;i<str.length;++i){HEAP8[buffer++>>0]=str.charCodeAt(i)}if(!dontAddNull)HEAP8[buffer>>0]=0}Module["writeAsciiToMemory"]=writeAsciiToMemory;function unSign(value,bits,ignore){if(value>=0){return value}return bits<=32?2*Math.abs(1<<bits-1)+value:Math.pow(2,bits)+value}function reSign(value,bits,ignore){if(value<=0){return value}var half=bits<=32?Math.abs(1<<bits-1):Math.pow(2,bits-1);if(value>=half&&(bits<=32||value>half)){value=-2*half+value}return value}if(!Math["imul"]||Math["imul"](4294967295,5)!==-5)Math["imul"]=function imul(a,b){var ah=a>>>16;var al=a&65535;var bh=b>>>16;var bl=b&65535;return al*bl+(ah*bl+al*bh<<16)|0};Math.imul=Math["imul"];if(!Math["clz32"])Math["clz32"]=(function(x){x=x>>>0;for(var i=0;i<32;i++){if(x&1<<31-i)return i}return 32});Math.clz32=Math["clz32"];var Math_abs=Math.abs;var Math_cos=Math.cos;var Math_sin=Math.sin;var Math_tan=Math.tan;var Math_acos=Math.acos;var Math_asin=Math.asin;var Math_atan=Math.atan;var Math_atan2=Math.atan2;var Math_exp=Math.exp;var Math_log=Math.log;var Math_sqrt=Math.sqrt;var Math_ceil=Math.ceil;var Math_floor=Math.floor;var Math_pow=Math.pow;var Math_imul=Math.imul;var Math_fround=Math.fround;var Math_min=Math.min;var Math_clz32=Math.clz32;var runDependencies=0;var runDependencyWatcher=null;var dependenciesFulfilled=null;function addRunDependency(id){runDependencies++;if(Module["monitorRunDependencies"]){Module["monitorRunDependencies"](runDependencies)}}Module["addRunDependency"]=addRunDependency;function removeRunDependency(id){runDependencies--;if(Module["monitorRunDependencies"]){Module["monitorRunDependencies"](runDependencies)}if(runDependencies==0){if(runDependencyWatcher!==null){clearInterval(runDependencyWatcher);runDependencyWatcher=null}if(dependenciesFulfilled){var callback=dependenciesFulfilled;dependenciesFulfilled=null;callback()}}}Module["removeRunDependency"]=removeRunDependency;Module["preloadedImages"]={};Module["preloadedAudios"]={};var memoryInitializer=null;STATIC_BASE=8;STATICTOP=STATIC_BASE+21936;__ATINIT__.push({func:(function(){__GLOBAL__sub_I_btQuickprof_cpp()})});allocate([0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96,1,0,0,1,0,0,0,2,0,0,0,3,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,49,55,98,116,84,121,112,101,100,67,111,110,115,116,114,97,105,110,116,0,0,0,0,0,49,51,98,116,84,121,112,101,100,79,98,106,101,99,116,0,216,82,0,0,72,1,0,0,96,83,0,0,48,1,0,0,0,0,0,0,1,0,0,0,88,1,0,0,2,4,0,0,0,0,0,0,216,1,0,0,4,0,0,0,5,0,0,0,2,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,49,57,98,116,71,104,111,115,116,80,97,105,114,67,97,108,108,98,97,99,107,0,0,0,50,53,98,116,79,118,101,114,108,97,112,112,105,110,103,80,97,105,114,67,97,108,108,98,97,99,107,0,0,0,0,0,216,82,0,0,176,1,0,0,0,83,0,0,152,1,0,0,208,1,0,0,0,0,0,0,49,56,98,116,86,101,104,105,99,108,101,82,97,121,99,97,115,116,101,114,0,0,0,0,216,82,0,0,232,1,0,0,0,0,0,0,128,2,0,0,6,0,0,0,7,0,0,0,1,0,0,0,1,0,0,0,78,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,50,52,67,108,111,115,101,115,116,82,97,121,82,101,115,117,108,116,67,97,108,108,98,97,99,107,69,0,0,78,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,49,55,82,97,121,82,101,115,117,108,116,67,97,108,108,98,97,99,107,69,0,216,82,0,0,80,2,0,0,0,83,0,0,32,2,0,0,120,2,0,0,0,0,0,0,0,0,0,0,216,2,0,0,8,0,0,0,9,0,0,0,1,0,0,0,2,0,0,0,50,48,98,116,68,101,102,97,117,108,116,77,111,116,105,111,110,83,116,97,116,101,0,0,49,51,98,116,77,111,116,105,111,110,83,116,97,116,101,0,216,82,0,0,192,2,0,0,0,83,0,0,168,2,0,0,208,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,3,0,0,10,0,0,0,11,0,0,0,2,0,0,0,2,0,0,0,78,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,50,55,67,108,111,115,101,115,116,67,111,110,118,101,120,82,101,115,117,108,116,67,97,108,108,98,97,99,107,69,0,0,0,0,0,0,0,78,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,50,48,67,111,110,118,101,120,82,101,115,117,108,116,67,97,108,108,98,97,99,107,69,0,0,0,0,0,0,216,82,0,0,184,3,0,0,0,83,0,0,128,3,0,0,232,3,0,0,0,0,0,0,0,0,0,0,112,4,0,0,12,0,0,0,13,0,0,0,3,0,0,0,1,0,0,0,50,57,67,111,110,99,114,101,116,101,67,111,110,116,97,99,116,82,101,115,117,108,116,67,97,108,108,98,97,99,107,0,78,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,50,49,67,111,110,116,97,99,116,82,101,115,117,108,116,67,97,108,108,98,97,99,107,69,0,0,0,0,0,216,82,0,0,56,4,0,0,0,83,0,0,24,4,0,0,104,4,0,0,0,0,0,0,123,32,118,97,114,32,115,101,108,102,32,61,32,77,111,100,117,108,101,91,39,103,101,116,67,97,99,104,101,39,93,40,77,111,100,117,108,101,91,39,67,111,110,99,114,101,116,101,67,111,110,116,97,99,116,82,101,115,117,108,116,67,97,108,108,98,97,99,107,39,93,41,91,36,48,93,59,32,105,102,32,40,33,115,101,108,102,46,104,97,115,79,119,110,80,114,111,112,101,114,116,121,40,39,97,100,100,83,105,110,103,108,101,82,101,115,117,108,116,39,41,41,32,116,104,114,111,119,32,39,97,32,74,83,73,109,112,108,101,109,101,110,116,97,116,105,111,110,32,109,117,115,116,32,105,109,112,108,101,109,101,110,116,32,97,108,108,32,102,117,110,99,116,105,111,110,115,44,32,121,111,117,32,102,111,114,103,111,116,32,67,111,110,99,114,101,116,101,67,111,110,116,97,99,116,82,101,115,117,108,116,67,97,108,108,98,97,99,107,58,58,97,100,100,83,105,110,103,108,101,82,101,115,117,108,116,46,39,59,32,114,101,116,117,114,110,32,115,101,108,102,46,97,100,100,83,105,110,103,108,101,82,101,115,117,108,116,40,36,49,44,36,50,44,36,51,44,36,52,44,36,53,44,36,54,44,36,55,41,59,32,125,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,6,0,0,4,0,0,0,14,0,0,0,15,0,0,0,3,0,0,0,2,0,0,0,3,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,98,116,82,105,103,105,100,66,111,100,121,70,108,111,97,116,68,97,116,97,0,0,0,0,49,49,98,116,82,105,103,105,100,66,111,100,121,0,0,0,0,83,0,0,248,5,0,0,24,21,0,0,0,0,0,0,0,0,0,0,224,8,0,0,16,0,0,0,17,0,0,0,18,0,0,0,19,0,0,0,5,0,0,0,3,0,0,0,20,0,0,0,1,0,0,0,2,0,0,0,3,0,0,0,6,0,0,0,21,0,0,0,7,0,0,0,1,0,0,0,2,0,0,0,8,0,0,0,9,0,0,0,10,0,0,0,11,0,0,0,12,0,0,0,22,0,0,0,13,0,0,0,4,0,0,0,14,0,0,0,15,0,0,0,4,0,0,0,5,0,0,0,5,0,0,0,6,0,0,0,6,0,0,0,23,0,0,0,16,0,0,0,17,0,0,0,18,0,0,0,19,0,0,0,1,0,0,0,2,0,0,0,24,0,0,0,20,0,0,0,3,0,0,0,4,0,0,0,5,0,0,0,25,0,0,0,21,0,0,0,6,0,0,0,0,0,0,0,100,101,98,117,103,68,114,97,119,87,111,114,108,100,0,0,115,121,110,99,104,114,111,110,105,122,101,77,111,116,105,111,110,83,116,97,116,101,115,0,115,116,101,112,83,105,109,117,108,97,116,105,111,110,0,0,105,110,116,101,114,110,97,108,83,105,110,103,108,101,83,116,101,112,83,105,109,117,108,97,116,105,111,110,0,0,0,0,117,112,100,97,116,101,65,99,116,105,111,110,115,0,0,0,117,112,100,97,116,101,65,99,116,105,118,97,116,105,111,110,83,116,97,116,101,0,0,0,115,111,108,118,101,67,111,110,115,116,114,97,105,110,116,115,0,0,0,0,0,0,0,0,99,97,108,99,117,108,97,116,101,83,105,109,117,108,97,116,105,111,110,73,115,108,97,110,100,115,0,0,0,0,0,0,0,0,0,0,0,0,0,0,99,114,101,97,116,101,80,114,101,100,105,99,116,105,118,101,67,111,110,116,97,99,116,115,0,0,0,0,0,0,0,0,114,101,108,101,97,115,101,32,112,114,101,100,105,99,116,105,118,101,32,99,111,110,116,97,99,116,32,109,97,110,105,102,111,108,100,115,0,0,0,0,112,114,101,100,105,99,116,105,118,101,32,99,111,110,118,101,120,83,119,101,101,112,84,101,115,116,0,0,0,0,0,0,105,110,116,101,103,114,97,116,101,84,114,97,110,115,102,111,114,109,115,0,0,0,0,0,67,67,68,32,109,111,116,105,111,110,32,99,108,97,109,112,105,110,103,0,0,0,0,0,97,112,112,108,121,32,115,112,101,99,117,108,97,116,105,118,101,32,99,111,110,116,97,99,116,32,114,101,115,116,105,116,117,116,105,111,110,0,0,0,112,114,101,100,105,99,116,85,110,99,111,110,115,116,114,97,105,110,116,77,111,116,105,111,110,0,0,0,0,0,0,0,98,116,68,121,110,97,109,105,99,115,87,111,114,108,100,70,108,111,97,116,68,97,116,97,0,0,0,0,0,0,0,0,50,51,98,116,68,105,115,99,114,101,116,101,68,121,110,97,109,105,99,115,87,111,114,108,100,0,0,0,0,0,0,0,49,53,98,116,68,121,110,97,109,105,99,115,87,111,114,108,100,0,0,0,0,0,0,0,0,83,0,0,184,8,0,0,32,33,0,0,0,0,0,0,0,83,0,0,152,8,0,0,208,8,0,0,0,0,0,0,0,0,0,0,48,9,0,0,26,0,0,0,27,0,0,0,7,0,0,0,3,0,0,0,51,52,98,116,67,108,111,115,101,115,116,78,111,116,77,101,67,111,110,118,101,120,82,101,115,117,108,116,67,97,108,108,98,97,99,107,0,0,0,0,0,83,0,0,8,9,0,0,240,3,0,0,0,0,0,0,0,0,0,0,176,9,0,0,28,0,0,0,29,0,0,0,1,0,0,0,0,0,0,0,50,55,73,110,112,108,97,99,101,83,111,108,118,101,114,73,115,108,97,110,100,67,97,108,108,98,97,99,107,0,0,0,78,50,53,98,116,83,105,109,117,108,97,116,105,111,110,73,115,108,97,110,100,77,97,110,97,103,101,114,49,52,73,115,108,97,110,100,67,97,108,108,98,97,99,107,69,0,0,0,216,82,0,0,120,9,0,0,0,83,0,0,88,9,0,0,168,9,0,0,0,0,0,0,0,0,0,0,24,10,0,0,1,0,0,0,30,0,0,0,31,0,0,0,1,0,0,0,22,0,0,0,23,0,0,0,1,0,0,0,1,0,0,0,4,0,0,0,7,0,0,0,4,0,0,0,32,0,0,0,50,51,98,116,71,101,110,101,114,105,99,54,68,111,102,67,111,110,115,116,114,97,105,110,116,0,0,0,0,0,0,0,0,83,0,0,248,9,0,0,96,1,0,0,0,0,0,0,98,116,71,101,110,101,114,105,99,54,68,111,102,67,111,110,115,116,114,97,105,110,116,68,97,116,97,0,0,0,0,0,0,0,0,0,168,10,0,0,1,0,0,0,33,0,0,0,31,0,0,0,1,0,0,0,22,0,0,0,24,0,0,0,1,0,0,0,1,0,0,0,4,0,0,0,8,0,0,0,5,0,0,0,32,0,0,0,3,0,0,0,0,0,0,0,50,57,98,116,71,101,110,101,114,105,99,54,68,111,102,83,112,114,105,110,103,67,111,110,115,116,114,97,105,110,116,0,0,83,0,0,136,10,0,0,24,10,0,0,0,0,0,0,98,116,71,101,110,101,114,105,99,54,68,111,102,83,112,114,105,110,103,67,111,110,115,116,114,97,105,110,116,68,97,116,97,0,0,0,0,0,0,0,0,0,0,0,56,11,0,0,1,0,0,0,34,0,0,0,35,0,0,0,1,0,0,0,25,0,0,0,26,0,0,0,1,0,0,0,2,0,0,0,5,0,0,0,9,0,0,0,6,0,0,0,0,0,0,0,50,51,98,116,80,111,105,110,116,50,80,111,105,110,116,67,111,110,115,116,114,97,105,110,116,0,0,0,0,0,0,0,0,83,0,0,24,11,0,0,96,1,0,0,0,0,0,0,98,116,80,111,105,110,116,50,80,111,105,110,116,67,111,110,115,116,114,97,105,110,116,70,108,111,97,116,68,97,116,97,0,0,0,0,0,0,0,0,98,116,84,121,112,101,100,67,111,110,115,116,114,97,105,110,116,70,108,111,97,116,68,97,116,97,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80,14,0,0,1,0,0,0,36,0,0,0,3,0,0,0,1,0,0,0,27,0,0,0,28,0,0,0,1,0,0,0,3,0,0,0,6,0,0,0,10,0,0,0,7,0,0,0,0,0,0,0,49,56,98,116,83,108,105,100,101,114,67,111,110,115,116,114,97,105,110,116,0,0,0,0,0,83,0,0,56,14,0,0,96,1,0,0,0,0,0,0,98,116,83,108,105,100,101,114,67,111,110,115,116,114,97,105,110,116,68,97,116,97,0,0,0,0,0,0,200,14,0,0,1,0,0,0,37,0,0,0,38,0,0,0,1,0,0,0,29,0,0,0,30,0,0,0,2,0,0,0,4,0,0,0,7,0,0,0,11,0,0,0,8,0,0,0,4,0,0,0,50,49,98,116,67,111,110,101,84,119,105,115,116,67,111,110,115,116,114,97,105,110,116,0,0,83,0,0,176,14,0,0,96,1,0,0,0,0,0,0,98,116,67,111,110,101,84,119,105,115,116,67,111,110,115,116,114,97,105,110,116,68,97,116,97,0,0,0,0,0,0,0,0,0,0,0,72,15,0,0,1,0,0,0,39,0,0,0,40,0,0,0,1,0,0,0,31,0,0,0,32,0,0,0,1,0,0,0,5,0,0,0,8,0,0,0,12,0,0,0,9,0,0,0,0,0,0,0,49,55,98,116,72,105,110,103,101,67,111,110,115,116,114,97,105,110,116,0,0,0,0,0,0,83,0,0,48,15,0,0,96,1,0,0,0,0,0,0,98,116,72,105,110,103,101,67,111,110,115,116,114,97,105,110,116,70,108,111,97,116,68,97,116,97,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96,16,0,0,41,0,0,0,42,0,0,0,5,0,0,0,1,0,0,0,6,0,0,0,43,0,0,0,13,0,0,0,5,0,0,0,1,0,0,0,1,0,0,0,2,0,0,0,1,0,0,0,2,0,0,0,0,0,0,0,115,111,108,118,101,71,114,111,117,112,67,97,99,104,101,70,114,105,101,110,100,108,121,83,101,116,117,112,0,0,0,0,115,111,108,118,101,71,114,111,117,112,67,97,99,104,101,70,114,105,101,110,100,108,121,73,116,101,114,97,116,105,111,110,115,0,0,0,0,0,0,0,115,111,108,118,101,71,114,111,117,112,0,0,0,0,0,0,51,53,98,116,83,101,113,117,101,110,116,105,97,108,73,109,112,117,108,115,101,67,111,110,115,116,114,97,105,110,116,83,111,108,118,101,114,0,0,0,49,56,98,116,67,111,110,115,116,114,97,105,110,116,83,111,108,118,101,114,0,0,0,0,216,82,0,0,64,16,0,0,0,83,0,0,24,16,0,0,88,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,19,0,0,44,0,0,0,45,0,0,0,1,0,0,0,33,0,0,0,7,0,0,0,8,0,0,0,6,0,0,0,0,0,0,0,49,54,98,116,82,97,121,99,97,115,116,86,101,104,105,99,108,101,0,0,0,0,0,0,49,55,98,116,65,99,116,105,111,110,73,110,116,101,114,102,97,99,101,0,0,0,0,0,216,82,0,0,32,19,0,0,0,83,0,0,8,19,0,0,56,19,0,0,0,0,0,0,0,0,0,0,136,19,0,0,46,0,0,0,47,0,0,0,2,0,0,0,0,0,0,0,50,53,98,116,68,101,102,97,117,108,116,86,101,104,105,99,108,101,82,97,121,99,97,115,116,101,114,0,0,0,0,0,0,83,0,0,104,19,0,0,0,2,0,0,0,0,0,0,0,0,0,0,112,20,0,0,48,0,0,0,49,0,0,0,2,0,0,0,34,0,0,0,35,0,0,0,3,0,0,0,36,0,0,0,37,0,0,0,38,0,0,0,4,0,0,0,14,0,0,0,50,0,0,0,15,0,0,0,39,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,51,48,98,116,75,105,110,101,109,97,116,105,99,67,104,97,114,97,99,116,101,114,67,111,110,116,114,111,108,108,101,114,0,0,0,0,0,0,0,0,51,48,98,116,67,104,97,114,97,99,116,101,114,67,111,110,116,114,111,108,108,101,114,73,110,116,101,114,102,97,99,101,0,0,0,0,0,0,0,0,0,83,0,0,56,20,0,0,56,19,0,0,0,0,0,0,0,83,0,0,16,20,0,0,96,20,0,0,0,0,0,0,0,0,0,0,200,20,0,0,26,0,0,0,51,0,0,0,2,0,0,0,9,0,0,0,52,51,98,116,75,105,110,101,109,97,116,105,99,67,108,111,115,101,115,116,78,111,116,77,101,67,111,110,118,101,120,82,101,115,117,108,116,67,97,108,108,98,97,99,107,0,0,0,0,83,0,0,152,20,0,0,240,3,0,0,0,0,0,0,10,215,163,60,0,0,0,0,98,116,67,111,108,108,105,115,105,111,110,79,98,106,101,99,116,70,108,111,97,116,68,97,116,97,0,0,0,0,0,0,49,55,98,116,67,111,108,108,105,115,105,111,110,79,98,106,101,99,116,0,0,0,0,0,216,82,0,0,0,21,0,0,0,0,0,0,144,21,0,0,8,0,0,0,52,0,0,0,53,0,0,0,3,0,0,0,16,0,0,0,10,0,0,0,40,0,0,0,7,0,0,0,7,0,0,0,0,0,0,0,0,0,0,0,192,21,0,0,8,0,0,0,54,0,0,0,55,0,0,0,3,0,0,0,16,0,0,0,10,0,0,0,40,0,0,0,8,0,0,0,8,0,0,0,0,0,0,0,49,51,98,116,71,104,111,115,116,79,98,106,101,99,116,0,0,83,0,0,128,21,0,0,24,21,0,0,0,0,0,0,50,52,98,116,80,97,105,114,67,97,99,104,105,110,103,71,104,111,115,116,79,98,106,101,99,116,0,0,0,0,0,0,0,83,0,0,160,21,0,0,144,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,22,0,0,56,0,0,0,57,0,0,0,3,0,0,0,11,0,0,0,41,0,0,0,42,0,0,0,12,0,0,0,13,0,0,0,9,0,0,0,17,0,0,0,9,0,0,0,18,0,0,0,19,0,0,0,20,0,0,0,10,0,0,0,43,0,0,0,50,49,98,116,67,111,108,108,105,115,105,111,110,68,105,115,112,97,116,99,104,101,114,0,0,83,0,0,32,22,0,0,160,67,0,0,0,0,0,0,0,0,0,0,160,22,0,0,58,0,0,0,59,0,0,0,11,0,0,0,0,0,0,0,50,51,98,116,67,111,108,108,105,115,105,111,110,80,97,105,114,67,97,108,108,98,97,99,107,0,0,0,0,0,0,0,49,55,98,116,79,118,101,114,108,97,112,67,97,108,108,98,97,99,107,0,0,0,0,0,216,82,0,0,128,22,0,0,0,83,0,0,96,22,0,0,152,22,0,0,0,0,0,0,0,0,0,0,32,23,0,0,60,0,0,0,61,0,0,0,21,0,0,0,22,0,0,0,14,0,0,0,23,0,0,0,51,49,98,116,68,101,102,97,117,108,116,67,111,108,108,105,115,105,111,110,67,111,110,102,105,103,117,114,97,116,105,111,110,0,0,0,0,0,0,0,50,52,98,116,67,111,108,108,105,115,105,111,110,67,111,110,102,105,103,117,114,97,116,105,111,110,0,0,0,0,0,0,216,82,0,0,248,22,0,0,0,83,0,0,208,22,0,0,24,23,0,0,0,0,0,0,0,0,0,0,168,23,0,0,62,0,0,0,63,0,0,0,4,0,0,0,0,0,0,0,78,51,49,98,116,67,111,110,118,101,120,80,108,97,110,101,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,49,48,67,114,101,97,116,101,70,117,110,99,69,0,51,48,98,116,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,67,114,101,97,116,101,70,117,110,99,0,0,0,0,0,0,0,0,216,82,0,0,120,23,0,0,0,83,0,0,72,23,0,0,160,23,0,0,0,0,0,0,0,0,0,0,0,24,0,0,62,0,0,0,64,0,0,0,5,0,0,0,0,0,0,0,78,50,54,98,116,66,111,120,66,111,120,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,49,48,67,114,101,97,116,101,70,117,110,99,69,0,0,0,0,0,0,0,83,0,0,208,23,0,0,160,23,0,0,0,0,0,0,0,0,0,0,96,24,0,0,62,0,0,0,65,0,0,0,6,0,0,0,0,0,0,0,78,51,52,98,116,83,112,104,101,114,101,84,114,105,97,110,103,108,101,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,49,48,67,114,101,97,116,101,70,117,110,99,69,0,0,0,0,0,0,0,83,0,0,40,24,0,0,160,23,0,0,0,0,0,0,0,0,0,0,192,24,0,0,62,0,0,0,66,0,0,0,7,0,0,0,0,0,0,0,78,51,50,98,116,83,112,104,101,114,101,83,112,104,101,114,101,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,49,48,67,114,101,97,116,101,70,117,110,99,69,0,0,0,0,0,0,0,0,0,83,0,0,136,24,0,0,160,23,0,0,0,0,0,0,0,0,0,0,16,25,0,0,62,0,0,0,67,0,0,0,8,0,0,0,0,0,0,0,78,49,54,98,116,69,109,112,116,121,65,108,103,111,114,105,116,104,109,49,48,67,114,101,97,116,101,70,117,110,99,69,0,0,0,0,0,0,0,0,0,83,0,0,232,24,0,0,160,23,0,0,0,0,0,0,0,0,0,0,112,25,0,0,62,0,0,0,68,0,0,0,9,0,0,0,0,0,0,0,78,50,56,98,116,67,111,109,112,111,117,110,100,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,49,55,83,119,97,112,112,101,100,67,114,101,97,116,101,70,117,110,99,69,0,0,0,0,0,0,83,0,0,56,25,0,0,160,23,0,0,0,0,0,0,0,0,0,0,208,25,0,0,62,0,0,0,69,0,0,0,10,0,0,0,0,0,0,0,78,51,54,98,116,67,111,109,112,111,117,110,100,67,111,109,112,111,117,110,100,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,49,48,67,114,101,97,116,101,70,117,110,99,69,0,0,0,0,0,83,0,0,152,25,0,0,160,23,0,0,0,0,0,0,0,0,0,0,40,26,0,0,62,0,0,0,70,0,0,0,11,0,0,0,0,0,0,0,78,50,56,98,116,67,111,109,112,111,117,110,100,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,49,48,67,114,101,97,116,101,70,117,110,99,69,0,0,0,0,0,83,0,0,248,25,0,0,160,23,0,0,0,0,0,0,0,0,0,0,144,26,0,0,62,0,0,0,71,0,0,0,12,0,0,0,0,0,0,0,78,51,51,98,116,67,111,110,118,101,120,67,111,110,99,97,118,101,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,49,55,83,119,97,112,112,101,100,67,114,101,97,116,101,70,117,110,99,69,0,0,0,0,0,0,0,0,0,83,0,0,80,26,0,0,160,23,0,0,0,0,0,0,0,0,0,0,240,26,0,0,62,0,0,0,72,0,0,0,13,0,0,0,0,0,0,0,78,51,51,98,116,67,111,110,118,101,120,67,111,110,99,97,118,101,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,49,48,67,114,101,97,116,101,70,117,110,99,69,0,0,0,0,0,0,0,0,83,0,0,184,26,0,0,160,23,0,0,0,0,0,0,0,0,0,0,104,27,0,0,73,0,0,0,74,0,0,0,9,0,0,0,44,0,0,0,105,115,108,97,110,100,85,110,105,111,110,70,105,110,100,65,110,100,81,117,105,99,107,83,111,114,116,0,0,0,0,0,112,114,111,99,101,115,115,73,115,108,97,110,100,115,0,0,50,53,98,116,83,105,109,117,108,97,116,105,111,110,73,115,108,97,110,100,77,97,110,97,103,101,114,0,0,0,0,0,216,82,0,0,72,27,0,0,0,0,0,0,216,27,0,0,75,0,0,0,76,0,0,0,1,0,0,0,1,0,0,0,45,0,0,0,0,0,0,0,51,49,98,116,67,111,110,118,101,120,80,108,97,110,101,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,0,0,0,0,0,0,0,50,48,98,116,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,0,0,216,82,0,0,184,27,0,0,0,83,0,0,144,27,0,0,208,27,0,0,0,0,0,0,0,0,0,0,120,28,0,0,77,0,0,0,78,0,0,0,2,0,0,0,2,0,0,0,46,0,0,0,0,0,0,0,0,0,0,0,64,28,0,0,79,0,0,0,80,0,0,0,10,0,0,0,0,0,0,0,50,52,98,116,67,111,110,118,101,120,84,114,105,97,110,103,108,101,67,97,108,108,98,97,99,107,0,0,0,0,0,0,0,83,0,0,32,28,0,0,208,54,0,0,0,0,0,0,51,51,98,116,67,111,110,118,101,120,67,111,110,99,97,118,101,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,0,0,0,0,0,0,83,0,0,80,28,0,0,120,76,0,0,0,0,0,0,0,0,0,0,64,29,0,0,81,0,0,0,82,0,0,0,11,0,0,0,0,0,0,0,90,78,51,51,98,116,67,111,110,118,101,120,67,111,110,99,97,118,101,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,50,49,99,97,108,99,117,108,97,116,101,84,105,109,101,79,102,73,109,112,97,99,116,69,80,49,55,98,116,67,111,108,108,105,115,105,111,110,79,98,106,101,99,116,83,49,95,82,75,49,54,98,116,68,105,115,112,97,116,99,104,101,114,73,110,102,111,80,49,54,98,116,77,97,110,105,102,111,108,100,82,101,115,117,108,116,69,51,49,76,111,99,97,108,84,114,105,97,110,103,108,101,83,112,104,101,114,101,67,97,115,116,67,97,108,108,98,97,99,107,0,0,0,0,83,0,0,160,28,0,0,208,54,0,0,0,0,0,0,0,0,0,0,144,29,0,0,9,0,0,0,47,0,0,0,10,0,0,0,83,0,0,0,84,0,0,0,0,0,0,0,78,49,50,98,116,67,111,110,118,101,120,67,97,115,116,49,48,67,97,115,116,82,101,115,117,108,116,69,0,0,0,0,216,82,0,0,112,29,0,0,0,0,0,0,56,30,0,0,85,0,0,0,86,0,0,0,12,0,0,0,11,0,0,0,1,0,0,0,1,0,0,0,48,0,0,0,24,0,0,0,1,0,0,0,25,0,0,0,49,0,0,0,10,0,0,0,2,0,0,0,26,0,0,0,15,0,0,0,50,0,0,0,12,0,0,0,13,0,0,0,3,0,0,0,13,0,0,0,14,0,0,0,27,0,0,0,14,0,0,0,12,0,0,0,28,0,0,0,29,0,0,0,15,0,0,0,15,0,0,0,30,0,0,0,16,0,0,0,1,0,0,0,17,0,0,0,49,53,98,116,84,114,105,97,110,103,108,101,83,104,97,112,101,0,0,0,0,0,0,0,0,83,0,0,32,30,0,0,32,53,0,0,0,0,0,0,98,116,67,111,110,118,101,120,73,110,116,101,114,110,97,108,83,104,97,112,101,68,97,116,97,0,0,0,0,0,0,0,84,114,105,97,110,103,108,101,0,0,0,0,0,0,0,0,0,0,0,0,184,30,0,0,87,0,0,0,88,0,0,0,4,0,0,0,3,0,0,0,51,0,0,0,0,0,0,0,50,54,98,116,66,111,120,66,111,120,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,0,0,0,0,0,83,0,0,152,30,0,0,120,76,0,0,0,0,0,0,0,0,0,0,56,31,0,0,89,0,0,0,90,0,0,0,16,0,0,0,17,0,0,0,3,0,0,0,0,0,0,0,49,54,98,116,77,97,110,105,102,111,108,100,82,101,115,117,108,116,0,0,0,0,0,0,78,51,54,98,116,68,105,115,99,114,101,116,101,67,111,108,108,105,115,105,111,110,68,101,116,101,99,116,111,114,73,110,116,101,114,102,97,99,101,54,82,101,115,117,108,116,69,0,216,82,0,0,0,31,0,0,0,83,0,0,232,30,0,0,48,31,0,0,0,0,0,0,0,0,0,0,32,33,0,0,91,0,0,0,92,0,0,0,18,0,0,0,19,0,0,0,5,0,0,0,3,0,0,0,93,0,0,0,1,0,0,0,2,0,0,0,18,0,0,0,52,0,0,0,21,0,0,0,53,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,79,118,101,114,102,108,111,119,32,105,110,32,65,65,66,66,44,32,111,98,106,101,99,116,32,114,101,109,111,118,101,100,32,102,114,111,109,32,115,105,109,117,108,97,116,105,111,110,0,0,0,0,0,0,0,0,73,102,32,121,111,117,32,99,97,110,32,114,101,112,114,111,100,117,99,101,32,116,104,105,115,44,32,112,108,101,97,115,101,32,101,109,97,105,108,32,98,117,103,115,64,99,111,110,116,105,110,117,111,117,115,112,104,121,115,105,99,115,46,99,111,109,10,0,0,0,0,0,80,108,101,97,115,101,32,105,110,99,108,117,100,101,32,97,98,111,118,101,32,105,110,102,111,114,109,97,116,105,111,110,44,32,121,111,117,114,32,80,108,97,116,102,111,114,109,44,32,118,101,114,115,105,111,110,32,111,102,32,79,83,46,10,0,0,0,0,0,0,0,0,84,104,97,110,107,115,46,10,0,0,0,0,0,0,0,0,117,112,100,97,116,101,65,97,98,98,115,0,0,0,0,0,99,97,108,99,117,108,97,116,101,79,118,101,114,108,97,112,112,105,110,103,80,97,105,114,115,0,0,0,0,0,0,0,112,101,114,102,111,114,109,68,105,115,99,114,101,116,101,67,111,108,108,105,115,105,111,110,68,101,116,101,99,116,105,111,110,0,0,0,0,0,0,0,100,105,115,112,97,116,99,104,65,108,108,67,111,108,108,105,115,105,111,110,80,97,105,114,115,0,0,0,0,0,0,0,99,111,110,118,101,120,83,119,101,101,112,67,111,109,112,111,117,110,100,0,0,0,0,0,99,111,110,118,101,120,83,119,101,101,112,84,101,115,116,0,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,0,0,0,0,0,0,216,82,0,0,8,33,0,0,0,0,0,0,112,33,0,0,94,0,0,0,95,0,0,0,19,0,0,0,20,0,0,0,252,255,255,255,112,33,0,0,96,0,0,0,97,0,0,0,21,0,0,0,0,0,0,0,49,55,68,101,98,117,103,68,114,97,119,99,97,108,108,98,97,99,107,0,0,0,0,0,96,83,0,0,88,33,0,0,0,0,0,0,2,0,0,0,208,54,0,0,2,0,0,0,0,55,0,0,2,4,0,0,0,0,0,0,208,33,0,0,89,0,0,0,98,0,0,0,16,0,0,0,17,0,0,0,4,0,0,0,0,0,0,0,50,51,98,116,66,114,105,100,103,101,100,77,97,110,105,102,111,108,100,82,101,115,117,108,116,0,0,0,0,0,0,0,0,83,0,0,176,33,0,0,56,31,0,0,0,0,0,0,50,52,98,116,66,114,111,97,100,112,104,97,115,101,65,97,98,98,67,97,108,108,98,97,99,107,0,0,0,0,0,0,216,82,0,0,224,33,0,0,0,0,0,0,104,34,0,0,99,0,0,0,100,0,0,0,13,0,0,0,0,0,0,0,50,49,98,116,83,105,110,103,108,101,83,119,101,101,112,67,97,108,108,98,97,99,107,0,50,51,98,116,66,114,111,97,100,112,104,97,115,101,82,97,121,67,97,108,108,98,97,99,107,0,0,0,0,0,0,0,0,83,0,0,56,34,0,0,0,34,0,0,0,0,0,0,0,83,0,0,32,34,0,0,88,34,0,0,0,0,0,0,0,0,0,0,168,34,0,0,99,0,0,0,101,0,0,0,14,0,0,0,0,0,0,0,49,57,98,116,83,105,110,103,108,101,82,97,121,67,97,108,108,98,97,99,107,0,0,0,0,83,0,0,144,34,0,0,88,34,0,0,0,0,0,0,0,0,0,0,112,35,0,0,26,0,0,0,102,0,0,0,15,0,0,0,10,0,0,0,90,78,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,50,53,111,98,106,101,99,116,81,117,101,114,121,83,105,110,103,108,101,73,110,116,101,114,110,97,108,69,80,75,49,51,98,116,67,111,110,118,101,120,83,104,97,112,101,82,75,49,49,98,116,84,114,97,110,115,102,111,114,109,83,53,95,80,75,50,52,98,116,67,111,108,108,105,115,105,111,110,79,98,106,101,99,116,87,114,97,112,112,101,114,82,78,83,95,50,48,67,111,110,118,101,120,82,101,115,117,108,116,67,97,108,108,98,97,99,107,69,102,69,49,52,76,111,99,97,108,73,110,102,111,65,100,100,101,114,0,0,0,0,0,83,0,0,208,34,0,0,232,3,0,0,0,0,0,0,0,0,0,0,80,36,0,0,81,0,0,0,103,0,0,0,22,0,0,0,1,0,0,0,90,78,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,50,53,111,98,106,101,99,116,81,117,101,114,121,83,105,110,103,108,101,73,110,116,101,114,110,97,108,69,80,75,49,51,98,116,67,111,110,118,101,120,83,104,97,112,101,82,75,49,49,98,116,84,114,97,110,115,102,111,114,109,83,53,95,80,75,50,52,98,116,67,111,108,108,105,115,105,111,110,79,98,106,101,99,116,87,114,97,112,112,101,114,82,78,83,95,50,48,67,111,110,118,101,120,82,101,115,117,108,116,67,97,108,108,98,97,99,107,69,102,69,51,50,66,114,105,100,103,101,84,114,105,97,110,103,108,101,67,111,110,118,101,120,99,97,115,116,67,97,108,108,98,97,99,107,95,48,0,0,0,0,0,0,0,0,0,83,0,0,152,35,0,0,192,68,0,0,0,0,0,0,0,0,0,0,40,37,0,0,81,0,0,0,104,0,0,0,22,0,0,0,2,0,0,0,90,78,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,50,53,111,98,106,101,99,116,81,117,101,114,121,83,105,110,103,108,101,73,110,116,101,114,110,97,108,69,80,75,49,51,98,116,67,111,110,118,101,120,83,104,97,112,101,82,75,49,49,98,116,84,114,97,110,115,102,111,114,109,83,53,95,80,75,50,52,98,116,67,111,108,108,105,115,105,111,110,79,98,106,101,99,116,87,114,97,112,112,101,114,82,78,83,95,50,48,67,111,110,118,101,120,82,101,115,117,108,116,67,97,108,108,98,97,99,107,69,102,69,51,50,66,114,105,100,103,101,84,114,105,97,110,103,108,101,67,111,110,118,101,120,99,97,115,116,67,97,108,108,98,97,99,107,0,0,0,83,0,0,120,36,0,0,192,68,0,0,0,0,0,0,0,0,0,0,216,37,0,0,105,0,0,0,106,0,0,0,16,0,0,0,11,0,0,0,90,78,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,50,49,114,97,121,84,101,115,116,83,105,110,103,108,101,73,110,116,101,114,110,97,108,69,82,75,49,49,98,116,84,114,97,110,115,102,111,114,109,83,50,95,80,75,50,52,98,116,67,111,108,108,105,115,105,111,110,79,98,106,101,99,116,87,114,97,112,112,101,114,82,78,83,95,49,55,82,97,121,82,101,115,117,108,116,67,97,108,108,98,97,99,107,69,69,49,53,76,111,99,97,108,73,110,102,111,65,100,100,101,114,50,0,0,0,0,0,83,0,0,80,37,0,0,120,2,0,0,0,0,0,0,0,0,0,0,176,38,0,0,107,0,0,0,108,0,0,0,18,0,0,0,54,0,0,0,5,0,0,0,17,0,0,0,18,0,0,0,0,0,0,0,90,78,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,50,49,114,97,121,84,101,115,116,83,105,110,103,108,101,73,110,116,101,114,110,97,108,69,82,75,49,49,98,116,84,114,97,110,115,102,111,114,109,83,50,95,80,75,50,52,98,116,67,111,108,108,105,115,105,111,110,79,98,106,101,99,116,87,114,97,112,112,101,114,82,78,83,95,49,55,82,97,121,82,101,115,117,108,116,67,97,108,108,98,97,99,107,69,69,57,82,97,121,84,101,115,116,101,114,0,0,0,78,54,98,116,68,98,118,116,56,73,67,111,108,108,105,100,101,69,0,0,0,0,0,0,216,82,0,0,144,38,0,0,0,83,0,0,16,38,0,0,168,38,0,0,0,0,0,0,0,0,0,0,112,39,0,0,81,0,0,0,109,0,0,0,23,0,0,0,1,0,0,0,90,78,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,50,49,114,97,121,84,101,115,116,83,105,110,103,108,101,73,110,116,101,114,110,97,108,69,82,75,49,49,98,116,84,114,97,110,115,102,111,114,109,83,50,95,80,75,50,52,98,116,67,111,108,108,105,115,105,111,110,79,98,106,101,99,116,87,114,97,112,112,101,114,82,78,83,95,49,55,82,97,121,82,101,115,117,108,116,67,97,108,108,98,97,99,107,69,69,50,57,66,114,105,100,103,101,84,114,105,97,110,103,108,101,82,97,121,99,97,115,116,67,97,108,108,98,97,99,107,95,48,0,0,0,0,0,83,0,0,216,38,0,0,144,68,0,0,0,0,0,0,0,0,0,0,48,40,0,0,81,0,0,0,110,0,0,0,23,0,0,0,2,0,0,0,90,78,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,50,49,114,97,121,84,101,115,116,83,105,110,103,108,101,73,110,116,101,114,110,97,108,69,82,75,49,49,98,116,84,114,97,110,115,102,111,114,109,83,50,95,80,75,50,52,98,116,67,111,108,108,105,115,105,111,110,79,98,106,101,99,116,87,114,97,112,112,101,114,82,78,83,95,49,55,82,97,121,82,101,115,117,108,116,67,97,108,108,98,97,99],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE);allocate([107,69,69,50,57,66,114,105,100,103,101,84,114,105,97,110,103,108,101,82,97,121,99,97,115,116,67,97,108,108,98,97,99,107,0,0,0,0,0,0,0,83,0,0,152,39,0,0,144,68,0,0,0,0,0,0,0,0,0,0,136,40,0,0,111,0,0,0,112,0,0,0,5,0,0,0,4,0,0,0,55,0,0,0,0,0,0,0,51,52,98,116,83,112,104,101,114,101,84,114,105,97,110,103,108,101,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,0,0,0,0,0,83,0,0,96,40,0,0,120,76,0,0,0,0,0,0,0,0,0,0,248,40,0,0,113,0,0,0,114,0,0,0,14,0,0,0,0,0,0,0,0,0,0,0,40,41,0,0,115,0,0,0,116,0,0,0,6,0,0,0,5,0,0,0,56,0,0,0,0,0,0,0,78,50,51,98,116,67,111,110,118,101,120,67,111,110,118,101,120,65,108,103,111,114,105,116,104,109,49,48,67,114,101,97,116,101,70,117,110,99,69,0,0,83,0,0,208,40,0,0,160,23,0,0,0,0,0,0,50,51,98,116,67,111,110,118,101,120,67,111,110,118,101,120,65,108,103,111,114,105,116,104,109,0,0,0,0,0,0,0,0,83,0,0,8,41,0,0,120,76,0,0,0,0,0,0,0,0,0,0,232,41,0,0,89,0,0,0,117,0,0,0,19,0,0,0,20,0,0,0,5,0,0,0,0,0,0,0,90,78,50,51,98,116,67,111,110,118,101,120,67,111,110,118,101,120,65,108,103,111,114,105,116,104,109,49,54,112,114,111,99,101,115,115,67,111,108,108,105,115,105,111,110,69,80,75,50,52,98,116,67,111,108,108,105,115,105,111,110,79,98,106,101,99,116,87,114,97,112,112,101,114,83,50,95,82,75,49,54,98,116,68,105,115,112,97,116,99,104,101,114,73,110,102,111,80,49,54,98,116,77,97,110,105,102,111,108,100,82,101,115,117,108,116,69,50,49,98,116,87,105,116,104,111,117,116,77,97,114,103,105,110,82,101,115,117,108,116,0,0,0,0,0,83,0,0,88,41,0,0,48,31,0,0,0,0,0,0,0,0,0,0,56,42,0,0,89,0,0,0,118,0,0,0,16,0,0,0,17,0,0,0,6,0,0,0,0,0,0,0,50,52,98,116,80,101,114,116,117,114,98,101,100,67,111,110,116,97,99,116,82,101,115,117,108,116,0,0,0,0,0,0,0,83,0,0,24,42,0,0,56,31,0,0,0,0,0,0,0,0,0,0,240,42,0,0,89,0,0,0,119,0,0,0,21,0,0,0,22,0,0,0,7,0,0,0,0,0,0,0,90,78,50,51,98,116,67,111,110,118,101,120,67,111,110,118,101,120,65,108,103,111,114,105,116,104,109,49,54,112,114,111,99,101,115,115,67,111,108,108,105,115,105,111,110,69,80,75,50,52,98,116,67,111,108,108,105,115,105,111,110,79,98,106,101,99,116,87,114,97,112,112,101,114,83,50,95,82,75,49,54,98,116,68,105,115,112,97,116,99,104,101,114,73,110,102,111,80,49,54,98,116,77,97,110,105,102,111,108,100,82,101,115,117,108,116,69,49,51,98,116,68,117,109,109,121,82,101,115,117,108,116,0,0,0,0,0,83,0,0,104,42,0,0,48,31,0,0,0,0,0,0,0,0,0,0,64,43,0,0,120,0,0,0,121,0,0,0,7,0,0,0,6,0,0,0,57,0,0,0,0,0,0,0,50,56,98,116,67,111,109,112,111,117,110,100,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,0,0,0,83,0,0,32,43,0,0,120,76,0,0,0,0,0,0,0,0,0,0,152,43,0,0,107,0,0,0,122,0,0,0,18,0,0,0,58,0,0,0,5,0,0,0,17,0,0,0,18,0,0,0,0,0,0,0,50,50,98,116,67,111,109,112,111,117,110,100,76,101,97,102,67,97,108,108,98,97,99,107,0,0,0,0,0,0,0,0,0,83,0,0,120,43,0,0,168,38,0,0,0,0,0,0,0,0,0,0,240,43,0,0,123,0,0,0,124,0,0,0,8,0,0,0,7,0,0,0,59,0,0,0,0,0,0,0,51,54,98,116,67,111,109,112,111,117,110,100,67,111,109,112,111,117,110,100,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,0,0,0,83,0,0,200,43,0,0,120,76,0,0,0,0,0,0,0,0,0,0,80,44,0,0,107,0,0,0,125,0,0,0,23,0,0,0,60,0,0,0,5,0,0,0,17,0,0,0,18,0,0,0,0,0,0,0,51,48,98,116,67,111,109,112,111,117,110,100,67,111,109,112,111,117,110,100,76,101,97,102,67,97,108,108,98,97,99,107,0,0,0,0,0,0,0,0,0,83,0,0,40,44,0,0,168,38,0,0,0,0,0,0,0,0,0,0,0,45,0,0,126,0,0,0,127,0,0,0,24,0,0,0,11,0,0,0,1,0,0,0,1,0,0,0,61,0,0,0,31,0,0,0,2,0,0,0,32,0,0,0,49,0,0,0,11,0,0,0,3,0,0,0,33,0,0,0,16,0,0,0,50,0,0,0,62,0,0,0,128,0,0,0,98,116,67,111,109,112,111,117,110,100,83,104,97,112,101,67,104,105,108,100,68,97,116,97,0,0,0,0,0,0,0,0,98,116,67,111,109,112,111,117,110,100,83,104,97,112,101,68,97,116,97,0,0,0,0,0,49,53,98,116,67,111,109,112,111,117,110,100,83,104,97,112,101,0,0,0,0,0,0,0,0,83,0,0,232,44,0,0,152,53,0,0,0,0,0,0,67,111,109,112,111,117,110,100,0,0,0,0,0,0,0,0,0,0,0,0,104,46,0,0,129,0,0,0,130,0,0,0,25,0,0,0,11,0,0,0,1,0,0,0,1,0,0,0,63,0,0,0,24,0,0,0,3,0,0,0,34,0,0,0,64,0,0,0,10,0,0,0,2,0,0,0,35,0,0,0,17,0,0,0,50,0,0,0,24,0,0,0,25,0,0,0,3,0,0,0,26,0,0,0,14,0,0,0,36,0,0,0,26,0,0,0,0,0,0,0,0,0,0,0,136,46,0,0,129,0,0,0,131,0,0,0,25,0,0,0,11,0,0,0,1,0,0,0,1,0,0,0,63,0,0,0,24,0,0,0,3,0,0,0,37,0,0,0,65,0,0,0,10,0,0,0,2,0,0,0,35,0,0,0,17,0,0,0,50,0,0,0,24,0,0,0,25,0,0,0,3,0,0,0,26,0,0,0,14,0,0,0,36,0,0,0,26,0,0,0,0,0,0,0,0,0,0,0,168,46,0,0,129,0,0,0,132,0,0,0,25,0,0,0,11,0,0,0,1,0,0,0,1,0,0,0,63,0,0,0,24,0,0,0,3,0,0,0,38,0,0,0,66,0,0,0,10,0,0,0,2,0,0,0,35,0,0,0,17,0,0,0,50,0,0,0,24,0,0,0,25,0,0,0,3,0,0,0,26,0,0,0,14,0,0,0,36,0,0,0,26,0,0,0,0,0,0,0,49,49,98,116,67,111,110,101,83,104,97,112,101,0,0,0,0,83,0,0,88,46,0,0,216,53,0,0,0,0,0,0,49,50,98,116,67,111,110,101,83,104,97,112,101,90,0,0,0,83,0,0,120,46,0,0,104,46,0,0,0,0,0,0,49,50,98,116,67,111,110,101,83,104,97,112,101,88,0,0,0,83,0,0,152,46,0,0,104,46,0,0,0,0,0,0,67,111,110,101,88,0,0,0,67,111,110,101,90,0,0,0,98,116,67,111,110,101,83,104,97,112,101,68,97,116,97,0,67,111,110,101,0,0,0,0,0,0,0,0,88,47,0,0,129,0,0,0,133,0,0,0,27,0,0,0,11,0,0,0,1,0,0,0,1,0,0,0,48,0,0,0,24,0,0,0,4,0,0,0,39,0,0,0,49,0,0,0,12,0,0,0,4,0,0,0,26,0,0,0,15,0,0,0,50,0,0,0,27,0,0,0,28,0,0,0,3,0,0,0,28,0,0,0,14,0,0,0,36,0,0,0,26,0,0,0,0,0,0,0,49,51,98,116,83,112,104,101,114,101,83,104,97,112,101,0,0,83,0,0,72,47,0,0,216,53,0,0,0,0,0,0,83,80,72,69,82,69,0,0,0,0,0,0,8,48,0,0,134,0,0,0,135,0,0,0,29,0,0,0,11,0,0,0,1,0,0,0,1,0,0,0,67,0,0,0,40,0,0,0,5,0,0,0,41,0,0,0,49,0,0,0,13,0,0,0,5,0,0,0,42,0,0,0,18,0,0,0,50,0,0,0,30,0,0,0,29,0,0,0,30,0,0,0,68,0,0,0,69,0,0,0,0,0,0,0,98,116,84,114,105,97,110,103,108,101,77,101,115,104,83,104,97,112,101,68,97,116,97,0,50,50,98,116,66,118,104,84,114,105,97,110,103,108,101,77,101,115,104,83,104,97,112,101,0,0,0,0,0,0,0,0,0,83,0,0,232,47,0,0,128,50,0,0,0,0,0,0,66,86,72,84,82,73,65,78,71,76,69,77,69,83,72,0,0,0,0,0,208,48,0,0,136,0,0,0,137,0,0,0,31,0,0,0,0,0,0,0,90,78,75,50,50,98,116,66,118,104,84,114,105,97,110,103,108,101,77,101,115,104,83,104,97,112,101,49,57,112,114,111,99,101,115,115,65,108,108,84,114,105,97,110,103,108,101,115,69,80,49,56,98,116,84,114,105,97,110,103,108,101,67,97,108,108,98,97,99,107,82,75,57,98,116,86,101,99,116,111,114,51,83,52,95,69,50,49,77,121,78,111,100,101,79,118,101,114,108,97,112,67,97,108,108,98,97,99,107,0,0,0,50,49,98,116,78,111,100,101,79,118,101,114,108,97,112,67,97,108,108,98,97,99,107,0,216,82,0,0,176,48,0,0,0,83,0,0,64,48,0,0,200,48,0,0,0,0,0,0,0,0,0,0,112,49,0,0,136,0,0,0,138,0,0,0,32,0,0,0,0,0,0,0,90,78,50,50,98,116,66,118,104,84,114,105,97,110,103,108,101,77,101,115,104,83,104,97,112,101,49,55,112,101,114,102,111,114,109,67,111,110,118,101,120,99,97,115,116,69,80,49,56,98,116,84,114,105,97,110,103,108,101,67,97,108,108,98,97,99,107,82,75,57,98,116,86,101,99,116,111,114,51,83,52,95,83,52,95,83,52,95,69,50,49,77,121,78,111,100,101,79,118,101,114,108,97,112,67,97,108,108,98,97,99,107,0,0,0,0,0,0,0,0,0,83,0,0,248,48,0,0,200,48,0,0,0,0,0,0,0,0,0,0,0,50,0,0,136,0,0,0,139,0,0,0,33,0,0,0,0,0,0,0,90,78,50,50,98,116,66,118,104,84,114,105,97,110,103,108,101,77,101,115,104,83,104,97,112,101,49,52,112,101,114,102,111,114,109,82,97,121,99,97,115,116,69,80,49,56,98,116,84,114,105,97,110,103,108,101,67,97,108,108,98,97,99,107,82,75,57,98,116,86,101,99,116,111,114,51,83,52,95,69,50,49,77,121,78,111,100,101,79,118,101,114,108,97,112,67,97,108,108,98,97,99,107,0,0,83,0,0,152,49,0,0,200,48,0,0,0,0,0,0,0,0,0,0,128,50,0,0,140,0,0,0,141,0,0,0,29,0,0,0,11,0,0,0,1,0,0,0,1,0,0,0,70,0,0,0,40,0,0,0,5,0,0,0,43,0,0,0,49,0,0,0,13,0,0,0,5,0,0,0,44,0,0,0,19,0,0,0,50,0,0,0,31,0,0,0,29,0,0,0,30,0,0,0,0,0,0,0,49,57,98,116,84,114,105,97,110,103,108,101,77,101,115,104,83,104,97,112,101,0,0,0,0,83,0,0,104,50,0,0,40,58,0,0,0,0,0,0,84,82,73,65,78,71,76,69,77,69,83,72,0,0,0,0,0,0,0,0,208,50,0,0,81,0,0,0,142,0,0,0,32,0,0,0,0,0,0,0,50,49,83,117,112,112,111,114,116,86,101,114,116,101,120,67,97,108,108,98,97,99,107,0,0,83,0,0,184,50,0,0,208,54,0,0,0,0,0,0,0,0,0,0,96,51,0,0,143,0,0,0,144,0,0,0,33,0,0,0,0,0,0,0,90,78,75,49,57,98,116,84,114,105,97,110,103,108,101,77,101,115,104,83,104,97,112,101,49,57,112,114,111,99,101,115,115,65,108,108,84,114,105,97,110,103,108,101,115,69,80,49,56,98,116,84,114,105,97,110,103,108,101,67,97,108,108,98,97,99,107,82,75,57,98,116,86,101,99,116,111,114,51,83,52,95,69,49,54,70,105,108,116,101,114,101,100,67,97,108,108,98,97,99,107,0,0,0,0,83,0,0,248,50,0,0,0,55,0,0,0,0,0,0,0,0,0,0,216,51,0,0,145,0,0,0,146,0,0,0,34,0,0,0,11,0,0,0,1,0,0,0,1,0,0,0,71,0,0,0,45,0,0,0,6,0,0,0,46,0,0,0,49,0,0,0,13,0,0,0,5,0,0,0,47,0,0,0,20,0,0,0,50,0,0,0,35,0,0,0,0,0,0,0,49,56,98,116,83,116,97,116,105,99,80,108,97,110,101,83,104,97,112,101,0,0,0,0,0,83,0,0,192,51,0,0,40,58,0,0,0,0,0,0,98,116,83,116,97,116,105,99,80,108,97,110,101,83,104,97,112,101,68,97,116,97,0,0,83,84,65,84,73,67,80,76,65,78,69,0,0,0,0,0,0,0,0,0,32,53,0,0,85,0,0,0,147,0,0,0,25,0,0,0,11,0,0,0,1,0,0,0,1,0,0,0,48,0,0,0,24,0,0,0,7,0,0,0,1,0,0,0,49,0,0,0,10,0,0,0,2,0,0,0,26,0,0,0,15,0,0,0,50,0,0,0,12,0,0,0,34,0,0,0,3,0,0,0,36,0,0,0,14,0,0,0,36,0,0,0,26,0,0,0,12,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,50,51,98,116,80,111,108,121,104,101,100,114,97,108,67,111,110,118,101,120,83,104,97,112,101,0,0,0,0,0,0,0,0,83,0,0,0,53,0,0,216,53,0,0,0,0,0,0,51,52,98,116,80,111,108,121,104,101,100,114,97,108,67,111,110,118,101,120,65,97,98,98,67,97,99,104,105,110,103,83,104,97,112,101,0,0,0,0,0,83,0,0,48,53,0,0,32,53,0,0,0,0,0,0,98,116,67,111,108,108,105,115,105,111,110,83,104,97,112,101,68,97,116,97,0,0,0,0,49,54,98,116,67,111,108,108,105,115,105,111,110,83,104,97,112,101,0,0,0,0,0,0,216,82,0,0,128,53,0,0,49,51,98,116,67,111,110,118,101,120,83,104,97,112,101,0,0,83,0,0,160,53,0,0,152,53,0,0,0,0,0,0,50,49,98,116,67,111,110,118,101,120,73,110,116,101,114,110,97,108,83,104,97,112,101,0,0,83,0,0,192,53,0,0,176,53,0,0,0,0,0,0,0,0,0,0,160,54,0,0,148,0,0,0,149,0,0,0,37,0,0,0,11,0,0,0,1,0,0,0,1,0,0,0,72,0,0,0,24,0,0,0,7,0,0,0,48,0,0,0,49,0,0,0,10,0,0,0,2,0,0,0,49,0,0,0,21,0,0,0,50,0,0,0,35,0,0,0,36,0,0,0,3,0,0,0,38,0,0,0,14,0,0,0,36,0,0,0,26,0,0,0,12,0,0,0,50,0,0,0,51,0,0,0,39,0,0,0,37,0,0,0,52,0,0,0,40,0,0,0,2,0,0,0,1,0,0,0,98,116,67,111,110,118,101,120,72,117,108,108,83,104,97,112,101,68,97,116,97,0,0,0,49,55,98,116,67,111,110,118,101,120,72,117,108,108,83,104,97,112,101,0,0,0,0,0,0,83,0,0,136,54,0,0,88,53,0,0,0,0,0,0,67,111,110,118,101,120,0,0,49,56,98,116,84,114,105,97,110,103,108,101,67,97,108,108,98,97,99,107,0,0,0,0,216,82,0,0,184,54,0,0,51,49,98,116,73,110,116,101,114,110,97,108,84,114,105,97,110,103,108,101,73,110,100,101,120,67,97,108,108,98,97,99,107,0,0,0,0,0,0,0,216,82,0,0,216,54,0,0,0,0,0,0,88,56,0,0,129,0,0,0,150,0,0,0,41,0,0,0,11,0,0,0,1,0,0,0,1,0,0,0,73,0,0,0,24,0,0,0,8,0,0,0,53,0,0,0,74,0,0,0,14,0,0,0,2,0,0,0,54,0,0,0,22,0,0,0,50,0,0,0,12,0,0,0,38,0,0,0,3,0,0,0,42,0,0,0,14,0,0,0,36,0,0,0,26,0,0,0,0,0,0,0,0,0,0,0,128,56,0,0,129,0,0,0,151,0,0,0,41,0,0,0,11,0,0,0,1,0,0,0,1,0,0,0,73,0,0,0,24,0,0,0,8,0,0,0,55,0,0,0,74,0,0,0,14,0,0,0,2,0,0,0,54,0,0,0,22,0,0,0,50,0,0,0,12,0,0,0,38,0,0,0,3,0,0,0,42,0,0,0,14,0,0,0,36,0,0,0,26,0,0,0,0,0,0,0,0,0,0,0,168,56,0,0,129,0,0,0,152,0,0,0,41,0,0,0,11,0,0,0,1,0,0,0,1,0,0,0,73,0,0,0,24,0,0,0,8,0,0,0,56,0,0,0,74,0,0,0,14,0,0,0,2,0,0,0,54,0,0,0,22,0,0,0,50,0,0,0,12,0,0,0,38,0,0,0,3,0,0,0,42,0,0,0,14,0,0,0,36,0,0,0,26,0,0,0,0,0,0,0,49,52,98,116,67,97,112,115,117,108,101,83,104,97,112,101,0,0,0,0,0,0,0,0,0,83,0,0,64,56,0,0,216,53,0,0,0,0,0,0,49,53,98,116,67,97,112,115,117,108,101,83,104,97,112,101,88,0,0,0,0,0,0,0,0,83,0,0,104,56,0,0,88,56,0,0,0,0,0,0,49,53,98,116,67,97,112,115,117,108,101,83,104,97,112,101,90,0,0,0,0,0,0,0,0,83,0,0,144,56,0,0,88,56,0,0,0,0,0,0,67,97,112,115,117,108,101,90,0,0,0,0,0,0,0,0,67,97,112,115,117,108,101,88,0,0,0,0,0,0,0,0,98,116,67,97,112,115,117,108,101,83,104,97,112,101,68,97,116,97,0,0,0,0,0,0,67,97,112,115,117,108,101,83,104,97,112,101,0,0,0,0,0,0,0,0,168,57,0,0,85,0,0,0,153,0,0,0,37,0,0,0,11,0,0,0,1,0,0,0,1,0,0,0,75,0,0,0,57,0,0,0,7,0,0,0,58,0,0,0,49,0,0,0,10,0,0,0,2,0,0,0,26,0,0,0,15,0,0,0,50,0,0,0,39,0,0,0,40,0,0,0,3,0,0,0,43,0,0,0,14,0,0,0,36,0,0,0,26,0,0,0,12,0,0,0,59,0,0,0,60,0,0,0,44,0,0,0,41,0,0,0,61,0,0,0,45,0,0,0,3,0,0,0,0,0,0,0,50,53,98,116,67,111,110,118,101,120,84,114,105,97,110,103,108,101,77,101,115,104,83,104,97,112,101,0,0,0,0,0,0,83,0,0,136,57,0,0,88,53,0,0,0,0,0,0,67,111,110,118,101,120,84,114,105,109,101,115,104,0,0,0,0,0,0,0,0,58,0,0,143,0,0,0,154,0,0,0,46,0,0,0,0,0,0,0,50,54,76,111,99,97,108,83,117,112,112,111,114,116,86,101,114,116,101,120,67,97,108,108,98,97,99,107,0,0,0,0,0,83,0,0,224,57,0,0,0,55,0,0,0,0,0,0,49,52,98,116,67,111,110,99,97,118,101,83,104,97,112,101,0,0,0,0,0,0,0,0,0,83,0,0,16,58,0,0,152,53,0,0,0,0,0,0,0,0,0,0,208,58,0,0,85,0,0,0,155,0,0,0,47,0,0,0,11,0,0,0,1,0,0,0,1,0,0,0,76,0,0,0,24,0,0,0,9,0,0,0,62,0,0,0,49,0,0,0,15,0,0,0,2,0,0,0,26,0,0,0,15,0,0,0,50,0,0,0,42,0,0,0,43,0,0,0,3,0,0,0,48,0,0,0,14,0,0,0,63,0,0,0,44,0,0,0,12,0,0,0,64,0,0,0,65,0,0,0,49,0,0,0,45,0,0,0,66,0,0,0,50,0,0,0,4,0,0,0,46,0,0,0,49,48,98,116,66,111,120,83,104,97,112,101,0,0,0,0,0,83,0,0,192,58,0,0,32,53,0,0,0,0,0,0,66,111,120,0,0,0,0,0,0,0,0,0,40,59,0,0,156,0,0,0,157,0,0,0,15,0,0,0,67,0,0,0,23,0,0,0,77,0,0,0,78,0,0,0,16,0,0,0,49,52,98,116,79,112,116,105,109,105,122,101,100,66,118,104,0,0,0,0,0,0,0,0,0,83,0,0,16,59,0,0,80,68,0,0,0,0,0,0,0,0,0,0,184,59,0,0,143,0,0,0,158,0,0,0,51,0,0,0,0,0,0,0,90,78,49,52,98,116,79,112,116,105,109,105,122,101,100,66,118,104,53,98,117,105,108,100,69,80,50,51,98,116,83,116,114,105,100,105,110,103,77,101,115,104,73,110,116,101,114,102,97,99,101,98,82,75,57,98,116,86,101,99,116,111,114,51,83,52,95,69,50,57,81,117,97,110,116,105,122,101,100,78,111,100,101,84,114,105,97,110,103,108,101,67,97,108,108,98,97,99,107,0,0,0,0,0,0,83,0,0,80,59,0,0,0,55,0,0,0,0,0,0,0,0,0,0,64,60,0,0,143,0,0,0,159,0,0,0,52,0,0,0,0,0,0,0,90,78,49,52,98,116,79,112,116,105,109,105,122,101,100,66,118,104,53,98,117,105,108,100,69,80,50,51,98,116,83,116,114,105,100,105,110,103,77,101,115,104,73,110,116,101,114,102,97,99,101,98,82,75,57,98,116,86,101,99,116,111,114,51,83,52,95,69,50,48,78,111,100,101,84,114,105,97,110,103,108,101,67,97,108,108,98,97,99,107,0,0,0,0,0,0,0,83,0,0,224,59,0,0,0,55,0,0,0,0,0,0,0,0,0,0,160,61,0,0,129,0,0,0,160,0,0,0,53,0,0,0,11,0,0,0,1,0,0,0,1,0,0,0,79,0,0,0,24,0,0,0,10,0,0,0,68,0,0,0,80,0,0,0,16,0,0,0,2,0,0,0,69,0,0,0,24,0,0,0,50,0,0,0,47,0,0,0,48,0,0,0,3,0,0,0,54,0,0,0,14,0,0,0,36,0,0,0,26,0,0,0,6,0,0,0,0,0,0,0,200,61,0,0,129,0,0,0,161,0,0,0,53,0,0,0,11,0,0,0,1,0,0,0,1,0,0,0,79,0,0,0,24,0,0,0,10,0,0,0,70,0,0,0,80,0,0,0,16,0,0,0,2,0,0,0,69,0,0,0,24,0,0,0,50,0,0,0,47,0,0,0,49,0,0,0,3,0,0,0,55,0,0,0,14,0,0,0,36,0,0,0,26,0,0,0,7,0,0,0,0,0,0,0,240,61,0,0,129,0,0,0,162,0,0,0,53,0,0,0,11,0,0,0,1,0,0,0,1,0,0,0,79,0,0,0,24,0,0,0,10,0,0,0,71,0,0,0,80,0,0,0,16,0,0,0,2,0,0,0,69,0,0,0,24,0,0,0,50,0,0,0,47,0,0,0,50,0,0,0,3,0,0,0,56,0,0,0,14,0,0,0,36,0,0,0,26,0,0,0,8,0,0,0,49,53,98,116,67,121,108,105,110,100,101,114,83,104,97,112,101,0,0,0,0,0,0,0,0,83,0,0,136,61,0,0,216,53,0,0,0,0,0,0,49,54,98,116,67,121,108,105,110,100,101,114,83,104,97,112,101,88,0,0,0,0,0,0,0,83,0,0,176,61,0,0,160,61,0,0,0,0,0,0,49,54,98,116,67,121,108,105,110,100,101,114,83,104,97,112,101,90,0,0,0,0,0,0,0,83,0,0,216,61,0,0,160,61,0,0,0,0,0,0,67,121,108,105,110,100,101,114,90,0,0,0,0,0,0,0,67,121,108,105,110,100,101,114,88,0,0,0,0,0,0,0,98,116,67,121,108,105,110,100,101,114,83,104,97,112,101,68,97,116,97,0,0,0,0,0,67,121,108,105,110,100,101,114,89,0,0,0,0,0,0,0,0,0,0,0,168,62,0,0,163,0,0,0,164,0,0,0,57,0,0,0,1,0,0,0,2,0,0,0,81,0,0,0,82,0,0,0,72,0,0,0,83,0,0,0,84,0,0,0,73,0,0,0,51,0,0,0,52,0,0,0,74,0,0,0,25,0,0,0,0,0,0,0,49,52,98,116,84,114,105,97,110,103,108,101,77,101,115,104,0,0,0,0,0,0,0,0,0,83,0,0,144,62,0,0,168,78,0,0,0,0,0,0,0,0,0,0,88,63,0,0,165,0,0,0,166,0,0,0,1,0,0,0,53,0,0,0,9,0,0,0,58,0,0,0,2,0,0,0,59,0,0,0,85,0,0,0,75,0,0,0,76,0,0,0,54,0,0,0,86,0,0,0,167,0,0,0,49,50,98,116,65,120,105,115,83,119,101,101,112,51,0,0,50,48,98,116,65,120,105,115,83,119,101,101,112,51,73,110,116,101,114,110,97,108,73,116,69,0,0,0,0,0,0,0,50,49,98,116,66,114,111,97,100,112,104,97,115,101,73,110,116,101,114,102,97,99,101,0,216,82,0,0,40,63,0,0,0,83,0,0,8,63,0,0,64,63,0,0,0,0,0,0,0,83,0,0,248,62,0,0,72,63,0,0,0,0,0,0,0,0,0,0,72,63,0,0,165,0,0,0,168,0,0,0,1,0,0,0,53,0,0,0,9,0,0,0,58,0,0,0,2,0,0,0,59,0,0,0,85,0,0,0,75,0,0,0,76,0,0,0,54,0,0,0,86,0,0,0,167,0,0,0,0,0,0,0,64,64,0,0,169,0,0,0,170,0,0,0,26,0,0,0,17,0,0,0,55,0,0,0,77,0,0,0,78,0,0,0,79,0,0,0,56,0,0,0,80,0,0,0,57,0,0,0,87,0,0,0,58,0,0,0,27,0,0,0,81,0,0,0,88,0,0,0,89,0,0,0,0,0,0,0,49,53,98,116,78,117,108,108,80,97,105,114,67,97,99,104,101,0,0,0,0,0,0,0,50,50,98,116,79,118,101,114,108,97,112,112,105,110,103,80,97,105,114,67,97,99,104,101,0,0,0,0,0,0,0,0,0,83,0,0,16,64,0,0,208,1,0,0,0,0,0,0,0,83,0,0,248,63,0,0,48,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,64,0,0,171,0,0,0,172,0,0,0,28,0,0,0,18,0,0,0,59,0,0,0,82,0,0,0,83,0,0,0,84,0,0,0,60,0,0,0,85,0,0,0,61,0,0,0,90,0,0,0,62,0,0,0,29,0,0,0,86,0,0,0,91,0,0,0,92,0,0,0,0,0,0,0,50,56,98,116,72,97,115,104,101,100,79,118,101,114,108,97,112,112,105,110,103,80,97,105,114,67,97,99,104,101,0,0,0,83,0,0,192,64,0,0,48,64,0,0,0,0,0,0,0,0,0,0,144,65,0,0,58,0,0,0,173,0,0,0,19,0,0,0,0,0,0,0,90,78,50,56,98,116,72,97,115,104,101,100,79,118,101,114,108,97,112,112,105,110,103,80,97,105,114,67,97,99,104,101,51,55,114,101,109,111,118,101,79,118,101,114,108,97,112,112,105,110,103,80,97,105,114,115,67,111,110,116,97,105,110,105,110,103,80,114,111,120,121,69,80,49,55,98,116,66,114,111,97,100,112,104,97,115,101,80,114,111,120,121,80,49,50,98,116,68,105,115,112,97,116,99,104,101,114,69,49,56,82,101,109,111,118,101,80,97,105,114,67,97,108,108,98,97,99,107,0,0,0,0,0,0,0,0,0,83,0,0,8,65,0,0,152,22,0,0,0,0,0,0,0,0,0,0,40,66,0,0,58,0,0,0,174,0,0,0,20,0,0,0,0,0,0,0,90,78,50,56,98,116,72,97,115,104,101,100,79,118,101,114,108,97,112,112,105,110,103,80,97,105,114,67,97,99,104,101,49,57,99,108,101,97,110,80,114,111,120,121,70,114,111,109,80,97,105,114,115,69,80,49,55,98,116,66,114,111,97,100,112,104,97,115,101,80,114,111,120,121,80,49,50,98,116,68,105,115,112,97,116,99,104,101,114,69,49,55,67,108,101,97,110,80,97,105,114,67,97,108,108,98,97,99,107,0,0,0,0,83,0,0,184,65,0,0,152,22,0,0,0,0,0,0,0,0,0,0,144,66,0,0,175,0,0,0,176,0,0,0,2,0,0,0,63,0,0,0,10,0,0,0,60,0,0,0,3,0,0,0,61,0,0,0,93,0,0,0,87,0,0,0,88,0,0,0,64,0,0,0,94,0,0,0,177,0,0,0,49,54,98,116,68,98,118,116,66,114,111,97,100,112,104,97,115,101,0,0,0,0,0,0,0,83,0,0,120,66,0,0,64,63,0,0,0,0,0,0,0,0,0,0,224,66,0,0,107,0,0,0,178,0,0,0,18,0,0,0,95,0,0,0,5,0,0,0,17,0,0,0,18,0,0,0,0,0,0,0,50,48,66,114,111,97,100,112,104,97,115,101,65,97,98,98,84,101,115,116,101,114,0,0,0,83,0,0,200,66,0,0,168,38,0,0,0,0,0,0,0,0,0,0,48,67,0,0,107,0,0,0,179,0,0,0,18,0,0,0,96,0,0,0,5,0,0,0,17,0,0,0,18,0,0,0,0,0,0,0,49,57,66,114,111,97,100,112,104,97,115,101,82,97,121,84,101,115,116,101,114,0,0,0,0,83,0,0,24,67,0,0,168,38,0,0,0,0,0,0,0,0,0,0,128,67,0,0,107,0,0,0,180,0,0,0,65,0,0,0,97,0,0,0,5,0,0,0,17,0,0,0,18,0,0,0,0,0,0,0,49,56,98,116,68,98,118,116,84,114,101,101,67,111,108,108,105,100,101,114,0,0,0,0,0,83,0,0,104,67,0,0,168,38,0,0,0,0,0,0,49,50,98,116,68,105,115,112,97,116,99,104,101,114,0,0,216,82,0,0,144,67,0,0,0,0,0,0,80,68,0,0,181,0,0,0,182,0,0,0,15,0,0,0,67,0,0,0,23,0,0,0,77,0,0,0,78,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,98,116,79,112,116,105,109,105,122,101,100,66,118,104,78,111,100,101,68,97,116,97,0,0,98,116,81,117,97,110,116,105,122,101,100,66,118,104,78,111,100,101,68,97,116,97,0,0,98,116,66,118,104,83,117,98,116,114,101,101,73,110,102,111,68,97,116,97,0,0,0,0,98,116,81,117,97,110,116,105,122,101,100,66,118,104,70,108,111,97,116,68,97,116,97,0,49,52,98,116,81,117,97,110,116,105,122,101,100,66,118,104,0,0,0,0,0,0,0,0,216,82,0,0,56,68,0,0,0,0,0,0,192,68,0,0,81,0,0,0,183,0,0,0,22,0,0,0,1,0,0,0,50,53,98,116,84,114,105,97,110,103,108,101,82,97,121,99,97,115,116,67,97,108,108,98,97,99,107,0,0,0,0,0,0,83,0,0,112,68,0,0,208,54,0,0,0,0,0,0,50,56,98,116,84,114,105,97,110,103,108,101,67,111,110,118,101,120,99,97,115,116,67,97,108,108,98,97,99,107,0,0,0,83,0,0,160,68,0,0,208,54,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,40,73,0,0,184,0,0,0,185,0,0,0,1,0,0,0,0,0,0,0,51,51,98,116,77,105,110,107,111,119,115,107,105,80,101,110,101,116,114,97,116,105,111,110,68,101,112,116,104,83,111,108,118,101,114,0,0,0,0,0,51,48,98,116,67,111,110,118,101,120,80,101,110,101,116,114,97,116,105,111,110,68,101,112,116,104,83,111,108,118,101,114,0,0,0,0,0,0,0,0,216,82,0,0,248,72,0,0,0,83,0,0,208,72,0,0,32,73,0,0,0,0,0,0,0,0,0,0,8,74,0,0,89,0,0,0,186,0,0,0,66,0,0,0,67,0,0,0,8,0,0,0,0,0,0,0,90,78,51,51,98,116,77,105,110,107,111,119,115,107,105,80,101,110,101,116,114,97,116,105,111,110,68,101,112,116,104,83,111,108,118,101,114,49,50,99,97,108,99,80,101,110,68,101,112,116,104,69,82,50,50,98,116,86,111,114,111,110,111,105,83,105,109,112,108,101,120,83,111,108,118,101,114,80,75,49,51,98,116,67,111,110,118,101,120,83,104,97,112,101,83,52,95,82,75,49,49,98,116,84,114,97,110,115,102,111,114,109,83,55,95,82,57,98,116,86,101,99,116,111,114,51,83,57,95,83,57,95,80,49,50,98,116,73,68,101,98,117,103,68,114,97,119,69,50,48,98,116,73,110,116,101,114,109,101,100,105,97,116,101,82,101,115,117,108,116,0,0,0,0,0,0,0,83,0,0,88,73,0,0,48,31,0,0,0,0,0,0,0,0,0,0,80,74,0,0,187,0,0,0,188,0,0,0,1,0,0,0,0,0,0,0,50,50,98,116,83,117,98,115,105,109,112,108,101,120,67,111,110,118,101,120,67,97,115,116,0,0,0,0,0,0,0,0,0,83,0,0,48,74,0,0,72,75,0,0,0,0,0,0,0,0,0,0,160,74,0,0,184,0,0,0,189,0,0,0,2,0,0,0,0,0,0,0,51,48,98,116,71,106,107,69,112,97,80,101,110,101,116,114,97,116,105,111,110,68,101,112,116,104,83,111,108,118,101,114,0,0,0,0,0,0,0,0,0,83,0,0,120,74,0,0,32,73,0,0,0,0,0,0,0,0,0,0,224,74,0,0,187,0,0,0,190,0,0,0,2,0,0,0,0,0,0,0,49,53,98,116,71,106,107,67,111,110,118,101,120,67,97,115,116,0,0,0,0,0,0,0,0,83,0,0,200,74,0,0,72,75,0,0,0,0,0,0,0,0,0,0,40,75,0,0,89,0,0,0,191,0,0,0,68,0,0,0,69,0,0,0,9,0,0,0,0,0,0,0,49,54,98,116,80,111,105,110,116,67,111,108,108,101,99,116,111,114,0,0,0,0,0,0,0,83,0,0,16,75,0,0,48,31,0,0,0,0,0,0,49,50,98,116,67,111,110,118,101,120,67,97,115,116,0,0,216,82,0,0,56,75,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160,75,0,0,187,0,0,0,192,0,0,0,3,0,0,0,0,0,0,0,50,55,98,116,67,111,110,116,105,110,117,111,117,115,67,111,110,118,101,120,67,111,108,108,105,115,105,111,110,0,0,0,0,83,0,0,128,75,0,0,72,75,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,76,0,0,193,0,0,0,194,0,0,0,11,0,0,0,0,0,0,0,49,55,98,116,71,106,107,80,97,105,114,68,101,116,101,99,116,111,114,0,0,0,0,0,51,54,98,116,68,105,115,99,114,101,116,101,67,111,108,108,105,115,105,111,110,68,101,116,101,99,116,111,114,73,110,116,101,114,102,97,99,101,0,0,216,82,0,0,240,75,0,0,0,83,0,0,216,75,0,0,24,76,0,0,0,0,0,0,2,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,51,48,98,116,65,99,116,105,118,97,116,105,110,103,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,0,0,0,0,0,0,0,0,0,83,0,0,80,76,0,0,208,27,0,0,0,0,0,0,0,0,0,0,192,76,0,0,195,0,0,0,196,0,0,0,12,0,0,0,8,0,0,0,98,0,0,0,0,0,0,0,49,54,98,116,69,109,112,116,121,65,108,103,111,114,105,116,104,109,0,0,0,0,0,0,0,83,0,0,168,76,0,0,208,27,0,0,0,0,0,0,0,0,0,0,24,77,0,0,197,0,0,0,198,0,0,0,13,0,0,0,9,0,0,0,99,0,0,0,0,0,0,0,51,50,98,116,83,112,104,101,114,101,83,112,104,101,114,101,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,0,0,0,0,0,0,0,83,0,0,240,76,0,0,120,76,0,0,0,0,0,0,0,0,0,0,88,77,0,0,193,0,0,0,199,0,0,0,14,0,0,0,0,0,0,0,49,54,98,116,66,111,120,66,111,120,68,101,116,101,99,116,111,114,0,0,0,0,0,0,0,83,0,0,64,77,0,0,24,76,0,0,0,0,0,0,0,0,0,0,160,77,0,0,193,0,0,0,200,0,0,0,15,0,0,0,0,0,0,0,50,50,83,112,104,101,114,101,84,114,105,97,110,103,108,101,68,101,116,101,99,116,111,114,0,0,0,0,0,0,0,0,0,83,0,0,128,77,0,0,24,76,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,78,0,0,201,0,0,0,202,0,0,0,30,0,0,0,31,0,0,0,89,0,0,0,0,0,0,0,50,51,98,116,72,97,115,104,101,100,83,105,109,112,108,101,80,97,105,114,67,97,99,104,101,0,0,0,0,0,0,0,216,82,0,0,232,77,0,0,0,0,0,0,56,78,0,0,203,0,0,0,204,0,0,0,49,56,98,116,67,111,110,118,101,120,80,111,108,121,104,101,100,114,111,110,0,0,0,0,216,82,0,0,32,78,0,0,0,0,0,0,168,78,0,0,205,0,0,0,206,0,0,0,57,0,0,0,1,0,0,0,2,0,0,0,81,0,0,0,82,0,0,0,72,0,0,0,100,0,0,0,101,0,0,0,73,0,0,0,51,0,0,0,52,0,0,0,74,0,0,0,25,0,0,0,0,0,0,0,50,54,98,116,84,114,105,97,110,103,108,101,73,110,100,101,120,86,101,114,116,101,120,65,114,114,97,121,0,0,0,0,0,83,0,0,136,78,0,0,128,79,0,0,0,0,0,0,98,116,73,110,116,73,110,100,101,120,68,97,116,97,0,0,98,116,83,104,111,114,116,73,110,116,73,110,100,101,120,84,114,105,112,108,101,116,68,97,116,97,0,0,0,0,0,0,98,116,67,104,97,114,73,110,100,101,120,84,114,105,112,108,101,116,68,97,116,97,0,0,98,116,86,101,99,116,111,114,51,70,108,111,97,116,68,97,116,97,0,0,0,0,0,0,98,116,86,101,99,116,111,114,51,68,111,117,98,108,101,68,97,116,97,0,0,0,0,0,98,116,77,101,115,104,80,97,114,116,68,97,116,97,0,0,98,116,83,116,114,105,100,105,110,103,77,101,115,104,73,110,116,101,114,102,97,99,101,68,97,116,97,0,0,0,0,0,50,51,98,116,83,116,114,105,100,105,110,103,77,101,115,104,73,110,116,101,114,102,97,99,101,0,0,0,0,0,0,0,216,82,0,0,96,79,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,82,111,111,116,0,0,0,0,144,79,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,117,110,99,97,117,103,104,116,0,0,0,0,0,0,0,0,116,101,114,109,105,110,97,116,105,110,103,32,119,105,116,104],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE+10240);allocate([32,37,115,32,101,120,99,101,112,116,105,111,110,32,111,102,32,116,121,112,101,32,37,115,58,32,37,115,0,0,0,0,116,101,114,109,105,110,97,116,105,110,103,32,119,105,116,104,32,37,115,32,101,120,99,101,112,116,105,111,110,32,111,102,32,116,121,112,101,32,37,115,0,0,0,0,0,0,0,0,116,101,114,109,105,110,97,116,105,110,103,32,119,105,116,104,32,37,115,32,102,111,114,101,105,103,110,32,101,120,99,101,112,116,105,111,110,0,0,0,116,101,114,109,105,110,97,116,105,110,103,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112,116,104,114,101,97,100,95,111,110,99,101,32,102,97,105,108,117,114,101,32,105,110,32,95,95,99,120,97,95,103,101,116,95,103,108,111,98,97,108,115,95,102,97,115,116,40,41,0,0,0,0,0,0,0,0,99,97,110,110,111,116,32,99,114,101,97,116,101,32,112,116,104,114,101,97,100,32,107,101,121,32,102,111,114,32,95,95,99,120,97,95,103,101,116,95,103,108,111,98,97,108,115,40,41,0,0,0,0,0,0,0,99,97,110,110,111,116,32,122,101,114,111,32,111,117,116,32,116,104,114,101,97,100,32,118,97,108,117,101,32,102,111,114,32,95,95,99,120,97,95,103,101,116,95,103,108,111,98,97,108,115,40,41,0,0,0,0,0,0,0,0,128,81,0,0,207,0,0,0,208,0,0,0,90,0,0,0,0,0,0,0,115,116,100,58,58,98,97,100,95,97,108,108,111,99,0,0,83,116,57,98,97,100,95,97,108,108,111,99,0,0,0,0,0,83,0,0,112,81,0,0,208,81,0,0,0,0,0,0,116,101,114,109,105,110,97,116,101,95,104,97,110,100,108,101,114,32,117,110,101,120,112,101,99,116,101,100,108,121,32,114,101,116,117,114,110,101,100,0,0,0,0,0,0,0,0,0,83,116,57,101,120,99,101,112,116,105,111,110,0,0,0,0,216,82,0,0,192,81,0,0,83,116,57,116,121,112,101,95,105,110,102,111,0,0,0,0,216,82,0,0,216,81,0,0,78,49,48,95,95,99,120,120,97,98,105,118,49,49,54,95,95,115,104,105,109,95,116,121,112,101,95,105,110,102,111,69,0,0,0,0,0,0,0,0,0,83,0,0,240,81,0,0,232,81,0,0,0,0,0,0,78,49,48,95,95,99,120,120,97,98,105,118,49,49,55,95,95,99,108,97,115,115,95,116,121,112,101,95,105,110,102,111,69,0,0,0,0,0,0,0,0,83,0,0,40,82,0,0,24,82,0,0,0,0,0,0,78,49,48,95,95,99,120,120,97,98,105,118,49,49,57,95,95,112,111,105,110,116,101,114,95,116,121,112,101,95,105,110,102,111,69,0,0,0,0,0,78,49,48,95,95,99,120,120,97,98,105,118,49,49,55,95,95,112,98,97,115,101,95,116,121,112,101,95,105,110,102,111,69,0,0,0,0,0,0,0,0,83,0,0,136,82,0,0,24,82,0,0,0,0,0,0,0,83,0,0,96,82,0,0,176,82,0,0,0,0,0,0,0,0,0,0,80,82,0,0,209,0,0,0,210,0,0,0,211,0,0,0,212,0,0,0,32,0,0,0,4,0,0,0,16,0,0,0,62,0,0,0,0,0,0,0,72,83,0,0,209,0,0,0,213,0,0,0,211,0,0,0,212,0,0,0,32,0,0,0,5,0,0,0,17,0,0,0,63,0,0,0,78,49,48,95,95,99,120,120,97,98,105,118,49,50,48,95,95,115,105,95,99,108,97,115,115,95,116,121,112,101,95,105,110,102,111,69,0,0,0,0,0,83,0,0,32,83,0,0,80,82,0,0,0,0,0,0,0,0,0,0,168,83,0,0,209,0,0,0,214,0,0,0,211,0,0,0,212,0,0,0,32,0,0,0,6,0,0,0,18,0,0,0,64,0,0,0,78,49,48,95,95,99,120,120,97,98,105,118,49,50,49,95,95,118,109,105,95,99,108,97,115,115,95,116,121,112,101,95,105,110,102,111,69,0,0,0,0,83,0,0,128,83,0,0,80,82,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE+20480);var tempDoublePtr=Runtime.alignMemory(allocate(12,"i8",ALLOC_STATIC),8);assert(tempDoublePtr%8==0);function copyTempFloat(ptr){HEAP8[tempDoublePtr]=HEAP8[ptr];HEAP8[tempDoublePtr+1]=HEAP8[ptr+1];HEAP8[tempDoublePtr+2]=HEAP8[ptr+2];HEAP8[tempDoublePtr+3]=HEAP8[ptr+3]}function copyTempDouble(ptr){HEAP8[tempDoublePtr]=HEAP8[ptr];HEAP8[tempDoublePtr+1]=HEAP8[ptr+1];HEAP8[tempDoublePtr+2]=HEAP8[ptr+2];HEAP8[tempDoublePtr+3]=HEAP8[ptr+3];HEAP8[tempDoublePtr+4]=HEAP8[ptr+4];HEAP8[tempDoublePtr+5]=HEAP8[ptr+5];HEAP8[tempDoublePtr+6]=HEAP8[ptr+6];HEAP8[tempDoublePtr+7]=HEAP8[ptr+7]}var _cosf=Math_cos;Module["_i64Subtract"]=_i64Subtract;var _fabsf=Math_abs;var ___errno_state=0;function ___setErrNo(value){HEAP32[___errno_state>>2]=value;return value}var ERRNO_CODES={EPERM:1,ENOENT:2,ESRCH:3,EINTR:4,EIO:5,ENXIO:6,E2BIG:7,ENOEXEC:8,EBADF:9,ECHILD:10,EAGAIN:11,EWOULDBLOCK:11,ENOMEM:12,EACCES:13,EFAULT:14,ENOTBLK:15,EBUSY:16,EEXIST:17,EXDEV:18,ENODEV:19,ENOTDIR:20,EISDIR:21,EINVAL:22,ENFILE:23,EMFILE:24,ENOTTY:25,ETXTBSY:26,EFBIG:27,ENOSPC:28,ESPIPE:29,EROFS:30,EMLINK:31,EPIPE:32,EDOM:33,ERANGE:34,ENOMSG:42,EIDRM:43,ECHRNG:44,EL2NSYNC:45,EL3HLT:46,EL3RST:47,ELNRNG:48,EUNATCH:49,ENOCSI:50,EL2HLT:51,EDEADLK:35,ENOLCK:37,EBADE:52,EBADR:53,EXFULL:54,ENOANO:55,EBADRQC:56,EBADSLT:57,EDEADLOCK:35,EBFONT:59,ENOSTR:60,ENODATA:61,ETIME:62,ENOSR:63,ENONET:64,ENOPKG:65,EREMOTE:66,ENOLINK:67,EADV:68,ESRMNT:69,ECOMM:70,EPROTO:71,EMULTIHOP:72,EDOTDOT:73,EBADMSG:74,ENOTUNIQ:76,EBADFD:77,EREMCHG:78,ELIBACC:79,ELIBBAD:80,ELIBSCN:81,ELIBMAX:82,ELIBEXEC:83,ENOSYS:38,ENOTEMPTY:39,ENAMETOOLONG:36,ELOOP:40,EOPNOTSUPP:95,EPFNOSUPPORT:96,ECONNRESET:104,ENOBUFS:105,EAFNOSUPPORT:97,EPROTOTYPE:91,ENOTSOCK:88,ENOPROTOOPT:92,ESHUTDOWN:108,ECONNREFUSED:111,EADDRINUSE:98,ECONNABORTED:103,ENETUNREACH:101,ENETDOWN:100,ETIMEDOUT:110,EHOSTDOWN:112,EHOSTUNREACH:113,EINPROGRESS:115,EALREADY:114,EDESTADDRREQ:89,EMSGSIZE:90,EPROTONOSUPPORT:93,ESOCKTNOSUPPORT:94,EADDRNOTAVAIL:99,ENETRESET:102,EISCONN:106,ENOTCONN:107,ETOOMANYREFS:109,EUSERS:87,EDQUOT:122,ESTALE:116,ENOTSUP:95,ENOMEDIUM:123,EILSEQ:84,EOVERFLOW:75,ECANCELED:125,ENOTRECOVERABLE:131,EOWNERDEAD:130,ESTRPIPE:86};function _sysconf(name){switch(name){case 30:return PAGE_SIZE;case 132:case 133:case 12:case 137:case 138:case 15:case 235:case 16:case 17:case 18:case 19:case 20:case 149:case 13:case 10:case 236:case 153:case 9:case 21:case 22:case 159:case 154:case 14:case 77:case 78:case 139:case 80:case 81:case 79:case 82:case 68:case 67:case 164:case 11:case 29:case 47:case 48:case 95:case 52:case 51:case 46:return 200809;case 27:case 246:case 127:case 128:case 23:case 24:case 160:case 161:case 181:case 182:case 242:case 183:case 184:case 243:case 244:case 245:case 165:case 178:case 179:case 49:case 50:case 168:case 169:case 175:case 170:case 171:case 172:case 97:case 76:case 32:case 173:case 35:return-1;case 176:case 177:case 7:case 155:case 8:case 157:case 125:case 126:case 92:case 93:case 129:case 130:case 131:case 94:case 91:return 1;case 74:case 60:case 69:case 70:case 4:return 1024;case 31:case 42:case 72:return 32;case 87:case 26:case 33:return 2147483647;case 34:case 1:return 47839;case 38:case 36:return 99;case 43:case 37:return 2048;case 0:return 2097152;case 3:return 65536;case 28:return 32768;case 44:return 32767;case 75:return 16384;case 39:return 1e3;case 89:return 700;case 71:return 256;case 40:return 255;case 2:return 100;case 180:return 64;case 25:return 20;case 5:return 16;case 6:return 6;case 73:return 4;case 84:{if(typeof navigator==="object")return navigator["hardwareConcurrency"]||1;return 1}}___setErrNo(ERRNO_CODES.EINVAL);return-1}function __ZSt18uncaught_exceptionv(){return!!__ZSt18uncaught_exceptionv.uncaught_exception}var EXCEPTIONS={last:0,caught:[],infos:{},deAdjust:(function(adjusted){if(!adjusted||EXCEPTIONS.infos[adjusted])return adjusted;for(var ptr in EXCEPTIONS.infos){var info=EXCEPTIONS.infos[ptr];if(info.adjusted===adjusted){return ptr}}return adjusted}),addRef:(function(ptr){if(!ptr)return;var info=EXCEPTIONS.infos[ptr];info.refcount++}),decRef:(function(ptr){if(!ptr)return;var info=EXCEPTIONS.infos[ptr];assert(info.refcount>0);info.refcount--;if(info.refcount===0){if(info.destructor){Runtime.dynCall("vi",info.destructor,[ptr])}delete EXCEPTIONS.infos[ptr];___cxa_free_exception(ptr)}}),clearRef:(function(ptr){if(!ptr)return;var info=EXCEPTIONS.infos[ptr];info.refcount=0})};function ___resumeException(ptr){if(!EXCEPTIONS.last){EXCEPTIONS.last=ptr}EXCEPTIONS.clearRef(EXCEPTIONS.deAdjust(ptr));throw ptr+" - Exception catching is disabled, this exception cannot be caught. Compile with -s DISABLE_EXCEPTION_CATCHING=0 or DISABLE_EXCEPTION_CATCHING=2 to catch."}function ___cxa_find_matching_catch(){var thrown=EXCEPTIONS.last;if(!thrown){return(asm["setTempRet0"](0),0)|0}var info=EXCEPTIONS.infos[thrown];var throwntype=info.type;if(!throwntype){return(asm["setTempRet0"](0),thrown)|0}var typeArray=Array.prototype.slice.call(arguments);var pointer=Module["___cxa_is_pointer_type"](throwntype);if(!___cxa_find_matching_catch.buffer)___cxa_find_matching_catch.buffer=_malloc(4);HEAP32[___cxa_find_matching_catch.buffer>>2]=thrown;thrown=___cxa_find_matching_catch.buffer;for(var i=0;i<typeArray.length;i++){if(typeArray[i]&&Module["___cxa_can_catch"](typeArray[i],throwntype,thrown)){thrown=HEAP32[thrown>>2];info.adjusted=thrown;return(asm["setTempRet0"](typeArray[i]),thrown)|0}}thrown=HEAP32[thrown>>2];return(asm["setTempRet0"](throwntype),thrown)|0}function ___cxa_throw(ptr,type,destructor){EXCEPTIONS.infos[ptr]={ptr:ptr,adjusted:ptr,type:type,destructor:destructor,refcount:0};EXCEPTIONS.last=ptr;if(!("uncaught_exception"in __ZSt18uncaught_exceptionv)){__ZSt18uncaught_exceptionv.uncaught_exception=1}else{__ZSt18uncaught_exceptionv.uncaught_exception++}throw ptr+" - Exception catching is disabled, this exception cannot be caught. Compile with -s DISABLE_EXCEPTION_CATCHING=0 or DISABLE_EXCEPTION_CATCHING=2 to catch."}Module["_memset"]=_memset;function _abort(){Module["abort"]()}function _pthread_once(ptr,func){if(!_pthread_once.seen)_pthread_once.seen={};if(ptr in _pthread_once.seen)return;Runtime.dynCall("v",func);_pthread_once.seen[ptr]=1}var _acosf=Math_acos;Module["_strlen"]=_strlen;var _sqrtf=Math_sqrt;var FS=undefined;var SOCKFS=undefined;function _send(fd,buf,len,flags){var sock=SOCKFS.getSocket(fd);if(!sock){___setErrNo(ERRNO_CODES.EBADF);return-1}return _write(fd,buf,len)}function _pwrite(fildes,buf,nbyte,offset){var stream=FS.getStream(fildes);if(!stream){___setErrNo(ERRNO_CODES.EBADF);return-1}try{var slab=HEAP8;return FS.write(stream,slab,buf,nbyte,offset)}catch(e){FS.handleFSError(e);return-1}}function _write(fildes,buf,nbyte){var stream=FS.getStream(fildes);if(!stream){___setErrNo(ERRNO_CODES.EBADF);return-1}try{var slab=HEAP8;return FS.write(stream,slab,buf,nbyte)}catch(e){FS.handleFSError(e);return-1}}function _fileno(stream){stream=FS.getStreamFromPtr(stream);if(!stream)return-1;return stream.fd}function _fputc(c,stream){var chr=unSign(c&255);HEAP8[_fputc.ret>>0]=chr;var fd=_fileno(stream);var ret=_write(fd,_fputc.ret,1);if(ret==-1){var streamObj=FS.getStreamFromPtr(stream);if(streamObj)streamObj.error=true;return-1}else{return chr}}var PTHREAD_SPECIFIC={};function _pthread_getspecific(key){return PTHREAD_SPECIFIC[key]||0}Module["_i64Add"]=_i64Add;var PTHREAD_SPECIFIC_NEXT_KEY=1;function _pthread_key_create(key,destructor){if(key==0){return ERRNO_CODES.EINVAL}HEAP32[key>>2]=PTHREAD_SPECIFIC_NEXT_KEY;PTHREAD_SPECIFIC[PTHREAD_SPECIFIC_NEXT_KEY]=0;PTHREAD_SPECIFIC_NEXT_KEY++;return 0}var _llvm_pow_f32=Math_pow;function _pthread_setspecific(key,value){if(!(key in PTHREAD_SPECIFIC)){return ERRNO_CODES.EINVAL}PTHREAD_SPECIFIC[key]=value;return 0}var _atan2f=Math_atan2;function ___cxa_pure_virtual(){ABORT=true;throw"Pure virtual function called!"}function ___cxa_guard_release(){}var _asinf=Math_asin;function ___cxa_guard_acquire(variable){if(!HEAP8[variable>>0]){HEAP8[variable>>0]=1;return 1}return 0}function _gettimeofday(ptr){var now=Date.now();HEAP32[ptr>>2]=now/1e3|0;HEAP32[ptr+4>>2]=now%1e3*1e3|0;return 0}function _emscripten_asm_const_double(code){var args=Array.prototype.slice.call(arguments,1);return+Runtime.getAsmConst(code,args.length).apply(null,args)}function ___cxa_begin_catch(ptr){__ZSt18uncaught_exceptionv.uncaught_exception--;EXCEPTIONS.caught.push(ptr);EXCEPTIONS.addRef(EXCEPTIONS.deAdjust(ptr));return ptr}var _sinf=Math_sin;function _emscripten_memcpy_big(dest,src,num){HEAPU8.set(HEAPU8.subarray(src,src+num),dest);return dest}Module["_memcpy"]=_memcpy;function _sbrk(bytes){var self=_sbrk;if(!self.called){DYNAMICTOP=alignMemoryPage(DYNAMICTOP);self.called=true;assert(Runtime.dynamicAlloc);self.alloc=Runtime.dynamicAlloc;Runtime.dynamicAlloc=(function(){abort("cannot dynamically allocate, sbrk now has control")})}var ret=DYNAMICTOP;if(bytes!=0)self.alloc(bytes);return ret}Module["_memmove"]=_memmove;function _malloc(bytes){var ptr=Runtime.dynamicAlloc(bytes+8);return ptr+8&4294967288}Module["_malloc"]=_malloc;function ___cxa_allocate_exception(size){return _malloc(size)}function ___errno_location(){return ___errno_state}Module["_llvm_bswap_i32"]=_llvm_bswap_i32;function _llvm_trap(){abort("trap!")}function _time(ptr){var ret=Date.now()/1e3|0;if(ptr){HEAP32[ptr>>2]=ret}return ret}var _UItoF=true;function _fwrite(ptr,size,nitems,stream){var bytesToWrite=nitems*size;if(bytesToWrite==0)return 0;var fd=_fileno(stream);var bytesWritten=_write(fd,ptr,bytesToWrite);if(bytesWritten==-1){var streamObj=FS.getStreamFromPtr(stream);if(streamObj)streamObj.error=true;return 0}else{return bytesWritten/size|0}}function __reallyNegative(x){return x<0||x===0&&1/x===-Infinity}function __formatString(format,varargs){var textIndex=format;var argIndex=0;function getNextArg(type){var ret;if(type==="double"){ret=(HEAP32[tempDoublePtr>>2]=HEAP32[varargs+argIndex>>2],HEAP32[tempDoublePtr+4>>2]=HEAP32[varargs+(argIndex+4)>>2],+HEAPF64[tempDoublePtr>>3])}else if(type=="i64"){ret=[HEAP32[varargs+argIndex>>2],HEAP32[varargs+(argIndex+4)>>2]]}else{type="i32";ret=HEAP32[varargs+argIndex>>2]}argIndex+=Runtime.getNativeFieldSize(type);return ret}var ret=[];var curr,next,currArg;while(1){var startTextIndex=textIndex;curr=HEAP8[textIndex>>0];if(curr===0)break;next=HEAP8[textIndex+1>>0];if(curr==37){var flagAlwaysSigned=false;var flagLeftAlign=false;var flagAlternative=false;var flagZeroPad=false;var flagPadSign=false;flagsLoop:while(1){switch(next){case 43:flagAlwaysSigned=true;break;case 45:flagLeftAlign=true;break;case 35:flagAlternative=true;break;case 48:if(flagZeroPad){break flagsLoop}else{flagZeroPad=true;break};case 32:flagPadSign=true;break;default:break flagsLoop}textIndex++;next=HEAP8[textIndex+1>>0]}var width=0;if(next==42){width=getNextArg("i32");textIndex++;next=HEAP8[textIndex+1>>0]}else{while(next>=48&&next<=57){width=width*10+(next-48);textIndex++;next=HEAP8[textIndex+1>>0]}}var precisionSet=false,precision=-1;if(next==46){precision=0;precisionSet=true;textIndex++;next=HEAP8[textIndex+1>>0];if(next==42){precision=getNextArg("i32");textIndex++}else{while(1){var precisionChr=HEAP8[textIndex+1>>0];if(precisionChr<48||precisionChr>57)break;precision=precision*10+(precisionChr-48);textIndex++}}next=HEAP8[textIndex+1>>0]}if(precision<0){precision=6;precisionSet=false}var argSize;switch(String.fromCharCode(next)){case"h":var nextNext=HEAP8[textIndex+2>>0];if(nextNext==104){textIndex++;argSize=1}else{argSize=2}break;case"l":var nextNext=HEAP8[textIndex+2>>0];if(nextNext==108){textIndex++;argSize=8}else{argSize=4}break;case"L":case"q":case"j":argSize=8;break;case"z":case"t":case"I":argSize=4;break;default:argSize=null}if(argSize)textIndex++;next=HEAP8[textIndex+1>>0];switch(String.fromCharCode(next)){case"d":case"i":case"u":case"o":case"x":case"X":case"p":{var signed=next==100||next==105;argSize=argSize||4;var currArg=getNextArg("i"+argSize*8);var origArg=currArg;var argText;if(argSize==8){currArg=Runtime.makeBigInt(currArg[0],currArg[1],next==117)}if(argSize<=4){var limit=Math.pow(256,argSize)-1;currArg=(signed?reSign:unSign)(currArg&limit,argSize*8)}var currAbsArg=Math.abs(currArg);var prefix="";if(next==100||next==105){if(argSize==8&&i64Math)argText=i64Math.stringify(origArg[0],origArg[1],null);else argText=reSign(currArg,8*argSize,1).toString(10)}else if(next==117){if(argSize==8&&i64Math)argText=i64Math.stringify(origArg[0],origArg[1],true);else argText=unSign(currArg,8*argSize,1).toString(10);currArg=Math.abs(currArg)}else if(next==111){argText=(flagAlternative?"0":"")+currAbsArg.toString(8)}else if(next==120||next==88){prefix=flagAlternative&&currArg!=0?"0x":"";if(argSize==8&&i64Math){if(origArg[1]){argText=(origArg[1]>>>0).toString(16);var lower=(origArg[0]>>>0).toString(16);while(lower.length<8)lower="0"+lower;argText+=lower}else{argText=(origArg[0]>>>0).toString(16)}}else if(currArg<0){currArg=-currArg;argText=(currAbsArg-1).toString(16);var buffer=[];for(var i=0;i<argText.length;i++){buffer.push((15-parseInt(argText[i],16)).toString(16))}argText=buffer.join("");while(argText.length<argSize*2)argText="f"+argText}else{argText=currAbsArg.toString(16)}if(next==88){prefix=prefix.toUpperCase();argText=argText.toUpperCase()}}else if(next==112){if(currAbsArg===0){argText="(nil)"}else{prefix="0x";argText=currAbsArg.toString(16)}}if(precisionSet){while(argText.length<precision){argText="0"+argText}}if(currArg>=0){if(flagAlwaysSigned){prefix="+"+prefix}else if(flagPadSign){prefix=" "+prefix}}if(argText.charAt(0)=="-"){prefix="-"+prefix;argText=argText.substr(1)}while(prefix.length+argText.length<width){if(flagLeftAlign){argText+=" "}else{if(flagZeroPad){argText="0"+argText}else{prefix=" "+prefix}}}argText=prefix+argText;argText.split("").forEach((function(chr){ret.push(chr.charCodeAt(0))}));break};case"f":case"F":case"e":case"E":case"g":case"G":{var currArg=getNextArg("double");var argText;if(isNaN(currArg)){argText="nan";flagZeroPad=false}else if(!isFinite(currArg)){argText=(currArg<0?"-":"")+"inf";flagZeroPad=false}else{var isGeneral=false;var effectivePrecision=Math.min(precision,20);if(next==103||next==71){isGeneral=true;precision=precision||1;var exponent=parseInt(currArg.toExponential(effectivePrecision).split("e")[1],10);if(precision>exponent&&exponent>=-4){next=(next==103?"f":"F").charCodeAt(0);precision-=exponent+1}else{next=(next==103?"e":"E").charCodeAt(0);precision--}effectivePrecision=Math.min(precision,20)}if(next==101||next==69){argText=currArg.toExponential(effectivePrecision);if(/[eE][-+]\d$/.test(argText)){argText=argText.slice(0,-1)+"0"+argText.slice(-1)}}else if(next==102||next==70){argText=currArg.toFixed(effectivePrecision);if(currArg===0&&__reallyNegative(currArg)){argText="-"+argText}}var parts=argText.split("e");if(isGeneral&&!flagAlternative){while(parts[0].length>1&&parts[0].indexOf(".")!=-1&&(parts[0].slice(-1)=="0"||parts[0].slice(-1)==".")){parts[0]=parts[0].slice(0,-1)}}else{if(flagAlternative&&argText.indexOf(".")==-1)parts[0]+=".";while(precision>effectivePrecision++)parts[0]+="0"}argText=parts[0]+(parts.length>1?"e"+parts[1]:"");if(next==69)argText=argText.toUpperCase();if(currArg>=0){if(flagAlwaysSigned){argText="+"+argText}else if(flagPadSign){argText=" "+argText}}}while(argText.length<width){if(flagLeftAlign){argText+=" "}else{if(flagZeroPad&&(argText[0]=="-"||argText[0]=="+")){argText=argText[0]+"0"+argText.slice(1)}else{argText=(flagZeroPad?"0":" ")+argText}}}if(next<97)argText=argText.toUpperCase();argText.split("").forEach((function(chr){ret.push(chr.charCodeAt(0))}));break};case"s":{var arg=getNextArg("i8*");var argLength=arg?_strlen(arg):"(null)".length;if(precisionSet)argLength=Math.min(argLength,precision);if(!flagLeftAlign){while(argLength<width--){ret.push(32)}}if(arg){for(var i=0;i<argLength;i++){ret.push(HEAPU8[arg++>>0])}}else{ret=ret.concat(intArrayFromString("(null)".substr(0,argLength),true))}if(flagLeftAlign){while(argLength<width--){ret.push(32)}}break};case"c":{if(flagLeftAlign)ret.push(getNextArg("i8"));while(--width>0){ret.push(32)}if(!flagLeftAlign)ret.push(getNextArg("i8"));break};case"n":{var ptr=getNextArg("i32*");HEAP32[ptr>>2]=ret.length;break};case"%":{ret.push(curr);break};default:{for(var i=startTextIndex;i<textIndex+2;i++){ret.push(HEAP8[i>>0])}}}textIndex+=2}else{ret.push(curr);textIndex+=1}}return ret}function _fprintf(stream,format,varargs){var result=__formatString(format,varargs);var stack=Runtime.stackSave();var ret=_fwrite(allocate(result,"i8",ALLOC_STACK),1,result.length,stream);Runtime.stackRestore(stack);return ret}function _vfprintf(s,f,va_arg){return _fprintf(s,f,HEAP32[va_arg>>2])}var _stderr=allocate(1,"i32*",ALLOC_STATIC);___errno_state=Runtime.staticAlloc(4);HEAP32[___errno_state>>2]=0;_fputc.ret=allocate([0],"i8",ALLOC_STATIC);STACK_BASE=STACKTOP=Runtime.alignMemory(STATICTOP);staticSealed=true;STACK_MAX=STACK_BASE+TOTAL_STACK;DYNAMIC_BASE=DYNAMICTOP=Runtime.alignMemory(STACK_MAX);assert(DYNAMIC_BASE<TOTAL_MEMORY,"TOTAL_MEMORY not big enough for stack");var cttz_i8=allocate([8,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,6,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,7,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,6,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0],"i8",ALLOC_DYNAMIC);function invoke_viiiii(index,a1,a2,a3,a4,a5){try{Module["dynCall_viiiii"](index,a1,a2,a3,a4,a5)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_vid(index,a1,a2){try{Module["dynCall_vid"](index,a1,a2)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_vi(index,a1){try{Module["dynCall_vi"](index,a1)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiidii(index,a1,a2,a3,a4,a5,a6){try{Module["dynCall_viiidii"](index,a1,a2,a3,a4,a5,a6)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_vii(index,a1,a2){try{Module["dynCall_vii"](index,a1,a2)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_iiiiiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10){try{return Module["dynCall_iiiiiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_ii(index,a1){try{return Module["dynCall_ii"](index,a1)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viidi(index,a1,a2,a3,a4){try{Module["dynCall_viidi"](index,a1,a2,a3,a4)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viddiii(index,a1,a2,a3,a4,a5,a6){try{Module["dynCall_viddiii"](index,a1,a2,a3,a4,a5,a6)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_vidii(index,a1,a2,a3,a4){try{Module["dynCall_vidii"](index,a1,a2,a3,a4)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_iiiii(index,a1,a2,a3,a4){try{return Module["dynCall_iiiii"](index,a1,a2,a3,a4)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_vidi(index,a1,a2,a3){try{Module["dynCall_vidi"](index,a1,a2,a3)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_diiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8){try{return Module["dynCall_diiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiiiddddiid(index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11){try{Module["dynCall_viiiiddddiid"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_diiiii(index,a1,a2,a3,a4,a5){try{return Module["dynCall_diiiii"](index,a1,a2,a3,a4,a5)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_iiii(index,a1,a2,a3){try{return Module["dynCall_iiii"](index,a1,a2,a3)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiiiii(index,a1,a2,a3,a4,a5,a6){try{Module["dynCall_viiiiii"](index,a1,a2,a3,a4,a5,a6)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_iiid(index,a1,a2,a3){try{return Module["dynCall_iiid"](index,a1,a2,a3)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_di(index,a1){try{return Module["dynCall_di"](index,a1)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_iiiiiii(index,a1,a2,a3,a4,a5,a6){try{return Module["dynCall_iiiiiii"](index,a1,a2,a3,a4,a5,a6)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_diiidii(index,a1,a2,a3,a4,a5,a6){try{return Module["dynCall_diiidii"](index,a1,a2,a3,a4,a5,a6)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viidii(index,a1,a2,a3,a4,a5){try{Module["dynCall_viidii"](index,a1,a2,a3,a4,a5)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiiiiii(index,a1,a2,a3,a4,a5,a6,a7){try{Module["dynCall_viiiiiii"](index,a1,a2,a3,a4,a5,a6,a7)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8,a9){try{Module["dynCall_viiiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiiiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10){try{Module["dynCall_viiiiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_iii(index,a1,a2){try{return Module["dynCall_iii"](index,a1,a2)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_diii(index,a1,a2,a3){try{return Module["dynCall_diii"](index,a1,a2,a3)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_diiiiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10){try{return Module["dynCall_diiiiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiiid(index,a1,a2,a3,a4,a5){try{Module["dynCall_viiiid"](index,a1,a2,a3,a4,a5)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_diiiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8,a9){try{return Module["dynCall_diiiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_did(index,a1,a2){try{return Module["dynCall_did"](index,a1,a2)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiiidddddidi(index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12){try{Module["dynCall_viiiidddddidi"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_diidii(index,a1,a2,a3,a4,a5){try{return Module["dynCall_diidii"](index,a1,a2,a3,a4,a5)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_diiii(index,a1,a2,a3,a4){try{return Module["dynCall_diiii"](index,a1,a2,a3,a4)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_iiiiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8,a9){try{return Module["dynCall_iiiiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiid(index,a1,a2,a3,a4){try{Module["dynCall_viiid"](index,a1,a2,a3,a4)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viii(index,a1,a2,a3){try{Module["dynCall_viii"](index,a1,a2,a3)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_v(index){try{Module["dynCall_v"](index)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viid(index,a1,a2,a3){try{Module["dynCall_viid"](index,a1,a2,a3)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_iidid(index,a1,a2,a3,a4){try{return Module["dynCall_iidid"](index,a1,a2,a3,a4)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiii(index,a1,a2,a3,a4){try{Module["dynCall_viiii"](index,a1,a2,a3,a4)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}Module.asmGlobalArg={"Math":Math,"Int8Array":Int8Array,"Int16Array":Int16Array,"Int32Array":Int32Array,"Uint8Array":Uint8Array,"Uint16Array":Uint16Array,"Uint32Array":Uint32Array,"Float32Array":Float32Array,"Float64Array":Float64Array,"NaN":NaN,"Infinity":Infinity};Module.asmLibraryArg={"abort":abort,"assert":assert,"invoke_viiiii":invoke_viiiii,"invoke_vid":invoke_vid,"invoke_vi":invoke_vi,"invoke_viiidii":invoke_viiidii,"invoke_vii":invoke_vii,"invoke_iiiiiiiiiii":invoke_iiiiiiiiiii,"invoke_ii":invoke_ii,"invoke_viidi":invoke_viidi,"invoke_viddiii":invoke_viddiii,"invoke_vidii":invoke_vidii,"invoke_iiiii":invoke_iiiii,"invoke_vidi":invoke_vidi,"invoke_diiiiiiii":invoke_diiiiiiii,"invoke_viiiiddddiid":invoke_viiiiddddiid,"invoke_diiiii":invoke_diiiii,"invoke_iiii":invoke_iiii,"invoke_viiiiii":invoke_viiiiii,"invoke_iiid":invoke_iiid,"invoke_di":invoke_di,"invoke_iiiiiii":invoke_iiiiiii,"invoke_diiidii":invoke_diiidii,"invoke_viidii":invoke_viidii,"invoke_viiiiiii":invoke_viiiiiii,"invoke_viiiiiiiii":invoke_viiiiiiiii,"invoke_viiiiiiiiii":invoke_viiiiiiiiii,"invoke_iii":invoke_iii,"invoke_diii":invoke_diii,"invoke_diiiiiiiiii":invoke_diiiiiiiiii,"invoke_viiiid":invoke_viiiid,"invoke_diiiiiiiii":invoke_diiiiiiiii,"invoke_did":invoke_did,"invoke_viiiidddddidi":invoke_viiiidddddidi,"invoke_diidii":invoke_diidii,"invoke_diiii":invoke_diiii,"invoke_iiiiiiiiii":invoke_iiiiiiiiii,"invoke_viiid":invoke_viiid,"invoke_viii":invoke_viii,"invoke_v":invoke_v,"invoke_viid":invoke_viid,"invoke_iidid":invoke_iidid,"invoke_viiii":invoke_viiii,"_emscripten_asm_const_double":_emscripten_asm_const_double,"_cosf":_cosf,"_send":_send,"_sqrtf":_sqrtf,"___cxa_guard_acquire":___cxa_guard_acquire,"___setErrNo":___setErrNo,"_vfprintf":_vfprintf,"_atan2f":_atan2f,"__ZSt18uncaught_exceptionv":__ZSt18uncaught_exceptionv,"___cxa_guard_release":___cxa_guard_release,"_pwrite":_pwrite,"_acosf":_acosf,"_asinf":_asinf,"_fabsf":_fabsf,"_sbrk":_sbrk,"_llvm_pow_f32":_llvm_pow_f32,"___cxa_begin_catch":___cxa_begin_catch,"_sinf":_sinf,"_fileno":_fileno,"___resumeException":___resumeException,"___cxa_find_matching_catch":___cxa_find_matching_catch,"_sysconf":_sysconf,"__reallyNegative":__reallyNegative,"_pthread_getspecific":_pthread_getspecific,"_emscripten_memcpy_big":_emscripten_memcpy_big,"_pthread_once":_pthread_once,"_pthread_key_create":_pthread_key_create,"_write":_write,"___errno_location":___errno_location,"_pthread_setspecific":_pthread_setspecific,"_fputc":_fputc,"___cxa_throw":___cxa_throw,"_abort":_abort,"___cxa_allocate_exception":___cxa_allocate_exception,"_fwrite":_fwrite,"_time":_time,"_fprintf":_fprintf,"_gettimeofday":_gettimeofday,"__formatString":__formatString,"_llvm_trap":_llvm_trap,"___cxa_pure_virtual":___cxa_pure_virtual,"STACKTOP":STACKTOP,"STACK_MAX":STACK_MAX,"tempDoublePtr":tempDoublePtr,"ABORT":ABORT,"cttz_i8":cttz_i8,"_stderr":_stderr};// EMSCRIPTEN_START_ASM
var asm=(function(global,env,buffer) {
"use asm";var a=new global.Int8Array(buffer);var b=new global.Int16Array(buffer);var c=new global.Int32Array(buffer);var d=new global.Uint8Array(buffer);var e=new global.Uint16Array(buffer);var f=new global.Uint32Array(buffer);var g=new global.Float32Array(buffer);var h=new global.Float64Array(buffer);var i=env.STACKTOP|0;var j=env.STACK_MAX|0;var k=env.tempDoublePtr|0;var l=env.ABORT|0;var m=env.cttz_i8|0;var n=env._stderr|0;var o=0;var p=0;var q=0;var r=0;var s=global.NaN,t=global.Infinity;var u=0,v=0,w=0,x=0,y=0.0,z=0,A=0,B=0,C=0.0;var D=0;var E=0;var F=0;var G=0;var H=0;var I=0;var J=0;var K=0;var L=0;var M=0;var N=global.Math.floor;var O=global.Math.abs;var P=global.Math.sqrt;var Q=global.Math.pow;var R=global.Math.cos;var S=global.Math.sin;var T=global.Math.tan;var U=global.Math.acos;var V=global.Math.asin;var W=global.Math.atan;var X=global.Math.atan2;var Y=global.Math.exp;var Z=global.Math.log;var _=global.Math.ceil;var $=global.Math.imul;var aa=global.Math.min;var ba=global.Math.clz32;var ca=env.abort;var da=env.assert;var ea=env.invoke_viiiii;var fa=env.invoke_vid;var ga=env.invoke_vi;var ha=env.invoke_viiidii;var ia=env.invoke_vii;var ja=env.invoke_iiiiiiiiiii;var ka=env.invoke_ii;var la=env.invoke_viidi;var ma=env.invoke_viddiii;var na=env.invoke_vidii;var oa=env.invoke_iiiii;var pa=env.invoke_vidi;var qa=env.invoke_diiiiiiii;var ra=env.invoke_viiiiddddiid;var sa=env.invoke_diiiii;var ta=env.invoke_iiii;var ua=env.invoke_viiiiii;var va=env.invoke_iiid;var wa=env.invoke_di;var xa=env.invoke_iiiiiii;var ya=env.invoke_diiidii;var za=env.invoke_viidii;var Aa=env.invoke_viiiiiii;var Ba=env.invoke_viiiiiiiii;var Ca=env.invoke_viiiiiiiiii;var Da=env.invoke_iii;var Ea=env.invoke_diii;var Fa=env.invoke_diiiiiiiiii;var Ga=env.invoke_viiiid;var Ha=env.invoke_diiiiiiiii;var Ia=env.invoke_did;var Ja=env.invoke_viiiidddddidi;var Ka=env.invoke_diidii;var La=env.invoke_diiii;var Ma=env.invoke_iiiiiiiiii;var Na=env.invoke_viiid;var Oa=env.invoke_viii;var Pa=env.invoke_v;var Qa=env.invoke_viid;var Ra=env.invoke_iidid;var Sa=env.invoke_viiii;var Ta=env._emscripten_asm_const_double;var Ua=env._cosf;var Va=env._send;var Wa=env._sqrtf;var Xa=env.___cxa_guard_acquire;var Ya=env.___setErrNo;var Za=env._vfprintf;var _a=env._atan2f;var $a=env.__ZSt18uncaught_exceptionv;var ab=env.___cxa_guard_release;var bb=env._pwrite;var cb=env._acosf;var db=env._asinf;var eb=env._fabsf;var fb=env._sbrk;var gb=env._llvm_pow_f32;var hb=env.___cxa_begin_catch;var ib=env._sinf;var jb=env._fileno;var kb=env.___resumeException;var lb=env.___cxa_find_matching_catch;var mb=env._sysconf;var nb=env.__reallyNegative;var ob=env._pthread_getspecific;var pb=env._emscripten_memcpy_big;var qb=env._pthread_once;var rb=env._pthread_key_create;var sb=env._write;var tb=env.___errno_location;var ub=env._pthread_setspecific;var vb=env._fputc;var wb=env.___cxa_throw;var xb=env._abort;var yb=env.___cxa_allocate_exception;var zb=env._fwrite;var Ab=env._time;var Bb=env._fprintf;var Cb=env._gettimeofday;var Db=env.__formatString;var Eb=env._llvm_trap;var Fb=env.___cxa_pure_virtual;var Gb=0.0;
// EMSCRIPTEN_START_FUNCS
function uc(a){a=a|0;var b=0;b=i;i=i+a|0;i=i+15&-16;return b|0}function vc(){return i|0}function wc(a){a=a|0;i=a}function xc(a,b){a=a|0;b=b|0;if(!o){o=a;p=b}}function yc(b){b=b|0;a[k>>0]=a[b>>0];a[k+1>>0]=a[b+1>>0];a[k+2>>0]=a[b+2>>0];a[k+3>>0]=a[b+3>>0]}function zc(b){b=b|0;a[k>>0]=a[b>>0];a[k+1>>0]=a[b+1>>0];a[k+2>>0]=a[b+2>>0];a[k+3>>0]=a[b+3>>0];a[k+4>>0]=a[b+4>>0];a[k+5>>0]=a[b+5>>0];a[k+6>>0]=a[b+6>>0];a[k+7>>0]=a[b+7>>0]}function Ac(a){a=a|0;D=a}function Bc(){return D|0}function Cc(a){a=a|0;return 52}function Dc(a,b,c,d){a=a|0;b=+b;c=+c;d=+d;var e=0.0,f=0.0,h=0.0;e=+R(+b);f=+R(+c);h=+R(+d);b=+S(+b);c=+S(+c);d=+S(+d);g[a>>2]=f*h;g[a+4>>2]=c*(b*h)-e*d;g[a+8>>2]=c*(e*h)+b*d;g[a+12>>2]=0.0;g[a+16>>2]=f*d;g[a+20>>2]=c*(b*d)+e*h;g[a+24>>2]=c*(e*d)-b*h;g[a+28>>2]=0.0;g[a+32>>2]=-c;g[a+36>>2]=f*b;g[a+40>>2]=f*e;g[a+44>>2]=0.0;return}function Ec(a,b){a=a|0;b=b|0;var c=0;c=i;Fc(a,b);i=c;return}function Fc(a,b){a=a|0;b=b|0;var c=0,d=0.0,e=0.0,f=0.0,h=0,j=0.0,k=0,l=0;h=i;i=i+16|0;d=+g[a>>2];e=+g[a+20>>2];f=+g[a+40>>2];if(d+e+f>0.0){d=+P(+(d+e+f+1.0));g[h+12>>2]=d*.5;j=(+g[a+36>>2]-+g[a+24>>2])*(.5/d);g[h>>2]=j;f=(+g[a+8>>2]-+g[a+32>>2])*(.5/d);g[h+4>>2]=f;e=(+g[a+16>>2]-+g[a+4>>2])*(.5/d);g[h+8>>2]=e;d=d*.5;g[b>>2]=j;c=b+4|0;g[c>>2]=f;c=b+8|0;g[c>>2]=e;c=b+12|0;g[c>>2]=d;i=h;return}if(d<e)c=e<f?2:1;else c=d<f?2:0;l=((c+1|0)>>>0)%3|0;k=((c+2|0)>>>0)%3|0;j=+P(+(+g[a+(c<<4)+(c<<2)>>2]-+g[a+(l<<4)+(l<<2)>>2]-+g[a+(k<<4)+(k<<2)>>2]+1.0));g[h+(c<<2)>>2]=j*.5;g[h+12>>2]=(+g[a+(k<<4)+(l<<2)>>2]-+g[a+(l<<4)+(k<<2)>>2])*(.5/j);g[h+(l<<2)>>2]=(+g[a+(l<<4)+(c<<2)>>2]+ +g[a+(c<<4)+(l<<2)>>2])*(.5/j);g[h+(k<<2)>>2]=(+g[a+(k<<4)+(c<<2)>>2]+ +g[a+(c<<4)+(k<<2)>>2])*(.5/j);j=+g[h>>2];f=+g[h+4>>2];e=+g[h+8>>2];d=+g[h+12>>2];g[b>>2]=j;c=b+4|0;g[c>>2]=f;c=b+8|0;g[c>>2]=e;c=b+12|0;g[c>>2]=d;i=h;return}function Gc(a){a=a|0;var b=0;b=i;if(a)RE(a);i=b;return}function Hc(){var a=0,d=0,e=0;d=i;a=QE(8)|0;a:do if(!a){while(1){a=c[5230]|0;c[5230]=a+0;if(!a)break;qc[a&3]();a=QE(8)|0;if(a)break a}a=yb(4)|0;c[a>>2]=20816;wb(a|0,20864,207)}while(0);e=a;c[e>>2]=0;c[e+4>>2]=0;b[a+4>>1]=1;b[a+6>>1]=-1;c[a>>2]=1032;i=d;return a|0}function Ic(a,b,d,e,f,g,h,j){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0.0,l=0;l=i;k=+Tb[c[(c[a>>2]|0)+12>>2]&1](a,b,d,e,f,g,h,j);i=l;return +k}function Jc(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Jb[c[(c[a>>2]|0)+4>>2]&255](a);i=b;return}function Kc(a,b){a=a|0;b=b|0;var d=0,e=0;e=i;c[5108]=(c[5108]|0)+1;d=QE(95)|0;if(!d)d=0;else{c[(d+19&-16)+-4>>2]=d;d=d+19&-16}sx(d,a,b,1);i=e;return d|0}function Lc(a){a=a|0;var b=0,d=0;b=i;i=i+16|0;hb(a|0)|0;if(qb(20632,3)|0)lE(20640,b);a=ob(c[5156]|0)|0;if(((a|0)!=0?(d=c[a>>2]|0,(d|0)!=0):0)?((c[d+52>>2]|0)==1129074247?(c[d+48>>2]&-256|0)==1126902528:0):0)pE(c[d+12>>2]|0);a=c[5112]|0;c[5112]=a+0;pE(a)}function Mc(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;f=i;c[5108]=(c[5108]|0)+1;e=QE(95)|0;if(!e)e=0;else{c[(e+19&-16)+-4>>2]=e;e=e+19&-16}sx(e,a,b,d);i=f;return e|0}function Nc(a,b){a=a|0;b=b|0;var d=0;d=i;Lb[c[(c[a>>2]|0)+24>>2]&127](a,b);i=d;return}function Oc(a,b,d){a=a|0;b=+b;d=d|0;var e=0;e=i;Sb[c[(c[a>>2]|0)+32>>2]&15](a,b,d);i=e;return}function Pc(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Jb[c[(c[a>>2]|0)+4>>2]&255](a);i=b;return}function Qc(){var a=0,b=0;b=i;a=QE(196)|0;a:do if(!a){while(1){a=c[5230]|0;c[5230]=a+0;if(!a)break;qc[a&3]();a=QE(196)|0;if(a)break a}a=yb(4)|0;c[a>>2]=20816;wb(a|0,20864,207)}while(0);TB(a,0);i=b;return a|0}function Rc(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Jb[c[(c[a>>2]|0)+4>>2]&255](a);i=b;return}function Sc(a){a=a|0;var b=0;b=i;if(a)RE(a);i=b;return}function Tc(){var b=0,d=0;d=i;c[5108]=(c[5108]|0)+1;b=QE(215)|0;if(!b)b=0;else{c[(b+19&-16)+-4>>2]=b;b=b+19&-16}c[b>>2]=3976;a[b+20>>0]=1;c[b+16>>2]=0;c[b+8>>2]=0;c[b+12>>2]=0;a[b+40>>0]=1;c[b+36>>2]=0;c[b+28>>2]=0;c[b+32>>2]=0;a[b+60>>0]=1;c[b+56>>2]=0;c[b+48>>2]=0;c[b+52>>2]=0;a[b+80>>0]=1;c[b+76>>2]=0;c[b+68>>2]=0;c[b+72>>2]=0;a[b+100>>0]=1;c[b+96>>2]=0;c[b+88>>2]=0;c[b+92>>2]=0;a[b+120>>0]=1;c[b+116>>2]=0;c[b+108>>2]=0;c[b+112>>2]=0;a[b+140>>0]=1;c[b+136>>2]=0;c[b+128>>2]=0;c[b+132>>2]=0;a[b+160>>0]=1;c[b+156>>2]=0;c[b+148>>2]=0;c[b+152>>2]=0;a[b+180>>0]=1;c[b+176>>2]=0;c[b+168>>2]=0;c[b+172>>2]=0;c[b+192>>2]=0;i=d;return b|0}function Uc(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Jb[c[(c[a>>2]|0)+4>>2]&255](a);i=b;return}function Vc(a){a=a|0;return +(+g[a>>2])}function Wc(a,b){a=a|0;b=+b;g[a>>2]=b;return}function Xc(a){a=a|0;return c[a+4>>2]|0}function Yc(a,b){a=a|0;b=b|0;c[a+4>>2]=b;return}function Zc(a){a=a|0;return c[a+8>>2]|0}function _c(a,b){a=a|0;b=b|0;c[a+8>>2]=b;return}function $c(a){a=a|0;return +(+g[a+12>>2])}function ad(a,b){a=a|0;b=+b;g[a+12>>2]=b;return}function bd(b){b=b|0;return (a[b+16>>0]&1)!=0|0}function cd(b,c){b=b|0;c=c|0;a[b+16>>0]=c&1;return}function dd(b){b=b|0;return (a[b+24>>0]&1)!=0|0}function ed(b,c){b=b|0;c=c|0;a[b+24>>0]=c&1;return}function fd(b){b=b|0;return (a[b+25>>0]&1)!=0|0}function gd(b,c){b=b|0;c=c|0;a[b+25>>0]=c&1;return}function hd(b){b=b|0;return (a[b+26>>0]&1)!=0|0}function id(b,c){b=b|0;c=c|0;a[b+26>>0]=c&1;return}function jd(a){a=a|0;return +(+g[a+28>>2])}function kd(a,b){a=a|0;b=+b;g[a+28>>2]=b;return}function ld(b){b=b|0;return (a[b+32>>0]&1)!=0|0}function md(b,c){b=b|0;c=c|0;a[b+32>>0]=c&1;return}function nd(a){a=a|0;return +(+g[a+36>>2])}function od(a,b){a=a|0;b=+b;g[a+36>>2]=b;return}function pd(a){a=a|0;var b=0;b=i;if(a)RE(a);i=b;return}function qd(a,b){a=+a;b=+b;var d=0,e=0;e=i;c[5108]=(c[5108]|0)+1;d=QE(75)|0;if(!d)d=0;else{c[(d+19&-16)+-4>>2]=d;d=d+19&-16}c[d+8>>2]=0;g[d+12>>2]=1.0;g[d+16>>2]=1.0;g[d+20>>2]=1.0;g[d+24>>2]=0.0;g[d+44>>2]=.03999999910593033;c[d>>2]=14096;c[d+4>>2]=10;c[d+52>>2]=1;g[d+28>>2]=a;g[d+32>>2]=b*.5;g[d+36>>2]=a;g[d+40>>2]=0.0;i=e;return d|0}function rd(a,b){a=a|0;b=b|0;var d=0;d=i;Lb[c[(c[a>>2]|0)+24>>2]&127](a,b);i=d;return}function sd(a,b,d){a=a|0;b=+b;d=d|0;var e=0;e=i;Sb[c[(c[a>>2]|0)+32>>2]&15](a,b,d);i=e;return}function td(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Jb[c[(c[a>>2]|0)+4>>2]&255](a);i=b;return}function ud(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Jb[c[(c[a>>2]|0)+4>>2]&255](a);i=b;return}function vd(a,b){a=a|0;b=b|0;var d=0,e=0;e=i;c[5108]=(c[5108]|0)+1;d=QE(135)|0;if(!d)d=0;else{c[(d+19&-16)+-4>>2]=d;d=d+19&-16}MA(d,a,b,16384,0,0);i=e;return d|0}function wd(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;f=i;c[5108]=(c[5108]|0)+1;e=QE(135)|0;if(!e)e=0;else{c[(e+19&-16)+-4>>2]=e;e=e+19&-16}MA(e,a,b,d&65535,0,0);i=f;return e|0}function xd(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0;g=i;c[5108]=(c[5108]|0)+1;f=QE(135)|0;if(!f)f=0;else{c[(f+19&-16)+-4>>2]=f;f=f+19&-16}MA(f,a,b,d&65535,e,0);i=g;return f|0}function yd(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0;h=i;c[5108]=(c[5108]|0)+1;g=QE(135)|0;if(!g)g=0;else{c[(g+19&-16)+-4>>2]=g;g=g+19&-16}MA(g,a,b,d&65535,e,f);i=h;return g|0}function zd(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Jb[c[(c[a>>2]|0)+4>>2]&255](a);i=b;return}function Ad(){var b=0,d=0,e=0,f=0;e=i;c[5108]=(c[5108]|0)+1;b=QE(307)|0;if(!b)d=0;else{c[(b+19&-16)+-4>>2]=b;d=b+19&-16}g[d+164>>2]=1.0;g[d+168>>2]=1.0;g[d+172>>2]=1.0;g[d+176>>2]=0.0;c[d+180>>2]=0;g[d+184>>2]=999999984306749440.0;b=d+188|0;c[b+0>>2]=0;c[b+4>>2]=0;c[b+8>>2]=0;c[b+12>>2]=0;c[d+204>>2]=1;c[d+208>>2]=-1;c[d+212>>2]=-1;c[d+216>>2]=1;g[d+220>>2]=0.0;g[d+224>>2]=.5;g[d+228>>2]=0.0;g[d+232>>2]=0.0;c[d+240>>2]=0;g[d+244>>2]=1.0;b=d+248|0;c[b+0>>2]=0;c[b+4>>2]=0;c[b+8>>2]=0;c[b+12>>2]=0;g[d+4>>2]=1.0;b=d+8|0;c[b+0>>2]=0;c[b+4>>2]=0;c[b+8>>2]=0;c[b+12>>2]=0;g[d+24>>2]=1.0;b=d+28|0;c[b+0>>2]=0;c[b+4>>2]=0;c[b+8>>2]=0;c[b+12>>2]=0;g[d+44>>2]=1.0;b=d+48|0;c[b+0>>2]=0;c[b+4>>2]=0;c[b+8>>2]=0;c[b+12>>2]=0;c[b+16>>2]=0;a[d+280>>0]=1;c[d+276>>2]=0;c[d+268>>2]=0;c[d+272>>2]=0;c[d+236>>2]=4;c[d>>2]=5464;c[5108]=(c[5108]|0)+1;b=QE(95)|0;if(!b){f=0;b=d+284|0;c[b>>2]=f;i=e;return d|0}c[(b+19&-16)+-4>>2]=b;if(!(b+19&-16)){f=0;b=d+284|0;c[b>>2]=f;i=e;return d|0}wB(b+19&-16);f=b+19&-16;b=d+284|0;c[b>>2]=f;i=e;return d|0}function Bd(a,b,d){a=a|0;b=b|0;d=d|0;var e=0;e=i;c[a+164>>2]=c[b+0>>2];c[a+168>>2]=c[b+4>>2];c[a+172>>2]=c[b+8>>2];c[a+176>>2]=c[b+12>>2];if((!(+g[b>>2]!=1.0)?!(+g[b+4>>2]!=1.0):0)?!(+g[b+8>>2]!=1.0):0){d=0;b=a+180|0;c[b>>2]=d;i=e;return}b=a+180|0;c[b>>2]=d;i=e;return}function Cd(a){a=a|0;return c[a+192>>2]|0}function Dd(a,b){a=a|0;b=+b;g[a+184>>2]=b;return}function Ed(a,b){a=a|0;b=b|0;var d=0;d=i;if((c[a+216>>2]&-2|0)==4){i=d;return}c[a+216>>2]=b;i=d;return}function Fd(a,b){a=a|0;b=b|0;c[a+216>>2]=b;return}function Gd(a){a=a|0;var b=0;b=i;if(c[a+204>>2]&3){i=b;return}if((c[a+216>>2]&-2|0)!=4)c[a+216>>2]=1;g[a+220>>2]=0.0;i=b;return}function Hd(a,b){a=a|0;b=b|0;var d=0;d=i;if(!b?(c[a+204>>2]&3|0)!=0:0){i=d;return}if((c[a+216>>2]&-2|0)!=4)c[a+216>>2]=1;g[a+220>>2]=0.0;i=d;return}function Id(a){a=a|0;a=c[a+216>>2]|0;return ((a|0)==2?0:(a|0)!=5)|0}function Jd(a){a=a|0;return (c[a+204>>2]&2|0)!=0|0}function Kd(a,b){a=a|0;b=+b;c[a+260>>2]=(c[a+260>>2]|0)+1;g[a+228>>2]=b;return}function Ld(a,b){a=a|0;b=+b;c[a+260>>2]=(c[a+260>>2]|0)+1;g[a+224>>2]=b;return}function Md(a,b){a=a|0;b=+b;c[a+260>>2]=(c[a+260>>2]|0)+1;g[a+232>>2]=b;return}function Nd(a){a=a|0;return a+4|0}function Od(a){a=a|0;return c[a+204>>2]|0}function Pd(a,b){a=a|0;b=b|0;c[a+204>>2]=b;return}function Qd(a,b){a=a|0;b=b|0;c[a+260>>2]=(c[a+260>>2]|0)+1;c[a+4>>2]=c[b+0>>2];c[a+8>>2]=c[b+4>>2];c[a+12>>2]=c[b+8>>2];c[a+16>>2]=c[b+12>>2];c[a+20>>2]=c[b+16>>2];c[a+24>>2]=c[b+20>>2];c[a+28>>2]=c[b+24>>2];c[a+32>>2]=c[b+28>>2];c[a+36>>2]=c[b+32>>2];c[a+40>>2]=c[b+36>>2];c[a+44>>2]=c[b+40>>2];c[a+48>>2]=c[b+44>>2];c[a+52>>2]=c[b+48>>2];c[a+56>>2]=c[b+52>>2];c[a+60>>2]=c[b+56>>2];c[a+64>>2]=c[b+60>>2];return}function Rd(a,b){a=a|0;b=b|0;var d=0;d=i;Lb[c[(c[a>>2]|0)+12>>2]&127](a,b);i=d;return}function Sd(a,b){a=a|0;b=+b;g[a+252>>2]=b;return}function Td(a,b){a=a|0;b=+b;g[a+248>>2]=b;return}function Ud(a){a=a|0;return c[a+268>>2]|0}function Vd(a,b){a=a|0;b=b|0;return c[(c[a+276>>2]|0)+(b<<2)>>2]|0}function Wd(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Jb[c[(c[a>>2]|0)+8>>2]&255](a);i=b;return}function Xd(b,d,e){b=+b;d=d|0;e=e|0;var f=0,h=0;h=i;f=QE(140)|0;a:do if(!f){while(1){f=c[5230]|0;c[5230]=f+0;if(!f)break;qc[f&3]();f=QE(140)|0;if(f)break a}f=yb(4)|0;c[f>>2]=20816;wb(f|0,20864,207)}while(0);g[f>>2]=b;c[f+4>>2]=d;c[f+72>>2]=e;d=f+76|0;c[d+0>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;c[d+16>>2]=0;c[d+20>>2]=0;g[f+100>>2]=.5;g[f+104>>2]=0.0;g[f+108>>2]=0.0;g[f+112>>2]=.800000011920929;g[f+116>>2]=1.0;a[f+120>>0]=0;g[f+124>>2]=.004999999888241291;g[f+128>>2]=.009999999776482582;g[f+132>>2]=.009999999776482582;g[f+136>>2]=.009999999776482582;Sn(f+8|0);i=h;return f|0}function Yd(b,d,e,f){b=+b;d=d|0;e=e|0;f=f|0;var h=0,j=0;j=i;h=QE(140)|0;a:do if(!h){while(1){h=c[5230]|0;c[5230]=h+0;if(!h)break;qc[h&3]();h=QE(140)|0;if(h)break a}h=yb(4)|0;c[h>>2]=20816;wb(h|0,20864,207)}while(0);g[h>>2]=b;c[h+4>>2]=d;c[h+72>>2]=e;d=h+76|0;c[d+0>>2]=c[f+0>>2];c[d+4>>2]=c[f+4>>2];c[d+8>>2]=c[f+8>>2];c[d+12>>2]=c[f+12>>2];g[h+92>>2]=0.0;g[h+96>>2]=0.0;g[h+100>>2]=.5;g[h+104>>2]=0.0;g[h+108>>2]=0.0;g[h+112>>2]=.800000011920929;g[h+116>>2]=1.0;a[h+120>>0]=0;g[h+124>>2]=.004999999888241291;g[h+128>>2]=.009999999776482582;g[h+132>>2]=.009999999776482582;g[h+136>>2]=.009999999776482582;Sn(h+8|0);i=j;return h|0}function Zd(a){a=a|0;return +(+g[a+92>>2])}function _d(a,b){a=a|0;b=+b;g[a+92>>2]=b;return}function $d(a){a=a|0;return +(+g[a+96>>2])}function ae(a,b){a=a|0;b=+b;g[a+96>>2]=b;return}function be(a){a=a|0;return +(+g[a+100>>2])}function ce(a,b){a=a|0;b=+b;g[a+100>>2]=b;return}function de(a){a=a|0;return +(+g[a+104>>2])}function ee(a,b){a=a|0;b=+b;g[a+104>>2]=b;return}function fe(a){a=a|0;return +(+g[a+108>>2])}function ge(a,b){a=a|0;b=+b;g[a+108>>2]=b;return}function he(a){a=a|0;return +(+g[a+112>>2])}function ie(a,b){a=a|0;b=+b;g[a+112>>2]=b;return}function je(a){a=a|0;return +(+g[a+116>>2])}function ke(a,b){a=a|0;b=+b;g[a+116>>2]=b;return}function le(b){b=b|0;return (a[b+120>>0]&1)!=0|0}function me(b,c){b=b|0;c=c|0;a[b+120>>0]=c&1;return}function ne(a){a=a|0;return +(+g[a+124>>2])}function oe(a,b){a=a|0;b=+b;g[a+124>>2]=b;return}function pe(a){a=a|0;return +(+g[a+128>>2])}function qe(a,b){a=a|0;b=+b;g[a+128>>2]=b;return}function re(a){a=a|0;return +(+g[a+132>>2])}function se(a,b){a=a|0;b=+b;g[a+132>>2]=b;return}function te(a){a=a|0;return +(+g[a+136>>2])}function ue(a,b){a=a|0;b=+b;g[a+136>>2]=b;return}function ve(a){a=a|0;var b=0;b=i;if(a)RE(a);i=b;return}function we(a){a=a|0;return a+48|0}function xe(a){a=a|0;return a+32|0}function ye(a){a=a|0;return +(+g[a+80>>2])}function ze(a){a=a|0;return a|0}function Ae(a,b){a=a|0;b=b|0;c[a+0>>2]=c[b+0>>2];c[a+4>>2]=c[b+4>>2];c[a+8>>2]=c[b+8>>2];c[a+12>>2]=c[b+12>>2];return}function Be(a){a=a|0;return a+16|0}function Ce(a,b){a=a|0;b=b|0;c[a+16>>2]=c[b+0>>2];c[a+20>>2]=c[b+4>>2];c[a+24>>2]=c[b+8>>2];c[a+28>>2]=c[b+12>>2];return}function De(a){a=a|0;return a+32|0}function Ee(a,b){a=a|0;b=b|0;c[a+32>>2]=c[b+0>>2];c[a+36>>2]=c[b+4>>2];c[a+40>>2]=c[b+8>>2];c[a+44>>2]=c[b+12>>2];return}function Fe(a){a=a|0;return a+48|0}function Ge(a,b){a=a|0;b=b|0;c[a+48>>2]=c[b+0>>2];c[a+52>>2]=c[b+4>>2];c[a+56>>2]=c[b+8>>2];c[a+60>>2]=c[b+12>>2];return}function He(a){a=a|0;return a+64|0}function Ie(a,b){a=a|0;b=b|0;c[a+64>>2]=c[b+0>>2];c[a+68>>2]=c[b+4>>2];c[a+72>>2]=c[b+8>>2];c[a+76>>2]=c[b+12>>2];return}function Je(a){a=a|0;var b=0;b=i;if(a)RE(a);i=b;return}function Ke(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;f=i;c[5108]=(c[5108]|0)+1;e=QE(1331)|0;if(!e)e=0;else{c[(e+19&-16)+-4>>2]=e;e=e+19&-16}Aq(e,a,b,d);i=f;return e|0}function Le(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0;h=i;c[5108]=(c[5108]|0)+1;g=QE(1331)|0;if(!g)g=0;else{c[(g+19&-16)+-4>>2]=g;g=g+19&-16}zq(g,a,b,d,e,f);i=h;return g|0}function Me(a,b){a=a|0;b=b|0;c[a+680>>2]=c[b+0>>2];c[a+684>>2]=c[b+4>>2];c[a+688>>2]=c[b+8>>2];c[a+692>>2]=c[b+12>>2];return}function Ne(a,b){a=a|0;b=b|0;c[a+696>>2]=c[b+0>>2];c[a+700>>2]=c[b+4>>2];c[a+704>>2]=c[b+8>>2];c[a+708>>2]=c[b+12>>2];return}function Oe(a,b){a=a|0;b=b|0;var c=0.0,d=0,e=0;e=i;d=0;while(1){if((d|0)==3)break;c=+SE(+g[b+(d<<2)>>2],6.2831854820251465);if(!(c<-3.1415927410125732)){if(c>3.1415927410125732)c=c+-6.2831854820251465}else c=c+6.2831854820251465;g[a+(d<<6)+868>>2]=c;d=d+1|0}i=e;return}function Pe(a,b){a=a|0;b=b|0;var c=0.0,d=0,e=0;e=i;d=0;while(1){if((d|0)==3)break;c=+SE(+g[b+(d<<2)>>2],6.2831854820251465);if(!(c<-3.1415927410125732)){if(c>3.1415927410125732)c=c+-6.2831854820251465}else c=c+6.2831854820251465;g[a+(d<<6)+872>>2]=c;d=d+1|0}i=e;return}function Qe(b,c){b=b|0;c=c|0;a[b+21>>0]=c&1;return}function Re(a){a=a|0;return +(+g[a+16>>2])}function Se(a,b){a=a|0;b=+b;g[a+16>>2]=b;return}function Te(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Jb[c[(c[a>>2]|0)+4>>2]&255](a);i=b;return}function Ue(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Jb[c[(c[a>>2]|0)+4>>2]&255](a);i=b;return}function Ve(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Jb[c[(c[a>>2]|0)+4>>2]&255](a);i=b;return}function We(a,b,d){a=a|0;b=b|0;d=d|0;var e=0;e=i;c[a+164>>2]=c[b+0>>2];c[a+168>>2]=c[b+4>>2];c[a+172>>2]=c[b+8>>2];c[a+176>>2]=c[b+12>>2];if((!(+g[b>>2]!=1.0)?!(+g[b+4>>2]!=1.0):0)?!(+g[b+8>>2]!=1.0):0){d=0;b=a+180|0;c[b>>2]=d;i=e;return}b=a+180|0;c[b>>2]=d;i=e;return}function Xe(a){a=a|0;return c[a+192>>2]|0}function Ye(a,b){a=a|0;b=+b;g[a+184>>2]=b;return}function Ze(a,b){a=a|0;b=b|0;var d=0;d=i;if((c[a+216>>2]&-2|0)==4){i=d;return}c[a+216>>2]=b;i=d;return}function _e(a,b){a=a|0;b=b|0;c[a+216>>2]=b;return}function $e(a){a=a|0;var b=0;b=i;if(c[a+204>>2]&3){i=b;return}if((c[a+216>>2]&-2|0)!=4)c[a+216>>2]=1;g[a+220>>2]=0.0;i=b;return}function af(a,b){a=a|0;b=b|0;var d=0;d=i;if(!b?(c[a+204>>2]&3|0)!=0:0){i=d;return}if((c[a+216>>2]&-2|0)!=4)c[a+216>>2]=1;g[a+220>>2]=0.0;i=d;return}function bf(a){a=a|0;a=c[a+216>>2]|0;return ((a|0)==2?0:(a|0)!=5)|0}function cf(a){a=a|0;return (c[a+204>>2]&2|0)!=0|0}function df(a,b){a=a|0;b=+b;c[a+260>>2]=(c[a+260>>2]|0)+1;g[a+228>>2]=b;return}function ef(a,b){a=a|0;b=+b;c[a+260>>2]=(c[a+260>>2]|0)+1;g[a+224>>2]=b;return}function ff(a,b){a=a|0;b=+b;c[a+260>>2]=(c[a+260>>2]|0)+1;g[a+232>>2]=b;return}function gf(a){a=a|0;return a+4|0}function hf(a){a=a|0;return c[a+204>>2]|0}function jf(a,b){a=a|0;b=b|0;c[a+204>>2]=b;return}function kf(a,b){a=a|0;b=b|0;c[a+260>>2]=(c[a+260>>2]|0)+1;c[a+4>>2]=c[b+0>>2];c[a+8>>2]=c[b+4>>2];c[a+12>>2]=c[b+8>>2];c[a+16>>2]=c[b+12>>2];c[a+20>>2]=c[b+16>>2];c[a+24>>2]=c[b+20>>2];c[a+28>>2]=c[b+24>>2];c[a+32>>2]=c[b+28>>2];c[a+36>>2]=c[b+32>>2];c[a+40>>2]=c[b+36>>2];c[a+44>>2]=c[b+40>>2];c[a+48>>2]=c[b+44>>2];c[a+52>>2]=c[b+48>>2];c[a+56>>2]=c[b+52>>2];c[a+60>>2]=c[b+56>>2];c[a+64>>2]=c[b+60>>2];return}function lf(a,b){a=a|0;b=b|0;var d=0;d=i;Lb[c[(c[a>>2]|0)+12>>2]&127](a,b);i=d;return}function mf(a,b){a=a|0;b=+b;g[a+252>>2]=b;return}function nf(a,b){a=a|0;b=+b;g[a+248>>2]=b;return}function of(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Jb[c[(c[a>>2]|0)+8>>2]&255](a);i=b;return}function pf(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var h=0,j=0,k=0,l=0,m=0;m=i;c[5108]=(c[5108]|0)+1;f=QE(343)|0;if(!f)l=0;else{c[(f+19&-16)+-4>>2]=f;l=f+19&-16}a[l+20>>0]=1;c[l+16>>2]=0;c[l+8>>2]=0;c[l+12>>2]=0;c[l+24>>2]=b;g[l+28>>2]=0.0;c[l+32>>2]=0;c[l+36>>2]=1;g[l+40>>2]=1.0;a[l+44>>0]=1;c[l+48>>2]=0;a[l+52>>0]=0;a[l+53>>0]=1;a[l+54>>0]=1;g[l+56>>2]=.03999999910593033;a[l+60>>0]=0;g[l+64>>2]=0.0;c[l+68>>2]=d;c[l+72>>2]=0;a[l+76>>0]=1;c[l+80>>2]=0;c[l+84>>2]=0;c[l+88>>2]=0;g[l+92>>2]=.6000000238418579;g[l+96>>2]=1.0;g[l+100>>2]=.30000001192092896;g[l+104>>2]=.01666666753590107;g[l+108>>2]=0.0;g[l+116>>2]=20.0;c[l+112>>2]=10;g[l+124>>2]=.20000000298023224;g[l+128>>2]=.800000011920929;g[l+132>>2]=0.0;g[l+120>>2]=1.0;c[l+136>>2]=1;g[l+140>>2]=-.03999999910593033;g[l+144>>2]=.10000000149011612;g[l+148>>2]=0.0;g[l+152>>2]=.8500000238418579;c[l+156>>2]=260;c[l+160>>2]=2;c[l+164>>2]=128;g[l+168>>2]=100.0;g[l+172>>2]=1000000015047466219876688.0e6;c[l>>2]=1568;a[l+192>>0]=1;c[l+188>>2]=0;c[l+180>>2]=0;c[l+184>>2]=0;k=l+196|0;c[k>>2]=0;j=l+200|0;c[j>>2]=e;a[l+224>>0]=1;c[l+220>>2]=0;c[l+212>>2]=0;c[l+216>>2]=0;a[l+244>>0]=1;c[l+240>>2]=0;c[l+232>>2]=0;c[l+236>>2]=0;g[l+248>>2]=0.0;g[l+252>>2]=-10.0;f=l+256|0;a[l+274>>0]=0;a[l+275>>0]=0;c[f+0>>2]=0;c[f+4>>2]=0;c[f+8>>2]=0;c[f+12>>2]=0;a[l+292>>0]=1;c[l+288>>2]=0;c[l+280>>2]=0;c[l+284>>2]=0;c[l+296>>2]=0;a[l+300>>0]=1;a[l+320>>0]=1;c[l+316>>2]=0;c[l+308>>2]=0;c[l+312>>2]=0;if(!e){c[5108]=(c[5108]|0)+1;f=QE(215)|0;if(!f)d=0;else{c[(f+19&-16)+-4>>2]=f;d=f+19&-16}c[d>>2]=3976;a[d+20>>0]=1;c[d+16>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;a[d+40>>0]=1;c[d+36>>2]=0;c[d+28>>2]=0;c[d+32>>2]=0;a[d+60>>0]=1;c[d+56>>2]=0;c[d+48>>2]=0;c[d+52>>2]=0;a[d+80>>0]=1;c[d+76>>2]=0;c[d+68>>2]=0;c[d+72>>2]=0;a[d+100>>0]=1;c[d+96>>2]=0;c[d+88>>2]=0;c[d+92>>2]=0;a[d+120>>0]=1;c[d+116>>2]=0;c[d+108>>2]=0;c[d+112>>2]=0;a[d+140>>0]=1;c[d+136>>2]=0;c[d+128>>2]=0;c[d+132>>2]=0;a[d+160>>0]=1;c[d+156>>2]=0;c[d+148>>2]=0;c[d+152>>2]=0;a[d+180>>0]=1;c[d+176>>2]=0;c[d+168>>2]=0;c[d+172>>2]=0;c[d+192>>2]=0;c[j>>2]=d;a[l+273>>0]=1}else a[l+273>>0]=0;c[5108]=(c[5108]|0)+1;f=QE(87)|0;if((f|0)!=0?(h=f+19&-16,c[h+-4>>2]=f,(f+19&-16|0)!=0):0){c[(f+19&-16)>>2]=6920;a[h+20>>0]=1;c[h+16>>2]=0;c[h+8>>2]=0;c[h+12>>2]=0;a[h+40>>0]=1;c[h+36>>2]=0;c[h+28>>2]=0;c[h+32>>2]=0;a[h+60>>0]=1;c[h+56>>2]=0;c[h+48>>2]=0;c[h+52>>2]=0;a[h+64>>0]=1;f=f+19&-16}else f=0;c[l+204>>2]=f;a[l+272>>0]=1;c[5108]=(c[5108]|0)+1;d=QE(107)|0;if(!d){f=0;c[k>>2]=f;i=m;return l|0}f=d+19&-16;c[f+-4>>2]=d;if(!(d+19&-16)){f=0;c[k>>2]=f;i=m;return l|0}e=c[j>>2]|0;c[(d+19&-16)>>2]=2376;c[f+4>>2]=0;c[f+8>>2]=e;c[f+12>>2]=0;c[f+16>>2]=0;c[f+20>>2]=0;c[f+24>>2]=b;a[f+44>>0]=1;c[f+40>>2]=0;c[f+32>>2]=0;c[f+36>>2]=0;a[f+64>>0]=1;c[f+60>>2]=0;c[f+52>>2]=0;c[f+56>>2]=0;a[f+84>>0]=1;c[f+80>>2]=0;c[f+72>>2]=0;c[f+76>>2]=0;f=d+19&-16;c[k>>2]=f;i=m;return l|0}function qf(a,b){a=a|0;b=b|0;var d=0;d=i;Lb[c[(c[a>>2]|0)+72>>2]&127](a,b);i=d;return}function rf(b){b=b|0;var d=0;d=i;i=i+16|0;if((a[24]|0)==0?(Xa(24)|0)!=0:0)ab(24);Lb[c[(c[b>>2]|0)+76>>2]&127](d,b);c[2]=c[d+0>>2];c[3]=c[d+4>>2];c[4]=c[d+8>>2];c[5]=c[d+12>>2];i=d;return 8}function sf(a,b){a=a|0;b=b|0;var d=0;d=i;Lb[c[(c[a>>2]|0)+84>>2]&127](a,b);i=d;return}function tf(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0;f=i;tc[c[(c[a>>2]|0)+88>>2]&127](a,b,d,e);i=f;return}function uf(a,b){a=a|0;b=b|0;var d=0;d=i;Lb[c[(c[a>>2]|0)+92>>2]&127](a,b);i=d;return}function vf(a,b){a=a|0;b=b|0;var d=0;d=i;pc[c[(c[a>>2]|0)+56>>2]&127](a,b,0);i=d;return}function wf(a,b,d){a=a|0;b=b|0;d=d|0;var e=0;e=i;pc[c[(c[a>>2]|0)+56>>2]&127](a,b,d);i=e;return}function xf(a,b){a=a|0;b=b|0;var d=0;d=i;Lb[c[(c[a>>2]|0)+60>>2]&127](a,b);i=d;return}function yf(a,b){a=a|0;b=+b;var d=0;d=i;a=sc[c[(c[a>>2]|0)+52>>2]&1](a,b,1,.01666666753590107)|0;i=d;return a|0}function zf(a,b,d){a=a|0;b=+b;d=d|0;var e=0;e=i;d=sc[c[(c[a>>2]|0)+52>>2]&1](a,b,d,.01666666753590107)|0;i=e;return d|0}function Af(a,b,d,e){a=a|0;b=+b;d=d|0;e=+e;var f=0;f=i;d=sc[c[(c[a>>2]|0)+52>>2]&1](a,b,d,e)|0;i=f;return d|0}function Bf(a){a=a|0;return c[a+24>>2]|0}function Cf(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0;f=i;tc[c[(c[a>>2]|0)+32>>2]&127](a,b,d,e);i=f;return}function Df(a){a=a|0;var b=0;b=i;a=c[a+68>>2]|0;a=Nb[c[(c[a>>2]|0)+36>>2]&127](a)|0;i=b;return a|0}function Ef(a){a=a|0;return a+28|0}function Ff(a,b){a=a|0;b=b|0;var d=0;d=i;tc[c[(c[a>>2]|0)+36>>2]&127](a,b,2,-3);i=d;return}function Gf(a,b,d){a=a|0;b=b|0;d=d|0;var e=0;e=i;tc[c[(c[a>>2]|0)+36>>2]&127](a,b,d,-3);i=e;return}function Hf(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0;f=i;tc[c[(c[a>>2]|0)+36>>2]&127](a,b,d,e);i=f;return}function If(a){a=a|0;return c[a+68>>2]|0}function Jf(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=+f;var g=0;g=i;_u(a,b,c,d,e,f);i=g;return}function Kf(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0;e=i;$u(a,b,c,d);i=e;return}function Lf(a,b){a=a|0;b=b|0;var d=0;d=i;Lb[c[(c[a>>2]|0)+64>>2]&127](a,b);i=d;return}function Mf(b){b=b|0;var d=0,e=0,f=0;f=i;if((a[120]|0)==0?(Xa(120)|0)!=0:0){g[8]=.6000000238418579;g[9]=1.0;g[10]=.30000001192092896;g[11]=.01666666753590107;g[12]=0.0;g[14]=20.0;c[13]=10;g[16]=.20000000298023224;g[17]=.800000011920929;g[18]=0.0;g[15]=1.0;c[19]=1;g[20]=-.03999999910593033;g[21]=.10000000149011612;g[22]=0.0;g[23]=.8500000238418579;c[24]=260;c[25]=2;c[26]=128;g[27]=100.0;g[28]=1000000015047466219876688.0e6;ab(120)}e=32;b=b+92|0;d=e+84|0;do{c[e>>2]=c[b>>2];e=e+4|0;b=b+4|0}while((e|0)<(d|0));i=f;return 32}function Nf(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Jb[c[(c[a>>2]|0)+4>>2]&255](a);i=b;return}function Of(b){b=b|0;var d=0,e=0;e=i;c[5108]=(c[5108]|0)+1;d=QE(115)|0;if(!d)d=0;else{c[(d+19&-16)+-4>>2]=d;d=d+19&-16}c[d+8>>2]=0;g[d+12>>2]=1.0;g[d+16>>2]=1.0;g[d+20>>2]=1.0;g[d+24>>2]=0.0;g[d+44>>2]=.03999999910593033;c[d+52>>2]=0;g[d+56>>2]=1.0;g[d+60>>2]=1.0;g[d+64>>2]=1.0;g[d+68>>2]=0.0;g[d+72>>2]=-1.0;g[d+76>>2]=-1.0;g[d+80>>2]=-1.0;g[d+84>>2]=0.0;a[d+88>>0]=0;c[d>>2]=14600;c[d+92>>2]=b;c[d+4>>2]=3;oy(d);i=e;return d|0}function Pf(b,d){b=b|0;d=d|0;var e=0,f=0;f=i;c[5108]=(c[5108]|0)+1;e=QE(115)|0;if(!e)e=0;else{c[(e+19&-16)+-4>>2]=e;e=e+19&-16}c[e+8>>2]=0;g[e+12>>2]=1.0;g[e+16>>2]=1.0;g[e+20>>2]=1.0;g[e+24>>2]=0.0;g[e+44>>2]=.03999999910593033;c[e+52>>2]=0;g[e+56>>2]=1.0;g[e+60>>2]=1.0;g[e+64>>2]=1.0;g[e+68>>2]=0.0;g[e+72>>2]=-1.0;g[e+76>>2]=-1.0;g[e+80>>2]=-1.0;g[e+84>>2]=0.0;a[e+88>>0]=0;c[e>>2]=14600;c[e+92>>2]=b;c[e+4>>2]=3;if(!d){i=f;return e|0}oy(e);i=f;return e|0}function Qf(a,b){a=a|0;b=b|0;var d=0;d=i;Lb[c[(c[a>>2]|0)+24>>2]&127](a,b);i=d;return}function Rf(a,b,d){a=a|0;b=+b;d=d|0;var e=0;e=i;Sb[c[(c[a>>2]|0)+32>>2]&15](a,b,d);i=e;return}function Sf(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Jb[c[(c[a>>2]|0)+4>>2]&255](a);i=b;return}function Tf(a){a=a|0;return +g[a+4>>2]<1.0|0}function Uf(a){a=a|0;return b[a+8>>1]|0}function Vf(a,c){a=a|0;c=c|0;b[a+8>>1]=c;return}function Wf(a){a=a|0;return b[a+10>>1]|0}function Xf(a,c){a=a|0;c=c|0;b[a+10>>1]=c;return}function Yf(a){a=a|0;return +(+g[a+4>>2])}function Zf(a,b){a=a|0;b=+b;g[a+4>>2]=b;return}function _f(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Jb[c[(c[a>>2]|0)+4>>2]&255](a);i=b;return}function $f(b,d){b=b|0;d=d|0;var e=0,f=0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0;f=i;c[5108]=(c[5108]|0)+1;e=QE(379)|0;if(!e)e=0;else{c[(e+19&-16)+-4>>2]=e;e=e+19&-16}c[e+4>>2]=3;c[e>>2]=256;c[e+8>>2]=-1;c[e+12>>2]=-1;g[e+16>>2]=3402823466385288598117041.0e14;a[e+20>>0]=1;a[e+21>>0]=0;c[e+24>>2]=-1;c[e+28>>2]=b;ar();c[e+32>>2]=2960;g[e+36>>2]=0.0;g[e+40>>2]=.30000001192092896;c[e+44>>2]=0;c[e>>2]=2792;n=e+300|0;c[n+0>>2]=c[d+0>>2];c[n+4>>2]=c[d+4>>2];c[n+8>>2]=c[d+8>>2];c[n+12>>2]=c[d+12>>2];m=+g[d>>2];l=+g[d+4>>2];k=+g[d+8>>2];j=m*+g[b+20>>2]+l*+g[b+24>>2]+k*+g[b+28>>2]+ +g[b+56>>2];h=m*+g[b+36>>2]+l*+g[b+40>>2]+k*+g[b+44>>2]+ +g[b+60>>2];g[e+316>>2]=m*+g[b+4>>2]+l*+g[b+8>>2]+k*+g[b+12>>2]+ +g[b+52>>2];g[e+320>>2]=j;g[e+324>>2]=h;g[e+328>>2]=0.0;c[e+332>>2]=0;a[e+344>>0]=0;g[e+348>>2]=.30000001192092896;g[e+352>>2]=1.0;g[e+356>>2]=0.0;i=f;return e|0}function ag(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var h=0,j=0;j=i;c[5108]=(c[5108]|0)+1;h=QE(379)|0;if(!h)h=0;else{c[(h+19&-16)+-4>>2]=h;h=h+19&-16}c[h+4>>2]=3;c[h+8>>2]=-1;c[h+12>>2]=-1;g[h+16>>2]=3402823466385288598117041.0e14;a[h+20>>0]=1;a[h+21>>0]=0;c[h+24>>2]=-1;c[h+28>>2]=b;c[h+32>>2]=d;g[h+36>>2]=0.0;g[h+40>>2]=.30000001192092896;c[h+44>>2]=0;c[h>>2]=2792;b=h+300|0;c[b+0>>2]=c[e+0>>2];c[b+4>>2]=c[e+4>>2];c[b+8>>2]=c[e+8>>2];c[b+12>>2]=c[e+12>>2];b=h+316|0;c[b+0>>2]=c[f+0>>2];c[b+4>>2]=c[f+4>>2];c[b+8>>2]=c[f+8>>2];c[b+12>>2]=c[f+12>>2];c[h+332>>2]=0;a[h+344>>0]=0;g[h+348>>2]=.30000001192092896;g[h+352>>2]=1.0;g[h+356>>2]=0.0;i=j;return h|0}function bg(a,b){a=a|0;b=b|0;c[a+300>>2]=c[b+0>>2];c[a+304>>2]=c[b+4>>2];c[a+308>>2]=c[b+8>>2];c[a+312>>2]=c[b+12>>2];return}function cg(a,b){a=a|0;b=b|0;c[a+316>>2]=c[b+0>>2];c[a+320>>2]=c[b+4>>2];c[a+324>>2]=c[b+8>>2];c[a+328>>2]=c[b+12>>2];return}function dg(a){a=a|0;return a+300|0}function eg(a){a=a|0;return a+316|0}function fg(b,c){b=b|0;c=c|0;a[b+21>>0]=c&1;return}function gg(a){a=a|0;return +(+g[a+16>>2])}function hg(a,b){a=a|0;b=+b;g[a+16>>2]=b;return}function ig(a){a=a|0;return a+348|0}function jg(a,b){a=a|0;b=b|0;c[a+348>>2]=c[b+0>>2];c[a+352>>2]=c[b+4>>2];c[a+356>>2]=c[b+8>>2];return}function kg(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Jb[c[(c[a>>2]|0)+4>>2]&255](a);i=b;return}function lg(a,b){a=a|0;b=b|0;var d=0;d=i;Lb[c[(c[a>>2]|0)+8>>2]&127](a,b);i=d;return}function mg(a,b){a=a|0;b=b|0;var d=0;d=i;Lb[c[(c[a>>2]|0)+12>>2]&127](a,b);i=d;return}function ng(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Jb[c[(c[a>>2]|0)+4>>2]&255](a);i=b;return}function og(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,h=0,j=0,k=0,l=0,m=0;h=i;i=i+64|0;c[5108]=(c[5108]|0)+1;f=QE(1147)|0;if(!f)f=0;else{c[(f+19&-16)+-4>>2]=f;f=f+19&-16}ar();c[f+4>>2]=7;c[f+8>>2]=-1;c[f+12>>2]=-1;g[f+16>>2]=3402823466385288598117041.0e14;a[f+20>>0]=1;a[f+21>>0]=0;c[f+24>>2]=-1;k=f+28|0;c[k>>2]=2960;j=f+32|0;c[j>>2]=b;g[f+36>>2]=0.0;g[f+40>>2]=.30000001192092896;c[f+44>>2]=0;c[f>>2]=3592;a[f+48>>0]=0;l=f+116|0;c[l+0>>2]=c[d+0>>2];c[l+4>>2]=c[d+4>>2];c[l+8>>2]=c[d+8>>2];c[l+12>>2]=c[d+12>>2];m=f+132|0;c[m+0>>2]=c[d+16>>2];c[m+4>>2]=c[d+20>>2];c[m+8>>2]=c[d+24>>2];c[m+12>>2]=c[d+28>>2];m=f+148|0;c[m+0>>2]=c[d+32>>2];c[m+4>>2]=c[d+36>>2];c[m+8>>2]=c[d+40>>2];c[m+12>>2]=c[d+44>>2];m=f+164|0;c[m+0>>2]=c[d+48>>2];c[m+4>>2]=c[d+52>>2];c[m+8>>2]=c[d+56>>2];c[m+12>>2]=c[d+60>>2];a[f+180>>0]=e&1;d=f+52|0;ip(h,b+4|0,l);c[d+0>>2]=c[h+0>>2];c[d+4>>2]=c[h+4>>2];c[d+8>>2]=c[h+8>>2];c[d+12>>2]=c[h+12>>2];b=f+68|0;c[b+0>>2]=c[h+16>>2];c[b+4>>2]=c[h+20>>2];c[b+8>>2]=c[h+24>>2];c[b+12>>2]=c[h+28>>2];b=f+84|0;c[b+0>>2]=c[h+32>>2];c[b+4>>2]=c[h+36>>2];c[b+8>>2]=c[h+40>>2];c[b+12>>2]=c[h+44>>2];b=f+100|0;c[b+0>>2]=c[h+48>>2];c[b+4>>2]=c[h+52>>2];c[b+8>>2]=c[h+56>>2];c[b+12>>2]=c[h+60>>2];g[f+184>>2]=1.0;g[f+188>>2]=-1.0;g[f+192>>2]=0.0;g[f+196>>2]=0.0;g[f+200>>2]=1.0;g[f+204>>2]=.699999988079071;g[f+208>>2]=0.0;g[f+212>>2]=0.0;g[f+216>>2]=1.0;g[f+220>>2]=.699999988079071;g[f+224>>2]=0.0;g[f+228>>2]=0.0;g[f+264>>2]=1.0;g[f+268>>2]=.699999988079071;g[f+272>>2]=1.0;g[f+276>>2]=0.0;g[f+280>>2]=1.0;g[f+284>>2]=.699999988079071;g[f+288>>2]=1.0;g[f+292>>2]=0.0;g[f+232>>2]=1.0;g[f+236>>2]=.699999988079071;g[f+240>>2]=1.0;g[f+244>>2]=0.0;g[f+248>>2]=1.0;g[f+252>>2]=.699999988079071;g[f+256>>2]=1.0;g[f+260>>2]=0.0;a[f+1096>>0]=0;b=f+1100|0;g[f+1116>>2]=0.0;g[f+1120>>2]=0.0;g[f+1124>>2]=0.0;c[f+300>>2]=0;c[b+0>>2]=0;c[b+4>>2]=0;c[b+8>>2]=0;a[b+12>>0]=0;a[f+49>>0]=1;cr(f,(c[k>>2]|0)+4|0,(c[j>>2]|0)+4|0);i=h;return f|0}function pg(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var j=0,k=0,l=0;k=i;c[5108]=(c[5108]|0)+1;j=QE(1147)|0;if(!j)j=0;else{c[(j+19&-16)+-4>>2]=j;j=j+19&-16}c[j+4>>2]=7;c[j+8>>2]=-1;c[j+12>>2]=-1;g[j+16>>2]=3402823466385288598117041.0e14;a[j+20>>0]=1;a[j+21>>0]=0;c[j+24>>2]=-1;l=j+28|0;c[l>>2]=b;b=j+32|0;c[b>>2]=d;g[j+36>>2]=0.0;g[j+40>>2]=.30000001192092896;c[j+44>>2]=0;c[j>>2]=3592;a[j+48>>0]=0;d=j+52|0;c[d+0>>2]=c[e+0>>2];c[d+4>>2]=c[e+4>>2];c[d+8>>2]=c[e+8>>2];c[d+12>>2]=c[e+12>>2];d=j+68|0;c[d+0>>2]=c[e+16>>2];c[d+4>>2]=c[e+20>>2];c[d+8>>2]=c[e+24>>2];c[d+12>>2]=c[e+28>>2];d=j+84|0;c[d+0>>2]=c[e+32>>2];c[d+4>>2]=c[e+36>>2];c[d+8>>2]=c[e+40>>2];c[d+12>>2]=c[e+44>>2];d=j+100|0;c[d+0>>2]=c[e+48>>2];c[d+4>>2]=c[e+52>>2];c[d+8>>2]=c[e+56>>2];c[d+12>>2]=c[e+60>>2];d=j+116|0;c[d+0>>2]=c[f+0>>2];c[d+4>>2]=c[f+4>>2];c[d+8>>2]=c[f+8>>2];c[d+12>>2]=c[f+12>>2];d=j+132|0;c[d+0>>2]=c[f+16>>2];c[d+4>>2]=c[f+20>>2];c[d+8>>2]=c[f+24>>2];c[d+12>>2]=c[f+28>>2];d=j+148|0;c[d+0>>2]=c[f+32>>2];c[d+4>>2]=c[f+36>>2];c[d+8>>2]=c[f+40>>2];c[d+12>>2]=c[f+44>>2];d=j+164|0;c[d+0>>2]=c[f+48>>2];c[d+4>>2]=c[f+52>>2];c[d+8>>2]=c[f+56>>2];c[d+12>>2]=c[f+60>>2];a[j+180>>0]=h&1;g[j+184>>2]=1.0;g[j+188>>2]=-1.0;g[j+192>>2]=0.0;g[j+196>>2]=0.0;g[j+200>>2]=1.0;g[j+204>>2]=.699999988079071;g[j+208>>2]=0.0;g[j+212>>2]=0.0;g[j+216>>2]=1.0;g[j+220>>2]=.699999988079071;g[j+224>>2]=0.0;g[j+228>>2]=0.0;g[j+264>>2]=1.0;g[j+268>>2]=.699999988079071;g[j+272>>2]=1.0;g[j+276>>2]=0.0;g[j+280>>2]=1.0;g[j+284>>2]=.699999988079071;g[j+288>>2]=1.0;g[j+292>>2]=0.0;g[j+232>>2]=1.0;g[j+236>>2]=.699999988079071;g[j+240>>2]=1.0;g[j+244>>2]=0.0;g[j+248>>2]=1.0;g[j+252>>2]=.699999988079071;g[j+256>>2]=1.0;g[j+260>>2]=0.0;a[j+1096>>0]=0;d=j+1100|0;g[j+1116>>2]=0.0;g[j+1120>>2]=0.0;g[j+1124>>2]=0.0;c[j+300>>2]=0;c[d+0>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;a[d+12>>0]=0;a[j+49>>0]=1;cr(j,(c[l>>2]|0)+4|0,(c[b>>2]|0)+4|0);i=k;return j|0}function qg(a,b){a=a|0;b=+b;g[a+184>>2]=b;return}function rg(a,b){a=a|0;b=+b;g[a+188>>2]=b;return}function sg(a,b){a=a|0;b=+b;var c=0;c=i;b=+SE(b,6.2831854820251465);if(!(b<-3.1415927410125732)){if(b>3.1415927410125732)b=b+-6.2831854820251465}else b=b+6.2831854820251465;g[a+192>>2]=b;i=c;return}function tg(a,b){a=a|0;b=+b;var c=0;c=i;b=+SE(b,6.2831854820251465);if(!(b<-3.1415927410125732)){if(b>3.1415927410125732)b=b+-6.2831854820251465}else b=b+6.2831854820251465;g[a+196>>2]=b;i=c;return}function ug(b,c){b=b|0;c=c|0;a[b+21>>0]=c&1;return}function vg(a){a=a|0;return +(+g[a+16>>2])}function wg(a,b){a=a|0;b=+b;g[a+16>>2]=b;return}function xg(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Jb[c[(c[a>>2]|0)+4>>2]&255](a);i=b;return}function yg(b,d){b=b|0;d=d|0;var e=0,f=0,h=0,j=0,k=0;f=i;c[5108]=(c[5108]|0)+1;e=QE(627)|0;if(!e)e=0;else{c[(e+19&-16)+-4>>2]=e;e=e+19&-16}c[e+4>>2]=5;c[e>>2]=256;c[e+8>>2]=-1;c[e+12>>2]=-1;g[e+16>>2]=3402823466385288598117041.0e14;a[e+20>>0]=1;a[e+21>>0]=0;c[e+24>>2]=-1;c[e+28>>2]=b;ar();c[e+32>>2]=2960;g[e+36>>2]=0.0;g[e+40>>2]=.30000001192092896;c[e+44>>2]=0;c[e>>2]=3712;k=e+300|0;c[k+0>>2]=c[d+0>>2];c[k+4>>2]=c[d+4>>2];c[k+8>>2]=c[d+8>>2];c[k+12>>2]=c[d+12>>2];j=e+316|0;c[j+0>>2]=c[d+16>>2];c[j+4>>2]=c[d+20>>2];c[j+8>>2]=c[d+24>>2];c[j+12>>2]=c[d+28>>2];h=e+332|0;c[h+0>>2]=c[d+32>>2];c[h+4>>2]=c[d+36>>2];c[h+8>>2]=c[d+40>>2];c[h+12>>2]=c[d+44>>2];b=e+348|0;c[b+0>>2]=c[d+48>>2];c[b+4>>2]=c[d+52>>2];c[b+8>>2]=c[d+56>>2];c[b+12>>2]=c[d+60>>2];b=e+364|0;a[e+527>>0]=0;c[b+0>>2]=c[k+0>>2];c[b+4>>2]=c[k+4>>2];c[b+8>>2]=c[k+8>>2];c[b+12>>2]=c[k+12>>2];b=e+380|0;c[b+0>>2]=c[j+0>>2];c[b+4>>2]=c[j+4>>2];c[b+8>>2]=c[j+8>>2];c[b+12>>2]=c[j+12>>2];b=e+396|0;c[b+0>>2]=c[h+0>>2];c[b+4>>2]=c[h+4>>2];c[b+8>>2]=c[h+8>>2];c[b+12>>2]=c[h+12>>2];b=e+412|0;a[e+524>>0]=0;a[e+525>>0]=0;a[e+526>>0]=0;a[e+552>>0]=0;c[b+0>>2]=0;c[b+4>>2]=0;c[b+8>>2]=0;c[b+12>>2]=0;g[e+572>>2]=-1.0;g[e+444>>2]=999999984306749440.0;g[e+448>>2]=999999984306749440.0;g[e+452>>2]=999999984306749440.0;g[e+428>>2]=1.0;g[e+432>>2]=.30000001192092896;g[e+436>>2]=1.0;g[e+440>>2]=.009999999776482582;g[e+456>>2]=.05000000074505806;c[e+592>>2]=0;g[e+596>>2]=0.0;g[e+600>>2]=.699999988079071;g[e+604>>2]=0.0;i=f;return e|0}function zg(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var h=0,j=0;j=i;c[5108]=(c[5108]|0)+1;h=QE(627)|0;if(!h)h=0;else{c[(h+19&-16)+-4>>2]=h;h=h+19&-16}c[h+4>>2]=5;c[h+8>>2]=-1;c[h+12>>2]=-1;g[h+16>>2]=3402823466385288598117041.0e14;a[h+20>>0]=1;a[h+21>>0]=0;c[h+24>>2]=-1;c[h+28>>2]=b;c[h+32>>2]=d;g[h+36>>2]=0.0;g[h+40>>2]=.30000001192092896;c[h+44>>2]=0;c[h>>2]=3712;b=h+300|0;c[b+0>>2]=c[e+0>>2];c[b+4>>2]=c[e+4>>2];c[b+8>>2]=c[e+8>>2];c[b+12>>2]=c[e+12>>2];b=h+316|0;c[b+0>>2]=c[e+16>>2];c[b+4>>2]=c[e+20>>2];c[b+8>>2]=c[e+24>>2];c[b+12>>2]=c[e+28>>2];b=h+332|0;c[b+0>>2]=c[e+32>>2];c[b+4>>2]=c[e+36>>2];c[b+8>>2]=c[e+40>>2];c[b+12>>2]=c[e+44>>2];b=h+348|0;c[b+0>>2]=c[e+48>>2];c[b+4>>2]=c[e+52>>2];c[b+8>>2]=c[e+56>>2];c[b+12>>2]=c[e+60>>2];b=h+364|0;c[b+0>>2]=c[f+0>>2];c[b+4>>2]=c[f+4>>2];c[b+8>>2]=c[f+8>>2];c[b+12>>2]=c[f+12>>2];b=h+380|0;c[b+0>>2]=c[f+16>>2];c[b+4>>2]=c[f+20>>2];c[b+8>>2]=c[f+24>>2];c[b+12>>2]=c[f+28>>2];b=h+396|0;c[b+0>>2]=c[f+32>>2];c[b+4>>2]=c[f+36>>2];c[b+8>>2]=c[f+40>>2];c[b+12>>2]=c[f+44>>2];b=h+412|0;c[b+0>>2]=c[f+48>>2];c[b+4>>2]=c[f+52>>2];c[b+8>>2]=c[f+56>>2];c[b+12>>2]=c[f+60>>2];b=h+524|0;a[h+552>>0]=0;a[b>>0]=0;a[b+1>>0]=0;a[b+2>>0]=0;a[b+3>>0]=0;g[h+572>>2]=-1.0;g[h+444>>2]=999999984306749440.0;g[h+448>>2]=999999984306749440.0;g[h+452>>2]=999999984306749440.0;g[h+428>>2]=1.0;g[h+432>>2]=.30000001192092896;g[h+436>>2]=1.0;g[h+440>>2]=.009999999776482582;g[h+456>>2]=.05000000074505806;c[h+592>>2]=0;g[h+596>>2]=0.0;g[h+600>>2]=.699999988079071;g[h+604>>2]=0.0;i=j;return h|0}function Ag(a,b,c){a=a|0;b=b|0;c=+c;var d=0;d=i;if((b|0)==3)g[a+452>>2]=c;else if((b|0)==4)g[a+448>>2]=c;else if((b|0)==5)g[a+444>>2]=c;i=d;return}function Bg(b,c){b=b|0;c=c|0;a[b+524>>0]=c&1;return}function Cg(a,b){a=a|0;b=+b;g[a+440>>2]=b;return}function Dg(b,c){b=b|0;c=c|0;a[b+552>>0]=c&1;return}function Eg(b,c){b=b|0;c=+c;g[b+572>>2]=c;a[b+553>>0]=0;return}function Fg(b,c){b=b|0;c=+c;g[b+572>>2]=c;a[b+553>>0]=1;return}function Gg(a,b){a=a|0;b=b|0;var c=0,d=0.0,e=0.0,f=0.0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0;c=i;i=i+48|0;Fc(a+364|0,c+16|0);h=-+g[c+16>>2];e=-+g[c+20>>2];m=-+g[c+24>>2];l=+g[c+28>>2];f=+g[b>>2];n=+g[b+12>>2];k=+g[b+8>>2];j=+g[b+4>>2];Fc(a+300|0,c);p=+g[c>>2];q=+g[c+12>>2];d=+g[c+8>>2];o=+g[c+4>>2];g[c+32>>2]=p*(l*n-f*h-j*e-k*m)+(l*f+n*h+k*e-j*m)*q+(f*m+(n*e+l*j)-k*h)*d-(n*m+l*k+j*h-f*e)*o;g[c+36>>2]=p*(n*m+l*k+j*h-f*e)+(q*(f*m+(n*e+l*j)-k*h)+(l*n-f*h-j*e-k*m)*o)-(l*f+n*h+k*e-j*m)*d;g[c+40>>2]=q*(n*m+l*k+j*h-f*e)+(l*n-f*h-j*e-k*m)*d+(l*f+n*h+k*e-j*m)*o-p*(f*m+(n*e+l*j)-k*h);g[c+44>>2]=(l*n-f*h-j*e-k*m)*q-p*(l*f+n*h+k*e-j*m)-(f*m+(n*e+l*j)-k*h)*o-(n*m+l*k+j*h-f*e)*d;qr(a,c+32|0);i=c;return}function Hg(a,b){a=a|0;b=b|0;var c=0;c=i;qr(a,b);i=c;return}function Ig(b,c){b=b|0;c=c|0;a[b+21>>0]=c&1;return}function Jg(a){a=a|0;return +(+g[a+16>>2])}function Kg(a,b){a=a|0;b=+b;g[a+16>>2]=b;return}function Lg(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Jb[c[(c[a>>2]|0)+4>>2]&255](a);i=b;return}function Mg(a,b){a=+a;b=+b;var d=0,e=0;e=i;c[5108]=(c[5108]|0)+1;d=QE(95)|0;if(!d)d=0;else{c[(d+19&-16)+-4>>2]=d;d=d+19&-16}c[d+8>>2]=0;g[d+12>>2]=1.0;g[d+16>>2]=1.0;g[d+20>>2]=1.0;g[d+24>>2]=0.0;g[d+44>>2]=.03999999910593033;c[d>>2]=11560;g[d+56>>2]=a;g[d+60>>2]=b;c[d+4>>2]=11;c[d+64>>2]=0;c[d+68>>2]=1;c[d+72>>2]=2;g[d+28>>2]=a;g[d+32>>2]=b;g[d+36>>2]=a;g[d+52>>2]=a/+P(+(a*a+b*b));i=e;return d|0}function Ng(a,b){a=a|0;b=b|0;var d=0;d=i;Lb[c[(c[a>>2]|0)+24>>2]&127](a,b);i=d;return}function Og(a,b,d){a=a|0;b=+b;d=d|0;var e=0;e=i;Sb[c[(c[a>>2]|0)+32>>2]&15](a,b,d);i=e;return}function Pg(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Jb[c[(c[a>>2]|0)+4>>2]&255](a);i=b;return}function Qg(a,b){a=a|0;b=b|0;var d=0;d=i;Lb[c[(c[a>>2]|0)+24>>2]&127](a,b);i=d;return}function Rg(a,b,d){a=a|0;b=+b;d=d|0;var e=0;e=i;Sb[c[(c[a>>2]|0)+32>>2]&15](a,b,d);i=e;return}function Sg(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Jb[c[(c[a>>2]|0)+4>>2]&255](a);i=b;return}function Tg(){var a=0,b=0;b=i;i=i+32|0;a=QE(92)|0;a:do if(!a){while(1){a=c[5230]|0;c[5230]=a+0;if(!a)break;qc[a&3]();a=QE(92)|0;if(a)break a}a=yb(4)|0;c[a>>2]=20816;wb(a|0,20864,207)}while(0);c[b>>2]=0;c[b+4>>2]=0;c[b+8>>2]=4096;c[b+12>>2]=4096;c[b+16>>2]=0;c[b+20>>2]=1;lt(a,b);i=b;return a|0}function Ug(a){a=a|0;var b=0,d=0;d=i;b=QE(92)|0;a:do if(!b){while(1){b=c[5230]|0;c[5230]=b+0;if(!b)break;qc[b&3]();b=QE(92)|0;if(b)break a}b=yb(4)|0;c[b>>2]=20816;wb(b|0,20864,207)}while(0);lt(b,a);i=d;return b|0}function Vg(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Jb[c[(c[a>>2]|0)+4>>2]&255](a);i=b;return}function Wg(a,b,d,e,f,g,h,j){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0.0,l=0;l=i;k=+Tb[c[(c[a>>2]|0)+12>>2]&1](a,b,d,e,f,g,h,j);i=l;return +k}function Xg(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Jb[c[(c[a>>2]|0)+4>>2]&255](a);i=b;return}function Yg(a,b){a=+a;b=+b;var d=0,e=0;e=i;c[5108]=(c[5108]|0)+1;d=QE(95)|0;if(!d)d=0;else{c[(d+19&-16)+-4>>2]=d;d=d+19&-16}c[d+8>>2]=0;g[d+12>>2]=1.0;g[d+16>>2]=1.0;g[d+20>>2]=1.0;g[d+24>>2]=0.0;g[d+44>>2]=.03999999910593033;g[d+56>>2]=a;g[d+60>>2]=b;c[d+4>>2]=11;g[d+52>>2]=a/+P(+(a*a+b*b));c[d>>2]=11664;c[d+64>>2]=0;c[d+68>>2]=2;c[d+72>>2]=1;g[d+28>>2]=a;g[d+36>>2]=b;g[d+32>>2]=a;i=e;return d|0}function Zg(a,b){a=a|0;b=b|0;var d=0;d=i;Lb[c[(c[a>>2]|0)+24>>2]&127](a,b);i=d;return}function _g(a,b,d){a=a|0;b=+b;d=d|0;var e=0;e=i;Sb[c[(c[a>>2]|0)+32>>2]&15](a,b,d);i=e;return}function $g(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Jb[c[(c[a>>2]|0)+4>>2]&255](a);i=b;return}function ah(a,b){a=+a;b=+b;var d=0,e=0;e=i;c[5108]=(c[5108]|0)+1;d=QE(95)|0;if(!d)d=0;else{c[(d+19&-16)+-4>>2]=d;d=d+19&-16}c[d+8>>2]=0;g[d+12>>2]=1.0;g[d+16>>2]=1.0;g[d+20>>2]=1.0;g[d+24>>2]=0.0;g[d+44>>2]=.03999999910593033;g[d+56>>2]=a;g[d+60>>2]=b;c[d+4>>2]=11;g[d+52>>2]=a/+P(+(a*a+b*b));c[d>>2]=11768;c[d+64>>2]=1;c[d+68>>2]=0;c[d+72>>2]=2;g[d+32>>2]=a;g[d+28>>2]=b;g[d+36>>2]=a;i=e;return d|0}function bh(a,b){a=a|0;b=b|0;var d=0;d=i;Lb[c[(c[a>>2]|0)+24>>2]&127](a,b);i=d;return}function ch(a,b,d){a=a|0;b=+b;d=d|0;var e=0;e=i;Sb[c[(c[a>>2]|0)+32>>2]&15](a,b,d);i=e;return}function dh(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Jb[c[(c[a>>2]|0)+4>>2]&255](a);i=b;return}function eh(){var a=0,b=0;b=i;c[5108]=(c[5108]|0)+1;a=QE(191)|0;if(!a){a=0;BA(a,1,1);i=b;return a|0}c[(a+19&-16)+-4>>2]=a;a=a+19&-16;BA(a,1,1);i=b;return a|0}function fh(a){a=a|0;var b=0,d=0;d=i;c[5108]=(c[5108]|0)+1;b=QE(191)|0;if(!b){b=0;BA(b,a,1);i=d;return b|0}c[(b+19&-16)+-4>>2]=b;b=b+19&-16;BA(b,a,1);i=d;return b|0}function gh(a,b){a=a|0;b=b|0;var d=0,e=0;e=i;c[5108]=(c[5108]|0)+1;d=QE(191)|0;if(!d){d=0;BA(d,a,b);i=e;return d|0}c[(d+19&-16)+-4>>2]=d;d=d+19&-16;BA(d,a,b);i=e;return d|0}function hh(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0;f=i;g=c[a+32>>2]|0;c[g>>2]=(c[g>>2]|0)+1;CA(a,DA(a,b,0)|0);CA(a,DA(a,d,0)|0);CA(a,DA(a,e,0)|0);i=f;return}function ih(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0;g=i;h=c[a+32>>2]|0;c[h>>2]=(c[h>>2]|0)+1;CA(a,DA(a,b,f)|0);CA(a,DA(a,d,f)|0);CA(a,DA(a,e,f)|0);i=g;return}function jh(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Jb[c[(c[a>>2]|0)+4>>2]&255](a);i=b;return}function kh(){var b=0,d=0;d=i;c[5108]=(c[5108]|0)+1;b=QE(131)|0;if(!b)b=0;else{c[(b+19&-16)+-4>>2]=b;b=b+19&-16}c[b+8>>2]=0;g[b+12>>2]=1.0;g[b+16>>2]=1.0;g[b+20>>2]=1.0;g[b+24>>2]=0.0;g[b+44>>2]=.03999999910593033;c[b+52>>2]=0;g[b+56>>2]=1.0;g[b+60>>2]=1.0;g[b+64>>2]=1.0;g[b+68>>2]=0.0;g[b+72>>2]=-1.0;g[b+76>>2]=-1.0;g[b+80>>2]=-1.0;g[b+84>>2]=0.0;a[b+88>>0]=0;c[b>>2]=13808;a[b+108>>0]=1;c[b+104>>2]=0;c[b+100>>2]=0;c[b+4>>2]=4;c[b+96>>2]=0;oy(b);i=d;return b|0}function lh(a,b){a=a|0;b=b|0;var c=0;c=i;Hy(a,b,1);i=c;return}function mh(a,b,c){a=a|0;b=b|0;c=c|0;var d=0;d=i;Hy(a,b,c);i=d;return}function nh(a,b){a=a|0;b=b|0;var d=0;d=i;Lb[c[(c[a>>2]|0)+24>>2]&127](a,b);i=d;return}function oh(a,b,d){a=a|0;b=+b;d=d|0;var e=0;e=i;Sb[c[(c[a>>2]|0)+32>>2]&15](a,b,d);i=e;return}function ph(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Jb[c[(c[a>>2]|0)+4>>2]&255](a);i=b;return}function qh(){var b=0,d=0,e=0;d=i;c[5108]=(c[5108]|0)+1;b=QE(791)|0;if(!b)b=0;else{c[(b+19&-16)+-4>>2]=b;b=b+19&-16}c[b>>2]=1025;c[b+116>>2]=0;a[b+120>>0]=0;e=b+124|0;c[e+0>>2]=0;c[e+4>>2]=0;c[e+8>>2]=0;c[e+12>>2]=0;c[e+16>>2]=0;c[e+20>>2]=0;c[e+24>>2]=0;c[e+28>>2]=0;c[b+300>>2]=0;a[b+304>>0]=0;e=b+308|0;c[e+0>>2]=0;c[e+4>>2]=0;c[e+8>>2]=0;c[e+12>>2]=0;c[e+16>>2]=0;c[e+20>>2]=0;c[e+24>>2]=0;c[e+28>>2]=0;c[b+484>>2]=0;a[b+488>>0]=0;e=b+492|0;c[e+0>>2]=0;c[e+4>>2]=0;c[e+8>>2]=0;c[e+12>>2]=0;c[e+16>>2]=0;c[e+20>>2]=0;c[e+24>>2]=0;c[e+28>>2]=0;c[b+668>>2]=0;a[b+672>>0]=0;e=b+676|0;c[e+0>>2]=0;c[e+4>>2]=0;c[e+8>>2]=0;c[e+12>>2]=0;c[e+16>>2]=0;c[e+20>>2]=0;c[e+24>>2]=0;c[e+28>>2]=0;c[b+740>>2]=0;c[b+744>>2]=0;c[b+748>>2]=0;c[b+768>>2]=0;i=d;return b|0}function rh(a){a=a|0;return c[a+740>>2]|0}function sh(a){a=a|0;return c[a+744>>2]|0}function th(a){a=a|0;return c[a+748>>2]|0}function uh(a,b){a=a|0;b=b|0;return a+(b*184|0)+4|0}function vh(a){a=a|0;var b=0;b=i;if(!a){i=b;return}c[5110]=(c[5110]|0)+1;RE(c[a+-4>>2]|0);i=b;return}function wh(a){a=a|0;var b=0,d=0.0,e=0.0,f=0.0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0.0,r=0.0,s=0.0;n=i;c[5108]=(c[5108]|0)+1;b=QE(75)|0;if(!b)m=0;else{c[(b+19&-16)+-4>>2]=b;m=b+19&-16}c[m+8>>2]=0;j=m+12|0;g[j>>2]=1.0;k=m+16|0;g[k>>2]=1.0;l=m+20|0;g[l>>2]=1.0;g[m+24>>2]=0.0;h=m+44|0;g[h>>2]=.03999999910593033;c[m+52>>2]=0;c[m>>2]=14912;c[m+4>>2]=0;d=+g[a>>2];e=+g[a+4>>2];f=+g[a+8>>2];if(d<e)b=d<f?0:2;else b=e<f?1:2;d=+g[a+(b<<2)>>2]*.10000000149011612;if(d<.03999999910593033){r=+zu(m);f=+Zb[c[(c[m>>2]|0)+48>>2]&15](m);s=+Zb[c[(c[m>>2]|0)+48>>2]&15](m);p=m+28|0;r=r+ +g[p>>2];o=m+32|0;f=f+ +g[o>>2];b=m+36|0;s=s+ +g[b>>2];g[h>>2]=d;q=+Zb[c[(c[m>>2]|0)+48>>2]&15](m);e=+Zb[c[(c[m>>2]|0)+48>>2]&15](m);d=s-+Zb[c[(c[m>>2]|0)+48>>2]&15](m);g[p>>2]=r-q;g[o>>2]=f-e;g[b>>2]=d;g[m+40>>2]=0.0;b=c[m>>2]|0}else b=14912|0;q=+Zb[c[b+48>>2]&15](m);e=+Zb[c[(c[m>>2]|0)+48>>2]&15](m);d=+Zb[c[(c[m>>2]|0)+48>>2]&15](m);e=+g[a+4>>2]*+g[k>>2]-e;d=+g[a+8>>2]*+g[l>>2]-d;g[m+28>>2]=+g[a>>2]*+g[j>>2]-q;g[m+32>>2]=e;g[m+36>>2]=d;g[m+40>>2]=0.0;i=n;return m|0}function xh(a,b){a=a|0;b=b|0;var d=0;d=i;Lb[c[(c[a>>2]|0)+24>>2]&127](a,b);i=d;return}function yh(a,b,d){a=a|0;b=+b;d=d|0;var e=0;e=i;Sb[c[(c[a>>2]|0)+32>>2]&15](a,b,d);i=e;return}function zh(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Jb[c[(c[a>>2]|0)+4>>2]&255](a);i=b;return}function Ah(b){b=b|0;var d=0,e=0,f=0,g=0,h=0;g=i;d=QE(5260)|0;a:do if(!d){while(1){d=c[5230]|0;c[5230]=d+0;if(!d)break;qc[d&3]();d=QE(5260)|0;if(d)break a}d=yb(4)|0;c[d>>2]=20816;wb(d|0,20864,207)}while(0);c[d>>2]=5600;c[d+4>>2]=2;a[d+24>>0]=1;c[d+20>>2]=0;c[d+12>>2]=0;c[d+16>>2]=0;c[d+28>>2]=7888;f=d+5256|0;c[f>>2]=b;c[d+60>>2]=70;c[d+64>>2]=Nb[c[(c[b>>2]|0)+12>>2]&127](b)|0;c[d+68>>2]=Nb[c[(c[b>>2]|0)+8>>2]&127](b)|0;e=0;do{b=0;do{h=c[f>>2]|0;c[d+(e*144|0)+(b<<2)+72>>2]=Wb[c[(c[h>>2]|0)+16>>2]&63](h,e,b)|0;b=b+1|0}while((b|0)<36);e=e+1|0}while((e|0)<36);i=g;return d|0}function Bh(a){a=a|0;var b=0;b=i;a=Nb[c[(c[a>>2]|0)+36>>2]&127](a)|0;i=b;return a|0}function Ch(a,b){a=a|0;b=b|0;var d=0;d=i;b=ec[c[(c[a>>2]|0)+40>>2]&31](a,b)|0;i=d;return b|0}function Dh(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Jb[c[(c[a>>2]|0)+4>>2]&255](a);i=b;return}function Eh(){var a=0,b=0;b=i;a=QE(24)|0;a:do if(!a){while(1){a=c[5230]|0;c[5230]=a+0;if(!a)break;qc[a&3]();a=QE(24)|0;if(a)break a}a=yb(4)|0;c[a>>2]=20816;wb(a|0,20864,207)}while(0);g[a>>2]=5.880000114440918;g[a+4>>2]=.8299999833106995;g[a+8>>2]=.8799999952316284;g[a+12>>2]=500.0;g[a+16>>2]=10.5;g[a+20>>2]=6.0e3;i=b;return a|0}function Fh(a){a=a|0;return +(+g[a>>2])}function Gh(a,b){a=a|0;b=+b;g[a>>2]=b;return}function Hh(a){a=a|0;return +(+g[a+4>>2])}function Ih(a,b){a=a|0;b=+b;g[a+4>>2]=b;return}function Jh(a){a=a|0;return +(+g[a+8>>2])}function Kh(a,b){a=a|0;b=+b;g[a+8>>2]=b;return}function Lh(a){a=a|0;return +(+g[a+12>>2])}function Mh(a,b){a=a|0;b=+b;g[a+12>>2]=b;return}function Nh(a){a=a|0;return +(+g[a+16>>2])}function Oh(a,b){a=a|0;b=+b;g[a+16>>2]=b;return}function Ph(a){a=a|0;return +(+g[a+20>>2])}function Qh(a,b){a=a|0;b=+b;g[a+20>>2]=b;return}function Rh(){var a=0,b=0;b=i;c[5108]=(c[5108]|0)+1;a=QE(111)|0;if(!a){a=0;Ew(a,1);i=b;return a|0}c[(a+19&-16)+-4>>2]=a;a=a+19&-16;Ew(a,1);i=b;return a|0}function Sh(a){a=a|0;var b=0,d=0;d=i;c[5108]=(c[5108]|0)+1;b=QE(111)|0;if(!b){b=0;Ew(b,a);i=d;return b|0}c[(b+19&-16)+-4>>2]=b;b=b+19&-16;Ew(b,a);i=d;return b|0}function Th(b,d,e){b=b|0;d=d|0;e=e|0;var f=0.0,h=0,j=0,k=0,l=0,m=0,n=0,o=0.0,p=0,q=0,r=0,s=0;p=i;i=i+128|0;c[b+68>>2]=(c[b+68>>2]|0)+1;c[p+0>>2]=c[d+0>>2];c[p+4>>2]=c[d+4>>2];c[p+8>>2]=c[d+8>>2];c[p+12>>2]=c[d+12>>2];c[p+16>>2]=c[d+16>>2];c[p+20>>2]=c[d+20>>2];c[p+24>>2]=c[d+24>>2];c[p+28>>2]=c[d+28>>2];c[p+32>>2]=c[d+32>>2];c[p+36>>2]=c[d+36>>2];c[p+40>>2]=c[d+40>>2];c[p+44>>2]=c[d+44>>2];c[p+48>>2]=c[d+48>>2];c[p+52>>2]=c[d+52>>2];c[p+56>>2]=c[d+56>>2];c[p+60>>2]=c[d+60>>2];n=c[e+4>>2]|0;o=+Zb[c[(c[e>>2]|0)+48>>2]&15](e);tc[c[(c[e>>2]|0)+8>>2]&127](e,d,p+112|0,p+96|0);f=+g[p+112>>2];if(+g[b+32>>2]>f)g[b+32>>2]=f;f=+g[p+96>>2];if(+g[b+48>>2]<f)g[b+48>>2]=f;f=+g[p+116>>2];if(+g[b+36>>2]>f)g[b+36>>2]=f;f=+g[p+100>>2];if(+g[b+52>>2]<f)g[b+52>>2]=f;f=+g[p+120>>2];if(+g[b+40>>2]>f)g[b+40>>2]=f;f=+g[p+104>>2];if(+g[b+56>>2]<f)g[b+56>>2]=f;l=c[b+64>>2]|0;if(!l){l=0;k=b+16|0}else{c[p+64>>2]=c[p+112>>2];c[p+68>>2]=c[p+116>>2];c[p+72>>2]=c[p+120>>2];c[p+76>>2]=c[p+124>>2];c[p+80>>2]=c[p+96>>2];c[p+84>>2]=c[p+100>>2];c[p+88>>2]=c[p+104>>2];c[p+92>>2]=c[p+108>>2];k=c[b+16>>2]|0;d=c[l+4>>2]|0;if(!d){c[5108]=(c[5108]|0)+1;h=QE(63)|0;if((h|0)!=0?(c[(h+19&-16)+-4>>2]=h,(h+19&-16|0)!=0):0){j=(h+19&-16)+0|0;d=j+44|0;do{c[j>>2]=0;j=j+4|0}while((j|0)<(d|0));d=h+19&-16}else d=0}else c[l+4>>2]=0;c[d+32>>2]=0;c[d+36>>2]=k;c[d+40>>2]=0;c[d+0>>2]=c[p+64>>2];c[d+4>>2]=c[p+68>>2];c[d+8>>2]=c[p+72>>2];c[d+12>>2]=c[p+76>>2];c[d+16>>2]=c[p+80>>2];c[d+20>>2]=c[p+84>>2];c[d+24>>2]=c[p+88>>2];c[d+28>>2]=c[p+92>>2];EC(l,c[l>>2]|0,d);c[l+12>>2]=(c[l+12>>2]|0)+1;l=d;k=b+16|0}d=c[k>>2]|0;if((d|0)==(c[b+20>>2]|0)?(m=(d|0)==0?1:d<<1,(d|0)<(m|0)):0){if(!m)h=0;else{c[5108]=(c[5108]|0)+1;d=QE((m*80|3)+16|0)|0;if(!d)h=0;else{c[(d+19&-16)+-4>>2]=d;h=d+19&-16}d=c[k>>2]|0}if((d|0)>0){j=0;do{q=h+(j*80|0)|0;r=c[b+24>>2]|0;s=r+(j*80|0)|0;c[q+0>>2]=c[s+0>>2];c[q+4>>2]=c[s+4>>2];c[q+8>>2]=c[s+8>>2];c[q+12>>2]=c[s+12>>2];q=h+(j*80|0)+16|0;s=r+(j*80|0)+16|0;c[q+0>>2]=c[s+0>>2];c[q+4>>2]=c[s+4>>2];c[q+8>>2]=c[s+8>>2];c[q+12>>2]=c[s+12>>2];q=h+(j*80|0)+32|0;s=r+(j*80|0)+32|0;c[q+0>>2]=c[s+0>>2];c[q+4>>2]=c[s+4>>2];c[q+8>>2]=c[s+8>>2];c[q+12>>2]=c[s+12>>2];q=h+(j*80|0)+48|0;s=r+(j*80|0)+48|0;c[q+0>>2]=c[s+0>>2];c[q+4>>2]=c[s+4>>2];c[q+8>>2]=c[s+8>>2];c[q+12>>2]=c[s+12>>2];q=h+(j*80|0)+64|0;r=r+(j*80|0)+64|0;c[q+0>>2]=c[r+0>>2];c[q+4>>2]=c[r+4>>2];c[q+8>>2]=c[r+8>>2];c[q+12>>2]=c[r+12>>2];j=j+1|0}while((j|0)!=(d|0))}d=c[b+24>>2]|0;if(d){if(a[b+28>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}c[b+24>>2]=0}a[b+28>>0]=1;c[b+24>>2]=h;c[b+20>>2]=m;d=c[k>>2]|0}b=c[b+24>>2]|0;m=b+(d*80|0)|0;c[m+0>>2]=c[p+0>>2];c[m+4>>2]=c[p+4>>2];c[m+8>>2]=c[p+8>>2];c[m+12>>2]=c[p+12>>2];m=b+(d*80|0)+16|0;c[m+0>>2]=c[p+16>>2];c[m+4>>2]=c[p+20>>2];c[m+8>>2]=c[p+24>>2];c[m+12>>2]=c[p+28>>2];m=b+(d*80|0)+32|0;c[m+0>>2]=c[p+32>>2];c[m+4>>2]=c[p+36>>2];c[m+8>>2]=c[p+40>>2];c[m+12>>2]=c[p+44>>2];m=b+(d*80|0)+48|0;c[m+0>>2]=c[p+48>>2];c[m+4>>2]=c[p+52>>2];c[m+8>>2]=c[p+56>>2];c[m+12>>2]=c[p+60>>2];b=b+(d*80|0)+64|0;c[b>>2]=e;c[b+4>>2]=n;g[b+8>>2]=o;c[b+12>>2]=l;c[k>>2]=(c[k>>2]|0)+1;i=p;return}function Uh(a,b){a=a|0;b=b|0;var d=0;d=i;Lb[c[(c[a>>2]|0)+24>>2]&127](a,b);i=d;return}function Vh(a,b,d){a=a|0;b=+b;d=d|0;var e=0;e=i;Sb[c[(c[a>>2]|0)+32>>2]&15](a,b,d);i=e;return}function Wh(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Jb[c[(c[a>>2]|0)+4>>2]&255](a);i=b;return}function Xh(a,d){a=a|0;d=d|0;var e=0,f=0,h=0;f=i;e=QE(80)|0;a:do if(!e){while(1){e=c[5230]|0;c[5230]=e+0;if(!e)break;qc[e&3]();e=QE(80)|0;if(e)break a}e=yb(4)|0;c[e>>2]=20816;wb(e|0,20864,207)}while(0);g[e+4>>2]=1.0;b[e+8>>1]=1;b[e+10>>1]=-1;c[e>>2]=880;h=e+12|0;c[h+0>>2]=c[a+0>>2];c[h+4>>2]=c[a+4>>2];c[h+8>>2]=c[a+8>>2];c[h+12>>2]=c[a+12>>2];a=e+28|0;c[a+0>>2]=c[d+0>>2];c[a+4>>2]=c[d+4>>2];c[a+8>>2]=c[d+8>>2];c[a+12>>2]=c[d+12>>2];c[e+76>>2]=0;i=f;return e|0}function Yh(a){a=a|0;return +g[a+4>>2]<1.0|0}function Zh(a){a=a|0;return a+12|0}function _h(a,b){a=a|0;b=b|0;c[a+12>>2]=c[b+0>>2];c[a+16>>2]=c[b+4>>2];c[a+20>>2]=c[b+8>>2];c[a+24>>2]=c[b+12>>2];return}function $h(a){a=a|0;return a+28|0}function ai(a,b){a=a|0;b=b|0;c[a+28>>2]=c[b+0>>2];c[a+32>>2]=c[b+4>>2];c[a+36>>2]=c[b+8>>2];c[a+40>>2]=c[b+12>>2];return}function bi(a){a=a|0;return a+44|0}function ci(a,b){a=a|0;b=b|0;c[a+44>>2]=c[b+0>>2];c[a+48>>2]=c[b+4>>2];c[a+52>>2]=c[b+8>>2];c[a+56>>2]=c[b+12>>2];return}function di(a){a=a|0;return a+60|0}function ei(a,b){a=a|0;b=b|0;c[a+60>>2]=c[b+0>>2];c[a+64>>2]=c[b+4>>2];c[a+68>>2]=c[b+8>>2];c[a+72>>2]=c[b+12>>2];return}function fi(a){a=a|0;return b[a+8>>1]|0}function gi(a,c){a=a|0;c=c|0;b[a+8>>1]=c;return}function hi(a){a=a|0;return b[a+10>>1]|0}function ii(a,c){a=a|0;c=c|0;b[a+10>>1]=c;return}function ji(a){a=a|0;return +(+g[a+4>>2])}function ki(a,b){a=a|0;b=+b;g[a+4>>2]=b;return}function li(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Jb[c[(c[a>>2]|0)+4>>2]&255](a);i=b;return}function mi(){var a=0,b=0;b=i;c[5108]=(c[5108]|0)+1;a=QE(219)|0;if(!a)a=0;else{c[(a+19&-16)+-4>>2]=a;a=a+19&-16}ni();ni();oi(a,744,744);i=b;return a|0}function ni(){var b=0;b=i;if(a[808]|0){i=b;return}if(!(Xa(808)|0)){i=b;return}if((a[864]|0)==0?(Xa(864)|0)!=0:0){g[204]=1.0;c[205]=0;c[206]=0;c[207]=0;c[208]=0;g[209]=1.0;c[210]=0;c[211]=0;c[212]=0;c[213]=0;g[214]=1.0;g[215]=0.0;ab(864)};c[186]=c[204];c[187]=c[205];c[188]=c[206];c[189]=c[207];c[190]=c[208];c[191]=c[209];c[192]=c[210];c[193]=c[211];c[194]=c[212];c[195]=c[213];c[196]=c[214];c[197]=c[215];c[198]=0;c[199]=0;c[200]=0;c[201]=0;ab(808);i=b;return}function oi(a,b,d){a=a|0;b=b|0;d=d|0;c[a>>2]=664;c[a+4>>2]=c[b+0>>2];c[a+8>>2]=c[b+4>>2];c[a+12>>2]=c[b+8>>2];c[a+16>>2]=c[b+12>>2];c[a+20>>2]=c[b+16>>2];c[a+24>>2]=c[b+20>>2];c[a+28>>2]=c[b+24>>2];c[a+32>>2]=c[b+28>>2];c[a+36>>2]=c[b+32>>2];c[a+40>>2]=c[b+36>>2];c[a+44>>2]=c[b+40>>2];c[a+48>>2]=c[b+44>>2];c[a+52>>2]=c[b+48>>2];c[a+56>>2]=c[b+52>>2];c[a+60>>2]=c[b+56>>2];c[a+64>>2]=c[b+60>>2];c[a+68>>2]=c[d+0>>2];c[a+72>>2]=c[d+4>>2];c[a+76>>2]=c[d+8>>2];c[a+80>>2]=c[d+12>>2];c[a+84>>2]=c[d+16>>2];c[a+88>>2]=c[d+20>>2];c[a+92>>2]=c[d+24>>2];c[a+96>>2]=c[d+28>>2];c[a+100>>2]=c[d+32>>2];c[a+104>>2]=c[d+36>>2];c[a+108>>2]=c[d+40>>2];c[a+112>>2]=c[d+44>>2];c[a+116>>2]=c[d+48>>2];c[a+120>>2]=c[d+52>>2];c[a+124>>2]=c[d+56>>2];c[a+128>>2]=c[d+60>>2];c[a+132>>2]=c[b+0>>2];c[a+136>>2]=c[b+4>>2];c[a+140>>2]=c[b+8>>2];c[a+144>>2]=c[b+12>>2];c[a+148>>2]=c[b+16>>2];c[a+152>>2]=c[b+20>>2];c[a+156>>2]=c[b+24>>2];c[a+160>>2]=c[b+28>>2];c[a+164>>2]=c[b+32>>2];c[a+168>>2]=c[b+36>>2];c[a+172>>2]=c[b+40>>2];c[a+176>>2]=c[b+44>>2];c[a+180>>2]=c[b+48>>2];c[a+184>>2]=c[b+52>>2];c[a+188>>2]=c[b+56>>2];c[a+192>>2]=c[b+60>>2];c[a+196>>2]=0;return}function pi(a){a=a|0;var b=0,d=0;d=i;c[5108]=(c[5108]|0)+1;b=QE(219)|0;if(!b)b=0;else{c[(b+19&-16)+-4>>2]=b;b=b+19&-16}ni();oi(b,a,744);i=d;return b|0}function qi(a,b){a=a|0;b=b|0;var d=0,e=0;e=i;c[5108]=(c[5108]|0)+1;d=QE(219)|0;if(!d)d=0;else{c[(d+19&-16)+-4>>2]=d;d=d+19&-16}oi(d,a,b);i=e;return d|0}function ri(a,b){a=a|0;b=b|0;var d=0;d=i;Lb[c[(c[a>>2]|0)+8>>2]&127](a,b);i=d;return}function si(a,b){a=a|0;b=b|0;var d=0;d=i;Lb[c[(c[a>>2]|0)+12>>2]&127](a,b);i=d;return}function ti(a){a=a|0;return a+4|0}function ui(a,b){a=a|0;b=b|0;c[a+4>>2]=c[b+0>>2];c[a+8>>2]=c[b+4>>2];c[a+12>>2]=c[b+8>>2];c[a+16>>2]=c[b+12>>2];c[a+20>>2]=c[b+16>>2];c[a+24>>2]=c[b+20>>2];c[a+28>>2]=c[b+24>>2];c[a+32>>2]=c[b+28>>2];c[a+36>>2]=c[b+32>>2];c[a+40>>2]=c[b+36>>2];c[a+44>>2]=c[b+40>>2];c[a+48>>2]=c[b+44>>2];c[a+52>>2]=c[b+48>>2];c[a+56>>2]=c[b+52>>2];c[a+60>>2]=c[b+56>>2];c[a+64>>2]=c[b+60>>2];return}function vi(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Jb[c[(c[a>>2]|0)+4>>2]&255](a);i=b;return}function wi(a,b){a=a|0;b=b|0;var d=0;d=i;Lb[c[(c[a>>2]|0)+24>>2]&127](a,b);i=d;return}function xi(a,b,d){a=a|0;b=+b;d=d|0;var e=0;e=i;Sb[c[(c[a>>2]|0)+32>>2]&15](a,b,d);i=e;return}function yi(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Jb[c[(c[a>>2]|0)+4>>2]&255](a);i=b;return}function zi(a){a=a|0;var b=0;b=i;a=Nb[c[(c[a>>2]|0)+36>>2]&127](a)|0;i=b;return a|0}function Ai(a,b){a=a|0;b=b|0;var d=0;d=i;b=ec[c[(c[a>>2]|0)+40>>2]&31](a,b)|0;i=d;return b|0}function Bi(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Jb[c[(c[a>>2]|0)+4>>2]&255](a);i=b;return}function Ci(a,d){a=a|0;d=d|0;var e=0,f=0,h=0;f=i;e=QE(84)|0;a:do if(!e){while(1){e=c[5230]|0;c[5230]=e+0;if(!e)break;qc[e&3]();e=QE(84)|0;if(e)break a}e=yb(4)|0;c[e>>2]=20816;wb(e|0,20864,207)}while(0);g[e+4>>2]=1.0;c[e+8>>2]=0;b[e+12>>1]=1;b[e+14>>1]=-1;c[e+16>>2]=0;c[e>>2]=528;h=e+20|0;c[h+0>>2]=c[a+0>>2];c[h+4>>2]=c[a+4>>2];c[h+8>>2]=c[a+8>>2];c[h+12>>2]=c[a+12>>2];a=e+36|0;c[a+0>>2]=c[d+0>>2];c[a+4>>2]=c[d+4>>2];c[a+8>>2]=c[d+8>>2];c[a+12>>2]=c[d+12>>2];i=f;return e|0}function Di(a){a=a|0;return (c[a+8>>2]|0)!=0|0}function Ei(a){a=a|0;return a+20|0}function Fi(a,b){a=a|0;b=b|0;c[a+20>>2]=c[b+0>>2];c[a+24>>2]=c[b+4>>2];c[a+28>>2]=c[b+8>>2];c[a+32>>2]=c[b+12>>2];return}function Gi(a){a=a|0;return a+36|0}function Hi(a,b){a=a|0;b=b|0;c[a+36>>2]=c[b+0>>2];c[a+40>>2]=c[b+4>>2];c[a+44>>2]=c[b+8>>2];c[a+48>>2]=c[b+12>>2];return}function Ii(a){a=a|0;return a+52|0}function Ji(a,b){a=a|0;b=b|0;c[a+52>>2]=c[b+0>>2];c[a+56>>2]=c[b+4>>2];c[a+60>>2]=c[b+8>>2];c[a+64>>2]=c[b+12>>2];return}function Ki(a){a=a|0;return a+68|0}function Li(a,b){a=a|0;b=b|0;c[a+68>>2]=c[b+0>>2];c[a+72>>2]=c[b+4>>2];c[a+76>>2]=c[b+8>>2];c[a+80>>2]=c[b+12>>2];return}function Mi(a){a=a|0;return b[a+12>>1]|0}function Ni(a,c){a=a|0;c=c|0;b[a+12>>1]=c;return}function Oi(a){a=a|0;return b[a+14>>1]|0}function Pi(a,c){a=a|0;c=c|0;b[a+14>>1]=c;return}function Qi(a){a=a|0;return c[a+8>>2]|0}function Ri(a,b){a=a|0;b=b|0;c[a+8>>2]=b;return}function Si(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Jb[c[(c[a>>2]|0)+4>>2]&255](a);i=b;return}function Ti(a,b){a=a|0;b=b|0;var d=0;d=i;Lb[c[(c[a>>2]|0)+64>>2]&127](a,b);i=d;return}function Ui(b){b=b|0;var d=0,e=0,f=0;f=i;if((a[216]|0)==0?(Xa(216)|0)!=0:0){g[32]=.6000000238418579;g[33]=1.0;g[34]=.30000001192092896;g[35]=.01666666753590107;g[36]=0.0;g[38]=20.0;c[37]=10;g[40]=.20000000298023224;g[41]=.800000011920929;g[42]=0.0;g[39]=1.0;c[43]=1;g[44]=-.03999999910593033;g[45]=.10000000149011612;g[46]=0.0;g[47]=.8500000238418579;c[48]=260;c[49]=2;c[50]=128;g[51]=100.0;g[52]=1000000015047466219876688.0e6;ab(216)}e=128;b=b+92|0;d=e+84|0;do{c[e>>2]=c[b>>2];e=e+4|0;b=b+4|0}while((e|0)<(d|0));i=f;return 128}function Vi(a){a=a|0;return c[a+24>>2]|0}function Wi(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0;f=i;tc[c[(c[a>>2]|0)+32>>2]&127](a,b,d,e);i=f;return}function Xi(a){a=a|0;var b=0;b=i;a=c[a+68>>2]|0;a=Nb[c[(c[a>>2]|0)+36>>2]&127](a)|0;i=b;return a|0}function Yi(a){a=a|0;return a+28|0}function Zi(a,b){a=a|0;b=b|0;var d=0;d=i;tc[c[(c[a>>2]|0)+36>>2]&127](a,b,1,-1);i=d;return}function _i(a,b,d){a=a|0;b=b|0;d=d|0;var e=0;e=i;tc[c[(c[a>>2]|0)+36>>2]&127](a,b,d,-1);i=e;return}function $i(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0;f=i;tc[c[(c[a>>2]|0)+36>>2]&127](a,b,d,e);i=f;return}function aj(a){a=a|0;return c[a+68>>2]|0}function bj(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=+f;var g=0;g=i;_u(a,b,c,d,e,f);i=g;return}function cj(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0;e=i;$u(a,b,c,d);i=e;return}function dj(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Jb[c[(c[a>>2]|0)+4>>2]&255](a);i=b;return}function ej(a,b){a=+a;b=+b;var d=0,e=0;e=i;c[5108]=(c[5108]|0)+1;d=QE(75)|0;if(!d)d=0;else{c[(d+19&-16)+-4>>2]=d;d=d+19&-16}c[d+8>>2]=0;g[d+12>>2]=1.0;g[d+16>>2]=1.0;g[d+20>>2]=1.0;g[d+24>>2]=0.0;g[d+44>>2]=.03999999910593033;c[d+4>>2]=10;c[d>>2]=14200;c[d+52>>2]=0;g[d+28>>2]=b*.5;g[d+32>>2]=a;g[d+36>>2]=a;g[d+40>>2]=0.0;i=e;return d|0}function fj(a,b){a=a|0;b=b|0;var d=0;d=i;Lb[c[(c[a>>2]|0)+24>>2]&127](a,b);i=d;return}function gj(a,b,d){a=a|0;b=+b;d=d|0;var e=0;e=i;Sb[c[(c[a>>2]|0)+32>>2]&15](a,b,d);i=e;return}function hj(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Jb[c[(c[a>>2]|0)+4>>2]&255](a);i=b;return}function ij(a,b,d,e){a=+a;b=+b;d=+d;e=+e;var f=0,h=0;h=i;f=QE(16)|0;a:do if(!f){while(1){f=c[5230]|0;c[5230]=f+0;if(!f)break;qc[f&3]();f=QE(16)|0;if(f)break a}f=yb(4)|0;c[f>>2]=20816;wb(f|0,20864,207)}while(0);g[f>>2]=a;g[f+4>>2]=b;g[f+8>>2]=d;g[f+12>>2]=e;i=h;return f|0}function jj(a,b,c,d,e){a=a|0;b=+b;c=+c;d=+d;e=+e;g[a>>2]=b;g[a+4>>2]=c;g[a+8>>2]=d;g[a+12>>2]=e;return}function kj(a){a=a|0;return +(+g[a>>2])}function lj(a){a=a|0;return +(+g[a+4>>2])}function mj(a){a=a|0;return +(+g[a+8>>2])}function nj(a){a=a|0;return +(+g[a+12>>2])}function oj(a,b){a=a|0;b=+b;g[a>>2]=b;return}function pj(a,b){a=a|0;b=+b;g[a+4>>2]=b;return}function qj(a,b){a=a|0;b=+b;g[a+8>>2]=b;return}function rj(a,b){a=a|0;b=+b;g[a+12>>2]=b;return}function sj(a){a=a|0;var b=0;b=i;if(a)RE(a);i=b;return}function tj(a,b){a=+a;b=+b;var d=0,e=0;e=i;c[5108]=(c[5108]|0)+1;d=QE(75)|0;if(!d)d=0;else{c[(d+19&-16)+-4>>2]=d;d=d+19&-16}c[d+8>>2]=0;g[d+12>>2]=1.0;g[d+16>>2]=1.0;g[d+20>>2]=1.0;g[d+24>>2]=0.0;g[d+44>>2]=.03999999910593033;c[d+4>>2]=10;c[d>>2]=14304;c[d+52>>2]=2;g[d+28>>2]=a;g[d+32>>2]=a;g[d+36>>2]=b*.5;g[d+40>>2]=0.0;i=e;return d|0}function uj(a,b){a=a|0;b=b|0;var d=0;d=i;Lb[c[(c[a>>2]|0)+24>>2]&127](a,b);i=d;return}function vj(a,b,d){a=a|0;b=+b;d=d|0;var e=0;e=i;Sb[c[(c[a>>2]|0)+32>>2]&15](a,b,d);i=e;return}function wj(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Jb[c[(c[a>>2]|0)+4>>2]&255](a);i=b;return}function xj(a){a=a|0;var b=0,d=0;d=i;b=QE(8)|0;a:do if(!b){while(1){b=c[5230]|0;c[5230]=b+0;if(!b)break;qc[b&3]();b=QE(8)|0;if(b)break a}b=yb(4)|0;c[b>>2]=20816;wb(b|0,20864,207)}while(0);c[b>>2]=4952;c[b+4>>2]=a;i=d;return b|0}function yj(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Jb[c[(c[a>>2]|0)+4>>2]&255](a);i=b;return}function zj(a){a=a|0;return (c[a+8>>2]|0)!=0|0}function Aj(a){a=a|0;return b[a+12>>1]|0}function Bj(a,c){a=a|0;c=c|0;b[a+12>>1]=c;return}function Cj(a){a=a|0;return b[a+14>>1]|0}function Dj(a,c){a=a|0;c=c|0;b[a+14>>1]=c;return}function Ej(a){a=a|0;return c[a+8>>2]|0}function Fj(a,b){a=a|0;b=b|0;c[a+8>>2]=b;return}function Gj(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Jb[c[(c[a>>2]|0)+4>>2]&255](a);i=b;return}function Hj(a){a=a|0;return +(+g[a+216>>2])}function Ij(a,b){a=a|0;b=+b;g[a+216>>2]=b;return}function Jj(a){a=a|0;return +(+g[a+228>>2])}function Kj(a,b){a=a|0;b=+b;g[a+228>>2]=b;return}function Lj(a){a=a|0;return +(+g[a+244>>2])}function Mj(a,b){a=a|0;b=+b;g[a+244>>2]=b;return}function Nj(a){a=a|0;return +(+g[a+204>>2])}function Oj(a,b){a=a|0;b=+b;g[a+204>>2]=b;return}function Pj(a){a=a|0;return +(+g[a+212>>2])}function Qj(a,b){a=a|0;b=+b;g[a+212>>2]=b;return}function Rj(a){a=a|0;return +(+g[a+220>>2])}function Sj(a,b){a=a|0;b=+b;g[a+220>>2]=b;return}function Tj(a){a=a|0;return +(+g[a+224>>2])}function Uj(a,b){a=a|0;b=+b;g[a+224>>2]=b;return}function Vj(a){a=a|0;return +(+g[a+232>>2])}function Wj(a,b){a=a|0;b=+b;g[a+232>>2]=b;return}function Xj(a){a=a|0;return +(+g[a+248>>2])}function Yj(a,b){a=a|0;b=+b;g[a+248>>2]=b;return}function Zj(a){a=a|0;return +(+g[a+208>>2])}function _j(a,b){a=a|0;b=+b;g[a+208>>2]=b;return}function $j(a){a=a|0;return +(+g[a+276>>2])}function ak(a,b){a=a|0;b=+b;g[a+276>>2]=b;return}function bk(b){b=b|0;return (a[b+260>>0]&1)!=0|0}function ck(b,c){b=b|0;c=c|0;a[b+260>>0]=c&1;return}function dk(a){a=a|0;return a+156|0}function ek(a,b){a=a|0;b=b|0;c[a+156>>2]=c[b+0>>2];c[a+160>>2]=c[b+4>>2];c[a+164>>2]=c[b+8>>2];c[a+168>>2]=c[b+12>>2];return}function fk(a){a=a|0;var b=0;b=i;if(a)RE(a);i=b;return}function gk(a,b){a=a|0;b=b|0;var d=0;d=i;Lb[c[(c[a>>2]|0)+24>>2]&127](a,b);i=d;return}function hk(a,b,d){a=a|0;b=+b;d=d|0;var e=0;e=i;Sb[c[(c[a>>2]|0)+32>>2]&15](a,b,d);i=e;return}function ik(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Jb[c[(c[a>>2]|0)+4>>2]&255](a);i=b;return}function jk(){var a=0,b=0;b=i;c[5108]=(c[5108]|0)+1;a=QE(35)|0;if(!a){a=0;i=b;return a|0}c[(a+19&-16)+-4>>2]=a;a=a+19&-16;i=b;return a|0}function kk(a,b,d,e){a=+a;b=+b;d=+d;e=+e;var f=0,h=0;h=i;c[5108]=(c[5108]|0)+1;f=QE(35)|0;if(!f)f=0;else{c[(f+19&-16)+-4>>2]=f;f=f+19&-16}g[f>>2]=a;g[f+4>>2]=b;g[f+8>>2]=d;g[f+12>>2]=e;i=h;return f|0}function lk(a){a=a|0;return +(+g[a+12>>2])}function mk(a,b,c,d,e){a=a|0;b=+b;c=+c;d=+d;e=+e;g[a>>2]=b;g[a+4>>2]=c;g[a+8>>2]=d;g[a+12>>2]=e;return}function nk(a){a=a|0;var b=0.0,c=0.0,d=0.0;d=+g[a>>2];c=+g[a+4>>2];b=+g[a+8>>2];b=+P(+(d*d+c*c+b*b));return +b}function ok(a){a=a|0;return +(+g[a>>2])}function pk(a){a=a|0;return +(+g[a+4>>2])}function qk(a){a=a|0;return +(+g[a+8>>2])}function rk(a,b){a=a|0;b=+b;g[a>>2]=b;return}function sk(a,b){a=a|0;b=+b;g[a+4>>2]=b;return}function tk(a,b){a=a|0;b=+b;g[a+8>>2]=b;return}function uk(a,b){a=a|0;b=+b;g[a>>2]=+g[a>>2]*b;g[a+4>>2]=+g[a+4>>2]*b;g[a+8>>2]=+g[a+8>>2]*b;return a|0}function vk(a){a=a|0;var b=0;b=i;if(!a){i=b;return}c[5110]=(c[5110]|0)+1;RE(c[a+-4>>2]|0);i=b;return}function wk(b,d,e){b=b|0;d=d|0;e=+e;var f=0,h=0,j=0;h=i;c[5108]=(c[5108]|0)+1;f=QE(203)|0;if(!f)f=0;else{c[(f+19&-16)+-4>>2]=f;f=f+19&-16}c[f>>2]=5024;a[f+144>>0]=1;c[f+140>>2]=0;c[f+132>>2]=0;c[f+136>>2]=0;c[f+176>>2]=1;g[f+56>>2]=.019999999552965164;j=f+60|0;c[j+0>>2]=0;c[j+4>>2]=0;c[j+8>>2]=0;c[j+12>>2]=0;a[f+170>>0]=1;c[f+8>>2]=b;g[f+52>>2]=e;g[f+48>>2]=0.0;c[f+12>>2]=d;a[f+171>>0]=1;g[f+172>>2]=0.0;g[f+16>>2]=0.0;g[f+20>>2]=0.0;g[f+44>>2]=29.399999618530273;g[f+24>>2]=55.0;g[f+28>>2]=10.0;a[f+168>>0]=0;a[f+169>>0]=0;a[f+180>>0]=1;g[f+36>>2]=.7853981852531433;g[f+40>>2]=.7071067690849304;g[f+108>>2]=0.0;a[f+181>>0]=0;a[f+182>>0]=0;i=h;return f|0}function xk(b,d,e,f){b=b|0;d=d|0;e=+e;f=f|0;var h=0,j=0;j=i;c[5108]=(c[5108]|0)+1;h=QE(203)|0;if(!h)h=0;else{c[(h+19&-16)+-4>>2]=h;h=h+19&-16}c[h>>2]=5024;a[h+144>>0]=1;c[h+140>>2]=0;c[h+132>>2]=0;c[h+136>>2]=0;c[h+176>>2]=f;g[h+56>>2]=.019999999552965164;f=h+60|0;c[f+0>>2]=0;c[f+4>>2]=0;c[f+8>>2]=0;c[f+12>>2]=0;a[h+170>>0]=1;c[h+8>>2]=b;g[h+52>>2]=e;g[h+48>>2]=0.0;c[h+12>>2]=d;a[h+171>>0]=1;g[h+172>>2]=0.0;g[h+16>>2]=0.0;g[h+20>>2]=0.0;g[h+44>>2]=29.399999618530273;g[h+24>>2]=55.0;g[h+28>>2]=10.0;a[h+168>>0]=0;a[h+169>>0]=0;a[h+180>>0]=1;g[h+36>>2]=.7853981852531433;g[h+40>>2]=.7071067690849304;g[h+108>>2]=0.0;a[h+181>>0]=0;a[h+182>>0]=0;i=j;return h|0}function yk(a,b){a=a|0;b=b|0;if((b|0)<0)b=0;else b=(b|0)>2?2:b;c[a+176>>2]=b;return}function zk(a,b){a=a|0;b=b|0;var d=0;d=i;Lb[c[(c[a>>2]|0)+16>>2]&127](a,b);i=d;return}function Ak(a,b,d){a=a|0;b=b|0;d=+d;var e=0;e=i;rc[c[(c[a>>2]|0)+20>>2]&7](a,b,d);i=e;return}function Bk(a,b){a=a|0;b=b|0;var d=0;d=i;Lb[c[(c[a>>2]|0)+28>>2]&127](a,b);i=d;return}function Ck(a,b){a=a|0;b=b|0;var d=0;d=i;Lb[c[(c[a>>2]|0)+32>>2]&127](a,b);i=d;return}function Dk(a,b,d){a=a|0;b=b|0;d=+d;var e=0;e=i;rc[c[(c[a>>2]|0)+36>>2]&7](a,b,d);i=e;return}function Ek(a,b){a=a|0;b=+b;g[a+24>>2]=b;return}function Fk(a,b){a=a|0;b=+b;g[a+28>>2]=b;return}function Gk(a,b){a=a|0;b=+b;g[a+32>>2]=b;return}function Hk(a){a=a|0;var b=0;b=i;a=Nb[c[(c[a>>2]|0)+40>>2]&127](a)|0;i=b;return a|0}function Ik(a){a=a|0;var b=0;b=i;Jb[c[(c[a>>2]|0)+44>>2]&255](a);i=b;return}function Jk(a,b){a=a|0;b=+b;g[a+44>>2]=b;return}function Kk(a){a=a|0;return +(+g[a+44>>2])}function Lk(a,b){a=a|0;b=+b;g[a+36>>2]=b;g[a+40>>2]=+R(+b);return}function Mk(a){a=a|0;return +(+g[a+36>>2])}function Nk(a){a=a|0;return c[a+8>>2]|0}function Ok(b,c){b=b|0;c=c|0;a[b+170>>0]=c&1;return}function Pk(a){a=a|0;var b=0;b=i;a=Nb[c[(c[a>>2]|0)+48>>2]&127](a)|0;i=b;return a|0}function Qk(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Jb[c[(c[a>>2]|0)+4>>2]&255](a);i=b;return}function Rk(a,b){a=a|0;b=+b;var d=0,e=0,f=0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0;e=i;c[5108]=(c[5108]|0)+1;d=QE(103)|0;if(!d)d=0;else{c[(d+19&-16)+-4>>2]=d;d=d+19&-16}f=d+4|0;c[f>>2]=35;c[d+8>>2]=0;g[d+12>>2]=0.0;c[d>>2]=13176;m=+g[a>>2];l=+g[a+4>>2];k=+g[a+8>>2];h=+g[a+12>>2];j=1.0/+P(+(m*m+l*l+k*k));g[d+48>>2]=m*j;g[d+52>>2]=l*j;g[d+56>>2]=k*j;g[d+60>>2]=h;g[d+64>>2]=b;a=d+68|0;c[a+0>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;c[a+12>>2]=0;c[f>>2]=28;i=e;return d|0}function Sk(a,b){a=a|0;b=b|0;var d=0;d=i;Lb[c[(c[a>>2]|0)+24>>2]&127](a,b);i=d;return}function Tk(a,b,d){a=a|0;b=+b;d=d|0;var e=0;e=i;Sb[c[(c[a>>2]|0)+32>>2]&15](a,b,d);i=e;return}function Uk(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Jb[c[(c[a>>2]|0)+4>>2]&255](a);i=b;return}function Vk(a){a=a|0;return (c[a+44>>2]|0)!=0|0}function Wk(a,b){a=a|0;b=b|0;c[a+44>>2]=b&1;return}function Xk(a){a=a|0;return ~~+g[a+48>>2]|0}function Yk(a,b){a=a|0;b=b|0;g[a+48>>2]=+(b|0);return}function Zk(a){a=a|0;var b=0;b=i;if(a)RE(a);i=b;return}function _k(a,b){a=a|0;b=b|0;var d=0;d=i;Lb[c[(c[a>>2]|0)+60>>2]&127](a,b);i=d;return}function $k(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Jb[c[(c[a>>2]|0)+4>>2]&255](a);i=b;return}function al(){var a=0,b=0;b=i;c[5108]=(c[5108]|0)+1;a=QE(35)|0;if(!a){a=0;i=b;return a|0}c[(a+19&-16)+-4>>2]=a;a=a+19&-16;i=b;return a|0}function bl(a,b,d){a=+a;b=+b;d=+d;var e=0,f=0;f=i;c[5108]=(c[5108]|0)+1;e=QE(35)|0;if(!e)e=0;else{c[(e+19&-16)+-4>>2]=e;e=e+19&-16}g[e>>2]=a;g[e+4>>2]=b;g[e+8>>2]=d;g[e+12>>2]=0.0;i=f;return e|0}function cl(a){a=a|0;var b=0.0,c=0.0,d=0.0;d=+g[a>>2];c=+g[a+4>>2];b=+g[a+8>>2];b=+P(+(d*d+c*c+b*b));return +b}function dl(a){a=a|0;return +(+g[a>>2])}function el(a){a=a|0;return +(+g[a+4>>2])}function fl(a){a=a|0;return +(+g[a+8>>2])}function gl(a,b){a=a|0;b=+b;g[a>>2]=b;return}function hl(a,b){a=a|0;b=+b;g[a+4>>2]=b;return}function il(a,b){a=a|0;b=+b;g[a+8>>2]=b;return}function jl(a,b,c,d){a=a|0;b=+b;c=+c;d=+d;g[a>>2]=b;g[a+4>>2]=c;g[a+8>>2]=d;g[a+12>>2]=0.0;return}function kl(a,b){a=a|0;b=+b;g[a>>2]=+g[a>>2]*b;g[a+4>>2]=+g[a+4>>2]*b;g[a+8>>2]=+g[a+8>>2]*b;return a|0}function ll(a){a=a|0;var b=0;b=i;if(!a){i=b;return}c[5110]=(c[5110]|0)+1;RE(c[a+-4>>2]|0);i=b;return}function ml(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Jb[c[(c[a>>2]|0)+4>>2]&255](a);i=b;return}function nl(a){a=+a;var b=0,d=0;d=i;c[5108]=(c[5108]|0)+1;b=QE(71)|0;if(!b)b=0;else{c[(b+19&-16)+-4>>2]=b;b=b+19&-16}c[b+8>>2]=0;g[b+12>>2]=1.0;g[b+16>>2]=1.0;g[b+20>>2]=1.0;g[b+24>>2]=0.0;c[b>>2]=12008;c[b+4>>2]=8;g[b+28>>2]=a;g[b+44>>2]=a;i=d;return b|0}function ol(a,b){a=a|0;b=b|0;var d=0;d=i;Lb[c[(c[a>>2]|0)+24>>2]&127](a,b);i=d;return}function pl(a,b,d){a=a|0;b=+b;d=d|0;var e=0;e=i;Sb[c[(c[a>>2]|0)+32>>2]&15](a,b,d);i=e;return}function ql(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Jb[c[(c[a>>2]|0)+4>>2]&255](a);i=b;return}function rl(){var a=0,b=0;b=i;a=QE(24)|0;a:do if(!a){while(1){a=c[5230]|0;c[5230]=a+0;if(!a)break;qc[a&3]();a=QE(24)|0;if(a)break a}a=yb(4)|0;c[a>>2]=20816;wb(a|0,20864,207)}while(0);c[a>>2]=0;c[a+4>>2]=0;c[a+8>>2]=4096;c[a+12>>2]=4096;c[a+16>>2]=0;c[a+20>>2]=1;i=b;return a|0}function sl(a){a=a|0;var b=0;b=i;if(a)RE(a);i=b;return}function tl(a,b){a=a|0;b=b|0;var d=0,e=0;e=i;c[5108]=(c[5108]|0)+1;d=QE(783)|0;if(!d)d=0;else{c[(d+19&-16)+-4>>2]=d;d=d+19&-16}yr(d,a,b,0);i=e;return d|0}function ul(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;f=i;c[5108]=(c[5108]|0)+1;e=QE(783)|0;if(!e)e=0;else{c[(e+19&-16)+-4>>2]=e;e=e+19&-16}yr(e,a,b,d);i=f;return e|0}function vl(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var h=0,j=0;j=i;c[5108]=(c[5108]|0)+1;h=QE(783)|0;if(!h)h=0;else{c[(h+19&-16)+-4>>2]=h;h=h+19&-16}c[h+4>>2]=4;c[h+8>>2]=-1;c[h+12>>2]=-1;g[h+16>>2]=3402823466385288598117041.0e14;a[h+20>>0]=1;a[h+21>>0]=0;c[h+24>>2]=-1;c[h+28>>2]=b;c[h+32>>2]=d;g[h+36>>2]=0.0;g[h+40>>2]=.30000001192092896;c[h+44>>2]=0;c[h>>2]=3840;b=h+552|0;c[b+0>>2]=c[e+0>>2];c[b+4>>2]=c[e+4>>2];c[b+8>>2]=c[e+8>>2];c[b+12>>2]=c[e+12>>2];b=h+568|0;c[b+0>>2]=c[e+16>>2];c[b+4>>2]=c[e+20>>2];c[b+8>>2]=c[e+24>>2];c[b+12>>2]=c[e+28>>2];b=h+584|0;c[b+0>>2]=c[e+32>>2];c[b+4>>2]=c[e+36>>2];c[b+8>>2]=c[e+40>>2];c[b+12>>2]=c[e+44>>2];b=h+600|0;c[b+0>>2]=c[e+48>>2];c[b+4>>2]=c[e+52>>2];c[b+8>>2]=c[e+56>>2];c[b+12>>2]=c[e+60>>2];b=h+616|0;c[b+0>>2]=c[f+0>>2];c[b+4>>2]=c[f+4>>2];c[b+8>>2]=c[f+8>>2];c[b+12>>2]=c[f+12>>2];b=h+632|0;c[b+0>>2]=c[f+16>>2];c[b+4>>2]=c[f+20>>2];c[b+8>>2]=c[f+24>>2];c[b+12>>2]=c[f+28>>2];b=h+648|0;c[b+0>>2]=c[f+32>>2];c[b+4>>2]=c[f+36>>2];c[b+8>>2]=c[f+40>>2];c[b+12>>2]=c[f+44>>2];b=h+664|0;c[b+0>>2]=c[f+48>>2];c[b+4>>2]=c[f+52>>2];c[b+8>>2]=c[f+56>>2];c[b+12>>2]=c[f+60>>2];g[h+688>>2]=0.0;g[h+692>>2]=-1.0;g[h+696>>2]=.8999999761581421;g[h+700>>2]=.30000001192092896;g[h+704>>2]=1.0;g[h+708>>2]=0.0;g[h+712>>2]=0.0;a[h+716>>0]=0;a[h+736>>0]=0;a[h+737>>0]=0;a[h+738>>0]=0;a[h+739>>0]=1;a[h+740>>0]=0;c[h+748>>2]=0;g[h+732>>2]=1.0;i=j;return h|0}function wl(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var j=0,k=0;k=i;c[5108]=(c[5108]|0)+1;j=QE(783)|0;if(!j)j=0;else{c[(j+19&-16)+-4>>2]=j;j=j+19&-16}c[j+4>>2]=4;c[j+8>>2]=-1;c[j+12>>2]=-1;g[j+16>>2]=3402823466385288598117041.0e14;a[j+20>>0]=1;a[j+21>>0]=0;c[j+24>>2]=-1;c[j+28>>2]=b;c[j+32>>2]=d;g[j+36>>2]=0.0;g[j+40>>2]=.30000001192092896;c[j+44>>2]=0;c[j>>2]=3840;b=j+552|0;c[b+0>>2]=c[e+0>>2];c[b+4>>2]=c[e+4>>2];c[b+8>>2]=c[e+8>>2];c[b+12>>2]=c[e+12>>2];b=j+568|0;c[b+0>>2]=c[e+16>>2];c[b+4>>2]=c[e+20>>2];c[b+8>>2]=c[e+24>>2];c[b+12>>2]=c[e+28>>2];b=j+584|0;c[b+0>>2]=c[e+32>>2];c[b+4>>2]=c[e+36>>2];c[b+8>>2]=c[e+40>>2];c[b+12>>2]=c[e+44>>2];b=j+600|0;c[b+0>>2]=c[e+48>>2];c[b+4>>2]=c[e+52>>2];c[b+8>>2]=c[e+56>>2];c[b+12>>2]=c[e+60>>2];b=j+616|0;c[b+0>>2]=c[f+0>>2];c[b+4>>2]=c[f+4>>2];c[b+8>>2]=c[f+8>>2];c[b+12>>2]=c[f+12>>2];b=j+632|0;c[b+0>>2]=c[f+16>>2];c[b+4>>2]=c[f+20>>2];c[b+8>>2]=c[f+24>>2];c[b+12>>2]=c[f+28>>2];b=j+648|0;c[b+0>>2]=c[f+32>>2];c[b+4>>2]=c[f+36>>2];c[b+8>>2]=c[f+40>>2];c[b+12>>2]=c[f+44>>2];b=j+664|0;c[b+0>>2]=c[f+48>>2];c[b+4>>2]=c[f+52>>2];c[b+8>>2]=c[f+56>>2];c[b+12>>2]=c[f+60>>2];g[j+688>>2]=0.0;g[j+692>>2]=-1.0;g[j+696>>2]=.8999999761581421;g[j+700>>2]=.30000001192092896;g[j+704>>2]=1.0;g[j+708>>2]=0.0;g[j+712>>2]=0.0;a[j+716>>0]=0;a[j+736>>0]=0;a[j+737>>0]=0;a[j+738>>0]=0;a[j+739>>0]=1;a[j+740>>0]=h&1;c[j+748>>2]=0;g[j+732>>2]=h?-1.0:1.0;i=k;return j|0}function xl(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0;j=i;c[5108]=(c[5108]|0)+1;h=QE(783)|0;if(!h)h=0;else{c[(h+19&-16)+-4>>2]=h;h=h+19&-16}xr(h,a,b,d,e,f,g,0);i=j;return h|0}function yl(a,b,d,e,f,g,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0;k=i;c[5108]=(c[5108]|0)+1;j=QE(783)|0;if(!j)j=0;else{c[(j+19&-16)+-4>>2]=j;j=j+19&-16}xr(j,a,b,d,e,f,g,h);i=k;return j|0}function zl(a,b,c,d,e){a=a|0;b=+b;c=+c;d=+d;e=+e;var f=0;f=i;g[a+692>>2]=(c-b)*.5;b=+SE((c-b)*.5+b,6.2831854820251465);if(!(b<-3.1415927410125732)){if(b>3.1415927410125732)b=b+-6.2831854820251465}else b=b+6.2831854820251465;g[a+688>>2]=b;g[a+696>>2]=d;g[a+700>>2]=e;g[a+704>>2]=1.0;i=f;return}function Al(a,b,c,d,e,f){a=a|0;b=+b;c=+c;d=+d;e=+e;f=+f;var h=0;h=i;g[a+692>>2]=(c-b)*.5;b=+SE((c-b)*.5+b,6.2831854820251465);if(!(b<-3.1415927410125732)){if(b>3.1415927410125732)b=b+-6.2831854820251465}else b=b+6.2831854820251465;g[a+688>>2]=b;g[a+696>>2]=d;g[a+700>>2]=e;g[a+704>>2]=f;i=h;return}function Bl(b,c){b=b|0;c=c|0;a[b+21>>0]=c&1;return}function Cl(a){a=a|0;return +(+g[a+16>>2])}function Dl(a,b){a=a|0;b=+b;g[a+16>>2]=b;return}function El(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Jb[c[(c[a>>2]|0)+4>>2]&255](a);i=b;return}function Fl(a,b){a=a|0;b=b|0;var d=0;d=i;Lb[c[(c[a>>2]|0)+24>>2]&127](a,b);i=d;return}function Gl(a,b,d){a=a|0;b=+b;d=d|0;var e=0;e=i;Sb[c[(c[a>>2]|0)+32>>2]&15](a,b,d);i=e;return}function Hl(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Jb[c[(c[a>>2]|0)+4>>2]&255](a);i=b;return}function Il(){var a=0,b=0;b=i;a=QE(12)|0;a:do if(!a){while(1){a=c[5230]|0;c[5230]=a+0;if(!a)break;qc[a&3]();a=QE(12)|0;if(a)break a}a=yb(4)|0;c[a>>2]=20816;wb(a|0,20864,207)}while(0);g[a>>2]=.30000001192092896;g[a+4>>2]=1.0;g[a+8>>2]=0.0;i=b;return a|0}function Jl(a){a=a|0;return +(+g[a>>2])}function Kl(a,b){a=a|0;b=+b;g[a>>2]=b;return}function Ll(a){a=a|0;return +(+g[a+4>>2])}function Ml(a,b){a=a|0;b=+b;g[a+4>>2]=b;return}function Nl(a){a=a|0;return +(+g[a+8>>2])}function Ol(a,b){a=a|0;b=+b;g[a+8>>2]=b;return}function Pl(a){a=a|0;var b=0;b=i;if(a)RE(a);i=b;return}function Ql(){var b=0,d=0,e=0;d=i;c[5108]=(c[5108]|0)+1;b=QE(303)|0;if(!b)b=0;else{c[(b+19&-16)+-4>>2]=b;b=b+19&-16}g[b+164>>2]=1.0;g[b+168>>2]=1.0;g[b+172>>2]=1.0;g[b+176>>2]=0.0;c[b+180>>2]=0;g[b+184>>2]=999999984306749440.0;e=b+188|0;c[e+0>>2]=0;c[e+4>>2]=0;c[e+8>>2]=0;c[e+12>>2]=0;c[b+204>>2]=1;c[b+208>>2]=-1;c[b+212>>2]=-1;c[b+216>>2]=1;g[b+220>>2]=0.0;g[b+224>>2]=.5;g[b+228>>2]=0.0;g[b+232>>2]=0.0;c[b+240>>2]=0;g[b+244>>2]=1.0;e=b+248|0;c[e+0>>2]=0;c[e+4>>2]=0;c[e+8>>2]=0;c[e+12>>2]=0;g[b+4>>2]=1.0;e=b+8|0;c[e+0>>2]=0;c[e+4>>2]=0;c[e+8>>2]=0;c[e+12>>2]=0;g[b+24>>2]=1.0;e=b+28|0;c[e+0>>2]=0;c[e+4>>2]=0;c[e+8>>2]=0;c[e+12>>2]=0;g[b+44>>2]=1.0;e=b+48|0;c[e+0>>2]=0;c[e+4>>2]=0;c[e+8>>2]=0;c[e+12>>2]=0;c[e+16>>2]=0;c[b>>2]=5416;a[b+280>>0]=1;c[b+276>>2]=0;c[b+268>>2]=0;c[b+272>>2]=0;c[b+236>>2]=4;i=d;return b|0}function Rl(a){a=a|0;return c[a+268>>2]|0}function Sl(a,b){a=a|0;b=b|0;return c[(c[a+276>>2]|0)+(b<<2)>>2]|0}function Tl(a,b,d){a=a|0;b=b|0;d=d|0;var e=0;e=i;c[a+164>>2]=c[b+0>>2];c[a+168>>2]=c[b+4>>2];c[a+172>>2]=c[b+8>>2];c[a+176>>2]=c[b+12>>2];if((!(+g[b>>2]!=1.0)?!(+g[b+4>>2]!=1.0):0)?!(+g[b+8>>2]!=1.0):0){d=0;b=a+180|0;c[b>>2]=d;i=e;return}b=a+180|0;c[b>>2]=d;i=e;return}function Ul(a){a=a|0;return c[a+192>>2]|0}function Vl(a,b){a=a|0;b=+b;g[a+184>>2]=b;return}function Wl(a,b){a=a|0;b=b|0;var d=0;d=i;if((c[a+216>>2]&-2|0)==4){i=d;return}c[a+216>>2]=b;i=d;return}function Xl(a,b){a=a|0;b=b|0;c[a+216>>2]=b;return}function Yl(a){a=a|0;var b=0;b=i;if(c[a+204>>2]&3){i=b;return}if((c[a+216>>2]&-2|0)!=4)c[a+216>>2]=1;g[a+220>>2]=0.0;i=b;return}function Zl(a,b){a=a|0;b=b|0;var d=0;d=i;if(!b?(c[a+204>>2]&3|0)!=0:0){i=d;return}if((c[a+216>>2]&-2|0)!=4)c[a+216>>2]=1;g[a+220>>2]=0.0;i=d;return}function _l(a){a=a|0;a=c[a+216>>2]|0;return ((a|0)==2?0:(a|0)!=5)|0}function $l(a){a=a|0;return (c[a+204>>2]&2|0)!=0|0}function am(a,b){a=a|0;b=+b;c[a+260>>2]=(c[a+260>>2]|0)+1;g[a+228>>2]=b;return}function bm(a,b){a=a|0;b=+b;c[a+260>>2]=(c[a+260>>2]|0)+1;g[a+224>>2]=b;return}function cm(a,b){a=a|0;b=+b;c[a+260>>2]=(c[a+260>>2]|0)+1;g[a+232>>2]=b;return}function dm(a){a=a|0;return a+4|0}function em(a){a=a|0;return c[a+204>>2]|0}function fm(a,b){a=a|0;b=b|0;c[a+204>>2]=b;return}function gm(a,b){a=a|0;b=b|0;c[a+260>>2]=(c[a+260>>2]|0)+1;c[a+4>>2]=c[b+0>>2];c[a+8>>2]=c[b+4>>2];c[a+12>>2]=c[b+8>>2];c[a+16>>2]=c[b+12>>2];c[a+20>>2]=c[b+16>>2];c[a+24>>2]=c[b+20>>2];c[a+28>>2]=c[b+24>>2];c[a+32>>2]=c[b+28>>2];c[a+36>>2]=c[b+32>>2];c[a+40>>2]=c[b+36>>2];c[a+44>>2]=c[b+40>>2];c[a+48>>2]=c[b+44>>2];c[a+52>>2]=c[b+48>>2];c[a+56>>2]=c[b+52>>2];c[a+60>>2]=c[b+56>>2];c[a+64>>2]=c[b+60>>2];return}function hm(a,b){a=a|0;b=b|0;var d=0;d=i;Lb[c[(c[a>>2]|0)+12>>2]&127](a,b);i=d;return}function im(a,b){a=a|0;b=+b;g[a+252>>2]=b;return}function jm(a,b){a=a|0;b=+b;g[a+248>>2]=b;return}function km(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Jb[c[(c[a>>2]|0)+8>>2]&255](a);i=b;return}function lm(a){a=a|0;return c[a>>2]|0}function mm(a,b){a=a|0;b=b|0;c[a>>2]=b;return}function nm(a){a=a|0;return c[a+4>>2]|0}function om(a,b){a=a|0;b=b|0;c[a+4>>2]=b;return}function pm(a){a=a|0;var b=0;b=i;if(a)RE(a);i=b;return}function qm(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Jb[c[(c[a>>2]|0)+4>>2]&255](a);i=b;return}function rm(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,h=0;h=i;c[5108]=(c[5108]|0)+1;f=QE(1407)|0;if(!f)f=0;else{c[(f+19&-16)+-4>>2]=f;f=f+19&-16}Aq(f,b,d,e);c[f>>2]=2640;c[f+4>>2]=9;a[f+1309>>0]=0;g[f+1316>>2]=0.0;g[f+1340>>2]=0.0;g[f+1364>>2]=1.0;a[f+1310>>0]=0;g[f+1320>>2]=0.0;g[f+1344>>2]=0.0;g[f+1368>>2]=1.0;a[f+1311>>0]=0;g[f+1324>>2]=0.0;g[f+1348>>2]=0.0;g[f+1372>>2]=1.0;a[f+1312>>0]=0;g[f+1328>>2]=0.0;g[f+1352>>2]=0.0;g[f+1376>>2]=1.0;a[f+1313>>0]=0;g[f+1332>>2]=0.0;g[f+1356>>2]=0.0;g[f+1380>>2]=1.0;a[f+1314>>0]=0;g[f+1336>>2]=0.0;g[f+1360>>2]=0.0;g[f+1384>>2]=1.0;i=h;return f|0}function sm(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var j=0,k=0;k=i;c[5108]=(c[5108]|0)+1;j=QE(1407)|0;if(!j)j=0;else{c[(j+19&-16)+-4>>2]=j;j=j+19&-16}zq(j,b,d,e,f,h);c[j>>2]=2640;c[j+4>>2]=9;a[j+1309>>0]=0;g[j+1316>>2]=0.0;g[j+1340>>2]=0.0;g[j+1364>>2]=1.0;a[j+1310>>0]=0;g[j+1320>>2]=0.0;g[j+1344>>2]=0.0;g[j+1368>>2]=1.0;a[j+1311>>0]=0;g[j+1324>>2]=0.0;g[j+1348>>2]=0.0;g[j+1372>>2]=1.0;a[j+1312>>0]=0;g[j+1328>>2]=0.0;g[j+1352>>2]=0.0;g[j+1376>>2]=1.0;a[j+1313>>0]=0;g[j+1332>>2]=0.0;g[j+1356>>2]=0.0;g[j+1380>>2]=1.0;a[j+1314>>0]=0;g[j+1336>>2]=0.0;g[j+1360>>2]=0.0;g[j+1384>>2]=1.0;i=k;return j|0}function tm(b,c,d){b=b|0;c=c|0;d=d|0;var e=0;e=i;a[b+c+1309>>0]=d&1;if((c|0)<3){a[b+c+788>>0]=d&1;i=e;return}else{a[b+(c+-3<<6)+912>>0]=d&1;i=e;return}}function um(a,b,c){a=a|0;b=b|0;c=+c;g[a+(b<<2)+1340>>2]=c;return}function vm(a,b,c){a=a|0;b=b|0;c=+c;g[a+(b<<2)+1364>>2]=c;return}function wm(a,b){a=a|0;b=b|0;c[a+680>>2]=c[b+0>>2];c[a+684>>2]=c[b+4>>2];c[a+688>>2]=c[b+8>>2];c[a+692>>2]=c[b+12>>2];return}function xm(a,b){a=a|0;b=b|0;c[a+696>>2]=c[b+0>>2];c[a+700>>2]=c[b+4>>2];c[a+704>>2]=c[b+8>>2];c[a+708>>2]=c[b+12>>2];return}function ym(a,b){a=a|0;b=b|0;var c=0.0,d=0,e=0;e=i;d=0;while(1){if((d|0)==3)break;c=+SE(+g[b+(d<<2)>>2],6.2831854820251465);if(!(c<-3.1415927410125732)){if(c>3.1415927410125732)c=c+-6.2831854820251465}else c=c+6.2831854820251465;g[a+(d<<6)+868>>2]=c;d=d+1|0}i=e;return}function zm(a,b){a=a|0;b=b|0;var c=0.0,d=0,e=0;e=i;d=0;while(1){if((d|0)==3)break;c=+SE(+g[b+(d<<2)>>2],6.2831854820251465);if(!(c<-3.1415927410125732)){if(c>3.1415927410125732)c=c+-6.2831854820251465}else c=c+6.2831854820251465;g[a+(d<<6)+872>>2]=c;d=d+1|0}i=e;return}function Am(b,c){b=b|0;c=c|0;a[b+21>>0]=c&1;return}function Bm(a){a=a|0;return +(+g[a+16>>2])}function Cm(a,b){a=a|0;b=+b;g[a+16>>2]=b;return}function Dm(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Jb[c[(c[a>>2]|0)+4>>2]&255](a);i=b;return}function Em(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=+f;var h=0,j=0;j=i;h=QE(44)|0;a:do if(!h){while(1){h=c[5230]|0;c[5230]=h+0;if(!h)break;qc[h&3]();h=QE(44)|0;if(h)break a}h=yb(4)|0;c[h>>2]=20816;wb(h|0,20864,207)}while(0);c[h>>2]=a;c[h+4>>2]=b;a=h+8|0;c[a+0>>2]=c[d+0>>2];c[a+4>>2]=c[d+4>>2];c[a+8>>2]=c[d+8>>2];c[a+12>>2]=c[d+12>>2];a=h+24|0;c[a+0>>2]=c[e+0>>2];c[a+4>>2]=c[e+4>>2];c[a+8>>2]=c[e+8>>2];c[a+12>>2]=c[e+12>>2];g[h+40>>2]=f;i=j;return h|0}function Fm(a){a=a|0;return c[a>>2]|0}function Gm(a,b){a=a|0;b=b|0;c[a>>2]=b;return}function Hm(a){a=a|0;return c[a+4>>2]|0}function Im(a,b){a=a|0;b=b|0;c[a+4>>2]=b;return}function Jm(a){a=a|0;return a+8|0}function Km(a,b){a=a|0;b=b|0;c[a+8>>2]=c[b+0>>2];c[a+12>>2]=c[b+4>>2];c[a+16>>2]=c[b+8>>2];c[a+20>>2]=c[b+12>>2];return}function Lm(a){a=a|0;return a+24|0}function Mm(a,b){a=a|0;b=b|0;c[a+24>>2]=c[b+0>>2];c[a+28>>2]=c[b+4>>2];c[a+32>>2]=c[b+8>>2];c[a+36>>2]=c[b+12>>2];return}function Nm(a){a=a|0;return +(+g[a+40>>2])}function Om(a,b){a=a|0;b=+b;g[a+40>>2]=b;return}function Pm(a){a=a|0;var b=0;b=i;if(a)RE(a);i=b;return}function Qm(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Jb[c[(c[a>>2]|0)+4>>2]&255](a);i=b;return}function Rm(b){b=b|0;var d=0,e=0,f=0;e=i;c[5108]=(c[5108]|0)+1;d=QE(635)|0;if(!d)d=0;else{c[(d+19&-16)+-4>>2]=d;d=d+19&-16}g[d+164>>2]=1.0;g[d+168>>2]=1.0;g[d+172>>2]=1.0;g[d+176>>2]=0.0;c[d+180>>2]=0;g[d+184>>2]=999999984306749440.0;f=d+188|0;c[f+0>>2]=0;c[f+4>>2]=0;c[f+8>>2]=0;c[f+12>>2]=0;c[d+204>>2]=1;c[d+208>>2]=-1;c[d+212>>2]=-1;c[d+216>>2]=1;g[d+220>>2]=0.0;g[d+224>>2]=.5;g[d+228>>2]=0.0;g[d+232>>2]=0.0;c[d+236>>2]=1;c[d+240>>2]=0;g[d+244>>2]=1.0;f=d+248|0;c[f+0>>2]=0;c[f+4>>2]=0;c[f+8>>2]=0;c[f+12>>2]=0;g[d+4>>2]=1.0;f=d+8|0;c[f+0>>2]=0;c[f+4>>2]=0;c[f+8>>2]=0;c[f+12>>2]=0;g[d+24>>2]=1.0;f=d+28|0;c[f+0>>2]=0;c[f+4>>2]=0;c[f+8>>2]=0;c[f+12>>2]=0;g[d+44>>2]=1.0;f=d+48|0;c[f+0>>2]=0;c[f+4>>2]=0;c[f+8>>2]=0;c[f+12>>2]=0;c[f+16>>2]=0;c[d>>2]=1464;a[d+500>>0]=1;c[d+496>>2]=0;c[d+488>>2]=0;c[d+492>>2]=0;sp(d,b);i=e;return d|0}function Sm(a){a=a|0;return a+4|0}function Tm(a,b){a=a|0;b=b|0;var c=0;c=i;up(a,b);i=c;return}function Um(a,b,c){a=a|0;b=+b;c=+c;g[a+472>>2]=b;g[a+476>>2]=c;return}function Vm(a,b,c){a=a|0;b=+b;c=+c;if(b<0.0)b=0.0;else b=b>1.0?1.0:b;g[a+444>>2]=b;if(c<0.0)b=0.0;else b=c>1.0?1.0:c;g[a+448>>2]=b;return}function Wm(a,b,d){a=a|0;b=+b;d=d|0;var e=0,f=0.0,h=0.0,i=0.0;e=c[a+204>>2]|0;if(b==0.0){c[a+204>>2]=e|1;i=0.0}else{c[a+204>>2]=e&-2;i=1.0/b}g[a+344>>2]=i;h=+g[a+384>>2]*b;f=+g[a+388>>2]*b;g[a+364>>2]=+g[a+380>>2]*b;g[a+368>>2]=h;g[a+372>>2]=f;g[a+376>>2]=0.0;b=+g[d>>2];if(b!=0.0)h=1.0/b;else h=0.0;b=+g[d+4>>2];if(b!=0.0)f=1.0/b;else f=0.0;b=+g[d+8>>2];if(b!=0.0)b=1.0/b;else b=0.0;g[a+396>>2]=h;g[a+400>>2]=f;g[a+404>>2]=b;g[a+408>>2]=0.0;f=i*+g[a+352>>2];b=i*+g[a+356>>2];g[a+560>>2]=+g[a+348>>2]*i;g[a+564>>2]=f;g[a+568>>2]=b;g[a+572>>2]=0.0;return}function Xm(a,b){a=a|0;b=b|0;var d=0.0,e=0.0,f=0.0;c[a+348>>2]=c[b+0>>2];c[a+352>>2]=c[b+4>>2];c[a+356>>2]=c[b+8>>2];c[a+360>>2]=c[b+12>>2];f=+g[a+344>>2];e=+g[a+352>>2]*f;d=+g[a+356>>2]*f;g[a+560>>2]=+g[a+348>>2]*f;g[a+564>>2]=e;g[a+568>>2]=d;g[a+572>>2]=0.0;return}function Ym(a,b){a=a|0;b=b|0;var c=0.0,d=0.0;d=+g[b+4>>2]*+g[a+548>>2];c=+g[b+8>>2]*+g[a+552>>2];g[a+428>>2]=+g[a+428>>2]+ +g[b>>2]*+g[a+544>>2];g[a+432>>2]=+g[a+432>>2]+d;g[a+436>>2]=+g[a+436>>2]+c;return}function Zm(a,b,c){a=a|0;b=b|0;c=c|0;var d=0.0,e=0.0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0;d=+g[a+348>>2];f=+g[a+352>>2];h=+g[b+4>>2]*f;i=+g[a+356>>2];j=+g[b+8>>2]*i;g[a+412>>2]=+g[a+412>>2]+ +g[b>>2]*d;g[a+416>>2]=+g[a+416>>2]+h;g[a+420>>2]=+g[a+420>>2]+j;d=+g[b>>2]*d;f=+g[b+4>>2]*f;i=+g[b+8>>2]*i;j=+g[c+4>>2];h=+g[c+8>>2];k=+g[c>>2];e=(h*d-k*i)*+g[a+548>>2];d=(k*f-j*d)*+g[a+552>>2];g[a+428>>2]=+g[a+428>>2]+(j*i-h*f)*+g[a+544>>2];g[a+432>>2]=+g[a+432>>2]+e;g[a+436>>2]=+g[a+436>>2]+d;return}function _m(a,b){a=a|0;b=b|0;var c=0.0,d=0.0;d=+g[b+4>>2]*+g[a+352>>2];c=+g[b+8>>2]*+g[a+356>>2];g[a+412>>2]=+g[a+412>>2]+ +g[b>>2]*+g[a+348>>2];g[a+416>>2]=+g[a+416>>2]+d;g[a+420>>2]=+g[a+420>>2]+c;return}function $m(a,b){a=a|0;b=b|0;var c=0.0,d=0.0,e=0.0,f=0.0,h=0.0;h=+g[b>>2];f=+g[b+4>>2];e=+g[b+8>>2];d=(+g[a+280>>2]*h+ +g[a+284>>2]*f+ +g[a+288>>2]*e)*+g[a+548>>2];c=(+g[a+296>>2]*h+ +g[a+300>>2]*f+ +g[a+304>>2]*e)*+g[a+552>>2];g[a+328>>2]=+g[a+328>>2]+(+g[a+264>>2]*h+ +g[a+268>>2]*f+ +g[a+272>>2]*e)*+g[a+544>>2];g[a+332>>2]=+g[a+332>>2]+d;g[a+336>>2]=+g[a+336>>2]+c;return}function an(a,b,c){a=a|0;b=b|0;c=c|0;var d=0;d=i;bn(a,b,c);i=d;return}function bn(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0.0,f=0.0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0;d=i;if(!(+g[a+344>>2]!=0.0)){i=d;return}dn(a,b);h=+g[b>>2]*+g[a+348>>2];k=+g[b+4>>2]*+g[a+352>>2];m=+g[b+8>>2]*+g[a+356>>2];j=+g[c+4>>2];n=+g[c+8>>2];l=+g[c>>2];f=(+g[a+280>>2]*(j*m-n*k)+ +g[a+284>>2]*(n*h-l*m)+ +g[a+288>>2]*(l*k-j*h))*+g[a+548>>2];e=(+g[a+296>>2]*(j*m-n*k)+ +g[a+300>>2]*(n*h-l*m)+ +g[a+304>>2]*(l*k-j*h))*+g[a+552>>2];g[a+328>>2]=+g[a+328>>2]+(+g[a+264>>2]*(j*m-n*k)+ +g[a+268>>2]*(n*h-l*m)+ +g[a+272>>2]*(l*k-j*h))*+g[a+544>>2];g[a+332>>2]=+g[a+332>>2]+f;g[a+336>>2]=+g[a+336>>2]+e;i=d;return}function cn(a,b){a=a|0;b=b|0;var c=0;c=i;dn(a,b);i=c;return}function dn(a,b){a=a|0;b=b|0;var c=0.0,d=0.0,e=0.0;e=+g[a+344>>2];d=+g[b+4>>2]*+g[a+352>>2]*e;c=+g[b+8>>2]*+g[a+356>>2]*e;g[a+312>>2]=+g[a+312>>2]+ +g[b>>2]*+g[a+348>>2]*e;g[a+316>>2]=+g[a+316>>2]+d;g[a+320>>2]=+g[a+320>>2]+c;return}function en(a){a=a|0;var b=0.0,c=0.0,d=0.0,e=0.0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0;n=+g[a+4>>2];h=+g[a+396>>2];m=+g[a+8>>2];e=+g[a+400>>2];l=+g[a+12>>2];c=+g[a+404>>2];k=+g[a+20>>2];j=+g[a+24>>2];i=+g[a+28>>2];f=+g[a+36>>2];d=+g[a+40>>2];b=+g[a+44>>2];g[a+264>>2]=n*(n*h)+m*(m*e)+l*(l*c);g[a+268>>2]=n*h*k+m*e*j+l*c*i;g[a+272>>2]=n*h*f+m*e*d+l*c*b;g[a+276>>2]=0.0;g[a+280>>2]=n*(h*k)+m*(e*j)+l*(c*i);g[a+284>>2]=k*(h*k)+j*(e*j)+i*(c*i);g[a+288>>2]=h*k*f+e*j*d+c*i*b;g[a+292>>2]=0.0;g[a+296>>2]=n*(h*f)+m*(e*d)+l*(c*b);g[a+300>>2]=k*(h*f)+j*(e*d)+i*(c*b);g[a+304>>2]=f*(h*f)+d*(e*d)+b*(c*b);g[a+308>>2]=0.0;return}function fn(a){a=a|0;return a+312|0}function gn(a){a=a|0;return a+328|0}function hn(a,b){a=a|0;b=b|0;c[a+260>>2]=(c[a+260>>2]|0)+1;c[a+312>>2]=c[b+0>>2];c[a+316>>2]=c[b+4>>2];c[a+320>>2]=c[b+8>>2];c[a+324>>2]=c[b+12>>2];return}function jn(a,b){a=a|0;b=b|0;c[a+260>>2]=(c[a+260>>2]|0)+1;c[a+328>>2]=c[b+0>>2];c[a+332>>2]=c[b+4>>2];c[a+336>>2]=c[b+8>>2];c[a+340>>2]=c[b+12>>2];return}function kn(a){a=a|0;return c[a+480>>2]|0}function ln(a,b){a=a|0;b=b|0;c[a+260>>2]=(c[a+260>>2]|0)+1;c[a+544>>2]=c[b+0>>2];c[a+548>>2]=c[b+4>>2];c[a+552>>2]=c[b+8>>2];c[a+556>>2]=c[b+12>>2];return}function mn(a,b){a=a|0;b=b|0;return ((c[b+236>>2]&2|0)==0?0:b)|0}function nn(a,b,d){a=a|0;b=b|0;d=d|0;var e=0;e=i;c[a+164>>2]=c[b+0>>2];c[a+168>>2]=c[b+4>>2];c[a+172>>2]=c[b+8>>2];c[a+176>>2]=c[b+12>>2];if((!(+g[b>>2]!=1.0)?!(+g[b+4>>2]!=1.0):0)?!(+g[b+8>>2]!=1.0):0){d=0;b=a+180|0;c[b>>2]=d;i=e;return}b=a+180|0;c[b>>2]=d;i=e;return}function on(a){a=a|0;return c[a+192>>2]|0}function pn(a,b){a=a|0;b=+b;g[a+184>>2]=b;return}function qn(a,b){a=a|0;b=b|0;var d=0;d=i;if((c[a+216>>2]&-2|0)==4){i=d;return}c[a+216>>2]=b;i=d;return}function rn(a,b){a=a|0;b=b|0;c[a+216>>2]=b;return}function sn(a){a=a|0;var b=0;b=i;if(c[a+204>>2]&3){i=b;return}if((c[a+216>>2]&-2|0)!=4)c[a+216>>2]=1;g[a+220>>2]=0.0;i=b;return}function tn(a,b){a=a|0;b=b|0;var d=0;d=i;if(!b?(c[a+204>>2]&3|0)!=0:0){i=d;return}if((c[a+216>>2]&-2|0)!=4)c[a+216>>2]=1;g[a+220>>2]=0.0;i=d;return}function un(a){a=a|0;a=c[a+216>>2]|0;return ((a|0)==2?0:(a|0)!=5)|0}function vn(a){a=a|0;return (c[a+204>>2]&2|0)!=0|0}function wn(a,b){a=a|0;b=+b;c[a+260>>2]=(c[a+260>>2]|0)+1;g[a+228>>2]=b;return}function xn(a,b){a=a|0;b=+b;c[a+260>>2]=(c[a+260>>2]|0)+1;g[a+224>>2]=b;return}function yn(a,b){a=a|0;b=+b;c[a+260>>2]=(c[a+260>>2]|0)+1;g[a+232>>2]=b;return}function zn(a){a=a|0;return a+4|0}function An(a){a=a|0;return c[a+204>>2]|0}function Bn(a,b){a=a|0;b=b|0;c[a+204>>2]=b;return}function Cn(a,b){a=a|0;b=b|0;c[a+260>>2]=(c[a+260>>2]|0)+1;c[a+4>>2]=c[b+0>>2];c[a+8>>2]=c[b+4>>2];c[a+12>>2]=c[b+8>>2];c[a+16>>2]=c[b+12>>2];c[a+20>>2]=c[b+16>>2];c[a+24>>2]=c[b+20>>2];c[a+28>>2]=c[b+24>>2];c[a+32>>2]=c[b+28>>2];c[a+36>>2]=c[b+32>>2];c[a+40>>2]=c[b+36>>2];c[a+44>>2]=c[b+40>>2];c[a+48>>2]=c[b+44>>2];c[a+52>>2]=c[b+48>>2];c[a+56>>2]=c[b+52>>2];c[a+60>>2]=c[b+56>>2];c[a+64>>2]=c[b+60>>2];return}function Dn(a,b){a=a|0;b=b|0;var d=0;d=i;Lb[c[(c[a>>2]|0)+12>>2]&127](a,b);i=d;return}function En(a,b){a=a|0;b=+b;g[a+252>>2]=b;return}function Fn(a,b){a=a|0;b=+b;g[a+248>>2]=b;return}function Gn(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Jb[c[(c[a>>2]|0)+8>>2]&255](a);i=b;return}function Hn(a){a=a|0;var b=0,d=0;d=i;c[5108]=(c[5108]|0)+1;b=QE(75)|0;if(!b)b=0;else{c[(b+19&-16)+-4>>2]=b;b=b+19&-16}dA(b,a);c[b>>2]=15552;c[b+52>>2]=0;i=d;return b|0}function In(a,b){a=a|0;b=b|0;var d=0;d=i;Lb[c[(c[a>>2]|0)+24>>2]&127](a,b);i=d;return}function Jn(a,b,d){a=a|0;b=+b;d=d|0;var e=0;e=i;Sb[c[(c[a>>2]|0)+32>>2]&15](a,b,d);i=e;return}function Kn(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Jb[c[(c[a>>2]|0)+4>>2]&255](a);i=b;return}function Ln(a){a=a|0;var b=0,d=0;d=i;c[5108]=(c[5108]|0)+1;b=QE(75)|0;if(!b)b=0;else{c[(b+19&-16)+-4>>2]=b;b=b+19&-16}dA(b,a);c[b>>2]=15656;c[b+52>>2]=2;i=d;return b|0}function Mn(a,b){a=a|0;b=b|0;var d=0;d=i;Lb[c[(c[a>>2]|0)+24>>2]&127](a,b);i=d;return}function Nn(a,b,d){a=a|0;b=+b;d=d|0;var e=0;e=i;Sb[c[(c[a>>2]|0)+32>>2]&15](a,b,d);i=e;return}function On(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Jb[c[(c[a>>2]|0)+4>>2]&255](a);i=b;return}function Pn(){var a=0,b=0,d=0;d=i;a=QE(64)|0;if(a){i=d;return a|0}while(1){a=c[5230]|0;c[5230]=a+0;if(!a){b=4;break}qc[a&3]();a=QE(64)|0;if(a){b=5;break}}if((b|0)==4){a=yb(4)|0;c[a>>2]=20816;wb(a|0,20864,207)}else if((b|0)==5){i=d;return a|0}return 0}function Qn(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;e=i;d=QE(64)|0;a:do if(!d){while(1){d=c[5230]|0;c[5230]=d+0;if(!d)break;qc[d&3]();d=QE(64)|0;if(d)break a}d=yb(4)|0;c[d>>2]=20816;wb(d|0,20864,207)}while(0);f=d+48|0;Zo(d,a);c[f+0>>2]=c[b+0>>2];c[f+4>>2]=c[b+4>>2];c[f+8>>2]=c[b+8>>2];c[f+12>>2]=c[b+12>>2];i=e;return d|0}function Rn(a){a=a|0;var b=0;b=i;Sn(a);i=b;return}function Sn(a){a=a|0;g[a>>2]=1.0;c[a+4>>2]=0;c[a+8>>2]=0;c[a+12>>2]=0;c[a+16>>2]=0;g[a+20>>2]=1.0;c[a+24>>2]=0;c[a+28>>2]=0;c[a+32>>2]=0;c[a+36>>2]=0;g[a+40>>2]=1.0;g[a+44>>2]=0.0;c[a+48>>2]=0;c[a+52>>2]=0;c[a+56>>2]=0;c[a+60>>2]=0;return}function Tn(a,b){a=a|0;b=b|0;c[a+48>>2]=c[b+0>>2];c[a+52>>2]=c[b+4>>2];c[a+56>>2]=c[b+8>>2];c[a+60>>2]=c[b+12>>2];return}function Un(a,b){a=a|0;b=b|0;var c=0;c=i;Zo(a,b);i=c;return}function Vn(a){a=a|0;return a+48|0}function Wn(b){b=b|0;var d=0;d=i;i=i+16|0;if((a[240]|0)==0?(Xa(240)|0)!=0:0)ab(240);Fc(b,d);c[56]=c[d+0>>2];c[57]=c[d+4>>2];c[58]=c[d+8>>2];c[59]=c[d+12>>2];i=d;return 224}function Xn(a){a=a|0;return a|0}function Yn(a){a=a|0;var b=0;b=i;if(a)RE(a);i=b;return}function Zn(a){a=a|0;return c[a+24>>2]|0}function _n(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0;f=i;tc[c[(c[a>>2]|0)+32>>2]&127](a,b,d,e);i=f;return}function $n(a){a=a|0;var b=0;b=i;a=c[a+68>>2]|0;a=Nb[c[(c[a>>2]|0)+36>>2]&127](a)|0;i=b;return a|0}function ao(a){a=a|0;return a+28|0}function bo(a,b){a=a|0;b=b|0;var d=0;d=i;tc[c[(c[a>>2]|0)+36>>2]&127](a,b,1,-1);i=d;return}function co(a,b,d){a=a|0;b=b|0;d=d|0;var e=0;e=i;tc[c[(c[a>>2]|0)+36>>2]&127](a,b,d,-1);i=e;return}function eo(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0;f=i;tc[c[(c[a>>2]|0)+36>>2]&127](a,b,d,e);i=f;return}function fo(a){a=a|0;return c[a+68>>2]|0}function go(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=+f;var g=0;g=i;_u(a,b,c,d,e,f);i=g;return}function ho(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0;e=i;$u(a,b,c,d);i=e;return}function io(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Jb[c[(c[a>>2]|0)+4>>2]&255](a);i=b;return}function jo(a){a=a|0;return +(+g[a>>2])}function ko(a){a=a|0;return +(+g[a+4>>2])}function lo(a){a=a|0;return +(+g[a+8>>2])}function mo(a){a=a|0;return +(+g[a+12>>2])}function no(a,b){a=a|0;b=+b;g[a>>2]=b;return}function oo(a,b){a=a|0;b=+b;g[a+4>>2]=b;return}function po(a,b){a=a|0;b=+b;g[a+8>>2]=b;return}function qo(a,b){a=a|0;b=+b;g[a+12>>2]=b;return}function ro(a){a=a|0;var b=0;b=i;if(a)RE(a);i=b;return}function so(b,d,e){b=b|0;d=d|0;e=e|0;var f=0;f=i;b=QE(152)|0;a:do if(!b){while(1){b=c[5230]|0;c[5230]=b+0;if(!b)break;qc[b&3]();b=QE(152)|0;if(b)break a}b=yb(4)|0;c[b>>2]=20816;wb(b|0,20864,207)}while(0);c[b>>2]=4840;a[b+20>>0]=1;c[b+16>>2]=0;c[b+8>>2]=0;c[b+12>>2]=0;a[b+40>>0]=1;c[b+36>>2]=0;c[b+28>>2]=0;c[b+32>>2]=0;a[b+60>>0]=1;c[b+56>>2]=0;c[b+48>>2]=0;c[b+52>>2]=0;a[b+80>>0]=1;c[b+76>>2]=0;c[b+68>>2]=0;c[b+72>>2]=0;c[b+100>>2]=e;g[b+104>>2]=0.0;a[b+148>>0]=1;c[b+144>>2]=0;c[b+136>>2]=0;c[b+140>>2]=0;c[b+116>>2]=d;c[b+120>>2]=0;c[b+124>>2]=2;c[b+128>>2]=1;g[b+112>>2]=0.0;g[b+108>>2]=0.0;i=f;return b|0}function to(a,b,d){a=a|0;b=+b;d=d|0;g[(c[a+144>>2]|0)+(d*284|0)+252>>2]=b;return}function uo(a,b,d){a=a|0;b=+b;d=d|0;g[(c[a+144>>2]|0)+(d*284|0)+232>>2]=b;return}function vo(a,b){a=a|0;b=b|0;return (c[a+144>>2]|0)+(b*284|0)+92|0}function wo(a,b,d){a=a|0;b=b|0;d=d|0;var e=0;e=i;fs(c[a+116>>2]|0,c[a+144>>2]|0,b,d);i=e;return}function xo(b,d,e,f,h,j,k,l){b=b|0;d=d|0;e=e|0;f=f|0;h=+h;j=+j;k=k|0;l=l|0;var m=0,n=0,o=0,p=0,q=0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0;x=i;i=i+288|0;c[x+144>>2]=c[d+0>>2];c[x+148>>2]=c[d+4>>2];c[x+152>>2]=c[d+8>>2];c[x+156>>2]=c[d+12>>2];o=x+160|0;c[o+0>>2]=c[e+0>>2];c[o+4>>2]=c[e+4>>2];c[o+8>>2]=c[e+8>>2];c[o+12>>2]=c[e+12>>2];p=x+176|0;c[p+0>>2]=c[f+0>>2];c[p+4>>2]=c[f+4>>2];c[p+8>>2]=c[f+8>>2];c[p+12>>2]=c[f+12>>2];s=+g[k>>2];t=+g[k+4>>2];u=+g[k+8>>2];v=+g[k+16>>2];w=+g[k+12>>2];r=+g[k+20>>2];c[x+0>>2]=c[x+144>>2];c[x+4>>2]=c[x+148>>2];c[x+8>>2]=c[x+152>>2];c[x+12>>2]=c[x+156>>2];c[x+16>>2]=c[o+0>>2];c[x+20>>2]=c[o+4>>2];c[x+24>>2]=c[o+8>>2];c[x+28>>2]=c[o+12>>2];c[x+32>>2]=c[p+0>>2];c[x+36>>2]=c[p+4>>2];c[x+40>>2]=c[p+8>>2];c[x+44>>2]=c[p+12>>2];f=c[b+136>>2]|0;if((f|0)==(c[b+140>>2]|0)?(q=(f|0)==0?1:f<<1,(f|0)<(q|0)):0){if(!q)e=0;else{c[5108]=(c[5108]|0)+1;f=QE((q*284|3)+16|0)|0;if(!f)e=0;else{c[(f+19&-16)+-4>>2]=f;e=f+19&-16}f=c[b+136>>2]|0}if((f|0)>0){m=0;do{k=e+(m*284|0)|0;if(k){d=c[b+144>>2]|0;n=k+0|0;o=d+(m*284|0)+0|0;p=n+92|0;do{c[n>>2]=c[o>>2];n=n+4|0;o=o+4|0}while((n|0)<(p|0));n=e+(m*284|0)+92|0;o=d+(m*284|0)+92|0;c[n+0>>2]=c[o+0>>2];c[n+4>>2]=c[o+4>>2];c[n+8>>2]=c[o+8>>2];c[n+12>>2]=c[o+12>>2];n=e+(m*284|0)+108|0;o=d+(m*284|0)+108|0;c[n+0>>2]=c[o+0>>2];c[n+4>>2]=c[o+4>>2];c[n+8>>2]=c[o+8>>2];c[n+12>>2]=c[o+12>>2];n=e+(m*284|0)+124|0;o=d+(m*284|0)+124|0;c[n+0>>2]=c[o+0>>2];c[n+4>>2]=c[o+4>>2];c[n+8>>2]=c[o+8>>2];c[n+12>>2]=c[o+12>>2];n=e+(m*284|0)+140|0;o=d+(m*284|0)+140|0;c[n+0>>2]=c[o+0>>2];c[n+4>>2]=c[o+4>>2];c[n+8>>2]=c[o+8>>2];c[n+12>>2]=c[o+12>>2];n=e+(m*284|0)+156|0;o=d+(m*284|0)+156|0;p=n+128|0;do{c[n>>2]=c[o>>2];n=n+4|0;o=o+4|0}while((n|0)<(p|0))}m=m+1|0}while((m|0)!=(f|0))}f=c[b+144>>2]|0;if(f){if(a[b+148>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[f+-4>>2]|0)}c[b+144>>2]=0}a[b+148>>0]=1;c[b+144>>2]=e;c[b+140>>2]=q;f=c[b+136>>2]|0}k=c[b+144>>2]|0;e=k+(f*284|0)|0;if(!e){q=f;o=k;p=q+1|0;c[b+136>>2]=p;q=o+(q*284|0)|0;o=b+116|0;p=c[o>>2]|0;es(p,q,0);p=c[b+136>>2]|0;p=p+-1|0;o=c[o>>2]|0;l=c[b+144>>2]|0;fs(o,l,p,0);i=x;return q|0}n=e+0|0;o=x+48|0;p=n+92|0;do{c[n>>2]=c[o>>2];n=n+4|0;o=o+4|0}while((n|0)<(p|0));n=k+(f*284|0)+92|0;c[n+0>>2]=c[x+240>>2];c[n+4>>2]=c[x+244>>2];c[n+8>>2]=c[x+248>>2];c[n+12>>2]=c[x+252>>2];n=k+(f*284|0)+108|0;c[n+0>>2]=c[x+224>>2];c[n+4>>2]=c[x+228>>2];c[n+8>>2]=c[x+232>>2];c[n+12>>2]=c[x+236>>2];n=k+(f*284|0)+124|0;c[n+0>>2]=c[x+208>>2];c[n+4>>2]=c[x+212>>2];c[n+8>>2]=c[x+216>>2];c[n+12>>2]=c[x+220>>2];n=k+(f*284|0)+140|0;c[n+0>>2]=c[x+192>>2];c[n+4>>2]=c[x+196>>2];c[n+8>>2]=c[x+200>>2];c[n+12>>2]=c[x+204>>2];k=k+(f*284|0)+156|0;n=k+0|0;o=x+0|0;p=n+48|0;do{c[n>>2]=c[o>>2];n=n+4|0;o=o+4|0}while((n|0)<(p|0));g[k+48>>2]=h;g[k+52>>2]=w;g[k+56>>2]=j;g[k+60>>2]=s;g[k+64>>2]=t;g[k+68>>2]=u;g[k+72>>2]=v;g[k+76>>2]=0.0;g[k+80>>2]=0.0;g[k+84>>2]=0.0;g[k+88>>2]=.10000000149011612;g[k+92>>2]=r;g[k+96>>2]=0.0;g[k+100>>2]=0.0;a[k+104>>0]=l&1;n=k+105|0;o=x+256|0;p=n+23|0;do{a[n>>0]=a[o>>0]|0;n=n+1|0;o=o+1|0}while((n|0)<(p|0));q=c[b+136>>2]|0;o=c[b+144>>2]|0;p=q+1|0;c[b+136>>2]=p;q=o+(q*284|0)|0;o=b+116|0;p=c[o>>2]|0;es(p,q,0);p=c[b+136>>2]|0;p=p+-1|0;o=c[o>>2]|0;l=c[b+144>>2]|0;fs(o,l,p,0);i=x;return q|0}function yo(a){a=a|0;return c[a+136>>2]|0}function zo(a){a=a|0;return c[a+116>>2]|0}function Ao(a,b){a=a|0;b=b|0;return (c[a+144>>2]|0)+(b*284|0)|0}function Bo(a,b,d){a=a|0;b=+b;d=d|0;g[(c[a+144>>2]|0)+(d*284|0)+256>>2]=b;return}function Co(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0;f=i;tc[c[(c[a>>2]|0)+24>>2]&127](a,b,d,e);i=f;return}function Do(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Jb[c[(c[a>>2]|0)+4>>2]&255](a);i=b;return}function Eo(a){a=a|0;var b=0,d=0;d=i;c[5108]=(c[5108]|0)+1;b=QE(75)|0;if(!b)b=0;else{c[(b+19&-16)+-4>>2]=b;b=b+19&-16}dA(b,a);i=d;return b|0}function Fo(a,b){a=a|0;b=b|0;var d=0;d=i;Lb[c[(c[a>>2]|0)+24>>2]&127](a,b);i=d;return}function Go(a,b,d){a=a|0;b=+b;d=d|0;var e=0;e=i;Sb[c[(c[a>>2]|0)+32>>2]&15](a,b,d);i=e;return}function Ho(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Jb[c[(c[a>>2]|0)+4>>2]&255](a);i=b;return}function Io(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Jb[c[(c[a>>2]|0)+4>>2]&255](a);i=b;return}function Jo(){var a=0,b=0,d=0;d=i;a=QE(4)|0;if(a){c[a>>2]=384;i=d;return a|0}while(1){a=c[5230]|0;c[5230]=a+0;if(!a){b=4;break}qc[a&3]();a=QE(4)|0;if(a){b=5;break}}if((b|0)==4){a=yb(4)|0;c[a>>2]=20816;wb(a|0,20864,207)}else if((b|0)==5){c[a>>2]=384;i=d;return a|0}return 0}function Ko(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Jb[c[(c[a>>2]|0)+4>>2]&255](a);i=b;return}function Lo(b,c){b=b|0;c=c|0;a[b+21>>0]=c&1;return}function Mo(a){a=a|0;return +(+g[a+16>>2])}function No(a,b){a=a|0;b=+b;g[a+16>>2]=b;return}function Oo(a){a=a|0;var b=0;b=i;if(!a){i=b;return}Jb[c[(c[a>>2]|0)+4>>2]&255](a);i=b;return}function Po(a){a=a|0;return}function Qo(a){a=a|0;var b=0;b=i;if(!a){i=b;return}c[5110]=(c[5110]|0)+1;RE(c[a+-4>>2]|0);i=b;return}function Ro(a){a=a|0;return}function So(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=+e;return}function To(a,b,c,d){a=a|0;b=b|0;c=c|0;d=+d;return}function Uo(a){a=a|0;return}function Vo(a){a=a|0;var b=0;b=i;RE(a);i=b;return}function Wo(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;f=i;a=c[b>>2]|0;e=c[d>>2]|0;a=(c[a+236>>2]|0)==4?a:0;e=(c[e+236>>2]|0)==4?e:0;if(a)pc[c[(c[a>>2]|0)+28>>2]&127](a,d,b);if(!e){i=f;return 0}pc[c[(c[e>>2]|0)+28>>2]&127](e,b,d);i=f;return 0}function Xo(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0;g=i;a=c[b>>2]|0;f=c[d>>2]|0;a=(c[a+236>>2]|0)==4?a:0;f=(c[f+236>>2]|0)==4?f:0;if(a)tc[c[(c[a>>2]|0)+32>>2]&127](a,d,e,b);if(!f){i=g;return 0}tc[c[(c[f>>2]|0)+32>>2]&127](f,b,e,d);i=g;return 0}function Yo(a,b,c){a=a|0;b=b|0;c=c|0;return}function Zo(a,b){a=a|0;b=b|0;var c=0.0,d=0.0,e=0.0,f=0.0,h=0.0,i=0.0,j=0.0;f=+g[b>>2];d=+g[b+4>>2];j=+g[b+8>>2];h=+g[b+12>>2];e=f*(2.0/(f*f+d*d+j*j+h*h));c=d*(2.0/(f*f+d*d+j*j+h*h));i=j*(2.0/(f*f+d*d+j*j+h*h));g[a>>2]=1.0-(d*c+j*i);g[a+4>>2]=f*c-h*i;g[a+8>>2]=f*i+h*c;g[a+12>>2]=0.0;g[a+16>>2]=f*c+h*i;g[a+20>>2]=1.0-(f*e+j*i);g[a+24>>2]=d*i-h*e;g[a+28>>2]=0.0;g[a+32>>2]=f*i-h*c;g[a+36>>2]=d*i+h*e;g[a+40>>2]=1.0-(f*e+d*c);g[a+44>>2]=0.0;return}function _o(a){a=a|0;return}function $o(a){a=a|0;return}function ap(a){a=a|0;var b=0;b=i;RE(a);i=b;return}function bp(a,c){a=a|0;c=c|0;var d=0;d=i;if(!((b[c+4>>1]&b[a+14>>1])<<16>>16)){c=0;i=d;return c|0}c=(b[a+12>>1]&b[c+6>>1])<<16>>16!=0;i=d;return c|0}function cp(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0;g[a+4>>2]=+g[b+24>>2];e=c[b>>2]|0;c[a+8>>2]=e;if(d){c[a+52>>2]=c[b+8>>2];c[a+56>>2]=c[b+12>>2];c[a+60>>2]=c[b+16>>2];c[a+64>>2]=c[b+20>>2]}else{k=+g[b+8>>2];j=+g[b+12>>2];i=+g[b+16>>2];h=+g[e+20>>2]*k+ +g[e+24>>2]*j+ +g[e+28>>2]*i;f=+g[e+36>>2]*k+ +g[e+40>>2]*j+ +g[e+44>>2]*i;g[a+52>>2]=+g[e+4>>2]*k+ +g[e+8>>2]*j+ +g[e+12>>2]*i;g[a+56>>2]=h;g[a+60>>2]=f;g[a+64>>2]=0.0}f=+g[b+24>>2];g[a+68>>2]=(1.0-f)*+g[a+20>>2]+ +g[a+36>>2]*f;g[a+72>>2]=(1.0-f)*+g[a+24>>2]+f*+g[a+40>>2];g[a+76>>2]=(1.0-f)*+g[a+28>>2]+f*+g[a+44>>2];return +(+g[b+24>>2])}function dp(a){a=a|0;return}function ep(a){a=a|0;return}function fp(a){a=a|0;var b=0;b=i;if(!a){i=b;return}c[5110]=(c[5110]|0)+1;RE(c[a+-4>>2]|0);i=b;return}function gp(a,b){a=a|0;b=b|0;var d=0,e=0.0,f=0.0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0;d=i;i=i+176|0;r=+g[a+68>>2];g[d+128>>2]=r;q=+g[a+84>>2];g[d+132>>2]=q;p=+g[a+100>>2];g[d+136>>2]=p;g[d+140>>2]=0.0;o=+g[a+72>>2];g[d+144>>2]=o;n=+g[a+88>>2];g[d+148>>2]=n;m=+g[a+104>>2];g[d+152>>2]=m;g[d+156>>2]=0.0;l=+g[a+76>>2];g[d+160>>2]=l;j=+g[a+92>>2];g[d+164>>2]=j;f=+g[a+108>>2];g[d+168>>2]=f;g[d+172>>2]=0.0;k=-+g[a+116>>2];h=-+g[a+120>>2];e=-+g[a+124>>2];c[d+0>>2]=c[d+128>>2];c[d+4>>2]=c[d+132>>2];c[d+8>>2]=c[d+136>>2];c[d+12>>2]=c[d+140>>2];c[d+16>>2]=c[d+144>>2];c[d+20>>2]=c[d+148>>2];c[d+24>>2]=c[d+152>>2];c[d+28>>2]=c[d+156>>2];c[d+32>>2]=c[d+160>>2];c[d+36>>2]=c[d+164>>2];c[d+40>>2]=c[d+168>>2];c[d+44>>2]=c[d+172>>2];g[d+48>>2]=r*k+q*h+p*e;g[d+52>>2]=o*k+n*h+m*e;g[d+56>>2]=l*k+j*h+f*e;g[d+60>>2]=0.0;ip(d+64|0,d,a+4|0);c[b+0>>2]=c[d+64>>2];c[b+4>>2]=c[d+68>>2];c[b+8>>2]=c[d+72>>2];c[b+12>>2]=c[d+76>>2];c[b+16>>2]=c[d+80>>2];c[b+20>>2]=c[d+84>>2];c[b+24>>2]=c[d+88>>2];c[b+28>>2]=c[d+92>>2];c[b+32>>2]=c[d+96>>2];c[b+36>>2]=c[d+100>>2];c[b+40>>2]=c[d+104>>2];c[b+44>>2]=c[d+108>>2];c[b+48>>2]=c[d+112>>2];c[b+52>>2]=c[d+116>>2];c[b+56>>2]=c[d+120>>2];c[b+60>>2]=c[d+124>>2];i=d;return}function hp(a,b){a=a|0;b=b|0;var d=0;d=i;i=i+64|0;ip(d,b,a+68|0);c[a+4>>2]=c[d+0>>2];c[a+8>>2]=c[d+4>>2];c[a+12>>2]=c[d+8>>2];c[a+16>>2]=c[d+12>>2];c[a+20>>2]=c[d+16>>2];c[a+24>>2]=c[d+20>>2];c[a+28>>2]=c[d+24>>2];c[a+32>>2]=c[d+28>>2];c[a+36>>2]=c[d+32>>2];c[a+40>>2]=c[d+36>>2];c[a+44>>2]=c[d+40>>2];c[a+48>>2]=c[d+44>>2];c[a+52>>2]=c[d+48>>2];c[a+56>>2]=c[d+52>>2];c[a+60>>2]=c[d+56>>2];c[a+64>>2]=c[d+60>>2];i=d;return}function ip(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0.0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0;e=i;i=i+48|0;y=+g[d>>2];s=+g[b>>2];x=+g[d+16>>2];r=+g[b+4>>2];w=+g[d+32>>2];j=+g[b+8>>2];v=+g[d+4>>2];u=+g[d+20>>2];t=+g[d+36>>2];k=+g[d+8>>2];m=+g[d+24>>2];o=+g[d+40>>2];q=+g[b+16>>2];p=+g[b+20>>2];h=+g[b+24>>2];n=+g[b+32>>2];l=+g[b+36>>2];f=+g[b+40>>2];g[e>>2]=y*s+x*r+w*j;g[e+4>>2]=v*s+u*r+t*j;g[e+8>>2]=k*s+m*r+o*j;g[e+12>>2]=0.0;g[e+16>>2]=y*q+x*p+w*h;g[e+20>>2]=v*q+u*p+t*h;g[e+24>>2]=k*q+m*p+o*h;g[e+28>>2]=0.0;g[e+32>>2]=y*n+x*l+w*f;g[e+36>>2]=v*n+u*l+t*f;g[e+40>>2]=k*n+m*l+o*f;g[e+44>>2]=0.0;o=+g[d+48>>2];m=+g[d+52>>2];k=+g[d+56>>2];j=o*s+m*r+k*j+ +g[b+48>>2];h=o*q+m*p+k*h+ +g[b+52>>2];f=o*n+m*l+k*f+ +g[b+56>>2];c[a+0>>2]=c[e+0>>2];c[a+4>>2]=c[e+4>>2];c[a+8>>2]=c[e+8>>2];c[a+12>>2]=c[e+12>>2];c[a+16>>2]=c[e+16>>2];c[a+20>>2]=c[e+20>>2];c[a+24>>2]=c[e+24>>2];c[a+28>>2]=c[e+28>>2];c[a+32>>2]=c[e+32>>2];c[a+36>>2]=c[e+36>>2];c[a+40>>2]=c[e+40>>2];c[a+44>>2]=c[e+44>>2];g[a+48>>2]=j;g[a+52>>2]=h;g[a+56>>2]=f;g[a+60>>2]=0.0;i=e;return}function jp(a){a=a|0;return}function kp(a){a=a|0;var b=0;b=i;RE(a);i=b;return}
function RD(b){b=b|0;var d=0,e=0;e=i;c[b>>2]=20040;d=c[b+32>>2]|0;if(!d){a[b+36>>0]=1;c[b+32>>2]=0;c[b+24>>2]=0;c[b+28>>2]=0;d=c[5110]|0;d=d+1|0;c[5110]=d;d=b+-4|0;d=c[d>>2]|0;RE(d);i=e;return}if(a[b+36>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}a[b+36>>0]=1;c[b+32>>2]=0;c[b+24>>2]=0;c[b+28>>2]=0;d=c[5110]|0;d=d+1|0;c[5110]=d;d=b+-4|0;d=c[d>>2]|0;RE(d);i=e;return}function SD(a,b,d,e,f,g,h,i,j,k){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;a=c[a+32>>2]|0;c[d>>2]=c[a+(k<<5)+12>>2];c[b>>2]=c[a+(k<<5)+16>>2];c[e>>2]=c[a+(k<<5)+28>>2];c[f>>2]=c[a+(k<<5)+20>>2];c[i>>2]=c[a+(k<<5)>>2];c[g>>2]=c[a+(k<<5)+4>>2];c[h>>2]=c[a+(k<<5)+8>>2];c[j>>2]=c[a+(k<<5)+24>>2];return}function TD(a,b,d,e,f,g,h,i,j,k){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;a=c[a+32>>2]|0;c[d>>2]=c[a+(k<<5)+12>>2];c[b>>2]=c[a+(k<<5)+16>>2];c[e>>2]=c[a+(k<<5)+28>>2];c[f>>2]=c[a+(k<<5)+20>>2];c[i>>2]=c[a+(k<<5)>>2];c[g>>2]=c[a+(k<<5)+4>>2];c[h>>2]=c[a+(k<<5)+8>>2];c[j>>2]=c[a+(k<<5)+24>>2];return}function UD(a){a=a|0;return (c[a+48>>2]|0)==1|0}function VD(a,b,d){a=a|0;b=b|0;d=d|0;c[a+52>>2]=c[b+0>>2];c[a+56>>2]=c[b+4>>2];c[a+60>>2]=c[b+8>>2];c[a+64>>2]=c[b+12>>2];c[a+68>>2]=c[d+0>>2];c[a+72>>2]=c[d+4>>2];c[a+76>>2]=c[d+8>>2];c[a+80>>2]=c[d+12>>2];c[a+48>>2]=1;return}function WD(a,b,d){a=a|0;b=b|0;d=d|0;c[b+0>>2]=c[a+52>>2];c[b+4>>2]=c[a+56>>2];c[b+8>>2]=c[a+60>>2];c[b+12>>2]=c[a+64>>2];c[d+0>>2]=c[a+68>>2];c[d+4>>2]=c[a+72>>2];c[d+8>>2]=c[a+76>>2];c[d+12>>2]=c[a+80>>2];return}function XD(a,b){a=a|0;b=b|0;return}function YD(a,b){a=a|0;b=b|0;return}function ZD(a,b,f,j){a=a|0;b=b|0;f=f|0;j=j|0;var k=0.0,l=0.0,m=0.0,n=0,o=0,p=0.0,q=0.0,r=0,s=0,t=0,u=0,v=0;o=i;i=i+80|0;j=Nb[c[(c[a>>2]|0)+28>>2]&127](a)|0;k=+g[a+4>>2];l=+g[a+8>>2];m=+g[a+12>>2];if((j|0)<=0){i=o;return}n=0;do{dc[c[(c[a>>2]|0)+16>>2]&3](a,o+76|0,o+52|0,o+64|0,o+56|0,o+72|0,o+68|0,o+48|0,o+60|0,n);f=c[o+64>>2]|0;do if(!f){f=c[o+60>>2]|0;if((f|0)==3){if((c[o+48>>2]|0)>0)f=0;else break;do{u=c[o+72>>2]|0;t=$(c[o+68>>2]|0,f)|0;s=c[o+76>>2]|0;r=c[o+56>>2]|0;v=$(e[u+t>>1]|0,r)|0;q=l*+g[s+(v+4)>>2];p=m*+g[s+(v+8)>>2];g[o>>2]=k*+g[s+v>>2];g[o+4>>2]=q;g[o+8>>2]=p;g[o+12>>2]=0.0;v=$(e[u+(t+2)>>1]|0,r)|0;p=l*+g[s+(v+4)>>2];q=m*+g[s+(v+8)>>2];g[o+16>>2]=k*+g[s+v>>2];g[o+20>>2]=p;g[o+24>>2]=q;g[o+28>>2]=0.0;r=$(e[u+(t+4)>>1]|0,r)|0;q=l*+g[s+(r+4)>>2];p=m*+g[s+(r+8)>>2];g[o+32>>2]=k*+g[s+r>>2];g[o+36>>2]=q;g[o+40>>2]=p;g[o+44>>2]=0.0;tc[c[(c[b>>2]|0)+8>>2]&127](b,o,n,f);f=f+1|0}while((f|0)<(c[o+48>>2]|0))}else if((f|0)==5){if((c[o+48>>2]|0)>0)f=0;else break;do{r=c[o+72>>2]|0;s=$(c[o+68>>2]|0,f)|0;t=c[o+76>>2]|0;u=c[o+56>>2]|0;v=$(d[r+s>>0]|0,u)|0;q=l*+g[t+(v+4)>>2];p=m*+g[t+(v+8)>>2];g[o>>2]=k*+g[t+v>>2];g[o+4>>2]=q;g[o+8>>2]=p;g[o+12>>2]=0.0;v=$(d[r+(s+1)>>0]|0,u)|0;p=l*+g[t+(v+4)>>2];q=m*+g[t+(v+8)>>2];g[o+16>>2]=k*+g[t+v>>2];g[o+20>>2]=p;g[o+24>>2]=q;g[o+28>>2]=0.0;u=$(d[r+(s+2)>>0]|0,u)|0;q=l*+g[t+(u+4)>>2];p=m*+g[t+(u+8)>>2];g[o+32>>2]=k*+g[t+u>>2];g[o+36>>2]=q;g[o+40>>2]=p;g[o+44>>2]=0.0;tc[c[(c[b>>2]|0)+8>>2]&127](b,o,n,f);f=f+1|0}while((f|0)<(c[o+48>>2]|0))}else if((f|0)==2){if((c[o+48>>2]|0)>0)f=0;else break;do{s=c[o+72>>2]|0;u=$(c[o+68>>2]|0,f)|0;t=c[o+76>>2]|0;r=c[o+56>>2]|0;v=$(r,c[s+u>>2]|0)|0;q=l*+g[t+(v+4)>>2];p=m*+g[t+(v+8)>>2];g[o>>2]=k*+g[t+v>>2];g[o+4>>2]=q;g[o+8>>2]=p;g[o+12>>2]=0.0;v=$(r,c[s+(u+4)>>2]|0)|0;p=l*+g[t+(v+4)>>2];q=m*+g[t+(v+8)>>2];g[o+16>>2]=k*+g[t+v>>2];g[o+20>>2]=p;g[o+24>>2]=q;g[o+28>>2]=0.0;u=$(r,c[s+(u+8)>>2]|0)|0;q=l*+g[t+(u+4)>>2];p=m*+g[t+(u+8)>>2];g[o+32>>2]=k*+g[t+u>>2];g[o+36>>2]=q;g[o+40>>2]=p;g[o+44>>2]=0.0;tc[c[(c[b>>2]|0)+8>>2]&127](b,o,n,f);f=f+1|0}while((f|0)<(c[o+48>>2]|0))}else break}else if((f|0)==1){f=c[o+60>>2]|0;if((f|0)==3){if((c[o+48>>2]|0)>0)f=0;else break;do{r=c[o+72>>2]|0;s=$(c[o+68>>2]|0,f)|0;t=c[o+76>>2]|0;u=c[o+56>>2]|0;v=$(e[r+s>>1]|0,u)|0;q=l*+h[t+(v+8)>>3];p=m*+h[t+(v+16)>>3];g[o>>2]=k*+h[t+v>>3];g[o+4>>2]=q;g[o+8>>2]=p;g[o+12>>2]=0.0;v=$(e[r+(s+2)>>1]|0,u)|0;p=l*+h[t+(v+8)>>3];q=m*+h[t+(v+16)>>3];g[o+16>>2]=k*+h[t+v>>3];g[o+20>>2]=p;g[o+24>>2]=q;g[o+28>>2]=0.0;u=$(e[r+(s+4)>>1]|0,u)|0;q=l*+h[t+(u+8)>>3];p=m*+h[t+(u+16)>>3];g[o+32>>2]=k*+h[t+u>>3];g[o+36>>2]=q;g[o+40>>2]=p;g[o+44>>2]=0.0;tc[c[(c[b>>2]|0)+8>>2]&127](b,o,n,f);f=f+1|0}while((f|0)<(c[o+48>>2]|0))}else if((f|0)==2){if((c[o+48>>2]|0)>0)f=0;else break;do{s=c[o+72>>2]|0;u=$(c[o+68>>2]|0,f)|0;t=c[o+76>>2]|0;r=c[o+56>>2]|0;v=$(r,c[s+u>>2]|0)|0;q=l*+h[t+(v+8)>>3];p=m*+h[t+(v+16)>>3];g[o>>2]=k*+h[t+v>>3];g[o+4>>2]=q;g[o+8>>2]=p;g[o+12>>2]=0.0;v=$(r,c[s+(u+4)>>2]|0)|0;p=l*+h[t+(v+8)>>3];q=m*+h[t+(v+16)>>3];g[o+16>>2]=k*+h[t+v>>3];g[o+20>>2]=p;g[o+24>>2]=q;g[o+28>>2]=0.0;u=$(r,c[s+(u+8)>>2]|0)|0;q=l*+h[t+(u+8)>>3];p=m*+h[t+(u+16)>>3];g[o+32>>2]=k*+h[t+u>>3];g[o+36>>2]=q;g[o+40>>2]=p;g[o+44>>2]=0.0;tc[c[(c[b>>2]|0)+8>>2]&127](b,o,n,f);f=f+1|0}while((f|0)<(c[o+48>>2]|0))}else if((f|0)==5){if((c[o+48>>2]|0)>0)f=0;else break;do{r=c[o+72>>2]|0;s=$(c[o+68>>2]|0,f)|0;t=c[o+76>>2]|0;u=c[o+56>>2]|0;v=$(d[r+s>>0]|0,u)|0;q=l*+h[t+(v+8)>>3];p=m*+h[t+(v+16)>>3];g[o>>2]=k*+h[t+v>>3];g[o+4>>2]=q;g[o+8>>2]=p;g[o+12>>2]=0.0;v=$(d[r+(s+1)>>0]|0,u)|0;p=l*+h[t+(v+8)>>3];q=m*+h[t+(v+16)>>3];g[o+16>>2]=k*+h[t+v>>3];g[o+20>>2]=p;g[o+24>>2]=q;g[o+28>>2]=0.0;u=$(d[r+(s+2)>>0]|0,u)|0;q=l*+h[t+(u+8)>>3];p=m*+h[t+(u+16)>>3];g[o+32>>2]=k*+h[t+u>>3];g[o+36>>2]=q;g[o+40>>2]=p;g[o+44>>2]=0.0;tc[c[(c[b>>2]|0)+8>>2]&127](b,o,n,f);f=f+1|0}while((f|0)<(c[o+48>>2]|0))}else break}while(0);Lb[c[(c[a>>2]|0)+24>>2]&127](a,n);n=n+1|0}while((n|0)!=(j|0));i=o;return}function _D(d,e,f){d=d|0;e=e|0;f=f|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0.0,y=0;w=i;i=i+32|0;j=Nb[c[(c[d>>2]|0)+28>>2]&127](d)|0;c[e+20>>2]=j;c[e>>2]=0;if(!j){s=e+4|0;r=d+4|0;x=+g[r>>2];g[s>>2]=x;s=d+8|0;x=+g[s>>2];s=e+8|0;g[s>>2]=x;s=d+12|0;x=+g[s>>2];s=e+12|0;g[s>>2]=x;s=d+16|0;x=+g[s>>2];s=e+16|0;g[s>>2]=x;i=w;return 20288}v=Wb[c[(c[f>>2]|0)+16>>2]&63](f,32,j)|0;j=c[v+8>>2]|0;c[e>>2]=ec[c[(c[f>>2]|0)+28>>2]&31](f,j)|0;s=Nb[c[(c[d>>2]|0)+28>>2]&127](d)|0;if((s|0)>0){r=0;while(1){dc[c[(c[d>>2]|0)+16>>2]&3](d,w+28|0,w+4|0,w+16|0,w+8|0,w+24|0,w+20|0,w,w+12|0,r);c[j+24>>2]=c[w>>2];c[j+28>>2]=c[w+4>>2];p=j+8|0;o=j+12|0;n=j+16|0;q=j+4|0;c[j+0>>2]=0;c[j+4>>2]=0;c[j+8>>2]=0;c[j+12>>2]=0;c[j+16>>2]=0;c[j+20>>2]=0;l=c[w+12>>2]|0;if((l|0)==3){k=c[w>>2]|0;if(k){k=Wb[c[(c[f>>2]|0)+16>>2]&63](f,8,k)|0;l=c[k+8>>2]|0;c[o>>2]=ec[c[(c[f>>2]|0)+28>>2]&31](f,l)|0;p=c[w>>2]|0;if((p|0)>0){o=c[w+24>>2]|0;n=c[w+20>>2]|0;m=0;do{y=$(n,m)|0;b[l+(m<<3)>>1]=b[o+y>>1]|0;b[l+(m<<3)+2>>1]=b[o+(y+2)>>1]|0;b[l+(m<<3)+4>>1]=b[o+(y+4)>>1]|0;m=m+1|0}while((m|0)!=(p|0))}Hb[c[(c[f>>2]|0)+20>>2]&31](f,k,20168,1497453121,c[k+8>>2]|0)}}else if((l|0)==5){k=c[w>>2]|0;if(k){m=Wb[c[(c[f>>2]|0)+16>>2]&63](f,4,k)|0;l=c[m+8>>2]|0;c[n>>2]=ec[c[(c[f>>2]|0)+28>>2]&31](f,l)|0;if((c[w>>2]|0)>0){k=0;do{o=c[w+24>>2]|0;p=$(c[w+20>>2]|0,k)|0;a[l+(k<<2)>>0]=a[o+p>>0]|0;a[l+(k<<2)+1>>0]=a[o+(p+1)>>0]|0;a[l+(k<<2)+2>>0]=a[o+(p+2)>>0]|0;k=k+1|0}while((k|0)<(c[w>>2]|0))}Hb[c[(c[f>>2]|0)+20>>2]&31](f,m,20200,1497453121,c[m+8>>2]|0)}}else if((l|0)==2?(u=c[w>>2]|0,(u|0)!=0):0){o=Wb[c[(c[f>>2]|0)+16>>2]&63](f,4,u*3|0)|0;l=c[o+8>>2]|0;c[p>>2]=ec[c[(c[f>>2]|0)+28>>2]&31](f,l)|0;if((c[w>>2]|0)>0){k=c[w+24>>2]|0;m=0;do{n=$(c[w+20>>2]|0,m)|0;p=m*3|0;c[l+(p<<2)>>2]=c[k+n>>2];c[l+(p+1<<2)>>2]=c[k+(n+4)>>2];c[l+(p+2<<2)>>2]=c[k+(n+8)>>2];m=m+1|0}while((m|0)<(c[w>>2]|0))}Hb[c[(c[f>>2]|0)+20>>2]&31](f,o,20152,1497453121,c[o+8>>2]|0)}k=c[w+16>>2]|0;if(!k){k=c[w+4>>2]|0;if(k){o=Wb[c[(c[f>>2]|0)+16>>2]&63](f,16,k)|0;m=c[o+8>>2]|0;c[j>>2]=ec[c[(c[f>>2]|0)+28>>2]&31](f,m)|0;l=c[w+4>>2]|0;if((l|0)>0){k=c[w+28>>2]|0;n=c[w+8>>2]|0;p=0;do{q=$(n,p)|0;g[m+(p<<4)>>2]=+g[k+q>>2];g[m+(p<<4)+4>>2]=+g[k+(q+4)>>2];g[m+(p<<4)+8>>2]=+g[k+(q+8)>>2];p=p+1|0}while((p|0)!=(l|0))}Hb[c[(c[f>>2]|0)+20>>2]&31](f,o,20224,1497453121,c[o+8>>2]|0)}}else if((k|0)==1?(t=c[w+4>>2]|0,(t|0)!=0):0){k=Wb[c[(c[f>>2]|0)+16>>2]&63](f,32,t)|0;o=c[k+8>>2]|0;c[q>>2]=ec[c[(c[f>>2]|0)+28>>2]&31](f,o)|0;n=c[w+4>>2]|0;if((n|0)>0){m=c[w+28>>2]|0;l=c[w+8>>2]|0;p=0;do{q=$(l,p)|0;h[o+(p<<5)>>3]=+h[m+q>>3];h[o+(p<<5)+8>>3]=+h[m+(q+8)>>3];h[o+(p<<5)+16>>3]=+h[m+(q+16)>>3];p=p+1|0}while((p|0)!=(n|0))}Hb[c[(c[f>>2]|0)+20>>2]&31](f,k,20248,1497453121,c[k+8>>2]|0)}Lb[c[(c[d>>2]|0)+24>>2]&127](d,r);r=r+1|0;if((r|0)==(s|0)){j=f;break}else j=j+32|0}}else j=f;Hb[c[(c[j>>2]|0)+20>>2]&31](f,v,20272,1497453121,c[v+8>>2]|0);s=e+4|0;r=d+4|0;x=+g[r>>2];g[s>>2]=x;s=d+8|0;x=+g[s>>2];s=e+8|0;g[s>>2]=x;s=d+12|0;x=+g[s>>2];s=e+12|0;g[s>>2]=x;s=d+16|0;x=+g[s>>2];s=e+16|0;g[s>>2]=x;i=w;return 20288}function $D(a){a=a|0;var b=0,d=0;d=i;do{c[a+4>>2]=0;g[a+8>>2]=0.0;b=c[a+24>>2]|0;if(b)$D(b);a=c[a+28>>2]|0}while((a|0)!=0);i=d;return}function aE(a){a=a|0;var b=0,d=0,e=0,f=0;f=i;i=i+16|0;e=c[5104]|0;if((c[e>>2]|0)==(a|0))b=e;else{b=c[e+24>>2]|0;a:do if(!b)d=5;else while(1){if((c[b>>2]|0)==(a|0))break a;b=c[b+28>>2]|0;if(!b){d=5;break}}while(0);if((d|0)==5){b=QE(36)|0;b:do if(!b){while(1){b=c[5230]|0;c[5230]=b+0;if(!b)break;qc[b&3]();b=QE(36)|0;if(b)break b}b=yb(4)|0;c[b>>2]=20816;wb(b|0,20864,207)}while(0);c[b>>2]=a;d=b+4|0;c[d+0>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;c[b+20>>2]=e;c[b+24>>2]=0;d=b+28|0;c[d>>2]=0;c[b+32>>2]=0;$D(b);c[d>>2]=c[e+24>>2];c[e+24>>2]=b}c[5104]=b}e=b+4|0;c[e>>2]=(c[e>>2]|0)+1;e=b+16|0;d=c[e>>2]|0;c[e>>2]=d+1;if(d){i=f;return}Cb(f|0,0)|0;d=c[5090]|0;c[b+12>>2]=(c[f+4>>2]|0)-(c[d+4>>2]|0)+(((c[f>>2]|0)-(c[d>>2]|0)|0)*1e6|0);i=f;return}function bE(){var a=0,b=0;b=i;a=QE(8)|0;a:do if(!a){while(1){a=c[5230]|0;c[5230]=a+0;if(!a)break;qc[a&3]();a=QE(8)|0;if(a)break a}a=yb(4)|0;c[a>>2]=20816;wb(a|0,20864,207)}while(0);c[5090]=a;Cb(a|0,0)|0;c[5092]=20408;c[5093]=0;c[5094]=0;c[5095]=0;c[5096]=0;c[5097]=0;c[5098]=0;c[5099]=0;c[5100]=0;$D(20368);i=b;return}function cE(a,b,c,d,e,f,g,h,j,k){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;var l=0,m=0,n=0,o=0,p=0,q=0;o=i;if((e|0)!=(k|0)){d=e-k|0;i=o;return d|0}if(!e){d=0;i=o;return d|0}n=gF(h|0,0,a|0,0)|0;p=D;m=gF(j|0,0,a|0,0)|0;q=D;k=gF(h|0,0,b|0,0)|0;a=D;l=gF(j|0,0,b|0,0)|0;b=D;k=XE(m|0,0,k|0,0)|0;m=D;b=XE(q|0,0,l|0,b|0)|0;b=XE(b|0,D|0,a|0,0)|0;a=D;k=XE(n|0,p|0,0,k|0)|0;l=D;n=XE(b|0,a|0,(l>>>0<p>>>0|(l|0)==(p|0)&k>>>0<n>>>0)&1|0,0)|0;m=XE(n|0,D|0,m|0,0)|0;n=D;a=gF(f|0,0,c|0,0)|0;p=D;b=gF(g|0,0,c|0,0)|0;q=D;j=gF(f|0,0,d|0,0)|0;c=D;h=gF(g|0,0,d|0,0)|0;d=D;j=XE(b|0,0,j|0,0)|0;b=D;d=XE(q|0,0,h|0,d|0)|0;c=XE(d|0,D|0,c|0,0)|0;d=D;j=XE(a|0,p|0,0,j|0)|0;h=D;a=XE(c|0,d|0,(h>>>0<p>>>0|(h|0)==(p|0)&j>>>0<a>>>0)&1|0,0)|0;b=XE(a|0,D|0,b|0,0)|0;a=D;if(!(n>>>0<a>>>0|(n|0)==(a|0)&m>>>0<b>>>0))if(!(n>>>0>a>>>0|(n|0)==(a|0)&m>>>0>b>>>0))if(l>>>0<h>>>0|(l|0)==(h|0)&k>>>0<j>>>0)j=-1;else j=(l>>>0>h>>>0|(l|0)==(h|0)&k>>>0>j>>>0)&1;else j=1;else j=-1;d=$(j,e)|0;i=o;return d|0}function dE(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0;l=i;e=c[a+56>>2]|0;if(!e){e=c[a+52>>2]|0;if(!e){c[5108]=(c[5108]|0)+1;g=QE(31)|0;if((g|0)!=0?(f=g+19&-16,c[f+-4>>2]=g,(g+19&-16|0)!=0):0){e=c[a+60>>2]|0;c[f+4>>2]=e;c[f+8>>2]=0;c[5108]=(c[5108]|0)+1;e=QE((e*24|3)+16|0)|0;if(!e)f=0;else{c[(e+19&-16)+-4>>2]=e;f=e+19&-16}c[(g+19&-16)>>2]=f;e=g+19&-16}else e=0;c[e+8>>2]=c[a+48>>2];c[a+48>>2]=e}else c[a+52>>2]=c[e+8>>2];h=c[e+4>>2]|0;f=c[e>>2]|0;if((h|0)>0){g=0;e=f;do{g=g+1|0;m=e;e=e+24|0;c[m>>2]=(g|0)<(h|0)?e:0}while((g|0)!=(h|0))}e=c[f>>2]|0;c[a+56>>2]=e;if(!f)f=0;else k=14}else{c[a+56>>2]=c[e>>2];f=e;k=14}if((k|0)==14){c[f+0>>2]=0;c[f+4>>2]=0;c[f+8>>2]=0;c[f+12>>2]=0;c[f+16>>2]=0;c[f+20>>2]=0;e=c[a+56>>2]|0}if(!e){e=c[a+52>>2]|0;if(!e){c[5108]=(c[5108]|0)+1;g=QE(31)|0;if((g|0)!=0?(j=g+19&-16,c[j+-4>>2]=g,(g+19&-16|0)!=0):0){e=c[a+60>>2]|0;c[j+4>>2]=e;c[j+8>>2]=0;c[5108]=(c[5108]|0)+1;e=QE((e*24|3)+16|0)|0;if(!e)e=0;else{c[(e+19&-16)+-4>>2]=e;e=e+19&-16}c[(g+19&-16)>>2]=e;e=g+19&-16}else e=0;c[e+8>>2]=c[a+48>>2];c[a+48>>2]=e}else c[a+52>>2]=c[e+8>>2];j=c[e+4>>2]|0;e=c[e>>2]|0;if((j|0)>0){g=0;h=e;do{g=g+1|0;m=h;h=h+24|0;c[m>>2]=(g|0)<(j|0)?h:0}while((g|0)!=(j|0))}c[a+56>>2]=c[e>>2];if(!e)e=0;else k=28}else{c[a+56>>2]=c[e>>2];k=28}if((k|0)==28){c[e+0>>2]=0;c[e+4>>2]=0;c[e+8>>2]=0;c[e+12>>2]=0;c[e+16>>2]=0;c[e+20>>2]=0}c[f+8>>2]=e;c[e+8>>2]=f;k=c[a+100>>2]|0;c[f+20>>2]=k;c[e+20>>2]=k;c[f+12>>2]=d;c[e+12>>2]=b;c[f+16>>2]=0;c[e+16>>2]=0;e=c[a+116>>2]|0;c[a+116>>2]=e+1;if((e|0)<(c[a+120>>2]|0)){i=l;return f|0}c[a+120>>2]=e+1;i=l;return f|0}function eE(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0;K=i;i=i+144|0;do if((d-b|0)==1)f=c[(c[a+92>>2]|0)+(b<<2)>>2]|0;else if(!(d-b|0)){c[e+0>>2]=0;c[e+4>>2]=0;c[e+8>>2]=0;c[e+12>>2]=0;i=K;return}else if((d-b|0)==2){f=c[(c[a+92>>2]|0)+(b<<2)>>2]|0;j=c[f+88>>2]|0;k=c[f+200>>2]|0;l=c[f+92>>2]|0;h=c[f+204>>2]|0;if((j|0)==(k|0)){if((l|0)==(h|0))if((c[f+96>>2]|0)==(c[f+208>>2]|0))break;else g=l;else g=h;if((l|0)==(g|0)){z=(c[f+96>>2]|0)>(c[f+208>>2]|0);g=z?f+112|0:f;c[g>>2]=g;c[g+4>>2]=g;c[e>>2]=g;c[e+4>>2]=g;c[e+8>>2]=g;c[e+12>>2]=g;f=z?f:f+112|0}else{h=0;J=9}}else{g=h;h=(l|0)==(h|0);J=9}do if((J|0)==9){c[f>>2]=f+112;c[f+4>>2]=f+112;c[f+112>>2]=f;c[f+116>>2]=f;z=(l-g|0)<0;y=(j-k|0)<0|(j|0)==(k|0)&z;c[e>>2]=y?f:f+112|0;c[e+4>>2]=y?f+112|0:f;if(z|h&(j-k|0)<0){c[e+8>>2]=f;c[e+12>>2]=f+112;g=f;f=f+112|0;break}else{c[e+8>>2]=f+112;c[e+12>>2]=f;g=f;f=f+112|0;break}}while(0);z=dE(a,g,f)|0;c[z>>2]=z;c[z+4>>2]=z;c[g+8>>2]=z;z=c[z+8>>2]|0;c[z>>2]=z;c[z+4>>2]=z;c[f+8>>2]=z;i=K;return}else{n=((d-b|0)/2|0)+b|0;k=c[a+92>>2]|0;f=c[k+(n+-1<<2)>>2]|0;h=c[f+88>>2]|0;g=c[f+92>>2]|0;f=c[f+96>>2]|0;a:do if((n|0)<(d|0)){m=n;while(1){j=c[k+(m<<2)>>2]|0;if((c[j+88>>2]|0)!=(h|0)){l=m;break a}if((c[j+92>>2]|0)!=(g|0)){l=m;break a}l=m+1|0;if((c[j+96>>2]|0)!=(f|0)){l=m;break a}if((l|0)<(d|0))m=l;else break}}else l=n;while(0);eE(a,b,n,e);c[K+96>>2]=0;c[K+100>>2]=0;c[K+104>>2]=0;c[K+108>>2]=0;eE(a,l,d,K+96|0);f=c[K+100>>2]|0;if(!f){i=K;return}y=c[e+4>>2]|0;if(!y){c[e+0>>2]=c[K+96>>2];c[e+4>>2]=c[K+100>>2];c[e+8>>2]=c[K+104>>2];c[e+12>>2]=c[K+108>>2];i=K;return}c[a+100>>2]=(c[a+100>>2]|0)+-1;g=c[e+12>>2]|0;h=c[K+104>>2]|0;j=c[g+88>>2]|0;b:do if((j|0)==(c[h+88>>2]|0)?(c[g+92>>2]|0)==(c[h+92>>2]|0):0){m=c[h+4>>2]|0;if((m|0)==(h|0)){f=c[h+8>>2]|0;if(f){h=c[f+12>>2]|0;j=c[h+88>>2]|0}y=h;n=j+1|0;m=c[h+96>>2]|0;break}j=c[h>>2]|0;c[m>>2]=j;c[j+4>>2]=m;c:do if((h|0)==(c[K+96>>2]|0)){l=c[j+88>>2]|0;k=c[m+88>>2]|0;do if((l|0)>=(k|0)){if((l|0)==(k|0)?(c[j+92>>2]|0)<(c[m+92>>2]|0):0)break;c[K+96>>2]=m;break c}while(0);c[K+96>>2]=j}while(0);if((h|0)==(f|0)){l=c[j+88>>2]|0;k=c[m+88>>2]|0;do if((l|0)<=(k|0)){if((l|0)==(k|0)?(c[j+92>>2]|0)>(c[m+92>>2]|0):0)break;c[K+100>>2]=m;j=m;J=39;break b}while(0);c[K+100>>2]=j;J=39}else{j=f;J=39}}else{j=f;J=39}while(0);if((J|0)==39){v=c[e>>2]|0;w=c[K+96>>2]|0;b=0;x=1;d=y;G=0;n=j;h=0;d:while(1)while(1){s=c[d+88>>2]|0;o=$((c[n+88>>2]|0)-s|0,x)|0;e:do if((o|0)<=0){if((o|0)<0){u=(b|0)!=0;p=c[d+92>>2]|0;t=c[n+92>>2]|0;while(1){r=c[(u?n+4|0:n)>>2]|0;m=(r|0)==(n|0);s=n+88|0;while(1){q=d+88|0;l=t-p|0;if(!m?(z=c[r+88>>2]|0,E=$(z-(c[s>>2]|0)|0,x)|0,C=c[r+92>>2]|0,F=C-t|0,(F|0)>-1):0){if(!E)break;if((E|0)<0?($(F,o)|0)<=($(E,l)|0):0)break}k=c[(u?d+4|0:d)>>2]|0;if((k|0)==(d|0)){o=d;m=n;break e}A=c[k+88>>2]|0;g=$(A-(c[q>>2]|0)|0,x)|0;f=c[k+92>>2]|0;p=f-p|0;q=o;o=$((c[s>>2]|0)-A|0,x)|0;if(!((o|0)<0&(p|0)>0)){o=d;m=n;break e}if(!g){p=f;d=k;continue}if((g|0)>=0){o=d;m=n;break e}if(($(p,q)|0)>=($(g,l)|0)){o=d;m=n;break e}else{p=f;d=k}}t=C;o=$(z-(c[q>>2]|0)|0,x)|0;n=r}}m=c[d+92>>2]|0;q=(b|0)!=0;f:do if(q){o=d;while(1){l=c[o>>2]|0;if((l|0)==(d|0))break f;if((c[l+88>>2]|0)!=(s|0))break f;u=m;m=c[l+92>>2]|0;if((m|0)>(u|0))break;else o=l}}else{o=d;while(1){l=c[o+4>>2]|0;if((l|0)==(d|0))break f;if((c[l+88>>2]|0)!=(s|0))break f;u=m;m=c[l+92>>2]|0;if((m|0)>(u|0))break;else o=l}}while(0);l=c[n+92>>2]|0;if(q){m=n;while(1){d=c[m+4>>2]|0;if((d|0)==(n|0))break e;if((c[d+88>>2]|0)!=(s|0))break e;u=l;l=c[d+92>>2]|0;if((l|0)<(u|0))break;else m=d}}else{m=n;while(1){d=c[m>>2]|0;if((d|0)==(n|0))break e;if((c[d+88>>2]|0)!=(s|0))break e;u=l;l=c[d+92>>2]|0;if((l|0)<(u|0))break;else m=d}}}else{r=(b|0)!=0;m=c[n+92>>2]|0;while(1){A=n+88|0;g=d+88|0;q=c[d+92>>2]|0;k=m-q|0;p=c[(r?d:d+4|0)>>2]|0;g:do if((p|0)==(d|0)){f=o;o=g}else{u=c[d+88>>2]|0;B=p;f=o;l=k;while(1){p=u;u=c[B+88>>2]|0;p=$(u-p|0,x)|0;k=q;q=c[B+92>>2]|0;k=q-k|0;if((k|0)>=1){o=g;k=l;break g}if(p){if((p|0)>=0){o=g;k=l;break g}if(($(k,f)|0)>($(p,l)|0)){o=g;k=l;break g}}f=$((c[A>>2]|0)-u|0,x)|0;g=B+88|0;k=m-q|0;p=c[(r?B:B+4|0)>>2]|0;if((p|0)==(B|0)){o=g;d=B;break}else{d=B;B=p;l=k}}}while(0);g=c[(r?n:n+4|0)>>2]|0;if((g|0)==(n|0)){o=d;m=n;break e}u=c[g+88>>2]|0;q=$(u-(c[A>>2]|0)|0,x)|0;p=m;m=c[g+92>>2]|0;p=m-p|0;o=$(u-(c[o>>2]|0)|0,x)|0;if(!((o|0)>0&(p|0)<0)){o=d;m=n;break e}if(!q){n=g;continue}if((q|0)>=0){o=d;m=n;break e}if(($(p,f)|0)>=($(q,k)|0)){o=d;m=n;break}else n=g}}while(0);u=b;b=b+1|0;if(!u){x=-1;d=v;G=o;n=w;h=m;continue d}if((b|0)==2)break d;else{d=o;n=m}}c[o+4>>2]=m;c[m>>2]=o;c[G>>2]=h;c[h+4>>2]=G;if((c[w+88>>2]|0)<(c[v+88>>2]|0))c[e>>2]=w;if((c[j+88>>2]|0)>=(c[y+88>>2]|0))c[e+4>>2]=j;c[e+12>>2]=c[K+108>>2];d=c[h+88>>2]|0;l=c[G+88>>2]|0;v=c[h+92>>2]|0;w=c[G+92>>2]|0;x=c[h+96>>2]|0;m=c[G+96>>2]|0;y=((v-w|0)<0)<<31>>31;B=0-(d-l)|0;z=UE(0,0,B|0,((B|0)<0)<<31>>31|0)|0;z=gF(x-m|0,((x-m|0)<0)<<31>>31|0,z|0,D|0)|0;A=D;u=gF(x-m|0,((x-m|0)<0)<<31>>31|0,v-w|0,y|0)|0;t=D;g=gF(d-l|0,((d-l|0)<0)<<31>>31|0,B|0,((B|0)<0)<<31>>31|0)|0;r=D;s=gF(v-w|0,y|0,v-w|0,y|0)|0;s=UE(g|0,r|0,s|0,D|0)|0;r=D;g=c[G+8>>2]|0;c[K+140>>2]=0;if(!g)b=0;else{j=UE(0,0,v-w|0,y|0)|0;k=D;b=0;n=g;do{o=c[n+12>>2]|0;q=c[o+88>>2]|0;p=c[o+92>>2]|0;o=c[o+96>>2]|0;E=gF(p-w|0,((p-w|0)<0)<<31>>31|0,B|0,((B|0)<0)<<31>>31|0)|0;f=D;C=gF(q-l|0,((q-l|0)<0)<<31>>31|0,j|0,k|0)|0;h:do if((E|0)==(C|0)&(f|0)==(D|0)?(C=gF(q-l|0,((q-l|0)<0)<<31>>31|0,z|0,A|0)|0,E=D,f=gF(p-w|0,((p-w|0)<0)<<31>>31|0,u|0,t|0)|0,E=XE(f|0,D|0,C|0,E|0)|0,C=D,f=gF(o-m|0,((o-m|0)<0)<<31>>31|0,s|0,r|0)|0,f=XE(E|0,C|0,f|0,D|0)|0,C=D,(C|0)>0|(C|0)==0&f>>>0>0):0){do if(b){f=(c[b+4>>2]|0)==(n|0);if((c[b>>2]|0)!=(n|0))if(f)break;else break h;if(!f)break h;C=c[b+12>>2]|0;E=c[(c[n+8>>2]|0)+12>>2]|0;f=c[E+88>>2]|0;e=c[E+92>>2]|0;E=c[E+96>>2]|0;F=(c[C+96>>2]|0)-E|0;p=($(o-E|0,(c[C+92>>2]|0)-e|0)|0)-($(F,p-e|0)|0)|0;q=($(F,q-f|0)|0)-($(o-E|0,(c[C+88>>2]|0)-f|0)|0)|0;o=gF(p|0,((p|0)<0)<<31>>31|0,v-w|0,y|0)|0;p=D;q=gF(q|0,((q|0)<0)<<31>>31|0,B|0,((B|0)<0)<<31>>31|0)|0;q=XE(o|0,p|0,q|0,D|0)|0;p=D;if((p|0)>0|(p|0)==0&q>>>0>0)break h}while(0);c[K+140>>2]=n;b=n}while(0);n=c[n>>2]|0}while((n|0)!=(g|0))}j=c[h+8>>2]|0;c[K+136>>2]=0;if(!j)g=0;else{k=UE(0,0,v-w|0,y|0)|0;l=D;g=0;q=j;do{f=c[q+12>>2]|0;p=c[f+88>>2]|0;o=c[f+92>>2]|0;f=c[f+96>>2]|0;C=gF(o-v|0,((o-v|0)<0)<<31>>31|0,B|0,((B|0)<0)<<31>>31|0)|0;m=D;n=gF(p-d|0,((p-d|0)<0)<<31>>31|0,k|0,l|0)|0;do if((C|0)==(n|0)&(m|0)==(D|0)?(n=gF(p-d|0,((p-d|0)<0)<<31>>31|0,z|0,A|0)|0,C=D,m=gF(o-v|0,((o-v|0)<0)<<31>>31|0,u|0,t|0)|0,C=XE(m|0,D|0,n|0,C|0)|0,n=D,m=gF(f-x|0,((f-x|0)<0)<<31>>31|0,s|0,r|0)|0,m=XE(C|0,n|0,m|0,D|0)|0,n=D,(n|0)>0|(n|0)==0&m>>>0>0):0){if(g){if((c[g>>2]|0)!=(q|0))break;if((c[g+4>>2]|0)==(q|0)?(n=c[g+12>>2]|0,C=c[(c[q+8>>2]|0)+12>>2]|0,m=c[C+88>>2]|0,F=c[C+92>>2]|0,C=c[C+96>>2]|0,E=(c[n+96>>2]|0)-C|0,o=($(f-C|0,(c[n+92>>2]|0)-F|0)|0)-($(E,o-F|0)|0)|0,p=($(E,p-m|0)|0)-($(f-C|0,(c[n+88>>2]|0)-m|0)|0)|0,f=gF(o|0,((o|0)<0)<<31>>31|0,v-w|0,y|0)|0,o=D,p=gF(p|0,((p|0)<0)<<31>>31|0,B|0,((B|0)<0)<<31>>31|0)|0,p=XE(f|0,o|0,p|0,D|0)|0,o=D,!((o|0)>0|(o|0)==0&p>>>0>0)):0)break}c[K+136>>2]=q;g=q}while(0);q=c[q>>2]|0}while((q|0)!=(j|0))}if((b|0)!=0|(g|0)!=0){gE(a,G,h,K+140|0,K+136|0);g=c[K+140>>2]|0;if(!g)g=G;else g=c[g+12>>2]|0;f=c[K+136>>2]|0;if(f)h=c[f+12>>2]|0}else g=G;y=h;n=c[h+88>>2]|0;m=(c[h+96>>2]|0)+1|0}f=c[y+92>>2]|0;o=f;x=g;v=y;l=0;h=0;q=1;k=0;d=0;B=0;r=0;j=0;b=0;while(1){A=x+88|0;s=(c[v+88>>2]|0)-(c[A>>2]|0)|0;z=x+92|0;t=o-(c[z>>2]|0)|0;p=x+96|0;C=(c[v+96>>2]|0)-(c[p>>2]|0)|0;c[K+120>>2]=s;c[K+124>>2]=t;c[K+128>>2]=C;c[K+132>>2]=-1;A=n-(c[A>>2]|0)|0;z=f-(c[z>>2]|0)|0;p=m-(c[p>>2]|0)|0;o=($(C,z)|0)-($(t,p)|0)|0;p=($(s,p)|0)-($(C,A)|0)|0;z=($(t,A)|0)-($(s,z)|0)|0;c[K+72>>2]=o;c[K+76>>2]=((o|0)<0)<<31>>31;c[K+80>>2]=p;c[K+84>>2]=((p|0)<0)<<31>>31;c[K+88>>2]=z;c[K+92>>2]=((z|0)<0)<<31>>31;A=gF(z|0,((z|0)<0)<<31>>31|0,t|0,((t|0)<0)<<31>>31|0)|0;w=D;u=gF(C|0,((C|0)<0)<<31>>31|0,p|0,((p|0)<0)<<31>>31|0)|0;u=UE(A|0,w|0,u|0,D|0)|0;w=D;C=gF(o|0,((o|0)<0)<<31>>31|0,C|0,((C|0)<0)<<31>>31|0)|0;A=D;z=gF(s|0,((s|0)<0)<<31>>31|0,z|0,((z|0)<0)<<31>>31|0)|0;z=UE(C|0,A|0,z|0,D|0)|0;A=D;p=gF(s|0,((s|0)<0)<<31>>31|0,p|0,((p|0)<0)<<31>>31|0)|0;s=D;t=gF(o|0,((o|0)<0)<<31>>31|0,t|0,((t|0)<0)<<31>>31|0)|0;t=UE(p|0,s|0,t|0,D|0)|0;c[K+48>>2]=u;c[K+52>>2]=w;c[K+56>>2]=z;c[K+60>>2]=A;c[K+64>>2]=t;c[K+68>>2]=D;c[K+24>>2]=0;c[K+28>>2]=0;c[K+32>>2]=0;c[K+36>>2]=0;c[K+40>>2]=0;t=fE(a,0,x,K+120|0,K+72|0,K+48|0,K+24|0)|0;c[K+0>>2]=0;c[K+4>>2]=0;c[K+8>>2]=0;c[K+12>>2]=0;c[K+16>>2]=0;A=fE(a,1,v,K+120|0,K+72|0,K+48|0,K)|0;if(!((t|0)!=0|(A|0)!=0)){J=119;break}if((t|0)!=0&(A|0)!=0)s=cE(c[K+24>>2]|0,c[K+28>>2]|0,c[K+32>>2]|0,c[K+36>>2]|0,c[K+40>>2]|0,c[K>>2]|0,c[K+4>>2]|0,c[K+8>>2]|0,c[K+12>>2]|0,c[K+16>>2]|0)|0;else s=(t|0)!=0?-1:1;do if(!q){if((s|0)>-1)if((c[K+16>>2]|0)<0&((c[K+8>>2]|0)==0&(c[K+12>>2]|0)==0)){J=132;break}else{J=127;break}if((c[K+40>>2]|0)<0&((c[K+32>>2]|0)==0&(c[K+36>>2]|0)==0)){c[K+116>>2]=t;c[K+112>>2]=A;u=v;w=h;p=f}else J=127}else J=127;while(0);if((J|0)==127){p=dE(a,x,v)|0;if(!B)k=p;else c[B+4>>2]=p;c[p>>2]=B;o=c[p+8>>2]|0;if(!r)d=o;else c[r>>2]=o;c[o+4>>2]=r;B=p;r=o;J=132}if((J|0)==132){J=0;c[K+116>>2]=t;c[K+112>>2]=A;if(!s){gE(a,x,v,K+116|0,K+112|0);q=c[K+112>>2]|0}else q=A;if((s|0)>-1&(q|0)!=0){p=(b|0)!=0;if(p?(H=c[b>>2]|0,(H|0)!=(A|0)):0){f=H;do{o=f;f=c[f>>2]|0;n=c[o+8>>2]|0;if((f|0)==(o|0))c[(c[n+12>>2]|0)+8>>2]=0;else{c[f+4>>2]=c[o+4>>2];c[c[o+4>>2]>>2]=f;c[(c[n+12>>2]|0)+8>>2]=f}m=c[n>>2]|0;if((m|0)==(n|0))c[(c[o+12>>2]|0)+8>>2]=0;else{c[m+4>>2]=c[n+4>>2];c[c[n+4>>2]>>2]=m;c[(c[o+12>>2]|0)+8>>2]=m};c[o+0>>2]=0;c[o+4>>2]=0;c[o+8>>2]=0;c[o+12>>2]=0;c[o+16>>2]=0;c[o>>2]=c[a+56>>2];c[a+56>>2]=o;c[n+0>>2]=0;c[n+4>>2]=0;c[n+8>>2]=0;c[n+12>>2]=0;c[n+16>>2]=0;c[n>>2]=c[a+56>>2];c[a+56>>2]=n;c[a+116>>2]=(c[a+116>>2]|0)+-1}while((f|0)!=(A|0))}if(!r)h=p?h:A;else{if(p){c[b>>2]=d;n=A+4|0}else{b=c[A+4>>2]|0;c[b>>2]=d;h=d;n=A+4|0}c[d+4>>2]=b;c[r>>2]=A;c[n>>2]=r;q=c[K+112>>2]|0;d=0}u=c[q+12>>2]|0;w=h;r=0;n=c[v+88>>2]|0;p=c[v+92>>2]|0;m=c[v+96>>2]|0;b=c[q+8>>2]|0}else{u=v;w=h;p=f}}q=c[K+116>>2]|0;if((s|0)<1&(q|0)!=0){p=(j|0)!=0;if(p?(I=c[j+4>>2]|0,(I|0)!=(t|0)):0){o=I;do{m=o+4|0;f=o;o=c[m>>2]|0;n=c[f>>2]|0;h=c[f+8>>2]|0;if((n|0)==(f|0))c[(c[h+12>>2]|0)+8>>2]=0;else{c[n+4>>2]=o;c[c[m>>2]>>2]=n;c[(c[h+12>>2]|0)+8>>2]=n}n=c[h>>2]|0;if((n|0)==(h|0))c[(c[f+12>>2]|0)+8>>2]=0;else{c[n+4>>2]=c[h+4>>2];c[c[h+4>>2]>>2]=n;c[(c[f+12>>2]|0)+8>>2]=n};c[f+0>>2]=0;c[f+4>>2]=0;c[f+8>>2]=0;c[f+12>>2]=0;c[f+16>>2]=0;c[f>>2]=c[a+56>>2];c[a+56>>2]=f;c[h+0>>2]=0;c[h+4>>2]=0;c[h+8>>2]=0;c[h+12>>2]=0;c[h+16>>2]=0;c[h>>2]=c[a+56>>2];c[a+56>>2]=h;c[a+116>>2]=(c[a+116>>2]|0)+-1}while((o|0)!=(t|0))}if(!B){o=q;l=p?l:t}else{if(p){c[j+4>>2]=k;h=t}else{j=c[t>>2]|0;c[j+4>>2]=k;l=k;h=t}c[k>>2]=j;c[h>>2]=B;c[B+4>>2]=t;o=c[K+116>>2]|0;k=0}q=c[o+12>>2]|0;s=l;t=k;B=0;n=c[x+88>>2]|0;p=c[x+92>>2]|0;m=c[x+96>>2]|0;A=c[o+8>>2]|0}else{q=x;s=l;t=k;A=j}if((q|0)==(g|0)&(u|0)==(y|0))break;o=c[u+92>>2]|0;x=q;v=u;l=s;h=w;q=0;k=t;f=p;j=A}if((J|0)==119){z=dE(a,x,v)|0;c[z>>2]=z;c[z+4>>2]=z;c[x+8>>2]=z;z=c[z+8>>2]|0;c[z>>2]=z;c[z+4>>2]=z;c[v+8>>2]=z;i=K;return}if(A){f=A+4|0;l=c[f>>2]|0;if((l|0)!=(s|0))do{j=l+4|0;g=l;l=c[j>>2]|0;k=c[g>>2]|0;h=c[g+8>>2]|0;if((k|0)==(g|0))c[(c[h+12>>2]|0)+8>>2]=0;else{c[k+4>>2]=l;c[c[j>>2]>>2]=k;c[(c[h+12>>2]|0)+8>>2]=k}k=c[h>>2]|0;if((k|0)==(h|0))c[(c[g+12>>2]|0)+8>>2]=0;else{c[k+4>>2]=c[h+4>>2];c[c[h+4>>2]>>2]=k;c[(c[g+12>>2]|0)+8>>2]=k};c[g+0>>2]=0;c[g+4>>2]=0;c[g+8>>2]=0;c[g+12>>2]=0;c[g+16>>2]=0;c[g>>2]=c[a+56>>2];c[a+56>>2]=g;c[h+0>>2]=0;c[h+4>>2]=0;c[h+8>>2]=0;c[h+12>>2]=0;c[h+16>>2]=0;c[h>>2]=c[a+56>>2];c[a+56>>2]=h;c[a+116>>2]=(c[a+116>>2]|0)+-1}while((l|0)!=(s|0));if(B){c[t>>2]=A;c[f>>2]=t;c[s>>2]=B;c[B+4>>2]=s}}else{c[t>>2]=B;c[B+4>>2]=t;c[q+8>>2]=B}if(!b){c[r>>2]=d;c[d+4>>2]=r;c[y+8>>2]=r;i=K;return}g=c[b>>2]|0;if((g|0)!=(w|0))do{j=g;g=c[g>>2]|0;f=c[j+8>>2]|0;if((g|0)==(j|0))c[(c[f+12>>2]|0)+8>>2]=0;else{c[g+4>>2]=c[j+4>>2];c[c[j+4>>2]>>2]=g;c[(c[f+12>>2]|0)+8>>2]=g}h=c[f>>2]|0;if((h|0)==(f|0))c[(c[j+12>>2]|0)+8>>2]=0;else{c[h+4>>2]=c[f+4>>2];c[c[f+4>>2]>>2]=h;c[(c[j+12>>2]|0)+8>>2]=h};c[j+0>>2]=0;c[j+4>>2]=0;c[j+8>>2]=0;c[j+12>>2]=0;c[j+16>>2]=0;c[j>>2]=c[a+56>>2];c[a+56>>2]=j;c[f+0>>2]=0;c[f+4>>2]=0;c[f+8>>2]=0;c[f+12>>2]=0;c[f+16>>2]=0;c[f>>2]=c[a+56>>2];c[a+56>>2]=f;c[a+116>>2]=(c[a+116>>2]|0)+-1}while((g|0)!=(w|0));if(!r){i=K;return}c[b>>2]=d;c[d+4>>2]=b;c[r>>2]=w;c[w+4>>2]=r;i=K;return}while(0);c[f+8>>2]=0;c[f>>2]=f;c[f+4>>2]=f;c[e>>2]=f;c[e+4>>2]=f;c[e+8>>2]=f;c[e+12>>2]=f;i=K;return}function fE(a,b,d,e,f,g,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0;A=i;j=c[d+8>>2]|0;if(!j){d=0;i=A;return d|0}z=j;j=0;do{do if((c[z+20>>2]|0)>(c[a+100>>2]|0)){v=c[z+12>>2]|0;t=c[v+88>>2]|0;w=t-(c[d+88>>2]|0)|0;u=c[v+92>>2]|0;x=u-(c[d+92>>2]|0)|0;v=c[v+96>>2]|0;y=v-(c[d+96>>2]|0)|0;l=gF(w|0,((w|0)<0)<<31>>31|0,c[g>>2]|0,c[g+4>>2]|0)|0;q=D;k=gF(x|0,((x|0)<0)<<31>>31|0,c[g+8>>2]|0,c[g+12>>2]|0)|0;q=XE(k|0,D|0,l|0,q|0)|0;l=D;k=gF(y|0,((y|0)<0)<<31>>31|0,c[g+16>>2]|0,c[g+20>>2]|0)|0;k=XE(q|0,l|0,k|0,D|0)|0;l=D;q=gF(c[f>>2]|0,c[f+4>>2]|0,w|0,((w|0)<0)<<31>>31|0)|0;m=D;p=gF(c[f+8>>2]|0,c[f+12>>2]|0,x|0,((x|0)<0)<<31>>31|0)|0;m=XE(p|0,D|0,q|0,m|0)|0;q=D;p=gF(c[f+16>>2]|0,c[f+20>>2]|0,y|0,((y|0)<0)<<31>>31|0)|0;p=XE(m|0,q|0,p|0,D|0)|0;q=D;if((l|0)>0|(l|0)==0&k>>>0>0){s=l;o=1;r=k;l=1}else{r=UE(0,0,k|0,l|0)|0;s=(l|0)<0?D:0;o=(l|0)<0?-1:0;r=(l|0)<0?r:0;l=(l|0)<0?-1:0}if(!((q|0)>0|(q|0)==0&p>>>0>0)){if((q|0)<0){l=0-o|0;n=UE(0,0,p|0,q|0)|0;m=D;o=l;k=(p|0)==0&(q|0)==0}else{n=0;m=0;k=1}if((o|0)==0&k)break}else{n=p;m=q}if(!j){c[h>>2]=r;c[h+4>>2]=s;c[h+8>>2]=n;c[h+12>>2]=m;c[h+16>>2]=l;j=z;break}k=cE(r,s,n,m,l,c[h>>2]|0,c[h+4>>2]|0,c[h+8>>2]|0,c[h+12>>2]|0,c[h+16>>2]|0)|0;if((k|0)<0){c[h>>2]=r;c[h+4>>2]=s;c[h+8>>2]=n;c[h+12>>2]=m;c[h+16>>2]=l;j=z;break}if(!k){k=(c[j+4>>2]|0)==(z|0);if((c[j>>2]|0)==(z|0))if(k){n=c[e+8>>2]|0;l=$(n,x)|0;k=c[e+4>>2]|0;l=l-($(k,y)|0)|0;q=c[e>>2]|0;y=($(q,y)|0)-($(w,n)|0)|0;x=($(w,k)|0)-($(q,x)|0)|0;q=c[j+12>>2]|0;k=c[(c[z+8>>2]|0)+12>>2]|0;n=c[k+88>>2]|0;o=(c[q+88>>2]|0)-n|0;p=c[k+92>>2]|0;m=(c[q+92>>2]|0)-p|0;k=c[k+96>>2]|0;q=(c[q+96>>2]|0)-k|0;w=($(v-k|0,m)|0)-($(u-p|0,q)|0)|0;k=($(t-n|0,q)|0)-($(v-k|0,o)|0)|0;u=($(u-p|0,o)|0)-($(t-n|0,m)|0)|0;v=gF(w|0,((w|0)<0)<<31>>31|0,l|0,((l|0)<0)<<31>>31|0)|0;w=D;y=gF(k|0,((k|0)<0)<<31>>31|0,y|0,((y|0)<0)<<31>>31|0)|0;k=D;x=gF(u|0,((u|0)<0)<<31>>31|0,x|0,((x|0)<0)<<31>>31|0)|0;x=XE(v|0,w|0,x|0,D|0)|0;k=XE(x|0,D|0,y|0,k|0)|0;y=D;k=(y|0)>0|(y|0)==0&k>>>0>0?2:1}else k=2;else k=k&1;j=(k|0)==2^b?j:z}}while(0);z=c[z>>2]|0}while((z|0)!=(c[d+8>>2]|0));i=A;return j|0}function gE(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,aa=0,ba=0,ca=0,da=0;da=i;Q=c[e>>2]|0;ca=c[f>>2]|0;if(Q)g=c[Q+12>>2]|0;else g=b;j=c[g+88>>2]|0;m=c[g+92>>2]|0;n=c[g+96>>2]|0;if(!ca)g=d;else g=c[ca+12>>2]|0;F=c[g+88>>2]|0;o=c[g+92>>2]|0;E=c[g+96>>2]|0;S=c[b+88>>2]|0;aa=(c[d+88>>2]|0)-S|0;B=c[b+92>>2]|0;ba=(c[d+92>>2]|0)-B|0;b=c[b+96>>2]|0;_=(c[d+96>>2]|0)-b|0;Z=c[((Q|0)!=0?Q:ca)+12>>2]|0;T=(c[Z+88>>2]|0)-S|0;P=(c[Z+92>>2]|0)-B|0;Z=(c[Z+96>>2]|0)-b|0;Y=($(P,_)|0)-($(Z,ba)|0)|0;Z=($(Z,aa)|0)-($(T,_)|0)|0;P=($(T,ba)|0)-($(P,aa)|0)|0;S=gF(Y|0,((Y|0)<0)<<31>>31|0,S|0,((S|0)<0)<<31>>31|0)|0;T=D;B=gF(Z|0,((Z|0)<0)<<31>>31|0,B|0,((B|0)<0)<<31>>31|0)|0;C=D;b=gF(P|0,((P|0)<0)<<31>>31|0,b|0,((b|0)<0)<<31>>31|0)|0;b=XE(S|0,T|0,b|0,D|0)|0;C=XE(b|0,D|0,B|0,C|0)|0;B=D;b=gF(P|0,((P|0)<0)<<31>>31|0,ba|0,((ba|0)<0)<<31>>31|0)|0;T=D;S=gF(Z|0,((Z|0)<0)<<31>>31|0,_|0,((_|0)<0)<<31>>31|0)|0;S=UE(b|0,T|0,S|0,D|0)|0;T=D;b=gF(Y|0,((Y|0)<0)<<31>>31|0,_|0,((_|0)<0)<<31>>31|0)|0;V=D;U=gF(P|0,((P|0)<0)<<31>>31|0,aa|0,((aa|0)<0)<<31>>31|0)|0;U=UE(b|0,V|0,U|0,D|0)|0;V=D;b=gF(Z|0,((Z|0)<0)<<31>>31|0,aa|0,((aa|0)<0)<<31>>31|0)|0;X=D;W=gF(Y|0,((Y|0)<0)<<31>>31|0,ba|0,((ba|0)<0)<<31>>31|0)|0;W=UE(b|0,X|0,W|0,D|0)|0;X=D;b=gF(S|0,T|0,j|0,((j|0)<0)<<31>>31|0)|0;O=D;d=gF(U|0,V|0,m|0,((m|0)<0)<<31>>31|0)|0;O=XE(d|0,D|0,b|0,O|0)|0;b=D;d=gF(W|0,X|0,n|0,((n|0)<0)<<31>>31|0)|0;d=XE(O|0,b|0,d|0,D|0)|0;b=D;if((Q|0)!=0?(c[Q+12>>2]|0)!=0:0){q=Q;r=j;p=m;while(1){q=c[(c[q+8>>2]|0)+4>>2]|0;m=q+12|0;j=c[m>>2]|0;h=c[j+88>>2]|0;N=gF(h|0,((h|0)<0)<<31>>31|0,Y|0,((Y|0)<0)<<31>>31|0)|0;M=D;g=c[j+92>>2]|0;O=gF(g|0,((g|0)<0)<<31>>31|0,Z|0,((Z|0)<0)<<31>>31|0)|0;M=XE(O|0,D|0,N|0,M|0)|0;N=D;j=c[j+96>>2]|0;O=gF(j|0,((j|0)<0)<<31>>31|0,P|0,((P|0)<0)<<31>>31|0)|0;O=XE(M|0,N|0,O|0,D|0)|0;N=D;if((N|0)<(B|0)|(N|0)==(B|0)&O>>>0<C>>>0){j=r;g=p;h=n;break}if((c[q+20>>2]|0)==(c[a+100>>2]|0)){j=r;g=p;h=n;break}l=gF(h|0,((h|0)<0)<<31>>31|0,S|0,T|0)|0;O=D;k=gF(g|0,((g|0)<0)<<31>>31|0,U|0,V|0)|0;O=XE(k|0,D|0,l|0,O|0)|0;l=D;k=gF(j|0,((j|0)<0)<<31>>31|0,W|0,X|0)|0;k=XE(O|0,l|0,k|0,D|0)|0;l=D;if(!((l|0)>(b|0)|(l|0)==(b|0)&k>>>0>d>>>0)){j=r;g=p;h=n;break}c[e>>2]=q;O=c[m>>2]|0;j=c[O+88>>2]|0;g=c[O+92>>2]|0;h=c[O+96>>2]|0;if(!O){d=k;b=l;break}else{b=l;d=k;r=j;p=g;n=h}}r=c[f>>2]|0;G=g;n=h}else{r=ca;G=m}h=gF(S|0,T|0,F|0,((F|0)<0)<<31>>31|0)|0;O=D;g=gF(U|0,V|0,o|0,((o|0)<0)<<31>>31|0)|0;O=XE(g|0,D|0,h|0,O|0)|0;h=D;g=gF(W|0,X|0,E|0,((E|0)<0)<<31>>31|0)|0;g=XE(O|0,h|0,g|0,D|0)|0;h=D;a:do if(r)if(!(c[r+12>>2]|0)){O=r;l=F;N=E}else{t=r;p=F;r=E;while(1){q=c[c[t+8>>2]>>2]|0;m=c[q+12>>2]|0;k=c[m+88>>2]|0;N=gF(k|0,((k|0)<0)<<31>>31|0,Y|0,((Y|0)<0)<<31>>31|0)|0;M=D;l=c[m+92>>2]|0;O=gF(l|0,((l|0)<0)<<31>>31|0,Z|0,((Z|0)<0)<<31>>31|0)|0;M=XE(O|0,D|0,N|0,M|0)|0;N=D;m=c[m+96>>2]|0;O=gF(m|0,((m|0)<0)<<31>>31|0,P|0,((P|0)<0)<<31>>31|0)|0;O=XE(M|0,N|0,O|0,D|0)|0;N=D;if((N|0)<(B|0)|(N|0)==(B|0)&O>>>0<C>>>0){O=t;l=p;N=r;break a}if((c[q+20>>2]|0)==(c[a+100>>2]|0)){O=t;l=p;N=r;break a}k=gF(k|0,((k|0)<0)<<31>>31|0,S|0,T|0)|0;O=D;N=gF(l|0,((l|0)<0)<<31>>31|0,U|0,V|0)|0;O=XE(N|0,D|0,k|0,O|0)|0;k=D;m=gF(m|0,((m|0)<0)<<31>>31|0,W|0,X|0)|0;m=XE(O|0,k|0,m|0,D|0)|0;k=D;if(!((k|0)>(h|0)|(k|0)==(h|0)&m>>>0>g>>>0)){O=t;l=p;N=r;break a}c[f>>2]=q;O=c[q+12>>2]|0;l=c[O+88>>2]|0;o=c[O+92>>2]|0;r=c[O+96>>2]|0;if(!O){g=m;h=k;O=q;N=r;break}else{t=q;h=k;g=m;p=l}}}else{O=0;l=F;N=E}while(0);h=UE(g|0,h|0,d|0,b|0)|0;M=D;if((M|0)>0|(M|0)==0&h>>>0>0){H=UE(0,0,P|0,((P|0)<0)<<31>>31|0)|0;I=D;b=h;g=M;J=j;K=G;L=n;r=l;q=o;p=N;b:while(1){c:while(1){B=($(q-K|0,ba)|0)+($(p-L|0,_)|0)+($(r-J|0,aa)|0)|0;z=c[e>>2]|0;do if(((z|0)!=0?(c[z+12>>2]|0)!=0:0)?(R=c[(c[z>>2]|0)+8>>2]|0,(c[R+20>>2]|0)>(c[a+100>>2]|0)):0){C=c[R+12>>2]|0;F=c[C+88>>2]|0;m=F-J|0;E=c[C+92>>2]|0;k=E-K|0;C=c[C+96>>2]|0;t=C-L|0;d=gF(m|0,((m|0)<0)<<31>>31|0,S|0,T|0)|0;u=D;s=gF(k|0,((k|0)<0)<<31>>31|0,U|0,V|0)|0;u=XE(s|0,D|0,d|0,u|0)|0;d=D;s=gF(t|0,((t|0)<0)<<31>>31|0,W|0,X|0)|0;s=XE(u|0,d|0,s|0,D|0)|0;d=D;t=($(k,ba)|0)+($(m,aa)|0)+($(t,_)|0)|0;if((s|0)==0&(d|0)==0)if((t|0)<0)break c;else break;if((d|0)<0){if((t|0)>0){k=1;y=t;A=((t|0)<0)<<31>>31;u=1}else{y=UE(0,0,t|0,((t|0)<0)<<31>>31|0)|0;k=(t|0)<0?-1:0;y=(t|0)<0?y:0;A=(t|0)<0?D:0;u=(t|0)<0?-1:0}if(!((d|0)>0|(d|0)==0&s>>>0>0)){s=UE(0,0,s|0,d|0)|0;d=D;u=0-k|0}if((B|0)>0){t=1;k=B;m=((B|0)<0)<<31>>31;v=1}else{k=UE(0,0,B|0,((B|0)<0)<<31>>31|0)|0;t=(B|0)<0?-1:0;k=(B|0)<0?k:0;m=(B|0)<0?D:0;v=(B|0)<0?-1:0}if(!((g|0)>0|(g|0)==0&b>>>0>0))if((g|0)<0){w=UE(0,0,b|0,g|0)|0;x=D;v=0-t|0}else{w=0;x=0}else{w=b;x=g}if((cE(y,A,s,d,u,k,m,w,x,v)|0)>-1)break c}}while(0);m=c[f>>2]|0;if(!m){d=97;break b}if(!(c[m+12>>2]|0)){d=97;break b}F=c[c[m+8>>2]>>2]|0;if((c[F+20>>2]|0)<=(c[a+100>>2]|0)){d=97;break b}E=c[F+12>>2]|0;k=c[E+88>>2]|0;t=k-r|0;d=c[E+92>>2]|0;s=d-q|0;q=c[E+96>>2]|0;r=q-p|0;E=gF(t|0,((t|0)<0)<<31>>31|0,Y|0,((Y|0)<0)<<31>>31|0)|0;m=D;C=gF(s|0,((s|0)<0)<<31>>31|0,Z|0,((Z|0)<0)<<31>>31|0)|0;m=XE(C|0,D|0,E|0,m|0)|0;E=D;C=gF(r|0,((r|0)<0)<<31>>31|0,H|0,I|0)|0;if(!((m|0)==(C|0)&(E|0)==(D|0))){d=97;break b}p=gF(t|0,((t|0)<0)<<31>>31|0,S|0,T|0)|0;w=D;u=gF(s|0,((s|0)<0)<<31>>31|0,U|0,V|0)|0;w=XE(u|0,D|0,p|0,w|0)|0;p=D;u=gF(r|0,((r|0)<0)<<31>>31|0,W|0,X|0)|0;u=XE(w|0,p|0,u|0,D|0)|0;p=D;t=($(s,ba)|0)+($(t,aa)|0)+($(r,_)|0)|0;w=k-J|0;C=d-K|0;x=q-L|0;w=gF(w|0,((w|0)<0)<<31>>31|0,S|0,T|0)|0;E=D;C=gF(C|0,((C|0)<0)<<31>>31|0,U|0,V|0)|0;E=XE(C|0,D|0,w|0,E|0)|0;w=D;x=gF(x|0,((x|0)<0)<<31>>31|0,W|0,X|0)|0;x=XE(E|0,w|0,x|0,D|0)|0;w=D;if(!((w|0)>0|(w|0)==0&x>>>0>0)){d=97;break b}if((u|0)==0&(p|0)==0){if((t|0)>=0){d=97;break b}}else{if((p|0)>=0){d=97;break b}if((t|0)>0){s=1;v=t;k=((t|0)<0)<<31>>31;t=1}else{v=UE(0,0,t|0,((t|0)<0)<<31>>31|0)|0;s=(t|0)<0?-1:0;v=(t|0)<0?v:0;k=(t|0)<0?D:0;t=(t|0)<0?-1:0}if((p|0)>0|(p|0)==0&u>>>0>0)d=p;else{u=UE(0,0,u|0,p|0)|0;d=D;t=0-s|0}if((B|0)>0){r=1;q=B;p=((B|0)<0)<<31>>31;s=1}else{q=UE(0,0,B|0,((B|0)<0)<<31>>31|0)|0;r=(B|0)<0?-1:0;q=(B|0)<0?q:0;p=(B|0)<0?D:0;s=(B|0)<0?-1:0}do if(!((g|0)>0|(g|0)==0&b>>>0>0)){if((g|0)>=0){b=0;g=0;break}b=UE(0,0,b|0,g|0)|0;g=D;s=0-r|0}while(0);if((cE(v,k,u,d,t,q,p,b,g,s)|0)<=0){d=97;break b}}c[f>>2]=F;p=c[F+12>>2]|0;g=w;b=x;r=c[p+88>>2]|0;q=c[p+92>>2]|0;p=c[p+96>>2]|0}g=r-F|0;K=q-E|0;b=p-C|0;g=gF(g|0,((g|0)<0)<<31>>31|0,S|0,T|0)|0;J=D;K=gF(K|0,((K|0)<0)<<31>>31|0,U|0,V|0)|0;J=XE(K|0,D|0,g|0,J|0)|0;g=D;b=gF(b|0,((b|0)<0)<<31>>31|0,W|0,X|0)|0;b=XE(J|0,g|0,b|0,D|0)|0;c[e>>2]=(z|0)==(Q|0)?0:R;g=D;J=F;K=E;L=C}if((d|0)==97){i=da;return}}if((M|0)>=0){i=da;return}L=UE(0,0,P|0,((P|0)<0)<<31>>31|0)|0;K=D;m=O;d=M;r=l;q=N;while(1){l=($(o-G|0,ba)|0)+($(q-n|0,_)|0)+($(r-j|0,aa)|0)|0;d:do if(!m){C=l;F=((l|0)<0)<<31>>31;m=d;w=l;z=r}else{A=m;C=l;F=((l|0)<0)<<31>>31;w=l;x=r;y=q;while(1){if(!(c[A+12>>2]|0)){m=d;z=x;q=y;break d}v=c[(c[A+4>>2]|0)+8>>2]|0;if((c[v+20>>2]|0)<=(c[a+100>>2]|0)){m=d;z=x;q=y;break d}E=c[v+12>>2]|0;z=c[E+88>>2]|0;R=z-x|0;B=c[E+92>>2]|0;Q=B-o|0;E=c[E+96>>2]|0;m=E-y|0;p=gF(R|0,((R|0)<0)<<31>>31|0,S|0,T|0)|0;P=D;l=gF(Q|0,((Q|0)<0)<<31>>31|0,U|0,V|0)|0;P=XE(l|0,D|0,p|0,P|0)|0;p=D;l=gF(m|0,((m|0)<0)<<31>>31|0,W|0,X|0)|0;l=XE(P|0,p|0,l|0,D|0)|0;p=D;m=($(Q,ba)|0)+($(R,aa)|0)+($(m,_)|0)|0;if((l|0)==0&(p|0)==0){if((m|0)<=0){m=d;z=x;q=y;break d}}else{if((p|0)>=0){m=d;z=x;q=y;break d}if((m|0)>0){q=1;t=m;u=((m|0)<0)<<31>>31;r=1}else{t=UE(0,0,m|0,((m|0)<0)<<31>>31|0)|0;q=(m|0)<0?-1:0;t=(m|0)<0?t:0;u=(m|0)<0?D:0;r=(m|0)<0?-1:0}if(!((p|0)>0|(p|0)==0&l>>>0>0)){l=UE(0,0,l|0,p|0)|0;p=D;r=0-q|0}if((w|0)>0){g=1;b=C;k=F;q=1}else{q=(w|0)<0;b=UE(0,0,C|0,F|0)|0;g=q?-1:0;b=q?b:0;k=q?D:0;q=q?-1:0}do if((d|0)>0|(d|0)==0&h>>>0>0){m=h;s=d}else{if((d|0)>=0){m=0;s=0;break}m=UE(0,0,h|0,d|0)|0;s=D;q=0-g|0}while(0);if((cE(t,u,l,p,r,b,k,m,s,q)|0)>=1){m=d;z=x;q=y;break d}}l=z-j|0;Q=B-G|0;R=E-n|0;d=gF(l|0,((l|0)<0)<<31>>31|0,S|0,T|0)|0;P=D;h=gF(Q|0,((Q|0)<0)<<31>>31|0,U|0,V|0)|0;P=XE(h|0,D|0,d|0,P|0)|0;d=D;h=gF(R|0,((R|0)<0)<<31>>31|0,W|0,X|0)|0;h=XE(P|0,d|0,h|0,D|0)|0;d=D;A=(A|0)==(ca|0)?0:v;c[f>>2]=A;l=($(Q,ba)|0)+($(R,_)|0)+($(l,aa)|0)|0;if(!A){C=l;F=((l|0)<0)<<31>>31;m=d;w=l;o=B;q=E;break}else{C=l;F=((l|0)<0)<<31>>31;w=l;x=z;o=B;y=E}}}while(0);d=c[e>>2]|0;if(!d){d=97;break}if(!(c[d+12>>2]|0)){d=97;break}x=c[(c[d+8>>2]|0)+4>>2]|0;if((c[x+20>>2]|0)<=(c[a+100>>2]|0)){d=97;break}k=c[x+12>>2]|0;g=c[k+88>>2]|0;d=g-j|0;b=c[k+92>>2]|0;l=b-G|0;k=c[k+96>>2]|0;j=k-n|0;R=gF(d|0,((d|0)<0)<<31>>31|0,Y|0,((Y|0)<0)<<31>>31|0)|0;P=D;Q=gF(l|0,((l|0)<0)<<31>>31|0,Z|0,((Z|0)<0)<<31>>31|0)|0;P=XE(Q|0,D|0,R|0,P|0)|0;R=D;Q=gF(j|0,((j|0)<0)<<31>>31|0,L|0,K|0)|0;if(!((P|0)==(Q|0)&(R|0)==(D|0))){d=97;break}r=gF(d|0,((d|0)<0)<<31>>31|0,S|0,T|0)|0;Q=D;p=gF(l|0,((l|0)<0)<<31>>31|0,U|0,V|0)|0;Q=XE(p|0,D|0,r|0,Q|0)|0;r=D;p=gF(j|0,((j|0)<0)<<31>>31|0,W|0,X|0)|0;p=XE(Q|0,r|0,p|0,D|0)|0;r=D;l=($(l,ba)|0)+($(d,aa)|0)+($(j,_)|0)|0;d=z-g|0;Q=o-b|0;t=q-k|0;d=gF(d|0,((d|0)<0)<<31>>31|0,S|0,T|0)|0;R=D;Q=gF(Q|0,((Q|0)<0)<<31>>31|0,U|0,V|0)|0;R=XE(Q|0,D|0,d|0,R|0)|0;d=D;t=gF(t|0,((t|0)<0)<<31>>31|0,W|0,X|0)|0;t=XE(R|0,d|0,t|0,D|0)|0;d=D;if((d|0)>=0){d=97;break}if((p|0)==0&(r|0)==0){if((l|0)<=0){d=97;break}}else{if((r|0)>=0){d=97;break}if((l|0)>0){k=1;s=l;n=((l|0)<0)<<31>>31;l=1}else{s=UE(0,0,l|0,((l|0)<0)<<31>>31|0)|0;k=(l|0)<0?-1:0;s=(l|0)<0?s:0;n=(l|0)<0?D:0;l=(l|0)<0?-1:0}if(!((r|0)>0|(r|0)==0&p>>>0>0)){p=UE(0,0,p|0,r|0)|0;r=D;l=0-k|0}if((w|0)>0){b=1;g=C;k=F;j=1}else{j=(w|0)<0;g=UE(0,0,C|0,F|0)|0;b=j?-1:0;g=j?g:0;k=j?D:0;j=j?-1:0}do if(!((m|0)>0|(m|0)==0&h>>>0>0)){if((m|0)>=0){h=0;m=0;break}h=UE(0,0,h|0,m|0)|0;m=D;j=0-b|0}while(0);if((cE(s,n,p,r,l,g,k,h,m,j)|0)>=0){d=97;break}}c[e>>2]=x;n=c[x+12>>2]|0;m=c[f>>2]|0;h=t;j=c[n+88>>2]|0;G=c[n+92>>2]|0;n=c[n+96>>2]|0;r=z}if((d|0)==97){i=da;return}}function hE(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,h=0,j=0,k=0.0,l=0,m=0,n=0,o=0.0,p=0.0,q=0,r=0,s=0,t=0.0,u=0.0,v=0.0,w=0,x=0.0,y=0.0,z=0.0,A=0.0,B=0,C=0,D=0,E=0,F=0,G=0,H=0;H=i;i=i+256|0;if((e|0)<1){f=c[b+12>>2]|0;if(f){if(a[b+16>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[f+-4>>2]|0)}c[b+12>>2]=0}a[b+16>>0]=1;c[b+12>>2]=0;c[b+4>>2]=0;c[b+8>>2]=0;f=c[b+32>>2]|0;if(f){if(a[b+36>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[f+-4>>2]|0)}c[b+32>>2]=0}a[b+36>>0]=1;c[b+32>>2]=0;c[b+24>>2]=0;c[b+28>>2]=0;f=c[b+52>>2]|0;if(f){if(a[b+56>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[f+-4>>2]|0)}c[b+52>>2]=0}a[b+56>>0]=1;c[b+52>>2]=0;c[b+44>>2]=0;c[b+48>>2]=0;i=H;return}c[H+88>>2]=0;c[H+92>>2]=0;r=H+96|0;c[r>>2]=0;c[H+100>>2]=256;c[H+104>>2]=0;c[H+108>>2]=0;c[H+112>>2]=0;c[H+116>>2]=256;c[H+120>>2]=0;c[H+124>>2]=0;c[H+128>>2]=0;c[H+132>>2]=256;a[H+152>>0]=1;E=H+148|0;c[E>>2]=0;c[H+140>>2]=0;c[H+144>>2]=0;t=1000000015047466219876688.0e6;u=1000000015047466219876688.0e6;x=-1000000015047466219876688.0e6;y=-1000000015047466219876688.0e6;z=-1000000015047466219876688.0e6;A=1000000015047466219876688.0e6;m=0;l=d;while(1){p=+g[l>>2];o=+g[l+4>>2];k=+g[l+8>>2];t=p<t?p:t;u=o<u?o:u;A=k<A?k:A;x=x<p?p:x;y=y<o?o:y;z=z<k?k:z;m=m+1|0;if((m|0)==(e|0))break;else l=l+16|0}v=x-t;p=y-u;o=z-A;if(v<p){c[H+168>>2]=p<o?2:1;n=v<o?0:2;w=H+168|0}else{c[H+168>>2]=v<o?2:0;n=p<o?1:2;w=H+168|0}c[H+160>>2]=n;q=c[w>>2]|0;if((n|0)==(q|0)){n=((n+1|0)>>>0)%3|0;c[H+160>>2]=n;q=c[w>>2]|0}q=3-q-n|0;c[H+164>>2]=q;if(((q+1|0)%3|0|0)==(c[w>>2]|0)){p=p*9.788566967472434e-05;o=o*9.788566967472434e-05;k=v*9.788566967472434e-05}else{p=-(p*9.788566967472434e-05);o=-(o*9.788566967472434e-05);k=-(v*9.788566967472434e-05)}g[H+56>>2]=k;g[H+60>>2]=p;g[H+64>>2]=o;g[H+68>>2]=0.0;if(k!=0.0)k=1.0/k;if(p!=0.0)p=1.0/p;if(o!=0.0)o=1.0/o;g[H+72>>2]=(t+x)*.5;g[H+76>>2]=(u+y)*.5;g[H+80>>2]=(A+z)*.5;g[H+84>>2]=0.0;D=H+248|0;a[D>>0]=1;B=H+244|0;c[B>>2]=0;C=H+236|0;c[C>>2]=0;c[H+240>>2]=0;if((e|0)>0){c[5108]=(c[5108]|0)+1;m=QE((e<<4|3)+16|0)|0;if(!m)m=0;else{c[(m+19&-16)+-4>>2]=m;m=m+19&-16}q=c[C>>2]|0;n=c[B>>2]|0;if((q|0)>0){j=0;do{l=m+(j<<4)|0;if(l){G=n+(j<<4)|0;c[l+0>>2]=c[G+0>>2];c[l+4>>2]=c[G+4>>2];c[l+8>>2]=c[G+8>>2];c[l+12>>2]=c[G+12>>2]}j=j+1|0}while((j|0)!=(q|0))}if(n){if(a[D>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[n+-4>>2]|0)}c[B>>2]=0}a[D>>0]=1;c[B>>2]=m;c[H+240>>2]=e;l=0;while(1){n=m+(l<<4)|0;if(n){c[n+0>>2]=c[H+216>>2];c[n+4>>2]=c[H+220>>2];c[n+8>>2]=c[H+224>>2];c[n+12>>2]=c[H+228>>2]}n=l+1|0;if((n|0)==(e|0))break;m=c[B>>2]|0;l=n}c[C>>2]=e;l=c[B>>2]|0;t=+g[H+72>>2];u=+g[H+76>>2];v=+g[H+80>>2];j=H+200+(c[H+164>>2]<<2)|0;q=H+200+(c[w>>2]<<2)|0;n=H+200+(c[H+160>>2]<<2)|0;m=0;while(1){x=+g[d>>2];g[H+200>>2]=x;z=+g[d+4>>2];g[H+204>>2]=z;y=o*(+g[d+8>>2]-v);g[H+200>>2]=k*(x-t);g[H+204>>2]=p*(z-u);g[H+208>>2]=y;g[H+212>>2]=0.0;c[l+(m<<4)>>2]=~~+g[j>>2];c[l+(m<<4)+4>>2]=~~+g[q>>2];c[l+(m<<4)+8>>2]=~~+g[n>>2];c[l+(m<<4)+12>>2]=m;m=m+1|0;if((m|0)==(e|0))break;else d=d+16|0}if((e|0)>1)iE(H+232|0,0,e+-1|0)}else c[C>>2]=e;c[H+92>>2]=c[H+88>>2];c[r>>2]=0;c[H+100>>2]=e;j=c[H+140>>2]|0;if((j|0)<(e|0)){if((c[H+144>>2]|0)<(e|0)){if(!e){f=j;m=0}else{c[5108]=(c[5108]|0)+1;l=QE((e<<2|3)+16|0)|0;if(!l)m=0;else{c[(l+19&-16)+-4>>2]=l;m=l+19&-16}f=c[H+140>>2]|0}if((f|0)>0){h=0;do{l=m+(h<<2)|0;if(l)c[l>>2]=c[(c[E>>2]|0)+(h<<2)>>2];h=h+1|0}while((h|0)!=(f|0))}l=c[E>>2]|0;if(l){if(a[H+152>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[l+-4>>2]|0)}c[E>>2]=0}a[H+152>>0]=1;c[E>>2]=m;c[H+144>>2]=e}do{l=(c[E>>2]|0)+(j<<2)|0;if(l)c[l>>2]=0;j=j+1|0}while((j|0)!=(e|0))}c[H+140>>2]=e;if((e|0)>0){d=0;do{l=c[r>>2]|0;if(!l){l=c[H+92>>2]|0;if(!l){c[5108]=(c[5108]|0)+1;j=QE(31)|0;if((j|0)!=0?(F=j+19&-16,c[F+-4>>2]=j,(j+19&-16|0)!=0):0){l=c[H+100>>2]|0;c[F+4>>2]=l;c[F+8>>2]=0;c[5108]=(c[5108]|0)+1;l=QE((l*112|3)+16|0)|0;if(!l)m=0;else{c[(l+19&-16)+-4>>2]=l;m=l+19&-16}c[(j+19&-16)>>2]=m;l=j+19&-16}else l=0;c[l+8>>2]=c[H+88>>2];c[H+88>>2]=l}else c[H+92>>2]=c[l+8>>2];h=c[l+4>>2]|0;l=c[l>>2]|0;if((h|0)>0){m=0;j=l;do{m=m+1|0;q=j;j=j+112|0;c[q>>2]=(m|0)<(h|0)?j:0}while((m|0)!=(h|0))}c[r>>2]=c[l>>2];if(!l)l=0;else s=83}else{c[r>>2]=c[l>>2];s=83}if((s|0)==83){s=0;c[l+0>>2]=0;c[l+4>>2]=0;c[l+8>>2]=0;c[l+12>>2]=0;c[l+16>>2]=0;c[l+104>>2]=-1}c[l+8>>2]=0;q=l+88|0;n=(c[B>>2]|0)+(d<<4)|0;c[q+0>>2]=c[n+0>>2];c[q+4>>2]=c[n+4>>2];c[q+8>>2]=c[n+8>>2];c[q+12>>2]=c[n+12>>2];c[l+104>>2]=-1;c[(c[E>>2]|0)+(d<<2)>>2]=l;d=d+1|0}while((d|0)!=(e|0))}j=c[B>>2]|0;if(j){if(a[D>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[j+-4>>2]|0)}c[B>>2]=0}a[D>>0]=1;c[B>>2]=0;c[C>>2]=0;c[H+240>>2]=0;c[H+108>>2]=c[H+104>>2];c[H+112>>2]=0;c[H+116>>2]=e*6;c[H+172>>2]=0;c[H+176>>2]=0;c[H+156>>2]=-3;c[H+184>>2]=0;c[H+188>>2]=0;c[H+192>>2]=0;c[H+196>>2]=0;eE(H+56|0,0,e,H+184|0);c[H+180>>2]=c[H+184>>2];h=c[B>>2]|0;if(h){if(a[D>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[h+-4>>2]|0)}c[B>>2]=0}f=c[b+4>>2]|0;if((f|0)<0){if((c[b+8>>2]|0)<0){h=c[b+12>>2]|0;if(h){if(a[b+16>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[h+-4>>2]|0)}c[b+12>>2]=0}a[b+16>>0]=1;c[b+12>>2]=0;c[b+8>>2]=0}do{d=(c[b+12>>2]|0)+(f<<4)|0;c[d+0>>2]=c[H+40>>2];c[d+4>>2]=c[H+44>>2];c[d+8>>2]=c[H+48>>2];c[d+12>>2]=c[H+52>>2];f=f+1|0}while((f|0)!=0)}c[b+4>>2]=0;c[H+24>>2]=0;c[H+28>>2]=0;c[H+32>>2]=0;h=c[b+24>>2]|0;if((h|0)<0){if((c[b+28>>2]|0)<0){f=c[b+32>>2]|0;if(f){if(a[b+36>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[f+-4>>2]|0)}c[b+32>>2]=0}a[b+36>>0]=1;c[b+32>>2]=0;c[b+28>>2]=0}do{f=(c[b+32>>2]|0)+(h*12|0)|0;if(f){c[f+0>>2]=c[H+24>>2];c[f+4>>2]=c[H+28>>2];c[f+8>>2]=c[H+32>>2]}h=h+1|0}while((h|0)!=0)}c[b+24>>2]=0;f=c[b+44>>2]|0;if((f|0)<0){h=c[b+52>>2]|0;if((c[b+48>>2]|0)<0){if(h){if(a[b+56>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[h+-4>>2]|0)}c[b+52>>2]=0}a[b+56>>0]=1;c[b+52>>2]=0;c[b+48>>2]=0;h=0}do{j=h+(f<<2)|0;if(j)c[j>>2]=0;f=f+1|0}while((f|0)!=0)}c[b+44>>2]=0;h=c[H+180>>2]|0;if((c[h+104>>2]|0)<0){c[h+104>>2]=0;c[5108]=(c[5108]|0)+1;j=QE(23)|0;if(j){c[(j+19&-16)+-4>>2]=j;f=j+19&-16;if(j+19&-16)c[f>>2]=h}else f=0;d=1;G=0;j=1;while(1){q=c[f+(G<<2)>>2]|0;if((c[q+100>>2]|0)>-1){g[H+232+(c[H+164>>2]<<2)>>2]=+(c[q+88>>2]|0);g[H+232+(c[H+168>>2]<<2)>>2]=+(c[q+92>>2]|0);k=+(c[q+96>>2]|0)}else{k=+jE(q+24|0);k=k/+jE(q+72|0);g[H+232+(c[H+164>>2]<<2)>>2]=k;k=+jE(q+40|0);k=k/+jE(q+72|0);g[H+232+(c[H+168>>2]<<2)>>2]=k;k=+jE(q+56|0);k=k/+jE(q+72|0)}g[H+232+(c[H+160>>2]<<2)>>2]=k;k=+g[H+232>>2]*+g[H+56>>2]+ +g[H+72>>2];p=+g[H+236>>2]*+g[H+60>>2]+ +g[H+76>>2];o=+g[H+240>>2]*+g[H+64>>2]+ +g[H+80>>2];h=c[b+4>>2]|0;do if((h|0)==(c[b+8>>2]|0)){n=(h|0)==0?1:h<<1;if((h|0)>=(n|0))break;if(!n)m=0;else{c[5108]=(c[5108]|0)+1;l=QE((n<<4|3)+16|0)|0;if(!l)m=0;else{c[(l+19&-16)+-4>>2]=l;m=l+19&-16}h=c[b+4>>2]|0}if((h|0)>0){l=0;do{e=m+(l<<4)|0;s=(c[b+12>>2]|0)+(l<<4)|0;c[e+0>>2]=c[s+0>>2];c[e+4>>2]=c[s+4>>2];c[e+8>>2]=c[s+8>>2];c[e+12>>2]=c[s+12>>2];l=l+1|0}while((l|0)!=(h|0))}l=c[b+12>>2]|0;if(l){if(a[b+16>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[l+-4>>2]|0)}c[b+12>>2]=0}a[b+16>>0]=1;c[b+12>>2]=m;c[b+8>>2]=n;h=c[b+4>>2]|0}while(0);F=c[b+12>>2]|0;g[F+(h<<4)>>2]=k;g[F+(h<<4)+4>>2]=p;g[F+(h<<4)+8>>2]=o;g[F+(h<<4)+12>>2]=0.0;c[b+4>>2]=(c[b+4>>2]|0)+1;F=c[q+8>>2]|0;if(!F)h=d;else{D=d;e=F;l=-1;s=j;C=f;E=-1;while(1){B=e+20|0;j=c[B>>2]|0;if((j|0)<0){r=c[b+24>>2]|0;c[H+12>>2]=0;c[H+16>>2]=0;c[H+20>>2]=0;m=c[b+28>>2]|0;do if((r|0)==(m|0)){m=(r|0)==0?1:r<<1;if((r|0)>=(m|0)){j=r;m=r;break}if(!m){h=r;f=0}else{c[5108]=(c[5108]|0)+1;j=QE((m*12|3)+16|0)|0;if(!j)j=0;else{c[(j+19&-16)+-4>>2]=j;j=j+19&-16}h=c[b+24>>2]|0;f=j}if((h|0)>0){j=0;do{n=f+(j*12|0)|0;if(n){d=(c[b+32>>2]|0)+(j*12|0)|0;c[n+0>>2]=c[d+0>>2];c[n+4>>2]=c[d+4>>2];c[n+8>>2]=c[d+8>>2]}j=j+1|0}while((j|0)!=(h|0))}j=c[b+32>>2]|0;if(j){if(a[b+36>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[j+-4>>2]|0)}c[b+32>>2]=0}a[b+36>>0]=1;c[b+32>>2]=f;c[b+28>>2]=m;j=c[b+24>>2]|0}else j=r;while(0);h=(c[b+32>>2]|0)+(j*12|0)|0;if(h){c[h+0>>2]=c[H+12>>2];c[h+4>>2]=c[H+16>>2];c[h+8>>2]=c[H+20>>2];j=c[b+24>>2]|0;m=c[b+28>>2]|0}j=j+1|0;c[b+24>>2]=j;c[H+0>>2]=0;c[H+4>>2]=0;c[H+8>>2]=0;do if((j|0)==(m|0)){q=(m|0)==0?1:m<<1;if((m|0)>=(q|0))break;if(!q)j=0;else{c[5108]=(c[5108]|0)+1;m=QE((q*12|3)+16|0)|0;if(!m)j=0;else{c[(m+19&-16)+-4>>2]=m;j=m+19&-16}m=c[b+24>>2]|0}if((m|0)>0){h=0;do{n=j+(h*12|0)|0;if(n){d=(c[b+32>>2]|0)+(h*12|0)|0;c[n+0>>2]=c[d+0>>2];c[n+4>>2]=c[d+4>>2];c[n+8>>2]=c[d+8>>2]}h=h+1|0}while((h|0)!=(m|0))}m=c[b+32>>2]|0;if(m){if(a[b+36>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[m+-4>>2]|0)}c[b+32>>2]=0}a[b+36>>0]=1;c[b+32>>2]=j;c[b+28>>2]=q;m=c[b+24>>2]|0}else m=j;while(0);h=c[b+32>>2]|0;j=h+(m*12|0)|0;if(!j)w=h;else{c[j+0>>2]=c[H+0>>2];c[j+4>>2]=c[H+4>>2];c[j+8>>2]=c[H+8>>2];m=c[b+24>>2]|0;w=c[b+32>>2]|0}c[b+24>>2]=m+1;c[B>>2]=r;c[(c[e+8>>2]|0)+20>>2]=r+1;c[w+(r*12|0)+4>>2]=1;c[w+((r+1|0)*12|0)+4>>2]=-1;d=c[e+12>>2]|0;m=c[d+104>>2]|0;if((m|0)<0){c[d+104>>2]=D;do if((D|0)==(s|0)){j=(s|0)==0?1:s<<1;if((s|0)>=(j|0)){j=s;f=C;break}do if(!j)f=0;else{c[5108]=(c[5108]|0)+1;m=QE((j<<2|3)+16|0)|0;if(!m){f=0;break}c[(m+19&-16)+-4>>2]=m;f=m+19&-16}while(0);if((s|0)>0){m=0;do{n=f+(m<<2)|0;if(n)c[n>>2]=c[C+(m<<2)>>2];m=m+1|0}while((m|0)!=(s|0))}if(!C)break;c[5110]=(c[5110]|0)+1;RE(c[C+-4>>2]|0)}else{j=s;f=C}while(0);m=f+(D<<2)|0;if(m)c[m>>2]=d;h=D+1|0;m=D}else{h=D;j=s;f=C}c[w+(r*12|0)+8>>2]=m;c[w+((r+1|0)*12|0)+8>>2]=G;n=c[B>>2]|0}else{n=j;h=D;j=s;f=C}if((E|0)>-1)c[(c[b+32>>2]|0)+(n*12|0)>>2]=E-n;else l=n;e=c[e>>2]|0;if((e|0)==(F|0))break;else{D=h;s=j;C=f;E=n}}c[(c[b+32>>2]|0)+(l*12|0)>>2]=n-l}w=G+1|0;if((w|0)<(h|0)){d=h;G=w}else break}if((G|0)>-1){s=0;do{d=c[(c[f+(s<<2)>>2]|0)+8>>2]|0;if(d){r=d;do{q=r+20|0;if((c[q>>2]|0)>-1){j=c[b+44>>2]|0;do if((j|0)==(c[b+48>>2]|0)){n=(j|0)==0?1:j<<1;if((j|0)>=(n|0))break;if(!n)l=0;else{c[5108]=(c[5108]|0)+1;j=QE((n<<2|3)+16|0)|0;if(!j)l=0;else{c[(j+19&-16)+-4>>2]=j;l=j+19&-16}j=c[b+44>>2]|0}if((j|0)>0){m=0;do{h=l+(m<<2)|0;if(h)c[h>>2]=c[(c[b+52>>2]|0)+(m<<2)>>2];m=m+1|0}while((m|0)!=(j|0))}j=c[b+52>>2]|0;if(j){if(a[b+56>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[j+-4>>2]|0)}c[b+52>>2]=0}a[b+56>>0]=1;c[b+52>>2]=l;c[b+48>>2]=n;j=c[b+44>>2]|0}while(0);h=(c[b+52>>2]|0)+(j<<2)|0;if(h){c[h>>2]=c[q>>2];j=c[b+44>>2]|0}c[b+44>>2]=j+1;j=r;do{c[j+20>>2]=-1;j=c[(c[j+8>>2]|0)+4>>2]|0}while((j|0)!=(r|0))}r=c[r>>2]|0}while((r|0)!=(d|0))}s=s+1|0}while((s|0)<(w|0))}if(f){c[5110]=(c[5110]|0)+1;RE(c[f+-4>>2]|0)}}kE(H+56|0);i=H;return}function iE(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0;m=i;i=i+16|0;h=c[a+12>>2]|0;j=c[h+(((d+b|0)/2|0)<<4)>>2]|0;k=c[h+(((d+b|0)/2|0)<<4)+4>>2]|0;l=c[h+(((d+b|0)/2|0)<<4)+8>>2]|0;e=b;f=d;while(1){g=e;while(1){e=c[h+(g<<4)+4>>2]|0;if((e|0)>=(k|0)){if((e|0)!=(k|0))break;e=c[h+(g<<4)>>2]|0;if((e|0)>=(j|0)){if((e|0)!=(j|0))break;if((c[h+(g<<4)+8>>2]|0)>=(l|0))break}}g=g+1|0}while(1){e=c[h+(f<<4)+4>>2]|0;if((k|0)>=(e|0)){if((k|0)!=(e|0))break;e=c[h+(f<<4)>>2]|0;if((j|0)>=(e|0)){if((j|0)!=(e|0))break;if((l|0)>=(c[h+(f<<4)+8>>2]|0))break}}f=f+-1|0}if((g|0)>(f|0))e=g;else{e=h+(g<<4)|0;c[m+0>>2]=c[e+0>>2];c[m+4>>2]=c[e+4>>2];c[m+8>>2]=c[e+8>>2];c[m+12>>2]=c[e+12>>2];h=h+(f<<4)|0;c[e+0>>2]=c[h+0>>2];c[e+4>>2]=c[h+4>>2];c[e+8>>2]=c[h+8>>2];c[e+12>>2]=c[h+12>>2];e=(c[a+12>>2]|0)+(f<<4)|0;c[e+0>>2]=c[m+0>>2];c[e+4>>2]=c[m+4>>2];c[e+8>>2]=c[m+8>>2];c[e+12>>2]=c[m+12>>2];e=g+1|0;f=f+-1|0}if((e|0)>(f|0))break;h=c[a+12>>2]|0}if((f|0)>(b|0))iE(a,b,f);if((e|0)>=(d|0)){i=m;return}iE(a,e,d);i=m;return}function jE(a){a=a|0;var b=0,d=0,e=0,f=0,g=0.0,h=0,j=0;f=i;i=i+16|0;d=c[a+8>>2]|0;e=c[a+12>>2]|0;b=c[a>>2]|0;a=c[a+4>>2]|0;if((e|0)>-1|(e|0)==-1&d>>>0>4294967295){g=(+(d>>>0)+4294967296.0*+(e>>>0))*18446744073709551616.0+(+(b>>>0)+4294967296.0*+(a>>>0));i=f;return +g}else{j=UE(0,0,b|0,a|0)|0;h=D;a=XE((b|0)==0&(a|0)==0&1|0,0,~d|0,~e|0)|0;c[f>>2]=j;c[f+4>>2]=h;c[f+8>>2]=a;c[f+12>>2]=D;g=-+jE(f);i=f;return +g}return 0.0}function kE(b){b=b|0;var d=0,e=0,f=0;f=i;d=c[b+92>>2]|0;if(d){if(a[b+96>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}c[b+92>>2]=0}a[b+96>>0]=1;c[b+92>>2]=0;c[b+84>>2]=0;c[b+88>>2]=0;d=c[b+64>>2]|0;if(d)do{c[b+64>>2]=c[d+8>>2];e=c[d>>2]|0;if(e){c[5110]=(c[5110]|0)+1;RE(c[e+-4>>2]|0)}c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0);d=c[b+64>>2]|0}while((d|0)!=0);d=c[b+48>>2]|0;if(d)do{c[b+48>>2]=c[d+8>>2];e=c[d>>2]|0;if(e){c[5110]=(c[5110]|0)+1;RE(c[e+-4>>2]|0)}c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0);d=c[b+48>>2]|0}while((d|0)!=0);d=c[b+32>>2]|0;if(!d){i=f;return}do{c[b+32>>2]=c[d+8>>2];e=c[d>>2]|0;if(e){c[5110]=(c[5110]|0)+1;RE(c[e+-4>>2]|0)}c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0);d=c[b+32>>2]|0}while((d|0)!=0);i=f;return}function lE(a,b){a=a|0;b=b|0;var d=0;d=i;i=i+16|0;c[d>>2]=b;b=c[n>>2]|0;Za(b|0,a|0,d|0)|0;vb(10,b|0)|0;xb()}function mE(a){a=a|0;return}function nE(a){a=a|0;var b=0;b=i;RE(a);i=b;return}function oE(a){a=a|0;return 20832}function pE(a){a=a|0;var b=0;b=i;i=i+16|0;qc[a&3]();lE(20880,b)}function qE(a){a=a|0;return}function rE(a){a=a|0;return}function sE(a){a=a|0;return}function tE(a){a=a|0;var b=0;b=i;RE(a);i=b;return}function uE(a){a=a|0;var b=0;b=i;RE(a);i=b;return}function vE(a){a=a|0;var b=0;b=i;RE(a);i=b;return}function wE(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0;g=i;i=i+64|0;if((a|0)==(b|0)){b=1;i=g;return b|0}if(!b){b=0;i=g;return b|0}b=BE(b,21072)|0;if(!b){b=0;i=g;return b|0}e=g+0|0;f=e+56|0;do{c[e>>2]=0;e=e+4|0}while((e|0)<(f|0));c[g>>2]=b;c[g+8>>2]=a;c[g+12>>2]=-1;c[g+48>>2]=1;tc[c[(c[b>>2]|0)+28>>2]&127](b,g,c[d>>2]|0,1);if((c[g+24>>2]|0)!=1){b=0;i=g;return b|0}c[d>>2]=c[g+16>>2];b=1;i=g;return b|0}function xE(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0;g=i;if((c[d+8>>2]|0)!=(b|0)){i=g;return}b=c[d+16>>2]|0;if(!b){c[d+16>>2]=e;c[d+24>>2]=f;c[d+36>>2]=1;i=g;return}if((b|0)!=(e|0)){c[d+36>>2]=(c[d+36>>2]|0)+1;c[d+24>>2]=2;a[d+54>>0]=1;i=g;return}if((c[d+24>>2]|0)!=2){i=g;return}c[d+24>>2]=f;i=g;return}function yE(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0;g=i;if((b|0)!=(c[d+8>>2]|0)){b=c[b+8>>2]|0;tc[c[(c[b>>2]|0)+28>>2]&127](b,d,e,f);i=g;return}b=c[d+16>>2]|0;if(!b){c[d+16>>2]=e;c[d+24>>2]=f;c[d+36>>2]=1;i=g;return}if((b|0)!=(e|0)){c[d+36>>2]=(c[d+36>>2]|0)+1;c[d+24>>2]=2;a[d+54>>0]=1;i=g;return}if((c[d+24>>2]|0)!=2){i=g;return}c[d+24>>2]=f;i=g;return}function zE(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0;h=i;f=c[a+4>>2]|0;if(!(f&1))g=f>>8;else g=c[(c[d>>2]|0)+(f>>8)>>2]|0;a=c[a>>2]|0;tc[c[(c[a>>2]|0)+28>>2]&127](a,b,d+g|0,(f&2|0)!=0?e:2);i=h;return}function AE(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0;j=i;if((b|0)!=(c[d+8>>2]|0)){g=c[b+12>>2]|0;zE(b+16|0,d,e,f);if((g|0)<=1){i=j;return}h=b+24|0;while(1){zE(h,d,e,f);if(a[d+54>>0]|0){g=12;break}h=h+8|0;if(h>>>0>=(b+(g<<3)+16|0)>>>0){g=12;break}}if((g|0)==12){i=j;return}}g=c[d+16>>2]|0;if(!g){c[d+16>>2]=e;c[d+24>>2]=f;c[d+36>>2]=1;i=j;return}if((g|0)!=(e|0)){c[d+36>>2]=(c[d+36>>2]|0)+1;c[d+24>>2]=2;a[d+54>>0]=1;i=j;return}if((c[d+24>>2]|0)!=2){i=j;return}c[d+24>>2]=f;i=j;return}function BE(d,e){d=d|0;e=e|0;var f=0,g=0,h=0,j=0;j=i;i=i+64|0;g=c[d>>2]|0;h=d+(c[g+-8>>2]|0)|0;g=c[g+-4>>2]|0;c[j>>2]=e;c[j+4>>2]=d;c[j+8>>2]=21016;d=j+12|0;f=d+40|0;do{c[d>>2]=0;d=d+4|0}while((d|0)<(f|0));b[j+52>>1]=0;a[j+54>>0]=0;if((g|0)==(e|0)){c[j+48>>2]=1;Xb[c[(c[g>>2]|0)+20>>2]&7](g,j,h,h,1,0);d=(c[j+24>>2]|0)==1?h:0;i=j;return d|0}Hb[c[(c[g>>2]|0)+24>>2]&31](g,j,h,1,0);d=c[j+36>>2]|0;if((d|0)==1){if((c[j+24>>2]|0)!=1?!(((c[j+40>>2]|0)==0?(c[j+28>>2]|0)==1:0)&(c[j+32>>2]|0)==1):0){d=0;i=j;return d|0}d=c[j+16>>2]|0;i=j;return d|0}else if(!d){d=((c[j+40>>2]|0)==1?(c[j+28>>2]|0)==1:0)&(c[j+32>>2]|0)==1?c[j+20>>2]|0:0;i=j;return d|0}else{d=0;i=j;return d|0}return 0}function CE(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0;g=i;a[b+53>>0]=1;if((c[b+4>>2]|0)!=(e|0)){i=g;return}a[b+52>>0]=1;e=c[b+16>>2]|0;if(!e){c[b+16>>2]=d;c[b+24>>2]=f;c[b+36>>2]=1;if(!((f|0)==1?(c[b+48>>2]|0)==1:0)){i=g;return}a[b+54>>0]=1;i=g;return}if((e|0)!=(d|0)){c[b+36>>2]=(c[b+36>>2]|0)+1;a[b+54>>0]=1;i=g;return}e=c[b+24>>2]|0;if((e|0)==2){c[b+24>>2]=f;e=f}if(!((e|0)==1?(c[b+48>>2]|0)==1:0)){i=g;return}a[b+54>>0]=1;i=g;return}function DE(b,d,e,f,g){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0,n=0,o=0;o=i;if((b|0)==(c[d+8>>2]|0)){if((c[d+4>>2]|0)!=(e|0)){i=o;return}if((c[d+28>>2]|0)==1){i=o;return}c[d+28>>2]=f;i=o;return}if((b|0)!=(c[d>>2]|0)){k=c[b+12>>2]|0;FE(b+16|0,d,e,f,g);if((k|0)<=1){i=o;return}h=c[b+8>>2]|0;if((h&2|0)==0?(c[d+36>>2]|0)!=1:0){if(!(h&1)){j=b+24|0;while(1){if(a[d+54>>0]|0){j=43;break}if((c[d+36>>2]|0)==1){j=43;break}FE(j,d,e,f,g);j=j+8|0;if(j>>>0>=(b+(k<<3)+16|0)>>>0){j=43;break}}if((j|0)==43){i=o;return}}j=b+24|0;while(1){if(a[d+54>>0]|0){j=43;break}if((c[d+36>>2]|0)==1?(c[d+24>>2]|0)==1:0){j=43;break}FE(j,d,e,f,g);j=j+8|0;if(j>>>0>=(b+(k<<3)+16|0)>>>0){j=43;break}}if((j|0)==43){i=o;return}}j=b+24|0;while(1){if(a[d+54>>0]|0){j=43;break}FE(j,d,e,f,g);j=j+8|0;if(j>>>0>=(b+(k<<3)+16|0)>>>0){j=43;break}}if((j|0)==43){i=o;return}}if((c[d+16>>2]|0)!=(e|0)?(c[d+20>>2]|0)!=(e|0):0){c[d+32>>2]=f;if((c[d+44>>2]|0)==4){i=o;return}k=c[b+12>>2]|0;a:do if((k|0)>0){j=0;h=0;l=b+16|0;b:do{a[d+52>>0]=0;a[d+53>>0]=0;EE(l,d,e,e,1,g);if(a[d+54>>0]|0)break;do if(a[d+53>>0]|0){if(!(a[d+52>>0]|0))if(!(c[b+8>>2]&1)){h=1;break b}else{h=1;break}if((c[d+24>>2]|0)==1){j=25;break a}if(!(c[b+8>>2]&2)){j=25;break a}else{j=1;h=1}}while(0);l=l+8|0}while(l>>>0<(b+(k<<3)+16|0)>>>0);if(j){n=h;j=24}else{m=h;j=21}}else{m=0;j=21}while(0);if((j|0)==21){c[d+20>>2]=e;c[d+40>>2]=(c[d+40>>2]|0)+1;if((c[d+36>>2]|0)==1?(c[d+24>>2]|0)==2:0){a[d+54>>0]=1;if(m)j=25;else j=26}else{n=m;j=24}}if((j|0)==24)if(n)j=25;else j=26;if((j|0)==25){c[d+44>>2]=3;i=o;return}else if((j|0)==26){c[d+44>>2]=4;i=o;return}}if((f|0)!=1){i=o;return}c[d+32>>2]=1;i=o;return}function EE(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0;k=i;h=c[a+4>>2]|0;if(!(h&1))j=h>>8;else j=c[(c[e>>2]|0)+(h>>8)>>2]|0;a=c[a>>2]|0;Xb[c[(c[a>>2]|0)+20>>2]&7](a,b,d,e+j|0,(h&2|0)!=0?f:2,g);i=k;return}function FE(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0;j=i;g=c[a+4>>2]|0;if(!(g&1))h=g>>8;else h=c[(c[d>>2]|0)+(g>>8)>>2]|0;a=c[a>>2]|0;Hb[c[(c[a>>2]|0)+24>>2]&31](a,b,d+h|0,(g&2|0)!=0?e:2,f);i=j;return}function GE(b,d,e,f,g){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0;j=i;if((b|0)==(c[d+8>>2]|0)){if((c[d+4>>2]|0)!=(e|0)){i=j;return}if((c[d+28>>2]|0)==1){i=j;return}c[d+28>>2]=f;i=j;return}if((b|0)!=(c[d>>2]|0)){b=c[b+8>>2]|0;Hb[c[(c[b>>2]|0)+24>>2]&31](b,d,e,f,g);i=j;return}if((c[d+16>>2]|0)!=(e|0)?(c[d+20>>2]|0)!=(e|0):0){c[d+32>>2]=f;if((c[d+44>>2]|0)==4){i=j;return}a[d+52>>0]=0;a[d+53>>0]=0;f=c[b+8>>2]|0;Xb[c[(c[f>>2]|0)+20>>2]&7](f,d,e,e,1,g);if(a[d+53>>0]|0){if(!(a[d+52>>0]|0)){f=1;h=13}}else{f=0;h=13}do if((h|0)==13){c[d+20>>2]=e;c[d+40>>2]=(c[d+40>>2]|0)+1;if((c[d+36>>2]|0)==1?(c[d+24>>2]|0)==2:0){a[d+54>>0]=1;if(f)break}else h=16;if((h|0)==16?f:0)break;c[d+44>>2]=4;i=j;return}while(0);c[d+44>>2]=3;i=j;return}if((f|0)!=1){i=j;return}c[d+32>>2]=1;i=j;return}function HE(b,d,e,f,g){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;g=i;if((c[d+8>>2]|0)==(b|0)){if((c[d+4>>2]|0)!=(e|0)){i=g;return}if((c[d+28>>2]|0)==1){i=g;return}c[d+28>>2]=f;i=g;return}if((c[d>>2]|0)!=(b|0)){i=g;return}if((c[d+16>>2]|0)!=(e|0)?(c[d+20>>2]|0)!=(e|0):0){c[d+32>>2]=f;c[d+20>>2]=e;c[d+40>>2]=(c[d+40>>2]|0)+1;if((c[d+36>>2]|0)==1?(c[d+24>>2]|0)==2:0)a[d+54>>0]=1;c[d+44>>2]=4;i=g;return}if((f|0)!=1){i=g;return}c[d+32>>2]=1;i=g;return}function IE(b,d,e,f,g,h){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0,n=0;n=i;if((b|0)==(c[d+8>>2]|0)){CE(d,e,f,g);i=n;return}j=a[d+52>>0]|0;k=a[d+53>>0]|0;l=c[b+12>>2]|0;a[d+52>>0]=0;a[d+53>>0]=0;EE(b+16|0,d,e,f,g,h);a:do if((l|0)>1){m=b+24|0;do{if(a[d+54>>0]|0)break a;if(!(a[d+52>>0]|0)){if((a[d+53>>0]|0)!=0?(c[b+8>>2]&1|0)==0:0)break a}else{if((c[d+24>>2]|0)==1)break a;if(!(c[b+8>>2]&2))break a}a[d+52>>0]=0;a[d+53>>0]=0;EE(m,d,e,f,g,h);m=m+8|0}while(m>>>0<(b+(l<<3)+16|0)>>>0)}while(0);a[d+52>>0]=j;a[d+53>>0]=k;i=n;return}function JE(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0;h=i;if((a|0)==(c[b+8>>2]|0)){CE(b,d,e,f);i=h;return}else{a=c[a+8>>2]|0;Xb[c[(c[a>>2]|0)+20>>2]&7](a,b,d,e,f,g);i=h;return}}function KE(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;g=i;if((c[b+8>>2]|0)!=(a|0)){i=g;return}CE(b,d,e,f);i=g;return}function LE(a,b,d){a=a|0;b=b|0;d=d|0;var e=0;e=i;i=i+16|0;c[e>>2]=c[d>>2];a=Wb[c[(c[a>>2]|0)+16>>2]&63](a,b,e)|0;if(!a){i=e;return a&1|0}c[d>>2]=c[e>>2];i=e;return a&1|0}function ME(a){a=a|0;var b=0;b=i;if(!a)a=0;else a=(BE(a,21184)|0)!=0;i=b;return a&1|0}function NE(){var a=0,b=0,d=0,e=0;e=i;i=i+16|0;if(qb(20632,3)|0)lE(20640,e);a=ob(c[5156]|0)|0;if(!a)lE(20608,e);d=c[a>>2]|0;if(!d)lE(20608,e);a=c[d+48>>2]|0;b=c[d+52>>2]|0;if(!((a&-256|0)==1126902528&(b|0)==1129074247)){c[e>>2]=20456;lE(20568,e)}if((a|0)==1126902529&(b|0)==1129074247)a=c[d+44>>2]|0;else a=d+80|0;c[e+12>>2]=a;b=c[d>>2]|0;a=c[b+4>>2]|0;if(wE(20944,b,e+12|0)|0){b=c[e+12>>2]|0;b=Nb[c[(c[b>>2]|0)+8>>2]&127](b)|0;c[e>>2]=20456;c[e+4>>2]=a;c[e+8>>2]=b;lE(20472,e)}else{c[e>>2]=20456;c[e+4>>2]=a;lE(20520,e)}}function OE(){var a=0;a=i;i=i+16|0;if(!(rb(20624,215)|0)){i=a;return}else lE(20696,a)}function PE(a){a=a|0;var b=0;b=i;i=i+16|0;RE(a);if(!(ub(c[5156]|0,0)|0)){i=b;return}else lE(20752,b)}function QE(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0;I=i;do if(a>>>0<245){if(a>>>0<11)n=16;else n=a+11&-8;a=n>>>3;h=c[5358]|0;if(h>>>a&3){b=c[21472+(((h>>>a&1^1)+a<<1)+2<<2)>>2]|0;d=c[b+8>>2]|0;do if((21472+((h>>>a&1^1)+a<<1<<2)|0)!=(d|0)){if(d>>>0<(c[5362]|0)>>>0)xb();if((c[d+12>>2]|0)==(b|0)){c[d+12>>2]=21472+((h>>>a&1^1)+a<<1<<2);c[21472+(((h>>>a&1^1)+a<<1)+2<<2)>>2]=d;break}else xb()}else c[5358]=h&~(1<<(h>>>a&1^1)+a);while(0);c[b+4>>2]=(h>>>a&1^1)+a<<3|3;c[b+((h>>>a&1^1)+a<<3|4)>>2]=c[b+((h>>>a&1^1)+a<<3|4)>>2]|1;x=b+8|0;i=I;return x|0}g=c[5360]|0;if(n>>>0>g>>>0){if(h>>>a){e=(h>>>a<<a&(2<<a|0-(2<<a))&0-(h>>>a<<a&(2<<a|0-(2<<a))))+-1|0;a=e>>>(e>>>12&16)>>>(e>>>(e>>>12&16)>>>5&8);f=a>>>(a>>>2&4)>>>(a>>>(a>>>2&4)>>>1&2);f=(e>>>(e>>>12&16)>>>5&8|e>>>12&16|a>>>2&4|a>>>(a>>>2&4)>>>1&2|f>>>1&1)+(f>>>(f>>>1&1))|0;a=c[21472+((f<<1)+2<<2)>>2]|0;e=c[a+8>>2]|0;do if((21472+(f<<1<<2)|0)!=(e|0)){if(e>>>0<(c[5362]|0)>>>0)xb();if((c[e+12>>2]|0)==(a|0)){c[e+12>>2]=21472+(f<<1<<2);c[21472+((f<<1)+2<<2)>>2]=e;k=c[5360]|0;break}else xb()}else{c[5358]=h&~(1<<f);k=g}while(0);g=(f<<3)-n|0;c[a+4>>2]=n|3;b=a+n|0;c[a+(n|4)>>2]=g|1;c[a+(f<<3)>>2]=g;if(k){e=c[5363]|0;f=k>>>3;d=c[5358]|0;if(d&1<<f){d=c[21472+((f<<1)+2<<2)>>2]|0;if(d>>>0<(c[5362]|0)>>>0)xb();else{j=21472+((f<<1)+2<<2)|0;l=d}}else{c[5358]=d|1<<f;j=21472+((f<<1)+2<<2)|0;l=21472+(f<<1<<2)|0}c[j>>2]=e;c[l+12>>2]=e;c[e+8>>2]=l;c[e+12>>2]=21472+(f<<1<<2)}c[5360]=g;c[5363]=b;x=a+8|0;i=I;return x|0}a=c[5359]|0;if(a){j=((a&0-a)+-1|0)>>>(((a&0-a)+-1|0)>>>12&16);k=j>>>(j>>>5&8)>>>(j>>>(j>>>5&8)>>>2&4);k=c[21736+((j>>>5&8|((a&0-a)+-1|0)>>>12&16|j>>>(j>>>5&8)>>>2&4|k>>>1&2|k>>>(k>>>1&2)>>>1&1)+(k>>>(k>>>1&2)>>>(k>>>(k>>>1&2)>>>1&1))<<2)>>2]|0;j=(c[k+4>>2]&-8)-n|0;f=k;while(1){d=c[f+16>>2]|0;if(!d){d=c[f+20>>2]|0;if(!d)break}f=(c[d+4>>2]&-8)-n|0;x=f>>>0<j>>>0;j=x?f:j;f=d;k=x?d:k}a=c[5362]|0;if(k>>>0<a>>>0)xb();h=k+n|0;if(k>>>0>=h>>>0)xb();b=c[k+24>>2]|0;f=c[k+12>>2]|0;do if((f|0)==(k|0)){e=k+20|0;f=c[e>>2]|0;if(!f){e=k+16|0;f=c[e>>2]|0;if(!f){m=0;break}}while(1){d=f+20|0;g=c[d>>2]|0;if(g){f=g;e=d;continue}d=f+16|0;g=c[d>>2]|0;if(!g)break;else{f=g;e=d}}if(e>>>0<a>>>0)xb();else{c[e>>2]=0;m=f;break}}else{e=c[k+8>>2]|0;if(e>>>0<a>>>0)xb();if((c[e+12>>2]|0)!=(k|0))xb();if((c[f+8>>2]|0)==(k|0)){c[e+12>>2]=f;c[f+8>>2]=e;m=f;break}else xb()}while(0);do if(b){e=c[k+28>>2]|0;if((k|0)==(c[21736+(e<<2)>>2]|0)){c[21736+(e<<2)>>2]=m;if(!m){c[5359]=c[5359]&~(1<<e);break}}else{if(b>>>0<(c[5362]|0)>>>0)xb();if((c[b+16>>2]|0)==(k|0))c[b+16>>2]=m;else c[b+20>>2]=m;if(!m)break}f=c[5362]|0;if(m>>>0<f>>>0)xb();c[m+24>>2]=b;e=c[k+16>>2]|0;do if(e)if(e>>>0<f>>>0)xb();else{c[m+16>>2]=e;c[e+24>>2]=m;break}while(0);d=c[k+20>>2]|0;if(d)if(d>>>0<(c[5362]|0)>>>0)xb();else{c[m+20>>2]=d;c[d+24>>2]=m;break}}while(0);if(j>>>0<16){x=j+n|0;c[k+4>>2]=x|3;x=k+(x+4)|0;c[x>>2]=c[x>>2]|1}else{c[k+4>>2]=n|3;c[k+(n|4)>>2]=j|1;c[k+(j+n)>>2]=j;e=c[5360]|0;if(e){b=c[5363]|0;d=c[5358]|0;if(d&1<<(e>>>3)){d=c[21472+((e>>>3<<1)+2<<2)>>2]|0;if(d>>>0<(c[5362]|0)>>>0)xb();else{q=21472+((e>>>3<<1)+2<<2)|0;p=d}}else{c[5358]=d|1<<(e>>>3);q=21472+((e>>>3<<1)+2<<2)|0;p=21472+(e>>>3<<1<<2)|0}c[q>>2]=b;c[p+12>>2]=b;c[b+8>>2]=p;c[b+12>>2]=21472+(e>>>3<<1<<2)}c[5360]=j;c[5363]=h}x=k+8|0;i=I;return x|0}}}else if(a>>>0<=4294967231){n=a+11&-8;j=c[5359]|0;if(j){if((a+11|0)>>>8)if(n>>>0>16777215)k=31;else{k=(a+11|0)>>>8<<((((a+11|0)>>>8)+1048320|0)>>>16&8);k=14-((k+520192|0)>>>16&4|(((a+11|0)>>>8)+1048320|0)>>>16&8|((k<<((k+520192|0)>>>16&4))+245760|0)>>>16&2)+(k<<((k+520192|0)>>>16&4)<<(((k<<((k+520192|0)>>>16&4))+245760|0)>>>16&2)>>>15)|0;k=n>>>(k+7|0)&1|k<<1}else k=0;f=c[21736+(k<<2)>>2]|0;a:do if(!f){e=0-n|0;a=0;g=0}else{if((k|0)==31)g=0;else g=25-(k>>>1)|0;e=0-n|0;a=0;h=n<<g;g=0;while(1){d=c[f+4>>2]&-8;if((d-n|0)>>>0<e>>>0)if((d|0)==(n|0)){e=d-n|0;a=f;g=f;break a}else{e=d-n|0;g=f}q=c[f+20>>2]|0;f=c[f+(h>>>31<<2)+16>>2]|0;a=(q|0)==0|(q|0)==(f|0)?a:q;if(!f)break;else h=h<<1}}while(0);if((a|0)==0&(g|0)==0){a=2<<k;if(!(j&(a|0-a)))break;p=(j&(a|0-a)&0-(j&(a|0-a)))+-1|0;q=p>>>(p>>>12&16)>>>(p>>>(p>>>12&16)>>>5&8);a=q>>>(q>>>2&4)>>>(q>>>(q>>>2&4)>>>1&2);a=c[21736+((p>>>(p>>>12&16)>>>5&8|p>>>12&16|q>>>2&4|q>>>(q>>>2&4)>>>1&2|a>>>1&1)+(a>>>(a>>>1&1))<<2)>>2]|0}if(!a){h=e;p=g}else while(1){q=(c[a+4>>2]&-8)-n|0;f=q>>>0<e>>>0;e=f?q:e;g=f?a:g;f=c[a+16>>2]|0;if(f){a=f;continue}a=c[a+20>>2]|0;if(!a){h=e;p=g;break}}if((p|0)!=0?h>>>0<((c[5360]|0)-n|0)>>>0:0){a=c[5362]|0;if(p>>>0<a>>>0)xb();m=p+n|0;if(p>>>0>=m>>>0)xb();b=c[p+24>>2]|0;f=c[p+12>>2]|0;do if((f|0)==(p|0)){g=p+20|0;f=c[g>>2]|0;if(!f){g=p+16|0;f=c[g>>2]|0;if(!f){r=0;break}}while(1){d=f+20|0;e=c[d>>2]|0;if(e){f=e;g=d;continue}d=f+16|0;e=c[d>>2]|0;if(!e)break;else{f=e;g=d}}if(g>>>0<a>>>0)xb();else{c[g>>2]=0;r=f;break}}else{e=c[p+8>>2]|0;if(e>>>0<a>>>0)xb();if((c[e+12>>2]|0)!=(p|0))xb();if((c[f+8>>2]|0)==(p|0)){c[e+12>>2]=f;c[f+8>>2]=e;r=f;break}else xb()}while(0);do if(b){f=c[p+28>>2]|0;if((p|0)==(c[21736+(f<<2)>>2]|0)){c[21736+(f<<2)>>2]=r;if(!r){c[5359]=c[5359]&~(1<<f);break}}else{if(b>>>0<(c[5362]|0)>>>0)xb();if((c[b+16>>2]|0)==(p|0))c[b+16>>2]=r;else c[b+20>>2]=r;if(!r)break}e=c[5362]|0;if(r>>>0<e>>>0)xb();c[r+24>>2]=b;f=c[p+16>>2]|0;do if(f)if(f>>>0<e>>>0)xb();else{c[r+16>>2]=f;c[f+24>>2]=r;break}while(0);e=c[p+20>>2]|0;if(e)if(e>>>0<(c[5362]|0)>>>0)xb();else{c[r+20>>2]=e;c[e+24>>2]=r;break}}while(0);b:do if(h>>>0>=16){c[p+4>>2]=n|3;c[p+(n|4)>>2]=h|1;c[p+(h+n)>>2]=h;f=h>>>3;if(h>>>0<256){d=c[5358]|0;do if(!(d&1<<f)){c[5358]=d|1<<f;s=21472+((f<<1)+2<<2)|0;t=21472+(f<<1<<2)|0}else{d=c[21472+((f<<1)+2<<2)>>2]|0;if(d>>>0>=(c[5362]|0)>>>0){s=21472+((f<<1)+2<<2)|0;t=d;break}xb()}while(0);c[s>>2]=m;c[t+12>>2]=m;c[p+(n+8)>>2]=t;c[p+(n+12)>>2]=21472+(f<<1<<2);break}d=h>>>8;if(d)if(h>>>0>16777215)b=31;else{b=d<<((d+1048320|0)>>>16&8)<<(((d<<((d+1048320|0)>>>16&8))+520192|0)>>>16&4);b=14-(((d<<((d+1048320|0)>>>16&8))+520192|0)>>>16&4|(d+1048320|0)>>>16&8|(b+245760|0)>>>16&2)+(b<<((b+245760|0)>>>16&2)>>>15)|0;b=h>>>(b+7|0)&1|b<<1}else b=0;f=21736+(b<<2)|0;c[p+(n+28)>>2]=b;c[p+(n+20)>>2]=0;c[p+(n+16)>>2]=0;e=c[5359]|0;d=1<<b;if(!(e&d)){c[5359]=e|d;c[f>>2]=m;c[p+(n+24)>>2]=f;c[p+(n+12)>>2]=m;c[p+(n+8)>>2]=m;break}e=c[f>>2]|0;if((b|0)==31)d=0;else d=25-(b>>>1)|0;c:do if((c[e+4>>2]&-8|0)!=(h|0)){b=h<<d;while(1){f=e+(b>>>31<<2)+16|0;d=c[f>>2]|0;if(!d)break;if((c[d+4>>2]&-8|0)==(h|0)){u=d;break c}else{b=b<<1;e=d}}if(f>>>0<(c[5362]|0)>>>0)xb();else{c[f>>2]=m;c[p+(n+24)>>2]=e;c[p+(n+12)>>2]=m;c[p+(n+8)>>2]=m;break b}}else u=e;while(0);b=u+8|0;d=c[b>>2]|0;x=c[5362]|0;if(u>>>0>=x>>>0&d>>>0>=x>>>0){c[d+12>>2]=m;c[b>>2]=m;c[p+(n+8)>>2]=d;c[p+(n+12)>>2]=u;c[p+(n+24)>>2]=0;break}else xb()}else{x=h+n|0;c[p+4>>2]=x|3;x=p+(x+4)|0;c[x>>2]=c[x>>2]|1}while(0);x=p+8|0;i=I;return x|0}}}else n=-1;while(0);a=c[5360]|0;if(a>>>0>=n>>>0){b=a-n|0;d=c[5363]|0;if(b>>>0>15){c[5363]=d+n;c[5360]=b;c[d+(n+4)>>2]=b|1;c[d+a>>2]=b;c[d+4>>2]=n|3}else{c[5360]=0;c[5363]=0;c[d+4>>2]=a|3;c[d+(a+4)>>2]=c[d+(a+4)>>2]|1}x=d+8|0;i=I;return x|0}a=c[5361]|0;if(a>>>0>n>>>0){w=a-n|0;c[5361]=w;x=c[5364]|0;c[5364]=x+n;c[x+(n+4)>>2]=w|1;c[x+4>>2]=n|3;x=x+8|0;i=I;return x|0}do if(!(c[5476]|0)){a=mb(30)|0;if(!(a+-1&a)){c[5478]=a;c[5477]=a;c[5479]=-1;c[5480]=-1;c[5481]=0;c[5469]=0;c[5476]=(Ab(0)|0)&-16^1431655768;break}else xb()}while(0);k=n+48|0;f=c[5478]|0;j=n+47|0;m=f+j&0-f;if(m>>>0<=n>>>0){x=0;i=I;return x|0}a=c[5468]|0;if((a|0)!=0?(u=c[5466]|0,(u+m|0)>>>0<=u>>>0|(u+m|0)>>>0>a>>>0):0){x=0;i=I;return x|0}d:do if(!(c[5469]&4)){g=c[5364]|0;e:do if(g){e=21880|0;while(1){a=c[e>>2]|0;if(a>>>0<=g>>>0?(o=e+4|0,(a+(c[o>>2]|0)|0)>>>0>g>>>0):0)break;a=c[e+8>>2]|0;if(!a){y=181;break e}else e=a}if(e){a=f+j-(c[5361]|0)&0-f;if(a>>>0<2147483647){g=fb(a|0)|0;if((g|0)==((c[e>>2]|0)+(c[o>>2]|0)|0))y=190;else y=191}else a=0}else y=181}else y=181;while(0);do if((y|0)==181){g=fb(0)|0;if((g|0)!=(-1|0)){a=c[5477]|0;if(!(a+-1&g))a=m;else a=m-g+(a+-1+g&0-a)|0;f=c[5466]|0;e=f+a|0;if(a>>>0>n>>>0&a>>>0<2147483647){u=c[5468]|0;if((u|0)!=0?e>>>0<=f>>>0|e>>>0>u>>>0:0){a=0;break}f=fb(a|0)|0;if((f|0)==(g|0))y=190;else{g=f;y=191}}else a=0}else a=0}while(0);f:do if((y|0)==190){if((g|0)!=(-1|0)){u=g;r=a;y=201;break d}}else if((y|0)==191){f=0-a|0;do if((g|0)!=(-1|0)&a>>>0<2147483647&k>>>0>a>>>0?(b=c[5478]|0,b=j-a+b&0-b,b>>>0<2147483647):0)if((fb(b|0)|0)==(-1|0)){fb(f|0)|0;a=0;break f}else{a=b+a|0;break}while(0);if((g|0)==(-1|0))a=0;else{u=g;r=a;y=201;break d}}while(0);c[5469]=c[5469]|4;y=198}else{a=0;y=198}while(0);if((((y|0)==198?m>>>0<2147483647:0)?(v=fb(m|0)|0,w=fb(0)|0,(v|0)!=(-1|0)&(w|0)!=(-1|0)&v>>>0<w>>>0):0)?(x=(w-v|0)>>>0>(n+40|0)>>>0,x):0){u=v;r=x?w-v|0:a;y=201}if((y|0)==201){g=(c[5466]|0)+r|0;c[5466]=g;if(g>>>0>(c[5467]|0)>>>0)c[5467]=g;h=c[5364]|0;g:do if(h){d=21880|0;while(1){a=c[d>>2]|0;e=d+4|0;g=c[e>>2]|0;if((u|0)==(a+g|0)){y=213;break}f=c[d+8>>2]|0;if(!f)break;else d=f}if(((y|0)==213?(c[d+12>>2]&8|0)==0:0)?h>>>0>=a>>>0&h>>>0<u>>>0:0){c[e>>2]=g+r;d=(c[5361]|0)+r|0;if(!(h+8&7))b=0;else b=0-(h+8)&7;x=d-b|0;c[5364]=h+b;c[5361]=x;c[h+(b+4)>>2]=x|1;c[h+(d+4)>>2]=40;c[5365]=c[5480];break}g=c[5362]|0;if(u>>>0<g>>>0){c[5362]=u;g=u}f=u+r|0;e=21880|0;while(1){if((c[e>>2]|0)==(f|0)){y=223;break}a=c[e+8>>2]|0;if(!a)break;else e=a}if((y|0)==223?(c[e+12>>2]&8|0)==0:0){c[e>>2]=u;f=e+4|0;c[f>>2]=(c[f>>2]|0)+r;f=u+8|0;if(!(f&7))q=0;else q=0-f&7;f=u+(r+8)|0;if(!(f&7))l=0;else l=0-f&7;f=u+(l+r)|0;p=q+n|0;o=u+p|0;m=f-(u+q)-n|0;c[u+(q+4)>>2]=n|3;h:do if((f|0)!=(h|0)){if((f|0)==(c[5363]|0)){x=(c[5360]|0)+m|0;c[5360]=x;c[5363]=o;c[u+(p+4)>>2]=x|1;c[u+(x+p)>>2]=x;break}k=r+4|0;j=c[u+(k+l)>>2]|0;if((j&3|0)==1){i:do if(j>>>0>=256){h=c[u+((l|24)+r)>>2]|0;a=c[u+(r+12+l)>>2]|0;do if((a|0)==(f|0)){e=l|16;d=u+(k+e)|0;a=c[d>>2]|0;if(!a){e=u+(e+r)|0;a=c[e>>2]|0;if(!a){E=0;break}}else e=d;while(1){b=a+20|0;d=c[b>>2]|0;if(d){a=d;e=b;continue}b=a+16|0;d=c[b>>2]|0;if(!d)break;else{a=d;e=b}}if(e>>>0<g>>>0)xb();else{c[e>>2]=0;E=a;break}}else{e=c[u+((l|8)+r)>>2]|0;if(e>>>0<g>>>0)xb();if((c[e+12>>2]|0)!=(f|0))xb();if((c[a+8>>2]|0)==(f|0)){c[e+12>>2]=a;c[a+8>>2]=e;E=a;break}else xb()}while(0);if(!h)break;a=c[u+(r+28+l)>>2]|0;do if((f|0)!=(c[21736+(a<<2)>>2]|0)){if(h>>>0<(c[5362]|0)>>>0)xb();if((c[h+16>>2]|0)==(f|0))c[h+16>>2]=E;else c[h+20>>2]=E;if(!E)break i}else{c[21736+(a<<2)>>2]=E;if(E)break;c[5359]=c[5359]&~(1<<a);break i}while(0);f=c[5362]|0;if(E>>>0<f>>>0)xb();c[E+24>>2]=h;g=l|16;a=c[u+(g+r)>>2]|0;do if(a)if(a>>>0<f>>>0)xb();else{c[E+16>>2]=a;c[a+24>>2]=E;break}while(0);g=c[u+(k+g)>>2]|0;if(!g)break;if(g>>>0<(c[5362]|0)>>>0)xb();else{c[E+20>>2]=g;c[g+24>>2]=E;break}}else{a=c[u+((l|8)+r)>>2]|0;e=c[u+(r+12+l)>>2]|0;do if((a|0)!=(21472+(j>>>3<<1<<2)|0)){if(a>>>0<g>>>0)xb();if((c[a+12>>2]|0)==(f|0))break;xb()}while(0);if((e|0)==(a|0)){c[5358]=c[5358]&~(1<<(j>>>3));break}do if((e|0)==(21472+(j>>>3<<1<<2)|0))C=e+8|0;else{if(e>>>0<g>>>0)xb();if((c[e+8>>2]|0)==(f|0)){C=e+8|0;break}xb()}while(0);c[a+12>>2]=e;c[C>>2]=a}while(0);f=u+((j&-8|l)+r)|0;a=(j&-8)+m|0}else a=m;f=f+4|0;c[f>>2]=c[f>>2]&-2;c[u+(p+4)>>2]=a|1;c[u+(a+p)>>2]=a;f=a>>>3;if(a>>>0<256){d=c[5358]|0;do if(!(d&1<<f)){c[5358]=d|1<<f;F=21472+((f<<1)+2<<2)|0;G=21472+(f<<1<<2)|0}else{d=c[21472+((f<<1)+2<<2)>>2]|0;if(d>>>0>=(c[5362]|0)>>>0){F=21472+((f<<1)+2<<2)|0;G=d;break}xb()}while(0);c[F>>2]=o;c[G+12>>2]=o;c[u+(p+8)>>2]=G;c[u+(p+12)>>2]=21472+(f<<1<<2);break}d=a>>>8;do if(!d)b=0;else{if(a>>>0>16777215){b=31;break}b=d<<((d+1048320|0)>>>16&8)<<(((d<<((d+1048320|0)>>>16&8))+520192|0)>>>16&4);b=14-(((d<<((d+1048320|0)>>>16&8))+520192|0)>>>16&4|(d+1048320|0)>>>16&8|(b+245760|0)>>>16&2)+(b<<((b+245760|0)>>>16&2)>>>15)|0;b=a>>>(b+7|0)&1|b<<1}while(0);e=21736+(b<<2)|0;c[u+(p+28)>>2]=b;c[u+(p+20)>>2]=0;c[u+(p+16)>>2]=0;f=c[5359]|0;d=1<<b;if(!(f&d)){c[5359]=f|d;c[e>>2]=o;c[u+(p+24)>>2]=e;c[u+(p+12)>>2]=o;c[u+(p+8)>>2]=o;break}f=c[e>>2]|0;if((b|0)==31)e=0;else e=25-(b>>>1)|0;j:do if((c[f+4>>2]&-8|0)!=(a|0)){b=a<<e;while(1){d=f+(b>>>31<<2)+16|0;e=c[d>>2]|0;if(!e)break;if((c[e+4>>2]&-8|0)==(a|0)){H=e;break j}else{b=b<<1;f=e}}if(d>>>0<(c[5362]|0)>>>0)xb();else{c[d>>2]=o;c[u+(p+24)>>2]=f;c[u+(p+12)>>2]=o;c[u+(p+8)>>2]=o;break h}}else H=f;while(0);b=H+8|0;d=c[b>>2]|0;x=c[5362]|0;if(H>>>0>=x>>>0&d>>>0>=x>>>0){c[d+12>>2]=o;c[b>>2]=o;c[u+(p+8)>>2]=d;c[u+(p+12)>>2]=H;c[u+(p+24)>>2]=0;break}else xb()}else{x=(c[5361]|0)+m|0;c[5361]=x;c[5364]=o;c[u+(p+4)>>2]=x|1}while(0);x=u+(q|8)|0;i=I;return x|0}f=21880|0;while(1){g=c[f>>2]|0;if(g>>>0<=h>>>0?(z=c[f+4>>2]|0,(g+z|0)>>>0>h>>>0):0)break;f=c[f+8>>2]|0}if(!(g+(z+-39)&7))f=0;else f=0-(g+(z+-39))&7;a=g+(z+-47+f)|0;a=a>>>0<(h+16|0)>>>0?h:a;f=u+8|0;if(!(f&7))f=0;else f=0-f&7;x=r+-40-f|0;c[5364]=u+f;c[5361]=x;c[u+(f+4)>>2]=x|1;c[u+(r+-36)>>2]=40;c[5365]=c[5480];c[a+4>>2]=27;c[a+8>>2]=c[5470];c[a+12>>2]=c[5471];c[a+16>>2]=c[5472];c[a+20>>2]=c[5473];c[5470]=u;c[5471]=r;c[5473]=0;c[5472]=a+8;c[a+28>>2]=7;if((a+32|0)>>>0<(g+z|0)>>>0){f=a+28|0;do{x=f;f=f+4|0;c[f>>2]=7}while((x+8|0)>>>0<(g+z|0)>>>0)}if((a|0)!=(h|0)){c[h+(a-h+4)>>2]=c[h+(a-h+4)>>2]&-2;c[h+4>>2]=a-h|1;c[h+(a-h)>>2]=a-h;if((a-h|0)>>>0<256){d=c[5358]|0;do if(!(d&1<<((a-h|0)>>>3))){c[5358]=d|1<<((a-h|0)>>>3);A=21472+(((a-h|0)>>>3<<1)+2<<2)|0;B=21472+((a-h|0)>>>3<<1<<2)|0}else{d=c[21472+(((a-h|0)>>>3<<1)+2<<2)>>2]|0;if(d>>>0>=(c[5362]|0)>>>0){A=21472+(((a-h|0)>>>3<<1)+2<<2)|0;B=d;break}xb()}while(0);c[A>>2]=h;c[B+12>>2]=h;c[h+8>>2]=B;c[h+12>>2]=21472+((a-h|0)>>>3<<1<<2);break}if((a-h|0)>>>8)if((a-h|0)>>>0>16777215)f=31;else{f=(a-h|0)>>>8<<((((a-h|0)>>>8)+1048320|0)>>>16&8);f=14-((f+520192|0)>>>16&4|(((a-h|0)>>>8)+1048320|0)>>>16&8|((f<<((f+520192|0)>>>16&4))+245760|0)>>>16&2)+(f<<((f+520192|0)>>>16&4)<<(((f<<((f+520192|0)>>>16&4))+245760|0)>>>16&2)>>>15)|0;f=(a-h|0)>>>(f+7|0)&1|f<<1}else f=0;e=21736+(f<<2)|0;c[h+28>>2]=f;c[h+20>>2]=0;c[h+16>>2]=0;d=c[5359]|0;b=1<<f;if(!(d&b)){c[5359]=d|b;c[e>>2]=h;c[h+24>>2]=e;c[h+12>>2]=h;c[h+8>>2]=h;break}b=c[e>>2]|0;if((f|0)==31)d=0;else d=25-(f>>>1)|0;k:do if((c[b+4>>2]&-8|0)!=(a-h|0)){f=a-h<<d;while(1){e=b+(f>>>31<<2)+16|0;d=c[e>>2]|0;if(!d)break;if((c[d+4>>2]&-8|0)==(a-h|0)){D=d;break k}else{f=f<<1;b=d}}if(e>>>0<(c[5362]|0)>>>0)xb();else{c[e>>2]=h;c[h+24>>2]=b;c[h+12>>2]=h;c[h+8>>2]=h;break g}}else D=b;while(0);b=D+8|0;d=c[b>>2]|0;x=c[5362]|0;if(D>>>0>=x>>>0&d>>>0>=x>>>0){c[d+12>>2]=h;c[b>>2]=h;c[h+8>>2]=d;c[h+12>>2]=D;c[h+24>>2]=0;break}else xb()}}else{x=c[5362]|0;if((x|0)==0|u>>>0<x>>>0)c[5362]=u;c[5470]=u;c[5471]=r;c[5473]=0;c[5367]=c[5476];c[5366]=-1;d=0;do{x=d<<1;c[21472+(x+3<<2)>>2]=21472+(x<<2);c[21472+(x+2<<2)>>2]=21472+(x<<2);d=d+1|0}while((d|0)!=32);b=u+8|0;if(!(b&7))d=0;else d=0-b&7;x=r+-40-d|0;c[5364]=u+d;c[5361]=x;c[u+(d+4)>>2]=x|1;c[u+(r+-36)>>2]=40;c[5365]=c[5480]}while(0);b=c[5361]|0;if(b>>>0>n>>>0){w=b-n|0;c[5361]=w;x=c[5364]|0;c[5364]=x+n;c[x+(n+4)>>2]=w|1;c[x+4>>2]=n|3;x=x+8|0;i=I;return x|0}}c[(tb()|0)>>2]=12;x=0;i=I;return x|0}function RE(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0;w=i;if(!a){i=w;return}j=c[5362]|0;if((a+-8|0)>>>0<j>>>0)xb();q=c[a+-4>>2]|0;if((q&3|0)==1)xb();p=a+((q&-8)+-8)|0;do if(!(q&1)){l=c[a+-8>>2]|0;if(!(q&3)){i=w;return}m=a+(-8-l)|0;n=l+(q&-8)|0;if(m>>>0<j>>>0)xb();if((m|0)==(c[5363]|0)){f=c[a+((q&-8)+-4)>>2]|0;if((f&3|0)!=3){u=m;g=n;break}c[5360]=n;c[a+((q&-8)+-4)>>2]=f&-2;c[a+(-8-l+4)>>2]=n|1;c[p>>2]=n;i=w;return}if(l>>>0<256){f=c[a+(-8-l+8)>>2]|0;e=c[a+(-8-l+12)>>2]|0;if((f|0)!=(21472+(l>>>3<<1<<2)|0)){if(f>>>0<j>>>0)xb();if((c[f+12>>2]|0)!=(m|0))xb()}if((e|0)==(f|0)){c[5358]=c[5358]&~(1<<(l>>>3));u=m;g=n;break}if((e|0)!=(21472+(l>>>3<<1<<2)|0)){if(e>>>0<j>>>0)xb();if((c[e+8>>2]|0)!=(m|0))xb();else d=e+8|0}else d=e+8|0;c[f+12>>2]=e;c[d>>2]=f;u=m;g=n;break}b=c[a+(-8-l+24)>>2]|0;f=c[a+(-8-l+12)>>2]|0;do if((f|0)==(m|0)){f=c[a+(-8-l+20)>>2]|0;if(!f){f=c[a+(-8-l+16)>>2]|0;if(!f){k=0;break}else h=a+(-8-l+16)|0}else h=a+(-8-l+20)|0;while(1){d=f+20|0;e=c[d>>2]|0;if(e){f=e;h=d;continue}d=f+16|0;e=c[d>>2]|0;if(!e)break;else{f=e;h=d}}if(h>>>0<j>>>0)xb();else{c[h>>2]=0;k=f;break}}else{e=c[a+(-8-l+8)>>2]|0;if(e>>>0<j>>>0)xb();if((c[e+12>>2]|0)!=(m|0))xb();if((c[f+8>>2]|0)==(m|0)){c[e+12>>2]=f;c[f+8>>2]=e;k=f;break}else xb()}while(0);if(b){f=c[a+(-8-l+28)>>2]|0;if((m|0)==(c[21736+(f<<2)>>2]|0)){c[21736+(f<<2)>>2]=k;if(!k){c[5359]=c[5359]&~(1<<f);u=m;g=n;break}}else{if(b>>>0<(c[5362]|0)>>>0)xb();if((c[b+16>>2]|0)==(m|0))c[b+16>>2]=k;else c[b+20>>2]=k;if(!k){u=m;g=n;break}}e=c[5362]|0;if(k>>>0<e>>>0)xb();c[k+24>>2]=b;f=c[a+(-8-l+16)>>2]|0;do if(f)if(f>>>0<e>>>0)xb();else{c[k+16>>2]=f;c[f+24>>2]=k;break}while(0);f=c[a+(-8-l+20)>>2]|0;if(f)if(f>>>0<(c[5362]|0)>>>0)xb();else{c[k+20>>2]=f;c[f+24>>2]=k;u=m;g=n;break}else{u=m;g=n}}else{u=m;g=n}}else{u=a+-8|0;g=q&-8}while(0);if(u>>>0>=p>>>0)xb();d=c[a+((q&-8)+-4)>>2]|0;if(!(d&1))xb();if(!(d&2)){if((p|0)==(c[5364]|0)){m=(c[5361]|0)+g|0;c[5361]=m;c[5364]=u;c[u+4>>2]=m|1;if((u|0)!=(c[5363]|0)){i=w;return}c[5363]=0;c[5360]=0;i=w;return}if((p|0)==(c[5363]|0)){m=(c[5360]|0)+g|0;c[5360]=m;c[5363]=u;c[u+4>>2]=m|1;c[u+m>>2]=m;i=w;return}g=(d&-8)+g|0;do if(d>>>0>=256){h=c[a+((q&-8)+16)>>2]|0;f=c[a+(q&-8|4)>>2]|0;do if((f|0)==(p|0)){f=c[a+((q&-8)+12)>>2]|0;if(!f){f=c[a+((q&-8)+8)>>2]|0;if(!f){r=0;break}else b=a+((q&-8)+8)|0}else b=a+((q&-8)+12)|0;while(1){d=f+20|0;e=c[d>>2]|0;if(e){f=e;b=d;continue}d=f+16|0;e=c[d>>2]|0;if(!e)break;else{f=e;b=d}}if(b>>>0<(c[5362]|0)>>>0)xb();else{c[b>>2]=0;r=f;break}}else{e=c[a+(q&-8)>>2]|0;if(e>>>0<(c[5362]|0)>>>0)xb();if((c[e+12>>2]|0)!=(p|0))xb();if((c[f+8>>2]|0)==(p|0)){c[e+12>>2]=f;c[f+8>>2]=e;r=f;break}else xb()}while(0);if(h){f=c[a+((q&-8)+20)>>2]|0;if((p|0)==(c[21736+(f<<2)>>2]|0)){c[21736+(f<<2)>>2]=r;if(!r){c[5359]=c[5359]&~(1<<f);break}}else{if(h>>>0<(c[5362]|0)>>>0)xb();if((c[h+16>>2]|0)==(p|0))c[h+16>>2]=r;else c[h+20>>2]=r;if(!r)break}e=c[5362]|0;if(r>>>0<e>>>0)xb();c[r+24>>2]=h;f=c[a+((q&-8)+8)>>2]|0;do if(f)if(f>>>0<e>>>0)xb();else{c[r+16>>2]=f;c[f+24>>2]=r;break}while(0);d=c[a+((q&-8)+12)>>2]|0;if(d)if(d>>>0<(c[5362]|0)>>>0)xb();else{c[r+20>>2]=d;c[d+24>>2]=r;break}}}else{e=c[a+(q&-8)>>2]|0;f=c[a+(q&-8|4)>>2]|0;if((e|0)!=(21472+(d>>>3<<1<<2)|0)){if(e>>>0<(c[5362]|0)>>>0)xb();if((c[e+12>>2]|0)!=(p|0))xb()}if((f|0)==(e|0)){c[5358]=c[5358]&~(1<<(d>>>3));break}if((f|0)!=(21472+(d>>>3<<1<<2)|0)){if(f>>>0<(c[5362]|0)>>>0)xb();if((c[f+8>>2]|0)!=(p|0))xb();else o=f+8|0}else o=f+8|0;c[e+12>>2]=f;c[o>>2]=e}while(0);c[u+4>>2]=g|1;c[u+g>>2]=g;if((u|0)==(c[5363]|0)){c[5360]=g;i=w;return}}else{c[a+((q&-8)+-4)>>2]=d&-2;c[u+4>>2]=g|1;c[u+g>>2]=g}f=g>>>3;if(g>>>0<256){d=c[5358]|0;if(d&1<<f){d=c[21472+((f<<1)+2<<2)>>2]|0;if(d>>>0<(c[5362]|0)>>>0)xb();else{s=21472+((f<<1)+2<<2)|0;t=d}}else{c[5358]=d|1<<f;s=21472+((f<<1)+2<<2)|0;t=21472+(f<<1<<2)|0}c[s>>2]=u;c[t+12>>2]=u;c[u+8>>2]=t;c[u+12>>2]=21472+(f<<1<<2);i=w;return}d=g>>>8;if(d)if(g>>>0>16777215)f=31;else{f=d<<((d+1048320|0)>>>16&8)<<(((d<<((d+1048320|0)>>>16&8))+520192|0)>>>16&4);f=14-(((d<<((d+1048320|0)>>>16&8))+520192|0)>>>16&4|(d+1048320|0)>>>16&8|(f+245760|0)>>>16&2)+(f<<((f+245760|0)>>>16&2)>>>15)|0;f=g>>>(f+7|0)&1|f<<1}else f=0;b=21736+(f<<2)|0;c[u+28>>2]=f;c[u+20>>2]=0;c[u+16>>2]=0;d=c[5359]|0;e=1<<f;a:do if(d&e){b=c[b>>2]|0;if((f|0)==31)d=0;else d=25-(f>>>1)|0;b:do if((c[b+4>>2]&-8|0)!=(g|0)){f=g<<d;while(1){e=b+(f>>>31<<2)+16|0;d=c[e>>2]|0;if(!d)break;if((c[d+4>>2]&-8|0)==(g|0)){v=d;break b}else{f=f<<1;b=d}}if(e>>>0<(c[5362]|0)>>>0)xb();else{c[e>>2]=u;c[u+24>>2]=b;c[u+12>>2]=u;c[u+8>>2]=u;break a}}else v=b;while(0);d=v+8|0;b=c[d>>2]|0;m=c[5362]|0;if(v>>>0>=m>>>0&b>>>0>=m>>>0){c[b+12>>2]=u;c[d>>2]=u;c[u+8>>2]=b;c[u+12>>2]=v;c[u+24>>2]=0;break}else xb()}else{c[5359]=d|e;c[b>>2]=u;c[u+24>>2]=b;c[u+12>>2]=u;c[u+8>>2]=u}while(0);m=(c[5366]|0)+-1|0;c[5366]=m;if(!m)b=21888|0;else{i=w;return}while(1){b=c[b>>2]|0;if(!b)break;else b=b+8|0}c[5366]=-1;i=w;return}function SE(a,b){a=+a;b=+b;var d=0,e=0,f=0,h=0,j=0,l=0,m=0,n=0;n=i;m=(g[k>>2]=a,c[k>>2]|0);j=(g[k>>2]=b,c[k>>2]|0);if((j<<1|0)!=0?!((j&2147483647)>>>0>2139095040|(m>>>23&255|0)==255):0){if(m<<1>>>0<=j<<1>>>0){if((m<<1|0)!=(j<<1|0)){b=a;i=n;return +b}b=a*0.0;i=n;return +b}if(!(m>>>23&255)){if((m<<9|0)>-1){e=0;d=m<<9;do{e=e+-1|0;d=d<<1}while((d|0)>-1)}else e=0;d=e;f=m<<1-e}else{d=m>>>23&255;f=m&8388607|8388608}if(!(j>>>23&255)){if((j<<9|0)>-1){e=0;h=j<<9;do{e=e+-1|0;h=h<<1}while((h|0)>-1)}else e=0;l=e;j=j<<1-e}else{l=j>>>23&255;j=j&8388607|8388608}e=f-j|0;a:do if((d|0)>(l|0)){h=(e|0)>-1;while(1){if(h){if((f|0)==(j|0))break}else e=f;f=e<<1;d=d+-1|0;e=f-j|0;if((d|0)>(l|0))h=(e|0)>-1;else{h=(e|0)>-1;break a}}b=a*0.0;i=n;return +b}else h=(e|0)>-1;while(0);if(h){if((f|0)==(j|0)){b=a*0.0;i=n;return +b}}else e=f;if(e>>>0<8388608)do{e=e<<1;d=d+-1|0}while(e>>>0<8388608);if((d|0)>0)d=e+-8388608|d<<23;else d=e>>>(1-d|0);b=(c[k>>2]=d|m&-2147483648,+g[k>>2]);i=n;return +b}b=a*b/(a*b);i=n;return +b}function TE(){}function UE(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;b=b-d-(c>>>0>a>>>0|0)>>>0;return (D=b,a-c>>>0|0)|0}function VE(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0;f=b+e|0;if((e|0)>=20){d=d&255;g=b&3;h=d|d<<8|d<<16|d<<24;if(g){g=b+4-g|0;while((b|0)<(g|0)){a[b>>0]=d;b=b+1|0}}while((b|0)<(f&~3|0)){c[b>>2]=h;b=b+4|0}}while((b|0)<(f|0)){a[b>>0]=d;b=b+1|0}return b-e|0}function WE(b){b=b|0;var c=0;c=b;while(a[c>>0]|0)c=c+1|0;return c-b|0}function XE(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;return (D=b+d+(a+c>>>0>>>0<a>>>0|0)>>>0,a+c>>>0|0)|0}function YE(b,d,e){b=b|0;d=d|0;e=e|0;var f=0;if((e|0)>=4096)return pb(b|0,d|0,e|0)|0;f=b|0;if((b&3)==(d&3)){while(b&3){if(!e)return f|0;a[b>>0]=a[d>>0]|0;b=b+1|0;d=d+1|0;e=e-1|0}while((e|0)>=4){c[b>>2]=c[d>>2];b=b+4|0;d=d+4|0;e=e-4|0}}while((e|0)>0){a[b>>0]=a[d>>0]|0;b=b+1|0;d=d+1|0;e=e-1|0}return f|0}function ZE(b,c,d){b=b|0;c=c|0;d=d|0;var e=0;if((c|0)<(b|0)&(b|0)<(c+d|0)){e=b;c=c+d|0;b=b+d|0;while((d|0)>0){b=b-1|0;c=c-1|0;d=d-1|0;a[b>>0]=a[c>>0]|0}b=e}else YE(b,c,d)|0;return b|0}function _E(a){a=a|0;return (a&255)<<24|(a>>8&255)<<16|(a>>16&255)<<8|a>>>24|0}function $E(a,b,c){a=a|0;b=b|0;c=c|0;if((c|0)<32){D=b<<c|(a&(1<<c)-1<<32-c)>>>32-c;return a<<c}D=a<<c-32;return 0}function aF(a,b,c){a=a|0;b=b|0;c=c|0;if((c|0)<32){D=b>>>c;return a>>>c|(b&(1<<c)-1)<<32-c}D=0;return b>>>c-32|0}function bF(a,b,c){a=a|0;b=b|0;c=c|0;if((c|0)<32){D=b>>c;return a>>>c|(b&(1<<c)-1)<<32-c}D=(b|0)<0?-1:0;return b>>c-32|0}function cF(b){b=b|0;var c=0;c=a[m+(b&255)>>0]|0;if((c|0)<8)return c|0;c=a[m+(b>>8&255)>>0]|0;if((c|0)<8)return c+8|0;c=a[m+(b>>16&255)>>0]|0;if((c|0)<8)return c+16|0;return (a[m+(b>>>24)>>0]|0)+24|0}function dF(a,b){a=a|0;b=b|0;var c=0,d=0,e=0;c=$(b&65535,a&65535)|0;e=(c>>>16)+($(b&65535,a>>>16)|0)|0;d=$(b>>>16,a&65535)|0;return (D=(e>>>16)+($(b>>>16,a>>>16)|0)+(((e&65535)+d|0)>>>16)|0,e+d<<16|c&65535|0)|0}function eF(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0,g=0,h=0;g=b>>31|((b|0)<0?-1:0)<<1;e=((b|0)<0?-1:0)>>31|((b|0)<0?-1:0)<<1;h=d>>31|((d|0)<0?-1:0)<<1;f=((d|0)<0?-1:0)>>31|((d|0)<0?-1:0)<<1;b=UE(g^a,e^b,g,e)|0;a=D;a=UE((jF(b,a,UE(h^c,f^d,h,f)|0,D,0)|0)^(h^g),D^(f^e),h^g,f^e)|0;return a|0}function fF(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0;f=i;i=i+8|0;h=b>>31|((b|0)<0?-1:0)<<1;g=((b|0)<0?-1:0)>>31|((b|0)<0?-1:0)<<1;k=e>>31|((e|0)<0?-1:0)<<1;j=((e|0)<0?-1:0)>>31|((e|0)<0?-1:0)<<1;b=UE(h^a,g^b,h,g)|0;a=D;jF(b,a,UE(k^d,j^e,k,j)|0,D,f|0)|0;a=UE(c[f>>2]^h,c[f+4>>2]^g,h,g)|0;b=D;i=f;return (D=b,a)|0}function gF(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0;e=dF(a,c)|0;f=D;return (D=($(b,c)|0)+($(d,a)|0)+f|f&0,e|0|0)|0}function hF(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;a=jF(a,b,c,d,0)|0;return a|0}function iF(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0;f=i;i=i+8|0;jF(a,b,d,e,f|0)|0;i=f;return (D=c[f+4>>2]|0,c[f>>2]|0)|0}function jF(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;if(!b)if(!e){if(f){c[f>>2]=(a>>>0)%(d>>>0);c[f+4>>2]=0}m=0;d=(a>>>0)/(d>>>0)>>>0;return (D=m,d)|0}else{if(!f){m=0;d=0;return (D=m,d)|0}c[f>>2]=a|0;c[f+4>>2]=b&0;m=0;d=0;return (D=m,d)|0}do if(d){if(e){h=(ba(e|0)|0)-(ba(b|0)|0)|0;if(h>>>0<=31){j=h+1|0;i=a>>>((h+1|0)>>>0)&h-31>>31|b<<31-h;m=b>>>((h+1|0)>>>0)&h-31>>31;g=0;h=a<<31-h;break}if(!f){m=0;d=0;return (D=m,d)|0}c[f>>2]=a|0;c[f+4>>2]=b|b&0;m=0;d=0;return (D=m,d)|0}if(d-1&d){h=(ba(d|0)|0)+33-(ba(b|0)|0)|0;j=h;i=32-h-1>>31&b>>>((h-32|0)>>>0)|(b<<32-h|a>>>(h>>>0))&h-32>>31;m=h-32>>31&b>>>(h>>>0);g=a<<64-h&32-h>>31;h=(b<<64-h|a>>>((h-32|0)>>>0))&32-h>>31|a<<32-h&h-33>>31;break}if(f){c[f>>2]=d-1&a;c[f+4>>2]=0}if((d|0)==1){m=b|b&0;d=a|0|0;return (D=m,d)|0}else{d=cF(d|0)|0;m=b>>>(d>>>0)|0;d=b<<32-d|a>>>(d>>>0)|0;return (D=m,d)|0}}else{if(!e){if(f){c[f>>2]=(b>>>0)%(d>>>0);c[f+4>>2]=0}m=0;d=(b>>>0)/(d>>>0)>>>0;return (D=m,d)|0}if(!a){if(f){c[f>>2]=0;c[f+4>>2]=(b>>>0)%(e>>>0)}m=0;d=(b>>>0)/(e>>>0)>>>0;return (D=m,d)|0}if(!(e-1&e)){if(f){c[f>>2]=a|0;c[f+4>>2]=e-1&b|b&0}m=0;d=b>>>((cF(e|0)|0)>>>0);return (D=m,d)|0}h=(ba(e|0)|0)-(ba(b|0)|0)|0;if(h>>>0<=30){j=h+1|0;i=b<<31-h|a>>>((h+1|0)>>>0);m=b>>>((h+1|0)>>>0);g=0;h=a<<31-h;break}if(!f){m=0;d=0;return (D=m,d)|0}c[f>>2]=a|0;c[f+4>>2]=b|b&0;m=0;d=0;return (D=m,d)|0}while(0);if(!j){j=h;b=m;h=0;a=0}else{k=XE(d|0|0,e|e&0,-1,-1)|0;l=D;b=m;a=0;do{p=h;h=g>>>31|h<<1;g=a|g<<1;p=i<<1|p>>>31|0;o=i>>>31|b<<1|0;UE(k,l,p,o)|0;m=D;n=m>>31|((m|0)<0?-1:0)<<1;a=n&1;i=UE(p,o,n&(d|0),(((m|0)<0?-1:0)>>31|((m|0)<0?-1:0)<<1)&(e|e&0))|0;b=D;j=j-1|0}while((j|0)!=0);j=h;h=0}if(f){c[f>>2]=i;c[f+4>>2]=b}m=(g|0)>>>31|j<<1|(0<<1|g>>>31)&0|h;d=(g<<1|0>>>31)&-2|a;return (D=m,d)|0}function kF(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;Hb[a&31](b|0,c|0,d|0,e|0,f|0)}function lF(a,b,c){a=a|0;b=b|0;c=+c;Ib[a&31](b|0,+c)}function mF(a,b){a=a|0;b=b|0;Jb[a&255](b|0)}function nF(a,b,c,d,e,f,g){a=a|0;b=b|0;c=c|0;d=d|0;e=+e;f=f|0;g=g|0;Kb[a&0](b|0,c|0,d|0,+e,f|0,g|0)}function oF(a,b,c){a=a|0;b=b|0;c=c|0;Lb[a&127](b|0,c|0)}function pF(a,b,c,d,e,f,g,h,i,j,k){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;return Mb[a&3](b|0,c|0,d|0,e|0,f|0,g|0,h|0,i|0,j|0,k|0)|0}function qF(a,b){a=a|0;b=b|0;return Nb[a&127](b|0)|0}function rF(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=+d;e=e|0;Ob[a&7](b|0,c|0,+d,e|0)}function sF(a,b,c,d,e,f,g){a=a|0;b=b|0;c=+c;d=+d;e=e|0;f=f|0;g=g|0;Pb[a&0](b|0,+c,+d,e|0,f|0,g|0)}function tF(a,b,c,d,e){a=a|0;b=b|0;c=+c;d=d|0;e=e|0;Qb[a&0](b|0,+c,d|0,e|0)}function uF(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;return Rb[a&31](b|0,c|0,d|0,e|0)|0}function vF(a,b,c,d){a=a|0;b=b|0;c=+c;d=d|0;Sb[a&15](b|0,+c,d|0)}function wF(a,b,c,d,e,f,g,h,i){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;return +Tb[a&1](b|0,c|0,d|0,e|0,f|0,g|0,h|0,i|0)}function xF(a,b,c,d,e,f,g,h,i,j,k,l){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=+f;g=+g;h=+h;i=+i;j=j|0;k=k|0;l=+l;Ub[a&0](b|0,c|0,d|0,e|0,+f,+g,+h,+i,j|0,k|0,+l)}function yF(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;return +Vb[a&15](b|0,c|0,d|0,e|0,f|0)}function zF(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;return Wb[a&63](b|0,c|0,d|0)|0}function AF(a,b,c,d,e,f,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;Xb[a&7](b|0,c|0,d|0,e|0,f|0,g|0)}function BF(a,b,c,d){a=a|0;b=b|0;c=c|0;d=+d;return Yb[a&7](b|0,c|0,+d)|0}function CF(a,b){a=a|0;b=b|0;return +Zb[a&15](b|0)}function DF(a,b,c,d,e,f,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;return _b[a&3](b|0,c|0,d|0,e|0,f|0,g|0)|0}function EF(a,b,c,d,e,f,g){a=a|0;b=b|0;c=c|0;d=d|0;e=+e;f=f|0;g=g|0;return +$b[a&3](b|0,c|0,d|0,+e,f|0,g|0)}function FF(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=+d;e=e|0;f=f|0;ac[a&0](b|0,c|0,+d,e|0,f|0)}function GF(a,b,c,d,e,f,g,h){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;bc[a&1](b|0,c|0,d|0,e|0,f|0,g|0,h|0)}function HF(a,b,c,d,e,f,g,h,i,j){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;cc[a&1](b|0,c|0,d|0,e|0,f|0,g|0,h|0,i|0,j|0)}function IF(a,b,c,d,e,f,g,h,i,j,k){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;dc[a&3](b|0,c|0,d|0,e|0,f|0,g|0,h|0,i|0,j|0,k|0)}function JF(a,b,c){a=a|0;b=b|0;c=c|0;return ec[a&31](b|0,c|0)|0}function KF(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;return +fc[a&15](b|0,c|0,d|0)}function LF(a,b,c,d,e,f,g,h,i,j,k){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;return +gc[a&3](b|0,c|0,d|0,e|0,f|0,g|0,h|0,i|0,j|0,k|0)}function MF(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=+f;hc[a&1](b|0,c|0,d|0,e|0,+f)}function NF(a,b,c,d,e,f,g,h,i,j){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;return +ic[a&3](b|0,c|0,d|0,e|0,f|0,g|0,h|0,i|0,j|0)}function OF(a,b,c){a=a|0;b=b|0;c=+c;return +jc[a&1](b|0,+c)}function PF(a,b,c,d,e,f,g,h,i,j,k,l,m){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=+f;g=+g;h=+h;i=+i;j=+j;k=k|0;l=+l;m=m|0;kc[a&0](b|0,c|0,d|0,e|0,+f,+g,+h,+i,+j,k|0,+l,m|0)}function QF(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=+d;e=e|0;f=f|0;return +lc[a&3](b|0,c|0,+d,e|0,f|0)}function RF(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;return +mc[a&1](b|0,c|0,d|0,e|0)}function SF(a,b,c,d,e,f,g,h,i,j){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;return nc[a&3](b|0,c|0,d|0,e|0,f|0,g|0,h|0,i|0,j|0)|0}function TF(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=+e;oc[a&15](b|0,c|0,d|0,+e)}function UF(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;pc[a&127](b|0,c|0,d|0)}function VF(a){a=a|0;qc[a&3]()}function WF(a,b,c,d){a=a|0;b=b|0;c=c|0;d=+d;rc[a&7](b|0,c|0,+d)}function XF(a,b,c,d,e){a=a|0;b=b|0;c=+c;d=d|0;e=+e;return sc[a&1](b|0,+c,d|0,+e)|0}function YF(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;tc[a&127](b|0,c|0,d|0,e|0)}function ZF(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;ca(0)}function _F(a,b){a=a|0;b=+b;ca(1)}function $F(a){a=a|0;ca(2)}function aG(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=+d;e=e|0;f=f|0;ca(3)}function bG(a,b){a=a|0;b=b|0;ca(4)}function cG(a,b,c,d,e,f,g,h,i,j){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;ca(5);return 0}function dG(a){a=a|0;ca(6);return 0}function eG(a,b,c,d){a=a|0;b=b|0;c=+c;d=d|0;ca(7)}function fG(a,b,c,d,e,f){a=a|0;b=+b;c=+c;d=d|0;e=e|0;f=f|0;ca(8)}function gG(a,b,c,d){a=a|0;b=+b;c=c|0;d=d|0;ca(9)}function hG(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;ca(10);return 0}function iG(a,b,c){a=a|0;b=+b;c=c|0;ca(11)}function jG(a,b,c,d,e,f,g,h){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;ca(12);return 0.0}function kG(a,b,c,d,e,f,g,h,i,j,k){a=a|0;b=b|0;c=c|0;d=d|0;e=+e;f=+f;g=+g;h=+h;i=i|0;j=j|0;k=+k;ca(13)}function lG(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;ca(14);return 0.0}function mG(a,b,c){a=a|0;b=b|0;c=c|0;ca(15);return 0}function nG(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;ca(16)}function oG(a,b,c){a=a|0;b=b|0;c=+c;ca(17);return 0}function pG(a){a=a|0;ca(18);return 0.0}function qG(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;ca(19);return 0}function rG(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=+d;e=e|0;f=f|0;ca(20);return 0.0}function sG(a,b,c,d,e){a=a|0;b=b|0;c=+c;d=d|0;e=e|0;ca(21)}function tG(a,b,c,d,e,f,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;ca(22)}function uG(a,b,c,d,e,f,g,h,i){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;ca(23)}function vG(a,b,c,d,e,f,g,h,i,j){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;ca(24)}function wG(a,b){a=a|0;b=b|0;ca(25);return 0}function xG(a,b,c){a=a|0;b=b|0;c=c|0;ca(26);return 0.0}function yG(a,b,c,d,e,f,g,h,i,j){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;ca(27);return 0.0}function zG(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=+e;ca(28)}function AG(a,b,c,d,e,f,g,h,i){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;ca(29);return 0.0}function BG(a,b){a=a|0;b=+b;ca(30);return 0.0}function CG(a,b,c,d,e,f,g,h,i,j,k,l){a=a|0;b=b|0;c=c|0;d=d|0;e=+e;f=+f;g=+g;h=+h;i=+i;j=j|0;k=+k;l=l|0;ca(31)}function DG(a,b,c,d,e){a=a|0;b=b|0;c=+c;d=d|0;e=e|0;ca(32);return 0.0}function EG(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;ca(33);return 0.0}function FG(a,b,c,d,e,f,g,h,i){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;ca(34);return 0}function GG(a,b,c,d){a=a|0;b=b|0;c=c|0;d=+d;ca(35)}function HG(a,b,c){a=a|0;b=b|0;c=c|0;ca(36)}function IG(){ca(37)}function JG(){Fb()}function KG(a,b,c){a=a|0;b=b|0;c=+c;ca(38)}function LG(a,b,c,d){a=a|0;b=+b;c=c|0;d=+d;ca(39);return 0}function MG(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;ca(40)}
function $y(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0,v=0,w=0.0,x=0,y=0;x=i;i=i+32|0;f=c[a+52>>2]|0;w=+g[a+(((f+2|0)%3|0)<<2)+28>>2];if((e|0)<=0){i=x;return}h=0;while(1){c[x+16>>2]=0;c[x+20>>2]=0;c[x+24>>2]=0;c[x+28>>2]=0;g[x+16+(f<<2)>>2]=+g[a+(f<<2)+28>>2];f=b+(h<<4)|0;u=b+(h<<4)+4|0;v=b+(h<<4)+8|0;p=w*+g[f>>2]+ +g[x+16>>2];k=w*+g[u>>2]+ +g[x+20>>2];l=w*+g[v>>2]+ +g[x+24>>2];j=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);o=+g[f>>2];n=+g[u>>2];m=+g[v>>2];if(o*(p-j*o)+n*(k-j*n)+m*(l-j*m)>-999999984306749440.0){g[d+(h<<4)>>2]=p-j*o;g[d+(h<<4)+4>>2]=k-j*n;g[d+(h<<4)+8>>2]=l-j*m;g[d+(h<<4)+12>>2]=0.0;q=+g[f>>2];s=+g[u>>2];t=+g[v>>2];r=o*(p-j*o)+n*(k-j*n)+m*(l-j*m)}else{q=o;s=n;t=m;r=-999999984306749440.0};c[x+0>>2]=0;c[x+4>>2]=0;c[x+8>>2]=0;c[x+12>>2]=0;y=c[a+52>>2]|0;g[x+(y<<2)>>2]=-+g[a+(y<<2)+28>>2];p=w*q+ +g[x>>2];o=w*s+ +g[x+4>>2];m=w*t+ +g[x+8>>2];n=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);l=+g[f>>2];k=+g[u>>2];j=+g[v>>2];if(l*(p-n*l)+k*(o-n*k)+j*(m-n*j)>r){g[d+(h<<4)>>2]=p-n*l;g[d+(h<<4)+4>>2]=o-n*k;g[d+(h<<4)+8>>2]=m-n*j;g[d+(h<<4)+12>>2]=0.0}h=h+1|0;if((h|0)==(e|0))break;f=c[a+52>>2]|0}i=x;return}function az(a,b,d){a=a|0;b=+b;d=d|0;var e=0,f=0.0,h=0.0,j=0.0,k=0;e=i;i=i+16|0;k=c[a+52>>2]|0;h=+g[a+(((k+2|0)%3|0)<<2)+28>>2];g[e>>2]=h;g[e+4>>2]=h;g[e+8>>2]=h;g[e+12>>2]=0.0;g[e+(k<<2)>>2]=+g[a+(k<<2)+28>>2]+ +g[e+(k<<2)>>2];h=(+g[e>>2]+.03999999910593033)*2.0;f=(+g[e+4>>2]+.03999999910593033)*2.0;j=(+g[e+8>>2]+.03999999910593033)*2.0;g[d>>2]=b*.0833333283662796*(f*f+j*j);g[d+4>>2]=b*.0833333283662796*(h*h+j*j);g[d+8>>2]=b*.0833333283662796*(h*h+f*f);i=e;return}function bz(a){a=a|0;return 14520}function cz(a){a=a|0;var b=0;b=i;if(!a){i=b;return}c[5110]=(c[5110]|0)+1;RE(c[a+-4>>2]|0);i=b;return}function dz(a){a=a|0;return 14536}function ez(a){a=a|0;var b=0;b=i;if(!a){i=b;return}c[5110]=(c[5110]|0)+1;RE(c[a+-4>>2]|0);i=b;return}function fz(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,h=0;f=i;e=ec[c[(c[d>>2]|0)+40>>2]&31](d,a)|0;h=ec[c[(c[d>>2]|0)+28>>2]&31](d,e)|0;c[b>>2]=h;if(h)Lb[c[(c[d>>2]|0)+48>>2]&127](d,e);c[b+4>>2]=c[a+4>>2];g[b+28>>2]=+g[a+28>>2];g[b+32>>2]=+g[a+32>>2];g[b+36>>2]=+g[a+36>>2];g[b+40>>2]=+g[a+40>>2];g[b+12>>2]=+g[a+12>>2];g[b+16>>2]=+g[a+16>>2];g[b+20>>2]=+g[a+20>>2];g[b+24>>2]=+g[a+24>>2];g[b+44>>2]=+g[a+44>>2];c[b+52>>2]=c[a+52>>2];i=f;return 14552}function gz(a){a=a|0;return 60}function hz(a,b){a=a|0;b=+b;var d=0,e=0.0,f=0.0,h=0.0,j=0.0,k=0.0;d=i;j=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);f=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);k=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);j=j+ +g[a+28>>2];f=f+ +g[a+32>>2];k=k+ +g[a+36>>2];g[a+44>>2]=b;h=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);e=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);b=k-+Zb[c[(c[a>>2]|0)+48>>2]&15](a);g[a+28>>2]=j-h;g[a+32>>2]=f-e;g[a+36>>2]=b;g[a+40>>2]=0.0;i=d;return}function iz(a,b){a=a|0;b=b|0;c[a+0>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;c[a+12>>2]=0;g[a+(c[b+52>>2]<<2)>>2]=1.0;return}function jz(a){a=a|0;return 14576}function kz(a,b){a=a|0;b=b|0;var d=0,e=0.0,f=0.0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0;d=i;m=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);j=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);e=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);o=(m+ +g[a+28>>2])/+g[a+12>>2];l=(j+ +g[a+32>>2])/+g[a+16>>2];h=(e+ +g[a+36>>2])/+g[a+20>>2];n=+O(+(+g[b>>2]));k=+O(+(+g[b+4>>2]));f=+O(+(+g[b+8>>2]));g[a+12>>2]=n;g[a+16>>2]=k;g[a+20>>2]=f;g[a+24>>2]=0.0;g[a+28>>2]=o*n-m;g[a+32>>2]=l*k-j;g[a+36>>2]=h*f-e;g[a+40>>2]=0.0;i=d;return}function lz(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0;f=i;i=i+16|0;x=c[a+52>>2]|0;k=+g[a+(((x+2|0)%3|0)<<2)+28>>2];g[f>>2]=k;g[f+4>>2]=k;g[f+8>>2]=k;g[f+12>>2]=0.0;g[f+(x<<2)>>2]=k+ +g[a+(x<<2)+28>>2];k=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);h=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);n=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);k=k+ +g[f>>2];g[f>>2]=k;h=h+ +g[f+4>>2];g[f+4>>2]=h;n=n+ +g[f+8>>2];u=+O(+(+g[b>>2]));t=+O(+(+g[b+4>>2]));v=+O(+(+g[b+8>>2]));q=+O(+(+g[b+16>>2]));p=+O(+(+g[b+20>>2]));r=+O(+(+g[b+24>>2]));l=+O(+(+g[b+32>>2]));j=+O(+(+g[b+36>>2]));m=+O(+(+g[b+40>>2]));w=+g[b+48>>2];s=+g[b+52>>2];o=+g[b+56>>2];g[d>>2]=w-(n*v+(u*k+t*h));g[d+4>>2]=s-(n*r+(q*k+p*h));g[d+8>>2]=o-(n*m+(l*k+j*h));g[d+12>>2]=0.0;g[e>>2]=w+(n*v+(u*k+t*h));g[e+4>>2]=s+(n*r+(q*k+p*h));g[e+8>>2]=o+(n*m+(l*k+j*h));g[e+12>>2]=0.0;i=f;return}function mz(a){a=a|0;var b=0;b=i;if(!a){i=b;return}c[5110]=(c[5110]|0)+1;RE(c[a+-4>>2]|0);i=b;return}function nz(a,b,d){a=a|0;b=b|0;d=d|0;var e=0.0,f=0.0,h=0.0,j=0.0,k=0.0,l=0,m=0.0;l=i;i=i+80|0;c[a+0>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;c[a+12>>2]=0;e=+g[d>>2];k=+g[d+4>>2];f=+g[d+8>>2];if(e*e+k*k+f*f<9.999999747378752e-05){j=1.0;h=0.0;f=0.0;e=0.0}else{m=1.0/+P(+(e*e+k*k+f*f));j=e*m;h=f*m;f=+g[d+12>>2];e=k*m}c[l+32>>2]=14800;c[l+36>>2]=0;c[l+40>>2]=0;c[l+44>>2]=0;c[l+48>>2]=0;g[l+52>>2]=-999999984306749440.0;g[l+56>>2]=j;g[l+60>>2]=e;g[l+64>>2]=h;g[l+68>>2]=f;g[l+16>>2]=999999984306749440.0;g[l+20>>2]=999999984306749440.0;g[l+24>>2]=999999984306749440.0;g[l+28>>2]=0.0;d=c[b+92>>2]|0;b=c[(c[d>>2]|0)+8>>2]|0;g[l>>2]=-999999984306749440.0;g[l+4>>2]=-999999984306749440.0;g[l+8>>2]=-999999984306749440.0;g[l+12>>2]=0.0;tc[b&127](d,l+32|0,l,l+16|0);c[a+0>>2]=c[l+36>>2];c[a+4>>2]=c[l+40>>2];c[a+8>>2]=c[l+44>>2];c[a+12>>2]=c[l+48>>2];i=l;return}function oz(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0,j=0,k=0;h=i;i=i+80|0;if((e|0)>0)f=0;else{i=h;return}do{g[d+(f<<4)+12>>2]=-999999984306749440.0;f=f+1|0}while((f|0)!=(e|0));f=0;do{j=b+(f<<4)|0;c[h+32>>2]=14800;c[h+36>>2]=0;c[h+40>>2]=0;c[h+44>>2]=0;c[h+48>>2]=0;g[h+52>>2]=-999999984306749440.0;c[h+56>>2]=c[j+0>>2];c[h+60>>2]=c[j+4>>2];c[h+64>>2]=c[j+8>>2];c[h+68>>2]=c[j+12>>2];g[h+16>>2]=999999984306749440.0;g[h+20>>2]=999999984306749440.0;g[h+24>>2]=999999984306749440.0;g[h+28>>2]=0.0;j=c[a+92>>2]|0;k=c[(c[j>>2]|0)+8>>2]|0;g[h>>2]=-999999984306749440.0;g[h+4>>2]=-999999984306749440.0;g[h+8>>2]=-999999984306749440.0;g[h+12>>2]=0.0;tc[k&127](j,h+32|0,h,h+16|0);j=d+(f<<4)|0;c[j+0>>2]=c[h+36>>2];c[j+4>>2]=c[h+40>>2];c[j+8>>2]=c[h+44>>2];c[j+12>>2]=c[h+48>>2];f=f+1|0}while((f|0)<(e|0));i=h;return}function pz(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0.0,h=0.0,j=0.0,k=0.0,l=0.0;e=i;pc[c[(c[b>>2]|0)+68>>2]&127](a,b,d);if(!(+Zb[c[(c[b>>2]|0)+48>>2]&15](b)!=0.0)){i=e;return}l=+g[d>>2];j=+g[d+4>>2];h=+g[d+8>>2];f=l*l+j*j+h*h<1.4210854715202004e-14?-1.0:h;k=l*l+j*j+h*h<1.4210854715202004e-14?-1.0:j;l=l*l+j*j+h*h<1.4210854715202004e-14?-1.0:l;h=1.0/+P(+(f*f+(l*l+k*k)));j=+Zb[c[(c[b>>2]|0)+48>>2]&15](b);g[a>>2]=h*l*j+ +g[a>>2];g[a+4>>2]=j*(h*k)+ +g[a+4>>2];g[a+8>>2]=j*(h*f)+ +g[a+8>>2];i=e;return}function qz(a){a=a|0;return 0}function rz(a){a=a|0;return 0}function sz(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;return}function tz(a,b,c){a=a|0;b=b|0;c=c|0;return}function uz(a){a=a|0;return 0}function vz(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;return}function wz(a,b,c){a=a|0;b=b|0;c=+c;return 0}function xz(a,b){a=a|0;b=b|0;var d=0,e=0;d=i;e=(c[a+92>>2]|0)+4|0;c[e+0>>2]=c[b+0>>2];c[e+4>>2]=c[b+4>>2];c[e+8>>2]=c[b+8>>2];c[e+12>>2]=c[b+12>>2];oy(a);i=d;return}function yz(a){a=a|0;return (c[a+92>>2]|0)+4|0}function zz(a){a=a|0;return 14776}function Az(a){a=a|0;var b=0,d=0;d=i;c[a>>2]=13336;b=c[a+52>>2]|0;if(b){Jb[c[c[b>>2]>>2]&255](b);b=c[a+52>>2]|0;if(b){c[5110]=(c[5110]|0)+1;RE(c[b+-4>>2]|0)}if(!a){i=d;return}}c[5110]=(c[5110]|0)+1;RE(c[a+-4>>2]|0);i=d;return}function Bz(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0.0,h=0.0,j=0.0,k=0.0,l=0.0;e=i;j=+g[a+24>>2];k=+g[a+28>>2];l=+g[a+32>>2];h=j*+g[b>>2]+k*+g[b+4>>2]+l*+g[b+8>>2];f=+g[a+20>>2];if(h>f){g[a+20>>2]=h;c[a+4>>2]=c[b+0>>2];c[a+8>>2]=c[b+4>>2];c[a+12>>2]=c[b+8>>2];c[a+16>>2]=c[b+12>>2];f=h}h=j*+g[b+16>>2]+k*+g[b+20>>2]+l*+g[b+24>>2];if(h>f){g[a+20>>2]=h;c[a+4>>2]=c[b+16>>2];c[a+8>>2]=c[b+20>>2];c[a+12>>2]=c[b+24>>2];c[a+16>>2]=c[b+28>>2]}else h=f;f=j*+g[b+32>>2]+k*+g[b+36>>2]+l*+g[b+40>>2];if(!(f>h)){i=e;return}g[a+20>>2]=f;c[a+4>>2]=c[b+32>>2];c[a+8>>2]=c[b+36>>2];c[a+12>>2]=c[b+40>>2];c[a+16>>2]=c[b+44>>2];i=e;return}function Cz(a){a=a|0;var b=0;b=i;RE(a);i=b;return}function Dz(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0;f=i;k=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);o=k+ +g[a+28>>2];m=k+ +g[a+32>>2];k=k+ +g[a+36>>2];w=+O(+(+g[b>>2]));v=+O(+(+g[b+4>>2]));u=+O(+(+g[b+8>>2]));s=+O(+(+g[b+16>>2]));r=+O(+(+g[b+20>>2]));q=+O(+(+g[b+24>>2]));n=+O(+(+g[b+32>>2]));l=+O(+(+g[b+36>>2]));j=+O(+(+g[b+40>>2]));t=+g[b+48>>2];p=+g[b+52>>2];h=+g[b+56>>2];g[d>>2]=t-(o*w+m*v+k*u);g[d+4>>2]=p-(o*s+m*r+k*q);g[d+8>>2]=h-(o*n+m*l+k*j);g[d+12>>2]=0.0;g[e>>2]=o*w+m*v+k*u+t;g[e+4>>2]=o*s+m*r+k*q+p;g[e+8>>2]=o*n+m*l+k*j+h;g[e+12>>2]=0.0;i=f;return}function Ez(a,b,d){a=a|0;b=+b;d=d|0;var e=0,f=0.0,h=0.0,j=0.0,k=0.0,l=0.0;e=i;k=+g[a+28>>2];h=+g[a+32>>2];l=+g[a+36>>2];j=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);f=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);l=(l+ +Zb[c[(c[a>>2]|0)+48>>2]&15](a))*2.0;g[d>>2]=b/12.0*((h+f)*2.0*((h+f)*2.0)+l*l);g[d+4>>2]=b/12.0*((k+j)*2.0*((k+j)*2.0)+l*l);g[d+8>>2]=b/12.0*((k+j)*2.0*((k+j)*2.0)+(h+f)*2.0*((h+f)*2.0));g[d+12>>2]=0.0;i=e;return}function Fz(a,b){a=a|0;b=+b;var d=0,e=0.0,f=0.0,h=0.0,j=0.0,k=0.0;d=i;j=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);f=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);k=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);j=j+ +g[a+28>>2];f=f+ +g[a+32>>2];k=k+ +g[a+36>>2];g[a+44>>2]=b;h=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);e=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);b=k-+Zb[c[(c[a>>2]|0)+48>>2]&15](a);g[a+28>>2]=j-h;g[a+32>>2]=f-e;g[a+36>>2]=b;g[a+40>>2]=0.0;i=d;return}function Gz(a,b,c){a=a|0;b=b|0;c=c|0;var d=0.0,e=0.0,f=0.0,h=0;h=i;e=+g[a+28>>2];f=+g[a+32>>2];d=+g[a+36>>2];switch(c|0){case 4:{g[b>>2]=0.0;g[b+4>>2]=0.0;g[b+8>>2]=1.0;g[b+12>>2]=-d;i=h;return}case 0:{g[b>>2]=1.0;g[b+4>>2]=0.0;g[b+8>>2]=0.0;g[b+12>>2]=-e;i=h;return}case 2:{g[b>>2]=0.0;g[b+4>>2]=1.0;g[b+8>>2]=0.0;g[b+12>>2]=-f;i=h;return}case 1:{g[b>>2]=-1.0;g[b+4>>2]=0.0;g[b+8>>2]=0.0;g[b+12>>2]=-e;i=h;return}case 5:{g[b>>2]=0.0;g[b+4>>2]=0.0;g[b+8>>2]=-1.0;g[b+12>>2]=-d;i=h;return}case 3:{g[b>>2]=0.0;g[b+4>>2]=-1.0;g[b+8>>2]=0.0;g[b+12>>2]=-f;i=h;return}default:{i=h;return}}}function Hz(a,b,c){a=a|0;b=b|0;c=+c;var d=0.0,e=0.0,f=0.0,h=0.0,j=0;j=i;e=+g[a+28>>2];f=+g[a+32>>2];h=+g[a+36>>2];d=+g[b>>2];if(!(d<=e+c)){a=0;i=j;return a|0}if(!(d>=-e-c)){a=0;i=j;return a|0}d=+g[b+4>>2];if(!(d<=f+c)){a=0;i=j;return a|0}if(!(d>=-f-c)){a=0;i=j;return a|0}d=+g[b+8>>2];if(!(d<=h+c)){a=0;i=j;return a|0}a=d>=-h-c;i=j;return a|0}function Iz(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0.0,j=0.0,k=0.0;f=i;i=i+48|0;pc[c[(c[a>>2]|0)+124>>2]&127](a,f+32|0,e);k=+g[f+32>>2];j=+g[f+36>>2];h=+g[f+40>>2];g[b>>2]=k;g[b+4>>2]=j;g[b+8>>2]=h;g[b+12>>2]=0.0;e=c[(c[a>>2]|0)+64>>2]|0;g[f>>2]=-k;g[f+4>>2]=-j;g[f+8>>2]=-h;g[f+12>>2]=0.0;pc[e&127](f+16|0,a,f);c[d+0>>2]=c[f+16>>2];c[d+4>>2]=c[f+20>>2];c[d+8>>2]=c[f+24>>2];c[d+12>>2]=c[f+28>>2];i=f;return}function Jz(a){a=a|0;return 6}function Kz(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0.0,h=0.0,j=0.0,k=0.0,l=0.0;e=i;l=+g[a+28>>2];j=+g[a+32>>2];f=+g[a+36>>2];k=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);h=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);f=f+ +Zb[c[(c[a>>2]|0)+48>>2]&15](a);g[d>>2]=+(b&1^1|0)*(l+k)-+(b&1|0)*(l+k);g[d+4>>2]=+(b>>>1&1^1|0)*(j+h)-+(b>>>1&1|0)*(j+h);g[d+8>>2]=+(b>>>2&1^1|0)*f-+(b>>>2&1|0)*f;g[d+12>>2]=0.0;i=e;return}function Lz(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0;g=i;do switch(b|0){case 6:{f=2;break}case 1:{f=0;b=2;break}case 7:{f=3;break}case 3:{f=2;break}case 10:{f=5;b=7;break}case 9:{f=4;b=6;break}case 5:{f=1;break}case 4:{f=0;break}case 8:{f=4;b=5;break}case 11:{f=6;b=7;break}case 2:{f=1;b=3;break}case 0:{f=0;b=1;break}default:{f=0;b=0}}while(0);pc[c[(c[a>>2]|0)+108>>2]&127](a,f,d);pc[c[(c[a>>2]|0)+108>>2]&127](a,b,e);i=g;return}function Mz(a){a=a|0;return 12}function Nz(a){a=a|0;return 8}function Oz(a,b,c){a=a|0;b=b|0;c=c|0;a=i;switch(b|0){case 4:{g[c>>2]=0.0;g[c+4>>2]=0.0;g[c+8>>2]=1.0;g[c+12>>2]=0.0;i=a;return}case 5:{g[c>>2]=0.0;g[c+4>>2]=0.0;g[c+8>>2]=-1.0;g[c+12>>2]=0.0;i=a;return}case 1:{g[c>>2]=-1.0;g[c+4>>2]=0.0;g[c+8>>2]=0.0;g[c+12>>2]=0.0;i=a;return}case 3:{g[c>>2]=0.0;g[c+4>>2]=-1.0;g[c+8>>2]=0.0;g[c+12>>2]=0.0;i=a;return}case 2:{g[c>>2]=0.0;g[c+4>>2]=1.0;g[c+8>>2]=0.0;g[c+12>>2]=0.0;i=a;return}case 0:{g[c>>2]=1.0;g[c+4>>2]=0.0;g[c+8>>2]=0.0;g[c+12>>2]=0.0;i=a;return}default:{i=a;return}}}function Pz(a){a=a|0;return 6}function Qz(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0,h=0.0,j=0.0,k=0.0;f=i;if((d|0)<=0){i=f;return}e=0;do{k=+g[a+28>>2];j=+g[a+32>>2];j=+g[b+(e<<4)+4>>2]>=0.0?j:-j;h=+g[a+36>>2];h=+g[b+(e<<4)+8>>2]>=0.0?h:-h;g[c+(e<<4)>>2]=+g[b+(e<<4)>>2]>=0.0?k:-k;g[c+(e<<4)+4>>2]=j;g[c+(e<<4)+8>>2]=h;g[c+(e<<4)+12>>2]=0.0;e=e+1|0}while((e|0)!=(d|0));i=f;return}function Rz(a,b,c){a=a|0;b=b|0;c=c|0;var d=0.0,e=0.0,f=0.0;f=+g[b+28>>2];e=+g[b+32>>2];e=+g[c+4>>2]>=0.0?e:-e;d=+g[b+36>>2];d=+g[c+8>>2]>=0.0?d:-d;g[a>>2]=+g[c>>2]>=0.0?f:-f;g[a+4>>2]=e;g[a+8>>2]=d;g[a+12>>2]=0.0;return}function Sz(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0.0,h=0.0,j=0.0,k=0.0,l=0.0;e=i;k=+g[b+28>>2];l=+g[b+32>>2];f=+g[b+36>>2];j=+Zb[c[(c[b>>2]|0)+48>>2]&15](b);h=+Zb[c[(c[b>>2]|0)+48>>2]&15](b);f=f+ +Zb[c[(c[b>>2]|0)+48>>2]&15](b);h=+g[d+4>>2]>=0.0?l+h:-(l+h);f=+g[d+8>>2]>=0.0?f:-f;g[a>>2]=+g[d>>2]>=0.0?k+j:-(k+j);g[a+4>>2]=h;g[a+8>>2]=f;g[a+12>>2]=0.0;i=e;return}function Tz(a){a=a|0;return 15072}function Uz(a,b){a=a|0;b=b|0;var d=0,e=0.0,f=0.0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0;d=i;m=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);j=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);e=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);o=(m+ +g[a+28>>2])/+g[a+12>>2];l=(j+ +g[a+32>>2])/+g[a+16>>2];h=(e+ +g[a+36>>2])/+g[a+20>>2];n=+O(+(+g[b>>2]));k=+O(+(+g[b+4>>2]));f=+O(+(+g[b+8>>2]));g[a+12>>2]=n;g[a+16>>2]=k;g[a+20>>2]=f;g[a+24>>2]=0.0;g[a+28>>2]=o*n-m;g[a+32>>2]=l*k-j;g[a+36>>2]=h*f-e;g[a+40>>2]=0.0;i=d;return}function Vz(a){a=a|0;var b=0,d=0;d=i;c[a>>2]=13336;b=c[a+52>>2]|0;if(b){Jb[c[c[b>>2]>>2]&255](b);b=c[a+52>>2]|0;if(b){c[5110]=(c[5110]|0)+1;RE(c[b+-4>>2]|0)}if(!a){i=d;return}}c[5110]=(c[5110]|0)+1;RE(c[a+-4>>2]|0);i=d;return}function Wz(a){a=a|0;var b=0;b=i;qC(a);i=b;return}function Xz(a){a=a|0;var b=0;b=i;qC(a);if(!a){i=b;return}c[5110]=(c[5110]|0)+1;RE(c[a+-4>>2]|0);i=b;return}function Yz(d,e,f,h,j){d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;var k=0,l=0,m=0.0,n=0.0,o=0,p=0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0;A=i;i=i+176|0;a[d+60>>0]=f&1;if(f){s=+g[h>>2]+-1.0;v=+g[h+4>>2]+-1.0;u=+g[h+8>>2]+-1.0;g[d+4>>2]=s;g[d+8>>2]=v;g[d+12>>2]=u;g[d+16>>2]=0.0;q=+g[j>>2]+1.0;z=+g[j+4>>2]+1.0;y=+g[j+8>>2]+1.0;g[d+20>>2]=q;g[d+24>>2]=z;g[d+28>>2]=y;g[d+32>>2]=0.0;g[d+36>>2]=65533.0/(q-s);g[d+40>>2]=65533.0/(z-v);g[d+44>>2]=65533.0/(y-u);g[d+48>>2]=0.0;a[d+60>>0]=1;n=s+ +(~~((s-s)*(65533.0/(q-s)))&65534)/(65533.0/(q-s))+-1.0;m=v+ +(~~((v-v)*(65533.0/(z-v)))&65534)/(65533.0/(z-v))+-1.0;r=u+ +(~~((u-u)*(65533.0/(y-u)))&65534)/(65533.0/(y-u))+-1.0;if(n<s){g[d+4>>2]=n;x=n}else x=s;if(m<v){g[d+8>>2]=m;w=m}else w=v;if(r<u){g[d+12>>2]=r;t=r}else t=u;r=x+ +((~~((q-x)*(65533.0/(q-s))+1.0)&65535|1)&65535)/(65533.0/(q-s))+1.0;n=w+ +((~~((z-w)*(65533.0/(z-v))+1.0)&65535|1)&65535)/(65533.0/(z-v))+1.0;m=t+ +((~~((y-t)*(65533.0/(y-u))+1.0)&65535|1)&65535)/(65533.0/(y-u))+1.0;if(q<r){g[d+20>>2]=r;q=r}if(z<n)g[d+24>>2]=n;else n=z;if(y<m)g[d+28>>2]=m;else m=y;g[d+36>>2]=65533.0/(q-x);g[d+40>>2]=65533.0/(n-w);g[d+44>>2]=65533.0/(m-t);g[d+48>>2]=0.0;c[A+152>>2]=15168;c[A+156>>2]=d+104;c[A+160>>2]=d;tc[c[(c[e>>2]|0)+8>>2]&127](e,A+152|0,d+4|0,d+20|0);k=c[d+108>>2]|0;c[A+136>>2]=0;c[A+140>>2]=0;c[A+144>>2]=0;c[A+148>>2]=0;j=c[d+128>>2]|0;if((j|0)<(k<<1|0)){if((c[d+132>>2]|0)<(k<<1|0)){if(!k){h=j;f=0}else{c[5108]=(c[5108]|0)+1;l=QE(k<<5|19)|0;if(!l)f=0;else{c[(l+19&-16)+-4>>2]=l;f=l+19&-16}h=c[d+128>>2]|0}if((h|0)>0){l=0;do{o=f+(l<<4)|0;p=(c[d+136>>2]|0)+(l<<4)|0;c[o+0>>2]=c[p+0>>2];c[o+4>>2]=c[p+4>>2];c[o+8>>2]=c[p+8>>2];c[o+12>>2]=c[p+12>>2];l=l+1|0}while((l|0)!=(h|0))}l=c[d+136>>2]|0;if(l){if(a[d+140>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[l+-4>>2]|0)}c[d+136>>2]=0}a[d+140>>0]=1;c[d+136>>2]=f;c[d+132>>2]=k<<1;f=d+136|0}else f=d+136|0;l=j;do{h=(c[f>>2]|0)+(l<<4)|0;c[h+0>>2]=c[A+136>>2];c[h+4>>2]=c[A+140>>2];c[h+8>>2]=c[A+144>>2];c[h+12>>2]=c[A+148>>2];l=l+1|0}while((l|0)!=(k<<1|0))}c[d+128>>2]=k<<1}else{c[A+128>>2]=15312;c[A+132>>2]=d+64;g[A+112>>2]=-999999984306749440.0;g[A+116>>2]=-999999984306749440.0;g[A+120>>2]=-999999984306749440.0;g[A+124>>2]=0.0;g[A+96>>2]=999999984306749440.0;g[A+100>>2]=999999984306749440.0;g[A+104>>2]=999999984306749440.0;g[A+108>>2]=0.0;tc[c[(c[e>>2]|0)+8>>2]&127](e,A+128|0,A+112|0,A+96|0);k=c[d+68>>2]|0;o=A+32|0;e=o+64|0;do{c[o>>2]=0;o=o+4|0}while((o|0)<(e|0));h=c[d+88>>2]|0;if((h|0)<(k<<1|0)){if((c[d+92>>2]|0)<(k<<1|0)){if(!k){j=h;f=0}else{c[5108]=(c[5108]|0)+1;l=QE(k<<7|19)|0;if(!l)f=0;else{c[(l+19&-16)+-4>>2]=l;f=l+19&-16}j=c[d+88>>2]|0}if((j|0)>0){l=0;do{o=f+(l<<6)+0|0;p=(c[d+96>>2]|0)+(l<<6)+0|0;e=o+64|0;do{c[o>>2]=c[p>>2];o=o+4|0;p=p+4|0}while((o|0)<(e|0));l=l+1|0}while((l|0)!=(j|0))}l=c[d+96>>2]|0;if(l){if(a[d+100>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[l+-4>>2]|0)}c[d+96>>2]=0}a[d+100>>0]=1;c[d+96>>2]=f;c[d+92>>2]=k<<1;f=d+96|0}else f=d+96|0;do{o=(c[f>>2]|0)+(h<<6)+0|0;p=A+32|0;e=o+64|0;do{c[o>>2]=c[p>>2];o=o+4|0;p=p+4|0}while((o|0)<(e|0));h=h+1|0}while((h|0)!=(k<<1|0))}c[d+88>>2]=k<<1}c[d+56>>2]=0;pC(d,0,k);if((a[d+60>>0]|0)!=0?(c[d+152>>2]|0)==0:0){if(!(c[d+156>>2]|0)){c[5108]=(c[5108]|0)+1;k=QE(51)|0;if(!k)f=0;else{c[(k+19&-16)+-4>>2]=k;f=k+19&-16}k=c[d+152>>2]|0;if((k|0)>0){l=0;do{h=f+(l<<5)|0;j=(c[d+160>>2]|0)+(l<<5)|0;c[h+0>>2]=c[j+0>>2];c[h+4>>2]=c[j+4>>2];c[h+8>>2]=c[j+8>>2];c[h+12>>2]=c[j+12>>2];c[h+16>>2]=c[j+16>>2];c[h+20>>2]=c[j+20>>2];c[h+24>>2]=c[j+24>>2];c[h+28>>2]=c[j+28>>2];l=l+1|0}while((l|0)!=(k|0))}k=c[d+160>>2]|0;if(k){if(a[d+164>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[k+-4>>2]|0)}c[d+160>>2]=0}a[d+164>>0]=1;c[d+160>>2]=f;c[d+156>>2]=1;l=(c[d+152>>2]|0)+1|0;k=f}else{l=1;k=c[d+160>>2]|0}c[d+152>>2]=l;c[k+0>>2]=c[A+0>>2];c[k+4>>2]=c[A+4>>2];c[k+8>>2]=c[A+8>>2];c[k+12>>2]=c[A+12>>2];c[k+16>>2]=c[A+16>>2];c[k+20>>2]=c[A+20>>2];c[k+24>>2]=c[A+24>>2];c[k+28>>2]=c[A+28>>2];k=c[d+160>>2]|0;l=c[d+136>>2]|0;b[k>>1]=b[l>>1]|0;b[k+2>>1]=b[l+2>>1]|0;b[k+4>>1]=b[l+4>>1]|0;b[k+6>>1]=b[l+6>>1]|0;b[k+8>>1]=b[l+8>>1]|0;b[k+10>>1]=b[l+10>>1]|0;c[k+12>>2]=0;l=c[l+12>>2]|0;c[k+16>>2]=(l|0)>-1?1:0-l|0}c[d+168>>2]=c[d+152>>2];k=c[d+116>>2]|0;if(k){if(a[d+120>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[k+-4>>2]|0)}c[d+116>>2]=0}a[d+120>>0]=1;c[d+116>>2]=0;c[d+108>>2]=0;c[d+112>>2]=0;k=c[d+76>>2]|0;if(!k){a[d+80>>0]=1;c[d+76>>2]=0;c[d+68>>2]=0;k=d+72|0;c[k>>2]=0;i=A;return}if(a[d+80>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[k+-4>>2]|0)}c[d+76>>2]=0;a[d+80>>0]=1;c[d+76>>2]=0;c[d+68>>2]=0;k=d+72|0;c[k>>2]=0;i=A;return}function Zz(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0;e=i;vC(a,b,c,d)|0;i=e;return 1}function _z(a){a=a|0;return 84}function $z(d,e,f,h){d=d|0;e=e|0;f=f|0;h=h|0;var j=0.0,k=0.0,l=0.0,m=0,n=0.0,o=0.0,p=0,q=0.0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0,G=0;y=i;k=+g[e>>2];j=k<999999984306749440.0?k:999999984306749440.0;l=+g[e+4>>2];o=l<999999984306749440.0?l:999999984306749440.0;q=+g[e+8>>2];n=q<999999984306749440.0?q:999999984306749440.0;k=k>-999999984306749440.0?k:-999999984306749440.0;l=l>-999999984306749440.0?l:-999999984306749440.0;q=q>-999999984306749440.0?q:-999999984306749440.0;z=+g[e+16>>2];j=z<j?z:j;A=+g[e+20>>2];o=A<o?A:o;B=+g[e+24>>2];n=B<n?B:n;k=k<z?z:k;l=l<A?A:l;q=q<B?B:q;B=+g[e+32>>2];j=B<j?B:j;A=+g[e+36>>2];o=A<o?A:o;z=+g[e+40>>2];n=z<n?z:n;k=k<B?B:k;l=l<A?A:l;q=q<z?z:q;if(k-j<2.0000000949949026e-03){j=j+-1.0000000474974513e-03;k=k+1.0000000474974513e-03}if(l-o<2.0000000949949026e-03){l=l+1.0000000474974513e-03;o=o+-1.0000000474974513e-03}if(q-n<2.0000000949949026e-03){n=n+-1.0000000474974513e-03;q=q+1.0000000474974513e-03}w=c[d+8>>2]|0;E=+g[w+4>>2];C=+g[w+8>>2];A=+g[w+12>>2];D=+g[w+36>>2];B=+g[w+40>>2];z=+g[w+44>>2];w=~~((j-E)*D)&65534;v=~~((o-C)*B)&65534;u=~~((n-A)*z)&65534;t=(~~((k-E)*D+1.0)&65535|1)&65535;s=(~~((l-C)*B+1.0)&65535|1)&65535;r=(~~((q-A)*z+1.0)&65535|1)&65535;d=c[d+4>>2]|0;e=c[d+4>>2]|0;if((e|0)==(c[d+8>>2]|0)?(x=(e|0)==0?1:e<<1,(e|0)<(x|0)):0){if(!x)m=0;else{c[5108]=(c[5108]|0)+1;e=QE((x<<4|3)+16|0)|0;if(!e)m=0;else{c[(e+19&-16)+-4>>2]=e;m=e+19&-16}e=c[d+4>>2]|0}if((e|0)>0){p=0;do{F=m+(p<<4)|0;G=(c[d+12>>2]|0)+(p<<4)|0;c[F+0>>2]=c[G+0>>2];c[F+4>>2]=c[G+4>>2];c[F+8>>2]=c[G+8>>2];c[F+12>>2]=c[G+12>>2];p=p+1|0}while((p|0)!=(e|0))}e=c[d+12>>2]|0;if(e){if(a[d+16>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[e+-4>>2]|0)}c[d+12>>2]=0}a[d+16>>0]=1;c[d+12>>2]=m;c[d+8>>2]=x;e=c[d+4>>2]|0}p=c[d+12>>2]|0;b[p+(e<<4)>>1]=w;b[p+(e<<4)+2>>1]=v;b[p+(e<<4)+4>>1]=u;b[p+(e<<4)+6>>1]=t;b[p+(e<<4)+8>>1]=s;b[p+(e<<4)+10>>1]=r;c[p+(e<<4)+12>>2]=f<<21|h;c[d+4>>2]=(c[d+4>>2]|0)+1;i=y;return}function aA(a){a=a|0;var b=0;b=i;RE(a);i=b;return}function bA(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var h=0,j=0,k=0,l=0,m=0,n=0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0,x=0.0,y=0.0,z=0.0,A=0.0;w=i;i=i+32|0;o=+g[d>>2];t=o<999999984306749440.0?o:999999984306749440.0;r=+g[d+4>>2];v=r<999999984306749440.0?r:999999984306749440.0;p=+g[d+8>>2];u=p<999999984306749440.0?p:999999984306749440.0;q=+g[d+12>>2];s=q<0.0?q:0.0;o=o>-999999984306749440.0?o:-999999984306749440.0;r=r>-999999984306749440.0?r:-999999984306749440.0;p=p>-999999984306749440.0?p:-999999984306749440.0;q=q>0.0?q:0.0;x=+g[d+16>>2];t=x<t?x:t;y=+g[d+20>>2];v=y<v?y:v;z=+g[d+24>>2];u=z<u?z:u;A=+g[d+28>>2];s=A<s?A:s;o=o<x?x:o;r=r<y?y:r;p=p<z?z:p;q=q<A?A:q;A=+g[d+32>>2];t=A<t?A:t;z=+g[d+36>>2];v=z<v?z:v;y=+g[d+40>>2];u=y<u?y:u;x=+g[d+44>>2];s=x<s?x:s;o=o<A?A:o;r=r<z?z:r;p=p<y?y:p;q=q<x?x:q;m=c[b+4>>2]|0;d=c[m+4>>2]|0;if((d|0)==(c[m+8>>2]|0)?(n=(d|0)==0?1:d<<1,(d|0)<(n|0)):0){if(!n)l=0;else{c[5108]=(c[5108]|0)+1;d=QE(n<<6|19)|0;if(!d)b=0;else{c[(d+19&-16)+-4>>2]=d;b=d+19&-16}d=c[m+4>>2]|0;l=b}if((d|0)>0){b=0;do{h=l+(b<<6)+0|0;j=(c[m+12>>2]|0)+(b<<6)+0|0;k=h+64|0;do{c[h>>2]=c[j>>2];h=h+4|0;j=j+4|0}while((h|0)<(k|0));b=b+1|0}while((b|0)!=(d|0))}b=c[m+12>>2]|0;if(b){if(a[m+16>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[b+-4>>2]|0)}c[m+12>>2]=0}a[m+16>>0]=1;c[m+12>>2]=l;c[m+8>>2]=n;d=c[m+4>>2]|0}n=c[m+12>>2]|0;g[n+(d<<6)>>2]=t;g[n+(d<<6)+4>>2]=v;g[n+(d<<6)+8>>2]=u;g[n+(d<<6)+12>>2]=s;g[n+(d<<6)+16>>2]=o;g[n+(d<<6)+20>>2]=r;g[n+(d<<6)+24>>2]=p;g[n+(d<<6)+28>>2]=q;c[n+(d<<6)+32>>2]=-1;c[n+(d<<6)+36>>2]=e;c[n+(d<<6)+40>>2]=f;n=n+(d<<6)+44|0;c[n+0>>2]=c[w+0>>2];c[n+4>>2]=c[w+4>>2];c[n+8>>2]=c[w+8>>2];c[n+12>>2]=c[w+12>>2];c[n+16>>2]=c[w+16>>2];c[m+4>>2]=(c[m+4>>2]|0)+1;i=w;return}function cA(a){a=a|0;var b=0;b=i;RE(a);i=b;return}function dA(a,b){a=a|0;b=b|0;var d=0,e=0.0,f=0.0,h=0.0,j=0,k=0.0,l=0.0,m=0.0;j=i;c[a+4>>2]=35;c[a+8>>2]=0;g[a+12>>2]=1.0;g[a+16>>2]=1.0;g[a+20>>2]=1.0;g[a+24>>2]=0.0;g[a+44>>2]=.03999999910593033;c[a>>2]=15448;c[a+52>>2]=1;e=+g[b>>2];f=+g[b+4>>2];h=+g[b+8>>2];if(e<f)d=e<h?0:2;else d=f<h?1:2;e=+g[b+(d<<2)>>2]*.10000000149011612;if(e<.03999999910593033){l=+zu(a);h=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);m=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);l=l+ +g[a+28>>2];h=h+ +g[a+32>>2];m=m+ +g[a+36>>2];g[a+44>>2]=e;k=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);f=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);e=m-+Zb[c[(c[a>>2]|0)+48>>2]&15](a);g[a+28>>2]=l-k;g[a+32>>2]=h-f;g[a+36>>2]=e;g[a+40>>2]=0.0;d=c[a>>2]|0}else d=15448|0;h=+Zb[c[d+48>>2]&15](a);f=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);e=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);f=+g[b+4>>2]*+g[a+16>>2]-f;e=+g[b+8>>2]*+g[a+20>>2]-e;g[a+28>>2]=+g[b>>2]*+g[a+12>>2]-h;g[a+32>>2]=f;g[a+36>>2]=e;g[a+40>>2]=0.0;c[a+4>>2]=13;i=j;return}function eA(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0;f=i;k=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);o=k+ +g[a+28>>2];m=k+ +g[a+32>>2];k=k+ +g[a+36>>2];w=+O(+(+g[b>>2]));v=+O(+(+g[b+4>>2]));u=+O(+(+g[b+8>>2]));s=+O(+(+g[b+16>>2]));r=+O(+(+g[b+20>>2]));q=+O(+(+g[b+24>>2]));n=+O(+(+g[b+32>>2]));l=+O(+(+g[b+36>>2]));j=+O(+(+g[b+40>>2]));t=+g[b+48>>2];p=+g[b+52>>2];h=+g[b+56>>2];g[d>>2]=t-(o*w+m*v+k*u);g[d+4>>2]=p-(o*s+m*r+k*q);g[d+8>>2]=h-(o*n+m*l+k*j);g[d+12>>2]=0.0;g[e>>2]=o*w+m*v+k*u+t;g[e+4>>2]=o*s+m*r+k*q+p;g[e+8>>2]=o*n+m*l+k*j+h;g[e+12>>2]=0.0;i=f;return}function fA(a,b,d){a=a|0;b=+b;d=d|0;var e=0.0,f=0.0,h=0,j=0,k=0,l=0.0;k=i;i=i+16|0;c[k+0>>2]=c[a+28>>2];c[k+4>>2]=c[a+32>>2];c[k+8>>2]=c[a+36>>2];c[k+12>>2]=c[a+40>>2];l=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);f=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);e=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);g[k>>2]=l+ +g[k>>2];g[k+4>>2]=f+ +g[k+4>>2];g[k+8>>2]=e+ +g[k+8>>2];j=c[a+52>>2]|0;if((j|0)==2){h=2;a=0}else if(!j){h=0;a=1}else{h=1;a=0}f=+g[k+(a<<2)>>2];e=+g[k+(h<<2)>>2];e=b*.25*(f*f)+b/12.0*(e*(e*4.0));if((j|0)==2){g[d>>2]=e;g[d+4>>2]=e;g[d+8>>2]=b*.5*(f*f);g[d+12>>2]=0.0;i=k;return}else if(!j){g[d>>2]=b*.5*(f*f);g[d+4>>2]=e;g[d+8>>2]=e;g[d+12>>2]=0.0;i=k;return}else{g[d>>2]=e;g[d+4>>2]=b*.5*(f*f);g[d+8>>2]=e;g[d+12>>2]=0.0;i=k;return}}function gA(a,b,c){a=a|0;b=b|0;c=c|0;var d=0.0,e=0.0,f=0.0,h=0.0,j=0.0,k=0;k=i;j=+g[b+32>>2];d=+g[b+28>>2];e=+g[c+4>>2];f=+g[c+8>>2];h=+P(+(e*e+f*f));if(h!=0.0){g[a+4>>2]=e*(j/h);if(+g[c>>2]<0.0)d=-d;g[a>>2]=d;g[a+8>>2]=f*(j/h);i=k;return}else{g[a+4>>2]=j;if(+g[c>>2]<0.0)d=-d;g[a>>2]=d;g[a+8>>2]=0.0;i=k;return}}function hA(a,b,c){a=a|0;b=b|0;c=c|0;var d=0.0,e=0.0,f=0.0,h=0.0,j=0.0,k=0;k=i;j=+g[b+28>>2];d=+g[b+36>>2];e=+g[c>>2];f=+g[c+4>>2];h=+P(+(e*e+f*f));if(h!=0.0){g[a>>2]=e*(j/h);if(+g[c+8>>2]<0.0)d=-d;g[a+8>>2]=d;g[a+4>>2]=f*(j/h);i=k;return}else{g[a>>2]=j;if(+g[c+8>>2]<0.0)d=-d;g[a+8>>2]=d;g[a+4>>2]=0.0;i=k;return}}function iA(a,b,c){a=a|0;b=b|0;c=c|0;var d=0.0,e=0.0,f=0.0,h=0.0,j=0.0,k=0;k=i;j=+g[b+28>>2];d=+g[b+32>>2];e=+g[c>>2];f=+g[c+8>>2];h=+P(+(e*e+f*f));if(h!=0.0){g[a>>2]=e*(j/h);if(+g[c+4>>2]<0.0)d=-d;g[a+4>>2]=d;g[a+8>>2]=f*(j/h);i=k;return}else{g[a>>2]=j;if(+g[c+4>>2]<0.0)d=-d;g[a+4>>2]=d;g[a+8>>2]=0.0;i=k;return}}function jA(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0.0,f=0.0,h=0.0,j=0.0,k=0.0,l=0.0,m=0,n=0;n=i;if((d|0)<=0){i=n;return}m=0;do{h=+g[a+28>>2];e=+g[a+32>>2];f=+g[b+(m<<4)>>2];j=+g[b+(m<<4)+8>>2];l=+P(+(f*f+j*j));if(!(l!=0.0))if(+g[b+(m<<4)+4>>2]<0.0){k=h;f=-e;e=0.0}else{k=h;f=e;e=0.0}else{if(+g[b+(m<<4)+4>>2]<0.0)e=-e;k=f*(h/l);f=e;e=j*(h/l)}g[c+(m<<4)>>2]=k;g[c+(m<<4)+4>>2]=f;g[c+(m<<4)+8>>2]=e;m=m+1|0}while((m|0)!=(d|0));i=n;return}function kA(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0.0,f=0.0,h=0.0,j=0.0,k=0.0,l=0.0,m=0,n=0;n=i;if((d|0)<=0){i=n;return}m=0;do{h=+g[a+28>>2];e=+g[a+36>>2];f=+g[b+(m<<4)>>2];j=+g[b+(m<<4)+4>>2];k=+P(+(f*f+j*j));if(!(k!=0.0))if(+g[b+(m<<4)+8>>2]<0.0){l=h;f=0.0;e=-e}else{l=h;f=0.0}else{if(+g[b+(m<<4)+8>>2]<0.0)e=-e;l=f*(h/k);f=j*(h/k)}g[c+(m<<4)>>2]=l;g[c+(m<<4)+4>>2]=f;g[c+(m<<4)+8>>2]=e;m=m+1|0}while((m|0)!=(d|0));i=n;return}function lA(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0.0,f=0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0,o=0;o=i;if((d|0)<=0){i=o;return}n=0;do{k=+g[a+32>>2];e=+g[a+28>>2];f=b+(n<<4)|0;h=+g[b+(n<<4)+4>>2];l=+g[b+(n<<4)+8>>2];m=+P(+(h*h+l*l));if(!(m!=0.0))if(+g[f>>2]<0.0){j=-e;h=k;e=0.0}else{j=e;h=k;e=0.0}else{if(+g[f>>2]<0.0)e=-e;j=e;h=h*(k/m);e=l*(k/m)}g[c+(n<<4)>>2]=j;g[c+(n<<4)+4>>2]=h;g[c+(n<<4)+8>>2]=e;n=n+1|0}while((n|0)!=(d|0));i=o;return}function mA(a,b){a=a|0;b=+b;var d=0,e=0.0,f=0.0,h=0.0,j=0.0,k=0.0;d=i;j=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);f=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);k=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);j=j+ +g[a+28>>2];f=f+ +g[a+32>>2];k=k+ +g[a+36>>2];g[a+44>>2]=b;h=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);e=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);b=k-+Zb[c[(c[a>>2]|0)+48>>2]&15](a);g[a+28>>2]=j-h;g[a+32>>2]=f-e;g[a+36>>2]=b;g[a+40>>2]=0.0;i=d;return}function nA(a){a=a|0;var b=0.0,d=0.0,e=0;e=i;d=+g[a+28>>2];b=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);+Zb[c[(c[a>>2]|0)+48>>2]&15](a);+Zb[c[(c[a>>2]|0)+48>>2]&15](a);i=e;return +(d+b)}function oA(a){a=a|0;return 15872}function pA(a){a=a|0;var b=0;b=i;if(!a){i=b;return}c[5110]=(c[5110]|0)+1;RE(c[a+-4>>2]|0);i=b;return}function qA(a){a=a|0;var b=0.0,d=0.0,e=0;e=i;d=+g[a+32>>2];+Zb[c[(c[a>>2]|0)+48>>2]&15](a);b=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);+Zb[c[(c[a>>2]|0)+48>>2]&15](a);i=e;return +(d+b)}function rA(a){a=a|0;return 15888}function sA(a){a=a|0;var b=0;b=i;if(!a){i=b;return}c[5110]=(c[5110]|0)+1;RE(c[a+-4>>2]|0);i=b;return}function tA(a){a=a|0;var b=0.0,d=0.0,e=0;e=i;d=+g[a+28>>2];b=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);+Zb[c[(c[a>>2]|0)+48>>2]&15](a);+Zb[c[(c[a>>2]|0)+48>>2]&15](a);i=e;return +(d+b)}function uA(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0.0,h=0.0,j=0.0,k=0.0,l=0.0;e=i;i=i+16|0;pc[c[(c[b>>2]|0)+68>>2]&127](e,b,d);c[a+0>>2]=c[e+0>>2];c[a+4>>2]=c[e+4>>2];c[a+8>>2]=c[e+8>>2];c[a+12>>2]=c[e+12>>2];if(!(+Zb[c[(c[b>>2]|0)+48>>2]&15](b)!=0.0)){i=e;return}l=+g[d>>2];j=+g[d+4>>2];h=+g[d+8>>2];f=l*l+j*j+h*h<1.4210854715202004e-14?-1.0:h;k=l*l+j*j+h*h<1.4210854715202004e-14?-1.0:j;l=l*l+j*j+h*h<1.4210854715202004e-14?-1.0:l;h=1.0/+P(+(f*f+(l*l+k*k)));j=+Zb[c[(c[b>>2]|0)+48>>2]&15](b);g[a>>2]=h*l*j+ +g[a>>2];g[a+4>>2]=j*(h*k)+ +g[a+4>>2];g[a+8>>2]=j*(h*f)+ +g[a+8>>2];i=e;return}function vA(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,h=0;f=i;e=ec[c[(c[d>>2]|0)+40>>2]&31](d,a)|0;h=ec[c[(c[d>>2]|0)+28>>2]&31](d,e)|0;c[b>>2]=h;if(h)Lb[c[(c[d>>2]|0)+48>>2]&127](d,e);c[b+4>>2]=c[a+4>>2];g[b+28>>2]=+g[a+28>>2];g[b+32>>2]=+g[a+32>>2];g[b+36>>2]=+g[a+36>>2];g[b+40>>2]=+g[a+40>>2];g[b+12>>2]=+g[a+12>>2];g[b+16>>2]=+g[a+16>>2];g[b+20>>2]=+g[a+20>>2];g[b+24>>2]=+g[a+24>>2];g[b+44>>2]=+g[a+44>>2];c[b+52>>2]=c[a+52>>2];i=f;return 15904}function wA(a){a=a|0;return 60}function xA(a,b){a=a|0;b=b|0;c[a+0>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;c[a+12>>2]=0;g[a+(c[b+52>>2]<<2)>>2]=1.0;return}function yA(a){a=a|0;return 15928}function zA(a,b){a=a|0;b=b|0;var d=0,e=0.0,f=0.0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0;d=i;m=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);j=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);e=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);o=(m+ +g[a+28>>2])/+g[a+12>>2];l=(j+ +g[a+32>>2])/+g[a+16>>2];h=(e+ +g[a+36>>2])/+g[a+20>>2];n=+O(+(+g[b>>2]));k=+O(+(+g[b+4>>2]));f=+O(+(+g[b+8>>2]));g[a+12>>2]=n;g[a+16>>2]=k;g[a+20>>2]=f;g[a+24>>2]=0.0;g[a+28>>2]=o*n-m;g[a+32>>2]=l*k-j;g[a+36>>2]=h*f-e;g[a+40>>2]=0.0;i=d;return}function AA(a){a=a|0;var b=0;b=i;if(!a){i=b;return}c[5110]=(c[5110]|0)+1;RE(c[a+-4>>2]|0);i=b;return}function BA(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,h=0,j=0,k=0;h=i;g[b+4>>2]=1.0;g[b+8>>2]=1.0;g[b+12>>2]=1.0;g[b+16>>2]=0.0;a[b+36>>0]=1;c[b+32>>2]=0;c[b+24>>2]=0;c[b+28>>2]=0;c[b+48>>2]=0;c[b>>2]=15952;a[b+100>>0]=1;c[b+96>>2]=0;c[b+88>>2]=0;c[b+92>>2]=0;a[b+120>>0]=1;c[b+116>>2]=0;c[b+108>>2]=0;c[b+112>>2]=0;a[b+140>>0]=1;c[b+136>>2]=0;c[b+128>>2]=0;c[b+132>>2]=0;a[b+160>>0]=1;c[b+156>>2]=0;c[b+148>>2]=0;c[b+152>>2]=0;a[b+164>>0]=d&1;a[b+165>>0]=e&1;g[b+168>>2]=0.0;c[5108]=(c[5108]|0)+1;d=QE(51)|0;if(!d)f=0;else{c[(d+19&-16)+-4>>2]=d;f=d+19&-16}e=c[b+24>>2]|0;if((e|0)>0){d=0;do{j=f+(d<<5)|0;k=(c[b+32>>2]|0)+(d<<5)|0;c[j+0>>2]=c[k+0>>2];c[j+4>>2]=c[k+4>>2];c[j+8>>2]=c[k+8>>2];c[j+12>>2]=c[k+12>>2];c[j+16>>2]=c[k+16>>2];c[j+20>>2]=c[k+20>>2];c[j+24>>2]=c[k+24>>2];c[j+28>>2]=c[k+28>>2];d=d+1|0}while((d|0)!=(e|0))}d=c[b+32>>2]|0;if(d){if(a[b+36>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}c[b+32>>2]=0}a[b+36>>0]=1;c[b+32>>2]=f;c[b+28>>2]=1;d=c[b+24>>2]|0;c[f+(d<<5)>>2]=0;c[f+(d<<5)+4>>2]=0;c[f+(d<<5)+8>>2]=12;c[f+(d<<5)+12>>2]=0;c[f+(d<<5)+16>>2]=0;c[f+(d<<5)+20>>2]=16;c[f+(d<<5)+24>>2]=2;c[f+(d<<5)+28>>2]=0;c[b+24>>2]=(c[b+24>>2]|0)+1;if(!(a[b+164>>0]|0)){d=c[b+32>>2]|0;c[d>>2]=(c[b+148>>2]|0)/3|0;c[d+4>>2]=0;c[d+24>>2]=3;c[d+8>>2]=6}else{d=c[b+32>>2]|0;c[d>>2]=(c[b+128>>2]|0)/3|0;c[d+4>>2]=0;c[d+24>>2]=2;c[d+8>>2]=12}if(!(a[b+165>>0]|0)){e=12;b=(c[b+108>>2]|0)/3|0;f=d+12|0;c[f>>2]=b;f=d+16|0;c[f>>2]=0;d=d+20|0;c[d>>2]=e;i=h;return}else{e=16;b=c[b+88>>2]|0;f=d+12|0;c[f>>2]=b;f=d+16|0;c[f>>2]=0;d=d+20|0;c[d>>2]=e;i=h;return}}function CA(d,e){d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0;m=i;if(!(a[d+164>>0]|0)){f=c[d+148>>2]|0;if((f|0)==(c[d+152>>2]|0)?(l=(f|0)==0?1:f<<1,(f|0)<(l|0)):0){if(!l)h=0;else{c[5108]=(c[5108]|0)+1;f=QE((l<<1)+19|0)|0;if(!f)h=0;else{c[(f+19&-16)+-4>>2]=f;h=f+19&-16}f=c[d+148>>2]|0}if((f|0)>0){j=0;do{g=h+(j<<1)|0;if(g)b[g>>1]=b[(c[d+156>>2]|0)+(j<<1)>>1]|0;j=j+1|0}while((j|0)!=(f|0))}g=c[d+156>>2]|0;if(g){if(a[d+160>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[g+-4>>2]|0);f=c[d+148>>2]|0}c[d+156>>2]=0}a[d+160>>0]=1;c[d+156>>2]=h;c[d+152>>2]=l}g=c[d+156>>2]|0;h=g+(f<<1)|0;if(h)b[h>>1]=e;c[d+148>>2]=f+1;c[(c[d+32>>2]|0)+4>>2]=g;i=m;return}else{f=c[d+128>>2]|0;if((f|0)==(c[d+132>>2]|0)?(k=(f|0)==0?1:f<<1,(f|0)<(k|0)):0){if(!k)h=0;else{c[5108]=(c[5108]|0)+1;f=QE((k<<2|3)+16|0)|0;if(!f)h=0;else{c[(f+19&-16)+-4>>2]=f;h=f+19&-16}f=c[d+128>>2]|0}if((f|0)>0){j=0;do{g=h+(j<<2)|0;if(g)c[g>>2]=c[(c[d+136>>2]|0)+(j<<2)>>2];j=j+1|0}while((j|0)!=(f|0))}g=c[d+136>>2]|0;if(g){if(a[d+140>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[g+-4>>2]|0)}c[d+136>>2]=0}a[d+140>>0]=1;c[d+136>>2]=h;c[d+132>>2]=k;f=c[d+128>>2]|0}h=c[d+136>>2]|0;g=h+(f<<2)|0;if(g){c[g>>2]=e;f=c[d+128>>2]|0}c[d+128>>2]=f+1;c[(c[d+32>>2]|0)+4>>2]=h;i=m;return}}function DA(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,h=0,j=0,k=0,l=0.0,m=0.0,n=0.0,o=0.0,p=0,q=0,r=0.0,s=0.0,t=0.0;q=i;if(a[b+165>>0]|0){j=c[b+88>>2]|0;a:do if((j|0)>0&e){k=c[b+96>>2]|0;l=+g[d>>2];o=+g[d+4>>2];n=+g[d+8>>2];m=+g[b+168>>2];f=0;while(1){t=+g[k+(f<<4)>>2]-l;s=+g[k+(f<<4)+4>>2]-o;r=+g[k+(f<<4)+8>>2]-n;if(t*t+s*s+r*r<=m)break;f=f+1|0;if((f|0)>=(j|0))break a}i=q;return f|0}while(0);f=(c[b+32>>2]|0)+12|0;c[f>>2]=(c[f>>2]|0)+1;if((j|0)==(c[b+92>>2]|0)?(p=(j|0)==0?1:j<<1,(j|0)<(p|0)):0){if(!p){f=j;h=0}else{c[5108]=(c[5108]|0)+1;f=QE((p<<4|3)+16|0)|0;if(!f)h=0;else{c[(f+19&-16)+-4>>2]=f;h=f+19&-16}f=c[b+88>>2]|0}if((f|0)>0){e=0;do{j=h+(e<<4)|0;k=(c[b+96>>2]|0)+(e<<4)|0;c[j+0>>2]=c[k+0>>2];c[j+4>>2]=c[k+4>>2];c[j+8>>2]=c[k+8>>2];c[j+12>>2]=c[k+12>>2];e=e+1|0}while((e|0)!=(f|0))}f=c[b+96>>2]|0;if(f){if(a[b+100>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[f+-4>>2]|0)}c[b+96>>2]=0}a[b+100>>0]=1;c[b+96>>2]=h;c[b+92>>2]=p;f=c[b+88>>2]|0}else f=j;f=(c[b+96>>2]|0)+(f<<4)|0;c[f+0>>2]=c[d+0>>2];c[f+4>>2]=c[d+4>>2];c[f+8>>2]=c[d+8>>2];c[f+12>>2]=c[d+12>>2];f=c[b+88>>2]|0;c[b+88>>2]=f+1;c[(c[b+32>>2]|0)+16>>2]=c[b+96>>2];i=q;return f|0}h=c[b+108>>2]|0;b:do if((h|0)>0&e){k=c[b+116>>2]|0;l=+g[d>>2];m=+g[d+4>>2];n=+g[d+8>>2];o=+g[b+168>>2];e=0;while(1){t=+g[k+(e<<2)>>2]-l;s=+g[k+(e+1<<2)>>2]-m;r=+g[k+(e+2<<2)>>2]-n;j=e+3|0;if(t*t+s*s+r*r<=o)break;if((j|0)<(h|0))e=j;else{p=d;break b}}f=(e|0)/3|0;i=q;return f|0}else p=d;while(0);f=c[b+112>>2]|0;if((h|0)==(f|0)){f=(h|0)==0?1:h<<1;if((h|0)<(f|0)){if(!f)e=0;else{c[5108]=(c[5108]|0)+1;h=QE((f<<2|3)+16|0)|0;if(!h)e=0;else{c[(h+19&-16)+-4>>2]=h;e=h+19&-16}h=c[b+108>>2]|0}if((h|0)>0){k=0;do{j=e+(k<<2)|0;if(j)g[j>>2]=+g[(c[b+116>>2]|0)+(k<<2)>>2];k=k+1|0}while((k|0)!=(h|0))}j=c[b+116>>2]|0;if(j){if(a[b+120>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[j+-4>>2]|0);h=c[b+108>>2]|0}c[b+116>>2]=0}a[b+120>>0]=1;c[b+116>>2]=e;c[b+112>>2]=f;k=h}else{k=h;f=h}}else k=h;h=c[b+116>>2]|0;j=h+(k<<2)|0;if(j)g[j>>2]=+g[p>>2];e=k+1|0;c[b+108>>2]=e;if((e|0)==(f|0)){k=(f|0)==0?1:f<<1;if((f|0)<(k|0)){if(!k)h=0;else{c[5108]=(c[5108]|0)+1;f=QE((k<<2|3)+16|0)|0;if(!f)h=0;else{c[(f+19&-16)+-4>>2]=f;h=f+19&-16}f=c[b+108>>2]|0}if((f|0)>0){e=0;do{j=h+(e<<2)|0;if(j)g[j>>2]=+g[(c[b+116>>2]|0)+(e<<2)>>2];e=e+1|0}while((e|0)!=(f|0))}e=c[b+116>>2]|0;if(e){if(a[b+120>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[e+-4>>2]|0);f=c[b+108>>2]|0}c[b+116>>2]=0}a[b+120>>0]=1;c[b+116>>2]=h;c[b+112>>2]=k;j=f;f=k}else j=f}else j=e;e=h+(j<<2)|0;if(e)g[e>>2]=+g[d+4>>2];e=j+1|0;c[b+108>>2]=e;if((e|0)==(f|0)){k=(f|0)==0?1:f<<1;if((f|0)<(k|0)){if(!k)h=0;else{c[5108]=(c[5108]|0)+1;f=QE((k<<2|3)+16|0)|0;if(!f)h=0;else{c[(f+19&-16)+-4>>2]=f;h=f+19&-16}f=c[b+108>>2]|0}if((f|0)>0){e=0;do{j=h+(e<<2)|0;if(j)g[j>>2]=+g[(c[b+116>>2]|0)+(e<<2)>>2];e=e+1|0}while((e|0)!=(f|0))}e=c[b+116>>2]|0;if(e){if(a[b+120>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[e+-4>>2]|0);f=c[b+108>>2]|0}c[b+116>>2]=0}a[b+120>>0]=1;c[b+116>>2]=h;c[b+112>>2]=k;j=h}else j=h}else{j=h;f=e}h=j+(f<<2)|0;if(h)g[h>>2]=+g[d+8>>2];f=f+1|0;c[b+108>>2]=f;d=c[b+32>>2]|0;c[d+12>>2]=(c[d+12>>2]|0)+1;c[d+16>>2]=j;f=((f|0)/3|0)+-1|0;i=q;return f|0}function EA(b,d){b=b|0;d=d|0;var e=0,f=0,h=0,j=0,k=0,l=0;k=i;if(a[b+165>>0]|0){if((c[b+92>>2]|0)>=(d|0)){i=k;return}if((d|0)!=0?(c[5108]=(c[5108]|0)+1,f=QE((d<<4|3)+16|0)|0,(f|0)!=0):0){c[(f+19&-16)+-4>>2]=f;h=f+19&-16}else h=0;f=c[b+88>>2]|0;if((f|0)>0){e=0;do{j=h+(e<<4)|0;l=(c[b+96>>2]|0)+(e<<4)|0;c[j+0>>2]=c[l+0>>2];c[j+4>>2]=c[l+4>>2];c[j+8>>2]=c[l+8>>2];c[j+12>>2]=c[l+12>>2];e=e+1|0}while((e|0)!=(f|0))}e=c[b+96>>2]|0;if(e){if(a[b+100>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[e+-4>>2]|0)}c[b+96>>2]=0}a[b+100>>0]=1;c[b+96>>2]=h;c[b+92>>2]=d;i=k;return}if((c[b+112>>2]|0)>=(d|0)){i=k;return}if((d|0)!=0?(c[5108]=(c[5108]|0)+1,e=QE((d<<2|3)+16|0)|0,(e|0)!=0):0){c[(e+19&-16)+-4>>2]=e;j=e+19&-16}else j=0;f=c[b+108>>2]|0;if((f|0)>0){h=0;do{e=j+(h<<2)|0;if(e)g[e>>2]=+g[(c[b+116>>2]|0)+(h<<2)>>2];h=h+1|0}while((h|0)!=(f|0))}e=c[b+116>>2]|0;if(e){if(a[b+120>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[e+-4>>2]|0)}c[b+116>>2]=0}a[b+120>>0]=1;c[b+116>>2]=j;c[b+112>>2]=d;i=k;return}function FA(d,e){d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0;k=i;if(!(a[d+164>>0]|0)){if((c[d+152>>2]|0)>=(e|0)){i=k;return}if((e|0)!=0?(c[5108]=(c[5108]|0)+1,f=QE((e<<1)+19|0)|0,(f|0)!=0):0){c[(f+19&-16)+-4>>2]=f;j=f+19&-16}else j=0;g=c[d+148>>2]|0;if((g|0)>0){h=0;do{f=j+(h<<1)|0;if(f)b[f>>1]=b[(c[d+156>>2]|0)+(h<<1)>>1]|0;h=h+1|0}while((h|0)!=(g|0))}f=c[d+156>>2]|0;if(f){if(a[d+160>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[f+-4>>2]|0)}c[d+156>>2]=0}a[d+160>>0]=1;c[d+156>>2]=j;c[d+152>>2]=e;i=k;return}else{if((c[d+132>>2]|0)>=(e|0)){i=k;return}if((e|0)!=0?(c[5108]=(c[5108]|0)+1,g=QE((e<<2|3)+16|0)|0,(g|0)!=0):0){c[(g+19&-16)+-4>>2]=g;j=g+19&-16}else j=0;g=c[d+128>>2]|0;if((g|0)>0){h=0;do{f=j+(h<<2)|0;if(f)c[f>>2]=c[(c[d+136>>2]|0)+(h<<2)>>2];h=h+1|0}while((h|0)!=(g|0))}f=c[d+136>>2]|0;if(f){if(a[d+140>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[f+-4>>2]|0)}c[d+136>>2]=0}a[d+140>>0]=1;c[d+136>>2]=j;c[d+132>>2]=e;i=k;return}}function GA(a){a=a|0;return 28}function HA(a){a=a|0;return c[a+24>>2]|0}function IA(a,b){a=a|0;b=b|0;return}function JA(a,b){a=a|0;b=b|0;return}function KA(a){a=a|0;var b=0;b=i;LA(a);if(!a){i=b;return}c[5110]=(c[5110]|0)+1;RE(c[a+-4>>2]|0);i=b;return}function LA(b){b=b|0;var d=0,e=0;e=i;c[b>>2]=15952;d=c[b+156>>2]|0;if(d){if(a[b+160>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}c[b+156>>2]=0}a[b+160>>0]=1;c[b+156>>2]=0;c[b+148>>2]=0;c[b+152>>2]=0;d=c[b+136>>2]|0;if(d){if(a[b+140>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}c[b+136>>2]=0}a[b+140>>0]=1;c[b+136>>2]=0;c[b+128>>2]=0;c[b+132>>2]=0;d=c[b+116>>2]|0;if(d){if(a[b+120>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}c[b+116>>2]=0}a[b+120>>0]=1;c[b+116>>2]=0;c[b+108>>2]=0;c[b+112>>2]=0;d=c[b+96>>2]|0;if(d){if(a[b+100>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}c[b+96>>2]=0}a[b+100>>0]=1;c[b+96>>2]=0;c[b+88>>2]=0;c[b+92>>2]=0;c[b>>2]=20040;d=c[b+32>>2]|0;if(!d){a[b+36>>0]=1;c[b+32>>2]=0;c[b+24>>2]=0;d=b+28|0;c[d>>2]=0;i=e;return}if(a[b+36>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}c[b+32>>2]=0;a[b+36>>0]=1;c[b+32>>2]=0;c[b+24>>2]=0;d=b+28|0;c[d>>2]=0;i=e;return}function MA(d,f,h,j,k,l){d=d|0;f=f|0;h=h|0;j=j|0;k=k|0;l=l|0;var m=0,n=0,o=0.0,p=0.0,q=0.0;n=i;c[d>>2]=16240;b[d+4>>1]=-2;b[d+6>>1]=-1;c[d+92>>2]=k;c[d+96>>2]=0;a[d+100>>0]=0;c[d+104>>2]=0;c[d+108>>2]=0;if(!k){c[5108]=(c[5108]|0)+1;k=QE(95)|0;if((k|0)!=0?(c[(k+19&-16)+-4>>2]=k,(k+19&-16|0)!=0):0){wB(k+19&-16);k=k+19&-16}else k=0;c[d+92>>2]=k;a[d+100>>0]=1}if(!l){c[5108]=(c[5108]|0)+1;k=QE(43)|0;if((k|0)!=0?(m=k+19&-16,c[m+-4>>2]=k,(k+19&-16|0)!=0):0){c[m+0>>2]=0;c[m+4>>2]=0;c[m+8>>2]=0;c[m+12>>2]=0;c[m+16>>2]=0;c[m+20>>2]=0;c[(k+19&-16)>>2]=16304;a[m+20>>0]=1;c[m+16>>2]=0;c[m+8>>2]=0;c[m+12>>2]=0;m=k+19&-16}else m=0;c[d+112>>2]=m;c[5108]=(c[5108]|0)+1;m=QE(215)|0;if((m|0)!=0?(c[(m+19&-16)+-4>>2]=m,(m+19&-16|0)!=0):0){TB(m+19&-16,c[d+112>>2]|0);m=m+19&-16}else m=0;c[d+108>>2]=m;a[m+193>>0]=1};c[d+8>>2]=c[f+0>>2];c[d+12>>2]=c[f+4>>2];c[d+16>>2]=c[f+8>>2];c[d+20>>2]=c[f+12>>2];c[d+24>>2]=c[h+0>>2];c[d+28>>2]=c[h+4>>2];c[d+32>>2]=c[h+8>>2];c[d+36>>2]=c[h+12>>2];q=+(e[d+6>>1]|0);p=q/(+g[d+28>>2]-+g[d+12>>2]);o=q/(+g[d+32>>2]-+g[d+16>>2]);g[d+40>>2]=q/(+g[d+24>>2]-+g[d+8>>2]);g[d+44>>2]=p;g[d+48>>2]=o;g[d+52>>2]=0.0;h=(j&65535)+1&65535;c[5108]=(c[5108]|0)+1;m=QE(h<<6|19)|0;if(!m)l=0;else{c[(m+19&-16)+-4>>2]=m;l=m+19&-16}if(h){m=l+(h<<6)|0;k=l;do{c[k>>2]=0;c[k+8>>2]=0;k=k+64|0}while((k|0)!=(m|0))}c[d+60>>2]=l;b[d+58>>1]=(j&65535)+1;b[d+56>>1]=0;b[d+64>>1]=1;if(h>>>0>1){m=1;k=1;do{b[l+(m<<6)+48>>1]=m+1;k=k+1<<16>>16;m=k&65535}while(m>>>0<h>>>0)}b[l+(h+-1<<6)+48>>1]=0;c[5108]=(c[5108]|0)+1;m=QE((h<<3|3)+16|0)|0;if(!m)m=0;else{c[(m+19&-16)+-4>>2]=m;m=m+19&-16}c[d+80>>2]=m;c[d+68>>2]=m;c[5108]=(c[5108]|0)+1;m=QE((h<<3|3)+16|0)|0;if(!m)m=0;else{c[(m+19&-16)+-4>>2]=m;m=m+19&-16}c[d+84>>2]=m;c[d+72>>2]=m;c[5108]=(c[5108]|0)+1;m=QE((h<<3|3)+16|0)|0;if(!m){l=0;m=d+88|0;c[m>>2]=l;m=d+76|0;c[m>>2]=l;l=c[d+60>>2]|0;c[l>>2]=0;k=l+48|0;b[k>>1]=0;k=l+54|0;b[k>>1]=1;k=c[d+68>>2]|0;b[k>>1]=0;h=k+2|0;b[h>>1]=0;h=b[d+6>>1]|0;f=k+4|0;b[f>>1]=h;k=k+6|0;b[k>>1]=0;k=l+50|0;b[k>>1]=0;k=l+56|0;b[k>>1]=1;k=c[d+72>>2]|0;b[k>>1]=0;f=k+2|0;b[f>>1]=0;f=b[d+6>>1]|0;h=k+4|0;b[h>>1]=f;k=k+6|0;b[k>>1]=0;k=l+52|0;b[k>>1]=0;l=l+58|0;b[l>>1]=1;m=c[m>>2]|0;b[m>>1]=0;l=m+2|0;b[l>>1]=0;l=b[d+6>>1]|0;k=m+4|0;b[k>>1]=l;m=m+6|0;b[m>>1]=0;c[d>>2]=16064;i=n;return}c[(m+19&-16)+-4>>2]=m;l=m+19&-16;m=d+88|0;c[m>>2]=l;m=d+76|0;c[m>>2]=l;l=c[d+60>>2]|0;c[l>>2]=0;k=l+48|0;b[k>>1]=0;k=l+54|0;b[k>>1]=1;k=c[d+68>>2]|0;b[k>>1]=0;h=k+2|0;b[h>>1]=0;h=b[d+6>>1]|0;f=k+4|0;b[f>>1]=h;k=k+6|0;b[k>>1]=0;k=l+50|0;b[k>>1]=0;k=l+56|0;b[k>>1]=1;k=c[d+72>>2]|0;b[k>>1]=0;f=k+2|0;b[f>>1]=0;f=b[d+6>>1]|0;h=k+4|0;b[h>>1]=f;k=k+6|0;b[k>>1]=0;k=l+52|0;b[k>>1]=0;l=l+58|0;b[l>>1]=1;m=c[m>>2]|0;b[m>>1]=0;l=m+2|0;b[l>>1]=0;l=b[d+6>>1]|0;k=m+4|0;b[k>>1]=l;m=m+6|0;b[m>>1]=0;c[d>>2]=16064;i=n;return}function NA(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0;k=i;j=c[b+4>>2]|0;if(!((j|0)<=(d|0)&(j|0)<(d|0))){c[b+4>>2]=d;i=k;return}if((c[b+8>>2]|0)<(d|0)){if(!d){h=j;g=0}else{c[5108]=(c[5108]|0)+1;f=QE((d<<4|3)+16|0)|0;if(!f)g=0;else{c[(f+19&-16)+-4>>2]=f;g=f+19&-16}h=c[b+4>>2]|0}if((h|0)>0){f=0;do{l=c[b+12>>2]|0;c[g+(f<<4)>>2]=c[l+(f<<4)>>2];c[g+(f<<4)+4>>2]=c[l+(f<<4)+4>>2];c[g+(f<<4)+8>>2]=c[l+(f<<4)+8>>2];c[g+(f<<4)+12>>2]=c[l+(f<<4)+12>>2];f=f+1|0}while((f|0)!=(h|0))}f=c[b+12>>2]|0;if(f){if(a[b+16>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[f+-4>>2]|0)}c[b+12>>2]=0}a[b+16>>0]=1;c[b+12>>2]=g;c[b+8>>2]=d;g=b+12|0}else g=b+12|0;f=j;do{h=c[g>>2]|0;c[h+(f<<4)>>2]=c[e>>2];c[h+(f<<4)+4>>2]=c[e+4>>2];c[h+(f<<4)+8>>2]=c[e+8>>2];c[h+(f<<4)+12>>2]=c[e+12>>2];f=f+1|0}while((f|0)!=(d|0));c[b+4>>2]=d;i=k;return}function OA(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0;t=i;while(1){r=(b+d|0)/2|0;s=c[a+12>>2]|0;p=c[s+(r<<4)>>2]|0;q=c[s+(r<<4)+4>>2]|0;r=c[s+(r<<4)+8>>2]|0;e=b;f=d;while(1){a:do if(!p)while(1){k=c[s+(e<<4)>>2]|0;if(!k)g=-1;else g=c[k+12>>2]|0;l=c[s+(e<<4)+4>>2]|0;if(!l)h=-1;else h=c[l+12>>2]|0;if(!q)j=-1;else j=c[q+12>>2]|0;do if((g|0)<=-1){g=(k|0)==0&(h|0)>(j|0);if(g|(k|0)==0^1)if(g)break;else break a;if((l|0)!=(q|0))break a;if((c[s+(e<<4)+8>>2]|0)>>>0<=r>>>0)break a}while(0);e=e+1|0}else{o=c[p+12>>2]|0;while(1){m=c[s+(e<<4)>>2]|0;if(!m)k=-1;else k=c[m+12>>2]|0;l=c[s+(e<<4)+4>>2]|0;if(!l)j=-1;else j=c[l+12>>2]|0;if(!q)h=-1;else h=c[q+12>>2]|0;do if((k|0)<=(o|0)){g=(m|0)==(p|0)&(j|0)>(h|0);if(g|(m|0)==(p|0)^1)if(g)break;else break a;if((l|0)!=(q|0))break a;if((c[s+(e<<4)+8>>2]|0)>>>0<=r>>>0)break a}while(0);e=e+1|0}}while(0);b:while(1){if(!p)m=-1;else m=c[p+12>>2]|0;n=c[s+(f<<4)>>2]|0;if(!n)k=-1;else k=c[n+12>>2]|0;if(!q)j=-1;else j=c[q+12>>2]|0;o=c[s+(f<<4)+4>>2]|0;if(!o)h=-1;else h=c[o+12>>2]|0;do if((m|0)<=(k|0)){g=(p|0)==(n|0)&(j|0)>(h|0);if(g|(p|0)==(n|0)^1)if(g)break;else break b;if((q|0)!=(o|0))break b;if(r>>>0<=(c[s+(f<<4)+8>>2]|0)>>>0)break b}while(0);f=f+-1|0}if((e|0)<=(f|0)){n=s+(e<<4)|0;j=c[n>>2]|0;k=c[s+(e<<4)+8>>2]|0;m=c[s+(e<<4)+12>>2]|0;h=s+(f<<4)|0;c[n+0>>2]=c[h+0>>2];c[n+4>>2]=c[h+4>>2];c[n+8>>2]=c[h+8>>2];c[n+12>>2]=c[h+12>>2];n=c[a+12>>2]|0;c[n+(f<<4)>>2]=j;c[n+(f<<4)+4>>2]=l;c[n+(f<<4)+8>>2]=k;c[n+(f<<4)+12>>2]=m;e=e+1|0;f=f+-1|0}if((e|0)>(f|0))break;s=c[a+12>>2]|0}if((f|0)>(b|0))OA(a,b,f);if((e|0)<(d|0))b=e;else break}i=t;return}function PA(a){a=a|0;return}function QA(a,d){a=a|0;d=d|0;var e=0,f=0,g=0,h=0;h=i;if(b[a+56>>1]|0){i=h;return}b[a+64>>1]=1;d=b[a+58>>1]|0;g=c[a+60>>2]|0;if((d&65535)>1){e=1;d=1;while(1){b[g+(e<<6)+48>>1]=e+1;f=d+1<<16>>16;d=b[a+58>>1]|0;if((f&65535)<(d&65535)){e=f&65535;d=f}else break}}b[g+((d&65535)+-1<<6)+48>>1]=0;i=h;return}function RA(a,b,d){a=a|0;b=b|0;d=d|0;c[b+0>>2]=c[a+8>>2];c[b+4>>2]=c[a+12>>2];c[b+8>>2]=c[a+16>>2];c[b+12>>2]=c[a+20>>2];c[d+0>>2]=c[a+24>>2];c[d+4>>2]=c[a+28>>2];c[d+8>>2]=c[a+32>>2];c[d+12>>2]=c[a+36>>2];return}function SA(a){a=a|0;return c[a+92>>2]|0}function TA(a){a=a|0;return c[a+92>>2]|0}function UA(a,b){a=a|0;b=b|0;var d=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;r=i;i=i+32|0;o=c[a+92>>2]|0;if(!(Nb[c[(c[o>>2]|0)+56>>2]&127](o)|0)){i=r;return}q=c[a+92>>2]|0;q=Nb[c[(c[q>>2]|0)+28>>2]&127](q)|0;d=c[q+4>>2]|0;if((d|0)>1){OA(q,0,d+-1|0);d=c[q+4>>2]|0}d=d-(c[a+104>>2]|0)|0;c[r+16>>2]=0;c[r+20>>2]=0;c[r+24>>2]=0;c[r+28>>2]=0;NA(q,d,r+16|0);c[a+104>>2]=0;d=c[q+4>>2]|0;if((d|0)>0){g=0;f=0;p=0;j=0;while(1){m=c[q+12>>2]|0;l=m+(p<<4)|0;h=c[l>>2]|0;m=m+(p<<4)+4|0;o=c[m>>2]|0;if((h|0)==(g|0))if((o|0)==(j|0)){h=j;n=12}else n=8;else{g=h;n=8}a:do if((n|0)==8){n=0;h=g+54|0;k=g+48|0;j=0;while(1){if((e[h+(j<<1)>>1]|0)<(e[o+48+(j<<1)>>1]|0)){h=o;n=12;break a}if((e[o+54+(j<<1)>>1]|0)<(e[k+(j<<1)>>1]|0)){h=o;n=12;break a}j=j+1|0;if((j|0)>=3){h=o;break}}}while(0);if((n|0)==12){f=c[a+92>>2]|0;pc[c[(c[f>>2]|0)+32>>2]&127](f,l,b);c[l>>2]=0;c[m>>2]=0;f=(c[a+104>>2]|0)+1|0;c[a+104>>2]=f;c[4116]=(c[4116]|0)+-1;d=c[q+4>>2]|0}p=p+1|0;if((p|0)>=(d|0))break;else j=h}if((d|0)>1){OA(q,0,d+-1|0);f=c[a+104>>2]|0;d=c[q+4>>2]|0}}else f=0;c[r+0>>2]=0;c[r+4>>2]=0;c[r+8>>2]=0;c[r+12>>2]=0;NA(q,d-f|0,r);c[a+104>>2]=0;i=r;return}function VA(a,d,f,h){a=a|0;d=d|0;f=f|0;h=h|0;var j=0,k=0,l=0,m=0,n=0,o=0;o=i;j=c[a+108>>2]|0;if(j){tc[c[(c[j>>2]|0)+28>>2]&127](j,d,f,h);i=o;return}j=b[a+56>>1]|0;if((j&65535)<<1>>>0<=1){i=o;return}l=1;n=1;do{k=c[a+68>>2]|0;if(b[k+(l<<2)>>1]&1){m=c[a+60>>2]|0;l=e[k+(l<<2)+2>>1]|0;if(!(+g[d>>2]>+g[m+(l<<6)+32>>2])?!(+g[f>>2]<+g[m+(l<<6)+16>>2]):0)k=1;else k=0;if(!(!(+g[d+8>>2]>+g[m+(l<<6)+40>>2])?!(+g[f+8>>2]<+g[m+(l<<6)+24>>2]):0))k=0;if(!(+g[d+4>>2]>+g[m+(l<<6)+36>>2])?!(+g[f+4>>2]<+g[m+(l<<6)+20>>2]|k^1):0){ec[c[(c[h>>2]|0)+8>>2]&31](h,m+(l<<6)|0)|0;j=b[a+56>>1]|0}}n=n+1<<16>>16;l=n&65535}while(l>>>0<((j&65535)<<1|1)>>>0);i=o;return}function WA(a,d,f,g,h,j){a=a|0;d=d|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0,l=0;l=i;k=c[a+108>>2]|0;if(k){Xb[c[(c[k>>2]|0)+24>>2]&7](k,d,f,g,h,j);i=l;return}j=b[a+56>>1]|0;if((j&65535)<<1>>>0<=1){i=l;return}h=1;d=1;do{k=c[a+68>>2]|0;if(b[k+(h<<2)>>1]&1){ec[c[(c[g>>2]|0)+8>>2]&31](g,(c[a+60>>2]|0)+((e[k+(h<<2)+2>>1]|0)<<6)|0)|0;j=b[a+56>>1]|0}d=d+1<<16>>16;h=d&65535}while(h>>>0<((j&65535)<<1|1)>>>0);i=l;return}function XA(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;c[d+0>>2]=c[b+16>>2];c[d+4>>2]=c[b+20>>2];c[d+8>>2]=c[b+24>>2];c[d+12>>2]=c[b+28>>2];c[e+0>>2]=c[b+32>>2];c[e+4>>2]=c[b+36>>2];c[e+8>>2]=c[b+40>>2];c[e+12>>2]=c[b+44>>2];return}function YA(a,d,f,h,j){a=a|0;d=d|0;f=f|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0;J=i;i=i+16|0;c[d+16>>2]=c[f+0>>2];c[d+20>>2]=c[f+4>>2];c[d+24>>2]=c[f+8>>2];c[d+28>>2]=c[f+12>>2];c[d+32>>2]=c[h+0>>2];c[d+36>>2]=c[h+4>>2];c[d+40>>2]=c[h+8>>2];c[d+44>>2]=c[h+12>>2];v=c[a+60>>2]|0;G=c[d+12>>2]&65535;$A(a,J+6|0,+g[f>>2],+g[f+4>>2],+g[f+8>>2],0);$A(a,J,+g[h>>2],+g[h+4>>2],+g[h+8>>2],1);F=0;do{u=b[v+(G<<6)+(F<<1)+48>>1]|0;z=b[v+(G<<6)+(F<<1)+54>>1]|0;n=b[J+6+(F<<1)>>1]|0;k=a+(F<<2)+68|0;l=c[k>>2]|0;t=(n&65535)-(e[l+((u&65535)<<2)>>1]|0)|0;m=b[J+(F<<1)>>1]|0;I=(m&65535)-(e[l+((z&65535)<<2)>>1]|0)|0;b[l+((u&65535)<<2)>>1]=n;b[l+((z&65535)<<2)>>1]=m;if((t|0)<0)_A(a,F,u);a:do if((I|0)>0?(E=c[k>>2]|0,w=c[a+60>>2]|0,H=e[E+((z&65535)<<2)+2>>1]|0,x=b[E+((z&65535)+1<<2)+2>>1]|0,x<<16>>16!=0):0){m=1<<F&3;l=w+(H<<6)+(F<<1)+54|0;n=x;r=E+((z&65535)<<2)|0;s=E+((z&65535)+1<<2)|0;while(1){q=b[s>>1]|0;if((e[r>>1]|0)<(q&65535))break a;o=c[a+60>>2]|0;p=n&65535;if(!(q&1)){if(((((e[w+(H<<6)+(m<<1)+54>>1]|0)>=(e[o+(p<<6)+(m<<1)+48>>1]|0)?(e[o+(p<<6)+(m<<1)+54>>1]|0)>=(e[w+(H<<6)+(m<<1)+48>>1]|0):0)?(e[w+(H<<6)+((1<<m&3)<<1)+54>>1]|0)>=(e[o+(p<<6)+((1<<m&3)<<1)+48>>1]|0):0)?(e[o+(p<<6)+((1<<m&3)<<1)+54>>1]|0)>=(e[w+(H<<6)+((1<<m&3)<<1)+48>>1]|0):0)?(A=c[a+92>>2]|0,y=o+((e[r+2>>1]|0)<<6)|0,Wb[c[(c[A>>2]|0)+8>>2]&63](A,y,o+(p<<6)|0)|0,A=c[a+96>>2]|0,(A|0)!=0):0)Wb[c[(c[A>>2]|0)+8>>2]&63](A,y,o+(p<<6)|0)|0;n=o+(p<<6)+(F<<1)+48|0;b[n>>1]=(b[n>>1]|0)+-1<<16>>16}else{n=o+(p<<6)+(F<<1)+54|0;b[n>>1]=(b[n>>1]|0)+-1<<16>>16}b[l>>1]=(b[l>>1]|0)+1<<16>>16;n=e[r>>1]|e[r+2>>1]<<16;o=e[s>>1]|e[s+2>>1]<<16;b[r>>1]=o;b[r+2>>1]=o>>>16;b[s>>1]=n;b[s+2>>1]=n>>>16;n=b[s+6>>1]|0;if(!(n<<16>>16))break;else{r=r+4|0;s=s+4|0}}}while(0);b:do if((t|0)>0?(B=c[k>>2]|0,C=b[B+((u&65535)+1<<2)+2>>1]|0,C<<16>>16!=0):0){p=(c[a+60>>2]|0)+((e[B+((u&65535)<<2)+2>>1]|0)<<6)+(F<<1)+48|0;o=1<<F&3;l=C;q=B+((u&65535)<<2)|0;n=B+((u&65535)+1<<2)|0;while(1){k=b[n>>1]|0;if((e[q>>1]|0)<(k&65535))break b;m=c[a+60>>2]|0;l=l&65535;if(!(k&1)){u=m+(l<<6)+(F<<1)+48|0;b[u>>1]=(b[u>>1]|0)+-1<<16>>16}else{k=e[q+2>>1]|0;if(((((e[m+(k<<6)+(o<<1)+54>>1]|0)>=(e[m+(l<<6)+(o<<1)+48>>1]|0)?(e[m+(l<<6)+(o<<1)+54>>1]|0)>=(e[m+(k<<6)+(o<<1)+48>>1]|0):0)?(e[m+(k<<6)+((1<<o&3)<<1)+54>>1]|0)>=(e[m+(l<<6)+((1<<o&3)<<1)+48>>1]|0):0)?(e[m+(l<<6)+((1<<o&3)<<1)+54>>1]|0)>=(e[m+(k<<6)+((1<<o&3)<<1)+48>>1]|0):0)?(D=c[a+92>>2]|0,Rb[c[(c[D>>2]|0)+12>>2]&31](D,m+(k<<6)|0,m+(l<<6)|0,j)|0,D=c[a+96>>2]|0,(D|0)!=0):0)Rb[c[(c[D>>2]|0)+12>>2]&31](D,m+(k<<6)|0,m+(l<<6)|0,j)|0;u=m+(l<<6)+(F<<1)+54|0;b[u>>1]=(b[u>>1]|0)+-1<<16>>16}b[p>>1]=(b[p>>1]|0)+1<<16>>16;l=e[q>>1]|e[q+2>>1]<<16;u=e[n>>1]|e[n+2>>1]<<16;b[q>>1]=u;b[q+2>>1]=u>>>16;b[n>>1]=l;b[n+2>>1]=l>>>16;l=b[n+6>>1]|0;if(!(l<<16>>16))break;else{q=q+4|0;n=n+4|0}}}while(0);if((I|0)<0)ZA(a,F,z,j);F=F+1|0}while((F|0)!=3);k=c[a+108>>2]|0;if(!k){i=J;return}Hb[c[(c[k>>2]|0)+16>>2]&31](k,c[d+60>>2]|0,f,h,j);i=J;return}function ZA(a,d,f,g){a=a|0;d=d|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;r=i;j=c[a+(d<<2)+68>>2]|0;h=b[j+((f&65535)+-1<<2)>>1]|0;if((e[j+((f&65535)<<2)>>1]|0)>=(h&65535)){i=r;return}m=c[a+60>>2]|0;q=m+((e[j+((f&65535)<<2)+2>>1]|0)<<6)+(d<<1)+54|0;l=j+((f&65535)<<2)|0;k=j+((f&65535)+-1<<2)|0;while(1){j=e[k+2>>1]|0;if(!(h&1)){h=e[l+2>>1]|0;if(((((e[m+(h<<6)+((1<<d&3)<<1)+54>>1]|0)>=(e[m+(j<<6)+((1<<d&3)<<1)+48>>1]|0)?(e[m+(j<<6)+((1<<d&3)<<1)+54>>1]|0)>=(e[m+(h<<6)+((1<<d&3)<<1)+48>>1]|0):0)?(e[m+(h<<6)+((1<<(1<<d&3)&3)<<1)+54>>1]|0)>=(e[m+(j<<6)+((1<<(1<<d&3)&3)<<1)+48>>1]|0):0)?(e[m+(j<<6)+((1<<(1<<d&3)&3)<<1)+54>>1]|0)>=(e[m+(h<<6)+((1<<(1<<d&3)&3)<<1)+48>>1]|0):0)?(p=c[a+92>>2]|0,n=m+(h<<6)|0,o=m+(j<<6)|0,Rb[c[(c[p>>2]|0)+12>>2]&31](p,n,o,g)|0,p=c[a+96>>2]|0,(p|0)!=0):0)Rb[c[(c[p>>2]|0)+12>>2]&31](p,n,o,g)|0;m=m+(j<<6)+(d<<1)+48|0;b[m>>1]=(b[m>>1]|0)+1<<16>>16}else{m=m+(j<<6)+(d<<1)+54|0;b[m>>1]=(b[m>>1]|0)+1<<16>>16}b[q>>1]=(b[q>>1]|0)+-1<<16>>16;f=e[l>>1]|e[l+2>>1]<<16;j=e[k>>1]|e[k+2>>1]<<16;b[l>>1]=j;b[l+2>>1]=j>>>16;b[k>>1]=f;b[k+2>>1]=f>>>16;f=l+-4|0;j=k+-4|0;h=b[j>>1]|0;if((e[f>>1]|0)>=(h&65535))break;m=c[a+60>>2]|0;l=f;k=j}i=r;return}function _A(a,d,f){a=a|0;d=d|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;q=i;h=c[a+(d<<2)+68>>2]|0;n=c[a+60>>2]|0;p=e[h+((f&65535)<<2)+2>>1]|0;g=b[h+((f&65535)+-1<<2)>>1]|0;if((e[h+((f&65535)<<2)>>1]|0)>=(g&65535)){i=q;return}l=n;k=h+((f&65535)<<2)|0;j=h+((f&65535)+-1<<2)|0;while(1){h=e[j+2>>1]|0;if(!(g&1)){l=l+(h<<6)+(d<<1)+48|0;b[l>>1]=(b[l>>1]|0)+1<<16>>16}else{if(((((e[n+(p<<6)+((1<<d&3)<<1)+54>>1]|0)>=(e[l+(h<<6)+((1<<d&3)<<1)+48>>1]|0)?(e[l+(h<<6)+((1<<d&3)<<1)+54>>1]|0)>=(e[n+(p<<6)+((1<<d&3)<<1)+48>>1]|0):0)?(e[n+(p<<6)+((1<<(1<<d&3)&3)<<1)+54>>1]|0)>=(e[l+(h<<6)+((1<<(1<<d&3)&3)<<1)+48>>1]|0):0)?(e[l+(h<<6)+((1<<(1<<d&3)&3)<<1)+54>>1]|0)>=(e[n+(p<<6)+((1<<(1<<d&3)&3)<<1)+48>>1]|0):0)?(o=c[a+92>>2]|0,m=l+(h<<6)|0,Wb[c[(c[o>>2]|0)+8>>2]&63](o,n+(p<<6)|0,m)|0,o=c[a+96>>2]|0,(o|0)!=0):0)Wb[c[(c[o>>2]|0)+8>>2]&63](o,n+(p<<6)|0,m)|0;l=l+(h<<6)+(d<<1)+54|0;b[l>>1]=(b[l>>1]|0)+1<<16>>16}b[n+(p<<6)+(d<<1)+48>>1]=(b[n+(p<<6)+(d<<1)+48>>1]|0)+-1<<16>>16;f=e[k>>1]|e[k+2>>1]<<16;h=e[j>>1]|e[j+2>>1]<<16;b[k>>1]=h;b[k+2>>1]=h>>>16;b[j>>1]=f;b[j+2>>1]=f>>>16;f=k+-4|0;h=j+-4|0;g=b[h>>1]|0;if((e[f>>1]|0)>=(g&65535))break;l=c[a+60>>2]|0;k=f;j=h}i=q;return}function $A(a,c,d,e,f,h){a=a|0;c=c|0;d=+d;e=+e;f=+f;h=h|0;var j=0,k=0,l=0;l=i;d=(d-+g[a+8>>2])*+g[a+40>>2];e=(e-+g[a+12>>2])*+g[a+44>>2];f=(f-+g[a+16>>2])*+g[a+48>>2];do if(!(d<=0.0)){k=b[a+6>>1]|0;j=b[a+4>>1]|0;if(!(d>=+(k&65535|0))){k=j&(~~d&65535)&65535|h;break}else{k=j&k&65535|h;break}}else k=h;while(0);b[c>>1]=k;do if(!(e<=0.0)){j=b[a+6>>1]|0;k=b[a+4>>1]|0;if(!(e>=+(j&65535|0))){j=k&(~~e&65535)&65535|h;break}else{j=k&j&65535|h;break}}else j=h;while(0);b[c+2>>1]=j;if(f<=0.0){k=h;k=k&65535;j=c+4|0;b[j>>1]=k;i=l;return}k=b[a+6>>1]|0;j=b[a+4>>1]|0;if(!(f>=+(k&65535|0))){k=j&(~~f&65535)&65535|h;k=k&65535;j=c+4|0;b[j>>1]=k;i=l;return}else{k=j&k&65535|h;k=k&65535;j=c+4|0;b[j>>1]=k;i=l;return}}function aB(a,d,f){a=a|0;d=d|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0;s=i;g=c[a+108>>2]|0;if(g)pc[c[(c[g>>2]|0)+12>>2]&127](g,c[d+60>>2]|0,f);q=c[d+12>>2]|0;r=c[a+60>>2]|0;o=c[a+92>>2]|0;if(!(Nb[c[(c[o>>2]|0)+56>>2]&127](o)|0)){o=c[a+92>>2]|0;pc[c[(c[o>>2]|0)+16>>2]&127](o,r+((q&65535)<<6)|0,f)}p=e[a+56>>1]|0;f=c[a+60>>2]|0;b[f+54>>1]=(e[f+54>>1]|0)+65534;b[f+56>>1]=(e[f+56>>1]|0)+65534;b[f+58>>1]=(e[f+58>>1]|0)+65534;f=b[a+6>>1]|0;o=0;do{m=a+(o<<2)+68|0;n=c[m>>2]|0;h=e[r+((q&65535)<<6)+(o<<1)+54>>1]|0;b[n+(h<<2)>>1]=f;d=b[n+(h+1<<2)+2>>1]|0;if(!(d<<16>>16))g=n;else{l=(c[a+60>>2]|0)+((e[n+(h<<2)+2>>1]|0)<<6)+(o<<1)+54|0;k=n+(h<<2)|0;g=n+(h+1<<2)|0;while(1){j=b[g>>1]|0;if((e[k>>1]|0)<(j&65535))break;f=c[a+60>>2]|0;h=d&65535;if(!(j&1)){j=f+(h<<6)+(o<<1)+48|0;b[j>>1]=(b[j>>1]|0)+-1<<16>>16}else{j=f+(h<<6)+(o<<1)+54|0;b[j>>1]=(b[j>>1]|0)+-1<<16>>16}b[l>>1]=(b[l>>1]|0)+1<<16>>16;d=e[k>>1]|e[k+2>>1]<<16;j=e[g>>1]|e[g+2>>1]<<16;b[k>>1]=j;b[k+2>>1]=j>>>16;b[g>>1]=d;b[g+2>>1]=d>>>16;d=b[g+6>>1]|0;if(!(d<<16>>16))break;else{k=k+4|0;g=g+4|0}}f=b[a+6>>1]|0;g=c[m>>2]|0}h=e[r+((q&65535)<<6)+(o<<1)+48>>1]|0;b[n+(h<<2)>>1]=f;d=b[g+(h+1<<2)+2>>1]|0;if(d<<16>>16){l=(c[a+60>>2]|0)+((e[g+(h<<2)+2>>1]|0)<<6)+(o<<1)+48|0;k=g+(h<<2)|0;j=g+(h+1<<2)|0;while(1){g=b[j>>1]|0;if((e[k>>1]|0)<(g&65535))break;h=c[a+60>>2]|0;f=d&65535;if(!(g&1)){m=h+(f<<6)+(o<<1)+48|0;b[m>>1]=(b[m>>1]|0)+-1<<16>>16}else{m=h+(f<<6)+(o<<1)+54|0;b[m>>1]=(b[m>>1]|0)+-1<<16>>16}b[l>>1]=(b[l>>1]|0)+1<<16>>16;d=e[k>>1]|e[k+2>>1]<<16;m=e[j>>1]|e[j+2>>1]<<16;b[k>>1]=m;b[k+2>>1]=m>>>16;b[j>>1]=d;b[j+2>>1]=d>>>16;d=b[j+6>>1]|0;if(!(d<<16>>16))break;else{k=k+4|0;j=j+4|0}}f=b[a+6>>1]|0}b[n+((p<<1)+-1<<2)+2>>1]=0;b[n+((p<<1)+-1<<2)>>1]=f;o=o+1|0}while((o|0)!=3);b[(c[a+60>>2]|0)+((q&65535)<<6)+48>>1]=b[a+64>>1]|0;b[a+64>>1]=q;b[a+56>>1]=(b[a+56>>1]|0)+-1<<16>>16;i=s;return}function bB(a,d,f,h,j,k,l,m,n){a=a|0;d=d|0;f=f|0;h=h|0;j=j|0;k=k|0;l=l|0;m=m|0;n=n|0;var o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0;w=i;i=i+16|0;$A(a,w+6|0,+g[d>>2],+g[d+4>>2],+g[d+8>>2],0);$A(a,w,+g[f>>2],+g[f+4>>2],+g[f+8>>2],1);v=b[a+64>>1]|0;u=c[a+60>>2]|0;b[a+64>>1]=b[u+((v&65535)<<6)+48>>1]|0;o=(b[a+56>>1]|0)+1<<16>>16;b[a+56>>1]=o;c[u+((v&65535)<<6)+12>>2]=v&65535;c[u+((v&65535)<<6)>>2]=j;b[u+((v&65535)<<6)+4>>1]=k;b[u+((v&65535)<<6)+6>>1]=l;c[u+((v&65535)<<6)+8>>2]=n;r=(o&65535)<<1&65534;b[u+54>>1]=(e[u+54>>1]|0)+2;p=c[a+68>>2]|0;n=e[p+(r+-1<<2)>>1]|e[p+(r+-1<<2)+2>>1]<<16;b[p+((r|1)<<2)>>1]=n;b[p+((r|1)<<2)+2>>1]=n>>>16;p=c[a+68>>2]|0;b[p+(r+-1<<2)>>1]=b[w+6>>1]|0;b[p+(r+-1<<2)+2>>1]=v;b[p+(r<<2)>>1]=b[w>>1]|0;b[p+(r<<2)+2>>1]=v;b[u+((v&65535)<<6)+48>>1]=r+-1;b[u+((v&65535)<<6)+54>>1]=(o&65535)<<1;p=(c[a+60>>2]|0)+56|0;b[p>>1]=(e[p>>1]|0)+2;p=c[a+72>>2]|0;n=e[p+(r+-1<<2)>>1]|e[p+(r+-1<<2)+2>>1]<<16;b[p+((r|1)<<2)>>1]=n;b[p+((r|1)<<2)+2>>1]=n>>>16;p=c[a+72>>2]|0;b[p+(r+-1<<2)>>1]=b[w+8>>1]|0;b[p+(r+-1<<2)+2>>1]=v;b[p+(r<<2)>>1]=b[w+2>>1]|0;b[p+(r<<2)+2>>1]=v;b[u+((v&65535)<<6)+50>>1]=r+-1;b[u+((v&65535)<<6)+56>>1]=(o&65535)<<1;p=(c[a+60>>2]|0)+58|0;b[p>>1]=(e[p>>1]|0)+2;p=c[a+76>>2]|0;n=e[p+(r+-1<<2)>>1]|e[p+(r+-1<<2)+2>>1]<<16;b[p+((r|1)<<2)>>1]=n;b[p+((r|1)<<2)+2>>1]=n>>>16;p=c[a+76>>2]|0;b[p+(r+-1<<2)>>1]=b[w+10>>1]|0;b[p+(r+-1<<2)+2>>1]=v;b[p+(r<<2)>>1]=b[w+4>>1]|0;b[p+(r<<2)+2>>1]=v;b[u+((v&65535)<<6)+52>>1]=r+-1;b[u+((v&65535)<<6)+58>>1]=(o&65535)<<1;o=c[a+68>>2]|0;r=e[u+((v&65535)<<6)+48>>1]|0;p=c[a+60>>2]|0;n=b[o+(r+-1<<2)>>1]|0;if((e[o+(r<<2)>>1]|0)<(n&65535)){t=p+((e[o+(r<<2)+2>>1]|0)<<6)+48|0;s=o+(r<<2)|0;q=o+(r+-1<<2)|0;while(1){o=e[q+2>>1]|0;if(!(n&1)){r=p+(o<<6)+48|0;b[r>>1]=(b[r>>1]|0)+1<<16>>16}else{r=p+(o<<6)+54|0;b[r>>1]=(b[r>>1]|0)+1<<16>>16}b[t>>1]=(b[t>>1]|0)+-1<<16>>16;o=e[s>>1]|e[s+2>>1]<<16;n=e[q>>1]|e[q+2>>1]<<16;b[s>>1]=n;b[s+2>>1]=n>>>16;b[q>>1]=o;b[q+2>>1]=o>>>16;o=s+-4|0;q=q+-4|0;n=b[q>>1]|0;if((e[o>>1]|0)>=(n&65535))break;p=c[a+60>>2]|0;s=o}o=c[a+68>>2]|0}p=e[u+((v&65535)<<6)+54>>1]|0;r=o+(p<<2)|0;q=o+(p+-1<<2)|0;n=b[q>>1]|0;a:do if((e[r>>1]|0)<(n&65535)){s=c[a+60>>2]|0;o=s+((e[o+(p<<2)+2>>1]|0)<<6)+54|0;while(1){p=e[q+2>>1]|0;if(!(n&1)){t=s+(p<<6)+48|0;b[t>>1]=(b[t>>1]|0)+1<<16>>16}else{t=s+(p<<6)+54|0;b[t>>1]=(b[t>>1]|0)+1<<16>>16}b[o>>1]=(b[o>>1]|0)+-1<<16>>16;p=e[r>>1]|e[r+2>>1]<<16;n=e[q>>1]|e[q+2>>1]<<16;b[r>>1]=n;b[r+2>>1]=n>>>16;b[q>>1]=p;b[q+2>>1]=p>>>16;p=r+-4|0;q=q+-4|0;n=b[q>>1]|0;if((e[p>>1]|0)>=(n&65535))break a;s=c[a+60>>2]|0;r=p}}while(0);o=c[a+72>>2]|0;r=e[u+((v&65535)<<6)+50>>1]|0;p=c[a+60>>2]|0;n=b[o+(r+-1<<2)>>1]|0;if((e[o+(r<<2)>>1]|0)<(n&65535)){t=p+((e[o+(r<<2)+2>>1]|0)<<6)+50|0;s=o+(r<<2)|0;q=o+(r+-1<<2)|0;while(1){o=e[q+2>>1]|0;if(!(n&1)){r=p+(o<<6)+50|0;b[r>>1]=(b[r>>1]|0)+1<<16>>16}else{r=p+(o<<6)+56|0;b[r>>1]=(b[r>>1]|0)+1<<16>>16}b[t>>1]=(b[t>>1]|0)+-1<<16>>16;o=e[s>>1]|e[s+2>>1]<<16;n=e[q>>1]|e[q+2>>1]<<16;b[s>>1]=n;b[s+2>>1]=n>>>16;b[q>>1]=o;b[q+2>>1]=o>>>16;o=s+-4|0;q=q+-4|0;n=b[q>>1]|0;if((e[o>>1]|0)>=(n&65535))break;p=c[a+60>>2]|0;s=o}o=c[a+72>>2]|0}p=e[u+((v&65535)<<6)+56>>1]|0;r=o+(p<<2)|0;q=o+(p+-1<<2)|0;n=b[q>>1]|0;b:do if((e[r>>1]|0)<(n&65535)){s=c[a+60>>2]|0;o=s+((e[o+(p<<2)+2>>1]|0)<<6)+56|0;while(1){p=e[q+2>>1]|0;if(!(n&1)){t=s+(p<<6)+50|0;b[t>>1]=(b[t>>1]|0)+1<<16>>16}else{t=s+(p<<6)+56|0;b[t>>1]=(b[t>>1]|0)+1<<16>>16}b[o>>1]=(b[o>>1]|0)+-1<<16>>16;p=e[r>>1]|e[r+2>>1]<<16;n=e[q>>1]|e[q+2>>1]<<16;b[r>>1]=n;b[r+2>>1]=n>>>16;b[q>>1]=p;b[q+2>>1]=p>>>16;p=r+-4|0;q=q+-4|0;n=b[q>>1]|0;if((e[p>>1]|0)>=(n&65535))break b;s=c[a+60>>2]|0;r=p}}while(0);_A(a,2,b[u+((v&65535)<<6)+52>>1]|0);ZA(a,2,b[u+((v&65535)<<6)+58>>1]|0,m);n=c[a+60>>2]|0;o=c[a+108>>2]|0;if(!o){v=n+((v&65535)<<6)|0;i=w;return v|0}c[n+((v&65535)<<6)+60>>2]=nc[c[(c[o>>2]|0)+8>>2]&3](o,d,f,h,j,k,l,m,0)|0;v=n+((v&65535)<<6)|0;i=w;return v|0}function cB(a){a=a|0;var b=0;b=i;dB(a);if(!a){i=b;return}c[5110]=(c[5110]|0)+1;RE(c[a+-4>>2]|0);i=b;return}function dB(b){b=b|0;var d=0,e=0;e=i;c[b>>2]=16240;if(c[b+108>>2]|0){d=c[b+112>>2]|0;Jb[c[c[d>>2]>>2]&255](d);d=c[b+112>>2]|0;if(d){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}d=c[b+108>>2]|0;Jb[c[c[d>>2]>>2]&255](d);d=c[b+108>>2]|0;if(d){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}}d=c[b+88>>2]|0;if(d){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}d=c[b+84>>2]|0;if(d){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}d=c[b+80>>2]|0;if(d){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}d=c[b+60>>2]|0;if(d){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}if(!(a[b+100>>0]|0)){i=e;return}d=c[b+92>>2]|0;Jb[c[c[d>>2]>>2]&255](d);d=c[b+92>>2]|0;if(!d){i=e;return}c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0);i=e;return}function eB(a){a=a|0;var b=0;b=i;dB(a);if(!a){i=b;return}c[5110]=(c[5110]|0)+1;RE(c[a+-4>>2]|0);i=b;return}function fB(a,b){a=a|0;b=b|0;return}function gB(a,b){a=a|0;b=b|0;return}function hB(a){a=a|0;return 1}function iB(a,b,c){a=a|0;b=b|0;c=c|0;return 0}function jB(a,b,c){a=a|0;b=b|0;c=c|0;return}function kB(a,b){a=a|0;b=b|0;return}function lB(a,b,c){a=a|0;b=b|0;c=c|0;return}function mB(a){a=a|0;return 0}function nB(a,b,c){a=a|0;b=b|0;c=c|0;return}function oB(a){a=a|0;return a+4|0}function pB(a){a=a|0;return c[a+16>>2]|0}function qB(a){a=a|0;return c[a+16>>2]|0}function rB(a,b,c){a=a|0;b=b|0;c=c|0;return}function sB(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;return 0}function tB(a,b,c){a=a|0;b=b|0;c=c|0;return 0}function uB(b){b=b|0;var d=0,e=0;e=i;c[b>>2]=16304;d=c[b+16>>2]|0;if(!d){RE(b);i=e;return}if(!(a[b+20>>0]|0)){RE(b);i=e;return}c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0);RE(b);i=e;return}function vB(b){b=b|0;var d=0,e=0;e=i;c[b>>2]=16304;d=c[b+16>>2]|0;if(d){if(a[b+20>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}c[b+16>>2]=0}a[b+20>>0]=1;c[b+16>>2]=0;c[b+8>>2]=0;c[b+12>>2]=0;i=e;return}function wB(b){b=b|0;var d=0,e=0,f=0,g=0,h=0;g=i;c[b>>2]=16504;a[b+20>>0]=1;c[b+16>>2]=0;c[b+8>>2]=0;c[b+12>>2]=0;c[b+24>>2]=0;a[b+28>>0]=0;a[b+48>>0]=1;c[b+44>>2]=0;c[b+36>>2]=0;c[b+40>>2]=0;a[b+68>>0]=1;c[b+64>>2]=0;c[b+56>>2]=0;c[b+60>>2]=0;c[b+72>>2]=0;c[5108]=(c[5108]|0)+1;d=QE(51)|0;if(!d)f=0;else{c[(d+19&-16)+-4>>2]=d;f=d+19&-16}d=c[b+8>>2]|0;if((d|0)>0){e=0;do{h=c[b+16>>2]|0;c[f+(e<<4)>>2]=c[h+(e<<4)>>2];c[f+(e<<4)+4>>2]=c[h+(e<<4)+4>>2];c[f+(e<<4)+8>>2]=c[h+(e<<4)+8>>2];c[f+(e<<4)+12>>2]=c[h+(e<<4)+12>>2];e=e+1|0}while((e|0)!=(d|0))}d=c[b+16>>2]|0;if(!d){a[b+20>>0]=1;c[b+16>>2]=f;c[b+12>>2]=2;xB(b);i=g;return}if(a[b+20>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}c[b+16>>2]=0;a[b+20>>0]=1;c[b+16>>2]=f;c[b+12>>2]=2;xB(b);i=g;return}function xB(b){b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0;l=i;j=c[b+12>>2]|0;k=c[b+36>>2]|0;if((k|0)>=(j|0)){i=l;return}if((k|0)<=(j|0)){if((c[b+40>>2]|0)<(j|0)){if(!j){e=k;h=0}else{c[5108]=(c[5108]|0)+1;d=QE((j<<2|3)+16|0)|0;if(!d)d=0;else{c[(d+19&-16)+-4>>2]=d;d=d+19&-16}e=c[b+36>>2]|0;h=d}if((e|0)>0){f=0;do{g=h+(f<<2)|0;if(g)c[g>>2]=c[(c[b+44>>2]|0)+(f<<2)>>2];f=f+1|0}while((f|0)!=(e|0))}d=c[b+44>>2]|0;if(d){if(a[b+48>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}c[b+44>>2]=0}a[b+48>>0]=1;c[b+44>>2]=h;c[b+40>>2]=j;d=h}else d=c[b+44>>2]|0;g=k;do{f=d+(g<<2)|0;if(f)c[f>>2]=0;g=g+1|0}while((g|0)!=(j|0))}c[b+36>>2]=j;g=c[b+56>>2]|0;if((g|0)<(j|0)){if((c[b+60>>2]|0)<(j|0)){if(!j){h=g;f=0}else{c[5108]=(c[5108]|0)+1;d=QE((j<<2|3)+16|0)|0;if(!d)f=0;else{c[(d+19&-16)+-4>>2]=d;f=d+19&-16}h=c[b+56>>2]|0}if((h|0)>0){d=0;do{e=f+(d<<2)|0;if(e)c[e>>2]=c[(c[b+64>>2]|0)+(d<<2)>>2];d=d+1|0}while((d|0)!=(h|0))}d=c[b+64>>2]|0;if(d){if(a[b+68>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}c[b+64>>2]=0}a[b+68>>0]=1;c[b+64>>2]=f;c[b+60>>2]=j;e=f}else e=c[b+64>>2]|0;do{f=e+(g<<2)|0;if(f)c[f>>2]=0;g=g+1|0}while((g|0)!=(j|0))}c[b+56>>2]=j;if((j|0)>0){VE(c[b+44>>2]|0,-1,j<<2|0)|0;VE(c[b+64>>2]|0,-1,j<<2|0)|0}if((k|0)<=0){i=l;return}d=c[b+16>>2]|0;e=c[b+44>>2]|0;f=c[b+64>>2]|0;g=0;do{h=c[(c[d+(g<<4)+4>>2]|0)+12>>2]<<16|c[(c[d+(g<<4)>>2]|0)+12>>2];h=(h+~(h<<15)>>10^h+~(h<<15))*9|0;h=e+((((h>>6^h)+~((h>>6^h)<<11)>>16^(h>>6^h)+~((h>>6^h)<<11))&(c[b+12>>2]|0)+-1)<<2)|0;c[f+(g<<2)>>2]=c[h>>2];c[h>>2]=g;g=g+1|0}while((g|0)!=(k|0));i=l;return}function yB(b){b=b|0;var d=0,e=0;e=i;c[b>>2]=16504;d=c[b+64>>2]|0;if(d){if(a[b+68>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}c[b+64>>2]=0}a[b+68>>0]=1;c[b+64>>2]=0;c[b+56>>2]=0;c[b+60>>2]=0;d=c[b+44>>2]|0;if(d){if(a[b+48>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}c[b+44>>2]=0}a[b+48>>0]=1;c[b+44>>2]=0;c[b+36>>2]=0;c[b+40>>2]=0;d=c[b+16>>2]|0;if(!d){a[b+20>>0]=1;c[b+16>>2]=0;c[b+8>>2]=0;d=b+12|0;c[d>>2]=0;i=e;return}if(a[b+20>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}c[b+16>>2]=0;a[b+20>>0]=1;c[b+16>>2]=0;c[b+8>>2]=0;d=b+12|0;c[d>>2]=0;i=e;return}function zB(a){a=a|0;var b=0;b=i;yB(a);RE(a);i=b;return}function AB(a,b,d){a=a|0;b=b|0;d=d|0;var e=0;e=i;a=c[b+8>>2]|0;if(!((a|0)!=0&(d|0)!=0)){i=e;return}Jb[c[c[a>>2]>>2]&255](a);Lb[c[(c[d>>2]|0)+60>>2]&127](d,c[b+8>>2]|0);c[b+8>>2]=0;i=e;return}function BB(a,b,d){a=a|0;b=b|0;d=d|0;var e=0;e=i;i=i+16|0;c[e>>2]=16808;c[e+4>>2]=b;c[e+8>>2]=a;c[e+12>>2]=d;pc[c[(c[a>>2]|0)+48>>2]&127](a,e,d);i=e;return}function CB(a,b,d){a=a|0;b=b|0;d=d|0;var e=0;e=i;i=i+16|0;c[e>>2]=16632;c[e+4>>2]=b;pc[c[(c[a>>2]|0)+48>>2]&127](a,e,d);i=e;return}function DB(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0;h=i;c[4122]=(c[4122]|0)+1;e=(c[b+12>>2]|0)>(c[d+12>>2]|0);f=c[(e?d:b)+12>>2]|0;e=c[(e?b:d)+12>>2]|0;b=((e<<16|f)+~((e<<16|f)<<15)>>10^(e<<16|f)+~((e<<16|f)<<15))*9|0;b=((b>>6^b)+~((b>>6^b)<<11)>>16^(b>>6^b)+~((b>>6^b)<<11))&(c[a+12>>2]|0)+-1;if((b|0)>=(c[a+36>>2]|0)){b=0;i=h;return b|0}d=c[(c[a+44>>2]|0)+(b<<2)>>2]|0;if((d|0)==-1){b=0;i=h;return b|0}b=c[a+16>>2]|0;while(1){if((c[(c[b+(d<<4)>>2]|0)+12>>2]|0)==(f|0)?(c[(c[b+(d<<4)+4>>2]|0)+12>>2]|0)==(e|0):0)break;d=c[(c[a+64>>2]|0)+(d<<2)>>2]|0;if((d|0)==-1){b=0;g=8;break}}if((g|0)==8){i=h;return b|0}b=b+(d<<4)|0;i=h;return b|0}function EB(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;r=i;c[4118]=(c[4118]|0)+1;k=(c[b+12>>2]|0)>(c[d+12>>2]|0);n=k?d:b;k=k?b:d;f=c[n+12>>2]|0;g=c[k+12>>2]|0;j=((g<<16|f)+~((g<<16|f)<<15)>>10^(g<<16|f)+~((g<<16|f)<<15))*9|0;j=((j>>6^j)+~((j>>6^j)<<11)>>16^(j>>6^j)+~((j>>6^j)<<11))&(c[a+12>>2]|0)+-1;d=c[(c[a+44>>2]|0)+(j<<2)>>2]|0;if((d|0)==-1){e=0;i=r;return e|0}h=c[a+16>>2]|0;b=d;while(1){if((c[(c[h+(b<<4)>>2]|0)+12>>2]|0)==(f|0)?(c[(c[h+(b<<4)+4>>2]|0)+12>>2]|0)==(g|0):0)break;d=c[(c[a+64>>2]|0)+(b<<2)>>2]|0;if((d|0)==-1){b=0;q=24;break}else b=d}if((q|0)==24){i=r;return b|0}d=h+(b<<4)|0;if(!d){e=0;i=r;return e|0}pc[c[(c[a>>2]|0)+32>>2]&127](a,d,e);p=c[h+(b<<4)+12>>2]|0;o=d-(c[a+16>>2]|0)>>4;l=(c[a+44>>2]|0)+(j<<2)|0;d=c[l>>2]|0;f=c[a+64>>2]|0;if((d|0)!=(o|0)){b=d;while(1){h=f+(b<<2)|0;g=c[h>>2]|0;if((g|0)==(o|0))break;else b=g}d=c[f+(o<<2)>>2]|0;if((b|0)==-1)q=12;else c[h>>2]=d}else{d=c[f+(o<<2)>>2]|0;q=12}if((q|0)==12)c[l>>2]=d;m=(c[a+8>>2]|0)+-1|0;d=c[a+72>>2]|0;if(d)Rb[c[(c[d>>2]|0)+12>>2]&31](d,n,k,e)|0;if((m|0)==(o|0)){c[a+8>>2]=(c[a+8>>2]|0)+-1;e=p;i=r;return e|0}j=c[a+16>>2]|0;k=c[(c[j+(m<<4)+4>>2]|0)+12>>2]<<16|c[(c[j+(m<<4)>>2]|0)+12>>2];k=(k+~(k<<15)>>10^k+~(k<<15))*9|0;k=((k>>6^k)+~((k>>6^k)<<11)>>16^(k>>6^k)+~((k>>6^k)<<11))&(c[a+12>>2]|0)+-1;l=(c[a+44>>2]|0)+(k<<2)|0;d=c[l>>2]|0;f=c[a+64>>2]|0;if((d|0)!=(m|0)){b=d;while(1){h=f+(b<<2)|0;g=c[h>>2]|0;if((g|0)==(m|0))break;else b=g}d=c[f+(m<<2)>>2]|0;if((b|0)==-1)q=22;else c[h>>2]=d}else{d=c[f+(m<<2)>>2]|0;q=22}if((q|0)==22)c[l>>2]=d;c[j+(o<<4)+0>>2]=c[j+(m<<4)+0>>2];c[j+(o<<4)+4>>2]=c[j+(m<<4)+4>>2];c[j+(o<<4)+8>>2]=c[j+(m<<4)+8>>2];c[j+(o<<4)+12>>2]=c[j+(m<<4)+12>>2];e=(c[a+44>>2]|0)+(k<<2)|0;c[(c[a+64>>2]|0)+(o<<2)>>2]=c[e>>2];c[e>>2]=o;c[a+8>>2]=(c[a+8>>2]|0)+-1;e=p;i=r;return e|0}function FB(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0;h=i;if((c[a+8>>2]|0)<=0){i=h;return}g=0;a:while(1){while(1){e=c[a+16>>2]|0;f=e+(g<<4)|0;if(!(ec[c[(c[b>>2]|0)+8>>2]&31](b,f)|0))break;Rb[c[(c[a>>2]|0)+12>>2]&31](a,c[f>>2]|0,c[e+(g<<4)+4>>2]|0,d)|0;c[4116]=(c[4116]|0)+-1;if((g|0)>=(c[a+8>>2]|0)){e=7;break a}}g=g+1|0;if((g|0)>=(c[a+8>>2]|0)){e=7;break}}if((e|0)==7){i=h;return}}function GB(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0;n=i;i=i+32|0;a[n+16>>0]=1;c[n+12>>2]=0;c[n+4>>2]=0;c[n+8>>2]=0;e=c[b+8>>2]|0;if((e|0)>0){k=0;g=0;m=0;h=0;while(1){l=c[b+16>>2]|0;if((h|0)==(k|0)){j=(k|0)==0?1:k<<1;if((k|0)<(j|0)){if(j){c[5108]=(c[5108]|0)+1;g=QE((j<<4|3)+16|0)|0;if(!g){f=h;g=0}else{c[(g+19&-16)+-4>>2]=g;f=h;g=g+19&-16}}else{f=k;g=0}if((f|0)>0){e=0;do{k=c[n+12>>2]|0;c[g+(e<<4)>>2]=c[k+(e<<4)>>2];c[g+(e<<4)+4>>2]=c[k+(e<<4)+4>>2];c[g+(e<<4)+8>>2]=c[k+(e<<4)+8>>2];c[g+(e<<4)+12>>2]=c[k+(e<<4)+12>>2];e=e+1|0}while((e|0)!=(f|0))}e=c[n+12>>2]|0;if(e){c[5110]=(c[5110]|0)+1;RE(c[e+-4>>2]|0);c[n+12>>2]=0;f=h}a[n+16>>0]=1;c[n+12>>2]=g;c[n+8>>2]=j;e=c[b+8>>2]|0}else{f=k;j=k}}else{f=h;j=k}c[g+(f<<4)>>2]=c[l+(m<<4)>>2];c[g+(f<<4)+4>>2]=c[l+(m<<4)+4>>2];c[g+(f<<4)+8>>2]=c[l+(m<<4)+8>>2];c[g+(f<<4)+12>>2]=c[l+(m<<4)+12>>2];h=f+1|0;m=m+1|0;if((m|0)>=(e|0))break;else k=j}c[n+4>>2]=h;if((f|0)>-1){e=0;do{Rb[c[(c[b>>2]|0)+12>>2]&31](b,c[g+(e<<4)>>2]|0,c[g+(e<<4)+4>>2]|0,d)|0;e=e+1|0}while((e|0)<(h|0))}}else{h=0;g=0}if((c[b+56>>2]|0)>0){e=c[b+64>>2]|0;f=0;do{c[e+(f<<2)>>2]=-1;f=f+1|0}while((f|0)<(c[b+56>>2]|0))}if((h|0)>1)OA(n,0,h+-1|0);if((h|0)>0){e=0;do{Wb[c[(c[b>>2]|0)+8>>2]&63](b,c[g+(e<<4)>>2]|0,c[g+(e<<4)+4>>2]|0)|0;e=e+1|0}while((e|0)<(h|0))}if(!g){i=n;return}c[5110]=(c[5110]|0)+1;RE(c[g+-4>>2]|0);c[n+12>>2]=0;i=n;return}function HB(a,b){a=a|0;b=b|0;c[a+72>>2]=b;return}function IB(a){a=a|0;return 0}function JB(a,b){a=a|0;b=b|0;c[a+24>>2]=b;return}function KB(a){a=a|0;return c[a+8>>2]|0}function LB(a){a=a|0;return a+4|0}function MB(a){a=a|0;return c[a+16>>2]|0}function NB(a){a=a|0;return c[a+16>>2]|0}function OB(d,e,f){d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;o=i;c[4120]=(c[4120]|0)+1;g=c[d+24>>2]|0;if(!g){if(!((b[f+6>>1]&b[e+4>>1])<<16>>16)){d=0;i=o;return d|0}if(!((b[e+6>>1]&b[f+4>>1])<<16>>16)){d=0;i=o;return d|0}}else if(!(Wb[c[(c[g>>2]|0)+8>>2]&63](g,e,f)|0)){d=0;i=o;return d|0}m=(c[e+12>>2]|0)>(c[f+12>>2]|0);n=m?f:e;m=m?e:f;g=c[n+12>>2]|0;h=c[m+12>>2]|0;l=((h<<16|g)+~((h<<16|g)<<15)>>10^(h<<16|g)+~((h<<16|g)<<15))*9|0;l=(l>>6^l)+~((l>>6^l)<<11)>>16^(l>>6^l)+~((l>>6^l)<<11);k=c[d+12>>2]|0;f=c[(c[d+44>>2]|0)+((l&k+-1)<<2)>>2]|0;a:do if((f|0)!=-1){e=c[d+16>>2]|0;while(1){if((c[(c[e+(f<<4)>>2]|0)+12>>2]|0)==(g|0)?(c[(c[e+(f<<4)+4>>2]|0)+12>>2]|0)==(h|0):0)break;f=c[(c[d+64>>2]|0)+(f<<2)>>2]|0;if((f|0)==-1)break a}f=e+(f<<4)|0;if(f){d=f;i=o;return d|0}}while(0);j=c[d+8>>2]|0;if((j|0)==(k|0)){f=(k|0)==0?1:k<<1;if((k|0)<(f|0)){if(!f){e=k;g=0}else{c[5108]=(c[5108]|0)+1;e=QE((f<<4|3)+16|0)|0;if(!e)g=0;else{c[(e+19&-16)+-4>>2]=e;g=e+19&-16}e=c[d+8>>2]|0}if((e|0)>0){h=0;do{p=c[d+16>>2]|0;c[g+(h<<4)>>2]=c[p+(h<<4)>>2];c[g+(h<<4)+4>>2]=c[p+(h<<4)+4>>2];c[g+(h<<4)+8>>2]=c[p+(h<<4)+8>>2];c[g+(h<<4)+12>>2]=c[p+(h<<4)+12>>2];h=h+1|0}while((h|0)!=(e|0))}h=c[d+16>>2]|0;if(h){if(a[d+20>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[h+-4>>2]|0);e=c[d+8>>2]|0}c[d+16>>2]=0}a[d+20>>0]=1;c[d+16>>2]=g;c[d+12>>2]=f}else{e=k;f=k}}else{e=j;f=k}c[d+8>>2]=e+1;h=c[d+16>>2]|0;e=c[d+72>>2]|0;if(e){Wb[c[(c[e>>2]|0)+8>>2]&63](e,n,m)|0;f=c[d+12>>2]|0}if((k|0)<(f|0)){xB(d);f=(c[d+12>>2]|0)+-1&l}else f=l&k+-1;l=(c[n+12>>2]|0)<(c[m+12>>2]|0);c[h+(j<<4)>>2]=l?n:m;c[h+(j<<4)+4>>2]=l?m:n;c[h+(j<<4)+8>>2]=0;c[h+(j<<4)+12>>2]=0;n=(c[d+44>>2]|0)+(f<<2)|0;c[(c[d+64>>2]|0)+(j<<2)>>2]=c[n>>2];c[n>>2]=j;d=h+(j<<4)|0;i=o;return d|0}function PB(a,b){a=a|0;b=b|0;var d=0;d=i;a=c[a+4>>2]|0;if((c[b>>2]|0)==(a|0)){a=1;i=d;return a|0}a=(c[b+4>>2]|0)==(a|0);i=d;return a|0}function QB(a){a=a|0;var b=0;b=i;RE(a);i=b;return}function RB(a,b){a=a|0;b=b|0;var d=0,e=0;d=i;e=c[a+4>>2]|0;if((c[b>>2]|0)!=(e|0)?(c[b+4>>2]|0)!=(e|0):0){i=d;return 0}e=c[a+8>>2]|0;pc[c[(c[e>>2]|0)+32>>2]&127](e,b,c[a+12>>2]|0);i=d;return 0}function SB(a){a=a|0;var b=0;b=i;RE(a);i=b;return}function TB(b,d){b=b|0;d=d|0;var e=0,f=0;f=i;c[b>>2]=16960;e=b+4|0;do{a[e+36>>0]=1;c[e+32>>2]=0;c[e+24>>2]=0;c[e+28>>2]=0;a[e+56>>0]=1;c[e+52>>2]=0;c[e+44>>2]=0;c[e+48>>2]=0;c[e>>2]=0;c[e+4>>2]=0;c[e+8>>2]=-1;c[e+12>>2]=0;c[e+16>>2]=0;e=e+60|0}while((e|0)!=(b+124|0));a[b+193>>0]=0;a[b+194>>0]=1;a[b+192>>0]=(d|0)!=0^1;g[b+140>>2]=0.0;c[b+144>>2]=0;c[b+164>>2]=0;c[b+148>>2]=1;c[b+152>>2]=0;c[b+156>>2]=10;c[b+160>>2]=1;c[b+168>>2]=0;c[b+172>>2]=0;g[b+176>>2]=0.0;if(d){e=b+136|0;c[e>>2]=d;e=b+188|0;c[e>>2]=0;e=b+180|0;c[e>>2]=0;e=b+184|0;c[e>>2]=0;e=b+124|0;c[e+0>>2]=0;c[e+4>>2]=0;c[e+8>>2]=0;i=f;return}c[5108]=(c[5108]|0)+1;e=QE(95)|0;if((e|0)!=0?(c[(e+19&-16)+-4>>2]=e,(e+19&-16|0)!=0):0){wB(e+19&-16);e=e+19&-16}else e=0;d=e;e=b+136|0;c[e>>2]=d;e=b+188|0;c[e>>2]=0;e=b+180|0;c[e>>2]=0;e=b+184|0;c[e>>2]=0;e=b+124|0;c[e+0>>2]=0;c[e+4>>2]=0;c[e+8>>2]=0;i=f;return}function UB(b){b=b|0;var d=0,e=0;e=i;c[b>>2]=16960;if((a[b+192>>0]|0)!=0?(d=c[b+136>>2]|0,Jb[c[c[d>>2]>>2]&255](d),d=c[b+136>>2]|0,(d|0)!=0):0){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}d=b+124|0;do{d=d+-60|0;AC(d)}while((d|0)!=(b+4|0));i=e;return}function VB(a){a=a|0;var b=0;b=i;UB(a);RE(a);i=b;return}function WB(d,e,f,g,h,j,k,l,m){d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;l=l|0;m=m|0;var n=0,o=0;o=i;i=i+48|0;c[5108]=(c[5108]|0)+1;l=QE(83)|0;if(!l)n=0;else{c[(l+19&-16)+-4>>2]=l;n=l+19&-16}c[n>>2]=h;b[n+4>>1]=j;b[n+6>>1]=k;h=n+16|0;c[h+0>>2]=c[e+0>>2];c[h+4>>2]=c[e+4>>2];c[h+8>>2]=c[e+8>>2];c[h+12>>2]=c[e+12>>2];h=n+32|0;c[h+0>>2]=c[f+0>>2];c[h+4>>2]=c[f+4>>2];c[h+8>>2]=c[f+8>>2];c[h+12>>2]=c[f+12>>2];c[n+8>>2]=0;h=n+56|0;c[h>>2]=0;k=n+52|0;c[k>>2]=0;c[o+16>>2]=c[e+0>>2];c[o+20>>2]=c[e+4>>2];c[o+24>>2]=c[e+8>>2];c[o+28>>2]=c[e+12>>2];c[o+32>>2]=c[f+0>>2];c[o+36>>2]=c[f+4>>2];c[o+40>>2]=c[f+8>>2];c[o+44>>2]=c[f+12>>2];c[n+60>>2]=c[d+144>>2];m=(c[d+188>>2]|0)+1|0;c[d+188>>2]=m;c[n+12>>2]=m;m=c[d+8>>2]|0;if(!m){c[5108]=(c[5108]|0)+1;l=QE(63)|0;if((l|0)!=0?(c[(l+19&-16)+-4>>2]=l,(l+19&-16|0)!=0):0){m=(l+19&-16)+0|0;g=m+44|0;do{c[m>>2]=0;m=m+4|0}while((m|0)<(g|0));m=l+19&-16}else m=0}else c[d+8>>2]=0;c[m+32>>2]=0;c[m+36>>2]=n;c[m+40>>2]=0;c[m+0>>2]=c[o+16>>2];c[m+4>>2]=c[o+20>>2];c[m+8>>2]=c[o+24>>2];c[m+12>>2]=c[o+28>>2];c[m+16>>2]=c[o+32>>2];c[m+20>>2]=c[o+36>>2];c[m+24>>2]=c[o+40>>2];c[m+28>>2]=c[o+44>>2];EC(d+4|0,c[d+4>>2]|0,m);c[d+16>>2]=(c[d+16>>2]|0)+1;c[n+48>>2]=m;l=d+(c[d+144>>2]<<2)+124|0;c[k>>2]=0;c[h>>2]=c[l>>2];m=c[l>>2]|0;if(m)c[m+52>>2]=n;c[l>>2]=n;if(a[d+193>>0]|0){i=o;return n|0}c[o>>2]=17224;c[o+4>>2]=d;c[o+8>>2]=n;rw(c[d+4>>2]|0,o+16|0,o);rw(c[d+64>>2]|0,o+16|0,o);i=o;return n|0}function XB(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0;h=i;if((c[d+60>>2]|0)==2){g=c[d+48>>2]|0;DC(b+64|0,g)|0;f=c[b+68>>2]|0;if(f){c[5110]=(c[5110]|0)+1;RE(c[f+-4>>2]|0)}c[b+68>>2]=g;c[b+76>>2]=(c[b+76>>2]|0)+-1}else{g=c[d+48>>2]|0;DC(b+4|0,g)|0;f=c[b+8>>2]|0;if(f){c[5110]=(c[5110]|0)+1;RE(c[f+-4>>2]|0)}c[b+8>>2]=g;c[b+16>>2]=(c[b+16>>2]|0)+-1}f=c[d+52>>2]|0;g=c[d+56>>2]|0;if(!f)c[b+(c[d+60>>2]<<2)+124>>2]=g;else c[f+56>>2]=g;f=c[d+56>>2]|0;if(f)c[f+52>>2]=c[d+52>>2];f=c[b+136>>2]|0;pc[c[(c[f>>2]|0)+16>>2]&127](f,d,e);if(!d){f=b+194|0;a[f>>0]=1;i=h;return}c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0);f=b+194|0;a[f>>0]=1;i=h;return}function YB(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;c[d+0>>2]=c[b+16>>2];c[d+4>>2]=c[b+20>>2];c[d+8>>2]=c[b+24>>2];c[d+12>>2]=c[b+28>>2];c[e+0>>2]=c[b+32>>2];c[e+4>>2]=c[b+36>>2];c[e+8>>2]=c[b+40>>2];c[e+12>>2]=c[b+44>>2];return}function ZB(a,b,d,e,f,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;d=i;i=i+16|0;c[d>>2]=17144;c[d+4>>2]=e;gC(a+4|0,c[a+4>>2]|0,b,e+4|0,e+20|0,+g[e+32>>2],f,h,d);gC(a+64|0,c[a+64>>2]|0,b,e+4|0,e+20|0,+g[e+32>>2],f,h,d);i=d;return}function _B(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0;f=i;i=i+48|0;c[f+32>>2]=17064;c[f+36>>2]=e;c[f+0>>2]=c[b+0>>2];c[f+4>>2]=c[b+4>>2];c[f+8>>2]=c[b+8>>2];c[f+12>>2]=c[b+12>>2];c[f+16>>2]=c[d+0>>2];c[f+20>>2]=c[d+4>>2];c[f+24>>2]=c[d+8>>2];c[f+28>>2]=c[d+12>>2];rw(c[a+4>>2]|0,f,f+32|0);rw(c[a+64>>2]|0,f,f+32|0);i=f;return}function $B(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var j=0,k=0,l=0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0,D=0.0,E=0.0,F=0.0,G=0,H=0.0;G=i;i=i+16|0;x=+g[e>>2];A=+g[e+4>>2];B=+g[e+8>>2];E=+g[e+12>>2];y=+g[f>>2];z=+g[f+4>>2];D=+g[f+8>>2];F=+g[f+12>>2];do if((c[d+60>>2]|0)==2){k=c[d+48>>2]|0;DC(b+64|0,k)|0;h=c[b+68>>2]|0;if(h){c[5110]=(c[5110]|0)+1;RE(c[h+-4>>2]|0)}c[b+68>>2]=k;c[b+76>>2]=(c[b+76>>2]|0)+-1;k=c[b+8>>2]|0;if(!k){c[5108]=(c[5108]|0)+1;k=QE(63)|0;if((k|0)!=0?(c[(k+19&-16)+-4>>2]=k,(k+19&-16|0)!=0):0){h=(k+19&-16)+0|0;j=h+44|0;do{c[h>>2]=0;h=h+4|0}while((h|0)<(j|0));k=k+19&-16}else k=0}else c[b+8>>2]=0;c[k+32>>2]=0;c[k+36>>2]=d;c[k+40>>2]=0;g[k>>2]=x;g[k+4>>2]=A;g[k+8>>2]=B;g[k+12>>2]=E;g[k+16>>2]=y;g[k+20>>2]=z;g[k+24>>2]=D;g[k+28>>2]=F;EC(b+4|0,c[b+4>>2]|0,k);c[b+16>>2]=(c[b+16>>2]|0)+1;c[d+48>>2]=k;k=1}else{c[b+168>>2]=(c[b+168>>2]|0)+1;C=c[d+48>>2]|0;r=+g[C>>2];if(((((r<=y?(s=+g[C+16>>2],s>=x):0)?(t=+g[C+4>>2],t<=z):0)?(u=+g[C+20>>2],u>=A):0)?(v=+g[C+8>>2],v<=D):0)?(w=+g[C+24>>2],w>=B):0){H=+g[d+16>>2];o=+g[d+20>>2];n=+g[d+24>>2];m=+g[b+140>>2];p=(+g[d+32>>2]-H)*.5*m;q=m*((+g[d+36>>2]-o)*.5);m=m*((+g[d+40>>2]-n)*.5);if(x-H<0.0)p=-p;if(A-o<0.0)o=-q;else o=q;if(B-n<0.0)m=-m;if(!(!(r<=x)|!(t<=A)|!(v<=B)|!(s>=y)|!(u>=z)|!(w>=D))){k=0;break}if(p>0.0){r=x+-.05000000074505806;q=p+(y+.05000000074505806)}else{r=p+(x+-.05000000074505806);q=y+.05000000074505806}if(o>0.0){p=o+(z+.05000000074505806);o=A+-.05000000074505806}else{p=z+.05000000074505806;o=o+(A+-.05000000074505806)}if(m>0.0){n=B+-.05000000074505806;m=m+(D+.05000000074505806)}else{n=m+(B+-.05000000074505806);m=D+.05000000074505806}k=DC(b+4|0,C)|0;a:do if(k){j=c[b+12>>2]|0;if((j|0)<=-1){k=c[b+4>>2]|0;break}if((j|0)>0){l=0;h=k;while(1){k=c[h+32>>2]|0;l=l+1|0;if(!k){k=h;break a}if((l|0)>=(j|0))break;else h=k}}}else k=0;while(0);g[C>>2]=r;g[C+4>>2]=o;g[C+8>>2]=n;g[C+12>>2]=E;g[C+16>>2]=q;g[C+20>>2]=p;g[C+24>>2]=m;g[C+28>>2]=F;EC(b+4|0,k,C);c[b+172>>2]=(c[b+172>>2]|0)+1;k=1;break}k=DC(b+4|0,C)|0;b:do if(k){j=c[b+12>>2]|0;if((j|0)<=-1){k=c[b+4>>2]|0;break}if((j|0)>0){l=0;h=k;while(1){k=c[h+32>>2]|0;l=l+1|0;if(!k){k=h;break b}if((l|0)>=(j|0))break;else h=k}}}else k=0;while(0);g[C>>2]=x;g[C+4>>2]=A;g[C+8>>2]=B;g[C+12>>2]=E;g[C+16>>2]=y;g[C+20>>2]=z;g[C+24>>2]=D;g[C+28>>2]=F;EC(b+4|0,k,C);c[b+172>>2]=(c[b+172>>2]|0)+1;k=1}while(0);h=c[d+52>>2]|0;j=c[d+56>>2]|0;if(!h)c[b+(c[d+60>>2]<<2)+124>>2]=j;else c[h+56>>2]=j;h=c[d+56>>2]|0;if(h)c[h+52>>2]=c[d+52>>2];c[d+16>>2]=c[e+0>>2];c[d+20>>2]=c[e+4>>2];c[d+24>>2]=c[e+8>>2];c[d+28>>2]=c[e+12>>2];c[d+32>>2]=c[f+0>>2];c[d+36>>2]=c[f+4>>2];c[d+40>>2]=c[f+8>>2];c[d+44>>2]=c[f+12>>2];j=c[b+144>>2]|0;c[d+60>>2]=j;c[d+52>>2]=0;c[d+56>>2]=c[b+(j<<2)+124>>2];h=c[b+(j<<2)+124>>2]|0;if(h)c[h+52>>2]=d;c[b+(j<<2)+124>>2]=d;if(!k){i=G;return}a[b+194>>0]=1;if(a[b+193>>0]|0){i=G;return}c[G>>2]=17224;c[G+4>>2]=b;hC(b+64|0,c[b+64>>2]|0,c[d+48>>2]|0,G);hC(b+4|0,c[b+4>>2]|0,c[d+48>>2]|0,G);i=G;return}function aC(b,d){b=b|0;d=d|0;var e=0,f=0,h=0.0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;r=i;i=i+48|0;BC(b+4|0,(($(c[b+152>>2]|0,c[b+16>>2]|0)|0)/100|0)+1|0);if(c[b+164>>2]|0){p=(($(c[b+148>>2]|0,c[b+76>>2]|0)|0)/100|0)+1|0;BC(b+64|0,p);p=(c[b+164>>2]|0)-p|0;c[b+164>>2]=(p|0)<0?0:p}f=((c[b+144>>2]|0)+1|0)%2|0;c[b+144>>2]=f;f=c[b+(f<<2)+124>>2]|0;if(f){do{k=f+56|0;o=f;f=c[k>>2]|0;l=c[o+52>>2]|0;if(!l)c[b+(c[o+60>>2]<<2)+124>>2]=f;else c[l+56>>2]=f;j=c[k>>2]|0;if(j)c[j+52>>2]=c[o+52>>2];c[o+52>>2]=0;c[k>>2]=c[b+132>>2];j=c[b+132>>2]|0;if(j)c[j+52>>2]=o;c[b+132>>2]=o;j=c[o+48>>2]|0;DC(b+4|0,j)|0;k=c[b+8>>2]|0;if(k){c[5110]=(c[5110]|0)+1;RE(c[k+-4>>2]|0)}c[b+8>>2]=j;c[b+16>>2]=(c[b+16>>2]|0)+-1;c[r+16>>2]=c[o+16>>2];c[r+20>>2]=c[o+20>>2];c[r+24>>2]=c[o+24>>2];c[r+28>>2]=c[o+28>>2];c[r+32>>2]=c[o+32>>2];c[r+36>>2]=c[o+36>>2];c[r+40>>2]=c[o+40>>2];c[r+44>>2]=c[o+44>>2];j=c[b+68>>2]|0;if(!j){c[5108]=(c[5108]|0)+1;l=QE(63)|0;if((l|0)!=0?(c[(l+19&-16)+-4>>2]=l,(l+19&-16|0)!=0):0){k=(l+19&-16)+0|0;j=k+44|0;do{c[k>>2]=0;k=k+4|0}while((k|0)<(j|0));j=l+19&-16}else j=0}else c[b+68>>2]=0;c[j+32>>2]=0;c[j+36>>2]=o;c[j+40>>2]=0;c[j+0>>2]=c[r+16>>2];c[j+4>>2]=c[r+20>>2];c[j+8>>2]=c[r+24>>2];c[j+12>>2]=c[r+28>>2];c[j+16>>2]=c[r+32>>2];c[j+20>>2]=c[r+36>>2];c[j+24>>2]=c[r+40>>2];c[j+28>>2]=c[r+44>>2];EC(b+64|0,c[b+64>>2]|0,j);l=(c[b+76>>2]|0)+1|0;c[b+76>>2]=l;c[o+48>>2]=j;c[o+60>>2]=2}while((f|0)!=0);c[b+164>>2]=l;a[b+194>>0]=1}c[r>>2]=17224;c[r+4>>2]=b;if((a[b+193>>0]|0)!=0?(hC(b+4|0,c[b+4>>2]|0,c[b+64>>2]|0,r),(a[b+193>>0]|0)!=0):0){p=c[b+4>>2]|0;hC(b+4|0,p,p,r)}do if((a[b+194>>0]|0)!=0?(n=c[b+136>>2]|0,n=Nb[c[(c[n>>2]|0)+28>>2]&127](n)|0,e=c[n+4>>2]|0,(e|0)>0):0){f=($(c[b+156>>2]|0,e)|0)/100|0;p=c[b+160>>2]|0;f=(p|0)>(f|0)?p:f;f=(e|0)<(f|0)?e:f;if((f|0)>0){j=0;do{l=((c[b+184>>2]|0)+j|0)%(e|0)|0;o=c[n+12>>2]|0;k=c[o+(l<<4)>>2]|0;l=c[o+(l<<4)+4>>2]|0;o=c[k+48>>2]|0;p=c[l+48>>2]|0;if(!(((((+g[o>>2]<=+g[p+16>>2]?+g[o+16>>2]>=+g[p>>2]:0)?+g[o+4>>2]<=+g[p+20>>2]:0)?+g[o+20>>2]>=+g[p+4>>2]:0)?+g[o+8>>2]<=+g[p+24>>2]:0)?+g[o+24>>2]>=+g[p+8>>2]:0)){e=c[b+136>>2]|0;Rb[c[(c[e>>2]|0)+12>>2]&31](e,k,l,d)|0;e=c[n+4>>2]|0;j=j+-1|0;f=f+-1|0}j=j+1|0}while((j|0)<(f|0));if((e|0)<=0){c[b+184>>2]=0;break}}c[b+184>>2]=((c[b+184>>2]|0)+f|0)%(e|0)|0}while(0);c[b+180>>2]=(c[b+180>>2]|0)+1;c[b+160>>2]=1;a[b+194>>0]=0;e=c[b+168>>2]|0;f=c[b+172>>2]|0;if(!e)h=0.0;else h=+(f>>>0)/+(e>>>0);g[b+176>>2]=h;c[b+172>>2]=f>>>1;c[b+168>>2]=e>>>1;p=c[b+136>>2]|0;if(!(Nb[c[(c[p>>2]|0)+56>>2]&127](p)|0)){i=r;return}p=c[b+136>>2]|0;p=Nb[c[(c[p>>2]|0)+28>>2]&127](p)|0;e=c[p+4>>2]|0;if((e|0)>1){OA(p,0,e+-1|0);l=0;f=0;j=0;k=0;q=44}else{l=0;f=0;j=0;m=0}while(1){if((q|0)==44){e=c[p+4>>2]|0;m=k}if((f|0)>=(e|0))break;n=c[p+12>>2]|0;e=n+(f<<4)|0;k=c[e>>2]|0;n=n+(f<<4)+4|0;o=c[n>>2]|0;if((k|0)==(l|0))if((o|0)==(m|0)){k=m;q=54}else q=48;else{l=k;q=48}if((q|0)==48){q=0;k=c[l+48>>2]|0;m=c[o+48>>2]|0;if(((((+g[k>>2]<=+g[m+16>>2]?+g[k+16>>2]>=+g[m>>2]:0)?+g[k+4>>2]<=+g[m+20>>2]:0)?+g[k+20>>2]>=+g[m+4>>2]:0)?+g[k+8>>2]<=+g[m+24>>2]:0)?+g[k+24>>2]>=+g[m+8>>2]:0)k=o;else{k=o;q=54}}if((q|0)==54){q=c[b+136>>2]|0;pc[c[(c[q>>2]|0)+32>>2]&127](q,e,d);c[e>>2]=0;c[n>>2]=0;j=j+1|0}f=f+1|0;q=44}if((e|0)>1){OA(p,0,e+-1|0);l=c[p+4>>2]|0}else l=e;k=l-j|0;if((j|0)<0){if((c[p+8>>2]|0)<(k|0)){if((l|0)==(j|0))f=0;else{c[5108]=(c[5108]|0)+1;e=QE((k<<4|3)+16|0)|0;if(!e)f=0;else{c[(e+19&-16)+-4>>2]=e;f=e+19&-16}j=c[p+4>>2]|0}if((j|0)>0){e=0;do{q=c[p+12>>2]|0;c[f+(e<<4)>>2]=c[q+(e<<4)>>2];c[f+(e<<4)+4>>2]=c[q+(e<<4)+4>>2];c[f+(e<<4)+8>>2]=c[q+(e<<4)+8>>2];c[f+(e<<4)+12>>2]=c[q+(e<<4)+12>>2];e=e+1|0}while((e|0)!=(j|0))}e=c[p+12>>2]|0;if(e){if(a[p+16>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[e+-4>>2]|0)}c[p+12>>2]=0}a[p+16>>0]=1;c[p+12>>2]=f;c[p+8>>2]=k;f=p+12|0}else f=p+12|0;e=l;do{q=(c[f>>2]|0)+(e<<4)|0;e=e+1|0;c[q+0>>2]=0;c[q+4>>2]=0;c[q+8>>2]=0;c[q+12>>2]=0}while((e|0)!=(k|0))}c[p+4>>2]=k;i=r;return}function bC(a){a=a|0;return c[a+136>>2]|0}function cC(a){a=a|0;return c[a+136>>2]|0}function dC(a,b,d){a=a|0;b=b|0;d=d|0;var e=0.0,f=0.0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0,p=0,q=0.0,r=0.0,s=0.0,t=0.0;p=i;o=c[a+4>>2]|0;a=c[a+64>>2]|0;do if(!o)if(!a){e=0.0;n=0.0;h=0.0;k=0.0;m=0.0;l=0.0;j=0.0;f=0.0}else{e=+g[a>>2];n=+g[a+16>>2];h=+g[a+20>>2];k=+g[a+24>>2];m=+g[a+28>>2];l=+g[a+4>>2];j=+g[a+8>>2];f=+g[a+12>>2]}else{e=+g[o>>2];l=+g[o+4>>2];j=+g[o+8>>2];f=+g[o+16>>2];h=+g[o+20>>2];k=+g[o+24>>2];if(!a){n=f;m=+g[o+28>>2];f=+g[o+12>>2];break}else{t=+g[a>>2];n=+g[a+16>>2];r=+g[a+4>>2];s=+g[a+20>>2];q=+g[a+8>>2];m=+g[a+24>>2];e=e<t?e:t;n=f>n?f:n;h=h>s?h:s;k=k>m?k:m;m=0.0;l=l<r?l:r;j=j<q?j:q;f=0.0;break}}while(0);g[b>>2]=e;g[b+4>>2]=l;g[b+8>>2]=j;g[b+12>>2]=f;g[d>>2]=n;g[d+4>>2]=h;g[d+8>>2]=k;g[d+12>>2]=m;i=p;return}function eC(b,d){b=b|0;d=d|0;var e=0;e=i;if((c[b+16>>2]|0)!=(0-(c[b+76>>2]|0)|0)){i=e;return}d=c[b+4>>2]|0;if(d)CC(b+4|0,d);d=c[b+8>>2]|0;if(d){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}c[b+8>>2]=0;c[b+12>>2]=-1;d=c[b+36>>2]|0;if(d){if(a[b+40>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}c[b+36>>2]=0}a[b+40>>0]=1;c[b+36>>2]=0;c[b+28>>2]=0;c[b+32>>2]=0;c[b+20>>2]=0;d=c[b+64>>2]|0;if(d)CC(b+64|0,d);d=c[b+68>>2]|0;if(d){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}c[b+68>>2]=0;c[b+72>>2]=-1;d=c[b+96>>2]|0;if(d){if(a[b+100>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}c[b+96>>2]=0}a[b+100>>0]=1;c[b+96>>2]=0;c[b+88>>2]=0;c[b+92>>2]=0;c[b+80>>2]=0;a[b+193>>0]=0;a[b+194>>0]=1;c[b+144>>2]=0;c[b+164>>2]=0;c[b+148>>2]=1;c[b+152>>2]=0;c[b+156>>2]=10;c[b+160>>2]=1;c[b+124>>2]=0;c[b+128>>2]=0;c[b+132>>2]=0;c[b+168>>2]=0;c[b+172>>2]=0;c[b+176>>2]=0;c[b+180>>2]=0;c[b+184>>2]=0;c[b+188>>2]=0;i=e;return}function fC(a){a=a|0;return}function gC(b,d,e,f,h,j,k,l,m){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;j=+j;k=k|0;l=l|0;m=m|0;var n=0,o=0,p=0,q=0,r=0,s=0.0,t=0.0,u=0.0,v=0.0,w=0,x=0,y=0,z=0.0,A=0.0,B=0.0,C=0.0,D=0,E=0.0;D=i;i=i+32|0;if(!d){i=D;return}o=c[b+44>>2]|0;if((o|0)<128){if((c[b+48>>2]|0)<128){c[5108]=(c[5108]|0)+1;n=QE(531)|0;if(!n)r=0;else{c[(n+19&-16)+-4>>2]=n;r=n+19&-16}p=c[b+44>>2]|0;if((p|0)>0){q=0;do{n=r+(q<<2)|0;if(n)c[n>>2]=c[(c[b+52>>2]|0)+(q<<2)>>2];q=q+1|0}while((q|0)!=(p|0))}n=c[b+52>>2]|0;if(n){if(a[b+56>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[n+-4>>2]|0)}c[b+52>>2]=0}a[b+56>>0]=1;c[b+52>>2]=r;c[b+48>>2]=128;p=b+52|0}else p=b+52|0;do{n=(c[p>>2]|0)+(o<<2)|0;if(n)c[n>>2]=0;o=o+1|0}while((o|0)!=128);y=b+48|0}else y=b+48|0;c[b+44>>2]=128;c[c[b+52>>2]>>2]=d;n=1;o=126;do{x=n+-1|0;p=c[b+52>>2]|0;w=c[p+(x<<2)>>2]|0;t=+g[w+4>>2]-+g[l+4>>2];v=+g[w+8>>2]-+g[l+8>>2];g[D>>2]=+g[w>>2]-+g[l>>2];g[D+4>>2]=t;g[D+8>>2]=v;g[D+12>>2]=0.0;v=+g[w+20>>2]-+g[k+4>>2];t=+g[w+24>>2]-+g[k+8>>2];g[D+16>>2]=+g[w+16>>2]-+g[k>>2];g[D+20>>2]=v;g[D+24>>2]=t;g[D+28>>2]=0.0;d=c[h>>2]|0;t=+g[e>>2];v=+g[f>>2];s=(+g[D+(d<<4)>>2]-t)*v;t=v*(+g[D+(1-d<<4)>>2]-t);d=c[h+4>>2]|0;v=+g[e+4>>2];E=+g[f+4>>2];u=(+g[D+(d<<4)+4>>2]-v)*E;v=E*(+g[D+(1-d<<4)+4>>2]-v);do if(((!(s>v|u>t)?(z=u>s?u:s,C=v<t?v:t,d=c[h+8>>2]|0,B=+g[e+8>>2],s=+g[f+8>>2],A=(+g[D+(d<<4)+8>>2]-B)*s,B=s*(+g[D+(1-d<<4)+8>>2]-B),!(z>B|A>C)):0)?(A>z?A:z)<j:0)?(B<C?B:C)>0.0:0){if(!(c[w+40>>2]|0)){Lb[c[(c[m>>2]|0)+12>>2]&127](m,w);n=x;break}if((x|0)>(o|0)){d=c[b+44>>2]|0;if((d|0)<(d<<1|0)){if((c[y>>2]|0)<(d<<1|0)){if(d){c[5108]=(c[5108]|0)+1;p=QE((d<<3|3)+16|0)|0;if(!p)p=0;else{c[(p+19&-16)+-4>>2]=p;p=p+19&-16}r=c[b+44>>2]|0;if((r|0)>0){o=0;do{q=p+(o<<2)|0;if(q)c[q>>2]=c[(c[b+52>>2]|0)+(o<<2)>>2];o=o+1|0}while((o|0)!=(r|0))}}else p=0;q=c[b+52>>2]|0;if(q){if(a[b+56>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[q+-4>>2]|0)}c[b+52>>2]=0}a[b+56>>0]=1;c[b+52>>2]=p;c[y>>2]=d<<1;q=d}else q=d;do{r=p+(q<<2)|0;if(r){c[r>>2]=0;p=c[b+52>>2]|0}q=q+1|0}while((q|0)!=(d<<1|0))}c[b+44>>2]=d<<1;o=(d<<1)+-2|0}c[p+(x<<2)>>2]=c[w+36>>2];c[(c[b+52>>2]|0)+(n<<2)>>2]=c[w+40>>2];n=n+1|0}else n=x;while(0)}while((n|0)!=0);i=D;return}function hC(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0;q=i;if(!((d|0)!=0&(e|0)!=0)){i=q;return}if((c[b+24>>2]|0)<128?(c[b+28>>2]|0)<128:0){c[5108]=(c[5108]|0)+1;h=QE(1043)|0;if(!h)l=0;else{c[(h+19&-16)+-4>>2]=h;l=h+19&-16}h=c[b+24>>2]|0;if((h|0)>0){k=0;do{j=l+(k<<3)|0;if(j){o=(c[b+32>>2]|0)+(k<<3)|0;p=c[o+4>>2]|0;c[j>>2]=c[o>>2];c[j+4>>2]=p}k=k+1|0}while((k|0)!=(h|0))}h=c[b+32>>2]|0;if(h){if(a[b+36>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[h+-4>>2]|0)}c[b+32>>2]=0}a[b+36>>0]=1;c[b+32>>2]=l;c[b+28>>2]=128;p=b+28|0}else p=b+28|0;c[b+24>>2]=128;h=c[b+32>>2]|0;c[h>>2]=d;c[h+4>>2]=e;h=1;l=124;while(1){m=h+-1|0;k=c[b+32>>2]|0;n=c[k+(m<<3)>>2]|0;o=c[k+(m<<3)+4>>2]|0;if((m|0)>(l|0)){j=c[b+24>>2]|0;if((j|0)<(j<<1|0)?(c[p>>2]|0)<(j<<1|0):0){if(j){c[5108]=(c[5108]|0)+1;k=QE((j<<4|3)+16|0)|0;if(!k)k=0;else{c[(k+19&-16)+-4>>2]=k;k=k+19&-16}e=c[b+24>>2]|0;if((e|0)>0){l=0;do{d=k+(l<<3)|0;if(d){s=(c[b+32>>2]|0)+(l<<3)|0;r=c[s+4>>2]|0;c[d>>2]=c[s>>2];c[d+4>>2]=r}l=l+1|0}while((l|0)!=(e|0))}}else k=0;l=c[b+32>>2]|0;if(l){if(a[b+36>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[l+-4>>2]|0)}c[b+32>>2]=0}a[b+36>>0]=1;c[b+32>>2]=k;c[p>>2]=j<<1}c[b+24>>2]=j<<1;d=(j<<1)+-4|0}else d=l;do if((n|0)==(o|0))if(!(c[n+40>>2]|0))h=m;else{e=c[n+36>>2]|0;o=k+(m<<3)|0;c[o>>2]=e;c[o+4>>2]=e;o=c[n+40>>2]|0;m=(c[b+32>>2]|0)+(h<<3)|0;c[m>>2]=o;c[m+4>>2]=o;m=c[n+40>>2]|0;o=(c[b+32>>2]|0)+(h+1<<3)|0;c[o>>2]=c[n+36>>2];c[o+4>>2]=m;h=h+2|0}else if(((((+g[n>>2]<=+g[o+16>>2]?+g[n+16>>2]>=+g[o>>2]:0)?+g[n+4>>2]<=+g[o+20>>2]:0)?+g[n+20>>2]>=+g[o+4>>2]:0)?+g[n+8>>2]<=+g[o+24>>2]:0)?+g[n+24>>2]>=+g[o+8>>2]:0){e=(c[o+40>>2]|0)!=0;if(!(c[n+40>>2]|0))if(e){e=c[o+36>>2]|0;m=k+(m<<3)|0;c[m>>2]=n;c[m+4>>2]=e;m=c[o+40>>2]|0;o=(c[b+32>>2]|0)+(h<<3)|0;c[o>>2]=n;c[o+4>>2]=m;h=h+1|0;break}else{pc[c[(c[f>>2]|0)+8>>2]&127](f,n,o);h=m;break}else{k=k+(m<<3)|0;l=c[n+36>>2]|0;if(e){m=c[o+36>>2]|0;c[k>>2]=l;c[k+4>>2]=m;m=c[o+36>>2]|0;e=(c[b+32>>2]|0)+(h<<3)|0;c[e>>2]=c[n+40>>2];c[e+4>>2]=m;e=c[o+40>>2]|0;m=(c[b+32>>2]|0)+(h+1<<3)|0;c[m>>2]=c[n+36>>2];c[m+4>>2]=e;m=c[o+40>>2]|0;o=(c[b+32>>2]|0)+(h+2<<3)|0;c[o>>2]=c[n+40>>2];c[o+4>>2]=m;h=h+3|0;break}else{c[k>>2]=l;c[k+4>>2]=o;m=(c[b+32>>2]|0)+(h<<3)|0;c[m>>2]=c[n+40>>2];c[m+4>>2]=o;h=h+1|0;break}}}else h=m;while(0);if(!h)break;else l=d}i=q;return}function iC(a,b){a=a|0;b=b|0;var d=0;d=i;a=c[a+4>>2]|0;ec[c[(c[a>>2]|0)+8>>2]&31](a,c[b+36>>2]|0)|0;i=d;return}function jC(a){a=a|0;var b=0;b=i;RE(a);i=b;return}function kC(a,b){a=a|0;b=b|0;var d=0;d=i;a=c[a+4>>2]|0;ec[c[(c[a>>2]|0)+8>>2]&31](a,c[b+36>>2]|0)|0;i=d;return}function lC(a){a=a|0;var b=0;b=i;RE(a);i=b;return}function mC(a,b){a=a|0;b=b|0;var d=0;d=i;pc[c[(c[a>>2]|0)+8>>2]&127](a,b,c[(c[a+8>>2]|0)+48>>2]|0);i=d;return}function nC(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;e=i;if((b|0)==(d|0)){i=e;return}f=c[(c[a+4>>2]|0)+136>>2]|0;Wb[c[(c[f>>2]|0)+8>>2]&63](f,c[b+36>>2]|0,c[d+36>>2]|0)|0;b=(c[a+4>>2]|0)+160|0;c[b>>2]=(c[b>>2]|0)+1;i=e;return}function oC(a){a=a|0;var b=0;b=i;RE(a);i=b;return}
function lp(a,c){a=a|0;c=c|0;var d=0;d=i;if(!((b[c+4>>1]&b[a+10>>1])<<16>>16)){c=0;i=d;return c|0}c=(b[a+8>>1]&b[c+6>>1])<<16>>16!=0;i=d;return c|0}function mp(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0;f=i;g[a+4>>2]=+g[b+40>>2];e=c[b>>2]|0;c[a+76>>2]=e;if(d){c[a+44>>2]=c[b+8>>2];c[a+48>>2]=c[b+12>>2];c[a+52>>2]=c[b+16>>2];c[a+56>>2]=c[b+20>>2];e=a+60|0;d=b+24|0;c[e+0>>2]=c[d+0>>2];c[e+4>>2]=c[d+4>>2];c[e+8>>2]=c[d+8>>2];c[e+12>>2]=c[d+12>>2];h=+g[b+40>>2];i=f;return +h}else{m=+g[b+8>>2];l=+g[b+12>>2];k=+g[b+16>>2];j=+g[e+20>>2]*m+ +g[e+24>>2]*l+ +g[e+28>>2]*k;h=+g[e+36>>2]*m+ +g[e+40>>2]*l+ +g[e+44>>2]*k;g[a+44>>2]=+g[e+4>>2]*m+ +g[e+8>>2]*l+ +g[e+12>>2]*k;g[a+48>>2]=j;g[a+52>>2]=h;g[a+56>>2]=0.0;e=a+60|0;d=b+24|0;c[e+0>>2]=c[d+0>>2];c[e+4>>2]=c[d+4>>2];c[e+8>>2]=c[d+8>>2];c[e+12>>2]=c[d+12>>2];h=+g[b+40>>2];i=f;return +h}return 0.0}function np(a){a=a|0;return}function op(a){a=a|0;return}function pp(a){a=a|0;var b=0;b=i;RE(a);i=b;return}function qp(a,c){a=a|0;c=c|0;var d=0;d=i;if(!((b[c+4>>1]&b[a+6>>1])<<16>>16)){c=0;i=d;return c|0}c=(b[a+4>>1]&b[c+6>>1])<<16>>16!=0;i=d;return c|0}function rp(a,b,c,d,e,f,g,h){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0.0,k=0;k=i;j=+Ta(1152,a|0,b|0,c|0,d|0,e|0,f|0,g|0,h|0);i=k;return +j}function sp(b,d){b=b|0;d=d|0;var e=0,f=0.0,h=0,j=0.0,k=0,l=0,m=0.0,n=0.0,o=0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0;o=i;c[b+236>>2]=2;c[b+312>>2]=0;c[b+316>>2]=0;c[b+320>>2]=0;c[b+324>>2]=0;c[b+328>>2]=0;c[b+332>>2]=0;c[b+336>>2]=0;c[b+340>>2]=0;g[b+544>>2]=1.0;g[b+548>>2]=1.0;g[b+552>>2]=1.0;g[b+556>>2]=0.0;g[b+348>>2]=1.0;g[b+352>>2]=1.0;g[b+356>>2]=1.0;e=b+360|0;h=e+36|0;do{c[e>>2]=0;e=e+4|0}while((e|0)<(h|0));c[b+412>>2]=0;c[b+416>>2]=0;c[b+420>>2]=0;c[b+424>>2]=0;c[b+428>>2]=0;c[b+432>>2]=0;c[b+436>>2]=0;c[b+440>>2]=0;f=+g[d+92>>2];j=+g[d+96>>2];if(f<0.0)f=0.0;else f=f>1.0?1.0:f;g[b+444>>2]=f;if(j<0.0)f=0.0;else f=j>1.0?1.0:j;g[b+448>>2]=f;g[b+472>>2]=+g[d+112>>2];g[b+476>>2]=+g[d+116>>2];e=c[d+4>>2]|0;c[b+480>>2]=e;c[b+608>>2]=0;c[b+612>>2]=0;a[b+452>>0]=a[d+120>>0]|0;g[b+456>>2]=+g[d+124>>2];g[b+460>>2]=+g[d+128>>2];g[b+464>>2]=+g[d+132>>2];g[b+468>>2]=+g[d+136>>2];if(!e){c[b+4>>2]=c[d+8>>2];c[b+8>>2]=c[d+12>>2];c[b+12>>2]=c[d+16>>2];c[b+16>>2]=c[d+20>>2];c[b+20>>2]=c[d+24>>2];c[b+24>>2]=c[d+28>>2];c[b+28>>2]=c[d+32>>2];c[b+32>>2]=c[d+36>>2];c[b+36>>2]=c[d+40>>2];c[b+40>>2]=c[d+44>>2];c[b+44>>2]=c[d+48>>2];c[b+48>>2]=c[d+52>>2];c[b+52>>2]=c[d+56>>2];c[b+56>>2]=c[d+60>>2];c[b+60>>2]=c[d+64>>2];c[b+64>>2]=c[d+68>>2];h=b+20|0;e=b+36|0;k=b+52|0;l=b+4|0}else{Lb[c[(c[e>>2]|0)+8>>2]&127](e,b+4|0);h=b+20|0;e=b+36|0;k=b+52|0;l=b+4|0}c[b+68>>2]=c[l+0>>2];c[b+72>>2]=c[l+4>>2];c[b+76>>2]=c[l+8>>2];c[b+80>>2]=c[l+12>>2];c[b+84>>2]=c[h+0>>2];c[b+88>>2]=c[h+4>>2];c[b+92>>2]=c[h+8>>2];c[b+96>>2]=c[h+12>>2];c[b+100>>2]=c[e+0>>2];c[b+104>>2]=c[e+4>>2];c[b+108>>2]=c[e+8>>2];c[b+112>>2]=c[e+12>>2];c[b+116>>2]=c[k+0>>2];c[b+120>>2]=c[k+4>>2];c[b+124>>2]=c[k+8>>2];c[b+128>>2]=c[k+12>>2];c[b+132>>2]=0;c[b+136>>2]=0;c[b+140>>2]=0;c[b+144>>2]=0;c[b+148>>2]=0;c[b+152>>2]=0;c[b+156>>2]=0;c[b+160>>2]=0;g[b+224>>2]=+g[d+100>>2];g[b+232>>2]=+g[d+104>>2];g[b+228>>2]=+g[d+108>>2];Lb[c[(c[b>>2]|0)+12>>2]&127](b,c[d+72>>2]|0);e=c[374]|0;c[374]=e+1;c[b+508>>2]=e;j=+g[d>>2];e=c[b+204>>2]|0;if(j==0.0){c[b+204>>2]=e|1;n=0.0}else{c[b+204>>2]=e&-2;n=1.0/j}g[b+344>>2]=n;m=j*+g[b+384>>2];f=j*+g[b+388>>2];g[b+364>>2]=j*+g[b+380>>2];g[b+368>>2]=m;g[b+372>>2]=f;g[b+376>>2]=0.0;f=+g[d+76>>2];if(f!=0.0)m=1.0/f;else m=0.0;j=+g[d+80>>2];if(j!=0.0)f=1.0/j;else f=0.0;j=+g[d+84>>2];if(j!=0.0)j=1.0/j;else j=0.0;g[b+396>>2]=m;g[b+400>>2]=f;g[b+404>>2]=j;g[b+408>>2]=0.0;D=n*+g[b+352>>2];x=n*+g[b+356>>2];g[b+560>>2]=n*+g[b+348>>2];g[b+564>>2]=D;g[b+568>>2]=x;g[b+572>>2]=0.0;x=+g[b+4>>2];D=x*m;w=+g[b+8>>2];C=w*f;v=+g[b+12>>2];B=v*j;u=+g[b+20>>2];A=m*u;t=+g[b+24>>2];z=f*t;s=+g[b+28>>2];y=j*s;r=+g[b+36>>2];q=m*r;p=+g[b+40>>2];n=f*p;f=+g[b+44>>2];m=j*f;g[b+264>>2]=x*D+w*C+v*B;g[b+268>>2]=D*u+C*t+B*s;g[b+272>>2]=D*r+C*p+B*f;g[b+276>>2]=0.0;g[b+280>>2]=x*A+w*z+v*y;g[b+284>>2]=u*A+t*z+s*y;g[b+288>>2]=A*r+z*p+y*f;g[b+292>>2]=0.0;g[b+296>>2]=x*q+w*n+v*m;g[b+300>>2]=u*q+t*n+s*m;g[b+304>>2]=r*q+p*n+f*m;g[b+308>>2]=0.0;c[b+504>>2]=0;c[b+512>>2]=0;c[b+516>>2]=0;c[b+520>>2]=0;c[b+524>>2]=0;c[b+528>>2]=0;c[b+532>>2]=0;c[b+536>>2]=0;c[b+540>>2]=0;m=+g[b+344>>2];j=m*+g[b+352>>2];f=m*+g[b+356>>2];g[b+560>>2]=+g[b+348>>2]*m;g[b+564>>2]=j;g[b+568>>2]=f;e=b+572|0;h=e+36|0;do{c[e>>2]=0;e=e+4|0}while((e|0)<(h|0));i=o;return}function tp(b,d,e,f,h){b=b|0;d=+d;e=e|0;f=f|0;h=h|0;var j=0;j=i;i=i+144|0;g[b+164>>2]=1.0;g[b+168>>2]=1.0;g[b+172>>2]=1.0;g[b+176>>2]=0.0;c[b+180>>2]=0;g[b+184>>2]=999999984306749440.0;c[b+188>>2]=0;c[b+192>>2]=0;c[b+196>>2]=0;c[b+200>>2]=0;c[b+204>>2]=1;c[b+208>>2]=-1;c[b+212>>2]=-1;c[b+216>>2]=1;g[b+220>>2]=0.0;g[b+224>>2]=.5;g[b+228>>2]=0.0;g[b+232>>2]=0.0;c[b+236>>2]=1;c[b+240>>2]=0;g[b+244>>2]=1.0;c[b+248>>2]=0;c[b+252>>2]=0;c[b+256>>2]=0;c[b+260>>2]=0;g[b+4>>2]=1.0;c[b+8>>2]=0;c[b+12>>2]=0;c[b+16>>2]=0;c[b+20>>2]=0;g[b+24>>2]=1.0;c[b+28>>2]=0;c[b+32>>2]=0;c[b+36>>2]=0;c[b+40>>2]=0;g[b+44>>2]=1.0;c[b+48>>2]=0;c[b+52>>2]=0;c[b+56>>2]=0;c[b+60>>2]=0;c[b+64>>2]=0;c[b>>2]=1464;a[b+500>>0]=1;c[b+496>>2]=0;c[b+488>>2]=0;c[b+492>>2]=0;g[j>>2]=d;c[j+4>>2]=e;c[j+72>>2]=f;c[j+76>>2]=c[h+0>>2];c[j+80>>2]=c[h+4>>2];c[j+84>>2]=c[h+8>>2];c[j+88>>2]=c[h+12>>2];g[j+92>>2]=0.0;g[j+96>>2]=0.0;g[j+100>>2]=.5;g[j+104>>2]=0.0;g[j+108>>2]=0.0;g[j+112>>2]=.800000011920929;g[j+116>>2]=1.0;a[j+120>>0]=0;g[j+124>>2]=.004999999888241291;g[j+128>>2]=.009999999776482582;g[j+132>>2]=.009999999776482582;g[j+136>>2]=.009999999776482582;g[j+8>>2]=1.0;c[j+12>>2]=0;c[j+16>>2]=0;c[j+20>>2]=0;c[j+24>>2]=0;g[j+28>>2]=1.0;c[j+32>>2]=0;c[j+36>>2]=0;c[j+40>>2]=0;c[j+44>>2]=0;g[j+48>>2]=1.0;c[j+52>>2]=0;c[j+56>>2]=0;c[j+60>>2]=0;c[j+64>>2]=0;c[j+68>>2]=0;sp(b,j);i=j;return}function up(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,h=0,i=0,j=0,k=0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0;if(!(c[a+204>>2]&2)){c[a+68>>2]=c[b+0>>2];c[a+72>>2]=c[b+4>>2];c[a+76>>2]=c[b+8>>2];c[a+80>>2]=c[b+12>>2];c[a+84>>2]=c[b+16>>2];c[a+88>>2]=c[b+20>>2];c[a+92>>2]=c[b+24>>2];c[a+96>>2]=c[b+28>>2];c[a+100>>2]=c[b+32>>2];c[a+104>>2]=c[b+36>>2];c[a+108>>2]=c[b+40>>2];c[a+112>>2]=c[b+44>>2];c[a+116>>2]=c[b+48>>2];c[a+120>>2]=c[b+52>>2];c[a+124>>2]=c[b+56>>2];c[a+128>>2]=c[b+60>>2];e=b;f=a+20|0;h=b+16|0;i=a+36|0;j=b+32|0;k=a+52|0;b=b+48|0;d=a+4|0}else{c[a+68>>2]=c[a+4>>2];c[a+72>>2]=c[a+8>>2];c[a+76>>2]=c[a+12>>2];c[a+80>>2]=c[a+16>>2];c[a+84>>2]=c[a+20>>2];c[a+88>>2]=c[a+24>>2];c[a+92>>2]=c[a+28>>2];c[a+96>>2]=c[a+32>>2];c[a+100>>2]=c[a+36>>2];c[a+104>>2]=c[a+40>>2];c[a+108>>2]=c[a+44>>2];c[a+112>>2]=c[a+48>>2];c[a+116>>2]=c[a+52>>2];c[a+120>>2]=c[a+56>>2];c[a+124>>2]=c[a+60>>2];c[a+128>>2]=c[a+64>>2];e=b;f=a+20|0;h=b+16|0;i=a+36|0;j=b+32|0;k=a+52|0;b=b+48|0;d=a+4|0}c[a+132>>2]=c[a+312>>2];c[a+136>>2]=c[a+316>>2];c[a+140>>2]=c[a+320>>2];c[a+144>>2]=c[a+324>>2];c[a+148>>2]=c[a+328>>2];c[a+152>>2]=c[a+332>>2];c[a+156>>2]=c[a+336>>2];c[a+160>>2]=c[a+340>>2];c[d+0>>2]=c[e+0>>2];c[d+4>>2]=c[e+4>>2];c[d+8>>2]=c[e+8>>2];c[d+12>>2]=c[e+12>>2];c[f+0>>2]=c[h+0>>2];c[f+4>>2]=c[h+4>>2];c[f+8>>2]=c[h+8>>2];c[f+12>>2]=c[h+12>>2];c[i+0>>2]=c[j+0>>2];c[i+4>>2]=c[j+4>>2];c[i+8>>2]=c[j+8>>2];c[i+12>>2]=c[j+12>>2];c[k+0>>2]=c[b+0>>2];c[k+4>>2]=c[b+4>>2];c[k+8>>2]=c[b+8>>2];c[k+12>>2]=c[b+12>>2];w=+g[a+4>>2];q=+g[a+396>>2];v=+g[a+8>>2];o=+g[a+400>>2];u=+g[a+12>>2];m=+g[a+404>>2];t=+g[a+20>>2];s=+g[a+24>>2];r=+g[a+28>>2];p=+g[a+36>>2];n=+g[a+40>>2];l=+g[a+44>>2];g[a+264>>2]=w*(w*q)+v*(v*o)+u*(u*m);g[a+268>>2]=w*q*t+v*o*s+u*m*r;g[a+272>>2]=w*q*p+v*o*n+u*m*l;g[a+276>>2]=0.0;g[a+280>>2]=w*(q*t)+v*(o*s)+u*(m*r);g[a+284>>2]=t*(q*t)+s*(o*s)+r*(m*r);g[a+288>>2]=q*t*p+o*s*n+m*r*l;g[a+292>>2]=0.0;g[a+296>>2]=w*(q*p)+v*(o*n)+u*(m*l);g[a+300>>2]=t*(q*p)+s*(o*n)+r*(m*l);g[a+304>>2]=p*(q*p)+n*(o*n)+l*(m*l);g[a+308>>2]=0.0;return}function vp(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0;h=i;g=(c[d+236>>2]&2|0)==0?0:d;if(!g){d=1;i=h;return d|0}f=c[b+488>>2]|0;if((f|0)<=0){d=1;i=h;return d|0}b=c[b+496>>2]|0;e=0;while(1){d=c[b+(e<<2)>>2]|0;if(a[d+20>>0]|0){if((c[d+28>>2]|0)==(g|0)){d=0;b=8;break}if((c[d+32>>2]|0)==(g|0)){d=0;b=8;break}}e=e+1|0;if((e|0)>=(f|0)){d=1;b=8;break}}if((b|0)==8){i=h;return d|0}return 0}function wp(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0;k=i;e=c[b+488>>2]|0;a:do if((e|0)>0){g=c[b+496>>2]|0;f=0;while(1){h=f+1|0;if((c[g+(f<<2)>>2]|0)==(d|0))break;if((h|0)<(e|0))f=h;else break a}if((f|0)!=(e|0)){e=b+256|0;c[e>>2]=1;i=k;return}}while(0);if((e|0)==(c[b+492>>2]|0)?(j=(e|0)==0?1:e<<1,(e|0)<(j|0)):0){if(!j)f=0;else{c[5108]=(c[5108]|0)+1;f=QE((j<<2|3)+16|0)|0;if(!f)f=0;else{c[(f+19&-16)+-4>>2]=f;f=f+19&-16}e=c[b+488>>2]|0}if((e|0)>0){h=0;do{g=f+(h<<2)|0;if(g)c[g>>2]=c[(c[b+496>>2]|0)+(h<<2)>>2];h=h+1|0}while((h|0)!=(e|0))}g=c[b+496>>2]|0;if(g){if(a[b+500>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[g+-4>>2]|0);e=c[b+488>>2]|0}c[b+496>>2]=0}a[b+500>>0]=1;c[b+496>>2]=f;c[b+492>>2]=j}f=(c[b+496>>2]|0)+(e<<2)|0;if(f)c[f>>2]=d;c[b+488>>2]=e+1;e=b+256|0;c[e>>2]=1;i=k;return}function xp(a){a=a|0;return 488}function yp(a,b,e){a=a|0;b=b|0;e=e|0;var f=0;f=i;Gs(a,b,e)|0;g[b+256>>2]=+g[a+264>>2];g[b+260>>2]=+g[a+268>>2];g[b+264>>2]=+g[a+272>>2];g[b+268>>2]=+g[a+276>>2];g[b+272>>2]=+g[a+280>>2];g[b+276>>2]=+g[a+284>>2];g[b+280>>2]=+g[a+288>>2];g[b+284>>2]=+g[a+292>>2];g[b+288>>2]=+g[a+296>>2];g[b+292>>2]=+g[a+300>>2];g[b+296>>2]=+g[a+304>>2];g[b+300>>2]=+g[a+308>>2];g[b+304>>2]=+g[a+312>>2];g[b+308>>2]=+g[a+316>>2];g[b+312>>2]=+g[a+320>>2];g[b+316>>2]=+g[a+324>>2];g[b+320>>2]=+g[a+328>>2];g[b+324>>2]=+g[a+332>>2];g[b+328>>2]=+g[a+336>>2];g[b+332>>2]=+g[a+340>>2];g[b+448>>2]=+g[a+344>>2];g[b+336>>2]=+g[a+544>>2];g[b+340>>2]=+g[a+548>>2];g[b+344>>2]=+g[a+552>>2];g[b+348>>2]=+g[a+556>>2];g[b+352>>2]=+g[a+348>>2];g[b+356>>2]=+g[a+352>>2];g[b+360>>2]=+g[a+356>>2];g[b+364>>2]=+g[a+360>>2];g[b+368>>2]=+g[a+364>>2];g[b+372>>2]=+g[a+368>>2];g[b+376>>2]=+g[a+372>>2];g[b+380>>2]=+g[a+376>>2];g[b+384>>2]=+g[a+380>>2];g[b+388>>2]=+g[a+384>>2];g[b+392>>2]=+g[a+388>>2];g[b+396>>2]=+g[a+392>>2];g[b+400>>2]=+g[a+396>>2];g[b+404>>2]=+g[a+400>>2];g[b+408>>2]=+g[a+404>>2];g[b+412>>2]=+g[a+408>>2];g[b+416>>2]=+g[a+412>>2];g[b+420>>2]=+g[a+416>>2];g[b+424>>2]=+g[a+420>>2];g[b+428>>2]=+g[a+424>>2];g[b+432>>2]=+g[a+428>>2];g[b+436>>2]=+g[a+432>>2];g[b+440>>2]=+g[a+436>>2];g[b+444>>2]=+g[a+440>>2];g[b+452>>2]=+g[a+444>>2];g[b+456>>2]=+g[a+448>>2];c[b+484>>2]=d[a+452>>0];g[b+460>>2]=+g[a+456>>2];g[b+464>>2]=+g[a+460>>2];g[b+468>>2]=+g[a+464>>2];g[b+472>>2]=+g[a+468>>2];g[b+476>>2]=+g[a+472>>2];g[b+480>>2]=+g[a+476>>2];i=f;return 1504}function zp(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;d=i;e=c[(c[b>>2]|0)+16>>2]|0;f=Nb[c[(c[a>>2]|0)+16>>2]&127](a)|0;f=Wb[e&63](b,f,1)|0;e=Wb[c[(c[a>>2]|0)+20>>2]&63](a,c[f+8>>2]|0,b)|0;Hb[c[(c[b>>2]|0)+20>>2]&31](b,f,e,1497645650,a);i=d;return}function Ap(a,b,c,d,e,f,h){a=a|0;b=+b;c=+c;d=+d;e=e|0;f=+f;h=h|0;var j=0.0,k=0.0,l=0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0;l=i;i=i+16|0;k=c*f+ +g[a+52>>2];j=d*f+ +g[a+56>>2];g[h+48>>2]=b*f+ +g[a+48>>2];g[h+52>>2]=k;g[h+56>>2]=j;g[h+60>>2]=0.0;j=+g[e>>2];k=+g[e+4>>2];c=+g[e+8>>2];b=+P(+(j*j+k*k+c*c));if(b*f>.7853981852531433)b=.7853981852531433/f;if(b<1.0000000474974513e-03)d=f*.5-b*(f*f*f*.02083333395421505*b);else d=+S(+(b*.5*f))/b;o=d*j;k=d*k;d=d*c;q=+R(+(b*f*.5));Fc(a,l);n=+g[l>>2];p=+g[l+12>>2];f=+g[l+8>>2];b=+g[l+4>>2];r=1.0/+P(+((q*p-o*n-k*b-d*f)*(q*p-o*n-k*b-d*f)+((d*p+q*f+o*b-k*n)*(d*p+q*f+o*b-k*n)+((q*n+o*p+k*f-d*b)*(q*n+o*p+k*f-d*b)+(d*n+(k*p+q*b)-o*f)*(d*n+(k*p+q*b)-o*f)))));j=(q*n+o*p+k*f-d*b)*r;c=r*(d*n+(k*p+q*b)-o*f);m=r*(d*p+q*f+o*b-k*n);f=r*(q*p-o*n-k*b-d*f);d=j*(2.0/(f*f+(m*m+(j*j+c*c))));b=2.0/(f*f+(m*m+(j*j+c*c)))*c;k=2.0/(f*f+(m*m+(j*j+c*c)))*m;g[h>>2]=1.0-(m*k+c*b);g[h+4>>2]=j*b-f*k;g[h+8>>2]=j*k+f*b;g[h+12>>2]=0.0;g[h+16>>2]=f*k+j*b;g[h+20>>2]=1.0-(j*d+m*k);g[h+24>>2]=c*k-f*d;g[h+28>>2]=0.0;g[h+32>>2]=j*k-f*b;g[h+36>>2]=f*d+c*k;g[h+40>>2]=1.0-(j*d+c*b);g[h+44>>2]=0.0;i=l;return}function Bp(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0.0,f=0.0,h=0.0,j=0.0,k=0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0;k=i;i=i+64|0;j=+g[a+20>>2];t=+g[a+40>>2];o=+g[a+24>>2];r=+g[a+36>>2];s=+g[a+32>>2];h=+g[a+16>>2];l=+g[a>>2];f=+g[a+4>>2];p=+g[a+8>>2];m=1.0/((j*t-o*r)*l+f*(o*s-t*h)+(r*h-j*s)*p);z=+g[b>>2];y=+g[b+4>>2];x=+g[b+8>>2];w=+g[b+16>>2];v=+g[b+20>>2];u=+g[b+24>>2];q=+g[b+32>>2];n=+g[b+36>>2];e=+g[b+40>>2];g[k+16>>2]=(j*t-o*r)*m*z+(o*s-t*h)*m*y+(r*h-j*s)*m*x;g[k+20>>2]=z*(m*(r*p-t*f))+y*(m*(t*l-s*p))+m*(s*f-r*l)*x;g[k+24>>2]=z*(m*(o*f-j*p))+y*(m*(h*p-o*l))+m*(j*l-h*f)*x;g[k+28>>2]=0.0;g[k+32>>2]=(j*t-o*r)*m*w+(o*s-t*h)*m*v+(r*h-j*s)*m*u;g[k+36>>2]=m*(r*p-t*f)*w+m*(t*l-s*p)*v+m*(s*f-r*l)*u;g[k+40>>2]=m*(o*f-j*p)*w+m*(h*p-o*l)*v+m*(j*l-h*f)*u;g[k+44>>2]=0.0;g[k+48>>2]=(j*t-o*r)*m*q+(o*s-t*h)*m*n+(r*h-j*s)*m*e;g[k+52>>2]=m*(r*p-t*f)*q+m*(t*l-s*p)*n+m*(s*f-r*l)*e;g[k+56>>2]=m*(o*f-j*p)*q+m*(h*p-o*l)*n+m*(j*l-h*f)*e;g[k+60>>2]=0.0;Fc(k+16|0,k);e=+g[k>>2];f=+g[k+4>>2];h=+g[k+8>>2];l=+g[k+12>>2];j=1.0/+P(+(e*e+f*f+h*h+l*l));g[k>>2]=e*j;g[k+4>>2]=f*j;g[k+8>>2]=h*j;g[k+12>>2]=l*j;l=l*j<-1.0?-1.0:l*j;g[d>>2]=+U(+(l>1.0?1.0:l))*2.0;g[c>>2]=e*j;g[c+4>>2]=f*j;g[c+8>>2]=h*j;g[c+12>>2]=0.0;if(e*j*(e*j)+f*j*(f*j)+h*j*(h*j)<1.4210854715202004e-14){g[c>>2]=1.0;g[c+4>>2]=0.0;g[c+8>>2]=0.0;g[c+12>>2]=0.0;i=k;return}else{o=1.0/+P(+(e*j*(e*j)+f*j*(f*j)+h*j*(h*j)));g[c>>2]=e*j*o;g[c+4>>2]=o*(f*j);g[c+8>>2]=o*(h*j);i=k;return}}function Cp(a,b){a=a|0;b=b|0;c[a+260>>2]=(c[a+260>>2]|0)+1;c[a+192>>2]=b;c[a+200>>2]=b;return}function Dp(b){b=b|0;var d=0,e=0;e=i;c[b>>2]=1464;d=c[b+496>>2]|0;if(!d){a[b+500>>0]=1;c[b+496>>2]=0;c[b+488>>2]=0;c[b+492>>2]=0;d=c[5110]|0;d=d+1|0;c[5110]=d;d=b+-4|0;d=c[d>>2]|0;RE(d);i=e;return}if(a[b+500>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}a[b+500>>0]=1;c[b+496>>2]=0;c[b+488>>2]=0;c[b+492>>2]=0;d=c[5110]|0;d=d+1|0;c[5110]=d;d=b+-4|0;d=c[d>>2]|0;RE(d);i=e;return}function Ep(b){b=b|0;var d=0,e=0;e=i;c[b>>2]=1464;d=c[b+496>>2]|0;if(d){if(a[b+500>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}c[b+496>>2]=0}a[b+500>>0]=1;c[b+496>>2]=0;c[b+488>>2]=0;c[b+492>>2]=0;i=e;return}function Fp(b){b=b|0;var d=0,e=0,f=0,g=0;g=i;c[b>>2]=1568;if((a[b+272>>0]|0)!=0?(d=c[b+204>>2]|0,Jb[c[c[d>>2]>>2]&255](d),d=c[b+204>>2]|0,(d|0)!=0):0){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}d=c[b+196>>2]|0;if((d|0)!=0?(Jb[c[c[d>>2]>>2]&255](d),f=c[b+196>>2]|0,(f|0)!=0):0){c[5110]=(c[5110]|0)+1;RE(c[f+-4>>2]|0)}if((a[b+273>>0]|0)!=0?(e=c[b+200>>2]|0,Jb[c[c[e>>2]>>2]&255](e),e=c[b+200>>2]|0,(e|0)!=0):0){c[5110]=(c[5110]|0)+1;RE(c[e+-4>>2]|0)}d=c[b+316>>2]|0;if(d){if(a[b+320>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}c[b+316>>2]=0}a[b+320>>0]=1;c[b+316>>2]=0;c[b+308>>2]=0;c[b+312>>2]=0;d=c[b+288>>2]|0;if(d){if(a[b+292>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}c[b+288>>2]=0}a[b+292>>0]=1;c[b+288>>2]=0;c[b+280>>2]=0;c[b+284>>2]=0;d=c[b+240>>2]|0;if(d){if(a[b+244>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}c[b+240>>2]=0}a[b+244>>0]=1;c[b+240>>2]=0;c[b+232>>2]=0;c[b+236>>2]=0;d=c[b+220>>2]|0;if(d){if(a[b+224>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}c[b+220>>2]=0}a[b+224>>0]=1;c[b+220>>2]=0;c[b+212>>2]=0;c[b+216>>2]=0;d=c[b+188>>2]|0;if(!d){a[b+192>>0]=1;c[b+188>>2]=0;c[b+180>>2]=0;d=b+184|0;c[d>>2]=0;Qu(b);i=g;return}if(a[b+192>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}c[b+188>>2]=0;a[b+192>>0]=1;c[b+188>>2]=0;c[b+180>>2]=0;d=b+184|0;c[d>>2]=0;Qu(b);i=g;return}function Gp(a){a=a|0;var b=0;b=i;Fp(a);if(!a){i=b;return}c[5110]=(c[5110]|0)+1;RE(c[a+-4>>2]|0);i=b;return}function Hp(a,b){a=a|0;b=+b;var d=0,e=0,f=0,h=0,j=0.0,k=0.0,l=0.0;h=i;i=i+32|0;d=c[a+8>>2]|0;if((d|0)<=0){i=h;return}f=0;do{e=c[(c[a+16>>2]|0)+(f<<2)>>2]|0;e=(c[e+236>>2]&2|0)==0?0:e;if(((e|0)!=0?(c[e+216>>2]|0)!=2:0)?!((c[e+204>>2]&2|0)==0|b!=0.0^1):0){d=c[e+480>>2]|0;if(!d)d=e+4|0;else{Lb[c[(c[d>>2]|0)+8>>2]&127](d,e+4|0);d=e+4|0}k=(+g[e+56>>2]-+g[e+120>>2])*(1.0/b);l=1.0/b*(+g[e+60>>2]-+g[e+124>>2]);g[e+312>>2]=(+g[e+52>>2]-+g[e+116>>2])*(1.0/b);g[e+316>>2]=k;g[e+320>>2]=l;g[e+324>>2]=0.0;Bp(e+68|0,d,h+8|0,h);l=+g[h>>2];k=1.0/b*(l*+g[h+12>>2]);j=1.0/b*(l*+g[h+16>>2]);g[e+328>>2]=1.0/b*(+g[h+8>>2]*l);g[e+332>>2]=k;g[e+336>>2]=j;g[e+340>>2]=0.0;c[e+132>>2]=c[e+312>>2];c[e+136>>2]=c[e+316>>2];c[e+140>>2]=c[e+320>>2];c[e+144>>2]=c[e+324>>2];c[e+148>>2]=c[e+328>>2];c[e+152>>2]=c[e+332>>2];c[e+156>>2]=c[e+336>>2];c[e+160>>2]=c[e+340>>2];c[e+68>>2]=c[d+0>>2];c[e+72>>2]=c[d+4>>2];c[e+76>>2]=c[d+8>>2];c[e+80>>2]=c[d+12>>2];c[e+84>>2]=c[e+20>>2];c[e+88>>2]=c[e+24>>2];c[e+92>>2]=c[e+28>>2];c[e+96>>2]=c[e+32>>2];c[e+100>>2]=c[e+36>>2];c[e+104>>2]=c[e+40>>2];c[e+108>>2]=c[e+44>>2];c[e+112>>2]=c[e+48>>2];c[e+116>>2]=c[e+52>>2];c[e+120>>2]=c[e+56>>2];c[e+124>>2]=c[e+60>>2];c[e+128>>2]=c[e+64>>2];d=c[a+8>>2]|0}f=f+1|0}while((f|0)<(d|0));i=h;return}function Ip(b){b=b|0;var d=0,e=0.0,f=0.0,h=0.0,j=0,k=0,l=0,m=0,n=0,o=0.0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0.0,L=0.0,M=0.0,N=0.0,O=0,P=0.0,Q=0.0,T=0.0,U=0.0,V=0.0,W=0.0;J=i;i=i+1024|0;aE(1752);bv(b);a:do if((Nb[c[(c[b>>2]|0)+20>>2]&127](b)|0)!=0?(E=Nb[c[(c[b>>2]|0)+20>>2]&127](b)|0,((Nb[c[(c[E>>2]|0)+48>>2]&127](E)|0)&6144|0)!=0):0){z=J+988|0;t=J+896|0;x=J+832|0;A=J+912|0;r=J+848|0;E=J+928|0;H=J+864|0;u=J+720|0;y=J+656|0;B=J+736|0;s=J+672|0;G=J+752|0;I=J+688|0;w=J+336|0;q=J+352|0;F=J+368|0;v=J+112|0;p=J+128|0;D=J+144|0;d=Nb[c[(c[b>>2]|0)+104>>2]&127](b)|0;b:while(1){C=d+-1|0;if((d|0)<=0)break a;n=ec[c[(c[b>>2]|0)+108>>2]&31](b,C)|0;d=Nb[c[(c[b>>2]|0)+20>>2]&127](b)|0;d=(Nb[c[(c[d>>2]|0)+48>>2]&127](d)|0)>>>11;m=Nb[c[(c[b>>2]|0)+20>>2]&127](b)|0;m=(Nb[c[(c[m>>2]|0)+48>>2]&127](m)|0)>>>12;o=+g[n+40>>2];if(o<=0.0){d=C;continue}switch(c[n+4>>2]|0){case 4:{ip(J+880|0,(c[n+28>>2]|0)+4|0,n+552|0);if(!(d&1)){ip(J+816|0,(c[n+32>>2]|0)+4|0,n+616|0);c[J+880>>2]=c[J+816>>2];c[J+884>>2]=c[J+820>>2];c[J+888>>2]=c[J+824>>2];c[J+892>>2]=c[J+828>>2];c[t+0>>2]=c[x+0>>2];c[t+4>>2]=c[x+4>>2];c[t+8>>2]=c[x+8>>2];c[t+12>>2]=c[x+12>>2];c[A+0>>2]=c[r+0>>2];c[A+4>>2]=c[r+4>>2];c[A+8>>2]=c[r+8>>2];c[A+12>>2]=c[r+12>>2];c[E+0>>2]=c[H+0>>2];c[E+4>>2]=c[H+4>>2];c[E+8>>2]=c[H+8>>2];c[E+12>>2]=c[H+12>>2]}else{d=Nb[c[(c[b>>2]|0)+20>>2]&127](b)|0;rc[c[(c[d>>2]|0)+56>>2]&7](d,J+880|0,o);ip(J+816|0,(c[n+32>>2]|0)+4|0,n+616|0);c[J+880>>2]=c[J+816>>2];c[J+884>>2]=c[J+820>>2];c[J+888>>2]=c[J+824>>2];c[J+892>>2]=c[J+828>>2];c[t+0>>2]=c[x+0>>2];c[t+4>>2]=c[x+4>>2];c[t+8>>2]=c[x+8>>2];c[t+12>>2]=c[x+12>>2];c[A+0>>2]=c[r+0>>2];c[A+4>>2]=c[r+4>>2];c[A+8>>2]=c[r+8>>2];c[A+12>>2]=c[r+12>>2];c[E+0>>2]=c[H+0>>2];c[E+4>>2]=c[H+4>>2];c[E+8>>2]=c[H+8>>2];c[E+12>>2]=c[H+12>>2];d=Nb[c[(c[b>>2]|0)+20>>2]&127](b)|0;rc[c[(c[d>>2]|0)+56>>2]&7](d,J+880|0,o)}h=+g[n+688>>2];e=+g[n+692>>2];f=+SE(h-e,6.2831854820251465);if(!(f<-3.1415927410125732)){if(f>3.1415927410125732)f=f+-6.2831854820251465}else f=f+6.2831854820251465;e=+SE(h+e,6.2831854820251465);if(!(e<-3.1415927410125732)){if(e>3.1415927410125732)e=e+-6.2831854820251465}else e=e+6.2831854820251465;if(f==e){d=C;continue b}d=f>e;if(!(m&1)){d=C;continue b}g[J+800>>2]=+g[J+888>>2];g[J+804>>2]=+g[J+904>>2];g[J+808>>2]=+g[J+920>>2];g[J+812>>2]=0.0;g[J+784>>2]=+g[J+880>>2];g[J+788>>2]=+g[J+896>>2];g[J+792>>2]=+g[J+912>>2];g[J+796>>2]=0.0;j=Nb[c[(c[b>>2]|0)+20>>2]&127](b)|0;k=c[(c[j>>2]|0)+60>>2]|0;c[J+768>>2]=0;c[J+772>>2]=0;c[J+776>>2]=0;c[J+780>>2]=0;Ub[k&0](j,E,J+800|0,J+784|0,o,o,d?0.0:f,d?6.2831854820251465:e,J+768|0,d^1,10.0);d=C;continue b}case 3:{g[J+944>>2]=1.0;c[J+948>>2]=0;c[J+952>>2]=0;c[J+956>>2]=0;c[J+960>>2]=0;g[J+964>>2]=1.0;c[J+968>>2]=0;c[J+972>>2]=0;c[J+976>>2]=0;c[J+980>>2]=0;g[J+984>>2]=1.0;c[z+0>>2]=0;c[z+4>>2]=0;c[z+8>>2]=0;c[z+12>>2]=0;c[z+16>>2]=0;e=+g[n+300>>2];f=+g[n+304>>2];h=+g[n+308>>2];j=c[n+28>>2]|0;K=e*+g[j+20>>2]+f*+g[j+24>>2]+h*+g[j+28>>2]+ +g[j+56>>2];L=e*+g[j+36>>2]+f*+g[j+40>>2]+h*+g[j+44>>2]+ +g[j+60>>2];g[J+992>>2]=e*+g[j+4>>2]+f*+g[j+8>>2]+h*+g[j+12>>2]+ +g[j+52>>2];g[J+996>>2]=K;g[J+1e3>>2]=L;g[J+1004>>2]=0.0;j=Nb[c[(c[b>>2]|0)+20>>2]&127](b)|0;rc[c[(c[j>>2]|0)+56>>2]&7](j,J+944|0,o);L=+g[n+316>>2];K=+g[n+320>>2];h=+g[n+324>>2];j=c[n+32>>2]|0;f=L*+g[j+20>>2]+K*+g[j+24>>2]+h*+g[j+28>>2]+ +g[j+56>>2];e=L*+g[j+36>>2]+K*+g[j+40>>2]+h*+g[j+44>>2]+ +g[j+60>>2];g[J+992>>2]=L*+g[j+4>>2]+K*+g[j+8>>2]+h*+g[j+12>>2]+ +g[j+52>>2];g[J+996>>2]=f;g[J+1e3>>2]=e;g[J+1004>>2]=0.0;if(!(d&1)){d=C;continue b}d=Nb[c[(c[b>>2]|0)+20>>2]&127](b)|0;rc[c[(c[d>>2]|0)+56>>2]&7](d,J+944|0,o);d=C;continue b}case 5:{ip(J+704|0,(c[n+28>>2]|0)+4|0,n+300|0);if(!(d&1)){ip(J+640|0,(c[n+32>>2]|0)+4|0,n+364|0);c[J+704>>2]=c[J+640>>2];c[J+708>>2]=c[J+644>>2];c[J+712>>2]=c[J+648>>2];c[J+716>>2]=c[J+652>>2];c[u+0>>2]=c[y+0>>2];c[u+4>>2]=c[y+4>>2];c[u+8>>2]=c[y+8>>2];c[u+12>>2]=c[y+12>>2];c[B+0>>2]=c[s+0>>2];c[B+4>>2]=c[s+4>>2];c[B+8>>2]=c[s+8>>2];c[B+12>>2]=c[s+12>>2];c[G+0>>2]=c[I+0>>2];c[G+4>>2]=c[I+4>>2];c[G+8>>2]=c[I+8>>2];c[G+12>>2]=c[I+12>>2]}else{d=Nb[c[(c[b>>2]|0)+20>>2]&127](b)|0;rc[c[(c[d>>2]|0)+56>>2]&7](d,J+704|0,o);ip(J+640|0,(c[n+32>>2]|0)+4|0,n+364|0);c[J+704>>2]=c[J+640>>2];c[J+708>>2]=c[J+644>>2];c[J+712>>2]=c[J+648>>2];c[J+716>>2]=c[J+652>>2];c[u+0>>2]=c[y+0>>2];c[u+4>>2]=c[y+4>>2];c[u+8>>2]=c[y+8>>2];c[u+12>>2]=c[y+12>>2];c[B+0>>2]=c[s+0>>2];c[B+4>>2]=c[s+4>>2];c[B+8>>2]=c[s+8>>2];c[B+12>>2]=c[s+12>>2];c[G+0>>2]=c[I+0>>2];c[G+4>>2]=c[I+4>>2];c[G+8>>2]=c[I+8>>2];c[G+12>>2]=c[I+12>>2];d=Nb[c[(c[b>>2]|0)+20>>2]&127](b)|0;rc[c[(c[d>>2]|0)+56>>2]&7](d,J+704|0,o)}if(!(m&1)){d=C;continue b}pr(J+624|0,n,6.0868353843688965,o);L=+g[J+624>>2];K=+g[J+628>>2];h=+g[J+632>>2];f=L*+g[J+720>>2]+K*+g[J+724>>2]+h*+g[J+728>>2]+ +g[J+756>>2];e=L*+g[J+736>>2]+K*+g[J+740>>2]+h*+g[J+744>>2]+ +g[J+760>>2];g[J+624>>2]=L*+g[J+704>>2]+K*+g[J+708>>2]+h*+g[J+712>>2]+ +g[J+752>>2];g[J+628>>2]=f;g[J+632>>2]=e;g[J+636>>2]=0.0;d=0;do{pr(J+608|0,n,+(d|0)*6.283185005187988*.03125,o);L=+g[J+608>>2];K=+g[J+612>>2];h=+g[J+616>>2];f=L*+g[J+720>>2]+K*+g[J+724>>2]+h*+g[J+728>>2]+ +g[J+756>>2];e=L*+g[J+736>>2]+K*+g[J+740>>2]+h*+g[J+744>>2]+ +g[J+760>>2];g[J+608>>2]=L*+g[J+704>>2]+K*+g[J+708>>2]+h*+g[J+712>>2]+ +g[J+752>>2];g[J+612>>2]=f;g[J+616>>2]=e;g[J+620>>2]=0.0;j=Nb[c[(c[b>>2]|0)+20>>2]&127](b)|0;k=c[(c[j>>2]|0)+8>>2]|0;c[J+592>>2]=0;c[J+596>>2]=0;c[J+600>>2]=0;c[J+604>>2]=0;tc[k&127](j,J+624|0,J+608|0,J+592|0);if(!(d&3)){j=Nb[c[(c[b>>2]|0)+20>>2]&127](b)|0;k=c[(c[j>>2]|0)+8>>2]|0;c[J+576>>2]=0;c[J+580>>2]=0;c[J+584>>2]=0;c[J+588>>2]=0;tc[k&127](j,G,J+608|0,J+576|0)};c[J+624>>2]=c[J+608>>2];c[J+628>>2]=c[J+612>>2];c[J+632>>2]=c[J+616>>2];c[J+636>>2]=c[J+620>>2];d=d+1|0}while((d|0)!=32);e=+g[n+452>>2];f=+g[n+512>>2];d=c[n+32>>2]|0;if(+g[d+344>>2]>0.0){ip(J+512|0,d+4|0,n+364|0);c[J+704>>2]=c[J+512>>2];c[J+708>>2]=c[J+516>>2];c[J+712>>2]=c[J+520>>2];c[J+716>>2]=c[J+524>>2];c[u+0>>2]=c[J+528>>2];c[u+4>>2]=c[J+532>>2];c[u+8>>2]=c[J+536>>2];c[u+12>>2]=c[J+540>>2];c[B+0>>2]=c[J+544>>2];c[B+4>>2]=c[J+548>>2];c[B+8>>2]=c[J+552>>2];c[B+12>>2]=c[J+556>>2];c[G+0>>2]=c[J+560>>2];c[G+4>>2]=c[J+564>>2];c[G+8>>2]=c[J+568>>2];c[G+12>>2]=c[J+572>>2]}else{ip(J+448|0,(c[n+28>>2]|0)+4|0,n+300|0);c[J+704>>2]=c[J+448>>2];c[J+708>>2]=c[J+452>>2];c[J+712>>2]=c[J+456>>2];c[J+716>>2]=c[J+460>>2];c[u+0>>2]=c[J+464>>2];c[u+4>>2]=c[J+468>>2];c[u+8>>2]=c[J+472>>2];c[u+12>>2]=c[J+476>>2];c[B+0>>2]=c[J+480>>2];c[B+4>>2]=c[J+484>>2];c[B+8>>2]=c[J+488>>2];c[B+12>>2]=c[J+492>>2];c[G+0>>2]=c[J+496>>2];c[G+4>>2]=c[J+500>>2];c[G+8>>2]=c[J+504>>2];c[G+12>>2]=c[J+508>>2]};c[J+432>>2]=c[G+0>>2];c[J+436>>2]=c[G+4>>2];c[J+440>>2]=c[G+8>>2];c[J+444>>2]=c[G+12>>2];g[J+416>>2]=+g[J+704>>2];g[J+420>>2]=+g[J+720>>2];g[J+424>>2]=+g[J+736>>2];g[J+428>>2]=0.0;g[J+400>>2]=+g[J+708>>2];g[J+404>>2]=+g[J+724>>2];g[J+408>>2]=+g[J+740>>2];g[J+412>>2]=0.0;d=Nb[c[(c[b>>2]|0)+20>>2]&127](b)|0;j=c[(c[d>>2]|0)+60>>2]|0;c[J+384>>2]=0;c[J+388>>2]=0;c[J+392>>2]=0;c[J+396>>2]=0;Ub[j&0](d,J+432|0,J+416|0,J+400|0,o,o,-f-e,e-f,J+384|0,1,10.0);d=C;continue b}case 6:case 9:{c[J+320>>2]=c[n+1064>>2];c[J+324>>2]=c[n+1068>>2];c[J+328>>2]=c[n+1072>>2];c[J+332>>2]=c[n+1076>>2];k=n+1080|0;c[w+0>>2]=c[k+0>>2];c[w+4>>2]=c[k+4>>2];c[w+8>>2]=c[k+8>>2];c[w+12>>2]=c[k+12>>2];j=n+1096|0;c[q+0>>2]=c[j+0>>2];c[q+4>>2]=c[j+4>>2];c[q+8>>2]=c[j+8>>2];c[q+12>>2]=c[j+12>>2];l=n+1112|0;c[F+0>>2]=c[l+0>>2];c[F+4>>2]=c[l+4>>2];c[F+8>>2]=c[l+8>>2];c[F+12>>2]=c[l+12>>2];if(!(d&1)){c[J+320>>2]=c[n+1128>>2];c[J+324>>2]=c[n+1132>>2];c[J+328>>2]=c[n+1136>>2];c[J+332>>2]=c[n+1140>>2];c[w+0>>2]=c[n+1144>>2];c[w+4>>2]=c[n+1148>>2];c[w+8>>2]=c[n+1152>>2];c[w+12>>2]=c[n+1156>>2];c[q+0>>2]=c[n+1160>>2];c[q+4>>2]=c[n+1164>>2];c[q+8>>2]=c[n+1168>>2];c[q+12>>2]=c[n+1172>>2];c[F+0>>2]=c[n+1176>>2];c[F+4>>2]=c[n+1180>>2];c[F+8>>2]=c[n+1184>>2];c[F+12>>2]=c[n+1188>>2]}else{d=Nb[c[(c[b>>2]|0)+20>>2]&127](b)|0;rc[c[(c[d>>2]|0)+56>>2]&7](d,J+320|0,o);c[J+320>>2]=c[n+1128>>2];c[J+324>>2]=c[n+1132>>2];c[J+328>>2]=c[n+1136>>2];c[J+332>>2]=c[n+1140>>2];c[w+0>>2]=c[n+1144>>2];c[w+4>>2]=c[n+1148>>2];c[w+8>>2]=c[n+1152>>2];c[w+12>>2]=c[n+1156>>2];c[q+0>>2]=c[n+1160>>2];c[q+4>>2]=c[n+1164>>2];c[q+8>>2]=c[n+1168>>2];c[q+12>>2]=c[n+1172>>2];c[F+0>>2]=c[n+1176>>2];c[F+4>>2]=c[n+1180>>2];c[F+8>>2]=c[n+1184>>2];c[F+12>>2]=c[n+1188>>2];d=Nb[c[(c[b>>2]|0)+20>>2]&127](b)|0;rc[c[(c[d>>2]|0)+56>>2]&7](d,J+320|0,o)}if(!(m&1)){d=C;continue b};c[J+320>>2]=c[n+1064>>2];c[J+324>>2]=c[n+1068>>2];c[J+328>>2]=c[n+1072>>2];c[J+332>>2]=c[n+1076>>2];c[w+0>>2]=c[k+0>>2];c[w+4>>2]=c[k+4>>2];c[w+8>>2]=c[k+8>>2];c[w+12>>2]=c[k+12>>2];c[q+0>>2]=c[j+0>>2];c[q+4>>2]=c[j+4>>2];c[q+8>>2]=c[j+8>>2];c[q+12>>2]=c[j+12>>2];c[F+0>>2]=c[l+0>>2];c[F+4>>2]=c[l+4>>2];c[F+8>>2]=c[l+8>>2];c[F+12>>2]=c[l+12>>2];d=n+1176|0;g[J+304>>2]=+g[J+328>>2];g[J+308>>2]=+g[J+344>>2];g[J+312>>2]=+g[J+360>>2];g[J+316>>2]=0.0;g[J+288>>2]=+g[J+320>>2];g[J+292>>2]=+g[J+336>>2];g[J+296>>2]=+g[J+352>>2];g[J+300>>2]=0.0;L=+g[n+932>>2];f=+g[n+936>>2];e=+g[n+996>>2];M=+g[n+1e3>>2];m=Nb[c[(c[b>>2]|0)+20>>2]&127](b)|0;O=c[(c[m>>2]|0)+64>>2]|0;c[J+272>>2]=0;c[J+276>>2]=0;c[J+280>>2]=0;c[J+284>>2]=0;kc[O&0](m,d,J+304|0,J+288|0,o*.8999999761581421,L,f,e,M,J+272|0,10.0,1);M=+g[J+324>>2];e=+g[J+340>>2];f=+g[J+356>>2];g[J+288>>2]=M;g[J+292>>2]=e;g[J+296>>2]=f;g[J+300>>2]=0.0;L=+g[n+1196>>2];K=+g[n+1200>>2];h=+R(+L);L=+S(+L);N=+R(+K);K=+S(+K);g[J+256>>2]=h*N*M+h*K*e-L*f;g[J+260>>2]=N*e-K*M;g[J+264>>2]=L*N*M+L*K*e+h*f;c[J+320>>2]=c[n+1128>>2];c[J+324>>2]=c[n+1132>>2];c[J+328>>2]=c[n+1136>>2];c[J+332>>2]=c[n+1140>>2];c[w+0>>2]=c[n+1144>>2];c[w+4>>2]=c[n+1148>>2];c[w+8>>2]=c[n+1152>>2];c[w+12>>2]=c[n+1156>>2];c[q+0>>2]=c[n+1160>>2];c[q+4>>2]=c[n+1164>>2];c[q+8>>2]=c[n+1168>>2];c[q+12>>2]=c[n+1172>>2];c[F+0>>2]=c[d+0>>2];c[F+4>>2]=c[d+4>>2];c[F+8>>2]=c[d+8>>2];c[F+12>>2]=c[d+12>>2];f=-+g[J+336>>2];h=-+g[J+352>>2];g[J+240>>2]=-+g[J+320>>2];g[J+244>>2]=f;g[J+248>>2]=h;g[J+252>>2]=0.0;h=+g[n+868>>2];f=+g[n+872>>2];if(!(h>f)){if(h<f){m=Nb[c[(c[b>>2]|0)+20>>2]&127](b)|0;O=c[(c[m>>2]|0)+60>>2]|0;c[J+208>>2]=0;c[J+212>>2]=0;c[J+216>>2]=0;c[J+220>>2]=0;Ub[O&0](m,d,J+240|0,J+256|0,o,o,h,f,J+208|0,1,10.0)}}else{m=Nb[c[(c[b>>2]|0)+20>>2]&127](b)|0;O=c[(c[m>>2]|0)+60>>2]|0;c[J+224>>2]=0;c[J+228>>2]=0;c[J+232>>2]=0;c[J+236>>2]=0;Ub[O&0](m,d,J+240|0,J+256|0,o,o,-3.1415927410125732,3.1415927410125732,J+224|0,0,10.0)};c[J+320>>2]=c[n+1064>>2];c[J+324>>2]=c[n+1068>>2];c[J+328>>2]=c[n+1072>>2];c[J+332>>2]=c[n+1076>>2];c[w+0>>2]=c[k+0>>2];c[w+4>>2]=c[k+4>>2];c[w+8>>2]=c[k+8>>2];c[w+12>>2]=c[k+12>>2];c[q+0>>2]=c[j+0>>2];c[q+4>>2]=c[j+4>>2];c[q+8>>2]=c[j+8>>2];c[q+12>>2]=c[j+12>>2];c[F+0>>2]=c[l+0>>2];c[F+4>>2]=c[l+4>>2];c[F+8>>2]=c[l+8>>2];c[F+12>>2]=c[l+12>>2];c[J+192>>2]=c[n+680>>2];c[J+196>>2]=c[n+684>>2];c[J+200>>2]=c[n+688>>2];c[J+204>>2]=c[n+692>>2];c[J+176>>2]=c[n+696>>2];c[J+180>>2]=c[n+700>>2];c[J+184>>2]=c[n+704>>2];c[J+188>>2]=c[n+708>>2];d=Nb[c[(c[b>>2]|0)+20>>2]&127](b)|0;j=c[(c[d>>2]|0)+72>>2]|0;c[J+160>>2]=0;c[J+164>>2]=0;c[J+168>>2]=0;c[J+172>>2]=0;Hb[j&31](d,J+192|0,J+176|0,J+320|0,J+160|0);d=C;continue b}case 7:{c[J+96>>2]=c[n+824>>2];c[J+100>>2]=c[n+828>>2];c[J+104>>2]=c[n+832>>2];c[J+108>>2]=c[n+836>>2];c[v+0>>2]=c[n+840>>2];c[v+4>>2]=c[n+844>>2];c[v+8>>2]=c[n+848>>2];c[v+12>>2]=c[n+852>>2];c[p+0>>2]=c[n+856>>2];c[p+4>>2]=c[n+860>>2];c[p+8>>2]=c[n+864>>2];c[p+12>>2]=c[n+868>>2];c[D+0>>2]=c[n+872>>2];c[D+4>>2]=c[n+876>>2];c[D+8>>2]=c[n+880>>2];c[D+12>>2]=c[n+884>>2];if(!(d&1)){c[J+96>>2]=c[n+888>>2];c[J+100>>2]=c[n+892>>2];c[J+104>>2]=c[n+896>>2];c[J+108>>2]=c[n+900>>2];c[v+0>>2]=c[n+904>>2];c[v+4>>2]=c[n+908>>2];c[v+8>>2]=c[n+912>>2];c[v+12>>2]=c[n+916>>2];c[p+0>>2]=c[n+920>>2];c[p+4>>2]=c[n+924>>2];c[p+8>>2]=c[n+928>>2];c[p+12>>2]=c[n+932>>2];c[D+0>>2]=c[n+936>>2];c[D+4>>2]=c[n+940>>2];c[D+8>>2]=c[n+944>>2];c[D+12>>2]=c[n+948>>2]}else{d=Nb[c[(c[b>>2]|0)+20>>2]&127](b)|0;rc[c[(c[d>>2]|0)+56>>2]&7](d,J+96|0,o);c[J+96>>2]=c[n+888>>2];c[J+100>>2]=c[n+892>>2];c[J+104>>2]=c[n+896>>2];c[J+108>>2]=c[n+900>>2];c[v+0>>2]=c[n+904>>2];c[v+4>>2]=c[n+908>>2];c[v+8>>2]=c[n+912>>2];c[v+12>>2]=c[n+916>>2];c[p+0>>2]=c[n+920>>2];c[p+4>>2]=c[n+924>>2];c[p+8>>2]=c[n+928>>2];c[p+12>>2]=c[n+932>>2];c[D+0>>2]=c[n+936>>2];c[D+4>>2]=c[n+940>>2];c[D+8>>2]=c[n+944>>2];c[D+12>>2]=c[n+948>>2];d=Nb[c[(c[b>>2]|0)+20>>2]&127](b)|0;rc[c[(c[d>>2]|0)+56>>2]&7](d,J+96|0,o)}if(!(m&1)){d=C;continue b}d=(a[n+180>>0]|0)!=0?n+824|0:n+888|0;K=+g[d>>2];f=+g[d+4>>2];h=+g[d+16>>2];e=+g[d+20>>2];N=+g[d+32>>2];M=+g[d+36>>2];W=+g[d+48>>2];U=+g[d+52>>2];Q=+g[d+56>>2];L=+g[n+184>>2];V=+g[d+8>>2]*0.0;T=+g[d+24>>2]*0.0;P=+g[d+40>>2]*0.0;g[J+80>>2]=W+(V+(f*0.0+K*L));g[J+84>>2]=U+(T+(e*0.0+h*L));g[J+88>>2]=Q+(P+(M*0.0+N*L));g[J+92>>2]=0.0;L=+g[n+188>>2];g[J+64>>2]=W+(V+(f*0.0+K*L));g[J+68>>2]=U+(T+(e*0.0+h*L));g[J+72>>2]=Q+(P+(M*0.0+N*L));g[J+76>>2]=0.0;d=Nb[c[(c[b>>2]|0)+20>>2]&127](b)|0;j=c[(c[d>>2]|0)+8>>2]|0;c[J+48>>2]=0;c[J+52>>2]=0;c[J+56>>2]=0;c[J+60>>2]=0;tc[j&127](d,J+80|0,J+64|0,J+48|0);g[J+32>>2]=K;g[J+36>>2]=h;g[J+40>>2]=N;g[J+44>>2]=0.0;g[J+16>>2]=f;g[J+20>>2]=e;g[J+24>>2]=M;g[J+28>>2]=0.0;M=+g[n+192>>2];e=+g[n+196>>2];d=Nb[c[(c[b>>2]|0)+20>>2]&127](b)|0;j=c[(c[d>>2]|0)+60>>2]|0;c[J+0>>2]=0;c[J+4>>2]=0;c[J+8>>2]=0;c[J+12>>2]=0;Ub[j&0](d,n+936|0,J+32|0,J+16|0,o,o,M,e,J,1,10.0);d=C;continue b}default:{d=C;continue b}}}}while(0);if(((((Nb[c[(c[b>>2]|0)+20>>2]&127](b)|0)!=0?(E=Nb[c[(c[b>>2]|0)+20>>2]&127](b)|0,((Nb[c[(c[E>>2]|0)+48>>2]&127](E)|0)&16387|0)!=0):0)?(Nb[c[(c[b>>2]|0)+20>>2]&127](b)|0)!=0:0)?(E=Nb[c[(c[b>>2]|0)+20>>2]&127](b)|0,(Nb[c[(c[E>>2]|0)+48>>2]&127](E)|0)!=0):0)?(c[b+280>>2]|0)>0:0){d=0;do{E=c[(c[b+288>>2]|0)+(d<<2)>>2]|0;Lb[c[(c[E>>2]|0)+12>>2]&127](E,c[b+72>>2]|0);d=d+1|0}while((d|0)<(c[b+280>>2]|0))}d=c[5104]|0;E=(c[d+16>>2]|0)+-1|0;c[d+16>>2]=E;if(E){i=J;return}do if(c[d+4>>2]|0){Cb(J+1008|0,0)|0;E=c[5090]|0;g[d+8>>2]=+(((c[J+1012>>2]|0)-(c[E+4>>2]|0)+(((c[J+1008>>2]|0)-(c[E>>2]|0)|0)*1e6|0)-(c[d+12>>2]|0)|0)>>>0)/1.0e3+ +g[d+8>>2];if(!(c[d+16>>2]|0)){d=c[5104]|0;break}else{i=J;return}}while(0);c[5104]=c[d+20>>2];i=J;return}function Jp(a){a=a|0;var b=0,d=0,e=0;d=i;if((c[a+232>>2]|0)<=0){i=d;return}b=0;do{e=(c[(c[a+240>>2]|0)+(b<<2)>>2]|0)+412|0;c[e+0>>2]=0;c[e+4>>2]=0;c[e+8>>2]=0;c[e+12>>2]=0;c[e+16>>2]=0;c[e+20>>2]=0;c[e+24>>2]=0;c[e+28>>2]=0;b=b+1|0}while((b|0)<(c[a+232>>2]|0));i=d;return}function Kp(a){a=a|0;var b=0,d=0,e=0,f=0,h=0,j=0.0,k=0.0;f=i;e=c[a+232>>2]|0;if((e|0)<=0){i=f;return}a=c[a+240>>2]|0;d=0;do{b=c[a+(d<<2)>>2]|0;h=c[b+216>>2]|0;if(!((h|0)==2|(h|0)==5)?(c[b+204>>2]&3|0)==0:0){k=+g[b+368>>2]*+g[b+352>>2];j=+g[b+372>>2]*+g[b+356>>2];g[b+412>>2]=+g[b+364>>2]*+g[b+348>>2]+ +g[b+412>>2];g[b+416>>2]=k+ +g[b+416>>2];g[b+420>>2]=j+ +g[b+420>>2]}d=d+1|0}while((d|0)!=(e|0));i=f;return}function Lp(b){b=b|0;var d=0,e=0.0,f=0,h=0,j=0.0,k=0.0,l=0,m=0;l=i;i=i+144|0;aE(1768);if(!(a[b+274>>0]|0)){d=c[b+232>>2]|0;if((d|0)>0){h=0;do{f=c[(c[b+240>>2]|0)+(h<<2)>>2]|0;m=c[f+216>>2]|0;if((!((m|0)==2|(m|0)==5)?(c[f+480>>2]|0)!=0:0)?(c[f+204>>2]&3|0)==0:0){if((a[b+300>>0]|0)!=0?(j=+g[b+268>>2],j!=0.0):0)e=+g[b+264>>2]-j;else e=+g[b+264>>2]*+g[f+244>>2];Ap(f+68|0,+g[f+132>>2],+g[f+136>>2],+g[f+140>>2],f+148|0,e,l);d=c[f+480>>2]|0;Lb[c[(c[d>>2]|0)+12>>2]&127](d,l);d=c[b+232>>2]|0}h=h+1|0}while((h|0)<(d|0))}}else{d=c[b+8>>2]|0;if((d|0)>0){h=0;do{f=c[(c[b+16>>2]|0)+(h<<2)>>2]|0;f=(c[f+236>>2]&2|0)==0?0:f;if(((f|0)!=0?(c[f+480>>2]|0)!=0:0)?(c[f+204>>2]&3|0)==0:0){if((a[b+300>>0]|0)!=0?(k=+g[b+268>>2],k!=0.0):0)e=+g[b+264>>2]-k;else e=+g[b+264>>2]*+g[f+244>>2];Ap(f+68|0,+g[f+132>>2],+g[f+136>>2],+g[f+140>>2],f+148|0,e,l+64|0);d=c[f+480>>2]|0;Lb[c[(c[d>>2]|0)+12>>2]&127](d,l+64|0);d=c[b+8>>2]|0}h=h+1|0}while((h|0)<(d|0))}}d=c[5104]|0;f=(c[d+16>>2]|0)+-1|0;c[d+16>>2]=f;if(f){i=l;return}do if(c[d+4>>2]|0){Cb(l+128|0,0)|0;f=c[5090]|0;g[d+8>>2]=+(((c[l+132>>2]|0)-(c[f+4>>2]|0)+(((c[l+128>>2]|0)-(c[f>>2]|0)|0)*1e6|0)-(c[d+12>>2]|0)|0)>>>0)/1.0e3+ +g[d+8>>2];if(!(c[d+16>>2]|0)){d=c[5104]|0;break}else{i=l;return}}while(0);c[5104]=c[d+20>>2];i=l;return}function Mp(b,d,e,f){b=b|0;d=+d;e=e|0;f=+f;var h=0,j=0.0,k=0,l=0;l=i;i=i+16|0;Cb(c[5090]|0,0)|0;$D(20368);c[5093]=(c[5093]|0)+1;h=c[5096]|0;c[5096]=h+1;if(!h){Cb(l|0,0)|0;h=c[5090]|0;c[5095]=(c[l+4>>2]|0)-(c[h+4>>2]|0)+(((c[l>>2]|0)-(c[h>>2]|0)|0)*1e6|0)}c[5106]=0;Cb(l|0,0)|0;aE(1792);if(e){g[b+268>>2]=f;j=+g[b+264>>2]+d;g[b+264>>2]=j;if(!(j>=f)){d=f;k=0}else{g[b+264>>2]=j-+(~~(j/f)|0)*f;d=f;k=~~(j/f)}}else{g[b+264>>2]=(a[b+300>>0]|0)!=0?0.0:d;g[b+268>>2]=0.0;k=!(+O(+d)<1.1920928955078125e-07)&1;e=k}if(Nb[c[(c[b>>2]|0)+20>>2]&127](b)|0){h=Nb[c[(c[b>>2]|0)+20>>2]&127](b)|0;a[1448]=(Nb[c[(c[h>>2]|0)+48>>2]&127](h)|0)>>>4&1}if(k){h=(k|0)>(e|0)?e:k;Ib[c[(c[b>>2]|0)+164>>2]&31](b,d*+(h|0));Jb[c[(c[b>>2]|0)+168>>2]&255](b);if((h|0)>0){e=0;do{Ib[c[(c[b>>2]|0)+160>>2]&31](b,d);Jb[c[(c[b>>2]|0)+80>>2]&255](b);e=e+1|0}while((e|0)<(h|0))}}else Jb[c[(c[b>>2]|0)+80>>2]&255](b);Jb[c[(c[b>>2]|0)+120>>2]&255](b);c[5106]=(c[5106]|0)+1;h=c[5104]|0;e=(c[h+16>>2]|0)+-1|0;c[h+16>>2]=e;if(e){i=l;return k|0}do if(c[h+4>>2]|0){Cb(l|0,0)|0;e=c[5090]|0;g[h+8>>2]=+(((c[l+4>>2]|0)-(c[e+4>>2]|0)+(((c[l>>2]|0)-(c[e>>2]|0)|0)*1e6|0)-(c[h+12>>2]|0)|0)>>>0)/1.0e3+ +g[h+8>>2];if(!(c[h+16>>2]|0)){h=c[5104]|0;break}else{i=l;return k|0}}while(0);c[5104]=c[h+20>>2];i=l;return k|0}function Np(d,e){d=d|0;e=+e;var f=0,h=0,j=0,k=0,l=0,m=0.0,n=0,o=0.0,p=0.0,q=0.0,r=0,s=0,t=0,u=0,v=0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,N=0.0,O=0.0,P=0.0;D=i;i=i+464|0;aE(1808);f=c[d+84>>2]|0;if(f)Ib[f&31](d,e);Ib[c[(c[d>>2]|0)+140>>2]&31](d,e);g[d+28>>2]=e;c[d+32>>2]=0;c[d+48>>2]=Nb[c[(c[d>>2]|0)+20>>2]&127](d)|0;aE(1944);aE(1976);f=c[d+316>>2]|0;if((c[d+308>>2]|0)>0){h=0;do{r=c[d+24>>2]|0;Lb[c[(c[r>>2]|0)+16>>2]&127](r,c[f+(h<<2)>>2]|0);h=h+1|0;f=c[d+316>>2]|0}while((h|0)<(c[d+308>>2]|0))}if(f){if(a[d+320>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[f+-4>>2]|0)}c[d+316>>2]=0}a[d+320>>0]=1;c[d+316>>2]=0;c[d+308>>2]=0;c[d+312>>2]=0;f=c[5104]|0;r=(c[f+16>>2]|0)+-1|0;c[f+16>>2]=r;do if(!r){if(c[f+4>>2]|0){Cb(D+280|0,0)|0;r=c[5090]|0;g[f+8>>2]=+(((c[D+284>>2]|0)-(c[r+4>>2]|0)+(((c[D+280>>2]|0)-(c[r>>2]|0)|0)*1e6|0)-(c[f+12>>2]|0)|0)>>>0)/1.0e3+ +g[f+8>>2];if(c[f+16>>2]|0)break;f=c[5104]|0}c[5104]=c[f+20>>2]}while(0);if((c[d+232>>2]|0)>0){u=D+264|0;t=D+164|0;s=D+400|0;r=0;do{l=c[(c[d+240>>2]|0)+(r<<2)>>2]|0;g[l+244>>2]=1.0;n=c[l+216>>2]|0;do if(((!((n|0)==2|(n|0)==5)?(c[l+204>>2]&3|0)==0:0)?(Ap(l+4|0,+g[l+312>>2],+g[l+316>>2],+g[l+320>>2],l+328|0,e,D+216|0),w=+g[u>>2],A=w-+g[l+52>>2],x=+g[D+268>>2],C=x-+g[l+56>>2],y=+g[D+272>>2],B=y-+g[l+60>>2],(a[d+44>>0]|0)!=0):0)?(q=+g[l+252>>2],q*q!=0.0?q*q<A*A+C*C+B*B:0):0){aE(2016);if((c[(c[l+192>>2]|0)+4>>2]|0)<20?(c[484]=(c[484]|0)+1,k=c[d+68>>2]|0,k=Nb[c[(c[k>>2]|0)+36>>2]&127](k)|0,n=c[d+24>>2]|0,g[D+124>>2]=1.0,b[D+128>>1]=1,b[D+130>>1]=-1,c[D+120>>2]=880,c[D+132>>2]=c[l+52>>2],c[D+136>>2]=c[l+56>>2],c[D+140>>2]=c[l+60>>2],c[D+144>>2]=c[l+64>>2],c[D+148>>2]=c[u+0>>2],c[D+152>>2]=c[u+4>>2],c[D+156>>2]=c[u+8>>2],c[D+160>>2]=c[u+12>>2],c[D+196>>2]=0,c[D+120>>2]=2296,c[D+200>>2]=l,c[D+208>>2]=k,c[D+212>>2]=n,z=+g[l+248>>2],c[D+72>>2]=0,g[D+76>>2]=1.0,g[D+80>>2]=1.0,g[D+84>>2]=1.0,g[D+88>>2]=0.0,c[D+64>>2]=12008,c[D+68>>2]=8,g[D+92>>2]=z,g[D+108>>2]=z,g[D+204>>2]=+g[d+56>>2],n=c[l+188>>2]|0,b[D+128>>1]=b[n+4>>1]|0,b[D+130>>1]=b[n+6>>1]|0,c[D+48>>2]=c[u+0>>2],c[D+52>>2]=c[u+4>>2],c[D+56>>2]=c[u+8>>2],c[D+60>>2]=c[u+12>>2],c[D+0>>2]=c[l+4>>2],c[D+4>>2]=c[l+8>>2],c[D+8>>2]=c[l+12>>2],c[D+12>>2]=c[l+16>>2],c[D+16>>2]=c[l+20>>2],c[D+20>>2]=c[l+24>>2],c[D+24>>2]=c[l+28>>2],c[D+28>>2]=c[l+32>>2],c[D+32>>2]=c[l+36>>2],c[D+36>>2]=c[l+40>>2],c[D+40>>2]=c[l+44>>2],c[D+44>>2]=c[l+48>>2],_u(d,D+64|0,l+4|0,D,D+120|0,0.0),z=+g[D+124>>2],z<1.0):0){o=z*(w-+g[l+52>>2]);p=z*(x-+g[l+56>>2]);q=z*(y-+g[l+60>>2]);m=-(p*+g[D+168>>2])-o*+g[t>>2]-q*+g[D+172>>2];n=c[d+24>>2]|0;n=Wb[c[(c[n>>2]|0)+12>>2]&63](n,l,c[D+196>>2]|0)|0;h=c[d+308>>2]|0;if((h|0)==(c[d+312>>2]|0)?(v=(h|0)==0?1:h<<1,(h|0)<(v|0)):0){if(!v)f=0;else{c[5108]=(c[5108]|0)+1;h=QE((v<<2|3)+16|0)|0;if(!h)f=0;else{c[(h+19&-16)+-4>>2]=h;f=h+19&-16}h=c[d+308>>2]|0}if((h|0)>0){k=0;do{j=f+(k<<2)|0;if(j)c[j>>2]=c[(c[d+316>>2]|0)+(k<<2)>>2];k=k+1|0}while((k|0)!=(h|0))}j=c[d+316>>2]|0;if(j){if(a[d+320>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[j+-4>>2]|0);h=c[d+308>>2]|0}c[d+316>>2]=0}a[d+320>>0]=1;c[d+316>>2]=f;c[d+312>>2]=v}f=(c[d+316>>2]|0)+(h<<2)|0;if(f)c[f>>2]=n;c[d+308>>2]=h+1;o=o+ +g[l+52>>2];p=p+ +g[l+56>>2];q=q+ +g[l+60>>2];k=c[D+196>>2]|0;P=+g[k+4>>2];O=+g[k+20>>2];N=+g[k+36>>2];M=+g[k+8>>2];L=+g[k+24>>2];K=+g[k+40>>2];J=+g[k+12>>2];H=+g[k+28>>2];F=+g[k+44>>2];I=-+g[k+52>>2];G=-+g[k+56>>2];E=-+g[k+60>>2];c[D+280>>2]=0;c[D+284>>2]=0;c[D+288>>2]=0;c[D+292>>2]=0;g[D+296>>2]=o*P+p*O+q*N+(P*I+O*G+N*E);g[D+300>>2]=o*M+p*L+q*K+(M*I+L*G+K*E);g[D+304>>2]=o*J+p*H+q*F+(J*I+H*G+F*E);g[D+308>>2]=0.0;c[D+344>>2]=c[t+0>>2];c[D+348>>2]=c[t+4>>2];c[D+352>>2]=c[t+8>>2];c[D+356>>2]=c[t+12>>2];g[D+360>>2]=m;g[D+364>>2]=0.0;g[D+368>>2]=0.0;g[D+372>>2]=0.0;c[D+392>>2]=0;a[D+396>>0]=0;c[s+0>>2]=0;c[s+4>>2]=0;c[s+8>>2]=0;c[s+12>>2]=0;c[s+16>>2]=0;c[s+20>>2]=0;c[s+24>>2]=0;c[s+28>>2]=0;k=Es(n,D+280|0)|0;g[n+(k*184|0)+96>>2]=0.0;m=+g[l+224>>2]*+g[(c[D+196>>2]|0)+224>>2];m=m<-10.0?-10.0:m;g[n+(k*184|0)+88>>2]=m>10.0?10.0:m;c[n+(k*184|0)+52>>2]=c[l+52>>2];c[n+(k*184|0)+56>>2]=c[l+56>>2];c[n+(k*184|0)+60>>2]=c[l+60>>2];c[n+(k*184|0)+64>>2]=c[l+64>>2];g[n+(k*184|0)+36>>2]=o;g[n+(k*184|0)+40>>2]=p;g[n+(k*184|0)+44>>2]=q;g[n+(k*184|0)+48>>2]=0.0}h=c[5104]|0;n=(c[h+16>>2]|0)+-1|0;c[h+16>>2]=n;if(!n){if(c[h+4>>2]|0){Cb(D+280|0,0)|0;n=c[5090]|0;g[h+8>>2]=+(((c[D+284>>2]|0)-(c[n+4>>2]|0)+(((c[D+280>>2]|0)-(c[n>>2]|0)|0)*1e6|0)-(c[h+12>>2]|0)|0)>>>0)/1.0e3+ +g[h+8>>2];if(c[h+16>>2]|0)break;h=c[5104]|0}c[5104]=c[h+20>>2]}}while(0);r=r+1|0}while((r|0)<(c[d+232>>2]|0))}f=c[5104]|0;r=(c[f+16>>2]|0)+-1|0;c[f+16>>2]=r;do if(!r){if(c[f+4>>2]|0){Cb(D+280|0,0)|0;r=c[5090]|0;g[f+8>>2]=+(((c[D+284>>2]|0)-(c[r+4>>2]|0)+(((c[D+280>>2]|0)-(c[r>>2]|0)|0)*1e6|0)-(c[f+12>>2]|0)|0)>>>0)/1.0e3+ +g[f+8>>2];if(c[f+16>>2]|0)break;f=c[5104]|0}c[5104]=c[f+20>>2]}while(0);Jb[c[(c[d>>2]|0)+44>>2]&255](d);Jb[c[(c[d>>2]|0)+148>>2]&255](d);g[d+104>>2]=e;Lb[c[(c[d>>2]|0)+152>>2]&127](d,d+92|0);Ib[c[(c[d>>2]|0)+144>>2]&31](d,e);aE(1840);if((c[d+280>>2]|0)>0){f=0;do{r=c[(c[d+288>>2]|0)+(f<<2)>>2]|0;rc[c[(c[r>>2]|0)+8>>2]&7](r,d,e);f=f+1|0}while((f|0)<(c[d+280>>2]|0))}f=c[5104]|0;r=(c[f+16>>2]|0)+-1|0;c[f+16>>2]=r;do if(!r){if(c[f+4>>2]|0){Cb(D+280|0,0)|0;r=c[5090]|0;g[f+8>>2]=+(((c[D+284>>2]|0)-(c[r+4>>2]|0)+(((c[D+280>>2]|0)-(c[r>>2]|0)|0)*1e6|0)-(c[f+12>>2]|0)|0)>>>0)/1.0e3+ +g[f+8>>2];if(c[f+16>>2]|0)break;f=c[5104]|0}c[5104]=c[f+20>>2]}while(0);Ib[c[(c[d>>2]|0)+156>>2]&31](d,e);f=c[d+80>>2]|0;if(f)Ib[f&31](d,e);f=c[5104]|0;r=(c[f+16>>2]|0)+-1|0;c[f+16>>2]=r;if(r){i=D;return}do if(c[f+4>>2]|0){Cb(D+280|0,0)|0;r=c[5090]|0;g[f+8>>2]=+(((c[D+284>>2]|0)-(c[r+4>>2]|0)+(((c[D+280>>2]|0)-(c[r>>2]|0)|0)*1e6|0)-(c[f+12>>2]|0)|0)>>>0)/1.0e3+ +g[f+8>>2];if(!(c[f+16>>2]|0)){f=c[5104]|0;break}else{i=D;return}}while(0);c[5104]=c[f+20>>2];i=D;return}function Op(a,b){a=a|0;b=b|0;var d=0,e=0.0,f=0,h=0,j=0,k=0,l=0.0,m=0.0;j=i;c[a+248>>2]=c[b+0>>2];c[a+252>>2]=c[b+4>>2];c[a+256>>2]=c[b+8>>2];c[a+260>>2]=c[b+12>>2];d=c[a+232>>2]|0;if((d|0)<=0){i=j;return}h=0;do{f=c[(c[a+240>>2]|0)+(h<<2)>>2]|0;k=c[f+216>>2]|0;if(!((k|0)==2|(k|0)==5)?(c[f+504>>2]&1|0)==0:0){e=+g[f+344>>2];if(e!=0.0){m=1.0/e*+g[b+4>>2];l=1.0/e*+g[b+8>>2];g[f+364>>2]=1.0/e*+g[b>>2];g[f+368>>2]=m;g[f+372>>2]=l;g[f+376>>2]=0.0}c[f+380>>2]=c[b+0>>2];c[f+384>>2]=c[b+4>>2];c[f+388>>2]=c[b+8>>2];c[f+392>>2]=c[b+12>>2];d=c[a+232>>2]|0}h=h+1|0}while((h|0)<(d|0));i=j;return}function Pp(a,b){a=a|0;b=b|0;c[a+0>>2]=c[b+248>>2];c[a+4>>2]=c[b+252>>2];c[a+8>>2]=c[b+256>>2];c[a+12>>2]=c[b+260>>2];return}function Qp(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0;e=i;Su(a,b,c,d);i=e;return}function Rp(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0;k=i;d=(c[b+236>>2]&2|0)==0?0:b;if(d){Lb[c[(c[a>>2]|0)+92>>2]&127](a,d);i=k;return}d=c[b+188>>2]|0;if(d){e=c[a+68>>2]|0;e=Nb[c[(c[e>>2]|0)+36>>2]&127](e)|0;pc[c[(c[e>>2]|0)+40>>2]&127](e,d,c[a+24>>2]|0);e=c[a+68>>2]|0;pc[c[(c[e>>2]|0)+12>>2]&127](e,d,c[a+24>>2]|0);c[b+188>>2]=0}d=c[a+8>>2]|0;if((d|0)<=0){i=k;return}e=c[a+16>>2]|0;g=0;while(1){f=e+(g<<2)|0;h=g+1|0;if((c[f>>2]|0)==(b|0))break;if((h|0)<(d|0))g=h;else{j=11;break}}if((j|0)==11){i=k;return}if((g|0)>=(d|0)){i=k;return}c[f>>2]=c[e+(d+-1<<2)>>2];c[(c[a+16>>2]|0)+(d+-1<<2)>>2]=b;c[a+8>>2]=d+-1;i=k;return}function Sp(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0;k=i;d=c[a+232>>2]|0;a:do if((d|0)>0){e=c[a+240>>2]|0;g=0;while(1){f=e+(g<<2)|0;h=g+1|0;if((c[f>>2]|0)==(b|0))break;if((h|0)<(d|0))g=h;else break a}if((g|0)<(d|0)){c[f>>2]=c[e+(d+-1<<2)>>2];c[(c[a+240>>2]|0)+(d+-1<<2)>>2]=b;c[a+232>>2]=d+-1}}while(0);d=c[b+188>>2]|0;if(d){e=c[a+68>>2]|0;e=Nb[c[(c[e>>2]|0)+36>>2]&127](e)|0;pc[c[(c[e>>2]|0)+40>>2]&127](e,d,c[a+24>>2]|0);e=c[a+68>>2]|0;pc[c[(c[e>>2]|0)+12>>2]&127](e,d,c[a+24>>2]|0);c[b+188>>2]=0}e=c[a+8>>2]|0;if((e|0)<=0){i=k;return}d=c[a+16>>2]|0;g=0;while(1){f=d+(g<<2)|0;h=g+1|0;if((c[f>>2]|0)==(b|0))break;if((h|0)<(e|0))g=h;else{j=15;break}}if((j|0)==15){i=k;return}if((g|0)>=(e|0)){i=k;return}c[f>>2]=c[d+(e+-1<<2)>>2];c[(c[a+16>>2]|0)+(e+-1<<2)>>2]=b;c[a+8>>2]=e+-1;i=k;return}function Tp(b,d){b=b|0;d=d|0;var e=0,f=0,h=0.0,j=0,k=0,l=0,m=0,n=0.0,o=0.0;m=i;e=c[d+204>>2]|0;if((e&3|0)==0?(c[d+504>>2]&1|0)==0:0){h=+g[d+344>>2];if(h!=0.0){o=1.0/h*+g[b+252>>2];n=1.0/h*+g[b+256>>2];g[d+364>>2]=1.0/h*+g[b+248>>2];g[d+368>>2]=o;g[d+372>>2]=n;g[d+376>>2]=0.0}c[d+380>>2]=c[b+248>>2];c[d+384>>2]=c[b+252>>2];c[d+388>>2]=c[b+256>>2];c[d+392>>2]=c[b+260>>2]}if(!(c[d+192>>2]|0)){i=m;return}if(e&1){if((c[d+216>>2]&-2|0)!=4)c[d+216>>2]=2}else{e=c[b+232>>2]|0;if((e|0)==(c[b+236>>2]|0)?(l=(e|0)==0?1:e<<1,(e|0)<(l|0)):0){if(!l)f=0;else{c[5108]=(c[5108]|0)+1;f=QE((l<<2|3)+16|0)|0;if(!f)f=0;else{c[(f+19&-16)+-4>>2]=f;f=f+19&-16}e=c[b+232>>2]|0}if((e|0)>0){k=0;do{j=f+(k<<2)|0;if(j)c[j>>2]=c[(c[b+240>>2]|0)+(k<<2)>>2];k=k+1|0}while((k|0)!=(e|0))}j=c[b+240>>2]|0;if(j){if(a[b+244>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[j+-4>>2]|0);e=c[b+232>>2]|0}c[b+240>>2]=0}a[b+244>>0]=1;c[b+240>>2]=f;c[b+236>>2]=l}f=(c[b+240>>2]|0)+(e<<2)|0;if(f)c[f>>2]=d;c[b+232>>2]=e+1;e=c[d+204>>2]|0}if(!(e&1))e=(e&2|0)==0;else e=0;tc[c[(c[b>>2]|0)+36>>2]&127](b,d,e?1:2,e?-1:-3);i=m;return}function Up(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var h=0,j=0,k=0.0,l=0,m=0,n=0,o=0,p=0.0,q=0.0;o=i;j=c[d+204>>2]|0;if((j&3|0)==0?(c[d+504>>2]&1|0)==0:0){k=+g[d+344>>2];if(k!=0.0){q=1.0/k*+g[b+252>>2];p=1.0/k*+g[b+256>>2];g[d+364>>2]=1.0/k*+g[b+248>>2];g[d+368>>2]=q;g[d+372>>2]=p;g[d+376>>2]=0.0}c[d+380>>2]=c[b+248>>2];c[d+384>>2]=c[b+252>>2];c[d+388>>2]=c[b+256>>2];c[d+392>>2]=c[b+260>>2]}if(!(c[d+192>>2]|0)){i=o;return}if(j&1){if((c[d+216>>2]&-2|0)!=4)c[d+216>>2]=2}else{h=c[b+232>>2]|0;if((h|0)==(c[b+236>>2]|0)?(n=(h|0)==0?1:h<<1,(h|0)<(n|0)):0){if(!n)j=0;else{c[5108]=(c[5108]|0)+1;j=QE((n<<2|3)+16|0)|0;if(!j)j=0;else{c[(j+19&-16)+-4>>2]=j;j=j+19&-16}h=c[b+232>>2]|0}if((h|0)>0){m=0;do{l=j+(m<<2)|0;if(l)c[l>>2]=c[(c[b+240>>2]|0)+(m<<2)>>2];m=m+1|0}while((m|0)!=(h|0))}l=c[b+240>>2]|0;if(l){if(a[b+244>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[l+-4>>2]|0);h=c[b+232>>2]|0}c[b+240>>2]=0}a[b+244>>0]=1;c[b+240>>2]=j;c[b+236>>2]=n}j=(c[b+240>>2]|0)+(h<<2)|0;if(j)c[j>>2]=d;c[b+232>>2]=h+1}tc[c[(c[b>>2]|0)+36>>2]&127](b,d,e,f);i=o;return}function Vp(b,d){b=b|0;d=+d;var e=0,f=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0.0,p=0.0,q=0.0,r=0.0;n=i;i=i+16|0;aE(1856);e=c[b+232>>2]|0;if((e|0)>0){l=(a[1448]|0)==0;k=0;do{j=c[(c[b+240>>2]|0)+(k<<2)>>2]|0;a:do if(j){f=c[j+216>>2]|0;do if(!((f|0)==4|(f|0)==2)){r=+g[j+312>>2];q=+g[j+316>>2];p=+g[j+320>>2];o=+g[j+472>>2];if(r*r+q*q+p*p<o*o?(r=+g[j+328>>2],q=+g[j+332>>2],p=+g[j+336>>2],o=+g[j+476>>2],r*r+q*q+p*p<o*o):0){g[j+220>>2]=+g[j+220>>2]+d;m=10;break}g[j+220>>2]=0.0;if((f&-2|0)!=4){c[j+216>>2]=0;h=0}else m=10}else m=10;while(0);if((m|0)==10){m=0;if((f|0)==4)break;else h=f}f=h&-2;do if(l){if((f|0)!=2?!(+g[j+220>>2]>2.0):0)break;if(c[j+204>>2]&3){if((f|0)==4)break a;c[j+216>>2]=2;break a}if((h|0)==1){if((f|0)==4)break a;c[j+216>>2]=3;break a}else{if((h|0)!=2)break a;e=(c[j+260>>2]|0)+2|0;c[j+328>>2]=0;c[j+332>>2]=0;c[j+336>>2]=0;c[j+340>>2]=0;c[j+260>>2]=e;c[j+312>>2]=0;c[j+316>>2]=0;c[j+320>>2]=0;c[j+324>>2]=0;e=c[b+232>>2]|0;break a}}while(0);if((f|0)!=4)c[j+216>>2]=1}while(0);k=k+1|0}while((k|0)<(e|0))}e=c[5104]|0;f=(c[e+16>>2]|0)+-1|0;c[e+16>>2]=f;if(f){i=n;return}do if(c[e+4>>2]|0){Cb(n|0,0)|0;f=c[5090]|0;g[e+8>>2]=+(((c[n+4>>2]|0)-(c[f+4>>2]|0)+(((c[n>>2]|0)-(c[f>>2]|0)|0)*1e6|0)-(c[e+12>>2]|0)|0)>>>0)/1.0e3+ +g[e+8>>2];if(!(c[e+16>>2]|0)){e=c[5104]|0;break}else{i=n;return}}while(0);c[5104]=c[e+20>>2];i=n;return}function Wp(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0;l=i;f=c[b+212>>2]|0;if((f|0)==(c[b+216>>2]|0)?(k=(f|0)==0?1:f<<1,(f|0)<(k|0)):0){if(!k)g=0;else{c[5108]=(c[5108]|0)+1;g=QE((k<<2|3)+16|0)|0;if(!g)g=0;else{c[(g+19&-16)+-4>>2]=g;g=g+19&-16}f=c[b+212>>2]|0}if((f|0)>0){j=0;do{h=g+(j<<2)|0;if(h)c[h>>2]=c[(c[b+220>>2]|0)+(j<<2)>>2];j=j+1|0}while((j|0)!=(f|0))}h=c[b+220>>2]|0;if(h){if(a[b+224>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[h+-4>>2]|0);f=c[b+212>>2]|0}c[b+220>>2]=0}a[b+224>>0]=1;c[b+220>>2]=g;c[b+216>>2]=k}g=(c[b+220>>2]|0)+(f<<2)|0;if(g)c[g>>2]=d;c[b+212>>2]=f+1;if(!e){i=l;return}wp(c[d+28>>2]|0,d);wp(c[d+32>>2]|0,d);i=l;return}function Xp(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0;k=i;d=c[a+212>>2]|0;a:do if((d|0)>0){e=c[a+220>>2]|0;g=0;while(1){f=e+(g<<2)|0;h=g+1|0;if((c[f>>2]|0)==(b|0))break;if((h|0)<(d|0))g=h;else break a}if((g|0)<(d|0)){c[f>>2]=c[e+(d+-1<<2)>>2];c[(c[a+220>>2]|0)+(d+-1<<2)>>2]=b;c[a+212>>2]=d+-1}}while(0);a=c[b+28>>2]|0;d=c[a+488>>2]|0;b:do if((d|0)>0){e=c[a+496>>2]|0;g=0;while(1){f=e+(g<<2)|0;h=g+1|0;if((c[f>>2]|0)==(b|0))break;if((h|0)<(d|0))g=h;else break b}if((g|0)<(d|0)){c[f>>2]=c[e+(d+-1<<2)>>2];c[(c[a+496>>2]|0)+(d+-1<<2)>>2]=b;c[a+488>>2]=d+-1;d=d+-1|0}}while(0);c[a+256>>2]=(d|0)>0&1;a=c[b+32>>2]|0;d=c[a+488>>2]|0;if((d|0)<=0){e=d;e=(e|0)>0;e=e&1;d=a+256|0;c[d>>2]=e;i=k;return}e=c[a+496>>2]|0;g=0;while(1){f=e+(g<<2)|0;h=g+1|0;if((c[f>>2]|0)==(b|0))break;if((h|0)<(d|0))g=h;else{j=19;break}}if((j|0)==19){e=(d|0)>0;e=e&1;d=a+256|0;c[d>>2]=e;i=k;return}if((g|0)>=(d|0)){e=d;e=(e|0)>0;e=e&1;d=a+256|0;c[d>>2]=e;i=k;return}c[f>>2]=c[e+(d+-1<<2)>>2];c[(c[a+496>>2]|0)+(d+-1<<2)>>2]=b;c[a+488>>2]=d+-1;e=d+-1|0;e=(e|0)>0;e=e&1;d=a+256|0;c[d>>2]=e;i=k;return}function Yp(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0;k=i;e=c[b+280>>2]|0;if((e|0)==(c[b+284>>2]|0)?(j=(e|0)==0?1:e<<1,(e|0)<(j|0)):0){if(!j)f=0;else{c[5108]=(c[5108]|0)+1;f=QE((j<<2|3)+16|0)|0;if(!f)f=0;else{c[(f+19&-16)+-4>>2]=f;f=f+19&-16}e=c[b+280>>2]|0}if((e|0)>0){h=0;do{g=f+(h<<2)|0;if(g)c[g>>2]=c[(c[b+288>>2]|0)+(h<<2)>>2];h=h+1|0}while((h|0)!=(e|0))}g=c[b+288>>2]|0;if(g){if(a[b+292>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[g+-4>>2]|0);e=c[b+280>>2]|0}c[b+288>>2]=0}a[b+292>>0]=1;c[b+288>>2]=f;c[b+284>>2]=j}f=(c[b+288>>2]|0)+(e<<2)|0;if(!f){e=e+1|0;c[b+280>>2]=e;i=k;return}c[f>>2]=d;e=e+1|0;c[b+280>>2]=e;i=k;return}function Zp(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0;k=i;d=c[a+280>>2]|0;if((d|0)<=0){i=k;return}e=c[a+288>>2]|0;g=0;while(1){f=e+(g<<2)|0;h=g+1|0;if((c[f>>2]|0)==(b|0))break;if((h|0)<(d|0))g=h;else{j=7;break}}if((j|0)==7){i=k;return}if((g|0)>=(d|0)){i=k;return}c[f>>2]=c[e+(d+-1<<2)>>2];c[(c[a+288>>2]|0)+(d+-1<<2)>>2]=b;c[a+280>>2]=d+-1;i=k;return}function _p(a,b){a=a|0;b=b|0;var d=0;d=i;Lb[c[(c[a>>2]|0)+64>>2]&127](a,b);i=d;return}function $p(a,b){a=a|0;b=b|0;var d=0;d=i;Lb[c[(c[a>>2]|0)+68>>2]&127](a,b);i=d;return}function aq(a,b){a=a|0;b=b|0;var d=0;d=i;Lb[c[(c[a>>2]|0)+64>>2]&127](a,b);i=d;return}function bq(a,b){a=a|0;b=b|0;var d=0;d=i;Lb[c[(c[a>>2]|0)+68>>2]&127](a,b);i=d;return}function cq(b,d){b=b|0;d=d|0;var e=0,f=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0;w=i;i=i+16|0;aE(1880);l=c[b+212>>2]|0;e=c[b+180>>2]|0;if((e|0)<(l|0)){if((c[b+184>>2]|0)<(l|0)){if(!l){j=e;k=0}else{c[5108]=(c[5108]|0)+1;f=QE((l<<2|3)+16|0)|0;if(!f)f=0;else{c[(f+19&-16)+-4>>2]=f;f=f+19&-16}j=c[b+180>>2]|0;k=f}if((j|0)>0){f=0;do{h=k+(f<<2)|0;if(h)c[h>>2]=c[(c[b+188>>2]|0)+(f<<2)>>2];f=f+1|0}while((f|0)!=(j|0))}f=c[b+188>>2]|0;if(f){if(a[b+192>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[f+-4>>2]|0)}c[b+188>>2]=0}a[b+192>>0]=1;c[b+188>>2]=k;c[b+184>>2]=l;h=b+188|0}else h=b+188|0;do{f=(c[h>>2]|0)+(e<<2)|0;if(f)c[f>>2]=0;e=e+1|0}while((e|0)!=(l|0))}c[b+180>>2]=l;e=0;while(1){if((e|0)>=(Nb[c[(c[b>>2]|0)+104>>2]&127](b)|0))break;c[(c[b+188>>2]|0)+(e<<2)>>2]=c[(c[b+220>>2]|0)+(e<<2)>>2];e=e+1|0}e=c[b+180>>2]|0;if((e|0)>1)mq(b+176|0,0,e+-1|0);if(!(Nb[c[(c[b>>2]|0)+104>>2]&127](b)|0))e=0;else e=c[b+188>>2]|0;m=c[b+196>>2]|0;o=c[b+180>>2]|0;p=Nb[c[(c[b>>2]|0)+20>>2]&127](b)|0;c[m+4>>2]=d;c[m+12>>2]=e;c[m+16>>2]=o;c[m+20>>2]=p;e=c[m+32>>2]|0;if((e|0)<0){if((c[m+36>>2]|0)<0){f=c[m+40>>2]|0;if(f){if(a[m+44>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[f+-4>>2]|0)}c[m+40>>2]=0}a[m+44>>0]=1;c[m+40>>2]=0;c[m+36>>2]=0}do{f=(c[m+40>>2]|0)+(e<<2)|0;if(f)c[f>>2]=0;e=e+1|0}while((e|0)!=0)}c[m+32>>2]=0;f=c[m+52>>2]|0;if((f|0)<0){if((c[m+56>>2]|0)<0){e=c[m+60>>2]|0;if(e){if(a[m+64>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[e+-4>>2]|0)}c[m+60>>2]=0}a[m+64>>0]=1;c[m+60>>2]=0;c[m+56>>2]=0}do{e=(c[m+60>>2]|0)+(f<<2)|0;if(e)c[e>>2]=0;f=f+1|0}while((f|0)!=0)}c[m+52>>2]=0;f=c[m+72>>2]|0;if((f|0)<0){if((c[m+76>>2]|0)<0){e=c[m+80>>2]|0;if(e){if(a[m+84>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[e+-4>>2]|0)}c[m+80>>2]=0}a[m+84>>0]=1;c[m+80>>2]=0;c[m+76>>2]=0}do{e=(c[m+80>>2]|0)+(f<<2)|0;if(e)c[e>>2]=0;f=f+1|0}while((f|0)!=0)}c[m+72>>2]=0;v=c[b+200>>2]|0;f=c[(c[v>>2]|0)+8>>2]|0;s=c[b+8>>2]|0;u=c[b+24>>2]|0;u=Nb[c[(c[u>>2]|0)+36>>2]&127](u)|0;pc[f&127](v,s,u);u=c[b+204>>2]|0;s=c[b+24>>2]|0;v=c[b+196>>2]|0;aE(6936);f=c[u+28>>2]|0;if((f|0)<0){if((c[u+32>>2]|0)<0){e=c[u+36>>2]|0;if(e){if(a[u+40>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[e+-4>>2]|0)}c[u+36>>2]=0}a[u+40>>0]=1;c[u+36>>2]=0;c[u+32>>2]=0}do{e=(c[u+36>>2]|0)+(f<<2)|0;if(e)c[e>>2]=0;f=f+1|0}while((f|0)!=0)}c[u+28>>2]=0;l=c[u+8>>2]|0;if((l|0)>0){f=c[u+16>>2]|0;e=0;do{m=f+(e<<3)|0;k=c[m>>2]|0;if((k|0)==(e|0))k=e;else{h=m;do{j=f+(k<<3)|0;c[h>>2]=c[j>>2];j=c[j>>2]|0;h=f+(j<<3)|0;k=c[h>>2]|0}while((j|0)!=(k|0));k=j}c[m>>2]=k;e=e+1|0}while((e|0)!=(l|0));if((l|0)>1){kw(u+4|0,0,l+-1|0);l=c[u+8>>2]|0}if((l|0)>0){o=c[u+16>>2]|0;k=o;h=0;while(1){e=c[o+(h<<3)>>2]|0;q=h;while(1){q=q+1|0;if((q|0)>=(l|0)){p=0;break}if((c[o+(q<<3)>>2]|0)!=(e|0)){p=1;break}}if((h|0)<(q|0)){n=c[b+16>>2]|0;m=1;f=h;do{j=c[n+(c[o+(f<<3)+4>>2]<<2)>>2]|0;if((c[j+208>>2]|0)==(e|0)){j=c[j+216>>2]|0;m=m&(j|0)!=1&(j|0)!=4}f=f+1|0}while((f|0)!=(q|0));if(m){m=o;while(1){j=c[n+(c[m+(h<<3)+4>>2]<<2)>>2]|0;if((c[j+208>>2]|0)==(e|0)?(c[j+216>>2]&-2|0)!=4:0)c[j+216>>2]=2;h=h+1|0;if((h|0)>=(q|0))break;else m=k}}else while(1){j=c[n+(c[o+(h<<3)+4>>2]<<2)>>2]|0;if((c[j+208>>2]|0)==(e|0)?(c[j+216>>2]|0)==2:0){c[j+216>>2]=3;g[j+220>>2]=0.0}h=h+1|0;if((h|0)>=(q|0))break;else k=o}}if(p)h=q;else break}}}o=Nb[c[(c[s>>2]|0)+36>>2]&127](s)|0;if((o|0)>0){q=0;do{n=ec[c[(c[s>>2]|0)+40>>2]&31](s,q)|0;j=c[n+740>>2]|0;h=c[n+744>>2]|0;if((j|0)!=0?(c[j+216>>2]|0)!=2:0)k=101;else k=99;if(((k|0)==99?(k=0,(h|0)!=0):0)?(c[h+216>>2]|0)!=2:0)k=101;if((k|0)==101){k=c[j+204>>2]|0;if(((k&2|0)!=0?((k&4|0)==0?(c[j+216>>2]|0)!=2:0):0)?(c[h+204>>2]&3|0)==0:0){if((c[h+216>>2]&-2|0)!=4)c[h+216>>2]=1;g[h+220>>2]=0.0}p=c[h+204>>2]|0;if((p&2|0)!=0?((p&4|0)==0?(c[h+216>>2]|0)!=2:0)&(k&3|0)==0:0){if((c[j+216>>2]&-2|0)!=4)c[j+216>>2]=1;g[j+220>>2]=0.0}if((a[u+64>>0]|0)!=0?Wb[c[(c[s>>2]|0)+28>>2]&63](s,j,h)|0:0){h=c[u+28>>2]|0;if((h|0)==(c[u+32>>2]|0)?(t=(h|0)==0?1:h<<1,(h|0)<(t|0)):0){if(!t)k=0;else{c[5108]=(c[5108]|0)+1;j=QE((t<<2|3)+16|0)|0;if(!j)k=0;else{c[(j+19&-16)+-4>>2]=j;k=j+19&-16}h=c[u+28>>2]|0}if((h|0)>0){f=0;do{j=k+(f<<2)|0;if(j)c[j>>2]=c[(c[u+36>>2]|0)+(f<<2)>>2];f=f+1|0}while((f|0)!=(h|0))}j=c[u+36>>2]|0;if(j){if(a[u+40>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[j+-4>>2]|0);h=c[u+28>>2]|0}c[u+36>>2]=0}a[u+40>>0]=1;c[u+36>>2]=k;c[u+32>>2]=t}k=(c[u+36>>2]|0)+(h<<2)|0;if(k)c[k>>2]=n;c[u+28>>2]=h+1}}q=q+1|0}while((q|0)<(o|0))}e=c[5104]|0;p=(c[e+16>>2]|0)+-1|0;c[e+16>>2]=p;do if(!p){if(c[e+4>>2]|0){Cb(w|0,0)|0;p=c[5090]|0;g[e+8>>2]=+(((c[w+4>>2]|0)-(c[p+4>>2]|0)+(((c[w>>2]|0)-(c[p>>2]|0)|0)*1e6|0)-(c[e+12>>2]|0)|0)>>>0)/1.0e3+ +g[e+8>>2];if(c[e+16>>2]|0)break;e=c[5104]|0}c[5104]=c[e+20>>2]}while(0);t=c[u+8>>2]|0;aE(6968);if(a[u+64>>0]|0){r=c[u+28>>2]|0;if((r|0)>1)Rt(u+24|0,0,r+-1|0);if((t|0)>0){o=1;j=0;s=0;while(1){k=c[u+16>>2]|0;p=c[k+(j<<3)>>2]|0;a:do if((j|0)<(t|0)){m=p;q=1;while(1){if((m|0)!=(p|0)){e=j;h=q;break a}n=c[(c[b+16>>2]|0)+(c[k+(j<<3)+4>>2]<<2)>>2]|0;k=c[u+48>>2]|0;do if((k|0)==(c[u+52>>2]|0)){f=(k|0)==0?1:k<<1;if((k|0)>=(f|0))break;if(!f)m=0;else{c[5108]=(c[5108]|0)+1;k=QE((f<<2|3)+16|0)|0;if(!k)m=0;else{c[(k+19&-16)+-4>>2]=k;m=k+19&-16}k=c[u+48>>2]|0}if((k|0)>0){h=0;do{l=m+(h<<2)|0;if(l)c[l>>2]=c[(c[u+56>>2]|0)+(h<<2)>>2];h=h+1|0}while((h|0)!=(k|0))}l=c[u+56>>2]|0;if(l){if(a[u+60>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[l+-4>>2]|0);k=c[u+48>>2]|0}c[u+56>>2]=0}a[u+60>>0]=1;c[u+56>>2]=m;c[u+52>>2]=f}while(0);h=(c[u+56>>2]|0)+(k<<2)|0;if(h)c[h>>2]=n;c[u+48>>2]=k+1;h=c[n+216>>2]|0;h=q&((h|0)==2|(h|0)==5);j=j+1|0;if((j|0)>=(t|0)){e=j;break a}k=c[u+16>>2]|0;m=c[k+(j<<3)>>2]|0;q=h}}else{e=j;h=1}while(0);if((s|0)<(r|0)){f=c[u+36>>2]|0;k=f+(s<<2)|0;l=c[k>>2]|0;j=c[(c[l+740>>2]|0)+208>>2]|0;if((j|0)<=-1)j=c[(c[l+744>>2]|0)+208>>2]|0;if((j|0)==(p|0)){m=s;do{m=m+1|0;if((m|0)>=(r|0))break;l=c[f+(m<<2)>>2]|0;j=c[(c[l+740>>2]|0)+208>>2]|0;if((j|0)<=-1)j=c[(c[l+744>>2]|0)+208>>2]|0}while((p|0)==(j|0));l=m;j=m-s|0}else{l=o;j=0;k=0}}else{l=o;j=0;k=0}if(!h)Xb[c[(c[v>>2]|0)+8>>2]&7](v,c[u+56>>2]|0,c[u+48>>2]|0,k,j,p);s=(j|0)==0?s:l;k=c[u+48>>2]|0;if((k|0)<0){if((c[u+52>>2]|0)<0){j=c[u+56>>2]|0;if(j){if(a[u+60>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[j+-4>>2]|0)}c[u+56>>2]=0}a[u+60>>0]=1;c[u+56>>2]=0;c[u+52>>2]=0}do{j=(c[u+56>>2]|0)+(k<<2)|0;if(j)c[j>>2]=0;k=k+1|0}while((k|0)!=0)}c[u+48>>2]=0;if((e|0)>=(t|0))break;else{o=l;j=e}}}}else{o=Nb[c[(c[s>>2]|0)+44>>2]&127](s)|0;p=Nb[c[(c[s>>2]|0)+36>>2]&127](s)|0;Xb[c[(c[v>>2]|0)+8>>2]&7](v,c[b+16>>2]|0,c[b+8>>2]|0,o,p,-1)}e=c[5104]|0;p=(c[e+16>>2]|0)+-1|0;c[e+16>>2]=p;do if(!p){if(c[e+4>>2]|0){Cb(w|0,0)|0;p=c[5090]|0;g[e+8>>2]=+(((c[w+4>>2]|0)-(c[p+4>>2]|0)+(((c[w>>2]|0)-(c[p>>2]|0)|0)*1e6|0)-(c[e+12>>2]|0)|0)>>>0)/1.0e3+ +g[e+8>>2];if(c[e+16>>2]|0)break;e=c[5104]|0}c[5104]=c[e+20>>2]}while(0);nq(c[b+196>>2]|0);e=c[b+200>>2]|0;pc[c[(c[e>>2]|0)+16>>2]&127](e,d,c[b+72>>2]|0);e=c[5104]|0;p=(c[e+16>>2]|0)+-1|0;c[e+16>>2]=p;if(p){i=w;return}do if(c[e+4>>2]|0){Cb(w|0,0)|0;p=c[5090]|0;g[e+8>>2]=+(((c[w+4>>2]|0)-(c[p+4>>2]|0)+(((c[w>>2]|0)-(c[p>>2]|0)|0)*1e6|0)-(c[e+12>>2]|0)|0)>>>0)/1.0e3+ +g[e+8>>2];if(!(c[e+16>>2]|0)){e=c[5104]|0;break}else{i=w;return}}while(0);c[5104]=c[e+20>>2];i=w;return}function dq(b){b=b|0;var d=0,e=0,f=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;p=i;i=i+16|0;aE(1904);m=c[b+204>>2]|0;pc[c[(c[m>>2]|0)+8>>2]&127](m,b,c[b+24>>2]|0);m=c[b+308>>2]|0;if((m|0)>0){l=c[b+316>>2]|0;k=0;do{e=c[l+(k<<2)>>2]|0;d=c[e+740>>2]|0;e=c[e+744>>2]|0;if(((d|0)!=0?((e|0)!=0?(c[d+204>>2]&3|0)==0:0):0)?(c[e+204>>2]&3|0)==0:0){f=c[d+208>>2]|0;e=c[e+208>>2]|0;j=c[(c[b+204>>2]|0)+16>>2]|0;d=c[j+(f<<3)>>2]|0;if((d|0)!=(f|0)){h=j+(f<<3)|0;do{f=j+(d<<3)|0;c[h>>2]=c[f>>2];f=c[f>>2]|0;h=j+(f<<3)|0;d=c[h>>2]|0}while((f|0)!=(d|0))}d=c[j+(e<<3)>>2]|0;if((d|0)!=(e|0)){h=j+(e<<3)|0;do{e=j+(d<<3)|0;c[h>>2]=c[e>>2];e=c[e>>2]|0;h=j+(e<<3)|0;d=c[h>>2]|0}while((e|0)!=(d|0))}if((f|0)!=(e|0)){c[j+(f<<3)>>2]=e;h=j+(e<<3)+4|0;c[h>>2]=(c[h>>2]|0)+(c[j+(f<<3)+4>>2]|0)}}k=k+1|0}while((k|0)!=(m|0))}l=c[b+212>>2]|0;if((l|0)>0){k=c[b+220>>2]|0;m=0;do{d=c[k+(m<<2)>>2]|0;if(((a[d+20>>0]|0)!=0?(o=c[d+28>>2]|0,(c[o+204>>2]&3|0)==0):0)?(n=c[d+32>>2]|0,(c[n+204>>2]&3|0)==0):0){f=c[o+208>>2]|0;e=c[n+208>>2]|0;j=c[(c[b+204>>2]|0)+16>>2]|0;d=c[j+(f<<3)>>2]|0;if((d|0)!=(f|0)){h=j+(f<<3)|0;do{f=j+(d<<3)|0;c[h>>2]=c[f>>2];f=c[f>>2]|0;h=j+(f<<3)|0;d=c[h>>2]|0}while((f|0)!=(d|0))}d=c[j+(e<<3)>>2]|0;if((d|0)!=(e|0)){h=j+(e<<3)|0;do{e=j+(d<<3)|0;c[h>>2]=c[e>>2];e=c[e>>2]|0;h=j+(e<<3)|0;d=c[h>>2]|0}while((e|0)!=(d|0))}if((f|0)!=(e|0)){c[j+(f<<3)>>2]=e;h=j+(e<<3)+4|0;c[h>>2]=(c[h>>2]|0)+(c[j+(f<<3)+4>>2]|0)}}m=m+1|0}while((m|0)!=(l|0))}d=c[b+204>>2]|0;Lb[c[(c[d>>2]|0)+12>>2]&127](d,b);d=c[5104]|0;o=(c[d+16>>2]|0)+-1|0;c[d+16>>2]=o;if(o){i=p;return}do if(c[d+4>>2]|0){Cb(p|0,0)|0;o=c[5090]|0;g[d+8>>2]=+(((c[p+4>>2]|0)-(c[o+4>>2]|0)+(((c[p>>2]|0)-(c[o>>2]|0)|0)*1e6|0)-(c[d+12>>2]|0)|0)>>>0)/1.0e3+ +g[d+8>>2];if(!(c[d+16>>2]|0)){d=c[5104]|0;break}else{i=p;return}}while(0);c[5104]=c[d+20>>2];i=p;return}function eq(d,e){d=d|0;e=+e;var f=0,h=0.0,j=0,k=0.0,l=0.0,m=0,n=0,o=0,p=0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0,z=0.0,A=0;y=i;i=i+352|0;aE(2048);if((c[d+232>>2]|0)>0){p=y+232|0;n=0;do{o=c[(c[d+240>>2]|0)+(n<<2)>>2]|0;g[o+244>>2]=1.0;f=c[o+216>>2]|0;do if(!((f|0)==2|(f|0)==5)?(c[o+204>>2]&3|0)==0:0){Ap(o+4|0,+g[o+312>>2],+g[o+316>>2],+g[o+320>>2],o+328|0,e,y+184|0);h=+g[p>>2]-+g[o+52>>2];l=+g[y+236>>2]-+g[o+56>>2];k=+g[y+240>>2]-+g[o+60>>2];if((a[d+44>>0]|0)!=0?(z=+g[o+252>>2],z*z!=0.0?z*z<h*h+l*l+k*k:0):0){aE(2072);if((c[(c[o+192>>2]|0)+4>>2]|0)<20){c[484]=(c[484]|0)+1;j=c[d+68>>2]|0;j=Nb[c[(c[j>>2]|0)+36>>2]&127](j)|0;f=c[d+24>>2]|0;g[y+252>>2]=1.0;b[y+256>>1]=1;b[y+258>>1]=-1;c[y+248>>2]=880;c[y+260>>2]=c[o+52>>2];c[y+264>>2]=c[o+56>>2];c[y+268>>2]=c[o+60>>2];c[y+272>>2]=c[o+64>>2];c[y+276>>2]=c[p+0>>2];c[y+280>>2]=c[p+4>>2];c[y+284>>2]=c[p+8>>2];c[y+288>>2]=c[p+12>>2];c[y+324>>2]=0;c[y+248>>2]=2296;c[y+328>>2]=o;c[y+336>>2]=j;c[y+340>>2]=f;h=+g[o+248>>2];c[y+136>>2]=0;g[y+140>>2]=1.0;g[y+144>>2]=1.0;g[y+148>>2]=1.0;g[y+152>>2]=0.0;c[y+128>>2]=12008;c[y+132>>2]=8;g[y+156>>2]=h;g[y+172>>2]=h;g[y+332>>2]=+g[d+56>>2];f=c[o+188>>2]|0;b[y+256>>1]=b[f+4>>1]|0;b[y+258>>1]=b[f+6>>1]|0;c[y+112>>2]=c[p+0>>2];c[y+116>>2]=c[p+4>>2];c[y+120>>2]=c[p+8>>2];c[y+124>>2]=c[p+12>>2];c[y+64>>2]=c[o+4>>2];c[y+68>>2]=c[o+8>>2];c[y+72>>2]=c[o+12>>2];c[y+76>>2]=c[o+16>>2];c[y+80>>2]=c[o+20>>2];c[y+84>>2]=c[o+24>>2];c[y+88>>2]=c[o+28>>2];c[y+92>>2]=c[o+32>>2];c[y+96>>2]=c[o+36>>2];c[y+100>>2]=c[o+40>>2];c[y+104>>2]=c[o+44>>2];c[y+108>>2]=c[o+48>>2];_u(d,y+128|0,o+4|0,y+64|0,y+248|0,0.0);h=+g[y+252>>2];if(h<1.0){g[o+244>>2]=h;Ap(o+4|0,+g[o+312>>2],+g[o+316>>2],+g[o+320>>2],o+328|0,h*e,y+184|0);g[o+244>>2]=0.0;up(o,y+184|0);j=4}else j=0;if(!j)m=11}else m=11;if((m|0)==11){m=0;j=0}f=c[5104]|0;A=(c[f+16>>2]|0)+-1|0;c[f+16>>2]=A;do if(!A){if(c[f+4>>2]|0){Cb(y+248|0,0)|0;A=c[5090]|0;g[f+8>>2]=+(((c[y+252>>2]|0)-(c[A+4>>2]|0)+(((c[y+248>>2]|0)-(c[A>>2]|0)|0)*1e6|0)-(c[f+12>>2]|0)|0)>>>0)/1.0e3+ +g[f+8>>2];if(c[f+16>>2]|0)break;f=c[5104]|0}c[5104]=c[f+20>>2]}while(0);if((j|0)==4)break}up(o,y+184|0)}while(0);n=n+1|0}while((n|0)<(c[d+232>>2]|0))}do if(a[d+275>>0]|0){aE(2096);f=c[d+308>>2]|0;if((f|0)>0){p=0;do{m=c[(c[d+316>>2]|0)+(p<<2)>>2]|0;o=c[m+740>>2]|0;o=(c[o+236>>2]&2|0)==0?0:o;n=c[m+744>>2]|0;n=(c[n+236>>2]&2|0)==0?0:n;j=c[m+748>>2]|0;if((j|0)>0){if(!o){f=0;do{h=+g[57]*+g[n+228>>2];if((h>0.0?(q=+g[m+(f*184|0)+124>>2],q!=0.0):0)?(r=h*(q*+g[m+(f*184|0)+68>>2]),s=h*(q*+g[m+(f*184|0)+72>>2]),t=h*(q*+g[m+(f*184|0)+76>>2]),g[y+48>>2]=-r,g[y+52>>2]=-s,g[y+56>>2]=-t,g[y+60>>2]=0.0,e=+g[m+(f*184|0)+56>>2]-+g[o+56>>2],l=+g[m+(f*184|0)+60>>2]-+g[o+60>>2],g[y+32>>2]=+g[m+(f*184|0)+52>>2]-+g[o+52>>2],g[y+36>>2]=e,g[y+40>>2]=l,g[y+44>>2]=0.0,l=+g[m+(f*184|0)+40>>2]-+g[n+56>>2],e=+g[m+(f*184|0)+44>>2]-+g[n+60>>2],g[y+16>>2]=+g[m+(f*184|0)+36>>2]-+g[n+52>>2],g[y+20>>2]=l,g[y+24>>2]=e,g[y+28>>2]=0.0,(n|0)!=0):0){g[y>>2]=r;g[y+4>>2]=s;g[y+8>>2]=t;g[y+12>>2]=0.0;bn(n,y,y+16|0);j=c[m+748>>2]|0}f=f+1|0}while((f|0)<(j|0))}else{j=0;do{h=+g[o+228>>2]*+g[n+228>>2];if((h>0.0?(u=+g[m+(j*184|0)+124>>2],u!=0.0):0)?(v=h*(u*+g[m+(j*184|0)+68>>2]),w=h*(u*+g[m+(j*184|0)+72>>2]),x=h*(u*+g[m+(j*184|0)+76>>2]),g[y+48>>2]=-v,g[y+52>>2]=-w,g[y+56>>2]=-x,g[y+60>>2]=0.0,e=+g[m+(j*184|0)+56>>2]-+g[o+56>>2],l=+g[m+(j*184|0)+60>>2]-+g[o+60>>2],g[y+32>>2]=+g[m+(j*184|0)+52>>2]-+g[o+52>>2],g[y+36>>2]=e,g[y+40>>2]=l,g[y+44>>2]=0.0,l=+g[m+(j*184|0)+40>>2]-+g[n+56>>2],e=+g[m+(j*184|0)+44>>2]-+g[n+60>>2],g[y+16>>2]=+g[m+(j*184|0)+36>>2]-+g[n+52>>2],g[y+20>>2]=l,g[y+24>>2]=e,g[y+28>>2]=0.0,bn(o,y+48|0,y+32|0),(n|0)!=0):0){g[y>>2]=v;g[y+4>>2]=w;g[y+8>>2]=x;g[y+12>>2]=0.0;bn(n,y,y+16|0)}j=j+1|0}while((j|0)<(c[m+748>>2]|0))}f=c[d+308>>2]|0}p=p+1|0}while((p|0)<(f|0))}f=c[5104]|0;j=(c[f+16>>2]|0)+-1|0;c[f+16>>2]=j;if(!j){if(c[f+4>>2]|0){Cb(y+248|0,0)|0;j=c[5090]|0;g[f+8>>2]=+(((c[y+252>>2]|0)-(c[j+4>>2]|0)+(((c[y+248>>2]|0)-(c[j>>2]|0)|0)*1e6|0)-(c[f+12>>2]|0)|0)>>>0)/1.0e3+ +g[f+8>>2];if(c[f+16>>2]|0)break;f=c[5104]|0}c[5104]=c[f+20>>2]}}while(0);f=c[5104]|0;j=(c[f+16>>2]|0)+-1|0;c[f+16>>2]=j;if(j){i=y;return}do if(c[f+4>>2]|0){Cb(y+248|0,0)|0;j=c[5090]|0;g[f+8>>2]=+(((c[y+252>>2]|0)-(c[j+4>>2]|0)+(((c[y+248>>2]|0)-(c[j>>2]|0)|0)*1e6|0)-(c[f+12>>2]|0)|0)>>>0)/1.0e3+ +g[f+8>>2];if(!(c[f+16>>2]|0)){f=c[5104]|0;break}else{i=y;return}}while(0);c[5104]=c[f+20>>2];i=y;return}function fq(b,d){b=b|0;d=+d;var e=0,f=0.0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0,r=0,s=0,t=0.0;s=i;i=i+16|0;aE(2136);e=c[b+232>>2]|0;if((e|0)>0){r=0;do{q=c[(c[b+240>>2]|0)+(r<<2)>>2]|0;if(!(c[q+204>>2]&3)){o=+g[q+444>>2];f=+Q(+(1.0-o),+d);j=f*+g[q+312>>2];g[q+312>>2]=j;h=f*+g[q+316>>2];g[q+316>>2]=h;f=f*+g[q+320>>2];g[q+320>>2]=f;p=+g[q+448>>2];m=+Q(+(1.0-p),+d);k=m*+g[q+328>>2];g[q+328>>2]=k;l=m*+g[q+332>>2];g[q+332>>2]=l;m=m*+g[q+336>>2];g[q+336>>2]=m;do if(a[q+452>>0]|0){if(m*m+(k*k+l*l)<+g[q+464>>2]?j*j+h*h+f*f<+g[q+460>>2]:0){t=+g[q+456>>2];g[q+328>>2]=k*t;g[q+332>>2]=t*l;g[q+336>>2]=t*m;g[q+312>>2]=t*j;g[q+316>>2]=t*h;g[q+320>>2]=t*f;j=t*j;h=t*h;f=t*f;n=k*t;l=t*l;m=t*m}else n=k;k=+P(+(j*j+h*h+f*f));do if(k<o)if(k>.004999999888241291){j=j-j*(1.0/k)*.004999999888241291;g[q+312>>2]=j;h=h-h*(1.0/k)*.004999999888241291;g[q+316>>2]=h;f=f-f*(1.0/k)*.004999999888241291;g[q+320>>2]=f;break}else{c[q+312>>2]=0;c[q+316>>2]=0;c[q+320>>2]=0;c[q+324>>2]=0;j=0.0;h=0.0;f=0.0;break}while(0);k=+P(+(n*n+l*l+m*m));if(k<p)if(k>.004999999888241291){g[q+328>>2]=n-n*(1.0/k)*.004999999888241291;g[q+332>>2]=l-l*(1.0/k)*.004999999888241291;g[q+336>>2]=m-m*(1.0/k)*.004999999888241291;break}else{c[q+328>>2]=0;c[q+332>>2]=0;c[q+336>>2]=0;c[q+340>>2]=0;break}}while(0);Ap(q+4|0,j,h,f,q+328|0,d,q+68|0);e=c[b+232>>2]|0}r=r+1|0}while((r|0)<(e|0))}e=c[5104]|0;r=(c[e+16>>2]|0)+-1|0;c[e+16>>2]=r;if(r){i=s;return}do if(c[e+4>>2]|0){Cb(s|0,0)|0;r=c[5090]|0;g[e+8>>2]=+(((c[s+4>>2]|0)-(c[r+4>>2]|0)+(((c[s>>2]|0)-(c[r>>2]|0)|0)*1e6|0)-(c[e+12>>2]|0)|0)>>>0)/1.0e3+ +g[e+8>>2];if(!(c[e+16>>2]|0)){e=c[5104]|0;break}else{i=s;return}}while(0);c[5104]=c[e+20>>2];i=s;return}function gq(b,d){b=b|0;d=d|0;var e=0,f=0;f=i;if((a[b+273>>0]|0)!=0?(e=c[b+200>>2]|0,(e|0)!=0):0){c[5110]=(c[5110]|0)+1;RE(c[e+-4>>2]|0)}a[b+273>>0]=0;c[b+200>>2]=d;c[(c[b+196>>2]|0)+8>>2]=d;i=f;return}function hq(a){a=a|0;return c[a+200>>2]|0}function iq(a){a=a|0;return c[a+212>>2]|0}function jq(a,b){a=a|0;b=b|0;return c[(c[a+220>>2]|0)+(b<<2)>>2]|0}function kq(a,b){a=a|0;b=b|0;return c[(c[a+220>>2]|0)+(b<<2)>>2]|0}function lq(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,h=0,j=0;j=i;Jb[c[(c[b>>2]|0)+32>>2]&255](b);d=Wb[c[(c[b>>2]|0)+16>>2]&63](b,104,1)|0;e=c[d+8>>2]|0;f=e+0|0;h=f+104|0;do{c[f>>2]=0;f=f+4|0}while((f|0)<(h|0));g[e+88>>2]=+g[a+248>>2];g[e+92>>2]=+g[a+252>>2];g[e+96>>2]=+g[a+256>>2];g[e+100>>2]=+g[a+260>>2];g[e>>2]=+g[a+92>>2];g[e+4>>2]=+g[a+96>>2];g[e+8>>2]=+g[a+100>>2];g[e+12>>2]=+g[a+104>>2];g[e+16>>2]=+g[a+108>>2];g[e+20>>2]=+g[a+116>>2];g[e+24>>2]=+g[a+120>>2];g[e+28>>2]=+g[a+124>>2];g[e+32>>2]=+g[a+128>>2];g[e+36>>2]=+g[a+132>>2];g[e+40>>2]=+g[a+140>>2];g[e+44>>2]=+g[a+144>>2];g[e+48>>2]=+g[a+148>>2];g[e+52>>2]=+g[a+152>>2];g[e+56>>2]=+g[a+168>>2];g[e+60>>2]=+g[a+172>>2];c[e+64>>2]=c[a+112>>2];c[e+68>>2]=c[a+156>>2];c[e+72>>2]=c[a+160>>2];c[e+76>>2]=c[a+164>>2];c[e+80>>2]=c[a+136>>2];Hb[c[(c[b>>2]|0)+20>>2]&31](b,d,2168,1145853764,e);d=c[a+8>>2]|0;if((d|0)>0){f=0;do{e=c[(c[a+16>>2]|0)+(f<<2)>>2]|0;if(c[e+236>>2]&2){h=Nb[c[(c[e>>2]|0)+16>>2]&127](e)|0;h=Wb[c[(c[b>>2]|0)+16>>2]&63](b,h,1)|0;d=Wb[c[(c[e>>2]|0)+20>>2]&63](e,c[h+8>>2]|0,b)|0;Hb[c[(c[b>>2]|0)+20>>2]&31](b,h,d,1497645650,e);d=c[a+8>>2]|0}f=f+1|0}while((f|0)<(d|0))}if((c[a+212>>2]|0)<=0){cv(a,b);d=c[b>>2]|0;d=d+36|0;d=c[d>>2]|0;Jb[d&255](b);i=j;return}d=0;do{e=c[(c[a+220>>2]|0)+(d<<2)>>2]|0;h=Nb[c[(c[e>>2]|0)+36>>2]&127](e)|0;h=Wb[c[(c[b>>2]|0)+16>>2]&63](b,h,1)|0;f=Wb[c[(c[e>>2]|0)+40>>2]&63](e,c[h+8>>2]|0,b)|0;Hb[c[(c[b>>2]|0)+20>>2]&31](b,h,f,1397641027,e);d=d+1|0}while((d|0)<(c[a+212>>2]|0));cv(a,b);d=c[b>>2]|0;d=d+36|0;d=c[d>>2]|0;Jb[d&255](b);i=j;return}function mq(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0;o=i;while(1){n=c[a+12>>2]|0;m=c[n+(((b+d|0)/2|0)<<2)>>2]|0;e=b;f=d;while(1){l=c[(c[m+28>>2]|0)+208>>2]|0;if((l|0)>-1)while(1){h=c[n+(e<<2)>>2]|0;g=c[(c[h+28>>2]|0)+208>>2]|0;if((g|0)<=-1)g=c[(c[h+32>>2]|0)+208>>2]|0;if((g|0)<(l|0))e=e+1|0;else break}else{k=c[(c[m+32>>2]|0)+208>>2]|0;while(1){h=c[n+(e<<2)>>2]|0;g=c[(c[h+28>>2]|0)+208>>2]|0;if((g|0)<=-1)g=c[(c[h+32>>2]|0)+208>>2]|0;if((g|0)<(k|0))e=e+1|0;else break}}if((l|0)>-1)while(1){j=c[n+(f<<2)>>2]|0;g=c[(c[j+28>>2]|0)+208>>2]|0;if((g|0)<=-1)g=c[(c[j+32>>2]|0)+208>>2]|0;if((l|0)<(g|0))f=f+-1|0;else{g=j;break}}else{k=c[(c[m+32>>2]|0)+208>>2]|0;while(1){j=c[n+(f<<2)>>2]|0;g=c[(c[j+28>>2]|0)+208>>2]|0;if((g|0)<=-1)g=c[(c[j+32>>2]|0)+208>>2]|0;if((k|0)<(g|0))f=f+-1|0;else{g=j;break}}}if((e|0)<=(f|0)){c[n+(e<<2)>>2]=g;c[(c[a+12>>2]|0)+(f<<2)>>2]=h;e=e+1|0;f=f+-1|0}if((e|0)>(f|0))break;n=c[a+12>>2]|0}if((f|0)>(b|0))mq(a,b,f);if((e|0)<(d|0))b=e;else break}i=o;return}function nq(b){b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0;k=i;e=c[b+32>>2]|0;if(!e)g=0;else g=c[b+40>>2]|0;d=c[b+52>>2]|0;if(!d)h=0;else h=c[b+60>>2]|0;f=c[b+72>>2]|0;if(!f)j=0;else j=c[b+80>>2]|0;l=c[b+8>>2]|0;+gc[c[(c[l>>2]|0)+12>>2]&3](l,g,e,h,d,j,f,c[b+4>>2]|0,c[b+20>>2]|0,c[b+24>>2]|0);d=c[b+32>>2]|0;if((d|0)<0){if((c[b+36>>2]|0)<0){e=c[b+40>>2]|0;if(e){if(a[b+44>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[e+-4>>2]|0)}c[b+40>>2]=0}a[b+44>>0]=1;c[b+40>>2]=0;c[b+36>>2]=0}do{e=(c[b+40>>2]|0)+(d<<2)|0;if(e)c[e>>2]=0;d=d+1|0}while((d|0)!=0)}c[b+32>>2]=0;e=c[b+52>>2]|0;if((e|0)<0){if((c[b+56>>2]|0)<0){d=c[b+60>>2]|0;if(d){if(a[b+64>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}c[b+60>>2]=0}a[b+64>>0]=1;c[b+60>>2]=0;c[b+56>>2]=0}do{d=(c[b+60>>2]|0)+(e<<2)|0;if(d)c[d>>2]=0;e=e+1|0}while((e|0)!=0)}c[b+52>>2]=0;e=c[b+72>>2]|0;if((e|0)>=0){c[b+72>>2]=0;i=k;return}if((c[b+76>>2]|0)<0){d=c[b+80>>2]|0;if(d){if(a[b+84>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}c[b+80>>2]=0}a[b+84>>0]=1;c[b+80>>2]=0;c[b+76>>2]=0}do{d=(c[b+80>>2]|0)+(e<<2)|0;if(d)c[d>>2]=0;e=e+1|0}while((e|0)!=0);c[b+72>>2]=0;i=k;return}function oq(a,b){a=a|0;b=+b;var d=0,e=0,f=0;e=i;i=i+16|0;aE(1840);if((c[a+280>>2]|0)>0){d=0;do{f=c[(c[a+288>>2]|0)+(d<<2)>>2]|0;rc[c[(c[f>>2]|0)+8>>2]&7](f,a,b);d=d+1|0}while((d|0)<(c[a+280>>2]|0))}d=c[5104]|0;a=(c[d+16>>2]|0)+-1|0;c[d+16>>2]=a;if(a){i=e;return}do if(c[d+4>>2]|0){Cb(e|0,0)|0;a=c[5090]|0;g[d+8>>2]=+(((c[e+4>>2]|0)-(c[a+4>>2]|0)+(((c[e>>2]|0)-(c[a>>2]|0)|0)*1e6|0)-(c[d+12>>2]|0)|0)>>>0)/1.0e3+ +g[d+8>>2];if(!(c[d+16>>2]|0)){d=c[5104]|0;break}else{i=e;return}}while(0);c[5104]=c[d+20>>2];i=e;return}function pq(a,b){a=a|0;b=b|0;return}function qq(a){a=a|0;return 2}function rq(a){a=a|0;return c[a+72>>2]|0}function sq(a,b){a=a|0;b=b|0;c[a+72>>2]=b;return}function tq(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0;f=i;e=c[b>>2]|0;if((e|0)==(c[a+80>>2]|0)){h=1.0;i=f;return +h}if(c[e+204>>2]&4){h=1.0;i=f;return +h}if((+g[a+28>>2]-+g[a+12>>2])*+g[b+8>>2]+(+g[a+32>>2]-+g[a+16>>2])*+g[b+12>>2]+(+g[a+36>>2]-+g[a+20>>2])*+g[b+16>>2]>=-+g[a+84>>2]){h=1.0;i=f;return +h}g[a+4>>2]=+g[b+40>>2];c[a+76>>2]=e;if(d){c[a+44>>2]=c[b+8>>2];c[a+48>>2]=c[b+12>>2];c[a+52>>2]=c[b+16>>2];c[a+56>>2]=c[b+20>>2]}else{m=+g[b+8>>2];l=+g[b+12>>2];k=+g[b+16>>2];j=m*+g[e+20>>2]+l*+g[e+24>>2]+k*+g[e+28>>2];h=m*+g[e+36>>2]+l*+g[e+40>>2]+k*+g[e+44>>2];g[a+44>>2]=+g[e+4>>2]*m+ +g[e+8>>2]*l+ +g[e+12>>2]*k;g[a+48>>2]=j;g[a+52>>2]=h;g[a+56>>2]=0.0}c[a+60>>2]=c[b+24>>2];c[a+64>>2]=c[b+28>>2];c[a+68>>2]=c[b+32>>2];c[a+72>>2]=c[b+36>>2];h=+g[b+40>>2];i=f;return +h}function uq(a,d){a=a|0;d=d|0;var e=0,f=0,g=0;g=i;e=c[d>>2]|0;f=c[a+80>>2]|0;if((e|0)==(f|0)){e=0;i=g;return e|0}if(!((b[a+10>>1]&b[d+4>>1])<<16>>16)){e=0;i=g;return e|0}if(!((b[d+6>>1]&b[a+8>>1])<<16>>16)){e=0;i=g;return e|0}d=c[a+92>>2]|0;e=Wb[c[(c[d>>2]|0)+28>>2]&63](d,f,e)|0;i=g;return e|0}function vq(a){a=a|0;var b=0;b=i;RE(a);i=b;return}function wq(b,d,e,f,g,h){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;r=i;if((h|0)<0){p=c[b+8>>2]|0;+gc[c[(c[p>>2]|0)+12>>2]&3](p,d,e,f,g,c[b+12>>2]|0,c[b+16>>2]|0,c[b+4>>2]|0,c[b+20>>2]|0,c[b+24>>2]|0);i=r;return}p=c[b+16>>2]|0;a:do if((p|0)>0){k=c[b+12>>2]|0;j=0;while(1){n=k+(j<<2)|0;m=c[n>>2]|0;l=c[(c[m+28>>2]|0)+208>>2]|0;if((l|0)<=-1)l=c[(c[m+32>>2]|0)+208>>2]|0;m=j+1|0;if((l|0)==(h|0)){m=j;break a}if((m|0)<(p|0))j=m;else{n=0;break}}}else{m=0;n=0}while(0);if((m|0)<(p|0)){o=c[b+12>>2]|0;l=0;do{j=c[o+(m<<2)>>2]|0;k=c[(c[j+28>>2]|0)+208>>2]|0;if((k|0)<=-1)k=c[(c[j+32>>2]|0)+208>>2]|0;l=((k|0)==(h|0)&1)+l|0;m=m+1|0}while((m|0)!=(p|0));q=l}else q=0;j=c[b+4>>2]|0;if((c[j+72>>2]|0)<2){p=c[b+8>>2]|0;+gc[c[(c[p>>2]|0)+12>>2]&3](p,d,e,f,g,n,q,j,c[b+20>>2]|0,c[b+24>>2]|0);i=r;return}if((e|0)>0){m=c[b+32>>2]|0;l=c[b+36>>2]|0;o=0;while(1){p=d+(o<<2)|0;if((m|0)==(l|0)){h=(l|0)==0?1:l<<1;if((l|0)<(h|0)){if(!h){m=l;l=0}else{c[5108]=(c[5108]|0)+1;m=QE((h<<2|3)+16|0)|0;if(!m)l=0;else{c[(m+19&-16)+-4>>2]=m;l=m+19&-16}m=c[b+32>>2]|0}if((m|0)>0){j=0;do{k=l+(j<<2)|0;if(k)c[k>>2]=c[(c[b+40>>2]|0)+(j<<2)>>2];j=j+1|0}while((j|0)!=(m|0))}k=c[b+40>>2]|0;if(k){if(a[b+44>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[k+-4>>2]|0);m=c[b+32>>2]|0}c[b+40>>2]=0}a[b+44>>0]=1;c[b+40>>2]=l;c[b+36>>2]=h;k=h}else{m=l;k=l}}else k=l;l=(c[b+40>>2]|0)+(m<<2)|0;if(l)c[l>>2]=c[p>>2];m=m+1|0;c[b+32>>2]=m;o=o+1|0;if((o|0)==(e|0))break;else l=k}}if((g|0)>0){k=c[b+52>>2]|0;l=c[b+56>>2]|0;h=0;do{p=f+(h<<2)|0;if((k|0)==(l|0)){o=(l|0)==0?1:l<<1;if((l|0)<(o|0)){if(!o)m=0;else{c[5108]=(c[5108]|0)+1;l=QE((o<<2|3)+16|0)|0;if(!l)m=0;else{c[(l+19&-16)+-4>>2]=l;m=l+19&-16}l=c[b+52>>2]|0}if((l|0)>0){j=0;do{k=m+(j<<2)|0;if(k)c[k>>2]=c[(c[b+60>>2]|0)+(j<<2)>>2];j=j+1|0}while((j|0)!=(l|0))}k=c[b+60>>2]|0;if(k){if(a[b+64>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[k+-4>>2]|0);l=c[b+52>>2]|0}c[b+60>>2]=0}a[b+64>>0]=1;c[b+60>>2]=m;c[b+56>>2]=o;k=l;l=o}else k=l}j=(c[b+60>>2]|0)+(k<<2)|0;if(j)c[j>>2]=c[p>>2];k=k+1|0;c[b+52>>2]=k;h=h+1|0}while((h|0)!=(g|0))}if((q|0)>0){j=c[b+72>>2]|0;k=c[b+76>>2]|0;p=0;while(1){h=n+(p<<2)|0;if((j|0)==(k|0)){o=(k|0)==0?1:k<<1;if((k|0)<(o|0)){if(!o){j=k;k=0}else{c[5108]=(c[5108]|0)+1;j=QE((o<<2|3)+16|0)|0;if(!j)k=0;else{c[(j+19&-16)+-4>>2]=j;k=j+19&-16}j=c[b+72>>2]|0}if((j|0)>0){m=0;do{l=k+(m<<2)|0;if(l)c[l>>2]=c[(c[b+80>>2]|0)+(m<<2)>>2];m=m+1|0}while((m|0)!=(j|0))}l=c[b+80>>2]|0;if(l){if(a[b+84>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[l+-4>>2]|0);j=c[b+72>>2]|0}c[b+80>>2]=0}a[b+84>>0]=1;c[b+80>>2]=k;c[b+76>>2]=o;l=o}else{j=k;l=k}}else l=k;k=(c[b+80>>2]|0)+(j<<2)|0;if(k)c[k>>2]=c[h>>2];j=j+1|0;c[b+72>>2]=j;p=p+1|0;if((p|0)==(q|0))break;else k=l}}else j=c[b+72>>2]|0;if(((c[b+52>>2]|0)+j|0)<=(c[(c[b+4>>2]|0)+72>>2]|0)){i=r;return}nq(b);i=r;return}function xq(a){a=a|0;var b=0;b=i;yq(a);RE(a);i=b;return}function yq(b){b=b|0;var d=0,e=0;e=i;c[b>>2]=2376;d=c[b+80>>2]|0;if(d){if(a[b+84>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}c[b+80>>2]=0}a[b+84>>0]=1;c[b+80>>2]=0;c[b+72>>2]=0;c[b+76>>2]=0;d=c[b+60>>2]|0;if(d){if(a[b+64>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}c[b+60>>2]=0}a[b+64>>0]=1;c[b+60>>2]=0;c[b+52>>2]=0;c[b+56>>2]=0;d=c[b+40>>2]|0;if(!d){a[b+44>>0]=1;c[b+40>>2]=0;c[b+32>>2]=0;d=b+36|0;c[d>>2]=0;i=e;return}if(a[b+44>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}c[b+40>>2]=0;a[b+44>>0]=1;c[b+40>>2]=0;c[b+32>>2]=0;d=b+36|0;c[d>>2]=0;i=e;return}function zq(b,d,e,f,h,j){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;var k=0;k=i;c[b+4>>2]=6;c[b+8>>2]=-1;c[b+12>>2]=-1;g[b+16>>2]=3402823466385288598117041.0e14;a[b+20>>0]=1;a[b+21>>0]=0;c[b+24>>2]=-1;c[b+28>>2]=d;c[b+32>>2]=e;g[b+36>>2]=0.0;g[b+40>>2]=.30000001192092896;c[b+44>>2]=0;c[b>>2]=2504;c[b+48>>2]=c[f+0>>2];c[b+52>>2]=c[f+4>>2];c[b+56>>2]=c[f+8>>2];c[b+60>>2]=c[f+12>>2];c[b+64>>2]=c[f+16>>2];c[b+68>>2]=c[f+20>>2];c[b+72>>2]=c[f+24>>2];c[b+76>>2]=c[f+28>>2];c[b+80>>2]=c[f+32>>2];c[b+84>>2]=c[f+36>>2];c[b+88>>2]=c[f+40>>2];c[b+92>>2]=c[f+44>>2];c[b+96>>2]=c[f+48>>2];c[b+100>>2]=c[f+52>>2];c[b+104>>2]=c[f+56>>2];c[b+108>>2]=c[f+60>>2];c[b+112>>2]=c[h+0>>2];c[b+116>>2]=c[h+4>>2];c[b+120>>2]=c[h+8>>2];c[b+124>>2]=c[h+12>>2];c[b+128>>2]=c[h+16>>2];c[b+132>>2]=c[h+20>>2];c[b+136>>2]=c[h+24>>2];c[b+140>>2]=c[h+28>>2];c[b+144>>2]=c[h+32>>2];c[b+148>>2]=c[h+36>>2];c[b+152>>2]=c[h+40>>2];c[b+156>>2]=c[h+44>>2];c[b+160>>2]=c[h+48>>2];c[b+164>>2]=c[h+52>>2];c[b+168>>2]=c[h+56>>2];c[b+172>>2]=c[h+60>>2];h=b+680|0;f=h+48|0;do{c[h>>2]=0;h=h+4|0}while((h|0)<(f|0));c[b+740>>2]=0;c[b+744>>2]=0;c[b+748>>2]=0;c[b+752>>2]=0;g[b+756>>2]=.20000000298023224;g[b+760>>2]=.20000000298023224;g[b+764>>2]=.20000000298023224;c[b+768>>2]=0;c[b+772>>2]=0;c[b+776>>2]=0;c[b+780>>2]=0;c[b+784>>2]=0;g[b+728>>2]=.699999988079071;g[b+732>>2]=1.0;g[b+736>>2]=.5;a[b+788>>0]=0;g[b+792>>2]=0.0;g[b+808>>2]=0.0;a[b+789>>0]=0;g[b+796>>2]=0.0;g[b+812>>2]=0.0;a[b+790>>0]=0;g[b+800>>2]=0.0;g[b+816>>2]=0.0;g[b+928>>2]=0.0;g[b+876>>2]=0.0;g[b+880>>2]=.10000000149011612;g[b+884>>2]=300.0;g[b+868>>2]=1.0;g[b+872>>2]=-1.0;g[b+896>>2]=0.0;g[b+900>>2]=.20000000298023224;g[b+904>>2]=0.0;g[b+908>>2]=0.0;g[b+888>>2]=1.0;g[b+892>>2]=.5;c[b+924>>2]=0;g[b+916>>2]=0.0;a[b+912>>0]=0;g[b+992>>2]=0.0;g[b+940>>2]=0.0;g[b+944>>2]=.10000000149011612;g[b+948>>2]=300.0;g[b+932>>2]=1.0;g[b+936>>2]=-1.0;g[b+960>>2]=0.0;g[b+964>>2]=.20000000298023224;g[b+968>>2]=0.0;g[b+972>>2]=0.0;g[b+952>>2]=1.0;g[b+956>>2]=.5;c[b+988>>2]=0;g[b+980>>2]=0.0;a[b+976>>0]=0;g[b+1056>>2]=0.0;g[b+1004>>2]=0.0;g[b+1008>>2]=.10000000149011612;g[b+1012>>2]=300.0;g[b+996>>2]=1.0;g[b+1e3>>2]=-1.0;g[b+1024>>2]=0.0;g[b+1028>>2]=.20000000298023224;g[b+1032>>2]=0.0;g[b+1036>>2]=0.0;g[b+1016>>2]=1.0;g[b+1020>>2]=.5;c[b+1052>>2]=0;g[b+1044>>2]=0.0;a[b+1040>>0]=0;a[b+1300>>0]=j&1;a[b+1301>>0]=1;c[b+1304>>2]=0;a[b+1308>>0]=0;Bq(b,(c[b+28>>2]|0)+4|0,(c[b+32>>2]|0)+4|0);i=k;return}function Aq(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var h=0,j=0;j=i;i=i+64|0;ar();c[b+4>>2]=6;c[b+8>>2]=-1;c[b+12>>2]=-1;g[b+16>>2]=3402823466385288598117041.0e14;a[b+20>>0]=1;a[b+21>>0]=0;c[b+24>>2]=-1;c[b+28>>2]=2960;c[b+32>>2]=d;g[b+36>>2]=0.0;g[b+40>>2]=.30000001192092896;c[b+44>>2]=0;c[b>>2]=2504;c[b+112>>2]=c[e+0>>2];c[b+116>>2]=c[e+4>>2];c[b+120>>2]=c[e+8>>2];c[b+124>>2]=c[e+12>>2];c[b+128>>2]=c[e+16>>2];c[b+132>>2]=c[e+20>>2];c[b+136>>2]=c[e+24>>2];c[b+140>>2]=c[e+28>>2];c[b+144>>2]=c[e+32>>2];c[b+148>>2]=c[e+36>>2];c[b+152>>2]=c[e+40>>2];c[b+156>>2]=c[e+44>>2];c[b+160>>2]=c[e+48>>2];c[b+164>>2]=c[e+52>>2];c[b+168>>2]=c[e+56>>2];c[b+172>>2]=c[e+60>>2];e=b+680|0;h=e+48|0;do{c[e>>2]=0;e=e+4|0}while((e|0)<(h|0));c[b+740>>2]=0;c[b+744>>2]=0;c[b+748>>2]=0;c[b+752>>2]=0;g[b+756>>2]=.20000000298023224;g[b+760>>2]=.20000000298023224;g[b+764>>2]=.20000000298023224;c[b+768>>2]=0;c[b+772>>2]=0;c[b+776>>2]=0;c[b+780>>2]=0;c[b+784>>2]=0;g[b+728>>2]=.699999988079071;g[b+732>>2]=1.0;g[b+736>>2]=.5;a[b+788>>0]=0;g[b+792>>2]=0.0;g[b+808>>2]=0.0;a[b+789>>0]=0;g[b+796>>2]=0.0;g[b+812>>2]=0.0;a[b+790>>0]=0;g[b+800>>2]=0.0;g[b+816>>2]=0.0;g[b+928>>2]=0.0;g[b+876>>2]=0.0;g[b+880>>2]=.10000000149011612;g[b+884>>2]=300.0;g[b+868>>2]=1.0;g[b+872>>2]=-1.0;g[b+896>>2]=0.0;g[b+900>>2]=.20000000298023224;g[b+904>>2]=0.0;g[b+908>>2]=0.0;g[b+888>>2]=1.0;g[b+892>>2]=.5;c[b+924>>2]=0;g[b+916>>2]=0.0;a[b+912>>0]=0;g[b+992>>2]=0.0;g[b+940>>2]=0.0;g[b+944>>2]=.10000000149011612;g[b+948>>2]=300.0;g[b+932>>2]=1.0;g[b+936>>2]=-1.0;g[b+960>>2]=0.0;g[b+964>>2]=.20000000298023224;g[b+968>>2]=0.0;g[b+972>>2]=0.0;g[b+952>>2]=1.0;g[b+956>>2]=.5;c[b+988>>2]=0;g[b+980>>2]=0.0;a[b+976>>0]=0;g[b+1056>>2]=0.0;g[b+1004>>2]=0.0;g[b+1008>>2]=.10000000149011612;g[b+1012>>2]=300.0;g[b+996>>2]=1.0;g[b+1e3>>2]=-1.0;g[b+1024>>2]=0.0;g[b+1028>>2]=.20000000298023224;g[b+1032>>2]=0.0;g[b+1036>>2]=0.0;g[b+1016>>2]=1.0;g[b+1020>>2]=.5;c[b+1052>>2]=0;g[b+1044>>2]=0.0;a[b+1040>>0]=0;a[b+1300>>0]=f&1;a[b+1301>>0]=1;c[b+1304>>2]=0;a[b+1308>>0]=0;ip(j,d+4|0,b+112|0);c[b+48>>2]=c[j+0>>2];c[b+52>>2]=c[j+4>>2];c[b+56>>2]=c[j+8>>2];c[b+60>>2]=c[j+12>>2];c[b+64>>2]=c[j+16>>2];c[b+68>>2]=c[j+20>>2];c[b+72>>2]=c[j+24>>2];c[b+76>>2]=c[j+28>>2];c[b+80>>2]=c[j+32>>2];c[b+84>>2]=c[j+36>>2];c[b+88>>2]=c[j+40>>2];c[b+92>>2]=c[j+44>>2];c[b+96>>2]=c[j+48>>2];c[b+100>>2]=c[j+52>>2];c[b+104>>2]=c[j+56>>2];c[b+108>>2]=c[j+60>>2];Bq(b,(c[b+28>>2]|0)+4|0,(c[b+32>>2]|0)+4|0);i=j;return}function Bq(b,d,e){b=b|0;d=d|0;e=e|0;var f=0.0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0;C=i;i=i+128|0;ip(C+64|0,d,b+48|0);c[b+1064>>2]=c[C+64>>2];c[b+1068>>2]=c[C+68>>2];c[b+1072>>2]=c[C+72>>2];c[b+1076>>2]=c[C+76>>2];c[b+1080>>2]=c[C+80>>2];c[b+1084>>2]=c[C+84>>2];c[b+1088>>2]=c[C+88>>2];c[b+1092>>2]=c[C+92>>2];c[b+1096>>2]=c[C+96>>2];c[b+1100>>2]=c[C+100>>2];c[b+1104>>2]=c[C+104>>2];c[b+1108>>2]=c[C+108>>2];c[b+1112>>2]=c[C+112>>2];c[b+1116>>2]=c[C+116>>2];c[b+1120>>2]=c[C+120>>2];c[b+1124>>2]=c[C+124>>2];ip(C,e,b+112|0);c[b+1128>>2]=c[C+0>>2];c[b+1132>>2]=c[C+4>>2];c[b+1136>>2]=c[C+8>>2];c[b+1140>>2]=c[C+12>>2];c[b+1144>>2]=c[C+16>>2];c[b+1148>>2]=c[C+20>>2];c[b+1152>>2]=c[C+24>>2];c[b+1156>>2]=c[C+28>>2];c[b+1160>>2]=c[C+32>>2];c[b+1164>>2]=c[C+36>>2];c[b+1168>>2]=c[C+40>>2];c[b+1172>>2]=c[C+44>>2];c[b+1176>>2]=c[C+48>>2];c[b+1180>>2]=c[C+52>>2];c[b+1184>>2]=c[C+56>>2];c[b+1188>>2]=c[C+60>>2];f=+g[b+1176>>2]-+g[b+1112>>2];h=+g[b+1180>>2]-+g[b+1116>>2];l=+g[b+1184>>2]-+g[b+1120>>2];w=+g[b+1084>>2];x=+g[b+1104>>2];y=+g[b+1088>>2];z=+g[b+1100>>2];r=+g[b+1096>>2];s=+g[b+1080>>2];t=+g[b+1064>>2];u=+g[b+1068>>2];v=+g[b+1072>>2];A=1.0/((w*x-y*z)*t+u*(y*r-x*s)+(z*s-w*r)*v);B=(z*s-w*r)*A;j=(w*x-y*z)*A*f+A*(z*v-x*u)*h+A*(y*u-w*v)*l;k=f*((y*r-x*s)*A)+h*(A*(x*t-r*v))+A*(s*v-y*t)*l;l=f*B+A*(r*u-z*t)*h+A*(w*t-s*u)*l;g[b+1256>>2]=j;g[b+1260>>2]=k;g[b+1264>>2]=l;g[b+1268>>2]=0.0;g[b+840>>2]=j;h=+g[b+680>>2];f=+g[b+696>>2];do if(!(h>f)){if(h>j){c[b+856>>2]=2;g[b+824>>2]=j-h;break}if(f<j){c[b+856>>2]=1;g[b+824>>2]=j-f;break}else{c[b+856>>2]=0;g[b+824>>2]=0.0;break}}else{c[b+856>>2]=0;g[b+824>>2]=0.0}while(0);g[b+844>>2]=k;h=+g[b+684>>2];f=+g[b+700>>2];do if(!(h>f)){if(h>k){c[b+860>>2]=2;g[b+828>>2]=k-h;break}if(f<k){c[b+860>>2]=1;g[b+828>>2]=k-f;break}else{c[b+860>>2]=0;g[b+828>>2]=0.0;break}}else{c[b+860>>2]=0;g[b+828>>2]=0.0}while(0);g[b+848>>2]=l;h=+g[b+688>>2];f=+g[b+704>>2];do if(!(h>f)){if(h>l){c[b+864>>2]=2;g[b+832>>2]=l-h;break}if(f<l){c[b+864>>2]=1;g[b+832>>2]=l-f;break}else{c[b+864>>2]=0;g[b+832>>2]=0.0;break}}else{c[b+864>>2]=0;g[b+832>>2]=0.0}while(0);l=+g[b+1128>>2];k=+g[b+1144>>2];j=+g[b+1160>>2];h=+g[b+1132>>2];f=+g[b+1148>>2];m=+g[b+1164>>2];o=(w*x-y*z)*A*h+A*(z*v-x*u)*f+A*(y*u-w*v)*m;q=(y*r-x*s)*A*h+A*(x*t-r*v)*f+A*(s*v-y*t)*m;p=l*B+A*(r*u-z*t)*k+A*(w*t-s*u)*j;n=B*+g[b+1136>>2]+A*(r*u-z*t)*+g[b+1152>>2]+A*(w*t-s*u)*+g[b+1168>>2];do if(p<1.0)if(p>-1.0){g[b+1192>>2]=+X(+-(B*h+A*(r*u-z*t)*f+A*(w*t-s*u)*m),+n);p=p<-1.0?-1.0:p;g[b+1196>>2]=+V(+(p>1.0?1.0:p));g[b+1200>>2]=+X(+-(l*((y*r-x*s)*A)+k*(A*(x*t-r*v))+A*(s*v-y*t)*j),+(l*((w*x-y*z)*A)+k*(A*(z*v-x*u))+A*(y*u-w*v)*j));break}else{g[b+1192>>2]=-+X(+o,+q);g[b+1196>>2]=-1.5707963705062866;g[b+1200>>2]=0.0;break}else{g[b+1192>>2]=+X(+o,+q);g[b+1196>>2]=1.5707963705062866;g[b+1200>>2]=0.0}while(0);g[b+1236>>2]=0.0;f=x*(l*x-j*v)-y*(k*v-l*y);q=v*(k*v-l*y)-x*(j*y-k*x);h=y*(j*y-k*x)-v*(l*x-j*v);g[b+1220>>2]=0.0;m=k*(k*v-l*y)-j*(l*x-j*v);n=j*(j*y-k*x)-l*(k*v-l*y);o=l*(l*x-j*v)-k*(j*y-k*x);g[b+1252>>2]=0.0;p=1.0/+P(+(f*f+q*q+h*h));g[b+1208>>2]=f*p;g[b+1212>>2]=q*p;g[b+1216>>2]=h*p;p=1.0/+P(+((j*y-k*x)*(j*y-k*x)+(l*x-j*v)*(l*x-j*v)+(k*v-l*y)*(k*v-l*y)));g[b+1224>>2]=(j*y-k*x)*p;g[b+1228>>2]=(l*x-j*v)*p;g[b+1232>>2]=(k*v-l*y)*p;p=1.0/+P(+(m*m+n*n+o*o));g[b+1240>>2]=m*p;g[b+1244>>2]=n*p;g[b+1248>>2]=o*p;if(!(a[b+1301>>0]|0)){i=C;return}f=+g[(c[b+28>>2]|0)+344>>2];h=+g[(c[b+32>>2]|0)+344>>2];if(f<1.1920928955078125e-07)e=1;else e=h<1.1920928955078125e-07&1;a[b+1280>>0]=e;if(f+h>0.0)f=h/(f+h);else f=.5;g[b+1272>>2]=f;g[b+1276>>2]=1.0-f;i=C;return}
function aD(b,d,e,f,h,j,k){b=b|0;d=d|0;e=e|0;f=f|0;h=+h;j=+j;k=k|0;var l=0,m=0,n=0.0,o=0,p=0,q=0,r=0.0,s=0.0,t=0.0,u=0.0,v=0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0,I=0,J=0,K=0,L=0,M=0.0,N=0.0,O=0.0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0.0,ca=0,da=0;aa=i;i=i+64|0;a[aa+48>>0]=1;c[aa+44>>2]=0;c[aa+36>>2]=0;c[aa+40>>2]=0;m=c[f+4>>2]|0;if((m|0)>0){c[5108]=(c[5108]|0)+1;l=QE((m<<4|3)+16|0)|0;if(!l)l=0;else{c[(l+19&-16)+-4>>2]=l;l=l+19&-16}a[aa+48>>0]=1;c[aa+44>>2]=l;c[aa+40>>2]=m}else l=0;q=c[d+28>>2]|0;if((q|0)>0){_=c[d+36>>2]|0;u=+g[e>>2];t=+g[e+4>>2];n=+g[e+8>>2];D=+g[e+16>>2];E=+g[e+20>>2];F=+g[e+24>>2];G=+g[e+32>>2];r=+g[e+36>>2];s=+g[e+40>>2];w=+g[b>>2];x=+g[b+4>>2];y=+g[b+8>>2];$=-1;C=3402823466385288598117041.0e14;o=0;while(1){z=+g[_+(o*36|0)+20>>2];A=+g[_+(o*36|0)+24>>2];B=+g[_+(o*36|0)+28>>2];p=(z*u+A*t+B*n)*w+(z*D+A*E+B*F)*x+(z*G+A*r+B*s)*y<C;$=p?o:$;o=o+1|0;if((o|0)==(q|0))break;else C=p?(z*u+A*t+B*n)*w+(z*D+A*E+B*F)*x+(z*G+A*r+B*s)*y:C}if(($|0)>=0){R=c[_+($*36|0)+4>>2]|0;if((R|0)>0){S=_+($*36|0)+12|0;U=_+($*36|0)+20|0;p=_+($*36|0)+24|0;Z=_+($*36|0)+28|0;B=D;w=E;x=F;C=G;Q=0;P=f;T=aa+32|0;while(1){L=c[S>>2]|0;v=c[L+(Q<<2)>>2]|0;q=c[d+16>>2]|0;Q=Q+1|0;L=c[L+(((Q|0)==(R|0)?0:Q)<<2)>>2]|0;F=+g[q+(v<<4)>>2];G=F-+g[q+(L<<4)>>2];E=+g[q+(v<<4)+4>>2];ba=E-+g[q+(L<<4)+4>>2];D=+g[q+(v<<4)+8>>2];z=D-+g[q+(L<<4)+8>>2];O=G*u+ba*t+z*n;M=G*B+ba*w+z*x;z=G*C+ba*r+z*s;ba=+g[U>>2];G=+g[p>>2];y=+g[Z>>2];N=u*ba+t*G+n*y;A=B*ba+w*G+x*y;y=C*ba+r*G+s*y;B=(F*u+E*t+D*n+ +g[e+48>>2])*-(M*y-z*A)+(F*B+E*w+D*x+ +g[e+52>>2])*-(z*N-O*y)+(F*C+E*r+D*s+ +g[e+56>>2])*-(O*A-M*N);L=P+4|0;q=c[L>>2]|0;if((q|0)>=2){H=P+12|0;o=c[H>>2]|0;D=+g[o+(q+-1<<4)>>2];F=+g[o+(q+-1<<4)+4>>2];G=+g[o+(q+-1<<4)+8>>2];K=T+4|0;l=T+8|0;I=T+12|0;J=T+16|0;E=D*-(M*y-z*A)+F*-(z*N-O*y)+G*-(O*A-M*N)-B;v=0;while(1){x=+g[o+(v<<4)>>2];s=+g[o+(v<<4)+4>>2];r=+g[o+(v<<4)+8>>2];C=+g[o+(v<<4)+12>>2];n=x*-(M*y-z*A)+s*-(z*N-O*y)+r*-(O*A-M*N)-B;do if(E<0.0)if(n<0.0){f=c[K>>2]|0;if((f|0)==(c[l>>2]|0)?(W=(f|0)==0?1:f<<1,(f|0)<(W|0)):0){if(!W)o=0;else{c[5108]=(c[5108]|0)+1;f=QE((W<<4|3)+16|0)|0;if(!f)o=0;else{c[(f+19&-16)+-4>>2]=f;o=f+19&-16}f=c[K>>2]|0}if((f|0)>0){m=0;do{ca=o+(m<<4)|0;da=(c[I>>2]|0)+(m<<4)|0;c[ca+0>>2]=c[da+0>>2];c[ca+4>>2]=c[da+4>>2];c[ca+8>>2]=c[da+8>>2];c[ca+12>>2]=c[da+12>>2];m=m+1|0}while((m|0)!=(f|0))}f=c[I>>2]|0;if(f){if(a[J>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[f+-4>>2]|0)}c[I>>2]=0}a[J>>0]=1;c[I>>2]=o;c[l>>2]=W;f=c[K>>2]|0}o=c[I>>2]|0;g[o+(f<<4)>>2]=x;g[o+(f<<4)+4>>2]=s;g[o+(f<<4)+8>>2]=r;g[o+(f<<4)+12>>2]=C;c[K>>2]=(c[K>>2]|0)+1;break}else{w=E/(E-n);E=D+(x-D)*w;F=F+(s-F)*w;G=G+(r-G)*w;f=c[K>>2]|0;if((f|0)==(c[l>>2]|0)?(Y=(f|0)==0?1:f<<1,(f|0)<(Y|0)):0){if(!Y)o=0;else{c[5108]=(c[5108]|0)+1;f=QE((Y<<4|3)+16|0)|0;if(!f)o=0;else{c[(f+19&-16)+-4>>2]=f;o=f+19&-16}f=c[K>>2]|0}if((f|0)>0){m=0;do{ca=o+(m<<4)|0;da=(c[I>>2]|0)+(m<<4)|0;c[ca+0>>2]=c[da+0>>2];c[ca+4>>2]=c[da+4>>2];c[ca+8>>2]=c[da+8>>2];c[ca+12>>2]=c[da+12>>2];m=m+1|0}while((m|0)!=(f|0))}f=c[I>>2]|0;if(f){if(a[J>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[f+-4>>2]|0)}c[I>>2]=0}a[J>>0]=1;c[I>>2]=o;c[l>>2]=Y;f=c[K>>2]|0}o=c[I>>2]|0;g[o+(f<<4)>>2]=E;g[o+(f<<4)+4>>2]=F;g[o+(f<<4)+8>>2]=G;g[o+(f<<4)+12>>2]=0.0;c[K>>2]=(c[K>>2]|0)+1;break}else if(n<0.0){w=E/(E-n);E=D+(x-D)*w;F=F+(s-F)*w;G=G+(r-G)*w;f=c[K>>2]|0;if((f|0)==(c[l>>2]|0)?(X=(f|0)==0?1:f<<1,(f|0)<(X|0)):0){if(!X)o=0;else{c[5108]=(c[5108]|0)+1;f=QE((X<<4|3)+16|0)|0;if(!f)o=0;else{c[(f+19&-16)+-4>>2]=f;o=f+19&-16}f=c[K>>2]|0}if((f|0)>0){m=0;do{ca=o+(m<<4)|0;da=(c[I>>2]|0)+(m<<4)|0;c[ca+0>>2]=c[da+0>>2];c[ca+4>>2]=c[da+4>>2];c[ca+8>>2]=c[da+8>>2];c[ca+12>>2]=c[da+12>>2];m=m+1|0}while((m|0)!=(f|0))}f=c[I>>2]|0;if(f){if(a[J>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[f+-4>>2]|0)}c[I>>2]=0}a[J>>0]=1;c[I>>2]=o;c[l>>2]=X;f=c[K>>2]|0}o=c[I>>2]|0;g[o+(f<<4)>>2]=E;g[o+(f<<4)+4>>2]=F;g[o+(f<<4)+8>>2]=G;g[o+(f<<4)+12>>2]=0.0;f=(c[K>>2]|0)+1|0;c[K>>2]=f;if((f|0)==(c[l>>2]|0)?(V=(f|0)==0?1:f<<1,(f|0)<(V|0)):0){if(!V)o=0;else{c[5108]=(c[5108]|0)+1;f=QE((V<<4|3)+16|0)|0;if(!f)o=0;else{c[(f+19&-16)+-4>>2]=f;o=f+19&-16}f=c[K>>2]|0}if((f|0)>0){m=0;do{ca=o+(m<<4)|0;da=(c[I>>2]|0)+(m<<4)|0;c[ca+0>>2]=c[da+0>>2];c[ca+4>>2]=c[da+4>>2];c[ca+8>>2]=c[da+8>>2];c[ca+12>>2]=c[da+12>>2];m=m+1|0}while((m|0)!=(f|0))}f=c[I>>2]|0;if(f){if(a[J>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[f+-4>>2]|0)}c[I>>2]=0}a[J>>0]=1;c[I>>2]=o;c[l>>2]=V;f=c[K>>2]|0}o=c[I>>2]|0;g[o+(f<<4)>>2]=x;g[o+(f<<4)+4>>2]=s;g[o+(f<<4)+8>>2]=r;g[o+(f<<4)+12>>2]=C;c[K>>2]=(c[K>>2]|0)+1}while(0);f=v+1|0;if((f|0)==(q|0))break;o=c[H>>2]|0;E=n;D=x;F=s;G=r;v=f}q=c[L>>2]|0}if((q|0)<0){m=P+8|0;f=P+12|0;if((c[m>>2]|0)<0){o=c[f>>2]|0;l=P+16|0;if(o){if(a[l>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[o+-4>>2]|0)}c[f>>2]=0}a[l>>0]=1;c[f>>2]=0;c[m>>2]=0}do{v=(c[f>>2]|0)+(q<<4)|0;c[v+0>>2]=c[aa+16>>2];c[v+4>>2]=c[aa+20>>2];c[v+8>>2]=c[aa+24>>2];c[v+12>>2]=c[aa+28>>2];q=q+1|0}while((q|0)!=0)}c[L>>2]=0;u=+g[e>>2];t=+g[e+4>>2];n=+g[e+8>>2];B=+g[e+16>>2];w=+g[e+20>>2];x=+g[e+24>>2];C=+g[e+32>>2];r=+g[e+36>>2];s=+g[e+40>>2];if((Q|0)>=(R|0)){l=e+56|0;v=e+48|0;m=e+52|0;o=U;q=Z;f=T;break}else{v=T;T=P;P=v}}}else{B=D;w=E;x=F;C=G;l=e+56|0;v=e+48|0;m=e+52|0;o=_+($*36|0)+20|0;p=_+($*36|0)+24|0;q=_+($*36|0)+28|0}y=+g[o>>2];z=+g[p>>2];A=+g[q>>2];u=y*u+z*t+A*n;t=y*B+z*w+A*x;s=y*C+z*r+A*s;r=+g[_+($*36|0)+32>>2]-(u*+g[v>>2]+t*+g[m>>2]+s*+g[l>>2]);q=f+4|0;l=c[q>>2]|0;if((l|0)>0){p=f+12|0;o=0;do{Y=c[p>>2]|0;m=Y+(o<<4)|0;n=r+(u*+g[m>>2]+t*+g[Y+(o<<4)+4>>2]+s*+g[Y+(o<<4)+8>>2]);n=!(n<=h)?n:h;if(n<=j){c[aa+0>>2]=c[m+0>>2];c[aa+4>>2]=c[m+4>>2];c[aa+8>>2]=c[m+8>>2];c[aa+12>>2]=c[m+12>>2];oc[c[(c[k>>2]|0)+16>>2]&15](k,b,aa,n);l=c[q>>2]|0}o=o+1|0}while((o|0)<(l|0))}l=c[aa+44>>2]|0}}if(!l){i=aa;return}if(a[aa+48>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[l+-4>>2]|0)}c[aa+44>>2]=0;i=aa;return}function bD(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var h=0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0,L=0,M=0,N=0,O=0;h=i;i=i+288|0;if(!(c[b+16>>2]|0)){K=c[b+12>>2]|0;b=c[b+20>>2]|0;n=+g[d>>2];q=+g[d+4>>2];u=+g[d+8>>2];k=+g[d+16>>2];r=+g[d+20>>2];j=+g[d+24>>2];m=+g[d+32>>2];s=+g[d+36>>2];l=+g[d+40>>2];F=+g[d+48>>2];E=+g[d+52>>2];D=+g[d+56>>2];J=+g[e>>2];I=+g[e+16>>2];y=+g[e+32>>2];H=+g[e+4>>2];G=+g[e+20>>2];w=+g[e+36>>2];v=+g[e+8>>2];z=+g[e+24>>2];x=+g[e+40>>2];C=-+g[e+48>>2];B=-+g[e+52>>2];p=-+g[e+56>>2];d=c[(c[K>>2]|0)+64>>2]|0;A=-+g[b+48>>2];t=-+g[b+52>>2];o=-+g[b+56>>2];g[h+32>>2]=(n*J+k*I+m*y)*A+(n*H+k*G+m*w)*t+(n*v+k*z+m*x)*o;g[h+36>>2]=(q*J+r*I+s*y)*A+(q*H+r*G+s*w)*t+(q*v+r*z+s*x)*o;g[h+40>>2]=(u*J+j*I+l*y)*A+(u*H+j*G+l*w)*t+(u*v+j*z+l*x)*o;g[h+44>>2]=0.0;pc[d&127](h+48|0,K,h+32|0);o=+g[h+48>>2];t=+g[h+52>>2];A=+g[h+56>>2];y=F*J+E*I+D*y+(J*C+I*B+y*p)+((n*J+k*I+m*y)*o+(q*J+r*I+s*y)*t+(u*J+j*I+l*y)*A);w=F*H+E*G+D*w+(H*C+G*B+w*p)+((n*H+k*G+m*w)*o+(q*H+r*G+s*w)*t+(u*H+j*G+l*w)*A);A=F*v+E*z+D*x+(v*C+z*B+x*p)+((n*v+k*z+m*x)*o+(q*v+r*z+s*x)*t+(u*v+j*z+l*x)*A);x=+g[b+48>>2];l=+g[b+52>>2];z=+g[b+56>>2];j=z*A+(x*y+l*w)-+g[b+64>>2];v=+g[e>>2];u=+g[e+4>>2];t=+g[e+8>>2];s=+g[e+16>>2];r=+g[e+20>>2];q=+g[e+24>>2];o=+g[e+32>>2];m=+g[e+36>>2];k=+g[e+40>>2];n=s*(y-x*j)+(w-l*j)*r+(A-z*j)*q+ +g[e+52>>2];p=(y-x*j)*o+(w-l*j)*m+(A-z*j)*k+ +g[e+56>>2];g[h+16>>2]=t*(A-z*j)+(v*(y-x*j)+u*(w-l*j))+ +g[e+48>>2];g[h+20>>2]=n;g[h+24>>2]=p;g[h+28>>2]=0.0;p=+g[b+48>>2];n=+g[b+52>>2];l=+g[b+56>>2];g[h>>2]=v*p+u*n+t*l;g[h+4>>2]=p*s+n*r+l*q;g[h+8>>2]=p*o+n*m+l*k;g[h+12>>2]=0.0;oc[c[(c[f>>2]|0)+16>>2]&15](f,h,h+16|0,j);i=h;return}else{N=c[b+4>>2]|0;a[N+312>>0]=0;c[N>>2]=0;a[N+356>>0]=1;g[N+292>>2]=999999984306749440.0;g[N+296>>2]=999999984306749440.0;g[N+300>>2]=999999984306749440.0;g[N+304>>2]=0.0;c[N+336>>2]=0;c[N+340>>2]=0;c[N+344>>2]=0;c[N+348>>2]=0;a[N+352>>0]=0;a[N+332>>0]=a[N+332>>0]&-16;N=c[b+12>>2]|0;M=c[b+16>>2]|0;L=c[N+4>>2]|0;K=c[M+4>>2]|0;D=+Zb[c[(c[N>>2]|0)+48>>2]&15](N);O=c[b+16>>2]|0;E=+Zb[c[(c[O>>2]|0)+48>>2]&15](O);O=c[b+4>>2]|0;b=c[b+8>>2]|0;c[h+200>>2]=19400;g[h+204>>2]=0.0;g[h+208>>2]=1.0;g[h+212>>2]=0.0;g[h+216>>2]=0.0;c[h+220>>2]=b;c[h+224>>2]=O;c[h+228>>2]=N;c[h+232>>2]=M;c[h+236>>2]=L;c[h+240>>2]=K;g[h+244>>2]=D;g[h+248>>2]=E;a[h+252>>0]=0;c[h+260>>2]=-1;c[h+272>>2]=1;c[h+276>>2]=1;g[h+192>>2]=999999984306749440.0;c[h+64>>2]=c[d+0>>2];c[h+68>>2]=c[d+4>>2];c[h+72>>2]=c[d+8>>2];c[h+76>>2]=c[d+12>>2];c[h+80>>2]=c[d+16>>2];c[h+84>>2]=c[d+20>>2];c[h+88>>2]=c[d+24>>2];c[h+92>>2]=c[d+28>>2];c[h+96>>2]=c[d+32>>2];c[h+100>>2]=c[d+36>>2];c[h+104>>2]=c[d+40>>2];c[h+108>>2]=c[d+44>>2];c[h+112>>2]=c[d+48>>2];c[h+116>>2]=c[d+52>>2];c[h+120>>2]=c[d+56>>2];c[h+124>>2]=c[d+60>>2];c[h+128>>2]=c[e+0>>2];c[h+132>>2]=c[e+4>>2];c[h+136>>2]=c[e+8>>2];c[h+140>>2]=c[e+12>>2];c[h+144>>2]=c[e+16>>2];c[h+148>>2]=c[e+20>>2];c[h+152>>2]=c[e+24>>2];c[h+156>>2]=c[e+28>>2];c[h+160>>2]=c[e+32>>2];c[h+164>>2]=c[e+36>>2];c[h+168>>2]=c[e+40>>2];c[h+172>>2]=c[e+44>>2];c[h+176>>2]=c[e+48>>2];c[h+180>>2]=c[e+52>>2];c[h+184>>2]=c[e+56>>2];c[h+188>>2]=c[e+60>>2];eD(h+200|0,h+64|0,f,0,0);i=h;return}}function cD(b,d,e,f,h,j){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;var k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0;z=i;i=i+304|0;w=+g[e+48>>2]-+g[d+48>>2];y=+g[e+52>>2]-+g[d+52>>2];x=+g[e+56>>2]-+g[d+56>>2];Bp(d,e,z+256|0,z+192|0);r=+g[z+192>>2];p=+g[z+256>>2]*r;q=r*+g[z+260>>2];r=r*+g[z+264>>2];g[z+176>>2]=p;g[z+180>>2]=q;g[z+184>>2]=r;g[z+188>>2]=0.0;t=+g[h+48>>2]-+g[f+48>>2];v=+g[h+52>>2]-+g[f+52>>2];u=+g[h+56>>2]-+g[f+56>>2];Bp(f,h,z+256|0,z+192|0);o=+g[z+192>>2];m=+g[z+256>>2]*o;n=o*+g[z+260>>2];o=o*+g[z+264>>2];g[z+160>>2]=m;g[z+164>>2]=n;g[z+168>>2]=o;g[z+172>>2]=0.0;h=c[b+12>>2]|0;l=+Zb[c[(c[h>>2]|0)+16>>2]&15](h);h=c[b+16>>2]|0;if(!h)k=0.0;else k=+Zb[c[(c[h>>2]|0)+16>>2]&15](h);p=l*+P(+(p*p+q*q+r*r))+k*+P(+(m*m+n*n+o*o));if(p+ +P(+((t-w)*(t-w)+(v-y)*(v-y)+(u-x)*(u-x)))==0.0){e=0;i=z;return e|0}c[z+256>>2]=19192;g[z+292>>2]=999999984306749440.0;a[z+296>>0]=0;bD(b,d,f,z+256|0);e=(a[z+296>>0]|0)==0;c[z+144>>2]=c[z+276>>2];c[z+148>>2]=c[z+280>>2];c[z+152>>2]=c[z+284>>2];c[z+156>>2]=c[z+288>>2];if(e){e=0;i=z;return e|0}k=+g[z+260>>2];l=+g[z+264>>2];o=+g[z+268>>2];if(p+((t-w)*k+(v-y)*l+(u-x)*o)<=1.1920928955078125e-07){e=0;i=z;return e|0}q=+g[z+292>>2]+ +g[j+172>>2];n=0.0;r=+g[z+272>>2];s=0;while(1){if(!(q>1.0000000474974513e-03)){h=18;break}h=c[j+168>>2]|0;if(h){e=c[(c[h>>2]|0)+20>>2]|0;g[z+128>>2]=1.0;g[z+132>>2]=1.0;g[z+136>>2]=1.0;g[z+140>>2]=0.0;Ob[e&7](h,z+144|0,.20000000298023224,z+128|0)}k=p+((u-x)*o+((v-y)*l+(t-w)*k));if(k<=1.1920928955078125e-07){e=0;h=19;break}k=n+q/k;if(!(!(k<0.0)&!(k>1.0)&!(k<=n))){e=0;h=19;break}Ap(d,w,y,x,z+176|0,k,z+192|0);Ap(f,t,v,u,z+160|0,k,z+64|0);h=c[j+168>>2]|0;if(h){e=c[(c[h>>2]|0)+20>>2]|0;g[z+48>>2]=1.0;g[z+52>>2]=0.0;g[z+56>>2]=0.0;g[z+60>>2]=0.0;Ob[e&7](h,z+240|0,.20000000298023224,z+48|0)}Ib[c[c[j>>2]>>2]&31](j,k);c[z>>2]=19192;g[z+36>>2]=999999984306749440.0;a[z+40>>0]=0;bD(b,z+192|0,z+64|0,z);if(!(a[z+40>>0]|0)){h=16;break}q=+g[z+36>>2]+ +g[j+172>>2];c[z+144>>2]=c[z+20>>2];c[z+148>>2]=c[z+24>>2];c[z+152>>2]=c[z+28>>2];c[z+156>>2]=c[z+32>>2];e=s+1|0;if((s|0)>63){h=17;break}else{n=k;k=+g[z+4>>2];r=+g[z+16>>2];l=+g[z+8>>2];o=+g[z+12>>2];s=e}}if((h|0)==16){pc[c[(c[j>>2]|0)+8>>2]&127](j,-1,s);e=0;i=z;return e|0}else if((h|0)==17){pc[c[(c[j>>2]|0)+8>>2]&127](j,-2,e);e=0;i=z;return e|0}else if((h|0)==18){g[j+164>>2]=n;g[j+132>>2]=k;g[j+136>>2]=l;g[j+140>>2]=o;g[j+144>>2]=r;c[j+148>>2]=c[z+144>>2];c[j+152>>2]=c[z+148>>2];c[j+156>>2]=c[z+152>>2];c[j+160>>2]=c[z+156>>2];e=1;i=z;return e|0}else if((h|0)==19){i=z;return e|0}return 0}function dD(a){a=a|0;var b=0;b=i;RE(a);i=b;return}function eD(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0,p=0.0,q=0.0,r=0.0,s=0.0,t=0,u=0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0,M=0,N=0,O=0.0,Q=0.0,R=0.0,S=0;N=i;i=i+288|0;g[b+56>>2]=0.0;L=N+276|0;M=N+280|0;c[N+272>>2]=0;c[N+276>>2]=0;c[N+280>>2]=0;c[N+284>>2]=0;c[N+208>>2]=c[d+0>>2];c[N+212>>2]=c[d+4>>2];c[N+216>>2]=c[d+8>>2];c[N+220>>2]=c[d+12>>2];c[N+224>>2]=c[d+16>>2];c[N+228>>2]=c[d+20>>2];c[N+232>>2]=c[d+24>>2];c[N+236>>2]=c[d+28>>2];c[N+240>>2]=c[d+32>>2];c[N+244>>2]=c[d+36>>2];c[N+248>>2]=c[d+40>>2];c[N+252>>2]=c[d+44>>2];o=N+256|0;c[o+0>>2]=c[d+48>>2];c[o+4>>2]=c[d+52>>2];c[o+8>>2]=c[d+56>>2];c[o+12>>2]=c[d+60>>2];c[N+144>>2]=c[d+64>>2];c[N+148>>2]=c[d+68>>2];c[N+152>>2]=c[d+72>>2];c[N+156>>2]=c[d+76>>2];c[N+160>>2]=c[d+80>>2];c[N+164>>2]=c[d+84>>2];c[N+168>>2]=c[d+88>>2];c[N+172>>2]=c[d+92>>2];c[N+176>>2]=c[d+96>>2];c[N+180>>2]=c[d+100>>2];c[N+184>>2]=c[d+104>>2];c[N+188>>2]=c[d+108>>2];u=N+192|0;c[u+0>>2]=c[d+112>>2];c[u+4>>2]=c[d+116>>2];c[u+8>>2]=c[d+120>>2];c[u+12>>2]=c[d+124>>2];F=+g[o>>2];G=+g[u>>2];H=+g[N+260>>2];I=+g[N+196>>2];J=+g[N+264>>2];K=+g[N+200>>2];g[o>>2]=F-(F+G)*.5;g[N+260>>2]=H-(H+I)*.5;g[N+264>>2]=J-(J+K)*.5;g[u>>2]=G-(F+G)*.5;g[N+196>>2]=I-(H+I)*.5;g[N+200>>2]=K-(J+K)*.5;if(((c[(c[b+28>>2]|0)+4>>2]|0)+-17|0)>>>0<2)h=((c[(c[b+32>>2]|0)+4>>2]|0)+-17|0)>>>0<2;else h=0;D=+g[b+44>>2];E=+g[b+48>>2];c[4846]=(c[4846]|0)+1;u=(a[b+52>>0]|0)==0;E=u?E:0.0;c[b+64>>2]=0;g[b+4>>2]=0.0;g[b+8>>2]=1.0;g[b+12>>2]=0.0;g[b+16>>2]=0.0;c[b+68>>2]=0;c[b+60>>2]=-1;D=(u?D:0.0)+E;u=c[b+24>>2]|0;a[u+312>>0]=0;c[u>>2]=0;a[u+356>>0]=1;g[u+292>>2]=999999984306749440.0;g[u+296>>2]=999999984306749440.0;g[u+300>>2]=999999984306749440.0;g[u+304>>2]=0.0;c[u+336>>2]=0;c[u+340>>2]=0;c[u+344>>2]=0;c[u+348>>2]=0;a[u+352>>0]=0;a[u+332>>0]=a[u+332>>0]&-16;k=+g[b+4>>2];j=+g[b+8>>2];l=+g[b+12>>2];a:do if(h){m=j;j=999999984306749440.0;while(1){r=-k;n=-m;p=-l;s=+g[d+4>>2]*r+ +g[d+20>>2]*n+ +g[d+36>>2]*p;B=+g[d+8>>2]*r+ +g[d+24>>2]*n+ +g[d+40>>2]*p;g[N+128>>2]=+g[d>>2]*r+ +g[d+16>>2]*n+ +g[d+32>>2]*p;g[N+132>>2]=s;g[N+136>>2]=B;g[N+140>>2]=0.0;B=k*+g[d+68>>2]+m*+g[d+84>>2]+l*+g[d+100>>2];s=k*+g[d+72>>2]+m*+g[d+88>>2]+l*+g[d+104>>2];g[N+112>>2]=+g[d+64>>2]*k+ +g[d+80>>2]*m+ +g[d+96>>2]*l;g[N+116>>2]=B;g[N+120>>2]=s;g[N+124>>2]=0.0;By(N+96|0,c[b+28>>2]|0,N+128|0);By(N+80|0,c[b+32>>2]|0,N+112|0);s=+g[N+96>>2];B=+g[N+100>>2];m=+g[N+104>>2];p=s*+g[N+208>>2]+B*+g[N+212>>2]+m*+g[N+216>>2]+ +g[N+256>>2];m=s*+g[N+224>>2]+B*+g[N+228>>2]+m*+g[N+232>>2]+ +g[N+260>>2];B=+g[N+80>>2];s=+g[N+84>>2];n=+g[N+88>>2];r=B*+g[N+144>>2]+s*+g[N+148>>2]+n*+g[N+152>>2]+ +g[N+192>>2];n=B*+g[N+160>>2]+s*+g[N+164>>2]+n*+g[N+168>>2]+ +g[N+196>>2];s=+g[b+4>>2]*(p-r)+ +g[b+8>>2]*(m-n)+ +g[b+12>>2]*0.0;if(s>0.0?s*s>j*+g[d+128>>2]:0){S=22;break a}t=c[b+24>>2]|0;u=c[t>>2]|0;if((u|0)>0){q=+g[t+308>>2];o=0;h=0;do{z=p-r-+g[t+(h<<4)+4>>2];A=m-n-+g[t+(h<<4)+8>>2];B=0.0-+g[t+(h<<4)+12>>2];o=o|z*z+A*A+B*B<=q;h=h+1|0}while((h|0)!=(u|0))}else o=0;if((+g[t+304>>2]==0.0?+g[t+300>>2]==0.0:0)?m-n==+g[t+296>>2]:0)h=p-r==+g[t+292>>2];else h=0;if(h|o){S=31;break a}k=j-s;if(k<=j*9.999999974752427e-07){S=33;break a}g[t+292>>2]=p-r;g[t+296>>2]=m-n;g[t+300>>2]=0.0;g[t+304>>2]=0.0;a[t+356>>0]=1;g[t+(u<<4)+4>>2]=p-r;g[t+(u<<4)+8>>2]=m-n;g[t+(u<<4)+12>>2]=0.0;g[t+(u<<4)+16>>2]=0.0;o=c[t>>2]|0;g[t+(o<<4)+84>>2]=p;g[t+(o<<4)+88>>2]=m;g[t+(o<<4)+92>>2]=0.0;g[t+(o<<4)+96>>2]=0.0;o=c[t>>2]|0;g[t+(o<<4)+164>>2]=r;g[t+(o<<4)+168>>2]=n;g[t+(o<<4)+172>>2]=0.0;g[t+(o<<4)+176>>2]=0.0;c[t>>2]=(c[t>>2]|0)+1;o=c[b+24>>2]|0;u=qD(o)|0;k=+g[o+276>>2];m=+g[o+280>>2];l=+g[o+284>>2];n=+g[o+288>>2];if(!u){S=35;break a}p=j;j=k*k+m*m+l*l;if(j<9.999999974752427e-07){j=p;S=37;break a}if(p-j<=p*1.1920928955078125e-07){S=39;break a}g[b+4>>2]=k;g[b+8>>2]=m;g[b+12>>2]=l;g[b+16>>2]=n;u=c[b+64>>2]|0;c[b+64>>2]=u+1;if((u|0)>1e3){B=0.0;o=0;m=0.0;A=0.0;q=0.0;break a}if((c[c[b+24>>2]>>2]|0)==4){S=42;break}}}else{m=j;j=999999984306749440.0;while(1){w=-k;x=-m;v=-l;z=+g[d+4>>2]*w+ +g[d+20>>2]*x+ +g[d+36>>2]*v;B=+g[d+8>>2]*w+ +g[d+24>>2]*x+ +g[d+40>>2]*v;g[N+128>>2]=+g[d>>2]*w+ +g[d+16>>2]*x+ +g[d+32>>2]*v;g[N+132>>2]=z;g[N+136>>2]=B;g[N+140>>2]=0.0;B=k*+g[d+68>>2]+m*+g[d+84>>2]+l*+g[d+100>>2];z=k*+g[d+72>>2]+m*+g[d+88>>2]+l*+g[d+104>>2];g[N+112>>2]=+g[d+64>>2]*k+ +g[d+80>>2]*m+ +g[d+96>>2]*l;g[N+116>>2]=B;g[N+120>>2]=z;g[N+124>>2]=0.0;By(N+96|0,c[b+28>>2]|0,N+128|0);By(N+80|0,c[b+32>>2]|0,N+112|0);z=+g[N+96>>2];B=+g[N+100>>2];v=+g[N+104>>2];x=z*+g[N+208>>2]+B*+g[N+212>>2]+v*+g[N+216>>2]+ +g[N+256>>2];m=z*+g[N+224>>2]+B*+g[N+228>>2]+v*+g[N+232>>2]+ +g[N+260>>2];v=z*+g[N+240>>2]+B*+g[N+244>>2]+v*+g[N+248>>2]+ +g[N+264>>2];B=+g[N+80>>2];z=+g[N+84>>2];w=+g[N+88>>2];y=B*+g[N+144>>2]+z*+g[N+148>>2]+w*+g[N+152>>2]+ +g[N+192>>2];l=B*+g[N+160>>2]+z*+g[N+164>>2]+w*+g[N+168>>2]+ +g[N+196>>2];w=B*+g[N+176>>2]+z*+g[N+180>>2]+w*+g[N+184>>2]+ +g[N+200>>2];z=+g[b+4>>2]*(x-y)+ +g[b+8>>2]*(m-l)+ +g[b+12>>2]*(v-w);if(z>0.0?z*z>j*+g[d+128>>2]:0){S=22;break a}u=c[b+24>>2]|0;t=c[u>>2]|0;if((t|0)>0){q=+g[u+308>>2];h=0;o=0;do{k=x-y-+g[u+(o<<4)+4>>2];A=m-l-+g[u+(o<<4)+8>>2];B=v-w-+g[u+(o<<4)+12>>2];h=h|k*k+A*A+B*B<=q;o=o+1|0}while((o|0)!=(t|0))}else h=0;if((+g[u+304>>2]==0.0?v-w==+g[u+300>>2]:0)?m-l==+g[u+296>>2]:0)o=x-y==+g[u+292>>2];else o=0;if(o|h){S=31;break a}k=j-z;if(k<=j*9.999999974752427e-07){S=33;break a}g[u+292>>2]=x-y;g[u+296>>2]=m-l;g[u+300>>2]=v-w;g[u+304>>2]=0.0;a[u+356>>0]=1;g[u+(t<<4)+4>>2]=x-y;g[u+(t<<4)+8>>2]=m-l;g[u+(t<<4)+12>>2]=v-w;g[u+(t<<4)+16>>2]=0.0;o=c[u>>2]|0;g[u+(o<<4)+84>>2]=x;g[u+(o<<4)+88>>2]=m;g[u+(o<<4)+92>>2]=v;g[u+(o<<4)+96>>2]=0.0;o=c[u>>2]|0;g[u+(o<<4)+164>>2]=y;g[u+(o<<4)+168>>2]=l;g[u+(o<<4)+172>>2]=w;g[u+(o<<4)+176>>2]=0.0;c[u>>2]=(c[u>>2]|0)+1;o=c[b+24>>2]|0;u=qD(o)|0;k=+g[o+276>>2];m=+g[o+280>>2];l=+g[o+284>>2];n=+g[o+288>>2];if(!u){S=35;break a}p=j;j=k*k+m*m+l*l;if(j<9.999999974752427e-07){j=p;S=37;break a}if(p-j<=p*1.1920928955078125e-07){S=39;break a}g[b+4>>2]=k;g[b+8>>2]=m;g[b+12>>2]=l;g[b+16>>2]=n;u=c[b+64>>2]|0;c[b+64>>2]=u+1;if((u|0)>1e3){B=0.0;o=0;m=0.0;A=0.0;q=0.0;break a}if((c[c[b+24>>2]>>2]|0)==4){S=42;break}}}while(0);if((S|0)==22){c[b+68>>2]=10;S=43}else if((S|0)==31){c[b+68>>2]=1;S=43}else if((S|0)==33){c[b+68>>2]=!(k<=0.0)?11:2;S=43}else if((S|0)==35){c[b+68>>2]=3;S=43}else if((S|0)==37){g[b+4>>2]=k;g[b+8>>2]=m;g[b+12>>2]=l;g[b+16>>2]=n;c[b+68>>2]=6;S=43}else if((S|0)==39){c[b+68>>2]=12;S=43}else if((S|0)==42){c[b+68>>2]=13;B=0.0;o=0;m=0.0;A=0.0;q=0.0}do if((S|0)==43){u=c[b+24>>2]|0;qD(u)|0;m=+g[u+260>>2];k=+g[u+264>>2];q=+g[u+268>>2];c[N+272>>2]=c[b+4>>2];c[N+276>>2]=c[b+8>>2];c[N+280>>2]=c[b+12>>2];c[N+284>>2]=c[b+16>>2];n=+g[b+4>>2];l=+g[b+8>>2];p=+g[b+12>>2];if(n*n+l*l+p*p<.0001)c[b+68>>2]=5;if(n*n+l*l+p*p>1.4210854715202004e-14){B=1.0/+P(+(n*n+l*l+p*p));g[N+272>>2]=B*+g[N+272>>2];g[L>>2]=B*+g[L>>2];g[M>>2]=B*+g[M>>2];z=E/+P(+j);c[b+60>>2]=1;B=1.0/B-D;o=1;m=z*n+m;A=z*l+k;q=z*p+q;break}else{c[b+60>>2]=2;B=0.0;o=0;A=k;break}}while(0);if(((c[b+72>>2]|0)!=0?(c[b+20>>2]|0)!=0:0)?(c[b+68>>2]|0)!=0:0)h=D+B<.01;else h=0;u=o^1;do if(h|u?(C=c[b+20>>2]|0,(C|0)!=0):0){c[4844]=(c[4844]|0)+1;c[b+4>>2]=0;c[b+8>>2]=0;c[b+12>>2]=0;c[b+16>>2]=0;if(!(Mb[c[(c[C>>2]|0)+8>>2]&3](C,c[b+24>>2]|0,c[b+28>>2]|0,c[b+32>>2]|0,N+208|0,N+144|0,b+4|0,N+64|0,N+48|0,f)|0)){n=+g[b+4>>2];k=+g[b+8>>2];r=+g[b+12>>2];if(!(n*n+k*k+r*r>0.0)){S=66;break}l=+g[N+48>>2];y=+g[N+64>>2]-l;j=+g[N+52>>2];z=+g[N+68>>2]-j;s=+g[N+56>>2];p=+g[N+72>>2]-s;p=+P(+(y*y+z*z+p*p))-D;if(p<B|u){c[N+272>>2]=c[b+4>>2];c[N+276>>2]=c[b+8>>2];c[N+280>>2]=c[b+12>>2];c[N+284>>2]=c[b+16>>2];A=+g[N+272>>2];B=+g[L>>2];D=+g[M>>2];m=1.0/+P(+(A*A+B*B+D*D));g[N+272>>2]=A*m;g[L>>2]=B*m;g[M>>2]=D*m;c[b+60>>2]=6;m=E*n+l;k=E*k+j;j=E*r+s;break}c[b+60>>2]=5;if(o){p=B;k=A;j=q;break}i=N;return}z=+g[N+48>>2];n=+g[N+64>>2];k=+g[N+52>>2];l=+g[N+68>>2];j=+g[N+56>>2];r=+g[N+72>>2];if(!((z-n)*(z-n)+(k-l)*(k-l)+(j-r)*(j-r)<=1.4210854715202004e-14)){p=(z-n)*(z-n)+(k-l)*(k-l)+(j-r)*(j-r);v=z-n;w=j-r;x=0.0;y=k-l}else{v=+g[b+4>>2];y=+g[b+8>>2];w=+g[b+12>>2];p=v*v+y*y+w*w;x=+g[b+16>>2]}if(!(p>1.4210854715202004e-14)){c[b+60>>2]=9;if(o){p=B;k=A;j=q;break}i=N;return}s=1.0/+P(+p);p=-+P(+((n-z)*(n-z)+(l-k)*(l-k)+(r-j)*(r-j)));if(B>p|u){g[N+272>>2]=v*s;g[L>>2]=y*s;g[M>>2]=w*s;g[N+284>>2]=x;c[b+60>>2]=3;m=z;break}c[b+60>>2]=8;if(o){p=B;k=A;j=q}else{i=N;return}}else S=66;while(0);if((S|0)==66)if(o){p=B;k=A;j=q}else{i=N;return}if(!(p<0.0)?!(p*p<+g[d+128>>2]):0){i=N;return}if((c[b+76>>2]|0)!=0?(d=c[b+28>>2]|0,tc[c[(c[d>>2]|0)+8>>2]&127](d,N+208|0,N+32|0,N+16|0),B=(+g[N+16>>2]+ +g[N+32>>2])*.5,D=(+g[N+20>>2]+ +g[N+36>>2])*.5,E=(+g[N+24>>2]+ +g[N+40>>2])*.5,d=c[b+32>>2]|0,tc[c[(c[d>>2]|0)+8>>2]&127](d,N+144|0,N+32|0,N+16|0),O=+g[N+272>>2],Q=+g[L>>2],R=+g[M>>2],(B-(+g[N+32>>2]+ +g[N+16>>2])*.5)*O+(D-(+g[N+36>>2]+ +g[N+20>>2])*.5)*Q+(E-(+g[N+40>>2]+ +g[N+24>>2])*.5)*R<0.0):0){g[N+272>>2]=-O;g[L>>2]=-Q;g[M>>2]=-R};c[b+4>>2]=c[N+272>>2];c[b+8>>2]=c[N+276>>2];c[b+12>>2]=c[N+280>>2];c[b+16>>2]=c[N+284>>2];g[b+56>>2]=p;d=c[(c[e>>2]|0)+16>>2]|0;g[N>>2]=(F+G)*.5+m;g[N+4>>2]=(H+I)*.5+k;g[N+8>>2]=(J+K)*.5+j;g[N+12>>2]=0.0;oc[d&15](e,N+272|0,N,p);i=N;return}function fD(a){a=a|0;var b=0;b=i;RE(a);i=b;return}function gD(a){a=a|0;return}function hD(b,e,f){b=b|0;e=e|0;f=f|0;var h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0,p=0,q=0,r=0.0,s=0.0,t=0,u=0.0,v=0,w=0.0,x=0,y=0,z=0.0,A=0,B=0,C=0.0,D=0.0,E=0.0,F=0.0,G=0;B=i;i=i+176|0;c[b+348>>2]=b+220;c[b+352>>2]=b+252;c[b+356>>2]=b+284;c[b+360>>2]=b+316;c[b+364>>2]=4;c[b+368>>2]=0;c[b+376>>2]=0;x=c[e+4>>2]|0;c[b>>2]=c[e>>2];c[b+4>>2]=x;c[b+8>>2]=c[e+8>>2];c[b+12>>2]=c[e+12>>2];c[b+16>>2]=c[e+16>>2];c[b+20>>2]=c[e+20>>2];c[b+24>>2]=c[e+24>>2];c[b+28>>2]=c[e+28>>2];c[b+32>>2]=c[e+32>>2];c[b+36>>2]=c[e+36>>2];c[b+40>>2]=c[e+40>>2];c[b+44>>2]=c[e+44>>2];c[b+48>>2]=c[e+48>>2];c[b+52>>2]=c[e+52>>2];c[b+56>>2]=c[e+56>>2];c[b+60>>2]=c[e+60>>2];c[b+64>>2]=c[e+64>>2];c[b+68>>2]=c[e+68>>2];c[b+72>>2]=c[e+72>>2];c[b+76>>2]=c[e+76>>2];c[b+80>>2]=c[e+80>>2];c[b+84>>2]=c[e+84>>2];c[b+88>>2]=c[e+88>>2];c[b+92>>2]=c[e+92>>2];c[b+96>>2]=c[e+96>>2];c[b+100>>2]=c[e+100>>2];c[b+104>>2]=c[e+104>>2];c[b+108>>2]=c[e+108>>2];c[b+112>>2]=c[e+112>>2];c[b+116>>2]=c[e+116>>2];x=d[e+120>>0]|d[e+121>>0]<<8|d[e+122>>0]<<16|d[e+123>>0]<<24;y=d[e+124>>0]|d[e+125>>0]<<8|d[e+126>>0]<<16|d[e+127>>0]<<24;a[b+120>>0]=x;a[b+121>>0]=x>>8;a[b+122>>0]=x>>16;a[b+123>>0]=x>>24;a[b+124>>0]=y;a[b+125>>0]=y>>8;a[b+126>>0]=y>>16;a[b+127>>0]=y>>24;g[b+144>>2]=0.0;c[b+180>>2]=0;c[b+128>>2]=c[f+0>>2];c[b+132>>2]=c[f+4>>2];c[b+136>>2]=c[f+8>>2];c[b+140>>2]=c[f+12>>2];l=+g[b+128>>2];m=+g[b+132>>2];n=+g[b+136>>2];if(l*l+m*m+n*n>0.0){h=-l;j=-m;k=-n}else{h=1.0;j=0.0;k=0.0}g[b+164>>2]=0.0;c[b+364>>2]=3;c[b+148>>2]=b+316;c[b+180>>2]=1;jD(b,h,j,k,b+316|0);g[b+164>>2]=1.0;x=(c[b+148>>2]|0)+16|0;c[b+128>>2]=c[x+0>>2];c[b+132>>2]=c[x+4>>2];c[b+136>>2]=c[x+8>>2];c[b+140>>2]=c[x+12>>2];c[B+72>>2]=c[x+0>>2];c[B+76>>2]=c[x+4>>2];c[B+80>>2]=c[x+8>>2];c[B+84>>2]=c[x+12>>2];c[B+56>>2]=c[x+0>>2];c[B+60>>2]=c[x+4>>2];c[B+64>>2]=c[x+8>>2];c[B+68>>2]=c[x+12>>2];c[B+40>>2]=c[x+0>>2];c[B+44>>2]=c[x+4>>2];c[B+48>>2]=c[x+8>>2];c[B+52>>2]=c[x+12>>2];c[B+24>>2]=c[x+0>>2];c[B+28>>2]=c[x+4>>2];c[B+32>>2]=c[x+8>>2];c[B+36>>2]=c[x+12>>2];w=0.0;x=0;y=0;j=l*l+m*m+n*n;a:while(1){v=c[b+368>>2]|0;n=+g[b+128>>2];m=+g[b+132>>2];l=+g[b+136>>2];k=+P(+(n*n+m*m+l*l));if(k<9.999999747378752e-05){A=5;break}g[b+(v*36|0)+(c[b+(v*36|0)+180>>2]<<2)+164>>2]=0.0;q=(c[b+364>>2]|0)+-1|0;c[b+364>>2]=q;c[b+(v*36|0)+(c[b+(v*36|0)+180>>2]<<2)+148>>2]=c[b+(q<<2)+348>>2];q=c[b+(v*36|0)+180>>2]|0;c[b+(v*36|0)+180>>2]=q+1;jD(b,-n,-m,-l,c[b+(v*36|0)+(q<<2)+148>>2]|0);q=c[b+(v*36|0)+180>>2]|0;p=c[b+(v*36|0)+(q+-1<<2)+148>>2]|0;n=+g[p+16>>2];m=+g[p+20>>2];l=+g[p+24>>2];o=0;do{u=n-+g[B+24+(o<<4)>>2];r=m-+g[B+24+(o<<4)+4>>2];s=l-+g[B+24+(o<<4)+8>>2];o=o+1|0;if(u*u+r*r+s*s<9.999999747378752e-05){A=9;break a}}while(o>>>0<4);x=x+1&3;t=B+24+(x<<4)|0;c[t+0>>2]=c[p+16>>2];c[t+4>>2]=c[p+20>>2];c[t+8>>2]=c[p+24>>2];c[t+12>>2]=c[p+28>>2];s=(+g[b+128>>2]*n+ +g[b+132>>2]*m+ +g[b+136>>2]*l)/k;w=s>w?s:w;if(k-w-k*9.999999747378752e-05<=0.0){A=11;break}c[B>>2]=0;if((q|0)==2)n=+oD((c[b+(v*36|0)+148>>2]|0)+16|0,(c[b+(v*36|0)+152>>2]|0)+16|0,B+8|0,B);else if((q|0)==3)n=+nD((c[b+(v*36|0)+148>>2]|0)+16|0,(c[b+(v*36|0)+152>>2]|0)+16|0,(c[b+(v*36|0)+156>>2]|0)+16|0,B+8|0,B);else if((q|0)==4){o=c[b+(v*36|0)+148>>2]|0;e=c[b+(v*36|0)+152>>2]|0;f=c[b+(v*36|0)+156>>2]|0;t=c[b+(v*36|0)+160>>2]|0;c[B+152>>2]=o+16;c[B+156>>2]=e+16;c[B+160>>2]=f+16;c[B+164>>2]=t+16;l=+g[o+16>>2];k=+g[t+16>>2];n=+g[o+20>>2];j=+g[t+20>>2];m=+g[o+24>>2];h=+g[t+24>>2];g[B+104>>2]=l-k;g[B+108>>2]=n-j;g[B+112>>2]=m-h;g[B+116>>2]=0.0;C=+g[e+16>>2];E=+g[e+20>>2];s=+g[e+24>>2];g[B+120>>2]=C-k;g[B+124>>2]=E-j;g[B+128>>2]=s-h;g[B+132>>2]=0.0;r=+g[f+16>>2];F=+g[f+20>>2];D=+g[f+24>>2];g[B+136>>2]=r-k;g[B+140>>2]=F-j;g[B+144>>2]=D-h;g[B+148>>2]=0.0;u=(n-j)*(s-h)*(r-k)+(m-h)*(C-k)*(F-j)-(F-j)*((s-h)*(l-k))-(n-j)*(C-k)*(D-h)+(D-h)*((l-k)*(E-j))-(r-k)*((m-h)*(E-j));if(!(!(u*(m*((C-r)*(n-E)-(E-F)*(l-C))+(l*((E-F)*(m-s)-(s-D)*(n-E))+n*((s-D)*(l-C)-(C-r)*(m-s))))<=0.0)|(u!=u|0.0!=0.0|u==0.0))){c[B+92>>2]=0;c[B+96>>2]=0;c[B+100>>2]=0;c[B+88>>2]=0;s=n-j;r=m-h;m=l-k;q=0;n=-1.0;while(1){p=c[19520+(q<<2)>>2]|0;E=+g[B+104+(p<<4)+8>>2];F=+g[B+104+(p<<4)+4>>2];l=+g[B+104+(p<<4)>>2];if(u*((s*E-r*F)*k+j*(r*l-E*m)+(F*m-s*l)*h)>0.0?(z=+nD(c[B+152+(q<<2)>>2]|0,c[B+152+(p<<2)>>2]|0,t+16|0,B+92|0,B+88|0),n<0.0|z<n):0){G=c[B+88>>2]|0;c[B>>2]=((G&2|0)==0?0:1<<p)+(G<<1&8)+((G&1|0)==0?0:1<<q);g[B+8+(q<<2)>>2]=+g[B+92>>2];g[B+8+(p<<2)>>2]=+g[B+96>>2];g[B+8+(c[19520+(p<<2)>>2]<<2)>>2]=0.0;g[B+20>>2]=+g[B+100>>2];n=z}q=q+1|0;if((q|0)==3)break;s=+g[B+104+(q<<4)+4>>2];r=+g[B+104+(q<<4)+8>>2];m=+g[B+104+(q<<4)>>2];k=+g[t+16>>2];j=+g[t+20>>2];h=+g[t+24>>2]}if(n<0.0){c[B>>2]=15;n=+g[f+20>>2];D=+g[e+24>>2];r=+g[t+16>>2];F=+g[f+24>>2];C=+g[e+16>>2];h=+g[t+20>>2];k=+g[f+16>>2];l=+g[t+24>>2];E=+g[e+20>>2];g[B+8>>2]=(n*D*r+F*C*h-h*(D*k)-n*C*l+l*(k*E)-r*(F*E))/u;j=+g[o+20>>2];s=+g[o+24>>2];m=+g[o+16>>2];g[B+12>>2]=(j*F*r+s*k*h-h*(F*m)-j*k*l+l*(m*n)-r*(s*n))/u;g[B+16>>2]=(E*s*r+D*m*h-h*(s*C)-E*m*l+l*(C*j)-r*(D*j))/u;g[B+20>>2]=1.0-((E*s*r+D*m*h-h*(s*C)-E*m*l+l*(C*j)-r*(D*j))/u+((n*D*r+F*C*h-h*(D*k)-n*C*l+l*(k*E)-r*(F*E))/u+(j*F*r+s*k*h-h*(F*m)-j*k*l+l*(m*n)-r*(s*n))/u));n=0.0}}else n=-1.0}else n=j;if(!(n>=0.0)){A=32;break}c[b+((1-v|0)*36|0)+180>>2]=0;c[b+128>>2]=0;c[b+132>>2]=0;c[b+136>>2]=0;c[b+140>>2]=0;c[b+368>>2]=1-v;e=c[b+(v*36|0)+180>>2]|0;f=c[B>>2]|0;if(e){q=0;do{p=b+(v*36|0)+(q<<2)+148|0;o=c[p>>2]|0;if(!(f&1<<q)){t=c[b+364>>2]|0;c[b+364>>2]=t+1;c[b+(t<<2)+348>>2]=o}else{c[b+((1-v|0)*36|0)+(c[b+((1-v|0)*36|0)+180>>2]<<2)+148>>2]=o;m=+g[B+8+(q<<2)>>2];t=c[b+((1-v|0)*36|0)+180>>2]|0;c[b+((1-v|0)*36|0)+180>>2]=t+1;g[b+((1-v|0)*36|0)+(t<<2)+164>>2]=m;t=c[p>>2]|0;r=m*+g[t+20>>2];s=m*+g[t+24>>2];g[b+128>>2]=+g[t+16>>2]*m+ +g[b+128>>2];g[b+132>>2]=r+ +g[b+132>>2];g[b+136>>2]=s+ +g[b+136>>2]}q=q+1|0}while((q|0)!=(e|0))}if((f|0)==15)c[b+376>>2]=1;y=y+1|0;if(y>>>0>=128){A=34;break}if(c[b+376>>2]|0)break;else j=n}if((A|0)==5)c[b+376>>2]=1;else if((A|0)==9){y=c[b+368>>2]|0;x=(c[b+(y*36|0)+180>>2]|0)+-1|0;c[b+(y*36|0)+180>>2]=x;x=c[b+(y*36|0)+(x<<2)+148>>2]|0;y=c[b+364>>2]|0;c[b+364>>2]=y+1;c[b+(y<<2)+348>>2]=x}else if((A|0)==11){y=c[b+368>>2]|0;x=(c[b+(y*36|0)+180>>2]|0)+-1|0;c[b+(y*36|0)+180>>2]=x;x=c[b+(y*36|0)+(x<<2)+148>>2]|0;y=c[b+364>>2]|0;c[b+364>>2]=y+1;c[b+(y<<2)+348>>2]=x}else if((A|0)==32){y=c[b+368>>2]|0;x=(c[b+(y*36|0)+180>>2]|0)+-1|0;c[b+(y*36|0)+180>>2]=x;x=c[b+(y*36|0)+(x<<2)+148>>2]|0;y=c[b+364>>2]|0;c[b+364>>2]=y+1;c[b+(y<<2)+348>>2]=x}else if((A|0)==34)c[b+376>>2]=2;c[b+372>>2]=b+((c[b+368>>2]|0)*36|0)+148;f=c[b+376>>2]|0;if((f|0)==1){g[b+144>>2]=0.0;i=B;return f|0}else if(!f){n=+g[b+128>>2];r=+g[b+132>>2];s=+g[b+136>>2];g[b+144>>2]=+P(+(n*n+r*r+s*s));i=B;return f|0}else{i=B;return f|0}return 0}function iD(b,e,f,h,j,k){b=b|0;e=e|0;f=f|0;h=h|0;j=j|0;k=k|0;var l=0,m=0,n=0;n=i;if((d[h+55>>0]|0|0)==(e|0)){l=0;i=n;return l|0}l=c[19520+(j<<2)>>2]|0;if(+g[h>>2]*+g[f+16>>2]+ +g[h+4>>2]*+g[f+20>>2]+ +g[h+8>>2]*+g[f+24>>2]-+g[h+16>>2]<-9.999999747378752e-06){m=kD(b,c[h+(l<<2)+20>>2]|0,c[h+(j<<2)+20>>2]|0,f,0)|0;if(!m){l=0;i=n;return l|0}a[m+52>>0]=j;c[m+32>>2]=h;a[h+j+52>>0]=0;c[h+(j<<2)+32>>2]=m;l=c[k>>2]|0;if(!l)c[k+4>>2]=m;else{a[l+53>>0]=2;c[l+36>>2]=m;a[m+54>>0]=1;c[m+40>>2]=l}c[k>>2]=m;c[k+8>>2]=(c[k+8>>2]|0)+1;l=1;i=n;return l|0}m=c[19504+(j<<2)>>2]|0;a[h+55>>0]=e;if(!(iD(b,e,f,c[h+(l<<2)+32>>2]|0,d[h+l+52>>0]|0,k)|0)){l=0;i=n;return l|0}if(!(iD(b,e,f,c[h+(m<<2)+32>>2]|0,d[h+m+52>>0]|0,k)|0)){l=0;i=n;return l|0}l=c[h+48>>2]|0;if(l)c[l+44>>2]=c[h+44>>2];l=c[h+44>>2]|0;if(l)c[l+48>>2]=c[h+48>>2];if((c[b+9280>>2]|0)==(h|0))c[b+9280>>2]=c[h+48>>2];c[b+9284>>2]=(c[b+9284>>2]|0)+-1;c[h+44>>2]=0;c[h+48>>2]=c[b+9288>>2];l=c[b+9288>>2]|0;if(l)c[l+44>>2]=h;c[b+9288>>2]=h;c[b+9292>>2]=(c[b+9292>>2]|0)+1;l=1;i=n;return l|0}function jD(a,b,e,f,h){a=a|0;b=+b;e=+e;f=+f;h=h|0;var j=0,k=0,l=0,m=0,n=0.0,o=0.0;l=i;i=i+48|0;n=1.0/+P(+(b*b+e*e+f*f));g[h>>2]=n*b;g[h+4>>2]=n*e;g[h+8>>2]=n*f;g[h+12>>2]=0.0;j=d[a+120>>0]|d[a+121>>0]<<8|d[a+122>>0]<<16|d[a+123>>0]<<24;m=d[a+124>>0]|d[a+125>>0]<<8|d[a+126>>0]<<16|d[a+127>>0]<<24;k=(c[a>>2]|0)+(m>>1)|0;if(m&1)j=c[(c[k>>2]|0)+j>>2]|0;pc[j&127](l,k,h);f=-+g[h>>2];e=-+g[h+4>>2];b=-+g[h+8>>2];k=d[a+120>>0]|d[a+121>>0]<<8|d[a+122>>0]<<16|d[a+123>>0]<<24;m=d[a+124>>0]|d[a+125>>0]<<8|d[a+126>>0]<<16|d[a+127>>0]<<24;j=(c[a+4>>2]|0)+(m>>1)|0;if(m&1)k=c[(c[j>>2]|0)+k>>2]|0;n=+g[a+24>>2]*f+ +g[a+28>>2]*e+ +g[a+32>>2]*b;o=+g[a+40>>2]*f+ +g[a+44>>2]*e+ +g[a+48>>2]*b;g[l+16>>2]=+g[a+8>>2]*f+ +g[a+12>>2]*e+ +g[a+16>>2]*b;g[l+20>>2]=n;g[l+24>>2]=o;g[l+28>>2]=0.0;pc[k&127](l+32|0,j,l+16|0);o=+g[l+32>>2];n=+g[l+36>>2];f=+g[l+40>>2];e=+g[l+4>>2]-(o*+g[a+72>>2]+n*+g[a+76>>2]+f*+g[a+80>>2]+ +g[a+108>>2]);b=+g[l+8>>2]-(o*+g[a+88>>2]+n*+g[a+92>>2]+f*+g[a+96>>2]+ +g[a+112>>2]);g[h+16>>2]=+g[l>>2]-(o*+g[a+56>>2]+n*+g[a+60>>2]+f*+g[a+64>>2]+ +g[a+104>>2]);g[h+20>>2]=e;g[h+24>>2]=b;g[h+28>>2]=0.0;i=l;return}function kD(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var j=0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0,s=0;s=i;r=c[b+9288>>2]|0;if(!r){c[b>>2]=5;j=0;i=s;return j|0}j=c[r+48>>2]|0;if(j)c[j+44>>2]=c[r+44>>2];j=c[r+44>>2]|0;if(j)c[j+48>>2]=c[r+48>>2];if((c[b+9288>>2]|0)==(r|0))c[b+9288>>2]=c[r+48>>2];c[b+9292>>2]=(c[b+9292>>2]|0)+-1;c[r+44>>2]=0;c[r+48>>2]=c[b+9280>>2];j=c[b+9280>>2]|0;if(j)c[j+44>>2]=r;c[b+9280>>2]=r;c[b+9284>>2]=(c[b+9284>>2]|0)+1;a[r+55>>0]=0;c[r+20>>2]=d;c[r+24>>2]=e;c[r+28>>2]=f;m=+g[d+16>>2];l=+g[e+16>>2]-m;q=+g[d+20>>2];p=+g[e+20>>2]-q;o=+g[d+24>>2];n=+g[e+24>>2]-o;m=+g[f+16>>2]-m;q=+g[f+20>>2]-q;o=+g[f+24>>2]-o;g[r>>2]=p*o-n*q;g[r+4>>2]=n*m-l*o;g[r+8>>2]=l*q-p*m;g[r+12>>2]=0.0;k=+P(+((p*o-n*q)*(p*o-n*q)+(n*m-l*o)*(n*m-l*o)+(l*q-p*m)*(l*q-p*m)));do if(k>9.999999747378752e-05){if((!(lD(p*o-n*q,n*m-l*o,l*q-p*m,+g[d+16>>2],+g[d+20>>2],+g[d+24>>2],+g[e+16>>2],+g[e+20>>2],+g[e+24>>2],r+16|0)|0)?!(lD(+g[r>>2],+g[r+4>>2],+g[r+8>>2],+g[e+16>>2],+g[e+20>>2],+g[e+24>>2],+g[f+16>>2],+g[f+20>>2],+g[f+24>>2],r+16|0)|0):0)?!(lD(+g[r>>2],+g[r+4>>2],+g[r+8>>2],+g[f+16>>2],+g[f+20>>2],+g[f+24>>2],+g[d+16>>2],+g[d+20>>2],+g[d+24>>2],r+16|0)|0):0)g[r+16>>2]=(+g[d+16>>2]*+g[r>>2]+ +g[d+20>>2]*+g[r+4>>2]+ +g[d+24>>2]*+g[r+8>>2])/k;g[r>>2]=1.0/k*+g[r>>2];g[r+4>>2]=1.0/k*+g[r+4>>2];g[r+8>>2]=1.0/k*+g[r+8>>2];if(h){j=r;i=s;return j|0}if(!(+g[r+16>>2]>=-9.999999747378752e-06)){c[b>>2]=3;break}else{j=r;i=s;return j|0}}else c[b>>2]=2;while(0);j=c[r+48>>2]|0;if(j)c[j+44>>2]=c[r+44>>2];j=c[r+44>>2]|0;if(j)c[j+48>>2]=c[r+48>>2];if((c[b+9280>>2]|0)==(r|0))c[b+9280>>2]=c[r+48>>2];c[b+9284>>2]=(c[b+9284>>2]|0)+-1;c[r+44>>2]=0;c[r+48>>2]=c[b+9288>>2];j=c[b+9288>>2]|0;if(j)c[j+44>>2]=r;c[b+9288>>2]=r;c[b+9292>>2]=(c[b+9292>>2]|0)+1;j=0;i=s;return j|0}function lD(a,b,c,d,e,f,h,j,k,l){a=+a;b=+b;c=+c;d=+d;e=+e;f=+f;h=+h;j=+j;k=+k;l=l|0;var m=0;m=i;if(!(((h-d)*b-(j-e)*a)*f+(((j-e)*c-(k-f)*b)*d+((k-f)*a-(h-d)*c)*e)<0.0)){l=0;i=m;return l|0}if((h-d)*d+(j-e)*e+(k-f)*f>0.0){g[l>>2]=+P(+(d*d+e*e+f*f));l=1;i=m;return l|0}if((h-d)*h+(j-e)*j+(k-f)*k<0.0){g[l>>2]=+P(+(h*h+j*j+k*k));l=1;i=m;return l|0}else{d=((h*h+j*j+k*k)*(d*d+e*e+f*f)-(h*d+j*e+k*f)*(h*d+j*e+k*f))/((h-d)*(h-d)+(j-e)*(j-e)+(k-f)*(k-f));g[l>>2]=+P(+(d>0.0?d:0.0));l=1;i=m;return l|0}return 0}function mD(a){a=a|0;var b=0,d=0,e=0.0,f=0.0,h=0.0,j=0,k=0.0,l=0.0,m=0.0,n=0,o=0.0,p=0.0,q=0.0,r=0;n=i;i=i+32|0;j=c[a+372>>2]|0;d=c[j+32>>2]|0;a:do if((d|0)==4){b=c[j>>2]|0;d=c[j+12>>2]|0;e=+g[d+16>>2];q=+g[b+16>>2]-e;o=+g[d+20>>2];m=+g[b+20>>2]-o;k=+g[d+24>>2];h=+g[b+24>>2]-k;b=c[j+4>>2]|0;l=+g[b+16>>2]-e;f=+g[b+20>>2]-o;p=+g[b+24>>2]-k;b=c[j+8>>2]|0;e=+g[b+16>>2]-e;o=+g[b+20>>2]-o;k=+g[b+24>>2]-k;if(!((0.0!=0.0?1:q*f*k+(m*p*e+h*l*o-q*p*o-m*l*k)-h*f*e!=q*f*k+(m*p*e+h*l*o-q*p*o-m*l*k)-h*f*e)|q*f*k+(m*p*e+h*l*o-q*p*o-m*l*k)-h*f*e==0.0)){b=1;i=n;return b|0}}else if((d|0)==1){b=1;d=0;while(1){c[n+16>>2]=0;c[n+20>>2]=0;c[n+24>>2]=0;c[n+28>>2]=0;g[n+16+(d<<2)>>2]=1.0;r=j+32|0;g[j+(b<<2)+16>>2]=0.0;b=(c[a+364>>2]|0)+-1|0;c[a+364>>2]=b;c[j+(c[r>>2]<<2)>>2]=c[a+(b<<2)+348>>2];b=c[r>>2]|0;c[r>>2]=b+1;e=+g[n+16>>2];f=+g[n+20>>2];h=+g[n+24>>2];jD(a,e,f,h,c[j+(b<<2)>>2]|0);if(mD(a)|0){b=1;d=19;break}j=c[a+372>>2]|0;b=(c[j+32>>2]|0)+-1|0;c[j+32>>2]=b;b=c[j+(b<<2)>>2]|0;j=c[a+364>>2]|0;c[a+364>>2]=j+1;c[a+(j<<2)+348>>2]=b;j=c[a+372>>2]|0;g[j+(c[j+32>>2]<<2)+16>>2]=0.0;b=(c[a+364>>2]|0)+-1|0;c[a+364>>2]=b;c[j+(c[j+32>>2]<<2)>>2]=c[a+(b<<2)+348>>2];b=c[j+32>>2]|0;c[j+32>>2]=b+1;jD(a,-e,-f,-h,c[j+(b<<2)>>2]|0);if(mD(a)|0){b=1;d=19;break}b=c[a+372>>2]|0;j=(c[b+32>>2]|0)+-1|0;c[b+32>>2]=j;j=c[b+(j<<2)>>2]|0;b=c[a+364>>2]|0;c[a+364>>2]=b+1;c[a+(b<<2)+348>>2]=j;d=d+1|0;if(d>>>0>=3)break a;b=c[a+372>>2]|0;j=b;b=c[b+32>>2]|0}if((d|0)==19){i=n;return b|0}}else if((d|0)==3){b=c[j+4>>2]|0;d=c[j>>2]|0;h=+g[d+16>>2];f=+g[b+16>>2]-h;e=+g[d+20>>2];m=+g[b+20>>2]-e;l=+g[d+24>>2];k=+g[b+24>>2]-l;b=c[j+8>>2]|0;h=+g[b+16>>2]-h;e=+g[b+20>>2]-e;l=+g[b+24>>2]-l;if((m*l-k*e)*(m*l-k*e)+(k*h-f*l)*(k*h-f*l)+(f*e-m*h)*(f*e-m*h)>0.0){g[j+28>>2]=0.0;b=(c[a+364>>2]|0)+-1|0;c[a+364>>2]=b;c[j+12>>2]=c[a+(b<<2)+348>>2];b=c[j+32>>2]|0;c[j+32>>2]=b+1;jD(a,m*l-k*e,k*h-f*l,f*e-m*h,c[j+(b<<2)>>2]|0);if(mD(a)|0){b=1;i=n;return b|0}d=c[a+372>>2]|0;b=(c[d+32>>2]|0)+-1|0;c[d+32>>2]=b;b=c[d+(b<<2)>>2]|0;d=c[a+364>>2]|0;c[a+364>>2]=d+1;c[a+(d<<2)+348>>2]=b;d=c[a+372>>2]|0;g[d+(c[d+32>>2]<<2)+16>>2]=0.0;b=(c[a+364>>2]|0)+-1|0;c[a+364>>2]=b;c[d+(c[d+32>>2]<<2)>>2]=c[a+(b<<2)+348>>2];b=c[d+32>>2]|0;c[d+32>>2]=b+1;jD(a,-(m*l-k*e),-(k*h-f*l),-(f*e-m*h),c[d+(b<<2)>>2]|0);if(mD(a)|0){b=1;i=n;return b|0}else{b=c[a+372>>2]|0;d=(c[b+32>>2]|0)+-1|0;c[b+32>>2]=d;d=c[b+(d<<2)>>2]|0;b=c[a+364>>2]|0;c[a+364>>2]=b+1;c[a+(b<<2)+348>>2]=d;break}}}else if((d|0)==2){b=c[j+4>>2]|0;j=c[j>>2]|0;k=+g[b+16>>2]-+g[j+16>>2];m=+g[b+20>>2]-+g[j+20>>2];l=+g[b+24>>2]-+g[j+24>>2];j=0;while(1){c[n+0>>2]=0;c[n+4>>2]=0;c[n+8>>2]=0;c[n+12>>2]=0;g[n+(j<<2)>>2]=1.0;h=+g[n+8>>2];f=+g[n+4>>2];e=+g[n>>2];if((m*h-l*f)*(m*h-l*f)+(l*e-k*h)*(l*e-k*h)+(k*f-m*e)*(k*f-m*e)>0.0){d=c[a+372>>2]|0;g[d+(c[d+32>>2]<<2)+16>>2]=0.0;b=(c[a+364>>2]|0)+-1|0;c[a+364>>2]=b;c[d+(c[d+32>>2]<<2)>>2]=c[a+(b<<2)+348>>2];b=c[d+32>>2]|0;c[d+32>>2]=b+1;jD(a,m*h-l*f,l*e-k*h,k*f-m*e,c[d+(b<<2)>>2]|0);if(mD(a)|0){b=1;d=19;break}d=c[a+372>>2]|0;b=(c[d+32>>2]|0)+-1|0;c[d+32>>2]=b;b=c[d+(b<<2)>>2]|0;d=c[a+364>>2]|0;c[a+364>>2]=d+1;c[a+(d<<2)+348>>2]=b;d=c[a+372>>2]|0;g[d+(c[d+32>>2]<<2)+16>>2]=0.0;b=(c[a+364>>2]|0)+-1|0;c[a+364>>2]=b;c[d+(c[d+32>>2]<<2)>>2]=c[a+(b<<2)+348>>2];b=c[d+32>>2]|0;c[d+32>>2]=b+1;jD(a,-(m*h-l*f),-(l*e-k*h),-(k*f-m*e),c[d+(b<<2)>>2]|0);if(mD(a)|0){b=1;d=19;break}b=c[a+372>>2]|0;d=(c[b+32>>2]|0)+-1|0;c[b+32>>2]=d;d=c[b+(d<<2)>>2]|0;b=c[a+364>>2]|0;c[a+364>>2]=b+1;c[a+(b<<2)+348>>2]=d}j=j+1|0;if(j>>>0>=3)break a}if((d|0)==19){i=n;return b|0}}while(0);b=0;i=n;return b|0}function nD(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var h=0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0,t=0.0,u=0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0;F=i;i=i+80|0;c[F+64>>2]=a;c[F+68>>2]=b;c[F+72>>2]=d;k=+g[a>>2];l=+g[b>>2];t=+g[a+4>>2];v=+g[b+4>>2];w=+g[a+8>>2];x=+g[b+8>>2];g[F+16>>2]=k-l;g[F+20>>2]=t-v;g[F+24>>2]=w-x;g[F+28>>2]=0.0;y=+g[d>>2];z=+g[d+4>>2];A=+g[d+8>>2];g[F+32>>2]=l-y;g[F+36>>2]=v-z;g[F+40>>2]=x-A;g[F+44>>2]=0.0;g[F+48>>2]=y-k;g[F+52>>2]=z-t;g[F+56>>2]=A-w;g[F+60>>2]=0.0;C=(t-v)*(x-A)-(w-x)*(v-z);D=(w-x)*(l-y)-(x-A)*(k-l);E=(v-z)*(k-l)-(t-v)*(l-y);if(!(E*E+(C*C+D*D)>0.0)){t=-1.0;i=F;return +t}c[F>>2]=0;c[F+4>>2]=0;c[F+8>>2]=0;m=t-v;n=w-x;o=k-l;p=k;q=t;r=w;u=a;h=0;j=-1.0;while(1){if(p*(E*m-D*n)+q*(C*n-E*o)+(D*o-C*m)*r>0.0?(s=c[19520+(h<<2)>>2]|0,B=+oD(u,c[F+64+(s<<2)>>2]|0,F,F+8|0),j<0.0|B<j):0){u=c[F+8>>2]|0;c[f>>2]=((u&1|0)==0?0:1<<h)+((u&2|0)==0?0:1<<s);g[e+(h<<2)>>2]=+g[F>>2];g[e+(s<<2)>>2]=+g[F+4>>2];g[e+(c[19520+(s<<2)>>2]<<2)>>2]=0.0;j=B}h=h+1|0;if((h|0)==3)break;u=c[F+64+(h<<2)>>2]|0;m=+g[F+16+(h<<4)+4>>2];n=+g[F+16+(h<<4)+8>>2];o=+g[F+16+(h<<4)>>2];p=+g[u>>2];q=+g[u+4>>2];r=+g[u+8>>2]}if(!(j<0.0)){t=j;i=F;return +t}p=+P(+(E*E+(C*C+D*D)));r=(C*+g[a>>2]+D*+g[a+4>>2]+E*+g[a+8>>2])/(E*E+(C*C+D*D));c[f>>2]=7;n=+g[b>>2]-C*r;m=+g[b+4>>2]-D*r;q=+g[b+8>>2]-E*r;q=+P(+((m*(l-y)-n*(v-z))*(m*(l-y)-n*(v-z))+(((v-z)*q-m*(x-A))*((v-z)*q-m*(x-A))+(n*(x-A)-q*(l-y))*(n*(x-A)-q*(l-y)))))/p;g[e>>2]=q;n=+g[d>>2]-C*r;m=+g[d+4>>2]-D*r;o=+g[d+8>>2]-E*r;t=+P(+((m*(y-k)-n*(z-t))*(m*(y-k)-n*(z-t))+(((z-t)*o-m*(A-w))*((z-t)*o-m*(A-w))+(n*(A-w)-o*(y-k))*(n*(A-w)-o*(y-k)))))/p;g[e+4>>2]=t;g[e+8>>2]=1.0-(t+q);t=E*r*(E*r)+(C*r*(C*r)+D*r*(D*r));i=F;return +t}function oD(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0.0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0;n=i;f=+g[a>>2];k=+g[b>>2]-f;h=+g[a+4>>2];m=+g[b+4>>2]-h;j=+g[a+8>>2];l=+g[b+8>>2]-j;if(!(k*k+m*m+l*l>0.0)){f=-1.0;i=n;return +f}f=-(f*k+h*m+j*l)/(k*k+m*m+l*l);if(f>=1.0){g[d>>2]=0.0;g[d+4>>2]=1.0;c[e>>2]=2;j=+g[b>>2];h=+g[b+4>>2];f=+g[b+8>>2];f=j*j+h*h+f*f;i=n;return +f}if(!(f<=0.0)){g[d+4>>2]=f;g[d>>2]=1.0-f;c[e>>2]=3;j=k*f+ +g[a>>2];h=m*f+ +g[a+4>>2];f=l*f+ +g[a+8>>2];f=j*j+h*h+f*f;i=n;return +f}else{g[d>>2]=1.0;g[d+4>>2]=0.0;c[e>>2]=1;j=+g[a>>2];h=+g[a+4>>2];f=+g[a+8>>2];f=j*j+h*h+f*f;i=n;return +f}return 0.0}function pD(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0;h=i;e=c[b>>2]|0;if((e|0)>3){f=a[d>>0]|0;if(!(f&8)){c[b>>2]=e+-1;g=b+(e+-1<<4)+4|0;c[b+52>>2]=c[g+0>>2];c[b+56>>2]=c[g+4>>2];c[b+60>>2]=c[g+8>>2];c[b+64>>2]=c[g+12>>2];g=b+(e+-1<<4)+84|0;c[b+132>>2]=c[g+0>>2];c[b+136>>2]=c[g+4>>2];c[b+140>>2]=c[g+8>>2];c[b+144>>2]=c[g+12>>2];g=b+(e+-1<<4)+164|0;c[b+212>>2]=c[g+0>>2];c[b+216>>2]=c[g+4>>2];c[b+220>>2]=c[g+8>>2];c[b+224>>2]=c[g+12>>2];e=e+-1|0;g=4}else g=6}else g=4;if((g|0)==4)if((e|0)>2){f=a[d>>0]|0;g=6}if((g|0)==6)if(!(f&4)){e=e+-1|0;c[b>>2]=e;c[b+36>>2]=c[b+(e<<4)+4>>2];c[b+40>>2]=c[b+(e<<4)+8>>2];c[b+44>>2]=c[b+(e<<4)+12>>2];c[b+48>>2]=c[b+(e<<4)+16>>2];c[b+116>>2]=c[b+(e<<4)+84>>2];c[b+120>>2]=c[b+(e<<4)+88>>2];c[b+124>>2]=c[b+(e<<4)+92>>2];c[b+128>>2]=c[b+(e<<4)+96>>2];c[b+196>>2]=c[b+(e<<4)+164>>2];c[b+200>>2]=c[b+(e<<4)+168>>2];c[b+204>>2]=c[b+(e<<4)+172>>2];c[b+208>>2]=c[b+(e<<4)+176>>2]}if((e|0)>1){f=a[d>>0]|0;if(!(f&2)){e=e+-1|0;c[b>>2]=e;c[b+20>>2]=c[b+(e<<4)+4>>2];c[b+24>>2]=c[b+(e<<4)+8>>2];c[b+28>>2]=c[b+(e<<4)+12>>2];c[b+32>>2]=c[b+(e<<4)+16>>2];c[b+100>>2]=c[b+(e<<4)+84>>2];c[b+104>>2]=c[b+(e<<4)+88>>2];c[b+108>>2]=c[b+(e<<4)+92>>2];c[b+112>>2]=c[b+(e<<4)+96>>2];c[b+180>>2]=c[b+(e<<4)+164>>2];c[b+184>>2]=c[b+(e<<4)+168>>2];c[b+188>>2]=c[b+(e<<4)+172>>2];c[b+192>>2]=c[b+(e<<4)+176>>2];g=11}}else g=11;do if((g|0)==11)if((e|0)>0){f=a[d>>0]|0;break}else{i=h;return}while(0);if(f&1){i=h;return}e=e+-1|0;c[b>>2]=e;c[b+4>>2]=c[b+(e<<4)+4>>2];c[b+8>>2]=c[b+(e<<4)+8>>2];c[b+12>>2]=c[b+(e<<4)+12>>2];c[b+16>>2]=c[b+(e<<4)+16>>2];c[b+84>>2]=c[b+(e<<4)+84>>2];c[b+88>>2]=c[b+(e<<4)+88>>2];c[b+92>>2]=c[b+(e<<4)+92>>2];c[b+96>>2]=c[b+(e<<4)+96>>2];c[b+164>>2]=c[b+(e<<4)+164>>2];c[b+168>>2]=c[b+(e<<4)+168>>2];c[b+172>>2]=c[b+(e<<4)+172>>2];c[b+176>>2]=c[b+(e<<4)+176>>2];i=h;return}function qD(b){b=b|0;var d=0,e=0.0,f=0.0,h=0.0,j=0.0,k=0.0,l=0.0,m=0,n=0,o=0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0,x=0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,N=0.0,O=0.0,P=0.0,Q=0,R=0.0,S=0.0,T=0.0,U=0;U=i;i=i+80|0;if(!(a[b+356>>0]|0)){d=a[b+312>>0]|0;d=d<<24>>24!=0;i=U;return d|0}c[b+336>>2]=0;c[b+340>>2]=0;c[b+344>>2]=0;c[b+348>>2]=0;a[b+352>>0]=0;d=a[b+332>>0]|0;a[b+332>>0]=d&-16;a[b+356>>0]=0;switch(c[b>>2]|0){case 2:{h=+g[b+4>>2];e=+g[b+8>>2];f=+g[b+12>>2];j=+g[b+20>>2]-h;l=+g[b+24>>2]-e;k=+g[b+28>>2]-f;do if((0.0-h)*j+(0.0-e)*l+(0.0-f)*k>0.0)if((0.0-h)*j+(0.0-e)*l+(0.0-f)*k<j*j+l*l+k*k){a[b+332>>0]=d&-16|3;e=((0.0-h)*j+(0.0-e)*l+(0.0-f)*k)/(j*j+l*l+k*k);break}else{a[b+332>>0]=d&-16|2;e=1.0;break}else{a[b+332>>0]=d&-16|1;e=0.0}while(0);g[b+336>>2]=1.0-e;g[b+340>>2]=e;g[b+344>>2]=0.0;g[b+348>>2]=0.0;v=+g[b+84>>2];z=+g[b+88>>2];B=+g[b+92>>2];v=v+e*(+g[b+100>>2]-v);z=z+e*(+g[b+104>>2]-z);B=B+e*(+g[b+108>>2]-B);g[b+244>>2]=v;g[b+248>>2]=z;g[b+252>>2]=B;g[b+256>>2]=0.0;y=+g[b+164>>2];A=+g[b+168>>2];C=+g[b+172>>2];y=y+e*(+g[b+180>>2]-y);A=A+e*(+g[b+184>>2]-A);C=C+e*(+g[b+188>>2]-C);g[b+260>>2]=y;g[b+264>>2]=A;g[b+268>>2]=C;g[b+272>>2]=0.0;g[b+276>>2]=v-y;g[b+280>>2]=z-A;g[b+284>>2]=B-C;g[b+288>>2]=0.0;pD(b,b+332|0);if((+g[b+336>>2]>=0.0?+g[b+340>>2]>=0.0:0)?+g[b+344>>2]>=0.0:0)d=+g[b+348>>2]>=0.0&1;else d=0;a[b+312>>0]=d;d=d<<24>>24!=0;i=U;return d|0}case 1:{c[b+244>>2]=c[b+84>>2];c[b+248>>2]=c[b+88>>2];c[b+252>>2]=c[b+92>>2];c[b+256>>2]=c[b+96>>2];c[b+260>>2]=c[b+164>>2];c[b+264>>2]=c[b+168>>2];c[b+268>>2]=c[b+172>>2];c[b+272>>2]=c[b+176>>2];B=+g[b+248>>2]-+g[b+264>>2];C=+g[b+252>>2]-+g[b+268>>2];g[b+276>>2]=+g[b+244>>2]-+g[b+260>>2];g[b+280>>2]=B;g[b+284>>2]=C;g[b+288>>2]=0.0;c[b+336>>2]=0;c[b+340>>2]=0;c[b+344>>2]=0;c[b+348>>2]=0;a[b+352>>0]=0;a[b+332>>0]=d&-16;g[b+336>>2]=1.0;g[b+340>>2]=0.0;g[b+344>>2]=0.0;g[b+348>>2]=0.0;a[b+312>>0]=1;d=1;d=d<<24>>24!=0;i=U;return d|0}case 3:{c[U+16>>2]=0;c[U+20>>2]=0;c[U+24>>2]=0;c[U+28>>2]=0;rD(U+16|0,b+4|0,b+20|0,b+36|0,b+316|0);t=+g[b+336>>2];u=+g[b+340>>2];C=+g[b+344>>2];v=+g[b+84>>2]*t+ +g[b+100>>2]*u+ +g[b+116>>2]*C;z=t*+g[b+88>>2]+u*+g[b+104>>2]+C*+g[b+120>>2];B=t*+g[b+92>>2]+u*+g[b+108>>2]+C*+g[b+124>>2];g[b+244>>2]=v;g[b+248>>2]=z;g[b+252>>2]=B;g[b+256>>2]=0.0;y=+g[b+164>>2]*t+ +g[b+180>>2]*u+ +g[b+196>>2]*C;A=t*+g[b+168>>2]+u*+g[b+184>>2]+C*+g[b+200>>2];C=t*+g[b+172>>2]+u*+g[b+188>>2]+C*+g[b+204>>2];g[b+260>>2]=y;g[b+264>>2]=A;g[b+268>>2]=C;g[b+272>>2]=0.0;g[b+276>>2]=v-y;g[b+280>>2]=z-A;g[b+284>>2]=B-C;g[b+288>>2]=0.0;pD(b,b+332|0);if((+g[b+336>>2]>=0.0?+g[b+340>>2]>=0.0:0)?+g[b+344>>2]>=0.0:0)d=+g[b+348>>2]>=0.0&1;else d=0;a[b+312>>0]=d;d=d<<24>>24!=0;i=U;return d|0}case 0:{a[b+312>>0]=0;d=0;d=d<<24>>24!=0;i=U;return d|0}case 4:{c[U+0>>2]=0;c[U+4>>2]=0;c[U+8>>2]=0;c[U+12>>2]=0;Q=U+48|0;a[Q>>0]=0;c[b+316>>2]=c[U+0>>2];c[b+320>>2]=c[U+4>>2];c[b+324>>2]=c[U+8>>2];c[b+328>>2]=c[U+12>>2];a[b+332>>0]=d|15;f=+g[b+20>>2];k=+g[b+4>>2];e=+g[b+24>>2];j=+g[b+8>>2];p=+g[b+28>>2];h=+g[b+12>>2];q=+g[b+36>>2];r=+g[b+40>>2];s=+g[b+44>>2];t=+g[b+52>>2];u=+g[b+56>>2];v=+g[b+60>>2];l=(t-k)*((e-j)*(s-h)-(p-h)*(r-j))+(u-j)*((p-h)*(q-k)-(f-k)*(s-h))+((f-k)*(r-j)-(e-j)*(q-k))*(v-h);if(l*l<9.99999905104687e-09)x=-1;else x=l*(((e-j)*(s-h)-(p-h)*(r-j))*(0.0-k)+((p-h)*(q-k)-(f-k)*(s-h))*(0.0-j)+((f-k)*(r-j)-(e-j)*(q-k))*(0.0-h))<0.0&1;l=(f-k)*((r-j)*(v-h)-(s-h)*(u-j))+(e-j)*((s-h)*(t-k)-(q-k)*(v-h))+((q-k)*(u-j)-(r-j)*(t-k))*(p-h);if(l*l<9.99999905104687e-09)o=-1;else o=l*(((r-j)*(v-h)-(s-h)*(u-j))*(0.0-k)+((s-h)*(t-k)-(q-k)*(v-h))*(0.0-j)+((q-k)*(u-j)-(r-j)*(t-k))*(0.0-h))<0.0&1;l=(q-k)*((u-j)*(p-h)-(v-h)*(e-j))+(r-j)*((v-h)*(f-k)-(t-k)*(p-h))+((t-k)*(e-j)-(u-j)*(f-k))*(s-h);if(l*l<9.99999905104687e-09)w=-1;else w=l*(((u-j)*(p-h)-(v-h)*(e-j))*(0.0-k)+((v-h)*(f-k)-(t-k)*(p-h))*(0.0-j)+((t-k)*(e-j)-(u-j)*(f-k))*(0.0-h))<0.0&1;l=(k-f)*((u-e)*(s-p)-(v-p)*(r-e))+(j-e)*((v-p)*(q-f)-(t-f)*(s-p))+((t-f)*(r-e)-(u-e)*(q-f))*(h-p);if(l*l<9.99999905104687e-09)d=-1;else d=l*(((u-e)*(s-p)-(v-p)*(r-e))*(0.0-f)+((v-p)*(q-f)-(t-f)*(s-p))*(0.0-e)+((t-f)*(r-e)-(u-e)*(q-f))*(0.0-p))<0.0&1;m=o|x|w|d;if((m|0)<0){a[b+352>>0]=1;a[b+312>>0]=0;d=0;d=d<<24>>24!=0;i=U;return d|0}n=(o|0)==0;o=(w|0)==0;d=(d|0)==0;if(!m){a[b+312>>0]=1;c[b+276>>2]=0;c[b+280>>2]=0;c[b+284>>2]=0;c[b+288>>2]=0;d=1;d=d<<24>>24!=0;i=U;return d|0}if((x|0)!=0?(rD(U,b+4|0,b+20|0,b+36|0,U+32|0),y=+g[U+32>>2],z=+g[U+36>>2],A=+g[U+40>>2],B=y-+g[U>>2],D=z-+g[U+4>>2],C=A-+g[U+8>>2],B*B+D*D+C*C<3402823466385288598117041.0e14):0){e=+g[U+44>>2];g[b+316>>2]=y;g[b+320>>2]=z;g[b+324>>2]=A;g[b+328>>2]=e;m=a[Q>>0]|0;a[b+332>>0]=m&1|a[b+332>>0]&-16|m&2|m&4;A=+g[U+56>>2];e=+g[U+60>>2];g[b+336>>2]=+g[U+52>>2];g[b+340>>2]=A;g[b+344>>2]=e;g[b+348>>2]=0.0;e=B*B+D*D+C*C}else e=3402823466385288598117041.0e14;if(!n?(rD(U,b+4|0,b+36|0,b+52|0,U+32|0),E=+g[U+32>>2],F=+g[U+36>>2],G=+g[U+40>>2],H=E-+g[U>>2],J=F-+g[U+4>>2],I=G-+g[U+8>>2],H*H+J*J+I*I<e):0){C=+g[U+44>>2];g[b+316>>2]=E;g[b+320>>2]=F;g[b+324>>2]=G;g[b+328>>2]=C;m=a[Q>>0]|0;a[b+332>>0]=m<<1&4|(m&1|a[b+332>>0]&-16)|m<<1&8;C=+g[U+56>>2];e=+g[U+60>>2];g[b+336>>2]=+g[U+52>>2];g[b+340>>2]=0.0;g[b+344>>2]=C;g[b+348>>2]=e;e=H*H+J*J+I*I}if(!o?(rD(U,b+4|0,b+52|0,b+20|0,U+32|0),K=+g[U+32>>2],L=+g[U+36>>2],M=+g[U+40>>2],N=K-+g[U>>2],P=L-+g[U+4>>2],O=M-+g[U+8>>2],N*N+P*P+O*O<e):0){C=+g[U+44>>2];g[b+316>>2]=K;g[b+320>>2]=L;g[b+324>>2]=M;g[b+328>>2]=C;m=a[Q>>0]|0;a[b+332>>0]=(m&255)>>>1&2|(m&1|a[b+332>>0]&-16)|m<<2&8;C=+g[U+60>>2];e=+g[U+56>>2];g[b+336>>2]=+g[U+52>>2];g[b+340>>2]=C;g[b+344>>2]=0.0;g[b+348>>2]=e;e=N*N+P*P+O*O}if(!d?(rD(U,b+20|0,b+52|0,b+36|0,U+32|0),R=+g[U+32>>2],S=+g[U+36>>2],T=+g[U+40>>2],A=R-+g[U>>2],B=S-+g[U+4>>2],C=T-+g[U+8>>2],A*A+B*B+C*C<e):0){A=+g[U+44>>2];g[b+316>>2]=R;g[b+320>>2]=S;g[b+324>>2]=T;g[b+328>>2]=A;d=a[Q>>0]|0;a[b+332>>0]=d<<1&2|a[b+332>>0]&-16|d&4|d<<2&8;A=+g[U+52>>2];B=+g[U+60>>2];C=+g[U+56>>2];g[b+336>>2]=0.0;g[b+340>>2]=A;g[b+344>>2]=B;g[b+348>>2]=C}D=+g[b+336>>2];t=+g[b+340>>2];u=+g[b+344>>2];C=+g[b+348>>2];v=+g[b+84>>2]*D+ +g[b+100>>2]*t+ +g[b+116>>2]*u+ +g[b+132>>2]*C;z=D*+g[b+88>>2]+t*+g[b+104>>2]+u*+g[b+120>>2]+C*+g[b+136>>2];B=D*+g[b+92>>2]+t*+g[b+108>>2]+u*+g[b+124>>2]+C*+g[b+140>>2];g[b+244>>2]=v;g[b+248>>2]=z;g[b+252>>2]=B;g[b+256>>2]=0.0;y=+g[b+164>>2]*D+ +g[b+180>>2]*t+ +g[b+196>>2]*u+ +g[b+212>>2]*C;A=D*+g[b+168>>2]+t*+g[b+184>>2]+u*+g[b+200>>2]+C*+g[b+216>>2];C=D*+g[b+172>>2]+t*+g[b+188>>2]+u*+g[b+204>>2]+C*+g[b+220>>2];g[b+260>>2]=y;g[b+264>>2]=A;g[b+268>>2]=C;g[b+272>>2]=0.0;g[b+276>>2]=v-y;g[b+280>>2]=z-A;g[b+284>>2]=B-C;g[b+288>>2]=0.0;pD(b,b+332|0);if((+g[b+336>>2]>=0.0?+g[b+340>>2]>=0.0:0)?+g[b+344>>2]>=0.0:0)d=+g[b+348>>2]>=0.0&1;else d=0;a[b+312>>0]=d;d=d<<24>>24!=0;i=U;return d|0}default:{a[b+312>>0]=0;d=0;d=d<<24>>24!=0;i=U;return d|0}}return 0}function rD(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0,B=0;B=i;A=a[h+16>>0]&-16;a[h+16>>0]=A;r=+g[e>>2];s=+g[d>>2];t=+g[e+4>>2];u=+g[d+4>>2];v=+g[e+8>>2];w=+g[d+8>>2];x=+g[f>>2];y=+g[f+4>>2];z=+g[f+8>>2];n=+g[b>>2];o=+g[b+4>>2];j=+g[b+8>>2];q=(r-s)*(n-s)+(t-u)*(o-u)+(v-w)*(j-w);p=(x-s)*(n-s)+(y-u)*(o-u)+(z-w)*(j-w);if(q<=0.0&p<=0.0){c[h+0>>2]=c[d+0>>2];c[h+4>>2]=c[d+4>>2];c[h+8>>2]=c[d+8>>2];c[h+12>>2]=c[d+12>>2];a[h+16>>0]=A|1;g[h+20>>2]=1.0;g[h+24>>2]=0.0;g[h+28>>2]=0.0;g[h+32>>2]=0.0;i=B;return}m=(r-s)*(n-r)+(t-u)*(o-t)+(v-w)*(j-v);l=(x-s)*(n-r)+(y-u)*(o-t)+(z-w)*(j-v);if(!(!(m>=0.0)|!(l<=m))){c[h+0>>2]=c[e+0>>2];c[h+4>>2]=c[e+4>>2];c[h+8>>2]=c[e+8>>2];c[h+12>>2]=c[e+12>>2];a[h+16>>0]=A|2;g[h+20>>2]=0.0;g[h+24>>2]=1.0;g[h+28>>2]=0.0;g[h+32>>2]=0.0;i=B;return}if((q>=0.0?q*l-m*p<=0.0:0)&m<=0.0){g[h>>2]=s+(r-s)*(q/(q-m));g[h+4>>2]=u+(t-u)*(q/(q-m));g[h+8>>2]=w+(v-w)*(q/(q-m));g[h+12>>2]=0.0;a[h+16>>0]=A|3;g[h+20>>2]=1.0-q/(q-m);g[h+24>>2]=q/(q-m);g[h+28>>2]=0.0;g[h+32>>2]=0.0;i=B;return}k=(r-s)*(n-x)+(t-u)*(o-y)+(v-w)*(j-z);j=(x-s)*(n-x)+(y-u)*(o-y)+(z-w)*(j-z);if(!(!(j>=0.0)|!(k<=j))){c[h+0>>2]=c[f+0>>2];c[h+4>>2]=c[f+4>>2];c[h+8>>2]=c[f+8>>2];c[h+12>>2]=c[f+12>>2];a[h+16>>0]=A|4;g[h+20>>2]=0.0;g[h+24>>2]=0.0;g[h+28>>2]=1.0;g[h+32>>2]=0.0;i=B;return}if((p>=0.0?k*p-q*j<=0.0:0)&j<=0.0){g[h>>2]=s+(x-s)*(p/(p-j));g[h+4>>2]=u+(y-u)*(p/(p-j));g[h+8>>2]=w+(z-w)*(p/(p-j));g[h+12>>2]=0.0;a[h+16>>0]=A|5;g[h+20>>2]=1.0-p/(p-j);g[h+24>>2]=0.0;g[h+28>>2]=p/(p-j);g[h+32>>2]=0.0;i=B;return}if((m*j-k*l<=0.0?l-m>=0.0:0)?k-j>=0.0:0){q=(l-m)/(l-m+(k-j));g[h>>2]=r+(x-r)*q;g[h+4>>2]=t+(y-t)*q;g[h+8>>2]=v+(z-v)*q;g[h+12>>2]=0.0;a[h+16>>0]=A|6;g[h+20>>2]=0.0;g[h+24>>2]=1.0-q;g[h+28>>2]=q;g[h+32>>2]=0.0;i=B;return}n=1.0/(q*l-m*p+(m*j-k*l+(k*p-q*j)));o=(k*p-q*j)*n;q=(q*l-m*p)*n;g[h>>2]=(x-s)*q+(s+(r-s)*o);g[h+4>>2]=(y-u)*q+(u+(t-u)*o);g[h+8>>2]=(z-w)*q+((v-w)*o+w);g[h+12>>2]=0.0;a[h+16>>0]=A|7;g[h+20>>2]=1.0-o-q;g[h+24>>2]=o;g[h+28>>2]=q;g[h+32>>2]=0.0;i=B;return}function sD(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;return}function tD(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;return 1.0}function uD(a,b){a=a|0;b=b|0;return}function vD(a){a=a|0;var b=0;b=i;RE(a);i=b;return}function wD(b){b=b|0;var d=0,e=0;e=i;c[b>>2]=19672;if(!(a[b+8>>0]|0)){i=e;return}d=c[b+12>>2]|0;if(!d){i=e;return}b=c[b+4>>2]|0;Lb[c[(c[b>>2]|0)+16>>2]&127](b,d);i=e;return}function xD(b){b=b|0;var d=0,e=0,f=0;e=i;c[b>>2]=19672;if(!(a[b+8>>0]|0)){RE(b);i=e;return}d=c[b+12>>2]|0;if(!d){RE(b);i=e;return}f=c[b+4>>2]|0;Lb[c[(c[f>>2]|0)+16>>2]&127](f,d);RE(b);i=e;return}function yD(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0,q=0,r=0;q=i;i=i+32|0;p=c[a+12>>2]|0;if(!p){i=q;return}c[f+4>>2]=p;e=c[b+4>>2]|0;r=c[d+4>>2]|0;b=c[b+12>>2]|0;a=c[d+12>>2]|0;j=+g[b+48>>2]-+g[a+48>>2];h=+g[b+52>>2]-+g[a+52>>2];l=+g[b+56>>2]-+g[a+56>>2];n=+P(+(j*j+h*h+l*l));o=+g[r+28>>2]*+g[r+12>>2];m=+g[e+28>>2]*+g[e+12>>2]+o;if(n>m){if(!(c[p+748>>2]|0)){i=q;return}d=c[p+740>>2]|0;b=c[(c[f+8>>2]|0)+8>>2]|0;e=c[(c[f+12>>2]|0)+8>>2]|0;if((d|0)==(b|0)){Fs(p,d+4|0,e+4|0);i=q;return}else{Fs(p,e+4|0,b+4|0);i=q;return}}g[q+16>>2]=1.0;g[q+20>>2]=0.0;g[q+24>>2]=0.0;g[q+28>>2]=0.0;if(n>1.1920928955078125e-07){g[q+16>>2]=j*(1.0/n);g[q+20>>2]=h*(1.0/n);g[q+24>>2]=l*(1.0/n);g[q+28>>2]=0.0;k=j*(1.0/n);j=h*(1.0/n);h=l*(1.0/n)}else{k=1.0;j=0.0;h=0.0}j=o*j+ +g[a+52>>2];h=o*h+ +g[a+56>>2];g[q>>2]=o*k+ +g[a+48>>2];g[q+4>>2]=j;g[q+8>>2]=h;g[q+12>>2]=0.0;oc[c[(c[f>>2]|0)+16>>2]&15](f,q+16|0,q,n-m);b=c[f+4>>2]|0;if(!(c[b+748>>2]|0)){i=q;return}d=c[b+740>>2]|0;a=c[(c[f+8>>2]|0)+8>>2]|0;e=c[(c[f+12>>2]|0)+8>>2]|0;if((d|0)==(a|0)){Fs(b,d+4|0,e+4|0);i=q;return}else{Fs(b,e+4|0,a+4|0);i=q;return}}function zD(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;return 1.0}function AD(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0;k=i;if(!(c[b+12>>2]|0)){i=k;return}if(!(a[b+8>>0]|0)){i=k;return}e=c[d+4>>2]|0;if((e|0)==(c[d+8>>2]|0)?(j=(e|0)==0?1:e<<1,(e|0)<(j|0)):0){if(!j)f=0;else{c[5108]=(c[5108]|0)+1;f=QE((j<<2|3)+16|0)|0;if(!f)f=0;else{c[(f+19&-16)+-4>>2]=f;f=f+19&-16}e=c[d+4>>2]|0}if((e|0)>0){h=0;do{g=f+(h<<2)|0;if(g)c[g>>2]=c[(c[d+12>>2]|0)+(h<<2)>>2];h=h+1|0}while((h|0)!=(e|0))}g=c[d+12>>2]|0;if(g){if(a[d+16>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[g+-4>>2]|0);e=c[d+4>>2]|0}c[d+12>>2]=0}a[d+16>>0]=1;c[d+12>>2]=f;c[d+8>>2]=j}f=(c[d+12>>2]|0)+(e<<2)|0;if(f)c[f>>2]=c[b+12>>2];c[d+4>>2]=e+1;i=k;return}function BD(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var h=0.0,j=0.0,k=0.0,l=0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0,s=0.0,t=0.0,u=0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0.0,N=0.0,Q=0.0,R=0.0,S=0.0,T=0.0,U=0.0,V=0.0,W=0.0,Y=0.0,Z=0.0,_=0.0,$=0,aa=0.0,ba=0.0,ca=0.0,da=0,ea=0,fa=0.0,ga=0.0,ha=0.0,ia=0.0,ja=0.0,ka=0.0,la=0.0,ma=0,na=0,oa=0,pa=0.0,qa=0.0,ra=0.0,sa=0.0,ta=0.0,ua=0.0,va=0.0,wa=0.0,xa=0.0,ya=0.0,za=0.0,Aa=0.0,Ba=0.0,Ca=0.0,Da=0.0,Ea=0.0,Fa=0.0,Ga=0.0,Ha=0.0,Ia=0;Ia=i;i=i+656|0;g[Ia+48>>2]=+g[b>>2];g[Ia>>2]=+g[b+64>>2];na=Ia+52|0;g[na>>2]=+g[b+4>>2];g[Ia+4>>2]=+g[b+68>>2];g[Ia+56>>2]=+g[b+8>>2];g[Ia+8>>2]=+g[b+72>>2];g[Ia+64>>2]=+g[b+16>>2];g[Ia+16>>2]=+g[b+80>>2];g[Ia+68>>2]=+g[b+20>>2];g[Ia+20>>2]=+g[b+84>>2];g[Ia+72>>2]=+g[b+24>>2];g[Ia+24>>2]=+g[b+88>>2];g[Ia+80>>2]=+g[b+32>>2];g[Ia+32>>2]=+g[b+96>>2];g[Ia+84>>2]=+g[b+36>>2];g[Ia+36>>2]=+g[b+100>>2];g[Ia+88>>2]=+g[b+40>>2];g[Ia+40>>2]=+g[b+104>>2];L=c[a+4>>2]|0;sa=+g[L+28>>2];ta=+g[L+32>>2];ra=+g[L+36>>2];pa=+Zb[c[(c[L>>2]|0)+48>>2]&15](L);qa=+Zb[c[(c[L>>2]|0)+48>>2]&15](L);ra=(ra+ +Zb[c[(c[L>>2]|0)+48>>2]&15](L))*2.0;L=c[a+8>>2]|0;ya=+g[L+28>>2];za=+g[L+32>>2];Ca=+g[L+36>>2];wa=+Zb[c[(c[L>>2]|0)+48>>2]&15](L);xa=+Zb[c[(c[L>>2]|0)+48>>2]&15](L);Ca=(Ca+ +Zb[c[(c[L>>2]|0)+48>>2]&15](L))*2.0;R=+g[b+112>>2]-+g[b+48>>2];ca=+g[b+116>>2]-+g[b+52>>2];Q=+g[b+120>>2]-+g[b+56>>2];la=+g[Ia+48>>2];ja=+g[Ia+64>>2];ka=+g[Ia+80>>2];ia=+g[na>>2];ga=+g[Ia+68>>2];ha=+g[Ia+84>>2];k=+g[Ia+56>>2];p=+g[Ia+72>>2];j=+g[Ia+88>>2];g[Ia+548>>2]=(sa+pa)*2.0*.5;g[Ia+552>>2]=(ta+qa)*2.0*.5;g[Ia+556>>2]=ra*.5;g[Ia+536>>2]=(ya+wa)*2.0*.5;g[Ia+540>>2]=(za+xa)*2.0*.5;g[Ia+544>>2]=Ca*.5;Da=+g[Ia>>2];ua=+g[Ia+16>>2];Aa=+g[Ia+32>>2];Ea=+g[Ia+4>>2];va=+g[Ia+20>>2];Ba=+g[Ia+36>>2];Fa=+g[Ia+8>>2];Ga=+g[Ia+24>>2];Ha=+g[Ia+40>>2];Z=+O(+(la*Da+ja*ua+ka*Aa));o=+O(+(la*Ea+ja*va+ka*Ba));T=+O(+(la*Fa+ja*Ga+ka*Ha));M=+O(+(Da*ia+ua*ga+Aa*ha));n=+O(+(Ea*ia+va*ga+Ba*ha));U=+O(+(Fa*ia+Ga*ga+Ha*ha));S=+O(+(Da*k+ua*p+Aa*j));fa=+O(+(Ea*k+va*p+Ba*j));m=+O(+(Fa*k+Ga*p+Ha*j));y=+O(+(R*la+ca*ja+Q*ka))-(Ca*.5*T+((sa+pa)*2.0*.5+Z*((ya+wa)*2.0*.5)+o*((za+xa)*2.0*.5)));if(y>0.0){i=Ia;return}if(y>-3402823466385288598117041.0e14){l=1;u=R*la+ca*ja+Q*ka<0.0&1;a=Ia+48|0}else{l=0;u=0;a=0;y=-3402823466385288598117041.0e14}z=+O(+(R*ia+ca*ga+Q*ha))-((ta+qa)*2.0*.5+M*((ya+wa)*2.0*.5)+n*((za+xa)*2.0*.5)+U*(Ca*.5));if(z>0.0){i=Ia;return}if(z>y){l=2;u=R*ia+ca*ga+Q*ha<0.0&1;a=na;y=z}z=+O(+(R*k+ca*p+Q*j))-(ra*.5+S*((ya+wa)*2.0*.5)+fa*((za+xa)*2.0*.5)+m*(Ca*.5));if(z>0.0){i=Ia;return}if(z>y){l=3;u=R*k+ca*p+Q*j<0.0&1;a=Ia+56|0;y=z}z=+O(+(R*Da+ca*ua+Q*Aa))-((ya+wa)*2.0*.5+(Z*((sa+pa)*2.0*.5)+M*((ta+qa)*2.0*.5)+S*(ra*.5)));if(z>0.0){i=Ia;return}if(z>y){l=4;u=R*Da+ca*ua+Q*Aa<0.0&1;a=Ia;y=z}z=+O(+(R*Ea+ca*va+Q*Ba))-((za+xa)*2.0*.5+(o*((sa+pa)*2.0*.5)+n*((ta+qa)*2.0*.5)+fa*(ra*.5)));if(z>0.0){i=Ia;return}if(z>y){l=5;u=R*Ea+ca*va+Q*Ba<0.0&1;a=Ia+4|0}else z=y;y=+O(+(R*Fa+ca*Ga+Q*Ha))-(Ca*.5+(T*((sa+pa)*2.0*.5)+U*((ta+qa)*2.0*.5)+m*(ra*.5)));if(y>0.0){i=Ia;return}if(y>z){l=6;u=R*Fa+ca*Ga+Q*Ha<0.0&1;a=Ia+8|0}else y=z;z=(R*k+ca*p+Q*j)*(Da*ia+ua*ga+Aa*ha)-(R*ia+ca*ga+Q*ha)*(Da*k+ua*p+Aa*j);v=+O(+z)-((S+9.999999747378752e-06)*((ta+qa)*2.0*.5)+(M+9.999999747378752e-06)*(ra*.5)+(T+9.999999747378752e-06)*((za+xa)*2.0*.5)+(o+9.999999747378752e-06)*(Ca*.5));if(v>1.1920928955078125e-07){i=Ia;return}t=(Da*k+ua*p+Aa*j)*(Da*k+ua*p+Aa*j)+0.0;ba=(Da*ia+ua*ga+Aa*ha)*(Da*ia+ua*ga+Aa*ha);w=+P(+(ba+t));if(w>1.1920928955078125e-07?v/w*1.0499999523162842>y:0){l=7;s=0.0/w;h=-(Da*k+ua*p+Aa*j)/w;x=(Da*ia+ua*ga+Aa*ha)/w;u=z<0.0&1;a=0;y=v/w}else{s=0.0;h=0.0;x=0.0}z=(R*k+ca*p+Q*j)*(Ea*ia+va*ga+Ba*ha)-(R*ia+ca*ga+Q*ha)*(Ea*k+va*p+Ba*j);v=+O(+z)-((fa+9.999999747378752e-06)*((ta+qa)*2.0*.5)+(n+9.999999747378752e-06)*(ra*.5)+(T+9.999999747378752e-06)*((ya+wa)*2.0*.5)+(Z+9.999999747378752e-06)*(Ca*.5));if(v>1.1920928955078125e-07){i=Ia;return}V=(Ea*k+va*p+Ba*j)*(Ea*k+va*p+Ba*j)+0.0;aa=(Ea*ia+va*ga+Ba*ha)*(Ea*ia+va*ga+Ba*ha);w=+P(+(aa+V));if(w>1.1920928955078125e-07?v/w*1.0499999523162842>y:0){l=8;s=0.0/w;h=-(Ea*k+va*p+Ba*j)/w;x=(Ea*ia+va*ga+Ba*ha)/w;u=z<0.0&1;a=0;y=v/w}z=(R*k+ca*p+Q*j)*(Fa*ia+Ga*ga+Ha*ha)-(R*ia+ca*ga+Q*ha)*(Fa*k+Ga*p+Ha*j);v=+O(+z)-((m+9.999999747378752e-06)*((ta+qa)*2.0*.5)+(U+9.999999747378752e-06)*(ra*.5)+(o+9.999999747378752e-06)*((ya+wa)*2.0*.5)+(Z+9.999999747378752e-06)*((za+xa)*2.0*.5));if(v>1.1920928955078125e-07){i=Ia;return}q=(Fa*k+Ga*p+Ha*j)*(Fa*k+Ga*p+Ha*j)+0.0;_=(Fa*ia+Ga*ga+Ha*ha)*(Fa*ia+Ga*ga+Ha*ha);w=+P(+(_+q));if(w>1.1920928955078125e-07?v/w*1.0499999523162842>y:0){l=9;s=0.0/w;h=-(Fa*k+Ga*p+Ha*j)/w;x=(Fa*ia+Ga*ga+Ha*ha)/w;u=z<0.0&1;a=0;y=v/w}z=(R*la+ca*ja+Q*ka)*(Da*k+ua*p+Aa*j)-(R*k+ca*p+Q*j)*(la*Da+ja*ua+ka*Aa);v=+O(+z)-((S+9.999999747378752e-06)*((sa+pa)*2.0*.5)+(Z+9.999999747378752e-06)*(ra*.5)+(U+9.999999747378752e-06)*((za+xa)*2.0*.5)+(n+9.999999747378752e-06)*(Ca*.5));if(v>1.1920928955078125e-07){i=Ia;return}Y=(la*Da+ja*ua+ka*Aa)*(la*Da+ja*ua+ka*Aa);w=+P(+(Y+t));do if(w>1.1920928955078125e-07){if(!(v/w*1.0499999523162842>y))break;l=10;s=(Da*k+ua*p+Aa*j)/w;h=0.0/w;x=-(la*Da+ja*ua+ka*Aa)/w;u=z<0.0&1;a=0;y=v/w}while(0);z=(R*la+ca*ja+Q*ka)*(Ea*k+va*p+Ba*j)-(R*k+ca*p+Q*j)*(la*Ea+ja*va+ka*Ba);v=+O(+z)-((fa+9.999999747378752e-06)*((sa+pa)*2.0*.5)+(o+9.999999747378752e-06)*(ra*.5)+(U+9.999999747378752e-06)*((ya+wa)*2.0*.5)+(M+9.999999747378752e-06)*(Ca*.5));if(v>1.1920928955078125e-07){i=Ia;return}W=(la*Ea+ja*va+ka*Ba)*(la*Ea+ja*va+ka*Ba);w=+P(+(W+V));do if(w>1.1920928955078125e-07){if(!(v/w*1.0499999523162842>y))break;l=11;s=(Ea*k+va*p+Ba*j)/w;h=0.0/w;x=-(la*Ea+ja*va+ka*Ba)/w;u=z<0.0&1;a=0;y=v/w}while(0);z=(R*la+ca*ja+Q*ka)*(Fa*k+Ga*p+Ha*j)-(R*k+ca*p+Q*j)*(la*Fa+ja*Ga+ka*Ha);v=+O(+z)-((m+9.999999747378752e-06)*((sa+pa)*2.0*.5)+(T+9.999999747378752e-06)*(ra*.5)+(n+9.999999747378752e-06)*((ya+wa)*2.0*.5)+(M+9.999999747378752e-06)*((za+xa)*2.0*.5));if(v>1.1920928955078125e-07){i=Ia;return}N=(la*Fa+ja*Ga+ka*Ha)*(la*Fa+ja*Ga+ka*Ha);w=+P(+(N+q));do if(w>1.1920928955078125e-07){if(!(v/w*1.0499999523162842>y))break;l=12;s=(Fa*k+Ga*p+Ha*j)/w;h=0.0/w;x=-(la*Fa+ja*Ga+ka*Ha)/w;u=z<0.0&1;a=0;y=v/w}while(0);w=(R*ia+ca*ga+Q*ha)*(la*Da+ja*ua+ka*Aa)-(R*la+ca*ja+Q*ka)*(Da*ia+ua*ga+Aa*ha);v=+O(+w)-((M+9.999999747378752e-06)*((sa+pa)*2.0*.5)+(Z+9.999999747378752e-06)*((ta+qa)*2.0*.5)+(m+9.999999747378752e-06)*((za+xa)*2.0*.5)+(fa+9.999999747378752e-06)*(Ca*.5));if(v>1.1920928955078125e-07){i=Ia;return}z=+P(+(Y+ba+0.0));do if(z>1.1920928955078125e-07){if(!(v/z*1.0499999523162842>y))break;l=13;s=-(Da*ia+ua*ga+Aa*ha)/z;h=(la*Da+ja*ua+ka*Aa)/z;x=0.0/z;u=w<0.0&1;a=0;y=v/z}while(0);v=(R*ia+ca*ga+Q*ha)*(la*Ea+ja*va+ka*Ba)-(R*la+ca*ja+Q*ka)*(Ea*ia+va*ga+Ba*ha);w=+O(+v)-((n+9.999999747378752e-06)*((sa+pa)*2.0*.5)+(o+9.999999747378752e-06)*((ta+qa)*2.0*.5)+(m+9.999999747378752e-06)*((ya+wa)*2.0*.5)+(S+9.999999747378752e-06)*(Ca*.5));if(w>1.1920928955078125e-07){i=Ia;return}z=+P(+(W+aa+0.0));do if(z>1.1920928955078125e-07){if(!(w/z*1.0499999523162842>y))break;l=14;s=-(Ea*ia+va*ga+Ba*ha)/z;h=(la*Ea+ja*va+ka*Ba)/z;x=0.0/z;u=v<0.0&1;a=0;y=w/z}while(0);z=(R*ia+ca*ga+Q*ha)*(la*Fa+ja*Ga+ka*Ha)-(R*la+ca*ja+Q*ka)*(Fa*ia+Ga*ga+Ha*ha);v=+O(+z)-((U+9.999999747378752e-06)*((sa+pa)*2.0*.5)+(T+9.999999747378752e-06)*((ta+qa)*2.0*.5)+(fa+9.999999747378752e-06)*((ya+wa)*2.0*.5)+(S+9.999999747378752e-06)*((za+xa)*2.0*.5));if(v>1.1920928955078125e-07){i=Ia;return}w=+P(+(N+_+0.0));do if(w>1.1920928955078125e-07){if(!(v/w*1.0499999523162842>y)){oa=55;break}l=15;s=-(Fa*ia+Ga*ga+Ha*ha)/w;h=(la*Fa+ja*Ga+ka*Ha)/w;x=0.0/w;u=z<0.0&1;y=v/w;oa=58}else oa=55;while(0);do if((oa|0)==55){if(!l){i=Ia;return}if(!a){oa=58;break}L=l;w=+g[a>>2];v=+g[a+16>>2];x=+g[a+32>>2];z=y}while(0);if((oa|0)==58){L=l;w=s*+g[Ia+48>>2]+h*+g[na>>2]+x*k;v=s*+g[Ia+64>>2]+h*+g[Ia+68>>2]+x*p;x=s*+g[Ia+80>>2]+h*+g[Ia+84>>2]+x*j;z=y}if(!u){ha=w;ia=v;ja=x}else{ha=-w;ia=-v;ja=-x}if((L|0)>6){n=+g[Ia+48>>2];h=+g[Ia+64>>2];t=+g[Ia+80>>2];s=(ha*n+ia*h+ja*t>0.0?1.0:-1.0)*((sa+pa)*2.0*.5);y=+g[na>>2];x=+g[Ia+68>>2];q=+g[Ia+84>>2];v=(ha*y+ia*x+ja*q>0.0?1.0:-1.0)*((ta+qa)*2.0*.5);w=(ha*k+ia*p+ja*j>0.0?1.0:-1.0)*(ra*.5);y=+g[b+48>>2]+s*n+v*y+w*k;x=+g[b+52>>2]+s*h+v*x+w*p;w=+g[b+56>>2]+s*t+v*q+w*j;c[Ia+520>>2]=c[b+112>>2];c[Ia+524>>2]=c[b+116>>2];c[Ia+528>>2]=c[b+120>>2];k=(ha*Da+ia*ua+ja*Aa>0.0?-1.0:1.0)*((ya+wa)*2.0*.5);q=(ha*Ea+ia*va+ja*Ba>0.0?-1.0:1.0)*((za+xa)*2.0*.5);v=+g[Ia+524>>2]+k*ua+q*va;t=+g[Ia+528>>2]+k*Aa+q*Ba;s=(ha*Fa+ia*Ga+ja*Ha>0.0?-1.0:1.0)*(Ca*.5);q=+g[Ia+520>>2]+k*Da+q*Ea+s*Fa;g[Ia+520>>2]=q;g[Ia+524>>2]=v+s*Ga;g[Ia+528>>2]=t+s*Ha;L=L+-7|0;k=+g[Ia+48+(((L|0)/3|0)<<2)>>2];j=+g[Ia+48+(((L|0)/3|0)+4<<2)>>2];h=+g[Ia+48+(((L|0)/3|0)+8<<2)>>2];n=+g[Ia+(((L|0)%3|0)<<2)>>2];o=+g[Ia+(((L|0)%3|0)+4<<2)>>2];p=+g[Ia+(((L|0)%3|0)+8<<2)>>2];m=1.0-(k*n+j*o+h*p)*(k*n+j*o+h*p);if(!(m<=9.999999747378752e-05))k=(((q-y)*k+(v+s*Ga-x)*j+(t+s*Ha-w)*h)*(k*n+j*o+h*p)-((q-y)*n+(v+s*Ga-x)*o+(t+s*Ha-w)*p))*(1.0/m);else k=0.0;g[Ia+520>>2]=q+k*n;g[Ia+524>>2]=v+s*Ga+k*o;g[Ia+528>>2]=t+s*Ha+k*p;L=c[(c[d>>2]|0)+16>>2]|0;g[Ia+504>>2]=-ha;g[Ia+508>>2]=-ia;g[Ia+512>>2]=-ja;g[Ia+516>>2]=0.0;oc[L&15](d,Ia+504|0,Ia+520|0,z);i=Ia;return}ma=(L|0)<4;if(ma){C=Ia;ca=ha;B=Ia+536|0;a=b+112|0;na=b+48|0;r=Ia+48|0;$=Ia+548|0;l=Ia;p=Ga;j=Ha;k=+g[Ia+8>>2];aa=ja;ba=ia}else{C=Ia+48|0;ca=-ha;B=Ia+548|0;a=b+48|0;na=b+112|0;r=Ia;$=Ia+536|0;l=Ia+48|0;aa=-ja;ba=-ia}h=ca*+g[l>>2]+ba*+g[C+16>>2]+aa*+g[C+32>>2];g[Ia+488>>2]=h;xa=ca*+g[C+4>>2]+ba*+g[C+20>>2]+aa*+g[C+36>>2];g[Ia+492>>2]=xa;k=ca*k+ba*p+aa*j;g[Ia+496>>2]=k;h=+O(+h);j=+O(+xa);k=+O(+k);if(j>h){f=0;l=j>k;u=j>k?1:2}else{f=h>k&1;l=h>k;u=h>k?0:2}b=l?2:1;v=+g[B+(u<<2)>>2];p=+g[a>>2]-+g[na>>2];q=v*+g[C+(u<<2)>>2];o=+g[a+4>>2];ea=na+4|0;n=+g[ea>>2];m=+g[a+8>>2];da=na+8|0;k=+g[da>>2];if(+g[Ia+488+(u<<2)>>2]<0.0){_=p+q;Z=o-n+v*+g[C+((u|4)<<2)>>2];Y=m-k+v*+g[C+((u|8)<<2)>>2]}else{_=p-q;Z=o-n-v*+g[C+((u|4)<<2)>>2];Y=m-k-v*+g[C+((u|8)<<2)>>2]}G=(ma?-1:-4)+L|0;if(!G){u=1;l=2}else if((G|0)==1){u=0;l=2}else{u=0;l=1}T=+g[r+(u<<2)>>2];R=+g[r+((u|4)<<2)>>2];S=+g[r+((u|8)<<2)>>2];W=_*T+Z*R+Y*S;V=+g[r+(l<<2)>>2];U=+g[r+((l|4)<<2)>>2];n=+g[r+((l|8)<<2)>>2];Q=_*V+Z*U+Y*n;F=C+(f<<2)|0;q=+g[F>>2];I=C+((f|4)<<2)|0;o=+g[I>>2];K=C+((f|8)<<2)|0;p=+g[K>>2];H=C+(b<<2)|0;N=+g[H>>2];J=C+((b|4)<<2)|0;M=+g[J>>2];L=C+((b|8)<<2)|0;m=+g[L>>2];wa=+g[B+(f<<2)>>2];xa=+g[B+(b<<2)>>2];va=(T*N+R*M+S*m)*xa;xa=(V*N+U*M+n*m)*xa;g[Ia+456>>2]=W-(T*q+R*o+S*p)*wa-va;g[Ia+460>>2]=Q-(V*q+U*o+n*p)*wa-xa;g[Ia+464>>2]=W-(T*q+R*o+S*p)*wa+va;g[Ia+468>>2]=Q-(V*q+U*o+n*p)*wa+xa;g[Ia+472>>2]=W+(T*q+R*o+S*p)*wa+va;g[Ia+476>>2]=Q+(V*q+U*o+n*p)*wa+xa;g[Ia+480>>2]=W+(T*q+R*o+S*p)*wa-va;g[Ia+484>>2]=Q+(V*q+U*o+n*p)*wa-xa;g[Ia+448>>2]=+g[$+(u<<2)>>2];g[Ia+452>>2]=+g[$+(l<<2)>>2];u=0;l=4;a=Ia+456|0;r=Ia+384|0;a:while(1){D=Ia+448+(u<<2)|0;E=1-u|0;B=a;a=r;C=-1;while(1){if((l|0)>0){w=+(C|0);r=0;A=B;f=a;while(1){e=A+(u<<2)|0;z=+g[e>>2];y=+g[D>>2];if(w*z<y){g[f>>2]=+g[A>>2];g[f+4>>2]=+g[A+4>>2];r=r+1|0;if(r&8)break a;z=+g[e>>2];y=+g[D>>2];f=f+8|0}b=A;A=A+8|0;e=(l|0)>1?A:B;x=+g[e+(u<<2)>>2];if(w*z<y^w*x<y){xa=+g[b+(E<<2)>>2];g[f+(E<<2)>>2]=xa+(w*y-z)*((+g[e+(E<<2)>>2]-xa)/(x-z));g[f+(u<<2)>>2]=w*+g[D>>2];r=r+1|0;if(!(r&8))f=f+8|0;else break a}l=l+-1|0;if((l|0)<=0){l=r;break}}}else l=0;r=(a|0)==(Ia+384|0)?Ia+592|0:Ia+384|0;if((C|0)<0){B=a;a=r;C=C+2|0}else break}u=u+1|0;if((u|0)>=2){r=l;break}}if((a|0)!=(Ia+384|0))YE(Ia+384|0,a|0,r<<3|0)|0;if((r|0)<1){i=Ia;return}z=1.0/((T*q+R*o+S*p)*(V*N+U*M+n*m)-(V*q+U*o+n*p)*(T*N+R*M+S*m));k=+g[$+(G<<2)>>2];t=+g[F>>2];j=+g[H>>2];s=+g[I>>2];h=+g[J>>2];v=+g[K>>2];w=+g[L>>2];u=0;l=0;do{L=l<<1;y=+g[Ia+384+(L<<2)>>2];x=+g[Ia+384+((L|1)<<2)>>2];pa=(V*N+U*M+n*m)*z*(y-W)-(T*N+R*M+S*m)*z*(x-Q);xa=(T*q+R*o+S*p)*z*(x-Q)-(V*q+U*o+n*p)*z*(y-W);L=u*3|0;va=_+pa*t+xa*j;g[Ia+288+(L<<2)>>2]=va;wa=Z+pa*s+xa*h;g[Ia+288+(L+1<<2)>>2]=wa;xa=Y+pa*v+xa*w;g[Ia+288+(L+2<<2)>>2]=xa;xa=k-(ca*va+ba*wa+aa*xa);g[Ia+256+(u<<2)>>2]=xa;if(xa>=0.0){L=u<<1;g[Ia+384+(L<<2)>>2]=y;g[Ia+384+((L|1)<<2)>>2]=x;u=u+1|0}l=l+1|0}while((l|0)!=(r|0));if((u|0)<1){i=Ia;return}A=(u|0)<4?u:4;A=(A|0)<1?1:A;if((u|0)<=(A|0)){f=(u|0)>0;if(ma){if(!f){i=Ia;return}k=-ha;j=-ia;h=-ja;f=0;do{L=f*3|0;g[Ia+240>>2]=+g[Ia+288+(L<<2)>>2]+ +g[na>>2];g[Ia+244>>2]=+g[Ia+288+(L+1<<2)>>2]+ +g[ea>>2];g[Ia+248>>2]=+g[Ia+288+(L+2<<2)>>2]+ +g[da>>2];L=c[(c[d>>2]|0)+16>>2]|0;g[Ia+224>>2]=k;g[Ia+228>>2]=j;g[Ia+232>>2]=h;g[Ia+236>>2]=0.0;oc[L&15](d,Ia+224|0,Ia+240|0,-+g[Ia+256+(f<<2)>>2]);f=f+1|0}while((f|0)!=(u|0));i=Ia;return}else{if(!f){i=Ia;return}k=-ha;j=-ia;h=-ja;a=0;do{L=a*3|0;xa=+g[Ia+256+(a<<2)>>2];g[Ia+208>>2]=+g[Ia+288+(L<<2)>>2]+ +g[na>>2]-ha*xa;g[Ia+212>>2]=+g[Ia+288+(L+1<<2)>>2]+ +g[ea>>2]-ia*xa;g[Ia+216>>2]=+g[Ia+288+(L+2<<2)>>2]+ +g[da>>2]-ja*xa;L=c[(c[d>>2]|0)+16>>2]|0;g[Ia+192>>2]=k;g[Ia+196>>2]=j;g[Ia+200>>2]=h;g[Ia+204>>2]=0.0;oc[L&15](d,Ia+192|0,Ia+208|0,-xa);a=a+1|0}while((a|0)!=(u|0));i=Ia;return}}if((u|0)>1){f=1;a=0;j=+g[Ia+256>>2];while(1){k=+g[Ia+256+(f<<2)>>2];l=k>j;a=l?f:a;f=f+1|0;if((f|0)==(u|0)){b=a;break}else j=l?k:j}}else b=0;if((u|0)==1){l=1;j=+g[Ia+384>>2];k=+g[Ia+388>>2];oa=116}else if((u|0)!=2){a=u+-1|0;if((a|0)>0){k=0.0;j=0.0;h=0.0;l=0;do{L=l<<1;pa=+g[Ia+384+(L<<2)>>2];va=+g[Ia+384+(L+3<<2)>>2];wa=+g[Ia+384+(L+2<<2)>>2];xa=+g[Ia+384+((L|1)<<2)>>2];k=k+(pa*va-wa*xa);j=j+(pa+wa)*(pa*va-wa*xa);h=h+(va+xa)*(pa*va-wa*xa);l=l+1|0}while((l|0)!=(a|0))}else{k=0.0;j=0.0;h=0.0}L=u<<1;p=+g[Ia+384+(L+-2<<2)>>2];o=+g[Ia+388>>2];n=+g[Ia+384>>2];m=+g[Ia+384+(L+-1<<2)>>2];k=k+(p*o-n*m);if(+O(+k)>1.1920928955078125e-07)k=1.0/(k*3.0);else k=999999984306749440.0;if((u|0)>0){l=u;j=k*(j+(p*o-n*m)*(p+n));k=k*(h+(p*o-n*m)*(m+o));oa=116}else a=0}else{l=2;j=(+g[Ia+384>>2]+ +g[Ia+392>>2])*.5;k=(+g[Ia+388>>2]+ +g[Ia+396>>2])*.5;oa=116}if((oa|0)==116){a=0;do{L=a<<1;g[Ia+592+(a<<2)>>2]=+X(+(+g[Ia+384+((L|1)<<2)>>2]-k),+(+g[Ia+384+(L<<2)>>2]-j));a=a+1|0}while((a|0)!=(l|0));a=0;do{c[Ia+560+(a<<2)>>2]=1;a=a+1|0}while((a|0)!=(l|0));a=1;u=l}l=Ia+560+(b<<2)|0;c[l>>2]=0;c[Ia+160>>2]=b;b:do if((A|0)>1){q=+g[Ia+592+(b<<2)>>2];if(a){f=Ia+160|0;e=Ia+164|0;r=1}else{a=Ia+160|0;f=Ia+164|0;e=1;while(1){c[f>>2]=b;c[l>>2]=0;e=e+1|0;if((e|0)==(A|0))break b;else{L=f;f=a+8|0;a=L}}}while(1){k=+(r|0)*(6.2831854820251465/+(A|0))+q;if(k>3.1415927410125732)k=k+-6.2831854820251465;c[e>>2]=b;l=b;a=0;p=1.0e9;while(1){do if(!(c[Ia+560+(a<<2)>>2]|0))j=p;else{j=+O(+(+g[Ia+592+(a<<2)>>2]-k));if(j>3.1415927410125732)j=6.2831854820251465-j;if(!(j<p)){j=p;break}c[e>>2]=a;l=a}while(0);a=a+1|0;if((a|0)==(u|0))break;else p=j}c[Ia+560+(l<<2)>>2]=0;r=r+1|0;if((r|0)==(A|0))break;else{L=e;e=f+8|0;f=L}}}while(0);if((A|0)<=0){i=Ia;return}h=-ja;j=-ia;k=-ha;if(ma){f=0;do{L=c[Ia+160+(f<<2)>>2]|0;g[Ia+144>>2]=+g[Ia+288+(L*3<<2)>>2]+ +g[na>>2];g[Ia+148>>2]=+g[Ia+288+((L*3|0)+1<<2)>>2]+ +g[ea>>2];g[Ia+152>>2]=+g[Ia+288+((L*3|0)+2<<2)>>2]+ +g[da>>2];K=c[(c[d>>2]|0)+16>>2]|0;g[Ia+128>>2]=k;g[Ia+132>>2]=j;g[Ia+136>>2]=h;g[Ia+140>>2]=0.0;oc[K&15](d,Ia+128|0,Ia+144|0,-+g[Ia+256+(L<<2)>>2]);f=f+1|0}while((f|0)<(A|0));i=Ia;return}else{a=0;do{K=c[Ia+160+(a<<2)>>2]|0;pa=+g[Ia+288+(K*3<<2)>>2]+ +g[na>>2];g[Ia+144>>2]=pa;va=+g[Ia+288+((K*3|0)+1<<2)>>2]+ +g[ea>>2];g[Ia+148>>2]=va;wa=+g[Ia+288+((K*3|0)+2<<2)>>2]+ +g[da>>2];g[Ia+152>>2]=wa;L=c[(c[d>>2]|0)+16>>2]|0;g[Ia+112>>2]=k;g[Ia+116>>2]=j;g[Ia+120>>2]=h;g[Ia+124>>2]=0.0;xa=+g[Ia+256+(K<<2)>>2];g[Ia+96>>2]=pa-ha*xa;g[Ia+100>>2]=va-xa*ia;g[Ia+104>>2]=wa-xa*ja;g[Ia+108>>2]=0.0;oc[L&15](d,Ia+112|0,Ia+96|0,-xa);a=a+1|0}while((a|0)<(A|0));i=Ia;return}}function CD(a){a=a|0;var b=0;b=i;RE(a);i=b;return}function DD(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0,A=0.0,B=0.0,C=0.0,D=0.0,E=0,F=0;E=i;i=i+96|0;A=+g[b+48>>2]-+g[b+112>>2];h=+g[b+52>>2]-+g[b+116>>2];D=+g[b+56>>2]-+g[b+120>>2];B=A*+g[b+64>>2]+h*+g[b+80>>2]+D*+g[b+96>>2];C=A*+g[b+68>>2]+h*+g[b+84>>2]+D*+g[b+100>>2];D=A*+g[b+72>>2]+h*+g[b+88>>2]+D*+g[b+104>>2];e=c[a+8>>2]|0;z=c[a+4>>2]|0;h=+g[z+28>>2]*+g[z+12>>2];A=h+ +g[a+12>>2];t=+g[e+72>>2];n=+g[e+56>>2];o=+g[e+76>>2];p=+g[e+60>>2];u=+g[e+80>>2];v=+g[e+64>>2];w=+g[e+88>>2];x=+g[e+92>>2];y=+g[e+96>>2];m=(o-p)*(y-v)-(u-v)*(x-p);s=(u-v)*(w-n)-(t-n)*(y-v);r=(t-n)*(x-p)-(o-p)*(w-n);l=1.0/+P(+(r*r+(m*m+s*s)));q=(B-n)*(l*m)+l*s*(C-p)+l*r*(D-v);if(q<0.0){q=-q;j=-(l*r);k=-(l*s);l=-(l*m)}else{j=l*r;k=l*s;l=l*m}if(!(q<A)){i=E;return}m=(D-v)*((t-n)*k-(o-p)*l)+((B-n)*((o-p)*j-(u-v)*k)+(C-p)*((u-v)*l-(t-n)*j));o=(D-u)*((w-t)*k-(x-o)*l)+((B-t)*((x-o)*j-(y-u)*k)+(C-o)*((y-u)*l-(w-t)*j));r=(D-y)*((n-w)*k-(p-x)*l)+((B-w)*((p-x)*j-(v-y)*k)+(C-x)*((v-y)*l-(n-w)*j));if(!(m>0.0&o>0.0&r>0.0)?!(m<=0.0&o<=0.0&r<=0.0):0){if((Nb[c[(c[e>>2]|0)+100>>2]&127](e)|0)<=0){i=E;return}o=0.0;q=0.0;p=0.0;e=0;z=0;do{F=c[a+8>>2]|0;tc[c[(c[F>>2]|0)+104>>2]&127](F,z,E+80|0,E+64|0);s=+g[E+80>>2];y=+g[E+84>>2];w=+g[E+88>>2];r=+g[E+64>>2]-s;x=+g[E+68>>2]-y;u=+g[E+72>>2]-w;do if((B-s)*r+(C-y)*x+(D-w)*u>0.0)if((B-s)*r+(C-y)*x+(D-w)*u<r*r+x*x+u*u){t=((B-s)*r+(C-y)*x+(D-w)*u)/(r*r+x*x+u*u);v=t;m=D-w-u*t;n=B-s-r*t;t=C-y-x*t;break}else{v=1.0;m=D-w-u;n=B-s-r;t=C-y-x;break}else{v=0.0;m=D-w;n=B-s;t=C-y}while(0);if(m*m+(t*t+n*n)<A*A){o=s+r*v;q=y+x*v;p=w+u*v;e=1}z=z+1|0;F=c[a+8>>2]|0}while((z|0)<(Nb[c[(c[F>>2]|0)+100>>2]&127](F)|0));if(!(e&1)){i=E;return}else{s=o;r=q;q=p;m=A*A}}else{s=B-l*q;r=C-k*q;q=D-j*q;m=A*A}n=B-s;p=C-r;o=D-q;if(!(n*n+p*p+o*o<m)){i=E;return}if(n*n+p*p+o*o>1.1920928955078125e-07){j=+P(+(n*n+p*p+o*o));h=h-j;l=n*(1.0/j);k=p*(1.0/j);j=o*(1.0/j)}h=-h;if(f){u=+g[b+64>>2];t=+g[b+68>>2];m=+g[b+72>>2];n=u*l+t*k+m*j;B=+g[b+80>>2];A=+g[b+84>>2];y=+g[b+88>>2];o=l*B+k*A+j*y;x=+g[b+96>>2];w=+g[b+100>>2];v=+g[b+104>>2];p=l*x+k*w+j*v;g[E+48>>2]=-n;g[E+52>>2]=-o;g[E+56>>2]=-p;g[E+60>>2]=0.0;o=s*B+r*A+q*y+ +g[b+116>>2]+o*h;p=s*x+r*w+q*v+ +g[b+120>>2]+p*h;g[E+32>>2]=s*u+r*t+q*m+ +g[b+112>>2]+n*h;g[E+36>>2]=o;g[E+40>>2]=p;g[E+44>>2]=0.0;oc[c[(c[d>>2]|0)+16>>2]&15](d,E+48|0,E+32|0,h);i=E;return}else{e=c[(c[d>>2]|0)+16>>2]|0;t=+g[b+64>>2];m=+g[b+68>>2];n=+g[b+72>>2];x=+g[b+80>>2];w=+g[b+84>>2];o=+g[b+88>>2];v=+g[b+96>>2];u=+g[b+100>>2];p=+g[b+104>>2];g[E+16>>2]=t*l+m*k+n*j;g[E+20>>2]=l*x+k*w+j*o;g[E+24>>2]=l*v+k*u+j*p;g[E+28>>2]=0.0;o=s*x+r*w+q*o+ +g[b+116>>2];p=s*v+r*u+q*p+ +g[b+120>>2];g[E>>2]=s*t+r*m+q*n+ +g[b+112>>2];g[E+4>>2]=o;g[E+8>>2]=p;g[E+12>>2]=0.0;oc[e&15](d,E+16|0,E,h);i=E;return}}function ED(a){a=a|0;var b=0;b=i;RE(a);i=b;return}function FD(b){b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0;l=i;j=c[b+12>>2]|0;k=c[b+32>>2]|0;if((k|0)>=(j|0)){i=l;return}if((k|0)<=(j|0)){if((c[b+36>>2]|0)<(j|0)){if(!j){e=k;h=0}else{c[5108]=(c[5108]|0)+1;d=QE((j<<2|3)+16|0)|0;if(!d)d=0;else{c[(d+19&-16)+-4>>2]=d;d=d+19&-16}e=c[b+32>>2]|0;h=d}if((e|0)>0){f=0;do{g=h+(f<<2)|0;if(g)c[g>>2]=c[(c[b+40>>2]|0)+(f<<2)>>2];f=f+1|0}while((f|0)!=(e|0))}d=c[b+40>>2]|0;if(d){if(a[b+44>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}c[b+40>>2]=0}a[b+44>>0]=1;c[b+40>>2]=h;c[b+36>>2]=j;d=h}else d=c[b+40>>2]|0;g=k;do{f=d+(g<<2)|0;if(f)c[f>>2]=0;g=g+1|0}while((g|0)!=(j|0))}c[b+32>>2]=j;g=c[b+52>>2]|0;if((g|0)<(j|0)){if((c[b+56>>2]|0)<(j|0)){if(!j){h=g;f=0}else{c[5108]=(c[5108]|0)+1;d=QE((j<<2|3)+16|0)|0;if(!d)f=0;else{c[(d+19&-16)+-4>>2]=d;f=d+19&-16}h=c[b+52>>2]|0}if((h|0)>0){d=0;do{e=f+(d<<2)|0;if(e)c[e>>2]=c[(c[b+60>>2]|0)+(d<<2)>>2];d=d+1|0}while((d|0)!=(h|0))}d=c[b+60>>2]|0;if(d){if(a[b+64>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}c[b+60>>2]=0}a[b+64>>0]=1;c[b+60>>2]=f;c[b+56>>2]=j;e=f}else e=c[b+60>>2]|0;do{f=e+(g<<2)|0;if(f)c[f>>2]=0;g=g+1|0}while((g|0)!=(j|0))}c[b+52>>2]=j;if((j|0)>0){VE(c[b+40>>2]|0,-1,j<<2|0)|0;VE(c[b+60>>2]|0,-1,j<<2|0)|0}if((k|0)<=0){i=l;return}d=c[b+16>>2]|0;e=c[b+40>>2]|0;f=c[b+60>>2]|0;g=0;do{h=c[d+(g*12|0)+4>>2]<<16|c[d+(g*12|0)>>2];h=(h+~(h<<15)>>10^h+~(h<<15))*9|0;h=e+((((h>>6^h)+~((h>>6^h)<<11)>>16^(h>>6^h)+~((h>>6^h)<<11))&(c[b+12>>2]|0)+-1)<<2)|0;c[f+(g<<2)>>2]=c[h>>2];c[h>>2]=g;g=g+1|0}while((g|0)!=(k|0));i=l;return}function GD(b){b=b|0;var d=0,e=0;e=i;c[b>>2]=19920;d=c[b+60>>2]|0;if(d){if(a[b+64>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}c[b+60>>2]=0}a[b+64>>0]=1;c[b+60>>2]=0;c[b+52>>2]=0;c[b+56>>2]=0;d=c[b+40>>2]|0;if(d){if(a[b+44>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}c[b+40>>2]=0}a[b+44>>0]=1;c[b+40>>2]=0;c[b+32>>2]=0;c[b+36>>2]=0;d=c[b+16>>2]|0;if(!d){a[b+20>>0]=1;c[b+16>>2]=0;c[b+8>>2]=0;d=b+12|0;c[d>>2]=0;i=e;return}if(a[b+20>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}c[b+16>>2]=0;a[b+20>>0]=1;c[b+16>>2]=0;c[b+8>>2]=0;d=b+12|0;c[d>>2]=0;i=e;return}function HD(a){a=a|0;var b=0;b=i;GD(a);RE(a);i=b;return}function ID(b){b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0;h=i;d=c[b+16>>2]|0;if(d){if(a[b+20>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}c[b+16>>2]=0}a[b+20>>0]=1;c[b+16>>2]=0;c[b+8>>2]=0;c[b+12>>2]=0;d=c[b+40>>2]|0;if(d){if(a[b+44>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}c[b+40>>2]=0}a[b+44>>0]=1;c[b+40>>2]=0;c[b+32>>2]=0;c[b+36>>2]=0;d=c[b+60>>2]|0;if(d){if(a[b+64>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}c[b+60>>2]=0}a[b+64>>0]=1;c[b+60>>2]=0;c[b+52>>2]=0;c[b+56>>2]=0;if((c[b+12>>2]|0)>=2){FD(b);i=h;return}c[5108]=(c[5108]|0)+1;d=QE(43)|0;if(!d)g=0;else{c[(d+19&-16)+-4>>2]=d;g=d+19&-16}d=c[b+8>>2]|0;if((d|0)>0){f=0;do{e=g+(f*12|0)|0;if(e){j=(c[b+16>>2]|0)+(f*12|0)|0;c[e+0>>2]=c[j+0>>2];c[e+4>>2]=c[j+4>>2];c[e+8>>2]=c[j+8>>2]}f=f+1|0}while((f|0)!=(d|0))}d=c[b+16>>2]|0;if(d){if(a[b+20>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}c[b+16>>2]=0}a[b+20>>0]=1;c[b+16>>2]=g;c[b+12>>2]=2;FD(b);i=h;return}function JD(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;p=i;c[4972]=(c[4972]|0)+1;h=((d<<16|b)+~((d<<16|b)<<15)>>10^(d<<16|b)+~((d<<16|b)<<15))*9|0;m=c[a+40>>2]|0;h=m+(((c[a+12>>2]|0)+-1&((h>>6^h)+~((h>>6^h)<<11)>>16^(h>>6^h)+~((h>>6^h)<<11)))<<2)|0;f=c[h>>2]|0;if((f|0)==-1){m=0;i=p;return m|0}n=c[a+16>>2]|0;e=f;while(1){if((c[n+(e*12|0)>>2]|0)==(b|0)?(c[n+(e*12|0)+4>>2]|0)==(d|0):0)break;e=c[(c[a+60>>2]|0)+(e<<2)>>2]|0;if((e|0)==-1){e=0;o=22;break}}if((o|0)==22){i=p;return e|0}if(!(n+(e*12|0)|0)){m=0;i=p;return m|0}l=c[n+(e*12|0)+8>>2]|0;k=(e*12|0)/12|0;j=c[a+60>>2]|0;if((f|0)!=(k|0)){while(1){b=j+(f<<2)|0;d=c[b>>2]|0;if((d|0)==(k|0))break;else f=d}e=c[j+(k<<2)>>2]|0;if((f|0)==-1)o=12;else c[b>>2]=e}else{e=c[j+(f<<2)>>2]|0;o=12}if((o|0)==12)c[h>>2]=e;h=(c[a+8>>2]|0)+-1|0;if((h|0)==(k|0)){c[a+8>>2]=k;m=l;i=p;return m|0}g=c[n+(h*12|0)+4>>2]<<16|c[n+(h*12|0)>>2];g=(g+~(g<<15)>>10^g+~(g<<15))*9|0;g=((g>>6^g)+~((g>>6^g)<<11)>>16^(g>>6^g)+~((g>>6^g)<<11))&(c[a+12>>2]|0)+-1;e=c[m+(g<<2)>>2]|0;if((e|0)!=(h|0)){b=e;while(1){d=j+(b<<2)|0;f=c[d>>2]|0;if((f|0)==(h|0))break;else b=f}e=c[j+(h<<2)>>2]|0;if((b|0)==-1)o=20;else c[d>>2]=e}else{e=c[j+(h<<2)>>2]|0;o=20}if((o|0)==20)c[m+(g<<2)>>2]=e;c[n+(k*12|0)+0>>2]=c[n+(h*12|0)+0>>2];c[n+(k*12|0)+4>>2]=c[n+(h*12|0)+4>>2];c[n+(k*12|0)+8>>2]=c[n+(h*12|0)+8>>2];m=(c[a+40>>2]|0)+(g<<2)|0;c[(c[a+60>>2]|0)+(k<<2)>>2]=c[m>>2];c[m>>2]=k;c[a+8>>2]=(c[a+8>>2]|0)+-1;m=l;i=p;return m|0}function KD(a){a=a|0;return c[a+16>>2]|0}function LD(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;o=i;c[4974]=(c[4974]|0)+1;n=((e<<16|d)+~((e<<16|d)<<15)>>10^(e<<16|d)+~((e<<16|d)<<15))*9|0;n=(n>>6^n)+~((n>>6^n)<<11)>>16^(n>>6^n)+~((n>>6^n)<<11);m=c[b+12>>2]|0;f=c[(c[b+40>>2]|0)+((m+-1&n)<<2)>>2]|0;a:do if((f|0)!=-1){h=c[b+16>>2]|0;while(1){if((c[h+(f*12|0)>>2]|0)==(d|0)?(c[h+(f*12|0)+4>>2]|0)==(e|0):0)break;f=c[(c[b+60>>2]|0)+(f<<2)>>2]|0;if((f|0)==-1)break a}f=h+(f*12|0)|0;if(f){e=f;i=o;return e|0}}while(0);l=c[b+8>>2]|0;if((l|0)==(m|0)){h=(m|0)==0?1:m<<1;if((m|0)<(h|0)){if(!h){k=m;g=0}else{c[5108]=(c[5108]|0)+1;f=QE((h*12|3)+16|0)|0;if(!f)g=0;else{c[(f+19&-16)+-4>>2]=f;g=f+19&-16}k=c[b+8>>2]|0}if((k|0)>0){j=0;do{f=g+(j*12|0)|0;if(f){p=(c[b+16>>2]|0)+(j*12|0)|0;c[f+0>>2]=c[p+0>>2];c[f+4>>2]=c[p+4>>2];c[f+8>>2]=c[p+8>>2]}j=j+1|0}while((j|0)!=(k|0))}f=c[b+16>>2]|0;if(f){if(a[b+20>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[f+-4>>2]|0)}c[b+16>>2]=0}a[b+20>>0]=1;c[b+16>>2]=g;c[b+12>>2]=h;f=c[b+8>>2]|0}else{f=m;h=m}}else{f=l;h=m}c[b+8>>2]=f+1;g=c[b+16>>2]|0;if((m|0)<(h|0)){FD(b);f=(c[b+12>>2]|0)+-1&n}else f=m+-1&n;c[g+(l*12|0)>>2]=d;c[g+(l*12|0)+4>>2]=e;c[g+(l*12|0)+8>>2]=0;e=(c[b+40>>2]|0)+(f<<2)|0;c[(c[b+60>>2]|0)+(l<<2)>>2]=c[e>>2];c[e>>2]=l;e=g+(l*12|0)|0;i=o;return e|0}function MD(b){b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0;l=i;c[b>>2]=19992;d=c[b+56>>2]|0;if(d){if(a[b+60>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}c[b+56>>2]=0}a[b+60>>0]=1;c[b+56>>2]=0;c[b+48>>2]=0;c[b+52>>2]=0;d=c[b+28>>2]|0;if((d|0)>0){g=0;do{e=c[b+36>>2]|0;k=e+(g*36|0)+4|0;h=e+(g*36|0)+12|0;f=c[h>>2]|0;j=e+(g*36|0)+16|0;if(f){if(a[j>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[f+-4>>2]|0)}c[h>>2]=0}a[j>>0]=1;c[h>>2]=0;c[k>>2]=0;c[e+(g*36|0)+8>>2]=0;g=g+1|0}while((g|0)!=(d|0))}d=c[b+36>>2]|0;if(d){if(a[b+40>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}c[b+36>>2]=0}a[b+40>>0]=1;c[b+36>>2]=0;c[b+28>>2]=0;c[b+32>>2]=0;d=c[b+16>>2]|0;if(!d){a[b+20>>0]=1;c[b+16>>2]=0;c[b+8>>2]=0;d=b+12|0;c[d>>2]=0;i=l;return}if(a[b+20>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}c[b+16>>2]=0;a[b+20>>0]=1;c[b+16>>2]=0;c[b+8>>2]=0;d=b+12|0;c[d>>2]=0;i=l;return}function ND(a){a=a|0;var b=0;b=i;MD(a);if(!a){i=b;return}c[5110]=(c[5110]|0)+1;RE(c[a+-4>>2]|0);i=b;return}function OD(a){a=a|0;var b=0,d=0,e=0.0,f=0.0,h=0.0,j=0,k=0,l=0;l=i;b=c[a+28>>2]|0;if((b|0)<=0){b=1;i=l;return b|0}j=c[a+36>>2]|0;e=0.0;f=0.0;h=0.0;k=0;a:while(1){switch(k|0){case 1:{e=+g[a+80>>2]+ +g[a+64>>2];f=+g[a+72>>2]-+g[a+88>>2];h=+g[a+84>>2]+ +g[a+68>>2];break}case 6:{e=+g[a+64>>2]-+g[a+80>>2];f=+g[a+88>>2]+ +g[a+72>>2];h=+g[a+68>>2]-+g[a+84>>2];break}case 2:{e=+g[a+80>>2]+ +g[a+64>>2];f=+g[a+88>>2]+ +g[a+72>>2];h=+g[a+68>>2]-+g[a+84>>2];break}case 5:{e=+g[a+64>>2]-+g[a+80>>2];f=+g[a+72>>2]-+g[a+88>>2];h=+g[a+84>>2]+ +g[a+68>>2];break}case 4:{e=+g[a+64>>2]-+g[a+80>>2];f=+g[a+88>>2]+ +g[a+72>>2];h=+g[a+84>>2]+ +g[a+68>>2];break}case 3:{e=+g[a+80>>2]+ +g[a+64>>2];f=+g[a+72>>2]-+g[a+88>>2];h=+g[a+68>>2]-+g[a+84>>2];break}case 0:{e=+g[a+80>>2]+ +g[a+64>>2];f=+g[a+88>>2]+ +g[a+72>>2];h=+g[a+84>>2]+ +g[a+68>>2];break}case 7:{e=+g[a+64>>2]-+g[a+80>>2];f=+g[a+72>>2]-+g[a+88>>2];h=+g[a+68>>2]-+g[a+84>>2];break}default:{}}d=0;do{if(+g[j+(d*36|0)+32>>2]+(e*+g[j+(d*36|0)+20>>2]+h*+g[j+(d*36|0)+24>>2]+f*+g[j+(d*36|0)+28>>2])>0.0){b=0;d=16;break a}d=d+1|0}while((d|0)<(b|0));k=k+1|0;if((k|0)>=8){b=1;d=16;break}}if((d|0)==16){i=l;return b|0}return 0}function PD(a,b,d,e,f,h,j){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;var k=0.0,l=0.0,m=0,n=0.0,o=0.0,p=0,q=0,r=0.0,s=0;q=i;i=i+16|0;g[e>>2]=3402823466385288598117041.0e14;g[f>>2]=-3402823466385288598117041.0e14;m=c[a+8>>2]|0;if((m|0)>0){p=0;do{s=c[a+16>>2]|0;r=+g[s+(p<<4)>>2];k=+g[s+(p<<4)+4>>2];n=+g[s+(p<<4)+8>>2];l=r*+g[b>>2]+k*+g[b+4>>2]+n*+g[b+8>>2]+ +g[b+48>>2];o=r*+g[b+16>>2]+k*+g[b+20>>2]+n*+g[b+24>>2]+ +g[b+52>>2];n=r*+g[b+32>>2]+k*+g[b+36>>2]+n*+g[b+40>>2]+ +g[b+56>>2];k=l*+g[d>>2]+o*+g[d+4>>2]+n*+g[d+8>>2];if(k<+g[e>>2]){g[e>>2]=k;g[h>>2]=l;g[h+4>>2]=o;g[h+8>>2]=n;g[h+12>>2]=0.0}if(k>+g[f>>2]){g[f>>2]=k;g[j>>2]=l;g[j+4>>2]=o;g[j+8>>2]=n;g[j+12>>2]=0.0}p=p+1|0}while((p|0)!=(m|0));l=+g[f>>2]}else l=-3402823466385288598117041.0e14;k=+g[e>>2];if(!(k>l)){i=q;return}g[e>>2]=l;g[f>>2]=k;c[q+0>>2]=c[h+0>>2];c[q+4>>2]=c[h+4>>2];c[q+8>>2]=c[h+8>>2];c[q+12>>2]=c[h+12>>2];c[h+0>>2]=c[j+0>>2];c[h+4>>2]=c[j+4>>2];c[h+8>>2]=c[j+8>>2];c[h+12>>2]=c[j+12>>2];c[j+0>>2]=c[q+0>>2];c[j+4>>2]=c[q+4>>2];c[j+8>>2]=c[q+8>>2];c[j+12>>2]=c[q+12>>2];i=q;return}function QD(b){b=b|0;var d=0,e=0;e=i;c[b>>2]=20040;d=c[b+32>>2]|0;if(d){if(a[b+36>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}c[b+32>>2]=0}a[b+36>>0]=1;c[b+32>>2]=0;c[b+24>>2]=0;c[b+28>>2]=0;i=e;return}
function Vw(a,b){a=a|0;b=b|0;var d=0.0,e=0.0,f=0.0,h=0,i=0,j=0;j=c[a+68>>2]|0;i=c[a+64>>2]|0;h=c[a+72>>2]|0;e=+g[b+(j<<2)>>2]/+g[a+(j<<2)+12>>2]*+g[a+60>>2];g[a+60>>2]=e;f=+g[a+56>>2]*((+g[b+(i<<2)>>2]/+g[a+(i<<2)+12>>2]+ +g[b+(h<<2)>>2]/+g[a+(h<<2)+12>>2])*.5);g[a+56>>2]=f;g[a+52>>2]=f/+P(+(e*e+f*f));f=+O(+(+g[b>>2]));e=+O(+(+g[b+4>>2]));d=+O(+(+g[b+8>>2]));g[a+12>>2]=f;g[a+16>>2]=e;g[a+20>>2]=d;g[a+24>>2]=0.0;return}function Ww(a,b){a=a|0;b=b|0;g[a>>2]=1.0;g[a+4>>2]=0.0;g[a+8>>2]=0.0;g[a+12>>2]=0.0;return}function Xw(a){a=a|0;return 11960}function Yw(a){a=a|0;var b=0;b=i;if(!a){i=b;return}c[5110]=(c[5110]|0)+1;RE(c[a+-4>>2]|0);i=b;return}function Zw(a,b){a=a|0;b=b|0;g[a>>2]=0.0;g[a+4>>2]=0.0;g[a+8>>2]=1.0;g[a+12>>2]=0.0;return}function _w(a){a=a|0;return 11968}function $w(a){a=a|0;var b=0;b=i;if(!a){i=b;return}c[5110]=(c[5110]|0)+1;RE(c[a+-4>>2]|0);i=b;return}function ax(a,b,c){a=a|0;b=b|0;c=c|0;return}function bx(a){a=a|0;return 0}function cx(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,h=0;f=i;e=ec[c[(c[d>>2]|0)+40>>2]&31](d,a)|0;h=ec[c[(c[d>>2]|0)+28>>2]&31](d,e)|0;c[b>>2]=h;if(h)Lb[c[(c[d>>2]|0)+48>>2]&127](d,e);c[b+4>>2]=c[a+4>>2];g[b+28>>2]=+g[a+28>>2];g[b+32>>2]=+g[a+32>>2];g[b+36>>2]=+g[a+36>>2];g[b+40>>2]=+g[a+40>>2];g[b+12>>2]=+g[a+12>>2];g[b+16>>2]=+g[a+16>>2];g[b+20>>2]=+g[a+20>>2];g[b+24>>2]=+g[a+24>>2];g[b+44>>2]=+g[a+44>>2];c[b+52>>2]=c[a+68>>2];i=f;return 11976}function dx(a){a=a|0;return 60}function ex(a,b){a=a|0;b=b|0;g[a>>2]=0.0;g[a+4>>2]=1.0;g[a+8>>2]=0.0;g[a+12>>2]=0.0;return}function fx(a){a=a|0;return 11992}function gx(a,b,d){a=a|0;b=+b;d=d|0;var e=0,f=0.0,h=0.0,j=0.0,k=0.0,l=0;e=i;i=i+96|0;g[e+32>>2]=1.0;c[e+36>>2]=0;c[e+40>>2]=0;c[e+44>>2]=0;c[e+48>>2]=0;g[e+52>>2]=1.0;c[e+56>>2]=0;c[e+60>>2]=0;c[e+64>>2]=0;c[e+68>>2]=0;g[e+72>>2]=1.0;l=e+76|0;c[l+0>>2]=0;c[l+4>>2]=0;c[l+8>>2]=0;c[l+12>>2]=0;c[l+16>>2]=0;tc[c[(c[a>>2]|0)+8>>2]&127](a,e+32|0,e+16|0,e);j=(+g[e>>2]-+g[e+16>>2])*.5;h=(+g[e+4>>2]-+g[e+20>>2])*.5;k=(+g[e+8>>2]-+g[e+24>>2])*.5;f=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);g[d>>2]=b*.0833333283662796*((h+f)*2.0*((h+f)*2.0)+(k+f)*2.0*((k+f)*2.0));g[d+4>>2]=b*.0833333283662796*((j+f)*2.0*((j+f)*2.0)+(k+f)*2.0*((k+f)*2.0));g[d+8>>2]=b*.0833333283662796*((j+f)*2.0*((j+f)*2.0)+(h+f)*2.0*((h+f)*2.0));g[d+12>>2]=0.0;i=e;return}function hx(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0;f=i;tc[c[(c[a>>2]|0)+80>>2]&127](a,b,d,e);i=f;return}function ix(a){a=a|0;var b=0;b=i;if(!a){i=b;return}c[5110]=(c[5110]|0)+1;RE(c[a+-4>>2]|0);i=b;return}function jx(a,b,d){a=a|0;b=b|0;d=d|0;c[a+0>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;c[a+12>>2]=0;return}function kx(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0;b=i;if((e|0)>0)a=0;else{i=b;return}do{f=d+(a<<4)|0;a=a+1|0;c[f+0>>2]=0;c[f+4>>2]=0;c[f+8>>2]=0;c[f+12>>2]=0}while((a|0)!=(e|0));i=b;return}function lx(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0.0,h=0.0,j=0.0,k=0.0,l=0.0;e=i;i=i+16|0;pc[c[(c[b>>2]|0)+68>>2]&127](e,b,d);c[a+0>>2]=c[e+0>>2];c[a+4>>2]=c[e+4>>2];c[a+8>>2]=c[e+8>>2];c[a+12>>2]=c[e+12>>2];l=+g[d>>2];j=+g[d+4>>2];h=+g[d+8>>2];f=l*l+j*j+h*h<1.4210854715202004e-14?-1.0:h;k=l*l+j*j+h*h<1.4210854715202004e-14?-1.0:j;l=l*l+j*j+h*h<1.4210854715202004e-14?-1.0:l;h=1.0/+P(+(f*f+(l*l+k*k)));j=+Zb[c[(c[b>>2]|0)+48>>2]&15](b);g[a>>2]=h*l*j+ +g[a>>2];g[a+4>>2]=j*(h*k)+ +g[a+4>>2];g[a+8>>2]=j*(h*f)+ +g[a+8>>2];i=e;return}function mx(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0;f=i;k=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);j=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);h=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);m=+g[b+52>>2]-j;l=+g[b+56>>2]-h;g[d>>2]=+g[b+48>>2]-k;g[d+4>>2]=m;g[d+8>>2]=l;g[d+12>>2]=0.0;j=j+ +g[b+52>>2];h=h+ +g[b+56>>2];g[e>>2]=k+ +g[b+48>>2];g[e+4>>2]=j;g[e+8>>2]=h;g[e+12>>2]=0.0;i=f;return}function nx(a,b,d){a=a|0;b=+b;d=d|0;var e=0;e=i;b=b*.4000000059604645*+Zb[c[(c[a>>2]|0)+48>>2]&15](a);b=b*+Zb[c[(c[a>>2]|0)+48>>2]&15](a);g[d>>2]=b;g[d+4>>2]=b;g[d+8>>2]=b;g[d+12>>2]=0.0;i=e;return}function ox(a){a=a|0;return +(+g[a+28>>2]*+g[a+12>>2])}function px(a,b){a=a|0;b=+b;g[a+44>>2]=b;return}function qx(a){a=a|0;return 12136}function rx(a){a=a|0;var b=0;b=i;if(!a){i=b;return}c[5110]=(c[5110]|0)+1;RE(c[a+-4>>2]|0);i=b;return}function sx(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var h=0;h=i;Mx(b,d);c[b>>2]=12152;c[b+52>>2]=0;c[b+56>>2]=0;a[b+60>>0]=e&1;a[b+61>>0]=0;c[b+4>>2]=21;if(!f){i=h;return}c[5108]=(c[5108]|0)+1;f=QE(191)|0;if(!f)f=0;else{c[(f+19&-16)+-4>>2]=f;f=f+19&-16}c[f+52>>2]=282;a[f+60>>0]=0;a[f+80>>0]=1;c[f+76>>2]=0;c[f+68>>2]=0;c[f+72>>2]=0;a[f+100>>0]=1;c[f+96>>2]=0;c[f+88>>2]=0;c[f+92>>2]=0;a[f+120>>0]=1;c[f+116>>2]=0;c[f+108>>2]=0;c[f+112>>2]=0;a[f+140>>0]=1;c[f+136>>2]=0;c[f+128>>2]=0;c[f+132>>2]=0;c[f+144>>2]=0;a[f+164>>0]=1;c[f+160>>2]=0;c[f+152>>2]=0;c[f+156>>2]=0;c[f+168>>2]=0;g[f+4>>2]=-3402823466385288598117041.0e14;g[f+8>>2]=-3402823466385288598117041.0e14;g[f+12>>2]=-3402823466385288598117041.0e14;g[f+16>>2]=0.0;g[f+20>>2]=3402823466385288598117041.0e14;g[f+24>>2]=3402823466385288598117041.0e14;g[f+28>>2]=3402823466385288598117041.0e14;g[f+32>>2]=0.0;c[f>>2]=15088;c[b+52>>2]=f;Yz(f,c[b+48>>2]|0,(a[b+60>>0]|0)!=0,b+16|0,b+32|0);a[b+61>>0]=1;i=h;return}function tx(b){b=b|0;var d=0,e=0;d=i;c[b>>2]=12152;if(!(a[b+61>>0]|0)){i=d;return}e=c[b+52>>2]|0;Jb[c[c[e>>2]>>2]&255](e);b=c[b+52>>2]|0;if(!b){i=d;return}c[5110]=(c[5110]|0)+1;RE(c[b+-4>>2]|0);i=d;return}function ux(b){b=b|0;var d=0,e=0;e=i;c[b>>2]=12152;if(a[b+61>>0]|0){d=c[b+52>>2]|0;Jb[c[c[d>>2]>>2]&255](d);d=c[b+52>>2]|0;if(d){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}if(!b){i=e;return}}c[5110]=(c[5110]|0)+1;RE(c[b+-4>>2]|0);i=e;return}function vx(d,f,h,j){d=d|0;f=f|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0;w=i;i=i+80|0;v=c[d+48>>2]|0;c[w>>2]=12336;c[w+4>>2]=v;c[w+8>>2]=f;v=c[d+52>>2]|0;if(!(a[v+60>>0]|0)){f=c[v+56>>2]|0;if((f|0)>0){d=f;o=0;p=c[v+96>>2]|0;f=0;while(1){f=f+1|0;if(!(+g[h>>2]>+g[p+16>>2])?!(+g[j>>2]<+g[p>>2]):0)k=1;else k=0;if(!(!(+g[h+8>>2]>+g[p+24>>2])?!(+g[j+8>>2]<+g[p+8>>2]):0))k=0;if(!(+g[h+4>>2]>+g[p+20>>2])?!(+g[j+4>>2]<+g[p+4>>2]):0){l=c[p+32>>2]|0;if((l|0)==-1&k){pc[c[(c[w>>2]|0)+8>>2]&127](w,c[p+36>>2]|0,c[p+40>>2]|0);d=c[v+56>>2]|0;m=43}else{n=l;l=(l|0)==-1;m=42}}else{l=c[p+32>>2]|0;n=l;l=(l|0)==-1;k=0;m=42}if((m|0)==42){m=0;if(k|l)m=43;else{k=n+o|0;l=p+(n<<6)|0}}if((m|0)==43){k=o+1|0;l=p+64|0}if((k|0)<(d|0)){o=k;p=l}else break}}else f=0;if((c[4340]|0)>=(f|0)){i=w;return}c[4340]=f;i=w;return}z=+g[h>>2];D=+g[h+4>>2];H=+g[h+8>>2];G=+g[v+4>>2];z=z<G?G:z;C=+g[v+8>>2];D=D<C?C:D;y=+g[v+12>>2];H=H<y?y:H;I=+g[v+20>>2];E=+g[v+24>>2];A=+g[v+28>>2];F=+g[v+36>>2];B=+g[v+40>>2];x=+g[v+44>>2];t=~~(((I<z?I:z)-G)*F)&65534;b[w+66>>1]=t;u=~~(((E<D?E:D)-C)*B)&65534;b[w+68>>1]=u;s=~~(((A<H?A:H)-y)*x)&65534;b[w+70>>1]=s;H=+g[j>>2];D=+g[j+4>>2];z=+g[j+8>>2];H=H<G?G:H;D=D<C?C:D;z=z<y?y:z;q=(~~(((I<H?I:H)-G)*F+1.0)&65535|1)&65535;b[w+60>>1]=q;r=(~~(((E<D?E:D)-C)*B+1.0)&65535|1)&65535;b[w+62>>1]=r;j=(~~(((A<z?A:z)-y)*x+1.0)&65535|1)&65535;b[w+64>>1]=j;d=c[v+144>>2]|0;if(!d){o=c[v+56>>2]|0;if((o|0)>0){l=0;k=c[v+136>>2]|0;f=0;do{f=f+1|0;m=((q&65535)>=(e[k>>1]|0)?(t&65535)<=(e[k+6>>1]|0):0)&(s&65535)<=(e[k+10>>1]|0)&(j&65535)>=(e[k+4>>1]|0)&(u&65535)<=(e[k+8>>1]|0)&(r&65535)>=(e[k+2>>1]|0);n=k+12|0;d=c[n>>2]|0;if((d|0)>-1&m)pc[c[(c[w>>2]|0)+8>>2]&127](w,d>>21,d&2097151);if(m|(d|0)>-1){l=l+1|0;k=k+16|0}else{h=c[n>>2]|0;l=l-h|0;k=k+(0-h<<4)|0}}while((l|0)<(o|0))}else f=0;if((c[4340]|0)>=(f|0)){i=w;return}c[4340]=f;i=w;return}else if((d|0)==1){if((c[v+152>>2]|0)<=0){i=w;return}h=0;do{k=c[v+160>>2]|0;if(((q&65535)>=(e[k+(h<<5)>>1]|0)?(t&65535)<=(e[k+(h<<5)+6>>1]|0):0)&(s&65535)<=(e[k+(h<<5)+10>>1]|0)&(j&65535)>=(e[k+(h<<5)+4>>1]|0)&(u&65535)<=(e[k+(h<<5)+8>>1]|0)&(r&65535)>=(e[k+(h<<5)+2>>1]|0)){p=c[k+(h<<5)+12>>2]|0;o=c[k+(h<<5)+16>>2]|0;a:do if((o|0)>0){n=p;m=(c[v+136>>2]|0)+(p<<4)|0;k=1;while(1){d=((q&65535)>=(e[m>>1]|0)?(t&65535)<=(e[m+6>>1]|0):0)&(s&65535)<=(e[m+10>>1]|0)&(j&65535)>=(e[m+4>>1]|0)&(u&65535)<=(e[m+8>>1]|0)&(r&65535)>=(e[m+2>>1]|0);f=m+12|0;l=c[f>>2]|0;if((l|0)>-1&d)pc[c[(c[w>>2]|0)+8>>2]&127](w,l>>21,l&2097151);if(d|(l|0)>-1){n=n+1|0;m=m+16|0}else{l=c[f>>2]|0;n=n-l|0;m=m+(0-l<<4)|0}if((n|0)>=(o+p|0))break a;k=k+1|0}}else k=0;while(0);if((c[4340]|0)<(k|0))c[4340]=k}h=h+1|0}while((h|0)<(c[v+152>>2]|0));i=w;return}else if((d|0)==2){sC(c[v+136>>2]|0,w,w+66|0,w+60|0);i=w;return}else{i=w;return}}function wx(b,d){b=b|0;d=d|0;var e=0,f=0,h=0.0,j=0.0,k=0.0,l=0;f=i;l=Nb[c[(c[b>>2]|0)+28>>2]&127](b)|0;k=+g[l>>2]-+g[d>>2];j=+g[l+4>>2]-+g[d+4>>2];h=+g[l+8>>2]-+g[d+8>>2];if(!(k*k+j*j+h*h>1.1920928955078125e-07)){i=f;return}Qx(b,d);if((a[b+61>>0]|0)!=0?(e=c[b+52>>2]|0,Jb[c[c[e>>2]>>2]&255](e),e=c[b+52>>2]|0,(e|0)!=0):0){c[5110]=(c[5110]|0)+1;RE(c[e+-4>>2]|0)}c[5108]=(c[5108]|0)+1;e=QE(191)|0;if(!e)e=0;else{c[(e+19&-16)+-4>>2]=e;e=e+19&-16}c[e+52>>2]=282;a[e+60>>0]=0;a[e+80>>0]=1;c[e+76>>2]=0;c[e+68>>2]=0;c[e+72>>2]=0;a[e+100>>0]=1;c[e+96>>2]=0;c[e+88>>2]=0;c[e+92>>2]=0;a[e+120>>0]=1;c[e+116>>2]=0;c[e+108>>2]=0;c[e+112>>2]=0;a[e+140>>0]=1;c[e+136>>2]=0;c[e+128>>2]=0;c[e+132>>2]=0;c[e+144>>2]=0;a[e+164>>0]=1;c[e+160>>2]=0;c[e+152>>2]=0;c[e+156>>2]=0;c[e+168>>2]=0;g[e+4>>2]=-3402823466385288598117041.0e14;g[e+8>>2]=-3402823466385288598117041.0e14;g[e+12>>2]=-3402823466385288598117041.0e14;g[e+16>>2]=0.0;g[e+20>>2]=3402823466385288598117041.0e14;g[e+24>>2]=3402823466385288598117041.0e14;g[e+28>>2]=3402823466385288598117041.0e14;g[e+32>>2]=0.0;c[e>>2]=15088;c[b+52>>2]=e;Yz(e,c[b+48>>2]|0,(a[b+60>>0]|0)!=0,b+16|0,b+32|0);a[b+61>>0]=1;i=f;return}function xx(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,h=0,j=0;h=i;e=ec[c[(c[d>>2]|0)+40>>2]&31](d,a)|0;j=ec[c[(c[d>>2]|0)+28>>2]&31](d,e)|0;c[b>>2]=j;if(j)Lb[c[(c[d>>2]|0)+48>>2]&127](d,e);c[b+4>>2]=c[a+4>>2];e=c[a+48>>2]|0;Wb[c[(c[e>>2]|0)+56>>2]&63](e,b+12|0,d)|0;g[b+52>>2]=+g[a+12>>2];do if((c[a+52>>2]|0)!=0?((Nb[c[(c[d>>2]|0)+52>>2]&127](d)|0)&1|0)==0:0){e=ec[c[(c[d>>2]|0)+24>>2]&31](d,c[a+52>>2]|0)|0;if(!e){c[b+40>>2]=ec[c[(c[d>>2]|0)+28>>2]&31](d,c[a+52>>2]|0)|0;c[b+44>>2]=0;j=c[a+52>>2]|0;j=Nb[c[(c[j>>2]|0)+12>>2]&127](j)|0;j=Wb[c[(c[d>>2]|0)+16>>2]&63](d,j,1)|0;e=c[a+52>>2]|0;e=Wb[c[(c[e>>2]|0)+16>>2]&63](e,c[j+8>>2]|0,d)|0;Hb[c[(c[d>>2]|0)+20>>2]&31](d,j,e,1213612625,c[a+52>>2]|0);break}else{c[b+40>>2]=e;c[b+44>>2]=0;break}}else f=8;while(0);if((f|0)==8){c[b+40>>2]=0;c[b+44>>2]=0}if((c[a+56>>2]|0)!=0?((Nb[c[(c[d>>2]|0)+52>>2]&127](d)|0)&2|0)==0:0){e=ec[c[(c[d>>2]|0)+24>>2]&31](d,c[a+56>>2]|0)|0;if(!e){c[b+48>>2]=ec[c[(c[d>>2]|0)+28>>2]&31](d,c[a+56>>2]|0)|0;f=c[a+56>>2]|0;f=Nb[c[(c[f>>2]|0)+8>>2]&127](f)|0;f=Wb[c[(c[d>>2]|0)+16>>2]&63](d,f,1)|0;e=c[a+56>>2]|0;e=Wb[c[(c[e>>2]|0)+12>>2]&63](e,c[f+8>>2]|0,d)|0;Hb[c[(c[d>>2]|0)+20>>2]&31](d,f,e,1346456916,c[a+56>>2]|0);i=h;return 12240}else{c[b+48>>2]=e;i=h;return 12240}}c[b+48>>2]=0;i=h;return 12240}function yx(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;e=i;d=c[a+52>>2]|0;if(!d){i=e;return}f=Nb[c[(c[d>>2]|0)+12>>2]&127](d)|0;f=Wb[c[(c[b>>2]|0)+16>>2]&63](b,f,1)|0;d=c[a+52>>2]|0;d=Wb[c[(c[d>>2]|0)+16>>2]&63](d,c[f+8>>2]|0,b)|0;Hb[c[(c[b>>2]|0)+20>>2]&31](b,f,d,1213612625,c[a+52>>2]|0);i=e;return}function zx(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;e=i;d=c[a+56>>2]|0;if(!d){i=e;return}f=Nb[c[(c[d>>2]|0)+8>>2]&127](d)|0;f=Wb[c[(c[b>>2]|0)+16>>2]&63](b,f,1)|0;d=c[a+56>>2]|0;d=Wb[c[(c[d>>2]|0)+12>>2]&63](d,c[f+8>>2]|0,b)|0;Hb[c[(c[b>>2]|0)+20>>2]&31](b,f,d,1346456916,c[a+56>>2]|0);i=e;return}function Ax(a,b,d){a=a|0;b=b|0;d=d|0;var e=0;e=i;pc[c[(c[b>>2]|0)+68>>2]&127](a,b,d);i=e;return}function Bx(a){a=a|0;return 60}function Cx(a){a=a|0;return +(+g[a+12>>2])}function Dx(a,b){a=a|0;b=+b;g[a+12>>2]=b;return}function Ex(a){a=a|0;return 12312}function Fx(a,b,f){a=a|0;b=b|0;f=f|0;var j=0,k=0.0,l=0,m=0.0,n=0.0,o=0,p=0,q=0,r=0,s=0,t=0;t=i;i=i+32|0;p=c[a+4>>2]|0;dc[c[(c[p>>2]|0)+16>>2]&3](p,t+28|0,t+24|0,t+20|0,t+16|0,t+12|0,t+8|0,t+4|0,t,b);p=c[t+12>>2]|0;s=$(c[t+8>>2]|0,f)|0;q=c[a+4>>2]|0;o=c[t>>2]|0;r=2;while(1){if((o|0)==3)j=e[p+s+(r<<1)>>1]|0;else if((o|0)==2)j=c[p+s+(r<<2)>>2]|0;else j=d[p+(r+s)>>0]|0;l=c[t+28>>2]|0;j=$(c[t+16>>2]|0,j)|0;if(!(c[t+20>>2]|0)){m=+g[l+j>>2]*+g[q+4>>2];n=+g[l+(j+4)>>2]*+g[q+8>>2];k=+g[l+(j+8)>>2]*+g[q+12>>2]}else{m=+h[l+j>>3]*+g[q+4>>2];n=+h[l+(j+8)>>3]*+g[q+8>>2];k=+h[l+(j+16)>>3]*+g[q+12>>2]}g[a+(r<<4)+12>>2]=m;g[a+(r<<4)+16>>2]=n;g[a+(r<<4)+20>>2]=k;g[a+(r<<4)+24>>2]=0.0;if((r|0)>0)r=r+-1|0;else break}s=c[a+8>>2]|0;tc[c[(c[s>>2]|0)+8>>2]&127](s,a+12|0,b,f);a=c[a+4>>2]|0;Lb[c[(c[a>>2]|0)+24>>2]&127](a,b);i=t;return}function Gx(a){a=a|0;var b=0;b=i;RE(a);i=b;return}function Hx(a){a=a|0;return}function Ix(a,b,d){a=a|0;b=b|0;d=d|0;var f=0.0,j=0.0,k=0.0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0;s=i;i=i+80|0;n=c[a+4>>2]|0;dc[c[(c[n>>2]|0)+16>>2]&3](n,s+28|0,s+24|0,s+20|0,s+16|0,s+12|0,s+8|0,s+4|0,s,b);n=c[s+12>>2]|0;o=$(c[s+8>>2]|0,d)|0;q=c[a+4>>2]|0;p=(c[s+20>>2]|0)==0;r=c[s+28>>2]|0;if((c[s>>2]|0)!=3){l=c[s+16>>2]|0;m=$(l,c[n+(o+8)>>2]|0)|0;if(p){j=+g[r+(m+4)>>2]*+g[q+8>>2];f=+g[r+(m+8)>>2]*+g[q+12>>2];g[s+64>>2]=+g[r+m>>2]*+g[q+4>>2];g[s+68>>2]=j;g[s+72>>2]=f;g[s+76>>2]=0.0;p=$(l,c[n+(o+4)>>2]|0)|0;f=+g[r+(p+4)>>2]*+g[q+8>>2];j=+g[r+(p+8)>>2]*+g[q+12>>2];g[s+48>>2]=+g[r+p>>2]*+g[q+4>>2];g[s+52>>2]=f;g[s+56>>2]=j;g[s+60>>2]=0.0;p=$(l,c[n+o>>2]|0)|0;j=+g[r+(p+4)>>2]*+g[q+8>>2];f=+g[r+(p+8)>>2]*+g[q+12>>2];g[s+32>>2]=+g[r+p>>2]*+g[q+4>>2];g[s+36>>2]=j;g[s+40>>2]=f;g[s+44>>2]=0.0;r=a+8|0;r=c[r>>2]|0;q=c[r>>2]|0;q=q+8|0;q=c[q>>2]|0;tc[q&127](r,s+32|0,b,d);a=c[a+4>>2]|0;d=c[a>>2]|0;d=d+24|0;d=c[d>>2]|0;Lb[d&127](a,b);i=s;return}else{j=+h[r+(m+8)>>3]*+g[q+8>>2];f=+h[r+(m+16)>>3]*+g[q+12>>2];g[s+64>>2]=+h[r+m>>3]*+g[q+4>>2];g[s+68>>2]=j;g[s+72>>2]=f;g[s+76>>2]=0.0;p=$(l,c[n+(o+4)>>2]|0)|0;f=+h[r+(p+8)>>3]*+g[q+8>>2];j=+h[r+(p+16)>>3]*+g[q+12>>2];g[s+48>>2]=+h[r+p>>3]*+g[q+4>>2];g[s+52>>2]=f;g[s+56>>2]=j;g[s+60>>2]=0.0;p=$(l,c[n+o>>2]|0)|0;j=+h[r+(p+8)>>3]*+g[q+8>>2];f=+h[r+(p+16)>>3]*+g[q+12>>2];g[s+32>>2]=+h[r+p>>3]*+g[q+4>>2];g[s+36>>2]=j;g[s+40>>2]=f;g[s+44>>2]=0.0;r=a+8|0;r=c[r>>2]|0;q=c[r>>2]|0;q=q+8|0;q=c[q>>2]|0;tc[q&127](r,s+32|0,b,d);a=c[a+4>>2]|0;d=c[a>>2]|0;d=d+24|0;d=c[d>>2]|0;Lb[d&127](a,b);i=s;return}}l=c[s+16>>2]|0;m=$(l,e[n+(o+4)>>1]|0)|0;if(p){j=+g[r+m>>2]*+g[q+4>>2];f=+g[r+(m+4)>>2]*+g[q+8>>2];k=+g[r+(m+8)>>2]*+g[q+12>>2]}else{j=+h[r+m>>3]*+g[q+4>>2];f=+h[r+(m+8)>>3]*+g[q+8>>2];k=+h[r+(m+16)>>3]*+g[q+12>>2]}g[s+64>>2]=j;g[s+68>>2]=f;g[s+72>>2]=k;g[s+76>>2]=0.0;m=$(l,e[n+(o+2)>>1]|0)|0;if(p){j=+g[r+m>>2]*+g[q+4>>2];f=+g[r+(m+4)>>2]*+g[q+8>>2];k=+g[r+(m+8)>>2]*+g[q+12>>2]}else{j=+h[r+m>>3]*+g[q+4>>2];f=+h[r+(m+8)>>3]*+g[q+8>>2];k=+h[r+(m+16)>>3]*+g[q+12>>2]}g[s+48>>2]=j;g[s+52>>2]=f;g[s+56>>2]=k;g[s+60>>2]=0.0;l=$(l,e[n+o>>1]|0)|0;if(p){j=+g[r+l>>2]*+g[q+4>>2];k=+g[r+(l+4)>>2]*+g[q+8>>2];f=+g[r+(l+8)>>2]*+g[q+12>>2]}else{j=+h[r+l>>3]*+g[q+4>>2];k=+h[r+(l+8)>>3]*+g[q+8>>2];f=+h[r+(l+16)>>3]*+g[q+12>>2]}g[s+32>>2]=j;g[s+36>>2]=k;g[s+40>>2]=f;g[s+44>>2]=0.0;r=a+8|0;r=c[r>>2]|0;q=c[r>>2]|0;q=q+8|0;q=c[q>>2]|0;tc[q&127](r,s+32|0,b,d);a=c[a+4>>2]|0;d=c[a>>2]|0;d=d+24|0;d=c[d>>2]|0;Lb[d&127](a,b);i=s;return}function Jx(a){a=a|0;var b=0;b=i;RE(a);i=b;return}function Kx(a,b,d){a=a|0;b=b|0;d=d|0;var f=0,j=0.0,k=0.0,l=0.0,m=0,n=0,o=0,p=0,q=0,r=0,s=0;s=i;i=i+80|0;o=c[a+4>>2]|0;dc[c[(c[o>>2]|0)+16>>2]&3](o,s+28|0,s+24|0,s+20|0,s+16|0,s+12|0,s+8|0,s+4|0,s,b);o=(c[s+12>>2]|0)+($(c[s+8>>2]|0,d)|0)|0;m=c[a+4>>2]|0;p=(c[s>>2]|0)==3;q=(c[s+20>>2]|0)==0;n=c[s+28>>2]|0;r=2;while(1){if(p)f=e[o+(r<<1)>>1]|0;else f=c[o+(r<<2)>>2]|0;f=$(c[s+16>>2]|0,f)|0;if(q){k=+g[n+f>>2]*+g[m+4>>2];l=+g[n+(f+4)>>2]*+g[m+8>>2];j=+g[n+(f+8)>>2]*+g[m+12>>2]}else{k=+h[n+f>>3]*+g[m+4>>2];l=+h[n+(f+8)>>3]*+g[m+8>>2];j=+h[n+(f+16)>>3]*+g[m+12>>2]}g[s+32+(r<<4)>>2]=k;g[s+32+(r<<4)+4>>2]=l;g[s+32+(r<<4)+8>>2]=j;g[s+32+(r<<4)+12>>2]=0.0;if((r|0)>0)r=r+-1|0;else break}r=c[a+8>>2]|0;tc[c[(c[r>>2]|0)+8>>2]&127](r,s+32|0,b,d);a=c[a+4>>2]|0;Lb[c[(c[a>>2]|0)+24>>2]&127](a,b);i=s;return}function Lx(a){a=a|0;var b=0;b=i;RE(a);i=b;return}function Mx(a,b){a=a|0;b=b|0;var d=0;d=i;i=i+48|0;c[a+8>>2]=0;g[a+12>>2]=0.0;c[a>>2]=12824;c[a+48>>2]=b;c[a+4>>2]=21;if(Nb[c[(c[b>>2]|0)+40>>2]&127](b)|0){pc[c[(c[b>>2]|0)+48>>2]&127](b,a+16|0,a+32|0);i=d;return}else{c[d+32>>2]=0;c[d+36>>2]=0;c[d+40>>2]=0;c[d+44>>2]=0;g[d+32>>2]=1.0;pc[c[(c[a>>2]|0)+68>>2]&127](d+16|0,a,d+32|0);g[a+32>>2]=+g[d+16>>2]+ +g[a+12>>2];g[d+32>>2]=-1.0;pc[c[(c[a>>2]|0)+68>>2]&127](d,a,d+32|0);c[d+16>>2]=c[d+0>>2];c[d+20>>2]=c[d+4>>2];c[d+24>>2]=c[d+8>>2];c[d+28>>2]=c[d+12>>2];g[a+16>>2]=+g[d+16>>2]-+g[a+12>>2];c[d+32>>2]=0;c[d+36>>2]=0;c[d+40>>2]=0;c[d+44>>2]=0;g[d+36>>2]=1.0;pc[c[(c[a>>2]|0)+68>>2]&127](d+16|0,a,d+32|0);g[a+36>>2]=+g[d+20>>2]+ +g[a+12>>2];g[d+36>>2]=-1.0;pc[c[(c[a>>2]|0)+68>>2]&127](d,a,d+32|0);c[d+16>>2]=c[d+0>>2];c[d+20>>2]=c[d+4>>2];c[d+24>>2]=c[d+8>>2];c[d+28>>2]=c[d+12>>2];g[a+20>>2]=+g[d+20>>2]-+g[a+12>>2];c[d+32>>2]=0;c[d+36>>2]=0;c[d+40>>2]=0;c[d+44>>2]=0;g[d+40>>2]=1.0;pc[c[(c[a>>2]|0)+68>>2]&127](d+16|0,a,d+32|0);g[a+40>>2]=+g[d+24>>2]+ +g[a+12>>2];g[d+40>>2]=-1.0;pc[c[(c[a>>2]|0)+68>>2]&127](d,a,d+32|0);c[d+16>>2]=c[d+0>>2];c[d+20>>2]=c[d+4>>2];c[d+24>>2]=c[d+8>>2];c[d+28>>2]=c[d+12>>2];g[a+24>>2]=+g[d+24>>2]-+g[a+12>>2];i=d;return}}function Nx(a){a=a|0;return}function Ox(a){a=a|0;var b=0;b=i;if(!a){i=b;return}c[5110]=(c[5110]|0)+1;RE(c[a+-4>>2]|0);i=b;return}function Px(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0;f=i;q=(+g[a+32>>2]-+g[a+16>>2])*.5;n=(+g[a+36>>2]-+g[a+20>>2])*.5;k=(+g[a+40>>2]-+g[a+24>>2])*.5;p=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);m=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);k=k+ +Zb[c[(c[a>>2]|0)+48>>2]&15](a);D=(+g[a+32>>2]+ +g[a+16>>2])*.5;B=(+g[a+36>>2]+ +g[a+20>>2])*.5;z=(+g[a+40>>2]+ +g[a+24>>2])*.5;H=+g[b>>2];y=+O(+H);G=+g[b+4>>2];x=+O(+G);v=+g[b+8>>2];w=+O(+v);F=+g[b+16>>2];u=+O(+F);E=+g[b+20>>2];t=+O(+E);r=+g[b+24>>2];s=+O(+r);C=+g[b+32>>2];o=+O(+C);A=+g[b+36>>2];l=+O(+A);h=+g[b+40>>2];j=+O(+h);v=D*H+B*G+z*v+ +g[b+48>>2];r=D*F+B*E+z*r+ +g[b+52>>2];h=D*C+B*A+z*h+ +g[b+56>>2];g[d>>2]=v-((q+p)*y+(n+m)*x+k*w);g[d+4>>2]=r-((q+p)*u+(n+m)*t+k*s);g[d+8>>2]=h-((q+p)*o+(n+m)*l+k*j);g[d+12>>2]=0.0;g[e>>2]=(q+p)*y+(n+m)*x+k*w+v;g[e+4>>2]=(q+p)*u+(n+m)*t+k*s+r;g[e+8>>2]=(q+p)*o+(n+m)*l+k*j+h;g[e+12>>2]=0.0;i=f;return}function Qx(a,b){a=a|0;b=b|0;var d=0,e=0;d=i;i=i+48|0;e=(c[a+48>>2]|0)+4|0;c[e+0>>2]=c[b+0>>2];c[e+4>>2]=c[b+4>>2];c[e+8>>2]=c[b+8>>2];c[e+12>>2]=c[b+12>>2];c[d+32>>2]=0;c[d+36>>2]=0;c[d+40>>2]=0;c[d+44>>2]=0;g[d+32>>2]=1.0;pc[c[(c[a>>2]|0)+68>>2]&127](d+16|0,a,d+32|0);g[a+32>>2]=+g[d+16>>2]+ +g[a+12>>2];g[d+32>>2]=-1.0;pc[c[(c[a>>2]|0)+68>>2]&127](d,a,d+32|0);c[d+16>>2]=c[d+0>>2];c[d+20>>2]=c[d+4>>2];c[d+24>>2]=c[d+8>>2];c[d+28>>2]=c[d+12>>2];g[a+16>>2]=+g[d+16>>2]-+g[a+12>>2];c[d+32>>2]=0;c[d+36>>2]=0;c[d+40>>2]=0;c[d+44>>2]=0;g[d+36>>2]=1.0;pc[c[(c[a>>2]|0)+68>>2]&127](d+16|0,a,d+32|0);g[a+36>>2]=+g[d+20>>2]+ +g[a+12>>2];g[d+36>>2]=-1.0;pc[c[(c[a>>2]|0)+68>>2]&127](d,a,d+32|0);c[d+16>>2]=c[d+0>>2];c[d+20>>2]=c[d+4>>2];c[d+24>>2]=c[d+8>>2];c[d+28>>2]=c[d+12>>2];g[a+20>>2]=+g[d+20>>2]-+g[a+12>>2];c[d+32>>2]=0;c[d+36>>2]=0;c[d+40>>2]=0;c[d+44>>2]=0;g[d+40>>2]=1.0;pc[c[(c[a>>2]|0)+68>>2]&127](d+16|0,a,d+32|0);g[a+40>>2]=+g[d+24>>2]+ +g[a+12>>2];g[d+40>>2]=-1.0;pc[c[(c[a>>2]|0)+68>>2]&127](d,a,d+32|0);c[d+16>>2]=c[d+0>>2];c[d+20>>2]=c[d+4>>2];c[d+24>>2]=c[d+8>>2];c[d+28>>2]=c[d+12>>2];g[a+24>>2]=+g[d+24>>2]-+g[a+12>>2];i=d;return}function Rx(a){a=a|0;return (c[a+48>>2]|0)+4|0}function Sx(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0;f=i;i=i+48|0;c[f>>2]=13032;c[f+4>>2]=b;c[f+8>>2]=c[d+0>>2];c[f+12>>2]=c[d+4>>2];c[f+16>>2]=c[d+8>>2];c[f+20>>2]=c[d+12>>2];c[f+24>>2]=c[e+0>>2];c[f+28>>2]=c[e+4>>2];c[f+32>>2]=c[e+8>>2];c[f+36>>2]=c[e+12>>2];b=c[a+48>>2]|0;tc[c[(c[b>>2]|0)+8>>2]&127](b,f,d,e);i=f;return}function Tx(a,b,d){a=a|0;b=+b;d=d|0;c[d+0>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;return}function Ux(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0.0,h=0.0,j=0.0,k=0.0,l=0.0;e=i;i=i+176|0;c[e+160>>2]=0;c[e+164>>2]=0;c[e+168>>2]=0;c[e+172>>2]=0;c[e+136>>2]=0;c[e+140>>2]=0;c[e+144>>2]=0;c[e+148>>2]=0;c[e+152>>2]=0;c[e+32>>2]=12968;c[e+36>>2]=0;c[e+40>>2]=0;c[e+44>>2]=0;c[e+48>>2]=0;g[e+52>>2]=1.0;c[e+56>>2]=c[e+160>>2];c[e+60>>2]=c[e+164>>2];c[e+64>>2]=c[e+168>>2];c[e+68>>2]=0;g[e+72>>2]=1.0;c[e+76>>2]=0;c[e+80>>2]=0;c[e+84>>2]=0;c[e+88>>2]=0;g[e+92>>2]=1.0;g[e+96>>2]=0.0;c[e+100>>2]=c[e+140>>2];c[e+104>>2]=c[e+144>>2];c[e+108>>2]=c[e+148>>2];c[e+112>>2]=c[e+152>>2];g[e+116>>2]=-999999984306749440.0;l=+g[d>>2];k=+g[d+4>>2];j=+g[d+8>>2];h=l*+g[e+56>>2]+k+j*0.0;f=l*+g[e+60>>2]+k*0.0+j;g[e+120>>2]=l+k*0.0+j*0.0;g[e+124>>2]=h;g[e+128>>2]=f;g[e+132>>2]=0.0;g[e+16>>2]=999999984306749440.0;g[e+20>>2]=999999984306749440.0;g[e+24>>2]=999999984306749440.0;g[e+28>>2]=0.0;d=c[(c[b>>2]|0)+64>>2]|0;g[e>>2]=-999999984306749440.0;g[e+4>>2]=-999999984306749440.0;g[e+8>>2]=-999999984306749440.0;g[e+12>>2]=0.0;tc[d&127](b,e+32|0,e,e+16|0);c[a+0>>2]=c[e+36>>2];c[a+4>>2]=c[e+40>>2];c[a+8>>2]=c[e+44>>2];c[a+12>>2]=c[e+48>>2];i=e;return}function Vx(a){a=a|0;return 12}function Wx(a){a=a|0;return 12944}function Xx(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0.0,h=0.0,j=0.0,k=0.0,l=0.0;e=i;j=+g[a+88>>2];k=+g[a+92>>2];l=+g[a+96>>2];f=j*+g[b>>2]+k*+g[b+4>>2]+l*+g[b+8>>2];h=+g[a+84>>2];if(f>h){g[a+84>>2]=f;c[a+4>>2]=c[b+0>>2];c[a+8>>2]=c[b+4>>2];c[a+12>>2]=c[b+8>>2];c[a+16>>2]=c[b+12>>2]}else f=h;h=j*+g[b+16>>2]+k*+g[b+20>>2]+l*+g[b+24>>2];if(h>f){g[a+84>>2]=h;c[a+4>>2]=c[b+16>>2];c[a+8>>2]=c[b+20>>2];c[a+12>>2]=c[b+24>>2];c[a+16>>2]=c[b+28>>2]}else h=f;f=j*+g[b+32>>2]+k*+g[b+36>>2]+l*+g[b+40>>2];if(!(f>h)){i=e;return}g[a+84>>2]=f;c[a+4>>2]=c[b+32>>2];c[a+8>>2]=c[b+36>>2];c[a+12>>2]=c[b+40>>2];c[a+16>>2]=c[b+44>>2];i=e;return}function Yx(a){a=a|0;var b=0;b=i;RE(a);i=b;return}function Zx(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0.0,h=0.0,j=0.0,k=0,l=0.0,m=0;k=i;f=+g[b>>2];h=+g[b+16>>2];l=f<h?f:h;j=+g[b+32>>2];if((l<j?l:j)>+g[a+24>>2]){i=k;return}m=f>h?b:b+16|0;if(+g[(+g[m>>2]>j?m:b+32|0)>>2]<+g[a+8>>2]){i=k;return}j=+g[b+8>>2];h=+g[b+24>>2];l=j<h?j:h;f=+g[b+40>>2];if((l<f?l:f)>+g[a+32>>2]){i=k;return}m=j>h?b+8|0:b+24|0;if(+g[(+g[m>>2]>f?m:b+40|0)>>2]<+g[a+16>>2]){i=k;return}h=+g[b+4>>2];f=+g[b+20>>2];l=h<f?h:f;j=+g[b+36>>2];if((l<j?l:j)>+g[a+28>>2]){i=k;return}m=h>f?b+4|0:b+20|0;if(+g[(+g[m>>2]>j?m:b+36|0)>>2]<+g[a+12>>2]){i=k;return}a=c[a+4>>2]|0;tc[c[(c[a>>2]|0)+8>>2]&127](a,b,d,e);i=k;return}function _x(a){a=a|0;var b=0;b=i;RE(a);i=b;return}function $x(a){a=a|0;return}function ay(a){a=a|0;var b=0;b=i;if(!a){i=b;return}c[5110]=(c[5110]|0)+1;RE(c[a+-4>>2]|0);i=b;return}function by(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;g[c>>2]=-999999984306749440.0;g[c+4>>2]=-999999984306749440.0;g[c+8>>2]=-999999984306749440.0;g[c+12>>2]=0.0;g[d>>2]=999999984306749440.0;g[d+4>>2]=999999984306749440.0;g[d+8>>2]=999999984306749440.0;g[d+12>>2]=0.0;return}function cy(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0.0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0,y=0.0;x=i;i=i+48|0;t=+g[e>>2];u=+g[d>>2];v=+g[e+4>>2];w=+g[d+4>>2];s=+g[e+8>>2];h=+g[d+8>>2];l=+P(+((t-u)*.5*((t-u)*.5)+(v-w)*.5*((v-w)*.5)+(s-h)*.5*((s-h)*.5)));j=+g[a+56>>2];e=+O(+j)>.7071067690849304;k=+g[a+52>>2];if(e){r=1.0/+P(+(j*j+k*k));y=+g[a+48>>2];f=y;m=y*-(j*r);n=0.0;o=k*r;p=-(j*r);q=(j*j+k*k)*r;r=-(y*(k*r))}else{q=+g[a+48>>2];r=1.0/+P(+(q*q+k*k));f=q;m=(q*q+k*k)*r;n=-(k*r);o=0.0;p=q*r;q=-(j*(q*r));r=j*-(k*r)}y=(t+u)*.5*f+(v+w)*.5*k+(s+h)*.5*j-+g[a+64>>2];f=(t+u)*.5-f*y;t=l*n;n=l*p;p=l*o;u=l*q;o=l*r;q=l*m;g[x>>2]=u+(t+f);g[x+4>>2]=o+(n+((v+w)*.5-k*y));g[x+8>>2]=q+(p+((s+h)*.5-j*y));g[x+12>>2]=0.0;g[x+16>>2]=t+f-u;g[x+20>>2]=n+((v+w)*.5-k*y)-o;g[x+24>>2]=p+((s+h)*.5-j*y)-q;g[x+28>>2]=0.0;g[x+32>>2]=f-t-u;g[x+36>>2]=(v+w)*.5-k*y-n-o;g[x+40>>2]=(s+h)*.5-j*y-p-q;g[x+44>>2]=0.0;tc[c[(c[b>>2]|0)+8>>2]&127](b,x,0,0);g[x>>2]=f-t-u;g[x+4>>2]=(v+w)*.5-k*y-n-o;g[x+8>>2]=(s+h)*.5-j*y-p-q;g[x+12>>2]=0.0;g[x+16>>2]=u+(f-t);g[x+20>>2]=o+((v+w)*.5-k*y-n);g[x+24>>2]=q+((s+h)*.5-j*y-p);g[x+28>>2]=0.0;g[x+32>>2]=u+(t+f);g[x+36>>2]=o+(n+((v+w)*.5-k*y));g[x+40>>2]=q+(p+((s+h)*.5-j*y));g[x+44>>2]=0.0;tc[c[(c[b>>2]|0)+8>>2]&127](b,x,0,1);i=x;return}function dy(a,b,d){a=a|0;b=+b;d=d|0;c[d+0>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;return}function ey(a,b){a=a|0;b=b|0;c[a+68>>2]=c[b+0>>2];c[a+72>>2]=c[b+4>>2];c[a+76>>2]=c[b+8>>2];c[a+80>>2]=c[b+12>>2];return}function fy(a){a=a|0;return a+68|0}function gy(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,h=0;f=i;e=ec[c[(c[d>>2]|0)+40>>2]&31](d,a)|0;h=ec[c[(c[d>>2]|0)+28>>2]&31](d,e)|0;c[b>>2]=h;if(h)Lb[c[(c[d>>2]|0)+48>>2]&127](d,e);c[b+4>>2]=c[a+4>>2];g[b+12>>2]=+g[a+68>>2];g[b+16>>2]=+g[a+72>>2];g[b+20>>2]=+g[a+76>>2];g[b+24>>2]=+g[a+80>>2];g[b+28>>2]=+g[a+48>>2];g[b+32>>2]=+g[a+52>>2];g[b+36>>2]=+g[a+56>>2];g[b+40>>2]=+g[a+60>>2];g[b+44>>2]=+g[a+64>>2];i=f;return 13288}function hy(a){a=a|0;return 52}function iy(a){a=a|0;return 13312}function jy(a){a=a|0;var b=0,d=0;d=i;c[a>>2]=13336;b=c[a+52>>2]|0;if(b){Jb[c[c[b>>2]>>2]&255](b);b=c[a+52>>2]|0;if(b){c[5110]=(c[5110]|0)+1;RE(c[b+-4>>2]|0)}if(!a){i=d;return}}c[5110]=(c[5110]|0)+1;RE(c[a+-4>>2]|0);i=d;return}function ky(d,f){d=d|0;f=f|0;var h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0.0,F=0.0,G=0.0,H=0,I=0.0,J=0,K=0,L=0,M=0,N=0,Q=0,R=0,S=0,T=0,U=0.0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0,ca=0,da=0,ea=0,fa=0.0,ga=0.0;ea=i;i=i+320|0;h=c[d+52>>2]|0;if((h|0)!=0?(Jb[c[c[h>>2]>>2]&255](h),j=c[d+52>>2]|0,(j|0)!=0):0){c[5110]=(c[5110]|0)+1;RE(c[j+-4>>2]|0)}c[5108]=(c[5108]|0)+1;h=QE(151)|0;if(!h)h=0;else{c[(h+19&-16)+-4>>2]=h;h=h+19&-16}c[h>>2]=19992;a[h+20>>0]=1;c[h+16>>2]=0;c[h+8>>2]=0;c[h+12>>2]=0;a[h+40>>0]=1;c[h+36>>2]=0;c[h+28>>2]=0;c[h+32>>2]=0;a[h+60>>0]=1;c[h+56>>2]=0;c[h+48>>2]=0;c[h+52>>2]=0;c[d+52>>2]=h;j=0;J=0;da=0;k=0;while(1){if((j|0)>=(Nb[c[(c[d>>2]|0)+96>>2]&127](d)|0))break;if((J|0)==(k|0)){o=(k|0)==0?1:k<<1;if((k|0)<(o|0)){if((o|0)!=0?(c[5108]=(c[5108]|0)+1,w=QE((o<<4|3)+16|0)|0,(w|0)!=0):0){c[(w+19&-16)+-4>>2]=w;m=w+19&-16}else m=0;if((k|0)>0){n=0;do{N=m+(n<<4)|0;M=da+(n<<4)|0;c[N+0>>2]=c[M+0>>2];c[N+4>>2]=c[M+4>>2];c[N+8>>2]=c[M+8>>2];c[N+12>>2]=c[M+12>>2];n=n+1|0}while((n|0)!=(k|0))}if(!da){l=k;n=m}else{c[5110]=(c[5110]|0)+1;RE(c[da+-4>>2]|0);l=k;n=m}}else{l=k;n=da;o=k}}else{l=J;n=da;o=k}da=n+(J<<4)|0;c[da+0>>2]=c[ea+192>>2];c[da+4>>2]=c[ea+196>>2];c[da+8>>2]=c[ea+200>>2];c[da+12>>2]=c[ea+204>>2];pc[c[(c[d>>2]|0)+108>>2]&127](d,j,da);j=j+1|0;J=l+1|0;da=n;k=o}a[ea+148>>0]=1;ca=ea+144|0;c[ca>>2]=0;c[ea+136>>2]=0;c[ea+140>>2]=0;a[ea+168>>0]=1;ba=ea+164|0;c[ba>>2]=0;c[ea+156>>2]=0;c[ea+160>>2]=0;a[ea+188>>0]=1;aa=ea+184|0;c[aa>>2]=0;c[ea+176>>2]=0;c[ea+180>>2]=0;if(f){if((J|0)>0){x=0;n=0;m=0;l=0;while(1){o=x;x=x+1|0;if((x|0)<(J|0)){w=da+(o<<4)|0;f=da+(o<<4)+4|0;k=da+(o<<4)+8|0;H=x;o=m;do{m=H;H=H+1|0;if((H|0)<(J|0)){h=da+(m<<4)|0;j=da+(m<<4)+4|0;z=da+(m<<4)+8|0;y=H;do{t=+g[w>>2];s=+g[h>>2]-t;p=+g[f>>2];I=+g[j>>2]-p;r=+g[k>>2];q=+g[z>>2]-r;t=+g[da+(y<<4)>>2]-t;p=+g[da+(y<<4)+4>>2]-p;r=+g[da+(y<<4)+8>>2]-r;F=1.0;A=0;while(1){E=(I*r-q*p)*F;u=(q*t-s*r)*F;v=(s*p-I*t)*F;a:do if(v*v+(E*E+u*u)>9.999999747378752e-05){F=1.0/+P(+(v*v+(E*E+u*u)));if((n|0)>0){D=0;do{if(E*F*+g[l+(D<<4)>>2]+u*F*+g[l+(D<<4)+4>>2]+v*F*+g[l+(D<<4)+8>>2]>.9990000128746033)break a;D=D+1|0}while((D|0)<(n|0))}G=E*F*+g[w>>2]+u*F*+g[f>>2]+v*F*+g[k>>2];D=0;do{if(E*F*+g[da+(D<<4)>>2]+u*F*+g[da+(D<<4)+4>>2]+v*F*+g[da+(D<<4)+8>>2]-G+-.009999999776482582>0.0)break a;D=D+1|0}while((D|0)<(J|0));do if((n|0)==(o|0)){C=(o|0)==0?1:o<<1;if((o|0)<(C|0)){do if(!C)B=0;else{c[5108]=(c[5108]|0)+1;D=QE((C<<4|3)+16|0)|0;if(!D){B=0;break}c[(D+19&-16)+-4>>2]=D;B=D+19&-16}while(0);if((o|0)>0){D=0;do{N=B+(D<<4)|0;M=l+(D<<4)|0;c[N+0>>2]=c[M+0>>2];c[N+4>>2]=c[M+4>>2];c[N+8>>2]=c[M+8>>2];c[N+12>>2]=c[M+12>>2];D=D+1|0}while((D|0)!=(o|0))}if(!l){D=o;o=C;l=B;break}c[5110]=(c[5110]|0)+1;RE(c[l+-4>>2]|0);D=o;o=C;l=B}else D=o}else D=n;while(0);g[l+(D<<4)>>2]=E*F;g[l+(D<<4)+4>>2]=u*F;g[l+(D<<4)+8>>2]=v*F;g[l+(D<<4)+12>>2]=-G;n=n+1|0}while(0);A=A+1|0;if((A|0)==2)break;else F=-1.0}y=y+1|0}while((y|0)!=(J|0))}}while((H|0)!=(J|0))}else o=m;if((x|0)==(J|0))break;else m=o}if((n|0)>0){w=0;j=0;h=0;while(1){N=l+(w<<4)|0;c[ea+120>>2]=c[N+0>>2];c[ea+124>>2]=c[N+4>>2];c[ea+128>>2]=c[N+8>>2];v=+g[l+(w<<4)+12>>2];v=v-+Zb[c[(c[d>>2]|0)+48>>2]&15](d);if((w|0)==(j|0)){k=(j|0)==0?1:j<<1;if((j|0)<(k|0)){if((k|0)!=0?(c[5108]=(c[5108]|0)+1,K=QE((k<<4|3)+16|0)|0,(K|0)!=0):0){c[(K+19&-16)+-4>>2]=K;m=K+19&-16}else m=0;if((j|0)>0){o=0;do{N=m+(o<<4)|0;M=h+(o<<4)|0;c[N+0>>2]=c[M+0>>2];c[N+4>>2]=c[M+4>>2];c[N+8>>2]=c[M+8>>2];c[N+12>>2]=c[M+12>>2];o=o+1|0}while((o|0)!=(j|0))}if(!h)o=j;else{c[5110]=(c[5110]|0)+1;RE(c[h+-4>>2]|0);o=j}}else{o=j;k=j;m=h}}else{o=w;k=j;m=h}N=m+(o<<4)|0;c[N+0>>2]=c[ea+120>>2];c[N+4>>2]=c[ea+124>>2];c[N+8>>2]=c[ea+128>>2];g[m+(o<<4)+12>>2]=v;w=w+1|0;if((w|0)<(n|0)){j=k;h=m}else break}if((w|0)>0){h=0;n=0;o=0;k=0;do{z=h;h=h+1|0;if((h|0)<(w|0)){y=h;do{B=y;y=y+1|0;if((y|0)<(w|0)){A=y;D=o;C=k;while(1){s=+g[m+(B<<4)+4>>2];v=+g[m+(A<<4)+8>>2];u=+g[m+(B<<4)+8>>2];r=+g[m+(A<<4)+4>>2];q=+g[m+(A<<4)>>2];p=+g[m+(B<<4)>>2];t=+g[m+(z<<4)+8>>2];E=+g[m+(z<<4)+4>>2];F=+g[m+(z<<4)>>2];b:do if((((r*p-s*q)*(r*p-s*q)+((s*v-u*r)*(s*v-u*r)+(u*q-v*p)*(u*q-v*p))>9.999999747378752e-05?(q*E-r*F)*(q*E-r*F)+((r*t-v*E)*(r*t-v*E)+(v*F-q*t)*(v*F-q*t))>9.999999747378752e-05:0)?(s*F-p*E)*(s*F-p*E)+((u*E-s*t)*(u*E-s*t)+(p*t-u*F)*(p*t-u*F))>9.999999747378752e-05:0)?(U=t*(r*p-s*q)+(E*(u*q-v*p)+(s*v-u*r)*F),+O(+U)>9.999999974752427e-07):0){fa=+g[m+(z<<4)+12>>2];I=+g[m+(B<<4)+12>>2];ga=+g[m+(A<<4)+12>>2];G=-1.0/U*((u*E-s*t)*ga+((s*v-u*r)*fa+(r*t-v*E)*I));v=-1.0/U*((p*t-u*F)*ga+((u*q-v*p)*fa+(v*F-q*t)*I));F=-1.0/U*((s*F-p*E)*ga+((r*p-s*q)*fa+(q*E-r*F)*I));o=0;do{if(+g[m+(o<<4)+12>>2]+(G*+g[m+(o<<4)>>2]+v*+g[m+(o<<4)+4>>2]+F*+g[m+(o<<4)+8>>2])+-.009999999776482582>0.0){o=D;k=C;break b}o=o+1|0}while((o|0)<(w|0));do if((n|0)==(C|0)){k=(C|0)==0?1:C<<1;if((C|0)>=(k|0)){x=C;o=D;k=C;break}do if(!k)o=0;else{c[5108]=(c[5108]|0)+1;o=QE((k<<4|3)+16|0)|0;if(!o){o=0;break}c[(o+19&-16)+-4>>2]=o;o=o+19&-16}while(0);if((C|0)>0){f=0;do{N=o+(f<<4)|0;M=D+(f<<4)|0;c[N+0>>2]=c[M+0>>2];c[N+4>>2]=c[M+4>>2];c[N+8>>2]=c[M+8>>2];c[N+12>>2]=c[M+12>>2];f=f+1|0}while((f|0)!=(C|0))}if(!D){x=C;break}c[5110]=(c[5110]|0)+1;RE(c[D+-4>>2]|0);x=C}else{x=n;o=D;k=C}while(0);g[o+(x<<4)>>2]=G;g[o+(x<<4)+4>>2]=v;g[o+(x<<4)+8>>2]=F;g[o+(x<<4)+12>>2]=0.0;n=n+1|0}else{o=D;k=C}while(0);A=A+1|0;if((A|0)==(w|0))break;else{D=o;C=k}}}}while((y|0)!=(w|0))}}while((h|0)!=(w|0))}else{n=0;o=0}}else{m=0;n=0;o=0}}else{l=0;m=0;n=0;o=0}hE(ea+132|0,o,n);if(o){c[5110]=(c[5110]|0)+1;RE(c[o+-4>>2]|0)}if(m){c[5110]=(c[5110]|0)+1;RE(c[m+-4>>2]|0)}if(l){c[5110]=(c[5110]|0)+1;RE(c[l+-4>>2]|0)}}else hE(ea+132|0,da,J);H=c[ea+176>>2]|0;if((H|0)>0&((H|0)<0^1)){c[5108]=(c[5108]|0)+1;j=QE((H<<4|3)+16|0)|0;if(!j)o=0;else{c[(j+19&-16)+-4>>2]=j;o=j+19&-16}l=0;do{N=o+(l<<4)|0;c[N+0>>2]=c[ea+104>>2];c[N+4>>2]=c[ea+108>>2];c[N+8>>2]=c[ea+112>>2];c[N+12>>2]=c[ea+116>>2];l=l+1|0}while((l|0)!=(H|0));Z=o}else Z=0;a[ea+96>>0]=1;X=ea+92|0;c[X>>2]=0;Y=ea+84|0;c[Y>>2]=0;c[ea+88>>2]=0;A=ea+291|0;C=A+19|0;do{a[A>>0]=0;A=A+1|0}while((A|0)<(C|0));if((H|0)<0)Eb();if((H|0)>0){ry(ea+80|0,H);n=c[X>>2]|0;m=0;do{o=n+(m*36|0)|0;if(o){a[o+16>>0]=1;c[o+4>>2]=0;c[o+8>>2]=0;c[o+12>>2]=0;A=o+20|0;D=ea+294|0;C=A+16|0;do{a[A>>0]=a[D>>0]|0;A=A+1|0;D=D+1|0}while((A|0)<(C|0))}m=m+1|0}while((m|0)!=(H|0))}c[Y>>2]=H;k=c[ea+136>>2]|0;w=c[d+52>>2]|0;l=c[w+8>>2]|0;if((l|0)<(k|0)){if((c[w+12>>2]|0)<(k|0)){if(!k){n=l;m=0}else{c[5108]=(c[5108]|0)+1;o=QE((k<<4|3)+16|0)|0;if(!o)o=0;else{c[(o+19&-16)+-4>>2]=o;o=o+19&-16}n=c[w+8>>2]|0;m=o}if((n|0)>0){o=0;do{N=m+(o<<4)|0;M=(c[w+16>>2]|0)+(o<<4)|0;c[N+0>>2]=c[M+0>>2];c[N+4>>2]=c[M+4>>2];c[N+8>>2]=c[M+8>>2];c[N+12>>2]=c[M+12>>2];o=o+1|0}while((o|0)!=(n|0))}o=c[w+16>>2]|0;if(o){if(a[w+20>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[o+-4>>2]|0)}c[w+16>>2]=0}a[w+20>>0]=1;c[w+16>>2]=m;c[w+12>>2]=k;n=w+16|0}else n=w+16|0;o=l;do{N=(c[n>>2]|0)+(o<<4)|0;c[N+0>>2]=c[ea+64>>2];c[N+4>>2]=c[ea+68>>2];c[N+8>>2]=c[ea+72>>2];c[N+12>>2]=c[ea+76>>2];o=o+1|0}while((o|0)!=(k|0))}c[w+8>>2]=k;if((k|0)>0){o=0;do{N=(c[(c[d+52>>2]|0)+16>>2]|0)+(o<<4)|0;M=(c[ca>>2]|0)+(o<<4)|0;c[N+0>>2]=c[M+0>>2];c[N+4>>2]=c[M+4>>2];c[N+8>>2]=c[M+8>>2];c[N+12>>2]=c[M+12>>2];o=o+1|0}while((o|0)!=(k|0))}if((H|0)>0){j=0;do{z=(c[ba>>2]|0)+((c[(c[aa>>2]|0)+(j<<2)>>2]|0)*12|0)|0;y=z;n=0;do{h=y+4|0;A=c[y+((c[h>>2]|0)*12|0)+8>>2]|0;C=c[X>>2]|0;B=C+(j*36|0)+4|0;o=c[B>>2]|0;D=C+(j*36|0)+8|0;if((o|0)==(c[D>>2]|0)?(V=(o|0)==0?1:o<<1,(o|0)<(V|0)):0){if(!V)m=0;else{c[5108]=(c[5108]|0)+1;o=QE((V<<2|3)+16|0)|0;if(!o)m=0;else{c[(o+19&-16)+-4>>2]=o;m=o+19&-16}o=c[B>>2]|0}x=C+(j*36|0)+12|0;if((o|0)>0){w=0;do{f=m+(w<<2)|0;if(f)c[f>>2]=c[(c[x>>2]|0)+(w<<2)>>2];w=w+1|0}while((w|0)!=(o|0))}o=c[x>>2]|0;f=C+(j*36|0)+16|0;if(o){if(a[f>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[o+-4>>2]|0)}c[x>>2]=0}a[f>>0]=1;c[x>>2]=m;c[D>>2]=V;o=c[B>>2]|0}m=(c[C+(j*36|0)+12>>2]|0)+(o<<2)|0;if(m){c[m>>2]=A;o=c[B>>2]|0}c[B>>2]=o+1;M=c[y+8>>2]|0;N=c[ca>>2]|0;v=+g[N+(M<<4)>>2]-+g[N+(A<<4)>>2];u=+g[N+(M<<4)+4>>2]-+g[N+(A<<4)+4>>2];s=+g[N+(M<<4)+8>>2]-+g[N+(A<<4)+8>>2];t=1.0/+P(+(v*v+u*u+s*s));if((n|0)<2){g[ea+224+(n<<4)>>2]=v*t;g[ea+224+(n<<4)+4>>2]=u*t;g[ea+224+(n<<4)+8>>2]=s*t;g[ea+224+(n<<4)+12>>2]=0.0;n=n+1|0}N=c[h>>2]|0;y=y+(((c[y+(N*12|0)>>2]|0)+N|0)*12|0)|0}while((y|0)!=(z|0));o=Z+(j<<4)|0;if((n|0)==2){u=+g[ea+228>>2];E=+g[ea+248>>2];v=+g[ea+232>>2];F=+g[ea+244>>2];t=+g[ea+240>>2];s=+g[ea+224>>2];M=Z+(j<<4)+4|0;N=Z+(j<<4)+8|0;g[Z+(j<<4)+12>>2]=0.0;G=1.0/+P(+((u*E-v*F)*(u*E-v*F)+(v*t-E*s)*(v*t-E*s)+(F*s-u*t)*(F*s-u*t)));g[o>>2]=(u*E-v*F)*G;g[M>>2]=(v*t-E*s)*G;g[N>>2]=(F*s-u*t)*G;l=c[X>>2]|0;g[l+(j*36|0)+20>>2]=(u*E-v*F)*G;g[l+(j*36|0)+24>>2]=+g[M>>2];g[l+(j*36|0)+28>>2]=+g[N>>2];g[l+(j*36|0)+32>>2]=1000000015047466219876688.0e6}else{c[o+0>>2]=0;c[o+4>>2]=0;c[o+8>>2]=0;c[o+12>>2]=0;l=c[X>>2]|0}m=c[l+(j*36|0)+4>>2]|0;if((m|0)>0){w=c[(c[d+52>>2]|0)+16>>2]|0;v=+g[o>>2];u=+g[Z+(j<<4)+4>>2];t=+g[Z+(j<<4)+8>>2];o=c[l+(j*36|0)+12>>2]|0;p=1000000015047466219876688.0e6;n=0;do{N=c[o+(n<<2)>>2]|0;G=+g[w+(N<<4)>>2]*v+ +g[w+(N<<4)+4>>2]*u+ +g[w+(N<<4)+8>>2]*t;p=p>G?G:p;n=n+1|0}while((n|0)!=(m|0))}else p=1000000015047466219876688.0e6;g[l+(j*36|0)+32>>2]=-p;j=j+1|0}while((j|0)!=(H|0))}if((c[Y>>2]|0)>0){o=0;w=0;k=0;while(1){if((w|0)==(o|0)){o=(w|0)==0?1:w<<1;if((w|0)<(o|0)){if((o|0)!=0?(c[5108]=(c[5108]|0)+1,T=QE((o<<2|3)+16|0)|0,(T|0)!=0):0){c[(T+19&-16)+-4>>2]=T;l=T+19&-16}else l=0;if((w|0)>0){m=0;do{n=l+(m<<2)|0;if(n)c[n>>2]=c[k+(m<<2)>>2];m=m+1|0}while((m|0)!=(w|0))}if(k){c[5110]=(c[5110]|0)+1;RE(c[k+-4>>2]|0)}}else{o=w;l=k}}else l=k;n=l+(w<<2)|0;if(n)c[n>>2]=w;w=w+1|0;if((w|0)>=(c[Y>>2]|0))break;else k=l}if(w){T=ea+56|0;W=ea+52|0;S=ea+44|0;o=w;while(1){f=o+-1|0;m=c[l+(f<<2)>>2]|0;c[5108]=(c[5108]|0)+1;o=QE(23)|0;if(o){c[(o+19&-16)+-4>>2]=o;n=o+19&-16;if(o+19&-16)c[n>>2]=m}else n=0;k=c[X>>2]|0;p=+g[k+(m*36|0)+20>>2];q=+g[k+(m*36|0)+24>>2];I=+g[k+(m*36|0)+28>>2];k=1;m=1;w=f;o=f;c:while(1){if((o|0)>0){B=m;D=n}else{D=m;_=192;break}d:while(1){m=c[X>>2]|0;do{N=w;w=w+-1|0;if((N|0)<=0){V=B;n=D;break c}C=c[l+(w<<2)>>2]|0}while(!(p*+g[m+(C*36|0)+20>>2]+q*+g[m+(C*36|0)+24>>2]+I*+g[m+(C*36|0)+28>>2]>.9990000128746033));do if((B|0)==(k|0)?(Q=(k|0)==0?1:k<<1,(k|0)<(Q|0)):0){do if(!Q)n=0;else{c[5108]=(c[5108]|0)+1;n=QE((Q<<2|3)+16|0)|0;if(!n){n=0;break}c[(n+19&-16)+-4>>2]=n;n=n+19&-16}while(0);if((k|0)>0){j=0;do{m=n+(j<<2)|0;if(m)c[m>>2]=c[D+(j<<2)>>2];j=j+1|0}while((j|0)!=(k|0))}if(!D){k=Q;break}c[5110]=(c[5110]|0)+1;RE(c[D+-4>>2]|0);k=Q}else n=D;while(0);m=n+(B<<2)|0;if(m)c[m>>2]=C;B=B+1|0;j=0;while(1){m=l+(j<<2)|0;f=j+1|0;if((c[m>>2]|0)==(C|0))break;if((f|0)<(o|0))j=f;else{D=n;continue d}}if((j|0)<(o|0))break;else D=n}N=o+-1|0;M=l+(N<<2)|0;c[m>>2]=c[M>>2];c[M>>2]=C;m=B;o=N}e:do if((_|0)==192)while(1){_=0;m=c[X>>2]|0;do{N=w;w=w+-1|0;if((N|0)<=0){V=D;break e}y=c[l+(w<<2)>>2]|0}while(!(p*+g[m+(y*36|0)+20>>2]+q*+g[m+(y*36|0)+24>>2]+I*+g[m+(y*36|0)+28>>2]>.9990000128746033));do if((D|0)==(k|0)?(R=(k|0)==0?1:k<<1,(k|0)<(R|0)):0){do if(!R)f=0;else{c[5108]=(c[5108]|0)+1;m=QE((R<<2|3)+16|0)|0;if(!m){f=0;break}c[(m+19&-16)+-4>>2]=m;f=m+19&-16}while(0);if((k|0)>0){j=0;do{m=f+(j<<2)|0;if(m)c[m>>2]=c[n+(j<<2)>>2];j=j+1|0}while((j|0)!=(k|0))}if(!n){k=R;n=f;break}c[5110]=(c[5110]|0)+1;RE(c[n+-4>>2]|0);k=R;n=f}while(0);m=n+(D<<2)|0;if(m)c[m>>2]=y;D=D+1|0;_=192}while(0);if((V|0)>1){a[T>>0]=1;c[W>>2]=0;c[S>>2]=0;c[ea+48>>2]=0;f=m;G=0.0;F=0.0;v=0.0;m=0;h=0;do{w=c[n+(h<<2)>>2]|0;G=+g[f+(w*36|0)+20>>2]+G;F=+g[f+(w*36|0)+24>>2]+F;v=+g[f+(w*36|0)+28>>2]+v;z=f+(w*36|0)+4|0;if((c[z>>2]|0)>0){A=f+(w*36|0)+12|0;B=0;do{C=c[(c[A>>2]|0)+(B<<2)>>2]|0;N=(c[(c[d+52>>2]|0)+16>>2]|0)+(C<<4)|0;c[ea+24>>2]=c[N+0>>2];c[ea+28>>2]=c[N+4>>2];c[ea+32>>2]=c[N+8>>2];c[ea+36>>2]=c[N+12>>2];f:do if((m|0)>0){f=c[W>>2]|0;w=0;while(1){if((c[f+(w*24|0)+20>>2]|0)==(C|0))break f;w=w+1|0;if((w|0)>=(m|0)){_=218;break}}}else _=218;while(0);if((_|0)==218){_=0;c[ea+0>>2]=c[ea+24>>2];c[ea+4>>2]=c[ea+28>>2];c[ea+8>>2]=c[ea+32>>2];c[ea+12>>2]=c[ea+36>>2];do if((m|0)==(c[ea+48>>2]|0)){D=(m|0)==0?1:m<<1;if((m|0)>=(D|0))break;if(!D)f=0;else{c[5108]=(c[5108]|0)+1;f=QE((D*24|3)+16|0)|0;if(!f)f=0;else{c[(f+19&-16)+-4>>2]=f;f=f+19&-16}m=c[S>>2]|0}x=c[W>>2]|0;if((m|0)>0){y=0;do{N=f+(y*24|0)|0;M=x+(y*24|0)|0;c[N+0>>2]=c[M+0>>2];c[N+4>>2]=c[M+4>>2];c[N+8>>2]=c[M+8>>2];c[N+12>>2]=c[M+12>>2];c[N+16>>2]=c[M+16>>2];c[N+20>>2]=c[M+20>>2];y=y+1|0}while((y|0)!=(m|0))}if(x){if(a[T>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[x+-4>>2]|0);m=c[S>>2]|0}c[W>>2]=0}a[T>>0]=1;c[W>>2]=f;c[ea+48>>2]=D}while(0);N=c[W>>2]|0;M=N+(m*24|0)|0;c[M+0>>2]=c[ea+0>>2];c[M+4>>2]=c[ea+4>>2];c[M+8>>2]=c[ea+8>>2];c[M+12>>2]=c[ea+12>>2];c[M+16>>2]=c[ea+16>>2];c[N+(m*24|0)+20>>2]=C;m=(c[S>>2]|0)+1|0;c[S>>2]=m}B=B+1|0}while((B|0)<(c[z>>2]|0))}h=h+1|0;f=c[X>>2]|0}while((h|0)!=(V|0));A=ea+275|0;D=f+((c[n>>2]|0)*9<<2)+20|0;C=A+16|0;do{a[A>>0]=a[D>>0]|0;A=A+1|0;D=D+1|0}while((A|0)<(C|0));I=1.0/+P(+(G*G+F*F+v*v));q=G*I;p=F*I;I=v*I;if(+O(+I)>.7071067690849304){s=1.0/+P(+(I*I+p*p));u=0.0;t=-(I*s);s=p*s}else{t=1.0/+P(+(q*q+p*p));u=-(p*t);t=q*t;s=0.0}do if((m|0)<2)if((m|0)>0){k=0;w=0;x=0;while(1){y=c[W>>2]|0;do if((k|0)==(w|0)){h=(w|0)==0?1:w<<1;if((w|0)>=(h|0)){j=w;f=x;break}do if(!h)f=0;else{c[5108]=(c[5108]|0)+1;m=QE((h*24|3)+16|0)|0;if(!m){w=k;f=0;break}c[(m+19&-16)+-4>>2]=m;w=k;f=m+19&-16}while(0);if((w|0)>0){m=0;do{N=f+(m*24|0)|0;M=x+(m*24|0)|0;c[N+0>>2]=c[M+0>>2];c[N+4>>2]=c[M+4>>2];c[N+8>>2]=c[M+8>>2];c[N+12>>2]=c[M+12>>2];c[N+16>>2]=c[M+16>>2];c[N+20>>2]=c[M+20>>2];m=m+1|0}while((m|0)!=(w|0))}if(x){c[5110]=(c[5110]|0)+1;RE(c[x+-4>>2]|0)}j=k;m=c[S>>2]|0;w=h}else{j=k;f=x}while(0);N=f+(j*24|0)|0;c[N+0>>2]=c[y+0>>2];c[N+4>>2]=c[y+4>>2];c[N+8>>2]=c[y+8>>2];c[N+12>>2]=c[y+12>>2];c[N+16>>2]=c[y+16>>2];c[N+20>>2]=c[y+20>>2];k=k+1|0;if((k|0)<(m|0))x=f;else{w=f;_=282;break}}}else{H=0;y=0;w=0}else{k=c[W>>2]|0;w=m;f=0;do{if(u*+g[k+(f*24|0)>>2]+t*+g[k+(f*24|0)+4>>2]+s*+g[k+(f*24|0)+8>>2]<u*+g[k>>2]+t*+g[k+4>>2]+s*+g[k+8>>2]){c[ea+224>>2]=c[k+0>>2];c[ea+228>>2]=c[k+4>>2];c[ea+232>>2]=c[k+8>>2];c[ea+236>>2]=c[k+12>>2];c[ea+240>>2]=c[k+16>>2];c[ea+244>>2]=c[k+20>>2];w=k+(f*24|0)|0;c[k+0>>2]=c[w+0>>2];c[k+4>>2]=c[w+4>>2];c[k+8>>2]=c[w+8>>2];c[k+12>>2]=c[w+12>>2];c[k+16>>2]=c[w+16>>2];c[k+20>>2]=c[w+20>>2];w=k+(f*24|0)|0;c[w+0>>2]=c[ea+224>>2];c[w+4>>2]=c[ea+228>>2];c[w+8>>2]=c[ea+232>>2];c[w+12>>2]=c[ea+236>>2];c[w+16>>2]=c[ea+240>>2];c[w+20>>2]=c[ea+244>>2];w=m}f=f+1|0}while((f|0)<(w|0));g[k+16>>2]=-1000000015047466219876688.0e6;if((w|0)>1){v=+g[k+4>>2];m=1;do{E=+g[k+(m*24|0)>>2]-+g[k>>2];F=+g[k+(m*24|0)+4>>2]-v;G=+g[k+(m*24|0)+8>>2]-+g[k+8>>2];g[k+(m*24|0)+16>>2]=((u*F-t*E)*I+(q*(t*G-s*F)+p*(s*E-u*G)))/+P(+(E*E+F*F+G*G));m=m+1|0}while((m|0)!=(w|0))};c[ea+208>>2]=c[k+0>>2];c[ea+212>>2]=c[k+4>>2];c[ea+216>>2]=c[k+8>>2];c[ea+220>>2]=c[k+12>>2];sy(ea+40|0,ea+208|0,1,w+-1|0);k=c[W>>2]|0;c[5108]=(c[5108]|0)+1;m=QE(43)|0;if(!m)h=0;else{c[(m+19&-16)+-4>>2]=m;h=m+19&-16}j=c[W>>2]|0;c[h+0>>2]=c[k+0>>2];c[h+4>>2]=c[k+4>>2];c[h+8>>2]=c[k+8>>2];c[h+12>>2]=c[k+12>>2];c[h+16>>2]=c[k+16>>2];c[h+20>>2]=c[k+20>>2];c[5108]=(c[5108]|0)+1;m=QE(67)|0;if(!m)w=0;else{c[(m+19&-16)+-4>>2]=m;w=m+19&-16}m=0;while(1){N=w+(m*24|0)|0;M=h+(m*24|0)|0;c[N+0>>2]=c[M+0>>2];c[N+4>>2]=c[M+4>>2];c[N+8>>2]=c[M+8>>2];c[N+12>>2]=c[M+12>>2];c[N+16>>2]=c[M+16>>2];c[N+20>>2]=c[M+20>>2];if(!m)break;else m=m+1|0}if(h){c[5110]=(c[5110]|0)+1;RE(c[h+-4>>2]|0)}m=w+24|0;c[m+0>>2]=c[j+24>>2];c[m+4>>2]=c[j+28>>2];c[m+8>>2]=c[j+32>>2];c[m+12>>2]=c[j+36>>2];c[m+16>>2]=c[j+40>>2];c[m+20>>2]=c[j+44>>2];m=c[S>>2]|0;if((m|0)==2){k=2;_=283;break}else{y=2;k=2;j=2;B=2}while(1){g:do if((y|0)>1){N=c[W>>2]|0;C=N+(B*24|0)|0;v=+g[C>>2];u=+g[N+(B*24|0)+4>>2];t=+g[N+(B*24|0)+8>>2];while(1){N=y+-2|0;D=y+-1|0;E=+g[w+(N*24|0)>>2];F=E-+g[w+(D*24|0)>>2];r=+g[w+(N*24|0)+4>>2];U=r-+g[w+(D*24|0)+4>>2];G=+g[w+(N*24|0)+8>>2];s=G-+g[w+(D*24|0)+8>>2];if((F*(r-u)-U*(E-v))*I+(q*(U*(G-t)-s*(r-u))+p*(s*(E-v)-F*(G-t)))>0.0)break;if((D|0)>1){y=D;k=D}else{y=D;k=D;break g}}do if((y|0)==(j|0)){D=(j|0)==0?1:j<<1;if((j|0)>=(D|0)){y=j;break}do if(!D)h=0;else{c[5108]=(c[5108]|0)+1;m=QE((D*24|3)+16|0)|0;if(!m){j=k;h=0;break}c[(m+19&-16)+-4>>2]=m;j=k;h=m+19&-16}while(0);if((j|0)>0){f=0;do{N=h+(f*24|0)|0;M=w+(f*24|0)|0;c[N+0>>2]=c[M+0>>2];c[N+4>>2]=c[M+4>>2];c[N+8>>2]=c[M+8>>2];c[N+12>>2]=c[M+12>>2];c[N+16>>2]=c[M+16>>2];c[N+20>>2]=c[M+20>>2];f=f+1|0}while((f|0)!=(j|0))}if(w){c[5110]=(c[5110]|0)+1;RE(c[w+-4>>2]|0)}m=c[S>>2]|0;y=k;j=D;w=h}while(0);y=w+(y*24|0)|0;c[y+0>>2]=c[C+0>>2];c[y+4>>2]=c[C+4>>2];c[y+8>>2]=c[C+8>>2];c[y+12>>2]=c[C+12>>2];c[y+16>>2]=c[C+16>>2];c[y+20>>2]=c[C+20>>2];k=k+1|0;y=k}while(0);B=B+1|0;if((B|0)==(m|0)){_=282;break}}}while(0);if((_|0)==282){_=0;if((k|0)>0)_=283;else{H=0;y=0}}if((_|0)==283){_=0;D=0;y=0;C=0;A=0;while(1){B=w+(A*24|0)+20|0;do if((C|0)==(D|0)){h=(D|0)==0?1:D<<1;if((D|0)>=(h|0)){m=D;break}do if(!h)j=0;else{c[5108]=(c[5108]|0)+1;m=QE((h<<2|3)+16|0)|0;if(!m){j=0;break}c[(m+19&-16)+-4>>2]=m;j=m+19&-16}while(0);if((D|0)>0){m=0;do{f=j+(m<<2)|0;if(f)c[f>>2]=c[y+(m<<2)>>2];m=m+1|0}while((m|0)!=(D|0))}if(!y){y=j;m=D;D=h;break}c[5110]=(c[5110]|0)+1;RE(c[y+-4>>2]|0);y=j;m=D;D=h}else m=C;while(0);j=y+(m<<2)|0;if(j){c[j>>2]=c[B>>2];m=C}C=m+1|0;m=c[S>>2]|0;h:do if((m|0)>0){x=c[W>>2]|0;f=c[B>>2]|0;j=0;while(1){h=x+(j*24|0)+20|0;j=j+1|0;if((c[h>>2]|0)==(f|0))break;if((j|0)>=(m|0))break h}c[h>>2]=-1}while(0);A=A+1|0;if((A|0)==(k|0)){H=C;break}}}i:do if((m|0)>0){x=c[W>>2]|0;z=c[Y>>2]|0;A=c[X>>2]|0;C=0;while(1){B=c[x+(C*24|0)+20>>2]|0;if(!((B|0)==-1|(z|0)<1)){D=0;do{f=0;while(1){if((c[n+(f<<2)>>2]|0)==(D|0))break;f=f+1|0;if((f|0)>=(V|0)){_=308;break}}do if((_|0)==308){_=0;h=c[A+(D*36|0)+4>>2]|0;if((h|0)<=0)break;j=c[A+(D*36|0)+12>>2]|0;k=0;do{if((c[j+(k<<2)>>2]|0)==(B|0)){k=1;break i}k=k+1|0}while((k|0)<(h|0))}while(0);D=D+1|0}while((D|0)<(z|0))}C=C+1|0;if((C|0)>=(m|0)){_=315;break}}}else _=315;while(0);if((_|0)==315){_=0;B=c[d+52>>2]|0;m=c[B+28>>2]|0;if((m|0)==(c[B+32>>2]|0)){ry(B+24|0,(m|0)==0?1:m<<1);m=c[B+28>>2]|0}C=(c[B+36>>2]|0)+(m*36|0)|0;if(C){a[C+16>>0]=1;c[C+12>>2]=0;c[C+4>>2]=0;c[C+8>>2]=0;if((H|0)>0){c[5108]=(c[5108]|0)+1;m=QE((H<<2|3)+16|0)|0;if(!m)D=0;else{c[(m+19&-16)+-4>>2]=m;D=m+19&-16}m=c[C+4>>2]|0;if((m|0)>0){j=0;do{k=D+(j<<2)|0;if(k)c[k>>2]=c[(c[C+12>>2]|0)+(j<<2)>>2];j=j+1|0}while((j|0)!=(m|0))}m=c[C+12>>2]|0;if(m){if(a[C+16>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[m+-4>>2]|0)}c[C+12>>2]=0}a[C+16>>0]=1;c[C+12>>2]=D;c[C+8>>2]=H;k=0;do{m=D+(k<<2)|0;if(m)c[m>>2]=0;k=k+1|0}while((k|0)!=(H|0));c[C+4>>2]=H;k=0;do{m=D+(k<<2)|0;if(m)c[m>>2]=c[y+(k<<2)>>2];k=k+1|0}while((k|0)!=(H|0))}else c[C+4>>2]=H;A=C+20|0;D=ea+275|0;C=A+16|0;do{a[A>>0]=a[D>>0]|0;A=A+1|0;D=D+1|0}while((A|0)<(C|0));m=c[B+28>>2]|0}c[B+28>>2]=m+1;k=0}if(w){c[5110]=(c[5110]|0)+1;RE(c[w+-4>>2]|0)}if(y){c[5110]=(c[5110]|0)+1;RE(c[y+-4>>2]|0)}m=c[W>>2]|0;if(m){if(a[T>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[m+-4>>2]|0)}c[W>>2]=0}a[T>>0]=1;c[W>>2]=0;c[S>>2]=0;c[ea+48>>2]=0;if(k&(V|0)>0){j=0;_=350}}else if((V|0)>0){j=0;_=350}if((_|0)==350)while(1){_=0;y=c[n+(j<<2)>>2]|0;h=c[X>>2]|0;z=c[h+(y*36|0)+4>>2]|0;if((z|0)>0){c[5108]=(c[5108]|0)+1;m=QE((z<<2|3)+16|0)|0;if(!m)f=0;else{c[(m+19&-16)+-4>>2]=m;f=m+19&-16}w=0;do{m=f+(w<<2)|0;if(m)c[m>>2]=0;w=w+1|0}while((w|0)!=(z|0));m=c[h+(y*36|0)+12>>2]|0;k=0;do{w=f+(k<<2)|0;if(w)c[w>>2]=c[m+(k<<2)>>2];k=k+1|0}while((k|0)!=(z|0))}else f=0;A=ea+227|0;D=h+(y*36|0)+20|0;C=A+16|0;do{a[A>>0]=a[D>>0]|0;A=A+1|0;D=D+1|0}while((A|0)<(C|0));B=c[d+52>>2]|0;m=c[B+28>>2]|0;if((m|0)==(c[B+32>>2]|0)){ry(B+24|0,(m|0)==0?1:m<<1);m=c[B+28>>2]|0}C=(c[B+36>>2]|0)+(m*36|0)|0;if(C){a[C+16>>0]=1;c[C+12>>2]=0;c[C+4>>2]=0;c[C+8>>2]=0;if((z|0)>0){c[5108]=(c[5108]|0)+1;m=QE((z<<2|3)+16|0)|0;if(!m)D=0;else{c[(m+19&-16)+-4>>2]=m;D=m+19&-16}m=c[C+4>>2]|0;if((m|0)>0){k=0;do{w=D+(k<<2)|0;if(w)c[w>>2]=c[(c[C+12>>2]|0)+(k<<2)>>2];k=k+1|0}while((k|0)!=(m|0))}m=c[C+12>>2]|0;if(m){if(a[C+16>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[m+-4>>2]|0)}c[C+12>>2]=0}a[C+16>>0]=1;c[C+12>>2]=D;c[C+8>>2]=z;w=0;do{m=D+(w<<2)|0;if(m)c[m>>2]=0;w=w+1|0}while((w|0)!=(z|0));c[C+4>>2]=z;w=0;do{m=D+(w<<2)|0;if(m)c[m>>2]=c[f+(w<<2)>>2];w=w+1|0}while((w|0)!=(z|0))}else c[C+4>>2]=z;A=C+20|0;D=ea+227|0;C=A+16|0;do{a[A>>0]=a[D>>0]|0;A=A+1|0;D=D+1|0}while((A|0)<(C|0));m=c[B+28>>2]|0}c[B+28>>2]=m+1;if(f){c[5110]=(c[5110]|0)+1;RE(c[f+-4>>2]|0)}j=j+1|0;if((j|0)>=(V|0))break;else _=350}if(n){c[5110]=(c[5110]|0)+1;RE(c[n+-4>>2]|0)}if(!o)break}}}else l=0;W=c[d+52>>2]|0;c[W+64>>2]=0;c[W+68>>2]=0;c[W+72>>2]=0;c[W+76>>2]=0;j=c[W+28>>2]|0;if((j|0)>0){w=0;D=0;f=0;h=0;B=0;C=0;m=0;z=0;H=0;A=0;k=0;y=0;V=0;while(1){o=c[W+36>>2]|0;T=c[o+(V*36|0)+4>>2]|0;if((T|0)>0){R=V&65535;S=V|-65536;K=D;M=B;N=C;Q=m;x=z;J=y;n=0;while(1){d=n+1|0;j=c[o+(V*36|0)+12>>2]|0;B=c[j+(n<<2)>>2]&65535;j=c[j+(((d|0)==(T|0)?0:d)<<2)>>2]&65535;n=B<<16>>16<j<<16>>16?B:j;L=B<<16>>16<j<<16>>16?j:B;C=B<<16>>16<j<<16>>16?B:j;B=B<<16>>16<j<<16>>16?j:B;j=x+-1|0;j:do if((((C&65535)<<16)+(B<<16>>16)&j)>>>0<f>>>0?($=c[K+((((C&65535)<<16)+(B<<16>>16)&j)<<2)>>2]|0,($|0)!=-1):0){D=$;while(1){if(B<<16>>16==(b[w+(D<<2)>>1]|0)?C<<16>>16==(b[w+(D<<2)+2>>1]|0):0)break;D=c[N+(D<<2)>>2]|0;if((D|0)==-1){y=0;break j}}if((D|0)!=-1)y=H+(D<<2)|0;else y=0}else y=0;while(0);D=c[W+16>>2]|0;u=+g[D+(C<<16>>16<<4)>>2]-+g[D+(B<<16>>16<<4)>>2];t=+g[D+(C<<16>>16<<4)+4>>2]-+g[D+(B<<16>>16<<4)+4>>2];E=+g[D+(C<<16>>16<<4)+8>>2]-+g[D+(B<<16>>16<<4)+8>>2];G=1.0/+P(+(u*u+t*t+E*E));D=c[W+48>>2]|0;k:do if((D|0)>0){C=c[W+56>>2]|0;B=0;while(1){F=+g[C+(B<<4)>>2];v=+g[C+(B<<4)+8>>2];do if(!(+O(+(F-u*G))>1.0e-06)){if(+O(+(+g[C+(B<<4)+4>>2]-t*G))>1.0e-06)break;if(!(+O(+(v-E*G))>1.0e-06))break k}while(0);do if(!(+O(+(u*G+F))>1.0e-06)){if(+O(+(t*G+ +g[C+(B<<4)+4>>2]))>1.0e-06)break;if(!(+O(+(E*G+v))>1.0e-06))break k}while(0);B=B+1|0;if((B|0)>=(D|0)){_=413;break}}}else _=413;while(0);if((_|0)==413){_=0;do if((D|0)==(c[W+52>>2]|0)){z=(D|0)==0?1:D<<1;if((D|0)>=(z|0))break;if(!z)C=0;else{c[5108]=(c[5108]|0)+1;D=QE((z<<4|3)+16|0)|0;if(!D)C=0;else{c[(D+19&-16)+-4>>2]=D;C=D+19&-16}D=c[W+48>>2]|0}if((D|0)>0){B=0;do{m=C+(B<<4)|0;o=(c[W+56>>2]|0)+(B<<4)|0;c[m+0>>2]=c[o+0>>2];c[m+4>>2]=c[o+4>>2];c[m+8>>2]=c[o+8>>2];c[m+12>>2]=c[o+12>>2];B=B+1|0}while((B|0)!=(D|0))}D=c[W+56>>2]|0;if(D){if(a[W+60>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[D+-4>>2]|0)}c[W+56>>2]=0}a[W+60>>0]=1;c[W+56>>2]=C;c[W+52>>2]=z;D=c[W+48>>2]|0}while(0);C=c[W+56>>2]|0;g[C+(D<<4)>>2]=u*G;g[C+(D<<4)+4>>2]=t*G;g[C+(D<<4)+8>>2]=E*G;g[C+(D<<4)+12>>2]=0.0;c[W+48>>2]=(c[W+48>>2]|0)+1}l:do if(!y){o=((n&65535)<<16)+(L<<16>>16)&j;m:do if(o>>>0<f>>>0){y=c[K+(o<<2)>>2]|0;if((y|0)==-1)break;while(1){if(L<<16>>16==(b[w+(y<<2)>>1]|0)?n<<16>>16==(b[w+(y<<2)+2>>1]|0):0)break;y=c[N+(y<<2)>>2]|0;if((y|0)==-1)break m}if((y|0)==-1)break;D=H+(y<<2)|0;b[D>>1]=S;b[D+2>>1]=S>>>16;D=K;B=M;C=N;m=Q;z=x;y=J;break l}while(0);do if((Q|0)==(x|0)){z=(Q|0)==0?1:Q<<1;if((Q|0)>=(z|0)){z=Q;break}do if(!z)B=0;else{c[5108]=(c[5108]|0)+1;B=QE((z<<2|3)+16|0)|0;if(!B){B=0;break}c[(B+19&-16)+-4>>2]=B;B=B+19&-16}while(0);if((Q|0)>0){C=0;do{D=B+(C<<2)|0;if(D){y=H+(C<<2)|0;y=e[y>>1]|e[y+2>>1]<<16;b[D>>1]=y;b[D+2>>1]=y>>>16}C=C+1|0}while((C|0)!=(Q|0))}if(!H){H=B;break}c[5110]=(c[5110]|0)+1;RE(c[H+-4>>2]|0);H=B}else z=x;while(0);B=H+(Q<<2)|0;if(B){b[B>>1]=S;b[B+2>>1]=S>>>16}m=Q+1|0;do if((k|0)==(J|0)){y=(k|0)==0?1:k<<1;if((k|0)>=(y|0)){J=k;break}do if(!y)B=0;else{c[5108]=(c[5108]|0)+1;D=QE((y<<2|3)+16|0)|0;if(!D){B=0;break}c[(D+19&-16)+-4>>2]=D;B=D+19&-16}while(0);if((k|0)>0){C=0;do{D=B+(C<<2)|0;if(D){j=w+(C<<2)|0;j=e[j>>1]|e[j+2>>1]<<16;b[D>>1]=j;b[D+2>>1]=j>>>16}C=C+1|0}while((C|0)!=(k|0))}if(!w){w=B;J=y;break}c[5110]=(c[5110]|0)+1;RE(c[w+-4>>2]|0);w=B;J=y}while(0);D=w+(k<<2)|0;if(D){b[D>>1]=(n&65535)<<16|L&65535;b[D+2>>1]=((n&65535)<<16|L&65535)>>>16}k=k+1|0;if((x|0)<(z|0)){do if((f|0)<(z|0)){if((f|0)>(z|0)){D=K;j=A}else{do if((A|0)<(z|0)){do if(!z)D=0;else{c[5108]=(c[5108]|0)+1;o=QE((z<<2|3)+16|0)|0;if(!o){D=0;break}c[(o+19&-16)+-4>>2]=o;D=o+19&-16}while(0);if((f|0)>0){A=0;do{B=D+(A<<2)|0;if(B)c[B>>2]=c[K+(A<<2)>>2];A=A+1|0}while((A|0)!=(f|0))}if(!K){A=z;break}c[5110]=(c[5110]|0)+1;RE(c[K+-4>>2]|0);A=z}else D=K;while(0);C=f;do{B=D+(C<<2)|0;if(B)c[B>>2]=0;C=C+1|0}while((C|0)!=(z|0));j=A}if((h|0)<(z|0)){do if((M|0)<(z|0)){do if(!z)C=0;else{c[5108]=(c[5108]|0)+1;o=QE((z<<2|3)+16|0)|0;if(!o){C=0;break}c[(o+19&-16)+-4>>2]=o;C=o+19&-16}while(0);if((h|0)>0){A=0;do{B=C+(A<<2)|0;if(B)c[B>>2]=c[N+(A<<2)>>2];A=A+1|0}while((A|0)!=(h|0))}if(!N){B=z;break}c[5110]=(c[5110]|0)+1;RE(c[N+-4>>2]|0);B=z}else{B=M;C=N}while(0);do{y=C+(h<<2)|0;if(y)c[y>>2]=0;h=h+1|0}while((h|0)!=(z|0))}else{B=M;C=N}if((z|0)>0){N=z<<2;VE(D|0,-1,N|0)|0;VE(C|0,-1,N|0)|0}if((f|0)<=0){y=z;h=z;A=j;break}h=z+-1|0;y=0;do{N=D+(((e[w+(y<<2)+2>>1]<<16)+(b[w+(y<<2)>>1]|0)&h)<<2)|0;c[C+(y<<2)>>2]=c[N>>2];c[N>>2]=y;y=y+1|0}while((y|0)!=(f|0));y=z;h=z;A=j}else{D=K;y=f;B=M;C=N}while(0);o=((n&65535)<<16)+(L<<16>>16)&z+-1}else{D=K;y=f;B=M;C=N}f=D+(o<<2)|0;c[C+(Q<<2)>>2]=c[f>>2];c[f>>2]=Q;f=y;y=J}else{b[y+2>>1]=R;D=K;B=M;C=N;m=Q;z=x;y=J}while(0);if((d|0)>=(T|0))break;o=c[W+36>>2]|0;K=D;M=B;N=C;Q=m;x=z;J=y;n=d}j=c[W+28>>2]|0;x=w}else x=w;V=V+1|0;if((V|0)>=(j|0))break;else w=x}if((j|0)>0){k=c[W+36>>2]|0;h=c[W+16>>2]|0;p=0.0;f=0;do{n=c[k+(f*36|0)+4>>2]|0;m=c[k+(f*36|0)+12>>2]|0;w=c[m>>2]|0;if((n+-2|0)>=1){v=+g[W+64>>2];u=+g[W+68>>2];t=+g[W+72>>2];o=1;do{M=c[m+(o<<2)>>2]|0;o=o+1|0;N=c[m+(((o|0)%(n|0)|0)<<2)>>2]|0;ga=+g[h+(w<<4)>>2];fa=+g[h+(M<<4)>>2];I=+g[h+(w<<4)+4>>2];q=+g[h+(M<<4)+4>>2];s=+g[h+(w<<4)+8>>2];E=+g[h+(M<<4)+8>>2];U=+g[h+(N<<4)>>2];r=+g[h+(N<<4)+4>>2];F=+g[h+(N<<4)+8>>2];G=+P(+(((ga-fa)*(I-r)-(I-q)*(ga-U))*((ga-fa)*(I-r)-(I-q)*(ga-U))+(((I-q)*(s-F)-(s-E)*(I-r))*((I-q)*(s-F)-(s-E)*(I-r))+((s-E)*(ga-U)-(ga-fa)*(s-F))*((s-E)*(ga-U)-(ga-fa)*(s-F)))))*.5;v=v+(ga+fa+U)*.3333333432674408*G;g[W+64>>2]=v;u=(I+q+r)*.3333333432674408*G+u;g[W+68>>2]=u;t=G*((s+E+F)*.3333333432674408)+t;g[W+72>>2]=t;p=p+G}while((o|0)!=(n+-1|0))}f=f+1|0}while((f|0)!=(j|0));o=1}else{p=0.0;o=0}}else{p=0.0;o=0;x=0;D=0;C=0;H=0}p=1.0/p;t=p*+g[W+64>>2];g[W+64>>2]=t;q=p*+g[W+68>>2];g[W+68>>2]=q;p=p*+g[W+72>>2];g[W+72>>2]=p;g[W+96>>2]=3402823466385288598117041.0e14;if(o){o=c[W+36>>2]|0;r=3402823466385288598117041.0e14;n=0;do{s=+O(+(+g[o+(n*36|0)+32>>2]+(+g[o+(n*36|0)+20>>2]*t+ +g[o+(n*36|0)+24>>2]*q+ +g[o+(n*36|0)+28>>2]*p)));if(s<r){g[W+96>>2]=s;r=s}n=n+1|0}while((n|0)<(j|0))}else r=3402823466385288598117041.0e14;o=c[W+8>>2]|0;if((o|0)>0){n=c[W+16>>2]|0;t=-3402823466385288598117041.0e14;u=-3402823466385288598117041.0e14;v=-3402823466385288598117041.0e14;s=3402823466385288598117041.0e14;q=3402823466385288598117041.0e14;p=3402823466385288598117041.0e14;f=0;do{G=+g[n+(f<<4)>>2];s=G<s?G:s;t=G>t?G:t;G=+g[n+(f<<4)+4>>2];q=G<q?G:q;u=G>u?G:u;G=+g[n+(f<<4)+8>>2];p=G<p?G:p;v=G>v?G:v;f=f+1|0}while((f|0)!=(o|0))}else{t=-3402823466385288598117041.0e14;u=-3402823466385288598117041.0e14;v=-3402823466385288598117041.0e14;s=3402823466385288598117041.0e14;q=3402823466385288598117041.0e14;p=3402823466385288598117041.0e14}g[W+100>>2]=t+s;g[W+104>>2]=u+q;g[W+108>>2]=p+v;g[W+112>>2]=0.0;t=t-s;s=u-q;p=v-p;g[W+116>>2]=t;g[W+120>>2]=s;g[W+124>>2]=p;g[W+128>>2]=0.0;q=r/1.7320507764816284;if(t<s)m=s<p?2:1;else m=t<p?2:0;o=W+(m<<2)+116|0;r=(+g[o>>2]*.5-q)*.0009765625;g[W+88>>2]=q;g[W+84>>2]=q;g[W+80>>2]=q;p=+g[o>>2]*.5;o=W+(m<<2)+80|0;g[o>>2]=p;n=0;while(1){if(OD(W)|0){_=524;break}p=p-r;g[o>>2]=p;n=n+1|0;if((n|0)>=1024){_=523;break}}n:do if((_|0)==523){g[W+88>>2]=q;g[W+84>>2]=q;g[W+80>>2]=q}else if((_|0)==524){s=(+g[W+96>>2]-q)*.0009765625;o=1<<m&3;q=+g[W+((1<<o&3)<<2)+80>>2];n=0;while(1){p=+g[W+(o<<2)+80>>2];g[W+(o<<2)+80>>2]=s+p;r=s+ +g[W+((1<<o&3)<<2)+80>>2];g[W+((1<<o&3)<<2)+80>>2]=r;n=n+1|0;if(!(OD(W)|0))break;if((n|0)>=1024)break n;else q=r}g[W+(o<<2)+80>>2]=p;g[W+((1<<o&3)<<2)+80>>2]=q}while(0);if(x){c[5110]=(c[5110]|0)+1;RE(c[x+-4>>2]|0)}if(H){c[5110]=(c[5110]|0)+1;RE(c[H+-4>>2]|0)}if(C){c[5110]=(c[5110]|0)+1;RE(c[C+-4>>2]|0)}if(D){c[5110]=(c[5110]|0)+1;RE(c[D+-4>>2]|0)}if(l){c[5110]=(c[5110]|0)+1;RE(c[l+-4>>2]|0)}j=c[Y>>2]|0;h=c[X>>2]|0;if((j|0)>0){l=0;do{o=h+(l*36|0)+4|0;m=h+(l*36|0)+12|0;k=c[m>>2]|0;n=h+(l*36|0)+16|0;if(k){if(a[n>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[k+-4>>2]|0)}c[m>>2]=0}a[n>>0]=1;c[m>>2]=0;c[o>>2]=0;c[h+(l*36|0)+8>>2]=0;l=l+1|0}while((l|0)!=(j|0))}if(h){if(a[ea+96>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[h+-4>>2]|0)}c[X>>2]=0}a[ea+96>>0]=1;c[X>>2]=0;c[Y>>2]=0;c[ea+88>>2]=0;if(Z){c[5110]=(c[5110]|0)+1;RE(c[Z+-4>>2]|0)}h=c[aa>>2]|0;if(h){if(a[ea+188>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[h+-4>>2]|0)}c[aa>>2]=0}a[ea+188>>0]=1;c[aa>>2]=0;c[ea+176>>2]=0;c[ea+180>>2]=0;h=c[ba>>2]|0;if(h){if(a[ea+168>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[h+-4>>2]|0)}c[ba>>2]=0}a[ea+168>>0]=1;c[ba>>2]=0;c[ea+156>>2]=0;c[ea+160>>2]=0;h=c[ca>>2]|0;if(h){if(a[ea+148>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[h+-4>>2]|0)}c[ca>>2]=0}if(!da){i=ea;return 1}c[5110]=(c[5110]|0)+1;RE(c[da+-4>>2]|0);i=ea;return 1}function ly(a,b,d){a=a|0;b=b|0;d=d|0;var e=0.0,f=0.0,h=0.0,j=0,k=0,l=0,m=0.0,n=0.0,o=0,p=0,q=0.0,r=0;p=i;i=i+2048|0;c[a+0>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;c[a+12>>2]=0;e=+g[d>>2];h=+g[d+4>>2];f=+g[d+8>>2];if(e*e+h*h+f*f<9.999999747378752e-05){n=1.0;m=0.0;e=0.0}else{q=1.0/+P(+(e*e+h*h+f*f));n=e*q;m=f*q;e=h*q}if((Nb[c[(c[b>>2]|0)+96>>2]&127](b)|0)<=0){i=p;return}l=0;f=-999999984306749440.0;do{if(((Nb[c[(c[b>>2]|0)+96>>2]&127](b)|0)-l|0)<128){d=(Nb[c[(c[b>>2]|0)+96>>2]&127](b)|0)-l|0;if((d|0)>0)o=7;else{h=-3402823466385288598117041.0e14;j=-1}}else{d=128;o=7}if((o|0)==7){o=0;j=0;do{pc[c[(c[b>>2]|0)+108>>2]&127](b,j,p+(j<<4)|0);j=j+1|0}while((j|0)!=(d|0));k=0;h=-3402823466385288598117041.0e14;j=-1;do{q=n*+g[p+(k<<4)>>2]+e*+g[p+(k<<4)+4>>2]+m*+g[p+(k<<4)+8>>2];r=q>h;j=r?k:j;h=r?q:h;k=k+1|0}while((k|0)!=(d|0))}if(h>f){d=p+(j<<4)|0;c[a+0>>2]=c[d+0>>2];c[a+4>>2]=c[d+4>>2];c[a+8>>2]=c[d+8>>2];c[a+12>>2]=c[d+12>>2];f=h}l=l+128|0}while((l|0)<(Nb[c[(c[b>>2]|0)+96>>2]&127](b)|0));i=p;return}function my(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0,j=0.0,k=0.0,l=0.0,m=0.0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0.0,y=0;w=i;i=i+2048|0;if((e|0)>0)f=0;else{i=w;return}do{g[d+(f<<4)+12>>2]=-999999984306749440.0;f=f+1|0}while((f|0)!=(e|0));t=0;do{if((Nb[c[(c[a>>2]|0)+96>>2]&127](a)|0)>0){q=b+(t<<4)|0;s=b+(t<<4)+4|0;o=b+(t<<4)+8|0;r=d+(t<<4)+12|0;p=d+(t<<4)|0;u=0;do{if(((Nb[c[(c[a>>2]|0)+96>>2]&127](a)|0)-u|0)<128){f=(Nb[c[(c[a>>2]|0)+96>>2]&127](a)|0)-u|0;if((f|0)>0)v=8;else{j=-3402823466385288598117041.0e14;h=-1}}else{f=128;v=8}if((v|0)==8){v=0;h=0;do{pc[c[(c[a>>2]|0)+108>>2]&127](a,h,w+(h<<4)|0);h=h+1|0}while((h|0)!=(f|0));k=+g[q>>2];l=+g[s>>2];m=+g[o>>2];n=0;j=-3402823466385288598117041.0e14;h=-1;do{x=k*+g[w+(n<<4)>>2]+l*+g[w+(n<<4)+4>>2]+m*+g[w+(n<<4)+8>>2];y=x>j;h=y?n:h;j=y?x:j;n=n+1|0}while((n|0)!=(f|0))}if(j>+g[r>>2]){n=w+(h<<4)|0;c[p+0>>2]=c[n+0>>2];c[p+4>>2]=c[n+4>>2];c[p+8>>2]=c[n+8>>2];c[p+12>>2]=c[n+12>>2];g[r>>2]=j}u=u+128|0}while((u|0)<(Nb[c[(c[a>>2]|0)+96>>2]&127](a)|0))}t=t+1|0}while((t|0)!=(e|0));i=w;return}function ny(a,b,d){a=a|0;b=+b;d=d|0;var e=0,f=0.0,h=0.0,j=0.0,k=0;e=i;i=i+96|0;j=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);g[e+32>>2]=1.0;c[e+36>>2]=0;c[e+40>>2]=0;c[e+44>>2]=0;c[e+48>>2]=0;g[e+52>>2]=1.0;c[e+56>>2]=0;c[e+60>>2]=0;c[e+64>>2]=0;c[e+68>>2]=0;g[e+72>>2]=1.0;k=e+76|0;c[k+0>>2]=0;c[k+4>>2]=0;c[k+8>>2]=0;c[k+12>>2]=0;c[k+16>>2]=0;tc[c[(c[a>>2]|0)+8>>2]&127](a,e+32|0,e+16|0,e);h=(j+(+g[e>>2]-+g[e+16>>2])*.5)*2.0;f=(j+(+g[e+4>>2]-+g[e+20>>2])*.5)*2.0;j=(j+(+g[e+8>>2]-+g[e+24>>2])*.5)*2.0;g[d>>2]=b*.0833333283662796*(f*f+j*j);g[d+4>>2]=b*.0833333283662796*(h*h+j*j);g[d+8>>2]=b*.0833333283662796*(h*h+f*f);g[d+12>>2]=0.0;i=e;return}function oy(b){b=b|0;var d=0,e=0,f=0,h=0.0;e=i;i=i+96|0;a[b+88>>0]=1;if((a[13560]|0)==0?(Xa(13560)|0)!=0:0){g[3366]=1.0;c[3367]=0;c[3368]=0;c[3369]=0;c[3370]=0;g[3371]=1.0;c[3372]=0;c[3373]=0;c[3374]=0;c[3375]=0;g[3376]=1.0;g[3377]=0.0;g[3378]=-1.0;c[3379]=0;c[3380]=0;c[3381]=0;c[3382]=0;g[3383]=-1.0;c[3384]=0;c[3385]=0;c[3386]=0;c[3387]=0;g[3388]=-1.0;g[3389]=0.0;ab(13560)}d=e+0|0;f=d+96|0;do{c[d>>2]=0;d=d+4|0}while((d|0)<(f|0));tc[c[(c[b>>2]|0)+76>>2]&127](b,13464,e,6);h=+g[b+44>>2];g[b+72>>2]=+g[e>>2]+h;g[b+56>>2]=+g[e+48>>2]-h;g[b+76>>2]=+g[e+20>>2]+h;g[b+60>>2]=+g[e+68>>2]-h;g[b+80>>2]=+g[e+40>>2]+h;g[b+64>>2]=+g[e+88>>2]-h;i=e;return}function py(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0;f=i;q=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);w=+g[a+72>>2];v=+g[a+56>>2];t=+g[a+76>>2];s=+g[a+60>>2];p=+g[a+80>>2];o=+g[a+64>>2];G=+g[b>>2];A=+O(+G);F=+g[b+4>>2];z=+O(+F);m=+g[b+8>>2];n=+O(+m);E=+g[b+16>>2];y=+O(+E);D=+g[b+20>>2];x=+O(+D);k=+g[b+24>>2];l=+O(+k);C=+g[b+32>>2];u=+O(+C);B=+g[b+36>>2];r=+O(+B);h=+g[b+40>>2];j=+O(+h);m=(w+v)*.5*G+(t+s)*.5*F+(p+o)*.5*m+ +g[b+48>>2];k=(w+v)*.5*E+(t+s)*.5*D+(p+o)*.5*k+ +g[b+52>>2];h=(w+v)*.5*C+(t+s)*.5*B+(p+o)*.5*h+ +g[b+56>>2];n=(q+(w-v)*.5)*A+(q+(t-s)*.5)*z+(q+(p-o)*.5)*n;l=(q+(w-v)*.5)*y+(q+(t-s)*.5)*x+(q+(p-o)*.5)*l;j=(q+(w-v)*.5)*u+(q+(t-s)*.5)*r+(q+(p-o)*.5)*j;g[d>>2]=m-n;g[d+4>>2]=k-l;g[d+8>>2]=h-j;g[d+12>>2]=0.0;g[e>>2]=n+m;g[e+4>>2]=l+k;g[e+8>>2]=j+h;g[e+12>>2]=0.0;i=f;return}function qy(a){a=a|0;var b=0,d=0;d=i;c[a>>2]=13336;b=c[a+52>>2]|0;if(!b){i=d;return}Jb[c[c[b>>2]>>2]&255](b);b=c[a+52>>2]|0;if(!b){i=d;return}c[5110]=(c[5110]|0)+1;RE(c[b+-4>>2]|0);i=d;return}function ry(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;q=i;if((c[b+8>>2]|0)>=(d|0)){i=q;return}if((d|0)!=0?(c[5108]=(c[5108]|0)+1,e=QE((d*36|3)+16|0)|0,(e|0)!=0):0){c[(e+19&-16)+-4>>2]=e;p=e+19&-16}else p=0;g=c[b+4>>2]|0;if((g|0)>0){o=0;do{e=p+(o*36|0)|0;if(e){m=c[b+12>>2]|0;a[e+16>>0]=1;c[e+12>>2]=0;c[e+4>>2]=0;c[e+8>>2]=0;n=c[m+(o*36|0)+4>>2]|0;if((n|0)>0){c[5108]=(c[5108]|0)+1;f=QE((n<<2|3)+16|0)|0;if(!f)h=0;else{c[(f+19&-16)+-4>>2]=f;h=f+19&-16}l=c[e+4>>2]|0;if((l|0)>0){j=0;do{k=h+(j<<2)|0;if(k)c[k>>2]=c[(c[e+12>>2]|0)+(j<<2)>>2];j=j+1|0}while((j|0)!=(l|0))}f=c[e+12>>2]|0;if(f){if(a[e+16>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[f+-4>>2]|0)}c[e+12>>2]=0}a[e+16>>0]=1;c[e+12>>2]=h;c[e+8>>2]=n;k=0;do{l=h+(k<<2)|0;if(l)c[l>>2]=0;k=k+1|0}while((k|0)!=(n|0));c[e+4>>2]=n;l=c[m+(o*36|0)+12>>2]|0;j=0;do{k=h+(j<<2)|0;if(k)c[k>>2]=c[l+(j<<2)>>2];j=j+1|0}while((j|0)!=(n|0))}else c[e+4>>2]=n;n=m+(o*36|0)+20|0;c[e+20>>2]=c[n+0>>2];c[e+24>>2]=c[n+4>>2];c[e+28>>2]=c[n+8>>2];c[e+32>>2]=c[n+12>>2]}o=o+1|0}while((o|0)!=(g|0));f=c[b+4>>2]|0;if((f|0)>0){h=0;do{e=c[b+12>>2]|0;l=e+(h*36|0)+4|0;j=e+(h*36|0)+12|0;g=c[j>>2]|0;k=e+(h*36|0)+16|0;if(g){if(a[k>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[g+-4>>2]|0)}c[j>>2]=0}a[k>>0]=1;c[j>>2]=0;c[l>>2]=0;c[e+(h*36|0)+8>>2]=0;h=h+1|0}while((h|0)!=(f|0));f=b+12|0}else f=b+12|0}else f=b+12|0;e=c[f>>2]|0;if(e){if(a[b+16>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[e+-4>>2]|0)}c[f>>2]=0}a[b+16>>0]=1;c[f>>2]=p;c[b+8>>2]=d;i=q;return}function sy(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0,r=0.0,s=0.0,t=0.0,u=0.0,v=0,w=0,x=0;w=i;i=i+32|0;q=c[a+12>>2]|0;r=+g[q+(((e+d|0)/2|0)*24|0)>>2];s=+g[q+(((e+d|0)/2|0)*24|0)+4>>2];t=+g[q+(((e+d|0)/2|0)*24|0)+8>>2];u=+g[q+(((e+d|0)/2|0)*24|0)+16>>2];v=c[q+(((e+d|0)/2|0)*24|0)+20>>2]|0;f=d;h=e;while(1){m=+g[b>>2];n=+g[b+4>>2];o=+g[b+8>>2];p=(r-m)*(r-m)+(s-n)*(s-n)+(t-o)*(t-o);a:while(1){j=+g[q+(f*24|0)+16>>2];do if(j!=u){if(!(j<u))break a}else{j=+g[q+(f*24|0)>>2]-m;l=+g[q+(f*24|0)+4>>2]-n;k=+g[q+(f*24|0)+8>>2]-o;if(j*j+l*l+k*k!=p)if(j*j+l*l+k*k<p)break;else break a;else if((c[q+(f*24|0)+20>>2]|0)<(v|0))break;else break a}while(0);f=f+1|0}b:while(1){j=+g[q+(h*24|0)+16>>2];do if(u!=j){if(!(u<j))break b}else{j=+g[q+(h*24|0)>>2]-m;l=+g[q+(h*24|0)+4>>2]-n;k=+g[q+(h*24|0)+8>>2]-o;if(p!=j*j+l*l+k*k)if(p<j*j+l*l+k*k)break;else break b;else if((v|0)<(c[q+(h*24|0)+20>>2]|0))break;else break b}while(0);h=h+-1|0}if((f|0)<=(h|0)){x=q+(f*24|0)|0;c[w+0>>2]=c[x+0>>2];c[w+4>>2]=c[x+4>>2];c[w+8>>2]=c[x+8>>2];c[w+12>>2]=c[x+12>>2];c[w+16>>2]=c[x+16>>2];c[w+20>>2]=c[x+20>>2];q=q+(h*24|0)|0;c[x+0>>2]=c[q+0>>2];c[x+4>>2]=c[q+4>>2];c[x+8>>2]=c[q+8>>2];c[x+12>>2]=c[q+12>>2];c[x+16>>2]=c[q+16>>2];c[x+20>>2]=c[q+20>>2];q=(c[a+12>>2]|0)+(h*24|0)|0;c[q+0>>2]=c[w+0>>2];c[q+4>>2]=c[w+4>>2];c[q+8>>2]=c[w+8>>2];c[q+12>>2]=c[w+12>>2];c[q+16>>2]=c[w+16>>2];c[q+20>>2]=c[w+20>>2];f=f+1|0;h=h+-1|0}if((f|0)>(h|0))break;q=c[a+12>>2]|0}if((h|0)>(d|0))sy(a,b,d,h);if((f|0)>=(e|0)){i=w;return}sy(a,b,f,e);i=w;return}function ty(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0.0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0;e=i;i=i+96|0;g[e+32>>2]=1.0;c[e+36>>2]=0;c[e+40>>2]=0;c[e+44>>2]=0;c[e+48>>2]=0;g[e+52>>2]=1.0;c[e+56>>2]=0;c[e+60>>2]=0;c[e+64>>2]=0;c[e+68>>2]=0;g[e+72>>2]=1.0;n=e+76|0;c[n+0>>2]=0;c[n+4>>2]=0;c[n+8>>2]=0;c[n+12>>2]=0;c[n+16>>2]=0;tc[c[(c[a>>2]|0)+8>>2]&127](a,e+32|0,e+16|0,e);l=+g[e>>2];m=+g[e+16>>2];j=+g[e+4>>2];k=+g[e+20>>2];f=+g[e+8>>2];h=+g[e+24>>2];g[d>>2]=+P(+((l-m)*(l-m)+(j-k)*(j-k)+(f-h)*(f-h)))*.5;g[b>>2]=(m+l)*.5;g[b+4>>2]=(k+j)*.5;g[b+8>>2]=(h+f)*.5;g[b+12>>2]=0.0;i=e;return}function uy(a,b){a=a|0;b=+b;var d=0;d=i;b=+Zb[c[(c[a>>2]|0)+16>>2]&15](a)*b;i=d;return +b}function vy(a){a=a|0;var b=0,d=0.0,e=0.0,f=0.0;b=i;i=i+32|0;pc[c[(c[a>>2]|0)+12>>2]&127](a,b+8|0,b);f=+g[b+8>>2];e=+g[b+12>>2];d=+g[b+16>>2];d=+P(+(f*f+e*e+d*d));i=b;return +(d+ +g[b>>2])}function wy(a,b,d,e,f,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0;s=i;tc[c[(c[a>>2]|0)+8>>2]&127](a,b,f,h);n=+g[h>>2];l=+g[h+4>>2];j=+g[h+8>>2];m=+g[f>>2];o=+g[f+4>>2];k=+g[f+8>>2];p=+g[d>>2];q=+g[d+4>>2];r=+g[d+8>>2];if(p>0.0)n=n+p;else m=m+p;if(q>0.0)l=l+q;else o=o+q;if(r>0.0)j=j+r;else k=k+r;r=+g[e>>2];q=+g[e+4>>2];p=+g[e+8>>2];p=+P(+(r*r+q*q+p*p));p=p*+Zb[c[(c[a>>2]|0)+16>>2]&15](a);g[f>>2]=m;g[f+4>>2]=o;g[f+8>>2]=k;g[f+12>>2]=0.0;g[h>>2]=n;g[h+4>>2]=l;g[h+8>>2]=j;g[h+12>>2]=0.0;g[f>>2]=+g[f>>2]-p;g[f+4>>2]=+g[f+4>>2]-p;g[f+8>>2]=+g[f+8>>2]-p;g[h>>2]=p+ +g[h>>2];g[h+4>>2]=p+ +g[h+4>>2];g[h+8>>2]=p+ +g[h+8>>2];i=s;return}function xy(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0;f=i;e=ec[c[(c[d>>2]|0)+40>>2]&31](d,a)|0;g=ec[c[(c[d>>2]|0)+28>>2]&31](d,e)|0;c[b>>2]=g;if(g)Lb[c[(c[d>>2]|0)+48>>2]&127](d,e);c[b+4>>2]=c[a+4>>2];i=f;return 13672}function yy(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;d=i;f=Nb[c[(c[a>>2]|0)+52>>2]&127](a)|0;f=Wb[c[(c[b>>2]|0)+16>>2]&63](b,f,1)|0;e=Wb[c[(c[a>>2]|0)+56>>2]&63](a,c[f+8>>2]|0,b)|0;Hb[c[(c[b>>2]|0)+20>>2]&31](b,f,e,1346455635,a);i=d;return}function zy(a){a=a|0;return}function Ay(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var h=0.0,j=0.0,k=0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0;k=i;i=i+64|0;n=+g[d>>2];o=+g[d+4>>2];m=+g[d+8>>2];p=n*+g[b+4>>2]+o*+g[b+20>>2]+m*+g[b+36>>2];q=n*+g[b+8>>2]+o*+g[b+24>>2]+m*+g[b+40>>2];g[k+48>>2]=+g[b>>2]*n+ +g[b+16>>2]*o+ +g[b+32>>2]*m;g[k+52>>2]=p;g[k+56>>2]=q;g[k+60>>2]=0.0;pc[c[(c[a>>2]|0)+64>>2]&127](k+32|0,a,k+48|0);q=+g[k+32>>2];p=+g[k+36>>2];m=+g[k+40>>2];o=q*+g[b>>2]+p*+g[b+4>>2]+m*+g[b+8>>2]+ +g[b+48>>2];n=q*+g[b+16>>2]+p*+g[b+20>>2]+m*+g[b+24>>2]+ +g[b+52>>2];m=q*+g[b+32>>2]+p*+g[b+36>>2]+m*+g[b+40>>2]+ +g[b+56>>2];r=c[(c[a>>2]|0)+64>>2]|0;p=-+g[k+52>>2];q=-+g[k+56>>2];g[k>>2]=-+g[k+48>>2];g[k+4>>2]=p;g[k+8>>2]=q;g[k+12>>2]=0.0;pc[r&127](k+16|0,a,k);q=+g[k+16>>2];p=+g[k+20>>2];j=+g[k+24>>2];l=q*+g[b>>2]+p*+g[b+4>>2]+j*+g[b+8>>2]+ +g[b+48>>2];h=q*+g[b+16>>2]+p*+g[b+20>>2]+j*+g[b+24>>2]+ +g[b+52>>2];j=q*+g[b+32>>2]+p*+g[b+36>>2]+j*+g[b+40>>2]+ +g[b+56>>2];g[e>>2]=o*+g[d>>2]+n*+g[d+4>>2]+m*+g[d+8>>2];j=l*+g[d>>2]+h*+g[d+4>>2]+j*+g[d+8>>2];g[f>>2]=j;h=+g[e>>2];if(!(h>j)){i=k;return}g[e>>2]=j;g[f>>2]=h;i=k;return}function By(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0.0,h=0.0,j=0.0,k=0,l=0.0,m=0.0,n=0.0,o=0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0;x=i;i=i+80|0;switch(c[b+4>>2]|0){case 8:{c[a+0>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;c[a+12>>2]=0;i=x;return}case 10:{j=+g[d>>2];h=+g[d+4>>2];f=+g[d+8>>2];o=c[b+52>>2]|0;w=+g[b+(o<<2)+28>>2];m=+g[b+(((o+2|0)%3|0)<<2)+28>>2];if(j*j+h*h+f*f<9.999999747378752e-05){v=1.0;u=0.0;t=0.0}else{t=1.0/+P(+(j*j+h*h+f*f));v=j*t;u=h*t;t=f*t}c[x+16>>2]=0;c[x+20>>2]=0;c[x+24>>2]=0;c[x+28>>2]=0;g[x+16+(o<<2)>>2]=w;r=m*v;s=m*u;f=m*t;q=+g[b+44>>2];p=v*q;h=u*q;q=t*q;n=+g[x+16>>2]+r-p;j=s+ +g[x+20>>2]-h;l=f+ +g[x+24>>2]-q;m=t*l+(v*n+u*j);if(!(m>-999999984306749440.0)){m=-999999984306749440.0;n=0.0;j=0.0;l=0.0}c[x+0>>2]=0;c[x+4>>2]=0;c[x+8>>2]=0;c[x+12>>2]=0;g[x+(o<<2)>>2]=-w;r=r+ +g[x>>2]-p;s=s+ +g[x+4>>2]-h;p=f+ +g[x+8>>2]-q;e=t*p+(v*r+u*s)>m;g[a>>2]=e?r:n;g[a+4>>2]=e?s:j;g[a+8>>2]=e?p:l;g[a+12>>2]=0.0;i=x;return}case 5:{o=c[b+92>>2]|0;k=c[b+96>>2]|0;p=+g[b+12>>2];q=+g[b+16>>2];n=+g[b+20>>2];h=+g[d>>2]*p;f=+g[d+4>>2]*q;j=+g[d+8>>2]*n;if((k|0)>0){b=0;l=-3402823466385288598117041.0e14;e=-1;while(1){m=h*+g[o+(b<<4)>>2]+f*+g[o+(b<<4)+4>>2]+j*+g[o+(b<<4)+8>>2];d=m>l;e=d?b:e;b=b+1|0;if((b|0)==(k|0))break;else l=d?m:l}}else e=-1;m=q*+g[o+(e<<4)+4>>2];n=n*+g[o+(e<<4)+8>>2];g[a>>2]=p*+g[o+(e<<4)>>2];g[a+4>>2]=m;g[a+8>>2]=n;g[a+12>>2]=0.0;i=x;return}case 13:{c[x+64>>2]=c[b+28>>2];c[x+68>>2]=c[b+32>>2];c[x+72>>2]=c[b+36>>2];c[x+76>>2]=c[b+40>>2];g[x+48>>2]=+g[d>>2];j=+g[d+4>>2];g[x+52>>2]=j;f=+g[d+8>>2];g[x+56>>2]=f;g[x+60>>2]=0.0;e=c[b+52>>2]|0;if((e|0)==2){k=0;b=e;d=1}else if((e|0)==1){j=f;k=0;b=e;d=2}else{j=f;k=1;b=0;d=2}m=+g[x+64+(k<<2)>>2];f=+g[x+64+(e<<2)>>2];h=+g[x+48+(k<<2)>>2];l=+P(+(h*h+j*j));if(l!=0.0){g[x+32+(k<<2)>>2]=h*(m/l);if(+g[x+48+(b<<2)>>2]<0.0)f=-f;g[x+32+(b<<2)>>2]=f;g[x+32+(d<<2)>>2]=m/l*j;g[a>>2]=+g[x+32>>2];g[a+4>>2]=+g[x+36>>2];g[a+8>>2]=+g[x+40>>2];g[a+12>>2]=0.0;i=x;return}else{g[x+32+(k<<2)>>2]=m;if(+g[x+48+(b<<2)>>2]<0.0)f=-f;g[x+32+(b<<2)>>2]=f;g[x+32+(d<<2)>>2]=0.0;g[a>>2]=+g[x+32>>2];g[a+4>>2]=+g[x+36>>2];g[a+8>>2]=+g[x+40>>2];g[a+12>>2]=0.0;i=x;return}}case 1:{n=+g[d>>2];p=+g[d+4>>2];h=+g[d+8>>2];f=n*+g[b+56>>2]+p*+g[b+60>>2]+h*+g[b+64>>2];j=n*+g[b+72>>2]+p*+g[b+76>>2]+h*+g[b+80>>2];h=n*+g[b+88>>2]+p*+g[b+92>>2]+h*+g[b+96>>2];if(f<j)e=j<h?2:1;else e=f<h?2:0;n=+g[b+56+(e<<4)+4>>2];p=+g[b+56+(e<<4)+8>>2];g[a>>2]=+g[b+56+(e<<4)>>2];g[a+4>>2]=n;g[a+8>>2]=p;g[a+12>>2]=0.0;i=x;return}case 4:{o=c[b+104>>2]|0;k=c[b+96>>2]|0;p=+g[b+12>>2];q=+g[b+16>>2];n=+g[b+20>>2];h=+g[d>>2]*p;f=+g[d+4>>2]*q;j=+g[d+8>>2]*n;if((k|0)>0){b=0;l=-3402823466385288598117041.0e14;e=-1;while(1){m=h*+g[o+(b<<4)>>2]+f*+g[o+(b<<4)+4>>2]+j*+g[o+(b<<4)+8>>2];d=m>l;e=d?b:e;b=b+1|0;if((b|0)==(k|0))break;else l=d?m:l}}else e=-1;m=q*+g[o+(e<<4)+4>>2];n=n*+g[o+(e<<4)+8>>2];g[a>>2]=p*+g[o+(e<<4)>>2];g[a+4>>2]=m;g[a+8>>2]=n;g[a+12>>2]=0.0;i=x;return}case 0:{m=+g[b+28>>2];n=+g[b+32>>2];n=+g[d+4>>2]>=0.0?n:-n;p=+g[b+36>>2];p=+g[d+8>>2]>=0.0?p:-p;g[a>>2]=+g[d>>2]>=0.0?m:-m;g[a+4>>2]=n;g[a+8>>2]=p;g[a+12>>2]=0.0;i=x;return}default:{pc[c[(c[b>>2]|0)+68>>2]&127](a,b,d);i=x;return}}}function Cy(a,b,d){a=a|0;b=b|0;d=d|0;var e=0.0,f=0.0,h=0.0,j=0,k=0.0;j=i;i=i+32|0;c[j+16>>2]=c[d+0>>2];c[j+20>>2]=c[d+4>>2];c[j+24>>2]=c[d+8>>2];c[j+28>>2]=c[d+12>>2];e=+g[j+16>>2];h=+g[j+20>>2];f=+g[j+24>>2];if(e*e+h*h+f*f<1.4210854715202004e-14){g[j+16>>2]=-1.0;g[j+20>>2]=-1.0;g[j+24>>2]=-1.0;g[j+28>>2]=0.0;e=-1.0;h=-1.0;f=-1.0}k=1.0/+P(+(e*e+h*h+f*f));g[j+16>>2]=e*k;g[j+20>>2]=h*k;g[j+24>>2]=f*k;By(j,b,j+16|0);switch(c[b+4>>2]|0){case 13:{e=+g[b+44>>2];break}case 4:case 5:{e=+g[b+44>>2];break}case 1:{e=+g[b+44>>2];break}case 11:{e=+g[b+44>>2];break}case 10:{e=+g[b+44>>2];break}case 8:{e=+g[b+28>>2]*+g[b+12>>2];break}case 0:{e=+g[b+44>>2];break}default:e=+Zb[c[(c[b>>2]|0)+48>>2]&15](b)}h=e*+g[j+20>>2]+ +g[j+4>>2];f=e*+g[j+24>>2]+ +g[j+8>>2];g[a>>2]=e*+g[j+16>>2]+ +g[j>>2];g[a+4>>2]=h;g[a+8>>2]=f;g[a+12>>2]=0.0;i=j;return}function Dy(a,b){a=a|0;b=b|0;var c=0.0,d=0.0,e=0.0;e=+O(+(+g[b>>2]));d=+O(+(+g[b+4>>2]));c=+O(+(+g[b+8>>2]));g[a+12>>2]=e;g[a+16>>2]=d;g[a+20>>2]=c;g[a+24>>2]=0.0;return}function Ey(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0.0,h=0,j=0,k=0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0;j=i;i=i+96|0;f=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);h=0;do{q=j+80+(h<<2)|0;c[j+80>>2]=0;c[j+84>>2]=0;c[j+88>>2]=0;c[j+92>>2]=0;g[q>>2]=1.0;k=c[(c[a>>2]|0)+64>>2]|0;l=+g[j+80>>2];m=+g[j+84>>2];n=+g[j+88>>2];o=l*+g[b+4>>2]+m*+g[b+20>>2]+n*+g[b+36>>2];p=l*+g[b+8>>2]+m*+g[b+24>>2]+n*+g[b+40>>2];g[j+48>>2]=+g[b>>2]*l+ +g[b+16>>2]*m+ +g[b+32>>2]*n;g[j+52>>2]=o;g[j+56>>2]=p;g[j+60>>2]=0.0;pc[k&127](j+64|0,a,j+48|0);p=+g[j+64>>2];o=+g[j+68>>2];n=+g[j+72>>2];m=p*+g[b+16>>2]+o*+g[b+20>>2]+n*+g[b+24>>2]+ +g[b+52>>2];l=p*+g[b+32>>2]+o*+g[b+36>>2]+n*+g[b+40>>2]+ +g[b+56>>2];g[j+32>>2]=p*+g[b>>2]+o*+g[b+4>>2]+n*+g[b+8>>2]+ +g[b+48>>2];g[j+36>>2]=m;g[j+40>>2]=l;g[j+44>>2]=0.0;k=j+32+(h<<2)|0;g[e+(h<<2)>>2]=f+ +g[k>>2];g[q>>2]=-1.0;q=c[(c[a>>2]|0)+64>>2]|0;l=+g[j+80>>2];m=+g[j+84>>2];n=+g[j+88>>2];o=l*+g[b+4>>2]+m*+g[b+20>>2]+n*+g[b+36>>2];p=l*+g[b+8>>2]+m*+g[b+24>>2]+n*+g[b+40>>2];g[j>>2]=+g[b>>2]*l+ +g[b+16>>2]*m+ +g[b+32>>2]*n;g[j+4>>2]=o;g[j+8>>2]=p;g[j+12>>2]=0.0;pc[q&127](j+16|0,a,j);p=+g[j+16>>2];o=+g[j+20>>2];n=+g[j+24>>2];m=p*+g[b+16>>2]+o*+g[b+20>>2]+n*+g[b+24>>2]+ +g[b+52>>2];l=p*+g[b+32>>2]+o*+g[b+36>>2]+n*+g[b+40>>2]+ +g[b+56>>2];g[j+32>>2]=p*+g[b>>2]+o*+g[b+4>>2]+n*+g[b+8>>2]+ +g[b+48>>2];g[j+36>>2]=m;g[j+40>>2]=l;g[j+44>>2]=0.0;g[d+(h<<2)>>2]=+g[k>>2]-f;h=h+1|0}while((h|0)!=3);i=j;return}function Fy(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0.0,h=0.0,j=0.0,k=0.0,l=0.0;e=i;pc[c[(c[b>>2]|0)+68>>2]&127](a,b,d);if(!(+Zb[c[(c[b>>2]|0)+48>>2]&15](b)!=0.0)){i=e;return}l=+g[d>>2];j=+g[d+4>>2];h=+g[d+8>>2];f=l*l+j*j+h*h<1.4210854715202004e-14?-1.0:h;k=l*l+j*j+h*h<1.4210854715202004e-14?-1.0:j;l=l*l+j*j+h*h<1.4210854715202004e-14?-1.0:l;h=1.0/+P(+(f*f+(l*l+k*k)));j=+Zb[c[(c[b>>2]|0)+48>>2]&15](b);g[a>>2]=h*l*j+ +g[a>>2];g[a+4>>2]=j*(h*k)+ +g[a+4>>2];g[a+8>>2]=j*(h*f)+ +g[a+8>>2];i=e;return}function Gy(a,b){a=a|0;b=b|0;var d=0;d=i;c[a+12>>2]=c[b+0>>2];c[a+16>>2]=c[b+4>>2];c[a+20>>2]=c[b+8>>2];c[a+24>>2]=c[b+12>>2];oy(a);i=d;return}function Hy(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0;k=i;f=c[b+96>>2]|0;if((f|0)==(c[b+100>>2]|0)?(j=(f|0)==0?1:f<<1,(f|0)<(j|0)):0){if(!j)g=0;else{c[5108]=(c[5108]|0)+1;f=QE((j<<4|3)+16|0)|0;if(!f)g=0;else{c[(f+19&-16)+-4>>2]=f;g=f+19&-16}f=c[b+96>>2]|0}if((f|0)>0){h=0;do{l=g+(h<<4)|0;m=(c[b+104>>2]|0)+(h<<4)|0;c[l+0>>2]=c[m+0>>2];c[l+4>>2]=c[m+4>>2];c[l+8>>2]=c[m+8>>2];c[l+12>>2]=c[m+12>>2];h=h+1|0}while((h|0)!=(f|0))}f=c[b+104>>2]|0;if(f){if(a[b+108>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[f+-4>>2]|0)}c[b+104>>2]=0}a[b+108>>0]=1;c[b+104>>2]=g;c[b+100>>2]=j;f=c[b+96>>2]|0}f=(c[b+104>>2]|0)+(f<<4)|0;c[f+0>>2]=c[d+0>>2];c[f+4>>2]=c[d+4>>2];c[f+8>>2]=c[d+8>>2];c[f+12>>2]=c[d+12>>2];c[b+96>>2]=(c[b+96>>2]|0)+1;if(!e){i=k;return}oy(b);i=k;return}function Iy(a,b,d){a=a|0;b=b|0;d=d|0;var e=0.0,f=0,h=0.0,j=0,k=0.0,l=0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0;r=i;l=c[b+96>>2]|0;if((l|0)<=0){c[a+0>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;c[a+12>>2]=0;i=r;return}m=+g[b+12>>2];p=+g[d>>2]*m;n=+g[b+16>>2];q=+g[d+4>>2]*n;o=+g[b+20>>2];k=+g[d+8>>2]*o;b=c[b+104>>2]|0;f=0;h=-3402823466385288598117041.0e14;j=-1;while(1){e=p*+g[b+(f<<4)>>2]+q*+g[b+(f<<4)+4>>2]+k*+g[b+(f<<4)+8>>2];d=e>h;j=d?f:j;f=f+1|0;if((f|0)==(l|0))break;else h=d?e:h}q=+g[b+(j<<4)+4>>2]*n;e=+g[b+(j<<4)+8>>2]*o;g[a>>2]=+g[b+(j<<4)>>2]*m;g[a+4>>2]=q;g[a+8>>2]=e;g[a+12>>2]=0.0;i=r;return}function Jy(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0.0,j=0.0,k=0.0,l=0,m=0,n=0,o=0.0,p=0.0,q=0.0,r=0.0,s=0,t=0,u=0.0,v=0;t=i;if((e|0)>0)f=0;else{i=t;return}do{g[d+(f<<4)+12>>2]=-999999984306749440.0;f=f+1|0}while((f|0)!=(e|0));n=0;do{h=+g[a+12>>2];p=+g[b+(n<<4)>>2]*h;j=+g[a+16>>2];r=+g[b+(n<<4)+4>>2]*j;k=+g[a+20>>2];q=+g[b+(n<<4)+8>>2]*k;f=c[a+96>>2]|0;if((f|0)>0){l=c[a+104>>2]|0;m=0;o=-3402823466385288598117041.0e14;s=-1;do{u=p*+g[l+(m<<4)>>2]+r*+g[l+(m<<4)+4>>2]+q*+g[l+(m<<4)+8>>2];v=u>o;s=v?m:s;o=v?u:o;m=m+1|0}while((m|0)!=(f|0));p=+g[l+(s<<4)+4>>2]*j;j=+g[l+(s<<4)+8>>2]*k;g[d+(n<<4)>>2]=+g[l+(s<<4)>>2]*h;g[d+(n<<4)+4>>2]=p;g[d+(n<<4)+8>>2]=j;g[d+(n<<4)+12>>2]=o}else g[d+(n<<4)+12>>2]=-999999984306749440.0;n=n+1|0}while((n|0)!=(e|0));i=t;return}function Ky(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0.0,h=0.0,j=0.0,k=0.0,l=0.0;e=i;pc[c[(c[b>>2]|0)+68>>2]&127](a,b,d);if(!(+Zb[c[(c[b>>2]|0)+48>>2]&15](b)!=0.0)){i=e;return}l=+g[d>>2];j=+g[d+4>>2];h=+g[d+8>>2];f=l*l+j*j+h*h<1.4210854715202004e-14?-1.0:h;k=l*l+j*j+h*h<1.4210854715202004e-14?-1.0:j;l=l*l+j*j+h*h<1.4210854715202004e-14?-1.0:l;h=1.0/+P(+(f*f+(l*l+k*k)));j=+Zb[c[(c[b>>2]|0)+48>>2]&15](b);g[a>>2]=h*l*j+ +g[a>>2];g[a+4>>2]=j*(h*k)+ +g[a+4>>2];g[a+8>>2]=j*(h*f)+ +g[a+8>>2];i=e;return}function Ly(a){a=a|0;return c[a+96>>2]|0}function My(a){a=a|0;return c[a+96>>2]|0}function Ny(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0.0,h=0.0,i=0,j=0;i=c[a+96>>2]|0;j=c[a+104>>2]|0;f=+g[j+(((b|0)%(i|0)|0)<<4)+4>>2]*+g[a+16>>2];h=+g[j+(((b|0)%(i|0)|0)<<4)+8>>2]*+g[a+20>>2];g[d>>2]=+g[j+(((b|0)%(i|0)|0)<<4)>>2]*+g[a+12>>2];g[d+4>>2]=f;g[d+8>>2]=h;g[d+12>>2]=0.0;d=c[a+104>>2]|0;h=+g[d+(((b+1|0)%(i|0)|0)<<4)+4>>2]*+g[a+16>>2];f=+g[d+(((b+1|0)%(i|0)|0)<<4)+8>>2]*+g[a+20>>2];g[e>>2]=+g[d+(((b+1|0)%(i|0)|0)<<4)>>2]*+g[a+12>>2];g[e+4>>2]=h;g[e+8>>2]=f;g[e+12>>2]=0.0;return}function Oy(a,b,d){a=a|0;b=b|0;d=d|0;var e=0.0,f=0.0,h=0;h=c[a+104>>2]|0;f=+g[h+(b<<4)+4>>2]*+g[a+16>>2];e=+g[h+(b<<4)+8>>2]*+g[a+20>>2];g[d>>2]=+g[h+(b<<4)>>2]*+g[a+12>>2];g[d+4>>2]=f;g[d+8>>2]=e;g[d+12>>2]=0.0;return}function Py(a){a=a|0;return 0}function Qy(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;return}function Ry(a,b,c){a=a|0;b=b|0;c=+c;return 0}function Sy(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,h=0,j=0;j=i;e=ec[c[(c[d>>2]|0)+40>>2]&31](d,a)|0;f=ec[c[(c[d>>2]|0)+28>>2]&31](d,e)|0;c[b>>2]=f;if(f)Lb[c[(c[d>>2]|0)+48>>2]&127](d,e);c[b+4>>2]=c[a+4>>2];g[b+28>>2]=+g[a+28>>2];g[b+32>>2]=+g[a+32>>2];g[b+36>>2]=+g[a+36>>2];g[b+40>>2]=+g[a+40>>2];g[b+12>>2]=+g[a+12>>2];g[b+16>>2]=+g[a+16>>2];g[b+20>>2]=+g[a+20>>2];g[b+24>>2]=+g[a+24>>2];g[b+44>>2]=+g[a+44>>2];f=c[a+96>>2]|0;c[b+60>>2]=f;if(!f){c[b+52>>2]=0;c[b+56>>2]=0;i=j;return 13936}c[b+52>>2]=ec[c[(c[d>>2]|0)+28>>2]&31](d,c[a+104>>2]|0)|0;c[b+56>>2]=0;h=Wb[c[(c[d>>2]|0)+16>>2]&63](d,16,f)|0;if((f|0)>0){e=c[a+104>>2]|0;b=0;a=c[h+8>>2]|0;while(1){g[a>>2]=+g[e+(b<<4)>>2];g[a+4>>2]=+g[e+(b<<4)+4>>2];g[a+8>>2]=+g[e+(b<<4)+8>>2];g[a+12>>2]=+g[e+(b<<4)+12>>2];b=b+1|0;if((b|0)==(f|0))break;else a=a+16|0}}else e=c[a+104>>2]|0;Hb[c[(c[d>>2]|0)+20>>2]&31](d,h,20224,1497453121,e);i=j;return 13936}function Ty(a,b,d,e,f,h,j){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;var k=0.0,l=0.0,m=0,n=0.0,o=0.0,p=0,q=0,r=0.0,s=0;q=i;i=i+16|0;g[e>>2]=3402823466385288598117041.0e14;g[f>>2]=-3402823466385288598117041.0e14;m=c[a+96>>2]|0;if((m|0)>0){p=0;do{s=c[a+104>>2]|0;r=+g[s+(p<<4)>>2]*+g[a+12>>2];k=+g[s+(p<<4)+4>>2]*+g[a+16>>2];n=+g[s+(p<<4)+8>>2]*+g[a+20>>2];l=r*+g[b>>2]+k*+g[b+4>>2]+n*+g[b+8>>2]+ +g[b+48>>2];o=r*+g[b+16>>2]+k*+g[b+20>>2]+n*+g[b+24>>2]+ +g[b+52>>2];n=r*+g[b+32>>2]+k*+g[b+36>>2]+n*+g[b+40>>2]+ +g[b+56>>2];k=l*+g[d>>2]+o*+g[d+4>>2]+n*+g[d+8>>2];if(k<+g[e>>2]){g[e>>2]=k;g[h>>2]=l;g[h+4>>2]=o;g[h+8>>2]=n;g[h+12>>2]=0.0}if(k>+g[f>>2]){g[f>>2]=k;g[j>>2]=l;g[j+4>>2]=o;g[j+8>>2]=n;g[j+12>>2]=0.0}p=p+1|0}while((p|0)!=(m|0));l=+g[f>>2]}else l=-3402823466385288598117041.0e14;k=+g[e>>2];if(!(k>l)){i=q;return}g[e>>2]=l;g[f>>2]=k;c[q+0>>2]=c[h+0>>2];c[q+4>>2]=c[h+4>>2];c[q+8>>2]=c[h+8>>2];c[q+12>>2]=c[h+12>>2];c[h+0>>2]=c[j+0>>2];c[h+4>>2]=c[j+4>>2];c[h+8>>2]=c[j+8>>2];c[h+12>>2]=c[j+12>>2];c[j+0>>2]=c[q+0>>2];c[j+4>>2]=c[q+4>>2];c[j+8>>2]=c[q+8>>2];c[j+12>>2]=c[q+12>>2];i=q;return}function Uy(a){a=a|0;return 68}function Vy(a){a=a|0;return 14e3}function Wy(b){b=b|0;var d=0,e=0,f=0;f=i;c[b>>2]=13808;d=c[b+104>>2]|0;if(d){if(a[b+108>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}c[b+104>>2]=0}a[b+108>>0]=1;c[b+104>>2]=0;c[b+96>>2]=0;c[b+100>>2]=0;c[b>>2]=13336;d=c[b+52>>2]|0;if((d|0)!=0?(Jb[c[c[d>>2]>>2]&255](d),e=c[b+52>>2]|0,(e|0)!=0):0){c[5110]=(c[5110]|0)+1;RE(c[e+-4>>2]|0)}if(!b){i=f;return}c[5110]=(c[5110]|0)+1;RE(c[b+-4>>2]|0);i=f;return}function Xy(b){b=b|0;var d=0,e=0;e=i;c[b>>2]=13808;d=c[b+104>>2]|0;if(d){if(a[b+108>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}c[b+104>>2]=0}a[b+108>>0]=1;c[b+104>>2]=0;c[b+96>>2]=0;c[b+100>>2]=0;c[b>>2]=13336;d=c[b+52>>2]|0;if(!d){i=e;return}Jb[c[c[d>>2]>>2]&255](d);d=c[b+52>>2]|0;if(!d){i=e;return}c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0);i=e;return}function Yy(a){a=a|0;return}function Zy(a){a=a|0;return}function _y(a,b,d){a=a|0;b=b|0;d=d|0;var e=0.0,f=0.0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0;q=i;i=i+32|0;c[a+0>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;c[a+12>>2]=0;e=+g[d>>2];f=+g[d+4>>2];h=+g[d+8>>2];if(e*e+f*f+h*h<9.999999747378752e-05){p=1.0;o=0.0;n=0.0}else{n=1.0/+P(+(e*e+f*f+h*h));p=e*n;o=f*n;n=h*n}d=c[b+52>>2]|0;m=+g[b+(((d+2|0)%3|0)<<2)+28>>2];c[q+16>>2]=0;c[q+20>>2]=0;c[q+24>>2]=0;c[q+28>>2]=0;g[q+16+(d<<2)>>2]=+g[b+(d<<2)+28>>2];k=p*m;l=o*m;m=n*m;j=k+ +g[q+16>>2];e=l+ +g[q+20>>2];h=m+ +g[q+24>>2];f=+Zb[c[(c[b>>2]|0)+48>>2]&15](b);j=j-p*f;e=e-o*f;f=h-n*f;h=n*f+(p*j+o*e);if(h>-999999984306749440.0){g[a>>2]=j;g[a+4>>2]=e;g[a+8>>2]=f;g[a+12>>2]=0.0;j=h}else j=-999999984306749440.0;c[q+0>>2]=0;c[q+4>>2]=0;c[q+8>>2]=0;c[q+12>>2]=0;d=c[b+52>>2]|0;g[q+(d<<2)>>2]=-+g[b+(d<<2)+28>>2];h=k+ +g[q>>2];e=l+ +g[q+4>>2];k=m+ +g[q+8>>2];f=+Zb[c[(c[b>>2]|0)+48>>2]&15](b);h=h-p*f;e=e-o*f;f=k-n*f;if(!(n*f+(p*h+o*e)>j)){i=q;return}g[a>>2]=h;g[a+4>>2]=e;g[a+8>>2]=f;g[a+12>>2]=0.0;i=q;return}
function vs(d,e,f){d=d|0;e=e|0;f=+f;var h=0,j=0.0,k=0.0,l=0,m=0.0,n=0.0,o=0,p=0,q=0.0,r=0.0,s=0;s=i;i=i+528|0;if((a[d+171>>0]|0)==0?+g[d+172>>2]<=0.0:0){i=s;return}a[d+168>>0]=(Nb[c[(c[d>>2]|0)+48>>2]&127](d)|0)&1;m=+g[d+16>>2]-+g[d+44>>2]*f;g[d+16>>2]=m;if(m>0.0?(j=+g[d+28>>2],m>j):0)g[d+16>>2]=j;else j=m;if(j<0.0?(m=+O(+j),n=+O(+(+g[d+24>>2])),m>n):0){g[d+16>>2]=-n;j=-n}g[d+20>>2]=j*f;h=c[d+8>>2]|0;c[s+0>>2]=c[h+4>>2];c[s+4>>2]=c[h+8>>2];c[s+8>>2]=c[h+12>>2];c[s+12>>2]=c[h+16>>2];c[s+16>>2]=c[h+20>>2];c[s+20>>2]=c[h+24>>2];c[s+24>>2]=c[h+28>>2];c[s+28>>2]=c[h+32>>2];c[s+32>>2]=c[h+36>>2];c[s+36>>2]=c[h+40>>2];c[s+40>>2]=c[h+44>>2];c[s+44>>2]=c[h+48>>2];c[s+48>>2]=c[h+52>>2];c[s+52>>2]=c[h+56>>2];c[s+56>>2]=c[h+60>>2];c[s+60>>2]=c[h+64>>2];h=c[d+176>>2]|0;if((a[5128]|0)==0?(Xa(5128)|0)!=0:0){g[1270]=1.0;c[1271]=0;c[1272]=0;c[1273]=0;c[1274]=0;g[1275]=1.0;c[1276]=0;c[1277]=0;c[1278]=0;c[1279]=0;g[1280]=1.0;g[1281]=0.0;ab(5128)}n=+g[d+20>>2];n=+g[d+52>>2]+(n>0.0?n:0.0);m=+g[5084+(h<<4)>>2]*n+ +g[d+96>>2];j=n*+g[5088+(h<<4)>>2]+ +g[d+100>>2];g[d+112>>2]=+g[d+92>>2]+ +g[5080+(h<<4)>>2]*n;g[d+116>>2]=m;g[d+120>>2]=j;g[d+124>>2]=0.0;g[s+456>>2]=1.0;c[s+460>>2]=0;c[s+464>>2]=0;c[s+468>>2]=0;c[s+472>>2]=0;g[s+476>>2]=1.0;c[s+480>>2]=0;c[s+484>>2]=0;c[s+488>>2]=0;c[s+492>>2]=0;g[s+496>>2]=1.0;h=s+500|0;c[h+0>>2]=0;c[h+4>>2]=0;c[h+8>>2]=0;c[h+12>>2]=0;c[h+16>>2]=0;g[s+392>>2]=1.0;c[s+396>>2]=0;c[s+400>>2]=0;c[s+404>>2]=0;c[s+408>>2]=0;g[s+412>>2]=1.0;c[s+416>>2]=0;c[s+420>>2]=0;c[s+424>>2]=0;c[s+428>>2]=0;g[s+432>>2]=1.0;h=s+436|0;c[h+0>>2]=0;c[h+4>>2]=0;c[h+8>>2]=0;c[h+12>>2]=0;c[h+16>>2]=0;h=c[d+176>>2]|0;if((a[5128]|0)==0?(Xa(5128)|0)!=0:0){g[1270]=1.0;c[1271]=0;c[1272]=0;c[1273]=0;c[1274]=0;g[1275]=1.0;c[1276]=0;c[1277]=0;c[1278]=0;c[1279]=0;g[1280]=1.0;g[1281]=0.0;ab(5128)}l=c[d+12>>2]|0;n=+Zb[c[(c[l>>2]|0)+48>>2]&15](l);n=n+ +g[d+56>>2];m=n*+g[5084+(h<<4)>>2]+ +g[d+96>>2];j=n*+g[5088+(h<<4)>>2]+ +g[d+100>>2];g[s+504>>2]=+g[5080+(h<<4)>>2]*n+ +g[d+92>>2];g[s+508>>2]=m;g[s+512>>2]=j;g[s+516>>2]=0.0;c[s+440>>2]=c[d+112>>2];c[s+444>>2]=c[d+116>>2];c[s+448>>2]=c[d+120>>2];c[s+452>>2]=c[d+124>>2];h=c[d+8>>2]|0;l=c[d+176>>2]|0;if((a[5128]|0)==0?(Xa(5128)|0)!=0:0){g[1270]=1.0;c[1271]=0;c[1272]=0;c[1273]=0;c[1274]=0;g[1275]=1.0;c[1276]=0;c[1277]=0;c[1278]=0;c[1279]=0;g[1280]=1.0;g[1281]=0.0;ab(5128)}n=-+g[5080+(l<<4)>>2];m=-+g[5084+(l<<4)>>2];j=-+g[5088+(l<<4)>>2];g[s+292>>2]=1.0;l=s+300|0;c[s+364>>2]=0;c[l+0>>2]=0;c[l+4>>2]=0;c[l+8>>2]=0;c[l+12>>2]=0;c[l+16>>2]=0;c[l+20>>2]=0;c[l+24>>2]=0;c[l+28>>2]=0;c[s+288>>2]=5256;c[s+368>>2]=h;g[s+372>>2]=n;g[s+376>>2]=m;g[s+380>>2]=j;g[s+384>>2]=0.0;g[s+388>>2]=.707099974155426;h=c[d+8>>2]|0;l=c[h+188>>2]|0;b[s+296>>1]=b[l+4>>1]|0;b[s+298>>1]=b[l+6>>1]|0;if(!(a[d+170>>0]|0))_u(e,c[d+12>>2]|0,s+456|0,s+392|0,s+288|0,0.0);else Ss(h,c[d+12>>2]|0,s+456|0,s+392|0,s+288|0,+g[e+56>>2]);if(+g[s+292>>2]<1.0){h=c[d+176>>2]|0;if((a[5128]|0)==0?(Xa(5128)|0)!=0:0){g[1270]=1.0;c[1271]=0;c[1272]=0;c[1273]=0;c[1274]=0;g[1275]=1.0;c[1276]=0;c[1277]=0;c[1278]=0;c[1279]=0;g[1280]=1.0;g[1281]=0.0;ab(5128)}do if(+g[s+332>>2]*+g[5080+(h<<4)>>2]+ +g[s+336>>2]*+g[5084+(h<<4)>>2]+ +g[s+340>>2]*+g[5088+(h<<4)>>2]>0.0){j=+g[s+292>>2];g[d+108>>2]=+g[d+52>>2]*j;if(!(a[d+180>>0]|0)){c[d+92>>2]=c[d+112>>2];c[d+96>>2]=c[d+116>>2];c[d+100>>2]=c[d+120>>2];c[d+104>>2]=c[d+124>>2];break}else{g[d+92>>2]=(1.0-j)*+g[d+92>>2]+j*+g[d+112>>2];g[d+96>>2]=(1.0-j)*+g[d+96>>2]+j*+g[d+116>>2];g[d+100>>2]=(1.0-j)*+g[d+100>>2]+j*+g[d+120>>2];break}}while(0);g[d+16>>2]=0.0;g[d+20>>2]=0.0}else{g[d+108>>2]=+g[d+52>>2];c[d+92>>2]=c[d+112>>2];c[d+96>>2]=c[d+116>>2];c[d+100>>2]=c[d+120>>2];c[d+104>>2]=c[d+124>>2]}if(!(a[d+171>>0]|0)){m=+g[d+172>>2];j=m>f?f:m;g[d+172>>2]=m-f;ps(d,e,+g[d+60>>2]*j,j*+g[d+64>>2],j*+g[d+68>>2])}else ps(d,e,+g[d+60>>2],+g[d+64>>2],+g[d+68>>2]);c[s+272>>2]=c[d+112>>2];c[s+276>>2]=c[d+116>>2];c[s+280>>2]=c[d+120>>2];c[s+284>>2]=c[d+124>>2];j=+g[d+16>>2];if(j<0.0)j=-j;else j=0.0;j=j*f;do if(j>0.0?(k=+g[d+24>>2],j>k):0){if((a[d+168>>0]|0)==0?(a[d+169>>0]|0)!=0:0){k=j;break}}else k=j;while(0);l=c[d+176>>2]|0;if((a[5128]|0)==0?(Xa(5128)|0)!=0:0){g[1270]=1.0;c[1271]=0;c[1272]=0;c[1273]=0;c[1274]=0;g[1275]=1.0;c[1276]=0;c[1277]=0;c[1278]=0;c[1279]=0;g[1280]=1.0;g[1281]=0.0;ab(5128)}j=k+ +g[d+108>>2];q=+g[5080+(l<<4)>>2]*j;r=j*+g[5084+(l<<4)>>2];j=j*+g[5088+(l<<4)>>2];g[d+112>>2]=+g[d+112>>2]-q;g[d+116>>2]=+g[d+116>>2]-r;g[d+120>>2]=+g[d+120>>2]-j;l=c[d+8>>2]|0;h=c[d+176>>2]|0;if((a[5128]|0)==0?(Xa(5128)|0)!=0:0){g[1270]=1.0;c[1271]=0;c[1272]=0;c[1273]=0;c[1274]=0;g[1275]=1.0;c[1276]=0;c[1277]=0;c[1278]=0;c[1279]=0;g[1280]=1.0;g[1281]=0.0;ab(5128)}k=+g[d+40>>2];p=s+172|0;g[p>>2]=1.0;o=s+180|0;c[s+244>>2]=0;c[o+0>>2]=0;c[o+4>>2]=0;c[o+8>>2]=0;c[o+12>>2]=0;c[o+16>>2]=0;c[o+20>>2]=0;c[o+24>>2]=0;c[o+28>>2]=0;c[s+168>>2]=5256;c[s+248>>2]=l;c[s+252>>2]=c[5080+(h<<4)>>2];c[s+256>>2]=c[5084+(h<<4)>>2];c[s+260>>2]=c[5088+(h<<4)>>2];c[s+264>>2]=c[5092+(h<<4)>>2];g[s+268>>2]=k;l=c[d+8>>2]|0;h=c[l+188>>2]|0;b[s+176>>1]=b[h+4>>1]|0;b[s+178>>1]=b[h+6>>1]|0;h=c[d+176>>2]|0;if((a[5128]|0)==0?(Xa(5128)|0)!=0:0){g[1270]=1.0;c[1271]=0;c[1272]=0;c[1273]=0;c[1274]=0;g[1275]=1.0;c[1276]=0;c[1277]=0;c[1278]=0;c[1279]=0;g[1280]=1.0;g[1281]=0.0;ab(5128)}n=+g[d+40>>2];g[s+68>>2]=1.0;o=s+76|0;c[s+140>>2]=0;c[o+0>>2]=0;c[o+4>>2]=0;c[o+8>>2]=0;c[o+12>>2]=0;c[o+16>>2]=0;c[o+20>>2]=0;c[o+24>>2]=0;c[o+28>>2]=0;c[s+64>>2]=5256;c[s+144>>2]=l;c[s+148>>2]=c[5080+(h<<4)>>2];c[s+152>>2]=c[5084+(h<<4)>>2];c[s+156>>2]=c[5088+(h<<4)>>2];c[s+160>>2]=c[5092+(h<<4)>>2];g[s+164>>2]=n;l=c[(c[d+8>>2]|0)+188>>2]|0;b[s+72>>1]=b[l+4>>1]|0;b[s+74>>1]=b[l+6>>1]|0;n=+g[d+112>>2];m=+g[d+116>>2];k=+g[d+120>>2];l=0;while(1){g[s+456>>2]=1.0;c[s+460>>2]=0;c[s+464>>2]=0;c[s+468>>2]=0;c[s+472>>2]=0;g[s+476>>2]=1.0;c[s+480>>2]=0;c[s+484>>2]=0;c[s+488>>2]=0;c[s+492>>2]=0;g[s+496>>2]=1.0;c[s+500>>2]=0;g[s+392>>2]=1.0;c[s+396>>2]=0;c[s+400>>2]=0;c[s+404>>2]=0;c[s+408>>2]=0;g[s+412>>2]=1.0;c[s+416>>2]=0;c[s+420>>2]=0;c[s+424>>2]=0;c[s+428>>2]=0;g[s+432>>2]=1.0;c[s+436>>2]=0;g[s+288>>2]=1.0;c[s+292>>2]=0;c[s+296>>2]=0;c[s+300>>2]=0;c[s+304>>2]=0;g[s+308>>2]=1.0;c[s+312>>2]=0;c[s+316>>2]=0;c[s+320>>2]=0;c[s+324>>2]=0;g[s+328>>2]=1.0;c[s+332>>2]=0;c[s+336>>2]=0;c[s+340>>2]=0;c[s+504>>2]=c[d+92>>2];c[s+508>>2]=c[d+96>>2];c[s+512>>2]=c[d+100>>2];c[s+516>>2]=c[d+104>>2];c[s+440>>2]=c[d+112>>2];c[s+444>>2]=c[d+116>>2];c[s+448>>2]=c[d+120>>2];c[s+452>>2]=c[d+124>>2];g[s+336>>2]=n-q;g[s+340>>2]=m-r;g[s+344>>2]=k-j;g[s+348>>2]=0.0;if(!(a[d+170>>0]|0)){_u(e,c[d+12>>2]|0,s+456|0,s+392|0,s+168|0,+g[e+56>>2]);if(!(+g[p>>2]<1.0))_u(e,c[d+12>>2]|0,s+456|0,s+288|0,s+64|0,+g[e+56>>2])}else{Ss(c[d+8>>2]|0,c[d+12>>2]|0,s+456|0,s+392|0,s+168|0,+g[e+56>>2]);if(!(+g[p>>2]<1.0))Ss(c[d+8>>2]|0,c[d+12>>2]|0,s+456|0,s+288|0,s+64|0,+g[e+56>>2])}k=+g[d+16>>2];if(k<0.0)n=-k;else n=0.0;n=n*f;o=(a[d+182>>0]|0)==0;if(!o?+g[p>>2]<1.0:0)h=1;else h=+g[s+68>>2]<1.0;if(!(n>0.0))break;m=+g[d+52>>2];if(!(n<m)|h^1|l)break;if((a[d+168>>0]|0)==0?(a[d+169>>0]|0)!=0:0){l=0;break};c[d+112>>2]=c[s+272>>2];c[d+116>>2]=c[s+276>>2];c[d+120>>2]=c[s+280>>2];c[d+124>>2]=c[s+284>>2];l=c[d+176>>2]|0;do if(!(a[5128]|0)){if(!(Xa(5128)|0))break;g[1270]=1.0;c[1271]=0;c[1272]=0;c[1273]=0;c[1274]=0;g[1275]=1.0;c[1276]=0;c[1277]=0;c[1278]=0;c[1279]=0;g[1280]=1.0;g[1281]=0.0;ab(5128)}while(0);n=m+ +g[d+108>>2];m=n*+g[5084+(l<<4)>>2];k=n*+g[5088+(l<<4)>>2];n=+g[d+112>>2]-+g[5080+(l<<4)>>2]*n;g[d+112>>2]=n;m=+g[d+116>>2]-m;g[d+116>>2]=m;k=+g[d+120>>2]-k;g[d+120>>2]=k;l=1}n=+g[p>>2];if(n<1.0|l){j=+g[d+96>>2];k=(j-+g[s+232>>2])*.5;do if(!o)if(!(a[d+181>>0]|0)){g[d+92>>2]=(1.0-k)*+g[d+92>>2]+k*+g[d+112>>2];g[d+96>>2]=(1.0-k)*j+k*+g[d+116>>2];g[d+100>>2]=(1.0-k)*+g[d+100>>2]+k*+g[d+120>>2];h=d+181|0;break}else{g[d+92>>2]=(1.0-n)*+g[d+92>>2]+n*+g[d+112>>2];g[d+96>>2]=(1.0-n)*j+n*+g[d+116>>2];g[d+100>>2]=(1.0-n)*+g[d+100>>2]+n*+g[d+120>>2];h=d+181|0;break}else{g[d+92>>2]=(1.0-n)*+g[d+92>>2]+n*+g[d+112>>2];g[d+96>>2]=(1.0-n)*j+n*+g[d+116>>2];g[d+100>>2]=(1.0-n)*+g[d+100>>2]+n*+g[d+120>>2];h=d+181|0}while(0);a[h>>0]=0;g[d+16>>2]=0.0;g[d+20>>2]=0.0;a[d+169>>0]=0}else{a[d+181>>0]=1;do if(!o){if(k<0.0)k=-k;else k=0.0;m=+g[d+24>>2];if(k*f>m){if((a[d+168>>0]|0)==0?(a[d+169>>0]|0)!=0:0)break;g[d+112>>2]=q+ +g[d+112>>2];g[d+116>>2]=r+ +g[d+116>>2];g[d+120>>2]=j+ +g[d+120>>2];h=c[d+176>>2]|0;do if(!(a[5128]|0)){if(!(Xa(5128)|0))break;g[1270]=1.0;c[1271]=0;c[1272]=0;c[1273]=0;c[1274]=0;g[1275]=1.0;c[1276]=0;c[1277]=0;c[1278]=0;c[1279]=0;g[1280]=1.0;g[1281]=0.0;ab(5128)}while(0);m=m+ +g[d+108>>2];k=m*+g[5084+(h<<4)>>2];j=m*+g[5088+(h<<4)>>2];g[d+112>>2]=+g[d+112>>2]-+g[5080+(h<<4)>>2]*m;g[d+116>>2]=+g[d+116>>2]-k;g[d+120>>2]=+g[d+120>>2]-j}}while(0);c[d+92>>2]=c[d+112>>2];c[d+96>>2]=c[d+116>>2];c[d+100>>2]=c[d+120>>2];c[d+104>>2]=c[d+124>>2]};c[s+48>>2]=c[d+92>>2];c[s+52>>2]=c[d+96>>2];c[s+56>>2]=c[d+100>>2];c[s+60>>2]=c[d+104>>2];h=c[d+8>>2]|0;c[h+260>>2]=(c[h+260>>2]|0)+1;c[h+4>>2]=c[s+0>>2];c[h+8>>2]=c[s+4>>2];c[h+12>>2]=c[s+8>>2];c[h+16>>2]=c[s+12>>2];c[h+20>>2]=c[s+16>>2];c[h+24>>2]=c[s+20>>2];c[h+28>>2]=c[s+24>>2];c[h+32>>2]=c[s+28>>2];c[h+36>>2]=c[s+32>>2];c[h+40>>2]=c[s+36>>2];c[h+44>>2]=c[s+40>>2];c[h+48>>2]=c[s+44>>2];c[h+52>>2]=c[s+48>>2];c[h+56>>2]=c[s+52>>2];c[h+60>>2]=c[s+56>>2];c[h+64>>2]=c[s+60>>2];i=s;return}function ws(a){a=a|0;var b=0;b=i;a=Nb[c[(c[a>>2]|0)+48>>2]&127](a)|0;i=b;return a|0}function xs(b){b=b|0;var d=0;d=i;if(!(Nb[c[(c[b>>2]|0)+40>>2]&127](b)|0)){i=d;return}g[b+16>>2]=+g[b+28>>2];a[b+169>>0]=1;i=d;return}function ys(a){a=a|0;var b=0;b=i;if(!(+g[a+16>>2]==0.0)){a=0;i=b;return a|0}a=+g[a+20>>2]==0.0;i=b;return a|0}function zs(a,b){a=a|0;b=b|0;return}function As(b,c){b=b|0;c=c|0;a[b+180>>0]=c&1;return}function Bs(a,b,d){a=a|0;b=b|0;d=+d;var e=0;e=i;Lb[c[(c[a>>2]|0)+32>>2]&127](a,b);rc[c[(c[a>>2]|0)+36>>2]&7](a,b,d);i=e;return}function Cs(a,b,d){a=a|0;b=b|0;d=d|0;var e=0.0,f=0.0,h=0.0,j=0,k=0.0,l=0.0,m=0;m=i;j=c[b>>2]|0;if((j|0)==(c[a+80>>2]|0)){e=1.0;i=m;return +e}if(c[j+204>>2]&4){e=1.0;i=m;return +e}f=+g[b+8>>2];h=+g[b+12>>2];e=+g[b+16>>2];if(d){k=f;l=h}else{k=+g[j+4>>2]*f+ +g[j+8>>2]*h+ +g[j+12>>2]*e;l=f*+g[j+20>>2]+h*+g[j+24>>2]+e*+g[j+28>>2];e=f*+g[j+36>>2]+h*+g[j+40>>2]+e*+g[j+44>>2]}if(k*+g[a+84>>2]+l*+g[a+88>>2]+e*+g[a+92>>2]<+g[a+100>>2]){e=1.0;i=m;return +e}g[a+4>>2]=+g[b+40>>2];c[a+76>>2]=j;if(d){c[a+44>>2]=c[b+8>>2];c[a+48>>2]=c[b+12>>2];c[a+52>>2]=c[b+16>>2];c[a+56>>2]=c[b+20>>2]}else{l=+g[b+8>>2];k=+g[b+12>>2];h=+g[b+16>>2];f=l*+g[j+20>>2]+k*+g[j+24>>2]+h*+g[j+28>>2];e=l*+g[j+36>>2]+k*+g[j+40>>2]+h*+g[j+44>>2];g[a+44>>2]=+g[j+4>>2]*l+ +g[j+8>>2]*k+ +g[j+12>>2]*h;g[a+48>>2]=f;g[a+52>>2]=e;g[a+56>>2]=0.0}c[a+60>>2]=c[b+24>>2];c[a+64>>2]=c[b+28>>2];c[a+68>>2]=c[b+32>>2];c[a+72>>2]=c[b+36>>2];e=+g[b+40>>2];i=m;return +e}function Ds(a){a=a|0;var b=0;b=i;RE(a);i=b;return}function Es(a,b){a=a|0;b=b|0;var d=0,e=0.0,f=0.0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0,y=0,z=0.0,A=0,B=0.0,C=0.0,D=0.0;A=i;d=c[a+748>>2]|0;if((d|0)!=4){c[a+748>>2]=d+1;x=(d|0)<0;d=x?0:d;a=a+(d*184|0)+4|0;YE(a|0,b|0,184)|0;i=A;return d|0}z=+g[b+80>>2];p=+g[a+84>>2];o=p<z?p:z;n=+g[a+268>>2];m=n<o?n:o;l=+g[a+452>>2];x=+g[a+636>>2]<(l<m?l:m);d=x?3:l<m?2:n<o?1:(p<z^1)<<31>>31;z=+g[b>>2];if(d){h=+g[a+188>>2];e=+g[b+4>>2];n=+g[a+192>>2];o=+g[b+8>>2];m=+g[a+196>>2];r=+g[a+556>>2];s=+g[a+372>>2];t=+g[a+560>>2];q=+g[a+376>>2];u=+g[a+564>>2];l=+g[a+380>>2];j=((z-h)*(t-q)-(e-n)*(r-s))*((z-h)*(t-q)-(e-n)*(r-s))+(((e-n)*(u-l)-(o-m)*(t-q))*((e-n)*(u-l)-(o-m)*(t-q))+((o-m)*(r-s)-(z-h)*(u-l))*((o-m)*(r-s)-(z-h)*(u-l)));if((d|0)==1){f=+g[a+4>>2];k=+g[a+8>>2];w=e;p=+g[a+12>>2];v=h;e=u;h=0.0;y=7}else{v=h;y=6}}else{v=+g[a+188>>2];n=+g[a+192>>2];m=+g[a+196>>2];e=+g[b+4>>2];o=+g[b+8>>2];s=+g[a+372>>2];r=+g[a+556>>2];q=+g[a+376>>2];t=+g[a+560>>2];l=+g[a+380>>2];u=+g[a+564>>2];j=0.0;y=6}if((y|0)==6){f=+g[a+4>>2];k=+g[a+8>>2];D=e-k;p=+g[a+12>>2];B=o-p;w=r-s;C=t-q;h=u-l;h=((z-f)*C-D*w)*((z-f)*C-D*w)+((D*h-B*C)*(D*h-B*C)+(B*w-(z-f)*h)*(B*w-(z-f)*h));if((d|0)==2){t=e;u=v;r=s;e=0.0;y=8}else{w=e;e=u;y=7}}if((y|0)==7){D=z-f;u=w-k;B=o-p;C=r-v;r=t-n;e=e-m;e=(D*r-u*C)*(D*r-u*C)+((u*e-B*r)*(u*e-B*r)+(B*C-D*e)*(B*C-D*e));if(x)f=0.0;else{t=w;u=v;r=s;y=8}}if((y|0)==8){D=z-f;k=t-k;o=o-p;p=r-u;n=q-n;f=l-m;f=(D*n-k*p)*(D*n-k*p)+((k*f-o*n)*(k*f-o*n)+(o*p-D*f)*(o*p-D*f))}p=+O(+j);n=+O(+h);l=+O(+e);k=+O(+f);o=p>-999999984306749440.0?p:-999999984306749440.0;m=n>o?n:o;d=k>(l>m?l:m)?3:l>m?2:n>o?1:(p>-999999984306749440.0^1)<<31>>31;x=(d|0)<0;d=x?0:d;a=a+(d*184|0)+4|0;YE(a|0,b|0,184)|0;i=A;return d|0}function Fs(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,h=0.0,j=0.0,k=0,l=0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0;l=i;f=c[b+748>>2]|0;if((f|0)<=0){i=l;return}do{f=f+-1|0;q=+g[b+(f*184|0)+4>>2];r=+g[b+(f*184|0)+8>>2];j=+g[b+(f*184|0)+12>>2];p=q*+g[d>>2]+r*+g[d+4>>2]+j*+g[d+8>>2]+ +g[d+48>>2];n=q*+g[d+16>>2]+r*+g[d+20>>2]+j*+g[d+24>>2]+ +g[d+52>>2];j=q*+g[d+32>>2]+r*+g[d+36>>2]+j*+g[d+40>>2]+ +g[d+56>>2];g[b+(f*184|0)+52>>2]=p;g[b+(f*184|0)+56>>2]=n;g[b+(f*184|0)+60>>2]=j;g[b+(f*184|0)+64>>2]=0.0;r=+g[b+(f*184|0)+20>>2];q=+g[b+(f*184|0)+24>>2];h=+g[b+(f*184|0)+28>>2];o=r*+g[e>>2]+q*+g[e+4>>2]+h*+g[e+8>>2]+ +g[e+48>>2];m=r*+g[e+16>>2]+q*+g[e+20>>2]+h*+g[e+24>>2]+ +g[e+52>>2];h=r*+g[e+32>>2]+q*+g[e+36>>2]+h*+g[e+40>>2]+ +g[e+56>>2];g[b+(f*184|0)+36>>2]=o;g[b+(f*184|0)+40>>2]=m;g[b+(f*184|0)+44>>2]=h;g[b+(f*184|0)+48>>2]=0.0;g[b+(f*184|0)+84>>2]=(p-o)*+g[b+(f*184|0)+68>>2]+(n-m)*+g[b+(f*184|0)+72>>2]+(j-h)*+g[b+(f*184|0)+76>>2];k=b+(f*184|0)+152|0;c[k>>2]=(c[k>>2]|0)+1}while((f|0)>0);f=c[b+748>>2]|0;if((f|0)<=0){i=l;return}d=f;k=f;while(1){k=k+-1|0;e=b+(k*184|0)+4|0;h=+g[b+(k*184|0)+84>>2];j=+g[b+752>>2];if(h<=j){n=+g[b+(k*184|0)+36>>2]-(+g[b+(k*184|0)+52>>2]-+g[b+(k*184|0)+68>>2]*h);m=+g[b+(k*184|0)+40>>2]-(+g[b+(k*184|0)+56>>2]-h*+g[b+(k*184|0)+72>>2]);h=+g[b+(k*184|0)+44>>2]-(+g[b+(k*184|0)+60>>2]-h*+g[b+(k*184|0)+76>>2]);if(n*n+m*m+h*h>j*j){f=d+-1|0;if((f|0)==(k|0))f=d;else{YE(e|0,b+(f*184|0)+4|0,184)|0;c[b+(f*184|0)+116>>2]=0;g[b+(f*184|0)+124>>2]=0.0;a[b+(f*184|0)+120>>0]=0;g[b+(f*184|0)+128>>2]=0.0;g[b+(f*184|0)+132>>2]=0.0;c[b+(f*184|0)+152>>2]=0;f=c[b+748>>2]|0}f=f+-1|0;c[b+748>>2]=f}else f=d}else{f=d+-1|0;if((f|0)==(k|0))f=d;else{YE(e|0,b+(f*184|0)+4|0,184)|0;c[b+(f*184|0)+116>>2]=0;g[b+(f*184|0)+124>>2]=0.0;a[b+(f*184|0)+120>>0]=0;g[b+(f*184|0)+128>>2]=0.0;g[b+(f*184|0)+132>>2]=0.0;c[b+(f*184|0)+152>>2]=0;f=c[b+748>>2]|0}f=f+-1|0;c[b+748>>2]=f}if((k|0)<=0)break;else d=f}i=l;return}function Gs(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,h=0,j=0.0;f=i;g[b+16>>2]=+g[a+4>>2];g[b+20>>2]=+g[a+8>>2];g[b+24>>2]=+g[a+12>>2];g[b+28>>2]=+g[a+16>>2];g[b+32>>2]=+g[a+20>>2];g[b+36>>2]=+g[a+24>>2];g[b+40>>2]=+g[a+28>>2];g[b+44>>2]=+g[a+32>>2];g[b+48>>2]=+g[a+36>>2];g[b+52>>2]=+g[a+40>>2];g[b+56>>2]=+g[a+44>>2];g[b+60>>2]=+g[a+48>>2];g[b+64>>2]=+g[a+52>>2];g[b+68>>2]=+g[a+56>>2];g[b+72>>2]=+g[a+60>>2];g[b+76>>2]=+g[a+64>>2];g[b+80>>2]=+g[a+68>>2];g[b+84>>2]=+g[a+72>>2];g[b+88>>2]=+g[a+76>>2];g[b+92>>2]=+g[a+80>>2];g[b+96>>2]=+g[a+84>>2];g[b+100>>2]=+g[a+88>>2];g[b+104>>2]=+g[a+92>>2];g[b+108>>2]=+g[a+96>>2];g[b+112>>2]=+g[a+100>>2];g[b+116>>2]=+g[a+104>>2];g[b+120>>2]=+g[a+108>>2];g[b+124>>2]=+g[a+112>>2];g[b+128>>2]=+g[a+116>>2];g[b+132>>2]=+g[a+120>>2];g[b+136>>2]=+g[a+124>>2];g[b+140>>2]=+g[a+128>>2];g[b+144>>2]=+g[a+132>>2];g[b+148>>2]=+g[a+136>>2];g[b+152>>2]=+g[a+140>>2];g[b+156>>2]=+g[a+144>>2];g[b+160>>2]=+g[a+148>>2];g[b+164>>2]=+g[a+152>>2];g[b+168>>2]=+g[a+156>>2];g[b+172>>2]=+g[a+160>>2];g[b+176>>2]=+g[a+164>>2];g[b+180>>2]=+g[a+168>>2];g[b+184>>2]=+g[a+172>>2];g[b+188>>2]=+g[a+176>>2];c[b+224>>2]=c[a+180>>2];g[b+192>>2]=+g[a+184>>2];c[b>>2]=0;c[b+4>>2]=ec[c[(c[d>>2]|0)+28>>2]&31](d,c[a+192>>2]|0)|0;c[b+8>>2]=0;c[b+228>>2]=c[a+204>>2];c[b+232>>2]=c[a+208>>2];c[b+236>>2]=c[a+212>>2];c[b+240>>2]=c[a+216>>2];g[b+196>>2]=+g[a+220>>2];g[b+200>>2]=+g[a+224>>2];g[b+204>>2]=+g[a+232>>2];g[b+208>>2]=+g[a+228>>2];c[b+244>>2]=c[a+236>>2];e=ec[c[(c[d>>2]|0)+40>>2]&31](d,a)|0;h=ec[c[(c[d>>2]|0)+28>>2]&31](d,e)|0;c[b+12>>2]=h;if(!h){d=a+244|0;j=+g[d>>2];d=b+212|0;g[d>>2]=j;d=a+248|0;j=+g[d>>2];d=b+216|0;g[d>>2]=j;d=a+252|0;j=+g[d>>2];d=b+220|0;g[d>>2]=j;d=a+256|0;d=c[d>>2]|0;e=b+248|0;c[e>>2]=d;i=f;return 5344}Lb[c[(c[d>>2]|0)+48>>2]&127](d,e);d=a+244|0;j=+g[d>>2];d=b+212|0;g[d>>2]=j;d=a+248|0;j=+g[d>>2];d=b+216|0;g[d>>2]=j;d=a+252|0;j=+g[d>>2];d=b+220|0;g[d>>2]=j;d=a+256|0;d=c[d>>2]|0;e=b+248|0;c[e>>2]=d;i=f;return 5344}function Hs(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;d=i;f=Nb[c[(c[a>>2]|0)+16>>2]&127](a)|0;f=Wb[c[(c[b>>2]|0)+16>>2]&63](b,f,1)|0;e=Wb[c[(c[a>>2]|0)+20>>2]&63](a,c[f+8>>2]|0,b)|0;Hb[c[(c[b>>2]|0)+20>>2]&31](b,f,e,1245859651,a);i=d;return}function Is(a){a=a|0;return 256}function Js(a,b){a=a|0;b=b|0;return 1}function Ks(b){b=b|0;var d=0,e=0;e=i;c[b>>2]=5416;d=c[b+276>>2]|0;if(d){if(a[b+280>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}c[b+276>>2]=0}a[b+280>>0]=1;c[b+276>>2]=0;c[b+268>>2]=0;c[b+272>>2]=0;i=e;return}function Ls(b){b=b|0;var d=0,e=0;e=i;c[b>>2]=5416;d=c[b+276>>2]|0;if(!d){a[b+280>>0]=1;c[b+276>>2]=0;c[b+268>>2]=0;c[b+272>>2]=0;d=c[5110]|0;d=d+1|0;c[5110]=d;d=b+-4|0;d=c[d>>2]|0;RE(d);i=e;return}if(a[b+280>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}a[b+280>>0]=1;c[b+276>>2]=0;c[b+268>>2]=0;c[b+272>>2]=0;d=c[5110]|0;d=d+1|0;c[5110]=d;d=b+-4|0;d=c[d>>2]|0;RE(d);i=e;return}function Ms(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0;k=i;j=c[d>>2]|0;e=c[b+268>>2]|0;a:do if((e|0)>0){f=c[b+276>>2]|0;d=0;while(1){g=d+1|0;if((c[f+(d<<2)>>2]|0)==(j|0))break;if((g|0)<(e|0))d=g;else break a}if((d|0)!=(e|0)){i=k;return}}while(0);if((e|0)==(c[b+272>>2]|0)?(h=(e|0)==0?1:e<<1,(e|0)<(h|0)):0){if(!h)d=0;else{c[5108]=(c[5108]|0)+1;d=QE((h<<2|3)+16|0)|0;if(!d)d=0;else{c[(d+19&-16)+-4>>2]=d;d=d+19&-16}e=c[b+268>>2]|0}if((e|0)>0){g=0;do{f=d+(g<<2)|0;if(f)c[f>>2]=c[(c[b+276>>2]|0)+(g<<2)>>2];g=g+1|0}while((g|0)!=(e|0))}f=c[b+276>>2]|0;if(f){if(a[b+280>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[f+-4>>2]|0);e=c[b+268>>2]|0}c[b+276>>2]=0}a[b+280>>0]=1;c[b+276>>2]=d;c[b+272>>2]=h}d=(c[b+276>>2]|0)+(e<<2)|0;if(d)c[d>>2]=j;c[b+268>>2]=e+1;i=k;return}function Ns(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0;j=i;b=c[b>>2]|0;e=c[a+268>>2]|0;if((e|0)<=0){i=j;return}d=c[a+276>>2]|0;g=0;while(1){f=d+(g<<2)|0;h=g+1|0;if((c[f>>2]|0)==(b|0))break;if((h|0)<(e|0))g=h;else{k=7;break}}if((k|0)==7){i=j;return}if((g|0)>=(e|0)){i=j;return}c[f>>2]=c[d+(e+-1<<2)>>2];c[a+268>>2]=e+-1;i=j;return}function Os(b){b=b|0;var d=0,e=0;e=i;c[b>>2]=5464;d=c[b+284>>2]|0;Jb[c[c[d>>2]>>2]&255](d);d=c[b+284>>2]|0;if(d){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}c[b>>2]=5416;d=c[b+276>>2]|0;if(!d){a[b+280>>0]=1;c[b+276>>2]=0;c[b+268>>2]=0;d=b+272|0;c[d>>2]=0;i=e;return}if(a[b+280>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}c[b+276>>2]=0;a[b+280>>0]=1;c[b+276>>2]=0;c[b+268>>2]=0;d=b+272|0;c[d>>2]=0;i=e;return}function Ps(a){a=a|0;var b=0;b=i;Os(a);if(!a){i=b;return}c[5110]=(c[5110]|0)+1;RE(c[a+-4>>2]|0);i=b;return}function Qs(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0;m=i;if(!e)e=c[b+188>>2]|0;l=c[d>>2]|0;f=c[b+268>>2]|0;a:do if((f|0)>0){h=c[b+276>>2]|0;g=0;while(1){j=g+1|0;if((c[h+(g<<2)>>2]|0)==(l|0))break;if((j|0)<(f|0))g=j;else break a}if((g|0)!=(f|0)){i=m;return}}while(0);if((f|0)==(c[b+272>>2]|0)?(k=(f|0)==0?1:f<<1,(f|0)<(k|0)):0){if(!k)g=0;else{c[5108]=(c[5108]|0)+1;g=QE((k<<2|3)+16|0)|0;if(!g)g=0;else{c[(g+19&-16)+-4>>2]=g;g=g+19&-16}f=c[b+268>>2]|0}if((f|0)>0){j=0;do{h=g+(j<<2)|0;if(h)c[h>>2]=c[(c[b+276>>2]|0)+(j<<2)>>2];j=j+1|0}while((j|0)!=(f|0))}h=c[b+276>>2]|0;if(h){if(a[b+280>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[h+-4>>2]|0);f=c[b+268>>2]|0}c[b+276>>2]=0}a[b+280>>0]=1;c[b+276>>2]=g;c[b+272>>2]=k}g=(c[b+276>>2]|0)+(f<<2)|0;if(g)c[g>>2]=l;c[b+268>>2]=f+1;f=c[b+284>>2]|0;Wb[c[(c[f>>2]|0)+8>>2]&63](f,e,d)|0;i=m;return}function Rs(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0;n=i;l=c[b>>2]|0;if(!e)e=c[a+188>>2]|0;f=c[a+268>>2]|0;if((f|0)<=0){i=n;return}g=c[a+276>>2]|0;j=0;while(1){h=g+(j<<2)|0;k=j+1|0;if((c[h>>2]|0)==(l|0))break;if((k|0)<(f|0))j=k;else{m=9;break}}if((m|0)==9){i=n;return}if((j|0)>=(f|0)){i=n;return}c[h>>2]=c[g+(f+-1<<2)>>2];c[a+268>>2]=f+-1;a=c[a+284>>2]|0;Rb[c[(c[a>>2]|0)+12>>2]&31](a,e,b,d)|0;i=n;return}function Ss(a,b,d,e,f,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;h=+h;var j=0.0,k=0.0,l=0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0,t=0,u=0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0;B=i;i=i+320|0;c[B+176>>2]=c[d+0>>2];c[B+180>>2]=c[d+4>>2];c[B+184>>2]=c[d+8>>2];c[B+188>>2]=c[d+12>>2];c[B+192>>2]=c[d+16>>2];c[B+196>>2]=c[d+20>>2];c[B+200>>2]=c[d+24>>2];c[B+204>>2]=c[d+28>>2];c[B+208>>2]=c[d+32>>2];c[B+212>>2]=c[d+36>>2];c[B+216>>2]=c[d+40>>2];c[B+220>>2]=c[d+44>>2];c[B+224>>2]=c[d+48>>2];c[B+228>>2]=c[d+52>>2];c[B+232>>2]=c[d+56>>2];c[B+236>>2]=c[d+60>>2];c[B+112>>2]=c[e+0>>2];c[B+116>>2]=c[e+4>>2];c[B+120>>2]=c[e+8>>2];c[B+124>>2]=c[e+12>>2];c[B+128>>2]=c[e+16>>2];c[B+132>>2]=c[e+20>>2];c[B+136>>2]=c[e+24>>2];c[B+140>>2]=c[e+28>>2];c[B+144>>2]=c[e+32>>2];c[B+148>>2]=c[e+36>>2];c[B+152>>2]=c[e+40>>2];c[B+156>>2]=c[e+44>>2];c[B+160>>2]=c[e+48>>2];c[B+164>>2]=c[e+52>>2];c[B+168>>2]=c[e+56>>2];c[B+172>>2]=c[e+60>>2];j=+g[B+164>>2]-+g[B+228>>2];G=+g[B+168>>2]-+g[B+232>>2];g[B+64>>2]=+g[B+160>>2]-+g[B+224>>2];g[B+68>>2]=j;g[B+72>>2]=G;g[B+76>>2]=0.0;Bp(B+176|0,B+112|0,B+248|0,B+240|0);G=+g[B+240>>2];j=G*+g[B+252>>2];D=G*+g[B+256>>2];g[B+48>>2]=+g[B+248>>2]*G;g[B+52>>2]=j;g[B+56>>2]=D;g[B+60>>2]=0.0;c[B+252>>2]=0;c[B+256>>2]=0;c[B+272>>2]=0;c[B+276>>2]=0;l=B+292|0;c[l+0>>2]=0;c[l+4>>2]=0;c[l+8>>2]=0;c[l+12>>2]=0;c[l+16>>2]=0;Fc(B+176|0,B+32|0);D=+g[B+32>>2];j=+g[B+36>>2];G=+g[B+40>>2];E=+g[B+44>>2];C=D*(2.0/(D*D+j*j+G*G+E*E));k=j*(2.0/(D*D+j*j+G*G+E*E));F=G*(2.0/(D*D+j*j+G*G+E*E));g[B+248>>2]=1.0-(j*k+G*F);g[B+252>>2]=D*k-E*F;g[B+256>>2]=D*F+E*k;g[B+260>>2]=0.0;g[B+264>>2]=D*k+E*F;g[B+268>>2]=1.0-(D*C+G*F);g[B+272>>2]=j*F-E*C;g[B+276>>2]=0.0;g[B+280>>2]=D*F-E*k;g[B+284>>2]=j*F+E*C;g[B+288>>2]=1.0-(D*C+j*k);g[l>>2]=0.0;wy(b,B+248|0,B+64|0,B+48|0,B+96|0,B+80|0);if((c[a+268>>2]|0)<=0){i=B;return}s=0;do{l=c[(c[a+276>>2]|0)+(s<<2)>>2]|0;if(ec[c[(c[f>>2]|0)+8>>2]&31](f,c[l+188>>2]|0)|0?(u=c[l+192>>2]|0,tc[c[(c[u>>2]|0)+8>>2]&127](u,l+4|0,B+16|0,B),m=+g[B+16>>2]+ +g[B+96>>2],q=+g[B+20>>2]+ +g[B+100>>2],o=+g[B+24>>2]+ +g[B+104>>2],g[B+16>>2]=m,g[B+20>>2]=q,g[B+24>>2]=o,g[B+28>>2]=0.0,n=+g[B>>2]+ +g[B+80>>2],r=+g[B+4>>2]+ +g[B+84>>2],p=+g[B+8>>2]+ +g[B+88>>2],g[B>>2]=n,g[B+4>>2]=r,g[B+8>>2]=p,g[B+12>>2]=0.0,w=+g[d+48>>2]-(n+m)*.5,A=+g[d+52>>2]-(r+q)*.5,x=+g[d+56>>2]-(p+o)*.5,v=+g[e+48>>2]-(n+m)*.5,z=+g[e+52>>2]-(r+q)*.5,y=+g[e+56>>2]-(p+o)*.5,u=w<-((n-m)*.5)|(w>(n-m)*.5?8:0)|(A>(r-q)*.5?16:0)|(A<-((r-q)*.5)?2:0)|(x>(p-o)*.5?32:0)|(x<-((p-o)*.5)?4:0),t=v<-((n-m)*.5)|(v>(n-m)*.5?8:0)|(z>(r-q)*.5?16:0)|(z<-((r-q)*.5)?2:0)|(y>(p-o)*.5?32:0)|(y<-((p-o)*.5)?4:0),(u&t|0)==0):0){if(w<-((n-m)*.5))if(!((-w-(n-m)*.5)/(v-w)>=0.0)){j=1.0;k=0.0}else{j=1.0;k=(-w-(n-m)*.5)/(v-w)}else if(v<-((n-m)*.5)?(-w-(n-m)*.5)/(v-w)<1.0:0){j=(-w-(n-m)*.5)/(v-w);k=0.0}else{j=1.0;k=0.0}if(A<-((r-q)*.5)){if(k<=(-A-(r-q)*.5)/(z-A))k=(-A-(r-q)*.5)/(z-A)}else if(z<-((r-q)*.5)?(-A-(r-q)*.5)/(z-A)<j:0)j=(-A-(r-q)*.5)/(z-A);if(!(u&4)){if((t&4|0)!=0?(-x-(p-o)*.5)/(y-x)<j:0)j=(-x-(p-o)*.5)/(y-x)}else if(k<=(-x-(p-o)*.5)/(y-x))k=(-x-(p-o)*.5)/(y-x);if(w>(n-m)*.5){if(k<=((n-m)*.5-w)/(v-w))k=((n-m)*.5-w)/(v-w)}else if(v>(n-m)*.5?((n-m)*.5-w)/(v-w)<j:0)j=((n-m)*.5-w)/(v-w);if(A>(r-q)*.5){if(k<=((r-q)*.5-A)/(z-A))k=((r-q)*.5-A)/(z-A)}else if(z>(r-q)*.5?((r-q)*.5-A)/(z-A)<j:0)j=((r-q)*.5-A)/(z-A);if(x>(p-o)*.5){if(k<=((p-o)*.5-x)/(y-x))k=((p-o)*.5-x)/(y-x)}else if(y>(p-o)*.5?((p-o)*.5-x)/(y-x)<j:0)j=((p-o)*.5-x)/(y-x);if(k<=j){H=c[l+192>>2]|0;c[B+248>>2]=0;c[B+252>>2]=H;c[B+256>>2]=l;c[B+260>>2]=l+4;c[B+264>>2]=-1;c[B+268>>2]=-1;Yu(b,B+176|0,B+112|0,B+248|0,f,h)}}s=s+1|0}while((s|0)<(c[a+268>>2]|0));i=B;return}function Ts(a,b,d){a=a|0;b=b|0;d=d|0;var e=0.0,f=0,h=0,j=0,k=0;k=i;i=i+80|0;h=c[c[a>>2]>>2]|0;j=c[c[a+4>>2]>>2]|0;if(!(Wb[c[(c[b>>2]|0)+24>>2]&63](b,h,j)|0)){i=k;return}f=c[h+192>>2]|0;c[k+56>>2]=0;c[k+60>>2]=f;c[k+64>>2]=h;c[k+68>>2]=h+4;c[k+72>>2]=-1;c[k+76>>2]=-1;f=c[j+192>>2]|0;c[k+32>>2]=0;c[k+36>>2]=f;c[k+40>>2]=j;c[k+44>>2]=j+4;c[k+48>>2]=-1;c[k+52>>2]=-1;f=c[a+8>>2]|0;if(!f){f=Rb[c[(c[b>>2]|0)+8>>2]&31](b,k+56|0,k+32|0,0)|0;c[a+8>>2]=f;if(!f){i=k;return}}c[k>>2]=7888;c[k+4>>2]=0;c[k+8>>2]=k+56;c[k+12>>2]=k+32;if((c[d+8>>2]|0)==1){Hb[c[(c[f>>2]|0)+8>>2]&31](f,k+56|0,k+32|0,d,k);i=k;return}e=+Vb[c[(c[f>>2]|0)+12>>2]&15](f,h,j,d,k);if(!(+g[d+12>>2]>e)){i=k;return}g[d+12>>2]=e;i=k;return}function Us(b){b=b|0;var d=0,e=0;e=i;c[b>>2]=5600;d=c[b+20>>2]|0;if(d){if(a[b+24>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}c[b+20>>2]=0}a[b+24>>0]=1;c[b+20>>2]=0;c[b+12>>2]=0;c[b+16>>2]=0;i=e;return}function Vs(b){b=b|0;var d=0,e=0;e=i;c[b>>2]=5600;d=c[b+20>>2]|0;if(d){if(a[b+24>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}c[b+20>>2]=0}a[b+24>>0]=1;c[b+20>>2]=0;c[b+12>>2]=0;c[b+16>>2]=0;RE(b);i=e;return}function Ws(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,h=0,j=0,k=0.0,l=0.0,m=0,n=0,o=0,p=0.0;o=i;i=i+16|0;c[1396]=(c[1396]|0)+1;if(!(c[b+4>>2]&2))f=5336;else{f=c[d+192>>2]|0;l=+jc[c[(c[f>>2]|0)+20>>2]&1](f,.019999999552965164);g[o+4>>2]=l;f=c[e+192>>2]|0;k=+jc[c[(c[f>>2]|0)+20>>2]&1](f,.019999999552965164);g[o>>2]=k;f=l<k?o+4|0:o}l=+g[f>>2];p=+g[d+184>>2];k=+g[e+184>>2];k=p<k?p:k;j=c[b+68>>2]|0;h=c[j+8>>2]|0;if(!h){if(c[b+4>>2]&4){d=0;i=o;return d|0}c[5108]=(c[5108]|0)+1;h=QE(791)|0;if(!h)m=0;else{c[(h+19&-16)+-4>>2]=h;m=h+19&-16}}else{m=c[j+12>>2]|0;c[j+12>>2]=c[m>>2];c[j+8>>2]=h+-1}c[m>>2]=1025;c[m+116>>2]=0;a[m+120>>0]=0;f=m+124|0;c[f+0>>2]=0;c[f+4>>2]=0;c[f+8>>2]=0;c[f+12>>2]=0;c[f+16>>2]=0;c[f+20>>2]=0;c[f+24>>2]=0;c[f+28>>2]=0;c[m+300>>2]=0;a[m+304>>0]=0;f=m+308|0;c[f+0>>2]=0;c[f+4>>2]=0;c[f+8>>2]=0;c[f+12>>2]=0;c[f+16>>2]=0;c[f+20>>2]=0;c[f+24>>2]=0;c[f+28>>2]=0;c[m+484>>2]=0;a[m+488>>0]=0;f=m+492|0;c[f+0>>2]=0;c[f+4>>2]=0;c[f+8>>2]=0;c[f+12>>2]=0;c[f+16>>2]=0;c[f+20>>2]=0;c[f+24>>2]=0;c[f+28>>2]=0;c[m+668>>2]=0;a[m+672>>0]=0;f=m+676|0;c[f+0>>2]=0;c[f+4>>2]=0;c[f+8>>2]=0;c[f+12>>2]=0;c[f+16>>2]=0;c[f+20>>2]=0;c[f+24>>2]=0;c[f+28>>2]=0;c[m+740>>2]=d;c[m+744>>2]=e;c[m+748>>2]=0;g[m+752>>2]=l;g[m+756>>2]=k;d=c[b+12>>2]|0;c[m+768>>2]=d;if((d|0)==(c[b+16>>2]|0)?(n=(d|0)==0?1:d<<1,(d|0)<(n|0)):0){if(!n)f=0;else{c[5108]=(c[5108]|0)+1;f=QE((n<<2|3)+16|0)|0;if(!f)f=0;else{c[(f+19&-16)+-4>>2]=f;f=f+19&-16}d=c[b+12>>2]|0}if((d|0)>0){j=0;do{h=f+(j<<2)|0;if(h)c[h>>2]=c[(c[b+20>>2]|0)+(j<<2)>>2];j=j+1|0}while((j|0)!=(d|0))}h=c[b+20>>2]|0;if(h){if(a[b+24>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[h+-4>>2]|0);d=c[b+12>>2]|0}c[b+20>>2]=0}a[b+24>>0]=1;c[b+20>>2]=f;c[b+16>>2]=n}f=(c[b+20>>2]|0)+(d<<2)|0;if(f)c[f>>2]=m;c[b+12>>2]=d+1;d=m;i=o;return d|0}function Xs(a,b){a=a|0;b=b|0;c[b+748>>2]=0;return}function Ys(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0;d=i;c[1396]=(c[1396]|0)+-1;Lb[c[(c[a>>2]|0)+20>>2]&127](a,b);f=c[b+768>>2]|0;e=(c[a+12>>2]|0)+-1|0;h=c[a+20>>2]|0;g=c[h+(f<<2)>>2]|0;c[h+(f<<2)>>2]=c[h+(e<<2)>>2];c[(c[a+20>>2]|0)+(e<<2)>>2]=g;c[(c[(c[a+20>>2]|0)+(f<<2)>>2]|0)+768>>2]=f;c[a+12>>2]=e;a=c[a+68>>2]|0;if(!b){i=d;return}e=c[a+16>>2]|0;if(e>>>0<=b>>>0?(e+($(c[a>>2]|0,c[a+4>>2]|0)|0)|0)>>>0>b>>>0:0){c[b>>2]=c[a+12>>2];c[a+12>>2]=b;c[a+8>>2]=(c[a+8>>2]|0)+1;i=d;return}c[5110]=(c[5110]|0)+1;RE(c[b+-4>>2]|0);i=d;return}function Zs(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0;f=i;i=i+16|0;c[f>>2]=a;c[f+4>>2]=e;e=c[a+((c[(c[b+4>>2]|0)+4>>2]|0)*144|0)+(c[(c[d+4>>2]|0)+4>>2]<<2)+72>>2]|0;b=Rb[c[(c[e>>2]|0)+8>>2]&31](e,f,b,d)|0;i=f;return b|0}function _s(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;f=i;a=c[b+204>>2]|0;if((a&4|0)==0?(e=c[d+204>>2]|0,(e&4|0)==0):0)if(!(a&3))a=1;else a=(e&3|0)==0;else a=0;i=f;return a|0}function $s(a,b,d){a=a|0;b=b|0;d=d|0;var e=0;a=i;e=c[b+216>>2]|0;if((e|0)==2|(e|0)==5?(e=c[d+216>>2]|0,(e|0)==2|(e|0)==5):0){b=0;i=a;return b|0}if(!(c[b+256>>2]|0)){b=1;i=a;return b|0}b=ec[c[c[b>>2]>>2]&31](b,d)|0;i=a;return b|0}function at(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0;f=i;i=i+16|0;c[f>>2]=5712;c[f+4>>2]=d;c[f+8>>2]=a;pc[c[(c[b>>2]|0)+48>>2]&127](b,f,e);i=f;return}function bt(a,b){a=a|0;b=b|0;var d=0,e=0;e=i;a=c[a+64>>2]|0;d=c[a+8>>2]|0;if(d){b=c[a+12>>2]|0;c[a+12>>2]=c[b>>2];c[a+8>>2]=d+-1;a=b;i=e;return a|0}c[5108]=(c[5108]|0)+1;a=QE(b+19|0)|0;if(!a){a=0;i=e;return a|0}c[(a+19&-16)+-4>>2]=a;a=a+19&-16;i=e;return a|0}function ct(a,b){a=a|0;b=b|0;var d=0,e=0;d=i;a=c[a+64>>2]|0;if(!b){i=d;return}e=c[a+16>>2]|0;if(e>>>0<=b>>>0?(e+($(c[a>>2]|0,c[a+4>>2]|0)|0)|0)>>>0>b>>>0:0){c[b>>2]=c[a+12>>2];c[a+12>>2]=b;c[a+8>>2]=(c[a+8>>2]|0)+1;i=d;return}c[5110]=(c[5110]|0)+1;RE(c[b+-4>>2]|0);i=d;return}function dt(a){a=a|0;return c[a+68>>2]|0}function et(a){a=a|0;return c[a+68>>2]|0}function ft(a){a=a|0;var b=0;b=i;if(!(c[a+12>>2]|0)){a=0;i=b;return a|0}a=c[a+20>>2]|0;i=b;return a|0}function gt(a,b){a=a|0;b=b|0;return c[(c[a+20>>2]|0)+(b<<2)>>2]|0}function ht(a){a=a|0;return c[a+12>>2]|0}function it(a){a=a|0;return}function jt(a,b){a=a|0;b=b|0;var d=0,e=0;d=i;e=c[a+8>>2]|0;pc[c[e+60>>2]&127](b,e,c[a+4>>2]|0);i=d;return 0}function kt(a){a=a|0;var b=0;b=i;RE(a);i=b;return}function lt(b,d){b=b|0;d=d|0;var e=0,f=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0;n=i;c[b>>2]=5816;c[5108]=(c[5108]|0)+1;e=QE(379)|0;if(!e)e=0;else{c[(e+19&-16)+-4>>2]=e;e=e+19&-16}g[e+308>>2]=9.999999747378752e-05;j=e+332|0;a[j>>0]=a[j>>0]&-16;c[b+24>>2]=e;j=(c[d+20>>2]|0)==0;c[5108]=(c[5108]|0)+1;f=QE(23)|0;if(!f)e=0;else{c[(f+19&-16)+-4>>2]=f;e=f+19&-16}k=(e|0)==0;if(j){if(k)e=0;else c[e>>2]=18624;c[b+28>>2]=e}else{if(k)e=0;else c[e>>2]=19048;c[b+28>>2]=e}c[5108]=(c[5108]|0)+1;e=QE(43)|0;if((e|0)!=0?(l=e+19&-16,c[l+-4>>2]=e,(e+19&-16|0)!=0):0){j=c[b+24>>2]|0;f=c[b+28>>2]|0;a[l+4>>0]=0;c[(e+19&-16)>>2]=10400;c[l+16>>2]=0;c[l+20>>2]=3;c[l+12>>2]=j;c[l+8>>2]=f;e=e+19&-16}else e=0;c[b+32>>2]=e;c[5108]=(c[5108]|0)+1;e=QE(27)|0;if((e|0)!=0?(c[(e+19&-16)+-4>>2]=e,(e+19&-16|0)!=0):0){a[(e+19&-16)+4>>0]=0;c[(e+19&-16)>>2]=6824;e=e+19&-16}else e=0;c[b+36>>2]=e;c[5108]=(c[5108]|0)+1;e=QE(27)|0;if((e|0)!=0?(c[(e+19&-16)+-4>>2]=e,(e+19&-16|0)!=0):0){a[(e+19&-16)+4>>0]=0;c[(e+19&-16)>>2]=6720;e=e+19&-16}else e=0;c[b+40>>2]=e;c[5108]=(c[5108]|0)+1;e=QE(27)|0;if((e|0)!=0?(c[(e+19&-16)+-4>>2]=e,(e+19&-16|0)!=0):0){a[(e+19&-16)+4>>0]=0;c[(e+19&-16)>>2]=6632;e=e+19&-16}else e=0;c[b+44>>2]=e;c[5108]=(c[5108]|0)+1;e=QE(27)|0;if((e|0)!=0?(c[(e+19&-16)+-4>>2]=e,(e+19&-16|0)!=0):0){a[(e+19&-16)+4>>0]=0;c[(e+19&-16)>>2]=6536;e=e+19&-16}else e=0;c[b+48>>2]=e;c[5108]=(c[5108]|0)+1;e=QE(27)|0;if((e|0)!=0?(c[(e+19&-16)+-4>>2]=e,(e+19&-16|0)!=0):0){a[(e+19&-16)+4>>0]=0;c[(e+19&-16)>>2]=6440;e=e+19&-16}else e=0;c[b+52>>2]=e;c[5108]=(c[5108]|0)+1;e=QE(27)|0;if((e|0)!=0?(c[(e+19&-16)+-4>>2]=e,(e+19&-16|0)!=0):0){a[(e+19&-16)+4>>0]=0;c[(e+19&-16)>>2]=6360;e=e+19&-16}else e=0;c[b+56>>2]=e;c[5108]=(c[5108]|0)+1;e=QE(27)|0;if((e|0)!=0?(c[(e+19&-16)+-4>>2]=e,(e+19&-16|0)!=0):0){a[(e+19&-16)+4>>0]=0;c[(e+19&-16)>>2]=6264;e=e+19&-16}else e=0;c[b+60>>2]=e;c[5108]=(c[5108]|0)+1;e=QE(27)|0;if((e|0)!=0?(c[(e+19&-16)+-4>>2]=e,(e+19&-16|0)!=0):0){a[(e+19&-16)+4>>0]=0;c[(e+19&-16)>>2]=6168;e=e+19&-16}else e=0;c[b+76>>2]=e;c[5108]=(c[5108]|0)+1;e=QE(27)|0;if((e|0)!=0?(c[(e+19&-16)+-4>>2]=e,(e+19&-16|0)!=0):0){a[(e+19&-16)+4>>0]=0;c[(e+19&-16)>>2]=6168;e=e+19&-16}else e=0;c[b+80>>2]=e;a[e+4>>0]=1;c[5108]=(c[5108]|0)+1;e=QE(27)|0;if((e|0)!=0?(c[(e+19&-16)+-4>>2]=e,(e+19&-16|0)!=0):0){a[(e+19&-16)+4>>0]=0;c[(e+19&-16)>>2]=6080;e=e+19&-16}else e=0;c[b+72>>2]=e;c[5108]=(c[5108]|0)+1;e=QE(35)|0;if((e|0)!=0?(m=e+19&-16,c[m+-4>>2]=e,(e+19&-16|0)!=0):0){a[m+4>>0]=0;c[(e+19&-16)>>2]=5944;c[m+8>>2]=1;c[m+12>>2]=0;e=e+19&-16}else e=0;c[b+88>>2]=e;c[5108]=(c[5108]|0)+1;e=QE(35)|0;if((e|0)!=0?(h=e+19&-16,c[h+-4>>2]=e,(e+19&-16|0)!=0):0){a[h+4>>0]=0;c[(e+19&-16)>>2]=5944;c[h+8>>2]=1;c[h+12>>2]=0;e=e+19&-16}else e=0;c[b+84>>2]=e;a[e+4>>0]=1;m=c[d+16>>2]|0;m=(m|0)>80?m:80;e=c[d>>2]|0;if(!e){a[b+12>>0]=1;c[5108]=(c[5108]|0)+1;l=QE(39)|0;do if(!l)e=0;else{k=l+19&-16;c[k+-4>>2]=l;if(!(l+19&-16)){e=0;break}e=c[d+8>>2]|0;c[(l+19&-16)>>2]=772;c[k+4>>2]=e;c[5108]=(c[5108]|0)+1;e=QE((e*772|3)+16|0)|0;if(!e)e=0;else{c[(e+19&-16)+-4>>2]=e;e=e+19&-16}c[k+16>>2]=e;c[k+12>>2]=e;f=c[k+4>>2]|0;c[k+8>>2]=f;if(f+-1|0){k=c[(l+19&-16)>>2]|0;j=f+-1|0;h=e;do{o=h;h=h+k|0;c[o>>2]=h;j=j+-1|0}while((j|0)!=0);e=e+($(k,f+-1|0)|0)|0}c[e>>2]=0;e=l+19&-16}while(0);c[b+8>>2]=e}else{a[b+12>>0]=0;c[b+8>>2]=e}e=c[d+4>>2]|0;if(e){a[b+20>>0]=0;c[b+16>>2]=e;i=n;return}a[b+20>>0]=1;c[5108]=(c[5108]|0)+1;l=QE(39)|0;do if(!l)e=0;else{j=l+19&-16;c[j+-4>>2]=l;if(!(l+19&-16)){e=0;break}e=c[d+12>>2]|0;c[(l+19&-16)>>2]=m;c[j+4>>2]=e;e=$(e,m)|0;c[5108]=(c[5108]|0)+1;e=QE(e+19|0)|0;if(!e)e=0;else{c[(e+19&-16)+-4>>2]=e;e=e+19&-16}c[j+16>>2]=e;c[j+12>>2]=e;k=c[j+4>>2]|0;c[j+8>>2]=k;if(k+-1|0){f=c[(l+19&-16)>>2]|0;h=k+-1|0;j=e;do{d=j;j=j+f|0;c[d>>2]=j;h=h+-1|0}while((h|0)!=0);e=e+($(f,k+-1|0)|0)|0}c[e>>2]=0;e=l+19&-16}while(0);c[b+16>>2]=e;i=n;return}function mt(b){b=b|0;var d=0,e=0,f=0;f=i;c[b>>2]=5816;if(a[b+20>>0]|0){d=c[b+16>>2]|0;e=c[d+16>>2]|0;if(e){c[5110]=(c[5110]|0)+1;RE(c[e+-4>>2]|0);d=c[b+16>>2]|0}if(d){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}}if(a[b+12>>0]|0){d=c[b+8>>2]|0;e=c[d+16>>2]|0;if(e){c[5110]=(c[5110]|0)+1;RE(c[e+-4>>2]|0);d=c[b+8>>2]|0}if(d){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}}d=c[b+32>>2]|0;Jb[c[c[d>>2]>>2]&255](d);d=c[b+32>>2]|0;if(d){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}d=c[b+36>>2]|0;Jb[c[c[d>>2]>>2]&255](d);d=c[b+36>>2]|0;if(d){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}d=c[b+40>>2]|0;Jb[c[c[d>>2]>>2]&255](d);d=c[b+40>>2]|0;if(d){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}d=c[b+44>>2]|0;Jb[c[c[d>>2]>>2]&255](d);d=c[b+44>>2]|0;if(d){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}d=c[b+48>>2]|0;Jb[c[c[d>>2]>>2]&255](d);d=c[b+48>>2]|0;if(d){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}d=c[b+52>>2]|0;Jb[c[c[d>>2]>>2]&255](d);d=c[b+52>>2]|0;if(d){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}d=c[b+56>>2]|0;Jb[c[c[d>>2]>>2]&255](d);d=c[b+56>>2]|0;if(d){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}d=c[b+60>>2]|0;Jb[c[c[d>>2]>>2]&255](d);d=c[b+60>>2]|0;if(d){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}d=c[b+76>>2]|0;Jb[c[c[d>>2]>>2]&255](d);d=c[b+76>>2]|0;if(d){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}d=c[b+80>>2]|0;Jb[c[c[d>>2]>>2]&255](d);d=c[b+80>>2]|0;if(d){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}d=c[b+72>>2]|0;Jb[c[c[d>>2]>>2]&255](d);d=c[b+72>>2]|0;if(d){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}d=c[b+88>>2]|0;Jb[c[c[d>>2]>>2]&255](d);d=c[b+88>>2]|0;if(d){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}d=c[b+84>>2]|0;Jb[c[c[d>>2]>>2]&255](d);d=c[b+84>>2]|0;if(d){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}d=c[b+24>>2]|0;if(d){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}d=c[b+28>>2]|0;Jb[c[c[d>>2]>>2]&255](d);d=c[b+28>>2]|0;if(!d){i=f;return}c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0);i=f;return}function nt(a){a=a|0;var b=0;b=i;mt(a);RE(a);i=b;return}function ot(a,b,d){a=a|0;b=b|0;d=d|0;var e=0;e=i;do if(!((b|0)==8&(d|0)==8)){if((b|0)==8&(d|0)==1){b=a+76|0;break}if((b|0)==1&(d|0)==8){b=a+80|0;break}if(!(d|b)){b=a+72|0;break}if((b|0)<20&(d|0)==28){b=a+88|0;break}if((d|0)<20&(b|0)==28){b=a+84|0;break}if((b|0)<20){if((d|0)<20){b=a+32|0;break}if((d+-21|0)>>>0<9){b=a+36|0;break}}else if((d|0)<20&(b+-21|0)>>>0<9){b=a+40|0;break}if((b|0)==31)if((d|0)==31){b=a+48|0;break}else{b=a+44|0;break}else if((d|0)==31){b=a+52|0;break}else{b=a+56|0;break}}else b=a+60|0;while(0);i=e;return c[b>>2]|0}function pt(a){a=a|0;return c[a+24>>2]|0}function qt(a){a=a|0;return c[a+16>>2]|0}function rt(a){a=a|0;return c[a+8>>2]|0}function st(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0;h=i;g=c[d>>2]|0;g=ec[c[(c[g>>2]|0)+56>>2]&31](g,28)|0;if(!(a[b+4>>0]|0)){if(!g){e=0;i=h;return e|0}j=c[b+8>>2]|0;b=c[b+12>>2]|0;d=c[d>>2]|0;c[g+4>>2]=d;c[g>>2]=7032;a[g+8>>0]=0;c[g+12>>2]=0;a[g+16>>0]=0;c[g+20>>2]=j;c[g+24>>2]=b;if(!(Wb[c[(c[d>>2]|0)+24>>2]&63](d,c[e+8>>2]|0,c[f+8>>2]|0)|0)){e=g;i=h;return e|0}d=c[g+4>>2]|0;c[g+12>>2]=Wb[c[(c[d>>2]|0)+12>>2]&63](d,c[e+8>>2]|0,c[f+8>>2]|0)|0;a[g+8>>0]=1;e=g;i=h;return e|0}else{if(!g){e=0;i=h;return e|0}j=c[b+8>>2]|0;b=c[b+12>>2]|0;d=c[d>>2]|0;c[g+4>>2]=d;c[g>>2]=7032;a[g+8>>0]=0;c[g+12>>2]=0;a[g+16>>0]=1;c[g+20>>2]=j;c[g+24>>2]=b;if(!(Wb[c[(c[d>>2]|0)+24>>2]&63](d,c[f+8>>2]|0,c[e+8>>2]|0)|0)){e=g;i=h;return e|0}d=c[g+4>>2]|0;c[g+12>>2]=Wb[c[(c[d>>2]|0)+12>>2]&63](d,c[f+8>>2]|0,c[e+8>>2]|0)|0;a[g+8>>0]=1;e=g;i=h;return e|0}return 0}function tt(a){a=a|0;var b=0;b=i;RE(a);i=b;return}function ut(a){a=a|0;return}function vt(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0;g=i;b=c[d>>2]|0;b=ec[c[(c[b>>2]|0)+56>>2]&31](b,16)|0;if(!b){b=0;i=g;return b|0}d=c[d>>2]|0;c[b+4>>2]=d;c[b>>2]=7808;a[b+8>>0]=0;c[b+12>>2]=0;if(!(Wb[c[(c[d>>2]|0)+24>>2]&63](d,c[e+8>>2]|0,c[f+8>>2]|0)|0)){i=g;return b|0}d=c[b+4>>2]|0;c[b+12>>2]=Wb[c[(c[d>>2]|0)+12>>2]&63](d,c[e+8>>2]|0,c[f+8>>2]|0)|0;a[b+8>>0]=1;i=g;return b|0}function wt(a){a=a|0;var b=0;b=i;RE(a);i=b;return}function xt(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0;h=i;g=c[d>>2]|0;g=ec[c[(c[g>>2]|0)+56>>2]&31](g,20)|0;if(!g){d=0;i=h;return d|0}j=c[d+4>>2]|0;b=a[b+4>>0]|0;d=c[d>>2]|0;c[g+4>>2]=d;c[g>>2]=10312;a[g+8>>0]=0;c[g+12>>2]=j;a[g+16>>0]=b;if(j){d=g;i=h;return d|0}c[g+12>>2]=Wb[c[(c[d>>2]|0)+12>>2]&63](d,c[e+8>>2]|0,c[f+8>>2]|0)|0;a[g+8>>0]=1;d=g;i=h;return d|0}function yt(a){a=a|0;var b=0;b=i;RE(a);i=b;return}function zt(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0;g=i;b=c[d>>2]|0;b=ec[c[(c[b>>2]|0)+56>>2]&31](b,16)|0;if(!b){b=0;i=g;return b|0}d=c[d>>2]|0;c[b+4>>2]=d;c[b>>2]=19672;a[b+8>>0]=0;c[b+12>>2]=0;c[b+12>>2]=Wb[c[(c[d>>2]|0)+12>>2]&63](d,c[e+8>>2]|0,c[f+8>>2]|0)|0;a[b+8>>0]=1;i=g;return b|0}function At(a){a=a|0;var b=0;b=i;RE(a);i=b;return}function Bt(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;d=i;e=c[b>>2]|0;e=ec[c[(c[e>>2]|0)+56>>2]&31](e,8)|0;if(!e){e=0;i=d;return e|0}c[e+4>>2]=c[b>>2];c[e>>2]=19600;i=d;return e|0}function Ct(a){a=a|0;var b=0;b=i;RE(a);i=b;return}function Dt(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0;f=i;a=c[b>>2]|0;a=ec[c[(c[a>>2]|0)+56>>2]&31](a,44)|0;if(!a){a=0;i=f;return a|0}lw(a,c[b>>2]|0,c[b+4>>2]|0,d,e,1);i=f;return a|0}function Et(a){a=a|0;var b=0;b=i;RE(a);i=b;return}function Ft(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0,n=0;m=i;l=c[d>>2]|0;l=ec[c[(c[l>>2]|0)+56>>2]&31](l,48)|0;if(!l){b=0;i=m;return b|0}c[l+4>>2]=c[d>>2];c[l>>2]=11184;a[l+28>>0]=1;c[l+24>>2]=0;c[l+16>>2]=0;c[l+20>>2]=0;c[l+32>>2]=c[d+4>>2];a[l+36>>0]=0;c[5108]=(c[5108]|0)+1;j=QE(87)|0;if((j|0)!=0?(k=j+19&-16,c[k+-4>>2]=j,(j+19&-16|0)!=0):0){c[(j+19&-16)>>2]=19920;a[k+20>>0]=1;c[k+16>>2]=0;c[k+8>>2]=0;c[k+12>>2]=0;a[k+24>>0]=0;a[k+44>>0]=1;c[k+40>>2]=0;c[k+32>>2]=0;c[k+36>>2]=0;a[k+64>>0]=1;c[k+60>>2]=0;c[k+52>>2]=0;c[k+56>>2]=0;c[5108]=(c[5108]|0)+1;b=QE(43)|0;if(!b)h=0;else{c[(b+19&-16)+-4>>2]=b;h=b+19&-16}d=c[k+8>>2]|0;if((d|0)>0){g=0;do{b=h+(g*12|0)|0;if(b){n=(c[k+16>>2]|0)+(g*12|0)|0;c[b+0>>2]=c[n+0>>2];c[b+4>>2]=c[n+4>>2];c[b+8>>2]=c[n+8>>2]}g=g+1|0}while((g|0)!=(d|0))}d=c[k+16>>2]|0;if(d){if(a[k+20>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}c[k+16>>2]=0}a[k+20>>0]=1;c[k+16>>2]=h;c[k+12>>2]=2;FD(j+19&-16);b=j+19&-16}else b=0;c[l+8>>2]=b;c[l+40>>2]=c[(c[e+4>>2]|0)+68>>2];c[l+44>>2]=c[(c[f+4>>2]|0)+68>>2];f=l;i=m;return f|0}function Gt(a){a=a|0;var b=0;b=i;RE(a);i=b;return}function Ht(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0;f=i;a=c[b>>2]|0;a=ec[c[(c[a>>2]|0)+56>>2]&31](a,44)|0;if(!a){a=0;i=f;return a|0}lw(a,c[b>>2]|0,c[b+4>>2]|0,d,e,0);i=f;return a|0}function It(a){a=a|0;var b=0;b=i;RE(a);i=b;return}function Jt(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0;g=i;b=c[d>>2]|0;b=ec[c[(c[b>>2]|0)+56>>2]&31](b,80)|0;if(!b){b=0;i=g;return b|0}d=c[d>>2]|0;c[b+4>>2]=d;c[b>>2]=7152;a[b+8>>0]=1;c[b+12>>2]=7184;c[b+60>>2]=d;c[b+64>>2]=0;c[b+16>>2]=f;c[b+20>>2]=e;e=Wb[c[(c[d>>2]|0)+12>>2]&63](d,c[f+8>>2]|0,c[e+8>>2]|0)|0;c[b+76>>2]=e;f=c[b+60>>2]|0;Lb[c[(c[f>>2]|0)+20>>2]&127](f,e);i=g;return b|0}function Kt(a){a=a|0;var b=0;b=i;RE(a);i=b;return}function Lt(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0;g=i;b=c[d>>2]|0;b=ec[c[(c[b>>2]|0)+56>>2]&31](b,80)|0;if(!b){b=0;i=g;return b|0}d=c[d>>2]|0;c[b+4>>2]=d;c[b>>2]=7152;a[b+8>>0]=0;c[b+12>>2]=7184;c[b+60>>2]=d;c[b+64>>2]=0;c[b+16>>2]=e;c[b+20>>2]=f;e=Wb[c[(c[d>>2]|0)+12>>2]&63](d,c[e+8>>2]|0,c[f+8>>2]|0)|0;c[b+76>>2]=e;f=c[b+60>>2]|0;Lb[c[(c[f>>2]|0)+20>>2]&127](f,e);i=g;return b|0}function Mt(a){a=a|0;var b=0;b=i;RE(a);i=b;return}function Nt(b){b=b|0;var d=0,e=0;e=i;c[b>>2]=6920;d=c[b+56>>2]|0;if(d){if(a[b+60>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}c[b+56>>2]=0}a[b+60>>0]=1;c[b+56>>2]=0;c[b+48>>2]=0;c[b+52>>2]=0;d=c[b+36>>2]|0;if(d){if(a[b+40>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}c[b+36>>2]=0}a[b+40>>0]=1;c[b+36>>2]=0;c[b+28>>2]=0;c[b+32>>2]=0;d=c[b+16>>2]|0;if(!d){d=b+12|0;a[b+20>>0]=1;c[b+16>>2]=0;c[b+8>>2]=0;c[d>>2]=0;i=e;return}if(a[b+20>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}c[b+16>>2]=0;d=b+12|0;a[b+20>>0]=1;c[b+16>>2]=0;c[b+8>>2]=0;c[d>>2]=0;i=e;return}function Ot(a){a=a|0;var b=0;b=i;Nt(a);RE(a);i=b;return}function Pt(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0;o=i;h=c[d+8>>2]|0;if((h|0)>0){e=c[d+16>>2]|0;k=0;f=0;do{j=c[e+(k<<2)>>2]|0;if(!(c[j+204>>2]&3)){c[j+208>>2]=f;f=f+1|0}c[j+212>>2]=-1;g[j+244>>2]=1.0;k=k+1|0}while((k|0)!=(h|0));m=f}else m=0;l=c[b+8>>2]|0;if((l|0)<(m|0)){if((c[b+12>>2]|0)<(m|0)){if(!m){h=l;e=0}else{c[5108]=(c[5108]|0)+1;e=QE((m<<3|3)+16|0)|0;if(!e)f=0;else{c[(e+19&-16)+-4>>2]=e;f=e+19&-16}h=c[b+8>>2]|0;e=f}if((h|0)>0){k=0;do{j=e+(k<<3)|0;if(j){f=(c[b+16>>2]|0)+(k<<3)|0;n=c[f+4>>2]|0;c[j>>2]=c[f>>2];c[j+4>>2]=n}k=k+1|0}while((k|0)!=(h|0))}f=c[b+16>>2]|0;if(f){if(a[b+20>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[f+-4>>2]|0)}c[b+16>>2]=0}a[b+20>>0]=1;c[b+16>>2]=e;c[b+12>>2]=m;h=b+16|0}else h=b+16|0;e=l;do{f=(c[h>>2]|0)+(e<<3)|0;if(f){c[f>>2]=0;c[f+4>>2]=0}e=e+1|0}while((e|0)!=(m|0))}c[b+8>>2]=m;if((m|0)>0){e=c[b+16>>2]|0;f=0;do{c[e+(f<<3)>>2]=f;c[e+(f<<3)+4>>2]=1;f=f+1|0}while((f|0)!=(m|0))}e=c[d+68>>2]|0;e=Nb[c[(c[e>>2]|0)+36>>2]&127](e)|0;d=Nb[c[(c[e>>2]|0)+36>>2]&127](e)|0;if(!d){i=o;return}l=Nb[c[(c[e>>2]|0)+20>>2]&127](e)|0;if((d|0)<=0){i=o;return}n=0;do{f=c[c[l+(n<<4)>>2]>>2]|0;e=c[c[l+(n<<4)+4>>2]>>2]|0;if(((f|0)!=0?((e|0)!=0?(c[f+204>>2]&7|0)==0:0):0)?(c[e+204>>2]&7|0)==0:0){k=c[f+208>>2]|0;h=c[e+208>>2]|0;m=c[b+16>>2]|0;j=c[m+(k<<3)>>2]|0;if((j|0)!=(k|0)){f=m+(k<<3)|0;do{k=m+(j<<3)|0;c[f>>2]=c[k>>2];k=c[k>>2]|0;f=m+(k<<3)|0;j=c[f>>2]|0}while((k|0)!=(j|0))}j=c[m+(h<<3)>>2]|0;if((j|0)!=(h|0)){f=m+(h<<3)|0;do{h=m+(j<<3)|0;c[f>>2]=c[h>>2];h=c[h>>2]|0;f=m+(h<<3)|0;j=c[f>>2]|0}while((h|0)!=(j|0))}if((k|0)!=(h|0)){c[m+(k<<3)>>2]=h;j=m+(h<<3)+4|0;c[j>>2]=(c[j>>2]|0)+(c[m+(k<<3)+4>>2]|0)}}n=n+1|0}while((n|0)!=(d|0));i=o;return}function Qt(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0;m=i;l=c[b+8>>2]|0;if((l|0)<=0){i=m;return}j=c[b+16>>2]|0;k=0;b=0;do{g=c[j+(k<<2)>>2]|0;if(!(c[g+204>>2]&3)){h=c[a+16>>2]|0;e=h+(b<<3)|0;d=c[e>>2]|0;if((d|0)==(b|0))d=b;else{f=d;do{d=h+(f<<3)|0;c[e>>2]=c[d>>2];d=c[d>>2]|0;e=h+(d<<3)|0;f=c[e>>2]|0}while((d|0)!=(f|0))}c[g+208>>2]=d;c[h+(b<<3)+4>>2]=k;c[g+212>>2]=-1;b=b+1|0}else{c[g+208>>2]=-1;c[g+212>>2]=-2}k=k+1|0}while((k|0)!=(l|0));i=m;return}function Rt(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0;o=i;while(1){n=c[a+12>>2]|0;m=c[n+(((b+d|0)/2|0)<<2)>>2]|0;e=b;f=d;while(1){l=c[(c[m+740>>2]|0)+208>>2]|0;if((l|0)>-1)while(1){h=c[n+(e<<2)>>2]|0;g=c[(c[h+740>>2]|0)+208>>2]|0;if((g|0)<=-1)g=c[(c[h+744>>2]|0)+208>>2]|0;if((g|0)<(l|0))e=e+1|0;else break}else{k=c[(c[m+744>>2]|0)+208>>2]|0;while(1){h=c[n+(e<<2)>>2]|0;g=c[(c[h+740>>2]|0)+208>>2]|0;if((g|0)<=-1)g=c[(c[h+744>>2]|0)+208>>2]|0;if((g|0)<(k|0))e=e+1|0;else break}}if((l|0)>-1)while(1){j=c[n+(f<<2)>>2]|0;g=c[(c[j+740>>2]|0)+208>>2]|0;if((g|0)<=-1)g=c[(c[j+744>>2]|0)+208>>2]|0;if((l|0)<(g|0))f=f+-1|0;else{g=j;break}}else{k=c[(c[m+744>>2]|0)+208>>2]|0;while(1){j=c[n+(f<<2)>>2]|0;g=c[(c[j+740>>2]|0)+208>>2]|0;if((g|0)<=-1)g=c[(c[j+744>>2]|0)+208>>2]|0;if((k|0)<(g|0))f=f+-1|0;else{g=j;break}}}if((e|0)<=(f|0)){c[n+(e<<2)>>2]=g;c[(c[a+12>>2]|0)+(f<<2)>>2]=h;e=e+1|0;f=f+-1|0}if((e|0)>(f|0))break;n=c[a+12>>2]|0}if((f|0)>(b|0))Rt(a,b,f);if((e|0)<(d|0))b=e;else break}i=o;return}function St(b){b=b|0;var d=0,e=0;e=i;c[b>>2]=7032;if(!(a[b+8>>0]|0)){i=e;return}d=c[b+12>>2]|0;if(!d){i=e;return}b=c[b+4>>2]|0;Lb[c[(c[b>>2]|0)+16>>2]&127](b,d);i=e;return}function Tt(b){b=b|0;var d=0,e=0,f=0;e=i;c[b>>2]=7032;if(!(a[b+8>>0]|0)){RE(b);i=e;return}d=c[b+12>>2]|0;if(!d){RE(b);i=e;return}f=c[b+4>>2]|0;Lb[c[(c[f>>2]|0)+16>>2]&127](f,d);RE(b);i=e;return}function Ut(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var j=0,k=0,l=0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0,K=0,L=0.0,M=0.0,N=0.0,Q=0.0,T=0.0,U=0.0,V=0.0,W=0.0,X=0.0,Y=0.0,Z=0.0,_=0.0,$=0,aa=0.0,ba=0.0,ca=0.0,da=0.0,ea=0.0,fa=0.0,ga=0.0;J=i;i=i+128|0;if(!(c[b+12>>2]|0)){i=J;return}l=(a[b+16>>0]|0)!=0;K=l?e:d;l=l?d:e;k=c[K+4>>2]|0;j=c[l+4>>2]|0;K=c[K+12>>2]|0;y=+g[K>>2];x=+g[K+16>>2];w=+g[K+32>>2];u=+g[K+4>>2];t=+g[K+20>>2];s=+g[K+36>>2];q=+g[K+8>>2];E=+g[K+24>>2];n=+g[K+40>>2];I=+g[K+48>>2];F=+g[K+52>>2];G=+g[K+56>>2];K=c[l+12>>2]|0;Q=+g[K>>2];N=+g[K+16>>2];B=+g[K+32>>2];M=+g[K+4>>2];L=+g[K+20>>2];D=+g[K+36>>2];p=+g[K+8>>2];m=+g[K+24>>2];o=+g[K+40>>2];H=-+g[K+48>>2];A=-+g[K+52>>2];z=-+g[K+56>>2];K=c[(c[k>>2]|0)+64>>2]|0;C=-+g[j+48>>2];r=-+g[j+52>>2];v=-+g[j+56>>2];g[J+32>>2]=(y*Q+x*N+w*B)*C+(y*M+x*L+w*D)*r+(y*p+x*m+w*o)*v;g[J+36>>2]=(u*Q+t*N+s*B)*C+(u*M+t*L+s*D)*r+(u*p+t*m+s*o)*v;g[J+40>>2]=(q*Q+E*N+n*B)*C+(q*M+E*L+n*D)*r+(q*p+E*m+n*o)*v;g[J+44>>2]=0.0;pc[K&127](J+48|0,k,J+32|0);v=+g[J+48>>2];r=+g[J+52>>2];C=+g[J+56>>2];B=I*Q+F*N+G*B+(Q*H+N*A+B*z)+((y*Q+x*N+w*B)*v+(u*Q+t*N+s*B)*r+(q*Q+E*N+n*B)*C);D=I*M+F*L+G*D+(M*H+L*A+D*z)+((y*M+x*L+w*D)*v+(u*M+t*L+s*D)*r+(q*M+E*L+n*D)*C);C=I*p+F*m+G*o+(p*H+m*A+o*z)+((y*p+x*m+w*o)*v+(u*p+t*m+s*o)*r+(q*p+E*m+n*o)*C);o=+g[j+48>>2];n=+g[j+52>>2];m=+g[j+56>>2];E=m*C+(o*B+n*D)-+g[j+64>>2];K=c[l+12>>2]|0;p=+g[K>>2];q=+g[K+4>>2];r=+g[K+8>>2];s=+g[K+16>>2];t=+g[K+20>>2];u=+g[K+24>>2];v=+g[K+32>>2];w=+g[K+36>>2];x=+g[K+40>>2];y=+g[K+48>>2];z=+g[K+52>>2];A=+g[K+56>>2];K=c[b+12>>2]|0;f=E<+g[K+752>>2];c[h+4>>2]=K;if(f){f=c[l+12>>2]|0;G=o*+g[f+16>>2]+n*+g[f+20>>2]+m*+g[f+24>>2];H=o*+g[f+32>>2]+n*+g[f+36>>2]+m*+g[f+40>>2];g[J+16>>2]=+g[f>>2]*o+ +g[f+4>>2]*n+ +g[f+8>>2]*m;g[J+20>>2]=G;g[J+24>>2]=H;g[J+28>>2]=0.0;g[J>>2]=r*(C-m*E)+(p*(B-o*E)+q*(D-n*E))+y;g[J+4>>2]=(B-o*E)*s+(D-n*E)*t+(C-m*E)*u+z;g[J+8>>2]=(B-o*E)*v+(D-n*E)*w+(C-m*E)*x+A;g[J+12>>2]=0.0;oc[c[(c[h>>2]|0)+16>>2]&15](h,J+16|0,J,E)}if((c[k+4>>2]|0)<7?(c[(c[h+4>>2]|0)+748>>2]|0)<(c[b+24>>2]|0):0){m=+g[j+56>>2];if(+O(+m)>.7071067690849304){H=+g[j+52>>2];o=1.0/+P(+(m*m+H*H));n=0.0;m=-(m*o);o=H*o}else{o=+g[j+48>>2];n=+g[j+52>>2];m=1.0/+P(+(o*o+n*n));n=-(n*m);m=o*m;o=0.0}F=.019999999552965164/+Zb[c[(c[k>>2]|0)+16>>2]&15](k);G=+P(+(o*o+(m*m+n*n)));F=F>.39269909262657166?.19634954631328583:F*.5;G=+S(+F)/G;I=n*G;H=m*G;G=o*G;F=+R(+F);l=c[b+20>>2]|0;if((l|0)>0){k=0;do{y=+g[j+48>>2];L=+g[j+52>>2];p=+g[j+56>>2];n=+(k|0)*(6.2831854820251465/+(l|0))*.5;M=+S(+n)/+P(+(y*y+L*L+p*p));n=+R(+n);o=G*-(L*M)+(I*n+F*-(y*M))-H*-(p*M);w=I*-(p*M)+(H*n+F*-(L*M))-G*-(y*M);fa=H*-(y*M)+(G*n+F*-(p*M))-I*-(L*M);r=F*n-I*-(y*M)-H*-(L*M)-G*-(p*M);C=p*M*w+(y*M*r+n*o)-L*M*fa;D=y*M*fa+(n*w+L*M*r)-p*M*o;ba=L*M*o+(p*M*r+n*fa)-y*M*w;fa=n*r-y*M*o-L*M*w-p*M*fa;l=(a[b+16>>0]|0)!=0;$=l?e:d;l=l?d:e;f=c[$+4>>2]|0;K=c[l+4>>2]|0;$=c[$+12>>2]|0;M=+g[$>>2];p=+g[$+4>>2];w=+g[$+8>>2];L=+g[$+16>>2];o=+g[$+20>>2];y=+g[$+24>>2];r=+g[$+32>>2];n=+g[$+36>>2];A=+g[$+40>>2];W=+g[$+48>>2];V=+g[$+52>>2];U=+g[$+56>>2];$=c[l+12>>2]|0;_=+g[$>>2];Z=+g[$+16>>2];s=+g[$+32>>2];Y=+g[$+4>>2];X=+g[$+20>>2];v=+g[$+36>>2];x=+g[$+8>>2];z=+g[$+24>>2];B=+g[$+40>>2];T=-+g[$+48>>2];Q=-+g[$+52>>2];N=-+g[$+56>>2];q=C*(2.0/(C*C+D*D+ba*ba+fa*fa));E=D*(2.0/(C*C+D*D+ba*ba+fa*fa));ga=ba*(2.0/(C*C+D*D+ba*ba+fa*fa));da=w*(C*ga-fa*E)+(p*(C*E+fa*ga)+M*(1.0-(D*E+ba*ga)));aa=w*(D*ga+fa*q)+(M*(C*E-fa*ga)+p*(1.0-(C*q+ba*ga)));u=M*(C*ga+fa*E)+p*(D*ga-fa*q)+w*(1.0-(C*q+D*E));ca=y*(C*ga-fa*E)+(o*(C*E+fa*ga)+L*(1.0-(D*E+ba*ga)));t=y*(D*ga+fa*q)+(L*(C*E-fa*ga)+o*(1.0-(C*q+ba*ga)));m=L*(C*ga+fa*E)+o*(D*ga-fa*q)+y*(1.0-(C*q+D*E));ea=A*(C*ga-fa*E)+(n*(C*E+fa*ga)+r*(1.0-(D*E+ba*ga)));ba=A*(D*ga+fa*q)+(r*(C*E-fa*ga)+n*(1.0-(C*q+ba*ga)));E=r*(C*ga+fa*E)+n*(D*ga-fa*q)+A*(1.0-(C*q+D*E));$=c[(c[f>>2]|0)+64>>2]|0;D=-+g[K+48>>2];q=-+g[K+52>>2];C=-+g[K+56>>2];g[J+96>>2]=(B*ea+(x*da+z*ca))*C+((s*ea+(_*da+Z*ca))*D+(v*ea+(Y*da+X*ca))*q);g[J+100>>2]=(B*ba+(x*aa+z*t))*C+((s*ba+(_*aa+Z*t))*D+(v*ba+(Y*aa+X*t))*q);g[J+104>>2]=(B*E+(x*u+z*m))*C+((s*E+(_*u+Z*m))*D+(v*E+(Y*u+X*m))*q);g[J+108>>2]=0.0;pc[$&127](J+112|0,f,J+96|0);q=+g[J+112>>2];m=+g[J+116>>2];u=+g[J+120>>2];E=+g[K+48>>2];D=+g[K+52>>2];C=+g[K+56>>2];t=C*(W*x+V*z+U*B+(x*T+z*Q+B*N)+((M*x+L*z+r*B)*q+(p*x+o*z+n*B)*m+(w*x+y*z+A*B)*u))+(E*(W*_+V*Z+U*s+(_*T+Z*Q+s*N)+((M*_+L*Z+r*s)*q+(p*_+o*Z+n*s)*m+(w*_+y*Z+A*s)*u))+D*(W*Y+V*X+U*v+(Y*T+X*Q+v*N)+((M*Y+L*X+r*v)*q+(p*Y+o*X+n*v)*m+(w*Y+y*X+A*v)*u)))-+g[K+64>>2];s=W*_+V*Z+U*s+(_*T+Z*Q+s*N)+((M*_+L*Z+r*s)*q+(p*_+o*Z+n*s)*m+(w*_+y*Z+A*s)*u)-E*t;v=W*Y+V*X+U*v+(Y*T+X*Q+v*N)+((M*Y+L*X+r*v)*q+(p*Y+o*X+n*v)*m+(w*Y+y*X+A*v)*u)-D*t;u=W*x+V*z+U*B+(x*T+z*Q+B*N)+((M*x+L*z+r*B)*q+(p*x+o*z+n*B)*m+(w*x+y*z+A*B)*u)-C*t;K=c[l+12>>2]|0;B=+g[K>>2];A=+g[K+4>>2];z=+g[K+8>>2];y=+g[K+16>>2];x=+g[K+20>>2];w=+g[K+24>>2];m=+g[K+32>>2];n=+g[K+36>>2];o=+g[K+40>>2];p=+g[K+48>>2];q=+g[K+52>>2];r=+g[K+56>>2];K=c[b+12>>2]|0;f=t<+g[K+752>>2];c[h+4>>2]=K;if(f){K=c[l+12>>2]|0;ga=E*+g[K+16>>2]+D*+g[K+20>>2]+C*+g[K+24>>2];fa=E*+g[K+32>>2]+D*+g[K+36>>2]+C*+g[K+40>>2];g[J+80>>2]=+g[K>>2]*E+ +g[K+4>>2]*D+ +g[K+8>>2]*C;g[J+84>>2]=ga;g[J+88>>2]=fa;g[J+92>>2]=0.0;g[J+64>>2]=z*u+(B*s+A*v)+p;g[J+68>>2]=s*y+v*x+u*w+q;g[J+72>>2]=s*m+v*n+u*o+r;g[J+76>>2]=0.0;oc[c[(c[h>>2]|0)+16>>2]&15](h,J+80|0,J+64|0,t)}k=k+1|0;l=c[b+20>>2]|0}while((k|0)<(l|0))}}if(!(a[b+8>>0]|0)){i=J;return}if(!(c[(c[b+12>>2]|0)+748>>2]|0)){i=J;return}j=c[h+4>>2]|0;if(!(c[j+748>>2]|0)){i=J;return}k=c[j+740>>2]|0;l=c[(c[h+8>>2]|0)+8>>2]|0;f=c[(c[h+12>>2]|0)+8>>2]|0;if((k|0)==(l|0)){Fs(j,k+4|0,f+4|0);i=J;return}else{Fs(j,f+4|0,l+4|0);i=J;return}}function Vt(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;return 1.0}function Wt(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0;k=i;if(!(c[b+12>>2]|0)){i=k;return}if(!(a[b+8>>0]|0)){i=k;return}e=c[d+4>>2]|0;if((e|0)==(c[d+8>>2]|0)?(j=(e|0)==0?1:e<<1,(e|0)<(j|0)):0){if(!j)f=0;else{c[5108]=(c[5108]|0)+1;f=QE((j<<2|3)+16|0)|0;if(!f)f=0;else{c[(f+19&-16)+-4>>2]=f;f=f+19&-16}e=c[d+4>>2]|0}if((e|0)>0){h=0;do{g=f+(h<<2)|0;if(g)c[g>>2]=c[(c[d+12>>2]|0)+(h<<2)>>2];h=h+1|0}while((h|0)!=(e|0))}g=c[d+12>>2]|0;if(g){if(a[d+16>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[g+-4>>2]|0);e=c[d+4>>2]|0}c[d+12>>2]=0}a[d+16>>0]=1;c[d+12>>2]=f;c[d+8>>2]=j}f=(c[d+12>>2]|0)+(e<<2)|0;if(f)c[f>>2]=c[b+12>>2];c[d+4>>2]=e+1;i=k;return}function Xt(a){a=a|0;var b=0,d=0;b=i;c[a>>2]=7152;c[a+12>>2]=7184;d=c[a+60>>2]|0;Lb[c[(c[d>>2]|0)+20>>2]&127](d,c[a+76>>2]|0);d=c[a+60>>2]|0;Lb[c[(c[d>>2]|0)+16>>2]&127](d,c[a+76>>2]|0);i=b;return}function Yt(a){a=a|0;var b=0,d=0;b=i;c[a>>2]=7152;c[a+12>>2]=7184;d=c[a+60>>2]|0;Lb[c[(c[d>>2]|0)+20>>2]&127](d,c[a+76>>2]|0);d=c[a+60>>2]|0;Lb[c[(c[d>>2]|0)+16>>2]&127](d,c[a+76>>2]|0);RE(a);i=b;return}function Zt(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0;k=i;if(!(c[b+76>>2]|0)){i=k;return}e=c[d+4>>2]|0;if((e|0)==(c[d+8>>2]|0)?(j=(e|0)==0?1:e<<1,(e|0)<(j|0)):0){if(!j)f=0;else{c[5108]=(c[5108]|0)+1;f=QE((j<<2|3)+16|0)|0;if(!f)f=0;else{c[(f+19&-16)+-4>>2]=f;f=f+19&-16}e=c[d+4>>2]|0}if((e|0)>0){h=0;do{g=f+(h<<2)|0;if(g)c[g>>2]=c[(c[d+12>>2]|0)+(h<<2)>>2];h=h+1|0}while((h|0)!=(e|0))}g=c[d+12>>2]|0;if(g){if(a[d+16>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[g+-4>>2]|0);e=c[d+4>>2]|0}c[d+12>>2]=0}a[d+16>>0]=1;c[d+12>>2]=f;c[d+8>>2]=j}f=(c[d+12>>2]|0)+(e<<2)|0;if(f)c[f>>2]=c[b+76>>2];c[d+4>>2]=e+1;i=k;return}function _t(a){a=a|0;var b=0,d=0;b=i;c[a>>2]=7184;d=c[a+48>>2]|0;Lb[c[(c[d>>2]|0)+20>>2]&127](d,c[a+64>>2]|0);d=c[a+48>>2]|0;Lb[c[(c[d>>2]|0)+16>>2]&127](d,c[a+64>>2]|0);i=b;return}function $t(a){a=a|0;var b=0,d=0;b=i;c[a>>2]=7184;d=c[a+48>>2]|0;Lb[c[(c[d>>2]|0)+20>>2]&127](d,c[a+64>>2]|0);d=c[a+48>>2]|0;Lb[c[(c[d>>2]|0)+16>>2]&127](d,c[a+64>>2]|0);RE(a);i=b;return}function au(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0,j=0.0,k=0.0,l=0.0,m=0,n=0,o=0.0,p=0;n=i;i=i+128|0;j=+g[b>>2];k=+g[b+16>>2];o=j<k?j:k;l=+g[b+32>>2];if((o<l?o:l)>+g[a+28>>2]){i=n;return}f=j>k?b:b+16|0;if(+g[(+g[f>>2]>l?f:b+32|0)>>2]<+g[a+12>>2]){i=n;return}l=+g[b+8>>2];k=+g[b+24>>2];o=l<k?l:k;j=+g[b+40>>2];if((o<j?o:j)>+g[a+36>>2]){i=n;return}f=l>k?b+8|0:b+24|0;if(+g[(+g[f>>2]>j?f:b+40|0)>>2]<+g[a+20>>2]){i=n;return}k=+g[b+4>>2];j=+g[b+20>>2];o=k<j?k:j;l=+g[b+36>>2];if((o<l?o:l)>+g[a+32>>2]){i=n;return}f=k>j?b+4|0:b+20|0;if(+g[(+g[f>>2]>l?f:b+36|0)>>2]<+g[a+16>>2]){i=n;return}m=c[a+48>>2]|0;h=c[a+4>>2]|0;if((c[(c[h+4>>2]|0)+4>>2]|0)>=20){i=n;return}c[n+32>>2]=0;g[n+36>>2]=1.0;g[n+40>>2]=1.0;g[n+44>>2]=1.0;g[n+48>>2]=0.0;c[n+76>>2]=0;c[n+24>>2]=7584;c[n+28>>2]=1;c[n+80>>2]=c[b+0>>2];c[n+84>>2]=c[b+4>>2];c[n+88>>2]=c[b+8>>2];c[n+92>>2]=c[b+12>>2];c[n+96>>2]=c[b+16>>2];c[n+100>>2]=c[b+20>>2];c[n+104>>2]=c[b+24>>2];c[n+108>>2]=c[b+28>>2];c[n+112>>2]=c[b+32>>2];c[n+116>>2]=c[b+36>>2];c[n+120>>2]=c[b+40>>2];c[n+124>>2]=c[b+44>>2];g[n+68>>2]=+g[a+56>>2];p=c[a+8>>2]|0;f=c[p+8>>2]|0;b=c[p+12>>2]|0;c[n>>2]=p;c[n+4>>2]=n+24;c[n+8>>2]=f;c[n+12>>2]=b;c[n+16>>2]=d;c[n+20>>2]=e;b=Rb[c[(c[m>>2]|0)+8>>2]&31](m,h,n,c[a+64>>2]|0)|0;f=c[a+44>>2]|0;h=c[f+8>>2]|0;if((c[h+8>>2]|0)==(c[(c[a+8>>2]|0)+8>>2]|0)){c[f+8>>2]=n;pc[c[(c[f>>2]|0)+8>>2]&127](f,d,e)}else{h=c[f+12>>2]|0;c[f+12>>2]=n;pc[c[(c[f>>2]|0)+12>>2]&127](f,d,e)}Hb[c[(c[b>>2]|0)+8>>2]&31](b,c[a+4>>2]|0,n,c[a+52>>2]|0,c[a+44>>2]|0);f=c[a+44>>2]|0;if((c[(c[f+8>>2]|0)+8>>2]|0)==(c[(c[a+8>>2]|0)+8>>2]|0))c[f+8>>2]=h;else c[f+12>>2]=h;Jb[c[c[b>>2]>>2]&255](b);Lb[c[(c[m>>2]|0)+60>>2]&127](m,b);c[n+24>>2]=13336;f=c[n+76>>2]|0;if(!f){i=n;return}Jb[c[c[f>>2]>>2]&255](f);f=c[n+76>>2]|0;if(!f){i=n;return}c[5110]=(c[5110]|0)+1;RE(c[f+-4>>2]|0);i=n;return}function bu(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var j=0,k=0,l=0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0;l=i;i=i+64|0;j=(a[b+8>>0]|0)!=0;k=j?e:d;d=j?d:e;j=c[d+4>>2]|0;if(((c[j+4>>2]|0)+-21|0)>>>0>=9){i=l;return}if((c[(c[k+4>>2]|0)+4>>2]|0)>=20){i=l;return}m=+Zb[c[(c[j>>2]|0)+48>>2]&15](j);c[h+4>>2]=c[b+76>>2];c[b+16>>2]=k;c[b+20>>2]=d;c[b+64>>2]=f;g[b+68>>2]=m;c[b+56>>2]=h;e=c[d+12>>2]|0;B=+g[e>>2];A=+g[e+16>>2];z=+g[e+32>>2];y=+g[e+4>>2];x=+g[e+20>>2];w=+g[e+36>>2];s=+g[e+8>>2];q=+g[e+24>>2];o=+g[e+40>>2];v=-+g[e+48>>2];u=-+g[e+52>>2];t=-+g[e+56>>2];e=c[k+12>>2]|0;K=+g[e>>2];J=+g[e+16>>2];I=+g[e+32>>2];H=+g[e+4>>2];G=+g[e+20>>2];F=+g[e+36>>2];E=+g[e+8>>2];D=+g[e+24>>2];C=+g[e+40>>2];r=+g[e+48>>2];p=+g[e+52>>2];n=+g[e+56>>2];g[l>>2]=B*K+A*J+z*I;g[l+4>>2]=B*H+A*G+z*F;g[l+8>>2]=B*E+A*D+z*C;g[l+12>>2]=0.0;g[l+16>>2]=y*K+x*J+w*I;g[l+20>>2]=y*H+x*G+w*F;g[l+24>>2]=y*E+x*D+w*C;g[l+28>>2]=0.0;g[l+32>>2]=s*K+q*J+o*I;g[l+36>>2]=s*H+q*G+o*F;g[l+40>>2]=s*E+q*D+o*C;g[l+44>>2]=0.0;g[l+48>>2]=B*v+A*u+z*t+(B*r+A*p+z*n);g[l+52>>2]=y*v+x*u+w*t+(y*r+x*p+w*n);g[l+56>>2]=s*v+q*u+o*t+(s*r+q*p+o*n);g[l+60>>2]=0.0;e=c[(c[b+16>>2]|0)+4>>2]|0;tc[c[(c[e>>2]|0)+8>>2]&127](e,l,b+24|0,b+40|0);g[b+40>>2]=+g[b+40>>2]+m;g[b+44>>2]=+g[b+44>>2]+m;g[b+48>>2]=+g[b+48>>2]+m;g[b+24>>2]=+g[b+24>>2]-m;g[b+28>>2]=+g[b+28>>2]-m;g[b+32>>2]=+g[b+32>>2]-m;e=c[b+76>>2]|0;d=c[d+8>>2]|0;c[e+740>>2]=c[k+8>>2];c[e+744>>2]=d;tc[c[(c[j>>2]|0)+64>>2]&127](j,b+12|0,b+24|0,b+40|0);k=c[h+4>>2]|0;do if(c[k+748>>2]|0){e=c[k+740>>2]|0;d=c[(c[h+8>>2]|0)+8>>2]|0;j=c[(c[h+12>>2]|0)+8>>2]|0;if((e|0)==(d|0)){Fs(k,e+4|0,j+4|0);break}else{Fs(k,j+4|0,d+4|0);break}}while(0);c[b+16>>2]=0;c[b+20>>2]=0;i=l;return}function cu(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,N=0.0,O=0.0,P=0.0,Q=0.0,R=0.0,S=0.0,T=0.0,U=0.0,V=0.0,W=0.0;h=i;i=i+240|0;f=(a[b+8>>0]|0)!=0;b=f?e:d;e=f?d:e;A=+g[b+116>>2]-+g[b+52>>2];C=+g[b+120>>2]-+g[b+56>>2];D=+g[b+124>>2]-+g[b+60>>2];E=+g[b+252>>2];if(A*A+C*C+D*D<E*E){E=1.0;i=h;return +E}O=+g[e+4>>2];P=+g[e+20>>2];p=+g[e+36>>2];q=+g[e+8>>2];r=+g[e+24>>2];s=+g[e+40>>2];t=+g[e+12>>2];u=+g[e+28>>2];v=+g[e+44>>2];n=-+g[e+52>>2];m=-+g[e+56>>2];l=-+g[e+60>>2];w=+g[b+4>>2];x=+g[b+20>>2];y=+g[b+36>>2];z=+g[b+8>>2];A=+g[b+24>>2];B=+g[b+40>>2];C=+g[b+12>>2];D=+g[b+28>>2];E=+g[b+44>>2];G=+g[b+52>>2];F=+g[b+56>>2];T=+g[b+60>>2];R=O*n+P*m+p*l+(O*G+P*F+p*T);V=q*n+r*m+s*l+(q*G+r*F+s*T);T=t*n+u*m+v*l+(t*G+u*F+v*T);F=+g[b+68>>2];G=+g[b+84>>2];H=+g[b+100>>2];I=+g[b+72>>2];J=+g[b+88>>2];K=+g[b+104>>2];L=+g[b+76>>2];M=+g[b+92>>2];N=+g[b+108>>2];k=+g[b+116>>2];j=+g[b+120>>2];S=+g[b+124>>2];Q=O*n+P*m+p*l+(O*k+P*j+p*S);U=q*n+r*m+s*l+(q*k+r*j+s*S);S=t*n+u*m+v*l+(t*k+u*j+v*S);e=c[e+192>>2]|0;if(((c[e+4>>2]|0)+-21|0)>>>0>=9){E=1.0;i=h;return +E}g[h+224>>2]=R;g[h+228>>2]=V;g[h+232>>2]=T;g[h+236>>2]=0.0;if(Q<R){g[h+224>>2]=Q;j=Q}else j=R;if(U<V){g[h+228>>2]=U;k=U}else k=V;if(S<T){g[h+232>>2]=S;l=S}else l=T;g[h+208>>2]=R;g[h+212>>2]=V;g[h+216>>2]=T;g[h+220>>2]=0.0;if(R<Q){g[h+208>>2]=Q;m=Q}else m=R;if(V<U){g[h+212>>2]=U;n=U}else n=V;if(T<S){g[h+216>>2]=S;o=S}else o=T;W=+g[b+248>>2];g[h+224>>2]=j-W;g[h+228>>2]=k-W;g[h+232>>2]=l-W;g[h+208>>2]=W+m;g[h+212>>2]=W+n;g[h+216>>2]=W+o;c[h>>2]=7312;g[h+4>>2]=O*w+P*x+p*y;g[h+8>>2]=O*z+P*A+p*B;g[h+12>>2]=O*C+P*D+p*E;g[h+16>>2]=0.0;g[h+20>>2]=q*w+r*x+s*y;g[h+24>>2]=q*z+r*A+s*B;g[h+28>>2]=q*C+r*D+s*E;g[h+32>>2]=0.0;g[h+36>>2]=t*w+u*x+v*y;g[h+40>>2]=t*z+u*A+v*B;g[h+44>>2]=t*C+u*D+v*E;g[h+48>>2]=0.0;g[h+52>>2]=R;g[h+56>>2]=V;g[h+60>>2]=T;g[h+64>>2]=0.0;g[h+68>>2]=O*F+P*G+p*H;g[h+72>>2]=O*I+P*J+p*K;g[h+76>>2]=O*L+P*M+p*N;g[h+80>>2]=0.0;g[h+84>>2]=q*F+r*G+s*H;g[h+88>>2]=q*I+r*J+s*K;g[h+92>>2]=q*L+r*M+s*N;g[h+96>>2]=0.0;g[h+100>>2]=t*F+u*G+v*H;g[h+104>>2]=t*I+u*J+v*K;g[h+108>>2]=t*L+u*M+v*N;g[h+112>>2]=0.0;g[h+116>>2]=Q;g[h+120>>2]=U;g[h+124>>2]=S;g[h+128>>2]=0.0;g[h+196>>2]=W;g[h+200>>2]=+g[b+244>>2];if(!e){E=1.0;i=h;return +E}tc[c[(c[e>>2]|0)+64>>2]&127](e,h,h+224|0,h+208|0);j=+g[h+200>>2];if(!(j<+g[b+244>>2])){E=1.0;i=h;return +E}g[b+244>>2]=j;E=j;i=h;return +E}function du(a,b){a=a|0;b=+b;g[a+44>>2]=b;return}function eu(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var h=0.0,j=0.0;f=i;i=i+784|0;g[f+712>>2]=1.0;c[f+716>>2]=0;c[f+720>>2]=0;c[f+724>>2]=0;c[f+728>>2]=0;g[f+732>>2]=1.0;c[f+736>>2]=0;c[f+740>>2]=0;c[f+744>>2]=0;c[f+748>>2]=0;g[f+752>>2]=1.0;e=f+756|0;c[e+0>>2]=0;c[e+4>>2]=0;c[e+8>>2]=0;c[e+12>>2]=0;c[e+16>>2]=0;c[f+536>>2]=7512;c[f+704>>2]=0;g[f+708>>2]=0.0;g[f+700>>2]=+g[b+200>>2];j=+g[b+196>>2];c[f+488>>2]=0;g[f+492>>2]=1.0;g[f+496>>2]=1.0;g[f+500>>2]=1.0;g[f+504>>2]=0.0;c[f+480>>2]=12008;c[f+484>>2]=8;g[f+508>>2]=j;g[f+524>>2]=j;c[f+384>>2]=0;g[f+388>>2]=1.0;g[f+392>>2]=1.0;g[f+396>>2]=1.0;g[f+400>>2]=0.0;g[f+420>>2]=.03999999910593033;c[f+428>>2]=0;c[f+376>>2]=7584;c[f+380>>2]=1;c[f+432>>2]=c[d+0>>2];c[f+436>>2]=c[d+4>>2];c[f+440>>2]=c[d+8>>2];c[f+444>>2]=c[d+12>>2];c[f+448>>2]=c[d+16>>2];c[f+452>>2]=c[d+20>>2];c[f+456>>2]=c[d+24>>2];c[f+460>>2]=c[d+28>>2];c[f+464>>2]=c[d+32>>2];c[f+468>>2]=c[d+36>>2];c[f+472>>2]=c[d+40>>2];c[f+476>>2]=c[d+44>>2];g[f+324>>2]=9.999999747378752e-05;a[f+348>>0]=0;c[f>>2]=18976;c[f+4>>2]=f+16;c[f+8>>2]=f+480;c[f+12>>2]=f+376;if(QC(f,b+4|0,b+68|0,f+712|0,f+712|0,f+536|0)|0?(h=+g[f+700>>2],+g[b+200>>2]>h):0)g[b+200>>2]=h;c[f+376>>2]=13336;e=c[f+428>>2]|0;if(!e){i=f;return}Jb[c[c[e>>2]>>2]&255](e);e=c[f+428>>2]|0;if(!e){i=f;return}c[5110]=(c[5110]|0)+1;RE(c[e+-4>>2]|0);i=f;return}function fu(a){a=a|0;return}function gu(a){a=a|0;var b=0;b=i;RE(a);i=b;return}function hu(a,b,c){a=a|0;b=b|0;c=c|0;return}function iu(a,b){a=a|0;b=b|0;return}function ju(a,b){a=a|0;b=+b;return}function ku(a){a=a|0;var b=0;b=i;RE(a);i=b;return}function lu(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0;h=+g[a+56>>2];k=+g[a+72>>2]-h;j=+g[a+60>>2];i=+g[a+76>>2]-j;l=+g[a+64>>2];m=+g[a+80>>2]-l;h=+g[a+88>>2]-h;j=+g[a+92>>2]-j;l=+g[a+96>>2]-l;g[d+12>>2]=0.0;f=1.0/+P(+((k*j-i*h)*(k*j-i*h)+((i*l-m*j)*(i*l-m*j)+(m*h-k*l)*(m*h-k*l))));g[d>>2]=f*(i*l-m*j);g[d+4>>2]=f*(m*h-k*l);g[d+8>>2]=(k*j-i*h)*f;c[e+0>>2]=c[a+56>>2];c[e+4>>2]=c[a+60>>2];c[e+8>>2]=c[a+64>>2];c[e+12>>2]=c[a+68>>2];return}function mu(a,b,d){a=a|0;b=b|0;d=+d;var e=0,f=0.0,h=0.0,j=0.0,k=0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0;k=i;i=i+32|0;n=+g[a+56>>2];r=+g[a+72>>2]-n;m=+g[a+60>>2];p=+g[a+76>>2]-m;l=+g[a+64>>2];s=+g[a+80>>2]-l;o=+g[a+88>>2]-n;q=+g[a+92>>2]-m;h=+g[a+96>>2]-l;j=1.0/+P(+((r*q-p*o)*(r*q-p*o)+((p*h-s*q)*(p*h-s*q)+(s*o-r*h)*(s*o-r*h))));f=j*(p*h-s*q);h=j*(s*o-r*h);j=(r*q-p*o)*j;l=+g[b>>2]*f+ +g[b+4>>2]*h+j*+g[b+8>>2]-(f*n+h*m+j*l);if(!(l>=-d)|!(l<=d)){b=0;i=k;return b|0}e=0;while(1){tc[c[(c[a>>2]|0)+104>>2]&127](a,e,k+16|0,k);q=+g[k+16>>2];p=+g[k>>2]-q;m=+g[k+20>>2];l=+g[k+4>>2]-m;r=+g[k+24>>2];o=+g[k+8>>2]-r;n=1.0/+P(+((h*p-f*l)*(h*p-f*l)+((j*l-h*o)*(j*l-h*o)+(f*o-j*p)*(f*o-j*p))));e=e+1|0;if(+g[b>>2]*(n*(j*l-h*o))+ +g[b+4>>2]*(n*(f*o-j*p))+(h*p-f*l)*n*+g[b+8>>2]-(r*((h*p-f*l)*n)+(q*(n*(j*l-h*o))+m*(n*(f*o-j*p))))<-d){b=0;e=5;break}if((e|0)>=3){b=1;e=5;break}}if((e|0)==5){i=k;return b|0}return 0}function nu(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0;f=i;tc[c[(c[a>>2]|0)+124>>2]&127](a,e,b,d);i=f;return}function ou(a){a=a|0;return 1}function pu(a,b,d){a=a|0;b=b|0;d=d|0;c[d+0>>2]=c[a+(b<<4)+56>>2];c[d+4>>2]=c[a+(b<<4)+60>>2];c[d+8>>2]=c[a+(b<<4)+64>>2];c[d+12>>2]=c[a+(b<<4)+68>>2];return}function qu(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0;f=i;pc[c[(c[a>>2]|0)+108>>2]&127](a,b,d);pc[c[(c[a>>2]|0)+108>>2]&127](a,(b+1|0)%3|0,e);i=f;return}function ru(a){a=a|0;return 3}function su(a){a=a|0;return 3}function tu(a,b,c){a=a|0;b=b|0;c=c|0;var d=0.0,e=0.0,f=0.0,h=0.0,j=0.0,k=0.0,l=0.0,m=0;m=i;h=+g[a+56>>2];f=+g[a+72>>2]-h;l=+g[a+60>>2];k=+g[a+76>>2]-l;e=+g[a+64>>2];j=+g[a+80>>2]-e;h=+g[a+88>>2]-h;l=+g[a+92>>2]-l;e=+g[a+96>>2]-e;g[c+12>>2]=0.0;d=1.0/+P(+((f*l-k*h)*(f*l-k*h)+((k*e-j*l)*(k*e-j*l)+(j*h-f*e)*(j*h-f*e))));g[c>>2]=d*(k*e-j*l);g[c+4>>2]=d*(j*h-f*e);g[c+8>>2]=(f*l-k*h)*d;if(!b){i=m;return}g[c>>2]=-(d*(k*e-j*l));g[c+4>>2]=-(d*(j*h-f*e));g[c+8>>2]=-((f*l-k*h)*d);i=m;return}function uu(a){a=a|0;return 2}function vu(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0.0,j=0.0,k=0.0,l=0,m=0,n=0,o=0.0,p=0.0;n=i;if((e|0)<=0){i=n;return}m=0;do{p=+g[b+(m<<4)>>2];o=+g[b+(m<<4)+4>>2];j=+g[b+(m<<4)+8>>2];h=p*+g[a+56>>2]+o*+g[a+60>>2]+j*+g[a+64>>2];k=p*+g[a+72>>2]+o*+g[a+76>>2]+j*+g[a+80>>2];j=p*+g[a+88>>2]+o*+g[a+92>>2]+j*+g[a+96>>2];l=d+(m<<4)|0;if(h<k)f=k<j?2:1;else f=h<j?2:0;f=a+(f<<4)+56|0;c[l+0>>2]=c[f+0>>2];c[l+4>>2]=c[f+4>>2];c[l+8>>2]=c[f+8>>2];c[l+12>>2]=c[f+12>>2];m=m+1|0}while((m|0)!=(e|0));i=n;return}function wu(a,b,d){a=a|0;b=b|0;d=d|0;var e=0.0,f=0.0,h=0.0,j=0,k=0.0,l=0.0;j=i;l=+g[d>>2];k=+g[d+4>>2];f=+g[d+8>>2];e=l*+g[b+56>>2]+k*+g[b+60>>2]+f*+g[b+64>>2];h=l*+g[b+72>>2]+k*+g[b+76>>2]+f*+g[b+80>>2];f=l*+g[b+88>>2]+k*+g[b+92>>2]+f*+g[b+96>>2];if(e<h){d=h<f?2:1;d=b+(d<<4)+56|0;c[a+0>>2]=c[d+0>>2];c[a+4>>2]=c[d+4>>2];c[a+8>>2]=c[d+8>>2];c[a+12>>2]=c[d+12>>2];i=j;return}else{d=e<f?2:0;d=b+(d<<4)+56|0;c[a+0>>2]=c[d+0>>2];c[a+4>>2]=c[d+4>>2];c[a+8>>2]=c[d+8>>2];c[a+12>>2]=c[d+12>>2];i=j;return}}function xu(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,h=0;f=i;e=ec[c[(c[d>>2]|0)+40>>2]&31](d,a)|0;h=ec[c[(c[d>>2]|0)+28>>2]&31](d,e)|0;c[b>>2]=h;if(h)Lb[c[(c[d>>2]|0)+48>>2]&127](d,e);c[b+4>>2]=c[a+4>>2];g[b+28>>2]=+g[a+28>>2];g[b+32>>2]=+g[a+32>>2];g[b+36>>2]=+g[a+36>>2];g[b+40>>2]=+g[a+40>>2];g[b+12>>2]=+g[a+12>>2];g[b+16>>2]=+g[a+16>>2];g[b+20>>2]=+g[a+20>>2];g[b+24>>2]=+g[a+24>>2];g[b+44>>2]=+g[a+44>>2];i=f;return 7752}function yu(a){a=a|0;return 52}function zu(a){a=a|0;return +(+g[a+44>>2])}function Au(a,b){a=a|0;b=b|0;g[a>>2]=1.0;g[a+4>>2]=1.0;g[a+8>>2]=1.0;g[a+12>>2]=0.0;return}function Bu(a){a=a|0;return 7784}function Cu(a,b,d){a=a|0;b=+b;d=d|0;c[d+0>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;return}function Du(a){a=a|0;return a+12|0}function Eu(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0;f=i;tc[c[(c[a>>2]|0)+80>>2]&127](a,b,d,e);i=f;return}function Fu(a){a=a|0;var b=0,d=0;d=i;c[a>>2]=13336;b=c[a+52>>2]|0;if(b){Jb[c[c[b>>2]>>2]&255](b);b=c[a+52>>2]|0;if(b){c[5110]=(c[5110]|0)+1;RE(c[b+-4>>2]|0)}if(!a){i=d;return}}c[5110]=(c[5110]|0)+1;RE(c[a+-4>>2]|0);i=d;return}function Gu(b){b=b|0;var d=0,e=0;e=i;c[b>>2]=7808;if(!(a[b+8>>0]|0)){i=e;return}d=c[b+12>>2]|0;if(!d){i=e;return}b=c[b+4>>2]|0;Lb[c[(c[b>>2]|0)+16>>2]&127](b,d);i=e;return}function Hu(b){b=b|0;var d=0,e=0,f=0;e=i;c[b>>2]=7808;if(!(a[b+8>>0]|0)){RE(b);i=e;return}d=c[b+12>>2]|0;if(!d){RE(b);i=e;return}f=c[b+4>>2]|0;Lb[c[(c[f>>2]|0)+16>>2]&127](f,d);RE(b);i=e;return}function Iu(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var j=0,k=0,l=0,m=0;k=i;i=i+144|0;j=c[b+12>>2]|0;if(!j){i=k;return}m=c[d+4>>2]|0;l=c[e+4>>2]|0;c[h+4>>2]=j;g[k+140>>2]=999999984306749440.0;d=c[d+12>>2]|0;c[k+12>>2]=c[d+0>>2];c[k+16>>2]=c[d+4>>2];c[k+20>>2]=c[d+8>>2];c[k+24>>2]=c[d+12>>2];c[k+28>>2]=c[d+16>>2];c[k+32>>2]=c[d+20>>2];c[k+36>>2]=c[d+24>>2];c[k+40>>2]=c[d+28>>2];c[k+44>>2]=c[d+32>>2];c[k+48>>2]=c[d+36>>2];c[k+52>>2]=c[d+40>>2];c[k+56>>2]=c[d+44>>2];c[k+60>>2]=c[d+48>>2];c[k+64>>2]=c[d+52>>2];c[k+68>>2]=c[d+56>>2];c[k+72>>2]=c[d+60>>2];e=c[e+12>>2]|0;c[k+76>>2]=c[e+0>>2];c[k+80>>2]=c[e+4>>2];c[k+84>>2]=c[e+8>>2];c[k+88>>2]=c[e+12>>2];c[k+92>>2]=c[e+16>>2];c[k+96>>2]=c[e+20>>2];c[k+100>>2]=c[e+24>>2];c[k+104>>2]=c[e+28>>2];c[k+108>>2]=c[e+32>>2];c[k+112>>2]=c[e+36>>2];c[k+116>>2]=c[e+40>>2];c[k+120>>2]=c[e+44>>2];c[k+124>>2]=c[e+48>>2];c[k+128>>2]=c[e+52>>2];c[k+132>>2]=c[e+56>>2];c[k+136>>2]=c[e+60>>2];c[k>>2]=19760;c[k+4>>2]=m;c[k+8>>2]=l;BD(k,k+12|0,h,c[f+20>>2]|0,0);if(!(a[b+8>>0]|0)){i=k;return}e=c[h+4>>2]|0;if(!(c[e+748>>2]|0)){i=k;return}d=c[e+740>>2]|0;j=c[(c[h+8>>2]|0)+8>>2]|0;f=c[(c[h+12>>2]|0)+8>>2]|0;if((d|0)==(j|0)){Fs(e,d+4|0,f+4|0);i=k;return}else{Fs(e,f+4|0,j+4|0);i=k;return}}function Ju(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;return 1.0}function Ku(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0;k=i;if(!(c[b+12>>2]|0)){i=k;return}if(!(a[b+8>>0]|0)){i=k;return}e=c[d+4>>2]|0;if((e|0)==(c[d+8>>2]|0)?(j=(e|0)==0?1:e<<1,(e|0)<(j|0)):0){if(!j)f=0;else{c[5108]=(c[5108]|0)+1;f=QE((j<<2|3)+16|0)|0;if(!f)f=0;else{c[(f+19&-16)+-4>>2]=f;f=f+19&-16}e=c[d+4>>2]|0}if((e|0)>0){h=0;do{g=f+(h<<2)|0;if(g)c[g>>2]=c[(c[d+12>>2]|0)+(h<<2)>>2];h=h+1|0}while((h|0)!=(e|0))}g=c[d+12>>2]|0;if(g){if(a[d+16>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[g+-4>>2]|0);e=c[d+4>>2]|0}c[d+12>>2]=0}a[d+16>>0]=1;c[d+12>>2]=f;c[d+8>>2]=j}f=(c[d+12>>2]|0)+(e<<2)|0;if(f)c[f>>2]=c[b+12>>2];c[d+4>>2]=e+1;i=k;return}function Lu(b,d,e,f){b=b|0;d=d|0;e=e|0;f=+f;var h=0,j=0.0,k=0.0,l=0.0,m=0.0,n=0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0,v=0,w=0,x=0,y=0,z=0,A=0.0,B=0.0;z=i;i=i+192|0;y=c[b+4>>2]|0;if(+g[y+752>>2]<f){i=z;return}w=c[y+740>>2]|0;v=(c[b+8>>2]|0)+8|0;x=c[v>>2]|0;k=+g[e>>2];o=+g[d>>2]*f+k;j=+g[e+4>>2];q=+g[d+4>>2]*f+j;l=+g[e+8>>2];p=+g[d+8>>2]*f+l;u=(c[b+12>>2]|0)+8|0;n=c[u>>2]|0;if((w|0)!=(x|0)){B=o-+g[n+52>>2];m=q-+g[n+56>>2];t=p-+g[n+60>>2];A=k-+g[x+52>>2];j=j-+g[x+56>>2];l=l-+g[x+60>>2];r=B*+g[n+4>>2]+m*+g[n+20>>2]+t*+g[n+36>>2];s=B*+g[n+8>>2]+m*+g[n+24>>2]+t*+g[n+40>>2];t=B*+g[n+12>>2]+m*+g[n+28>>2]+t*+g[n+44>>2];m=A*+g[x+4>>2]+j*+g[x+20>>2]+l*+g[x+36>>2];k=A*+g[x+8>>2]+j*+g[x+24>>2]+l*+g[x+40>>2];l=A*+g[x+12>>2]+j*+g[x+28>>2]+l*+g[x+44>>2]}else{B=o-+g[w+52>>2];m=q-+g[w+56>>2];t=p-+g[w+60>>2];A=k-+g[n+52>>2];j=j-+g[n+56>>2];l=l-+g[n+60>>2];r=B*+g[w+4>>2]+m*+g[w+20>>2]+t*+g[w+36>>2];s=B*+g[w+8>>2]+m*+g[w+24>>2]+t*+g[w+40>>2];t=B*+g[w+12>>2]+m*+g[w+28>>2]+t*+g[w+44>>2];m=A*+g[n+4>>2]+j*+g[n+20>>2]+l*+g[n+36>>2];k=A*+g[n+8>>2]+j*+g[n+24>>2]+l*+g[n+40>>2];l=A*+g[n+12>>2]+j*+g[n+28>>2]+l*+g[n+44>>2]}g[z>>2]=r;g[z+4>>2]=s;g[z+8>>2]=t;g[z+12>>2]=0.0;g[z+16>>2]=m;g[z+20>>2]=k;g[z+24>>2]=l;g[z+28>>2]=0.0;c[z+64>>2]=c[d+0>>2];c[z+68>>2]=c[d+4>>2];c[z+72>>2]=c[d+8>>2];c[z+76>>2]=c[d+12>>2];g[z+80>>2]=f;g[z+84>>2]=0.0;g[z+88>>2]=0.0;g[z+92>>2]=0.0;c[z+112>>2]=0;a[z+116>>0]=0;c[z+120>>2]=0;c[z+124>>2]=0;c[z+128>>2]=0;c[z+132>>2]=0;c[z+136>>2]=0;c[z+140>>2]=0;c[z+144>>2]=0;c[z+148>>2]=0;g[z+48>>2]=o;g[z+52>>2]=q;g[z+56>>2]=p;g[z+60>>2]=0.0;c[z+32>>2]=c[e+0>>2];c[z+36>>2]=c[e+4>>2];c[z+40>>2]=c[e+8>>2];c[z+44>>2]=c[e+12>>2];l=+g[y+752>>2];h=c[y+748>>2]|0;if((h|0)>0){n=0;d=-1;l=l*l;while(1){k=+g[y+(n*184|0)+4>>2]-r;m=+g[y+(n*184|0)+8>>2]-s;j=+g[y+(n*184|0)+12>>2]-t;e=k*k+m*m+j*j<l;d=e?n:d;n=n+1|0;if((n|0)==(h|0))break;else l=e?k*k+m*m+j*j:l}}else d=-1;n=c[v>>2]|0;u=c[u>>2]|0;j=+g[n+224>>2]*+g[u+224>>2];j=j<-10.0?-10.0:j;g[z+84>>2]=j>10.0?10.0:j;g[z+92>>2]=+g[n+228>>2]*+g[u+228>>2];j=+g[n+232>>2]*+g[u+232>>2];j=j<-10.0?-10.0:j;g[z+88>>2]=j>10.0?10.0:j;j=+g[z+72>>2];u=+O(+j)>.7071067690849304;k=+g[z+68>>2];if(u){r=1.0/+P(+(j*j+k*k));g[z+152>>2]=0.0;g[z+156>>2]=-(r*j);g[z+160>>2]=r*k;g[z+168>>2]=(j*j+k*k)*r;f=+g[z+64>>2];l=-(f*(r*k));j=f*-(r*j)}else{f=+g[z+64>>2];r=1.0/+P(+(f*f+k*k));g[z+152>>2]=-(k*r);g[z+156>>2]=r*f;g[z+160>>2]=0.0;g[z+168>>2]=-(j*(r*f));l=j*-(k*r);j=(f*f+k*k)*r}g[z+172>>2]=l;g[z+176>>2]=j;if((w|0)!=(x|0)){c[z+96>>2]=c[b+20>>2];c[z+100>>2]=c[b+16>>2];e=b+24|0;h=b+28|0}else{c[z+96>>2]=c[b+16>>2];c[z+100>>2]=c[b+20>>2];e=b+28|0;h=b+24|0}c[z+104>>2]=c[h>>2];c[z+108>>2]=c[e>>2];if((d|0)>-1){b=y+(d*184|0)+152|0;w=c[b>>2]|0;n=y+(d*184|0)+124|0;q=+g[n>>2];x=y+(d*184|0)+128|0;f=+g[x>>2];u=y+(d*184|0)+132|0;r=+g[u>>2];v=y+(d*184|0)+116|0;e=c[v>>2]|0;YE(y+(d*184|0)+4|0,z|0,184)|0;c[v>>2]=e;g[n>>2]=q;g[x>>2]=f;g[u>>2]=r;c[b>>2]=w;i=z;return}else{Es(y,z)|0;i=z;return}}function Mu(a,b,d){a=a|0;b=b|0;d=d|0;c[a+20>>2]=b;c[a+28>>2]=d;return}function Nu(a,b,d){a=a|0;b=b|0;d=d|0;c[a+16>>2]=b;c[a+24>>2]=d;return}function Ou(a){a=a|0;var b=0;b=i;RE(a);i=b;return}function Pu(a){a=a|0;return}function Qu(b){b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0;j=i;c[b>>2]=8016;e=c[b+8>>2]|0;d=c[b+16>>2]|0;if((e|0)>0){h=0;do{g=(c[d+(h<<2)>>2]|0)+188|0;f=c[g>>2]|0;if(f){e=c[b+68>>2]|0;e=Nb[c[(c[e>>2]|0)+36>>2]&127](e)|0;pc[c[(c[e>>2]|0)+40>>2]&127](e,f,c[b+24>>2]|0);e=c[b+68>>2]|0;pc[c[(c[e>>2]|0)+12>>2]&127](e,f,c[b+24>>2]|0);c[g>>2]=0;e=c[b+8>>2]|0;d=c[b+16>>2]|0}h=h+1|0}while((h|0)<(e|0))}if(!d){a[b+20>>0]=1;c[b+16>>2]=0;c[b+8>>2]=0;d=b+12|0;c[d>>2]=0;i=j;return}if(a[b+20>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}c[b+16>>2]=0;a[b+20>>0]=1;c[b+16>>2]=0;c[b+8>>2]=0;d=b+12|0;c[d>>2]=0;i=j;return}function Ru(a){a=a|0;var b=0;b=i;Qu(a);RE(a);i=b;return}function Su(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0;m=i;i=i+96|0;g=c[b+8>>2]|0;if((g|0)==(c[b+12>>2]|0)?(l=(g|0)==0?1:g<<1,(g|0)<(l|0)):0){if(!l)h=0;else{c[5108]=(c[5108]|0)+1;h=QE((l<<2|3)+16|0)|0;if(!h)h=0;else{c[(h+19&-16)+-4>>2]=h;h=h+19&-16}g=c[b+8>>2]|0}if((g|0)>0){k=0;do{j=h+(k<<2)|0;if(j)c[j>>2]=c[(c[b+16>>2]|0)+(k<<2)>>2];k=k+1|0}while((k|0)!=(g|0))}j=c[b+16>>2]|0;if(j){if(a[b+20>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[j+-4>>2]|0);g=c[b+8>>2]|0}c[b+16>>2]=0}a[b+20>>0]=1;c[b+16>>2]=h;c[b+12>>2]=l}h=(c[b+16>>2]|0)+(g<<2)|0;if(h)c[h>>2]=d;c[b+8>>2]=g+1;c[m+32>>2]=c[d+4>>2];c[m+36>>2]=c[d+8>>2];c[m+40>>2]=c[d+12>>2];c[m+44>>2]=c[d+16>>2];c[m+48>>2]=c[d+20>>2];c[m+52>>2]=c[d+24>>2];c[m+56>>2]=c[d+28>>2];c[m+60>>2]=c[d+32>>2];c[m+64>>2]=c[d+36>>2];c[m+68>>2]=c[d+40>>2];c[m+72>>2]=c[d+44>>2];c[m+76>>2]=c[d+48>>2];c[m+80>>2]=c[d+52>>2];c[m+84>>2]=c[d+56>>2];c[m+88>>2]=c[d+60>>2];c[m+92>>2]=c[d+64>>2];g=c[d+192>>2]|0;tc[c[(c[g>>2]|0)+8>>2]&127](g,m+32|0,m+16|0,m);g=c[b+68>>2]|0;c[d+188>>2]=nc[c[(c[g>>2]|0)+8>>2]&3](g,m+16|0,m,c[(c[d+192>>2]|0)+4>>2]|0,d,e,f,c[b+24>>2]|0,0)|0;i=m;return}function Tu(b){b=b|0;var d=0,e=0.0,f=0.0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0,r=0,s=0,t=0,u=0;t=i;i=i+64|0;aE(8296);d=c[b+8>>2]|0;if((d|0)>0){r=0;do{q=c[(c[b+16>>2]|0)+(r<<2)>>2]|0;if(!((a[b+76>>0]|0)==0?(u=c[q+216>>2]|0,(u|0)==2|(u|0)==5):0)){d=c[q+192>>2]|0;tc[c[(c[d>>2]|0)+8>>2]&127](d,q+4|0,t+48|0,t+32|0);e=+g[t+48>>2]+-.019999999552965164;g[t+48>>2]=e;f=+g[t+52>>2]+-.019999999552965164;g[t+52>>2]=f;h=+g[t+56>>2]+-.019999999552965164;g[t+56>>2]=h;j=+g[t+32>>2]+.019999999552965164;g[t+32>>2]=j;k=+g[t+36>>2]+.019999999552965164;g[t+36>>2]=k;l=+g[t+40>>2]+.019999999552965164;g[t+40>>2]=l;if(((a[b+44>>0]|0)!=0?(c[q+236>>2]|0)==2:0)?(c[q+204>>2]&3|0)==0:0){d=c[q+192>>2]|0;tc[c[(c[d>>2]|0)+8>>2]&127](d,q+68|0,t+16|0,t);m=+g[t+16>>2]+-.019999999552965164;g[t+16>>2]=m;l=+g[t+20>>2]+-.019999999552965164;g[t+20>>2]=l;k=+g[t+24>>2]+-.019999999552965164;g[t+24>>2]=k;n=+g[t>>2]+.019999999552965164;g[t>>2]=n;o=+g[t+4>>2]+.019999999552965164;g[t+4>>2]=o;p=+g[t+8>>2]+.019999999552965164;g[t+8>>2]=p;e=+g[t+48>>2];if(m<e){g[t+48>>2]=m;e=m}f=+g[t+52>>2];if(l<f){g[t+52>>2]=l;f=l}h=+g[t+56>>2];if(k<h){g[t+56>>2]=k;h=k}j=+g[t+28>>2];if(j<+g[t+60>>2])g[t+60>>2]=j;j=+g[t+32>>2];if(j<n){g[t+32>>2]=n;j=n}k=+g[t+36>>2];if(k<o){g[t+36>>2]=o;k=o}l=+g[t+40>>2];if(l<p){g[t+40>>2]=p;l=p}m=+g[t+12>>2];if(+g[t+44>>2]<m)g[t+44>>2]=m}d=c[b+68>>2]|0;if((c[q+204>>2]&1|0)==0?(j=j-e,f=k-f,e=l-h,!(j*j+f*f+e*e<999999995904.0)):0){if((c[q+216>>2]&-2|0)!=4)c[q+216>>2]=5;if((a[8072]|0)!=0?(s=c[b+72>>2]|0,(s|0)!=0):0){a[8072]=0;Lb[c[(c[s>>2]|0)+36>>2]&127](s,8080);d=c[b+72>>2]|0;Lb[c[(c[d>>2]|0)+36>>2]&127](d,8136);d=c[b+72>>2]|0;Lb[c[(c[d>>2]|0)+36>>2]&127](d,8208);d=c[b+72>>2]|0;Lb[c[(c[d>>2]|0)+36>>2]&127](d,8280)}}else Hb[c[(c[d>>2]|0)+16>>2]&31](d,c[q+188>>2]|0,t+48|0,t+32|0,c[b+24>>2]|0);d=c[b+8>>2]|0}r=r+1|0}while((r|0)<(d|0))}d=c[5104]|0;q=(c[d+16>>2]|0)+-1|0;c[d+16>>2]=q;if(q){i=t;return}do if(c[d+4>>2]|0){Cb(t+48|0,0)|0;q=c[5090]|0;g[d+8>>2]=+(((c[t+52>>2]|0)-(c[q+4>>2]|0)+(((c[t+48>>2]|0)-(c[q>>2]|0)|0)*1e6|0)-(c[d+12>>2]|0)|0)>>>0)/1.0e3+ +g[d+8>>2];if(!(c[d+16>>2]|0)){d=c[5104]|0;break}else{i=t;return}}while(0);c[5104]=c[d+20>>2];i=t;return}function Uu(a){a=a|0;var b=0,d=0;b=i;i=i+16|0;aE(8312);d=c[a+68>>2]|0;Lb[c[(c[d>>2]|0)+32>>2]&127](d,c[a+24>>2]|0);a=c[5104]|0;d=(c[a+16>>2]|0)+-1|0;c[a+16>>2]=d;if(d){i=b;return}do if(c[a+4>>2]|0){Cb(b|0,0)|0;d=c[5090]|0;g[a+8>>2]=+(((c[b+4>>2]|0)-(c[d+4>>2]|0)+(((c[b>>2]|0)-(c[d>>2]|0)|0)*1e6|0)-(c[a+12>>2]|0)|0)>>>0)/1.0e3+ +g[a+8>>2];if(!(c[a+16>>2]|0)){a=c[5104]|0;break}else{i=b;return}}while(0);c[5104]=c[a+20>>2];i=b;return}function Vu(a){a=a|0;var b=0,d=0,e=0,f=0;d=i;i=i+16|0;aE(8344);Jb[c[(c[a>>2]|0)+8>>2]&255](a);Jb[c[(c[a>>2]|0)+12>>2]&255](a);b=c[a+24>>2]|0;aE(8384);if(b){f=c[(c[b>>2]|0)+32>>2]|0;e=c[a+68>>2]|0;e=Nb[c[(c[e>>2]|0)+36>>2]&127](e)|0;tc[f&127](b,e,a+28|0,c[a+24>>2]|0)}a=c[5104]|0;b=(c[a+16>>2]|0)+-1|0;c[a+16>>2]=b;do if(!b){if(c[a+4>>2]|0){Cb(d|0,0)|0;b=c[5090]|0;g[a+8>>2]=+(((c[d+4>>2]|0)-(c[b+4>>2]|0)+(((c[d>>2]|0)-(c[b>>2]|0)|0)*1e6|0)-(c[a+12>>2]|0)|0)>>>0)/1.0e3+ +g[a+8>>2];b=c[5104]|0;if(c[a+16>>2]|0)break}else b=a;b=c[b+20>>2]|0;c[5104]=b}else b=a;while(0);a=b+16|0;e=(c[a>>2]|0)+-1|0;c[a>>2]=e;if(e){i=d;return}do if(c[b+4>>2]|0){Cb(d|0,0)|0;f=c[5090]|0;e=b+8|0;g[e>>2]=+(((c[d+4>>2]|0)-(c[f+4>>2]|0)+(((c[d>>2]|0)-(c[f>>2]|0)|0)*1e6|0)-(c[b+12>>2]|0)|0)>>>0)/1.0e3+ +g[e>>2];if(!(c[a>>2]|0)){b=c[5104]|0;break}else{i=d;return}}while(0);c[5104]=c[b+20>>2];i=d;return}function Wu(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0;k=i;d=c[b+188>>2]|0;if(d){e=c[a+68>>2]|0;e=Nb[c[(c[e>>2]|0)+36>>2]&127](e)|0;pc[c[(c[e>>2]|0)+40>>2]&127](e,d,c[a+24>>2]|0);e=c[a+68>>2]|0;pc[c[(c[e>>2]|0)+12>>2]&127](e,d,c[a+24>>2]|0);c[b+188>>2]=0}d=c[a+8>>2]|0;if((d|0)<=0){i=k;return}e=c[a+16>>2]|0;g=0;while(1){f=e+(g<<2)|0;h=g+1|0;if((c[f>>2]|0)==(b|0))break;if((h|0)<(d|0))g=h;else{j=9;break}}if((j|0)==9){i=k;return}if((g|0)>=(d|0)){i=k;return}c[f>>2]=c[e+(d+-1<<2)>>2];c[(c[a+16>>2]|0)+(d+-1<<2)>>2]=b;c[a+8>>2]=d+-1;i=k;return}
function pC(d,f,h){d=d|0;f=f|0;h=h|0;var j=0,k=0,l=0.0,m=0.0,n=0.0,o=0,p=0,q=0,r=0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0,y=0,z=0.0,A=0,B=0,C=0.0,D=0.0,E=0.0,F=0,G=0,H=0,I=0,J=0,K=0,L=0.0,M=0.0,N=0.0;K=i;i=i+128|0;H=c[d+56>>2]|0;if((h-f|0)==1){if(!(a[d+60>>0]|0)){p=(c[d+96>>2]|0)+(H<<6)+0|0;q=(c[d+76>>2]|0)+(f<<6)+0|0;r=p+64|0;do{c[p>>2]=c[q>>2];p=p+4|0;q=q+4|0}while((p|0)<(r|0))}else{y=(c[d+136>>2]|0)+(H<<4)|0;x=(c[d+116>>2]|0)+(f<<4)|0;c[y+0>>2]=c[x+0>>2];c[y+4>>2]=c[x+4>>2];c[y+8>>2]=c[x+8>>2];c[y+12>>2]=c[x+12>>2]}c[d+56>>2]=(c[d+56>>2]|0)+1;i=K;return}if((h|0)>(f|0)){y=(a[d+60>>0]|0)==0;s=0.0;w=0.0;r=f;z=0.0;do{if(y){x=c[d+76>>2]|0;n=+g[x+(r<<6)>>2];m=+g[x+(r<<6)+4>>2];l=+g[x+(r<<6)+8>>2];u=+g[x+(r<<6)+16>>2];t=+g[x+(r<<6)+20>>2];v=+g[x+(r<<6)+24>>2]}else{x=c[d+116>>2]|0;E=+g[d+36>>2];D=+g[d+40>>2];C=+g[d+44>>2];u=+g[d+4>>2];t=+g[d+8>>2];v=+g[d+12>>2];n=+(e[x+(r<<4)>>1]|0)/E+u;m=+(e[x+(r<<4)+2>>1]|0)/D+t;l=+(e[x+(r<<4)+4>>1]|0)/C+v;u=+(e[x+(r<<4)+6>>1]|0)/E+u;t=+(e[x+(r<<4)+8>>1]|0)/D+t;v=+(e[x+(r<<4)+10>>1]|0)/C+v}s=s+(u+n)*.5;w=w+(t+m)*.5;z=z+(v+l)*.5;r=r+1|0}while((r|0)!=(h|0));C=1.0/+(h-f|0);E=s*C;D=w*C;C=z*C;if(y){r=c[d+76>>2]|0;q=f;l=0.0;n=0.0;m=0.0;do{u=(+g[r+(q<<6)+16>>2]+ +g[r+(q<<6)>>2])*.5-E;v=(+g[r+(q<<6)+20>>2]+ +g[r+(q<<6)+4>>2])*.5-D;z=(+g[r+(q<<6)+24>>2]+ +g[r+(q<<6)+8>>2])*.5-C;n=n+u*u;m=m+v*v;l=l+z*z;q=q+1|0}while((q|0)!=(h|0));s=+(h-f|0)}else{y=c[d+116>>2]|0;z=+g[d+36>>2];v=+g[d+40>>2];u=+g[d+44>>2];t=+g[d+4>>2];s=+g[d+8>>2];w=+g[d+12>>2];x=f;l=0.0;n=0.0;m=0.0;do{N=(+(e[y+(x<<4)+6>>1]|0)/z+t+(+(e[y+(x<<4)>>1]|0)/z+t))*.5-E;M=(+(e[y+(x<<4)+8>>1]|0)/v+s+(+(e[y+(x<<4)+2>>1]|0)/v+s))*.5-D;L=(+(e[y+(x<<4)+10>>1]|0)/u+w+(+(e[y+(x<<4)+4>>1]|0)/u+w))*.5-C;n=n+N*N;m=m+M*M;l=l+L*L;x=x+1|0}while((x|0)!=(h|0));s=+(h-f|0)}}else{s=+(h-f|0);l=0.0;n=0.0;m=0.0}C=1.0/(s+-1.0);n=n*C;m=m*C;l=l*C;if(n<m)r=m<l?2:1;else r=n<l?2:0;c[K+16>>2]=0;c[K+20>>2]=0;c[K+24>>2]=0;c[K+28>>2]=0;if((h|0)>(f|0)){x=(a[d+60>>0]|0)==0;n=0.0;m=0.0;l=0.0;y=f;do{if(x){B=c[d+76>>2]|0;v=+g[B+(y<<6)+16>>2];u=+g[B+(y<<6)+20>>2];t=+g[B+(y<<6)+24>>2];s=+g[B+(y<<6)>>2];w=+g[B+(y<<6)+4>>2];z=+g[B+(y<<6)+8>>2]}else{B=c[d+116>>2]|0;M=+g[d+36>>2];N=+g[d+40>>2];C=+g[d+44>>2];s=+g[d+4>>2];w=+g[d+8>>2];z=+g[d+12>>2];v=+(e[B+(y<<4)+6>>1]|0)/M+s;u=+(e[B+(y<<4)+8>>1]|0)/N+w;t=+(e[B+(y<<4)+10>>1]|0)/C+z;s=+(e[B+(y<<4)>>1]|0)/M+s;w=+(e[B+(y<<4)+2>>1]|0)/N+w;z=+(e[B+(y<<4)+4>>1]|0)/C+z}n=n+(v+s)*.5;m=(u+w)*.5+m;l=(t+z)*.5+l;y=y+1|0}while((y|0)!=(h|0));g[K+16>>2]=n;g[K+20>>2]=m;g[K+24>>2]=l}else{n=0.0;m=0.0;l=0.0}g[K+16>>2]=1.0/+(h-f|0)*n;g[K+20>>2]=1.0/+(h-f|0)*m;g[K+24>>2]=1.0/+(h-f|0)*l;z=+g[K+16+(r<<2)>>2];if((h|0)>(f|0)){y=K+(r<<2)|0;x=f;j=f;do{r=(a[d+60>>0]|0)==0;if(r){B=c[d+76>>2]|0;s=+g[B+(x<<6)+16>>2];n=+g[B+(x<<6)+20>>2];m=+g[B+(x<<6)+24>>2];l=+g[B+(x<<6)>>2];t=+g[B+(x<<6)+4>>2];u=+g[B+(x<<6)+8>>2]}else{B=c[d+116>>2]|0;N=+g[d+36>>2];v=+g[d+40>>2];C=+g[d+44>>2];l=+g[d+4>>2];t=+g[d+8>>2];u=+g[d+12>>2];s=+(e[B+(x<<4)+6>>1]|0)/N+l;n=+(e[B+(x<<4)+8>>1]|0)/v+t;m=+(e[B+(x<<4)+10>>1]|0)/C+u;l=+(e[B+(x<<4)>>1]|0)/N+l;t=+(e[B+(x<<4)+2>>1]|0)/v+t;u=+(e[B+(x<<4)+4>>1]|0)/C+u}g[K>>2]=(s+l)*.5;g[K+4>>2]=(n+t)*.5;g[K+8>>2]=(m+u)*.5;g[K+12>>2]=0.0;if(+g[y>>2]>z){if(r){o=c[d+76>>2]|0;k=o+(x<<6)|0;p=K+32|0;q=k+0|0;r=p+64|0;do{c[p>>2]=c[q>>2];p=p+4|0;q=q+4|0}while((p|0)<(r|0));p=k+0|0;q=o+(j<<6)+0|0;r=p+64|0;do{c[p>>2]=c[q>>2];p=p+4|0;q=q+4|0}while((p|0)<(r|0));p=(c[d+76>>2]|0)+(j<<6)+0|0;q=K+32|0;r=p+64|0;do{c[p>>2]=c[q>>2];p=p+4|0;q=q+4|0}while((p|0)<(r|0))}else{B=c[d+116>>2]|0;r=B+(x<<4)|0;c[K+96>>2]=c[r+0>>2];c[K+100>>2]=c[r+4>>2];c[K+104>>2]=c[r+8>>2];c[K+108>>2]=c[r+12>>2];B=B+(j<<4)|0;c[r+0>>2]=c[B+0>>2];c[r+4>>2]=c[B+4>>2];c[r+8>>2]=c[B+8>>2];c[r+12>>2]=c[B+12>>2];r=(c[d+116>>2]|0)+(j<<4)|0;c[r+0>>2]=c[K+96>>2];c[r+4>>2]=c[K+100>>2];c[r+8>>2]=c[K+104>>2];c[r+12>>2]=c[K+108>>2]}j=j+1|0}x=x+1|0}while((x|0)!=(h|0))}else j=f;if(!((j|0)>(((h-f|0)/3|0)+f|0)?(j|0)<(h+-1-((h-f|0)/3|0)|0):0))j=(h-f>>1)+f|0;G=c[d+56>>2]|0;if(!(a[d+60>>0]|0)){y=(c[d+96>>2]|0)+(G<<6)|0;c[y+0>>2]=c[d+20>>2];c[y+4>>2]=c[d+24>>2];c[y+8>>2]=c[d+28>>2];c[y+12>>2]=c[d+32>>2]}else{y=c[d+136>>2]|0;z=(+g[d+24>>2]-+g[d+8>>2])*+g[d+40>>2];C=(+g[d+28>>2]-+g[d+12>>2])*+g[d+44>>2];b[y+(G<<4)>>1]=~~((+g[d+20>>2]-+g[d+4>>2])*+g[d+36>>2])&65534;b[y+(G<<4)+2>>1]=~~z&65534;b[y+(G<<4)+4>>1]=~~C&65534}k=c[d+56>>2]|0;if(!(a[d+60>>0]|0)){y=(c[d+96>>2]|0)+(k<<6)+16|0;c[y+0>>2]=c[d+4>>2];c[y+4>>2]=c[d+8>>2];c[y+8>>2]=c[d+12>>2];c[y+12>>2]=c[d+16>>2]}else{y=c[d+136>>2]|0;v=+g[d+4>>2];z=+g[d+8>>2];C=+g[d+12>>2];z=(z-z)*+g[d+40>>2];C=(C-C)*+g[d+44>>2];b[y+(k<<4)+6>>1]=~~((v-v)*+g[d+36>>2]+1.0)&65535|1;b[y+(k<<4)+8>>1]=~~(z+1.0)&65535|1;b[y+(k<<4)+10>>1]=~~(C+1.0)&65535|1}F=c[d+56>>2]|0;if((h|0)>(f|0)){A=a[d+60>>0]|0;B=f;do{do if(A<<24>>24){p=c[d+116>>2]|0;l=+g[d+36>>2];M=+g[d+40>>2];u=+g[d+44>>2];w=+g[d+4>>2];s=+g[d+8>>2];v=+g[d+12>>2];m=+g[d+4>>2];N=+g[d+8>>2];z=+g[d+12>>2];n=+g[d+36>>2];t=+g[d+40>>2];C=+g[d+44>>2];o=~~((+(e[p+(B<<4)>>1]|0)/l+w-m)*n)&65534;k=~~((+(e[p+(B<<4)+2>>1]|0)/M+s-N)*t)&65534;q=~~((+(e[p+(B<<4)+4>>1]|0)/u+v-z)*C)&65534;x=(~~((+(e[p+(B<<4)+6>>1]|0)/l+w-m)*n+1.0)&65535|1)&65535;y=(~~((+(e[p+(B<<4)+8>>1]|0)/M+s-N)*t+1.0)&65535|1)&65535;p=(~~((+(e[p+(B<<4)+10>>1]|0)/u+v-z)*C+1.0)&65535|1)&65535;r=c[d+136>>2]|0;if((e[r+(F<<4)>>1]|0)>(o&65535))b[r+(F<<4)>>1]=o;if((e[r+(F<<4)+6>>1]|0)<(x&65535))b[r+(F<<4)+6>>1]=x;if((e[r+(F<<4)+2>>1]|0)>(k&65535))b[r+(F<<4)+2>>1]=k;if((e[r+(F<<4)+8>>1]|0)<(y&65535))b[r+(F<<4)+8>>1]=y;if((e[r+(F<<4)+4>>1]|0)>(q&65535))b[r+(F<<4)+4>>1]=q;if((e[r+(F<<4)+10>>1]|0)<(p&65535))b[r+(F<<4)+10>>1]=p}else{y=c[d+76>>2]|0;z=+g[y+(B<<6)>>2];u=+g[y+(B<<6)+4>>2];t=+g[y+(B<<6)+8>>2];v=+g[y+(B<<6)+12>>2];s=+g[y+(B<<6)+16>>2];m=+g[y+(B<<6)+20>>2];w=+g[y+(B<<6)+24>>2];n=+g[y+(B<<6)+28>>2];y=c[d+96>>2]|0;if(z<+g[y+(F<<6)>>2])g[y+(F<<6)>>2]=z;if(u<+g[y+(F<<6)+4>>2])g[y+(F<<6)+4>>2]=u;if(t<+g[y+(F<<6)+8>>2])g[y+(F<<6)+8>>2]=t;if(v<+g[y+(F<<6)+12>>2])g[y+(F<<6)+12>>2]=v;if(+g[y+(F<<6)+16>>2]<s)g[y+(F<<6)+16>>2]=s;if(+g[y+(F<<6)+20>>2]<m)g[y+(F<<6)+20>>2]=m;if(+g[y+(F<<6)+24>>2]<w)g[y+(F<<6)+24>>2]=w;if(!(+g[y+(F<<6)+28>>2]<n))break;g[y+(F<<6)+28>>2]=n}while(0);B=B+1|0}while((B|0)!=(h|0))}c[d+56>>2]=F+1;pC(d,f,j);A=c[d+56>>2]|0;pC(d,j,h);B=(c[d+56>>2]|0)-H|0;j=a[d+60>>0]|0;if(j<<24>>24!=0&(B<<4|0)>2048){y=c[d+136>>2]|0;r=c[y+(F+1<<4)+12>>2]|0;r=(r|0)>-1?1:0-r|0;x=c[y+(A<<4)+12>>2]|0;x=(x|0)>-1?1:0-x|0;if((r<<4|0)<2049){q=c[d+152>>2]|0;if((q|0)==(c[d+156>>2]|0)?(I=(q|0)==0?1:q<<1,(q|0)<(I|0)):0){if(!I){j=q;p=0}else{c[5108]=(c[5108]|0)+1;k=QE(I<<5|19)|0;if(!k)k=0;else{c[(k+19&-16)+-4>>2]=k;k=k+19&-16}j=c[d+152>>2]|0;p=k}if((j|0)>0){o=0;do{k=p+(o<<5)|0;f=(c[d+160>>2]|0)+(o<<5)|0;c[k+0>>2]=c[f+0>>2];c[k+4>>2]=c[f+4>>2];c[k+8>>2]=c[f+8>>2];c[k+12>>2]=c[f+12>>2];c[k+16>>2]=c[f+16>>2];c[k+20>>2]=c[f+20>>2];c[k+24>>2]=c[f+24>>2];c[k+28>>2]=c[f+28>>2];o=o+1|0}while((o|0)!=(j|0))}k=c[d+160>>2]|0;if(k){if(a[d+164>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[k+-4>>2]|0)}c[d+160>>2]=0}a[d+164>>0]=1;c[d+160>>2]=p;c[d+156>>2]=I;k=c[d+152>>2]|0}else k=q;c[d+152>>2]=k+1;p=(c[d+160>>2]|0)+(q<<5)|0;c[p+0>>2]=c[K+96>>2];c[p+4>>2]=c[K+100>>2];c[p+8>>2]=c[K+104>>2];c[p+12>>2]=c[K+108>>2];c[p+16>>2]=c[K+112>>2];c[p+20>>2]=c[K+116>>2];c[p+24>>2]=c[K+120>>2];c[p+28>>2]=c[K+124>>2];p=c[d+160>>2]|0;b[p+(q<<5)>>1]=b[y+(F+1<<4)>>1]|0;b[p+(q<<5)+2>>1]=b[y+(F+1<<4)+2>>1]|0;b[p+(q<<5)+4>>1]=b[y+(F+1<<4)+4>>1]|0;b[p+(q<<5)+6>>1]=b[y+(F+1<<4)+6>>1]|0;b[p+(q<<5)+8>>1]=b[y+(F+1<<4)+8>>1]|0;b[p+(q<<5)+10>>1]=b[y+(F+1<<4)+10>>1]|0;c[p+(q<<5)+12>>2]=F+1;c[p+(q<<5)+16>>2]=r;q=d+152|0}else q=d+152|0;if((x<<4|0)<2049){r=c[q>>2]|0;if((r|0)==(c[d+156>>2]|0)?(J=(r|0)==0?1:r<<1,(r|0)<(J|0)):0){if(!J){j=r;o=0}else{c[5108]=(c[5108]|0)+1;k=QE(J<<5|19)|0;if(!k)k=0;else{c[(k+19&-16)+-4>>2]=k;k=k+19&-16}j=c[q>>2]|0;o=k}if((j|0)>0){k=0;do{p=o+(k<<5)|0;f=(c[d+160>>2]|0)+(k<<5)|0;c[p+0>>2]=c[f+0>>2];c[p+4>>2]=c[f+4>>2];c[p+8>>2]=c[f+8>>2];c[p+12>>2]=c[f+12>>2];c[p+16>>2]=c[f+16>>2];c[p+20>>2]=c[f+20>>2];c[p+24>>2]=c[f+24>>2];c[p+28>>2]=c[f+28>>2];k=k+1|0}while((k|0)!=(j|0))}k=c[d+160>>2]|0;if(k){if(a[d+164>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[k+-4>>2]|0)}c[d+160>>2]=0}a[d+164>>0]=1;c[d+160>>2]=o;c[d+156>>2]=J;j=c[q>>2]|0}else j=r;c[q>>2]=j+1;p=(c[d+160>>2]|0)+(r<<5)|0;c[p+0>>2]=c[K+32>>2];c[p+4>>2]=c[K+36>>2];c[p+8>>2]=c[K+40>>2];c[p+12>>2]=c[K+44>>2];c[p+16>>2]=c[K+48>>2];c[p+20>>2]=c[K+52>>2];c[p+24>>2]=c[K+56>>2];c[p+28>>2]=c[K+60>>2];p=c[d+160>>2]|0;b[p+(r<<5)>>1]=b[y+(A<<4)>>1]|0;b[p+(r<<5)+2>>1]=b[y+(A<<4)+2>>1]|0;b[p+(r<<5)+4>>1]=b[y+(A<<4)+4>>1]|0;b[p+(r<<5)+6>>1]=b[y+(A<<4)+6>>1]|0;b[p+(r<<5)+8>>1]=b[y+(A<<4)+8>>1]|0;b[p+(r<<5)+10>>1]=b[y+(A<<4)+10>>1]|0;c[p+(r<<5)+12>>2]=A;c[p+(r<<5)+16>>2]=x}c[d+168>>2]=c[q>>2];j=a[d+60>>0]|0}if(!(j<<24>>24)){c[(c[d+96>>2]|0)+(G<<6)+32>>2]=B;i=K;return}else{c[(c[d+136>>2]|0)+(G<<4)+12>>2]=0-B;i=K;return}}function qC(b){b=b|0;var d=0,e=0;e=i;c[b>>2]=17328;d=c[b+160>>2]|0;if(d){if(a[b+164>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}c[b+160>>2]=0}a[b+164>>0]=1;c[b+160>>2]=0;c[b+152>>2]=0;c[b+156>>2]=0;d=c[b+136>>2]|0;if(d){if(a[b+140>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}c[b+136>>2]=0}a[b+140>>0]=1;c[b+136>>2]=0;c[b+128>>2]=0;c[b+132>>2]=0;d=c[b+116>>2]|0;if(d){if(a[b+120>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}c[b+116>>2]=0}a[b+120>>0]=1;c[b+116>>2]=0;c[b+108>>2]=0;c[b+112>>2]=0;d=c[b+96>>2]|0;if(d){if(a[b+100>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}c[b+96>>2]=0}a[b+100>>0]=1;c[b+96>>2]=0;c[b+88>>2]=0;c[b+92>>2]=0;d=c[b+76>>2]|0;if(!d){a[b+80>>0]=1;c[b+76>>2]=0;c[b+68>>2]=0;d=b+72|0;c[d>>2]=0;i=e;return}if(a[b+80>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}c[b+76>>2]=0;a[b+80>>0]=1;c[b+76>>2]=0;c[b+68>>2]=0;d=b+72|0;c[d>>2]=0;i=e;return}function rC(a){a=a|0;var b=0;b=i;qC(a);if(!a){i=b;return}c[5110]=(c[5110]|0)+1;RE(c[a+-4>>2]|0);i=b;return}function sC(a,b,d,f){a=a|0;b=b|0;d=d|0;f=f|0;var g=0,h=0,j=0;j=i;while(1){g=c[a+12>>2]|0;if(!(((e[f>>1]|0)>=(e[a>>1]|0)?(e[d>>1]|0)<=(e[a+6>>1]|0):0)&(e[d+4>>1]|0)<=(e[a+10>>1]|0)&(e[f+4>>1]|0)>=(e[a+4>>1]|0)&(e[d+2>>1]|0)<=(e[a+8>>1]|0)&(e[f+2>>1]|0)>=(e[a+2>>1]|0))){h=8;break}if((g|0)>-1)break;sC(a+16|0,b,d,f);g=c[a+28>>2]|0;if((g|0)>-1){a=a+32|0;continue}else{a=a+(1-g<<4)|0;continue}}if((h|0)==8){i=j;return}pc[c[(c[b>>2]|0)+8>>2]&127](b,g>>21,g&2097151);i=j;return}function tC(a,b,d,e,f,h,j,k){a=a|0;b=b|0;d=d|0;e=+e;f=+f;h=+h;j=j|0;k=k|0;var l=0,m=0,n=0,o=0.0,p=0.0,q=0,r=0.0,s=0.0,t=0.0,u=0.0,v=0,w=0,x=0,y=0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0,K=0,L=0,M=0.0,N=0.0,O=0.0,Q=0.0,R=0.0,S=0.0,T=0.0,U=0.0,V=0.0,W=0.0,X=0.0,Y=0;Y=i;i=i+32|0;U=+g[d>>2];W=+g[d+4>>2];V=+g[d+8>>2];s=+g[j>>2];B=(U>e?e:U)+s;t=+g[j+4>>2];F=(W>f?f:W)+t;u=+g[j+8>>2];D=(V>h?h:V)+u;o=+g[k>>2];A=(U<e?e:U)+o;p=+g[k+4>>2];E=(W<f?f:W)+p;r=+g[k+8>>2];C=(V<h?h:V)+r;M=1.0/+P(+((e-U)*(e-U)+(f-W)*(f-W)+(h-V)*(h-V)));if((e-U)*M==0.0)G=999999984306749440.0;else G=1.0/((e-U)*M);if((f-W)*M==0.0)H=999999984306749440.0;else H=1.0/((f-W)*M);if((h-V)*M==0.0)I=999999984306749440.0;else I=1.0/((h-V)*M);J=G<0.0&1;K=H<0.0&1;L=I<0.0&1;m=c[a+56>>2]|0;a:do if((m|0)>0){x=0;y=c[a+96>>2]|0;l=1;while(1){c[Y+0>>2]=c[y+0>>2];c[Y+4>>2]=c[y+4>>2];c[Y+8>>2]=c[y+8>>2];c[Y+12>>2]=c[y+12>>2];v=y+16|0;c[Y+16>>2]=c[v+0>>2];c[Y+20>>2]=c[v+4>>2];c[Y+24>>2]=c[v+8>>2];c[Y+28>>2]=c[v+12>>2];g[Y>>2]=+g[Y>>2]-o;g[Y+4>>2]=+g[Y+4>>2]-p;g[Y+8>>2]=+g[Y+8>>2]-r;g[Y+16>>2]=+g[Y+16>>2]-s;g[Y+20>>2]=+g[Y+20>>2]-t;g[Y+24>>2]=+g[Y+24>>2]-u;if(!(B>+g[v>>2])?!(A<+g[y>>2]):0)n=1;else n=0;if(!(!(D>+g[y+24>>2])?!(C<+g[y+8>>2]):0))n=0;if((((!(F>+g[y+20>>2])?!(E<+g[y+4>>2]|n^1):0)?(O=+g[d>>2],N=G*(+g[Y+(J<<4)>>2]-O),O=G*(+g[Y+((J^1)<<4)>>2]-O),R=+g[d+4>>2],Q=H*(+g[Y+(K<<4)+4>>2]-R),R=H*(+g[Y+((K^1)<<4)+4>>2]-R),!(N>R|Q>O)):0)?(z=Q>N?Q:N,X=R<O?R:O,T=+g[d+8>>2],S=I*(+g[Y+(L<<4)+8>>2]-T),T=I*(+g[Y+((L^1)<<4)+8>>2]-T),!(z>T|S>X)):0)?(S>z?S:z)<(h-V)*((h-V)*M)+((e-U)*((e-U)*M)+(f-W)*((f-W)*M)):0){q=(T<X?T:X)>0.0;n=c[y+32>>2]|0;if((n|0)==-1&q){pc[c[(c[b>>2]|0)+8>>2]&127](b,c[y+36>>2]|0,c[y+40>>2]|0);m=c[a+56>>2]|0;w=24}else{v=n;n=(n|0)==-1;w=23}}else{n=c[y+32>>2]|0;v=n;n=(n|0)==-1;q=0;w=23}if((w|0)==23){w=0;if(q|n)w=24;else{q=v+x|0;v=y+(v<<6)|0}}if((w|0)==24){q=x+1|0;v=y+64|0}if((q|0)>=(m|0))break a;o=+g[k>>2];p=+g[k+4>>2];r=+g[k+8>>2];s=+g[j>>2];t=+g[j+4>>2];u=+g[j+8>>2];x=q;y=v;l=l+1|0}}else l=0;while(0);if((c[4340]|0)>=(l|0)){i=Y;return}c[4340]=l;i=Y;return}function uC(a,d,f,h,j,k,l,m,n){a=a|0;d=d|0;f=f|0;h=+h;j=+j;k=+k;l=l|0;m=m|0;n=n|0;var o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,Q=0.0,R=0.0,S=0.0,T=0.0,U=0.0,V=0.0,W=0.0,X=0.0,Y=0,Z=0.0,_=0.0,$=0.0,aa=0.0,ba=0.0,ca=0.0,da=0.0,ea=0.0,fa=0.0,ga=0.0,ha=0.0,ia=0.0,ja=0.0,ka=0.0,la=0.0;Y=i;i=i+32|0;z=+g[f>>2];A=+g[f+4>>2];B=+g[f+8>>2];Q=1.0/+P(+((h-z)*(h-z)+(j-A)*(j-A)+(k-B)*(k-B)));if((h-z)*Q==0.0)D=999999984306749440.0;else D=1.0/((h-z)*Q);if((j-A)*Q==0.0)E=999999984306749440.0;else E=1.0/((j-A)*Q);if((k-B)*Q==0.0)F=999999984306749440.0;else F=1.0/((k-B)*Q);L=D<0.0&1;M=E<0.0&1;N=F<0.0&1;la=(z>h?h:z)+ +g[l>>2];ka=(A>j?j:A)+ +g[l+4>>2];ja=(B>k?k:B)+ +g[l+8>>2];ha=(z<h?h:z)+ +g[m>>2];da=(A<j?j:A)+ +g[m+4>>2];$=(B<k?k:B)+ +g[m+8>>2];ga=+g[a+4>>2];la=la<ga?ga:la;ca=+g[a+8>>2];ka=ka<ca?ca:ka;_=+g[a+12>>2];ja=ja<_?_:ja;ia=+g[a+20>>2];ea=+g[a+24>>2];aa=+g[a+28>>2];fa=+g[a+36>>2];ba=+g[a+40>>2];Z=+g[a+44>>2];I=~~(((ia<la?ia:la)-ga)*fa)&65534;J=~~(((ea<ka?ea:ka)-ca)*ba)&65534;H=~~(((aa<ja?aa:ja)-_)*Z)&65534;ha=ha<ga?ga:ha;da=da<ca?ca:da;$=$<_?_:$;K=(~~(((ia<ha?ia:ha)-ga)*fa+1.0)&65535|1)&65535;O=(~~(((ea<da?ea:da)-ca)*ba+1.0)&65535|1)&65535;G=(~~(((aa<$?aa:$)-_)*Z+1.0)&65535|1)&65535;if((n|0)>0){p=0;q=c[a+136>>2]|0;o=0;do{o=o+1|0;u=q+6|0;s=b[q>>1]|0;v=q+10|0;r=b[q+4>>1]|0;w=q+8|0;t=b[q+2>>1]|0;y=q+12|0;x=(c[y>>2]|0)>-1;if(((((K&65535)>=(s&65535)?(I&65535)<=(e[u>>1]|0):0)&(H&65535)<=(e[v>>1]|0)&(G&65535)>=(r&65535)&(J&65535)<=(e[w>>1]|0)&(O&65535)>=(t&65535)?(ka=+g[a+36>>2],_=+g[a+40>>2],aa=+g[a+44>>2],Z=+g[a+4>>2],$=+g[a+8>>2],T=+g[a+12>>2],g[Y+12>>2]=0.0,U=+(e[u>>1]|0)/ka+Z,R=+(e[w>>1]|0)/_+$,S=+(e[v>>1]|0)/aa+T,g[Y+28>>2]=0.0,g[Y>>2]=+(s&65535)/ka+Z-+g[m>>2],g[Y+4>>2]=+(t&65535)/_+$-+g[m+4>>2],g[Y+8>>2]=+(r&65535)/aa+T-+g[m+8>>2],g[Y+16>>2]=U-+g[l>>2],g[Y+20>>2]=R-+g[l+4>>2],g[Y+24>>2]=S-+g[l+8>>2],S=+g[f>>2],R=D*(+g[Y+(L<<4)>>2]-S),S=D*(+g[Y+((L^1)<<4)>>2]-S),U=+g[f+4>>2],T=E*(+g[Y+(M<<4)+4>>2]-U),U=E*(+g[Y+((M^1)<<4)+4>>2]-U),!(R>U|T>S)):0)?(C=T>R?T:R,X=U<S?U:S,W=+g[f+8>>2],V=F*(+g[Y+(N<<4)+8>>2]-W),W=F*(+g[Y+((N^1)<<4)+8>>2]-W),!(C>W|V>X)):0)?(V>C?V:C)<(k-B)*((k-B)*Q)+((h-z)*((h-z)*Q)+(j-A)*((j-A)*Q)):0){r=(W<X?W:X)>0.0;if(x&r){s=c[y>>2]|0;pc[c[(c[d>>2]|0)+8>>2]&127](d,s>>21,s&2097151);s=16}else s=15}else{r=0;s=15}if((s|0)==15){s=0;if(r|x)s=16;else{y=c[y>>2]|0;p=p-y|0;q=q+(0-y<<4)|0}}if((s|0)==16){p=p+1|0;q=q+16|0}}while((p|0)<(n|0))}else o=0;if((c[4340]|0)>=(o|0)){i=Y;return}c[4340]=o;i=Y;return}function vC(d,f,h,j){d=d|0;f=f|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;o=i;c[d+168>>2]=c[d+152>>2];c[f>>2]=17328;c[f+52>>2]=282;a[f+60>>0]=0;a[f+80>>0]=1;c[f+76>>2]=0;c[f+68>>2]=0;c[f+72>>2]=0;a[f+100>>0]=1;c[f+96>>2]=0;c[f+88>>2]=0;c[f+92>>2]=0;a[f+120>>0]=1;c[f+116>>2]=0;c[f+108>>2]=0;c[f+112>>2]=0;a[f+140>>0]=1;c[f+136>>2]=0;c[f+128>>2]=0;c[f+132>>2]=0;c[f+144>>2]=0;a[f+164>>0]=1;c[f+160>>2]=0;c[f+152>>2]=0;c[f+156>>2]=0;c[f+168>>2]=0;g[f+4>>2]=-3402823466385288598117041.0e14;g[f+8>>2]=-3402823466385288598117041.0e14;g[f+12>>2]=-3402823466385288598117041.0e14;g[f+16>>2]=0.0;g[f+20>>2]=3402823466385288598117041.0e14;g[f+24>>2]=3402823466385288598117041.0e14;g[f+28>>2]=3402823466385288598117041.0e14;g[f+32>>2]=0.0;k=c[d+56>>2]|0;if(j){c[f+56>>2]=_E(k|0)|0;a[f+4>>0]=a[d+7>>0]|0;a[f+5>>0]=a[d+6>>0]|0;a[f+6>>0]=a[d+5>>0]|0;a[f+7>>0]=a[d+4>>0]|0;a[f+8>>0]=a[d+11>>0]|0;a[f+9>>0]=a[d+10>>0]|0;a[f+10>>0]=a[d+9>>0]|0;a[f+11>>0]=a[d+8>>0]|0;a[f+12>>0]=a[d+15>>0]|0;a[f+13>>0]=a[d+14>>0]|0;a[f+14>>0]=a[d+13>>0]|0;a[f+15>>0]=a[d+12>>0]|0;a[f+16>>0]=a[d+19>>0]|0;a[f+17>>0]=a[d+18>>0]|0;a[f+18>>0]=a[d+17>>0]|0;a[f+19>>0]=a[d+16>>0]|0;a[f+20>>0]=a[d+23>>0]|0;a[f+21>>0]=a[d+22>>0]|0;a[f+22>>0]=a[d+21>>0]|0;a[f+23>>0]=a[d+20>>0]|0;a[f+24>>0]=a[d+27>>0]|0;a[f+25>>0]=a[d+26>>0]|0;a[f+26>>0]=a[d+25>>0]|0;a[f+27>>0]=a[d+24>>0]|0;a[f+28>>0]=a[d+31>>0]|0;a[f+29>>0]=a[d+30>>0]|0;a[f+30>>0]=a[d+29>>0]|0;a[f+31>>0]=a[d+28>>0]|0;a[f+32>>0]=a[d+35>>0]|0;a[f+33>>0]=a[d+34>>0]|0;a[f+34>>0]=a[d+33>>0]|0;a[f+35>>0]=a[d+32>>0]|0;a[f+36>>0]=a[d+39>>0]|0;a[f+37>>0]=a[d+38>>0]|0;a[f+38>>0]=a[d+37>>0]|0;a[f+39>>0]=a[d+36>>0]|0;a[f+40>>0]=a[d+43>>0]|0;a[f+41>>0]=a[d+42>>0]|0;a[f+42>>0]=a[d+41>>0]|0;a[f+43>>0]=a[d+40>>0]|0;a[f+44>>0]=a[d+47>>0]|0;a[f+45>>0]=a[d+46>>0]|0;a[f+46>>0]=a[d+45>>0]|0;a[f+47>>0]=a[d+44>>0]|0;a[f+48>>0]=a[d+51>>0]|0;a[f+49>>0]=a[d+50>>0]|0;a[f+50>>0]=a[d+49>>0]|0;a[f+51>>0]=a[d+48>>0]|0;c[f+144>>2]=_E(c[d+144>>2]|0)|0;l=_E(c[d+168>>2]|0)|0}else{c[f+56>>2]=k;c[f+4>>2]=c[d+4>>2];c[f+8>>2]=c[d+8>>2];c[f+12>>2]=c[d+12>>2];c[f+16>>2]=c[d+16>>2];c[f+20>>2]=c[d+20>>2];c[f+24>>2]=c[d+24>>2];c[f+28>>2]=c[d+28>>2];c[f+32>>2]=c[d+32>>2];c[f+36>>2]=c[d+36>>2];c[f+40>>2]=c[d+40>>2];c[f+44>>2]=c[d+44>>2];c[f+48>>2]=c[d+48>>2];c[f+144>>2]=c[d+144>>2];l=c[d+168>>2]|0}c[f+168>>2]=l;a[f+60>>0]=a[d+60>>0]|0;h=c[d+56>>2]|0;if(!(a[d+60>>0]|0)){l=c[f+96>>2]|0;if(l){if(a[f+100>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[l+-4>>2]|0)}c[f+96>>2]=0};c[f+88>>2]=0;c[f+92>>2]=0;c[f+96>>2]=0;a[f+100>>0]=0;c[f+96>>2]=f+172;c[f+88>>2]=h;c[f+92>>2]=h;if(j)if((h|0)>0){m=c[d+96>>2]|0;l=f+172|0;k=0;do{p=m+(k<<6)|0;r=l+(k<<6)|0;a[r>>0]=a[p+3>>0]|0;a[r+1>>0]=a[p+2>>0]|0;a[r+2>>0]=a[p+1>>0]|0;a[r+3>>0]=a[p>>0]|0;r=m+(k<<6)+4|0;p=l+(k<<6)+4|0;a[p>>0]=a[r+3>>0]|0;a[p+1>>0]=a[r+2>>0]|0;a[p+2>>0]=a[r+1>>0]|0;a[p+3>>0]=a[r>>0]|0;p=m+(k<<6)+8|0;r=l+(k<<6)+8|0;a[r>>0]=a[p+3>>0]|0;a[r+1>>0]=a[p+2>>0]|0;a[r+2>>0]=a[p+1>>0]|0;a[r+3>>0]=a[p>>0]|0;r=m+(k<<6)+12|0;l=l+(k<<6)+12|0;a[l>>0]=a[r+3>>0]|0;a[l+1>>0]=a[r+2>>0]|0;a[l+2>>0]=a[r+1>>0]|0;a[l+3>>0]=a[r>>0]|0;l=c[d+96>>2]|0;r=l+(k<<6)+16|0;p=c[f+96>>2]|0;q=p+(k<<6)+16|0;a[q>>0]=a[r+3>>0]|0;a[q+1>>0]=a[r+2>>0]|0;a[q+2>>0]=a[r+1>>0]|0;a[q+3>>0]=a[r>>0]|0;q=l+(k<<6)+20|0;r=p+(k<<6)+20|0;a[r>>0]=a[q+3>>0]|0;a[r+1>>0]=a[q+2>>0]|0;a[r+2>>0]=a[q+1>>0]|0;a[r+3>>0]=a[q>>0]|0;r=l+(k<<6)+24|0;q=p+(k<<6)+24|0;a[q>>0]=a[r+3>>0]|0;a[q+1>>0]=a[r+2>>0]|0;a[q+2>>0]=a[r+1>>0]|0;a[q+3>>0]=a[r>>0]|0;l=l+(k<<6)+28|0;p=p+(k<<6)+28|0;a[p>>0]=a[l+3>>0]|0;a[p+1>>0]=a[l+2>>0]|0;a[p+2>>0]=a[l+1>>0]|0;a[p+3>>0]=a[l>>0]|0;m=c[d+96>>2]|0;p=_E(c[m+(k<<6)+32>>2]|0)|0;l=c[f+96>>2]|0;c[l+(k<<6)+32>>2]=p;c[l+(k<<6)+36>>2]=_E(c[m+(k<<6)+36>>2]|0)|0;c[l+(k<<6)+40>>2]=_E(c[m+(k<<6)+40>>2]|0)|0;k=k+1|0}while((k|0)!=(h|0))}else l=f+172|0;else if((h|0)>0){l=f+172|0;m=c[d+96>>2]|0;k=0;do{l=l+(k<<6)|0;p=m+(k<<6)|0;c[l+0>>2]=c[p+0>>2];c[l+4>>2]=c[p+4>>2];c[l+8>>2]=c[p+8>>2];c[l+12>>2]=c[p+12>>2];l=(c[f+96>>2]|0)+(k<<6)+16|0;p=(c[d+96>>2]|0)+(k<<6)+16|0;c[l+0>>2]=c[p+0>>2];c[l+4>>2]=c[p+4>>2];c[l+8>>2]=c[p+8>>2];c[l+12>>2]=c[p+12>>2];m=c[d+96>>2]|0;l=c[f+96>>2]|0;c[l+(k<<6)+32>>2]=c[m+(k<<6)+32>>2];c[l+(k<<6)+36>>2]=c[m+(k<<6)+36>>2];c[l+(k<<6)+40>>2]=c[m+(k<<6)+40>>2];k=k+1|0}while((k|0)!=(h|0))}else l=f+172|0;if(l){if(a[f+100>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[l+-4>>2]|0)}c[f+96>>2]=0};c[f+88>>2]=0;c[f+92>>2]=0;c[f+96>>2]=0;a[f+100>>0]=0;k=h<<6}else{k=c[f+136>>2]|0;if(k){if(a[f+140>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[k+-4>>2]|0)}c[f+136>>2]=0};c[f+128>>2]=0;c[f+132>>2]=0;c[f+136>>2]=0;a[f+140>>0]=0;c[f+136>>2]=f+172;c[f+128>>2]=h;c[f+132>>2]=h;if(j)if((h|0)>0){l=c[d+136>>2]|0;k=0;do{p=e[l+(k<<4)>>1]|0;b[f+172+(k<<4)>>1]=p>>>8|p<<8;p=e[l+(k<<4)+2>>1]|0;b[f+172+(k<<4)+2>>1]=p>>>8|p<<8;p=e[l+(k<<4)+4>>1]|0;b[f+172+(k<<4)+4>>1]=p>>>8|p<<8;p=e[l+(k<<4)+6>>1]|0;b[f+172+(k<<4)+6>>1]=p>>>8|p<<8;p=e[l+(k<<4)+8>>1]|0;b[f+172+(k<<4)+8>>1]=p>>>8|p<<8;p=e[l+(k<<4)+10>>1]|0;b[f+172+(k<<4)+10>>1]=p>>>8|p<<8;c[f+172+(k<<4)+12>>2]=_E(c[l+(k<<4)+12>>2]|0)|0;k=k+1|0}while((k|0)!=(h|0));l=c[f+136>>2]|0;n=18}else{l=f+172|0;n=18}else if((h|0)>0){l=c[d+136>>2]|0;k=0;do{b[f+172+(k<<4)>>1]=b[l+(k<<4)>>1]|0;b[f+172+(k<<4)+2>>1]=b[l+(k<<4)+2>>1]|0;b[f+172+(k<<4)+4>>1]=b[l+(k<<4)+4>>1]|0;b[f+172+(k<<4)+6>>1]=b[l+(k<<4)+6>>1]|0;b[f+172+(k<<4)+8>>1]=b[l+(k<<4)+8>>1]|0;b[f+172+(k<<4)+10>>1]=b[l+(k<<4)+10>>1]|0;c[f+172+(k<<4)+12>>2]=c[l+(k<<4)+12>>2];k=k+1|0}while((k|0)!=(h|0));l=f+172|0;k=h<<4;n=19}else{l=f+172|0;n=18}if((n|0)==18)if(!l)k=h<<4;else{k=h<<4;n=19}if((n|0)==19){if(!((a[f+140>>0]|0)==0|(l|0)==0)){c[5110]=(c[5110]|0)+1;RE(c[l+-4>>2]|0)}c[f+136>>2]=0};c[f+128>>2]=0;c[f+132>>2]=0;c[f+136>>2]=0;a[f+140>>0]=0}h=f+(k+172)|0;l=c[d+168>>2]|0;k=c[f+160>>2]|0;if(k){if(a[f+164>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[k+-4>>2]|0)}c[f+160>>2]=0};c[f+152>>2]=0;c[f+156>>2]=0;c[f+160>>2]=0;a[f+164>>0]=0;c[f+160>>2]=h;c[f+152>>2]=l;c[f+156>>2]=l;m=c[d+168>>2]|0;if(j)if((m|0)>0){k=c[d+160>>2]|0;l=0;do{p=e[k+(l<<5)>>1]|0;b[h+(l<<5)>>1]=p>>>8|p<<8;p=e[k+(l<<5)+2>>1]|0;b[h+(l<<5)+2>>1]=p>>>8|p<<8;p=e[k+(l<<5)+4>>1]|0;b[h+(l<<5)+4>>1]=p>>>8|p<<8;p=e[k+(l<<5)+6>>1]|0;b[h+(l<<5)+6>>1]=p>>>8|p<<8;p=e[k+(l<<5)+8>>1]|0;b[h+(l<<5)+8>>1]=p>>>8|p<<8;p=e[k+(l<<5)+10>>1]|0;b[h+(l<<5)+10>>1]=p>>>8|p<<8;c[h+(l<<5)+12>>2]=_E(c[k+(l<<5)+12>>2]|0)|0;c[h+(l<<5)+16>>2]=_E(c[k+(l<<5)+16>>2]|0)|0;l=l+1|0}while((l|0)!=(m|0));h=c[f+160>>2]|0;n=51}else n=51;else if((m|0)>0){l=c[d+160>>2]|0;k=0;do{b[h+(k<<5)>>1]=b[l+(k<<5)>>1]|0;b[h+(k<<5)+2>>1]=b[l+(k<<5)+2>>1]|0;b[h+(k<<5)+4>>1]=b[l+(k<<5)+4>>1]|0;b[h+(k<<5)+6>>1]=b[l+(k<<5)+6>>1]|0;b[h+(k<<5)+8>>1]=b[l+(k<<5)+8>>1]|0;b[h+(k<<5)+10>>1]=b[l+(k<<5)+10>>1]|0;c[h+(k<<5)+12>>2]=c[l+(k<<5)+12>>2];c[h+(k<<5)+16>>2]=c[l+(k<<5)+16>>2];c[h+(k<<5)+20>>2]=0;c[h+(k<<5)+24>>2]=0;c[h+(k<<5)+28>>2]=0;k=k+1|0}while((k|0)<(c[d+168>>2]|0))}else n=51;if((n|0)==51)if(!h){c[f>>2]=0;c[f+152>>2]=0;c[f+156>>2]=0;c[f+160>>2]=0;a[f+164>>0]=0;i=o;return 1}if(!((a[f+164>>0]|0)==0|(h|0)==0)){c[5110]=(c[5110]|0)+1;RE(c[h+-4>>2]|0)}c[f+160>>2]=0;c[f>>2]=0;c[f+152>>2]=0;c[f+156>>2]=0;c[f+160>>2]=0;a[f+164>>0]=0;i=o;return 1}function wC(d,e){d=d|0;e=e|0;var f=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;p=i;i=i+112|0;g[d+20>>2]=+g[e+16>>2];g[d+24>>2]=+g[e+20>>2];g[d+28>>2]=+g[e+24>>2];g[d+32>>2]=+g[e+28>>2];g[d+4>>2]=+g[e>>2];g[d+8>>2]=+g[e+4>>2];g[d+12>>2]=+g[e+8>>2];g[d+16>>2]=+g[e+12>>2];g[d+36>>2]=+g[e+32>>2];g[d+40>>2]=+g[e+36>>2];g[d+44>>2]=+g[e+40>>2];g[d+48>>2]=+g[e+44>>2];c[d+56>>2]=c[e+48>>2];a[d+60>>0]=(c[e+52>>2]|0)!=0&1;o=c[e+56>>2]|0;f=p+48|0;m=f+64|0;do{c[f>>2]=0;f=f+4|0}while((f|0)<(m|0));n=c[d+88>>2]|0;if((n|0)<(o|0)){if((c[d+92>>2]|0)<(o|0)){if(!o){h=n;k=0}else{c[5108]=(c[5108]|0)+1;h=QE(o<<6|19)|0;if(!h)j=0;else{c[(h+19&-16)+-4>>2]=h;j=h+19&-16}h=c[d+88>>2]|0;k=j}if((h|0)>0){j=0;do{f=k+(j<<6)+0|0;l=(c[d+96>>2]|0)+(j<<6)+0|0;m=f+64|0;do{c[f>>2]=c[l>>2];f=f+4|0;l=l+4|0}while((f|0)<(m|0));j=j+1|0}while((j|0)!=(h|0))}j=c[d+96>>2]|0;if(j){if(a[d+100>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[j+-4>>2]|0)}c[d+96>>2]=0}a[d+100>>0]=1;c[d+96>>2]=k;c[d+92>>2]=o;h=d+96|0}else h=d+96|0;j=n;do{f=(c[h>>2]|0)+(j<<6)+0|0;l=p+48|0;m=f+64|0;do{c[f>>2]=c[l>>2];f=f+4|0;l=l+4|0}while((f|0)<(m|0));j=j+1|0}while((j|0)!=(o|0))}c[d+88>>2]=o;if((o|0)>0){j=c[d+96>>2]|0;h=0;f=c[e+64>>2]|0;while(1){g[j+(h<<6)+16>>2]=+g[f+16>>2];g[j+(h<<6)+20>>2]=+g[f+20>>2];g[j+(h<<6)+24>>2]=+g[f+24>>2];g[j+(h<<6)+28>>2]=+g[f+28>>2];g[j+(h<<6)>>2]=+g[f>>2];g[j+(h<<6)+4>>2]=+g[f+4>>2];g[j+(h<<6)+8>>2]=+g[f+8>>2];g[j+(h<<6)+12>>2]=+g[f+12>>2];c[j+(h<<6)+32>>2]=c[f+32>>2];c[j+(h<<6)+36>>2]=c[f+36>>2];c[j+(h<<6)+40>>2]=c[f+40>>2];h=h+1|0;if((h|0)==(o|0))break;else f=f+48|0}}n=c[e+60>>2]|0;c[p+32>>2]=0;c[p+36>>2]=0;c[p+40>>2]=0;c[p+44>>2]=0;k=c[d+128>>2]|0;if((k|0)<(n|0)){if((c[d+132>>2]|0)<(n|0)){if(!n){h=k;f=0}else{c[5108]=(c[5108]|0)+1;h=QE((n<<4|3)+16|0)|0;if(!h)j=0;else{c[(h+19&-16)+-4>>2]=h;j=h+19&-16}h=c[d+128>>2]|0;f=j}if((h|0)>0){j=0;do{o=f+(j<<4)|0;m=(c[d+136>>2]|0)+(j<<4)|0;c[o+0>>2]=c[m+0>>2];c[o+4>>2]=c[m+4>>2];c[o+8>>2]=c[m+8>>2];c[o+12>>2]=c[m+12>>2];j=j+1|0}while((j|0)!=(h|0))}j=c[d+136>>2]|0;if(j){if(a[d+140>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[j+-4>>2]|0)}c[d+136>>2]=0}a[d+140>>0]=1;c[d+136>>2]=f;c[d+132>>2]=n;j=d+136|0}else j=d+136|0;h=k;do{o=(c[j>>2]|0)+(h<<4)|0;c[o+0>>2]=c[p+32>>2];c[o+4>>2]=c[p+36>>2];c[o+8>>2]=c[p+40>>2];c[o+12>>2]=c[p+44>>2];h=h+1|0}while((h|0)!=(n|0))}c[d+128>>2]=n;if((n|0)>0){j=c[d+136>>2]|0;h=0;f=c[e+68>>2]|0;while(1){c[j+(h<<4)+12>>2]=c[f+12>>2];b[j+(h<<4)+6>>1]=b[f+6>>1]|0;b[j+(h<<4)+8>>1]=b[f+8>>1]|0;b[j+(h<<4)+10>>1]=b[f+10>>1]|0;b[j+(h<<4)>>1]=b[f>>1]|0;b[j+(h<<4)+2>>1]=b[f+2>>1]|0;b[j+(h<<4)+4>>1]=b[f+4>>1]|0;h=h+1|0;if((h|0)==(n|0))break;else f=f+16|0}}c[d+144>>2]=c[e+76>>2];n=c[e+80>>2]|0;k=c[d+152>>2]|0;if((k|0)<(n|0)){if((c[d+156>>2]|0)<(n|0)){if(!n){h=k;f=0}else{c[5108]=(c[5108]|0)+1;h=QE(n<<5|19)|0;if(!h)j=0;else{c[(h+19&-16)+-4>>2]=h;j=h+19&-16}h=c[d+152>>2]|0;f=j}if((h|0)>0){j=0;do{o=f+(j<<5)|0;m=(c[d+160>>2]|0)+(j<<5)|0;c[o+0>>2]=c[m+0>>2];c[o+4>>2]=c[m+4>>2];c[o+8>>2]=c[m+8>>2];c[o+12>>2]=c[m+12>>2];c[o+16>>2]=c[m+16>>2];c[o+20>>2]=c[m+20>>2];c[o+24>>2]=c[m+24>>2];c[o+28>>2]=c[m+28>>2];j=j+1|0}while((j|0)!=(h|0))}j=c[d+160>>2]|0;if(j){if(a[d+164>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[j+-4>>2]|0)}c[d+160>>2]=0}a[d+164>>0]=1;c[d+160>>2]=f;c[d+156>>2]=n;j=d+160|0}else j=d+160|0;h=k;do{o=(c[j>>2]|0)+(h<<5)|0;c[o+0>>2]=c[p+0>>2];c[o+4>>2]=c[p+4>>2];c[o+8>>2]=c[p+8>>2];c[o+12>>2]=c[p+12>>2];c[o+16>>2]=c[p+16>>2];c[o+20>>2]=c[p+20>>2];c[o+24>>2]=c[p+24>>2];c[o+28>>2]=c[p+28>>2];h=h+1|0}while((h|0)!=(n|0))}c[d+152>>2]=n;if((n|0)<=0){i=p;return}h=c[d+160>>2]|0;j=0;f=c[e+72>>2]|0;while(1){b[h+(j<<5)+6>>1]=b[f+14>>1]|0;b[h+(j<<5)+8>>1]=b[f+16>>1]|0;b[h+(j<<5)+10>>1]=b[f+18>>1]|0;b[h+(j<<5)>>1]=b[f+8>>1]|0;b[h+(j<<5)+2>>1]=b[f+10>>1]|0;b[h+(j<<5)+4>>1]=b[f+12>>1]|0;c[h+(j<<5)+12>>2]=c[f>>2];c[h+(j<<5)+16>>2]=c[f+4>>2];j=j+1|0;if((j|0)==(n|0))break;else f=f+20|0}i=p;return}function xC(d,e){d=d|0;e=e|0;var f=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;q=i;i=i+112|0;g[d+20>>2]=+h[e+32>>3];g[d+24>>2]=+h[e+40>>3];g[d+28>>2]=+h[e+48>>3];g[d+32>>2]=+h[e+56>>3];g[d+4>>2]=+h[e>>3];g[d+8>>2]=+h[e+8>>3];g[d+12>>2]=+h[e+16>>3];g[d+16>>2]=+h[e+24>>3];g[d+36>>2]=+h[e+64>>3];g[d+40>>2]=+h[e+72>>3];g[d+44>>2]=+h[e+80>>3];g[d+48>>2]=+h[e+88>>3];c[d+56>>2]=c[e+96>>2];a[d+60>>0]=(c[e+100>>2]|0)!=0&1;p=c[e+104>>2]|0;f=q+48|0;n=f+64|0;do{c[f>>2]=0;f=f+4|0}while((f|0)<(n|0));o=c[d+88>>2]|0;if((o|0)<(p|0)){if((c[d+92>>2]|0)<(p|0)){if(!p){j=o;l=0}else{c[5108]=(c[5108]|0)+1;j=QE(p<<6|19)|0;if(!j)k=0;else{c[(j+19&-16)+-4>>2]=j;k=j+19&-16}j=c[d+88>>2]|0;l=k}if((j|0)>0){k=0;do{f=l+(k<<6)+0|0;m=(c[d+96>>2]|0)+(k<<6)+0|0;n=f+64|0;do{c[f>>2]=c[m>>2];f=f+4|0;m=m+4|0}while((f|0)<(n|0));k=k+1|0}while((k|0)!=(j|0))}k=c[d+96>>2]|0;if(k){if(a[d+100>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[k+-4>>2]|0)}c[d+96>>2]=0}a[d+100>>0]=1;c[d+96>>2]=l;c[d+92>>2]=p;j=d+96|0}else j=d+96|0;k=o;do{f=(c[j>>2]|0)+(k<<6)+0|0;m=q+48|0;n=f+64|0;do{c[f>>2]=c[m>>2];f=f+4|0;m=m+4|0}while((f|0)<(n|0));k=k+1|0}while((k|0)!=(p|0))}c[d+88>>2]=p;if((p|0)>0){k=c[d+96>>2]|0;j=0;f=c[e+112>>2]|0;while(1){g[k+(j<<6)+16>>2]=+h[f+32>>3];g[k+(j<<6)+20>>2]=+h[f+40>>3];g[k+(j<<6)+24>>2]=+h[f+48>>3];g[k+(j<<6)+28>>2]=+h[f+56>>3];g[k+(j<<6)>>2]=+h[f>>3];g[k+(j<<6)+4>>2]=+h[f+8>>3];g[k+(j<<6)+8>>2]=+h[f+16>>3];g[k+(j<<6)+12>>2]=+h[f+24>>3];c[k+(j<<6)+32>>2]=c[f+64>>2];c[k+(j<<6)+36>>2]=c[f+68>>2];c[k+(j<<6)+40>>2]=c[f+72>>2];j=j+1|0;if((j|0)==(p|0))break;else f=f+80|0}}o=c[e+108>>2]|0;c[q+32>>2]=0;c[q+36>>2]=0;c[q+40>>2]=0;c[q+44>>2]=0;l=c[d+128>>2]|0;if((l|0)<(o|0)){if((c[d+132>>2]|0)<(o|0)){if(!o){j=l;f=0}else{c[5108]=(c[5108]|0)+1;j=QE((o<<4|3)+16|0)|0;if(!j)k=0;else{c[(j+19&-16)+-4>>2]=j;k=j+19&-16}j=c[d+128>>2]|0;f=k}if((j|0)>0){k=0;do{p=f+(k<<4)|0;n=(c[d+136>>2]|0)+(k<<4)|0;c[p+0>>2]=c[n+0>>2];c[p+4>>2]=c[n+4>>2];c[p+8>>2]=c[n+8>>2];c[p+12>>2]=c[n+12>>2];k=k+1|0}while((k|0)!=(j|0))}k=c[d+136>>2]|0;if(k){if(a[d+140>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[k+-4>>2]|0)}c[d+136>>2]=0}a[d+140>>0]=1;c[d+136>>2]=f;c[d+132>>2]=o;k=d+136|0}else k=d+136|0;j=l;do{p=(c[k>>2]|0)+(j<<4)|0;c[p+0>>2]=c[q+32>>2];c[p+4>>2]=c[q+36>>2];c[p+8>>2]=c[q+40>>2];c[p+12>>2]=c[q+44>>2];j=j+1|0}while((j|0)!=(o|0))}c[d+128>>2]=o;if((o|0)>0){k=c[d+136>>2]|0;j=0;f=c[e+116>>2]|0;while(1){c[k+(j<<4)+12>>2]=c[f+12>>2];b[k+(j<<4)+6>>1]=b[f+6>>1]|0;b[k+(j<<4)+8>>1]=b[f+8>>1]|0;b[k+(j<<4)+10>>1]=b[f+10>>1]|0;b[k+(j<<4)>>1]=b[f>>1]|0;b[k+(j<<4)+2>>1]=b[f+2>>1]|0;b[k+(j<<4)+4>>1]=b[f+4>>1]|0;j=j+1|0;if((j|0)==(o|0))break;else f=f+16|0}}c[d+144>>2]=c[e+120>>2];o=c[e+124>>2]|0;l=c[d+152>>2]|0;if((l|0)<(o|0)){if((c[d+156>>2]|0)<(o|0)){if(!o){j=l;f=0}else{c[5108]=(c[5108]|0)+1;j=QE(o<<5|19)|0;if(!j)k=0;else{c[(j+19&-16)+-4>>2]=j;k=j+19&-16}j=c[d+152>>2]|0;f=k}if((j|0)>0){k=0;do{p=f+(k<<5)|0;n=(c[d+160>>2]|0)+(k<<5)|0;c[p+0>>2]=c[n+0>>2];c[p+4>>2]=c[n+4>>2];c[p+8>>2]=c[n+8>>2];c[p+12>>2]=c[n+12>>2];c[p+16>>2]=c[n+16>>2];c[p+20>>2]=c[n+20>>2];c[p+24>>2]=c[n+24>>2];c[p+28>>2]=c[n+28>>2];k=k+1|0}while((k|0)!=(j|0))}k=c[d+160>>2]|0;if(k){if(a[d+164>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[k+-4>>2]|0)}c[d+160>>2]=0}a[d+164>>0]=1;c[d+160>>2]=f;c[d+156>>2]=o;k=d+160|0}else k=d+160|0;j=l;do{p=(c[k>>2]|0)+(j<<5)|0;c[p+0>>2]=c[q+0>>2];c[p+4>>2]=c[q+4>>2];c[p+8>>2]=c[q+8>>2];c[p+12>>2]=c[q+12>>2];c[p+16>>2]=c[q+16>>2];c[p+20>>2]=c[q+20>>2];c[p+24>>2]=c[q+24>>2];c[p+28>>2]=c[q+28>>2];j=j+1|0}while((j|0)!=(o|0))}c[d+152>>2]=o;if((o|0)<=0){i=q;return}j=c[d+160>>2]|0;k=0;f=c[e+128>>2]|0;while(1){b[j+(k<<5)+6>>1]=b[f+14>>1]|0;b[j+(k<<5)+8>>1]=b[f+16>>1]|0;b[j+(k<<5)+10>>1]=b[f+18>>1]|0;b[j+(k<<5)>>1]=b[f+8>>1]|0;b[j+(k<<5)+2>>1]=b[f+10>>1]|0;b[j+(k<<5)+4>>1]=b[f+12>>1]|0;c[j+(k<<5)+12>>2]=c[f>>2];c[j+(k<<5)+16>>2]=c[f+4>>2];k=k+1|0;if((k|0)==(o|0))break;else f=f+20|0}i=q;return}function yC(a,e,f){a=a|0;e=e|0;f=f|0;var h=0,j=0,k=0,l=0,m=0,n=0;n=i;g[e+16>>2]=+g[a+20>>2];g[e+20>>2]=+g[a+24>>2];g[e+24>>2]=+g[a+28>>2];g[e+28>>2]=+g[a+32>>2];g[e>>2]=+g[a+4>>2];g[e+4>>2]=+g[a+8>>2];g[e+8>>2]=+g[a+12>>2];g[e+12>>2]=+g[a+16>>2];g[e+32>>2]=+g[a+36>>2];g[e+36>>2]=+g[a+40>>2];g[e+40>>2]=+g[a+44>>2];g[e+44>>2]=+g[a+48>>2];c[e+48>>2]=c[a+56>>2];c[e+52>>2]=d[a+60>>0];h=c[a+88>>2]|0;c[e+56>>2]=h;if(h){h=ec[c[(c[f>>2]|0)+28>>2]&31](f,c[a+96>>2]|0)|0;c[e+64>>2]=h;if(h){l=c[a+88>>2]|0;j=Wb[c[(c[f>>2]|0)+16>>2]&63](f,48,l)|0;if((l|0)>0){h=c[a+96>>2]|0;m=0;k=c[j+8>>2]|0;while(1){g[k+16>>2]=+g[h+(m<<6)+16>>2];g[k+20>>2]=+g[h+(m<<6)+20>>2];g[k+24>>2]=+g[h+(m<<6)+24>>2];g[k+28>>2]=+g[h+(m<<6)+28>>2];g[k>>2]=+g[h+(m<<6)>>2];g[k+4>>2]=+g[h+(m<<6)+4>>2];g[k+8>>2]=+g[h+(m<<6)+8>>2];g[k+12>>2]=+g[h+(m<<6)+12>>2];c[k+32>>2]=c[h+(m<<6)+32>>2];c[k+36>>2]=c[h+(m<<6)+36>>2];c[k+40>>2]=c[h+(m<<6)+40>>2];m=m+1|0;if((m|0)==(l|0))break;else k=k+48|0}}else h=c[a+96>>2]|0;Hb[c[(c[f>>2]|0)+20>>2]&31](f,j,17368,1497453121,h)}}else c[e+64>>2]=0;h=c[a+128>>2]|0;c[e+60>>2]=h;if(h){h=ec[c[(c[f>>2]|0)+28>>2]&31](f,c[a+136>>2]|0)|0;c[e+68>>2]=h;if(h){l=c[a+128>>2]|0;j=Wb[c[(c[f>>2]|0)+16>>2]&63](f,16,l)|0;if((l|0)>0){h=c[a+136>>2]|0;m=0;k=c[j+8>>2]|0;while(1){c[k+12>>2]=c[h+(m<<4)+12>>2];b[k+6>>1]=b[h+(m<<4)+6>>1]|0;b[k+8>>1]=b[h+(m<<4)+8>>1]|0;b[k+10>>1]=b[h+(m<<4)+10>>1]|0;b[k>>1]=b[h+(m<<4)>>1]|0;b[k+2>>1]=b[h+(m<<4)+2>>1]|0;b[k+4>>1]=b[h+(m<<4)+4>>1]|0;m=m+1|0;if((m|0)==(l|0))break;else k=k+16|0}}else h=c[a+136>>2]|0;Hb[c[(c[f>>2]|0)+20>>2]&31](f,j,17392,1497453121,h)}}else c[e+68>>2]=0;c[e+76>>2]=c[a+144>>2];h=c[a+152>>2]|0;c[e+80>>2]=h;if(!h){c[e+72>>2]=0;i=n;return 17440}h=ec[c[(c[f>>2]|0)+28>>2]&31](f,c[a+160>>2]|0)|0;c[e+72>>2]=h;if(!h){i=n;return 17440}l=c[a+152>>2]|0;m=Wb[c[(c[f>>2]|0)+16>>2]&63](f,20,l)|0;if((l|0)>0){h=c[a+160>>2]|0;j=0;k=c[m+8>>2]|0;while(1){b[k+14>>1]=b[h+(j<<5)+6>>1]|0;b[k+16>>1]=b[h+(j<<5)+8>>1]|0;b[k+18>>1]=b[h+(j<<5)+10>>1]|0;b[k+8>>1]=b[h+(j<<5)>>1]|0;b[k+10>>1]=b[h+(j<<5)+2>>1]|0;b[k+12>>1]=b[h+(j<<5)+4>>1]|0;c[k>>2]=c[h+(j<<5)+12>>2];c[k+4>>2]=c[h+(j<<5)+16>>2];j=j+1|0;if((j|0)==(l|0))break;else k=k+20|0}}else h=c[a+160>>2]|0;Hb[c[(c[f>>2]|0)+20>>2]&31](f,m,17416,1497453121,h);i=n;return 17440}function zC(a){a=a|0;return}function AC(b){b=b|0;var d=0,e=0;e=i;d=c[b>>2]|0;if(d)CC(b,d);d=c[b+4>>2]|0;if(d){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}c[b+4>>2]=0;c[b+8>>2]=-1;d=c[b+32>>2]|0;if(d){if(a[b+36>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}c[b+32>>2]=0}a[b+36>>0]=1;c[b+32>>2]=0;c[b+24>>2]=0;c[b+28>>2]=0;c[b+16>>2]=0;d=c[b+52>>2]|0;if(!d){a[b+56>>0]=1;c[b+52>>2]=0;c[b+44>>2]=0;c[b+48>>2]=0;a[b+36>>0]=1;c[b+32>>2]=0;c[b+24>>2]=0;c[b+28>>2]=0;i=e;return}if(!(a[b+56>>0]|0)){a[b+56>>0]=1;c[b+52>>2]=0;c[b+44>>2]=0;c[b+48>>2]=0;a[b+36>>0]=1;c[b+32>>2]=0;c[b+24>>2]=0;c[b+28>>2]=0;i=e;return}c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0);d=c[b+32>>2]|0;a[b+56>>0]=1;c[b+52>>2]=0;c[b+44>>2]=0;c[b+48>>2]=0;if(!d){a[b+36>>0]=1;c[b+32>>2]=0;c[b+24>>2]=0;c[b+28>>2]=0;i=e;return}if(a[b+36>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}c[b+32>>2]=0;a[b+36>>0]=1;c[b+32>>2]=0;c[b+24>>2]=0;c[b+28>>2]=0;i=e;return}function BC(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0;n=i;i=i+32|0;if((b|0)<0)b=c[a+12>>2]|0;d=c[a>>2]|0;if(!((d|0)!=0&(b|0)>0)){i=n;return}while(1){e=d+40|0;if(c[e>>2]|0){m=0;while(1){l=(c[a+16>>2]|0)>>>m&1;k=d+32|0;f=c[k>>2]|0;if(f>>>0>d>>>0){j=(c[f+40>>2]|0)==(d|0)&1;g=c[f+((j^1)<<2)+36>>2]|0;h=c[f+32>>2]|0;if(!h)c[a>>2]=d;else c[h+(((c[h+40>>2]|0)==(f|0)&1)<<2)+36>>2]=d;c[g+32>>2]=d;c[f+32>>2]=d;c[k>>2]=h;k=d+36|0;c[f+36>>2]=c[k>>2];c[f+40>>2]=c[e>>2];c[(c[k>>2]|0)+32>>2]=f;c[(c[e>>2]|0)+32>>2]=f;c[d+(j<<2)+36>>2]=f;c[d+((j^1)<<2)+36>>2]=g;c[n+0>>2]=c[f+0>>2];c[n+4>>2]=c[f+4>>2];c[n+8>>2]=c[f+8>>2];c[n+12>>2]=c[f+12>>2];c[n+16>>2]=c[f+16>>2];c[n+20>>2]=c[f+20>>2];c[n+24>>2]=c[f+24>>2];c[n+28>>2]=c[f+28>>2];c[f+0>>2]=c[d+0>>2];c[f+4>>2]=c[d+4>>2];c[f+8>>2]=c[d+8>>2];c[f+12>>2]=c[d+12>>2];c[f+16>>2]=c[d+16>>2];c[f+20>>2]=c[d+20>>2];c[f+24>>2]=c[d+24>>2];c[f+28>>2]=c[d+28>>2];c[d+0>>2]=c[n+0>>2];c[d+4>>2]=c[n+4>>2];c[d+8>>2]=c[n+8>>2];c[d+12>>2]=c[n+12>>2];c[d+16>>2]=c[n+16>>2];c[d+20>>2]=c[n+20>>2];c[d+24>>2]=c[n+24>>2];c[d+28>>2]=c[n+28>>2];d=f}d=c[d+(l<<2)+36>>2]|0;e=d+40|0;if(!(c[e>>2]|0))break;else m=m+1&31}}if(!(DC(a,d)|0))e=0;else e=c[a>>2]|0;EC(a,e,d);c[a+16>>2]=(c[a+16>>2]|0)+1;b=b+-1|0;if(!b)break;d=c[a>>2]|0}i=n;return}function CC(a,b){a=a|0;b=b|0;var d=0,e=0;e=i;if(c[b+40>>2]|0){CC(a,c[b+36>>2]|0);CC(a,c[b+40>>2]|0)}if((c[a>>2]|0)==(b|0))c[a>>2]=0;d=c[a+4>>2]|0;if(!d){c[a+4>>2]=b;i=e;return}c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0);c[a+4>>2]=b;i=e;return}function DC(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,h=0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0,x=0,y=0,z=0,A=0;h=i;if((c[a>>2]|0)==(b|0)){c[a>>2]=0;d=0;i=h;return d|0}e=c[b+32>>2]|0;d=c[e+32>>2]|0;b=c[e+(((c[e+40>>2]|0)!=(b|0)&1)<<2)+36>>2]|0;if(!d){c[a>>2]=b;c[b+32>>2]=0;d=c[a+4>>2]|0;if(!d)d=b;else{c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0);d=c[a>>2]|0}c[a+4>>2]=e;i=h;return d|0}c[d+(((c[d+40>>2]|0)==(e|0)&1)<<2)+36>>2]=b;c[b+32>>2]=d;b=c[a+4>>2]|0;if(b){c[5110]=(c[5110]|0)+1;RE(c[b+-4>>2]|0)}c[a+4>>2]=e;do{u=+g[d>>2];z=d+4|0;s=+g[z>>2];x=d+8|0;q=+g[x>>2];A=d+16|0;o=+g[A>>2];y=d+20|0;m=+g[y>>2];b=d+24|0;k=+g[b>>2];w=c[d+36>>2]|0;e=c[d+40>>2]|0;v=+g[w>>2];t=+g[e>>2];t=v<t?v:t;g[d>>2]=t;v=+g[w+16>>2];n=+g[e+16>>2];n=v>n?v:n;g[A>>2]=n;v=+g[w+4>>2];r=+g[e+4>>2];r=v<r?v:r;g[z>>2]=r;v=+g[w+20>>2];l=+g[e+20>>2];l=v>l?v:l;g[y>>2]=l;v=+g[w+8>>2];p=+g[e+8>>2];p=v<p?v:p;g[x>>2]=p;v=+g[w+24>>2];j=+g[e+24>>2];j=v>j?v:j;g[b>>2]=j;if(!(u!=t|s!=r|q!=p|o!=n)?!(m!=l|k!=j):0){f=14;break}d=c[d+32>>2]|0}while((d|0)!=0);if((f|0)==14){i=h;return d|0}y=c[a>>2]|0;i=h;return y|0}function EC(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,h=0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0,q=0,r=0,s=0.0;r=i;if(!(c[a>>2]|0)){c[a>>2]=d;c[d+32>>2]=0;i=r;return}e=c[b+40>>2]|0;if(e){k=+g[d>>2]+ +g[d+16>>2];l=+g[d+4>>2]+ +g[d+20>>2];j=+g[d+8>>2]+ +g[d+24>>2];do{q=c[b+36>>2]|0;m=+O(+(k-(+g[q>>2]+ +g[q+16>>2])))+ +O(+(l-(+g[q+4>>2]+ +g[q+20>>2])))+ +O(+(j-(+g[q+8>>2]+ +g[q+24>>2])));b=c[b+((!(m<+O(+(k-(+g[e>>2]+ +g[e+16>>2])))+ +O(+(l-(+g[e+4>>2]+ +g[e+20>>2])))+ +O(+(j-(+g[e+8>>2]+ +g[e+24>>2]))))&1)<<2)+36>>2]|0;e=c[b+40>>2]|0}while((e|0)!=0)}p=b+32|0;q=c[p>>2]|0;e=c[a+4>>2]|0;if(!e){c[5108]=(c[5108]|0)+1;e=QE(63)|0;if((e|0)!=0?(c[(e+19&-16)+-4>>2]=e,(e+19&-16|0)!=0):0){f=(e+19&-16)+0|0;h=f+44|0;do{c[f>>2]=0;f=f+4|0}while((f|0)<(h|0));e=e+19&-16}else e=0}else c[a+4>>2]=0;c[e+32>>2]=q;h=e+36|0;c[h>>2]=0;f=e+40|0;c[f>>2]=0;s=+g[d>>2];o=+g[b>>2];o=s<o?s:o;g[e>>2]=o;s=+g[d+16>>2];l=+g[b+16>>2];l=s>l?s:l;g[e+16>>2]=l;s=+g[d+4>>2];n=+g[b+4>>2];n=s<n?s:n;g[e+4>>2]=n;s=+g[d+20>>2];k=+g[b+20>>2];k=s>k?s:k;g[e+20>>2]=k;s=+g[d+8>>2];m=+g[b+8>>2];m=s<m?s:m;g[e+8>>2]=m;s=+g[d+24>>2];j=+g[b+24>>2];j=s>j?s:j;g[e+24>>2]=j;if(!q){c[h>>2]=b;c[p>>2]=e;c[f>>2]=d;c[d+32>>2]=e;c[a>>2]=e;i=r;return}c[q+(((c[(c[p>>2]|0)+40>>2]|0)==(b|0)&1)<<2)+36>>2]=e;c[h>>2]=b;c[p>>2]=e;c[f>>2]=d;c[d+32>>2]=e;e=q;while(1){b=e+4|0;if(((((+g[e>>2]<=o?+g[b>>2]<=n:0)?+g[e+8>>2]<=m:0)?+g[e+16>>2]>=l:0)?+g[e+20>>2]>=k:0)?+g[e+24>>2]>=j:0){e=21;break}d=c[e+36>>2]|0;q=c[e+40>>2]|0;s=+g[d>>2];o=+g[q>>2];o=s<o?s:o;g[e>>2]=o;s=+g[d+16>>2];l=+g[q+16>>2];l=s>l?s:l;g[e+16>>2]=l;s=+g[d+4>>2];n=+g[q+4>>2];n=s<n?s:n;g[b>>2]=n;s=+g[d+20>>2];k=+g[q+20>>2];k=s>k?s:k;g[e+20>>2]=k;s=+g[d+8>>2];m=+g[q+8>>2];m=s<m?s:m;g[e+8>>2]=m;s=+g[d+24>>2];j=+g[q+24>>2];j=s>j?s:j;g[e+24>>2]=j;e=c[e+32>>2]|0;if(!e){e=21;break}}if((e|0)==21){i=r;return}}function FC(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0.0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0;H=i;i=i+32|0;k=+g[b+16>>2];j=+g[b>>2];l=+g[b+20>>2];h=+g[b+4>>2];o=+g[b+24>>2];f=+g[b+8>>2];t=+g[b+32>>2];x=+g[b+36>>2];y=+g[b+40>>2];E=(l-h)*(y-f)-(o-f)*(x-h);F=(o-f)*(t-j)-(k-j)*(y-f);G=(k-j)*(x-h)-(l-h)*(t-j);g[H+16>>2]=E;g[H+20>>2]=F;g[H+24>>2]=G;g[H+28>>2]=0.0;p=+g[a+4>>2];r=+g[a+8>>2];v=+g[a+12>>2];D=E*p+F*r+G*v-(j*E+h*F+f*G);n=+g[a+20>>2];s=+g[a+24>>2];w=+g[a+28>>2];if(D*(E*n+F*s+G*w-(j*E+h*F+f*G))>=0.0){i=H;return}B=c[a+36>>2]|0;if((B&1|0)!=0&D<=0.0){i=H;return}C=D/(D-(E*n+F*s+G*w-(j*E+h*F+f*G)));if(!(C<+g[a+40>>2])){i=H;return}A=(E*E+F*F+G*G)*-9.999999747378752e-05;z=j-(n*C+p*(1.0-C));u=h-(s*C+r*(1.0-C));q=f-(w*C+v*(1.0-C));m=k-(n*C+p*(1.0-C));l=l-(s*C+r*(1.0-C));k=o-(w*C+v*(1.0-C));if(!(G*(z*l-u*m)+(E*(u*k-q*l)+F*(q*m-z*k))>=A)){i=H;return}j=t-(n*C+p*(1.0-C));h=x-(s*C+r*(1.0-C));f=y-(w*C+v*(1.0-C));if(!(G*(m*h-l*j)+(E*(l*f-k*h)+F*(k*j-m*f))>=A)){i=H;return}if(!(G*(u*j-z*h)+(E*(q*h-u*f)+F*(z*f-q*j))>=A)){i=H;return}f=1.0/+P(+(E*E+F*F+G*G));g[H+16>>2]=E*f;g[H+20>>2]=F*f;g[H+24>>2]=G*f;b=c[(c[a>>2]|0)+12>>2]|0;if((B&2|0)==0&D<=0.0){g[H>>2]=-(E*f);g[H+4>>2]=-(F*f);g[H+8>>2]=-(G*f);g[H+12>>2]=0.0;g[a+40>>2]=+lc[b&3](a,H,C,d,e);i=H;return}else{g[a+40>>2]=+lc[b&3](a,H+16|0,C,d,e);i=H;return}}function GC(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var h=0.0,j=0.0,k=0.0,l=0.0,m=0,n=0.0;m=i;i=i+672|0;c[m+576>>2]=0;g[m+580>>2]=1.0;g[m+584>>2]=1.0;g[m+588>>2]=1.0;g[m+592>>2]=0.0;c[m+620>>2]=0;c[m+568>>2]=7584;c[m+572>>2]=1;c[m+624>>2]=c[d+0>>2];c[m+628>>2]=c[d+4>>2];c[m+632>>2]=c[d+8>>2];c[m+636>>2]=c[d+12>>2];c[m+640>>2]=c[d+16>>2];c[m+644>>2]=c[d+20>>2];c[m+648>>2]=c[d+24>>2];c[m+652>>2]=c[d+28>>2];c[m+656>>2]=c[d+32>>2];c[m+660>>2]=c[d+36>>2];c[m+664>>2]=c[d+40>>2];c[m+668>>2]=c[d+44>>2];g[m+612>>2]=+g[b+204>>2];g[m+516>>2]=9.999999747378752e-05;a[m+540>>0]=0;c[m+200>>2]=19048;d=c[b+4>>2]|0;c[m+176>>2]=19312;c[m+180>>2]=m+208;c[m+184>>2]=m+200;c[m+188>>2]=d;c[m+192>>2]=m+568;c[m+196>>2]=0;c[m>>2]=7512;c[m+168>>2]=0;g[m+164>>2]=1.0;g[m+172>>2]=+g[b+208>>2];if((cD(m+176|0,b+8|0,b+72|0,b+136|0,b+136|0,m)|0?(h=+g[m+132>>2],j=+g[m+136>>2],k=+g[m+140>>2],h*h+j*j+k*k>9.999999747378752e-05):0)?(l=+g[m+164>>2],l<+g[b+200>>2]):0){n=1.0/+P(+(h*h+j*j+k*k));g[m+132>>2]=h*n;g[m+136>>2]=j*n;g[m+140>>2]=k*n;+$b[c[(c[b>>2]|0)+12>>2]&3](b,m+132|0,m+148|0,l,e,f)}c[m+568>>2]=13336;e=c[m+620>>2]|0;if(!e){i=m;return}Jb[c[c[e>>2]>>2]&255](e);e=c[m+620>>2]|0;if(!e){i=m;return}c[5110]=(c[5110]|0)+1;RE(c[e+-4>>2]|0);i=m;return}function HC(a){a=a|0;var b=0;b=i;RE(a);i=b;return}function IC(b,d,e,f,h,j,k,l,m,n){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;k=k|0;l=l|0;m=m|0;n=n|0;var o=0.0,p=0,q=0,r=0,s=0.0,t=0.0,u=0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0,D=0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0;C=i;i=i+4256|0;if(((c[e+4>>2]|0)+-17|0)>>>0<2)u=((c[f+4>>2]|0)+-17|0)>>>0<2;else u=0;b=0;do{JC();v=+g[17616+(b<<4)>>2];t=+g[17620+(b<<4)>>2];s=+g[17624+(b<<4)>>2];o=+g[h+4>>2]*-v+ +g[h+20>>2]*-t+ +g[h+36>>2]*-s;z=+g[h+8>>2]*-v+ +g[h+24>>2]*-t+ +g[h+40>>2]*-s;g[C+1280+(b<<4)>>2]=+g[h>>2]*-v+ +g[h+16>>2]*-t+ +g[h+32>>2]*-s;g[C+1280+(b<<4)+4>>2]=o;g[C+1280+(b<<4)+8>>2]=z;g[C+1280+(b<<4)+12>>2]=0.0;z=v*+g[j+4>>2]+t*+g[j+20>>2]+s*+g[j+36>>2];o=v*+g[j+8>>2]+t*+g[j+24>>2]+s*+g[j+40>>2];g[C+288+(b<<4)>>2]=v*+g[j>>2]+t*+g[j+16>>2]+s*+g[j+32>>2];g[C+288+(b<<4)+4>>2]=z;g[C+288+(b<<4)+8>>2]=o;g[C+288+(b<<4)+12>>2]=0.0;b=b+1|0}while((b|0)!=42);b=Nb[c[(c[e>>2]|0)+84>>2]&127](e)|0;if((b|0)>0){p=0;q=42;while(1){pc[c[(c[e>>2]|0)+88>>2]&127](e,p,C+272|0);z=+g[C+272>>2];o=+g[C+276>>2];s=+g[C+280>>2];t=z*+g[h+16>>2]+o*+g[h+20>>2]+s*+g[h+24>>2];v=z*+g[h+32>>2]+o*+g[h+36>>2]+s*+g[h+40>>2];g[C+272>>2]=+g[h>>2]*z+ +g[h+4>>2]*o+ +g[h+8>>2]*s;g[C+276>>2]=t;g[C+280>>2]=v;g[C+284>>2]=0.0;JC();r=17616+(q<<4)|0;c[r+0>>2]=c[C+272>>2];c[r+4>>2]=c[C+276>>2];c[r+8>>2]=c[C+280>>2];c[r+12>>2]=c[C+284>>2];v=+g[C+272>>2];t=+g[C+276>>2];s=+g[C+280>>2];o=+g[h+4>>2]*-v+ +g[h+20>>2]*-t+ +g[h+36>>2]*-s;z=+g[h+8>>2]*-v+ +g[h+24>>2]*-t+ +g[h+40>>2]*-s;g[C+1280+(q<<4)>>2]=+g[h>>2]*-v+ +g[h+16>>2]*-t+ +g[h+32>>2]*-s;g[C+1280+(q<<4)+4>>2]=o;g[C+1280+(q<<4)+8>>2]=z;g[C+1280+(q<<4)+12>>2]=0.0;z=v*+g[j+4>>2]+t*+g[j+20>>2]+s*+g[j+36>>2];o=v*+g[j+8>>2]+t*+g[j+24>>2]+s*+g[j+40>>2];g[C+288+(q<<4)>>2]=+g[j>>2]*v+ +g[j+16>>2]*t+ +g[j+32>>2]*s;g[C+288+(q<<4)+4>>2]=z;g[C+288+(q<<4)+8>>2]=o;g[C+288+(q<<4)+12>>2]=0.0;p=p+1|0;if((p|0)==(b|0))break;else q=q+1|0}b=b+42|0}else b=42;q=Nb[c[(c[f>>2]|0)+84>>2]&127](f)|0;if((q|0)>0){p=0;r=b;while(1){pc[c[(c[f>>2]|0)+88>>2]&127](f,p,C+256|0);z=+g[C+256>>2];o=+g[C+260>>2];s=+g[C+264>>2];t=z*+g[j+16>>2]+o*+g[j+20>>2]+s*+g[j+24>>2];v=z*+g[j+32>>2]+o*+g[j+36>>2]+s*+g[j+40>>2];g[C+256>>2]=+g[j>>2]*z+ +g[j+4>>2]*o+ +g[j+8>>2]*s;g[C+260>>2]=t;g[C+264>>2]=v;g[C+268>>2]=0.0;JC();D=17616+(r<<4)|0;c[D+0>>2]=c[C+256>>2];c[D+4>>2]=c[C+260>>2];c[D+8>>2]=c[C+264>>2];c[D+12>>2]=c[C+268>>2];v=+g[C+256>>2];t=+g[C+260>>2];s=+g[C+264>>2];o=+g[h+4>>2]*-v+ +g[h+20>>2]*-t+ +g[h+36>>2]*-s;z=+g[h+8>>2]*-v+ +g[h+24>>2]*-t+ +g[h+40>>2]*-s;g[C+1280+(r<<4)>>2]=+g[h>>2]*-v+ +g[h+16>>2]*-t+ +g[h+32>>2]*-s;g[C+1280+(r<<4)+4>>2]=o;g[C+1280+(r<<4)+8>>2]=z;g[C+1280+(r<<4)+12>>2]=0.0;z=v*+g[j+4>>2]+t*+g[j+20>>2]+s*+g[j+36>>2];o=v*+g[j+8>>2]+t*+g[j+24>>2]+s*+g[j+40>>2];g[C+288+(r<<4)>>2]=+g[j>>2]*v+ +g[j+16>>2]*t+ +g[j+32>>2]*s;g[C+288+(r<<4)+4>>2]=z;g[C+288+(r<<4)+8>>2]=o;g[C+288+(r<<4)+12>>2]=0.0;p=p+1|0;if((p|0)==(q|0))break;else r=r+1|0}b=q+b|0}tc[c[(c[e>>2]|0)+76>>2]&127](e,C+1280|0,C+3264|0,b);tc[c[(c[f>>2]|0)+76>>2]&127](f,C+288|0,C+2272|0,b);if((b|0)>0)if(u){u=0;w=0.0;x=0.0;y=0.0;s=999999984306749440.0;while(1){JC();t=+g[17616+(u<<4)>>2];o=+g[17620+(u<<4)>>2];v=+g[17628+(u<<4)>>2];if(t*t+o*o+0.0>.01?(B=+g[C+3264+(u<<4)>>2],z=+g[C+3264+(u<<4)+4>>2],A=+g[C+3264+(u<<4)+8>>2],G=+g[C+2272+(u<<4)>>2],F=+g[C+2272+(u<<4)+4>>2],E=+g[C+2272+(u<<4)+8>>2],A=t*(G*+g[j>>2]+F*+g[j+4>>2]+E*+g[j+8>>2]+ +g[j+48>>2]-(B*+g[h>>2]+z*+g[h+4>>2]+A*+g[h+8>>2]+ +g[h+48>>2]))+o*(G*+g[j+16>>2]+F*+g[j+20>>2]+E*+g[j+24>>2]+ +g[j+52>>2]-(B*+g[h+16>>2]+z*+g[h+20>>2]+A*+g[h+24>>2]+ +g[h+52>>2]))+0.0,A<s):0)s=A;else{t=w;o=x;v=y}u=u+1|0;if((u|0)==(b|0)){A=t;y=o;x=0.0;break}else{w=t;x=o;y=v}}}else{u=0;o=0.0;z=0.0;A=0.0;v=0.0;s=999999984306749440.0;while(1){JC();t=+g[17616+(u<<4)>>2];y=+g[17620+(u<<4)>>2];x=+g[17624+(u<<4)>>2];w=+g[17628+(u<<4)>>2];if(t*t+y*y+x*x>.01?(E=+g[C+3264+(u<<4)>>2],G=+g[C+3264+(u<<4)+4>>2],B=+g[C+3264+(u<<4)+8>>2],I=+g[C+2272+(u<<4)>>2],H=+g[C+2272+(u<<4)+4>>2],F=+g[C+2272+(u<<4)+8>>2],B=t*(I*+g[j>>2]+H*+g[j+4>>2]+F*+g[j+8>>2]+ +g[j+48>>2]-(E*+g[h>>2]+G*+g[h+4>>2]+B*+g[h+8>>2]+ +g[h+48>>2]))+y*(I*+g[j+16>>2]+H*+g[j+20>>2]+F*+g[j+24>>2]+ +g[j+52>>2]-(E*+g[h+16>>2]+G*+g[h+20>>2]+B*+g[h+24>>2]+ +g[h+52>>2]))+x*(I*+g[j+32>>2]+H*+g[j+36>>2]+F*+g[j+40>>2]+ +g[j+56>>2]-(E*+g[h+32>>2]+G*+g[h+36>>2]+B*+g[h+40>>2]+ +g[h+56>>2])),B<s):0){v=w;s=B}else{t=o;y=z;x=A}u=u+1|0;if((u|0)==(b|0)){A=t;break}else{o=t;z=y;A=x}}}else{A=0.0;y=0.0;x=0.0;v=0.0;s=999999984306749440.0}switch(c[e+4>>2]|0){case 4:case 5:case 10:case 11:case 13:case 1:case 0:case 8:break;default:+Zb[c[(c[e>>2]|0)+48>>2]&15](e)}switch(c[f+4>>2]|0){case 4:case 5:case 10:case 11:case 13:case 1:case 0:case 8:break;default:+Zb[c[(c[f>>2]|0)+48>>2]&15](f)}if(s<0.0){h=0;i=C;return h|0}switch(c[e+4>>2]|0){case 1:{t=+g[e+44>>2];break}case 13:{t=+g[e+44>>2];break}case 11:{t=+g[e+44>>2];break}case 10:{t=+g[e+44>>2];break}case 4:case 5:{t=+g[e+44>>2];break}case 8:{t=+g[e+28>>2]*+g[e+12>>2];break}case 0:{t=+g[e+44>>2];break}default:t=+Zb[c[(c[e>>2]|0)+48>>2]&15](e)}q=c[f+4>>2]|0;switch(q|0){case 8:{q=8;o=+g[f+28>>2]*+g[f+12>>2];break}case 0:{q=0;o=+g[f+44>>2];break}case 1:{q=1;o=+g[f+44>>2];break}case 13:{q=13;o=+g[f+44>>2];break}case 11:{q=11;o=+g[f+44>>2];break}case 10:{q=10;o=+g[f+44>>2];break}case 4:case 5:{o=+g[f+44>>2];break}default:{o=+Zb[c[(c[f>>2]|0)+48>>2]&15](f);q=c[f+4>>2]|0}}o=s+(t+o+.5);c[C+176>>2]=19400;g[C+180>>2]=0.0;g[C+184>>2]=1.0;g[C+188>>2]=0.0;g[C+192>>2]=0.0;c[C+196>>2]=0;c[C+200>>2]=d;c[C+204>>2]=e;c[C+208>>2]=f;c[C+212>>2]=c[e+4>>2];c[C+216>>2]=q;g[C+220>>2]=+Zb[c[(c[e>>2]|0)+48>>2]&15](e);g[C+224>>2]=+Zb[c[(c[f>>2]|0)+48>>2]&15](f);a[C+228>>0]=0;c[C+236>>2]=-1;c[C+248>>2]=1;c[C+252>>2]=1;t=+g[h+48>>2]+A*o;w=y*o+ +g[h+52>>2];B=x*o+ +g[h+56>>2];c[C+44>>2]=c[h+0>>2];c[C+48>>2]=c[h+4>>2];c[C+52>>2]=c[h+8>>2];c[C+56>>2]=c[h+12>>2];c[C+60>>2]=c[h+16>>2];c[C+64>>2]=c[h+20>>2];c[C+68>>2]=c[h+24>>2];c[C+72>>2]=c[h+28>>2];c[C+76>>2]=c[h+32>>2];c[C+80>>2]=c[h+36>>2];c[C+84>>2]=c[h+40>>2];c[C+88>>2]=c[h+44>>2];g[C+92>>2]=t;g[C+96>>2]=w;g[C+100>>2]=B;g[C+104>>2]=0.0;c[C+108>>2]=c[j+0>>2];c[C+112>>2]=c[j+4>>2];c[C+116>>2]=c[j+8>>2];c[C+120>>2]=c[j+12>>2];c[C+124>>2]=c[j+16>>2];c[C+128>>2]=c[j+20>>2];c[C+132>>2]=c[j+24>>2];c[C+136>>2]=c[j+28>>2];c[C+140>>2]=c[j+32>>2];c[C+144>>2]=c[j+36>>2];c[C+148>>2]=c[j+40>>2];c[C+152>>2]=c[j+44>>2];c[C+156>>2]=c[j+48>>2];c[C+160>>2]=c[j+52>>2];c[C+164>>2]=c[j+56>>2];c[C+168>>2]=c[j+60>>2];g[C+172>>2]=999999984306749440.0;c[C>>2]=18752;a[C+40>>0]=0;g[C+180>>2]=-A;g[C+184>>2]=-y;g[C+188>>2]=-x;g[C+192>>2]=0.0;eD(C+176|0,C+44|0,C,n,0);o=o-+g[C+36>>2];b=a[C+40>>0]|0;if(b<<24>>24){w=+g[C+24>>2]-y*o;B=+g[C+28>>2]-x*o;g[l>>2]=+g[C+20>>2]-A*o;g[l+4>>2]=w;g[l+8>>2]=B;g[l+12>>2]=0.0;c[m+0>>2]=c[C+20>>2];c[m+4>>2]=c[C+24>>2];c[m+8>>2]=c[C+28>>2];c[m+12>>2]=c[C+32>>2];g[k>>2]=A;g[k+4>>2]=y;g[k+8>>2]=x;g[k+12>>2]=v}h=b<<24>>24!=0;i=C;return h|0}function JC(){var b=0;b=i;if(a[18608]|0){i=b;return}if(!(Xa(18608)|0)){i=b;return}g[4404]=0.0;g[4405]=-0.0;g[4406]=-1.0;g[4407]=0.0;g[4408]=.7236080169677734;g[4409]=-.5257250070571899;g[4410]=-.44721901416778564;g[4411]=0.0;g[4412]=-.2763879895210266;g[4413]=-.8506489992141724;g[4414]=-.44721901416778564;g[4415]=0.0;g[4416]=-.8944259881973267;g[4417]=-0.0;g[4418]=-.4472160041332245;g[4419]=0.0;g[4420]=-.2763879895210266;g[4421]=.8506489992141724;g[4422]=-.44721999764442444;g[4423]=0.0;g[4424]=.7236080169677734;g[4425]=.5257250070571899;g[4426]=-.44721901416778564;g[4427]=0.0;g[4428]=.2763879895210266;g[4429]=-.8506489992141724;g[4430]=.44721999764442444;g[4431]=0.0;g[4432]=-.7236080169677734;g[4433]=-.5257250070571899;g[4434]=.44721901416778564;g[4435]=0.0;g[4436]=-.7236080169677734;g[4437]=.5257250070571899;g[4438]=.44721901416778564;g[4439]=0.0;g[4440]=.2763879895210266;g[4441]=.8506489992141724;g[4442]=.44721901416778564;g[4443]=0.0;g[4444]=.8944259881973267;g[4445]=0.0;g[4446]=.4472160041332245;g[4447]=0.0;g[4448]=-0.0;g[4449]=0.0;g[4450]=1.0;g[4451]=0.0;g[4452]=.4253230094909668;g[4453]=-.3090110123157501;g[4454]=-.8506540060043335;g[4455]=0.0;g[4456]=-.16245600581169128;g[4457]=-.49999499320983887;g[4458]=-.8506540060043335;g[4459]=0.0;g[4460]=.2628690004348755;g[4461]=-.8090119957923889;g[4462]=-.525738000869751;g[4463]=0.0;g[4464]=.4253230094909668;g[4465]=.3090110123157501;g[4466]=-.8506540060043335;g[4467]=0.0;g[4468]=.8506479859352112;g[4469]=-0.0;g[4470]=-.5257359743118286;g[4471]=0.0;g[4472]=-.5257300138473511;g[4473]=-0.0;g[4474]=-.8506519794464111;g[4475]=0.0;g[4476]=-.6881899833679199;g[4477]=-.49999698996543884;g[4478]=-.5257359743118286;g[4479]=0.0;g[4480]=-.16245600581169128;g[4481]=.49999499320983887;g[4482]=-.8506540060043335;g[4483]=0.0;g[4484]=-.6881899833679199;g[4485]=.49999698996543884;g[4486]=-.5257359743118286;g[4487]=0.0;g[4488]=.2628690004348755;g[4489]=.8090119957923889;g[4490]=-.525738000869751;g[4491]=0.0;g[4492]=.9510579705238342;g[4493]=.3090130090713501;g[4494]=0.0;g[4495]=0.0;g[4496]=.9510579705238342;g[4497]=-.3090130090713501;g[4498]=0.0;g[4499]=0.0;g[4500]=.5877860188484192;g[4501]=-.80901700258255;g[4502]=0.0;g[4503]=0.0;g[4504]=0.0;g[4505]=-1.0;g[4506]=0.0;g[4507]=0.0;g[4508]=-.5877860188484192;g[4509]=-.80901700258255;g[4510]=0.0;g[4511]=0.0;g[4512]=-.9510579705238342;g[4513]=-.3090130090713501;g[4514]=-0.0;g[4515]=0.0;g[4516]=-.9510579705238342;g[4517]=.3090130090713501;g[4518]=-0.0;g[4519]=0.0;g[4520]=-.5877860188484192;g[4521]=.80901700258255;g[4522]=-0.0;g[4523]=0.0;g[4524]=-0.0;g[4525]=1.0;g[4526]=-0.0;g[4527]=0.0;g[4528]=.5877860188484192;g[4529]=.80901700258255;g[4530]=-0.0;g[4531]=0.0;g[4532]=.6881899833679199;g[4533]=-.49999698996543884;g[4534]=.5257359743118286;g[4535]=0.0;g[4536]=-.2628690004348755;g[4537]=-.8090119957923889;g[4538]=.525738000869751;g[4539]=0.0;g[4540]=-.8506479859352112;g[4541]=0.0;g[4542]=.5257359743118286;g[4543]=0.0;g[4544]=-.2628690004348755;g[4545]=.8090119957923889;g[4546]=.525738000869751;g[4547]=0.0;g[4548]=.6881899833679199;g[4549]=.49999698996543884;g[4550]=.5257359743118286;g[4551]=0.0;g[4552]=.5257300138473511;g[4553]=0.0;g[4554]=.8506519794464111;g[4555]=0.0;g[4556]=.16245600581169128;g[4557]=-.49999499320983887;g[4558]=.8506540060043335;g[4559]=0.0;g[4560]=-.4253230094909668;g[4561]=-.3090110123157501;g[4562]=.8506540060043335;g[4563]=0.0;g[4564]=-.4253230094909668;g[4565]=.3090110123157501;g[4566]=.8506540060043335;g[4567]=0.0;g[4568]=.16245600581169128;g[4569]=.49999499320983887;g[4570]=.8506540060043335;g[4571]=0.0;ab(18608);i=b;return}function KC(a){a=a|0;var b=0;b=i;RE(a);i=b;return}function LC(a){a=a|0;return}function MC(b,d,e,f){b=b|0;d=d|0;e=e|0;f=+f;c[b+4>>2]=c[d+0>>2];c[b+8>>2]=c[d+4>>2];c[b+12>>2]=c[d+8>>2];c[b+16>>2]=c[d+12>>2];c[b+20>>2]=c[e+0>>2];c[b+24>>2]=c[e+4>>2];c[b+28>>2]=c[e+8>>2];c[b+32>>2]=c[e+12>>2];g[b+36>>2]=f;a[b+40>>0]=1;return}function NC(a,b,c){a=a|0;b=b|0;c=c|0;return}function OC(a,b,c){a=a|0;b=b|0;c=c|0;return}function PC(a){a=a|0;var b=0;b=i;RE(a);i=b;return}function QC(b,d,e,f,h,j){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;var k=0,l=0.0,m=0.0,n=0.0,o=0.0,p=0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0,w=0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0,L=0.0,M=0.0,N=0.0,O=0.0,Q=0.0,R=0.0,S=0.0,T=0.0,U=0.0,V=0.0,W=0.0,X=0.0,Y=0.0,Z=0.0,_=0.0,$=0.0,aa=0.0,ba=0.0,ca=0.0,da=0.0,ea=0.0,fa=0,ga=0.0;fa=i;i=i+128|0;p=c[b+4>>2]|0;a[p+312>>0]=0;c[p>>2]=0;a[p+356>>0]=1;g[p+292>>2]=999999984306749440.0;g[p+296>>2]=999999984306749440.0;g[p+300>>2]=999999984306749440.0;g[p+304>>2]=0.0;c[p+336>>2]=0;c[p+340>>2]=0;c[p+344>>2]=0;c[p+348>>2]=0;a[p+352>>0]=0;a[p+332>>0]=a[p+332>>0]&-16;o=+g[d+48>>2];n=+g[d+52>>2];m=+g[d+56>>2];q=+g[f+48>>2];l=+g[f+52>>2];r=+g[f+56>>2];L=+g[d>>2];S=+g[d+4>>2];T=+g[d+8>>2];U=+g[d+16>>2];M=+g[d+20>>2];N=+g[d+24>>2];O=+g[d+32>>2];Q=+g[d+36>>2];R=+g[d+40>>2];V=+g[f>>2];$=+g[f+4>>2];aa=+g[f+8>>2];ba=+g[f+16>>2];W=+g[f+20>>2];X=+g[f+24>>2];Y=+g[f+32>>2];Z=+g[f+36>>2];_=+g[f+40>>2];ca=+g[e+48>>2]-o-(+g[h+48>>2]-q);ea=+g[e+52>>2]-n-(+g[h+52>>2]-l);da=+g[e+56>>2]-m-(+g[h+56>>2]-r);p=c[b+8>>2]|0;K=c[(c[p>>2]|0)+64>>2]|0;g[fa+96>>2]=L*-ca+U*-ea+O*-da;g[fa+100>>2]=S*-ca+M*-ea+Q*-da;g[fa+104>>2]=T*-ca+N*-ea+R*-da;g[fa+108>>2]=0.0;pc[K&127](fa+112|0,p,fa+96|0);G=+g[fa+112>>2];H=+g[fa+116>>2];F=+g[fa+120>>2];s=G*+g[d>>2]+H*+g[d+4>>2]+F*+g[d+8>>2]+ +g[d+48>>2];u=G*+g[d+16>>2]+H*+g[d+20>>2]+F*+g[d+24>>2]+ +g[d+52>>2];F=G*+g[d+32>>2]+H*+g[d+36>>2]+F*+g[d+40>>2]+ +g[d+56>>2];p=c[b+12>>2]|0;K=c[(c[p>>2]|0)+64>>2]|0;H=ca*+g[f+4>>2]+ea*+g[f+20>>2]+da*+g[f+36>>2];G=ca*+g[f+8>>2]+ea*+g[f+24>>2]+da*+g[f+40>>2];g[fa+64>>2]=ca*+g[f>>2]+ea*+g[f+16>>2]+da*+g[f+32>>2];g[fa+68>>2]=H;g[fa+72>>2]=G;g[fa+76>>2]=0.0;pc[K&127](fa+80|0,p,fa+64|0);G=+g[fa+80>>2];H=+g[fa+84>>2];t=+g[fa+88>>2];s=s-(G*+g[f>>2]+H*+g[f+4>>2]+t*+g[f+8>>2]+ +g[f+48>>2]);u=u-(G*+g[f+16>>2]+H*+g[f+20>>2]+t*+g[f+24>>2]+ +g[f+52>>2]);t=F-(G*+g[f+32>>2]+H*+g[f+36>>2]+t*+g[f+40>>2]+ +g[f+56>>2]);a:do if(s*s+u*u+t*t>9.999999747378752e-05){D=q;C=o;B=n;z=m;y=l;m=0.0;K=32;o=0.0;A=0.0;n=0.0;q=0.0;l=0.0;x=u;while(1){if(!K){l=A;break a}K=K+-1|0;p=c[b+8>>2]|0;w=c[(c[p>>2]|0)+64>>2]|0;H=-s;ga=-x;u=-t;g[fa+32>>2]=L*H+U*ga+O*u;g[fa+36>>2]=S*H+M*ga+Q*u;g[fa+40>>2]=T*H+N*ga+R*u;g[fa+44>>2]=0.0;pc[w&127](fa+48|0,p,fa+32|0);u=+g[fa+48>>2];ga=+g[fa+52>>2];H=+g[fa+56>>2];F=C+(L*u+S*ga+T*H);J=B+(U*u+M*ga+N*H);H=z+(O*u+Q*ga+R*H);p=c[b+12>>2]|0;w=c[(c[p>>2]|0)+64>>2]|0;g[fa>>2]=V*s+ba*x+Y*t;g[fa+4>>2]=$*s+W*x+Z*t;g[fa+8>>2]=aa*s+X*x+_*t;g[fa+12>>2]=0.0;pc[w&127](fa+16|0,p,fa);ga=+g[fa+16>>2];u=+g[fa+20>>2];G=+g[fa+24>>2];E=D+(V*ga+$*u+aa*G);I=y+(ba*ga+W*u+X*G);G=r+(Y*ga+Z*u+_*G);u=s*(F-E)+x*(J-I)+t*(H-G);if(m>1.0){k=0;p=23;break}if(u>0.0){r=ca*s+ea*x+da*t;if(r>=-1.4210854715202004e-14){k=0;p=23;break}m=m-u/r;u=(1.0-m)*+g[f+48>>2]+m*+g[h+48>>2];C=+g[d+48>>2]*(1.0-m)+m*+g[e+48>>2];B=(1.0-m)*+g[d+52>>2]+m*+g[e+52>>2];z=(1.0-m)*+g[d+56>>2]+m*+g[e+56>>2];y=(1.0-m)*+g[f+52>>2]+m*+g[h+52>>2];r=(1.0-m)*+g[f+56>>2]+m*+g[h+56>>2];o=s;n=x;q=t}else{u=D;l=A}v=c[b+4>>2]|0;w=c[v>>2]|0;if((w|0)>0){t=+g[v+308>>2];k=0;p=0;do{x=F-E-+g[v+(p<<4)+4>>2];A=J-I-+g[v+(p<<4)+8>>2];D=H-G-+g[v+(p<<4)+12>>2];k=k|x*x+A*A+D*D<=t;p=p+1|0}while((p|0)!=(w|0))}else k=0;if((+g[v+304>>2]==0.0?H-G==+g[v+300>>2]:0)?J-I==+g[v+296>>2]:0)p=F-E==+g[v+292>>2];else p=0;if(!(p|k)){g[v+292>>2]=F-E;g[v+296>>2]=J-I;g[v+300>>2]=H-G;g[v+304>>2]=0.0;a[v+356>>0]=1;g[v+(w<<4)+4>>2]=F-E;g[v+(w<<4)+8>>2]=J-I;g[v+(w<<4)+12>>2]=H-G;g[v+(w<<4)+16>>2]=0.0;p=c[v>>2]|0;g[v+(p<<4)+84>>2]=F;g[v+(p<<4)+88>>2]=J;g[v+(p<<4)+92>>2]=H;g[v+(p<<4)+96>>2]=0.0;p=c[v>>2]|0;g[v+(p<<4)+164>>2]=E;g[v+(p<<4)+168>>2]=I;g[v+(p<<4)+172>>2]=G;g[v+(p<<4)+176>>2]=0.0;c[v>>2]=(c[v>>2]|0)+1;v=c[b+4>>2]|0}p=qD(v)|0;s=+g[v+276>>2];x=+g[v+280>>2];t=+g[v+284>>2];if(!p)break a;if(!(s*s+x*x+t*t>9.999999747378752e-05))break a;else{D=u;A=l;l=+g[v+288>>2]}}if((p|0)==23){i=fa;return k|0}}else{m=0.0;o=0.0;l=0.0;n=0.0;q=0.0}while(0);g[j+164>>2]=m;m=q*q+(n*n+o*o);if(!(m>=1.4210854715202004e-14)){o=0.0;n=0.0;m=0.0;l=0.0}else{m=1.0/+P(+m);o=o*m;n=n*m;m=q*m}g[j+132>>2]=o;g[j+136>>2]=n;g[j+140>>2]=m;g[j+144>>2]=l;if(ca*o+ea*n+da*m>=-+g[j+172>>2]){e=0;i=fa;return e|0}e=c[b+4>>2]|0;qD(e)|0;ZE(j+148|0,e+260|0,16)|0;e=1;i=fa;return e|0}function RC(a){a=a|0;var b=0;b=i;RE(a);i=b;return}function SC(b,e,f,h,j,k,l,m,n,o){b=b|0;e=e|0;f=f|0;h=h|0;j=j|0;k=k|0;l=l|0;m=m|0;n=n|0;o=o|0;var p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0,z=0.0,A=0.0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0.0,O=0.0,Q=0.0,R=0.0,S=0.0,T=0.0,U=0.0,V=0.0,W=0.0,X=0.0,Y=0.0,Z=0.0;M=i;i=i+10240|0;V=+g[k+52>>2]-+g[j+52>>2];v=+g[k+56>>2]-+g[j+56>>2];g[M>>2]=+g[k+48>>2]-+g[j+48>>2];g[M+4>>2]=V;g[M+8>>2]=v;g[M+12>>2]=0.0;c[M+10088>>2]=f;c[M+10092>>2]=h;v=+g[k>>2];V=+g[j>>2];u=+g[k+16>>2];s=+g[j+16>>2];t=+g[k+32>>2];W=+g[j+32>>2];r=+g[j+4>>2];X=+g[j+20>>2];N=+g[j+36>>2];p=+g[j+8>>2];z=+g[j+24>>2];w=+g[j+40>>2];U=+g[k+4>>2];T=+g[k+20>>2];S=+g[k+36>>2];R=+g[k+8>>2];Q=+g[k+24>>2];O=+g[k+40>>2];g[M+10096>>2]=v*V+u*s+t*W;g[M+10100>>2]=v*r+u*X+t*N;g[M+10104>>2]=v*p+u*z+t*w;g[M+10108>>2]=0.0;g[M+10112>>2]=V*U+s*T+W*S;g[M+10116>>2]=r*U+X*T+N*S;g[M+10120>>2]=p*U+z*T+w*S;g[M+10124>>2]=0.0;g[M+10128>>2]=V*R+s*Q+W*O;g[M+10132>>2]=r*R+X*Q+N*O;g[M+10136>>2]=p*R+z*Q+w*O;g[M+10140>>2]=0.0;w=+g[k+48>>2]-+g[j+48>>2];z=+g[k+52>>2]-+g[j+52>>2];p=+g[k+56>>2]-+g[j+56>>2];N=+g[j>>2];X=+g[k>>2];r=+g[j+16>>2];W=+g[k+16>>2];s=+g[j+32>>2];V=+g[k+32>>2];t=+g[j+4>>2];u=+g[j+20>>2];v=+g[j+36>>2];x=+g[j+8>>2];A=+g[j+24>>2];q=+g[j+40>>2];g[M+10144>>2]=N*X+r*W+s*V;g[M+10148>>2]=N*U+r*T+s*S;g[M+10152>>2]=N*R+r*Q+s*O;g[M+10156>>2]=0.0;g[M+10160>>2]=X*t+W*u+V*v;g[M+10164>>2]=U*t+T*u+S*v;g[M+10168>>2]=R*t+Q*u+O*v;g[M+10172>>2]=0.0;g[M+10176>>2]=X*x+W*A+V*q;g[M+10180>>2]=U*x+T*A+S*q;g[M+10184>>2]=R*x+Q*A+O*q;g[M+10188>>2]=0.0;g[M+10192>>2]=w*N+z*r+p*s;g[M+10196>>2]=w*t+z*u+p*v;g[M+10200>>2]=w*x+z*A+p*q;g[M+10204>>2]=0.0;c[M+10208>>2]=71;c[M+10212>>2]=0;c[M+10072>>2]=0;c[M+9836>>2]=0;c[M+9840>>2]=0;c[M+9844>>2]=0;c[M+9848>>2]=0;c[M+10084>>2]=2;c[M+10076>>2]=0;g[M+9852>>2]=0.0;q=+g[M>>2];p=+g[M+4>>2];A=+g[M+8>>2];g[M+9328>>2]=-q;g[M+9332>>2]=-p;g[M+9336>>2]=-A;g[M+9340>>2]=0.0;do if((hD(M+9708|0,M+10088|0,M+9328|0)|0)==1){J=M+9296|0;I=M+9304|0;H=M+9308|0;c[J+0>>2]=0;c[J+4>>2]=0;c[J+8>>2]=0;c[J+12>>2]=0;c[M+16>>2]=9;L=M+56|0;c[M+9292>>2]=0;c[L+0>>2]=0;c[L+4>>2]=0;c[L+8>>2]=0;c[L+12>>2]=0;c[L+16>>2]=0;e=0;do{o=128-e+-1|0;c[M+16+(o*56|0)+2152>>2]=0;b=c[I>>2]|0;c[M+16+(o*56|0)+2156>>2]=b;if(b)c[b+44>>2]=M+16+(o*56|0)+2108;c[I>>2]=M+16+(o*56|0)+2108;c[H>>2]=(c[H>>2]|0)+1;e=e+1|0}while((e|0)!=128);F=c[M+10080>>2]|0;if((c[F+32>>2]|0)>>>0>1?mD(M+9708|0)|0:0){b=c[J>>2]|0;if(b){B=c[M+9300>>2]|0;C=c[H>>2]|0;do{e=b+48|0;y=c[e>>2]|0;o=b+44|0;if(y)c[y+44>>2]=c[o>>2];y=c[o>>2]|0;if(y)c[y+48>>2]=c[e>>2];if((c[J>>2]|0)==(b|0))c[J>>2]=c[e>>2];B=B+-1|0;c[o>>2]=0;c[e>>2]=c[I>>2];y=c[I>>2]|0;if(y)c[y+44>>2]=b;c[I>>2]=b;C=C+1|0;b=c[J>>2]|0}while((b|0)!=0);c[M+9300>>2]=B;c[H>>2]=C}c[M+16>>2]=0;c[M+9292>>2]=0;b=c[F>>2]|0;y=c[F+12>>2]|0;z=+g[y+16>>2];s=+g[b+16>>2]-z;u=+g[y+20>>2];v=+g[b+20>>2]-u;N=+g[y+24>>2];x=+g[b+24>>2]-N;y=c[F+4>>2]|0;w=+g[y+16>>2]-z;Q=+g[y+20>>2]-u;t=+g[y+24>>2]-N;e=c[F+8>>2]|0;z=+g[e+16>>2]-z;u=+g[e+20>>2]-u;N=+g[e+24>>2]-N;if(s*Q*N+(v*t*z+x*w*u-s*t*u-v*w*N)-x*Q*z<0.0){c[F>>2]=y;c[F+4>>2]=b;z=+g[F+16>>2];g[F+16>>2]=+g[F+20>>2];g[F+20>>2]=z;o=y}else{o=b;b=y}C=kD(M+16|0,o,b,e,1)|0;B=kD(M+16|0,c[F+4>>2]|0,c[F>>2]|0,c[F+12>>2]|0,1)|0;D=kD(M+16|0,c[F+8>>2]|0,c[F+4>>2]|0,c[F+12>>2]|0,1)|0;E=kD(M+16|0,c[F>>2]|0,c[F+8>>2]|0,c[F+12>>2]|0,1)|0;if((c[M+9300>>2]|0)==4){e=c[J>>2]|0;u=+g[e+16>>2];b=c[e+48>>2]|0;if(b){p=u*u;o=e;while(1){A=+g[b+16>>2];y=A*A<p;o=y?b:o;b=c[b+48>>2]|0;if(!b)break;else p=y?A*A:p}e=o;u=+g[o+16>>2]}q=+g[e>>2];p=+g[e+4>>2];A=+g[e+8>>2];x=+g[e+12>>2];y=c[e+20>>2]|0;o=c[e+24>>2]|0;F=c[e+28>>2]|0;a[C+52>>0]=0;c[C+32>>2]=B;a[B+52>>0]=0;c[B+32>>2]=C;a[C+53>>0]=0;c[C+36>>2]=D;a[D+52>>0]=1;c[D+32>>2]=C;a[C+54>>0]=0;c[C+40>>2]=E;a[E+52>>0]=2;c[E+32>>2]=C;a[B+53>>0]=2;c[B+36>>2]=E;a[E+54>>0]=1;c[E+40>>2]=B;a[B+54>>0]=1;c[B+40>>2]=D;a[D+53>>0]=2;c[D+36>>2]=B;a[D+54>>0]=1;c[D+40>>2]=E;a[E+53>>0]=2;c[E+36>>2]=D;c[M+16>>2]=0;G=0;E=y;D=o;C=F;F=1;while(1){B=c[M+9292>>2]|0;if(B>>>0>=64){K=47;break}c[M+10216>>2]=0;c[M+10220>>2]=0;c[M+10224>>2]=0;c[M+9292>>2]=B+1;a[e+55>>0]=F;y=e+4|0;o=e+8|0;jD(M+9708|0,+g[e>>2],+g[y>>2],+g[o>>2],M+16+(B<<5)+60|0);if(+g[e>>2]*+g[M+16+(B<<5)+76>>2]+ +g[y>>2]*+g[M+16+(B<<5)+80>>2]+ +g[o>>2]*+g[M+16+(B<<5)+84>>2]-+g[e+16>>2]>9.999999747378752e-05){b=0;y=1}else{K=46;break}do{y=y&(iD(M+16|0,F,M+16+(B<<5)+60|0,c[e+(b<<2)+32>>2]|0,d[e+b+52>>0]|0,M+10216|0)|0);b=b+1|0}while(!(b>>>0>2|y^1));if(!(y&(c[M+10224>>2]|0)>>>0>2)){K=45;break}b=c[M+10216>>2]|0;o=c[M+10220>>2]|0;a[b+53>>0]=2;c[b+36>>2]=o;a[o+54>>0]=1;c[o+40>>2]=b;o=e+48|0;b=c[o>>2]|0;y=e+44|0;if(b)c[b+44>>2]=c[y>>2];b=c[y>>2]|0;if(b)c[b+48>>2]=c[o>>2];if((c[J>>2]|0)==(e|0))c[J>>2]=c[o>>2];c[M+9300>>2]=(c[M+9300>>2]|0)+-1;c[y>>2]=0;c[o>>2]=c[I>>2];b=c[I>>2]|0;if(b)c[b+44>>2]=e;c[I>>2]=e;c[H>>2]=(c[H>>2]|0)+1;e=c[J>>2]|0;u=+g[e+16>>2];b=c[e+48>>2]|0;if(b){w=u*u;o=e;while(1){x=+g[b+16>>2];y=x*x<w;o=y?b:o;b=c[b+48>>2]|0;if(!b)break;else w=y?x*x:w}e=o;u=+g[o+16>>2]}q=+g[e>>2];p=+g[e+4>>2];A=+g[e+8>>2];x=+g[e+12>>2];B=c[e+20>>2]|0;b=c[e+24>>2]|0;C=c[e+28>>2]|0;G=G+1|0;if(G>>>0>=255)break;else{E=B;D=b;F=F+1|0}}if((K|0)==45){c[M+16>>2]=4;B=E;b=D}else if((K|0)==46){c[M+16>>2]=7;B=E;b=D}else if((K|0)==47){c[M+16>>2]=6;B=E;b=D}w=u*q;r=u*p;s=u*A;g[L>>2]=q;g[M+60>>2]=p;g[M+64>>2]=A;g[M+68>>2]=x;g[M+72>>2]=u;c[M+52>>2]=3;c[M+20>>2]=B;c[M+24>>2]=b;c[M+28>>2]=C;J=b+16|0;N=+g[J>>2]-w;H=b+20|0;u=+g[H>>2]-r;I=b+24|0;v=+g[I>>2]-s;o=C+16|0;x=+g[o>>2]-w;e=C+20|0;t=+g[e>>2]-r;y=C+24|0;Q=+g[y>>2]-s;Q=+P(+((N*t-u*x)*(N*t-u*x)+((u*Q-v*t)*(u*Q-v*t)+(v*x-N*Q)*(v*x-N*Q))));g[M+36>>2]=Q;N=+g[o>>2]-w;x=+g[e>>2]-r;v=+g[y>>2]-s;y=B+16|0;t=+g[y>>2]-w;e=B+20|0;u=+g[e>>2]-r;o=B+24|0;z=+g[o>>2]-s;z=+P(+((N*u-x*t)*(N*u-x*t)+((x*z-v*u)*(x*z-v*u)+(v*t-N*z)*(v*t-N*z))));g[M+40>>2]=z;N=+g[y>>2]-w;t=+g[e>>2]-r;v=+g[o>>2]-s;w=+g[J>>2]-w;u=+g[H>>2]-r;x=+g[I>>2]-s;x=+P(+((N*u-t*w)*(N*u-t*w)+((t*x-v*u)*(t*x-v*u)+(v*w-N*x)*(v*w-N*x))));g[M+36>>2]=Q/(x+(Q+z));g[M+40>>2]=z/(x+(Q+z));g[M+44>>2]=x/(x+(Q+z));if((c[M+16>>2]|0)==9){x=0.0;w=0.0;v=0.0;r=0.0;q=0.0;p=0.0;z=0.0;A=0.0;u=0.0;b=0;break}if(!(c[M+52>>2]|0)){t=0.0;s=0.0;u=0.0}else{o=M+52|0;K=53}}else K=48}else K=48;if((K|0)==48){c[M+16>>2]=8;g[L>>2]=q;g[M+60>>2]=p;g[M+64>>2]=A;g[M+68>>2]=0.0;t=+P(+(q*q+p*p+A*A));if(t>0.0){r=1.0/t*A;s=1.0/t*p;q=1.0/t*q}else{r=0.0;s=0.0;q=1.0}g[L>>2]=q;g[M+60>>2]=s;g[M+64>>2]=r;g[M+68>>2]=0.0;g[M+72>>2]=0.0;c[M+52>>2]=1;c[M+20>>2]=c[F>>2];g[M+36>>2]=1.0;o=M+52|0;K=53}if((K|0)==53){y=0;t=0.0;s=0.0;u=0.0;do{b=c[M+10208>>2]|0;I=c[M+10212>>2]|0;e=(c[M+10088>>2]|0)+(I>>1)|0;if(I&1)b=c[(c[e>>2]|0)+b>>2]|0;pc[b&127](M+9312|0,e,c[M+16+(y<<2)+4>>2]|0);z=+g[M+16+(y<<2)+20>>2];t=t+ +g[M+9312>>2]*z;u=u+z*+g[M+9316>>2];s=s+z*+g[M+9320>>2];y=y+1|0}while(y>>>0<(c[o>>2]|0)>>>0)}X=+g[j>>2];W=+g[j+4>>2];V=+g[j+8>>2];O=+g[j+16>>2];R=+g[j+20>>2];N=+g[j+24>>2];U=+g[j+32>>2];T=+g[j+36>>2];S=+g[j+40>>2];z=+g[j+48>>2];Q=+g[j+52>>2];A=+g[j+56>>2];r=+g[L>>2];v=+g[M+72>>2];q=+g[M+60>>2];p=+g[M+64>>2];Z=t-r*v;Y=u-v*q;v=s-v*p;x=Z*X+Y*W+v*V+z;w=Z*O+Y*R+v*N+Q;v=Z*U+Y*T+v*S+A;r=-r;q=-q;p=-p;z=t*X+u*W+s*V+z;A=t*U+u*T+s*S+A;u=t*O+u*R+s*N+Q;b=1}else{x=0.0;w=0.0;v=0.0;r=0.0;q=0.0;p=0.0;z=0.0;A=0.0;u=0.0;b=0}while(0);if(b){g[m>>2]=z;g[m+4>>2]=u;g[m+8>>2]=A;g[m+12>>2]=0.0;g[n>>2]=x;g[n+4>>2]=w;g[n+8>>2]=v;g[n+12>>2]=0.0;g[l>>2]=r;g[l+4>>2]=q;g[l+8>>2]=p;g[l+12>>2]=0.0;m=1;i=M;return m|0}c[M+9708>>2]=f;c[M+9712>>2]=h;Q=+g[k>>2];q=+g[j>>2];x=+g[k+16>>2];p=+g[j+16>>2];N=+g[k+32>>2];A=+g[j+32>>2];R=+g[j+4>>2];O=+g[j+20>>2];S=+g[j+36>>2];U=+g[j+8>>2];W=+g[j+24>>2];Y=+g[j+40>>2];w=+g[k+4>>2];v=+g[k+20>>2];u=+g[k+36>>2];t=+g[k+8>>2];s=+g[k+24>>2];r=+g[k+40>>2];g[M+9716>>2]=Q*q+x*p+N*A;g[M+9720>>2]=Q*R+x*O+N*S;g[M+9724>>2]=Q*U+x*W+N*Y;g[M+9728>>2]=0.0;g[M+9732>>2]=q*w+p*v+A*u;g[M+9736>>2]=R*w+O*v+S*u;g[M+9740>>2]=U*w+W*v+Y*u;g[M+9744>>2]=0.0;g[M+9748>>2]=q*t+p*s+A*r;g[M+9752>>2]=R*t+O*s+S*r;g[M+9756>>2]=U*t+W*s+Y*r;g[M+9760>>2]=0.0;T=+g[k+48>>2]-+g[j+48>>2];V=+g[k+52>>2]-+g[j+52>>2];X=+g[k+56>>2]-+g[j+56>>2];g[M+9764>>2]=Q*q+x*p+N*A;g[M+9768>>2]=q*w+p*v+A*u;g[M+9772>>2]=q*t+p*s+A*r;g[M+9776>>2]=0.0;g[M+9780>>2]=Q*R+x*O+N*S;g[M+9784>>2]=R*w+O*v+S*u;g[M+9788>>2]=R*t+O*s+S*r;g[M+9792>>2]=0.0;g[M+9796>>2]=Q*U+x*W+N*Y;g[M+9800>>2]=U*w+W*v+Y*u;g[M+9804>>2]=U*t+W*s+Y*r;g[M+9808>>2]=0.0;g[M+9812>>2]=T*q+V*p+X*A;g[M+9816>>2]=T*R+V*O+X*S;g[M+9820>>2]=T*U+V*W+X*Y;g[M+9824>>2]=0.0;c[M+9828>>2]=72;c[M+9832>>2]=0;c[M+9692>>2]=0;c[M+9456>>2]=0;c[M+9460>>2]=0;c[M+9464>>2]=0;c[M+9468>>2]=0;c[M+9704>>2]=2;c[M+9696>>2]=0;g[M+9472>>2]=0.0;if(hD(M+9328|0,M+9708|0,M)|0){m=0;i=M;return m|0}o=c[M+9700>>2]|0;if(!(c[o+32>>2]|0)){u=0.0;t=0.0;s=0.0;r=0.0;q=0.0;p=0.0}else{C=0;u=0.0;t=0.0;s=0.0;r=0.0;q=0.0;p=0.0;do{A=+g[o+(C<<2)+16>>2];b=c[M+9828>>2]|0;k=c[M+9832>>2]|0;e=(c[M+9708>>2]|0)+(k>>1)|0;if(k&1)b=c[(c[e>>2]|0)+b>>2]|0;pc[b&127](M+9312|0,e,c[o+(C<<2)>>2]|0);u=u+A*+g[M+9312>>2];s=s+A*+g[M+9316>>2];t=t+A*+g[M+9320>>2];b=c[(c[M+9700>>2]|0)+(C<<2)>>2]|0;v=-+g[b>>2];w=-+g[b+4>>2];x=-+g[b+8>>2];b=c[M+9828>>2]|0;k=c[M+9832>>2]|0;e=(c[M+9712>>2]|0)+(k>>1)|0;if(k&1)b=c[(c[e>>2]|0)+b>>2]|0;X=+g[M+9732>>2]*v+ +g[M+9736>>2]*w+ +g[M+9740>>2]*x;W=+g[M+9748>>2]*v+ +g[M+9752>>2]*w+ +g[M+9756>>2]*x;g[M+10088>>2]=+g[M+9716>>2]*v+ +g[M+9720>>2]*w+ +g[M+9724>>2]*x;g[M+10092>>2]=X;g[M+10096>>2]=W;g[M+10100>>2]=0.0;pc[b&127](M+10216|0,e,M+10088|0);W=+g[M+10216>>2];X=+g[M+10220>>2];Y=+g[M+10224>>2];r=r+A*(W*+g[M+9764>>2]+X*+g[M+9768>>2]+Y*+g[M+9772>>2]+ +g[M+9812>>2]);p=p+A*(W*+g[M+9780>>2]+X*+g[M+9784>>2]+Y*+g[M+9788>>2]+ +g[M+9816>>2]);q=q+A*(W*+g[M+9796>>2]+X*+g[M+9800>>2]+Y*+g[M+9804>>2]+ +g[M+9820>>2]);C=C+1|0;o=c[M+9700>>2]|0}while(C>>>0<(c[o+32>>2]|0)>>>0)}z=+g[j>>2];Q=+g[j+4>>2];x=+g[j+8>>2];w=+g[j+16>>2];v=+g[j+20>>2];A=+g[j+24>>2];O=+g[j+32>>2];S=+g[j+36>>2];T=+g[j+40>>2];N=+g[j+48>>2];R=+g[j+52>>2];U=+g[j+56>>2];V=u-r;W=s-p;Y=t-q;X=+P(+(V*V+W*W+Y*Y));X=X>9.999999747378752e-05?1.0/X:1.0;g[m>>2]=u*z+s*Q+t*x+N;g[m+4>>2]=u*w+s*v+t*A+R;g[m+8>>2]=u*O+s*S+t*T+U;g[m+12>>2]=0.0;g[n>>2]=r*z+p*Q+q*x+N;g[n+4>>2]=r*w+p*v+q*A+R;g[n+8>>2]=r*O+p*S+q*T+U;g[n+12>>2]=0.0;g[l>>2]=X*V;g[l+4>>2]=X*W;g[l+8>>2]=X*Y;g[l+12>>2]=0.0;m=0;i=M;return m|0}function TC(a){a=a|0;var b=0;b=i;RE(a);i=b;return}function UC(b,d,e,f,h,j){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;var k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0,r=0.0,s=0.0,t=0.0,u=0,v=0;u=i;i=i+288|0;v=c[b+4>>2]|0;a[v+312>>0]=0;c[v>>2]=0;a[v+356>>0]=1;g[v+292>>2]=999999984306749440.0;g[v+296>>2]=999999984306749440.0;g[v+300>>2]=999999984306749440.0;g[v+304>>2]=0.0;c[v+336>>2]=0;c[v+340>>2]=0;c[v+344>>2]=0;c[v+348>>2]=0;a[v+352>>0]=0;a[v+332>>0]=a[v+332>>0]&-16;r=+g[e+48>>2]-+g[d+48>>2]-(+g[h+48>>2]-+g[f+48>>2]);t=+g[e+52>>2]-+g[d+52>>2]-(+g[h+52>>2]-+g[f+52>>2]);s=+g[e+56>>2]-+g[d+56>>2]-(+g[h+56>>2]-+g[f+56>>2]);c[u+216>>2]=19192;g[u+252>>2]=999999984306749440.0;a[u+256>>0]=0;v=c[b+8>>2]|0;q=c[b+12>>2]|0;b=c[b+4>>2]|0;c[u+136>>2]=19400;g[u+140>>2]=0.0;g[u+144>>2]=1.0;g[u+148>>2]=0.0;g[u+152>>2]=0.0;c[u+156>>2]=0;c[u+160>>2]=b;c[u+164>>2]=v;c[u+168>>2]=q;c[u+172>>2]=c[v+4>>2];c[u+176>>2]=c[q+4>>2];g[u+180>>2]=+Zb[c[(c[v>>2]|0)+48>>2]&15](v);g[u+184>>2]=+Zb[c[(c[q>>2]|0)+48>>2]&15](q);a[u+188>>0]=0;c[u+196>>2]=-1;c[u+208>>2]=1;c[u+212>>2]=1;g[u+128>>2]=999999984306749440.0;c[u+0>>2]=c[d+0>>2];c[u+4>>2]=c[d+4>>2];c[u+8>>2]=c[d+8>>2];c[u+12>>2]=c[d+12>>2];c[u+16>>2]=c[d+16>>2];c[u+20>>2]=c[d+20>>2];c[u+24>>2]=c[d+24>>2];c[u+28>>2]=c[d+28>>2];c[u+32>>2]=c[d+32>>2];c[u+36>>2]=c[d+36>>2];c[u+40>>2]=c[d+40>>2];c[u+44>>2]=c[d+44>>2];c[u+48>>2]=c[d+48>>2];c[u+52>>2]=c[d+52>>2];c[u+56>>2]=c[d+56>>2];c[u+60>>2]=c[d+60>>2];c[u+64>>2]=c[f+0>>2];c[u+68>>2]=c[f+4>>2];c[u+72>>2]=c[f+8>>2];c[u+76>>2]=c[f+12>>2];c[u+80>>2]=c[f+16>>2];c[u+84>>2]=c[f+20>>2];c[u+88>>2]=c[f+24>>2];c[u+92>>2]=c[f+28>>2];c[u+96>>2]=c[f+32>>2];c[u+100>>2]=c[f+36>>2];c[u+104>>2]=c[f+40>>2];c[u+108>>2]=c[f+44>>2];c[u+112>>2]=c[f+48>>2];c[u+116>>2]=c[f+52>>2];c[u+120>>2]=c[f+56>>2];c[u+124>>2]=c[f+60>>2];eD(u+136|0,u,u+216|0,0,0);b=(a[u+256>>0]|0)==0;q=u+236|0;c[u+264>>2]=c[q+0>>2];c[u+268>>2]=c[q+4>>2];c[u+272>>2]=c[q+8>>2];c[u+276>>2]=c[q+12>>2];if(b){b=0;i=u;return b|0}n=+g[u+252>>2];p=+g[u+220>>2];k=+g[u+224>>2];m=+g[u+228>>2];l=+g[u+232>>2];do if(n>1.0000000474974513e-03){o=0.0;b=1;while(1){if((b|0)>32){b=0;d=13;break}l=o;o=o-n/(s*m+(t*k+r*p));if(!(!(o<0.0)&!(o>1.0)&!(o<=l))){b=0;d=13;break}Ib[c[c[j>>2]>>2]&31](j,o);k=1.0-o;g[u+48>>2]=k*+g[d+48>>2]+o*+g[e+48>>2];g[u+52>>2]=k*+g[d+52>>2]+o*+g[e+52>>2];g[u+56>>2]=k*+g[d+56>>2]+o*+g[e+56>>2];g[u+112>>2]=k*+g[f+48>>2]+o*+g[h+48>>2];g[u+116>>2]=k*+g[f+52>>2]+o*+g[h+52>>2];g[u+120>>2]=k*+g[f+56>>2]+o*+g[h+56>>2];eD(u+136|0,u,u+216|0,0,0);if(!(a[u+256>>0]|0)){b=0;d=13;break}n=+g[u+252>>2];if(n<0.0){d=8;break};c[u+264>>2]=c[q+0>>2];c[u+268>>2]=c[q+4>>2];c[u+272>>2]=c[q+8>>2];c[u+276>>2]=c[q+12>>2];p=+g[u+220>>2];k=+g[u+224>>2];m=+g[u+228>>2];if(!(n>1.0000000474974513e-03)){d=10;break}else b=b+1|0}if((d|0)==8){g[j+164>>2]=o;r=+g[u+224>>2];l=+g[u+228>>2];k=+g[u+232>>2];g[j+132>>2]=+g[u+220>>2];g[j+136>>2]=r;g[j+140>>2]=l;g[j+144>>2]=k;c[j+148>>2]=c[q+0>>2];c[j+152>>2]=c[q+4>>2];c[j+156>>2]=c[q+8>>2];c[j+160>>2]=c[q+12>>2];b=1;i=u;return b|0}else if((d|0)==10){n=p;l=+g[u+232>>2];break}else if((d|0)==13){i=u;return b|0}}else{o=0.0;n=p}while(0);if(s*m+(t*k+r*n)>=-+g[j+172>>2]){b=0;i=u;return b|0}g[j+164>>2]=o;g[j+132>>2]=n;g[j+136>>2]=k;g[j+140>>2]=m;g[j+144>>2]=l;c[j+148>>2]=c[u+264>>2];c[j+152>>2]=c[u+268>>2];c[j+156>>2]=c[u+272>>2];c[j+160>>2]=c[u+276>>2];b=1;i=u;return b|0}function VC(a){a=a|0;var b=0;b=i;RE(a);i=b;return}function WC(b,d,e,f){b=b|0;d=d|0;e=e|0;f=+f;var h=0;h=i;if(!(+g[b+36>>2]>f)){i=h;return}a[b+40>>0]=1;c[b+4>>2]=c[d+0>>2];c[b+8>>2]=c[d+4>>2];c[b+12>>2]=c[d+8>>2];c[b+16>>2]=c[d+12>>2];c[b+20>>2]=c[e+0>>2];c[b+24>>2]=c[e+4>>2];c[b+28>>2]=c[e+8>>2];c[b+32>>2]=c[e+12>>2];g[b+36>>2]=f;i=h;return}function XC(a,b,c){a=a|0;b=b|0;c=c|0;return}function YC(a,b,c){a=a|0;b=b|0;c=c|0;return}function ZC(a){a=a|0;var b=0;b=i;RE(a);i=b;return}function _C(a){a=a|0;return}function $C(a,b,c,d,e,f,h,j,k,l,m){a=a|0;b=b|0;c=+c;d=+d;e=+e;f=+f;h=+h;j=+j;k=k|0;l=l|0;m=+m;var n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0;z=i;x=+g[a>>2]*f+ +g[a+16>>2]*h+ +g[a+32>>2]*j;y=+g[a+4>>2]*f+ +g[a+20>>2]*h+ +g[a+36>>2]*j;w=+g[a+8>>2]*f+ +g[a+24>>2]*h+ +g[a+40>>2]*j;u=+g[b>>2]*f+ +g[b+16>>2]*h+ +g[b+32>>2]*j;v=+g[b+4>>2]*f+ +g[b+20>>2]*h+ +g[b+36>>2]*j;t=+g[b+8>>2]*f+ +g[b+24>>2]*h+ +g[b+40>>2]*j;n=+g[k+80>>2];if(x<0.0)n=-n;o=+g[k+84>>2];if(y<0.0)o=-o;p=+g[k+88>>2];if(w<0.0)p=-p;q=+g[l+80>>2];if(u<0.0)q=-q;r=+g[l+84>>2];if(v<0.0)r=-r;s=+g[l+88>>2];if(!(t<0.0)){n=x*n;o=y*o;o=n+o;w=w*p;w=o+w;u=u*q;v=v*r;v=u+v;u=t*s;u=v+u;a=k+96|0;v=+g[a>>2];a=w>v;v=a?w:v;a=l+96|0;w=+g[a>>2];a=u>w;w=a?u:w;w=v+w;v=c*f+d*h+e*j+w;w=w-(c*f+d*h+e*j);a=v<w;w=a?v:w;a=!(w>m);i=z;return a|0}s=-s;n=x*n;o=y*o;o=n+o;w=w*p;w=o+w;u=u*q;v=v*r;v=u+v;u=t*s;u=v+u;a=k+96|0;v=+g[a>>2];a=w>v;v=a?w:v;a=l+96|0;w=+g[a>>2];a=u>w;w=a?u:w;w=v+w;v=c*f+d*h+e*j+w;w=w-(c*f+d*h+e*j);a=v<w;w=a?v:w;a=!(w>m);i=z;return a|0}
function Sr(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var h=0,j=0,k=0.0,l=0.0,m=0,n=0,o=0.0,p=0,q=0,r=0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0,N=0,Q=0,R=0.0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0,ca=0,da=0,ea=0;ea=i;i=i+80|0;if((e|0)<=0){i=ea;return}ba=0;do{W=c[d+(ba<<2)>>2]|0;Y=c[W+740>>2]|0;Z=c[W+744>>2]|0;$=Rr(b,Y,+g[f+12>>2])|0;aa=Rr(b,Z,+g[f+12>>2])|0;_=c[b+16>>2]|0;if(!(((((+g[_+($*244|0)+128>>2]==0.0?+g[_+($*244|0)+132>>2]==0.0:0)?+g[_+($*244|0)+136>>2]==0.0:0)?+g[_+(aa*244|0)+128>>2]==0.0:0)?+g[_+(aa*244|0)+132>>2]==0.0:0)?+g[_+(aa*244|0)+136>>2]==0.0:0))da=9;if((da|0)==9?(da=0,X=c[W+748>>2]|0,(X|0)>0):0){j=X;ca=0;h=1;do{T=W+(ca*184|0)+4|0;p=W+(ca*184|0)+84|0;if(+g[p>>2]<=+g[W+756>>2]){U=c[b+28>>2]|0;if((U|0)==(c[b+32>>2]|0)?(V=(U|0)==0?1:U<<1,(U|0)<(V|0)):0){if(!V){m=U;n=0}else{c[5108]=(c[5108]|0)+1;j=QE((V*152|3)+16|0)|0;if(!j)j=0;else{c[(j+19&-16)+-4>>2]=j;j=j+19&-16}m=c[b+28>>2]|0;n=j}if((m|0)>0){j=0;do{YE(n+(j*152|0)|0,(c[b+36>>2]|0)+(j*152|0)|0,152)|0;j=j+1|0}while((j|0)!=(m|0))}j=c[b+36>>2]|0;if(j){if(a[b+40>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[j+-4>>2]|0)}c[b+36>>2]=0}a[b+40>>0]=1;c[b+36>>2]=n;c[b+32>>2]=V;j=c[b+28>>2]|0}else j=U;c[b+28>>2]=j+1;S=c[b+36>>2]|0;m=(c[Y+236>>2]&2|0)==0?0:Y;j=(c[Z+236>>2]&2|0)==0?0:Z;c[S+(U*152|0)+144>>2]=$;c[S+(U*152|0)+148>>2]=aa;c[S+(U*152|0)+132>>2]=T;y=+g[W+(ca*184|0)+52>>2]-+g[Y+52>>2];C=+g[W+(ca*184|0)+56>>2]-+g[Y+56>>2];x=+g[W+(ca*184|0)+60>>2]-+g[Y+60>>2];g[ea+64>>2]=y;g[ea+68>>2]=C;g[ea+72>>2]=x;g[ea+76>>2]=0.0;E=+g[W+(ca*184|0)+36>>2]-+g[Z+52>>2];F=+g[W+(ca*184|0)+40>>2]-+g[Z+56>>2];D=+g[W+(ca*184|0)+44>>2]-+g[Z+60>>2];g[ea+48>>2]=E;g[ea+52>>2]=F;g[ea+56>>2]=D;g[ea+60>>2]=0.0;if(!(c[_+($*244|0)+240>>2]|0)){l=0.0;t=0.0;k=0.0}else{k=+g[_+($*244|0)+192>>2]+ +g[_+($*244|0)+224>>2];t=+g[_+($*244|0)+196>>2]+ +g[_+($*244|0)+228>>2];K=+g[_+($*244|0)+200>>2]+ +g[_+($*244|0)+232>>2];l=+g[_+($*244|0)+176>>2]+ +g[_+($*244|0)+208>>2]+(t*x-K*C);t=+g[_+($*244|0)+184>>2]+ +g[_+($*244|0)+216>>2]+(k*C-t*y);k=+g[_+($*244|0)+180>>2]+ +g[_+($*244|0)+212>>2]+(K*y-k*x)}if(!(c[_+(aa*244|0)+240>>2]|0)){o=0.0;u=0.0;s=0.0}else{s=+g[_+(aa*244|0)+192>>2]+ +g[_+(aa*244|0)+224>>2];u=+g[_+(aa*244|0)+196>>2]+ +g[_+(aa*244|0)+228>>2];K=+g[_+(aa*244|0)+200>>2]+ +g[_+(aa*244|0)+232>>2];o=+g[_+(aa*244|0)+176>>2]+ +g[_+(aa*244|0)+208>>2]+(u*D-K*F);u=+g[_+(aa*244|0)+184>>2]+ +g[_+(aa*244|0)+216>>2]+(s*F-u*E);s=+g[_+(aa*244|0)+180>>2]+ +g[_+(aa*244|0)+212>>2]+(K*E-s*D)}R=l-o;L=k-s;K=t-u;Q=W+(ca*184|0)+68|0;H=+g[Q>>2];N=W+(ca*184|0)+72|0;I=+g[N>>2];M=W+(ca*184|0)+76|0;J=+g[M>>2];n=c[b+16>>2]|0;r=c[n+($*244|0)+240>>2]|0;q=c[n+(aa*244|0)+240>>2]|0;if(r){A=((C*J-x*I)*+g[r+264>>2]+(x*H-J*y)*+g[r+268>>2]+(I*y-C*H)*+g[r+272>>2])*+g[r+544>>2];z=((C*J-x*I)*+g[r+280>>2]+(x*H-J*y)*+g[r+284>>2]+(I*y-C*H)*+g[r+288>>2])*+g[r+548>>2];k=((C*J-x*I)*+g[r+296>>2]+(x*H-J*y)*+g[r+300>>2]+(I*y-C*H)*+g[r+304>>2])*+g[r+552>>2]}else{A=0.0;z=0.0;k=0.0}g[S+(U*152|0)+64>>2]=A;g[S+(U*152|0)+68>>2]=z;g[S+(U*152|0)+72>>2]=k;g[S+(U*152|0)+76>>2]=0.0;w=+g[M>>2];o=+g[N>>2];s=+g[Q>>2];if(q){B=(+g[q+264>>2]*-(F*w-D*o)+ +g[q+268>>2]*-(D*s-w*E)+ +g[q+272>>2]*-(o*E-F*s))*+g[q+544>>2];v=(+g[q+280>>2]*-(F*w-D*o)+ +g[q+284>>2]*-(D*s-w*E)+ +g[q+288>>2]*-(o*E-F*s))*+g[q+548>>2];l=(+g[q+296>>2]*-(F*w-D*o)+ +g[q+300>>2]*-(D*s-w*E)+ +g[q+304>>2]*-(o*E-F*s))*+g[q+552>>2]}else{B=0.0;v=0.0;l=0.0}g[S+(U*152|0)+80>>2]=B;g[S+(U*152|0)+84>>2]=v;g[S+(U*152|0)+88>>2]=l;g[S+(U*152|0)+92>>2]=0.0;if(r)A=+g[r+344>>2]+((z*x-k*C)*+g[Q>>2]+(k*y-x*A)*+g[N>>2]+(C*A-z*y)*+g[M>>2]);else A=0.0;if(q){G=-B;u=-v;B=-l;u=+g[q+344>>2]+((D*u-F*B)*+g[Q>>2]+(E*B-D*G)*+g[N>>2]+(F*G-E*u)*+g[M>>2])}else u=0.0;g[S+(U*152|0)+108>>2]=1.0/(A+u);if(r){c[S+(U*152|0)+16>>2]=c[Q+0>>2];c[S+(U*152|0)+20>>2]=c[Q+4>>2];c[S+(U*152|0)+24>>2]=c[Q+8>>2];c[S+(U*152|0)+28>>2]=c[Q+12>>2];g[S+(U*152|0)>>2]=C*J-x*I;g[S+(U*152|0)+4>>2]=x*H-J*y;g[S+(U*152|0)+8>>2]=I*y-C*H;g[S+(U*152|0)+12>>2]=0.0}else{c[S+(U*152|0)+0>>2]=0;c[S+(U*152|0)+4>>2]=0;c[S+(U*152|0)+8>>2]=0;c[S+(U*152|0)+12>>2]=0;c[S+(U*152|0)+16>>2]=0;c[S+(U*152|0)+20>>2]=0;c[S+(U*152|0)+24>>2]=0;c[S+(U*152|0)+28>>2]=0}if(q){B=-+g[N>>2];G=-+g[M>>2];g[S+(U*152|0)+48>>2]=-+g[Q>>2];g[S+(U*152|0)+52>>2]=B;g[S+(U*152|0)+56>>2]=G;g[S+(U*152|0)+60>>2]=0.0;g[S+(U*152|0)+32>>2]=-(F*w-D*o);g[S+(U*152|0)+36>>2]=-(D*s-w*E);g[S+(U*152|0)+40>>2]=-(o*E-F*s);g[S+(U*152|0)+44>>2]=0.0}else{c[S+(U*152|0)+32>>2]=0;c[S+(U*152|0)+36>>2]=0;c[S+(U*152|0)+40>>2]=0;c[S+(U*152|0)+44>>2]=0;c[S+(U*152|0)+48>>2]=0;c[S+(U*152|0)+52>>2]=0;c[S+(U*152|0)+56>>2]=0;c[S+(U*152|0)+60>>2]=0}G=+g[p>>2]+ +g[f+56>>2];if(r){o=+g[r+332>>2];A=+g[r+336>>2];B=+g[r+328>>2];z=o*x-A*C+ +g[r+312>>2];A=+g[r+316>>2]+(A*y-x*B);o=C*B-o*y+ +g[r+320>>2]}else{z=0.0;A=0.0;o=0.0}if(q){u=+g[q+332>>2];t=+g[q+336>>2];C=+g[q+328>>2];s=u*D-t*F+ +g[q+312>>2];t=+g[q+316>>2]+(t*E-D*C);u=F*C-u*E+ +g[q+320>>2]}else{s=0.0;t=0.0;u=0.0}B=+g[Q>>2]*(z-s)+(A-t)*+g[N>>2]+(o-u)*+g[M>>2];g[S+(U*152|0)+104>>2]=+g[W+(ca*184|0)+88>>2];B=B*+g[W+(ca*184|0)+96>>2];B=!(B>=-0.0)?-B:0.0;do if(!(c[f+64>>2]&4))g[S+(U*152|0)+100>>2]=0.0;else{u=+g[W+(ca*184|0)+124>>2]*+g[f+60>>2];g[S+(U*152|0)+100>>2]=u;do if(r){if(!(c[n+($*244|0)+240>>2]|0))break;F=u*(+g[S+(U*152|0)+20>>2]*+g[n+($*244|0)+132>>2]*+g[r+352>>2])*+g[n+($*244|0)+116>>2];E=u*(+g[S+(U*152|0)+24>>2]*+g[n+($*244|0)+136>>2]*+g[r+356>>2])*+g[n+($*244|0)+120>>2];g[n+($*244|0)+64>>2]=+g[n+($*244|0)+112>>2]*(u*(+g[S+(U*152|0)+16>>2]*+g[n+($*244|0)+128>>2]*+g[r+348>>2]))+ +g[n+($*244|0)+64>>2];g[n+($*244|0)+68>>2]=F+ +g[n+($*244|0)+68>>2];g[n+($*244|0)+72>>2]=E+ +g[n+($*244|0)+72>>2];E=u*+g[n+($*244|0)+100>>2]*+g[S+(U*152|0)+68>>2];F=u*+g[n+($*244|0)+104>>2]*+g[S+(U*152|0)+72>>2];g[n+($*244|0)+80>>2]=u*+g[n+($*244|0)+96>>2]*+g[S+(U*152|0)+64>>2]+ +g[n+($*244|0)+80>>2];g[n+($*244|0)+84>>2]=E+ +g[n+($*244|0)+84>>2];g[n+($*244|0)+88>>2]=F+ +g[n+($*244|0)+88>>2]}while(0);if(!q)break;o=+g[S+(U*152|0)+100>>2];if(!(c[n+(aa*244|0)+240>>2]|0))break;F=+g[S+(U*152|0)+88>>2];E=+g[S+(U*152|0)+84>>2];D=+g[S+(U*152|0)+80>>2];A=o*(+g[S+(U*152|0)+52>>2]*+g[n+(aa*244|0)+132>>2]*+g[q+352>>2])*+g[n+(aa*244|0)+116>>2];C=o*(+g[S+(U*152|0)+56>>2]*+g[n+(aa*244|0)+136>>2]*+g[q+356>>2])*+g[n+(aa*244|0)+120>>2];g[n+(aa*244|0)+64>>2]=+g[n+(aa*244|0)+112>>2]*(o*(+g[S+(U*152|0)+48>>2]*+g[n+(aa*244|0)+128>>2]*+g[q+348>>2]))+ +g[n+(aa*244|0)+64>>2];g[n+(aa*244|0)+68>>2]=A+ +g[n+(aa*244|0)+68>>2];g[n+(aa*244|0)+72>>2]=C+ +g[n+(aa*244|0)+72>>2];E=E*(+g[n+(aa*244|0)+100>>2]*-o);F=F*(+g[n+(aa*244|0)+104>>2]*-o);g[n+(aa*244|0)+80>>2]=+g[n+(aa*244|0)+80>>2]-D*(+g[n+(aa*244|0)+96>>2]*-o);g[n+(aa*244|0)+84>>2]=+g[n+(aa*244|0)+84>>2]-E;g[n+(aa*244|0)+88>>2]=+g[n+(aa*244|0)+88>>2]-F}while(0);g[S+(U*152|0)+96>>2]=0.0;if(!(c[n+($*244|0)+240>>2]|0)){u=0.0;t=0.0;s=0.0;k=0.0;w=0.0;x=0.0}else{u=+g[n+($*244|0)+208>>2];t=+g[n+($*244|0)+212>>2];s=+g[n+($*244|0)+216>>2];k=+g[n+($*244|0)+224>>2];w=+g[n+($*244|0)+228>>2];x=+g[n+($*244|0)+232>>2]}if(!(c[n+(aa*244|0)+240>>2]|0)){o=0.0;l=0.0;v=0.0;y=0.0;z=0.0;A=0.0}else{o=+g[n+(aa*244|0)+208>>2];l=+g[n+(aa*244|0)+212>>2];v=+g[n+(aa*244|0)+216>>2];y=+g[n+(aa*244|0)+224>>2];z=+g[n+(aa*244|0)+228>>2];A=+g[n+(aa*244|0)+232>>2]}o=B-((u+ +g[n+($*244|0)+176>>2])*+g[S+(U*152|0)+16>>2]+(t+ +g[n+($*244|0)+180>>2])*+g[S+(U*152|0)+20>>2]+(s+ +g[n+($*244|0)+184>>2])*+g[S+(U*152|0)+24>>2]+((k+ +g[n+($*244|0)+192>>2])*+g[S+(U*152|0)>>2]+(w+ +g[n+($*244|0)+196>>2])*+g[S+(U*152|0)+4>>2]+(x+ +g[n+($*244|0)+200>>2])*+g[S+(U*152|0)+8>>2])+((o+ +g[n+(aa*244|0)+176>>2])*+g[S+(U*152|0)+48>>2]+(l+ +g[n+(aa*244|0)+180>>2])*+g[S+(U*152|0)+52>>2]+(v+ +g[n+(aa*244|0)+184>>2])*+g[S+(U*152|0)+56>>2]+((y+ +g[n+(aa*244|0)+192>>2])*+g[S+(U*152|0)+32>>2]+(z+ +g[n+(aa*244|0)+196>>2])*+g[S+(U*152|0)+36>>2]+(A+ +g[n+(aa*244|0)+200>>2])*+g[S+(U*152|0)+40>>2])));r=(c[f+44>>2]|0)==0;if(G>0.0){s=0.0;o=o-G/+g[f+12>>2]}else s=-(G*+g[(r|G>+g[f+48>>2]?f+32|0:f+36|0)>>2])/+g[f+12>>2];F=+g[S+(U*152|0)+108>>2];s=s*F;o=o*F;if(r|G>+g[f+48>>2]){g[S+(U*152|0)+112>>2]=s+o;g[S+(U*152|0)+128>>2]=0.0}else{g[S+(U*152|0)+112>>2]=o;g[S+(U*152|0)+128>>2]=s}g[S+(U*152|0)+116>>2]=0.0;g[S+(U*152|0)+120>>2]=0.0;g[S+(U*152|0)+124>>2]=1.0e10;c[S+(U*152|0)+140>>2]=c[b+68>>2];if(!m){s=0.0;l=0.0;k=0.0}else{s=+g[m+328>>2];l=+g[m+332>>2];k=+g[m+336>>2]}if(!j){o=0.0;u=0.0;t=0.0}else{o=+g[j+328>>2];u=+g[j+332>>2];t=+g[j+336>>2]}v=o-s;u=u-l;s=t-k;g[ea+32>>2]=v;g[ea+36>>2]=u;g[ea+40>>2]=s;g[ea+44>>2]=0.0;do if((h|0)>0?+g[W+(ca*184|0)+92>>2]>0.0:0){h=h+-1|0;o=+P(+(v*v+u*u+s*s));if(o>+g[f+80>>2]){k=v*(1.0/o);g[ea+32>>2]=k;l=u*(1.0/o);g[ea+36>>2]=l;o=s*(1.0/o);g[ea+40>>2]=o;do if(Y){if(!(c[Y+180>>2]&2))break;s=+g[Y+4>>2];z=+g[Y+20>>2];C=+g[Y+36>>2];w=+g[Y+8>>2];A=+g[Y+24>>2];E=+g[Y+40>>2];v=+g[Y+12>>2];B=+g[Y+28>>2];G=+g[Y+44>>2];D=(s*k+z*l+o*C)*+g[Y+164>>2];F=(k*w+l*A+o*E)*+g[Y+168>>2];o=(k*v+l*B+o*G)*+g[Y+172>>2];g[ea+32>>2]=s*D+w*F+v*o;g[ea+36>>2]=z*D+A*F+B*o;g[ea+40>>2]=C*D+E*F+G*o;g[ea+44>>2]=0.0;k=s*D+w*F+v*o;l=z*D+A*F+B*o;o=C*D+E*F+G*o}while(0);do if(Z){if(!(c[Z+180>>2]&2))break;s=+g[Z+4>>2];z=+g[Z+20>>2];C=+g[Z+36>>2];w=+g[Z+8>>2];A=+g[Z+24>>2];E=+g[Z+40>>2];v=+g[Z+12>>2];B=+g[Z+28>>2];G=+g[Z+44>>2];D=(s*k+z*l+C*o)*+g[Z+164>>2];F=(k*w+l*A+o*E)*+g[Z+168>>2];o=(k*v+l*B+o*G)*+g[Z+172>>2];g[ea+32>>2]=s*D+w*F+v*o;g[ea+36>>2]=z*D+A*F+B*o;g[ea+40>>2]=C*D+E*F+G*o;g[ea+44>>2]=0.0;k=s*D+w*F+v*o;l=z*D+A*F+B*o;o=C*D+E*F+G*o}while(0);if(!(+P(+(k*k+l*l+o*o))>.001))break;Qr(b,ea+32|0,$,aa,U,T);break}Qr(b,Q,$,aa,U,T);o=+g[M>>2];if(+O(+o)>.7071067690849304){k=+g[N>>2];G=1.0/+P(+(o*o+k*k));g[ea+16>>2]=0.0;g[ea+20>>2]=-(G*o);g[ea+24>>2]=G*k;g[ea>>2]=(o*o+k*k)*G;F=+g[Q>>2];g[ea+4>>2]=-(F*(G*k));v=F*-(G*o);l=0.0;s=-(G*o);u=G*k;t=(o*o+k*k)*G;k=-(F*(G*k))}else{t=+g[Q>>2];G=+g[N>>2];k=1.0/+P(+(t*t+G*G));g[ea+16>>2]=-(G*k);g[ea+20>>2]=k*t;g[ea+24>>2]=0.0;g[ea>>2]=-(o*(k*t));g[ea+4>>2]=o*-(G*k);v=(t*t+G*G)*k;l=-(G*k);s=k*t;u=0.0;t=-(o*(k*t));k=o*-(G*k)}g[ea+8>>2]=v;do if(!Y)o=u;else{if(!(c[Y+180>>2]&2)){o=u;break}y=+g[Y+4>>2];z=+g[Y+20>>2];C=+g[Y+36>>2];x=+g[Y+8>>2];A=+g[Y+24>>2];E=+g[Y+40>>2];w=+g[Y+12>>2];B=+g[Y+28>>2];G=+g[Y+44>>2];D=(y*l+z*s+C*u)*+g[Y+164>>2];F=(l*x+s*A+u*E)*+g[Y+168>>2];o=(l*w+s*B+u*G)*+g[Y+172>>2];g[ea+16>>2]=y*D+x*F+w*o;g[ea+20>>2]=z*D+A*F+B*o;g[ea+24>>2]=C*D+E*F+G*o;g[ea+28>>2]=0.0;l=y*D+x*F+w*o;s=z*D+A*F+B*o;o=C*D+E*F+G*o}while(0);do if(!Z)u=o;else{if(!(c[Z+180>>2]&2)){u=o;break}y=+g[Z+4>>2];z=+g[Z+20>>2];C=+g[Z+36>>2];x=+g[Z+8>>2];A=+g[Z+24>>2];E=+g[Z+40>>2];w=+g[Z+12>>2];B=+g[Z+28>>2];G=+g[Z+44>>2];D=(y*l+z*s+C*o)*+g[Z+164>>2];F=(l*x+s*A+o*E)*+g[Z+168>>2];u=(l*w+s*B+o*G)*+g[Z+172>>2];g[ea+16>>2]=y*D+x*F+w*u;g[ea+20>>2]=z*D+A*F+B*u;g[ea+24>>2]=C*D+E*F+G*u;g[ea+28>>2]=0.0;l=y*D+x*F+w*u;s=z*D+A*F+B*u;u=C*D+E*F+G*u}while(0);do if(!Y)o=v;else{if(!(c[Y+180>>2]&2)){o=v;break}y=+g[Y+4>>2];z=+g[Y+20>>2];C=+g[Y+36>>2];x=+g[Y+8>>2];A=+g[Y+24>>2];E=+g[Y+40>>2];w=+g[Y+12>>2];B=+g[Y+28>>2];G=+g[Y+44>>2];D=(y*t+z*k+C*v)*+g[Y+164>>2];F=(t*x+k*A+v*E)*+g[Y+168>>2];o=(t*w+k*B+v*G)*+g[Y+172>>2];g[ea>>2]=y*D+x*F+w*o;g[ea+4>>2]=z*D+A*F+B*o;g[ea+8>>2]=C*D+E*F+G*o;g[ea+12>>2]=0.0;t=y*D+x*F+w*o;k=z*D+A*F+B*o;o=C*D+E*F+G*o}while(0);do if(Z){if(!(c[Z+180>>2]&2))break;x=+g[Z+4>>2];z=+g[Z+20>>2];C=+g[Z+36>>2];w=+g[Z+8>>2];A=+g[Z+24>>2];E=+g[Z+40>>2];v=+g[Z+12>>2];B=+g[Z+28>>2];G=+g[Z+44>>2];D=(x*t+z*k+C*o)*+g[Z+164>>2];F=(t*w+k*A+o*E)*+g[Z+168>>2];o=(t*v+k*B+o*G)*+g[Z+172>>2];g[ea>>2]=x*D+w*F+v*o;g[ea+4>>2]=z*D+A*F+B*o;g[ea+8>>2]=C*D+E*F+G*o;g[ea+12>>2]=0.0;t=x*D+w*F+v*o;k=z*D+A*F+B*o;o=C*D+E*F+G*o}while(0);if(+P(+(l*l+s*s+u*u))>.001)Qr(b,ea+16|0,$,aa,U,T);if(!(+P(+(t*t+k*k+o*o))>.001))break;Qr(b,ea,$,aa,U,T)}while(0);do if(!(c[f+64>>2]&32))da=100;else{if(!(a[W+(ca*184|0)+120>>0]|0)){da=100;break}Pr(b,W+(ca*184|0)+156|0,$,aa,U,T,ea+64|0,ea+48|0,1.0,+g[W+(ca*184|0)+136>>2],+g[W+(ca*184|0)+144>>2]);if(!(c[f+64>>2]&16))break;Pr(b,W+(ca*184|0)+172|0,$,aa,U,T,ea+64|0,ea+48|0,1.0,+g[W+(ca*184|0)+140>>2],+g[W+(ca*184|0)+148>>2])}while(0);do if((da|0)==100){da=0;n=W+(ca*184|0)+156|0;s=+g[Q>>2];l=+g[N>>2];v=+g[M>>2];u=R-(R*H+L*I+K*J)*s;t=L-(R*H+L*I+K*J)*l;o=K-(R*H+L*I+K*J)*v;g[W+(ca*184|0)+156>>2]=u;r=W+(ca*184|0)+160|0;g[r>>2]=t;p=W+(ca*184|0)+164|0;g[p>>2]=o;g[W+(ca*184|0)+168>>2]=0.0;if((c[f+64>>2]&64|0)==0?u*u+t*t+o*o>1.1920928955078125e-07:0){K=1.0/+P(+(u*u+t*t+o*o));g[n>>2]=u*K;g[r>>2]=K*t;g[p>>2]=K*o;Or(Y,n);Or(Z,n);Pr(b,n,$,aa,U,T,ea+64|0,ea+48|0,1.0,0.0,0.0);if(!(c[f+64>>2]&16))break;j=W+(ca*184|0)+172|0;G=+g[r>>2];D=+g[M>>2];C=+g[p>>2];E=+g[N>>2];J=+g[Q>>2];F=+g[n>>2];g[W+(ca*184|0)+172>>2]=G*D-C*E;g[W+(ca*184|0)+184>>2]=0.0;K=1.0/+P(+((G*D-C*E)*(G*D-C*E)+(C*J-D*F)*(C*J-D*F)+(E*F-G*J)*(E*F-G*J)));g[j>>2]=(G*D-C*E)*K;g[W+(ca*184|0)+176>>2]=(C*J-D*F)*K;g[W+(ca*184|0)+180>>2]=(E*F-G*J)*K;Or(Y,j);Or(Z,j);Pr(b,j,$,aa,U,T,ea+64|0,ea+48|0,1.0,0.0,0.0);break}q=W+(ca*184|0)+172|0;if(+O(+v)>.7071067690849304){K=1.0/+P(+(v*v+l*l));g[n>>2]=0.0;g[r>>2]=-(K*v);g[p>>2]=K*l;k=(v*v+l*l)*K;o=-(s*(K*l));l=s*-(K*v)}else{K=1.0/+P(+(s*s+l*l));g[n>>2]=-(l*K);g[r>>2]=K*s;g[p>>2]=0.0;k=-(v*(K*s));o=v*-(l*K);l=(s*s+l*l)*K}g[q>>2]=k;g[W+(ca*184|0)+176>>2]=o;g[W+(ca*184|0)+180>>2]=l;Or(Y,n);Or(Z,n);Pr(b,n,$,aa,U,T,ea+64|0,ea+48|0,1.0,0.0,0.0);j=c[f+64>>2]|0;if(j&16){Or(Y,q);Or(Z,q);Pr(b,q,$,aa,U,T,ea+64|0,ea+48|0,1.0,0.0,0.0);j=c[f+64>>2]|0}if((j&80|0)!=80)break;a[W+(ca*184|0)+120>>0]=1}while(0);r=c[b+16>>2]|0;m=c[r+($*244|0)+240>>2]|0;j=c[r+(aa*244|0)+240>>2]|0;p=c[S+(U*152|0)+140>>2]|0;q=c[b+76>>2]|0;n=c[f+64>>2]|0;do if(!(n&4))g[q+(p*152|0)+100>>2]=0.0;else{l=+g[W+(ca*184|0)+128>>2]*+g[f+60>>2];g[q+(p*152|0)+100>>2]=l;if(m){G=+g[m+344>>2];K=l*(G*+g[q+(p*152|0)+20>>2]*+g[m+352>>2])*+g[r+($*244|0)+116>>2];J=l*(G*+g[q+(p*152|0)+24>>2]*+g[m+356>>2])*+g[r+($*244|0)+120>>2];g[r+($*244|0)+64>>2]=+g[r+($*244|0)+112>>2]*(l*(G*+g[q+(p*152|0)+16>>2]*+g[m+348>>2]))+ +g[r+($*244|0)+64>>2];g[r+($*244|0)+68>>2]=K+ +g[r+($*244|0)+68>>2];g[r+($*244|0)+72>>2]=J+ +g[r+($*244|0)+72>>2];J=l*+g[r+($*244|0)+100>>2]*+g[q+(p*152|0)+68>>2];K=l*+g[r+($*244|0)+104>>2]*+g[q+(p*152|0)+72>>2];g[r+($*244|0)+80>>2]=l*+g[r+($*244|0)+96>>2]*+g[q+(p*152|0)+64>>2]+ +g[r+($*244|0)+80>>2];g[r+($*244|0)+84>>2]=J+ +g[r+($*244|0)+84>>2];g[r+($*244|0)+88>>2]=K+ +g[r+($*244|0)+88>>2]}if(!j)break;l=+g[j+344>>2];k=+g[q+(p*152|0)+100>>2];if(!(c[r+(aa*244|0)+240>>2]|0))break;K=+g[q+(p*152|0)+88>>2];J=+g[q+(p*152|0)+84>>2];G=+g[q+(p*152|0)+80>>2];E=k*(l*+g[q+(p*152|0)+52>>2]*+g[j+352>>2])*+g[r+(aa*244|0)+116>>2];F=k*(l*+g[q+(p*152|0)+56>>2]*+g[j+356>>2])*+g[r+(aa*244|0)+120>>2];g[r+(aa*244|0)+64>>2]=+g[r+(aa*244|0)+112>>2]*(k*(l*+g[q+(p*152|0)+48>>2]*+g[j+348>>2]))+ +g[r+(aa*244|0)+64>>2];g[r+(aa*244|0)+68>>2]=E+ +g[r+(aa*244|0)+68>>2];g[r+(aa*244|0)+72>>2]=F+ +g[r+(aa*244|0)+72>>2];J=J*(+g[r+(aa*244|0)+100>>2]*-k);K=K*(+g[r+(aa*244|0)+104>>2]*-k);g[r+(aa*244|0)+80>>2]=+g[r+(aa*244|0)+80>>2]-G*(+g[r+(aa*244|0)+96>>2]*-k);g[r+(aa*244|0)+84>>2]=+g[r+(aa*244|0)+84>>2]-J;g[r+(aa*244|0)+88>>2]=+g[r+(aa*244|0)+88>>2]-K}while(0);do if(n&16){if(!(n&4)){g[q+((p+1|0)*152|0)+100>>2]=0.0;break}k=+g[W+(ca*184|0)+132>>2]*+g[f+60>>2];g[q+((p+1|0)*152|0)+100>>2]=k;do if(m){l=+g[m+344>>2];if(!(c[r+($*244|0)+240>>2]|0))break;K=k*(l*+g[q+((p+1|0)*152|0)+20>>2])*+g[r+($*244|0)+116>>2];J=k*(l*+g[q+((p+1|0)*152|0)+24>>2])*+g[r+($*244|0)+120>>2];g[r+($*244|0)+64>>2]=+g[r+($*244|0)+112>>2]*(k*(l*+g[q+((p+1|0)*152|0)+16>>2]))+ +g[r+($*244|0)+64>>2];g[r+($*244|0)+68>>2]=K+ +g[r+($*244|0)+68>>2];g[r+($*244|0)+72>>2]=J+ +g[r+($*244|0)+72>>2];J=k*+g[r+($*244|0)+100>>2]*+g[q+((p+1|0)*152|0)+68>>2];K=k*+g[r+($*244|0)+104>>2]*+g[q+((p+1|0)*152|0)+72>>2];g[r+($*244|0)+80>>2]=k*+g[r+($*244|0)+96>>2]*+g[q+((p+1|0)*152|0)+64>>2]+ +g[r+($*244|0)+80>>2];g[r+($*244|0)+84>>2]=J+ +g[r+($*244|0)+84>>2];g[r+($*244|0)+88>>2]=K+ +g[r+($*244|0)+88>>2]}while(0);if(!j)break;k=+g[j+344>>2];l=+g[q+((p+1|0)*152|0)+100>>2];if(!(c[r+(aa*244|0)+240>>2]|0))break;K=+g[q+((p+1|0)*152|0)+88>>2];J=+g[q+((p+1|0)*152|0)+84>>2];G=+g[q+((p+1|0)*152|0)+80>>2];E=l*(k*+g[q+((p+1|0)*152|0)+52>>2])*+g[r+(aa*244|0)+116>>2];F=l*(k*+g[q+((p+1|0)*152|0)+56>>2])*+g[r+(aa*244|0)+120>>2];g[r+(aa*244|0)+64>>2]=+g[r+(aa*244|0)+112>>2]*(l*(k*+g[q+((p+1|0)*152|0)+48>>2]))+ +g[r+(aa*244|0)+64>>2];g[r+(aa*244|0)+68>>2]=E+ +g[r+(aa*244|0)+68>>2];g[r+(aa*244|0)+72>>2]=F+ +g[r+(aa*244|0)+72>>2];J=J*(+g[r+(aa*244|0)+100>>2]*-l);K=K*(+g[r+(aa*244|0)+104>>2]*-l);g[r+(aa*244|0)+80>>2]=+g[r+(aa*244|0)+80>>2]-G*(+g[r+(aa*244|0)+96>>2]*-l);g[r+(aa*244|0)+84>>2]=+g[r+(aa*244|0)+84>>2]-J;g[r+(aa*244|0)+88>>2]=+g[r+(aa*244|0)+88>>2]-K}while(0);j=c[W+748>>2]|0}ca=ca+1|0}while((ca|0)<(j|0))}ba=ba+1|0}while((ba|0)!=(e|0));i=ea;return}function Tr(b,d,e,f,h,j,k,l,m){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;k=k|0;l=l|0;m=m|0;var n=0,o=0,p=0,q=0.0,r=0,s=0,t=0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,N=0.0,Q=0.0,R=0.0,S=0,T=0,U=0,V=0,W=0,X=0;X=i;i=i+320|0;c[b+188>>2]=-1;aE(4032);c[b+184>>2]=0;if((e|0)>0){m=0;do{c[(c[d+(m<<2)>>2]|0)+212>>2]=-1;m=m+1|0}while((m|0)!=(e|0))}m=c[b+12>>2]|0;if((m|0)<(e+1|0)){if((e+1|0)!=0?(c[5108]=(c[5108]|0)+1,p=QE(((e+1|0)*244|3)+16|0)|0,(p|0)!=0):0){c[(p+19&-16)+-4>>2]=p;o=p+19&-16}else o=0;m=c[b+8>>2]|0;if((m|0)>0){p=0;do{t=o+(p*244|0)|0;S=c[b+16>>2]|0;s=S+(p*244|0)|0;c[t+0>>2]=c[s+0>>2];c[t+4>>2]=c[s+4>>2];c[t+8>>2]=c[s+8>>2];c[t+12>>2]=c[s+12>>2];t=o+(p*244|0)+16|0;s=S+(p*244|0)+16|0;c[t+0>>2]=c[s+0>>2];c[t+4>>2]=c[s+4>>2];c[t+8>>2]=c[s+8>>2];c[t+12>>2]=c[s+12>>2];t=o+(p*244|0)+32|0;s=S+(p*244|0)+32|0;c[t+0>>2]=c[s+0>>2];c[t+4>>2]=c[s+4>>2];c[t+8>>2]=c[s+8>>2];c[t+12>>2]=c[s+12>>2];t=o+(p*244|0)+48|0;s=S+(p*244|0)+48|0;c[t+0>>2]=c[s+0>>2];c[t+4>>2]=c[s+4>>2];c[t+8>>2]=c[s+8>>2];c[t+12>>2]=c[s+12>>2];YE(o+(p*244|0)+64|0,S+(p*244|0)+64|0,180)|0;p=p+1|0}while((p|0)!=(m|0))}m=c[b+16>>2]|0;if(m){if(a[b+20>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[m+-4>>2]|0)}c[b+16>>2]=0}a[b+20>>0]=1;c[b+16>>2]=o;c[b+12>>2]=e+1;m=e+1|0;o=b+8|0}else o=b+8|0;VE(X+56|0,0,244)|0;p=c[o>>2]|0;if((p|0)<0){if((m|0)<0){m=c[b+16>>2]|0;if(m){if(a[b+20>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[m+-4>>2]|0)}c[b+16>>2]=0}a[b+20>>0]=1;c[b+16>>2]=0;c[b+12>>2]=0}m=p;do{S=c[b+16>>2]|0;t=S+(m*244|0)|0;c[t+0>>2]=c[X+56>>2];c[t+4>>2]=c[X+60>>2];c[t+8>>2]=c[X+64>>2];c[t+12>>2]=c[X+68>>2];t=S+(m*244|0)+16|0;c[t+0>>2]=c[X+72>>2];c[t+4>>2]=c[X+76>>2];c[t+8>>2]=c[X+80>>2];c[t+12>>2]=c[X+84>>2];t=S+(m*244|0)+32|0;c[t+0>>2]=c[X+88>>2];c[t+4>>2]=c[X+92>>2];c[t+8>>2]=c[X+96>>2];c[t+12>>2]=c[X+100>>2];t=S+(m*244|0)+48|0;c[t+0>>2]=c[X+104>>2];c[t+4>>2]=c[X+108>>2];c[t+8>>2]=c[X+112>>2];c[t+12>>2]=c[X+116>>2];YE(S+(m*244|0)+64|0,X+120|0,180)|0;m=m+1|0}while((m|0)!=0)}c[o>>2]=0;if((e|0)>0){s=0;do{r=d+(s<<2)|0;t=Rr(b,c[r>>2]|0,+g[l+12>>2])|0;r=c[r>>2]|0;r=(c[r+236>>2]&2|0)==0?0:r;if(((r|0)!=0?+g[r+344>>2]!=0.0:0)?(n=c[b+16>>2]|0,(c[r+504>>2]&2|0)!=0):0){u=+g[l+76>>2];I=1.0/+g[r+396>>2];M=1.0/+g[r+400>>2];q=1.0/+g[r+404>>2];E=+g[r+4>>2];F=+g[r+8>>2];G=+g[r+12>>2];H=+g[r+20>>2];K=+g[r+24>>2];Q=+g[r+28>>2];J=+g[r+36>>2];N=+g[r+40>>2];w=+g[r+44>>2];y=+g[r+328>>2];z=+g[r+332>>2];v=+g[r+336>>2];B=(E*(I*E)+F*(M*F)+G*(q*G))*y+(I*E*H+M*F*K+q*G*Q)*z+(I*E*J+M*F*N+q*G*w)*v;A=(E*(I*H)+F*(M*K)+G*(q*Q))*y+(H*(I*H)+K*(M*K)+Q*(q*Q))*z+(I*H*J+M*K*N+q*Q*w)*v;w=v*(J*(I*J)+N*(M*N)+w*(q*w))+(y*(E*(I*J)+F*(M*N)+G*(q*w))+z*(H*(I*J)+K*(M*N)+Q*(q*w)));q=(z*w-v*A)*(z*w-v*A)+(v*B-y*w)*(v*B-y*w)+(y*A-z*B)*(y*A-z*B);if(q>u*u){q=1.0/+P(+q)*u;x=(z*w-v*A)*q;u=q*(v*B-y*w);q=q*(y*A-z*B)}else{x=z*w-v*A;u=v*B-y*w;q=y*A-z*B}M=+g[l+12>>2];N=(x*+g[r+268>>2]+u*+g[r+284>>2]+q*+g[r+300>>2])*M;Q=M*(x*+g[r+272>>2]+u*+g[r+288>>2]+q*+g[r+304>>2]);g[n+(t*244|0)+224>>2]=+g[n+(t*244|0)+224>>2]-(x*+g[r+264>>2]+u*+g[r+280>>2]+q*+g[r+296>>2])*M;g[n+(t*244|0)+228>>2]=+g[n+(t*244|0)+228>>2]-N;g[n+(t*244|0)+232>>2]=+g[n+(t*244|0)+232>>2]-Q}s=s+1|0}while((s|0)!=(e|0))}if((k|0)>0){o=0;do{S=c[j+(o<<2)>>2]|0;Jb[c[(c[S>>2]|0)+8>>2]&255](S);g[S+36>>2]=0.0;o=o+1|0}while((o|0)<(k|0))}o=c[b+168>>2]|0;if((o|0)<(k|0)?(c[b+172>>2]|0)<(k|0):0){if(!k)m=0;else{c[5108]=(c[5108]|0)+1;o=QE((k<<3|3)+16|0)|0;if(!o)m=0;else{c[(o+19&-16)+-4>>2]=o;m=o+19&-16}o=c[b+168>>2]|0}if((o|0)>0){n=0;do{p=m+(n<<3)|0;if(p){t=(c[b+176>>2]|0)+(n<<3)|0;S=c[t+4>>2]|0;c[p>>2]=c[t>>2];c[p+4>>2]=S}n=n+1|0}while((n|0)!=(o|0))}o=c[b+176>>2]|0;if(o){if(a[b+180>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[o+-4>>2]|0)}c[b+176>>2]=0}a[b+180>>0]=1;c[b+176>>2]=m;c[b+172>>2]=k}c[b+168>>2]=k;if((k|0)>0){t=0;o=0;do{r=c[b+176>>2]|0;s=r+(t<<3)|0;n=j+(t<<2)|0;m=c[n>>2]|0;p=c[m+44>>2]|0;if(p){m=p+0|0;p=m+64|0;do{c[m>>2]=0;m=m+4|0}while((m|0)<(p|0));m=c[n>>2]|0}if(!(a[m+20>>0]|0)){c[s>>2]=0;c[r+(t<<3)+4>>2]=0;m=0}else{Lb[c[(c[m>>2]|0)+16>>2]&127](m,s);m=c[s>>2]|0}o=m+o|0;t=t+1|0}while((t|0)<(k|0));n=o}else n=0;o=c[b+48>>2]|0;if((o|0)<(n|0)?(c[b+52>>2]|0)<(n|0):0){if(!n)p=0;else{c[5108]=(c[5108]|0)+1;p=QE((n*152|3)+16|0)|0;if(!p)m=0;else{c[(p+19&-16)+-4>>2]=p;m=p+19&-16}o=c[b+48>>2]|0;p=m}if((o|0)>0){m=0;do{YE(p+(m*152|0)|0,(c[b+56>>2]|0)+(m*152|0)|0,152)|0;m=m+1|0}while((m|0)!=(o|0))}m=c[b+56>>2]|0;if(m){if(a[b+60>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[m+-4>>2]|0)}c[b+56>>2]=0}a[b+60>>0]=1;c[b+56>>2]=p;c[b+52>>2]=n}c[b+48>>2]=n;if((k|0)>0){m=c[b+176>>2]|0;V=0;W=0;while(1){U=m+(W<<3)|0;if(!(c[U>>2]|0))p=0;else{d=c[b+56>>2]|0;p=j+(W<<2)|0;r=c[p>>2]|0;T=c[r+28>>2]|0;S=c[r+32>>2]|0;o=Rr(b,T,+g[l+12>>2])|0;n=Rr(b,S,+g[l+12>>2])|0;m=c[b+16>>2]|0;t=c[r+24>>2]|0;t=(t|0)>0?t:c[l+20>>2]|0;if((t|0)>(c[b+184>>2]|0))c[b+184>>2]=t;if((c[U>>2]|0)>0){s=0;do{e=s+V|0;VE(d+(e*152|0)|0,0,152)|0;g[d+(e*152|0)+120>>2]=-3402823466385288598117041.0e14;g[d+(e*152|0)+124>>2]=3402823466385288598117041.0e14;g[d+(e*152|0)+100>>2]=0.0;g[d+(e*152|0)+96>>2]=0.0;c[d+(e*152|0)+144>>2]=o;c[d+(e*152|0)+148>>2]=n;c[d+(e*152|0)+136>>2]=t;s=s+1|0}while((s|0)<(c[U>>2]|0))}c[m+(o*244|0)+64>>2]=0;c[m+(o*244|0)+68>>2]=0;c[m+(o*244|0)+72>>2]=0;c[m+(o*244|0)+76>>2]=0;c[m+(o*244|0)+80>>2]=0;c[m+(o*244|0)+84>>2]=0;c[m+(o*244|0)+88>>2]=0;c[m+(o*244|0)+92>>2]=0;c[m+(o*244|0)+144>>2]=0;c[m+(o*244|0)+148>>2]=0;c[m+(o*244|0)+152>>2]=0;c[m+(o*244|0)+156>>2]=0;c[m+(o*244|0)+160>>2]=0;c[m+(o*244|0)+164>>2]=0;c[m+(o*244|0)+168>>2]=0;c[m+(o*244|0)+172>>2]=0;c[m+(n*244|0)+64>>2]=0;c[m+(n*244|0)+68>>2]=0;c[m+(n*244|0)+72>>2]=0;c[m+(n*244|0)+76>>2]=0;c[m+(n*244|0)+80>>2]=0;c[m+(n*244|0)+84>>2]=0;c[m+(n*244|0)+88>>2]=0;c[m+(n*244|0)+92>>2]=0;c[m+(n*244|0)+144>>2]=0;c[m+(n*244|0)+148>>2]=0;c[m+(n*244|0)+152>>2]=0;c[m+(n*244|0)+156>>2]=0;c[m+(n*244|0)+160>>2]=0;c[m+(n*244|0)+164>>2]=0;c[m+(n*244|0)+168>>2]=0;c[m+(n*244|0)+172>>2]=0;g[X>>2]=1.0/+g[l+12>>2];g[X+4>>2]=+g[l+32>>2];c[X+8>>2]=d+(V*152|0)+16;c[X+12>>2]=d+(V*152|0);c[X+16>>2]=d+(V*152|0)+48;c[X+20>>2]=d+(V*152|0)+32;c[X+24>>2]=38;c[X+28>>2]=d+(V*152|0)+112;t=d+(V*152|0)+116|0;g[t>>2]=+g[l+40>>2];g[X+52>>2]=+g[l+4>>2];c[X+32>>2]=t;c[X+36>>2]=d+(V*152|0)+120;c[X+40>>2]=d+(V*152|0)+124;c[X+48>>2]=c[l+20>>2];t=c[p>>2]|0;Lb[c[(c[t>>2]|0)+20>>2]&127](t,X);if((c[U>>2]|0)>0){e=0;do{t=e+V|0;u=+g[(c[p>>2]|0)+16>>2];if(+g[d+(t*152|0)+124>>2]>=u)g[d+(t*152|0)+124>>2]=u;if(+g[d+(t*152|0)+120>>2]<=-u)g[d+(t*152|0)+120>>2]=-u;c[d+(t*152|0)+132>>2]=r;s=c[r+28>>2]|0;D=+g[d+(t*152|0)>>2];G=+g[d+(t*152|0)+4>>2];A=+g[d+(t*152|0)+8>>2];F=(D*+g[s+280>>2]+G*+g[s+284>>2]+A*+g[s+288>>2])*+g[s+548>>2];H=(D*+g[s+296>>2]+G*+g[s+300>>2]+A*+g[s+304>>2])*+g[s+552>>2];g[d+(t*152|0)+64>>2]=(+g[s+264>>2]*D+ +g[s+268>>2]*G+ +g[s+272>>2]*A)*+g[s+544>>2];g[d+(t*152|0)+68>>2]=F;g[d+(t*152|0)+72>>2]=H;g[d+(t*152|0)+76>>2]=0.0;s=c[r+32>>2]|0;H=+g[d+(t*152|0)+32>>2];F=+g[d+(t*152|0)+36>>2];A=+g[d+(t*152|0)+40>>2];G=(H*+g[s+280>>2]+F*+g[s+284>>2]+A*+g[s+288>>2])*+g[s+548>>2];D=(H*+g[s+296>>2]+F*+g[s+300>>2]+A*+g[s+304>>2])*+g[s+552>>2];g[d+(t*152|0)+80>>2]=(+g[s+264>>2]*H+ +g[s+268>>2]*F+ +g[s+272>>2]*A)*+g[s+544>>2];g[d+(t*152|0)+84>>2]=G;g[d+(t*152|0)+88>>2]=D;g[d+(t*152|0)+92>>2]=0.0;D=+g[T+344>>2];G=+g[d+(t*152|0)+16>>2];H=+g[d+(t*152|0)+20>>2];I=+g[d+(t*152|0)+24>>2];J=+g[d+(t*152|0)>>2];K=+g[d+(t*152|0)+4>>2];L=+g[d+(t*152|0)+8>>2];E=+g[S+344>>2];M=+g[d+(t*152|0)+48>>2];N=+g[d+(t*152|0)+52>>2];Q=+g[d+(t*152|0)+56>>2];R=+g[d+(t*152|0)+32>>2];A=G*(D*G)+H*(D*H)+I*(D*I)+(J*(+g[T+264>>2]*J+ +g[T+268>>2]*K+ +g[T+272>>2]*L)+K*(J*+g[T+280>>2]+K*+g[T+284>>2]+L*+g[T+288>>2])+L*(J*+g[T+296>>2]+K*+g[T+300>>2]+L*+g[T+304>>2]))+(M*(E*M)+N*(E*N)+Q*(E*Q))+(R*(+g[S+264>>2]*R+ +g[S+268>>2]*F+ +g[S+272>>2]*A)+F*(R*+g[S+280>>2]+F*+g[S+284>>2]+A*+g[S+288>>2])+A*(R*+g[S+296>>2]+F*+g[S+300>>2]+A*+g[S+304>>2]));if(+O(+A)>1.1920928955078125e-07)A=1.0/A;else A=0.0;g[d+(t*152|0)+108>>2]=A;if(!(c[m+(o*244|0)+240>>2]|0)){z=0.0;y=0.0;x=0.0;B=0.0;q=0.0;C=0.0}else{z=+g[m+(o*244|0)+208>>2];y=+g[m+(o*244|0)+212>>2];x=+g[m+(o*244|0)+216>>2];B=+g[m+(o*244|0)+224>>2];q=+g[m+(o*244|0)+228>>2];C=+g[m+(o*244|0)+232>>2]}if(!(c[m+(n*244|0)+240>>2]|0)){w=0.0;v=0.0;u=0.0;D=0.0;E=0.0;F=0.0}else{w=+g[m+(n*244|0)+208>>2];v=+g[m+(n*244|0)+212>>2];u=+g[m+(n*244|0)+216>>2];D=+g[m+(n*244|0)+224>>2];E=+g[m+(n*244|0)+228>>2];F=+g[m+(n*244|0)+232>>2]}g[d+(t*152|0)+112>>2]=+g[d+(t*152|0)+112>>2]*A+A*(0.0-+g[X+52>>2]*((z+ +g[T+312>>2])*G+(y+ +g[T+316>>2])*H+(x+ +g[T+320>>2])*I+((B+ +g[T+328>>2])*J+(q+ +g[T+332>>2])*K+(C+ +g[T+336>>2])*L)+((w+ +g[S+312>>2])*M+(v+ +g[S+316>>2])*N+(u+ +g[S+320>>2])*Q+((D+ +g[S+328>>2])*R+(E+ +g[S+332>>2])*+g[d+(t*152|0)+36>>2]+(F+ +g[S+336>>2])*+g[d+(t*152|0)+40>>2]))));g[d+(t*152|0)+100>>2]=0.0;e=e+1|0}while((e|0)<(c[U>>2]|0))}m=c[b+176>>2]|0;p=c[m+(W<<3)>>2]|0}W=W+1|0;if((W|0)>=(k|0))break;else V=p+V|0}}tc[c[(c[b>>2]|0)+28>>2]&127](b,f,h,l);t=c[b+48>>2]|0;e=c[b+28>>2]|0;s=c[b+68>>2]|0;o=c[b+128>>2]|0;if((o|0)<(t|0)?(c[b+132>>2]|0)<(t|0):0){if(!t)n=0;else{c[5108]=(c[5108]|0)+1;o=QE((t<<2|3)+16|0)|0;if(!o)n=0;else{c[(o+19&-16)+-4>>2]=o;n=o+19&-16}o=c[b+128>>2]|0}if((o|0)>0){p=0;do{m=n+(p<<2)|0;if(m)c[m>>2]=c[(c[b+136>>2]|0)+(p<<2)>>2];p=p+1|0}while((p|0)!=(o|0))}o=c[b+136>>2]|0;if(o){if(a[b+140>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[o+-4>>2]|0)}c[b+136>>2]=0}a[b+140>>0]=1;c[b+136>>2]=n;c[b+132>>2]=t}c[b+128>>2]=t;if(!(c[l+64>>2]&16)){o=c[b+108>>2]|0;if((o|0)<(e|0)?(c[b+112>>2]|0)<(e|0):0){if(!e)n=0;else{c[5108]=(c[5108]|0)+1;o=QE((e<<2|3)+16|0)|0;if(!o)n=0;else{c[(o+19&-16)+-4>>2]=o;n=o+19&-16}o=c[b+108>>2]|0}if((o|0)>0){m=0;do{p=n+(m<<2)|0;if(p)c[p>>2]=c[(c[b+116>>2]|0)+(m<<2)>>2];m=m+1|0}while((m|0)!=(o|0))}o=c[b+116>>2]|0;if(o){if(a[b+120>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[o+-4>>2]|0)}c[b+116>>2]=0}a[b+120>>0]=1;c[b+116>>2]=n;c[b+112>>2]=e}c[b+108>>2]=e}else{o=c[b+108>>2]|0;if((o|0)<(e<<1|0)?(c[b+112>>2]|0)<(e<<1|0):0){if(!e)n=0;else{c[5108]=(c[5108]|0)+1;o=QE((e<<3|3)+16|0)|0;if(!o)n=0;else{c[(o+19&-16)+-4>>2]=o;n=o+19&-16}o=c[b+108>>2]|0}if((o|0)>0){m=0;do{p=n+(m<<2)|0;if(p)c[p>>2]=c[(c[b+116>>2]|0)+(m<<2)>>2];m=m+1|0}while((m|0)!=(o|0))}o=c[b+116>>2]|0;if(o){if(a[b+120>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[o+-4>>2]|0)}c[b+116>>2]=0}a[b+120>>0]=1;c[b+116>>2]=n;c[b+112>>2]=e<<1}c[b+108>>2]=e<<1}o=c[b+148>>2]|0;if((o|0)<(s|0)?(c[b+152>>2]|0)<(s|0):0){if(!s)n=0;else{c[5108]=(c[5108]|0)+1;o=QE((s<<2|3)+16|0)|0;if(!o)n=0;else{c[(o+19&-16)+-4>>2]=o;n=o+19&-16}o=c[b+148>>2]|0}if((o|0)>0){m=0;do{p=n+(m<<2)|0;if(p)c[p>>2]=c[(c[b+156>>2]|0)+(m<<2)>>2];m=m+1|0}while((m|0)!=(o|0))}o=c[b+156>>2]|0;if(o){if(a[b+160>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[o+-4>>2]|0)}c[b+156>>2]=0}a[b+160>>0]=1;c[b+156>>2]=n;c[b+152>>2]=s}c[b+148>>2]=s;if((t|0)>0){o=c[b+136>>2]|0;n=0;do{c[o+(n<<2)>>2]=n;n=n+1|0}while((n|0)!=(t|0))}if((e|0)>0){o=c[b+116>>2]|0;n=0;do{c[o+(n<<2)>>2]=n;n=n+1|0}while((n|0)!=(e|0))}if((s|0)>0){n=c[b+156>>2]|0;o=0;do{c[n+(o<<2)>>2]=o;o=o+1|0}while((o|0)!=(s|0))}n=c[5104]|0;S=(c[n+16>>2]|0)+-1|0;c[n+16>>2]=S;if(S){i=X;return 0.0}do if(c[n+4>>2]|0){Cb(X+304|0,0)|0;S=c[5090]|0;g[n+8>>2]=+(((c[X+308>>2]|0)-(c[S+4>>2]|0)+(((c[X+304>>2]|0)-(c[S>>2]|0)|0)*1e6|0)-(c[n+12>>2]|0)|0)>>>0)/1.0e3+ +g[n+8>>2];if(!(c[n+16>>2]|0)){n=c[5104]|0;break}else{i=X;return 0.0}}while(0);c[5104]=c[n+20>>2];i=X;return 0.0}function Ur(b,d,e,f,h,j,k,l,m,n){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;k=k|0;l=l|0;m=m|0;n=n|0;var o=0.0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0.0;v=i;e=c[b+48>>2]|0;r=c[b+28>>2]|0;s=c[b+68>>2]|0;if(c[m+64>>2]&1){if((e|0)>0){f=c[b+136>>2]|0;h=c[b+192>>2]|0;q=0;do{j=f+(q<<2)|0;n=c[j>>2]|0;q=q+1|0;h=($(h,1664525)|0)+1013904223|0;if(q>>>0<65537){p=h>>>16^h;if(q>>>0<257)if(q>>>0<17){p=(p>>>8^p)>>>4^(p>>>8^p);if(q>>>0<5)if(q>>>0<3)p=(p>>>2^p)>>>1^(p>>>2^p);else p=p>>>2^p}else p=p>>>8^p}else p=h;p=f+(((p>>>0)%(q>>>0)|0)<<2)|0;c[j>>2]=c[p>>2];c[p>>2]=n}while((q|0)!=(e|0));c[b+192>>2]=h}if((c[m+20>>2]|0)>(d|0)){if((r|0)>0){n=c[b+116>>2]|0;f=c[b+192>>2]|0;j=0;do{h=n+(j<<2)|0;e=c[h>>2]|0;j=j+1|0;f=($(f,1664525)|0)+1013904223|0;if(j>>>0<65537){p=f>>>16^f;if(j>>>0<257)if(j>>>0<17){p=(p>>>8^p)>>>4^(p>>>8^p);if(j>>>0<5)if(j>>>0<3)p=(p>>>2^p)>>>1^(p>>>2^p);else p=p>>>2^p}else p=p>>>8^p}else p=f;q=n+(((p>>>0)%(j>>>0)|0)<<2)|0;c[h>>2]=c[q>>2];c[q>>2]=e}while((j|0)!=(r|0));c[b+192>>2]=f}if((s|0)>0){n=c[b+156>>2]|0;f=c[b+192>>2]|0;j=0;do{h=n+(j<<2)|0;e=c[h>>2]|0;j=j+1|0;f=($(f,1664525)|0)+1013904223|0;if(j>>>0<65537){p=f>>>16^f;if(j>>>0<257)if(j>>>0<17){p=(p>>>8^p)>>>4^(p>>>8^p);if(j>>>0<5)if(j>>>0<3)p=(p>>>2^p)>>>1^(p>>>2^p);else p=p>>>2^p}else p=p>>>8^p}else p=f;r=n+(((p>>>0)%(j>>>0)|0)<<2)|0;c[h>>2]=c[r>>2];c[r>>2]=e}while((j|0)!=(s|0));c[b+192>>2]=f}}}e=c[b+48>>2]|0;if(!(c[m+64>>2]&256)){if((e|0)>0){j=0;do{f=c[(c[b+136>>2]|0)+(j<<2)>>2]|0;h=c[b+56>>2]|0;if((c[h+(f*152|0)+136>>2]|0)>(d|0)){e=c[b+16>>2]|0;Kr(e+((c[h+(f*152|0)+144>>2]|0)*244|0)|0,e+((c[h+(f*152|0)+148>>2]|0)*244|0)|0,h+(f*152|0)|0);e=c[b+48>>2]|0}j=j+1|0}while((j|0)<(e|0))}if((c[m+20>>2]|0)<=(d|0)){i=v;return 0.0}if((l|0)>0){h=0;do{f=k+(h<<2)|0;e=c[f>>2]|0;if(a[e+20>>0]|0){r=Rr(b,c[e+28>>2]|0,+g[m+12>>2])|0;d=Rr(b,c[(c[f>>2]|0)+32>>2]|0,+g[m+12>>2])|0;s=c[b+16>>2]|0;q=c[f>>2]|0;oc[c[(c[q>>2]|0)+24>>2]&15](q,s+(r*244|0)|0,s+(d*244|0)|0,+g[m+12>>2])}h=h+1|0}while((h|0)!=(l|0))}j=c[b+28>>2]|0;if((j|0)>0){h=0;do{d=c[(c[b+116>>2]|0)+(h<<2)>>2]|0;s=c[b+36>>2]|0;r=c[b+16>>2]|0;Lr(r+((c[s+(d*152|0)+144>>2]|0)*244|0)|0,r+((c[s+(d*152|0)+148>>2]|0)*244|0)|0,s+(d*152|0)|0);h=h+1|0}while((h|0)!=(j|0))}f=c[b+68>>2]|0;if((f|0)>0){e=0;do{h=c[(c[b+156>>2]|0)+(e<<2)>>2]|0;j=c[b+76>>2]|0;o=+g[(c[b+36>>2]|0)+((c[j+(h*152|0)+140>>2]|0)*152|0)+100>>2];if(o>0.0){o=o*+g[j+(h*152|0)+104>>2];g[j+(h*152|0)+120>>2]=-o;g[j+(h*152|0)+124>>2]=o;d=c[b+16>>2]|0;Kr(d+((c[j+(h*152|0)+144>>2]|0)*244|0)|0,d+((c[j+(h*152|0)+148>>2]|0)*244|0)|0,j+(h*152|0)|0)}e=e+1|0}while((e|0)!=(f|0))}h=c[b+88>>2]|0;if((h|0)<=0){i=v;return 0.0}f=0;do{j=c[b+96>>2]|0;o=+g[(c[b+36>>2]|0)+((c[j+(f*152|0)+140>>2]|0)*152|0)+100>>2];if(o>0.0){w=+g[j+(f*152|0)+104>>2];o=o*w>w?w:o*w;g[j+(f*152|0)+120>>2]=-o;g[j+(f*152|0)+124>>2]=o;d=c[b+16>>2]|0;Kr(d+((c[j+(f*152|0)+144>>2]|0)*244|0)|0,d+((c[j+(f*152|0)+148>>2]|0)*244|0)|0,j+(f*152|0)|0)}f=f+1|0}while((f|0)!=(h|0));i=v;return 0.0}if((e|0)>0){p=0;do{f=c[(c[b+136>>2]|0)+(p<<2)>>2]|0;h=c[b+56>>2]|0;if((c[h+(f*152|0)+136>>2]|0)>(d|0)){e=c[b+16>>2]|0;Kr(e+((c[h+(f*152|0)+144>>2]|0)*244|0)|0,e+((c[h+(f*152|0)+148>>2]|0)*244|0)|0,h+(f*152|0)|0);e=c[b+48>>2]|0}p=p+1|0}while((p|0)<(e|0))}if((c[m+20>>2]|0)<=(d|0)){i=v;return 0.0}if((l|0)>0){h=0;do{f=k+(h<<2)|0;e=c[f>>2]|0;if(a[e+20>>0]|0){r=Rr(b,c[e+28>>2]|0,+g[m+12>>2])|0;d=Rr(b,c[(c[f>>2]|0)+32>>2]|0,+g[m+12>>2])|0;s=c[b+16>>2]|0;q=c[f>>2]|0;oc[c[(c[q>>2]|0)+24>>2]&15](q,s+(r*244|0)|0,s+(d*244|0)|0,+g[m+12>>2])}h=h+1|0}while((h|0)!=(l|0))}e=c[m+64>>2]|0;p=c[b+28>>2]|0;if(e&512){if((p|0)<=0){i=v;return 0.0}h=0;do{j=c[(c[b+116>>2]|0)+(h<<2)>>2]|0;n=c[b+36>>2]|0;f=c[b+16>>2]|0;Lr(f+((c[n+(j*152|0)+144>>2]|0)*244|0)|0,f+((c[n+(j*152|0)+148>>2]|0)*244|0)|0,n+(j*152|0)|0);o=+g[n+(j*152|0)+100>>2];j=$(h,(e>>>4&1)+1|0)|0;n=c[(c[b+156>>2]|0)+(j<<2)>>2]|0;f=c[b+76>>2]|0;if(o>0.0){w=o*+g[f+(n*152|0)+104>>2];g[f+(n*152|0)+120>>2]=-w;g[f+(n*152|0)+124>>2]=w;d=c[b+16>>2]|0;Kr(d+((c[f+(n*152|0)+144>>2]|0)*244|0)|0,d+((c[f+(n*152|0)+148>>2]|0)*244|0)|0,f+(n*152|0)|0)}if((c[m+64>>2]&16|0)!=0?(t=c[(c[b+156>>2]|0)+(j+1<<2)>>2]|0,u=c[b+76>>2]|0,o>0.0):0){o=o*+g[u+(t*152|0)+104>>2];g[u+(t*152|0)+120>>2]=-o;g[u+(t*152|0)+124>>2]=o;d=c[b+16>>2]|0;Kr(d+((c[u+(t*152|0)+144>>2]|0)*244|0)|0,d+((c[u+(t*152|0)+148>>2]|0)*244|0)|0,u+(t*152|0)|0)}h=h+1|0}while((h|0)!=(p|0));i=v;return 0.0}if((p|0)>0){j=0;do{d=c[(c[b+116>>2]|0)+(j<<2)>>2]|0;s=c[b+36>>2]|0;r=c[b+16>>2]|0;Lr(r+((c[s+(d*152|0)+144>>2]|0)*244|0)|0,r+((c[s+(d*152|0)+148>>2]|0)*244|0)|0,s+(d*152|0)|0);j=j+1|0}while((j|0)!=(p|0))}f=c[b+68>>2]|0;if((f|0)>0){e=0;do{h=c[(c[b+156>>2]|0)+(e<<2)>>2]|0;j=c[b+76>>2]|0;o=+g[(c[b+36>>2]|0)+((c[j+(h*152|0)+140>>2]|0)*152|0)+100>>2];if(o>0.0){o=o*+g[j+(h*152|0)+104>>2];g[j+(h*152|0)+120>>2]=-o;g[j+(h*152|0)+124>>2]=o;d=c[b+16>>2]|0;Kr(d+((c[j+(h*152|0)+144>>2]|0)*244|0)|0,d+((c[j+(h*152|0)+148>>2]|0)*244|0)|0,j+(h*152|0)|0)}e=e+1|0}while((e|0)!=(f|0))}h=c[b+88>>2]|0;if((h|0)<=0){i=v;return 0.0}f=0;do{j=c[b+96>>2]|0;o=+g[(c[b+36>>2]|0)+((c[j+(f*152|0)+140>>2]|0)*152|0)+100>>2];if(o>0.0){w=+g[j+(f*152|0)+104>>2];o=o*w>w?w:o*w;g[j+(f*152|0)+120>>2]=-o;g[j+(f*152|0)+124>>2]=o;d=c[b+16>>2]|0;Kr(d+((c[j+(f*152|0)+144>>2]|0)*244|0)|0,d+((c[j+(f*152|0)+148>>2]|0)*244|0)|0,j+(f*152|0)|0)}f=f+1|0}while((f|0)!=(h|0));i=v;return 0.0}function Vr(a,b,d,e,f,g,h,j,k){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;f=i;if(!(c[j+44>>2]|0)){i=f;return}k=c[j+20>>2]|0;if(!(c[j+64>>2]&256)){if((k|0)<=0){i=f;return}b=0;do{g=c[a+28>>2]|0;if((g|0)>0){k=0;do{e=c[(c[a+116>>2]|0)+(k<<2)>>2]|0;d=c[a+36>>2]|0;h=c[a+16>>2]|0;Mr(h+((c[d+(e*152|0)+144>>2]|0)*244|0)|0,h+((c[d+(e*152|0)+148>>2]|0)*244|0)|0,d+(e*152|0)|0);k=k+1|0}while((k|0)!=(g|0));k=c[j+20>>2]|0}b=b+1|0}while((b|0)<(k|0));i=f;return}else{if((k|0)<=0){i=f;return}b=0;do{g=c[a+28>>2]|0;if((g|0)>0){k=0;do{e=c[(c[a+116>>2]|0)+(k<<2)>>2]|0;d=c[a+36>>2]|0;h=c[a+16>>2]|0;Mr(h+((c[d+(e*152|0)+144>>2]|0)*244|0)|0,h+((c[d+(e*152|0)+148>>2]|0)*244|0)|0,d+(e*152|0)|0);k=k+1|0}while((k|0)!=(g|0));k=c[j+20>>2]|0}b=b+1|0}while((b|0)<(k|0));i=f;return}}function Wr(a,b,d,e,f,h,j,k,l){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;k=k|0;l=l|0;var m=0,n=0,o=0;o=i;i=i+16|0;aE(4064);cc[c[(c[a>>2]|0)+32>>2]&1](a,b,d,e,f,h,j,k,l);n=c[a+184>>2]|0;m=c[k+20>>2]|0;m=(n|0)>(m|0)?n:m;if((m|0)>0){n=0;do{+gc[c[(c[a>>2]|0)+40>>2]&3](a,n,b,d,e,f,h,j,k,l);n=n+1|0}while((n|0)<(m|0))}m=c[5104]|0;f=(c[m+16>>2]|0)+-1|0;c[m+16>>2]=f;if(f){i=o;return 0.0}do if(c[m+4>>2]|0){Cb(o|0,0)|0;f=c[5090]|0;g[m+8>>2]=+(((c[o+4>>2]|0)-(c[f+4>>2]|0)+(((c[o>>2]|0)-(c[f>>2]|0)|0)*1e6|0)-(c[m+12>>2]|0)|0)>>>0)/1.0e3+ +g[m+8>>2];if(!(c[m+16>>2]|0)){m=c[5104]|0;break}else{i=o;return 0.0}}while(0);c[5104]=c[m+20>>2];i=o;return 0.0}function Xr(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var h=0,j=0,k=0,l=0,m=0.0,n=0.0,o=0.0,p=0,q=0,r=0.0,s=0;q=i;i=i+80|0;d=c[b+28>>2]|0;e=c[f+64>>2]|0;if((e&4|0)!=0&(d|0)>0){j=c[b+36>>2]|0;h=c[b+76>>2]|0;if(!(e&16)){e=0;do{k=c[j+(e*152|0)+132>>2]|0;g[k+120>>2]=+g[j+(e*152|0)+100>>2];g[k+124>>2]=+g[h+((c[j+(e*152|0)+140>>2]|0)*152|0)+100>>2];e=e+1|0}while((e|0)!=(d|0))}else{e=0;do{k=c[j+(e*152|0)+132>>2]|0;g[k+120>>2]=+g[j+(e*152|0)+100>>2];l=c[j+(e*152|0)+140>>2]|0;g[k+124>>2]=+g[h+(l*152|0)+100>>2];g[k+128>>2]=+g[h+((l+1|0)*152|0)+100>>2];e=e+1|0}while((e|0)!=(d|0))}}e=c[b+48>>2]|0;if((e|0)>0){k=0;do{d=c[b+56>>2]|0;h=c[d+(k*152|0)+132>>2]|0;j=c[h+44>>2]|0;l=d+(k*152|0)+100|0;if(j){m=+g[l>>2];s=c[h+28>>2]|0;n=1.0/+g[f+12>>2];o=m*+g[d+(k*152|0)+20>>2]*+g[s+352>>2]*n;r=m*+g[d+(k*152|0)+24>>2]*+g[s+356>>2]*n;g[j>>2]=+g[d+(k*152|0)+16>>2]*m*+g[s+348>>2]*n+ +g[j>>2];g[j+4>>2]=o+ +g[j+4>>2];g[j+8>>2]=r+ +g[j+8>>2];r=+g[l>>2];s=c[h+32>>2]|0;o=1.0/+g[f+12>>2];n=r*+g[d+(k*152|0)+52>>2]*+g[s+352>>2]*o;m=r*+g[d+(k*152|0)+56>>2]*+g[s+356>>2]*o;g[j+32>>2]=+g[d+(k*152|0)+48>>2]*r*+g[s+348>>2]*o+ +g[j+32>>2];g[j+36>>2]=n+ +g[j+36>>2];g[j+40>>2]=m+ +g[j+40>>2];s=c[h+28>>2]|0;m=+g[l>>2];n=1.0/+g[f+12>>2];o=+g[d+(k*152|0)+4>>2]*+g[s+548>>2]*m*n;r=m*(+g[d+(k*152|0)+8>>2]*+g[s+552>>2])*n;g[j+16>>2]=+g[d+(k*152|0)>>2]*+g[s+544>>2]*m*n+ +g[j+16>>2];g[j+20>>2]=o+ +g[j+20>>2];g[j+24>>2]=r+ +g[j+24>>2];s=c[h+32>>2]|0;r=+g[l>>2];o=1.0/+g[f+12>>2];n=+g[d+(k*152|0)+36>>2]*+g[s+548>>2]*r*o;m=r*(+g[d+(k*152|0)+40>>2]*+g[s+552>>2])*o;g[j+48>>2]=+g[d+(k*152|0)+32>>2]*+g[s+544>>2]*r*o+ +g[j+48>>2];g[j+52>>2]=n+ +g[j+52>>2];g[j+56>>2]=m+ +g[j+56>>2]}m=+g[l>>2];g[h+36>>2]=m;m=+O(+m);if(m>=+g[h+16>>2])a[h+20>>0]=0;k=k+1|0}while((k|0)!=(e|0))}d=c[b+8>>2]|0;if((d|0)>0){e=c[b+16>>2]|0;h=0;do{j=e+(h*244|0)|0;k=c[e+(h*244|0)+240>>2]|0;if(k){if(!(c[f+44>>2]|0)){l=e+(h*244|0)+176|0;m=+g[e+(h*244|0)+64>>2]+ +g[l>>2];g[l>>2]=m;l=e+(h*244|0)+180|0;n=+g[e+(h*244|0)+68>>2]+ +g[l>>2];g[l>>2]=n;l=e+(h*244|0)+184|0;o=+g[e+(h*244|0)+72>>2]+ +g[l>>2];g[l>>2]=o;l=e+(h*244|0)+192|0;g[l>>2]=+g[e+(h*244|0)+80>>2]+ +g[l>>2];l=e+(h*244|0)+196|0;g[l>>2]=+g[e+(h*244|0)+84>>2]+ +g[l>>2];l=e+(h*244|0)+200|0;g[l>>2]=+g[e+(h*244|0)+88>>2]+ +g[l>>2];l=e;e=k}else{o=+g[f+12>>2];n=+g[f+52>>2];k=e+(h*244|0)+176|0;g[k>>2]=+g[e+(h*244|0)+64>>2]+ +g[k>>2];k=e+(h*244|0)+180|0;g[k>>2]=+g[e+(h*244|0)+68>>2]+ +g[k>>2];k=e+(h*244|0)+184|0;g[k>>2]=+g[e+(h*244|0)+72>>2]+ +g[k>>2];k=e+(h*244|0)+192|0;g[k>>2]=+g[e+(h*244|0)+80>>2]+ +g[k>>2];k=e+(h*244|0)+196|0;g[k>>2]=+g[e+(h*244|0)+84>>2]+ +g[k>>2];k=e+(h*244|0)+200|0;g[k>>2]=+g[e+(h*244|0)+88>>2]+ +g[k>>2];k=e+(h*244|0)+144|0;l=e+(h*244|0)+148|0;if(!(((((!(+g[k>>2]!=0.0)?!(+g[l>>2]!=0.0):0)?!(+g[e+(h*244|0)+152>>2]!=0.0):0)?!(+g[e+(h*244|0)+160>>2]!=0.0):0)?!(+g[e+(h*244|0)+164>>2]!=0.0):0)?!(+g[e+(h*244|0)+168>>2]!=0.0):0))p=22;if((p|0)==22){p=0;r=+g[e+(h*244|0)+164>>2]*n;m=+g[e+(h*244|0)+168>>2]*n;g[q>>2]=+g[e+(h*244|0)+160>>2]*n;g[q+4>>2]=r;g[q+8>>2]=m;g[q+12>>2]=0.0;Ap(j,+g[k>>2],+g[l>>2],+g[e+(h*244|0)+152>>2],q,o,q+16|0);c[j+0>>2]=c[q+16>>2];c[j+4>>2]=c[q+20>>2];c[j+8>>2]=c[q+24>>2];c[j+12>>2]=c[q+28>>2];l=e+(h*244|0)+16|0;c[l+0>>2]=c[q+32>>2];c[l+4>>2]=c[q+36>>2];c[l+8>>2]=c[q+40>>2];c[l+12>>2]=c[q+44>>2];l=e+(h*244|0)+32|0;c[l+0>>2]=c[q+48>>2];c[l+4>>2]=c[q+52>>2];c[l+8>>2]=c[q+56>>2];c[l+12>>2]=c[q+60>>2];e=e+(h*244|0)+48|0;c[e+0>>2]=c[q+64>>2];c[e+4>>2]=c[q+68>>2];c[e+8>>2]=c[q+72>>2];c[e+12>>2]=c[q+76>>2];e=c[b+16>>2]|0}l=e;m=+g[e+(h*244|0)+176>>2];n=+g[e+(h*244|0)+180>>2];o=+g[e+(h*244|0)+184>>2];e=c[e+(h*244|0)+240>>2]|0}m=m+ +g[l+(h*244|0)+208>>2];n=n+ +g[l+(h*244|0)+212>>2];o=o+ +g[l+(h*244|0)+216>>2];k=e+260|0;c[k>>2]=(c[k>>2]|0)+1;g[e+312>>2]=m;g[e+316>>2]=n;g[e+320>>2]=o;g[e+324>>2]=0.0;k=c[b+16>>2]|0;l=c[k+(h*244|0)+240>>2]|0;o=+g[k+(h*244|0)+192>>2]+ +g[k+(h*244|0)+224>>2];n=+g[k+(h*244|0)+196>>2]+ +g[k+(h*244|0)+228>>2];m=+g[k+(h*244|0)+200>>2]+ +g[k+(h*244|0)+232>>2];c[l+260>>2]=(c[l+260>>2]|0)+1;g[l+328>>2]=o;g[l+332>>2]=n;g[l+336>>2]=m;g[l+340>>2]=0.0;if(c[f+44>>2]|0){k=c[b+16>>2]|0;l=c[k+(h*244|0)+240>>2]|0;j=k+(h*244|0)|0;c[l+260>>2]=(c[l+260>>2]|0)+1;c[l+4>>2]=c[j+0>>2];c[l+8>>2]=c[j+4>>2];c[l+12>>2]=c[j+8>>2];c[l+16>>2]=c[j+12>>2];j=k+(h*244|0)+16|0;c[l+20>>2]=c[j+0>>2];c[l+24>>2]=c[j+4>>2];c[l+28>>2]=c[j+8>>2];c[l+32>>2]=c[j+12>>2];j=k+(h*244|0)+32|0;c[l+36>>2]=c[j+0>>2];c[l+40>>2]=c[j+4>>2];c[l+44>>2]=c[j+8>>2];c[l+48>>2]=c[j+12>>2];k=k+(h*244|0)+48|0;c[l+52>>2]=c[k+0>>2];c[l+56>>2]=c[k+4>>2];c[l+60>>2]=c[k+8>>2];c[l+64>>2]=c[k+12>>2]}e=c[b+16>>2]|0;c[(c[e+(h*244|0)+240>>2]|0)+212>>2]=-1;d=c[b+8>>2]|0}h=h+1|0}while((h|0)<(d|0))}if((c[b+28>>2]|0)<0?(c[b+32>>2]|0)<0:0){d=c[b+36>>2]|0;if(d){if(a[b+40>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}c[b+36>>2]=0}a[b+40>>0]=1;c[b+36>>2]=0;c[b+32>>2]=0}c[b+28>>2]=0;if((c[b+48>>2]|0)<0?(c[b+52>>2]|0)<0:0){d=c[b+56>>2]|0;if(d){if(a[b+60>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}c[b+56>>2]=0}a[b+60>>0]=1;c[b+56>>2]=0;c[b+52>>2]=0}c[b+48>>2]=0;if((c[b+68>>2]|0)<0?(c[b+72>>2]|0)<0:0){d=c[b+76>>2]|0;if(d){if(a[b+80>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}c[b+76>>2]=0}a[b+80>>0]=1;c[b+76>>2]=0;c[b+72>>2]=0}c[b+68>>2]=0;if((c[b+88>>2]|0)<0?(c[b+92>>2]|0)<0:0){d=c[b+96>>2]|0;if(d){if(a[b+100>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}c[b+96>>2]=0}a[b+100>>0]=1;c[b+96>>2]=0;c[b+92>>2]=0}c[b+88>>2]=0;if((c[b+8>>2]|0)>=0){c[b+8>>2]=0;i=q;return 0.0}if((c[b+12>>2]|0)>=0){c[b+8>>2]=0;i=q;return 0.0}d=c[b+16>>2]|0;if(d){if(a[b+20>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}c[b+16>>2]=0}a[b+20>>0]=1;c[b+16>>2]=0;c[b+12>>2]=0;c[b+8>>2]=0;i=q;return 0.0}function Yr(a,b,d,e,f,h,j,k,l,m){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;k=k|0;l=l|0;m=m|0;var n=0;n=i;i=i+16|0;aE(4104);+ic[c[(c[a>>2]|0)+44>>2]&3](a,b,d,e,f,h,j,k,l);+ic[c[(c[a>>2]|0)+48>>2]&3](a,b,d,e,f,h,j,k,l);+mc[c[(c[a>>2]|0)+36>>2]&1](a,b,d,k);m=c[5104]|0;a=(c[m+16>>2]|0)+-1|0;c[m+16>>2]=a;if(a){i=n;return 0.0}do if(c[m+4>>2]|0){Cb(n|0,0)|0;a=c[5090]|0;g[m+8>>2]=+(((c[n+4>>2]|0)-(c[a+4>>2]|0)+(((c[n>>2]|0)-(c[a>>2]|0)|0)*1e6|0)-(c[m+12>>2]|0)|0)>>>0)/1.0e3+ +g[m+8>>2];if(!(c[m+16>>2]|0)){m=c[5104]|0;break}else{i=n;return 0.0}}while(0);c[5104]=c[m+20>>2];i=n;return 0.0}function Zr(a){a=a|0;c[a+192>>2]=0;return}function _r(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0;k=i;j=c[b+4>>2]|0;if((j|0)==(c[b+8>>2]|0)?(h=(j|0)==0?1:j<<1,(j|0)<(h|0)):0){if(!h){f=j;g=0}else{c[5108]=(c[5108]|0)+1;e=QE((h*244|3)+16|0)|0;if(!e)e=0;else{c[(e+19&-16)+-4>>2]=e;e=e+19&-16}f=c[b+4>>2]|0;g=e}if((f|0)>0){e=0;do{m=g+(e*244|0)|0;l=c[b+12>>2]|0;n=l+(e*244|0)|0;c[m+0>>2]=c[n+0>>2];c[m+4>>2]=c[n+4>>2];c[m+8>>2]=c[n+8>>2];c[m+12>>2]=c[n+12>>2];m=g+(e*244|0)+16|0;n=l+(e*244|0)+16|0;c[m+0>>2]=c[n+0>>2];c[m+4>>2]=c[n+4>>2];c[m+8>>2]=c[n+8>>2];c[m+12>>2]=c[n+12>>2];m=g+(e*244|0)+32|0;n=l+(e*244|0)+32|0;c[m+0>>2]=c[n+0>>2];c[m+4>>2]=c[n+4>>2];c[m+8>>2]=c[n+8>>2];c[m+12>>2]=c[n+12>>2];m=g+(e*244|0)+48|0;n=l+(e*244|0)+48|0;c[m+0>>2]=c[n+0>>2];c[m+4>>2]=c[n+4>>2];c[m+8>>2]=c[n+8>>2];c[m+12>>2]=c[n+12>>2];YE(g+(e*244|0)+64|0,l+(e*244|0)+64|0,180)|0;e=e+1|0}while((e|0)!=(f|0))}e=c[b+12>>2]|0;if(e){if(a[b+16>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[e+-4>>2]|0)}c[b+12>>2]=0}a[b+16>>0]=1;c[b+12>>2]=g;c[b+8>>2]=h;e=c[b+4>>2]|0}else e=j;c[b+4>>2]=e+1;m=c[b+12>>2]|0;c[m+(j*244|0)+0>>2]=c[d+0>>2];c[m+(j*244|0)+4>>2]=c[d+4>>2];c[m+(j*244|0)+8>>2]=c[d+8>>2];c[m+(j*244|0)+12>>2]=c[d+12>>2];c[m+(j*244|0)+16>>2]=c[d+16>>2];c[m+(j*244|0)+20>>2]=c[d+20>>2];c[m+(j*244|0)+24>>2]=c[d+24>>2];c[m+(j*244|0)+28>>2]=c[d+28>>2];c[m+(j*244|0)+32>>2]=c[d+32>>2];c[m+(j*244|0)+36>>2]=c[d+36>>2];c[m+(j*244|0)+40>>2]=c[d+40>>2];c[m+(j*244|0)+44>>2]=c[d+44>>2];c[m+(j*244|0)+48>>2]=c[d+48>>2];c[m+(j*244|0)+52>>2]=c[d+52>>2];c[m+(j*244|0)+56>>2]=c[d+56>>2];c[m+(j*244|0)+60>>2]=c[d+60>>2];YE(m+(j*244|0)+64|0,d+64|0,180)|0;i=k;return (c[b+12>>2]|0)+(j*244|0)|0}function $r(a){a=a|0;return 1}function as(a,b,c){a=a|0;b=b|0;c=c|0;return}function bs(a,b,c){a=a|0;b=b|0;c=c|0;return}function cs(b){b=b|0;var d=0,e=0;e=i;c[b>>2]=4840;d=c[b+144>>2]|0;if(d){if(a[b+148>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}c[b+144>>2]=0}a[b+148>>0]=1;c[b+144>>2]=0;c[b+136>>2]=0;c[b+140>>2]=0;d=c[b+76>>2]|0;if(d){if(a[b+80>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}c[b+76>>2]=0}a[b+80>>0]=1;c[b+76>>2]=0;c[b+68>>2]=0;c[b+72>>2]=0;d=c[b+56>>2]|0;if(d){if(a[b+60>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}c[b+56>>2]=0}a[b+60>>0]=1;c[b+56>>2]=0;c[b+48>>2]=0;c[b+52>>2]=0;d=c[b+36>>2]|0;if(d){if(a[b+40>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}c[b+36>>2]=0}a[b+40>>0]=1;c[b+36>>2]=0;c[b+28>>2]=0;c[b+32>>2]=0;d=c[b+16>>2]|0;if(!d){a[b+20>>0]=1;c[b+16>>2]=0;c[b+8>>2]=0;d=b+12|0;c[d>>2]=0;i=e;return}if(a[b+20>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}c[b+16>>2]=0;a[b+20>>0]=1;c[b+16>>2]=0;c[b+8>>2]=0;d=b+12|0;c[d>>2]=0;i=e;return}function ds(a){a=a|0;var b=0;b=i;cs(a);RE(a);i=b;return}function es(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,h=0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0;h=i;i=i+64|0;a[d+84>>0]=0;c[h+0>>2]=c[b+4>>2];c[h+4>>2]=c[b+8>>2];c[h+8>>2]=c[b+12>>2];c[h+12>>2]=c[b+16>>2];c[h+16>>2]=c[b+20>>2];c[h+20>>2]=c[b+24>>2];c[h+24>>2]=c[b+28>>2];c[h+28>>2]=c[b+32>>2];c[h+32>>2]=c[b+36>>2];c[h+36>>2]=c[b+40>>2];c[h+40>>2]=c[b+44>>2];c[h+44>>2]=c[b+48>>2];c[h+48>>2]=c[b+52>>2];c[h+52>>2]=c[b+56>>2];c[h+56>>2]=c[b+60>>2];c[h+60>>2]=c[b+64>>2];if(e?(f=c[b+480>>2]|0,(f|0)!=0):0)Lb[c[(c[f>>2]|0)+8>>2]&127](f,h);w=+g[d+156>>2];u=+g[h>>2];v=+g[d+160>>2];t=+g[h+4>>2];o=+g[d+164>>2];s=+g[h+8>>2];r=+g[h+16>>2];q=+g[h+20>>2];p=+g[h+24>>2];n=+g[h+32>>2];l=+g[h+36>>2];j=+g[h+40>>2];m=w*r+v*q+o*p+ +g[h+52>>2];k=w*n+v*l+o*j+ +g[h+56>>2];g[d+36>>2]=w*u+v*t+o*s+ +g[h+48>>2];g[d+40>>2]=m;g[d+44>>2]=k;g[d+48>>2]=0.0;k=+g[d+172>>2];m=+g[d+176>>2];o=+g[d+180>>2];g[d+52>>2]=u*k+t*m+s*o;g[d+56>>2]=k*r+m*q+o*p;g[d+60>>2]=k*n+m*l+o*j;g[d+64>>2]=0.0;o=+g[d+188>>2];m=+g[d+192>>2];k=+g[d+196>>2];g[d+68>>2]=u*o+t*m+s*k;g[d+72>>2]=o*r+m*q+k*p;g[d+76>>2]=o*n+m*l+k*j;g[d+80>>2]=0.0;i=h;return}function fs(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0.0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0;e=i;es(a,b+(c*284|0)|0,d);o=+g[b+(c*284|0)+52>>2];j=+g[b+(c*284|0)+56>>2];s=+g[b+(c*284|0)+60>>2];I=+g[b+(c*284|0)+76>>2];B=+g[b+(c*284|0)+72>>2];A=+g[b+(c*284|0)+68>>2];y=1.0/+P(+((B*-o-A*-j)*(B*-o-A*-j)+((I*-j-B*-s)*(I*-j-B*-s)+(A*-s-I*-o)*(A*-s-I*-o))));x=(I*-j-B*-s)*y;w=y*(A*-s-I*-o);y=y*(B*-o-A*-j);f=+g[b+(c*284|0)+232>>2]*.5;m=+S(+f)/+P(+(o*o+j*j+s*s));f=+R(+f);n=2.0/(f*f+(m*-s*(m*-s)+(m*-o*(m*-o)+m*-j*(m*-j))));G=1.0-(m*-j*(m*-j*n)+m*-s*(m*-s*n));F=m*-o*(m*-j*n)-f*(m*-s*n);H=m*-o*(m*-s*n)+f*(m*-j*n);D=m*-o*(m*-j*n)+f*(m*-s*n);C=1.0-(m*-o*(m*-o*n)+m*-s*(m*-s*n));E=m*-j*(m*-s*n)-f*(m*-o*n);l=m*-o*(m*-s*n)-f*(m*-j*n);f=m*-j*(m*-s*n)+f*(m*-o*n);n=1.0-(m*-o*(m*-o*n)+m*-j*(m*-j*n));m=+g[b+(c*284|0)+236>>2]*-.5;z=+S(+m)/+P(+(I*I+(B*B+A*A)));m=+R(+m);t=2.0/(m*m+(I*z*(I*z)+(A*z*(A*z)+B*z*(B*z))));p=1.0-(B*z*(B*z*t)+I*z*(I*z*t));k=A*z*(B*z*t)-m*(I*z*t);v=A*z*(I*z*t)+m*(B*z*t);q=A*z*(B*z*t)+m*(I*z*t);h=1.0-(A*z*(A*z*t)+I*z*(I*z*t));u=B*z*(I*z*t)-m*(A*z*t);r=A*z*(I*z*t)-m*(B*z*t);m=B*z*(I*z*t)+m*(A*z*t);t=1.0-(A*z*(A*z*t)+B*z*(B*z*t));z=+g[b+(c*284|0)+72>>2];B=+g[b+(c*284|0)+76>>2];g[b+(c*284|0)+92>>2]=B*(G*v+F*u+H*t)+(A*(H*r+(F*q+G*p))+z*(H*m+(G*k+F*h)));g[b+(c*284|0)+96>>2]=y*(G*v+F*u+H*t)+(x*(H*r+(F*q+G*p))+w*(H*m+(G*k+F*h)));g[b+(c*284|0)+100>>2]=(G*v+F*u+H*t)*-s+((H*r+(F*q+G*p))*-o+(H*m+(G*k+F*h))*-j);g[b+(c*284|0)+104>>2]=0.0;g[b+(c*284|0)+108>>2]=B*(D*v+C*u+E*t)+(A*(E*r+(C*q+D*p))+z*(E*m+(D*k+C*h)));g[b+(c*284|0)+112>>2]=y*(D*v+C*u+E*t)+(x*(E*r+(C*q+D*p))+w*(E*m+(D*k+C*h)));g[b+(c*284|0)+116>>2]=(D*v+C*u+E*t)*-s+((E*r+(C*q+D*p))*-o+(E*m+(D*k+C*h))*-j);g[b+(c*284|0)+120>>2]=0.0;g[b+(c*284|0)+124>>2]=B*(l*v+f*u+n*t)+(A*(n*r+(f*q+l*p))+z*(n*m+(l*k+f*h)));g[b+(c*284|0)+128>>2]=y*(l*v+f*u+n*t)+(x*(n*r+(f*q+l*p))+w*(n*m+(l*k+f*h)));g[b+(c*284|0)+132>>2]=(l*v+f*u+n*t)*-s+((n*r+(f*q+l*p))*-o+(n*m+(l*k+f*h))*-j);g[b+(c*284|0)+136>>2]=0.0;j=+g[b+(c*284|0)+32>>2];h=j*+g[b+(c*284|0)+56>>2]+ +g[b+(c*284|0)+40>>2];f=j*+g[b+(c*284|0)+60>>2]+ +g[b+(c*284|0)+44>>2];g[b+(c*284|0)+140>>2]=+g[b+(c*284|0)+52>>2]*j+ +g[b+(c*284|0)+36>>2];g[b+(c*284|0)+144>>2]=h;g[b+(c*284|0)+148>>2]=f;g[b+(c*284|0)+152>>2]=0.0;i=e;return}function gs(b,d){b=b|0;d=+d;var e=0,f=0,h=0.0,j=0,k=0,l=0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0.0,G=0.0;D=i;i=i+96|0;e=c[b+136>>2]|0;if((e|0)>0){f=0;do{fs(c[b+116>>2]|0,c[b+144>>2]|0,f,0);f=f+1|0;e=c[b+136>>2]|0}while((f|0)<(e|0));C=b+116|0}else C=b+116|0;f=c[C>>2]|0;s=+g[f+312>>2];u=+g[f+316>>2];h=+g[f+320>>2];h=+P(+(s*s+u*u+h*h))*3.5999999046325684;g[b+112>>2]=h;z=c[b+128>>2]|0;if(+g[f+(z<<2)+4>>2]*+g[f+312>>2]+ +g[f+(z<<2)+20>>2]*+g[f+316>>2]+ +g[f+(z<<2)+36>>2]*+g[f+320>>2]<0.0)g[b+112>>2]=-h;a:do if((e|0)>0){B=0;do{A=c[b+144>>2]|0;e=A+(B*284|0)|0;es(f,e,0);j=A+(B*284|0)+204|0;k=A+(B*284|0)+212|0;q=+g[j>>2]+ +g[k>>2];f=A+(B*284|0)+52|0;v=A+(B*284|0)+56|0;w=A+(B*284|0)+60|0;E=A+(B*284|0)+36|0;x=A+(B*284|0)+16|0;s=q*+g[v>>2]+ +g[A+(B*284|0)+40>>2];u=q*+g[w>>2]+ +g[A+(B*284|0)+44>>2];g[A+(B*284|0)+16>>2]=+g[f>>2]*q+ +g[E>>2];y=A+(B*284|0)+20|0;g[y>>2]=s;z=A+(B*284|0)+24|0;g[z>>2]=u;g[A+(B*284|0)+28>>2]=0.0;g[D+64>>2]=-1.0;l=c[b+100>>2]|0;E=Rb[c[(c[l>>2]|0)+8>>2]&31](l,E,x,D+32|0)|0;l=A+(B*284|0)+88|0;c[l>>2]=0;do if(E){q=q*+g[D+64>>2];c[e+0>>2]=c[D+48>>2];c[e+4>>2]=c[D+52>>2];c[e+8>>2]=c[D+56>>2];c[e+12>>2]=c[D+60>>2];a[A+(B*284|0)+84>>0]=1;if((a[4824]|0)==0?(Xa(4824)|0)!=0:0){c[D+72>>2]=0;c[D+76>>2]=0;c[D+80>>2]=0;c[D+84>>2]=0;tp(4208,0.0,0,0,D+72|0);ab(4824)}c[1103]=c[1103]|1;g[1138]=0.0;p=+g[1148]*0.0;o=+g[1149]*0.0;g[1143]=+g[1147]*0.0;g[1144]=p;g[1145]=o;g[1146]=0.0;c[1151]=0;c[1152]=0;c[1153]=0;c[1154]=0;o=+g[1140]*0.0;p=+g[1141]*0.0;g[1192]=+g[1139]*0.0;g[1193]=o;g[1194]=p;g[1195]=0.0;c[l>>2]=4208;q=q-+g[k>>2];l=A+(B*284|0)+32|0;g[l>>2]=q;p=+g[j>>2];o=+g[A+(B*284|0)+208>>2]*.009999999776482582;if(q<p-o){g[l>>2]=p-o;q=p-o}if(q>p+o)g[l>>2]=p+o;c[x+0>>2]=c[D+32>>2];c[x+4>>2]=c[D+36>>2];c[x+8>>2]=c[D+40>>2];c[x+12>>2]=c[D+44>>2];s=+g[e>>2];t=+g[A+(B*284|0)+4>>2];u=+g[A+(B*284|0)+8>>2];r=s*+g[f>>2]+t*+g[v>>2]+u*+g[w>>2];l=c[C>>2]|0;h=+g[x>>2]-+g[l+52>>2];m=+g[y>>2]-+g[l+56>>2];n=+g[z>>2]-+g[l+60>>2];q=+g[l+332>>2];p=+g[l+336>>2];o=+g[l+328>>2];if(!(r>=-.10000000149011612)){g[A+(B*284|0)+272>>2]=-1.0/r*(s*(q*n-m*p+ +g[l+312>>2])+t*(h*p-n*o+ +g[l+316>>2])+u*(m*o-h*q+ +g[l+320>>2]));g[A+(B*284|0)+268>>2]=-1.0/r;break}else{g[A+(B*284|0)+272>>2]=0.0;g[A+(B*284|0)+268>>2]=10.0;break}}else{g[A+(B*284|0)+32>>2]=+g[j>>2];g[A+(B*284|0)+272>>2]=0.0;s=-+g[v>>2];u=-+g[w>>2];g[e>>2]=-+g[f>>2];g[A+(B*284|0)+4>>2]=s;g[A+(B*284|0)+8>>2]=u;g[A+(B*284|0)+12>>2]=0.0;g[A+(B*284|0)+268>>2]=1.0}while(0);B=B+1|0;l=c[b+136>>2]|0;f=c[C>>2]|0}while((B|0)<(l|0));h=1.0/+g[f+344>>2];if((l|0)>0){j=c[b+144>>2]|0;k=0;do{if(a[j+(k*284|0)+84>>0]|0){u=+g[j+(k*284|0)+272>>2];u=h*(+g[j+(k*284|0)+216>>2]*(+g[j+(k*284|0)+204>>2]-+g[j+(k*284|0)+32>>2])*+g[j+(k*284|0)+268>>2]-u*+g[(u<0.0?j+(k*284|0)+220|0:j+(k*284|0)+224|0)>>2]);e=j+(k*284|0)+276|0;g[e>>2]=u;if(u<0.0)g[e>>2]=0.0}else g[j+(k*284|0)+276>>2]=0.0;k=k+1|0}while((k|0)!=(l|0));e=f;f=0;while(1){r=+g[j+(f*284|0)+276>>2];u=+g[j+(f*284|0)+248>>2];r=r>u?u:r;u=r*+g[j+(f*284|0)+4>>2]*d;s=r*+g[j+(f*284|0)+8>>2]*d;g[D+16>>2]=+g[j+(f*284|0)>>2]*r*d;g[D+20>>2]=u;g[D+24>>2]=s;g[D+28>>2]=0.0;s=+g[j+(f*284|0)+20>>2]-+g[e+56>>2];u=+g[j+(f*284|0)+24>>2]-+g[e+60>>2];g[D>>2]=+g[j+(f*284|0)+16>>2]-+g[e+52>>2];g[D+4>>2]=s;g[D+8>>2]=u;g[D+12>>2]=0.0;bn(e,D+16|0,D);f=f+1|0;if((f|0)>=(c[b+136>>2]|0))break a;j=c[b+144>>2]|0;e=c[C>>2]|0}}}while(0);Ib[c[(c[b>>2]|0)+20>>2]&31](b,d);j=c[b+136>>2]|0;if((j|0)<=0){i=D;return}f=c[b+144>>2]|0;l=c[C>>2]|0;k=0;do{o=+g[f+(k*284|0)+36>>2]-+g[l+52>>2];q=+g[f+(k*284|0)+40>>2]-+g[l+56>>2];p=+g[f+(k*284|0)+44>>2]-+g[l+60>>2];h=+g[l+332>>2];m=+g[l+336>>2];n=+g[l+328>>2];if(!(a[f+(k*284|0)+84>>0]|0)){h=+g[f+(k*284|0)+240>>2];z=f+(k*284|0)+236|0;g[z>>2]=h+ +g[z>>2]}else{z=c[b+128>>2]|0;G=+g[l+(z<<2)+4>>2];t=+g[l+(z<<2)+20>>2];s=+g[l+(z<<2)+36>>2];F=+g[f+(k*284|0)>>2];r=+g[f+(k*284|0)+4>>2];u=+g[f+(k*284|0)+8>>2];h=((q*n-o*h+ +g[l+320>>2])*(s-u*(G*F+t*r+s*u))+((h*p-q*m+ +g[l+312>>2])*(G-F*(G*F+t*r+s*u))+(o*m-p*n+ +g[l+316>>2])*(t-r*(G*F+t*r+s*u))))*d/+g[f+(k*284|0)+212>>2];g[f+(k*284|0)+240>>2]=h;z=f+(k*284|0)+236|0;g[z>>2]=h+ +g[z>>2]}g[f+(k*284|0)+240>>2]=h*.9900000095367432;k=k+1|0}while((k|0)!=(j|0));i=D;return}function hs(b,d){b=b|0;d=+d;var e=0,f=0,h=0,j=0,k=0.0,l=0,m=0.0,n=0,o=0,p=0.0,q=0,r=0.0,s=0,t=0,u=0.0,v=0.0,w=0.0,x=0.0,y=0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,N=0.0,O=0.0,Q=0.0,R=0.0;t=i;i=i+384|0;o=c[b+136>>2]|0;if(!o){i=t;return}f=c[b+8>>2]|0;if((f|0)<(o|0)){if((c[b+12>>2]|0)<(o|0)){c[5108]=(c[5108]|0)+1;e=QE((o<<4|3)+16|0)|0;if(!e)l=0;else{c[(e+19&-16)+-4>>2]=e;l=e+19&-16}j=c[b+8>>2]|0;if((j|0)>0){h=0;do{n=l+(h<<4)|0;q=(c[b+16>>2]|0)+(h<<4)|0;c[n+0>>2]=c[q+0>>2];c[n+4>>2]=c[q+4>>2];c[n+8>>2]=c[q+8>>2];c[n+12>>2]=c[q+12>>2];h=h+1|0}while((h|0)!=(j|0))}h=c[b+16>>2]|0;if(h){if(a[b+20>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[h+-4>>2]|0)}c[b+16>>2]=0}a[b+20>>0]=1;c[b+16>>2]=l;c[b+12>>2]=o;j=b+16|0}else j=b+16|0;e=f;do{n=(c[j>>2]|0)+(e<<4)|0;c[n+0>>2]=c[t+144>>2];c[n+4>>2]=c[t+148>>2];c[n+8>>2]=c[t+152>>2];c[n+12>>2]=c[t+156>>2];e=e+1|0}while((e|0)!=(o|0))}c[b+8>>2]=o;f=c[b+28>>2]|0;if((f|0)<(o|0)){if((c[b+32>>2]|0)<(o|0)){c[5108]=(c[5108]|0)+1;e=QE((o<<4|3)+16|0)|0;if(!e)l=0;else{c[(e+19&-16)+-4>>2]=e;l=e+19&-16}j=c[b+28>>2]|0;if((j|0)>0){h=0;do{n=l+(h<<4)|0;q=(c[b+36>>2]|0)+(h<<4)|0;c[n+0>>2]=c[q+0>>2];c[n+4>>2]=c[q+4>>2];c[n+8>>2]=c[q+8>>2];c[n+12>>2]=c[q+12>>2];h=h+1|0}while((h|0)!=(j|0))}e=c[b+36>>2]|0;if(e){if(a[b+40>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[e+-4>>2]|0)}c[b+36>>2]=0}a[b+40>>0]=1;c[b+36>>2]=l;c[b+32>>2]=o;j=b+36|0}else j=b+36|0;e=f;do{n=(c[j>>2]|0)+(e<<4)|0;c[n+0>>2]=c[t+128>>2];c[n+4>>2]=c[t+132>>2];c[n+8>>2]=c[t+136>>2];c[n+12>>2]=c[t+140>>2];e=e+1|0}while((e|0)!=(o|0))}c[b+28>>2]=o;j=c[b+48>>2]|0;if((j|0)<(o|0)){if((c[b+52>>2]|0)<(o|0)){c[5108]=(c[5108]|0)+1;e=QE((o<<2|3)+16|0)|0;if(!e)f=0;else{c[(e+19&-16)+-4>>2]=e;f=e+19&-16}h=c[b+48>>2]|0;if((h|0)>0){l=0;do{e=f+(l<<2)|0;if(e)g[e>>2]=+g[(c[b+56>>2]|0)+(l<<2)>>2];l=l+1|0}while((l|0)!=(h|0))}e=c[b+56>>2]|0;if(e){if(a[b+60>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[e+-4>>2]|0)}c[b+56>>2]=0}a[b+60>>0]=1;c[b+56>>2]=f;c[b+52>>2]=o}else f=c[b+56>>2]|0;do{h=f+(j<<2)|0;if(h)g[h>>2]=0.0;j=j+1|0}while((j|0)!=(o|0))}c[b+48>>2]=o;j=c[b+68>>2]|0;if((j|0)<(o|0)){if((c[b+72>>2]|0)<(o|0)){c[5108]=(c[5108]|0)+1;e=QE((o<<2|3)+16|0)|0;if(!e)f=0;else{c[(e+19&-16)+-4>>2]=e;f=e+19&-16}h=c[b+68>>2]|0;if((h|0)>0){l=0;do{e=f+(l<<2)|0;if(e)g[e>>2]=+g[(c[b+76>>2]|0)+(l<<2)>>2];l=l+1|0}while((l|0)!=(h|0))}e=c[b+76>>2]|0;if(e){if(a[b+80>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[e+-4>>2]|0)}c[b+76>>2]=0}a[b+80>>0]=1;c[b+76>>2]=f;c[b+72>>2]=o}else f=c[b+76>>2]|0;do{h=f+(j<<2)|0;if(h)g[h>>2]=0.0;j=j+1|0}while((j|0)!=(o|0))}c[b+68>>2]=o;e=c[b+136>>2]|0;if((e|0)<=0){i=t;return}f=c[b+76>>2]|0;h=c[b+56>>2]|0;j=0;do{g[f+(j<<2)>>2]=0.0;g[h+(j<<2)>>2]=0.0;j=j+1|0}while((j|0)!=(e|0));q=0;do{n=c[b+144>>2]|0;o=c[n+(q*284|0)+88>>2]|0;if(o){l=n+(q*284|0)+92|0;c[t+80>>2]=c[l+0>>2];c[t+84>>2]=c[l+4>>2];c[t+88>>2]=c[l+8>>2];c[t+92>>2]=c[l+12>>2];l=n+(q*284|0)+108|0;c[t+96>>2]=c[l+0>>2];c[t+100>>2]=c[l+4>>2];c[t+104>>2]=c[l+8>>2];c[t+108>>2]=c[l+12>>2];l=n+(q*284|0)+124|0;c[t+112>>2]=c[l+0>>2];c[t+116>>2]=c[l+4>>2];c[t+120>>2]=c[l+8>>2];c[t+124>>2]=c[l+12>>2];l=c[b+36>>2]|0;y=c[b+120>>2]|0;p=+g[t+80+(y<<2)+16>>2];z=+g[t+80+(y<<2)+32>>2];g[l+(q<<4)>>2]=+g[t+80+(y<<2)>>2];g[l+(q<<4)+4>>2]=p;g[l+(q<<4)+8>>2]=z;g[l+(q<<4)+12>>2]=0.0;l=c[b+36>>2]|0;y=l+(q<<4)|0;z=+g[y>>2];h=n+(q*284|0)|0;p=+g[h>>2];e=l+(q<<4)+4|0;x=+g[e>>2];j=n+(q*284|0)+4|0;m=+g[j>>2];l=l+(q<<4)+8|0;u=+g[l>>2];f=n+(q*284|0)+8|0;w=+g[f>>2];k=z-p*(z*p+x*m+u*w);v=x-m*(z*p+x*m+u*w);w=u-w*(z*p+x*m+u*w);u=1.0/+P(+(k*k+v*v+w*w));g[y>>2]=k*u;g[e>>2]=v*u;g[l>>2]=w*u;l=c[b+16>>2]|0;m=+g[j>>2];x=+g[f>>2];p=+g[h>>2];g[l+(q<<4)>>2]=m*(w*u)-x*(v*u);g[l+(q<<4)+4>>2]=x*(k*u)-w*u*p;g[l+(q<<4)+8>>2]=v*u*p-m*(k*u);g[l+(q<<4)+12>>2]=0.0;l=c[b+16>>2]|0;h=l+(q<<4)|0;u=+g[h>>2];f=l+(q<<4)+4|0;k=+g[f>>2];l=l+(q<<4)+8|0;m=+g[l>>2];p=1.0/+P(+(u*u+k*k+m*m));g[h>>2]=u*p;g[f>>2]=k*p;g[l>>2]=m*p;l=c[b+116>>2]|0;f=c[b+36>>2]|0;h=f+(q<<4)|0;j=(c[b+76>>2]|0)+(q<<2)|0;p=+g[h>>2];e=f+(q<<4)+4|0;m=+g[e>>2];f=f+(q<<4)+8|0;k=+g[f>>2];if(p*p+m*m+k*k>1.100000023841858)g[j>>2]=0.0;else{k=+g[n+(q*284|0)+16>>2];w=k-+g[l+52>>2];u=+g[n+(q*284|0)+20>>2];B=u-+g[l+56>>2];m=+g[n+(q*284|0)+24>>2];D=m-+g[l+60>>2];g[t+360>>2]=w;g[t+364>>2]=B;g[t+368>>2]=D;g[t+372>>2]=0.0;k=k-+g[o+52>>2];u=u-+g[o+56>>2];m=m-+g[o+60>>2];g[t+344>>2]=k;g[t+348>>2]=u;g[t+352>>2]=m;g[t+356>>2]=0.0;x=+g[l+332>>2];E=+g[l+336>>2];A=+g[l+328>>2];p=+g[o+332>>2];C=+g[o+336>>2];z=+g[o+328>>2];v=x*D-E*B+ +g[l+312>>2]-(p*m-C*u+ +g[o+312>>2]);m=+g[l+316>>2]+(E*w-D*A)-(+g[o+316>>2]+(C*k-m*z));k=B*A-x*w+ +g[l+320>>2]-(u*z-p*k+ +g[o+320>>2]);g[t+208>>2]=+g[l+4>>2];g[t+212>>2]=+g[l+20>>2];g[t+216>>2]=+g[l+36>>2];g[t+220>>2]=0.0;g[t+224>>2]=+g[l+8>>2];g[t+228>>2]=+g[l+24>>2];g[t+232>>2]=+g[l+40>>2];g[t+236>>2]=0.0;g[t+240>>2]=+g[l+12>>2];g[t+244>>2]=+g[l+28>>2];g[t+248>>2]=+g[l+44>>2];g[t+252>>2]=0.0;g[t+160>>2]=+g[o+4>>2];g[t+164>>2]=+g[o+20>>2];g[t+168>>2]=+g[o+36>>2];g[t+172>>2]=0.0;g[t+176>>2]=+g[o+8>>2];g[t+180>>2]=+g[o+24>>2];g[t+184>>2]=+g[o+40>>2];g[t+188>>2]=0.0;g[t+192>>2]=+g[o+12>>2];g[t+196>>2]=+g[o+28>>2];g[t+200>>2]=+g[o+44>>2];g[t+204>>2]=0.0;Kq(t+256|0,t+208|0,t+160|0,t+360|0,t+344|0,h,l+396|0,+g[l+344>>2],o+396|0,+g[o+344>>2]);g[j>>2]=1.0/+g[t+336>>2]*((v*+g[h>>2]+m*+g[e>>2]+k*+g[f>>2])*-.20000000298023224)}e=c[b+136>>2]|0}q=q+1|0}while((q|0)<(e|0));if((e|0)<=0){i=t;return}h=c[b+144>>2]|0;l=0;q=0;while(1){j=c[h+(q*284|0)+88>>2]|0;if(j){m=+g[h+(q*284|0)+252>>2];if(m!=0.0){n=c[b+56>>2]|0;j=n+(q<<2)|0;g[j>>2]=0.0;f=h+(q*284|0)+280|0;g[f>>2]=1.0;o=h;m=m*d}else{x=+g[h+(q*284|0)+256>>2];x=x!=0.0?x:0.0;o=c[b+116>>2]|0;n=c[b+16>>2]|0;k=+g[h+(q*284|0)+16>>2];B=+g[h+(q*284|0)+20>>2];F=+g[h+(q*284|0)+24>>2];H=+g[n+(q<<4)>>2];C=+g[n+(q<<4)+4>>2];m=+g[n+(q<<4)+8>>2];O=k-+g[o+52>>2];Q=B-+g[o+56>>2];M=F-+g[o+60>>2];L=+g[o+264>>2]*(Q*m-M*C)+ +g[o+280>>2]*(M*H-O*m)+(O*C-Q*H)*+g[o+296>>2];R=(Q*m-M*C)*+g[o+268>>2]+(M*H-O*m)*+g[o+284>>2]+(O*C-Q*H)*+g[o+300>>2];N=(Q*m-M*C)*+g[o+272>>2]+(M*H-O*m)*+g[o+288>>2]+(O*C-Q*H)*+g[o+304>>2];u=k-+g[j+52>>2];p=B-+g[j+56>>2];D=F-+g[j+60>>2];I=(C*u-H*p)*+g[j+296>>2]+(+g[j+264>>2]*(m*p-C*D)+ +g[j+280>>2]*(H*D-m*u));K=(m*p-C*D)*+g[j+268>>2]+(H*D-m*u)*+g[j+284>>2]+(C*u-H*p)*+g[j+300>>2];J=(m*p-C*D)*+g[j+272>>2]+(H*D-m*u)*+g[j+288>>2]+(C*u-H*p)*+g[j+304>>2];k=k-+g[o+52>>2];B=B-+g[o+56>>2];F=F-+g[o+60>>2];v=+g[o+332>>2];G=+g[o+336>>2];A=+g[o+328>>2];w=+g[j+332>>2];E=+g[j+336>>2];z=+g[j+328>>2];m=-(1.0/(+g[o+344>>2]+(m*(Q*L-O*R)+(H*(M*R-Q*N)+C*(O*N-M*L)))+(+g[j+344>>2]+(m*(p*I-u*K)+(H*(D*K-p*J)+C*(u*J-D*I)))))*((F*v-B*G+ +g[o+312>>2]-(D*w-p*E+ +g[j+312>>2]))*H+(+g[o+316>>2]+(k*G-F*A)-(+g[j+316>>2]+(u*E-D*z)))*C+(B*A-k*v+ +g[o+320>>2]-(p*z-u*w+ +g[j+320>>2]))*m));m=x<m?x:m;o=c[b+144>>2]|0;n=c[b+56>>2]|0;j=n+(q<<2)|0;g[j>>2]=0.0;f=o+(q*284|0)+280|0;g[f>>2]=1.0;m=m<-x?-x:m}g[f>>2]=1.0;p=+g[h+(q*284|0)+276>>2]*d*+g[h+(q*284|0)+228>>2];g[j>>2]=m;m=m*.5;k=+g[(c[b+76>>2]|0)+(q<<2)>>2];if(m*m+k*k>p*p){J=p/+P(+(m*m+k*k));g[f>>2]=J*+g[f>>2];l=1}}else{n=c[b+56>>2]|0;g[n+(q<<2)>>2]=0.0;g[h+(q*284|0)+280>>2]=1.0;o=h}q=q+1|0;e=c[b+136>>2]|0;if((q|0)>=(e|0))break;else h=o}if(l){if((e|0)<=0){i=t;return}j=c[b+76>>2]|0;f=0;do{h=j+(f<<2)|0;if(+g[h>>2]!=0.0?(s=o+(f*284|0)+280|0,r=+g[s>>2],r<1.0):0){l=n+(f<<2)|0;g[l>>2]=r*+g[l>>2];g[h>>2]=+g[s>>2]*+g[h>>2]}f=f+1|0}while((f|0)!=(e|0))}if((e|0)<=0){i=t;return}f=o;j=n;e=0;while(1){l=c[b+116>>2]|0;o=f+(e*284|0)+16|0;m=+g[o>>2]-+g[l+52>>2];h=f+(e*284|0)+20|0;p=+g[h>>2]-+g[l+56>>2];n=f+(e*284|0)+24|0;d=+g[n>>2]-+g[l+60>>2];g[t+64>>2]=m;g[t+68>>2]=p;g[t+72>>2]=d;g[t+76>>2]=0.0;k=+g[j+(e<<2)>>2];if(k!=0.0){j=c[b+16>>2]|0;I=k*+g[j+(e<<4)+4>>2];J=k*+g[j+(e<<4)+8>>2];g[t+48>>2]=k*+g[j+(e<<4)>>2];g[t+52>>2]=I;g[t+56>>2]=J;g[t+60>>2]=0.0;bn(l,t+48|0,t+64|0)}k=+g[(c[b+76>>2]|0)+(e<<2)>>2];if(k!=0.0){l=c[(c[b+144>>2]|0)+(e*284|0)+88>>2]|0;I=+g[h>>2]-+g[l+56>>2];G=+g[n>>2]-+g[l+60>>2];g[t+32>>2]=+g[o>>2]-+g[l+52>>2];g[t+36>>2]=I;g[t+40>>2]=G;g[t+44>>2]=0.0;o=c[b+36>>2]|0;G=+g[o+(e<<4)>>2]*k;I=k*+g[o+(e<<4)+4>>2];J=k*+g[o+(e<<4)+8>>2];g[t+16>>2]=G;g[t+20>>2]=I;g[t+24>>2]=J;g[t+28>>2]=0.0;o=c[b+116>>2]|0;n=c[b+124>>2]|0;B=+g[o+(n<<2)+4>>2];C=+g[o+(n<<2)+20>>2];D=+g[o+(n<<2)+36>>2];E=(B*m+C*p+D*d)*(1.0-+g[f+(e*284|0)+244>>2]);g[t+64>>2]=m-B*E;g[t+68>>2]=p-C*E;g[t+72>>2]=d-D*E;bn(o,t+16|0,t+64|0);g[t>>2]=-G;g[t+4>>2]=-I;g[t+8>>2]=-J;g[t+12>>2]=0.0;bn(l,t,t+32|0)}e=e+1|0;if((e|0)>=(c[b+136>>2]|0))break;f=c[b+144>>2]|0;j=c[b+56>>2]|0}i=t;return}function is(b,d){b=b|0;d=d|0;var e=0,f=0,h=0,j=0.0,k=0.0,l=0,m=0;f=i;i=i+48|0;if((c[b+136>>2]|0)<=0){i=f;return}e=0;do{m=c[b+144>>2]|0;g[f+32>>2]=(a[m+(e*284|0)+84>>0]|0)==0?1.0:0.0;g[f+36>>2]=0.0;g[f+40>>2]=1.0;g[f+44>>2]=0.0;l=m+(e*284|0)+140|0;c[f+16>>2]=c[l+0>>2];c[f+20>>2]=c[l+4>>2];c[f+24>>2]=c[l+8>>2];c[f+28>>2]=c[l+12>>2];l=c[b+120>>2]|0;h=c[(c[d>>2]|0)+8>>2]|0;k=+g[m+(e*284|0)+(l<<2)+108>>2]+ +g[f+20>>2];j=+g[m+(e*284|0)+(l<<2)+124>>2]+ +g[f+24>>2];g[f>>2]=+g[m+(e*284|0)+(l<<2)+92>>2]+ +g[f+16>>2];g[f+4>>2]=k;g[f+8>>2]=j;g[f+12>>2]=0.0;tc[h&127](d,f+16|0,f,f+32|0);tc[c[(c[d>>2]|0)+8>>2]&127](d,f+16|0,(c[b+144>>2]|0)+(e*284|0)+16|0,f+32|0);e=e+1|0}while((e|0)<(c[b+136>>2]|0));i=f;return}function js(a,d,e,f){a=a|0;d=d|0;e=e|0;f=f|0;var h=0,j=0.0,k=0.0,l=0.0,m=0.0;h=i;i=i+96|0;g[h+4>>2]=1.0;c[h+8>>2]=0;b[h+12>>1]=1;b[h+14>>1]=-1;c[h+16>>2]=0;c[h>>2]=528;c[h+20>>2]=c[d+0>>2];c[h+24>>2]=c[d+4>>2];c[h+28>>2]=c[d+8>>2];c[h+32>>2]=c[d+12>>2];c[h+36>>2]=c[e+0>>2];c[h+40>>2]=c[e+4>>2];c[h+44>>2]=c[e+8>>2];c[h+48>>2]=c[e+12>>2];a=c[a+4>>2]|0;tc[c[(c[a>>2]|0)+32>>2]&127](a,d,e,h);d=c[h+8>>2]|0;if(!d){d=0;i=h;return d|0}d=(c[d+236>>2]&2|0)==0?0:d;if(!d){d=0;i=h;return d|0}if(c[d+204>>2]&4){d=0;i=h;return d|0}c[f+0>>2]=c[h+68>>2];c[f+4>>2]=c[h+72>>2];c[f+8>>2]=c[h+76>>2];c[f+12>>2]=c[h+80>>2];c[f+16>>2]=c[h+52>>2];c[f+20>>2]=c[h+56>>2];c[f+24>>2]=c[h+60>>2];c[f+28>>2]=c[h+64>>2];m=+g[f+16>>2];l=+g[f+20>>2];k=+g[f+24>>2];j=1.0/+P(+(m*m+l*l+k*k));g[f+16>>2]=m*j;g[f+20>>2]=l*j;g[f+24>>2]=k*j;g[f+32>>2]=+g[h+4>>2];i=h;return d|0}function ks(a){a=a|0;var b=0;b=i;RE(a);i=b;return}function ls(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;c[a+120>>2]=b;c[a+124>>2]=d;c[a+128>>2]=e;return}function ms(a,b,d){a=a|0;b=b|0;d=+d;b=i;Ib[c[(c[a>>2]|0)+16>>2]&31](a,d);i=b;return}function ns(b){b=b|0;var d=0,e=0;e=i;c[b>>2]=5024;d=c[b+140>>2]|0;if(d){if(a[b+144>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}c[b+140>>2]=0}a[b+144>>0]=1;c[b+140>>2]=0;c[b+132>>2]=0;c[b+136>>2]=0;i=e;return}function os(b){b=b|0;var d=0,e=0;e=i;c[b>>2]=5024;d=c[b+140>>2]|0;if(d){if(a[b+144>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}a[b+144>>0]=1;c[b+140>>2]=0;c[b+132>>2]=0;c[b+136>>2]=0;if(!b){i=e;return}}else{a[b+144>>0]=1;c[b+140>>2]=0;c[b+132>>2]=0;c[b+136>>2]=0}c[5110]=(c[5110]|0)+1;RE(c[b+-4>>2]|0);i=e;return}function ps(d,e,f,h,j){d=d|0;e=e|0;f=+f;h=+h;j=+j;var k=0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0,r=0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0;q=i;i=i+240|0;h=+g[d+96>>2]+h;p=+g[d+100>>2]+j;g[d+112>>2]=+g[d+92>>2]+f;g[d+116>>2]=h;g[d+120>>2]=p;g[d+124>>2]=0.0;g[q+168>>2]=1.0;c[q+172>>2]=0;c[q+176>>2]=0;c[q+180>>2]=0;c[q+184>>2]=0;g[q+188>>2]=1.0;c[q+192>>2]=0;c[q+196>>2]=0;c[q+200>>2]=0;c[q+204>>2]=0;g[q+208>>2]=1.0;k=q+212|0;c[k+0>>2]=0;c[k+4>>2]=0;c[k+8>>2]=0;c[k+12>>2]=0;c[k+16>>2]=0;g[q+104>>2]=1.0;c[q+108>>2]=0;c[q+112>>2]=0;c[q+116>>2]=0;c[q+120>>2]=0;g[q+124>>2]=1.0;c[q+128>>2]=0;c[q+132>>2]=0;c[q+136>>2]=0;c[q+140>>2]=0;g[q+144>>2]=1.0;k=q+148|0;c[k+0>>2]=0;c[k+4>>2]=0;c[k+8>>2]=0;c[k+12>>2]=0;c[k+16>>2]=0;p=1.0;k=10;while(1){if((k|0)<=0){k=13;break};k=k+-1|0;c[q+216>>2]=c[d+92>>2];c[q+220>>2]=c[d+96>>2];c[q+224>>2]=c[d+100>>2];c[q+228>>2]=c[d+104>>2];c[q+152>>2]=c[d+112>>2];c[q+156>>2]=c[d+116>>2];c[q+160>>2]=c[d+120>>2];c[q+164>>2]=c[d+124>>2];j=+g[d+92>>2]-+g[d+112>>2];h=+g[d+96>>2]-+g[d+116>>2];f=+g[d+100>>2]-+g[d+120>>2];r=c[d+8>>2]|0;g[q+4>>2]=1.0;c[q+76>>2]=0;c[q+12>>2]=0;c[q+16>>2]=0;c[q+20>>2]=0;c[q+24>>2]=0;c[q+28>>2]=0;c[q+32>>2]=0;c[q+36>>2]=0;c[q+40>>2]=0;c[q>>2]=5256;c[q+80>>2]=r;g[q+84>>2]=j;g[q+88>>2]=h;g[q+92>>2]=f;g[q+96>>2]=0.0;g[q+100>>2]=0.0;r=c[r+188>>2]|0;b[q+8>>1]=b[r+4>>1]|0;b[q+10>>1]=b[r+6>>1]|0;r=c[d+12>>2]|0;f=+Zb[c[(c[r>>2]|0)+48>>2]&15](r);r=c[d+12>>2]|0;Ib[c[(c[r>>2]|0)+44>>2]&31](r,f+ +g[d+56>>2]);if(!(a[d+170>>0]|0))_u(e,c[d+12>>2]|0,q+168|0,q+104|0,q,+g[e+56>>2]);else Ss(c[d+8>>2]|0,c[d+12>>2]|0,q+168|0,q+104|0,q,+g[e+56>>2]);r=c[d+12>>2]|0;Ib[c[(c[r>>2]|0)+44>>2]&31](r,f);f=+g[q+4>>2];p=p-f;if(f<1.0){j=+g[d+112>>2];m=+g[d+92>>2];f=+g[d+116>>2];n=+g[d+96>>2];l=+g[d+120>>2];o=+g[d+100>>2];h=+P(+((j-m)*(j-m)+(f-n)*(f-n)+(l-o)*(l-o)));if(h>1.1920928955078125e-07){v=+g[q+44>>2];t=+g[q+48>>2];x=+g[q+52>>2];w=((j-m)*(1.0/h)*v+(f-n)*(1.0/h)*t+(l-o)*(1.0/h)*x)*2.0;u=(j-m)*(1.0/h)-v*w;s=(f-n)*(1.0/h)-t*w;w=(l-o)*(1.0/h)-x*w;l=1.0/+P(+(w*w+(u*u+s*s)));c[d+112>>2]=c[d+92>>2];c[d+116>>2]=c[d+96>>2];c[d+120>>2]=c[d+100>>2];c[d+124>>2]=c[d+104>>2];j=h*(l*u-v*(x*(l*w)+(v*(l*u)+t*(l*s))))+ +g[d+112>>2];g[d+112>>2]=j;f=h*(l*s-t*(x*(l*w)+(v*(l*u)+t*(l*s))))+ +g[d+116>>2];g[d+116>>2]=f;l=h*(l*w-x*(x*(l*w)+(v*(l*u)+t*(l*s))))+ +g[d+120>>2];g[d+120>>2]=l;h=f}else h=f;f=j-m;h=h-n;j=l-o;if(!(f*f+h*h+j*j>1.1920928955078125e-07)){k=13;break}o=1.0/+P(+(f*f+h*h+j*j));if(f*o*+g[d+76>>2]+h*o*+g[d+80>>2]+j*o*+g[d+84>>2]<=0.0){k=13;break}}else{c[d+92>>2]=c[d+112>>2];c[d+96>>2]=c[d+116>>2];c[d+100>>2]=c[d+120>>2];c[d+104>>2]=c[d+124>>2]}if(!(p>.009999999776482582)){k=13;break}}if((k|0)==13){i=q;return}}function qs(b,d){b=b|0;d=d|0;var e=0.0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0;a[b+171>>0]=1;c[b+60>>2]=c[d+0>>2];c[b+64>>2]=c[d+4>>2];c[b+68>>2]=c[d+8>>2];c[b+72>>2]=c[d+12>>2];e=+g[b+60>>2];f=+g[b+64>>2];i=+g[b+68>>2];h=1.0/+P(+(e*e+f*f+i*i));if(+P(+(i*h*(i*h)+(e*h*(e*h)+f*h*(f*h))))<1.1920928955078125e-07){k=0.0;j=0.0;e=0.0;f=0.0}else{k=e*h;j=f*h;e=i*h;f=+g[b+72>>2]}g[b+76>>2]=k;g[b+80>>2]=j;g[b+84>>2]=e;g[b+88>>2]=f;return}function rs(b,d,e){b=b|0;d=d|0;e=+e;var f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0;a[b+171>>0]=0;c[b+60>>2]=c[d+0>>2];c[b+64>>2]=c[d+4>>2];c[b+68>>2]=c[d+8>>2];c[b+72>>2]=c[d+12>>2];f=+g[b+60>>2];h=+g[b+64>>2];j=+g[b+68>>2];i=1.0/+P(+(f*f+h*h+j*j));if(+P(+(j*i*(j*i)+(f*i*(f*i)+h*i*(h*i))))<1.1920928955078125e-07){l=0.0;k=0.0;f=0.0;h=0.0}else{l=f*i;k=h*i;f=j*i;h=+g[b+72>>2]}g[b+76>>2]=l;g[b+80>>2]=k;g[b+84>>2]=f;g[b+88>>2]=h;g[b+172>>2]=+g[b+172>>2]+e;return}function ss(b,d){b=b|0;d=d|0;var e=0,f=0,h=0,j=0;e=i;g[b+16>>2]=0.0;g[b+20>>2]=0.0;a[b+168>>0]=0;a[b+169>>0]=0;g[b+172>>2]=0.0;c[b+60>>2]=0;c[b+64>>2]=0;c[b+68>>2]=0;c[b+72>>2]=0;b=c[(c[b+8>>2]|0)+284>>2]|0;if((c[(Nb[c[(c[b>>2]|0)+28>>2]&127](b)|0)+4>>2]|0)<=0){i=e;return}do{h=c[b>>2]|0;j=c[h+12>>2]|0;h=c[c[(Nb[c[h+28>>2]&127](b)|0)+12>>2]>>2]|0;f=c[(c[(Nb[c[(c[b>>2]|0)+28>>2]&127](b)|0)+12>>2]|0)+4>>2]|0;Rb[j&31](b,h,f,c[d+24>>2]|0)|0}while((c[(Nb[c[(c[b>>2]|0)+28>>2]&127](b)|0)+4>>2]|0)>0);i=e;return}function ts(a,b){a=a|0;b=b|0;var d=0;d=i;i=i+32|0;c[d+16>>2]=0;c[d+20>>2]=0;c[d+24>>2]=0;c[d+28>>2]=0;c[d+0>>2]=c[b+0>>2];c[d+4>>2]=c[b+4>>2];c[d+8>>2]=c[b+8>>2];c[d+12>>2]=c[b+12>>2];b=c[a+8>>2]|0;c[b+260>>2]=(c[b+260>>2]|0)+1;g[b+4>>2]=1.0;c[b+8>>2]=c[d+16>>2];c[b+12>>2]=c[d+20>>2];c[b+16>>2]=c[d+24>>2];c[b+20>>2]=0;g[b+24>>2]=1.0;c[b+28>>2]=0;c[b+32>>2]=0;c[b+36>>2]=0;c[b+40>>2]=0;g[b+44>>2]=1.0;g[b+48>>2]=0.0;c[b+52>>2]=c[d+0>>2];c[b+56>>2]=c[d+4>>2];c[b+60>>2]=c[d+8>>2];c[b+64>>2]=c[d+12>>2];i=d;return}function us(b,d){b=b|0;d=d|0;var e=0,f=0,h=0,j=0.0,k=0,l=0.0,m=0,n=0,o=0.0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0.0,y=0.0;w=i;i=i+96|0;a[b+148>>0]=0;u=0;while(1){q=c[b+12>>2]|0;tc[c[(c[q>>2]|0)+8>>2]&127](q,(c[b+8>>2]|0)+4|0,w+80|0,w+64|0);q=c[d+68>>2]|0;Hb[c[(c[q>>2]|0)+16>>2]&31](q,c[(c[b+8>>2]|0)+188>>2]|0,w+80|0,w+64|0,c[d+24>>2]|0);q=c[d+24>>2]|0;tc[c[(c[q>>2]|0)+32>>2]&127](q,c[(c[b+8>>2]|0)+284>>2]|0,d+28|0,q);q=c[b+8>>2]|0;c[b+92>>2]=c[q+52>>2];c[b+96>>2]=c[q+56>>2];c[b+100>>2]=c[q+60>>2];c[b+104>>2]=c[q+64>>2];q=c[q+284>>2]|0;if((Nb[c[(c[q>>2]|0)+36>>2]&127](q)|0)>0){t=0;j=0.0;e=0;do{f=c[b+132>>2]|0;if((f|0)<0){if((c[b+136>>2]|0)<0){h=c[b+140>>2]|0;if(h){if(a[b+144>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[h+-4>>2]|0)}c[b+140>>2]=0}a[b+144>>0]=1;c[b+140>>2]=0;c[b+136>>2]=0}do{h=(c[b+140>>2]|0)+(f<<2)|0;if(h)c[h>>2]=0;f=f+1|0}while((f|0)!=0)}c[b+132>>2]=0;h=c[(c[b+8>>2]|0)+284>>2]|0;h=c[(Nb[c[(c[h>>2]|0)+28>>2]&127](h)|0)+12>>2]|0;q=c[c[h+(t<<4)>>2]>>2]|0;f=c[c[h+(t<<4)+4>>2]>>2]|0;if(!((q|0)!=0?(c[q+204>>2]&4|0)!=0:0))v=15;do if((v|0)==15){v=0;if((f|0)!=0?(c[f+204>>2]&4|0)!=0:0)break;f=c[h+(t<<4)+8>>2]|0;if(f)Lb[c[(c[f>>2]|0)+16>>2]&127](f,b+128|0);r=c[b+132>>2]|0;if((r|0)>0){p=c[b+140>>2]|0;q=c[b+8>>2]|0;s=0;do{n=c[p+(s<<2)>>2]|0;o=(c[n+740>>2]|0)==(q|0)?-1.0:1.0;h=c[n+748>>2]|0;if((h|0)>0){m=0;do{l=+g[n+(m*184|0)+84>>2];if(l<0.0){k=n+(m*184|0)+68|0;if(l<j){f=n+(m*184|0)+72|0;x=o*+g[f>>2];e=n+(m*184|0)+76|0;j=o*+g[e>>2];g[b+152>>2]=o*+g[k>>2];g[b+156>>2]=x;g[b+160>>2]=j;g[b+164>>2]=0.0;h=c[n+748>>2]|0;j=l}else{f=n+(m*184|0)+72|0;e=n+(m*184|0)+76|0}y=l*(o*+g[f>>2])*.20000000298023224;x=l*(o*+g[e>>2])*.20000000298023224;g[b+92>>2]=l*(o*+g[k>>2])*.20000000298023224+ +g[b+92>>2];g[b+96>>2]=y+ +g[b+96>>2];g[b+100>>2]=x+ +g[b+100>>2];e=1}m=m+1|0}while((m|0)<(h|0))}s=s+1|0}while((s|0)!=(r|0))}}while(0);t=t+1|0;q=c[(c[b+8>>2]|0)+284>>2]|0}while((t|0)<(Nb[c[(c[q>>2]|0)+36>>2]&127](q)|0))}else e=0;q=c[b+8>>2]|0;c[w+0>>2]=c[q+4>>2];c[w+4>>2]=c[q+8>>2];c[w+8>>2]=c[q+12>>2];c[w+12>>2]=c[q+16>>2];c[w+16>>2]=c[q+20>>2];c[w+20>>2]=c[q+24>>2];c[w+24>>2]=c[q+28>>2];c[w+28>>2]=c[q+32>>2];c[w+32>>2]=c[q+36>>2];c[w+36>>2]=c[q+40>>2];c[w+40>>2]=c[q+44>>2];c[w+44>>2]=c[q+48>>2];c[w+48>>2]=c[b+92>>2];c[w+52>>2]=c[b+96>>2];c[w+56>>2]=c[b+100>>2];c[w+60>>2]=c[b+104>>2];c[q+260>>2]=(c[q+260>>2]|0)+1;c[q+4>>2]=c[w+0>>2];c[q+8>>2]=c[w+4>>2];c[q+12>>2]=c[w+8>>2];c[q+16>>2]=c[w+12>>2];c[q+20>>2]=c[w+16>>2];c[q+24>>2]=c[w+20>>2];c[q+28>>2]=c[w+24>>2];c[q+32>>2]=c[w+28>>2];c[q+36>>2]=c[w+32>>2];c[q+40>>2]=c[w+36>>2];c[q+44>>2]=c[w+40>>2];c[q+48>>2]=c[w+44>>2];c[q+52>>2]=c[w+48>>2];c[q+56>>2]=c[w+52>>2];c[q+60>>2]=c[w+56>>2];c[q+64>>2]=c[w+60>>2];if(!e){v=32;break}a[b+148>>0]=1;if((u|0)>3){v=32;break}else u=u+1|0}if((v|0)==32){q=(c[b+8>>2]|0)+52|0;c[b+92>>2]=c[q+0>>2];c[b+96>>2]=c[q+4>>2];c[b+100>>2]=c[q+8>>2];c[b+104>>2]=c[q+12>>2];ZE(b+112|0,q|0,16)|0;i=w;return}}
function Yv(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var j=0,k=0,l=0,m=0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0,u=0.0,v=0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0,D=0,E=0.0,F=0,G=0.0,H=0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,N=0,Q=0,T=0,U=0.0,V=0,W=0.0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0,ca=0,da=0,ea=0,fa=0,ga=0,ha=0,ia=0.0,ja=0.0,ka=0,la=0.0,ma=0.0,na=0,oa=0.0,pa=0.0,qa=0.0,ra=0.0,sa=0.0,ta=0.0,ua=0.0,va=0.0,wa=0.0,xa=0.0,ya=0.0,za=0.0,Aa=0.0,Ba=0,Ca=0,Da=0.0,Ea=0.0,Fa=0.0,Ga=0,Ha=0.0,Ia=0,Ja=0,Ka=0;Ka=i;i=i+832|0;m=c[b+20>>2]|0;if(!m){m=c[b+4>>2]|0;m=Wb[c[(c[m>>2]|0)+12>>2]&63](m,c[d+8>>2]|0,c[e+8>>2]|0)|0;c[b+20>>2]=m;a[b+16>>0]=1}c[h+4>>2]=m;Ia=c[d+4>>2]|0;Ja=c[e+4>>2]|0;D=c[Ia+4>>2]|0;C=c[Ja+4>>2]|0;if((D|0)==10&(C|0)==10){y=+g[m+752>>2];_=c[Ia+52>>2]|0;w=+g[Ia+(_<<2)+28>>2];z=+g[Ia+(((_+2|0)%3|0)<<2)+28>>2];$=c[Ja+52>>2]|0;r=+g[Ja+($<<2)+28>>2];A=+g[Ja+((($+2|0)%3|0)<<2)+28>>2];aa=c[d+12>>2]|0;D=c[e+12>>2]|0;G=+g[aa+(_<<2)>>2];I=+g[aa+(_<<2)+16>>2];E=+g[aa+(_<<2)+32>>2];s=+g[D+($<<2)>>2];u=+g[D+($<<2)+16>>2];o=+g[D+($<<2)+32>>2];n=+g[D+48>>2]-+g[aa+48>>2];x=+g[D+52>>2]-+g[aa+52>>2];B=+g[D+56>>2]-+g[aa+56>>2];q=1.0-(G*s+I*u+E*o)*(G*s+I*u+E*o);if(!(q==0.0)){q=(G*n+I*x+E*B-(G*s+I*u+E*o)*(s*n+u*x+o*B))/q;if(!(q<-w)){if(q>w)q=w}else q=-w}else q=0.0;p=(G*s+I*u+E*o)*q-(s*n+u*x+o*B);if(p<-r){q=(G*s+I*u+E*o)*-r+(G*n+I*x+E*B);if(!(q<-w))if(q>w){q=w;r=-r}else r=-r;else{q=-w;r=-r}}else if(p>r){q=r*(G*s+I*u+E*o)+(G*n+I*x+E*B);if(!(q<-w)){if(q>w)q=w}else q=-w}else r=p;w=s*r;u=u*r;s=o*r;p=w+(n-G*q);n=u+(x-I*q);o=s+(B-E*q);r=+P(+(o*o+(p*p+n*n)));if(!(r-z-A>y)){do if(o*o+(p*p+n*n)<=1.4210854715202004e-14)if(+O(+E)>.7071067690849304){n=1.0/+P(+(I*I+E*E));g[Ka+320>>2]=0.0;g[Ka+324>>2]=-(E*n);g[Ka+328>>2]=I*n;p=0.0;q=-(E*n);n=I*n;break}else{q=1.0/+P(+(G*G+I*I));g[Ka+320>>2]=-(I*q);g[Ka+324>>2]=G*q;g[Ka+328>>2]=0.0;p=-(I*q);q=G*q;n=0.0;break}else{g[Ka+320>>2]=p*-(1.0/r);g[Ka+324>>2]=n*-(1.0/r);g[Ka+328>>2]=o*-(1.0/r);g[Ka+332>>2]=0.0;p=p*-(1.0/r);q=n*-(1.0/r);n=o*-(1.0/r)}while(0);U=A*q+(u+ +g[D+52>>2]);W=A*n+(s+ +g[D+56>>2]);g[Ka+304>>2]=A*p+(w+ +g[D+48>>2]);g[Ka+308>>2]=U;g[Ka+312>>2]=W;g[Ka+316>>2]=0.0}if(r-z-A<y){oc[c[(c[h>>2]|0)+16>>2]&15](h,Ka+320|0,Ka+304|0,r-z-A);m=c[h+4>>2]|0}if(!(c[m+748>>2]|0)){i=Ka;return}l=c[m+740>>2]|0;k=c[(c[h+8>>2]|0)+8>>2]|0;j=c[(c[h+12>>2]|0)+8>>2]|0;if((l|0)==(k|0)){Fs(m,l+4|0,j+4|0);i=Ka;return}else{Fs(m,j+4|0,k+4|0);i=Ka;return}}g[Ka+296>>2]=999999984306749440.0;v=c[b+8>>2]|0;V=c[b+12>>2]|0;c[Ka+88>>2]=19400;g[Ka+92>>2]=0.0;g[Ka+96>>2]=1.0;g[Ka+100>>2]=0.0;g[Ka+104>>2]=0.0;c[Ka+108>>2]=V;c[Ka+112>>2]=v;c[Ka+116>>2]=Ia;c[Ka+120>>2]=Ja;c[Ka+124>>2]=D;c[Ka+128>>2]=C;g[Ka+132>>2]=+Zb[c[(c[Ia>>2]|0)+48>>2]&15](Ia);g[Ka+136>>2]=+Zb[c[(c[Ja>>2]|0)+48>>2]&15](Ja);a[Ka+140>>0]=0;c[Ka+148>>2]=-1;c[Ka+160>>2]=1;c[Ka+164>>2]=1;c[Ka+116>>2]=Ia;c[Ka+120>>2]=Ja;Fa=+Zb[c[(c[Ia>>2]|0)+48>>2]&15](Ia);J=+Zb[c[(c[Ja>>2]|0)+48>>2]&15](Ja);J=Fa+J+ +g[(c[b+20>>2]|0)+752>>2];g[Ka+296>>2]=J*J;v=c[d+12>>2]|0;c[Ka+168>>2]=c[v+0>>2];c[Ka+172>>2]=c[v+4>>2];c[Ka+176>>2]=c[v+8>>2];c[Ka+180>>2]=c[v+12>>2];V=Ka+184|0;c[V+0>>2]=c[v+16>>2];c[V+4>>2]=c[v+20>>2];c[V+8>>2]=c[v+24>>2];c[V+12>>2]=c[v+28>>2];Q=Ka+200|0;c[Q+0>>2]=c[v+32>>2];c[Q+4>>2]=c[v+36>>2];c[Q+8>>2]=c[v+40>>2];c[Q+12>>2]=c[v+44>>2];j=Ka+216|0;c[j+0>>2]=c[v+48>>2];c[j+4>>2]=c[v+52>>2];c[j+8>>2]=c[v+56>>2];c[j+12>>2]=c[v+60>>2];v=Ka+232|0;D=c[e+12>>2]|0;c[v+0>>2]=c[D+0>>2];c[v+4>>2]=c[D+4>>2];c[v+8>>2]=c[D+8>>2];c[v+12>>2]=c[D+12>>2];T=Ka+248|0;c[T+0>>2]=c[D+16>>2];c[T+4>>2]=c[D+20>>2];c[T+8>>2]=c[D+24>>2];c[T+12>>2]=c[D+28>>2];N=Ka+264|0;c[N+0>>2]=c[D+32>>2];c[N+4>>2]=c[D+36>>2];c[N+8>>2]=c[D+40>>2];c[N+12>>2]=c[D+44>>2];F=Ka+280|0;c[F+0>>2]=c[D+48>>2];c[F+4>>2]=c[D+52>>2];c[F+8>>2]=c[D+56>>2];c[F+12>>2]=c[D+60>>2];D=c[Ia+4>>2]|0;do if((D|0)<7?(t=c[Ja+4>>2]|0,(t|0)<7):0){c[Ka+80>>2]=10832;if(!D){D=t;G=0.0}else{G=+Zb[c[(c[Ia>>2]|0)+48>>2]&15](Ia);D=c[Ja+4>>2]|0}if(!D)I=0.0;else I=+Zb[c[(c[Ja>>2]|0)+48>>2]&15](Ja);c[Ka+40>>2]=10560;c[Ka+44>>2]=h;g[Ka+64>>2]=G;g[Ka+68>>2]=I;a[Ka+76>>0]=0;Ba=c[Ia+52>>2]|0;if(Ba){Ca=c[Ja+52>>2]|0;if(!Ca){if((c[Ja+4>>2]|0)!=1)break;t=Ka+32|0;a[t>>0]=1;C=Ka+28|0;c[C>>2]=0;H=Ka+20|0;c[H>>2]=0;D=Ka+24|0;c[D>>2]=0;m=c[e+12>>2]|0;U=+g[Ja+56>>2];W=+g[Ja+60>>2];q=+g[Ja+64>>2];r=U*+g[m>>2]+W*+g[m+4>>2]+q*+g[m+8>>2]+ +g[m+48>>2];p=U*+g[m+16>>2]+W*+g[m+20>>2]+q*+g[m+24>>2]+ +g[m+52>>2];q=U*+g[m+32>>2]+W*+g[m+36>>2]+q*+g[m+40>>2]+ +g[m+56>>2];c[5108]=(c[5108]|0)+1;m=QE(35)|0;if(!m)k=0;else{c[(m+19&-16)+-4>>2]=m;k=m+19&-16}m=c[H>>2]|0;if((m|0)>0){l=0;do{aa=k+(l<<4)|0;$=(c[C>>2]|0)+(l<<4)|0;c[aa+0>>2]=c[$+0>>2];c[aa+4>>2]=c[$+4>>2];c[aa+8>>2]=c[$+8>>2];c[aa+12>>2]=c[$+12>>2];l=l+1|0}while((l|0)!=(m|0))}m=c[C>>2]|0;if(m){if(a[t>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[m+-4>>2]|0)}c[C>>2]=0}a[t>>0]=1;c[C>>2]=k;c[D>>2]=1;m=c[H>>2]|0;g[k+(m<<4)>>2]=r;g[k+(m<<4)+4>>2]=p;g[k+(m<<4)+8>>2]=q;g[k+(m<<4)+12>>2]=0.0;m=(c[H>>2]|0)+1|0;c[H>>2]=m;aa=c[e+12>>2]|0;U=+g[Ja+72>>2];W=+g[Ja+76>>2];r=+g[Ja+80>>2];s=U*+g[aa>>2]+W*+g[aa+4>>2]+r*+g[aa+8>>2]+ +g[aa+48>>2];q=U*+g[aa+16>>2]+W*+g[aa+20>>2]+r*+g[aa+24>>2]+ +g[aa+52>>2];r=U*+g[aa+32>>2]+W*+g[aa+36>>2]+r*+g[aa+40>>2]+ +g[aa+56>>2];if((m|0)==(c[D>>2]|0)?(ha=(m|0)==0?1:m<<1,(m|0)<(ha|0)):0){if(!ha)l=0;else{c[5108]=(c[5108]|0)+1;m=QE((ha<<4|3)+16|0)|0;if(!m)l=0;else{c[(m+19&-16)+-4>>2]=m;l=m+19&-16}m=c[H>>2]|0}if((m|0)>0){k=0;do{aa=l+(k<<4)|0;$=(c[C>>2]|0)+(k<<4)|0;c[aa+0>>2]=c[$+0>>2];c[aa+4>>2]=c[$+4>>2];c[aa+8>>2]=c[$+8>>2];c[aa+12>>2]=c[$+12>>2];k=k+1|0}while((k|0)!=(m|0))}m=c[C>>2]|0;if(m){if(a[t>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[m+-4>>2]|0)}c[C>>2]=0}a[t>>0]=1;c[C>>2]=l;c[D>>2]=ha;m=c[H>>2]|0}aa=c[C>>2]|0;g[aa+(m<<4)>>2]=s;g[aa+(m<<4)+4>>2]=q;g[aa+(m<<4)+8>>2]=r;g[aa+(m<<4)+12>>2]=0.0;m=(c[H>>2]|0)+1|0;c[H>>2]=m;aa=c[e+12>>2]|0;U=+g[Ja+88>>2];W=+g[Ja+92>>2];q=+g[Ja+96>>2];r=U*+g[aa>>2]+W*+g[aa+4>>2]+q*+g[aa+8>>2]+ +g[aa+48>>2];p=U*+g[aa+16>>2]+W*+g[aa+20>>2]+q*+g[aa+24>>2]+ +g[aa+52>>2];q=U*+g[aa+32>>2]+W*+g[aa+36>>2]+q*+g[aa+40>>2]+ +g[aa+56>>2];if((m|0)==(c[D>>2]|0)?(ka=(m|0)==0?1:m<<1,(m|0)<(ka|0)):0){if(!ka)l=0;else{c[5108]=(c[5108]|0)+1;m=QE((ka<<4|3)+16|0)|0;if(!m)l=0;else{c[(m+19&-16)+-4>>2]=m;l=m+19&-16}m=c[H>>2]|0}if((m|0)>0){k=0;do{aa=l+(k<<4)|0;$=(c[C>>2]|0)+(k<<4)|0;c[aa+0>>2]=c[$+0>>2];c[aa+4>>2]=c[$+4>>2];c[aa+8>>2]=c[$+8>>2];c[aa+12>>2]=c[$+12>>2];k=k+1|0}while((k|0)!=(m|0))}m=c[C>>2]|0;if(m){if(a[t>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[m+-4>>2]|0)}c[C>>2]=0}a[t>>0]=1;c[C>>2]=l;c[D>>2]=ka;m=c[H>>2]|0}aa=c[C>>2]|0;g[aa+(m<<4)>>2]=r;g[aa+(m<<4)+4>>2]=p;g[aa+(m<<4)+8>>2]=q;g[aa+(m<<4)+12>>2]=0.0;c[H>>2]=(c[H>>2]|0)+1;q=+g[(c[b+20>>2]|0)+752>>2];eD(Ka+88|0,Ka+168|0,Ka+80|0,c[f+20>>2]|0,0);n=+g[Ka+92>>2];o=+g[Ka+96>>2];p=+g[Ka+100>>2];if(n*n+o*o+p*p>1.1920928955078125e-07){U=1.0/(n*n+o*o+p*p);g[Ka>>2]=n*U;g[Ka+4>>2]=o*U;g[Ka+8>>2]=p*U;g[Ka+12>>2]=0.0;U=+g[Ka+144>>2];W=+Zb[c[(c[Ia>>2]|0)+48>>2]&15](Ia);W=U-W-+Zb[c[(c[Ja>>2]|0)+48>>2]&15](Ja);aD(Ka,c[Ia+52>>2]|0,c[d+12>>2]|0,Ka+16|0,W-q,q,h)}do if((a[b+16>>0]|0)!=0?(na=c[h+4>>2]|0,(c[na+748>>2]|0)!=0):0){l=c[na+740>>2]|0;k=c[(c[h+8>>2]|0)+8>>2]|0;m=c[(c[h+12>>2]|0)+8>>2]|0;if((l|0)==(k|0)){Fs(na,l+4|0,m+4|0);break}else{Fs(na,m+4|0,k+4|0);break}}while(0);m=c[C>>2]|0;if(m){if(a[t>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[m+-4>>2]|0)}c[C>>2]=0}a[t>>0]=1;c[C>>2]=0;c[H>>2]=0;c[D>>2]=0;i=Ka;return}Ha=+g[(c[b+20>>2]|0)+752>>2];if(!(a[f+24>>0]|0)){eD(Ka+88|0,Ka+168|0,Ka+40|0,c[f+20>>2]|0,0);n=+g[Ka+72>>2];if((a[Ka+76>>0]|0)!=0&n<0.0){p=+g[Ka+48>>2];o=+g[Ka+56>>2];r=+g[Ka+60>>2];q=+g[Ka+52>>2];Ga=104}}else{ea=c[d+12>>2]|0;ka=c[e+12>>2]|0;c[4824]=(c[4824]|0)+1;Aa=+g[Ba+64>>2];I=+g[Ba+68>>2];u=+g[ea+4>>2];J=+g[Ba+72>>2];w=+g[ea+8>>2];s=+g[ea+16>>2];r=+g[ea+20>>2];A=+g[ea+24>>2];B=+g[ea+32>>2];E=+g[ea+36>>2];G=+g[ea+40>>2];U=+g[Ca+64>>2];W=+g[Ca+68>>2];Ea=+g[Ca+72>>2];Da=Aa*+g[ea>>2]+I*u+J*w+ +g[ea+48>>2]-(U*+g[ka>>2]+W*+g[ka+4>>2]+Ea*+g[ka+8>>2]+ +g[ka+48>>2]);Fa=Aa*s+I*r+J*A+ +g[ea+52>>2]-(U*+g[ka+16>>2]+W*+g[ka+20>>2]+Ea*+g[ka+24>>2]+ +g[ka+52>>2]);Ea=Aa*B+I*E+J*G+ +g[ea+56>>2]-(U*+g[ka+32>>2]+W*+g[ka+36>>2]+Ea*+g[ka+40>>2]+ +g[ka+56>>2]);N=c[Ba+28>>2]|0;a:do if((N|0)>0){n=r;z=0.0;I=3402823466385288598117041.0e14;D=0;J=0.0;y=0.0;r=0.0;K=0.0;while(1){aa=c[Ba+36>>2]|0;U=+g[aa+(D*36|0)+20>>2];W=+g[aa+(D*36|0)+24>>2];o=+g[aa+(D*36|0)+28>>2];p=U*+g[ea>>2]+W*u+o*w;q=U*s+W*n+o*A;o=U*B+W*E+o*G;g[Ka+400>>2]=p;g[Ka+404>>2]=q;g[Ka+408>>2]=o;g[Ka+412>>2]=0.0;if(Da*p+Fa*q+Ea*o<0.0){g[Ka+400>>2]=-p;g[Ka+404>>2]=-q;g[Ka+408>>2]=-o;p=-p;o=-o;q=-q}c[4820]=(c[4820]|0)+1;if($C(ea,ka,Da,Fa,Ea,p,q,o,Ba,Ca,I)|0){c[4822]=(c[4822]|0)+1;PD(Ba,ea,Ka+400|0,Ka+808|0,Ka+784|0,Ka+464|0,Ka+448|0);PD(Ca,ka,Ka+400|0,Ka+720|0,Ka+480|0,Ka+432|0,Ka+416|0);x=+g[Ka+784>>2];w=+g[Ka+720>>2];if(!(x<w)?(sa=+g[Ka+480>>2],qa=+g[Ka+808>>2],!(sa<qa)):0){A=x-w<sa-qa?x-w:sa-qa;t=1}else{A=z;t=0}if(!t){t=0;p=J;o=y;q=K;break a}if(A<I){z=A;I=A;r=0.0}else{z=A;p=J;o=y;q=K}}else{p=J;o=y;q=K}D=D+1|0;if((D|0)>=(N|0)){u=I;Ga=51;break a}u=+g[ea+4>>2];w=+g[ea+8>>2];s=+g[ea+16>>2];n=+g[ea+20>>2];A=+g[ea+24>>2];B=+g[ea+32>>2];E=+g[ea+36>>2];G=+g[ea+40>>2];J=p;y=o;K=q}}else{u=3402823466385288598117041.0e14;p=0.0;o=0.0;r=0.0;q=0.0;Ga=51}while(0);b:do if((Ga|0)==51){C=c[Ca+28>>2]|0;if((C|0)>0){w=0.0;D=0;I=p;G=o;B=q;while(1){aa=c[Ca+36>>2]|0;U=+g[aa+(D*36|0)+20>>2];W=+g[aa+(D*36|0)+24>>2];o=+g[aa+(D*36|0)+28>>2];p=U*+g[ka>>2]+W*+g[ka+4>>2]+o*+g[ka+8>>2];q=U*+g[ka+16>>2]+W*+g[ka+20>>2]+o*+g[ka+24>>2];o=U*+g[ka+32>>2]+W*+g[ka+36>>2]+o*+g[ka+40>>2];g[Ka+384>>2]=p;g[Ka+388>>2]=q;g[Ka+392>>2]=o;g[Ka+396>>2]=0.0;if(Da*p+Fa*q+Ea*o<0.0){g[Ka+384>>2]=-p;g[Ka+388>>2]=-q;g[Ka+392>>2]=-o;p=-p;o=-o;q=-q}c[4820]=(c[4820]|0)+1;do if($C(ea,ka,Da,Fa,Ea,p,q,o,Ba,Ca,u)|0){c[4822]=(c[4822]|0)+1;PD(Ba,ea,Ka+384|0,Ka+808|0,Ka+784|0,Ka+464|0,Ka+448|0);PD(Ca,ka,Ka+384|0,Ka+720|0,Ka+480|0,Ka+432|0,Ka+416|0);x=+g[Ka+784>>2];s=+g[Ka+720>>2];do if(x<s)t=0;else{n=+g[Ka+480>>2];y=+g[Ka+808>>2];if(n<y){t=0;break}w=x-s<n-y?x-s:n-y;t=1}while(0);if(!t){t=0;p=I;o=G;q=B;break b}if(!(w<u)){E=w;p=I;o=G;q=B;break}E=w;u=w;r=0.0}else{E=w;p=I;o=G;q=B}while(0);D=D+1|0;if((D|0)>=(C|0))break;else{w=E;I=p;G=o;B=q}}}m=c[Ba+48>>2]|0;if((m|0)>0){C=c[Ca+48>>2]|0;U=0.0;W=0.0;n=0.0;na=0;fa=-1;D=-1;ja=0.0;A=0.0;G=0.0;z=0.0;E=0.0;ia=0.0;y=0.0;M=0.0;s=0.0;L=0.0;I=0.0;K=0.0;x=0.0;J=0.0;pa=0.0;w=0.0;while(1){aa=c[Ba+56>>2]|0;xa=+g[aa+(na<<4)>>2];B=+g[aa+(na<<4)+4>>2];ya=+g[aa+(na<<4)+8>>2];Aa=xa*+g[ea>>2]+B*+g[ea+4>>2]+ya*+g[ea+8>>2];za=xa*+g[ea+16>>2]+B*+g[ea+20>>2]+ya*+g[ea+24>>2];ya=xa*+g[ea+32>>2]+B*+g[ea+36>>2]+ya*+g[ea+40>>2];if((C|0)>0){xa=U;la=n;f=0;va=p;wa=q;ua=A;ta=z;ra=y;while(1){aa=c[Ca+56>>2]|0;A=+g[aa+(f<<4)>>2];B=+g[aa+(f<<4)+4>>2];oa=+g[aa+(f<<4)+8>>2];U=A*+g[ka>>2]+B*+g[ka+4>>2]+oa*+g[ka+8>>2];ma=A*+g[ka+16>>2]+B*+g[ka+20>>2]+oa*+g[ka+24>>2];oa=A*+g[ka+32>>2]+B*+g[ka+36>>2]+oa*+g[ka+40>>2];g[Ka+368>>2]=za*oa-ya*ma;g[Ka+372>>2]=ya*U-Aa*oa;g[Ka+376>>2]=Aa*ma-za*U;g[Ka+380>>2]=0.0;do if(!(+O(+(za*oa-ya*ma))>1.0e-06)){if(+O(+(ya*U-Aa*oa))>1.0e-06){Ga=69;break}if(!(+O(+(Aa*ma-za*U))>1.0e-06)){U=xa;p=va;q=wa;B=ja;A=ua;z=ta;qa=ia;sa=s;ma=pa}else Ga=69}else Ga=69;while(0);do if((Ga|0)==69){Ga=0;B=1.0/+P(+((za*oa-ya*ma)*(za*oa-ya*ma)+(ya*U-Aa*oa)*(ya*U-Aa*oa)+(Aa*ma-za*U)*(Aa*ma-za*U)));p=(za*oa-ya*ma)*B;g[Ka+368>>2]=p;q=(ya*U-Aa*oa)*B;g[Ka+372>>2]=q;B=(Aa*ma-za*U)*B;g[Ka+376>>2]=B;if(Da*p+Fa*q+Ea*B<0.0){g[Ka+368>>2]=-p;g[Ka+372>>2]=-q;g[Ka+376>>2]=-B;p=-p;B=-B;q=-q}c[4820]=(c[4820]|0)+1;if(!($C(ea,ka,Da,Fa,Ea,p,q,B,Ba,Ca,u)|0)){U=xa;p=va;q=wa;B=ja;A=ua;z=ta;qa=ia;sa=s;ma=pa;break}c[4822]=(c[4822]|0)+1;PD(Ba,ea,Ka+368|0,Ka+808|0,Ka+784|0,Ka+464|0,Ka+448|0);PD(Ca,ka,Ka+368|0,Ka+720|0,Ka+480|0,Ka+432|0,Ka+416|0);A=+g[Ka+784>>2];z=+g[Ka+720>>2];do if(!(A<z)){n=+g[Ka+480>>2];y=+g[Ka+808>>2];if(n<y){A=la;T=0;z=ua;n=ta;y=ra;break}if(A-z<n-y){A=A-z;T=1;ja=+g[Ka+448>>2];z=+g[Ka+452>>2];n=+g[Ka+456>>2];ia=+g[Ka+432>>2];y=+g[Ka+436>>2];s=+g[Ka+440>>2];break}else{A=n-y;T=1;ja=+g[Ka+464>>2];z=+g[Ka+468>>2];n=+g[Ka+472>>2];ia=+g[Ka+416>>2];y=+g[Ka+420>>2];s=+g[Ka+424>>2];break}}else{A=la;T=0;z=ua;n=ta;y=ra}while(0);if(!T){t=0;p=va;q=wa;break b}if(!(A<u)){U=xa;la=A;p=va;q=wa;B=ja;A=z;z=n;qa=ia;ra=y;sa=s;ma=pa;break}W=Aa;la=A;u=A;fa=na;D=f;o=B;r=0.0;B=ja;A=z;G=z;z=n;E=n;qa=ia;ra=y;M=y;sa=s;L=s;I=ja;K=ia;x=za;J=ya;w=oa}while(0);f=f+1|0;C=c[Ca+48>>2]|0;if((f|0)>=(C|0))break;else{xa=U;va=p;wa=q;ja=B;ua=A;ta=z;ia=qa;s=sa;pa=ma}}m=c[Ba+48>>2]|0;n=la;ja=B;ia=qa;y=ra;s=sa;la=ma}else la=pa;na=na+1|0;if((na|0)>=(m|0)){C=fa;u=la;break}else pa=la}}else{U=0.0;W=0.0;C=-1;D=-1;G=0.0;E=0.0;M=0.0;L=0.0;I=0.0;K=0.0;x=0.0;J=0.0;u=0.0;w=0.0}if((D|C|0)>-1){n=K-I;s=M-G;y=L-E;A=W*U+x*u+J*w;z=W*n+x*s+J*y;B=U*n+u*s+w*y;do if(!(1.0-A*A==0.0))if((z-A*B)/(1.0-A*A)<-1000000015047466219876688.0e6)G=-1000000015047466219876688.0e6;else{if(!((z-A*B)/(1.0-A*A)>1000000015047466219876688.0e6)){G=(z-A*B)/(1.0-A*A);break}G=1000000015047466219876688.0e6}else G=0.0;while(0);E=A*G-B;do if(E<-1000000015047466219876688.0e6){if(A*-1000000015047466219876688.0e6+z<-1000000015047466219876688.0e6){B=-1000000015047466219876688.0e6;E=-1000000015047466219876688.0e6;break}if(!(A*-1000000015047466219876688.0e6+z>1000000015047466219876688.0e6)){B=A*-1000000015047466219876688.0e6+z;E=-1000000015047466219876688.0e6;break}B=1000000015047466219876688.0e6;E=-1000000015047466219876688.0e6}else{if(!(E>1000000015047466219876688.0e6)){B=G;break}if(A*1000000015047466219876688.0e6+z<-1000000015047466219876688.0e6){B=-1000000015047466219876688.0e6;E=1000000015047466219876688.0e6;break}if(!(A*1000000015047466219876688.0e6+z>1000000015047466219876688.0e6)){B=A*1000000015047466219876688.0e6+z;E=1000000015047466219876688.0e6;break}B=1000000015047466219876688.0e6;E=1000000015047466219876688.0e6}while(0);z=U*E;I=E*u;G=E*w;A=n-W*B+z;w=s-B*x+I;s=y-B*J+G;g[Ka+352>>2]=A;g[Ka+356>>2]=w;g[Ka+360>>2]=s;g[Ka+364>>2]=0.0;if(A*A+w*w+s*s>1.1920928955078125e-07){n=+P(+(A*A+w*w+s*s));g[Ka+352>>2]=A*(1.0/n);g[Ka+356>>2]=1.0/n*w;g[Ka+360>>2]=1.0/n*s;if(A*(1.0/n)*Da+1.0/n*w*Fa+1.0/n*s*Ea<0.0){g[Ka+352>>2]=-(A*(1.0/n));g[Ka+356>>2]=-(1.0/n*w);g[Ka+360>>2]=-(1.0/n*s)}g[Ka+336>>2]=K+z;g[Ka+340>>2]=M+I;g[Ka+344>>2]=L+G;g[Ka+348>>2]=0.0;oc[c[(c[h>>2]|0)+16>>2]&15](h,Ka+352|0,Ka+336|0,-n)}}if(Da*p+Fa*q+Ea*o<0.0){t=1;p=-p;o=-o;r=0.0;q=-q}else t=1}while(0);if(t){n=-1000000015047466219876688.0e6;Ga=104}}if((Ga|0)==104){V=c[Ia+52>>2]|0;Q=c[Ja+52>>2]|0;T=c[d+12>>2]|0;N=c[e+12>>2]|0;J=n-Ha;E=1.0/+P(+(p*p+q*q+o*o));I=p*E;G=q*E;E=o*E;g[Ka+808>>2]=I;g[Ka+812>>2]=G;g[Ka+816>>2]=E;g[Ka+820>>2]=r;m=c[Q+28>>2]|0;C=c[Q+36>>2]|0;if((m|0)>0){x=+g[N>>2];w=+g[N+4>>2];u=+g[N+8>>2];s=+g[N+16>>2];r=+g[N+20>>2];q=+g[N+24>>2];p=+g[N+32>>2];o=+g[N+36>>2];y=+g[N+40>>2];t=-1;B=-3402823466385288598117041.0e14;v=0;while(1){n=+g[C+(v*36|0)+20>>2];z=+g[C+(v*36|0)+24>>2];A=+g[C+(v*36|0)+28>>2];l=(n*x+z*w+A*u)*I+(n*s+z*r+A*q)*G+(n*p+z*o+A*y)*E>B;t=l?v:t;v=v+1|0;if((v|0)==(m|0)){F=t;break}else B=l?(n*x+z*w+A*u)*I+(n*s+z*r+A*q)*G+(n*p+z*o+A*y)*E:B}}else F=-1;a[Ka+800>>0]=1;H=Ka+796|0;c[H>>2]=0;c[Ka+788>>2]=0;c[Ka+792>>2]=0;D=c[C+(F*36|0)+4>>2]|0;c:do if((D|0)>0){C=C+(F*36|0)+12|0;m=0;v=0;j=0;l=0;while(1){aa=c[(c[C>>2]|0)+(l<<2)>>2]|0;$=c[Q+16>>2]|0;U=+g[$+(aa<<4)>>2];W=+g[$+(aa<<4)+4>>2];u=+g[$+(aa<<4)+8>>2];w=U*+g[N>>2]+W*+g[N+4>>2]+u*+g[N+8>>2]+ +g[N+48>>2];s=U*+g[N+16>>2]+W*+g[N+20>>2]+u*+g[N+24>>2]+ +g[N+52>>2];u=U*+g[N+32>>2]+W*+g[N+36>>2]+u*+g[N+40>>2]+ +g[N+56>>2];if((m|0)==(v|0)){t=(v|0)==0?1:v<<1;if((v|0)<(t|0)){do if(!t){k=j;j=0}else{c[5108]=(c[5108]|0)+1;m=QE((t<<4|3)+16|0)|0;if(!m){k=j;j=0;break}c[(m+19&-16)+-4>>2]=m;k=c[H>>2]|0;j=m+19&-16}while(0);if((v|0)>0){m=0;do{aa=j+(m<<4)|0;$=k+(m<<4)|0;c[aa+0>>2]=c[$+0>>2];c[aa+4>>2]=c[$+4>>2];c[aa+8>>2]=c[$+8>>2];c[aa+12>>2]=c[$+12>>2];m=m+1|0}while((m|0)!=(v|0))}if(!k)m=v;else{if(!(a[Ka+800>>0]|0))m=v;else{c[5110]=(c[5110]|0)+1;RE(c[k+-4>>2]|0);m=c[Ka+788>>2]|0}c[H>>2]=0}a[Ka+800>>0]=1;c[H>>2]=j;c[Ka+792>>2]=t}else m=v}g[j+(m<<4)>>2]=w;g[j+(m<<4)+4>>2]=s;g[j+(m<<4)+8>>2]=u;g[j+(m<<4)+12>>2]=0.0;m=(c[Ka+788>>2]|0)+1|0;c[Ka+788>>2]=m;l=l+1|0;if((l|0)>=(D|0))break c;v=c[Ka+792>>2]|0}}else j=0;while(0);if((F|0)>-1){aD(Ka+808|0,V,T,Ka+784|0,J,Ha,h);j=c[H>>2]|0}if(j){if(a[Ka+800>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[j+-4>>2]|0)}c[H>>2]=0}}if(!(a[b+16>>0]|0)){i=Ka;return}k=c[h+4>>2]|0;if(!(c[k+748>>2]|0)){i=Ka;return}l=c[k+740>>2]|0;m=c[(c[h+8>>2]|0)+8>>2]|0;j=c[(c[h+12>>2]|0)+8>>2]|0;if((l|0)==(m|0)){Fs(k,l+4|0,j+4|0);i=Ka;return}else{Fs(k,j+4|0,m+4|0);i=Ka;return}}}while(0);eD(Ka+88|0,Ka+168|0,h,c[f+20>>2]|0,0);if(((c[b+28>>2]|0)!=0?(c[(c[h+4>>2]|0)+748>>2]|0)<(c[b+32>>2]|0):0)?(U=+g[Ka+92>>2],y=+g[Ka+96>>2],L=+g[Ka+100>>2],U*U+y*y+L*L>1.1920928955078125e-07):0){K=1.0/(U*U+y*y+L*L);if(+O(+(L*K))>.7071067690849304){E=1.0/+P(+(L*K*(L*K)+y*K*(y*K)));G=0.0;B=y*K*E;E=-(L*K*E)}else{E=1.0/+P(+(U*K*(U*K)+y*K*(y*K)));G=-(y*K*E);B=0.0;E=U*K*E}n=+Zb[c[(c[Ia>>2]|0)+16>>2]&15](Ia);J=+Zb[c[(c[Ja>>2]|0)+16>>2]&15](Ja);I=.019999999552965164/(n<J?n:J);if(n<J){c[Ka+720>>2]=c[Ka+168>>2];c[Ka+724>>2]=c[Ka+172>>2];c[Ka+728>>2]=c[Ka+176>>2];c[Ka+732>>2]=c[Ka+180>>2];c[Ka+736>>2]=c[V+0>>2];c[Ka+740>>2]=c[V+4>>2];c[Ka+744>>2]=c[V+8>>2];c[Ka+748>>2]=c[V+12>>2];c[Ka+752>>2]=c[Q+0>>2];c[Ka+756>>2]=c[Q+4>>2];c[Ka+760>>2]=c[Q+8>>2];c[Ka+764>>2]=c[Q+12>>2];c[Ka+768>>2]=c[j+0>>2];c[Ka+772>>2]=c[j+4>>2];c[Ka+776>>2]=c[j+8>>2];c[Ka+780>>2]=c[j+12>>2]}else{c[Ka+720>>2]=c[v+0>>2];c[Ka+724>>2]=c[v+4>>2];c[Ka+728>>2]=c[v+8>>2];c[Ka+732>>2]=c[v+12>>2];c[Ka+736>>2]=c[T+0>>2];c[Ka+740>>2]=c[T+4>>2];c[Ka+744>>2]=c[T+8>>2];c[Ka+748>>2]=c[T+12>>2];c[Ka+752>>2]=c[N+0>>2];c[Ka+756>>2]=c[N+4>>2];c[Ka+760>>2]=c[N+8>>2];c[Ka+764>>2]=c[N+12>>2];c[Ka+768>>2]=c[F+0>>2];c[Ka+772>>2]=c[F+4>>2];c[Ka+776>>2]=c[F+8>>2];c[Ka+780>>2]=c[F+12>>2]}D=c[b+28>>2]|0;if((D|0)>0?(A=B*B+(E*E+G*G),W=I>.39269909262657166?.19634954631328583:I*.5,ea=Ka+516|0,_=Ka+532|0,H=Ka+548|0,ba=Ka+564|0,fa=Ka+580|0,Z=Ka+596|0,k=Ka+612|0,ca=Ka+628|0,ga=Ka+644|0,Y=Ka+660|0,$=Ka+736|0,l=Ka+676|0,X=Ka+752|0,aa=Ka+692|0,da=Ka+768|0,A>1.1920928955078125e-07):0){I=+S(+W)/+P(+A);z=G*I;A=E*I;E=B*I;G=+R(+W);I=+P(+(L*K*(L*K)+(U*K*(U*K)+y*K*(y*K))));if(n<J){C=0;do{ma=+(C|0)*(6.2831854820251465/+(D|0))*.5;Aa=+S(+ma)/I;ma=+R(+ma);va=E*-(y*K*Aa)+(z*ma+G*-(U*K*Aa))-A*-(L*K*Aa);Fa=z*-(L*K*Aa)+(A*ma+G*-(y*K*Aa))-E*-(U*K*Aa);wa=A*-(U*K*Aa)+(E*ma+G*-(L*K*Aa))-z*-(y*K*Aa);q=G*ma-z*-(U*K*Aa)-A*-(y*K*Aa)-E*-(L*K*Aa);B=L*K*Aa*Fa+(U*K*Aa*q+ma*va)-y*K*Aa*wa;Ea=U*K*Aa*wa+(ma*Fa+y*K*Aa*q)-L*K*Aa*va;r=y*K*Aa*va+(L*K*Aa*q+ma*wa)-U*K*Aa*Fa;wa=ma*q-U*K*Aa*va-y*K*Aa*Fa-L*K*Aa*wa;Aa=B*(2.0/(wa*wa+(r*r+(B*B+Ea*Ea))));Fa=Ea*(2.0/(wa*wa+(r*r+(B*B+Ea*Ea))));va=r*(2.0/(wa*wa+(r*r+(B*B+Ea*Ea))));Ja=c[d+12>>2]|0;q=+g[Ja>>2];ma=+g[Ja+16>>2];p=+g[Ja+32>>2];M=+g[Ja+4>>2];la=+g[Ja+20>>2];o=+g[Ja+36>>2];Ha=+g[Ja+8>>2];xa=+g[Ja+24>>2];W=+g[Ja+40>>2];g[Ka+168>>2]=(B*va+wa*Fa)*p+(ma*(B*Fa-wa*va)+q*(1.0-(Ea*Fa+r*va)));g[Ka+172>>2]=(1.0-(Ea*Fa+r*va))*M+(B*Fa-wa*va)*la+(B*va+wa*Fa)*o;g[Ka+176>>2]=(1.0-(Ea*Fa+r*va))*Ha+(B*Fa-wa*va)*xa+(B*va+wa*Fa)*W;g[Ka+180>>2]=0.0;g[Ka+184>>2]=(Ea*va-wa*Aa)*p+(q*(B*Fa+wa*va)+ma*(1.0-(B*Aa+r*va)));g[Ka+188>>2]=(B*Fa+wa*va)*M+(1.0-(B*Aa+r*va))*la+(Ea*va-wa*Aa)*o;g[Ka+192>>2]=(B*Fa+wa*va)*Ha+(1.0-(B*Aa+r*va))*xa+(Ea*va-wa*Aa)*W;g[Ka+196>>2]=0.0;g[Ka+200>>2]=q*(B*va-wa*Fa)+ma*(Ea*va+wa*Aa)+p*(1.0-(B*Aa+Ea*Fa));g[Ka+204>>2]=(B*va-wa*Fa)*M+(Ea*va+wa*Aa)*la+(1.0-(B*Aa+Ea*Fa))*o;g[Ka+208>>2]=(B*va-wa*Fa)*Ha+(Ea*va+wa*Aa)*xa+(1.0-(B*Aa+Ea*Fa))*W;g[Ka+212>>2]=0.0;Ja=c[e+12>>2]|0;c[v+0>>2]=c[Ja+0>>2];c[v+4>>2]=c[Ja+4>>2];c[v+8>>2]=c[Ja+8>>2];c[v+12>>2]=c[Ja+12>>2];c[T+0>>2]=c[Ja+16>>2];c[T+4>>2]=c[Ja+20>>2];c[T+8>>2]=c[Ja+24>>2];c[T+12>>2]=c[Ja+28>>2];c[N+0>>2]=c[Ja+32>>2];c[N+4>>2]=c[Ja+36>>2];c[N+8>>2]=c[Ja+40>>2];c[N+12>>2]=c[Ja+44>>2];c[F+0>>2]=c[Ja+48>>2];c[F+4>>2]=c[Ja+52>>2];c[F+8>>2]=c[Ja+56>>2];c[F+12>>2]=c[Ja+60>>2];Ja=c[f+20>>2]|0;c[Ka+480>>2]=10752;c[Ka+512>>2]=h;c[ea+0>>2]=c[Ka+168>>2];c[ea+4>>2]=c[Ka+172>>2];c[ea+8>>2]=c[Ka+176>>2];c[ea+12>>2]=c[Ka+180>>2];c[_+0>>2]=c[V+0>>2];c[_+4>>2]=c[V+4>>2];c[_+8>>2]=c[V+8>>2];c[_+12>>2]=c[V+12>>2];c[H+0>>2]=c[Q+0>>2];c[H+4>>2]=c[Q+4>>2];c[H+8>>2]=c[Q+8>>2];c[H+12>>2]=c[Q+12>>2];c[ba+0>>2]=c[j+0>>2];c[ba+4>>2]=c[j+4>>2];c[ba+8>>2]=c[j+8>>2];c[ba+12>>2]=c[j+12>>2];c[fa+0>>2]=c[v+0>>2];c[fa+4>>2]=c[v+4>>2];c[fa+8>>2]=c[v+8>>2];c[fa+12>>2]=c[v+12>>2];c[Z+0>>2]=c[T+0>>2];c[Z+4>>2]=c[T+4>>2];c[Z+8>>2]=c[T+8>>2];c[Z+12>>2]=c[T+12>>2];c[k+0>>2]=c[N+0>>2];c[k+4>>2]=c[N+4>>2];c[k+8>>2]=c[N+8>>2];c[k+12>>2]=c[N+12>>2];c[ca+0>>2]=c[F+0>>2];c[ca+4>>2]=c[F+4>>2];c[ca+8>>2]=c[F+8>>2];c[ca+12>>2]=c[F+12>>2];c[ga+0>>2]=c[Ka+720>>2];c[ga+4>>2]=c[Ka+724>>2];c[ga+8>>2]=c[Ka+728>>2];c[ga+12>>2]=c[Ka+732>>2];c[Y+0>>2]=c[$+0>>2];c[Y+4>>2]=c[$+4>>2];c[Y+8>>2]=c[$+8>>2];c[Y+12>>2]=c[$+12>>2];c[l+0>>2]=c[X+0>>2];c[l+4>>2]=c[X+4>>2];c[l+8>>2]=c[X+8>>2];c[l+12>>2]=c[X+12>>2];c[aa+0>>2]=c[da+0>>2];c[aa+4>>2]=c[da+4>>2];c[aa+8>>2]=c[da+8>>2];c[aa+12>>2]=c[da+12>>2];a[Ka+708>>0]=n<J&1;c[Ka+712>>2]=Ja;eD(Ka+88|0,Ka+168|0,Ka+480|0,Ja,0);D=c[b+28>>2]|0;C=C+1|0}while((C|0)<(D|0))}else{C=0;do{ma=+(C|0)*(6.2831854820251465/+(D|0))*.5;Aa=+S(+ma)/I;ma=+R(+ma);Ja=c[d+12>>2]|0;c[Ka+168>>2]=c[Ja+0>>2];c[Ka+172>>2]=c[Ja+4>>2];c[Ka+176>>2]=c[Ja+8>>2];c[Ka+180>>2]=c[Ja+12>>2];c[V+0>>2]=c[Ja+16>>2];c[V+4>>2]=c[Ja+20>>2];c[V+8>>2]=c[Ja+24>>2];c[V+12>>2]=c[Ja+28>>2];c[Q+0>>2]=c[Ja+32>>2];c[Q+4>>2]=c[Ja+36>>2];c[Q+8>>2]=c[Ja+40>>2];c[Q+12>>2]=c[Ja+44>>2];c[j+0>>2]=c[Ja+48>>2];c[j+4>>2]=c[Ja+52>>2];c[j+8>>2]=c[Ja+56>>2];c[j+12>>2]=c[Ja+60>>2];va=E*-(y*K*Aa)+(z*ma+G*-(U*K*Aa))-A*-(L*K*Aa);Fa=z*-(L*K*Aa)+(A*ma+G*-(y*K*Aa))-E*-(U*K*Aa);wa=A*-(U*K*Aa)+(E*ma+G*-(L*K*Aa))-z*-(y*K*Aa);q=G*ma-z*-(U*K*Aa)-A*-(y*K*Aa)-E*-(L*K*Aa);B=L*K*Aa*Fa+(U*K*Aa*q+ma*va)-y*K*Aa*wa;Ea=U*K*Aa*wa+(ma*Fa+y*K*Aa*q)-L*K*Aa*va;r=y*K*Aa*va+(L*K*Aa*q+ma*wa)-U*K*Aa*Fa;wa=ma*q-U*K*Aa*va-y*K*Aa*Fa-L*K*Aa*wa;Aa=B*(2.0/(wa*wa+(r*r+(B*B+Ea*Ea))));Fa=Ea*(2.0/(wa*wa+(r*r+(B*B+Ea*Ea))));va=r*(2.0/(wa*wa+(r*r+(B*B+Ea*Ea))));Ja=c[e+12>>2]|0;q=+g[Ja>>2];ma=+g[Ja+16>>2];p=+g[Ja+32>>2];M=+g[Ja+4>>2];la=+g[Ja+20>>2];o=+g[Ja+36>>2];Ha=+g[Ja+8>>2];xa=+g[Ja+24>>2];W=+g[Ja+40>>2];g[Ka+232>>2]=(B*va+wa*Fa)*p+(ma*(B*Fa-wa*va)+q*(1.0-(Ea*Fa+r*va)));g[Ka+236>>2]=(1.0-(Ea*Fa+r*va))*M+(B*Fa-wa*va)*la+(B*va+wa*Fa)*o;g[Ka+240>>2]=(1.0-(Ea*Fa+r*va))*Ha+(B*Fa-wa*va)*xa+(B*va+wa*Fa)*W;g[Ka+244>>2]=0.0;g[Ka+248>>2]=(Ea*va-wa*Aa)*p+(q*(B*Fa+wa*va)+ma*(1.0-(B*Aa+r*va)));g[Ka+252>>2]=(B*Fa+wa*va)*M+(1.0-(B*Aa+r*va))*la+(Ea*va-wa*Aa)*o;g[Ka+256>>2]=(B*Fa+wa*va)*Ha+(1.0-(B*Aa+r*va))*xa+(Ea*va-wa*Aa)*W;g[Ka+260>>2]=0.0;g[Ka+264>>2]=q*(B*va-wa*Fa)+ma*(Ea*va+wa*Aa)+p*(1.0-(B*Aa+Ea*Fa));g[Ka+268>>2]=(B*va-wa*Fa)*M+(Ea*va+wa*Aa)*la+(1.0-(B*Aa+Ea*Fa))*o;g[Ka+272>>2]=(B*va-wa*Fa)*Ha+(Ea*va+wa*Aa)*xa+(1.0-(B*Aa+Ea*Fa))*W;g[Ka+276>>2]=0.0;Ja=c[f+20>>2]|0;c[Ka+480>>2]=10752;c[Ka+512>>2]=h;c[ea+0>>2]=c[Ka+168>>2];c[ea+4>>2]=c[Ka+172>>2];c[ea+8>>2]=c[Ka+176>>2];c[ea+12>>2]=c[Ka+180>>2];c[_+0>>2]=c[V+0>>2];c[_+4>>2]=c[V+4>>2];c[_+8>>2]=c[V+8>>2];c[_+12>>2]=c[V+12>>2];c[H+0>>2]=c[Q+0>>2];c[H+4>>2]=c[Q+4>>2];c[H+8>>2]=c[Q+8>>2];c[H+12>>2]=c[Q+12>>2];c[ba+0>>2]=c[j+0>>2];c[ba+4>>2]=c[j+4>>2];c[ba+8>>2]=c[j+8>>2];c[ba+12>>2]=c[j+12>>2];c[fa+0>>2]=c[v+0>>2];c[fa+4>>2]=c[v+4>>2];c[fa+8>>2]=c[v+8>>2];c[fa+12>>2]=c[v+12>>2];c[Z+0>>2]=c[T+0>>2];c[Z+4>>2]=c[T+4>>2];c[Z+8>>2]=c[T+8>>2];c[Z+12>>2]=c[T+12>>2];c[k+0>>2]=c[N+0>>2];c[k+4>>2]=c[N+4>>2];c[k+8>>2]=c[N+8>>2];c[k+12>>2]=c[N+12>>2];c[ca+0>>2]=c[F+0>>2];c[ca+4>>2]=c[F+4>>2];c[ca+8>>2]=c[F+8>>2];c[ca+12>>2]=c[F+12>>2];c[ga+0>>2]=c[Ka+720>>2];c[ga+4>>2]=c[Ka+724>>2];c[ga+8>>2]=c[Ka+728>>2];c[ga+12>>2]=c[Ka+732>>2];c[Y+0>>2]=c[$+0>>2];c[Y+4>>2]=c[$+4>>2];c[Y+8>>2]=c[$+8>>2];c[Y+12>>2]=c[$+12>>2];c[l+0>>2]=c[X+0>>2];c[l+4>>2]=c[X+4>>2];c[l+8>>2]=c[X+8>>2];c[l+12>>2]=c[X+12>>2];c[aa+0>>2]=c[da+0>>2];c[aa+4>>2]=c[da+4>>2];c[aa+8>>2]=c[da+8>>2];c[aa+12>>2]=c[da+12>>2];a[Ka+708>>0]=n<J&1;c[Ka+712>>2]=Ja;eD(Ka+88|0,Ka+168|0,Ka+480|0,Ja,0);D=c[b+28>>2]|0;C=C+1|0}while((C|0)<(D|0))}}}if(!(a[b+16>>0]|0)){i=Ka;return}m=c[h+4>>2]|0;if(!(c[m+748>>2]|0)){i=Ka;return}l=c[m+740>>2]|0;k=c[(c[h+8>>2]|0)+8>>2]|0;j=c[(c[h+12>>2]|0)+8>>2]|0;if((l|0)==(k|0)){Fs(m,l+4|0,j+4|0);i=Ka;return}else{Fs(m,j+4|0,k+4|0);i=Ka;return}}function Zv(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0;b=i;i=i+624|0;p=+g[d+116>>2]-+g[d+52>>2];o=+g[d+120>>2]-+g[d+56>>2];n=+g[d+124>>2]-+g[d+60>>2];k=+g[e+116>>2]-+g[e+52>>2];l=+g[e+120>>2]-+g[e+56>>2];j=+g[e+124>>2]-+g[e+60>>2];m=+g[d+252>>2];if(p*p+o*o+n*n<m*m?(p=+g[e+252>>2],k*k+l*l+j*j<p*p):0){j=1.0;i=b;return +j}f=c[d+192>>2]|0;j=+g[e+248>>2];c[b+576>>2]=0;g[b+580>>2]=1.0;g[b+584>>2]=1.0;g[b+588>>2]=1.0;g[b+592>>2]=0.0;c[b+568>>2]=12008;c[b+572>>2]=8;g[b+596>>2]=j;g[b+612>>2]=j;c[b+392>>2]=7512;g[b+556>>2]=999999984306749440.0;c[b+560>>2]=0;g[b+564>>2]=0.0;g[b+340>>2]=9.999999747378752e-05;a[b+364>>0]=0;c[b+16>>2]=19128;c[b+20>>2]=b+32;c[b+24>>2]=f;c[b+28>>2]=b+568;if(UC(b+16|0,d+4|0,d+68|0,e+4|0,e+68|0,b+392|0)|0){j=+g[b+556>>2];if(+g[d+244>>2]>j)g[d+244>>2]=j;if(+g[e+244>>2]>j)g[e+244>>2]=j;if(!(j<1.0))j=1.0}else j=1.0;f=c[e+192>>2]|0;p=+g[d+248>>2];c[b+576>>2]=0;g[b+580>>2]=1.0;g[b+584>>2]=1.0;g[b+588>>2]=1.0;g[b+592>>2]=0.0;c[b+568>>2]=12008;c[b+572>>2]=8;g[b+596>>2]=p;g[b+612>>2]=p;c[b+392>>2]=7512;g[b+556>>2]=999999984306749440.0;c[b+560>>2]=0;g[b+564>>2]=0.0;g[b+340>>2]=9.999999747378752e-05;a[b+364>>0]=0;c[b>>2]=19128;c[b+4>>2]=b+32;c[b+8>>2]=b+568;c[b+12>>2]=f;if(!(UC(b,d+4|0,d+68|0,e+4|0,e+68|0,b+392|0)|0)){i=b;return +j}k=+g[b+556>>2];if(+g[d+244>>2]>k)g[d+244>>2]=k;if(+g[e+244>>2]>k)g[e+244>>2]=k;if(!(j>k)){i=b;return +j}j=k;i=b;return +j}function _v(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0;k=i;if(!(c[b+20>>2]|0)){i=k;return}if(!(a[b+16>>0]|0)){i=k;return}e=c[d+4>>2]|0;if((e|0)==(c[d+8>>2]|0)?(j=(e|0)==0?1:e<<1,(e|0)<(j|0)):0){if(!j)f=0;else{c[5108]=(c[5108]|0)+1;f=QE((j<<2|3)+16|0)|0;if(!f)f=0;else{c[(f+19&-16)+-4>>2]=f;f=f+19&-16}e=c[d+4>>2]|0}if((e|0)>0){h=0;do{g=f+(h<<2)|0;if(g)c[g>>2]=c[(c[d+12>>2]|0)+(h<<2)>>2];h=h+1|0}while((h|0)!=(e|0))}g=c[d+12>>2]|0;if(g){if(a[d+16>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[g+-4>>2]|0);e=c[d+4>>2]|0}c[d+12>>2]=0}a[d+16>>0]=1;c[d+12>>2]=f;c[d+8>>2]=j}f=(c[d+12>>2]|0)+(e<<2)|0;if(f)c[f>>2]=c[b+20>>2];c[d+4>>2]=e+1;i=k;return}function $v(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0;e=i;f=c[d>>2]|0;f=ec[c[(c[f>>2]|0)+56>>2]&31](f,36)|0;if(!f){f=0;i=e;return f|0}h=c[d+4>>2]|0;k=c[b+12>>2]|0;j=c[b+8>>2]|0;g=c[b+16>>2]|0;b=c[b+20>>2]|0;c[f+4>>2]=c[d>>2];c[f>>2]=10424;c[f+8>>2]=k;c[f+12>>2]=j;a[f+16>>0]=0;c[f+20>>2]=h;a[f+24>>0]=0;c[f+28>>2]=g;c[f+32>>2]=b;i=e;return f|0}function aw(b,d,e,f){b=b|0;d=d|0;e=e|0;f=+f;var h=0,j=0.0,k=0.0,l=0.0;h=i;i=i+16|0;g[b+32>>2]=f;c[b+8>>2]=c[d+0>>2];c[b+12>>2]=c[d+4>>2];c[b+16>>2]=c[d+8>>2];c[b+20>>2]=c[d+12>>2];j=+g[b+28>>2];l=+g[e+4>>2]-j*+g[d+4>>2];k=+g[e+8>>2]-j*+g[d+8>>2];g[h>>2]=+g[e>>2]-+g[d>>2]*j;g[h+4>>2]=l;g[h+8>>2]=k;g[h+12>>2]=0.0;f=+g[b+24>>2]+j+f;g[b+32>>2]=f;if(!(f<0.0)){e=b+4|0;e=c[e>>2]|0;b=c[e>>2]|0;b=b+16|0;b=c[b>>2]|0;oc[b&15](e,d,h,f);i=h;return}a[b+36>>0]=1;e=b+4|0;e=c[e>>2]|0;b=c[e>>2]|0;b=b+16|0;b=c[b>>2]|0;oc[b&15](e,d,h,f);i=h;return}function bw(a,b,c){a=a|0;b=b|0;c=c|0;return}function cw(a,b,c){a=a|0;b=b|0;c=c|0;return}function dw(a){a=a|0;var b=0;b=i;RE(a);i=b;return}function ew(b,d,e,f){b=b|0;d=d|0;e=e|0;f=+f;var h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0;o=i;i=i+16|0;j=+g[d>>2];k=+g[d+4>>2];l=+g[d+8>>2];m=+g[e>>2];n=+g[e+4>>2];h=+g[e+8>>2];if(!(a[b+228>>0]|0)){z=+g[b+100>>2];w=+g[b+116>>2];C=+g[b+132>>2];y=+g[b+104>>2];u=+g[b+120>>2];B=+g[b+136>>2];x=+g[b+108>>2];s=+g[b+124>>2];A=+g[b+140>>2];F=-+g[b+148>>2];E=-+g[b+152>>2];D=-+g[b+156>>2];I=+g[b+164>>2];r=+g[b+168>>2];J=+g[b+172>>2];H=+g[b+180>>2];G=+g[b+184>>2];q=+g[b+188>>2];v=+g[b+196>>2];t=+g[b+200>>2];p=+g[b+204>>2];r=h*(C*I+B*r+A*J)+(m*(z*I+y*r+x*J)+n*(w*I+u*r+s*J))+((x*F+s*E+A*D)*J+(I*(z*F+w*E+C*D)+r*(y*F+u*E+B*D))+ +g[b+212>>2]);q=h*(C*H+B*G+A*q)+(m*(z*H+y*G+x*q)+n*(w*H+u*G+s*q))+((z*F+w*E+C*D)*H+(y*F+u*E+B*D)*G+(x*F+s*E+A*D)*q+ +g[b+216>>2]);p=(z*F+w*E+C*D)*v+(y*F+u*E+B*D)*t+(x*F+s*E+A*D)*p+ +g[b+220>>2]+(h*(C*v+B*t+A*p)+(m*(z*v+y*t+x*p)+n*(w*v+u*t+s*p)));g[o>>2]=r;g[o+4>>2]=q;g[o+8>>2]=p;g[o+12>>2]=0.0;h=(j*f+m-r)*+g[d>>2]+(k*f+n-q)*+g[d+4>>2]+(l*f+h-p)*+g[d+8>>2];e=b+32|0;e=c[e>>2]|0;b=c[e>>2]|0;b=b+16|0;b=c[b>>2]|0;oc[b&15](e,d,o,h);i=o;return}else{B=+g[b+36>>2];u=+g[b+52>>2];r=+g[b+68>>2];s=+g[b+40>>2];w=+g[b+56>>2];D=+g[b+72>>2];t=+g[b+44>>2];y=+g[b+60>>2];p=+g[b+76>>2];F=-+g[b+84>>2];E=-+g[b+88>>2];q=-+g[b+92>>2];I=+g[b+164>>2];z=+g[b+168>>2];J=+g[b+172>>2];H=+g[b+180>>2];G=+g[b+184>>2];A=+g[b+188>>2];v=+g[b+196>>2];x=+g[b+200>>2];C=+g[b+204>>2];z=(l*f+h)*(r*I+D*z+p*J)+((j*f+m)*(B*I+s*z+t*J)+(k*f+n)*(u*I+w*z+y*J))+((t*F+y*E+p*q)*J+(I*(B*F+u*E+r*q)+z*(s*F+w*E+D*q))+ +g[b+212>>2]);A=(l*f+h)*(r*H+D*G+p*A)+((j*f+m)*(B*H+s*G+t*A)+(k*f+n)*(u*H+w*G+y*A))+((B*F+u*E+r*q)*H+(s*F+w*E+D*q)*G+(t*F+y*E+p*q)*A+ +g[b+216>>2]);C=(B*F+u*E+r*q)*v+(s*F+w*E+D*q)*x+(t*F+y*E+p*q)*C+ +g[b+220>>2]+((l*f+h)*(r*v+D*x+p*C)+((j*f+m)*(B*v+s*x+t*C)+(k*f+n)*(u*v+w*x+y*C)));g[o>>2]=z+j*(j*(z-m)+k*(A-n)+l*(C-h));g[o+4>>2]=A+k*(j*(z-m)+k*(A-n)+l*(C-h));g[o+8>>2]=C+l*(j*(z-m)+k*(A-n)+l*(C-h));g[o+12>>2]=0.0;C=j*(z-m)+k*(A-n)+l*(C-h);e=b+32|0;e=c[e>>2]|0;b=c[e>>2]|0;b=b+16|0;b=c[b>>2]|0;oc[b&15](e,d,o,C);i=o;return}}function fw(a){a=a|0;var b=0;b=i;RE(a);i=b;return}function gw(a,b,c,d){a=a|0;b=b|0;c=c|0;d=+d;return}function hw(a,b,c){a=a|0;b=b|0;c=c|0;return}function iw(a,b,c){a=a|0;b=b|0;c=c|0;return}function jw(a){a=a|0;var b=0;b=i;RE(a);i=b;return}function kw(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0;m=i;while(1){l=c[a+12>>2]|0;k=c[l+(((b+d|0)/2|0)<<3)>>2]|0;e=b;f=d;while(1){while(1){j=e+1|0;if((c[l+(e<<3)>>2]|0)<(k|0))e=j;else break}while(1){g=l+(f<<3)|0;h=f+-1|0;if((k|0)<(c[g>>2]|0))f=h;else break}if((e|0)<=(f|0)){e=l+(e<<3)|0;n=c[e>>2]|0;l=c[e+4>>2]|0;o=c[g+4>>2]|0;c[e>>2]=c[g>>2];c[e+4>>2]=o;e=(c[a+12>>2]|0)+(f<<3)|0;c[e>>2]=n;c[e+4>>2]=l;e=j;f=h}if((e|0)>(f|0))break;l=c[a+12>>2]|0}if((f|0)>(b|0))kw(a,b,f);if((e|0)<(d|0))b=e;else break}i=m;return}function lw(b,d,e,f,g,h){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0;j=i;c[b+4>>2]=d;c[b>>2]=11016;a[b+24>>0]=1;c[b+20>>2]=0;c[b+12>>2]=0;c[b+16>>2]=0;a[b+28>>0]=h&1;c[b+32>>2]=e;a[b+36>>0]=0;c[b+40>>2]=c[(c[(h?g:f)+4>>2]|0)+68>>2];mw(b,f,g);i=j;return}function mw(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0;n=i;i=i+32|0;l=(a[b+28>>0]|0)!=0;m=l?e:d;l=l?d:e;j=c[m+4>>2]|0;k=c[j+16>>2]|0;d=c[b+12>>2]|0;if((d|0)<(k|0)){if((c[b+16>>2]|0)<(k|0)){if(!k){g=d;h=0}else{c[5108]=(c[5108]|0)+1;e=QE((k<<2|3)+16|0)|0;if(!e)e=0;else{c[(e+19&-16)+-4>>2]=e;e=e+19&-16}g=c[b+12>>2]|0;h=e}if((g|0)>0){e=0;do{f=h+(e<<2)|0;if(f)c[f>>2]=c[(c[b+20>>2]|0)+(e<<2)>>2];e=e+1|0}while((e|0)!=(g|0))}e=c[b+20>>2]|0;if(e){if(a[b+24>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[e+-4>>2]|0)}c[b+20>>2]=0}a[b+24>>0]=1;c[b+20>>2]=h;c[b+16>>2]=k;f=b+20|0}else f=b+20|0;do{e=(c[f>>2]|0)+(d<<2)|0;if(e)c[e>>2]=0;d=d+1|0}while((d|0)!=(k|0))}c[b+12>>2]=k;if((k|0)<=0){i=n;return}e=0;do{if(!(c[j+64>>2]|0)){f=c[(c[j+24>>2]|0)+(e*80|0)+64>>2]|0;g=c[m+8>>2]|0;h=c[m+12>>2]|0;c[n>>2]=m;c[n+4>>2]=f;c[n+8>>2]=g;c[n+12>>2]=h;c[n+16>>2]=-1;c[n+20>>2]=e;h=c[b+4>>2]|0;h=Rb[c[(c[h>>2]|0)+8>>2]&31](h,n,l,c[b+32>>2]|0)|0;c[(c[b+20>>2]|0)+(e<<2)>>2]=h}else c[(c[b+20>>2]|0)+(e<<2)>>2]=0;e=e+1|0}while((e|0)!=(k|0));i=n;return}function nw(b){b=b|0;var d=0,e=0,f=0,g=0;g=i;c[b>>2]=11016;d=c[b+12>>2]|0;if((d|0)>0){f=0;do{e=c[(c[b+20>>2]|0)+(f<<2)>>2]|0;if(e){Jb[c[c[e>>2]>>2]&255](e);e=c[b+4>>2]|0;Lb[c[(c[e>>2]|0)+60>>2]&127](e,c[(c[b+20>>2]|0)+(f<<2)>>2]|0)}f=f+1|0}while((f|0)!=(d|0))}d=c[b+20>>2]|0;if(!d){a[b+24>>0]=1;c[b+20>>2]=0;c[b+12>>2]=0;d=b+16|0;c[d>>2]=0;i=g;return}if(a[b+24>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}c[b+20>>2]=0;a[b+24>>0]=1;c[b+20>>2]=0;c[b+12>>2]=0;d=b+16|0;c[d>>2]=0;i=g;return}function ow(a){a=a|0;var b=0;b=i;nw(a);RE(a);i=b;return}function pw(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,N=0.0,O=0.0,P=0.0,Q=0.0,R=0.0,S=0.0,T=0.0;v=i;i=i+320|0;u=(a[b+28>>0]|0)!=0;t=u?e:d;u=u?d:e;s=c[t+4>>2]|0;if((c[s+68>>2]|0)!=(c[b+40>>2]|0)){k=c[b+12>>2]|0;if((k|0)>0){l=0;do{j=c[(c[b+20>>2]|0)+(l<<2)>>2]|0;if(j){Jb[c[c[j>>2]>>2]&255](j);p=c[b+4>>2]|0;Lb[c[(c[p>>2]|0)+60>>2]&127](p,c[(c[b+20>>2]|0)+(l<<2)>>2]|0)}l=l+1|0}while((l|0)!=(k|0))}mw(b,d,e)}p=c[s+64>>2]|0;m=c[b+4>>2]|0;l=c[b+20>>2]|0;n=c[b+32>>2]|0;c[v+280>>2]=11096;c[v+284>>2]=t;c[v+288>>2]=u;c[v+292>>2]=m;c[v+296>>2]=f;c[v+300>>2]=h;c[v+304>>2]=l;c[v+308>>2]=n;n=v+272|0;a[n>>0]=1;m=v+268|0;c[m>>2]=0;o=v+260|0;c[o>>2]=0;c[v+264>>2]=0;k=c[b+12>>2]|0;if((k|0)>0){f=0;while(1){l=c[l+(f<<2)>>2]|0;if(l){Lb[c[(c[l>>2]|0)+16>>2]&127](l,v+256|0);k=c[o>>2]|0;if((k|0)>0){d=0;do{j=c[(c[m>>2]|0)+(d<<2)>>2]|0;if(c[j+748>>2]|0){c[h+4>>2]=j;l=c[j+740>>2]|0;e=c[(c[h+8>>2]|0)+8>>2]|0;if((l|0)==(e|0))Fs(j,l+4|0,(c[(c[h+12>>2]|0)+8>>2]|0)+4|0);else Fs(j,(c[(c[h+12>>2]|0)+8>>2]|0)+4|0,e+4|0);c[h+4>>2]=0;k=c[o>>2]|0}d=d+1|0}while((d|0)<(k|0));if((k|0)<=0){q=k;r=19}}else{q=k;r=19}if((r|0)==19?(r=0,(q|0)<0):0){if((c[v+264>>2]|0)<0){k=c[m>>2]|0;if(k){if(a[n>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[k+-4>>2]|0)}c[m>>2]=0}a[n>>0]=1;c[m>>2]=0;c[v+264>>2]=0;e=q}else e=q;do{l=(c[m>>2]|0)+(e<<2)|0;if(l)c[l>>2]=0;e=e+1|0}while((e|0)!=0)}c[o>>2]=0;k=c[b+12>>2]|0}f=f+1|0;if((f|0)>=(k|0))break;l=c[b+20>>2]|0}k=c[m>>2]|0;if(k){if(a[n>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[k+-4>>2]|0)}c[m>>2]=0}}a[n>>0]=1;c[m>>2]=0;c[o>>2]=0;c[v+264>>2]=0;if(!p){d=c[b+12>>2]|0;if((d|0)>0){j=0;do{sw(v+280|0,c[(c[s+24>>2]|0)+(j*80|0)+64>>2]|0,j);j=j+1|0}while((j|0)<(d|0))}else{i=v;return}}else{o=c[t+12>>2]|0;K=+g[o>>2];J=+g[o+16>>2];I=+g[o+32>>2];H=+g[o+4>>2];G=+g[o+20>>2];F=+g[o+36>>2];B=+g[o+8>>2];z=+g[o+24>>2];x=+g[o+40>>2];E=-+g[o+48>>2];D=-+g[o+52>>2];C=-+g[o+56>>2];o=c[u+12>>2]|0;T=+g[o>>2];S=+g[o+16>>2];R=+g[o+32>>2];Q=+g[o+4>>2];P=+g[o+20>>2];O=+g[o+36>>2];N=+g[o+8>>2];M=+g[o+24>>2];L=+g[o+40>>2];A=+g[o+48>>2];y=+g[o+52>>2];w=+g[o+56>>2];g[v+160>>2]=K*T+J*S+I*R;g[v+164>>2]=K*Q+J*P+I*O;g[v+168>>2]=K*N+J*M+I*L;g[v+172>>2]=0.0;g[v+176>>2]=H*T+G*S+F*R;g[v+180>>2]=H*Q+G*P+F*O;g[v+184>>2]=H*N+G*M+F*L;g[v+188>>2]=0.0;g[v+192>>2]=B*T+z*S+x*R;g[v+196>>2]=B*Q+z*P+x*O;g[v+200>>2]=B*N+z*M+x*L;g[v+204>>2]=0.0;g[v+208>>2]=K*E+J*D+I*C+(K*A+J*y+I*w);g[v+212>>2]=H*E+G*D+F*C+(H*A+G*y+F*w);g[v+216>>2]=B*E+z*D+x*C+(B*A+z*y+x*w);g[v+220>>2]=0.0;o=c[u+4>>2]|0;tc[c[(c[o>>2]|0)+8>>2]&127](o,v+160|0,v+240|0,v+224|0);c[v+128>>2]=c[v+240>>2];c[v+132>>2]=c[v+244>>2];c[v+136>>2]=c[v+248>>2];c[v+140>>2]=c[v+252>>2];c[v+144>>2]=c[v+224>>2];c[v+148>>2]=c[v+228>>2];c[v+152>>2]=c[v+232>>2];c[v+156>>2]=c[v+236>>2];rw(c[p>>2]|0,v+128|0,v+280|0)}d=c[b+12>>2]|0;if((d|0)<=0){i=v;return}k=0;do{do if(c[(c[b+20>>2]|0)+(k<<2)>>2]|0){n=c[s+24>>2]|0;p=c[n+(k*80|0)+64>>2]|0;o=c[t+12>>2]|0;E=+g[o>>2];D=+g[o+4>>2];C=+g[o+8>>2];B=+g[o+16>>2];A=+g[o+20>>2];z=+g[o+24>>2];J=+g[o+32>>2];L=+g[o+36>>2];N=+g[o+40>>2];y=+g[n+(k*80|0)>>2];x=+g[n+(k*80|0)+16>>2];w=+g[n+(k*80|0)+32>>2];G=+g[n+(k*80|0)+4>>2];H=+g[n+(k*80|0)+20>>2];I=+g[n+(k*80|0)+36>>2];K=+g[n+(k*80|0)+8>>2];M=+g[n+(k*80|0)+24>>2];O=+g[n+(k*80|0)+40>>2];S=+g[n+(k*80|0)+48>>2];F=+g[n+(k*80|0)+52>>2];R=+g[n+(k*80|0)+56>>2];P=+g[o+48>>2]+(E*S+D*F+C*R);Q=+g[o+52>>2]+(B*S+A*F+z*R);R=+g[o+56>>2]+(J*S+L*F+N*R);g[v+64>>2]=E*y+D*x+C*w;g[v+68>>2]=E*G+D*H+C*I;g[v+72>>2]=E*K+D*M+C*O;g[v+76>>2]=0.0;g[v+80>>2]=B*y+A*x+z*w;g[v+84>>2]=B*G+A*H+z*I;g[v+88>>2]=B*K+A*M+z*O;g[v+92>>2]=0.0;g[v+96>>2]=J*y+L*x+N*w;g[v+100>>2]=J*G+L*H+N*I;g[v+104>>2]=J*K+L*M+N*O;g[v+108>>2]=0.0;g[v+112>>2]=P;g[v+116>>2]=Q;g[v+120>>2]=R;g[v+124>>2]=0.0;tc[c[(c[p>>2]|0)+8>>2]&127](p,v+64|0,v+48|0,v+32|0);p=c[u+4>>2]|0;tc[c[(c[p>>2]|0)+8>>2]&127](p,c[u+12>>2]|0,v+16|0,v);if(!(+g[v+48>>2]>+g[v>>2])?!(+g[v+32>>2]<+g[v+16>>2]):0)j=1;else j=0;if(!(!(+g[v+56>>2]>+g[v+8>>2])?!(+g[v+40>>2]<+g[v+24>>2]):0))j=0;if(!(+g[v+52>>2]>+g[v+4>>2])?!(+g[v+36>>2]<+g[v+20>>2]|j^1):0)break;p=c[(c[b+20>>2]|0)+(k<<2)>>2]|0;Jb[c[c[p>>2]>>2]&255](p);p=c[b+4>>2]|0;Lb[c[(c[p>>2]|0)+60>>2]&127](p,c[(c[b+20>>2]|0)+(k<<2)>>2]|0);c[(c[b+20>>2]|0)+(k<<2)>>2]=0}while(0);k=k+1|0}while((k|0)<(d|0));i=v;return}function qw(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var j=0.0,k=0,l=0,m=0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0,E=0,F=0.0,G=0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,N=0.0,O=0.0,P=0.0,Q=0.0,R=0.0;E=i;k=(a[b+28>>0]|0)!=0;D=k?e:d;k=k?d:e;e=c[b+12>>2]|0;if((e|0)<=0){v=1.0;i=E;return +v}m=(c[D+192>>2]|0)+24|0;n=+g[D+4>>2];z=+g[D+8>>2];A=+g[D+12>>2];B=+g[D+16>>2];C=+g[D+20>>2];o=+g[D+24>>2];p=+g[D+28>>2];q=+g[D+32>>2];r=+g[D+36>>2];s=+g[D+40>>2];t=+g[D+44>>2];u=+g[D+48>>2];v=+g[D+52>>2];w=+g[D+56>>2];x=+g[D+60>>2];y=+g[D+64>>2];d=c[D+260>>2]|0;j=1.0;l=0;do{G=c[m>>2]|0;R=+g[G+(l*80|0)>>2];Q=+g[G+(l*80|0)+16>>2];P=+g[G+(l*80|0)+32>>2];O=+g[G+(l*80|0)+4>>2];N=+g[G+(l*80|0)+20>>2];M=+g[G+(l*80|0)+36>>2];L=+g[G+(l*80|0)+8>>2];K=+g[G+(l*80|0)+24>>2];J=+g[G+(l*80|0)+40>>2];I=+g[G+(l*80|0)+48>>2];H=+g[G+(l*80|0)+52>>2];F=+g[G+(l*80|0)+56>>2];c[D+260>>2]=d+1;g[D+4>>2]=n*R+z*Q+A*P;g[D+8>>2]=n*O+z*N+A*M;g[D+12>>2]=n*L+z*K+A*J;g[D+16>>2]=0.0;g[D+20>>2]=C*R+o*Q+p*P;g[D+24>>2]=C*O+o*N+p*M;g[D+28>>2]=C*L+o*K+p*J;g[D+32>>2]=0.0;g[D+36>>2]=r*R+s*Q+t*P;g[D+40>>2]=r*O+s*N+t*M;g[D+44>>2]=r*L+s*K+t*J;g[D+48>>2]=0.0;g[D+52>>2]=v+(n*I+z*H+A*F);g[D+56>>2]=w+(C*I+o*H+p*F);g[D+60>>2]=x+(r*I+s*H+t*F);g[D+64>>2]=0.0;G=c[(c[b+20>>2]|0)+(l<<2)>>2]|0;F=+Vb[c[(c[G>>2]|0)+12>>2]&15](G,D,k,f,h);j=F<j?F:j;d=(c[D+260>>2]|0)+1|0;c[D+260>>2]=d;g[D+4>>2]=n;g[D+8>>2]=z;g[D+12>>2]=A;g[D+16>>2]=B;g[D+20>>2]=C;g[D+24>>2]=o;g[D+28>>2]=p;g[D+32>>2]=q;g[D+36>>2]=r;g[D+40>>2]=s;g[D+44>>2]=t;g[D+48>>2]=u;g[D+52>>2]=v;g[D+56>>2]=w;g[D+60>>2]=x;g[D+64>>2]=y;l=l+1|0}while((l|0)!=(e|0));i=E;return +j}function rw(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,h=0,j=0,k=0,l=0,m=0,n=0.0,o=0,p=0,q=0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0;w=i;if(!a){i=w;return}r=+g[b>>2];s=+g[b+4>>2];t=+g[b+8>>2];u=+g[b+16>>2];v=+g[b+20>>2];n=+g[b+24>>2];c[5108]=(c[5108]|0)+1;b=QE(275)|0;if(b){c[(b+19&-16)+-4>>2]=b;e=b+19&-16;if(b+19&-16)c[e>>2]=a}else e=0;b=64;m=1;while(1){a=m+-1|0;l=c[e+(a<<2)>>2]|0;do if(((((+g[l>>2]<=u?+g[l+16>>2]>=r:0)?+g[l+4>>2]<=v:0)?+g[l+20>>2]>=s:0)?+g[l+8>>2]<=n:0)?+g[l+24>>2]>=t:0){if(!(c[l+40>>2]|0)){Lb[c[(c[d>>2]|0)+12>>2]&127](d,l);break}k=c[l+36>>2]|0;if((a|0)==(b|0)?(o=(b|0)==0?1:b<<1,(m|0)<=(o|0)):0){if((o|0)!=0?(c[5108]=(c[5108]|0)+1,q=QE((o<<2|3)+16|0)|0,(q|0)!=0):0){c[(q+19&-16)+-4>>2]=q;j=q+19&-16}else j=0;if((b|0)>0){f=0;do{h=j+(f<<2)|0;if(h)c[h>>2]=c[e+(f<<2)>>2];f=f+1|0}while((f|0)!=(b|0))}if(!e){b=o;e=j}else{c[5110]=(c[5110]|0)+1;RE(c[e+-4>>2]|0);b=o;e=j}}a=e+(a<<2)|0;if(a)c[a>>2]=k;j=c[l+40>>2]|0;if((m|0)==(b|0)){a=(m|0)==0?1:m<<1;if((m|0)<(a|0)){if((a|0)!=0?(c[5108]=(c[5108]|0)+1,p=QE((a<<2|3)+16|0)|0,(p|0)!=0):0){c[(p+19&-16)+-4>>2]=p;h=p+19&-16}else h=0;if((m|0)>0){f=0;do{b=h+(f<<2)|0;if(b)c[b>>2]=c[e+(f<<2)>>2];f=f+1|0}while((f|0)!=(m|0))}if(!e){b=a;e=h}else{c[5110]=(c[5110]|0)+1;RE(c[e+-4>>2]|0);b=a;e=h}}else b=m}a=e+(m<<2)|0;if(a)c[a>>2]=j;a=m+1|0}while(0);if((a|0)>0)m=a;else break}if(!e){i=w;return}c[5110]=(c[5110]|0)+1;RE(c[e+-4>>2]|0);i=w;return}function sw(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,h=0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0;h=i;i=i+160|0;f=c[a+4>>2]|0;e=c[f+12>>2]|0;D=+g[e>>2];C=+g[e+4>>2];B=+g[e+8>>2];A=+g[e+16>>2];z=+g[e+20>>2];y=+g[e+24>>2];r=+g[e+32>>2];p=+g[e+36>>2];n=+g[e+40>>2];f=c[(c[f+4>>2]|0)+24>>2]|0;x=+g[f+(d*80|0)>>2];w=+g[f+(d*80|0)+16>>2];v=+g[f+(d*80|0)+32>>2];u=+g[f+(d*80|0)+4>>2];t=+g[f+(d*80|0)+20>>2];s=+g[f+(d*80|0)+36>>2];q=+g[f+(d*80|0)+8>>2];o=+g[f+(d*80|0)+24>>2];m=+g[f+(d*80|0)+40>>2];F=+g[f+(d*80|0)+48>>2];E=+g[f+(d*80|0)+52>>2];j=+g[f+(d*80|0)+56>>2];l=+g[e+48>>2]+(D*F+C*E+B*j);k=+g[e+52>>2]+(A*F+z*E+y*j);j=+g[e+56>>2]+(r*F+p*E+n*j);g[h+88>>2]=D*x+C*w+B*v;g[h+92>>2]=D*u+C*t+B*s;g[h+96>>2]=D*q+C*o+B*m;g[h+100>>2]=0.0;g[h+104>>2]=A*x+z*w+y*v;g[h+108>>2]=A*u+z*t+y*s;g[h+112>>2]=A*q+z*o+y*m;g[h+116>>2]=0.0;g[h+120>>2]=r*x+p*w+n*v;g[h+124>>2]=r*u+p*t+n*s;g[h+128>>2]=r*q+p*o+n*m;g[h+132>>2]=0.0;g[h+136>>2]=l;g[h+140>>2]=k;g[h+144>>2]=j;g[h+148>>2]=0.0;tc[c[(c[b>>2]|0)+8>>2]&127](b,h+88|0,h+72|0,h+56|0);e=c[a+8>>2]|0;f=c[e+4>>2]|0;tc[c[(c[f>>2]|0)+8>>2]&127](f,c[e+12>>2]|0,h+40|0,h+24|0);if(!(+g[h+72>>2]>+g[h+24>>2])?!(+g[h+56>>2]<+g[h+40>>2]):0)e=1;else e=0;if(!(!(+g[h+80>>2]>+g[h+32>>2])?!(+g[h+64>>2]<+g[h+48>>2]):0))e=0;if(+g[h+76>>2]>+g[h+28>>2]){i=h;return}if(+g[h+60>>2]<+g[h+44>>2]|e^1){i=h;return}e=c[a+4>>2]|0;f=c[e+8>>2]|0;c[h>>2]=e;c[h+4>>2]=b;c[h+8>>2]=f;c[h+12>>2]=h+88;c[h+16>>2]=-1;c[h+20>>2]=d;if(!(c[(c[a+24>>2]|0)+(d<<2)>>2]|0)){e=c[a+12>>2]|0;e=Rb[c[(c[e>>2]|0)+8>>2]&31](e,h,c[a+8>>2]|0,c[a+28>>2]|0)|0;c[(c[a+24>>2]|0)+(d<<2)>>2]=e;e=c[a+4>>2]|0}b=c[a+20>>2]|0;f=c[b+8>>2]|0;if((c[f+8>>2]|0)==(c[e+8>>2]|0)){c[b+8>>2]=h;pc[c[(c[b>>2]|0)+8>>2]&127](b,-1,d)}else{f=c[b+12>>2]|0;c[b+12>>2]=h;pc[c[(c[b>>2]|0)+12>>2]&127](b,-1,d)}e=c[(c[a+24>>2]|0)+(d<<2)>>2]|0;Hb[c[(c[e>>2]|0)+8>>2]&31](e,h,c[a+8>>2]|0,c[a+16>>2]|0,c[a+20>>2]|0);e=c[a+20>>2]|0;if((c[(c[e+8>>2]|0)+8>>2]|0)==(c[(c[a+4>>2]|0)+8>>2]|0)){c[e+8>>2]=f;i=h;return}else{c[e+12>>2]=f;i=h;return}}function tw(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0;g=i;d=c[a+12>>2]|0;if((d|0)<=0){i=g;return}f=0;do{e=c[(c[a+20>>2]|0)+(f<<2)>>2]|0;if(e){Lb[c[(c[e>>2]|0)+16>>2]&127](e,b);d=c[a+12>>2]|0}f=f+1|0}while((f|0)<(d|0));i=g;return}function uw(a,b){a=a|0;b=b|0;var d=0;d=i;b=c[b+36>>2]|0;sw(a,c[(c[(c[(c[a+4>>2]|0)+4>>2]|0)+24>>2]|0)+(b*80|0)+64>>2]|0,b);i=d;return}function vw(a){a=a|0;var b=0;b=i;RE(a);i=b;return}function ww(b){b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0;h=i;c[b>>2]=11184;d=c[b+8>>2]|0;e=c[d+8>>2]|0;if((e|0)>0){g=0;do{f=c[(c[d+16>>2]|0)+(g*12|0)+8>>2]|0;if(f){Jb[c[c[f>>2]>>2]&255](f);j=c[b+4>>2]|0;Lb[c[(c[j>>2]|0)+60>>2]&127](j,f)}g=g+1|0}while((g|0)!=(e|0));d=c[b+8>>2]|0}ID(d);d=c[b+8>>2]|0;Jb[c[c[d>>2]>>2]&255](d);d=c[b+8>>2]|0;if(d){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}d=c[b+24>>2]|0;if(!d){a[b+28>>0]=1;c[b+24>>2]=0;c[b+16>>2]=0;d=b+20|0;c[d>>2]=0;i=h;return}if(a[b+28>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}c[b+24>>2]=0;a[b+28>>0]=1;c[b+24>>2]=0;c[b+16>>2]=0;d=b+20|0;c[d>>2]=0;i=h;return}function xw(a){a=a|0;var b=0;b=i;ww(a);RE(a);i=b;return}function yw(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0;g=i;f=c[a+8>>2]|0;a=c[f+8>>2]|0;if((a|0)<=0){i=g;return}e=0;do{d=c[(c[f+16>>2]|0)+(e*12|0)+8>>2]|0;if(d){Lb[c[(c[d>>2]|0)+16>>2]&127](d,b);a=c[f+8>>2]|0}e=e+1|0}while((e|0)<(a|0));i=g;return}function zw(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,N=0.0,P=0.0,Q=0.0,R=0.0,S=0.0,T=0.0,U=0.0,V=0.0,W=0.0,X=0.0,Y=0.0,Z=0.0,_=0.0,$=0.0,aa=0,ba=0,ca=0,da=0,ea=0,fa=0.0,ga=0.0,ha=0.0,ia=0.0,ja=0.0,ka=0.0,la=0.0,ma=0.0,na=0.0,oa=0.0,pa=0.0;ea=i;i=i+192|0;ca=c[d+4>>2]|0;da=c[e+4>>2]|0;if((c[ca+68>>2]|0)==(c[b+40>>2]|0)?(c[da+68>>2]|0)==(c[b+44>>2]|0):0)aa=b+8|0;else{l=c[b+8>>2]|0;k=c[l+8>>2]|0;if((k|0)>0){m=0;do{j=c[(c[l+16>>2]|0)+(m*12|0)+8>>2]|0;if(j){Jb[c[c[j>>2]>>2]&255](j);r=c[b+4>>2]|0;Lb[c[(c[r>>2]|0)+60>>2]&127](r,j)}m=m+1|0}while((m|0)!=(k|0));l=c[b+8>>2]|0}ID(l);aa=b+8|0}j=ea+180|0;a[j>>0]=1;n=ea+176|0;c[n>>2]=0;r=ea+168|0;c[r>>2]=0;c[ea+172>>2]=0;p=c[aa>>2]|0;m=c[p+8>>2]|0;if((m|0)>0){q=0;do{l=c[(c[p+16>>2]|0)+(q*12|0)+8>>2]|0;if(l){Lb[c[(c[l>>2]|0)+16>>2]&127](l,ea+164|0);m=c[r>>2]|0;if((m|0)>0){o=0;do{k=c[(c[n>>2]|0)+(o<<2)>>2]|0;if(c[k+748>>2]|0){c[h+4>>2]=k;m=c[k+740>>2]|0;l=c[(c[h+8>>2]|0)+8>>2]|0;if((m|0)==(l|0))Fs(k,m+4|0,(c[(c[h+12>>2]|0)+8>>2]|0)+4|0);else Fs(k,(c[(c[h+12>>2]|0)+8>>2]|0)+4|0,l+4|0);c[h+4>>2]=0;m=c[r>>2]|0}o=o+1|0}while((o|0)<(m|0));if((m|0)<=0){s=m;t=22}}else{s=m;t=22}if((t|0)==22?(t=0,(s|0)<0):0){if((c[ea+172>>2]|0)<0){m=c[n>>2]|0;if(m){if(a[j>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[m+-4>>2]|0)}c[n>>2]=0}a[j>>0]=1;c[n>>2]=0;c[ea+172>>2]=0;l=s}else l=s;do{m=(c[n>>2]|0)+(l<<2)|0;if(m)c[m>>2]=0;l=l+1|0}while((l|0)!=0)}c[r>>2]=0;m=c[p+8>>2]|0}q=q+1|0}while((q|0)<(m|0));l=c[n>>2]|0;if(l){if(a[j>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[l+-4>>2]|0)}c[n>>2]=0}}a[j>>0]=1;c[n>>2]=0;c[r>>2]=0;c[ea+172>>2]=0;r=c[ca+64>>2]|0;q=c[da+64>>2]|0;o=c[b+4>>2]|0;p=c[aa>>2]|0;s=c[b+32>>2]|0;c[ea+128>>2]=11272;c[ea+132>>2]=0;c[ea+136>>2]=d;c[ea+140>>2]=e;c[ea+144>>2]=o;c[ea+148>>2]=f;c[ea+152>>2]=h;c[ea+156>>2]=p;c[ea+160>>2]=s;s=c[d+12>>2]|0;D=+g[s>>2];E=+g[s+16>>2];F=+g[s+32>>2];G=+g[s+4>>2];H=+g[s+20>>2];I=+g[s+36>>2];J=+g[s+8>>2];K=+g[s+24>>2];L=+g[s+40>>2];Z=-+g[s+48>>2];_=-+g[s+52>>2];$=-+g[s+56>>2];s=c[e+12>>2]|0;M=+g[s>>2];N=+g[s+16>>2];P=+g[s+32>>2];Q=+g[s+4>>2];R=+g[s+20>>2];S=+g[s+36>>2];T=+g[s+8>>2];U=+g[s+24>>2];V=+g[s+40>>2];W=+g[s+48>>2];X=+g[s+52>>2];Y=+g[s+56>>2];r=c[r>>2]|0;q=c[q>>2]|0;if((r|0)!=0&(q|0)!=0){c[5108]=(c[5108]|0)+1;o=QE(1043)|0;c[(o+19&-16)+-4>>2]=o;c[(o+19&-16)>>2]=r;c[(o+19&-16)+4>>2]=q;v=+O(+(D*M+E*N+F*P));A=+O(+(D*Q+E*R+F*S));C=+O(+(D*T+E*U+F*V));x=+O(+(G*M+H*N+I*P));y=+O(+(G*Q+H*R+I*S));w=+O(+(G*T+H*U+I*V));B=+O(+(J*M+K*N+L*P));z=+O(+(J*Q+K*R+L*S));u=+O(+(J*T+K*U+L*V));r=1;j=128;t=128;o=o+19&-16;f=124;while(1){n=r+-1|0;p=c[o+(n<<3)>>2]|0;q=c[o+(n<<3)+4>>2]|0;pa=+g[q+16>>2];oa=+g[q>>2];na=+g[q+20>>2];ma=+g[q+4>>2];la=+g[q+24>>2];fa=+g[q+8>>2];ka=D*Z+E*_+F*$+(D*W+E*X+F*Y)+((D*M+E*N+F*P)*((pa+oa)*.5)+(D*Q+E*R+F*S)*((na+ma)*.5)+(D*T+E*U+F*V)*((la+fa)*.5));ia=G*Z+H*_+I*$+(G*W+H*X+I*Y)+((G*M+H*N+I*P)*((pa+oa)*.5)+(G*Q+H*R+I*S)*((na+ma)*.5)+(G*T+H*U+I*V)*((la+fa)*.5));ga=J*Z+K*_+L*$+(J*W+K*X+L*Y)+((J*M+K*N+L*P)*((pa+oa)*.5)+(J*Q+K*R+L*S)*((na+ma)*.5)+(J*T+K*U+L*V)*((la+fa)*.5));ja=((pa-oa)*.5+0.0)*v+((na-ma)*.5+0.0)*A+((la-fa)*.5+0.0)*C;ha=((pa-oa)*.5+0.0)*x+((na-ma)*.5+0.0)*y+((la-fa)*.5+0.0)*w;fa=((pa-oa)*.5+0.0)*B+((na-ma)*.5+0.0)*z+((la-fa)*.5+0.0)*u;do if(((((+g[p>>2]<=ja+ka?+g[p+16>>2]>=ka-ja:0)?+g[p+4>>2]<=ia+ha:0)?+g[p+20>>2]>=ia-ha:0)?+g[p+8>>2]<=ga+fa:0)?+g[p+24>>2]>=ga-fa:0){if((n|0)>(f|0)){k=j<<1;if((j|0)<(k|0)&(t|0)<(k|0)){if(j){c[5108]=(c[5108]|0)+1;h=QE((j<<4|3)+16|0)|0;if(!h)h=0;else{c[(h+19&-16)+-4>>2]=h;h=h+19&-16}if((j|0)>0){t=0;do{f=h+(t<<3)|0;if(f){m=o+(t<<3)|0;s=c[m+4>>2]|0;c[f>>2]=c[m>>2];c[f+4>>2]=s}t=t+1|0}while((t|0)!=(j|0))}}else h=0;if(!o)f=k;else{c[5110]=(c[5110]|0)+1;RE(c[o+-4>>2]|0);f=k}}else{f=t;h=o}m=k;l=f;f=k+-4|0}else{m=j;l=t;h=o}k=(c[q+40>>2]|0)!=0;if(!(c[p+40>>2]|0))if(k){k=c[q+36>>2]|0;j=h+(n<<3)|0;c[j>>2]=p;c[j+4>>2]=k;j=c[q+40>>2]|0;k=h+(r<<3)|0;c[k>>2]=p;c[k+4>>2]=j;k=r+1|0;j=m;t=l;break}else{pc[c[(c[ea+128>>2]|0)+8>>2]&127](ea+128|0,p,q);k=n;j=m;t=l;break}else{j=h+(n<<3)|0;t=c[p+36>>2]|0;if(k){k=c[q+36>>2]|0;c[j>>2]=t;c[j+4>>2]=k;j=c[q+36>>2]|0;k=h+(r<<3)|0;c[k>>2]=c[p+40>>2];c[k+4>>2]=j;k=c[q+40>>2]|0;j=h+(r+1<<3)|0;c[j>>2]=c[p+36>>2];c[j+4>>2]=k;j=c[q+40>>2]|0;k=h+(r+2<<3)|0;c[k>>2]=c[p+40>>2];c[k+4>>2]=j;k=r+3|0;j=m;t=l;break}else{c[j>>2]=t;c[j+4>>2]=q;k=h+(r<<3)|0;c[k>>2]=c[p+40>>2];c[k+4>>2]=q;k=r+1|0;j=m;t=l;break}}}else{k=n;h=o}while(0);if(!k)break;else{r=k;o=h}}if(h){c[5110]=(c[5110]|0)+1;RE(c[h+-4>>2]|0)}}p=c[aa>>2]|0;if((c[p+8>>2]|0)>0){q=0;do{l=c[p+16>>2]|0;k=c[l+(q*12|0)+8>>2]|0;do if(k){s=c[l+(q*12|0)>>2]|0;r=c[ca+24>>2]|0;o=c[r+(s*80|0)+64>>2]|0;n=c[d+12>>2]|0;Q=+g[n>>2];pa=+g[n+4>>2];z=+g[n+8>>2];M=+g[n+16>>2];K=+g[n+20>>2];I=+g[n+24>>2];L=+g[n+32>>2];H=+g[n+36>>2];w=+g[n+40>>2];G=+g[r+(s*80|0)>>2];F=+g[r+(s*80|0)+16>>2];E=+g[r+(s*80|0)+32>>2];u=+g[r+(s*80|0)+4>>2];la=+g[r+(s*80|0)+20>>2];v=+g[r+(s*80|0)+36>>2];J=+g[r+(s*80|0)+8>>2];ma=+g[r+(s*80|0)+24>>2];na=+g[r+(s*80|0)+40>>2];P=+g[r+(s*80|0)+48>>2];N=+g[r+(s*80|0)+52>>2];y=+g[r+(s*80|0)+56>>2];x=+g[n+48>>2]+(Q*P+pa*N+z*y);oa=+g[n+52>>2]+(M*P+K*N+I*y);y=+g[n+56>>2]+(L*P+H*N+w*y);g[ea>>2]=Q*G+pa*F+z*E;g[ea+4>>2]=Q*u+pa*la+z*v;g[ea+8>>2]=Q*J+pa*ma+z*na;g[ea+12>>2]=0.0;g[ea+16>>2]=M*G+K*F+I*E;g[ea+20>>2]=M*u+K*la+I*v;g[ea+24>>2]=M*J+K*ma+I*na;g[ea+28>>2]=0.0;g[ea+32>>2]=L*G+H*F+w*E;g[ea+36>>2]=L*u+H*la+w*v;g[ea+40>>2]=L*J+H*ma+w*na;g[ea+44>>2]=0.0;g[ea+48>>2]=x;g[ea+52>>2]=oa;g[ea+56>>2]=y;g[ea+60>>2]=0.0;tc[c[(c[o>>2]|0)+8>>2]&127](o,ea,ea+112|0,ea+96|0);o=c[(c[p+16>>2]|0)+(q*12|0)+4>>2]|0;n=c[da+24>>2]|0;s=c[n+(o*80|0)+64>>2]|0;r=c[e+12>>2]|0;y=+g[r>>2];oa=+g[r+4>>2];x=+g[r+8>>2];na=+g[r+16>>2];w=+g[r+20>>2];ma=+g[r+24>>2];H=+g[r+32>>2];J=+g[r+36>>2];L=+g[r+40>>2];v=+g[n+(o*80|0)>>2];la=+g[n+(o*80|0)+16>>2];u=+g[n+(o*80|0)+32>>2];E=+g[n+(o*80|0)+4>>2];F=+g[n+(o*80|0)+20>>2];G=+g[n+(o*80|0)+36>>2];I=+g[n+(o*80|0)+8>>2];K=+g[n+(o*80|0)+24>>2];M=+g[n+(o*80|0)+40>>2];z=+g[n+(o*80|0)+48>>2];pa=+g[n+(o*80|0)+52>>2];Q=+g[n+(o*80|0)+56>>2];N=+g[r+48>>2]+(y*z+oa*pa+x*Q);P=+g[r+52>>2]+(na*z+w*pa+ma*Q);Q=+g[r+56>>2]+(H*z+J*pa+L*Q);g[ea>>2]=y*v+oa*la+x*u;g[ea+4>>2]=y*E+oa*F+x*G;g[ea+8>>2]=y*I+oa*K+x*M;g[ea+12>>2]=0.0;g[ea+16>>2]=na*v+w*la+ma*u;g[ea+20>>2]=na*E+w*F+ma*G;g[ea+24>>2]=na*I+w*K+ma*M;g[ea+28>>2]=0.0;g[ea+32>>2]=H*v+J*la+L*u;g[ea+36>>2]=H*E+J*F+L*G;g[ea+40>>2]=H*I+J*K+L*M;g[ea+44>>2]=0.0;g[ea+48>>2]=N;g[ea+52>>2]=P;g[ea+56>>2]=Q;g[ea+60>>2]=0.0;tc[c[(c[s>>2]|0)+8>>2]&127](s,ea,ea+80|0,ea+64|0);if(!(+g[ea+112>>2]>+g[ea+64>>2])?!(+g[ea+96>>2]<+g[ea+80>>2]):0)l=1;else l=0;if(!(!(+g[ea+120>>2]>+g[ea+72>>2])?!(+g[ea+104>>2]<+g[ea+88>>2]):0))l=0;if(!(+g[ea+116>>2]>+g[ea+68>>2])?!(+g[ea+100>>2]<+g[ea+84>>2]|l^1):0)break;Jb[c[c[k>>2]>>2]&255](k);o=c[b+4>>2]|0;Lb[c[(c[o>>2]|0)+60>>2]&127](o,k);o=c[p+16>>2]|0;n=c[o+(q*12|0)>>2]|0;o=c[o+(q*12|0)+4>>2]|0;l=c[b+16>>2]|0;if((l|0)==(c[b+20>>2]|0)?(ba=(l|0)==0?1:l<<1,(l|0)<(ba|0)):0){if(!ba)k=0;else{c[5108]=(c[5108]|0)+1;l=QE((ba*12|3)+16|0)|0;if(!l)k=0;else{c[(l+19&-16)+-4>>2]=l;k=l+19&-16}l=c[b+16>>2]|0}if((l|0)>0){j=0;do{m=k+(j*12|0)|0;if(m){s=(c[b+24>>2]|0)+(j*12|0)|0;c[m+0>>2]=c[s+0>>2];c[m+4>>2]=c[s+4>>2];c[m+8>>2]=c[s+8>>2]}j=j+1|0}while((j|0)!=(l|0))}l=c[b+24>>2]|0;if(l){if(a[b+28>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[l+-4>>2]|0)}c[b+24>>2]=0}a[b+28>>0]=1;c[b+24>>2]=k;c[b+20>>2]=ba;l=c[b+16>>2]|0}k=c[b+24>>2]|0;j=k+(l*12|0)|0;if(j){c[j>>2]=n;c[k+(l*12|0)+4>>2]=o;c[k+(l*12|0)+8>>2]=0;l=c[b+16>>2]|0}c[b+16>>2]=l+1}while(0);q=q+1|0}while((q|0)<(c[p+8>>2]|0));k=b+24|0;l=b+16|0}else{k=b+24|0;l=b+16|0}if((c[l>>2]|0)>0){j=0;do{r=c[aa>>2]|0;s=c[k>>2]|0;Wb[c[(c[r>>2]|0)+8>>2]&63](r,c[s+(j*12|0)>>2]|0,c[s+(j*12|0)+4>>2]|0)|0;j=j+1|0}while((j|0)<(c[l>>2]|0))}j=c[k>>2]|0;if(!j){a[b+28>>0]=1;c[k>>2]=0;c[l>>2]=0;s=b+20|0;c[s>>2]=0;i=ea;return}if(a[b+28>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[j+-4>>2]|0)}c[k>>2]=0;a[b+28>>0]=1;c[k>>2]=0;c[l>>2]=0;s=b+20|0;c[s>>2]=0;i=ea;return}function Aw(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;return 0.0}function Bw(a,b){a=a|0;b=b|0;return}function Cw(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,h=0,j=0,k=0,l=0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0,K=0;l=i;i=i+240|0;c[a+4>>2]=(c[a+4>>2]|0)+1;j=c[b+36>>2]|0;h=c[d+36>>2]|0;d=c[a+8>>2]|0;K=c[(c[d+4>>2]|0)+24>>2]|0;b=c[K+(j*80|0)+64>>2]|0;J=(c[(c[a+12>>2]|0)+4>>2]|0)+24|0;e=c[(c[J>>2]|0)+(h*80|0)+64>>2]|0;d=c[d+12>>2]|0;m=+g[d>>2];H=+g[d+4>>2];I=+g[d+8>>2];p=+g[d+16>>2];r=+g[d+20>>2];t=+g[d+24>>2];q=+g[d+32>>2];u=+g[d+36>>2];C=+g[d+40>>2];v=+g[K+(j*80|0)>>2];w=+g[K+(j*80|0)+16>>2];x=+g[K+(j*80|0)+32>>2];y=+g[K+(j*80|0)+4>>2];z=+g[K+(j*80|0)+20>>2];A=+g[K+(j*80|0)+36>>2];s=+g[K+(j*80|0)+8>>2];B=+g[K+(j*80|0)+24>>2];D=+g[K+(j*80|0)+40>>2];n=+g[K+(j*80|0)+48>>2];o=+g[K+(j*80|0)+52>>2];G=+g[K+(j*80|0)+56>>2];E=+g[d+48>>2]+(m*n+H*o+I*G);F=+g[d+52>>2]+(p*n+r*o+t*G);G=+g[d+56>>2]+(q*n+u*o+C*G);g[l+176>>2]=m*v+H*w+I*x;g[l+180>>2]=m*y+H*z+I*A;g[l+184>>2]=m*s+H*B+I*D;g[l+188>>2]=0.0;g[l+192>>2]=p*v+r*w+t*x;g[l+196>>2]=p*y+r*z+t*A;g[l+200>>2]=p*s+r*B+t*D;g[l+204>>2]=0.0;g[l+208>>2]=q*v+u*w+C*x;g[l+212>>2]=q*y+u*z+C*A;g[l+216>>2]=q*s+u*B+C*D;g[l+220>>2]=0.0;g[l+224>>2]=E;g[l+228>>2]=F;g[l+232>>2]=G;g[l+236>>2]=0.0;d=c[(c[a+12>>2]|0)+12>>2]|0;G=+g[d>>2];F=+g[d+4>>2];E=+g[d+8>>2];D=+g[d+16>>2];C=+g[d+20>>2];B=+g[d+24>>2];u=+g[d+32>>2];s=+g[d+36>>2];q=+g[d+40>>2];J=c[J>>2]|0;A=+g[J+(h*80|0)>>2];z=+g[J+(h*80|0)+16>>2];y=+g[J+(h*80|0)+32>>2];x=+g[J+(h*80|0)+4>>2];w=+g[J+(h*80|0)+20>>2];v=+g[J+(h*80|0)+36>>2];t=+g[J+(h*80|0)+8>>2];r=+g[J+(h*80|0)+24>>2];p=+g[J+(h*80|0)+40>>2];I=+g[J+(h*80|0)+48>>2];H=+g[J+(h*80|0)+52>>2];m=+g[J+(h*80|0)+56>>2];o=+g[d+48>>2]+(G*I+F*H+E*m);n=+g[d+52>>2]+(D*I+C*H+B*m);m=+g[d+56>>2]+(u*I+s*H+q*m);g[l+112>>2]=G*A+F*z+E*y;g[l+116>>2]=G*x+F*w+E*v;g[l+120>>2]=G*t+F*r+E*p;g[l+124>>2]=0.0;g[l+128>>2]=D*A+C*z+B*y;g[l+132>>2]=D*x+C*w+B*v;g[l+136>>2]=D*t+C*r+B*p;g[l+140>>2]=0.0;g[l+144>>2]=u*A+s*z+q*y;g[l+148>>2]=u*x+s*w+q*v;g[l+152>>2]=u*t+s*r+q*p;g[l+156>>2]=0.0;g[l+160>>2]=o;g[l+164>>2]=n;g[l+168>>2]=m;g[l+172>>2]=0.0;tc[c[(c[b>>2]|0)+8>>2]&127](b,l+176|0,l+96|0,l+80|0);tc[c[(c[e>>2]|0)+8>>2]&127](e,l+112|0,l+64|0,l+48|0);if(!(+g[l+96>>2]>+g[l+48>>2])?!(+g[l+80>>2]<+g[l+64>>2]):0)d=1;else d=0;if(!(!(+g[l+104>>2]>+g[l+56>>2])?!(+g[l+88>>2]<+g[l+72>>2]):0))d=0;if(+g[l+100>>2]>+g[l+52>>2]){i=l;return}if(+g[l+84>>2]<+g[l+68>>2]|d^1){i=l;return}J=c[a+8>>2]|0;d=c[J+8>>2]|0;c[l+24>>2]=J;c[l+28>>2]=b;c[l+32>>2]=d;c[l+36>>2]=l+176;c[l+40>>2]=-1;c[l+44>>2]=j;d=c[a+12>>2]|0;b=c[d+8>>2]|0;c[l>>2]=d;c[l+4>>2]=e;c[l+8>>2]=b;c[l+12>>2]=l+112;c[l+16>>2]=-1;c[l+20>>2]=h;b=c[a+28>>2]|0;c[4976]=(c[4976]|0)+1;d=((h<<16|j)+~((h<<16|j)<<15)>>10^(h<<16|j)+~((h<<16|j)<<15))*9|0;d=(c[b+12>>2]|0)+-1&((d>>6^d)+~((d>>6^d)<<11)>>16^(d>>6^d)+~((d>>6^d)<<11));a:do if((d|0)<(c[b+32>>2]|0)?(f=c[(c[b+40>>2]|0)+(d<<2)>>2]|0,(f|0)!=-1):0){e=c[b+16>>2]|0;d=f;while(1){if((c[e+(d*12|0)>>2]|0)==(j|0)?(c[e+(d*12|0)+4>>2]|0)==(h|0):0)break;d=c[(c[b+60>>2]|0)+(d<<2)>>2]|0;if((d|0)==-1){k=17;break a}}if(e+(d*12|0)|0)b=c[e+(d*12|0)+8>>2]|0;else k=17}else k=17;while(0);if((k|0)==17){b=c[a+16>>2]|0;b=Rb[c[(c[b>>2]|0)+8>>2]&31](b,l+24|0,l,c[a+32>>2]|0)|0;J=c[a+28>>2]|0;c[(Wb[c[(c[J>>2]|0)+12>>2]&63](J,j,h)|0)+8>>2]=b}J=c[a+24>>2]|0;f=c[J+8>>2]|0;k=c[J+12>>2]|0;c[J+8>>2]=l+24;c[J+12>>2]=l;pc[c[(c[J>>2]|0)+8>>2]&127](J,-1,j);J=c[a+24>>2]|0;pc[c[(c[J>>2]|0)+12>>2]&127](J,-1,h);Hb[c[(c[b>>2]|0)+8>>2]&31](b,l+24|0,l,c[a+20>>2]|0,c[a+24>>2]|0);J=c[a+24>>2]|0;c[J+8>>2]=f;c[J+12>>2]=k;i=l;return}function Dw(a){a=a|0;var b=0;b=i;RE(a);i=b;return}function Ew(b,d){b=b|0;d=d|0;var e=0,f=0;f=i;c[b+8>>2]=0;c[b>>2]=11368;a[b+28>>0]=1;c[b+24>>2]=0;c[b+16>>2]=0;c[b+20>>2]=0;g[b+32>>2]=999999984306749440.0;g[b+36>>2]=999999984306749440.0;g[b+40>>2]=999999984306749440.0;g[b+44>>2]=0.0;g[b+48>>2]=-999999984306749440.0;g[b+52>>2]=-999999984306749440.0;g[b+56>>2]=-999999984306749440.0;g[b+60>>2]=0.0;c[b+64>>2]=0;c[b+68>>2]=1;g[b+72>>2]=0.0;g[b+76>>2]=1.0;g[b+80>>2]=1.0;g[b+84>>2]=1.0;g[b+88>>2]=0.0;c[b+4>>2]=31;if(!d){i=f;return}c[5108]=(c[5108]|0)+1;d=QE(79)|0;if((d|0)!=0?(e=d+19&-16,c[e+-4>>2]=d,(d+19&-16|0)!=0):0){a[e+36>>0]=1;c[e+32>>2]=0;c[e+24>>2]=0;c[e+28>>2]=0;a[e+56>>0]=1;c[e+52>>2]=0;c[e+44>>2]=0;c[e+48>>2]=0;c[(d+19&-16)>>2]=0;c[e+4>>2]=0;c[e+8>>2]=-1;c[e+12>>2]=0;c[e+16>>2]=0;d=d+19&-16}else d=0;c[b+64>>2]=d;i=f;return}function Fw(b){b=b|0;var d=0,e=0,f=0;f=i;c[b>>2]=11368;d=c[b+64>>2]|0;if((d|0)!=0?(AC(d),e=c[b+64>>2]|0,(e|0)!=0):0){c[5110]=(c[5110]|0)+1;RE(c[e+-4>>2]|0)}d=c[b+24>>2]|0;if(!d){a[b+28>>0]=1;c[b+24>>2]=0;c[b+16>>2]=0;d=b+20|0;c[d>>2]=0;i=f;return}if(a[b+28>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}c[b+24>>2]=0;a[b+28>>0]=1;c[b+24>>2]=0;c[b+16>>2]=0;d=b+20|0;c[d>>2]=0;i=f;return}function Gw(a){a=a|0;var b=0;b=i;Fw(a);if(!a){i=b;return}c[5110]=(c[5110]|0)+1;RE(c[a+-4>>2]|0);i=b;return}function Hw(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0;h=i;i=i+80|0;c[a+68>>2]=(c[a+68>>2]|0)+1;d=c[a+16>>2]|0;if((d|0)<=0){d=c[a>>2]|0;d=d+68|0;d=c[d>>2]|0;Jb[d&255](a);i=h;return}e=d;g=d;while(1){g=g+-1|0;d=c[a+24>>2]|0;if((c[d+(g*80|0)+64>>2]|0)==(b|0)){c[a+68>>2]=(c[a+68>>2]|0)+1;f=c[a+64>>2]|0;if(f){e=c[d+(g*80|0)+76>>2]|0;DC(f,e)|0;d=c[f+4>>2]|0;if(d){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}c[f+4>>2]=e;c[f+12>>2]=(c[f+12>>2]|0)+-1;e=c[a+16>>2]|0;d=c[a+24>>2]|0}e=e+-1|0;m=d+(g*80|0)|0;c[h+0>>2]=c[m+0>>2];c[h+4>>2]=c[m+4>>2];c[h+8>>2]=c[m+8>>2];c[h+12>>2]=c[m+12>>2];l=d+(g*80|0)+16|0;c[h+16>>2]=c[l+0>>2];c[h+20>>2]=c[l+4>>2];c[h+24>>2]=c[l+8>>2];c[h+28>>2]=c[l+12>>2];k=d+(g*80|0)+32|0;c[h+32>>2]=c[k+0>>2];c[h+36>>2]=c[k+4>>2];c[h+40>>2]=c[k+8>>2];c[h+44>>2]=c[k+12>>2];j=d+(g*80|0)+48|0;c[h+48>>2]=c[j+0>>2];c[h+52>>2]=c[j+4>>2];c[h+56>>2]=c[j+8>>2];c[h+60>>2]=c[j+12>>2];f=d+(g*80|0)+64|0;c[h+64>>2]=c[f+0>>2];c[h+68>>2]=c[f+4>>2];c[h+72>>2]=c[f+8>>2];c[h+76>>2]=c[f+12>>2];n=d+(e*80|0)|0;c[m+0>>2]=c[n+0>>2];c[m+4>>2]=c[n+4>>2];c[m+8>>2]=c[n+8>>2];c[m+12>>2]=c[n+12>>2];m=d+(e*80|0)+16|0;c[l+0>>2]=c[m+0>>2];c[l+4>>2]=c[m+4>>2];c[l+8>>2]=c[m+8>>2];c[l+12>>2]=c[m+12>>2];l=d+(e*80|0)+32|0;c[k+0>>2]=c[l+0>>2];c[k+4>>2]=c[l+4>>2];c[k+8>>2]=c[l+8>>2];c[k+12>>2]=c[l+12>>2];k=d+(e*80|0)+48|0;c[j+0>>2]=c[k+0>>2];c[j+4>>2]=c[k+4>>2];c[j+8>>2]=c[k+8>>2];c[j+12>>2]=c[k+12>>2];d=d+(e*80|0)+64|0;c[f+0>>2]=c[d+0>>2];c[f+4>>2]=c[d+4>>2];c[f+8>>2]=c[d+8>>2];c[f+12>>2]=c[d+12>>2];d=c[a+24>>2]|0;c[d+(e*80|0)+0>>2]=c[h+0>>2];c[d+(e*80|0)+4>>2]=c[h+4>>2];c[d+(e*80|0)+8>>2]=c[h+8>>2];c[d+(e*80|0)+12>>2]=c[h+12>>2];c[d+(e*80|0)+16>>2]=c[h+16>>2];c[d+(e*80|0)+20>>2]=c[h+20>>2];c[d+(e*80|0)+24>>2]=c[h+24>>2];c[d+(e*80|0)+28>>2]=c[h+28>>2];c[d+(e*80|0)+32>>2]=c[h+32>>2];c[d+(e*80|0)+36>>2]=c[h+36>>2];c[d+(e*80|0)+40>>2]=c[h+40>>2];c[d+(e*80|0)+44>>2]=c[h+44>>2];c[d+(e*80|0)+48>>2]=c[h+48>>2];c[d+(e*80|0)+52>>2]=c[h+52>>2];c[d+(e*80|0)+56>>2]=c[h+56>>2];c[d+(e*80|0)+60>>2]=c[h+60>>2];c[d+(e*80|0)+64>>2]=c[h+64>>2];c[d+(e*80|0)+68>>2]=c[h+68>>2];c[d+(e*80|0)+72>>2]=c[h+72>>2];c[d+(e*80|0)+76>>2]=c[h+76>>2];if(c[a+64>>2]|0)c[(c[(c[a+24>>2]|0)+(g*80|0)+76>>2]|0)+36>>2]=g;d=(c[a+16>>2]|0)+-1|0;c[a+16>>2]=d}else d=e;if((g|0)<=0)break;else e=d}l=c[a>>2]|0;l=l+68|0;l=c[l>>2]|0;Jb[l&255](a);i=h;return}function Iw(a){a=a|0;var b=0.0,d=0,e=0,f=0,h=0;e=i;i=i+32|0;g[a+32>>2]=999999984306749440.0;g[a+36>>2]=999999984306749440.0;g[a+40>>2]=999999984306749440.0;g[a+44>>2]=0.0;g[a+48>>2]=-999999984306749440.0;g[a+52>>2]=-999999984306749440.0;g[a+56>>2]=-999999984306749440.0;g[a+60>>2]=0.0;if((c[a+16>>2]|0)<=0){i=e;return}d=0;do{f=c[a+24>>2]|0;h=c[f+(d*80|0)+64>>2]|0;tc[c[(c[h>>2]|0)+8>>2]&127](h,f+(d*80|0)|0,e+16|0,e);b=+g[e+16>>2];if(+g[a+32>>2]>b)g[a+32>>2]=b;b=+g[e>>2];if(+g[a+48>>2]<b)g[a+48>>2]=b;b=+g[e+20>>2];if(+g[a+36>>2]>b)g[a+36>>2]=b;b=+g[e+4>>2];if(+g[a+52>>2]<b)g[a+52>>2]=b;b=+g[e+24>>2];if(+g[a+40>>2]>b)g[a+40>>2]=b;b=+g[e+8>>2];if(+g[a+56>>2]<b)g[a+56>>2]=b;d=d+1|0}while((d|0)<(c[a+16>>2]|0));i=e;return}function Jw(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0;f=i;t=+g[a+48>>2];v=+g[a+32>>2];E=+g[a+52>>2];w=+g[a+36>>2];F=+g[a+56>>2];k=+g[a+40>>2];G=(c[a+16>>2]|0)==0;x=G?0.0:(F+k)*.5;z=G?0.0:(E+w)*.5;B=G?0.0:(t+v)*.5;o=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);m=+Zb[c[(c[a>>2]|0)+48>>2]&15](a);o=(G?0.0:(t-v)*.5)+o;m=(G?0.0:(E-w)*.5)+m;k=(G?0.0:(F-k)*.5)+ +Zb[c[(c[a>>2]|0)+48>>2]&15](a);F=+g[b>>2];w=+O(+F);E=+g[b+4>>2];v=+O(+E);t=+g[b+8>>2];u=+O(+t);D=+g[b+16>>2];s=+O(+D);C=+g[b+20>>2];r=+O(+C);p=+g[b+24>>2];q=+O(+p);A=+g[b+32>>2];n=+O(+A);y=+g[b+36>>2];l=+O(+y);h=+g[b+40>>2];j=+O(+h);t=B*F+z*E+x*t+ +g[b+48>>2];p=B*D+z*C+x*p+ +g[b+52>>2];h=B*A+z*y+x*h+ +g[b+56>>2];g[d>>2]=t-(o*w+m*v+k*u);g[d+4>>2]=p-(o*s+m*r+k*q);g[d+8>>2]=h-(o*n+m*l+k*j);g[d+12>>2]=0.0;g[e>>2]=o*w+m*v+k*u+t;g[e+4>>2]=o*s+m*r+k*q+p;g[e+8>>2]=o*n+m*l+k*j+h;g[e+12>>2]=0.0;i=f;return}function Kw(a,b,d){a=a|0;b=+b;d=d|0;var e=0,f=0.0,h=0.0,j=0.0,k=0;e=i;i=i+96|0;g[e+32>>2]=1.0;c[e+36>>2]=0;c[e+40>>2]=0;c[e+44>>2]=0;c[e+48>>2]=0;g[e+52>>2]=1.0;c[e+56>>2]=0;c[e+60>>2]=0;c[e+64>>2]=0;c[e+68>>2]=0;g[e+72>>2]=1.0;k=e+76|0;c[k+0>>2]=0;c[k+4>>2]=0;c[k+8>>2]=0;c[k+12>>2]=0;c[k+16>>2]=0;tc[c[(c[a>>2]|0)+8>>2]&127](a,e+32|0,e+16|0,e);h=(+g[e>>2]-+g[e+16>>2])*.5*2.0;f=(+g[e+4>>2]-+g[e+20>>2])*.5*2.0;j=(+g[e+8>>2]-+g[e+24>>2])*.5*2.0;g[d>>2]=b/12.0*(f*f+j*j);g[d+4>>2]=b/12.0*(h*h+j*j);g[d+8>>2]=b/12.0*(h*h+f*f);i=e;return}function Lw(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0.0,r=0.0;p=i;i=i+144|0;if((c[a+16>>2]|0)<=0){o=a+76|0;c[o+0>>2]=c[b+0>>2];c[o+4>>2]=c[b+4>>2];c[o+8>>2]=c[b+8>>2];c[o+12>>2]=c[b+12>>2];o=c[a>>2]|0;o=o+68|0;o=c[o>>2]|0;Jb[o&255](a);i=p;return}m=p+32|0;l=p+48|0;o=p+64|0;n=0;do{k=c[a+24>>2]|0;j=k+(n*80|0)|0;c[p+16>>2]=c[j+0>>2];c[p+20>>2]=c[j+4>>2];c[p+24>>2]=c[j+8>>2];c[p+28>>2]=c[j+12>>2];j=k+(n*80|0)+16|0;c[m+0>>2]=c[j+0>>2];c[m+4>>2]=c[j+4>>2];c[m+8>>2]=c[j+8>>2];c[m+12>>2]=c[j+12>>2];j=k+(n*80|0)+32|0;c[l+0>>2]=c[j+0>>2];c[l+4>>2]=c[j+4>>2];c[l+8>>2]=c[j+8>>2];c[l+12>>2]=c[j+12>>2];j=k+(n*80|0)+48|0;c[o+0>>2]=c[j+0>>2];c[o+4>>2]=c[j+4>>2];c[o+8>>2]=c[j+8>>2];c[o+12>>2]=c[j+12>>2];k=c[k+(n*80|0)+64>>2]|0;k=Nb[c[(c[k>>2]|0)+28>>2]&127](k)|0;c[p+0>>2]=c[k+0>>2];c[p+4>>2]=c[k+4>>2];c[p+8>>2]=c[k+8>>2];q=+g[p+4>>2]*+g[b+4>>2]/+g[a+80>>2];r=+g[p+8>>2]*+g[b+8>>2]/+g[a+84>>2];g[p>>2]=+g[p>>2]*+g[b>>2]/+g[a+76>>2];g[p+4>>2]=q;g[p+8>>2]=r;g[p+12>>2]=0.0;k=c[(c[a+24>>2]|0)+(n*80|0)+64>>2]|0;Lb[c[(c[k>>2]|0)+24>>2]&127](k,p);r=+g[p+68>>2]*+g[b+4>>2]/+g[a+80>>2];q=+g[p+72>>2]*+g[b+8>>2]/+g[a+84>>2];g[p+64>>2]=+g[o>>2]*+g[b>>2]/+g[a+76>>2];g[p+68>>2]=r;g[p+72>>2]=q;g[p+76>>2]=0.0;k=c[a+24>>2]|0;j=k+(n*80|0)|0;c[j+0>>2]=c[p+16>>2];c[j+4>>2]=c[p+20>>2];c[j+8>>2]=c[p+24>>2];c[j+12>>2]=c[p+28>>2];j=k+(n*80|0)+16|0;c[j+0>>2]=c[m+0>>2];c[j+4>>2]=c[m+4>>2];c[j+8>>2]=c[m+8>>2];c[j+12>>2]=c[m+12>>2];j=k+(n*80|0)+32|0;c[j+0>>2]=c[l+0>>2];c[j+4>>2]=c[l+4>>2];c[j+8>>2]=c[l+8>>2];c[j+12>>2]=c[l+12>>2];k=k+(n*80|0)+48|0;c[k+0>>2]=c[o+0>>2];c[k+4>>2]=c[o+4>>2];c[k+8>>2]=c[o+8>>2];c[k+12>>2]=c[o+12>>2];if(c[a+64>>2]|0){j=c[(c[a+24>>2]|0)+(n*80|0)+64>>2]|0;tc[c[(c[j>>2]|0)+8>>2]&127](j,p+16|0,p+128|0,p+112|0);c[p+80>>2]=c[p+128>>2];c[p+84>>2]=c[p+132>>2];c[p+88>>2]=c[p+136>>2];c[p+92>>2]=c[p+140>>2];c[p+96>>2]=c[p+112>>2];c[p+100>>2]=c[p+116>>2];c[p+104>>2]=c[p+120>>2];c[p+108>>2]=c[p+124>>2];j=c[a+64>>2]|0;k=c[(c[a+24>>2]|0)+(n*80|0)+76>>2]|0;d=DC(j,k)|0;a:do if(d){f=c[j+8>>2]|0;if((f|0)<=-1){d=c[j>>2]|0;break}if((f|0)>0){h=0;e=d;while(1){d=c[e+32>>2]|0;h=h+1|0;if(!d){d=e;break a}if((h|0)>=(f|0))break;else e=d}}}else d=0;while(0);c[k+0>>2]=c[p+80>>2];c[k+4>>2]=c[p+84>>2];c[k+8>>2]=c[p+88>>2];c[k+12>>2]=c[p+92>>2];c[k+16>>2]=c[p+96>>2];c[k+20>>2]=c[p+100>>2];c[k+24>>2]=c[p+104>>2];c[k+28>>2]=c[p+108>>2];EC(j,d,k)}n=n+1|0}while((n|0)<(c[a+16>>2]|0));o=a+76|0;c[o+0>>2]=c[b+0>>2];c[o+4>>2]=c[b+4>>2];c[o+8>>2]=c[b+8>>2];c[o+12>>2]=c[b+12>>2];o=c[a>>2]|0;o=o+68|0;o=c[o>>2]|0;Jb[o&255](a);i=p;return}function Mw(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,h=0,j=0,k=0,l=0;k=i;e=ec[c[(c[d>>2]|0)+40>>2]&31](d,a)|0;f=ec[c[(c[d>>2]|0)+28>>2]&31](d,e)|0;c[b>>2]=f;if(f)Lb[c[(c[d>>2]|0)+48>>2]&127](d,e);c[b+4>>2]=c[a+4>>2];g[b+20>>2]=+g[a+72>>2];e=c[a+16>>2]|0;c[b+16>>2]=e;c[b+12>>2]=0;if(!e){i=k;return 11472}j=Wb[c[(c[d>>2]|0)+16>>2]&63](d,76,e)|0;e=c[j+8>>2]|0;c[b+12>>2]=ec[c[(c[d>>2]|0)+28>>2]&31](d,e)|0;if((c[b+16>>2]|0)>0){f=c[a+24>>2]|0;h=0;while(1){g[e+72>>2]=+g[f+(h*80|0)+72>>2];c[e+64>>2]=ec[c[(c[d>>2]|0)+28>>2]&31](d,c[f+(h*80|0)+64>>2]|0)|0;if(!(ec[c[(c[d>>2]|0)+24>>2]&31](d,c[(c[a+24>>2]|0)+(h*80|0)+64>>2]|0)|0)){f=c[(c[d>>2]|0)+16>>2]|0;l=c[(c[a+24>>2]|0)+(h*80|0)+64>>2]|0;l=Nb[c[(c[l>>2]|0)+52>>2]&127](l)|0;l=Wb[f&63](d,l,1)|0;f=c[(c[a+24>>2]|0)+(h*80|0)+64>>2]|0;f=Wb[c[(c[f>>2]|0)+56>>2]&63](f,c[l+8>>2]|0,d)|0;Hb[c[(c[d>>2]|0)+20>>2]&31](d,l,f,1346455635,c[(c[a+24>>2]|0)+(h*80|0)+64>>2]|0)}f=c[a+24>>2]|0;c[e+68>>2]=c[f+(h*80|0)+68>>2];g[e>>2]=+g[f+(h*80|0)>>2];g[e+4>>2]=+g[f+(h*80|0)+4>>2];g[e+8>>2]=+g[f+(h*80|0)+8>>2];g[e+12>>2]=+g[f+(h*80|0)+12>>2];g[e+16>>2]=+g[f+(h*80|0)+16>>2];g[e+20>>2]=+g[f+(h*80|0)+20>>2];g[e+24>>2]=+g[f+(h*80|0)+24>>2];g[e+28>>2]=+g[f+(h*80|0)+28>>2];g[e+32>>2]=+g[f+(h*80|0)+32>>2];g[e+36>>2]=+g[f+(h*80|0)+36>>2];g[e+40>>2]=+g[f+(h*80|0)+40>>2];g[e+44>>2]=+g[f+(h*80|0)+44>>2];g[e+48>>2]=+g[f+(h*80|0)+48>>2];g[e+52>>2]=+g[f+(h*80|0)+52>>2];g[e+56>>2]=+g[f+(h*80|0)+56>>2];g[e+60>>2]=+g[f+(h*80|0)+60>>2];h=h+1|0;if((h|0)>=(c[b+16>>2]|0)){e=d;break}else e=e+76|0}}else e=d;Hb[c[(c[e>>2]|0)+20>>2]&31](d,j,11440,1497453121,c[j+8>>2]|0);i=k;return 11472}function Nw(a){a=a|0;return 24}function Ow(a){a=a|0;return +(+g[a+72>>2])}function Pw(a,b){a=a|0;b=+b;g[a+72>>2]=b;return}function Qw(a){a=a|0;return 11536}function Rw(a){a=a|0;return a+76|0}function Sw(a,b,d){a=a|0;b=b|0;d=d|0;var e=0.0,f=0.0,h=0,j=0,k=0,l=0.0,m=0.0,n=0;n=i;m=+g[b+60>>2]*.5;h=c[b+68>>2]|0;l=+g[d>>2];f=+g[d+4>>2];e=+g[d+8>>2];e=+P(+(l*l+f*f+e*e));k=c[b+64>>2]|0;if(+g[d+(h<<2)>>2]>e*+g[b+52>>2]){g[a+(k<<2)>>2]=0.0;g[a+(h<<2)>>2]=m;g[a+(c[b+72>>2]<<2)>>2]=0.0;i=n;return}l=+g[d+(k<<2)>>2];j=c[b+72>>2]|0;e=+g[d+(j<<2)>>2];f=+P(+(l*l+e*e));if(f>1.1920928955078125e-07){f=+g[b+56>>2]/f;g[a+(k<<2)>>2]=l*f;g[a+(h<<2)>>2]=-m;g[a+(j<<2)>>2]=e*f;i=n;return}else{g[a+(k<<2)>>2]=0.0;g[a+(h<<2)>>2]=-m;g[a+(j<<2)>>2]=0.0;i=n;return}}function Tw(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0,j=0.0,k=0,l=0.0,m=0,n=0.0,o=0,p=0.0,q=0;q=i;i=i+16|0;if((e|0)<=0){i=q;return}o=0;do{m=d+(o<<4)|0;p=+g[a+60>>2]*.5;f=c[a+68>>2]|0;n=+g[b+(o<<4)>>2];l=+g[b+(o<<4)+4>>2];j=+g[b+(o<<4)+8>>2];j=+P(+(n*n+l*l+j*j));k=c[a+64>>2]|0;do if(!(+g[b+(o<<4)+(f<<2)>>2]>j*+g[a+52>>2])){l=+g[b+(o<<4)+(k<<2)>>2];h=c[a+72>>2]|0;j=+g[b+(o<<4)+(h<<2)>>2];n=+P(+(l*l+j*j));if(n>1.1920928955078125e-07){n=+g[a+56>>2]/n;g[q+(k<<2)>>2]=l*n;g[q+(f<<2)>>2]=-p;g[q+(h<<2)>>2]=j*n;break}else{g[q+(k<<2)>>2]=0.0;g[q+(f<<2)>>2]=-p;g[q+(h<<2)>>2]=0.0;break}}else{g[q+(k<<2)>>2]=0.0;g[q+(f<<2)>>2]=p;g[q+(c[a+72>>2]<<2)>>2]=0.0}while(0);c[m+0>>2]=c[q+0>>2];c[m+4>>2]=c[q+4>>2];c[m+8>>2]=c[q+8>>2];c[m+12>>2]=c[q+12>>2];o=o+1|0}while((o|0)!=(e|0));i=q;return}function Uw(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,h=0.0,j=0,k=0.0,l=0.0,m=0.0,n=0,o=0.0;n=i;m=+g[b+60>>2]*.5;e=c[b+68>>2]|0;l=+g[d>>2];k=+g[d+4>>2];h=+g[d+8>>2];h=+P(+(l*l+k*k+h*h));j=c[b+64>>2]|0;do if(!(+g[d+(e<<2)>>2]>h*+g[b+52>>2])){k=+g[d+(j<<2)>>2];f=c[b+72>>2]|0;h=+g[d+(f<<2)>>2];l=+P(+(k*k+h*h));if(l>1.1920928955078125e-07){l=+g[b+56>>2]/l;g[a+(j<<2)>>2]=k*l;g[a+(e<<2)>>2]=-m;g[a+(f<<2)>>2]=h*l;break}else{g[a+(j<<2)>>2]=0.0;g[a+(e<<2)>>2]=-m;g[a+(f<<2)>>2]=0.0;break}}else{g[a+(j<<2)>>2]=0.0;g[a+(e<<2)>>2]=m;g[a+(c[b+72>>2]<<2)>>2]=0.0}while(0);if(!(+Zb[c[(c[b>>2]|0)+48>>2]&15](b)!=0.0)){i=n;return}o=+g[d>>2];l=+g[d+4>>2];k=+g[d+8>>2];h=o*o+l*l+k*k<1.4210854715202004e-14?-1.0:k;m=o*o+l*l+k*k<1.4210854715202004e-14?-1.0:l;o=o*o+l*l+k*k<1.4210854715202004e-14?-1.0:o;k=1.0/+P(+(h*h+(o*o+m*m)));l=+Zb[c[(c[b>>2]|0)+48>>2]&15](b);g[a>>2]=k*o*l+ +g[a>>2];g[a+4>>2]=l*(k*m)+ +g[a+4>>2];g[a+8>>2]=l*(k*h)+ +g[a+8>>2];i=n;return}
function or(b,d,e,f){b=b|0;d=d|0;e=e|0;f=+f;var h=0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0,r=0,s=0,t=0,u=0.0,v=0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,Q=0.0,R=0.0,S=0.0,T=0.0,U=0.0,V=0.0,W=0.0,X=0.0,Y=0.0,Z=0.0,_=0.0,$=0.0,aa=0.0;O=i;i=i+448|0;if(!(a[b+527>>0]|0)){i=O;return}L=c[b+28>>2]|0;w=+g[b+348>>2];l=+g[b+352>>2];n=+g[b+356>>2];B=+g[L+52>>2];m=w*+g[L+4>>2]+l*+g[L+8>>2]+n*+g[L+12>>2]+B;A=+g[L+56>>2];p=w*+g[L+20>>2]+l*+g[L+24>>2]+n*+g[L+28>>2]+A;z=+g[L+60>>2];n=w*+g[L+36>>2]+l*+g[L+40>>2]+n*+g[L+44>>2]+z;L=c[b+32>>2]|0;l=+g[b+412>>2];w=+g[b+416>>2];o=+g[b+420>>2];y=+g[L+52>>2];x=l*+g[L+4>>2]+w*+g[L+8>>2]+o*+g[L+12>>2]+y;j=+g[L+56>>2];D=l*+g[L+20>>2]+w*+g[L+24>>2]+o*+g[L+28>>2]+j;u=+g[L+60>>2];o=l*+g[L+36>>2]+w*+g[L+40>>2]+o*+g[L+44>>2]+u;if(!(a[b+524>>0]|0)){k=+g[d+192>>2]+ +g[d+80>>2];l=+g[d+196>>2]+ +g[d+84>>2];G=+g[d+200>>2]+ +g[d+88>>2];w=+g[e+192>>2]+ +g[e+80>>2];F=+g[e+196>>2]+ +g[e+84>>2];H=+g[e+200>>2]+ +g[e+88>>2];E=+g[d+176>>2]+ +g[d+64>>2]+((n-z)*l-(p-A)*G)-(+g[e+176>>2]+ +g[e+64>>2]+((o-u)*F-(D-j)*H));H=+g[d+180>>2]+ +g[d+68>>2]+((m-B)*G-(n-z)*k)-(+g[e+180>>2]+ +g[e+68>>2]+((x-y)*H-(o-u)*w));F=+g[d+184>>2]+ +g[d+72>>2]+((p-A)*k-(m-B)*l)-(+g[e+184>>2]+ +g[e+72>>2]+((D-j)*w-(x-y)*F));h=(c[d+240>>2]|0)==0;t=0;do{w=1.0/+g[b+(t*84|0)+128>>2];s=b+(t*84|0)+48|0;l=+g[s>>2];q=b+(t*84|0)+52|0;k=+g[q>>2];r=b+(t*84|0)+56|0;G=+g[r>>2];G=w*(((m-x)*l+(p-D)*k+(n-o)*G)*-.30000001192092896/f)-w*(E*l+H*k+F*G);g[b+36>>2]=+g[b+36>>2]+G;k=+g[r>>2];l=+g[q>>2];w=+g[s>>2];v=c[b+28>>2]|0;C=+g[v+344>>2];if(!h){S=((p-A)*k-(n-z)*l)*+g[v+296>>2]+((n-z)*w-(m-B)*k)*+g[v+300>>2]+((m-B)*l-(p-A)*w)*+g[v+304>>2];Q=((p-A)*k-(n-z)*l)*+g[v+280>>2]+((n-z)*w-(m-B)*k)*+g[v+284>>2]+((m-B)*l-(p-A)*w)*+g[v+288>>2];R=((p-A)*k-(n-z)*l)*+g[v+264>>2]+((n-z)*w-(m-B)*k)*+g[v+268>>2]+((m-B)*l-(p-A)*w)*+g[v+272>>2];U=G*(l*C)*+g[d+116>>2];T=G*(k*C)*+g[d+120>>2];g[d+64>>2]=G*(w*C)*+g[d+112>>2]+ +g[d+64>>2];g[d+68>>2]=U+ +g[d+68>>2];g[d+72>>2]=T+ +g[d+72>>2];Q=Q*(G*+g[d+100>>2]);C=S*(G*+g[d+104>>2]);g[d+80>>2]=R*(G*+g[d+96>>2])+ +g[d+80>>2];g[d+84>>2]=Q+ +g[d+84>>2];g[d+88>>2]=C+ +g[d+88>>2]}v=c[b+32>>2]|0;C=+g[v+344>>2];if(c[e+240>>2]|0){Q=((D-j)*k-(o-u)*l)*+g[v+296>>2]+((o-u)*w-(x-y)*k)*+g[v+300>>2]+((x-y)*l-(D-j)*w)*+g[v+304>>2];R=((D-j)*k-(o-u)*l)*+g[v+280>>2]+((o-u)*w-(x-y)*k)*+g[v+284>>2]+((x-y)*l-(D-j)*w)*+g[v+288>>2];l=((D-j)*k-(o-u)*l)*+g[v+264>>2]+((o-u)*w-(x-y)*k)*+g[v+268>>2]+((x-y)*l-(D-j)*w)*+g[v+272>>2];w=C*+g[q>>2]*-G*+g[e+116>>2];k=C*+g[r>>2]*-G*+g[e+120>>2];g[e+64>>2]=+g[e+112>>2]*(C*+g[s>>2]*-G)+ +g[e+64>>2];g[e+68>>2]=w+ +g[e+68>>2];g[e+72>>2]=k+ +g[e+72>>2];k=R*(+g[e+100>>2]*-G);C=Q*(+g[e+104>>2]*-G);g[e+80>>2]=l*(+g[e+96>>2]*-G)+ +g[e+80>>2];g[e+84>>2]=k+ +g[e+84>>2];g[e+88>>2]=C+ +g[e+88>>2]}t=t+1|0}while((t|0)!=3)}do if(!(a[b+552>>0]|0)){p=+g[b+440>>2];if(!(p>1.1920928955078125e-07)){s=e+192|0;h=d+192|0;v=e+200|0;r=d+200|0;L=e+88|0;I=d+88|0;M=e+80|0;J=d+80|0;t=e+196|0;q=d+196|0;N=e+84|0;K=d+84|0;break}o=+g[e+192>>2]+ +g[e+80>>2]-(+g[d+192>>2]+ +g[d+80>>2]);n=+g[e+196>>2]+ +g[e+84>>2]-(+g[d+196>>2]+ +g[d+84>>2]);l=+g[e+200>>2]+ +g[e+88>>2]-(+g[d+200>>2]+ +g[d+88>>2]);if(o*o+n*n+l*l>1.1920928955078125e-07){C=1.0/+P(+(o*o+n*n+l*l));h=c[b+28>>2]|0;k=+g[h+264>>2];u=+g[h+280>>2];j=+g[h+296>>2];w=+g[h+268>>2];x=+g[h+284>>2];y=+g[h+300>>2];z=+g[h+272>>2];A=+g[h+288>>2];B=+g[h+304>>2];h=c[b+32>>2]|0;p=p*(1.0/(o*C*(o*C*k+n*C*u+l*C*j)+n*C*(o*C*w+n*C*x+l*C*y)+l*C*(o*C*z+n*C*A+l*C*B)+(o*C*(o*C*+g[h+264>>2]+n*C*+g[h+280>>2]+l*C*+g[h+296>>2])+n*C*(o*C*+g[h+268>>2]+n*C*+g[h+284>>2]+l*C*+g[h+300>>2])+l*C*(o*C*+g[h+272>>2]+n*C*+g[h+288>>2]+l*C*+g[h+304>>2]))));C=+P(+(l*p*(l*p)+(o*p*(o*p)+n*p*(n*p))));m=1.0/C*(o*p);o=1.0/C*(n*p);p=1.0/C*(l*p);if(c[d+240>>2]|0){F=C*0.0*+g[d+116>>2];E=C*0.0*+g[d+120>>2];g[d+64>>2]=C*0.0*+g[d+112>>2]+ +g[d+64>>2];g[d+68>>2]=F+ +g[d+68>>2];g[d+72>>2]=E+ +g[d+72>>2];E=(m*u+o*x+p*A)*(C*+g[d+100>>2]);F=(m*j+o*y+p*B)*(C*+g[d+104>>2]);g[d+80>>2]=(m*k+o*w+p*z)*(C*+g[d+96>>2])+ +g[d+80>>2];g[d+84>>2]=E+ +g[d+84>>2];g[d+88>>2]=F+ +g[d+88>>2];h=c[b+32>>2]|0}if(c[e+240>>2]|0){F=m*+g[h+296>>2]+o*+g[h+300>>2]+p*+g[h+304>>2];E=m*+g[h+280>>2]+o*+g[h+284>>2]+p*+g[h+288>>2];D=m*+g[h+264>>2]+o*+g[h+268>>2]+p*+g[h+272>>2];A=C*-0.0*+g[e+116>>2];B=C*-0.0*+g[e+120>>2];g[e+64>>2]=C*-0.0*+g[e+112>>2]+ +g[e+64>>2];g[e+68>>2]=A+ +g[e+68>>2];g[e+72>>2]=B+ +g[e+72>>2];E=E*(+g[e+100>>2]*-C);F=F*(+g[e+104>>2]*-C);g[e+80>>2]=D*(+g[e+96>>2]*-C)+ +g[e+80>>2];g[e+84>>2]=E+ +g[e+84>>2];g[e+88>>2]=F+ +g[e+88>>2];s=e+192|0;h=d+192|0;v=e+200|0;r=d+200|0;L=e+88|0;I=d+88|0;M=e+80|0;J=d+80|0;t=e+196|0;q=d+196|0;N=e+84|0;K=d+84|0}else{s=e+192|0;h=d+192|0;v=e+200|0;r=d+200|0;L=e+88|0;I=d+88|0;M=e+80|0;J=d+80|0;t=e+196|0;q=d+196|0;N=e+84|0;K=d+84|0}}else{s=e+192|0;h=d+192|0;v=e+200|0;r=d+200|0;L=e+88|0;I=d+88|0;M=e+80|0;J=d+80|0;t=e+196|0;q=d+196|0;N=e+84|0;K=d+84|0}}else{K=c[b+28>>2]|0;c[O+352>>2]=c[K+4>>2];c[O+356>>2]=c[K+8>>2];c[O+360>>2]=c[K+12>>2];c[O+364>>2]=c[K+16>>2];c[O+368>>2]=c[K+20>>2];c[O+372>>2]=c[K+24>>2];c[O+376>>2]=c[K+28>>2];c[O+380>>2]=c[K+32>>2];c[O+384>>2]=c[K+36>>2];c[O+388>>2]=c[K+40>>2];c[O+392>>2]=c[K+44>>2];c[O+396>>2]=c[K+48>>2];c[O+400>>2]=c[K+52>>2];c[O+404>>2]=c[K+56>>2];c[O+408>>2]=c[K+60>>2];c[O+412>>2]=c[K+64>>2];K=c[b+32>>2]|0;c[O+288>>2]=c[K+4>>2];c[O+292>>2]=c[K+8>>2];c[O+296>>2]=c[K+12>>2];c[O+300>>2]=c[K+16>>2];c[O+304>>2]=c[K+20>>2];c[O+308>>2]=c[K+24>>2];c[O+312>>2]=c[K+28>>2];c[O+316>>2]=c[K+32>>2];c[O+320>>2]=c[K+36>>2];c[O+324>>2]=c[K+40>>2];c[O+328>>2]=c[K+44>>2];c[O+332>>2]=c[K+48>>2];c[O+336>>2]=c[K+52>>2];c[O+340>>2]=c[K+56>>2];c[O+344>>2]=c[K+60>>2];c[O+348>>2]=c[K+64>>2];D=+g[d+196>>2]+ +g[d+84>>2];m=+g[d+200>>2]+ +g[d+88>>2];g[O+272>>2]=+g[d+192>>2]+ +g[d+80>>2];g[O+276>>2]=D;g[O+280>>2]=m;g[O+284>>2]=0.0;m=+g[e+196>>2]+ +g[e+84>>2];D=+g[e+200>>2]+ +g[e+88>>2];g[O+256>>2]=+g[e+192>>2]+ +g[e+80>>2];g[O+260>>2]=m;g[O+264>>2]=D;g[O+268>>2]=0.0;g[O+192>>2]=1.0;K=O+196|0;c[K+0>>2]=0;c[K+4>>2]=0;c[K+8>>2]=0;c[K+12>>2]=0;g[O+212>>2]=1.0;L=O+216|0;c[L+0>>2]=0;c[L+4>>2]=0;c[L+8>>2]=0;c[L+12>>2]=0;g[O+232>>2]=1.0;I=O+236|0;c[I+0>>2]=0;c[I+4>>2]=0;c[I+8>>2]=0;c[I+12>>2]=0;c[I+16>>2]=0;Ap(O+352|0,0.0,0.0,0.0,O+272|0,f,O+192|0);g[O+128>>2]=1.0;I=O+132|0;c[I+0>>2]=0;c[I+4>>2]=0;c[I+8>>2]=0;c[I+12>>2]=0;g[O+148>>2]=1.0;J=O+152|0;c[J+0>>2]=0;c[J+4>>2]=0;c[J+8>>2]=0;c[J+12>>2]=0;g[O+168>>2]=1.0;v=O+172|0;c[v+0>>2]=0;c[v+4>>2]=0;c[v+8>>2]=0;c[v+12>>2]=0;c[v+16>>2]=0;Ap(O+288|0,0.0,0.0,0.0,O+256|0,f,O+128|0);D=+g[b+556>>2];m=+g[b+560>>2];E=+g[b+564>>2];Q=+g[b+568>>2];H=D*(2.0/(D*D+m*m+E*E+Q*Q));z=m*(2.0/(D*D+m*m+E*E+Q*Q));u=E*(2.0/(D*D+m*m+E*E+Q*Q));W=+g[b+364>>2];V=+g[b+368>>2];Z=+g[b+372>>2];T=(D*u-Q*z)*Z+(V*(D*z+Q*u)+W*(1.0-(m*z+E*u)));S=Z*(m*u+Q*H)+(W*(D*z-Q*u)+V*(1.0-(D*H+E*u)));R=W*(D*u+Q*z)+V*(m*u-Q*H)+Z*(1.0-(D*H+m*z));U=+g[b+380>>2];k=+g[b+384>>2];x=+g[b+388>>2];p=(1.0-(m*z+E*u))*U+(D*z+Q*u)*k+(D*u-Q*z)*x;o=(D*z-Q*u)*U+(1.0-(D*H+E*u))*k+(m*u+Q*H)*x;n=(D*u+Q*z)*U+(m*u-Q*H)*k+(1.0-(D*H+m*z))*x;G=+g[b+396>>2];w=+g[b+400>>2];y=+g[b+404>>2];B=(1.0-(m*z+E*u))*G+(D*z+Q*u)*w+(D*u-Q*z)*y;E=(D*z-Q*u)*G+(1.0-(D*H+E*u))*w+(m*u+Q*H)*y;z=(D*u+Q*z)*G+(m*u-Q*H)*w+(1.0-(D*H+m*z))*y;m=+g[b+300>>2];H=+g[b+316>>2];D=+g[b+332>>2];Q=+g[b+304>>2];u=+g[b+320>>2];F=+g[b+336>>2];l=+g[b+308>>2];j=+g[b+324>>2];C=+g[b+340>>2];A=-+g[b+348>>2];aa=-+g[b+352>>2];Y=-+g[b+356>>2];Z=W*0.0+V*0.0+Z*0.0+ +g[b+412>>2]+(R*(l*A+j*aa+C*Y)+(T*(m*A+H*aa+D*Y)+S*(Q*A+u*aa+F*Y)));x=U*0.0+k*0.0+x*0.0+ +g[b+416>>2]+(n*(l*A+j*aa+C*Y)+(p*(m*A+H*aa+D*Y)+o*(Q*A+u*aa+F*Y)));Y=G*0.0+w*0.0+y*0.0+ +g[b+420>>2]+(z*(l*A+j*aa+C*Y)+(B*(m*A+H*aa+D*Y)+E*(Q*A+u*aa+F*Y)));aa=+g[O+128>>2];A=+g[I>>2];y=+g[O+136>>2];w=+g[O+144>>2];G=+g[O+148>>2];k=+g[J>>2];U=+g[O+160>>2];V=+g[O+164>>2];W=+g[O+168>>2];X=y*Y+(aa*Z+A*x)+ +g[O+176>>2];_=Y*k+(w*Z+G*x)+ +g[O+180>>2];$=Z*U+x*V+Y*W+ +g[O+184>>2];g[O+64>>2]=(T*m+S*Q+R*l)*aa+(p*m+o*Q+n*l)*A+(B*m+E*Q+z*l)*y;g[O+68>>2]=(T*H+S*u+R*j)*aa+(p*H+o*u+n*j)*A+(B*H+E*u+z*j)*y;g[O+72>>2]=(T*D+S*F+R*C)*aa+(p*D+o*F+n*C)*A+(B*D+E*F+z*C)*y;g[O+76>>2]=0.0;g[O+80>>2]=(T*m+S*Q+R*l)*w+(p*m+o*Q+n*l)*G+(B*m+E*Q+z*l)*k;g[O+84>>2]=(T*H+S*u+R*j)*w+(p*H+o*u+n*j)*G+(B*H+E*u+z*j)*k;g[O+88>>2]=(T*D+S*F+R*C)*w+(p*D+o*F+n*C)*G+(B*D+E*F+z*C)*k;g[O+92>>2]=0.0;g[O+96>>2]=(T*m+S*Q+R*l)*U+(p*m+o*Q+n*l)*V+(B*m+E*Q+z*l)*W;g[O+100>>2]=(T*H+S*u+R*j)*U+(p*H+o*u+n*j)*V+(B*H+E*u+z*j)*W;g[O+104>>2]=(T*D+S*F+R*C)*U+(p*D+o*F+n*C)*V+(B*D+E*F+z*C)*W;g[O+108>>2]=0.0;g[O+112>>2]=X;g[O+116>>2]=_;g[O+120>>2]=$;g[O+124>>2]=0.0;$=(B*m+E*Q+z*l)*-Y+((T*m+S*Q+R*l)*-Z+(p*m+o*Q+n*l)*-x);_=(B*H+E*u+z*j)*-Y+((T*H+S*u+R*j)*-Z+(p*H+o*u+n*j)*-x);x=(B*D+E*F+z*C)*-Y+((T*D+S*F+R*C)*-Z+(p*D+o*F+n*C)*-x);Z=+g[O+192>>2];Y=+g[K>>2];X=+g[O+200>>2];W=+g[O+208>>2];V=+g[O+212>>2];U=+g[L>>2];k=+g[O+224>>2];G=+g[O+228>>2];w=+g[O+232>>2];y=$*Z+_*Y+x*X+ +g[O+240>>2];A=$*W+_*V+x*U+ +g[O+244>>2];x=$*k+_*G+x*w+ +g[O+248>>2];g[O>>2]=(T*m+S*Q+R*l)*Z+(T*H+S*u+R*j)*Y+(T*D+S*F+R*C)*X;g[O+4>>2]=(p*m+o*Q+n*l)*Z+(p*H+o*u+n*j)*Y+(p*D+o*F+n*C)*X;g[O+8>>2]=(B*m+E*Q+z*l)*Z+(B*H+E*u+z*j)*Y+(B*D+E*F+z*C)*X;g[O+12>>2]=0.0;g[O+16>>2]=(T*m+S*Q+R*l)*W+(T*H+S*u+R*j)*V+(T*D+S*F+R*C)*U;g[O+20>>2]=(p*m+o*Q+n*l)*W+(p*H+o*u+n*j)*V+(p*D+o*F+n*C)*U;g[O+24>>2]=(B*m+E*Q+z*l)*W+(B*H+E*u+z*j)*V+(B*D+E*F+z*C)*U;g[O+28>>2]=0.0;g[O+32>>2]=(T*m+S*Q+R*l)*k+(T*H+S*u+R*j)*G+(T*D+S*F+R*C)*w;g[O+36>>2]=(p*m+o*Q+n*l)*k+(p*H+o*u+n*j)*G+(p*D+o*F+n*C)*w;g[O+40>>2]=(B*m+E*Q+z*l)*k+(B*H+E*u+z*j)*G+(B*D+E*F+z*C)*w;g[O+44>>2]=0.0;g[O+48>>2]=y;g[O+52>>2]=A;g[O+56>>2]=x;g[O+60>>2]=0.0;Bp(O+352|0,O+64|0,O+424|0,O+416|0);x=+g[O+416>>2];A=1.0/f*(+g[O+424>>2]*x);y=1.0/f*(x*+g[O+428>>2]);x=1.0/f*(x*+g[O+432>>2]);Bp(O+288|0,O,O+424|0,O+416|0);w=+g[O+416>>2];A=A-+g[O+272>>2];y=y-+g[O+276>>2];x=x-+g[O+280>>2];C=1.0/f*(+g[O+424>>2]*w)-+g[O+256>>2];z=1.0/f*(w*+g[O+428>>2])-+g[O+260>>2];w=1.0/f*(w*+g[O+432>>2])-+g[O+264>>2];if(A*A+y*y+x*x>1.1920928955078125e-07){j=1.0/+P(+(A*A+y*y+x*x));L=c[b+28>>2]|0;l=A*j*(A*j*+g[L+264>>2]+y*j*+g[L+280>>2]+x*j*+g[L+296>>2])+y*j*(A*j*+g[L+268>>2]+y*j*+g[L+284>>2]+x*j*+g[L+300>>2])+x*j*(A*j*+g[L+272>>2]+y*j*+g[L+288>>2]+x*j*+g[L+304>>2]);p=A*j;n=y*j;j=x*j}else{l=0.0;p=0.0;n=0.0;j=0.0}if(C*C+z*z+w*w>1.1920928955078125e-07){u=1.0/+P(+(C*C+z*z+w*w));L=c[b+32>>2]|0;k=C*u*(C*u*+g[L+264>>2]+z*u*+g[L+280>>2]+w*u*+g[L+296>>2])+z*u*(C*u*+g[L+268>>2]+z*u*+g[L+284>>2]+w*u*+g[L+300>>2])+w*u*(C*u*+g[L+272>>2]+z*u*+g[L+288>>2]+w*u*+g[L+304>>2]);o=C*u;m=z*u;u=w*u}else{k=0.0;o=0.0;m=0.0;u=0.0}B=p*l+o*k;o=n*l+m*k;n=j*l+u*k;if(n*n+(B*B+o*o)>1.1920928955078125e-07){l=1.0/+P(+(n*n+(B*B+o*o)));v=c[b+28>>2]|0;p=B*l*(B*l*+g[v+264>>2]+o*l*+g[v+280>>2]+n*l*+g[v+296>>2])+o*l*(B*l*+g[v+268>>2]+o*l*+g[v+284>>2]+n*l*+g[v+300>>2])+n*l*(B*l*+g[v+272>>2]+o*l*+g[v+288>>2]+n*l*+g[v+304>>2]);h=c[b+32>>2]|0;n=B*l*(B*l*+g[h+264>>2]+o*l*+g[h+280>>2]+n*l*+g[h+296>>2])+o*l*(B*l*+g[h+268>>2]+o*l*+g[h+284>>2]+n*l*+g[h+300>>2])+n*l*(B*l*+g[h+272>>2]+o*l*+g[h+288>>2]+n*l*+g[h+304>>2]);l=1.0/((p+n)*(p+n))*(A*p-C*n);C=1.0/((p+n)*(p+n))*(y*p-z*n);n=1.0/((p+n)*(p+n))*(x*p-w*n);j=+g[b+572>>2];if(!(j>=0.0))j=C;else{if(a[b+553>>0]|0)j=j/p;k=+g[b+576>>2];o=+g[b+580>>2];p=+g[b+584>>2];m=+P(+((l+k)*(l+k)+(C+o)*(C+o)+(n+p)*(n+p)));if(m>j){l=j*((l+k)*(1.0/m))-k;n=j*((n+p)*(1.0/m))-p;j=j*((C+o)*(1.0/m))-o}else j=C;g[b+576>>2]=l+k;g[b+580>>2]=j+o;g[b+584>>2]=n+p}m=+P(+(n*n+(j*j+l*l)));l=l*(1.0/m);k=j*(1.0/m);j=n*(1.0/m);if(c[d+240>>2]|0){F=l*+g[v+296>>2]+k*+g[v+300>>2]+j*+g[v+304>>2];E=l*+g[v+280>>2]+k*+g[v+284>>2]+j*+g[v+288>>2];D=l*+g[v+264>>2]+k*+g[v+268>>2]+j*+g[v+272>>2];B=m*0.0*+g[d+116>>2];C=m*0.0*+g[d+120>>2];g[d+64>>2]=m*0.0*+g[d+112>>2]+ +g[d+64>>2];g[d+68>>2]=B+ +g[d+68>>2];g[d+72>>2]=C+ +g[d+72>>2];E=E*(m*+g[d+100>>2]);F=F*(m*+g[d+104>>2]);g[d+80>>2]=D*(m*+g[d+96>>2])+ +g[d+80>>2];g[d+84>>2]=E+ +g[d+84>>2];g[d+88>>2]=F+ +g[d+88>>2];h=c[b+32>>2]|0}if(c[e+240>>2]|0){F=l*+g[h+296>>2]+k*+g[h+300>>2]+j*+g[h+304>>2];E=l*+g[h+280>>2]+k*+g[h+284>>2]+j*+g[h+288>>2];D=l*+g[h+264>>2]+k*+g[h+268>>2]+j*+g[h+272>>2];B=m*-0.0*+g[e+116>>2];C=m*-0.0*+g[e+120>>2];g[e+64>>2]=m*-0.0*+g[e+112>>2]+ +g[e+64>>2];g[e+68>>2]=B+ +g[e+68>>2];g[e+72>>2]=C+ +g[e+72>>2];E=E*(+g[e+100>>2]*-m);F=F*(+g[e+104>>2]*-m);g[e+80>>2]=D*(+g[e+96>>2]*-m)+ +g[e+80>>2];g[e+84>>2]=E+ +g[e+84>>2];g[e+88>>2]=F+ +g[e+88>>2];s=e+192|0;h=d+192|0;v=e+200|0;r=d+200|0;L=e+88|0;I=d+88|0;M=e+80|0;J=d+80|0;t=e+196|0;q=d+196|0;N=e+84|0;K=d+84|0}else{s=e+192|0;h=d+192|0;v=e+200|0;r=d+200|0;L=e+88|0;I=d+88|0;M=e+80|0;J=d+80|0;t=e+196|0;q=d+196|0;N=e+84|0;K=d+84|0}}else{s=e+192|0;h=d+192|0;v=e+200|0;r=d+200|0;L=e+88|0;I=d+88|0;M=e+80|0;J=d+80|0;t=e+196|0;q=d+196|0;N=e+84|0;K=d+84|0}}while(0);H=+g[h>>2]+ +g[J>>2];u=+g[q>>2]+ +g[K>>2];G=+g[r>>2]+ +g[I>>2];D=+g[s>>2]+ +g[M>>2];E=+g[t>>2]+ +g[N>>2];F=+g[v>>2]+ +g[L>>2];if(a[b+526>>0]|0){o=+g[b+528>>2];p=o*+g[b+504>>2]*+g[b+432>>2]/f;C=+g[b+460>>2];B=+g[b+464>>2];z=+g[b+468>>2];if((D-H)*C+(E-u)*B+(F-G)*z>0.0)p=p+o*((D-H)*C+(E-u)*B+(F-G)*z)*+g[b+436>>2];k=+g[b+516>>2];aa=k+p*+g[b+492>>2];aa=aa>0.0?aa:0.0;g[b+516>>2]=aa;A=+g[b+536>>2];l=+g[b+540>>2];$=+g[b+544>>2];j=A*(C*(aa-k))+B*(aa-k)*l+z*(aa-k)*$;y=+P(+((z*(aa-k)-$*j)*(z*(aa-k)-$*j)+((C*(aa-k)-A*j)*(C*(aa-k)-A*j)+(B*(aa-k)-l*j)*(B*(aa-k)-l*j))));A=1.0/y*(C*(aa-k)-A*j);B=1.0/y*(B*(aa-k)-l*j);C=1.0/y*(z*(aa-k)-$*j);v=c[b+28>>2]|0;if(c[d+240>>2]|0){z=A*+g[v+296>>2]+B*+g[v+300>>2]+C*+g[v+304>>2];j=A*+g[v+280>>2]+B*+g[v+284>>2]+C*+g[v+288>>2];$=A*+g[v+264>>2]+B*+g[v+268>>2]+C*+g[v+272>>2];aa=y*0.0*+g[d+116>>2];k=y*0.0*+g[d+120>>2];g[d+64>>2]=y*0.0*+g[d+112>>2]+ +g[d+64>>2];g[d+68>>2]=aa+ +g[d+68>>2];g[d+72>>2]=k+ +g[d+72>>2];j=j*(y*+g[d+100>>2]);z=z*(y*+g[d+104>>2]);g[J>>2]=$*(y*+g[d+96>>2])+ +g[J>>2];g[K>>2]=j+ +g[K>>2];g[I>>2]=z+ +g[I>>2]}v=c[b+32>>2]|0;if(c[e+240>>2]|0){z=A*+g[v+296>>2]+B*+g[v+300>>2]+C*+g[v+304>>2];j=A*+g[v+280>>2]+B*+g[v+284>>2]+C*+g[v+288>>2];A=A*+g[v+264>>2]+B*+g[v+268>>2]+C*+g[v+272>>2];C=y*-0.0*+g[e+116>>2];B=y*-0.0*+g[e+120>>2];g[e+64>>2]=y*-0.0*+g[e+112>>2]+ +g[e+64>>2];g[e+68>>2]=C+ +g[e+68>>2];g[e+72>>2]=B+ +g[e+72>>2];B=j*(+g[e+100>>2]*-y);C=z*(+g[e+104>>2]*-y);g[M>>2]=A*(+g[e+96>>2]*-y)+ +g[M>>2];g[N>>2]=B+ +g[N>>2];g[L>>2]=C+ +g[L>>2]}}if(!(a[b+525>>0]|0)){i=O;return}p=+g[b+532>>2];m=p*+g[b+508>>2]*+g[b+432>>2]/f;l=+g[b+476>>2];k=+g[b+480>>2];j=+g[b+484>>2];if((D-H)*l+(E-u)*k+(F-G)*j>0.0)m=m+p*((D-H)*l+(E-u)*k+(F-G)*j)*+g[b+436>>2];o=+g[b+520>>2];p=o+m*+g[b+496>>2];p=p>0.0?p:0.0;g[b+520>>2]=p;h=c[b+28>>2]|0;if(c[d+240>>2]|0){f=l*+g[h+296>>2]+k*+g[h+300>>2]+j*+g[h+304>>2];F=l*+g[h+280>>2]+k*+g[h+284>>2]+j*+g[h+288>>2];j=l*+g[h+264>>2]+k*+g[h+268>>2]+j*+g[h+272>>2];l=(p-o)*0.0*+g[d+116>>2];k=(p-o)*0.0*+g[d+120>>2];g[d+64>>2]=(p-o)*0.0*+g[d+112>>2]+ +g[d+64>>2];g[d+68>>2]=l+ +g[d+68>>2];g[d+72>>2]=k+ +g[d+72>>2];k=F*((p-o)*+g[d+100>>2]);l=f*((p-o)*+g[d+104>>2]);g[J>>2]=j*((p-o)*+g[d+96>>2])+ +g[J>>2];g[K>>2]=k+ +g[K>>2];g[I>>2]=l+ +g[I>>2];l=+g[b+476>>2];k=+g[b+480>>2];j=+g[b+484>>2]}h=c[b+32>>2]|0;if(!(c[e+240>>2]|0)){i=O;return}f=l*+g[h+296>>2]+k*+g[h+300>>2]+j*+g[h+304>>2];F=l*+g[h+280>>2]+k*+g[h+284>>2]+j*+g[h+288>>2];E=l*+g[h+264>>2]+k*+g[h+268>>2]+j*+g[h+272>>2];C=(p-o)*-0.0*+g[e+116>>2];D=(p-o)*-0.0*+g[e+120>>2];g[e+64>>2]=(p-o)*-0.0*+g[e+112>>2]+ +g[e+64>>2];g[e+68>>2]=C+ +g[e+68>>2];g[e+72>>2]=D+ +g[e+72>>2];F=F*(+g[e+100>>2]*-(p-o));f=f*(+g[e+104>>2]*-(p-o));g[M>>2]=E*(+g[e+96>>2]*-(p-o))+ +g[M>>2];g[N>>2]=F+ +g[N>>2];g[L>>2]=f+ +g[L>>2];i=O;return}function pr(a,b,c,d){a=a|0;b=b|0;c=+c;d=+d;var e=0.0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0;i=+R(+c);h=+S(+c);c=+g[b+444>>2];if(+O(+i)>1.1920928955078125e-07){e=+g[b+448>>2];c=+P(+((h*h/(i*i)+1.0)/(1.0/(e*e)+h*h/(i*i)/(c*c))));e=h*h;f=i*i}else{e=h*h;f=i*i}k=c*.5;c=+S(+k)/+P(+(f+0.0+e));k=+R(+k);l=k*d+i*c*0.0-h*c*-0.0;e=k*0.0-h*c*d-c*0.0*0.0;j=k*0.0+c*0.0*0.0-i*c*d;f=-(c*0.0*d)-i*c*0.0-h*c*-0.0;g[a>>2]=h*c*e+(k*l+f*-(c*0.0))-j*-(i*c);g[a+4>>2]=j*-(c*0.0)+(k*e+f*-(i*c))-h*c*l;g[a+8>>2]=l*-(i*c)+(k*j+h*c*f)-e*-(c*0.0);g[a+12>>2]=0.0;return}function qr(a,b){a=a|0;b=b|0;var d=0.0,e=0.0,f=0.0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,t=0.0,u=0.0,v=0.0,w=0;w=i;c[a+556>>2]=c[b+0>>2];c[a+560>>2]=c[b+4>>2];c[a+564>>2]=c[b+8>>2];c[a+568>>2]=c[b+12>>2];l=+g[a+568>>2];k=+g[a+560>>2];m=+g[a+564>>2];n=+g[a+556>>2];f=-n-k*0.0-m*0.0;e=(m+l*0.0-n*0.0)*-m+(l*(l+k*0.0-m*0.0)+f*-n)-(l*0.0+n*0.0-k)*-k;d=(l*0.0+n*0.0-k)*-n+(l*(m+l*0.0-n*0.0)+f*-k)-(l+k*0.0-m*0.0)*-m;f=(l+k*0.0-m*0.0)*-k+(l*(l*0.0+n*0.0-k)+f*-m)-(m+l*0.0-n*0.0)*-n;if(f*0.0+(d*0.0+e)<-.9999998807907104)if(+O(0.0)>.7071067690849304){j=0.0;h=s;f=0.0;e=s}else{j=0.0;h=1.0;f=-0.0;e=0.0}else{o=+P(+((f*0.0+(d*0.0+e)+1.0)*2.0));j=o*.5;h=(e*0.0-f)*(1.0/o);f=(f*0.0-d*0.0)*(1.0/o);e=(d-e*0.0)*(1.0/o)}o=1.0/+P(+(j*j+(e*e+(h*h+f*f))));r=f*o;p=h*o;q=e*o;o=j*o;d=1.0/+P(+((o*l-n*-r-k*-p-m*-q)*(o*l-n*-r-k*-p-m*-q)+((l*-q+o*m+k*-r-n*-p)*(l*-q+o*m+k*-r-n*-p)+((o*n+l*-r+m*-p-k*-q)*(o*n+l*-r+m*-p-k*-q)+(n*-q+(l*-p+o*k)-m*-r)*(n*-q+(l*-p+o*k)-m*-r)))));u=(o*n+l*-r+m*-p-k*-q)*d;h=d*(n*-q+(l*-p+o*k)-m*-r);v=d*(l*-q+o*m+k*-r-n*-p);d=d*(o*l-n*-r-k*-p-m*-q);f=+g[a+444>>2];if(f>=.05000000074505806?(t=+g[a+448>>2],t>=.05000000074505806):0){e=o<-1.0?-1.0:o;e=+U(+(e>1.0?1.0:e))*2.0;if(e>1.1920928955078125e-07){j=1.0/+P(+(q*q+(r*r+p*p)));if(+O(+(p*j))>1.1920928955078125e-07){m=r*j;n=p*j;l=q*j;f=+P(+((q*j*(q*j)/(p*j*(p*j))+1.0)/(1.0/(t*t)+q*j*(q*j)/(p*j*(p*j))/(f*f))))}else{m=r*j;n=p*j;l=q*j}}else{m=0.0;n=0.0;l=0.0;f=0.0}if(+O(+e)>1.1920928955078125e-07){if(!(e>f)){f=-f;if(e<f)e=f}else e=f;o=e*.5;k=+S(+o)/+P(+(l*l+(n*n+m*m)));o=+R(+o);p=n*k;m=m*k;n=l*k}else{m=r;n=q}}else{m=r;n=q}l=+g[a+452>>2];if(l>=.05000000074505806){e=d<-1.0?-1.0:d;e=+U(+(e>1.0?1.0:e))*2.0;if(e>3.1415927410125732){e=d>1.0?-1.0:-d;f=-u;j=-h;k=-v;e=+U(+(e>1.0?1.0:e))*2.0}else{f=u;j=h;k=v}if(e>1.1920928955078125e-07){q=1.0/+P(+(k*k+(j*j+f*f)));f=f*q;j=j*q;k=k*q}if(+O(+e)>1.1920928955078125e-07){if(!(e>l)){if(e<-l)e=-l}else e=l;d=e*.5;e=+S(+d)/+P(+(k*k+(j*j+f*f)));h=j*e;f=f*e;e=k*e;d=+R(+d)}else{f=u;e=v}}else{f=u;e=v}g[a+556>>2]=p*e+(m*d+o*f)-n*h;g[a+560>>2]=n*f+(p*d+o*h)-m*e;g[a+564>>2]=n*d+o*e+m*h-p*f;g[a+568>>2]=o*d-m*f-p*h-n*e;i=w;return}function rr(a,b,d,e){a=a|0;b=b|0;d=+d;e=e|0;var f=0;f=i;if((b|0)==2|(b|0)==1)if(e>>>0<3){g[a+600>>2]=d;c[a+592>>2]=c[a+592>>2]|2;i=f;return}else{g[a+432>>2]=d;i=f;return}else if((b|0)==4|(b|0)==3)if(e>>>0<3){g[a+596>>2]=d;c[a+592>>2]=c[a+592>>2]|1;i=f;return}else{g[a+604>>2]=d;c[a+592>>2]=c[a+592>>2]|4;i=f;return}else{i=f;return}}function sr(a,b,c){a=a|0;b=b|0;c=c|0;var d=0.0,e=0;e=i;do if((b|0)==2|(b|0)==1){if(c>>>0<3){d=+g[a+600>>2];break}if((c+-3|0)>>>0<3)d=+g[a+432>>2];else d=0.0}else if((b|0)==4|(b|0)==3){if(c>>>0<3){d=+g[a+596>>2];break}if((c+-3|0)>>>0<3)d=+g[a+604>>2];else d=0.0}else d=0.0;while(0);i=e;return +d}function tr(a,b,d){a=a|0;b=b|0;d=d|0;var e=0;e=i;c[a+300>>2]=c[b+0>>2];c[a+304>>2]=c[b+4>>2];c[a+308>>2]=c[b+8>>2];c[a+312>>2]=c[b+12>>2];c[a+316>>2]=c[b+16>>2];c[a+320>>2]=c[b+20>>2];c[a+324>>2]=c[b+24>>2];c[a+328>>2]=c[b+28>>2];c[a+332>>2]=c[b+32>>2];c[a+336>>2]=c[b+36>>2];c[a+340>>2]=c[b+40>>2];c[a+344>>2]=c[b+44>>2];c[a+348>>2]=c[b+48>>2];c[a+352>>2]=c[b+52>>2];c[a+356>>2]=c[b+56>>2];c[a+360>>2]=c[b+60>>2];c[a+364>>2]=c[d+0>>2];c[a+368>>2]=c[d+4>>2];c[a+372>>2]=c[d+8>>2];c[a+376>>2]=c[d+12>>2];c[a+380>>2]=c[d+16>>2];c[a+384>>2]=c[d+20>>2];c[a+388>>2]=c[d+24>>2];c[a+392>>2]=c[d+28>>2];c[a+396>>2]=c[d+32>>2];c[a+400>>2]=c[d+36>>2];c[a+404>>2]=c[d+40>>2];c[a+408>>2]=c[d+44>>2];c[a+412>>2]=c[d+48>>2];c[a+416>>2]=c[d+52>>2];c[a+420>>2]=c[d+56>>2];c[a+424>>2]=c[d+60>>2];Jb[c[(c[a>>2]|0)+8>>2]&255](a);i=e;return}function ur(a,b,c){a=a|0;b=b|0;c=c|0;var d=0;d=i;br(a,b,c)|0;g[b+52>>2]=+g[a+300>>2];g[b+56>>2]=+g[a+304>>2];g[b+60>>2]=+g[a+308>>2];g[b+64>>2]=+g[a+312>>2];g[b+68>>2]=+g[a+316>>2];g[b+72>>2]=+g[a+320>>2];g[b+76>>2]=+g[a+324>>2];g[b+80>>2]=+g[a+328>>2];g[b+84>>2]=+g[a+332>>2];g[b+88>>2]=+g[a+336>>2];g[b+92>>2]=+g[a+340>>2];g[b+96>>2]=+g[a+344>>2];g[b+100>>2]=+g[a+348>>2];g[b+104>>2]=+g[a+352>>2];g[b+108>>2]=+g[a+356>>2];g[b+112>>2]=+g[a+360>>2];g[b+116>>2]=+g[a+364>>2];g[b+120>>2]=+g[a+368>>2];g[b+124>>2]=+g[a+372>>2];g[b+128>>2]=+g[a+376>>2];g[b+132>>2]=+g[a+380>>2];g[b+136>>2]=+g[a+384>>2];g[b+140>>2]=+g[a+388>>2];g[b+144>>2]=+g[a+392>>2];g[b+148>>2]=+g[a+396>>2];g[b+152>>2]=+g[a+400>>2];g[b+156>>2]=+g[a+404>>2];g[b+160>>2]=+g[a+408>>2];g[b+164>>2]=+g[a+412>>2];g[b+168>>2]=+g[a+416>>2];g[b+172>>2]=+g[a+420>>2];g[b+176>>2]=+g[a+424>>2];g[b+180>>2]=+g[a+444>>2];g[b+184>>2]=+g[a+448>>2];g[b+188>>2]=+g[a+452>>2];g[b+192>>2]=+g[a+428>>2];g[b+196>>2]=+g[a+432>>2];g[b+200>>2]=+g[a+436>>2];g[b+204>>2]=+g[a+440>>2];i=d;return 3800}function vr(a){a=a|0;return 212}function wr(a){a=a|0;var b=0;b=i;if(!a){i=b;return}c[5110]=(c[5110]|0)+1;RE(c[a+-4>>2]|0);i=b;return}function xr(b,d,e,f,h,j,k,l){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;k=k|0;l=l|0;var m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0,z=0.0,A=0.0;y=i;c[b+4>>2]=4;c[b+8>>2]=-1;c[b+12>>2]=-1;g[b+16>>2]=3402823466385288598117041.0e14;a[b+20>>0]=1;a[b+21>>0]=0;c[b+24>>2]=-1;c[b+28>>2]=d;c[b+32>>2]=e;g[b+36>>2]=0.0;g[b+40>>2]=.30000001192092896;c[b+44>>2]=0;c[b>>2]=3840;g[b+688>>2]=0.0;g[b+692>>2]=-1.0;g[b+696>>2]=.8999999761581421;g[b+700>>2]=.30000001192092896;g[b+704>>2]=1.0;g[b+708>>2]=0.0;g[b+712>>2]=0.0;a[b+716>>0]=0;a[b+736>>0]=0;a[b+737>>0]=0;a[b+738>>0]=0;a[b+739>>0]=1;a[b+740>>0]=l&1;c[b+748>>2]=0;c[b+600>>2]=c[f+0>>2];c[b+604>>2]=c[f+4>>2];c[b+608>>2]=c[f+8>>2];c[b+612>>2]=c[f+12>>2];p=+g[d+4>>2];o=+g[d+20>>2];n=+g[d+36>>2];m=+g[j>>2];q=+g[j+4>>2];r=+g[j+8>>2];do if(!(p*m+o*q+n*r>=.9999998807907104))if(!(p*m+o*q+n*r<=-.9999998807907104)){w=r*(p*r-n*m)-q*(o*m-p*q);x=q*(n*q-o*r)-m*(p*r-n*m);t=n*q-o*r;s=o*m-p*q;u=p*r-n*m;v=m*(o*m-p*q)-r*(n*q-o*r);break}else{w=+g[d+12>>2];x=+g[d+44>>2];t=+g[d+8>>2];s=+g[d+40>>2];u=+g[d+24>>2];v=+g[d+28>>2];break}else{w=-+g[d+12>>2];x=-+g[d+44>>2];t=+g[d+8>>2];s=+g[d+40>>2];u=+g[d+24>>2];v=-+g[d+28>>2]}while(0);g[b+552>>2]=w;g[b+556>>2]=t;g[b+560>>2]=+g[j>>2];g[b+564>>2]=0.0;g[b+568>>2]=v;g[b+572>>2]=u;g[b+576>>2]=+g[j+4>>2];g[b+580>>2]=0.0;g[b+584>>2]=x;g[b+588>>2]=s;g[b+592>>2]=+g[j+8>>2];g[b+596>>2]=0.0;o=+g[j+4>>2];q=+g[k+8>>2];n=+g[j+8>>2];s=+g[k+4>>2];t=+g[k>>2];m=+g[j>>2];do if(q*n+(o*s+t*m)<-.9999998807907104)if(+O(+n)>.7071067690849304){m=1.0/+P(+(o*o+n*n));r=0.0;p=-(n*m);m=o*m;n=0.0;break}else{p=1.0/+P(+(o*o+m*m));r=-(o*p);p=m*p;m=0.0;n=0.0;break}else{u=+P(+((q*n+(o*s+t*m)+1.0)*2.0));r=(o*q-n*s)*(1.0/u);p=(n*t-q*m)*(1.0/u);m=(s*m-o*t)*(1.0/u);n=u*.5}while(0);A=w*n+x*p-v*m;o=v*n+w*m-x*r;z=x*n+v*r-w*p;w=-(w*r)-v*p-x*m;r=-r;x=-p;p=-m;v=o*p+(n*A+w*r)-z*x;u=z*r+(n*o+w*x)-A*p;r=A*x+(n*z+w*p)-o*r;c[b+664>>2]=c[h+0>>2];c[b+668>>2]=c[h+4>>2];c[b+672>>2]=c[h+8>>2];c[b+676>>2]=c[h+12>>2];g[b+616>>2]=v;g[b+620>>2]=s*r-q*u;g[b+624>>2]=+g[k>>2];g[b+628>>2]=0.0;g[b+632>>2]=u;g[b+636>>2]=q*v-t*r;g[b+640>>2]=+g[k+4>>2];g[b+644>>2]=0.0;g[b+648>>2]=r;g[b+652>>2]=t*u-s*v;g[b+656>>2]=+g[k+8>>2];g[b+660>>2]=0.0;g[b+732>>2]=l?-1.0:1.0;i=y;return}function yr(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var h=0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0;h=i;c[b+4>>2]=4;c[b>>2]=256;c[b+8>>2]=-1;c[b+12>>2]=-1;g[b+16>>2]=3402823466385288598117041.0e14;a[b+20>>0]=1;a[b+21>>0]=0;c[b+24>>2]=-1;c[b+28>>2]=d;ar();c[b+32>>2]=2960;g[b+36>>2]=0.0;g[b+40>>2]=.30000001192092896;c[b+44>>2]=0;c[b>>2]=3840;c[b+552>>2]=c[e+0>>2];c[b+556>>2]=c[e+4>>2];c[b+560>>2]=c[e+8>>2];c[b+564>>2]=c[e+12>>2];c[b+568>>2]=c[e+16>>2];c[b+572>>2]=c[e+20>>2];c[b+576>>2]=c[e+24>>2];c[b+580>>2]=c[e+28>>2];c[b+584>>2]=c[e+32>>2];c[b+588>>2]=c[e+36>>2];c[b+592>>2]=c[e+40>>2];c[b+596>>2]=c[e+44>>2];c[b+600>>2]=c[e+48>>2];c[b+604>>2]=c[e+52>>2];c[b+608>>2]=c[e+56>>2];c[b+612>>2]=c[e+60>>2];c[b+616>>2]=c[e+0>>2];c[b+620>>2]=c[e+4>>2];c[b+624>>2]=c[e+8>>2];c[b+628>>2]=c[e+12>>2];c[b+632>>2]=c[e+16>>2];c[b+636>>2]=c[e+20>>2];c[b+640>>2]=c[e+24>>2];c[b+644>>2]=c[e+28>>2];c[b+648>>2]=c[e+32>>2];c[b+652>>2]=c[e+36>>2];c[b+656>>2]=c[e+40>>2];c[b+660>>2]=c[e+44>>2];c[b+664>>2]=c[e+48>>2];c[b+668>>2]=c[e+52>>2];c[b+672>>2]=c[e+56>>2];c[b+676>>2]=c[e+60>>2];g[b+688>>2]=0.0;g[b+692>>2]=-1.0;g[b+696>>2]=.8999999761581421;g[b+700>>2]=.30000001192092896;g[b+704>>2]=1.0;g[b+708>>2]=0.0;g[b+712>>2]=0.0;a[b+716>>0]=0;a[b+736>>0]=0;a[b+737>>0]=0;a[b+738>>0]=0;a[b+739>>0]=1;a[b+740>>0]=f&1;c[b+748>>2]=0;d=c[b+28>>2]|0;n=+g[b+600>>2];m=+g[b+604>>2];l=+g[b+608>>2];k=n*+g[d+20>>2]+m*+g[d+24>>2]+l*+g[d+28>>2]+ +g[d+56>>2];j=n*+g[d+36>>2]+m*+g[d+40>>2]+l*+g[d+44>>2]+ +g[d+60>>2];g[b+664>>2]=n*+g[d+4>>2]+m*+g[d+8>>2]+l*+g[d+12>>2]+ +g[d+52>>2];g[b+668>>2]=k;g[b+672>>2]=j;g[b+676>>2]=0.0;g[b+732>>2]=f?-1.0:1.0;i=h;return}function zr(b){b=b|0;var d=0.0,e=0.0,f=0,h=0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0,M=0,N=0.0,Q=0.0,R=0.0,S=0.0,T=0.0,U=0.0,V=0.0,W=0.0,X=0.0;L=i;i=i+176|0;if(!(a[b+738>>0]|0)){i=L;return}g[b+36>>2]=0.0;g[b+744>>2]=0.0;a:do if(!(a[b+736>>0]|0)){h=c[b+28>>2]|0;n=+g[b+600>>2];p=+g[b+604>>2];J=+g[b+608>>2];K=n*+g[h+20>>2]+p*+g[h+24>>2]+J*+g[h+28>>2]+ +g[h+56>>2];f=c[b+32>>2]|0;t=+g[b+664>>2];u=+g[f+4>>2];v=+g[b+668>>2];w=+g[f+8>>2];x=+g[b+672>>2];y=+g[f+12>>2];z=+g[f+20>>2];A=+g[f+24>>2];B=+g[f+28>>2];C=+g[f+36>>2];D=+g[f+40>>2];E=+g[f+44>>2];F=+g[f+52>>2];G=+g[f+56>>2];H=+g[f+60>>2];o=t*z+v*A+x*B+G-K;I=n*+g[h+4>>2]+p*+g[h+8>>2]+J*+g[h+12>>2]+ +g[h+52>>2];J=n*+g[h+36>>2]+p*+g[h+40>>2]+J*+g[h+44>>2]+ +g[h+60>>2];p=t*u+v*w+x*y+F-I;n=t*C+v*D+x*E+H-J;if(p*p+o*o+n*n>1.1920928955078125e-07){s=1.0/+P(+(p*p+o*o+n*n));j=p*s;p=o*s;o=n*s}else{j=1.0;p=0.0;o=0.0}g[L+128>>2]=j;g[L+132>>2]=p;g[L+136>>2]=o;g[L+140>>2]=0.0;if(+O(+o)>.7071067690849304){r=o*o+p*p;k=1.0/+P(+r);s=-(k*o);o=k*p;n=0.0;m=s;l=o;k=r*k;o=-(j*o);p=j*s}else{r=j*j+p*p;s=1.0/+P(+r);p=-(p*s);k=s*j;n=p;m=k;l=0.0;k=-(o*k);o=o*p;p=r*s}g[L+144>>2]=n;g[L+148>>2]=m;g[L+152>>2]=l;g[L+160>>2]=k;g[L+164>>2]=o;g[L+168>>2]=p;p=u;o=z;n=C;m=w;l=A;k=D;j=y;e=B;d=E;q=F;r=G;s=H;h=0;while(1){M=c[b+28>>2]|0;g[L+80>>2]=+g[M+4>>2];g[L+84>>2]=+g[M+20>>2];g[L+88>>2]=+g[M+36>>2];g[L+92>>2]=0.0;g[L+96>>2]=+g[M+8>>2];g[L+100>>2]=+g[M+24>>2];g[L+104>>2]=+g[M+40>>2];g[L+108>>2]=0.0;g[L+112>>2]=+g[M+12>>2];g[L+116>>2]=+g[M+28>>2];g[L+120>>2]=+g[M+44>>2];g[L+124>>2]=0.0;g[L+32>>2]=p;g[L+36>>2]=o;g[L+40>>2]=n;g[L+44>>2]=0.0;g[L+48>>2]=m;g[L+52>>2]=l;g[L+56>>2]=k;g[L+60>>2]=0.0;g[L+64>>2]=j;g[L+68>>2]=e;g[L+72>>2]=d;g[L+76>>2]=0.0;e=K-+g[M+56>>2];d=J-+g[M+60>>2];g[L+16>>2]=I-+g[M+52>>2];g[L+20>>2]=e;g[L+24>>2]=d;g[L+28>>2]=0.0;g[L>>2]=t*u+v*w+x*y+F-q;g[L+4>>2]=t*z+v*A+x*B+G-r;g[L+8>>2]=t*C+v*D+x*E+H-s;g[L+12>>2]=0.0;Kq(b+(h*84|0)+48|0,L+80|0,L+32|0,L+16|0,L,L+128+(h<<4)|0,M+396|0,+g[M+344>>2],f+396|0,+g[f+344>>2]);h=h+1|0;if((h|0)==3)break a;f=c[b+32>>2]|0;p=+g[f+4>>2];o=+g[f+20>>2];n=+g[f+36>>2];m=+g[f+8>>2];l=+g[f+24>>2];k=+g[f+40>>2];j=+g[f+12>>2];e=+g[f+28>>2];d=+g[f+44>>2];q=+g[f+52>>2];r=+g[f+56>>2];s=+g[f+60>>2]}}while(0);e=+g[b+560>>2];d=+g[b+576>>2];j=+g[b+592>>2];if(+O(+j)>.7071067690849304){p=1.0/+P(+(d*d+j*j));k=0.0;l=-(j*p);m=d*p;n=(d*d+j*j)*p;o=-(e*(d*p));p=e*-(j*p)}else{p=1.0/+P(+(e*e+d*d));k=-(d*p);l=e*p;m=0.0;n=-(j*(e*p));o=j*-(d*p);p=(e*e+d*d)*p}h=c[b+28>>2]|0;H=+g[h+4>>2];G=+g[h+8>>2];y=+g[h+12>>2];R=k*H+l*G+m*y;F=+g[h+20>>2];E=+g[h+24>>2];A=+g[h+28>>2];T=k*F+l*E+m*A;D=+g[h+36>>2];w=+g[h+40>>2];s=+g[h+44>>2];W=k*D+l*w+m*s;m=n*H+o*G+p*y;I=n*F+o*E+p*A;J=n*D+o*w+p*s;f=c[b+32>>2]|0;k=+g[f+4>>2];q=+g[f+20>>2];C=+g[f+36>>2];u=+g[f+8>>2];v=+g[f+24>>2];z=+g[f+40>>2];N=+g[f+12>>2];S=+g[f+28>>2];V=+g[f+44>>2];c[b+300>>2]=0;c[b+304>>2]=0;c[b+308>>2]=0;c[b+312>>2]=0;g[b+316>>2]=H*R+F*T+D*W;g[b+320>>2]=G*R+E*T+w*W;g[b+324>>2]=y*R+A*T+s*W;g[b+328>>2]=0.0;g[b+332>>2]=k*-R+q*-T+C*-W;g[b+336>>2]=u*-R+v*-T+z*-W;g[b+340>>2]=N*-R+S*-T+V*-W;g[b+344>>2]=0.0;o=(H*R+F*T+D*W)*+g[h+396>>2];p=(G*R+E*T+w*W)*+g[h+400>>2];l=(y*R+A*T+s*W)*+g[h+404>>2];g[b+348>>2]=o;g[b+352>>2]=p;g[b+356>>2]=l;g[b+360>>2]=0.0;t=(k*-R+q*-T+C*-W)*+g[f+396>>2];B=(u*-R+v*-T+z*-W)*+g[f+400>>2];X=(N*-R+S*-T+V*-W)*+g[f+404>>2];g[b+364>>2]=t;g[b+368>>2]=B;g[b+372>>2]=X;g[b+376>>2]=0.0;g[b+380>>2]=(H*R+F*T+D*W)*o+(G*R+E*T+w*W)*p+(y*R+A*T+s*W)*l+((k*-R+q*-T+C*-W)*t+(u*-R+v*-T+z*-W)*B+(N*-R+S*-T+V*-W)*X);f=c[b+28>>2]|0;X=+g[f+4>>2];W=+g[f+20>>2];V=+g[f+36>>2];T=+g[f+8>>2];S=+g[f+24>>2];R=+g[f+40>>2];N=+g[f+12>>2];B=+g[f+28>>2];z=+g[f+44>>2];h=c[b+32>>2]|0;v=+g[h+4>>2];u=+g[h+20>>2];t=+g[h+36>>2];C=+g[h+8>>2];q=+g[h+24>>2];k=+g[h+40>>2];l=+g[h+12>>2];p=+g[h+28>>2];o=+g[h+44>>2];c[b+384>>2]=0;c[b+388>>2]=0;c[b+392>>2]=0;c[b+396>>2]=0;g[b+400>>2]=m*X+I*W+J*V;g[b+404>>2]=m*T+I*S+J*R;g[b+408>>2]=m*N+I*B+J*z;g[b+412>>2]=0.0;g[b+416>>2]=v*-m+u*-I+t*-J;g[b+420>>2]=C*-m+q*-I+k*-J;g[b+424>>2]=l*-m+p*-I+o*-J;g[b+428>>2]=0.0;U=(m*X+I*W+J*V)*+g[f+396>>2];Q=(m*T+I*S+J*R)*+g[f+400>>2];x=(m*N+I*B+J*z)*+g[f+404>>2];g[b+432>>2]=U;g[b+436>>2]=Q;g[b+440>>2]=x;g[b+444>>2]=0.0;r=(v*-m+u*-I+t*-J)*+g[h+396>>2];n=(C*-m+q*-I+k*-J)*+g[h+400>>2];K=(l*-m+p*-I+o*-J)*+g[h+404>>2];g[b+448>>2]=r;g[b+452>>2]=n;g[b+456>>2]=K;g[b+460>>2]=0.0;g[b+464>>2]=(m*X+I*W+J*V)*U+(m*T+I*S+J*R)*Q+(m*N+I*B+J*z)*x+((v*-m+u*-I+t*-J)*r+(C*-m+q*-I+k*-J)*n+(l*-m+p*-I+o*-J)*K);h=c[b+28>>2]|0;K=+g[h+4>>2];J=+g[h+20>>2];o=+g[h+36>>2];I=+g[h+8>>2];p=+g[h+24>>2];m=+g[h+40>>2];l=+g[h+12>>2];n=+g[h+28>>2];k=+g[h+44>>2];f=c[b+32>>2]|0;q=+g[f+4>>2];C=+g[f+20>>2];r=+g[f+36>>2];t=+g[f+8>>2];u=+g[f+24>>2];v=+g[f+40>>2];x=+g[f+12>>2];z=+g[f+28>>2];B=+g[f+44>>2];c[b+468>>2]=0;c[b+472>>2]=0;c[b+476>>2]=0;c[b+480>>2]=0;o=(H*e+G*d+y*j)*K+(F*e+E*d+A*j)*J+(D*e+w*d+s*j)*o;m=(H*e+G*d+y*j)*I+(F*e+E*d+A*j)*p+(D*e+w*d+s*j)*m;k=(H*e+G*d+y*j)*l+(F*e+E*d+A*j)*n+(D*e+w*d+s*j)*k;g[b+484>>2]=o;g[b+488>>2]=m;g[b+492>>2]=k;g[b+496>>2]=0.0;y=-(H*e+G*d+y*j);A=-(F*e+E*d+A*j);e=-(D*e+w*d+s*j);g[b+500>>2]=q*y+C*A+r*e;g[b+504>>2]=t*y+u*A+v*e;g[b+508>>2]=x*y+z*A+B*e;g[b+512>>2]=0.0;n=o*+g[h+396>>2];l=m*+g[h+400>>2];j=k*+g[h+404>>2];g[b+516>>2]=n;g[b+520>>2]=l;g[b+524>>2]=j;g[b+528>>2]=0.0;s=(q*y+C*A+r*e)*+g[f+396>>2];w=(t*y+u*A+v*e)*+g[f+400>>2];d=(x*y+z*A+B*e)*+g[f+404>>2];g[b+532>>2]=s;g[b+536>>2]=w;g[b+540>>2]=d;g[b+544>>2]=0.0;g[b+548>>2]=o*n+m*l+k*j+((q*y+C*A+r*e)*s+(t*y+u*A+v*e)*w+(x*y+z*A+B*e)*d);g[b+724>>2]=0.0;f=c[b+28>>2]|0;h=c[b+32>>2]|0;d=+Cr(b,f+4|0,h+4|0);g[b+728>>2]=d;g[b+708>>2]=0.0;g[b+712>>2]=0.0;a[b+716>>0]=0;e=+g[b+692>>2];do if(e>=0.0){d=+SE(d-+g[b+688>>2],6.2831854820251465);if(!(d<-3.1415927410125732)){if(d>3.1415927410125732)d=d+-6.2831854820251465}else d=d+6.2831854820251465;if(d<-e){a[b+716>>0]=1;g[b+708>>2]=-(d+e);g[b+712>>2]=1.0;break}if(d>e){a[b+716>>0]=1;g[b+708>>2]=e-d;g[b+712>>2]=-1.0}}while(0);x=+g[b+560>>2];y=+g[b+576>>2];B=+g[b+592>>2];z=x*+g[f+4>>2]+y*+g[f+8>>2]+B*+g[f+12>>2];A=x*+g[f+20>>2]+y*+g[f+24>>2]+B*+g[f+28>>2];B=x*+g[f+36>>2]+y*+g[f+40>>2]+B*+g[f+44>>2];g[b+720>>2]=1.0/(z*(z*+g[f+264>>2]+A*+g[f+280>>2]+B*+g[f+296>>2])+A*(z*+g[f+268>>2]+A*+g[f+284>>2]+B*+g[f+300>>2])+B*(z*+g[f+272>>2]+A*+g[f+288>>2]+B*+g[f+304>>2])+(z*(z*+g[h+264>>2]+A*+g[h+280>>2]+B*+g[h+296>>2])+A*(z*+g[h+268>>2]+A*+g[h+284>>2]+B*+g[h+300>>2])+B*(z*+g[h+272>>2]+A*+g[h+288>>2]+B*+g[h+304>>2])));i=L;return}function Ar(b,d){b=b|0;d=d|0;var e=0.0,f=0.0,h=0,j=0;j=i;if(a[b+738>>0]|0){c[d>>2]=0;c[d+4>>2]=0;i=j;return}c[d>>2]=5;c[d+4>>2]=1;e=+Cr(b,(c[b+28>>2]|0)+4|0,(c[b+32>>2]|0)+4|0);g[b+728>>2]=e;g[b+708>>2]=0.0;g[b+712>>2]=0.0;a[b+716>>0]=0;f=+g[b+692>>2];do if(f>=0.0){e=+SE(e-+g[b+688>>2],6.2831854820251465);if(!(e<-3.1415927410125732)){if(e>3.1415927410125732)e=e+-6.2831854820251465}else e=e+6.2831854820251465;if(e<-f){a[b+716>>0]=1;g[b+708>>2]=-(e+f);g[b+712>>2]=1.0;break}if(e>f){a[b+716>>0]=1;g[b+708>>2]=f-e;g[b+712>>2]=-1.0}else h=12}else h=12;while(0);if((h|0)==12?(a[b+737>>0]|0)==0:0){i=j;return}c[d>>2]=6;c[d+4>>2]=0;i=j;return}function Br(b,d){b=b|0;d=d|0;var e=0.0,f=0.0,h=0,j=0.0,k=0,l=0,m=0.0,n=0.0,o=0.0,p=0,q=0.0,r=0,s=0.0,t=0,u=0.0,v=0,w=0.0,x=0.0,y=0.0,z=0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,N=0.0,O=0.0,Q=0.0,R=0.0,S=0.0,T=0.0,U=0.0,V=0.0,W=0.0,X=0.0,Y=0.0,Z=0,_=0,$=0,aa=0;$=i;i=i+256|0;Z=c[b+28>>2]|0;_=c[b+32>>2]|0;v=c[d+24>>2]|0;if(!(a[b+739>>0]|0)){ip($+192|0,Z+4|0,b+552|0);ip($+128|0,_+4|0,b+616|0);j=+g[$+240>>2];f=+g[$+244>>2];e=+g[$+248>>2];m=+g[$+176>>2];n=+g[$+180>>2];o=+g[$+184>>2];p=(a[b+736>>0]|0)==0;if(p){h=c[d+8>>2]|0;g[h>>2]=1.0;g[h+(v+1<<2)>>2]=1.0;g[h+((v<<1)+2<<2)>>2]=1.0;h=c[d+16>>2]|0;g[h>>2]=-1.0;g[h+(v+1<<2)>>2]=-1.0;g[h+((v<<1)+2<<2)>>2]=-1.0;h=v+1|0;k=(v<<1)+2|0;l=v<<1}else{h=v+1|0;k=(v<<1)+2|0;l=v<<1}q=j-+g[Z+52>>2];I=f-+g[Z+56>>2];H=e-+g[Z+60>>2];t=c[d+12>>2]|0;g[t>>2]=0.0;g[t+4>>2]=H;g[t+8>>2]=-I;g[t+12>>2]=0.0;g[t+(v<<2)>>2]=-H;g[t+(h<<2)>>2]=0.0;g[t+(v+2<<2)>>2]=q;g[t+(v+3<<2)>>2]=0.0;g[t+(l<<2)>>2]=I;aa=l|1;g[t+(aa<<2)>>2]=-q;g[t+(k<<2)>>2]=0.0;z=l+3|0;g[t+(z<<2)>>2]=0.0;q=m-+g[_+52>>2];I=n-+g[_+56>>2];H=o-+g[_+60>>2];r=c[d+20>>2]|0;g[r>>2]=0.0;g[r+4>>2]=-H;g[r+8>>2]=I;g[r+12>>2]=0.0;g[r+(v<<2)>>2]=H;g[r+(h<<2)>>2]=0.0;g[r+(v+2<<2)>>2]=-q;g[r+(v+3<<2)>>2]=0.0;g[r+(l<<2)>>2]=-I;g[r+(aa<<2)>>2]=q;g[r+(k<<2)>>2]=0.0;g[r+(z<<2)>>2]=0.0;q=+g[d>>2]*+g[d+4>>2];l=c[d+28>>2]|0;if(p){g[l>>2]=q*(m-j);g[l+(v<<2)>>2]=q*(n-f);g[l+(v<<1<<2)>>2]=q*(o-e)}w=+g[$+200>>2];x=+g[$+216>>2];y=+g[$+232>>2];e=+g[$+192>>2];D=+g[$+208>>2];E=+g[$+224>>2];B=+g[$+196>>2];F=+g[$+212>>2];A=+g[$+228>>2];v=c[d+24>>2]|0;g[t+(v*3<<2)>>2]=e;g[t+((v*3|0)+1<<2)>>2]=D;g[t+((v*3|0)+2<<2)>>2]=E;g[t+(v<<2<<2)>>2]=B;g[t+((v<<2|1)<<2)>>2]=F;g[t+((v<<2|2)<<2)>>2]=A;g[r+(v*3<<2)>>2]=-e;g[r+((v*3|0)+1<<2)>>2]=-D;g[r+((v*3|0)+2<<2)>>2]=-E;g[r+(v<<2<<2)>>2]=-B;g[r+((v<<2|1)<<2)>>2]=-F;g[r+((v<<2|2)<<2)>>2]=-A;H=+g[$+136>>2];C=+g[$+152>>2];I=+g[$+168>>2];g[l+(v*3<<2)>>2]=q*(E*(w*C-x*H)+(e*(x*I-y*C)+D*(y*H-w*I)));g[l+(v<<2<<2)>>2]=q*(A*(w*C-x*H)+(B*(x*I-y*C)+F*(y*H-w*I)));if(!(a[b+716>>0]|0)){z=0;u=0.0}else{u=+g[b+708>>2]*+g[b+732>>2];z=u>0.0?1:2}p=a[b+737>>0]|0;h=(z|0)!=0;if(!(p&255|z)){i=$;return}g[t+(v*5<<2)>>2]=w;g[t+((v*5|0)+1<<2)>>2]=x;g[t+((v*5|0)+2<<2)>>2]=y;g[r+(v*5<<2)>>2]=-w;g[r+((v*5|0)+1<<2)>>2]=-x;g[r+((v*5|0)+2<<2)>>2]=-y;e=+g[b+688>>2];j=+g[b+692>>2];f=+SE(e-j,6.2831854820251465);if(!(f<-3.1415927410125732))if(f>3.1415927410125732)s=f+-6.2831854820251465;else s=f;else s=f+6.2831854820251465;f=+SE(e+j,6.2831854820251465);if(!(f<-3.1415927410125732)){if(f>3.1415927410125732)f=f+-6.2831854820251465}else f=f+6.2831854820251465;k=s==f;r=l+(v*5<<2)|0;g[r>>2]=0.0;l=c[b+748>>2]|0;m=+g[((l&2|0)==0?d+4|0:b+760|0)>>2];if(!(h&k|p<<24>>24==0)){if(l&4)g[(c[d+32>>2]|0)+(v*5<<2)>>2]=+g[b+752>>2];q=+g[b+728>>2];n=+g[b+680>>2];p=s>f;do if(!(p|k)){o=n/(m*+g[d>>2]);if(o<0.0)if(q>=s&s-o>q){j=(s-q)/o;break}else{j=q<s?0.0:1.0;break}if(o>0.0)if(q<=f&f-o<q){j=(f-q)/o;break}else{j=q>f?0.0:1.0;break}else j=0.0}else j=p?1.0:0.0;while(0);g[r>>2]=j*n*+g[b+732>>2]+ +g[r>>2];g[(c[d+36>>2]|0)+(v*5<<2)>>2]=-+g[b+684>>2];g[(c[d+40>>2]|0)+(v*5<<2)>>2]=+g[b+684>>2]}if(!h){i=$;return}g[r>>2]=+g[r>>2]+u*(m*+g[d>>2]);if(l&1)g[(c[d+32>>2]|0)+(v*5<<2)>>2]=+g[b+756>>2];do if(!k){h=(c[d+36>>2]|0)+(v*5<<2)|0;if((z|0)==1){g[h>>2]=0.0;g[(c[d+40>>2]|0)+(v*5<<2)>>2]=3402823466385288598117041.0e14;break}else{g[h>>2]=-3402823466385288598117041.0e14;g[(c[d+40>>2]|0)+(v*5<<2)>>2]=0.0;break}}else{g[(c[d+36>>2]|0)+(v*5<<2)>>2]=-3402823466385288598117041.0e14;g[(c[d+40>>2]|0)+(v*5<<2)>>2]=3402823466385288598117041.0e14}while(0);f=+g[b+704>>2];do if(f>0.0){e=w*+g[Z+328>>2]+x*+g[Z+332>>2]+y*+g[Z+336>>2]-(w*+g[_+328>>2]+x*+g[_+332>>2]+y*+g[_+336>>2]);if((z|0)==1){if(!(e<0.0))break;if(!(+g[r>>2]<-(f*e)))break;g[r>>2]=-(f*e);break}else{if(!(e>0.0))break;if(!(+g[r>>2]>-(f*e)))break;g[r>>2]=-(f*e);break}}while(0);g[r>>2]=+g[b+700>>2]*+g[r>>2];i=$;return}ip($+64|0,Z+4|0,b+552|0);ip($,_+4|0,b+616|0);C=+g[$+48>>2];D=+g[$+112>>2];E=+g[$+52>>2];F=+g[$+116>>2];G=+g[$+56>>2];H=+g[$+120>>2];f=+g[(c[b+28>>2]|0)+344>>2];e=+g[(c[b+32>>2]|0)+344>>2];if(f<1.1920928955078125e-07)z=1;else z=e<1.1920928955078125e-07;if(f+e>0.0)B=e/(f+e);else B=.5;m=1.0-B;O=+g[$+72>>2];Q=+g[$+88>>2];R=+g[$+104>>2];S=+g[$+8>>2];T=+g[$+24>>2];U=+g[$+40>>2];V=B*O+m*S;X=B*Q+m*T;W=B*R+m*U;Y=1.0/+P(+(V*V+X*X+W*W));N=C-+g[_+52>>2];K=E-+g[_+56>>2];s=G-+g[_+60>>2];M=V*Y*(N*(V*Y)+K*(X*Y)+s*(W*Y));J=X*Y*(N*(V*Y)+K*(X*Y)+s*(W*Y));f=W*Y*(N*(V*Y)+K*(X*Y)+s*(W*Y));L=D-+g[Z+52>>2];j=F-+g[Z+56>>2];I=H-+g[Z+60>>2];y=V*Y*(V*Y*L+X*Y*j+W*Y*I);x=X*Y*(V*Y*L+X*Y*j+W*Y*I);e=W*Y*(V*Y*L+X*Y*j+W*Y*I);w=L-y+B*(y-M);A=j-x+B*(x-J);q=I-e+B*(e-f);n=N-M-m*(y-M);o=K-J-m*(x-J);u=s-f-m*(e-f);y=B*(N-M)+m*(L-y);x=B*(K-J)+m*(j-x);e=B*(s-f)+m*(I-e);if(y*y+x*x+e*e>1.1920928955078125e-07){I=1.0/+P(+(y*y+x*x+e*e));N=y*I;M=I*x;I=I*e}else{N=+g[$+68>>2];M=+g[$+84>>2];I=+g[$+100>>2]}J=X*Y*I-W*Y*M;K=W*Y*N-I*(V*Y);L=M*(V*Y)-X*Y*N;r=c[d+12>>2]|0;g[r>>2]=A*I-q*M;g[r+4>>2]=q*N-w*I;g[r+8>>2]=w*M-A*N;r=c[d+20>>2]|0;g[r>>2]=-(o*I-u*M);g[r+4>>2]=-(u*N-n*I);g[r+8>>2]=-(n*M-o*N);if(z?(a[b+716>>0]|0)!=0:0){y=m*(o*L-u*K);x=m*(u*J-n*L);e=m*(n*K-o*J);f=B*(A*L-q*K);s=B*(q*J-w*L);j=B*(w*K-A*J)}else{y=o*L-u*K;x=u*J-n*L;e=n*K-o*J;f=A*L-q*K;s=q*J-w*L;j=w*K-A*J}r=c[d+12>>2]|0;g[r+(v<<2)>>2]=f;g[r+(v+1<<2)>>2]=s;g[r+(v+2<<2)>>2]=j;r=c[d+20>>2]|0;g[r+(v<<2)>>2]=-y;g[r+(v+1<<2)>>2]=-x;g[r+(v+2<<2)>>2]=-e;if(z){j=m*(o*(W*Y)-u*(X*Y));s=m*(u*(V*Y)-n*(W*Y));f=m*(n*(X*Y)-o*(V*Y));e=B*(A*(W*Y)-q*(X*Y));x=B*(q*(V*Y)-w*(W*Y));y=B*(w*(X*Y)-A*(V*Y))}else{j=o*(W*Y)-u*(X*Y);s=u*(V*Y)-n*(W*Y);f=n*(X*Y)-o*(V*Y);e=A*(W*Y)-q*(X*Y);x=q*(V*Y)-w*(W*Y);y=w*(X*Y)-A*(V*Y)}r=c[d+12>>2]|0;g[r+(v<<1<<2)>>2]=e;g[r+((v<<1|1)<<2)>>2]=x;g[r+((v<<1)+2<<2)>>2]=y;r=c[d+20>>2]|0;g[r+(v<<1<<2)>>2]=-j;g[r+((v<<1|1)<<2)>>2]=-s;g[r+((v<<1)+2<<2)>>2]=-f;q=+g[d>>2]*+g[d+4>>2];if(!(a[b+736>>0]|0)){h=c[d+8>>2]|0;g[h>>2]=N;g[h+4>>2]=M;g[h+8>>2]=I;h=c[d+8>>2]|0;g[h+(v<<2)>>2]=J;g[h+(v+1<<2)>>2]=K;g[h+(v+2<<2)>>2]=L;h=c[d+8>>2]|0;g[h+(v<<1<<2)>>2]=V*Y;g[h+((v<<1|1)<<2)>>2]=X*Y;g[h+((v<<1)+2<<2)>>2]=W*Y;h=c[d+16>>2]|0;m=-N;g[h>>2]=m;o=-M;g[h+4>>2]=o;n=-I;g[h+8>>2]=n;g[h+(v<<2)>>2]=-J;g[h+(v+1<<2)>>2]=-K;g[h+(v+2<<2)>>2]=-L;g[h+(v<<1<<2)>>2]=-(V*Y);g[h+((v<<1|1)<<2)>>2]=-(X*Y);g[h+((v<<1)+2<<2)>>2]=-(W*Y);h=c[d+28>>2]|0;g[h>>2]=q*((C-D)*N+(E-F)*M+(G-H)*I);g[h+(v<<2)>>2]=q*((C-D)*J+(E-F)*K+(G-H)*L);g[h+(v<<1<<2)>>2]=q*((C-D)*(V*Y)+(E-F)*(X*Y)+(G-H)*(W*Y));r=c[d+20>>2]|0;q=m;m=-J;u=-K;j=-L}else{h=c[d+28>>2]|0;q=-N;o=-M;n=-I;m=-J;u=-K;j=-L}l=c[d+12>>2]|0;g[l+(v*3<<2)>>2]=N;g[l+((v*3|0)+1<<2)>>2]=M;g[l+((v*3|0)+2<<2)>>2]=I;g[l+(v<<2<<2)>>2]=J;g[l+((v<<2|1)<<2)>>2]=K;g[l+((v<<2|2)<<2)>>2]=L;g[r+(v*3<<2)>>2]=q;g[r+((v*3|0)+1<<2)>>2]=o;g[r+((v*3|0)+2<<2)>>2]=n;g[r+(v<<2<<2)>>2]=m;g[r+((v<<2|1)<<2)>>2]=u;g[r+((v<<2|2)<<2)>>2]=j;H=+g[d>>2]*+g[d+4>>2];g[h+(v*3<<2)>>2]=H*((Q*U-R*T)*N+(R*S-O*U)*M+(O*T-Q*S)*I);g[h+(v<<2<<2)>>2]=H*((Q*U-R*T)*J+(R*S-O*U)*K+(O*T-Q*S)*L);if(!(a[b+716>>0]|0)){z=0;u=0.0}else{u=+g[b+708>>2]*+g[b+732>>2];z=u>0.0?1:2}p=a[b+737>>0]|0;t=(z|0)!=0;if(!(p&255|z)){i=$;return}v=(c[d+24>>2]|0)*5|0;g[l+(v<<2)>>2]=V*Y;g[l+(v+1<<2)>>2]=X*Y;g[l+(v+2<<2)>>2]=W*Y;g[r+(v<<2)>>2]=-(V*Y);g[r+(v+1<<2)>>2]=-(X*Y);g[r+(v+2<<2)>>2]=-(W*Y);f=+g[b+688>>2];e=+g[b+692>>2];j=+SE(f-e,6.2831854820251465);if(!(j<-3.1415927410125732)){if(j>3.1415927410125732)j=j+-6.2831854820251465}else j=j+6.2831854820251465;f=+SE(f+e,6.2831854820251465);if(!(f<-3.1415927410125732)){if(f>3.1415927410125732)f=f+-6.2831854820251465}else f=f+6.2831854820251465;k=j==f;r=h+(v<<2)|0;g[r>>2]=0.0;l=c[b+748>>2]|0;m=+g[((l&2|0)==0?d+4|0:b+760|0)>>2];if(!(t&k|p<<24>>24==0)){if(l&4)g[(c[d+32>>2]|0)+(v<<2)>>2]=+g[b+752>>2];o=+g[b+728>>2];n=+g[b+680>>2];p=j>f;do if(!(p|k)){q=n/(m*+g[d>>2]);if(q<0.0)if(o>=j&j-q>o){j=(j-o)/q;break}else{j=o<j?0.0:1.0;break}if(q>0.0)if(o<=f&f-q<o){j=(f-o)/q;break}else{j=o>f?0.0:1.0;break}else j=0.0}else j=p?1.0:0.0;while(0);g[r>>2]=j*n*+g[b+732>>2]+ +g[r>>2];g[(c[d+36>>2]|0)+(v<<2)>>2]=-+g[b+684>>2];g[(c[d+40>>2]|0)+(v<<2)>>2]=+g[b+684>>2]}if(!t){i=$;return}g[r>>2]=+g[r>>2]+u*(m*+g[d>>2]);if(l&1)g[(c[d+32>>2]|0)+(v<<2)>>2]=+g[b+756>>2];do if(!k){h=(c[d+36>>2]|0)+(v<<2)|0;if((z|0)==1){g[h>>2]=0.0;g[(c[d+40>>2]|0)+(v<<2)>>2]=3402823466385288598117041.0e14;break}else{g[h>>2]=-3402823466385288598117041.0e14;g[(c[d+40>>2]|0)+(v<<2)>>2]=0.0;break}}else{g[(c[d+36>>2]|0)+(v<<2)>>2]=-3402823466385288598117041.0e14;g[(c[d+40>>2]|0)+(v<<2)>>2]=3402823466385288598117041.0e14}while(0);f=+g[b+704>>2];do if(f>0.0){e=+g[Z+328>>2]*(V*Y)+ +g[Z+332>>2]*(X*Y)+ +g[Z+336>>2]*(W*Y)-(V*Y*+g[_+328>>2]+X*Y*+g[_+332>>2]+W*Y*+g[_+336>>2]);if((z|0)==1){if(!(e<0.0))break;if(!(+g[r>>2]<-(f*e)))break;g[r>>2]=-(f*e);break}else{if(!(e>0.0))break;if(!(+g[r>>2]>-(f*e)))break;g[r>>2]=-(f*e);break}}while(0);g[r>>2]=+g[b+700>>2]*+g[r>>2];i=$;return}function Cr(a,b,c){a=a|0;b=b|0;c=c|0;var d=0.0,e=0.0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0;v=+g[a+552>>2];u=+g[a+568>>2];t=+g[a+584>>2];s=+g[b>>2];r=+g[b+4>>2];q=+g[b+8>>2];o=+g[b+16>>2];n=+g[b+20>>2];m=+g[b+24>>2];k=+g[b+32>>2];i=+g[b+36>>2];f=+g[b+40>>2];j=+g[a+556>>2];h=+g[a+572>>2];e=+g[a+588>>2];x=+g[a+620>>2];w=+g[a+636>>2];d=+g[a+652>>2];p=x*+g[c>>2]+w*+g[c+4>>2]+d*+g[c+8>>2];l=x*+g[c+16>>2]+w*+g[c+20>>2]+d*+g[c+24>>2];d=x*+g[c+32>>2]+w*+g[c+36>>2]+d*+g[c+40>>2];d=+X(+((v*s+u*r+t*q)*p+(v*o+u*n+t*m)*l+(v*k+u*i+t*f)*d),+((s*j+r*h+q*e)*p+(o*j+n*h+m*e)*l+(k*j+i*h+f*e)*d));return +(d*+g[a+732>>2])}function Dr(a,b,d,e){a=a|0;b=b|0;d=+d;e=e|0;var f=0;f=i;if(!((e|0)==5|(e|0)==-1)){i=f;return}if((b|0)==2){g[a+760>>2]=d;c[a+748>>2]=c[a+748>>2]|2;i=f;return}else if((b|0)==3){g[a+752>>2]=d;c[a+748>>2]=c[a+748>>2]|4;i=f;return}else if((b|0)==4){g[a+756>>2]=d;c[a+748>>2]=c[a+748>>2]|1;i=f;return}else{i=f;return}}function Er(a,b,c){a=a|0;b=b|0;c=c|0;var d=0.0,e=0;e=i;do if((c|0)==5|(c|0)==-1)if((b|0)==2){d=+g[a+760>>2];break}else if((b|0)==3){d=+g[a+752>>2];break}else if((b|0)==4){d=+g[a+756>>2];break}else{d=0.0;break}else d=0.0;while(0);i=e;return +d}function Fr(a,b,e){a=a|0;b=b|0;e=e|0;var f=0.0,h=0.0,j=0.0,k=0;k=i;br(a,b,e)|0;g[b+52>>2]=+g[a+552>>2];g[b+56>>2]=+g[a+556>>2];g[b+60>>2]=+g[a+560>>2];g[b+64>>2]=+g[a+564>>2];g[b+68>>2]=+g[a+568>>2];g[b+72>>2]=+g[a+572>>2];g[b+76>>2]=+g[a+576>>2];g[b+80>>2]=+g[a+580>>2];g[b+84>>2]=+g[a+584>>2];g[b+88>>2]=+g[a+588>>2];g[b+92>>2]=+g[a+592>>2];g[b+96>>2]=+g[a+596>>2];g[b+100>>2]=+g[a+600>>2];g[b+104>>2]=+g[a+604>>2];g[b+108>>2]=+g[a+608>>2];g[b+112>>2]=+g[a+612>>2];g[b+116>>2]=+g[a+616>>2];g[b+120>>2]=+g[a+620>>2];g[b+124>>2]=+g[a+624>>2];g[b+128>>2]=+g[a+628>>2];g[b+132>>2]=+g[a+632>>2];g[b+136>>2]=+g[a+636>>2];g[b+140>>2]=+g[a+640>>2];g[b+144>>2]=+g[a+644>>2];g[b+148>>2]=+g[a+648>>2];g[b+152>>2]=+g[a+652>>2];g[b+156>>2]=+g[a+656>>2];g[b+160>>2]=+g[a+660>>2];g[b+164>>2]=+g[a+664>>2];g[b+168>>2]=+g[a+668>>2];g[b+172>>2]=+g[a+672>>2];g[b+176>>2]=+g[a+676>>2];c[b+184>>2]=d[a+736>>0];c[b+188>>2]=d[a+737>>0];g[b+196>>2]=+g[a+684>>2];g[b+192>>2]=+g[a+680>>2];c[b+180>>2]=d[a+740>>0];h=+g[a+688>>2];j=+g[a+692>>2];f=+SE(h-j,6.2831854820251465);if(!(f<-3.1415927410125732)){if(f>3.1415927410125732)f=f+-6.2831854820251465}else f=f+6.2831854820251465;g[b+200>>2]=f;f=+SE(h+j,6.2831854820251465);if(f<-3.1415927410125732){f=f+6.2831854820251465;e=b+204|0;g[e>>2]=f;e=a+696|0;f=+g[e>>2];e=b+208|0;g[e>>2]=f;e=a+700|0;f=+g[e>>2];e=b+212|0;g[e>>2]=f;e=a+704|0;f=+g[e>>2];e=b+216|0;g[e>>2]=f;i=k;return 3928}if(!(f>3.1415927410125732)){e=b+204|0;g[e>>2]=f;e=a+696|0;f=+g[e>>2];e=b+208|0;g[e>>2]=f;e=a+700|0;f=+g[e>>2];e=b+212|0;g[e>>2]=f;e=a+704|0;f=+g[e>>2];e=b+216|0;g[e>>2]=f;i=k;return 3928}f=f+-6.2831854820251465;e=b+204|0;g[e>>2]=f;e=a+696|0;f=+g[e>>2];e=b+208|0;g[e>>2]=f;e=a+700|0;f=+g[e>>2];e=b+212|0;g[e>>2]=f;e=a+704|0;f=+g[e>>2];e=b+216|0;g[e>>2]=f;i=k;return 3928}function Gr(a){a=a|0;return 220}function Hr(a){a=a|0;var b=0;b=i;if(!a){i=b;return}c[5110]=(c[5110]|0)+1;RE(c[a+-4>>2]|0);i=b;return}function Ir(b){b=b|0;var d=0,e=0;e=i;c[b>>2]=3976;d=c[b+176>>2]|0;if(d){if(a[b+180>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}c[b+176>>2]=0}a[b+180>>0]=1;c[b+176>>2]=0;c[b+168>>2]=0;c[b+172>>2]=0;d=c[b+156>>2]|0;if(d){if(a[b+160>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}c[b+156>>2]=0}a[b+160>>0]=1;c[b+156>>2]=0;c[b+148>>2]=0;c[b+152>>2]=0;d=c[b+136>>2]|0;if(d){if(a[b+140>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}c[b+136>>2]=0}a[b+140>>0]=1;c[b+136>>2]=0;c[b+128>>2]=0;c[b+132>>2]=0;d=c[b+116>>2]|0;if(d){if(a[b+120>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}c[b+116>>2]=0}a[b+120>>0]=1;c[b+116>>2]=0;c[b+108>>2]=0;c[b+112>>2]=0;d=c[b+96>>2]|0;if(d){if(a[b+100>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}c[b+96>>2]=0}a[b+100>>0]=1;c[b+96>>2]=0;c[b+88>>2]=0;c[b+92>>2]=0;d=c[b+76>>2]|0;if(d){if(a[b+80>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}c[b+76>>2]=0}a[b+80>>0]=1;c[b+76>>2]=0;c[b+68>>2]=0;c[b+72>>2]=0;d=c[b+56>>2]|0;if(d){if(a[b+60>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}c[b+56>>2]=0}a[b+60>>0]=1;c[b+56>>2]=0;c[b+48>>2]=0;c[b+52>>2]=0;d=c[b+36>>2]|0;if(d){if(a[b+40>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}c[b+36>>2]=0}a[b+40>>0]=1;c[b+36>>2]=0;c[b+28>>2]=0;c[b+32>>2]=0;d=c[b+16>>2]|0;if(!d){a[b+20>>0]=1;c[b+16>>2]=0;c[b+8>>2]=0;d=b+12|0;c[d>>2]=0;i=e;return}if(a[b+20>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[d+-4>>2]|0)}c[b+16>>2]=0;a[b+20>>0]=1;c[b+16>>2]=0;c[b+8>>2]=0;d=b+12|0;c[d>>2]=0;i=e;return}function Jr(a){a=a|0;var b=0;b=i;Ir(a);if(!a){i=b;return}c[5110]=(c[5110]|0)+1;RE(c[a+-4>>2]|0);i=b;return}function Kr(a,b,d){a=a|0;b=b|0;d=d|0;var e=0.0,f=0.0,h=0.0,j=0.0,k=0.0,l=0.0,m=0;m=i;h=+g[d+100>>2];j=+g[d+16>>2];k=+g[d+20>>2];l=+g[d+24>>2];e=+g[d+108>>2];e=+g[d+112>>2]-h*+g[d+116>>2]-(j*+g[a+64>>2]+k*+g[a+68>>2]+l*+g[a+72>>2]+(+g[d>>2]*+g[a+80>>2]+ +g[d+4>>2]*+g[a+84>>2]+ +g[d+8>>2]*+g[a+88>>2]))*e-e*(+g[d+48>>2]*+g[b+64>>2]+ +g[d+52>>2]*+g[b+68>>2]+ +g[d+56>>2]*+g[b+72>>2]+(+g[d+32>>2]*+g[b+80>>2]+ +g[d+36>>2]*+g[b+84>>2]+ +g[d+40>>2]*+g[b+88>>2]));f=+g[d+120>>2];do if(!(h+e<f)){f=+g[d+124>>2];if(h+e>f){g[d+100>>2]=f;e=f-h;break}else{g[d+100>>2]=h+e;break}}else{g[d+100>>2]=f;e=f-h}while(0);if(c[a+240>>2]|0){f=e*(k*+g[a+132>>2])*+g[a+116>>2];h=e*(l*+g[a+136>>2])*+g[a+120>>2];g[a+64>>2]=+g[a+112>>2]*(e*(j*+g[a+128>>2]))+ +g[a+64>>2];g[a+68>>2]=f+ +g[a+68>>2];g[a+72>>2]=h+ +g[a+72>>2];h=e*+g[a+100>>2]*+g[d+68>>2];f=e*+g[a+104>>2]*+g[d+72>>2];g[a+80>>2]=e*+g[a+96>>2]*+g[d+64>>2]+ +g[a+80>>2];g[a+84>>2]=h+ +g[a+84>>2];g[a+88>>2]=f+ +g[a+88>>2]}if(!(c[b+240>>2]|0)){i=m;return}f=e*(+g[d+52>>2]*+g[b+132>>2])*+g[b+116>>2];h=e*(+g[d+56>>2]*+g[b+136>>2])*+g[b+120>>2];g[b+64>>2]=+g[b+112>>2]*(e*(+g[d+48>>2]*+g[b+128>>2]))+ +g[b+64>>2];g[b+68>>2]=f+ +g[b+68>>2];g[b+72>>2]=h+ +g[b+72>>2];h=e*+g[b+100>>2]*+g[d+84>>2];f=e*+g[b+104>>2]*+g[d+88>>2];g[b+80>>2]=e*+g[b+96>>2]*+g[d+80>>2]+ +g[b+80>>2];g[b+84>>2]=h+ +g[b+84>>2];g[b+88>>2]=f+ +g[b+88>>2];i=m;return}function Lr(a,b,d){a=a|0;b=b|0;d=d|0;var e=0.0,f=0.0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0;n=i;f=+g[d+100>>2];j=+g[d+16>>2];k=+g[d+20>>2];l=+g[d+24>>2];h=+g[d+108>>2];h=+g[d+112>>2]-f*+g[d+116>>2]-(j*+g[a+64>>2]+k*+g[a+68>>2]+l*+g[a+72>>2]+(+g[d>>2]*+g[a+80>>2]+ +g[d+4>>2]*+g[a+84>>2]+ +g[d+8>>2]*+g[a+88>>2]))*h-h*(+g[d+48>>2]*+g[b+64>>2]+ +g[d+52>>2]*+g[b+68>>2]+ +g[d+56>>2]*+g[b+72>>2]+(+g[d+32>>2]*+g[b+80>>2]+ +g[d+36>>2]*+g[b+84>>2]+ +g[d+40>>2]*+g[b+88>>2]));e=+g[d+120>>2];if(f+h<e)m=e-f;else{m=h;e=f+h}g[d+100>>2]=e;if(c[a+240>>2]|0){e=m*(k*+g[a+132>>2])*+g[a+116>>2];f=m*(l*+g[a+136>>2])*+g[a+120>>2];g[a+64>>2]=+g[a+112>>2]*(m*(j*+g[a+128>>2]))+ +g[a+64>>2];g[a+68>>2]=e+ +g[a+68>>2];g[a+72>>2]=f+ +g[a+72>>2];f=m*+g[a+100>>2]*+g[d+68>>2];e=m*+g[a+104>>2]*+g[d+72>>2];g[a+80>>2]=m*+g[a+96>>2]*+g[d+64>>2]+ +g[a+80>>2];g[a+84>>2]=f+ +g[a+84>>2];g[a+88>>2]=e+ +g[a+88>>2]}if(!(c[b+240>>2]|0)){i=n;return}e=m*(+g[d+52>>2]*+g[b+132>>2])*+g[b+116>>2];f=m*(+g[d+56>>2]*+g[b+136>>2])*+g[b+120>>2];g[b+64>>2]=+g[b+112>>2]*(m*(+g[d+48>>2]*+g[b+128>>2]))+ +g[b+64>>2];g[b+68>>2]=e+ +g[b+68>>2];g[b+72>>2]=f+ +g[b+72>>2];f=m*+g[b+100>>2]*+g[d+84>>2];e=m*+g[b+104>>2]*+g[d+88>>2];g[b+80>>2]=m*+g[b+96>>2]*+g[d+80>>2]+ +g[b+80>>2];g[b+84>>2]=f+ +g[b+84>>2];g[b+88>>2]=e+ +g[b+88>>2];i=n;return}function Mr(a,b,d){a=a|0;b=b|0;d=d|0;var e=0.0,f=0.0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0;n=i;e=+g[d+128>>2];if(!(e!=0.0)){i=n;return}c[990]=(c[990]|0)+1;h=+g[d+96>>2];k=+g[d+16>>2];l=+g[d+20>>2];m=+g[d+24>>2];f=+g[d+108>>2];f=e-h*+g[d+116>>2]-(k*+g[a+144>>2]+l*+g[a+148>>2]+m*+g[a+152>>2]+(+g[d>>2]*+g[a+160>>2]+ +g[d+4>>2]*+g[a+164>>2]+ +g[d+8>>2]*+g[a+168>>2]))*f-f*(+g[d+48>>2]*+g[b+144>>2]+ +g[d+52>>2]*+g[b+148>>2]+ +g[d+56>>2]*+g[b+152>>2]+(+g[d+32>>2]*+g[b+160>>2]+ +g[d+36>>2]*+g[b+164>>2]+ +g[d+40>>2]*+g[b+168>>2]));e=+g[d+120>>2];if(h+f<e)j=e-h;else{j=f;e=h+f}g[d+96>>2]=e;if(c[a+240>>2]|0){e=j*(l*+g[a+132>>2])*+g[a+116>>2];f=j*(m*+g[a+136>>2])*+g[a+120>>2];g[a+144>>2]=+g[a+112>>2]*(j*(k*+g[a+128>>2]))+ +g[a+144>>2];g[a+148>>2]=e+ +g[a+148>>2];g[a+152>>2]=f+ +g[a+152>>2];f=j*+g[a+100>>2]*+g[d+68>>2];e=j*+g[a+104>>2]*+g[d+72>>2];g[a+160>>2]=j*+g[a+96>>2]*+g[d+64>>2]+ +g[a+160>>2];g[a+164>>2]=f+ +g[a+164>>2];g[a+168>>2]=e+ +g[a+168>>2]}if(!(c[b+240>>2]|0)){i=n;return}e=j*(+g[d+52>>2]*+g[b+132>>2])*+g[b+116>>2];f=j*(+g[d+56>>2]*+g[b+136>>2])*+g[b+120>>2];g[b+144>>2]=+g[b+112>>2]*(j*(+g[d+48>>2]*+g[b+128>>2]))+ +g[b+144>>2];g[b+148>>2]=e+ +g[b+148>>2];g[b+152>>2]=f+ +g[b+152>>2];f=j*+g[b+100>>2]*+g[d+84>>2];e=j*+g[b+104>>2]*+g[d+88>>2];g[b+160>>2]=j*+g[b+96>>2]*+g[d+80>>2]+ +g[b+160>>2];g[b+164>>2]=f+ +g[b+164>>2];g[b+168>>2]=e+ +g[b+168>>2];i=n;return}function Nr(a,b,d){a=a|0;b=b|0;d=+d;var e=0,f=0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0,o=0;f=i;if(!b)b=0;else b=(c[b+236>>2]&2|0)==0?0:b;c[a+64>>2]=0;c[a+68>>2]=0;c[a+72>>2]=0;c[a+76>>2]=0;c[a+80>>2]=0;c[a+84>>2]=0;c[a+88>>2]=0;c[a+92>>2]=0;c[a+144>>2]=0;c[a+148>>2]=0;c[a+152>>2]=0;c[a+156>>2]=0;c[a+160>>2]=0;c[a+164>>2]=0;c[a+168>>2]=0;c[a+172>>2]=0;if(!b){g[a>>2]=1.0;c[a+4>>2]=0;c[a+8>>2]=0;c[a+12>>2]=0;c[a+16>>2]=0;g[a+20>>2]=1.0;c[a+24>>2]=0;c[a+28>>2]=0;c[a+32>>2]=0;c[a+36>>2]=0;g[a+40>>2]=1.0;c[a+44>>2]=0;c[a+48>>2]=0;c[a+52>>2]=0;c[a+56>>2]=0;c[a+60>>2]=0;c[a+240>>2]=0;c[a+128>>2]=0;c[a+132>>2]=0;c[a+136>>2]=0;c[a+140>>2]=0;g[a+96>>2]=1.0;g[a+100>>2]=1.0;g[a+104>>2]=1.0;g[a+108>>2]=0.0;g[a+112>>2]=1.0;g[a+116>>2]=1.0;g[a+120>>2]=1.0;g[a+124>>2]=0.0;b=a+176|0;e=b+60|0;do{c[b>>2]=0;b=b+4|0}while((b|0)<(e|0));b=a+236|0;g[b>>2]=0.0;i=f;return}else{e=b+4|0;c[a+0>>2]=c[e+0>>2];c[a+4>>2]=c[e+4>>2];c[a+8>>2]=c[e+8>>2];c[a+12>>2]=c[e+12>>2];e=b+20|0;c[a+16>>2]=c[e+0>>2];c[a+20>>2]=c[e+4>>2];c[a+24>>2]=c[e+8>>2];c[a+28>>2]=c[e+12>>2];e=b+36|0;c[a+32>>2]=c[e+0>>2];c[a+36>>2]=c[e+4>>2];c[a+40>>2]=c[e+8>>2];c[a+44>>2]=c[e+12>>2];e=b+52|0;c[a+48>>2]=c[e+0>>2];c[a+52>>2]=c[e+4>>2];c[a+56>>2]=c[e+8>>2];c[a+60>>2]=c[e+12>>2];e=b+344|0;m=+g[e>>2];n=b+348|0;l=m*+g[b+352>>2];k=m*+g[b+356>>2];g[a+128>>2]=m*+g[n>>2];g[a+132>>2]=l;g[a+136>>2]=k;g[a+140>>2]=0.0;c[a+240>>2]=b;o=b+544|0;c[a+96>>2]=c[o+0>>2];c[a+100>>2]=c[o+4>>2];c[a+104>>2]=c[o+8>>2];c[a+108>>2]=c[o+12>>2];c[a+112>>2]=c[n+0>>2];c[a+116>>2]=c[n+4>>2];c[a+120>>2]=c[n+8>>2];c[a+124>>2]=c[n+12>>2];n=b+312|0;c[a+176>>2]=c[n+0>>2];c[a+180>>2]=c[n+4>>2];c[a+184>>2]=c[n+8>>2];c[a+188>>2]=c[n+12>>2];n=b+328|0;c[a+192>>2]=c[n+0>>2];c[a+196>>2]=c[n+4>>2];c[a+200>>2]=c[n+8>>2];c[a+204>>2]=c[n+12>>2];k=+g[e>>2];l=k*+g[b+416>>2]*d;m=k*+g[b+420>>2]*d;g[a+208>>2]=k*+g[b+412>>2]*d;g[a+212>>2]=l;g[a+216>>2]=m;g[a+220>>2]=0.0;m=+g[b+428>>2];l=+g[b+432>>2];k=+g[b+436>>2];j=(m*+g[b+268>>2]+l*+g[b+284>>2]+k*+g[b+300>>2])*d;h=(m*+g[b+272>>2]+l*+g[b+288>>2]+k*+g[b+304>>2])*d;g[a+224>>2]=(+g[b+264>>2]*m+ +g[b+280>>2]*l+ +g[b+296>>2]*k)*d;g[a+228>>2]=j;g[a+232>>2]=h;b=a+236|0;g[b>>2]=0.0;i=f;return}}function Or(a,b){a=a|0;b=b|0;var d=0,e=0.0,f=0.0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0;d=i;if(!a){i=d;return}if(!(c[a+180>>2]&1)){i=d;return}r=+g[a+4>>2];t=+g[b>>2];o=+g[a+20>>2];s=+g[b+4>>2];l=+g[a+36>>2];e=+g[b+8>>2];q=+g[a+8>>2];n=+g[a+24>>2];j=+g[a+40>>2];p=+g[a+12>>2];m=+g[a+28>>2];f=+g[a+44>>2];k=(r*t+o*s+l*e)*+g[a+164>>2];h=(t*q+s*n+e*j)*+g[a+168>>2];e=(t*p+s*m+e*f)*+g[a+172>>2];g[b>>2]=r*k+q*h+p*e;g[b+4>>2]=o*k+n*h+m*e;g[b+8>>2]=l*k+j*h+f*e;g[b+12>>2]=0.0;i=d;return}function Pr(b,d,e,f,h,j,k,l,m,n,o){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;k=k|0;l=l|0;m=+m;n=+n;o=+o;var p=0,q=0.0,r=0,s=0,t=0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0,N=0,O=0.0,P=0.0,Q=0.0,R=0.0;N=i;M=c[b+68>>2]|0;if((M|0)==(c[b+72>>2]|0)?(t=(M|0)==0?1:M<<1,(M|0)<(t|0)):0){if(!t){r=M;s=0}else{c[5108]=(c[5108]|0)+1;p=QE((t*152|3)+16|0)|0;if(!p)p=0;else{c[(p+19&-16)+-4>>2]=p;p=p+19&-16}r=c[b+68>>2]|0;s=p}if((r|0)>0){p=0;do{YE(s+(p*152|0)|0,(c[b+76>>2]|0)+(p*152|0)|0,152)|0;p=p+1|0}while((p|0)!=(r|0))}p=c[b+76>>2]|0;if(p){if(a[b+80>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[p+-4>>2]|0)}c[b+76>>2]=0}a[b+80>>0]=1;c[b+76>>2]=s;c[b+72>>2]=t;p=c[b+68>>2]|0}else p=M;c[b+68>>2]=p+1;s=c[b+76>>2]|0;c[s+(M*152|0)+140>>2]=h;h=c[b+16>>2]|0;b=c[h+(e*244|0)+240>>2]|0;t=c[h+(f*244|0)+240>>2]|0;c[s+(M*152|0)+144>>2]=e;c[s+(M*152|0)+148>>2]=f;F=+g[j+84>>2];g[s+(M*152|0)+104>>2]=F;c[s+(M*152|0)+132>>2]=0;g[s+(M*152|0)+100>>2]=0.0;g[s+(M*152|0)+96>>2]=0.0;if(b){c[s+(M*152|0)+16>>2]=c[d+0>>2];c[s+(M*152|0)+20>>2]=c[d+4>>2];c[s+(M*152|0)+24>>2]=c[d+8>>2];c[s+(M*152|0)+28>>2]=c[d+12>>2];u=+g[k+4>>2];D=+g[s+(M*152|0)+24>>2];K=+g[k+8>>2];q=+g[s+(M*152|0)+20>>2];E=+g[s+(M*152|0)+16>>2];y=+g[k>>2];g[s+(M*152|0)>>2]=u*D-K*q;g[s+(M*152|0)+4>>2]=K*E-D*y;g[s+(M*152|0)+8>>2]=q*y-u*E;g[s+(M*152|0)+12>>2]=0.0;v=((u*D-K*q)*+g[b+264>>2]+ +g[b+268>>2]*(K*E-D*y)+(q*y-u*E)*+g[b+272>>2])*+g[b+544>>2];x=((u*D-K*q)*+g[b+280>>2]+(K*E-D*y)*+g[b+284>>2]+(q*y-u*E)*+g[b+288>>2])*+g[b+548>>2];w=((u*D-K*q)*+g[b+296>>2]+(K*E-D*y)*+g[b+300>>2]+(q*y-u*E)*+g[b+304>>2])*+g[b+552>>2];g[s+(M*152|0)+64>>2]=v;g[s+(M*152|0)+68>>2]=x;g[s+(M*152|0)+72>>2]=w;g[s+(M*152|0)+76>>2]=0.0;z=E;A=q;B=D;C=u*D-K*q;D=K*E-D*y;E=q*y-u*E}else{c[s+(M*152|0)+64>>2]=0;c[s+(M*152|0)+68>>2]=0;c[s+(M*152|0)+72>>2]=0;c[s+(M*152|0)+76>>2]=0;c[s+(M*152|0)+0>>2]=0;c[s+(M*152|0)+4>>2]=0;c[s+(M*152|0)+8>>2]=0;c[s+(M*152|0)+12>>2]=0;c[s+(M*152|0)+16>>2]=0;c[s+(M*152|0)+20>>2]=0;c[s+(M*152|0)+24>>2]=0;c[s+(M*152|0)+28>>2]=0;x=0.0;w=0.0;v=0.0;z=0.0;A=0.0;B=0.0;C=0.0;D=0.0;E=0.0}if(t){L=-+g[d>>2];P=-+g[d+4>>2];K=-+g[d+8>>2];g[s+(M*152|0)+48>>2]=L;g[s+(M*152|0)+52>>2]=P;g[s+(M*152|0)+56>>2]=K;g[s+(M*152|0)+60>>2]=0.0;O=+g[l+4>>2];R=+g[l+8>>2];Q=+g[l>>2];g[s+(M*152|0)+32>>2]=O*K-R*P;g[s+(M*152|0)+36>>2]=R*L-Q*K;g[s+(M*152|0)+40>>2]=Q*P-O*L;g[s+(M*152|0)+44>>2]=0.0;u=((O*K-R*P)*+g[t+264>>2]+ +g[t+268>>2]*(R*L-Q*K)+(Q*P-O*L)*+g[t+272>>2])*+g[t+544>>2];q=((O*K-R*P)*+g[t+280>>2]+(R*L-Q*K)*+g[t+284>>2]+(Q*P-O*L)*+g[t+288>>2])*+g[t+548>>2];y=((O*K-R*P)*+g[t+296>>2]+(R*L-Q*K)*+g[t+300>>2]+(Q*P-O*L)*+g[t+304>>2])*+g[t+552>>2];g[s+(M*152|0)+80>>2]=u;g[s+(M*152|0)+84>>2]=q;g[s+(M*152|0)+88>>2]=y;g[s+(M*152|0)+92>>2]=0.0;G=L;H=P;I=K;J=O*K-R*P;K=R*L-Q*K;L=Q*P-O*L}else{c[s+(M*152|0)+80>>2]=0;c[s+(M*152|0)+84>>2]=0;c[s+(M*152|0)+88>>2]=0;c[s+(M*152|0)+92>>2]=0;c[s+(M*152|0)+32>>2]=0;c[s+(M*152|0)+36>>2]=0;c[s+(M*152|0)+40>>2]=0;c[s+(M*152|0)+44>>2]=0;c[s+(M*152|0)+48>>2]=0;c[s+(M*152|0)+52>>2]=0;c[s+(M*152|0)+56>>2]=0;c[s+(M*152|0)+60>>2]=0;u=0.0;q=0.0;y=0.0;G=0.0;H=0.0;I=0.0;J=0.0;K=0.0;L=0.0}if(b){Q=+g[k+8>>2];P=+g[k+4>>2];O=+g[k>>2];x=+g[b+344>>2]+((x*Q-w*P)*+g[d>>2]+(w*O-Q*v)*+g[d+4>>2]+(P*v-x*O)*+g[d+8>>2])}else x=0.0;if(t){u=-u;w=-q;O=-y;v=+g[l+8>>2];y=+g[l+4>>2];q=+g[l>>2];w=+g[t+344>>2]+((v*w-y*O)*+g[d>>2]+(q*O-v*u)*+g[d+4>>2]+(y*u-q*w)*+g[d+8>>2])}else w=0.0;x=m/(x+w);g[s+(M*152|0)+108>>2]=x;if(b){u=(+g[h+(e*244|0)+176>>2]+ +g[h+(e*244|0)+208>>2])*z+(+g[h+(e*244|0)+180>>2]+ +g[h+(e*244|0)+212>>2])*A+(+g[h+(e*244|0)+184>>2]+ +g[h+(e*244|0)+216>>2])*B;v=+g[h+(e*244|0)+192>>2];w=+g[h+(e*244|0)+196>>2];q=+g[h+(e*244|0)+200>>2]}else{u=z*0.0+A*0.0+B*0.0;v=0.0;w=0.0;q=0.0}q=u+(v*C+w*D+q*E);if(t){I=(+g[h+(f*244|0)+176>>2]+ +g[h+(f*244|0)+208>>2])*G+(+g[h+(f*244|0)+180>>2]+ +g[h+(f*244|0)+212>>2])*H+(+g[h+(f*244|0)+184>>2]+ +g[h+(f*244|0)+216>>2])*I;H=+g[h+(f*244|0)+192>>2];G=+g[h+(f*244|0)+196>>2];m=+g[h+(f*244|0)+200>>2];H=H*J;J=G*K;J=H+J;m=m*L;m=J+m;m=I+m;m=q+m;n=n-m;n=x*n;j=s+(M*152|0)+112|0;g[j>>2]=n;j=s+(M*152|0)+116|0;g[j>>2]=o;n=-F;j=s+(M*152|0)+120|0;g[j>>2]=n;j=s+(M*152|0)+124|0;g[j>>2]=F;i=N;return}else{I=G*0.0+H*0.0+I*0.0;H=0.0;G=0.0;m=0.0;H=H*J;J=G*K;J=H+J;m=m*L;m=J+m;m=I+m;m=q+m;n=n-m;n=x*n;j=s+(M*152|0)+112|0;g[j>>2]=n;j=s+(M*152|0)+116|0;g[j>>2]=o;n=-F;j=s+(M*152|0)+120|0;g[j>>2]=n;j=s+(M*152|0)+124|0;g[j>>2]=F;i=N;return}}function Qr(b,d,e,f,h,j){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;var k=0,l=0.0,m=0,n=0,o=0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0,C=0;C=i;B=c[b+88>>2]|0;if((B|0)==(c[b+92>>2]|0)?(o=(B|0)==0?1:B<<1,(B|0)<(o|0)):0){if(!o){m=B;n=0}else{c[5108]=(c[5108]|0)+1;k=QE((o*152|3)+16|0)|0;if(!k)k=0;else{c[(k+19&-16)+-4>>2]=k;k=k+19&-16}m=c[b+88>>2]|0;n=k}if((m|0)>0){k=0;do{YE(n+(k*152|0)|0,(c[b+96>>2]|0)+(k*152|0)|0,152)|0;k=k+1|0}while((k|0)!=(m|0))}k=c[b+96>>2]|0;if(k){if(a[b+100>>0]|0){c[5110]=(c[5110]|0)+1;RE(c[k+-4>>2]|0)}c[b+96>>2]=0}a[b+100>>0]=1;c[b+96>>2]=n;c[b+92>>2]=o;k=c[b+88>>2]|0}else k=B;c[b+88>>2]=k+1;n=c[b+96>>2]|0;c[n+(B*152|0)+140>>2]=h;c[n+(B*152|0)+16>>2]=0;c[n+(B*152|0)+20>>2]=0;c[n+(B*152|0)+24>>2]=0;c[n+(B*152|0)+28>>2]=0;g[n+(B*152|0)+48>>2]=-0.0;g[n+(B*152|0)+52>>2]=-0.0;g[n+(B*152|0)+56>>2]=-0.0;g[n+(B*152|0)+60>>2]=0.0;h=c[b+16>>2]|0;b=c[h+(e*244|0)+240>>2]|0;o=c[h+(f*244|0)+240>>2]|0;c[n+(B*152|0)+144>>2]=e;c[n+(B*152|0)+148>>2]=f;A=+g[j+88>>2];g[n+(B*152|0)+104>>2]=A;c[n+(B*152|0)+132>>2]=0;g[n+(B*152|0)+100>>2]=0.0;g[n+(B*152|0)+96>>2]=0.0;x=-+g[d>>2];y=-+g[d+4>>2];z=-+g[d+8>>2];g[n+(B*152|0)>>2]=x;g[n+(B*152|0)+4>>2]=y;g[n+(B*152|0)+8>>2]=z;g[n+(B*152|0)+12>>2]=0.0;if(b){l=(+g[b+264>>2]*x+ +g[b+268>>2]*y+ +g[b+272>>2]*z)*+g[b+544>>2];p=(+g[b+280>>2]*x+ +g[b+284>>2]*y+ +g[b+288>>2]*z)*+g[b+548>>2];q=(+g[b+296>>2]*x+ +g[b+300>>2]*y+ +g[b+304>>2]*z)*+g[b+552>>2]}else{l=0.0;p=0.0;q=0.0}g[n+(B*152|0)+64>>2]=l;g[n+(B*152|0)+68>>2]=p;g[n+(B*152|0)+72>>2]=q;g[n+(B*152|0)+76>>2]=0.0;u=+g[d>>2];v=+g[d+4>>2];w=+g[d+8>>2];s=+g[d+12>>2];g[n+(B*152|0)+32>>2]=u;g[n+(B*152|0)+36>>2]=v;g[n+(B*152|0)+40>>2]=w;g[n+(B*152|0)+44>>2]=s;if(o){q=(u*+g[o+264>>2]+v*+g[o+268>>2]+w*+g[o+272>>2])*+g[o+544>>2];p=(u*+g[o+280>>2]+v*+g[o+284>>2]+w*+g[o+288>>2])*+g[o+548>>2];l=(u*+g[o+296>>2]+v*+g[o+300>>2]+w*+g[o+304>>2])*+g[o+552>>2]}else{q=0.0;p=0.0;l=0.0}g[n+(B*152|0)+80>>2]=q;g[n+(B*152|0)+84>>2]=p;g[n+(B*152|0)+88>>2]=l;g[n+(B*152|0)+92>>2]=0.0;if(b){s=+g[b+264>>2]*x+ +g[b+268>>2]*y+ +g[b+272>>2]*z;r=+g[b+280>>2]*x+ +g[b+284>>2]*y+ +g[b+288>>2]*z;q=+g[b+296>>2]*x+ +g[b+300>>2]*y+ +g[b+304>>2]*z}else{s=0.0;r=0.0;q=0.0}if(o){p=+g[o+264>>2]*u+ +g[o+268>>2]*v+ +g[o+272>>2]*w;l=u*+g[o+280>>2]+v*+g[o+284>>2]+w*+g[o+288>>2];t=u*+g[o+296>>2]+v*+g[o+300>>2]+w*+g[o+304>>2]}else{p=0.0;l=0.0;t=0.0}s=1.0/(s*x+r*y+q*z+0.0+(p*u+l*v+t*w));g[n+(B*152|0)+108>>2]=s;if(b){p=(+g[h+(e*244|0)+176>>2]+ +g[h+(e*244|0)+208>>2])*0.0+(+g[h+(e*244|0)+180>>2]+ +g[h+(e*244|0)+212>>2])*0.0+(+g[h+(e*244|0)+184>>2]+ +g[h+(e*244|0)+216>>2])*0.0;l=+g[h+(e*244|0)+192>>2];r=+g[h+(e*244|0)+196>>2];q=+g[h+(e*244|0)+200>>2]}else{p=0.0;l=0.0;r=0.0;q=0.0}l=p+(l*x+r*y+q*z);if(!o){r=-0.0;q=0.0;p=0.0;x=0.0;q=q*u;u=p*v;u=q+u;v=x*w;v=u+v;v=r+v;v=l+v;v=0.0-v;v=s*v;e=n+(B*152|0)+112|0;g[e>>2]=v;e=n+(B*152|0)+116|0;g[e>>2]=0.0;v=-A;e=n+(B*152|0)+120|0;g[e>>2]=v;e=n+(B*152|0)+124|0;g[e>>2]=A;i=C;return}r=(+g[h+(f*244|0)+176>>2]+ +g[h+(f*244|0)+208>>2])*-0.0+(+g[h+(f*244|0)+180>>2]+ +g[h+(f*244|0)+212>>2])*-0.0+(+g[h+(f*244|0)+184>>2]+ +g[h+(f*244|0)+216>>2])*-0.0;q=+g[h+(f*244|0)+192>>2];p=+g[h+(f*244|0)+196>>2];x=+g[h+(f*244|0)+200>>2];q=q*u;u=p*v;u=q+u;v=x*w;v=u+v;v=r+v;v=l+v;v=0.0-v;v=s*v;e=n+(B*152|0)+112|0;g[e>>2]=v;e=n+(B*152|0)+116|0;g[e>>2]=0.0;v=-A;e=n+(B*152|0)+120|0;g[e>>2]=v;e=n+(B*152|0)+124|0;g[e>>2]=A;i=C;return}function Rr(a,b,d){a=a|0;b=b|0;d=+d;var e=0,f=0,h=0;f=i;i=i+496|0;e=c[b+212>>2]|0;if((e|0)>-1){i=f;return e|0}h=(c[b+236>>2]&2|0)==0;e=h?0:b;do if(!h){if(!(+g[e+344>>2]!=0.0)?(c[e+204>>2]&2|0)==0:0)break;e=c[a+8>>2]|0;VE(f+244|0,0,244)|0;Nr(_r(a+4|0,f+244|0)|0,b,d);c[b+212>>2]=e;i=f;return e|0}while(0);e=c[a+188>>2]|0;if((e|0)>=0){i=f;return e|0}c[a+188>>2]=c[a+8>>2];VE(f|0,0,244)|0;Nr(_r(a+4|0,f)|0,0,d);e=c[a+188>>2]|0;i=f;return e|0}
function Cq(b){b=b|0;var d=0,e=0.0,f=0.0,h=0.0,j=0,k=0,l=0,m=0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0;m=i;i=i+144|0;if(!(a[b+1308>>0]|0)){i=m;return}g[b+928>>2]=0.0;g[b+992>>2]=0.0;g[b+1056>>2]=0.0;c[b+712>>2]=0;c[b+716>>2]=0;c[b+720>>2]=0;c[b+724>>2]=0;Bq(b,(c[b+28>>2]|0)+4|0,(c[b+32>>2]|0)+4|0);Jb[c[(c[b>>2]|0)+44>>2]&255](b);h=+g[b+1284>>2];f=+g[b+1288>>2];e=+g[b+1292>>2];d=0;do{if(+g[b+(d<<2)+696>>2]>=+g[b+(d<<2)+680>>2]){if(!(a[b+1300>>0]|0)){j=b+(d<<2)+1160|0;k=b+(d<<2)+1144|0;l=b+(d<<2)+1128|0}else{j=b+(d<<2)+1096|0;k=b+(d<<2)+1080|0;l=b+(d<<2)+1064|0}n=+g[j>>2];o=+g[k>>2];g[m>>2]=+g[l>>2];g[m+4>>2]=o;g[m+8>>2]=n;g[m+12>>2]=0.0;k=c[b+28>>2]|0;g[m+96>>2]=+g[k+4>>2];g[m+100>>2]=+g[k+20>>2];g[m+104>>2]=+g[k+36>>2];g[m+108>>2]=0.0;g[m+112>>2]=+g[k+8>>2];g[m+116>>2]=+g[k+24>>2];g[m+120>>2]=+g[k+40>>2];g[m+124>>2]=0.0;g[m+128>>2]=+g[k+12>>2];g[m+132>>2]=+g[k+28>>2];g[m+136>>2]=+g[k+44>>2];g[m+140>>2]=0.0;j=c[b+32>>2]|0;g[m+48>>2]=+g[j+4>>2];g[m+52>>2]=+g[j+20>>2];g[m+56>>2]=+g[j+36>>2];g[m+60>>2]=0.0;g[m+64>>2]=+g[j+8>>2];g[m+68>>2]=+g[j+24>>2];g[m+72>>2]=+g[j+40>>2];g[m+76>>2]=0.0;g[m+80>>2]=+g[j+12>>2];g[m+84>>2]=+g[j+28>>2];g[m+88>>2]=+g[j+44>>2];g[m+92>>2]=0.0;n=f-+g[k+56>>2];o=e-+g[k+60>>2];g[m+32>>2]=h-+g[k+52>>2];g[m+36>>2]=n;g[m+40>>2]=o;g[m+44>>2]=0.0;o=f-+g[j+56>>2];n=e-+g[j+60>>2];g[m+16>>2]=h-+g[j+52>>2];g[m+20>>2]=o;g[m+24>>2]=n;g[m+28>>2]=0.0;Kq(b+(d*84|0)+176|0,m+96|0,m+48|0,m+32|0,m+16|0,m,k+396|0,+g[k+344>>2],j+396|0,+g[j+344>>2])}d=d+1|0}while((d|0)!=3);l=0;do{e=+g[b+(l<<6)+868>>2];f=+g[b+(l<<6)+872>>2];h=+Lq(+g[b+(l<<2)+1192>>2],e,f);g[b+(l<<6)+920>>2]=h;do if(!(e>f)){if(e>h){c[b+(l<<6)+924>>2]=1;d=b+(l<<6)+916|0;g[d>>2]=h-e;if(h-e>3.1415927410125732){g[d>>2]=h-e+-6.2831854820251465;d=24;break}if(!(h-e<-3.1415927410125732)){d=24;break}g[d>>2]=h-e+6.2831854820251465;d=24;break}d=b+(l<<6)+924|0;if(!(f<h)){c[d>>2]=0;d=23;break}c[d>>2]=2;d=b+(l<<6)+916|0;g[d>>2]=h-f;if(h-f>3.1415927410125732){g[d>>2]=h-f+-6.2831854820251465;d=24;break}if(h-f<-3.1415927410125732){g[d>>2]=h-f+6.2831854820251465;d=24}else d=24}else{c[b+(l<<6)+924>>2]=0;d=23}while(0);if((d|0)==23?(d=0,(a[b+(l<<6)+912>>0]|0)!=0):0)d=24;if((d|0)==24){k=b+(l<<4)+1208|0;c[m+0>>2]=c[k+0>>2];c[m+4>>2]=c[k+4>>2];c[m+8>>2]=c[k+8>>2];c[m+12>>2]=c[k+12>>2];k=b+(l*84|0)+428|0;j=c[b+28>>2]|0;K=+g[j+4>>2];J=+g[j+20>>2];I=+g[j+36>>2];G=+g[j+8>>2];F=+g[j+24>>2];E=+g[j+40>>2];C=+g[j+12>>2];B=+g[j+28>>2];A=+g[j+44>>2];d=c[b+32>>2]|0;y=+g[d+4>>2];x=+g[d+20>>2];w=+g[d+36>>2];u=+g[d+8>>2];t=+g[d+24>>2];s=+g[d+40>>2];q=+g[d+12>>2];o=+g[d+28>>2];h=+g[d+44>>2];c[k+0>>2]=0;c[k+4>>2]=0;c[k+8>>2]=0;c[k+12>>2]=0;p=+g[m>>2];n=+g[m+4>>2];f=+g[m+8>>2];g[b+(l*84|0)+444>>2]=K*p+J*n+I*f;g[b+(l*84|0)+448>>2]=G*p+F*n+E*f;g[b+(l*84|0)+452>>2]=C*p+B*n+A*f;g[b+(l*84|0)+456>>2]=0.0;g[b+(l*84|0)+460>>2]=y*-p+x*-n+w*-f;g[b+(l*84|0)+464>>2]=u*-p+t*-n+s*-f;g[b+(l*84|0)+468>>2]=q*-p+o*-n+h*-f;g[b+(l*84|0)+472>>2]=0.0;H=(K*p+J*n+I*f)*+g[j+396>>2];D=(G*p+F*n+E*f)*+g[j+400>>2];z=(C*p+B*n+A*f)*+g[j+404>>2];g[b+(l*84|0)+476>>2]=H;g[b+(l*84|0)+480>>2]=D;g[b+(l*84|0)+484>>2]=z;g[b+(l*84|0)+488>>2]=0.0;v=(y*-p+x*-n+w*-f)*+g[d+396>>2];r=(u*-p+t*-n+s*-f)*+g[d+400>>2];e=(q*-p+o*-n+h*-f)*+g[d+404>>2];g[b+(l*84|0)+492>>2]=v;g[b+(l*84|0)+496>>2]=r;g[b+(l*84|0)+500>>2]=e;g[b+(l*84|0)+504>>2]=0.0;g[b+(l*84|0)+508>>2]=(K*p+J*n+I*f)*H+(G*p+F*n+E*f)*D+(C*p+B*n+A*f)*z+((y*-p+x*-n+w*-f)*v+(u*-p+t*-n+s*-f)*r+(q*-p+o*-n+h*-f)*e)}l=l+1|0}while((l|0)!=3);i=m;return}function Dq(b,d){b=b|0;d=d|0;var e=0,f=0,h=0,j=0.0,k=0.0,l=0.0,m=0,n=0;n=i;if(a[b+1308>>0]|0){c[d>>2]=0;c[d+4>>2]=0;i=n;return}Bq(b,(c[b+28>>2]|0)+4|0,(c[b+32>>2]|0)+4|0);c[d>>2]=0;c[d+4>>2]=6;if((c[b+856>>2]|0)==0?(a[b+788>>0]|0)==0:0){e=0;f=6}else{c[d>>2]=1;c[d+4>>2]=5;e=1;f=5}if(!((c[b+860>>2]|0)==0?(a[b+789>>0]|0)==0:0)){e=e+1|0;c[d>>2]=e;f=f+-1|0;c[d+4>>2]=f}if((c[b+864>>2]|0)==0?(a[b+790>>0]|0)==0:0)m=0;else{e=e+1|0;c[d>>2]=e;f=f+-1|0;c[d+4>>2]=f;m=0}do{j=+g[b+(m<<6)+868>>2];k=+g[b+(m<<6)+872>>2];l=+Lq(+g[b+(m<<2)+1192>>2],j,k);g[b+(m<<6)+920>>2]=l;do if(!(j>k)){if(j>l){c[b+(m<<6)+924>>2]=1;h=b+(m<<6)+916|0;g[h>>2]=l-j;if(l-j>3.1415927410125732){g[h>>2]=l-j+-6.2831854820251465;h=21;break}if(!(l-j<-3.1415927410125732)){h=21;break}g[h>>2]=l-j+6.2831854820251465;h=21;break}h=b+(m<<6)+924|0;if(!(k<l)){c[h>>2]=0;h=20;break}c[h>>2]=2;h=b+(m<<6)+916|0;g[h>>2]=l-k;if(l-k>3.1415927410125732){g[h>>2]=l-k+-6.2831854820251465;h=21;break}if(l-k<-3.1415927410125732){g[h>>2]=l-k+6.2831854820251465;h=21}else h=21}else{c[b+(m<<6)+924>>2]=0;h=20}while(0);if((h|0)==20){h=0;if(a[b+(m<<6)+912>>0]|0)h=21}if((h|0)==21){e=e+1|0;c[d>>2]=e;f=f+-1|0;c[d+4>>2]=f}m=m+1|0}while((m|0)!=3);i=n;return}function Eq(b,d){b=b|0;d=d|0;var e=0,f=0,h=0,j=0,k=0,l=0,m=0;m=i;i=i+16|0;k=c[b+28>>2]|0;l=c[b+32>>2]|0;if(!(a[b+1301>>0]|0)){j=0;e=Fq(b,d,0,k+4|0,l+4|0,k+312|0,l+312|0,k+328|0,l+328|0)|0;do{f=b+(j<<6)+868|0;if(!((c[b+(j<<6)+924>>2]|0)==0?(a[b+(j<<6)+912>>0]|0)==0:0)){h=b+(j<<4)+1208|0;c[m+0>>2]=c[h+0>>2];c[m+4>>2]=c[h+4>>2];c[m+8>>2]=c[h+8>>2];c[m+12>>2]=c[h+12>>2];h=c[b+1304>>2]>>(j*3|0)+9;if(!(h&1))g[b+(j<<6)+896>>2]=+g[c[d+32>>2]>>2];if(!(h&2))g[b+(j<<6)+904>>2]=+g[c[d+32>>2]>>2];if(!(h&4))g[b+(j<<6)+900>>2]=+g[d+4>>2];e=(Gq(b,f,k+4|0,l+4|0,k+312|0,l+312|0,k+328|0,l+328|0,d,e,m,1,0)|0)+e|0}j=j+1|0}while((j|0)!=3);i=m;return}j=0;e=0;do{f=b+(j<<6)+868|0;if(!((c[b+(j<<6)+924>>2]|0)==0?(a[b+(j<<6)+912>>0]|0)==0:0)){h=b+(j<<4)+1208|0;c[m+0>>2]=c[h+0>>2];c[m+4>>2]=c[h+4>>2];c[m+8>>2]=c[h+8>>2];c[m+12>>2]=c[h+12>>2];h=c[b+1304>>2]>>(j*3|0)+9;if(!(h&1))g[b+(j<<6)+896>>2]=+g[c[d+32>>2]>>2];if(!(h&2))g[b+(j<<6)+904>>2]=+g[c[d+32>>2]>>2];if(!(h&4))g[b+(j<<6)+900>>2]=+g[d+4>>2];e=(Gq(b,f,k+4|0,l+4|0,k+312|0,l+312|0,k+328|0,l+328|0,d,e,m,1,0)|0)+e|0}j=j+1|0}while((j|0)!=3);Fq(b,d,e,k+4|0,l+4|0,k+312|0,l+312|0,k+328|0,l+328|0)|0;i=m;return}function Fq(b,d,e,f,h,j,k,l,m){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;k=k|0;l=l|0;m=m|0;var n=0,o=0,p=0,q=0;q=i;i=i+80|0;g[q+76>>2]=0.0;g[q+24>>2]=0.0;g[q+28>>2]=.10000000149011612;g[q+32>>2]=300.0;g[q+16>>2]=1.0;g[q+20>>2]=-1.0;g[q+44>>2]=0.0;g[q+48>>2]=.20000000298023224;g[q+52>>2]=0.0;g[q+56>>2]=0.0;g[q+36>>2]=1.0;g[q+40>>2]=.5;c[q+72>>2]=0;g[q+64>>2]=0.0;a[q+60>>0]=0;p=0;do{n=c[b+(p<<2)+856>>2]|0;o=a[b+p+788>>0]|0;do if(!((n|0)==0&o<<24>>24==0)){g[q+56>>2]=0.0;c[q+72>>2]=n;g[q+68>>2]=+g[b+(p<<2)+840>>2];g[q+64>>2]=+g[b+(p<<2)+824>>2];g[q+36>>2]=+g[b+732>>2];a[q+60>>0]=o;g[q+20>>2]=+g[b+(p<<2)+696>>2];g[q+40>>2]=+g[b+728>>2];g[q+16>>2]=+g[b+(p<<2)+680>>2];g[q+32>>2]=0.0;g[q+28>>2]=+g[b+(p<<2)+808>>2];g[q+24>>2]=+g[b+(p<<2)+792>>2];g[q>>2]=+g[b+(p<<2)+1064>>2];g[q+4>>2]=+g[b+(p<<2)+1080>>2];g[q+8>>2]=+g[b+(p<<2)+1096>>2];g[q+12>>2]=0.0;n=c[b+1304>>2]>>p*3;if(!(n&1))o=c[d+32>>2]|0;else o=b+(p<<2)+740|0;g[q+44>>2]=+g[o>>2];if(!(n&2))o=c[d+32>>2]|0;else o=b+(p<<2)+772|0;g[q+52>>2]=+g[o>>2];if(!(n&4))n=d+4|0;else n=b+(p<<2)+756|0;g[q+48>>2]=+g[n>>2];if(!(a[b+1301>>0]|0)){e=(Gq(b,q+16|0,f,h,j,k,l,m,d,e,q,0,0)|0)+e|0;break}o=p+1|0;if(!(c[b+(((o|0)==3?0:o)<<6)+924>>2]|0))n=1;else n=(c[b+(((p+2|0)%3|0)<<6)+924>>2]|0)==0&1;e=(Gq(b,q+16|0,f,h,j,k,l,m,d,e,q,0,n)|0)+e|0}while(0);p=p+1|0}while((p|0)!=3);i=q;return e|0}function Gq(b,d,e,f,h,j,k,l,m,n,o,p,q){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;k=k|0;l=l|0;m=m|0;n=n|0;o=o|0;p=p|0;q=q|0;var r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0,A=0,B=0,C=0,D=0,E=0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0;D=i;B=$(c[m+24>>2]|0,n)|0;z=a[d+44>>0]|0;C=c[d+56>>2]|0;if(!(z<<24>>24!=0|(C|0)!=0)){m=0;i=D;return m|0}E=c[((p|0)!=0?m+12|0:m+8|0)>>2]|0;n=c[((p|0)!=0?m+20|0:m+16|0)>>2]|0;g[E+(B<<2)>>2]=+g[o>>2];g[E+(B+1<<2)>>2]=+g[o+4>>2];g[E+(B+2<<2)>>2]=+g[o+8>>2];g[n+(B<<2)>>2]=-+g[o>>2];g[n+(B+1<<2)>>2]=-+g[o+4>>2];g[n+(B+2<<2)>>2]=-+g[o+8>>2];do if(!p){s=+g[b+1176>>2];if(!(a[b+1301>>0]|0)){u=s-+g[e+48>>2];s=+g[b+1180>>2]-+g[e+52>>2];r=+g[b+1184>>2]-+g[e+56>>2];y=+g[o+8>>2];v=+g[o+4>>2];t=+g[o>>2];q=c[m+12>>2]|0;g[q+(B<<2)>>2]=s*y-r*v;g[q+(B+1<<2)>>2]=r*t-u*y;g[q+(B+2<<2)>>2]=u*v-s*t;t=+g[b+1176>>2]-+g[f+48>>2];s=+g[b+1180>>2]-+g[f+52>>2];v=+g[b+1184>>2]-+g[f+56>>2];u=+g[o+8>>2];y=+g[o+4>>2];r=+g[o>>2];b=c[m+20>>2]|0;g[b+(B<<2)>>2]=-(s*u-v*y);g[b+(B+1<<2)>>2]=-(v*r-t*u);g[b+(B+2<<2)>>2]=-(t*y-s*r);break}K=s-+g[f+48>>2];I=+g[b+1180>>2]-+g[f+52>>2];G=+g[b+1184>>2]-+g[f+56>>2];J=+g[o>>2];H=+g[o+4>>2];F=+g[o+8>>2];M=+g[b+1112>>2]-+g[e+48>>2];s=+g[b+1116>>2]-+g[e+52>>2];v=+g[b+1120>>2]-+g[e+56>>2];r=+g[d+52>>2]-+g[d+48>>2];L=J*(J*M+H*s+F*v)+J*r-J*(K*J+I*H+G*F);t=H*(J*M+H*s+F*v)+H*r-H*(K*J+I*H+G*F);r=F*(J*M+H*s+F*v)+F*r-F*(K*J+I*H+G*F);y=+g[b+1272>>2];x=+g[b+1276>>2];u=F*(s-H*(J*M+H*s+F*v)+y*t)-H*(v-F*(J*M+H*s+F*v)+y*r);w=J*(v-F*(J*M+H*s+F*v)+y*r)-F*(M-J*(J*M+H*s+F*v)+y*L);v=H*(M-J*(J*M+H*s+F*v)+y*L)-J*(s-H*(J*M+H*s+F*v)+y*t);s=F*(I-H*(K*J+I*H+G*F)-x*t)-H*(G-F*(K*J+I*H+G*F)-x*r);r=J*(G-F*(K*J+I*H+G*F)-x*r)-F*(K-J*(K*J+I*H+G*F)-x*L);t=H*(K-J*(K*J+I*H+G*F)-x*L)-J*(I-H*(K*J+I*H+G*F)-x*t);if(!((a[b+1280>>0]|0)==0|(q|0)!=0)){s=x*s;r=x*r;t=x*t;u=y*u;w=y*w;v=y*v}b=c[m+12>>2]|0;g[b+(B<<2)>>2]=u;g[b+(B+1<<2)>>2]=w;g[b+(B+2<<2)>>2]=v;b=c[m+20>>2]|0;g[b+(B<<2)>>2]=-s;g[b+(B+1<<2)>>2]=-r;g[b+(B+2<<2)>>2]=-t}while(0);if((C|0)!=0?+g[d>>2]==+g[d+4>>2]:0){n=c[m+28>>2]|0;g[n+(B<<2)>>2]=0.0}else A=11;do if((A|0)==11){n=c[m+28>>2]|0;g[n+(B<<2)>>2]=0.0;if(z<<24>>24){g[(c[m+32>>2]|0)+(B<<2)>>2]=+g[d+28>>2];if(C)break;w=+g[d+8>>2];if(p)s=w;else s=-w;t=+g[d+52>>2];u=+g[d>>2];v=+g[d+4>>2];r=+g[m>>2]*+g[d+32>>2];do if(!(u>v))if(!(u==v)){s=s/r;if(s<0.0)if(t>=u&u-s>t){s=(u-t)/s;break}else{s=t<u?0.0:1.0;break}if(s>0.0)if(t<=v&v-s<t){s=(v-t)/s;break}else{s=t>v?0.0:1.0;break}else s=0.0}else s=0.0;else s=1.0;while(0);g[n+(B<<2)>>2]=s*w+ +g[n+(B<<2)>>2];g[(c[m+36>>2]|0)+(B<<2)>>2]=-+g[d+12>>2];g[(c[m+40>>2]|0)+(B<<2)>>2]=+g[d+12>>2]}if(!C){m=1;i=D;return m|0}}while(0);r=+g[m>>2]*+g[d+32>>2]*+g[d+48>>2];f=n+(B<<2)|0;s=+g[f>>2];if(p)s=s-r;else s=r+s;g[f>>2]=s;g[(c[m+32>>2]|0)+(B<<2)>>2]=+g[d+36>>2];if(+g[d>>2]==+g[d+4>>2]){g[(c[m+36>>2]|0)+(B<<2)>>2]=-3402823466385288598117041.0e14;g[(c[m+40>>2]|0)+(B<<2)>>2]=3402823466385288598117041.0e14;m=1;i=D;return m|0}n=(c[m+36>>2]|0)+(B<<2)|0;if((C|0)==1){g[n>>2]=0.0;g[(c[m+40>>2]|0)+(B<<2)>>2]=3402823466385288598117041.0e14}else{g[n>>2]=-3402823466385288598117041.0e14;g[(c[m+40>>2]|0)+(B<<2)>>2]=0.0}s=+g[d+40>>2];if(!(s>0.0)){m=1;i=D;return m|0}if(p){v=+g[o>>2];G=+g[o+4>>2];r=+g[o+8>>2];r=+g[k>>2]*v+ +g[k+4>>2]*G+ +g[k+8>>2]*r-(v*+g[l>>2]+G*+g[l+4>>2]+r*+g[l+8>>2])}else{v=+g[o>>2];G=+g[o+4>>2];r=+g[o+8>>2];r=+g[h>>2]*v+ +g[h+4>>2]*G+ +g[h+8>>2]*r-(v*+g[j>>2]+G*+g[j+4>>2]+r*+g[j+8>>2])}if((C|0)==1){if(!(r<0.0)){m=1;i=D;return m|0}r=-(r*s);if(!(+g[f>>2]<r)){m=1;i=D;return m|0}g[f>>2]=r;m=1;i=D;return m|0}else{if(!(r>0.0)){m=1;i=D;return m|0}r=-(r*s);if(!(+g[f>>2]>r)){m=1;i=D;return m|0}g[f>>2]=r;m=1;i=D;return m|0}return 0}function Hq(a){a=a|0;var b=0.0,d=0.0,e=0.0,f=0.0;b=+g[(c[a+28>>2]|0)+344>>2];d=+g[(c[a+32>>2]|0)+344>>2];if(d==0.0)b=1.0;else b=b/(b+d);f=1.0-b;e=b*+g[a+1116>>2]+f*+g[a+1180>>2];d=b*+g[a+1120>>2]+f*+g[a+1184>>2];g[a+1284>>2]=b*+g[a+1112>>2]+f*+g[a+1176>>2];g[a+1288>>2]=e;g[a+1292>>2]=d;g[a+1296>>2]=0.0;return}function Iq(a,b,d,e){a=a|0;b=b|0;d=+d;e=e|0;var f=0;f=i;if(e>>>0<3)if((b|0)==3){g[a+(e<<2)+740>>2]=d;c[a+1304>>2]=c[a+1304>>2]|1<<e*3;i=f;return}else if((b|0)==2){g[a+(e<<2)+756>>2]=d;c[a+1304>>2]=c[a+1304>>2]|4<<e*3;i=f;return}else if((b|0)==4){g[a+(e<<2)+772>>2]=d;c[a+1304>>2]=c[a+1304>>2]|2<<e*3;i=f;return}else{i=f;return}if((e+-3|0)>>>0>=3){i=f;return}if((b|0)==4){g[a+(e+-3<<6)+904>>2]=d;c[a+1304>>2]=c[a+1304>>2]|2<<e*3;i=f;return}else if((b|0)==2){g[a+(e+-3<<6)+900>>2]=d;c[a+1304>>2]=c[a+1304>>2]|4<<e*3;i=f;return}else if((b|0)==3){g[a+(e+-3<<6)+896>>2]=d;c[a+1304>>2]=c[a+1304>>2]|1<<e*3;i=f;return}else{i=f;return}}function Jq(a,b,c){a=a|0;b=b|0;c=c|0;var d=0.0,e=0;e=i;do if(c>>>0<3)if((b|0)==4){d=+g[a+(c<<2)+772>>2];break}else if((b|0)==3){d=+g[a+(c<<2)+740>>2];break}else if((b|0)==2){d=+g[a+(c<<2)+756>>2];break}else{d=0.0;break}else if((c+-3|0)>>>0<3)if((b|0)==3){d=+g[a+(c+-3<<6)+896>>2];break}else if((b|0)==4){d=+g[a+(c+-3<<6)+904>>2];break}else if((b|0)==2){d=+g[a+(c+-3<<6)+900>>2];break}else{d=0.0;break}else d=0.0;while(0);i=e;return +d}function Kq(a,b,d,e,f,h,i,j,k,l){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;i=i|0;j=+j;k=k|0;l=+l;var m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0;c[a+0>>2]=c[h+0>>2];c[a+4>>2]=c[h+4>>2];c[a+8>>2]=c[h+8>>2];c[a+12>>2]=c[h+12>>2];s=+g[e+4>>2];v=+g[a+8>>2];w=+g[e+8>>2];p=+g[a+4>>2];m=+g[a>>2];r=+g[e>>2];u=(s*v-w*p)*+g[b>>2]+ +g[b+4>>2]*(w*m-v*r)+(p*r-s*m)*+g[b+8>>2];t=(s*v-w*p)*+g[b+16>>2]+(w*m-v*r)*+g[b+20>>2]+(p*r-s*m)*+g[b+24>>2];s=(s*v-w*p)*+g[b+32>>2]+(w*m-v*r)*+g[b+36>>2]+(p*r-s*m)*+g[b+40>>2];g[a+16>>2]=u;g[a+20>>2]=t;g[a+24>>2]=s;g[a+28>>2]=0.0;r=+g[f+4>>2];w=+g[f+8>>2];n=+g[f>>2];q=+g[d>>2]*(r*-v-w*-p)+ +g[d+4>>2]*(w*-m-n*-v)+(n*-p-r*-m)*+g[d+8>>2];o=(r*-v-w*-p)*+g[d+16>>2]+(w*-m-n*-v)*+g[d+20>>2]+(n*-p-r*-m)*+g[d+24>>2];m=(r*-v-w*-p)*+g[d+32>>2]+(w*-m-n*-v)*+g[d+36>>2]+(n*-p-r*-m)*+g[d+40>>2];g[a+32>>2]=q;g[a+36>>2]=o;g[a+40>>2]=m;g[a+44>>2]=0.0;u=+g[i>>2]*u;t=+g[i+4>>2]*t;s=+g[i+8>>2]*s;g[a+48>>2]=u;g[a+52>>2]=t;g[a+56>>2]=s;g[a+60>>2]=0.0;r=+g[k>>2]*q;p=+g[k+4>>2]*o;n=+g[k+8>>2]*m;g[a+64>>2]=r;g[a+68>>2]=p;g[a+72>>2]=n;g[a+76>>2]=0.0;g[a+80>>2]=u*+g[a+16>>2]+t*+g[a+20>>2]+s*+g[a+24>>2]+j+l+(r*q+p*o+n*m);return}function Lq(a,b,c){a=+a;b=+b;c=+c;var d=0.0,e=0.0,f=0;f=i;if(b>=c){d=a;i=f;return +d}if(a<b){d=+SE(b-a,6.2831854820251465);if(!(d<-3.1415927410125732)){if(d>3.1415927410125732)d=d+-6.2831854820251465}else d=d+6.2831854820251465;e=+O(+d);d=+SE(c-a,6.2831854820251465);if(!(d<-3.1415927410125732)){if(d>3.1415927410125732)d=d+-6.2831854820251465}else d=d+6.2831854820251465;if(e<+O(+d)){d=a;i=f;return +d}d=a+6.2831854820251465;i=f;return +d}if(!(a>c)){d=a;i=f;return +d}d=+SE(a-c,6.2831854820251465);if(!(d<-3.1415927410125732)){if(d>3.1415927410125732)d=d+-6.2831854820251465}else d=d+6.2831854820251465;e=+O(+d);d=+SE(a-b,6.2831854820251465);if(!(d<-3.1415927410125732)){if(d>3.1415927410125732)d=d+-6.2831854820251465}else d=d+6.2831854820251465;if(!(+O(+d)<e)){d=a;i=f;return +d}d=a+-6.2831854820251465;i=f;return +d}function Mq(a,b,e){a=a|0;b=b|0;e=e|0;var f=0;f=i;br(a,b,e)|0;g[b+52>>2]=+g[a+48>>2];g[b+56>>2]=+g[a+52>>2];g[b+60>>2]=+g[a+56>>2];g[b+64>>2]=+g[a+60>>2];g[b+68>>2]=+g[a+64>>2];g[b+72>>2]=+g[a+68>>2];g[b+76>>2]=+g[a+72>>2];g[b+80>>2]=+g[a+76>>2];g[b+84>>2]=+g[a+80>>2];g[b+88>>2]=+g[a+84>>2];g[b+92>>2]=+g[a+88>>2];g[b+96>>2]=+g[a+92>>2];g[b+100>>2]=+g[a+96>>2];g[b+104>>2]=+g[a+100>>2];g[b+108>>2]=+g[a+104>>2];g[b+112>>2]=+g[a+108>>2];g[b+116>>2]=+g[a+112>>2];g[b+120>>2]=+g[a+116>>2];g[b+124>>2]=+g[a+120>>2];g[b+128>>2]=+g[a+124>>2];g[b+132>>2]=+g[a+128>>2];g[b+136>>2]=+g[a+132>>2];g[b+140>>2]=+g[a+136>>2];g[b+144>>2]=+g[a+140>>2];g[b+148>>2]=+g[a+144>>2];g[b+152>>2]=+g[a+148>>2];g[b+156>>2]=+g[a+152>>2];g[b+160>>2]=+g[a+156>>2];g[b+164>>2]=+g[a+160>>2];g[b+168>>2]=+g[a+164>>2];g[b+172>>2]=+g[a+168>>2];g[b+176>>2]=+g[a+172>>2];g[b+228>>2]=+g[a+868>>2];g[b+212>>2]=+g[a+872>>2];g[b+196>>2]=+g[a+680>>2];g[b+180>>2]=+g[a+696>>2];g[b+232>>2]=+g[a+932>>2];g[b+216>>2]=+g[a+936>>2];g[b+200>>2]=+g[a+684>>2];g[b+184>>2]=+g[a+700>>2];g[b+236>>2]=+g[a+996>>2];g[b+220>>2]=+g[a+1e3>>2];g[b+204>>2]=+g[a+688>>2];g[b+188>>2]=+g[a+704>>2];c[b+244>>2]=d[a+1300>>0];c[b+248>>2]=d[a+1301>>0];i=f;return 2600}function Nq(a){a=a|0;return 252}function Oq(a){a=a|0;var b=0;b=i;if(!a){i=b;return}c[5110]=(c[5110]|0)+1;RE(c[a+-4>>2]|0);i=b;return}function Pq(b,d){b=b|0;d=d|0;var e=0,f=0.0,h=0.0;e=i;if(a[b+1309>>0]|0){f=(+g[b+1256>>2]-+g[b+1316>>2])*+g[b+1340>>2];g[b+792>>2]=f*(+g[d>>2]*+g[b+1364>>2]/+(c[d+48>>2]|0));f=+O(+f);g[b+808>>2]=f/+g[d>>2]}if(a[b+1310>>0]|0){f=(+g[b+1260>>2]-+g[b+1320>>2])*+g[b+1344>>2];g[b+796>>2]=f*(+g[d>>2]*+g[b+1368>>2]/+(c[d+48>>2]|0));f=+O(+f);g[b+812>>2]=f/+g[d>>2]}if(a[b+1311>>0]|0){f=(+g[b+1264>>2]-+g[b+1324>>2])*+g[b+1348>>2];g[b+800>>2]=f*(+g[d>>2]*+g[b+1372>>2]/+(c[d+48>>2]|0));f=+O(+f);g[b+816>>2]=f/+g[d>>2]}if(a[b+1312>>0]|0){h=-((+g[b+1192>>2]-+g[b+1328>>2])*+g[b+1352>>2]);f=+g[d>>2];g[b+876>>2]=f*+g[b+1376>>2]/+(c[d+48>>2]|0)*h;g[b+880>>2]=+O(+h)/f}if(a[b+1313>>0]|0){h=-((+g[b+1196>>2]-+g[b+1332>>2])*+g[b+1356>>2]);f=+g[d>>2];g[b+940>>2]=f*+g[b+1380>>2]/+(c[d+48>>2]|0)*h;g[b+944>>2]=+O(+h)/f}if(!(a[b+1314>>0]|0)){Eq(b,d);i=e;return}h=-((+g[b+1200>>2]-+g[b+1336>>2])*+g[b+1360>>2]);f=+g[d>>2];g[b+1004>>2]=f*+g[b+1384>>2]/+(c[d+48>>2]|0)*h;g[b+1008>>2]=+O(+h)/f;Eq(b,d);i=e;return}function Qq(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0.0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0;e=i;w=+g[b>>2];v=+g[b+4>>2];u=+g[b+8>>2];t=1.0/+P(+(w*w+v*v+u*u));A=+g[d>>2];z=+g[d+4>>2];y=+g[d+8>>2];x=1.0/+P(+(A*A+z*z+y*y));D=u*t*(z*x)-v*t*(y*x);C=w*t*(y*x)-u*t*(A*x);B=v*t*(A*x)-w*t*(z*x);b=c[a+28>>2]|0;f=+g[b+4>>2];j=+g[b+20>>2];l=+g[b+36>>2];h=+g[b+8>>2];k=+g[b+24>>2];m=+g[b+40>>2];n=+g[b+12>>2];p=+g[b+28>>2];r=+g[b+44>>2];o=-+g[b+52>>2];q=-+g[b+56>>2];s=-+g[b+60>>2];g[a+48>>2]=f*D+C*j+B*l;g[a+52>>2]=A*x*f+z*x*j+y*x*l;g[a+56>>2]=w*t*f+v*t*j+u*t*l;g[a+60>>2]=0.0;g[a+64>>2]=D*h+C*k+B*m;g[a+68>>2]=A*x*h+z*x*k+y*x*m;g[a+72>>2]=w*t*h+v*t*k+u*t*m;g[a+76>>2]=0.0;g[a+80>>2]=D*n+C*p+B*r;g[a+84>>2]=A*x*n+z*x*p+y*x*r;g[a+88>>2]=w*t*n+v*t*p+u*t*r;g[a+92>>2]=0.0;g[a+96>>2]=f*0.0+j*0.0+l*0.0+(f*o+j*q+l*s);g[a+100>>2]=h*0.0+k*0.0+m*0.0+(h*o+k*q+m*s);g[a+104>>2]=n*0.0+p*0.0+r*0.0+(n*o+p*q+r*s);g[a+108>>2]=0.0;b=c[a+32>>2]|0;s=+g[b+4>>2];r=+g[b+20>>2];q=+g[b+36>>2];p=+g[b+8>>2];o=+g[b+24>>2];n=+g[b+40>>2];m=+g[b+12>>2];k=+g[b+28>>2];h=+g[b+44>>2];l=-+g[b+52>>2];j=-+g[b+56>>2];f=-+g[b+60>>2];g[a+112>>2]=D*s+C*r+B*q;g[a+116>>2]=A*x*s+z*x*r+y*x*q;g[a+120>>2]=w*t*s+v*t*r+u*t*q;g[a+124>>2]=0.0;g[a+128>>2]=D*p+C*o+B*n;g[a+132>>2]=A*x*p+z*x*o+y*x*n;g[a+136>>2]=w*t*p+v*t*o+u*t*n;g[a+140>>2]=0.0;g[a+144>>2]=D*m+C*k+B*h;g[a+148>>2]=A*x*m+z*x*k+y*x*h;g[a+152>>2]=w*t*m+v*t*k+u*t*h;g[a+156>>2]=0.0;g[a+160>>2]=s*0.0+r*0.0+q*0.0+(s*l+r*j+q*f);g[a+164>>2]=p*0.0+o*0.0+n*0.0+(p*l+o*j+n*f);g[a+168>>2]=m*0.0+k*0.0+h*0.0+(m*l+k*j+h*f);g[a+172>>2]=0.0;Bq(a,(c[a+28>>2]|0)+4|0,(c[a+32>>2]|0)+4|0);i=e;return}function Rq(a,b,e){a=a|0;b=b|0;e=e|0;var f=0;f=i;Mq(a,b,e)|0;g[b+276>>2]=+g[a+1316>>2];g[b+324>>2]=+g[a+1364>>2];c[b+252>>2]=d[a+1309>>0];g[b+300>>2]=+g[a+1340>>2];g[b+280>>2]=+g[a+1320>>2];g[b+328>>2]=+g[a+1368>>2];c[b+256>>2]=d[a+1310>>0];g[b+304>>2]=+g[a+1344>>2];g[b+284>>2]=+g[a+1324>>2];g[b+332>>2]=+g[a+1372>>2];c[b+260>>2]=d[a+1311>>0];g[b+308>>2]=+g[a+1348>>2];g[b+288>>2]=+g[a+1328>>2];g[b+336>>2]=+g[a+1376>>2];c[b+264>>2]=d[a+1312>>0];g[b+312>>2]=+g[a+1352>>2];g[b+292>>2]=+g[a+1332>>2];g[b+340>>2]=+g[a+1380>>2];c[b+268>>2]=d[a+1313>>0];g[b+316>>2]=+g[a+1356>>2];g[b+296>>2]=+g[a+1336>>2];g[b+344>>2]=+g[a+1384>>2];c[b+272>>2]=d[a+1314>>0];g[b+320>>2]=+g[a+1360>>2];i=f;return 2744}function Sq(a){a=a|0;return 348}function Tq(a){a=a|0;var b=0;b=i;if(!a){i=b;return}c[5110]=(c[5110]|0)+1;RE(c[a+-4>>2]|0);i=b;return}function Uq(a){a=a|0;var b=0,d=0,e=0,f=0,h=0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0;d=i;i=i+144|0;g[a+36>>2]=0.0;c[d+128>>2]=0;c[d+132>>2]=0;c[d+136>>2]=0;c[d+140>>2]=0;b=0;do{e=d+128+(b<<2)|0;g[e>>2]=1.0;f=c[a+28>>2]|0;G=+g[f+4>>2];g[d+80>>2]=G;C=+g[f+20>>2];g[d+84>>2]=C;j=+g[f+36>>2];g[d+88>>2]=j;g[d+92>>2]=0.0;F=+g[f+8>>2];g[d+96>>2]=F;B=+g[f+24>>2];g[d+100>>2]=B;u=+g[f+40>>2];g[d+104>>2]=u;g[d+108>>2]=0.0;E=+g[f+12>>2];g[d+112>>2]=E;A=+g[f+28>>2];g[d+116>>2]=A;n=+g[f+44>>2];g[d+120>>2]=n;g[d+124>>2]=0.0;h=c[a+32>>2]|0;x=+g[h+4>>2];g[d+32>>2]=x;t=+g[h+20>>2];g[d+36>>2]=t;o=+g[h+36>>2];g[d+40>>2]=o;g[d+44>>2]=0.0;w=+g[h+8>>2];g[d+48>>2]=w;s=+g[h+24>>2];g[d+52>>2]=s;m=+g[h+40>>2];g[d+56>>2]=m;g[d+60>>2]=0.0;v=+g[h+12>>2];g[d+64>>2]=v;r=+g[h+28>>2];g[d+68>>2]=r;k=+g[h+44>>2];g[d+72>>2]=k;g[d+76>>2]=0.0;y=+g[a+300>>2];q=+g[a+304>>2];l=+g[a+308>>2];D=+g[f+52>>2];z=+g[f+56>>2];p=+g[f+60>>2];g[d+16>>2]=y*G+q*F+l*E+D-D;g[d+20>>2]=y*C+q*B+l*A+z-z;g[d+24>>2]=y*j+q*u+l*n+p-p;g[d+28>>2]=0.0;p=+g[a+316>>2];n=+g[a+320>>2];l=+g[a+324>>2];u=+g[h+52>>2];q=+g[h+56>>2];j=+g[h+60>>2];g[d>>2]=p*x+n*w+l*v+u-u;g[d+4>>2]=p*t+n*s+l*r+q-q;g[d+8>>2]=p*o+n*m+l*k+j-j;g[d+12>>2]=0.0;h=c[a+28>>2]|0;f=c[a+32>>2]|0;Kq(a+(b*84|0)+48|0,d+80|0,d+32|0,d+16|0,d,d+128|0,h+396|0,+g[h+344>>2],f+396|0,+g[f+344>>2]);g[e>>2]=0.0;b=b+1|0}while((b|0)!=3);i=d;return}function Vq(b,d){b=b|0;d=d|0;b=(a[b+344>>0]|0)==0?3:0;c[d>>2]=b;c[d+4>>2]=b;return}function Wq(a,b){a=a|0;b=b|0;var d=0.0,e=0,f=0.0,h=0,j=0,k=0,l=0,m=0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0;h=i;l=c[a+28>>2]|0;m=c[a+32>>2]|0;e=c[b+8>>2]|0;g[e>>2]=1.0;j=c[b+24>>2]|0;g[e+(j+1<<2)>>2]=1.0;g[e+((j<<1)+2<<2)>>2]=1.0;n=+g[a+300>>2];s=+g[a+304>>2];d=+g[a+308>>2];q=+g[l+4>>2]*n+ +g[l+8>>2]*s+ +g[l+12>>2]*d;o=n*+g[l+20>>2]+s*+g[l+24>>2]+d*+g[l+28>>2];d=n*+g[l+36>>2]+s*+g[l+40>>2]+d*+g[l+44>>2];e=c[b+12>>2]|0;g[e>>2]=0.0;g[e+4>>2]=d;g[e+8>>2]=-o;g[e+12>>2]=0.0;g[e+(j<<2)>>2]=-d;g[e+(j+1<<2)>>2]=0.0;g[e+(j+2<<2)>>2]=q;g[e+(j+3<<2)>>2]=0.0;g[e+(j<<1<<2)>>2]=o;g[e+((j<<1|1)<<2)>>2]=-q;g[e+((j<<1)+2<<2)>>2]=0.0;g[e+((j<<1)+3<<2)>>2]=0.0;e=c[b+16>>2]|0;g[e>>2]=-1.0;g[e+(j+1<<2)>>2]=-1.0;g[e+((j<<1)+2<<2)>>2]=-1.0;s=+g[a+316>>2];n=+g[a+320>>2];f=+g[a+324>>2];r=+g[m+4>>2]*s+ +g[m+8>>2]*n+ +g[m+12>>2]*f;p=s*+g[m+20>>2]+n*+g[m+24>>2]+f*+g[m+28>>2];f=s*+g[m+36>>2]+n*+g[m+40>>2]+f*+g[m+44>>2];j=c[b+20>>2]|0;e=c[b+24>>2]|0;g[j>>2]=0.0;g[j+4>>2]=-f;g[j+8>>2]=p;g[j+12>>2]=0.0;g[j+(e<<2)>>2]=f;g[j+(e+1<<2)>>2]=0.0;g[j+(e+2<<2)>>2]=-r;g[j+(e+3<<2)>>2]=0.0;g[j+(e<<1<<2)>>2]=-p;g[j+((e<<1|1)<<2)>>2]=r;g[j+((e<<1)+2<<2)>>2]=0.0;g[j+((e<<1)+3<<2)>>2]=0.0;j=c[a+332>>2]|0;n=+g[((j&1|0)==0?b+4|0:a+336|0)>>2]*+g[b>>2];k=c[b+28>>2]|0;g[k>>2]=n*(r+ +g[m+52>>2]-q-+g[l+52>>2]);g[k+(e<<2)>>2]=n*(p+ +g[m+56>>2]-o-+g[l+56>>2]);g[k+(e<<1<<2)>>2]=n*(f+ +g[m+60>>2]-d-+g[l+60>>2]);if(j&2){j=c[b+32>>2]|0;g[j>>2]=+g[a+340>>2];g[j+(e<<2)>>2]=+g[a+340>>2];g[j+(e<<1<<2)>>2]=+g[a+340>>2]}f=+g[a+356>>2];if(f>0.0){g[c[b+36>>2]>>2]=-f;g[c[b+40>>2]>>2]=f;d=+g[a+356>>2]}else d=f;if(d>0.0){g[(c[b+36>>2]|0)+(e<<2)>>2]=-f;g[(c[b+40>>2]|0)+(e<<2)>>2]=f;d=+g[a+356>>2]}if(!(d>0.0)){e=a+352|0;d=+g[e>>2];e=b+52|0;g[e>>2]=d;i=h;return}g[(c[b+36>>2]|0)+(e<<1<<2)>>2]=-f;g[(c[b+40>>2]|0)+(e<<1<<2)>>2]=f;e=a+352|0;d=+g[e>>2];e=b+52|0;g[e>>2]=d;i=h;return}function Xq(a,b,d,e){a=a|0;b=b|0;d=+d;e=e|0;var f=0;f=i;if((e|0)!=-1){i=f;return}if((b|0)==2|(b|0)==1){g[a+336>>2]=d;c[a+332>>2]=c[a+332>>2]|1;i=f;return}else if((b|0)==4|(b|0)==3){g[a+340>>2]=d;c[a+332>>2]=c[a+332>>2]|2;i=f;return}else{i=f;return}}function Yq(a,b,c){a=a|0;b=b|0;c=c|0;var d=0.0,e=0;e=i;do if((c|0)==-1)if((b|0)==2|(b|0)==1){d=+g[a+336>>2];break}else if((b|0)==4|(b|0)==3){d=+g[a+340>>2];break}else{d=3402823466385288598117041.0e14;break}else d=3402823466385288598117041.0e14;while(0);i=e;return +d}function Zq(a,b,c){a=a|0;b=b|0;c=c|0;var d=0;d=i;br(a,b,c)|0;g[b+52>>2]=+g[a+300>>2];g[b+56>>2]=+g[a+304>>2];g[b+60>>2]=+g[a+308>>2];g[b+64>>2]=+g[a+312>>2];g[b+68>>2]=+g[a+316>>2];g[b+72>>2]=+g[a+320>>2];g[b+76>>2]=+g[a+324>>2];g[b+80>>2]=+g[a+328>>2];i=d;return 2888}function _q(a){a=a|0;return 84}function $q(a){a=a|0;var b=0;b=i;if(!a){i=b;return}c[5110]=(c[5110]|0)+1;RE(c[a+-4>>2]|0);i=b;return}function ar(){var b=0,d=0.0,e=0.0;b=i;i=i+16|0;if((a[3576]|0)==0?(Xa(3576)|0)!=0:0){c[b+0>>2]=0;c[b+4>>2]=0;c[b+8>>2]=0;c[b+12>>2]=0;tp(2960,0.0,0,0,b);ab(3576)}c[791]=c[791]|1;g[826]=0.0;d=+g[836]*0.0;e=+g[837]*0.0;g[831]=+g[835]*0.0;g[832]=d;g[833]=e;g[834]=0.0;c[839]=0;c[840]=0;c[841]=0;c[842]=0;e=+g[828]*0.0;d=+g[829]*0.0;g[880]=+g[827]*0.0;g[881]=e;g[882]=d;g[883]=0.0;i=b;return}function br(a,b,e){a=a|0;b=b|0;e=e|0;var f=0,h=0,j=0;h=i;c[b>>2]=ec[c[(c[e>>2]|0)+28>>2]&31](e,c[a+28>>2]|0)|0;c[b+4>>2]=ec[c[(c[e>>2]|0)+28>>2]&31](e,c[a+32>>2]|0)|0;f=ec[c[(c[e>>2]|0)+40>>2]&31](e,a)|0;j=ec[c[(c[e>>2]|0)+28>>2]&31](e,f)|0;c[b+8>>2]=j;if(j)Lb[c[(c[e>>2]|0)+48>>2]&127](e,f);c[b+12>>2]=c[a+4>>2];c[b+24>>2]=d[a+21>>0];c[b+40>>2]=c[a+24>>2];g[b+44>>2]=+g[a+16>>2];c[b+48>>2]=d[a+20>>0];c[b+20>>2]=c[a+12>>2];c[b+16>>2]=c[a+8>>2];g[b+28>>2]=+g[a+36>>2];g[b+32>>2]=+g[a+40>>2];c[b+36>>2]=0;f=c[a+28>>2]|0;if((c[f+488>>2]|0)>0){e=0;do{if((c[(c[f+496>>2]|0)+(e<<2)>>2]|0)==(a|0)){c[b+36>>2]=1;f=c[a+28>>2]|0}e=e+1|0}while((e|0)<(c[f+488>>2]|0))}f=c[a+32>>2]|0;if((c[f+488>>2]|0)>0)e=0;else{i=h;return 2928}do{if((c[(c[f+496>>2]|0)+(e<<2)>>2]|0)==(a|0)){c[b+36>>2]=1;f=c[a+32>>2]|0}e=e+1|0}while((e|0)<(c[f+488>>2]|0));i=h;return 2928}function cr(b,d,e){b=b|0;d=d|0;e=e|0;var f=0.0,h=0.0,j=0.0,k=0,l=0.0,m=0.0,n=0.0,o=0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0;k=i;i=i+256|0;if((a[b+180>>0]|0)==0?(a[b+48>>0]|0)!=0:0){ip(k+64|0,e,b+116|0);c[b+824>>2]=c[k+64>>2];c[b+828>>2]=c[k+68>>2];c[b+832>>2]=c[k+72>>2];c[b+836>>2]=c[k+76>>2];c[b+840>>2]=c[k+80>>2];c[b+844>>2]=c[k+84>>2];c[b+848>>2]=c[k+88>>2];c[b+852>>2]=c[k+92>>2];c[b+856>>2]=c[k+96>>2];c[b+860>>2]=c[k+100>>2];c[b+864>>2]=c[k+104>>2];c[b+868>>2]=c[k+108>>2];c[b+872>>2]=c[k+112>>2];c[b+876>>2]=c[k+116>>2];c[b+880>>2]=c[k+120>>2];c[b+884>>2]=c[k+124>>2];ip(k,d,b+52|0);c[b+888>>2]=c[k+0>>2];c[b+892>>2]=c[k+4>>2];c[b+896>>2]=c[k+8>>2];c[b+900>>2]=c[k+12>>2];c[b+904>>2]=c[k+16>>2];c[b+908>>2]=c[k+20>>2];c[b+912>>2]=c[k+24>>2];c[b+916>>2]=c[k+28>>2];c[b+920>>2]=c[k+32>>2];c[b+924>>2]=c[k+36>>2];c[b+928>>2]=c[k+40>>2];c[b+932>>2]=c[k+44>>2];c[b+936>>2]=c[k+48>>2];c[b+940>>2]=c[k+52>>2];c[b+944>>2]=c[k+56>>2];c[b+948>>2]=c[k+60>>2]}else{ip(k+192|0,d,b+52|0);c[b+824>>2]=c[k+192>>2];c[b+828>>2]=c[k+196>>2];c[b+832>>2]=c[k+200>>2];c[b+836>>2]=c[k+204>>2];c[b+840>>2]=c[k+208>>2];c[b+844>>2]=c[k+212>>2];c[b+848>>2]=c[k+216>>2];c[b+852>>2]=c[k+220>>2];c[b+856>>2]=c[k+224>>2];c[b+860>>2]=c[k+228>>2];c[b+864>>2]=c[k+232>>2];c[b+868>>2]=c[k+236>>2];c[b+872>>2]=c[k+240>>2];c[b+876>>2]=c[k+244>>2];c[b+880>>2]=c[k+248>>2];c[b+884>>2]=c[k+252>>2];ip(k+128|0,e,b+116|0);c[b+888>>2]=c[k+128>>2];c[b+892>>2]=c[k+132>>2];c[b+896>>2]=c[k+136>>2];c[b+900>>2]=c[k+140>>2];c[b+904>>2]=c[k+144>>2];c[b+908>>2]=c[k+148>>2];c[b+912>>2]=c[k+152>>2];c[b+916>>2]=c[k+156>>2];c[b+920>>2]=c[k+160>>2];c[b+924>>2]=c[k+164>>2];c[b+928>>2]=c[k+168>>2];c[b+932>>2]=c[k+172>>2];c[b+936>>2]=c[k+176>>2];c[b+940>>2]=c[k+180>>2];c[b+944>>2]=c[k+1