/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.tool;

import com.adobe.epubcheck.api.EPUBProfile;
import com.adobe.epubcheck.api.EpubCheck;
import com.adobe.epubcheck.api.EpubCheckFactory;
import com.adobe.epubcheck.api.MasterReport;
import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.messages.MessageDictionaryDumper;
import com.adobe.epubcheck.nav.NavChecker;
import com.adobe.epubcheck.opf.OPFChecker;
import com.adobe.epubcheck.opf.OPFChecker30;
import com.adobe.epubcheck.opf.ValidationContext;
import com.adobe.epubcheck.ops.OPSChecker;
import com.adobe.epubcheck.overlay.OverlayChecker;
import com.adobe.epubcheck.reporting.CheckingReport;
import com.adobe.epubcheck.util.Archive;
import com.adobe.epubcheck.util.DefaultReportImpl;
import com.adobe.epubcheck.util.EPUBVersion;
import com.adobe.epubcheck.util.FeatureEnum;
import com.adobe.epubcheck.util.FileResourceProvider;
import com.adobe.epubcheck.util.GenericResourceProvider;
import com.adobe.epubcheck.util.InvalidVersionException;
import com.adobe.epubcheck.util.Messages;
import com.adobe.epubcheck.util.OPSType;
import com.adobe.epubcheck.util.URLResourceProvider;
import com.adobe.epubcheck.util.XmlReportImpl;
import com.adobe.epubcheck.util.XmpReportImpl;
import com.adobe.epubcheck.util.outWriter;
import io.mola.galimatias.GalimatiasParseException;
import io.mola.galimatias.URL;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.epubcheck.core.Checker;
import org.w3c.epubcheck.util.url.URLUtils;

public class EpubChecker {
    String path = null;
    String mode = null;
    EPUBProfile profile = null;
    EPUBVersion version = EPUBVersion.VERSION_3;
    boolean expanded = false;
    boolean keep = false;
    boolean jsonOutput = false;
    boolean xmlOutput = false;
    boolean xmpOutput = false;
    File fileOut;
    File listChecksOut;
    File customMessageFile;
    boolean listChecks = false;
    boolean displayHelp = false;
    boolean displayVersion = false;
    boolean useCustomMessageFile = false;
    boolean failOnWarnings = false;
    private Messages messages = Messages.getInstance();
    private Locale locale = Locale.getDefault();
    int reportingLevel = 2;
    private static final HashMap<OPSType, String> modeMimeTypeMap;
    private static final String EPUBCHECK_CUSTOM_MESSAGE_FILE = "ePubCheckCustomMessageFile";

    public Locale getLocale() {
        return this.locale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int run(String[] args) {
        int n;
        Report report = null;
        int returnValue = 1;
        try {
            if (!this.processArguments(args)) return returnValue;
            if (this.displayHelp || this.displayVersion && this.path == null) {
                int n2 = 0;
                if (report == null) return n2;
                this.printEpubCheckCompleted(report);
                return n2;
            }
            report = this.createReport();
            report.initialize();
            if (!this.listChecks) {
                if (this.useCustomMessageFile) {
                    report.setCustomMessageFile(this.customMessageFile.getAbsolutePath());
                }
                returnValue = this.processFile(report);
                int returnValue2 = report.generate();
                if (returnValue != 0) return returnValue;
                returnValue = returnValue2;
                return returnValue;
            }
            this.dumpMessageDictionary(report);
            n = 0;
            if (report == null) return n;
        }
        catch (Exception ignored) {
            returnValue = 1;
            return returnValue;
        }
        this.printEpubCheckCompleted(report);
        return n;
        finally {
            if (report != null) {
                this.printEpubCheckCompleted(report);
            }
        }
    }

    @Deprecated
    public int processEpubFile(String[] args) {
        return this.run(args);
    }

    int validateFile(String path, EPUBVersion version, Report report, EPUBProfile profile) {
        GenericResourceProvider resourceProvider;
        URL url;
        if (path.startsWith("http://") || path.startsWith("https://")) {
            try {
                url = URL.parse((String)path);
                resourceProvider = new URLResourceProvider();
            }
            catch (GalimatiasParseException e) {
                System.err.println(String.format(this.messages.get("file_not_found"), path));
                return 1;
            }
        } else {
            File f = new File(path);
            if (f.exists()) {
                url = URLUtils.toURL(f);
                resourceProvider = new FileResourceProvider(f);
            } else {
                System.err.println(String.format(this.messages.get("file_not_found"), path));
                return 1;
            }
        }
        OPSType opsType = new OPSType(this.mode, version);
        ValidationContext context = new ValidationContext.ValidationContextBuilder().url(url).report(report).resourceProvider(resourceProvider).mimetype(modeMimeTypeMap.get(opsType)).version(version).profile(profile).build();
        Checker checker = null;
        if (this.mode == null) {
            checker = EpubCheckFactory.getInstance().newInstance(context);
        } else {
            switch (this.mode) {
                case "opf": {
                    if (version == EPUBVersion.VERSION_2) {
                        checker = new OPFChecker(context);
                        break;
                    }
                    checker = new OPFChecker30(context);
                    break;
                }
                case "xhtml": 
                case "svg": {
                    checker = new OPSChecker(context);
                    break;
                }
                case "mo": {
                    if (version != EPUBVersion.VERSION_3) break;
                    checker = new OverlayChecker(context);
                    break;
                }
                case "nav": {
                    if (version != EPUBVersion.VERSION_3) break;
                    checker = new NavChecker(context);
                    break;
                }
            }
        }
        if (checker == null) {
            outWriter.println(this.messages.get("display_help"));
            System.err.println(String.format(this.messages.get("mode_version_not_supported"), new Object[]{this.mode, version}));
            throw new RuntimeException(String.format(this.messages.get("mode_version_not_supported"), new Object[]{this.mode, version}));
        }
        if (checker.getClass() == EpubCheck.class) {
            int validationResult = ((EpubCheck)checker).doValidate();
            if (validationResult == 0) {
                if (!this.jsonOutput && !this.xmlOutput && !this.xmpOutput || this.fileOut != null) {
                    outWriter.println(this.messages.get("no_errors__or_warnings"));
                }
                return 0;
            }
            if (validationResult == 1) {
                System.err.println(this.messages.get("there_were_warnings"));
                return this.failOnWarnings ? 1 : 0;
            }
            System.err.println(this.messages.get("there_were_errors"));
            return 1;
        }
        checker.check();
        if (report.getWarningCount() == 0 && report.getFatalErrorCount() == 0 && report.getErrorCount() == 0) {
            if (!this.jsonOutput && !this.xmlOutput && !this.xmpOutput || this.fileOut != null) {
                outWriter.println(this.messages.get("no_errors__or_warnings"));
            }
            return 0;
        }
        if (report.getWarningCount() > 0 && report.getFatalErrorCount() == 0 && report.getErrorCount() == 0) {
            System.err.println(this.messages.get("there_were_warnings"));
            return this.failOnWarnings ? 1 : 0;
        }
        System.err.println(this.messages.get("there_were_errors"));
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int processFile(Report report) {
        report.info(null, FeatureEnum.TOOL_NAME, "epubcheck");
        report.info(null, FeatureEnum.TOOL_VERSION, EpubCheck.version());
        report.info(null, FeatureEnum.TOOL_DATE, EpubCheck.buildDate());
        int result = 0;
        Archive epub = null;
        try {
            if (this.expanded) {
                File f = new File(this.path);
                if (!f.exists()) {
                    System.err.println(String.format(this.messages.get("directory_not_found"), this.path));
                    int n = 1;
                    return n;
                }
                try {
                    epub = new Archive(this.path, true);
                    epub.createArchive();
                    report.setEpubFileName(epub.getEpubFile().getAbsolutePath());
                    this.path = epub.getEpubFile().getAbsolutePath();
                    this.mode = null;
                }
                catch (RuntimeException ex) {
                    System.err.println(this.messages.get("there_were_errors"));
                    int n = 1;
                    report.close();
                    return n;
                }
            }
            if (this.mode != null) {
                report.info(null, FeatureEnum.EXEC_MODE, String.format(this.messages.get("single_file"), new Object[]{this.mode, this.version.toString(), this.profile}));
            }
            result = this.validateFile(this.path, this.version, report, this.profile);
            if (this.expanded && epub != null && (!this.keep || report.getErrorCount() > 0 || report.getFatalErrorCount() > 0)) {
                if (this.keep && (report.getErrorCount() > 0 || report.getFatalErrorCount() > 0)) {
                    System.err.println(this.messages.get("deleting_archive"));
                }
                epub.deleteEpubFile();
            }
            int f = result;
            return f;
        }
        catch (Throwable e) {
            e.printStackTrace();
            int n = 1;
            return n;
        }
        finally {
            report.close();
        }
    }

    private void printEpubCheckCompleted(Report report) {
        if (report != null) {
            String variant;
            int count;
            StringBuilder messageCount = new StringBuilder();
            if (this.reportingLevel <= 5) {
                messageCount.append(this.messages.get("messages") + ": ");
                count = report.getFatalErrorCount();
                variant = count == 0 ? "zero" : (count == 1 ? "one" : "many");
                messageCount.append(String.format(this.messages.get("counter_fatal_" + variant), count));
            }
            if (this.reportingLevel <= 4) {
                count = report.getErrorCount();
                variant = count == 0 ? "zero" : (count == 1 ? "one" : "many");
                messageCount.append(" / " + String.format(this.messages.get("counter_error_" + variant), count));
            }
            if (this.reportingLevel <= 3) {
                count = report.getWarningCount();
                variant = count == 0 ? "zero" : (count == 1 ? "one" : "many");
                messageCount.append(" / " + String.format(this.messages.get("counter_warn_" + variant), count));
            }
            if (this.reportingLevel <= 2) {
                count = report.getInfoCount();
                variant = count == 0 ? "zero" : (count == 1 ? "one" : "many");
                messageCount.append(" / " + String.format(this.messages.get("counter_info_" + variant), count));
            }
            if (this.reportingLevel <= 1) {
                count = report.getUsageCount();
                variant = count == 0 ? "zero" : (count == 1 ? "one" : "many");
                messageCount.append(" / " + String.format(this.messages.get("counter_usage_" + variant), count));
            }
            if (messageCount.length() > 0) {
                messageCount.append("\n");
                outWriter.println(messageCount);
            }
        }
        outWriter.println(this.messages.get("epubcheck_completed"));
        outWriter.setQuiet(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpMessageDictionary(Report report) throws IOException {
        OutputStreamWriter fw = null;
        try {
            fw = this.listChecksOut != null ? new FileWriter(this.listChecksOut) : new OutputStreamWriter(System.out);
            new MessageDictionaryDumper(report.getDictionary()).dump(fw);
        }
        catch (Exception e) {
            if (this.listChecksOut != null) {
                System.err.println(String.format(this.messages.get("error_creating_config_file"), this.listChecksOut.getAbsoluteFile()));
            }
            System.err.println(e.getMessage());
        }
        finally {
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private Report createReport() throws IOException {
        MasterReport report;
        if (this.listChecks) {
            report = new DefaultReportImpl("none");
        } else if (this.jsonOutput | this.xmpOutput | this.xmlOutput) {
            PrintWriter pw = null;
            pw = this.fileOut == null ? new PrintWriter(System.out, true) : new PrintWriter(this.fileOut, "UTF-8");
            report = this.xmlOutput ? new XmlReportImpl(pw, this.path, EpubCheck.version()) : (this.xmpOutput ? new XmpReportImpl(pw, this.path, EpubCheck.version()) : new CheckingReport(pw, this.path));
        } else {
            report = new DefaultReportImpl(this.path);
        }
        report.setReportingLevel(this.reportingLevel);
        report.setLocale(this.locale);
        if (this.useCustomMessageFile) {
            report.setOverrideFile(this.customMessageFile);
        }
        return report;
    }

    private boolean processArguments(String[] args) {
        if (args.length < 1) {
            System.err.println(this.messages.get("argument_needed"));
            return false;
        }
        this.setCustomMessageFileFromEnvironment();
        Pattern argPattern = Pattern.compile("--?(.*)");
        block63: for (int i = 0; i < args.length; ++i) {
            Matcher argMatch = argPattern.matcher(args[i]);
            if (argMatch.matches()) {
                switch (argMatch.group(1)) {
                    case "v": {
                        if (i + 1 < args.length) {
                            if (args[++i].equals("2.0") || args[i].equals("2")) {
                                this.version = EPUBVersion.VERSION_2;
                                break;
                            }
                            if (args[i].equals("3.0") || args[i].equals("3")) {
                                this.version = EPUBVersion.VERSION_3;
                                break;
                            }
                            outWriter.println(this.messages.get("display_help"));
                            throw new RuntimeException(new InvalidVersionException("Version not supported"));
                        }
                        outWriter.println(this.messages.get("display_help"));
                        throw new RuntimeException(this.messages.get("version_argument_expected"));
                    }
                    case "m": 
                    case "mode": {
                        if (i + 1 < args.length) {
                            this.mode = args[++i];
                            this.expanded = this.mode.equals("exp");
                            break;
                        }
                        outWriter.println(this.messages.get("display_help"));
                        throw new RuntimeException(this.messages.get("mode_argument_expected"));
                    }
                    case "p": 
                    case "profile": {
                        if (i + 1 < args.length) {
                            String profileStr = args[++i];
                            try {
                                this.profile = EPUBProfile.valueOf(profileStr.toUpperCase(Locale.ROOT));
                            }
                            catch (IllegalArgumentException e) {
                                System.err.println(this.messages.get("mode_version_ignored", profileStr));
                                this.profile = EPUBProfile.DEFAULT;
                            }
                            break;
                        }
                        outWriter.println(this.messages.get("display_help"));
                        throw new RuntimeException(this.messages.get("profile_argument_expected"));
                    }
                    case "s": 
                    case "save": {
                        this.keep = true;
                        break;
                    }
                    case "o": 
                    case "out": {
                        File pathFile;
                        if (args.length > i + 1 && !args[i + 1].startsWith("-")) {
                            this.fileOut = new File(args[++i]);
                        } else if (args.length > i + 1 && args[i + 1].equalsIgnoreCase("-")) {
                            this.fileOut = null;
                            ++i;
                        } else {
                            pathFile = new File(this.path);
                            this.fileOut = pathFile.isDirectory() ? new File(pathFile.getAbsoluteFile().getParentFile(), pathFile.getName() + "check.xml") : new File(this.path + "check.xml");
                        }
                        this.xmlOutput = true;
                        break;
                    }
                    case "j": 
                    case "json": {
                        File pathFile;
                        if (args.length > i + 1 && !args[i + 1].startsWith("-")) {
                            this.fileOut = new File(args[++i]);
                        } else if (args.length > i + 1 && args[i + 1].equalsIgnoreCase("-")) {
                            this.fileOut = null;
                            ++i;
                        } else {
                            pathFile = new File(this.path);
                            this.fileOut = pathFile.isDirectory() ? new File(pathFile.getAbsoluteFile().getParentFile(), pathFile.getName() + "check.json") : new File(this.path + "check.json");
                        }
                        this.jsonOutput = true;
                        break;
                    }
                    case "x": 
                    case "xmp": {
                        File pathFile;
                        if (args.length > i + 1 && !args[i + 1].startsWith("-")) {
                            this.fileOut = new File(args[++i]);
                        } else if (args.length > i + 1 && args[i + 1].equalsIgnoreCase("-")) {
                            this.fileOut = null;
                            ++i;
                        } else {
                            pathFile = new File(this.path);
                            this.fileOut = pathFile.isDirectory() ? new File(pathFile.getAbsoluteFile().getParentFile(), pathFile.getName() + "check.xmp") : new File(this.path + "check.xmp");
                        }
                        this.xmpOutput = true;
                        break;
                    }
                    case "i": 
                    case "info": {
                        this.reportingLevel = 2;
                        break;
                    }
                    case "f": 
                    case "fatal": {
                        this.reportingLevel = 5;
                        break;
                    }
                    case "e": 
                    case "error": {
                        this.reportingLevel = 4;
                        break;
                    }
                    case "w": 
                    case "warn": {
                        this.reportingLevel = 3;
                        break;
                    }
                    case "u": 
                    case "usage": {
                        this.reportingLevel = 1;
                        break;
                    }
                    case "q": 
                    case "quiet": {
                        outWriter.setQuiet(true);
                        break;
                    }
                    case "failonwarnings": {
                        this.failOnWarnings = true;
                        break;
                    }
                    case "r": 
                    case "redir": {
                        if (i + 1 >= args.length) continue block63;
                        this.fileOut = new File(args[++i]);
                        break;
                    }
                    case "c": 
                    case "customMessages": {
                        if (i + 1 >= args.length) continue block63;
                        String fileName = args[i + 1];
                        if ("none".compareTo(fileName.toLowerCase(Locale.ROOT)) == 0) {
                            this.customMessageFile = null;
                            this.useCustomMessageFile = false;
                            ++i;
                            break;
                        }
                        if (!fileName.startsWith("-")) {
                            this.customMessageFile = new File(fileName);
                            this.useCustomMessageFile = true;
                            ++i;
                            break;
                        }
                        System.err.println(String.format(this.messages.get("expected_message_filename"), fileName));
                        this.displayHelp();
                        return false;
                    }
                    case "l": 
                    case "listChecks": {
                        if (i + 1 < args.length) {
                            this.listChecksOut = !args[i + 1].startsWith("-") ? new File(args[++i]) : null;
                        }
                        this.listChecks = true;
                        break;
                    }
                    case "locale": {
                        if (i + 1 < args.length) {
                            if (args[i + 1].startsWith("-")) {
                                System.err.println(String.format(this.messages.get("incorrect_locale"), args[i + 1]));
                                this.displayHelp();
                                return false;
                            }
                            String langTag = args[++i];
                            this.locale = Locale.forLanguageTag(langTag);
                            this.messages = Messages.getInstance(this.locale);
                            break;
                        }
                        System.err.println(String.format(this.messages.get("missing_locale"), new Object[0]));
                        this.displayHelp();
                        return false;
                    }
                    case "h": 
                    case "?": 
                    case "help": {
                        this.displayHelp();
                        this.displayHelp = true;
                        break;
                    }
                    case "version": {
                        this.displayVersion();
                        this.displayVersion = true;
                        break;
                    }
                    default: {
                        System.err.println(String.format(this.messages.get("unrecognized_argument"), args[i]));
                        this.displayHelp();
                        return false;
                    }
                }
                continue;
            }
            if (this.path == null) {
                this.path = args[i];
                continue;
            }
            System.err.println(String.format(this.messages.get("unrecognized_argument"), args[i]));
            this.displayHelp();
            return false;
        }
        if (this.xmlOutput && this.xmpOutput || this.xmlOutput && this.jsonOutput || this.xmpOutput && this.jsonOutput) {
            System.err.println(this.messages.get("output_type_conflict"));
            return false;
        }
        if (this.path != null) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.path.length(); ++i) {
                if (this.path.charAt(i) == '\\') {
                    sb.append('/');
                    continue;
                }
                sb.append(this.path.charAt(i));
            }
            this.path = sb.toString();
        }
        if (this.path == null) {
            if (this.listChecks || this.displayHelp || this.displayVersion) {
                return true;
            }
            System.err.println(this.messages.get("no_file_specified"));
            return false;
        }
        if (this.path.matches(".+\\.[Ee][Pp][Uu][Bb]")) {
            if (this.mode != null || this.version != EPUBVersion.VERSION_3) {
                System.err.println(this.messages.get("mode_version_ignored"));
                this.mode = null;
            }
        } else if (this.mode == null && this.profile == null) {
            outWriter.println(this.messages.get("mode_required"));
            return false;
        }
        return true;
    }

    private void setCustomMessageFileFromEnvironment() {
        File f;
        Map<String, String> env = System.getenv();
        String customMessageFileName = env.get(EPUBCHECK_CUSTOM_MESSAGE_FILE);
        if (customMessageFileName != null && customMessageFileName.length() > 0 && (f = new File(customMessageFileName)).exists()) {
            this.customMessageFile = f;
            this.useCustomMessageFile = true;
        }
    }

    private void displayHelp() {
        outWriter.println(String.format(this.messages.get("help_text"), EpubCheck.version()));
    }

    private void displayVersion() {
        outWriter.println(String.format(this.messages.get("epubcheck_version_text"), EpubCheck.version()));
    }

    static {
        System.setProperty("java.awt.headless", "true");
        HashMap<OPSType, String> map = new HashMap<OPSType, String>();
        map.put(new OPSType("xhtml", EPUBVersion.VERSION_2), "application/xhtml+xml");
        map.put(new OPSType("xhtml", EPUBVersion.VERSION_3), "application/xhtml+xml");
        map.put(new OPSType("svg", EPUBVersion.VERSION_2), "image/svg+xml");
        map.put(new OPSType("svg", EPUBVersion.VERSION_3), "image/svg+xml");
        map.put(new OPSType("mo", EPUBVersion.VERSION_3), "application/smil+xml");
        map.put(new OPSType("nav", EPUBVersion.VERSION_3), "application/xhtml+xml");
        modeMimeTypeMap = map;
    }
}

