/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.xml.handlers;

import com.adobe.epubcheck.util.EPUBVersion;
import com.adobe.epubcheck.util.ResourceUtil;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.Map;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DefaultResolver
implements EntityResolver {
    private static final Map<String, String> SYSTEM_ID_MAP = new ImmutableMap.Builder().put((Object)"http://openebook.org/dtds/oeb-1.2/oebpkg12.dtd", (Object)ResourceUtil.getResourcePath("schema/20/dtd/oebpkg12.dtd")).put((Object)"http://http://idpf.org/dtds/oeb-1.2/oebpkg12.dtd", (Object)ResourceUtil.getResourcePath("schema/20/dtd/oebpkg12.dtd")).put((Object)"http://openebook.org/dtds/oeb-1.2/oeb12.ent", (Object)ResourceUtil.getResourcePath("schema/20/dtd/oeb12.dtdinc")).put((Object)"http://openebook.org/dtds/oeb-1.2/oebdoc12.dtd", (Object)ResourceUtil.getResourcePath("schema/20/dtd/oebdoc12.dtd")).put((Object)"http://www.idpf.org/dtds/2007/opf.dtd", (Object)ResourceUtil.getResourcePath("schema/20/dtd/opf20.dtd")).put((Object)"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd", (Object)ResourceUtil.getResourcePath("schema/20/dtd/xhtml1-transitional.dtd")).put((Object)"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd", (Object)ResourceUtil.getResourcePath("schema/20/dtd/xhtml1-strict.dtd")).put((Object)"http://www.w3.org/TR/xhtml1/DTD/xhtml-lat1.ent", (Object)ResourceUtil.getResourcePath("schema/20/dtd/xhtml-lat1.dtdinc")).put((Object)"http://www.w3.org/TR/xhtml1/DTD/xhtml-symbol.ent", (Object)ResourceUtil.getResourcePath("schema/20/dtd/xhtml-symbol.dtdinc")).put((Object)"http://www.w3.org/TR/xhtml1/DTD/xhtml-special.ent", (Object)ResourceUtil.getResourcePath("schema/20/dtd/xhtml-special.dtdinc")).put((Object)"http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd", (Object)ResourceUtil.getResourcePath("schema/20/dtd/svg11.dtd")).put((Object)"http://www.daisy.org/z3986/2005/dtbook-2005-2.dtd", (Object)ResourceUtil.getResourcePath("schema/20/dtd/dtbook-2005-2.dtd")).put((Object)"http://www.daisy.org/z3986/2005/ncx-2005-1.dtd", (Object)ResourceUtil.getResourcePath("schema/20/dtd/ncx-2005-1.dtd")).put((Object)"http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd", (Object)ResourceUtil.getResourcePath("schema/20/dtd/xhtml11-ent.dtd")).put((Object)"http://www.w3.org/MarkUp/DTD/xhtml11.dtd", (Object)ResourceUtil.getResourcePath("schema/20/dtd/xhtml11-ent.dtd")).put((Object)"xhtml-lat1.ent", (Object)ResourceUtil.getResourcePath("dtd/xhtml-lat1.dtdinc")).put((Object)"xhtml-symbol.ent", (Object)ResourceUtil.getResourcePath("dtd/xhtml-symbol.dtdinc")).put((Object)"xhtml-special.ent", (Object)ResourceUtil.getResourcePath("dtd/xhtml-special.dtdinc")).build();
    private final EPUBVersion version;

    public DefaultResolver(EPUBVersion version) {
        this.version = version;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        String resourcePath = SYSTEM_ID_MAP.get(systemId);
        if (this.version == EPUBVersion.VERSION_3 || systemId.equals("about:legacy-compat")) {
            return new InputSource(new StringReader(""));
        }
        if (resourcePath != null) {
            InputStream resourceStream = ResourceUtil.getResourceStream(resourcePath);
            InputSource source = new InputSource(resourceStream);
            source.setPublicId(publicId);
            source.setSystemId(systemId);
            return source;
        }
        boolean offline = Boolean.parseBoolean(System.getProperty("epubcheck.offline"));
        if (systemId.startsWith("http") && offline) {
            return new InputSource(new StringReader(""));
        }
        return null;
    }
}

