/*
 * Decompiled with CFR 0.152.
 */
package com.singlestore.jdbc.type;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Point {
    private final double x;
    private final double y;
    private static final Pattern pointPattern = Pattern.compile("^POINT\\((.*) (.*)\\)$");

    public Point(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public Point(String s) throws IllegalArgumentException {
        Matcher m = pointPattern.matcher(s);
        if (!m.matches()) {
            throw new IllegalArgumentException();
        }
        this.x = Double.parseDouble(m.group(1));
        this.y = Double.parseDouble(m.group(2));
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public String toString() {
        return "POINT(" + this.x + " " + this.y + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof Point)) {
            return false;
        }
        return this.toString().equals(o.toString());
    }

    public int hashCode() {
        return Objects.hash(this.x, this.y);
    }
}

