/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.database.spanner;

import java.sql.Connection;
import java.util.List;
import org.flywaydb.core.api.ResourceProvider;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.database.base.BaseDatabaseType;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.jdbc.JdbcConnectionFactory;
import org.flywaydb.core.internal.jdbc.StatementInterceptor;
import org.flywaydb.core.internal.parser.Parser;
import org.flywaydb.core.internal.parser.ParsingContext;
import org.flywaydb.database.spanner.SpannerDatabase;
import org.flywaydb.database.spanner.SpannerParser;

public class SpannerDatabaseType
extends BaseDatabaseType {
    private static final Log LOG = LogFactory.getLog(SpannerDatabaseType.class);

    public String getName() {
        return "Google Cloud Spanner";
    }

    public List<String> getSupportedEngines() {
        return List.of("CloudSpanner");
    }

    public int getNullType() {
        return 0;
    }

    public int getPriority() {
        return -1;
    }

    public boolean supportsReadOnlyTransactions() {
        return true;
    }

    public boolean handlesJDBCUrl(String url) {
        return url.startsWith("jdbc:cloudspanner:") || url.startsWith("jdbc:p6spy:cloudspanner:");
    }

    public String getDriverClass(String url, ClassLoader classLoader) {
        if (url.startsWith("jdbc:p6spy:cloudspanner:")) {
            return "com.p6spy.engine.spy.P6SpyDriver";
        }
        return "com.google.cloud.spanner.jdbc.JdbcDriver";
    }

    public boolean handlesDatabaseProductNameAndVersion(String databaseProductName, String databaseProductVersion, Connection connection) {
        return databaseProductName.contains("Google Cloud Spanner");
    }

    public Database createDatabase(Configuration configuration, JdbcConnectionFactory jdbcConnectionFactory, StatementInterceptor statementInterceptor) {
        return new SpannerDatabase(configuration, jdbcConnectionFactory, statementInterceptor);
    }

    public Parser createParser(Configuration configuration, ResourceProvider resourceProvider, ParsingContext parsingContext) {
        return new SpannerParser(configuration, parsingContext);
    }
}

