/**
 * @license
 * Copyright 2025 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
import type { Config } from '../config/config.js';
import type { FailureKind, FallbackAction, ModelPolicy, ModelPolicyChain } from './modelPolicy.js';
/**
 * Resolves the active policy chain for the given config, ensuring the
 * user-selected active model is represented.
 */
export declare function resolvePolicyChain(config: Config): ModelPolicyChain;
/**
 * Produces the failed policy (if it exists in the chain) and the list of
 * fallback candidates that follow it.
 */
export declare function buildFallbackPolicyContext(chain: ModelPolicyChain, failedModel: string): {
    failedPolicy?: ModelPolicy;
    candidates: ModelPolicy[];
};
export declare function resolvePolicyAction(failureKind: FailureKind, policy: ModelPolicy): FallbackAction;
