/**
 * @license
 * Copyright 2025 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
import type { ExtensionLoader } from '../utils/extensionLoader.js';
import type { Config } from '../config/config.js';
export declare class ContextManager {
    private readonly loadedPaths;
    private readonly config;
    private globalMemory;
    private environmentMemory;
    constructor(config: Config);
    /**
     * Loads the global memory (Tier 1) and returns the formatted content.
     */
    loadGlobalMemory(): Promise<string>;
    /**
     * Loads the environment memory (Tier 2) and returns the formatted content.
     */
    loadEnvironmentMemory(trustedRoots: string[], extensionLoader: ExtensionLoader): Promise<string>;
    /**
     * Discovers and loads context for a specific accessed path (Tier 3 - JIT).
     * Traverses upwards from the accessed path to the project root.
     */
    discoverContext(accessedPath: string, trustedRoots: string[]): Promise<string>;
    getGlobalMemory(): string;
    getEnvironmentMemory(): string;
    private markAsLoaded;
    /**
     * Resets the loaded paths tracking and memory. Useful for testing or full reloads.
     */
    reset(): void;
    getLoadedPaths(): ReadonlySet<string>;
}
