"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.unescape = void 0;
/**
 * Un-escape a string that has been escaped with {@link escape}.
 *
 * If the {@link MinimatchOptions.windowsPathsNoEscape} option is used, then
 * square-bracket escapes are removed, but not backslash escapes.
 *
 * For example, it will turn the string `'[*]'` into `*`, but it will not
 * turn `'\\*'` into `'*'`, because `\` is a path separator in
 * `windowsPathsNoEscape` mode.
 *
 * When `windowsPathsNoEscape` is not set, then both square-bracket escapes and
 * backslash escapes are removed.
 *
 * Slashes (and backslashes in `windowsPathsNoEscape` mode) cannot be escaped
 * or unescaped.
 *
 * When `magicalBraces` is not set, escapes of braces (`{` and `}`) will not be
 * unescaped.
 */
const unescape = (s, { windowsPathsNoEscape = false, magicalBraces = true, } = {}) => {
    if (magicalBraces) {
        return windowsPathsNoEscape
            ? s.replace(/\[([^\/\\])\]/g, '$1')
            : s
                .replace(/((?!\\).|^)\[([^\/\\])\]/g, '$1$2')
                .replace(/\\([^\/])/g, '$1');
    }
    return windowsPathsNoEscape
        ? s.replace(/\[([^\/\\{}])\]/g, '$1')
        : s
            .replace(/((?!\\).|^)\[([^\/\\{}])\]/g, '$1$2')
            .replace(/\\([^\/{}])/g, '$1');
};
exports.unescape = unescape;
//# sourceMappingURL=unescape.js.map