/**
 * @license
 * Copyright 2026 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
import type { HttpHeaders } from '@a2a-js/sdk/client';
import type { A2AAuthProvider, A2AAuthProviderType } from './types.js';
/**
 * Abstract base class for A2A authentication providers.
 */
export declare abstract class BaseA2AAuthProvider implements A2AAuthProvider {
    abstract readonly type: A2AAuthProviderType;
    abstract headers(): Promise<HttpHeaders>;
    private static readonly MAX_AUTH_RETRIES;
    private authRetryCount;
    /**
     * Default: retry on 401/403 with fresh headers.
     * Subclasses with cached tokens must override to force-refresh to avoid infinite retries.
     */
    shouldRetryWithHeaders(_req: RequestInit, res: Response): Promise<HttpHeaders | undefined>;
    initialize(): Promise<void>;
}
