/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.actions;

import docking.DialogComponentProvider;
import docking.widgets.combobox.GhidraComboBox;
import ghidra.program.model.data.AnnotationHandler;
import ghidra.util.HelpLocation;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.JPanel;

class AnnotationHandlerDialog
extends DialogComponentProvider {
    private GhidraComboBox<AnnotationHandler> handlerComboBox;
    private List<AnnotationHandler> handlerList;
    private AnnotationHandler handler;
    private boolean success;

    AnnotationHandlerDialog(List<AnnotationHandler> handlerList) {
        super("Export Format");
        this.handlerList = handlerList;
        this.addWorkPanel(this.create());
        this.addOKButton();
        this.addCancelButton();
        this.setOkEnabled(true);
        this.setHelpLocation(new HelpLocation("DataTypeManagerPlugin", "Export_To"));
        this.setRememberSize(false);
    }

    protected void cancelCallback() {
        this.close();
    }

    protected void okCallback() {
        Object[] objs = this.handlerComboBox.getSelectedObjects();
        if (objs != null && objs.length > 0) {
            this.handler = (AnnotationHandler)objs[0];
        }
        this.success = true;
        this.close();
    }

    JPanel create() {
        JPanel outerPanel = new JPanel(new BorderLayout());
        outerPanel.getAccessibleContext().setAccessibleName("Annotation Handler");
        this.handlerComboBox = new GhidraComboBox(this.handlerList);
        this.handlerComboBox.getAccessibleContext().setAccessibleName("Combo Box");
        outerPanel.add((Component)this.handlerComboBox, "North");
        return outerPanel;
    }

    public AnnotationHandler getHandler() {
        return this.handler;
    }

    public boolean wasSuccessful() {
        return this.success;
    }
}

