/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.omf.omf;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.omf.OmfException;
import ghidra.app.util.bin.format.omf.OmfUtils;
import ghidra.app.util.bin.format.omf.omf.OmfData;
import ghidra.app.util.bin.format.omf.omf.OmfRecordTypes;
import ghidra.program.model.data.DataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class OmfEnumeratedData
extends OmfData {
    private long streamOffset;
    private int streamLength;

    public OmfEnumeratedData(BinaryReader reader) throws IOException {
        super(reader);
    }

    @Override
    public void parseData() throws IOException, OmfException {
        long start = this.dataReader.getPointerIndex();
        this.segmentIndex = OmfUtils.readIndex(this.dataReader);
        this.dataOffset = OmfUtils.readInt2Or4(this.dataReader, this.hasBigFields());
        this.streamOffset = this.dataReader.getPointerIndex();
        this.streamLength = this.getRecordLength() - 1 - (int)(this.streamOffset - start);
    }

    @Override
    public int getLength() {
        return this.streamLength;
    }

    @Override
    public byte[] getByteArray(BinaryReader reader) throws IOException {
        reader.setPointerIndex(this.streamOffset);
        byte[] buffer = reader.readNextByteArray(this.streamLength);
        return buffer;
    }

    @Override
    public boolean isAllZeroes() {
        return false;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        return OmfUtils.toOmfRecordDataType(this, OmfRecordTypes.getName(this.recordType));
    }
}

