/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.demangler;

public class CharacterIterator {
    public static final char DONE = '\uffff';
    private String string;
    private int index;

    public CharacterIterator(String str) {
        this.string = str;
    }

    public String getString() {
        return this.string;
    }

    public int getIndex() {
        return this.index;
    }

    public int getLength() {
        return this.string.length();
    }

    public void setIndex(int index) {
        if (index < 0 || index > this.string.length() - 1) {
            throw new IllegalArgumentException();
        }
        this.index = index;
    }

    public boolean hasNext() {
        return this.index < this.string.length();
    }

    public char peek() {
        try {
            return this.string.charAt(this.index);
        }
        catch (IndexOutOfBoundsException e) {
            return '\uffff';
        }
    }

    public char peek(int lookAhead) {
        try {
            return this.string.charAt(this.index + lookAhead);
        }
        catch (IndexOutOfBoundsException e) {
            return '\uffff';
        }
    }

    public char next() {
        try {
            return this.string.charAt(++this.index);
        }
        catch (IndexOutOfBoundsException e) {
            this.index = this.string.length();
            return '\uffff';
        }
    }

    public char getAndIncrement() {
        try {
            return this.string.charAt(this.index++);
        }
        catch (IndexOutOfBoundsException e) {
            this.index = this.string.length();
            return '\uffff';
        }
    }

    public char previous() {
        try {
            return this.string.charAt(--this.index);
        }
        catch (IndexOutOfBoundsException e) {
            this.index = 0;
            return '\uffff';
        }
    }

    public String nextString(int len) {
        String s = this.string.substring(this.index, this.index + len);
        this.index += len;
        return s;
    }

    public int nextInteger() {
        int origIndex = this.index;
        while (Character.isDigit(this.peek())) {
            this.getAndIncrement();
        }
        if (origIndex == this.index) {
            return this.string.charAt(this.index) - 48;
        }
        String s = this.string.substring(origIndex, this.index);
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            this.index = origIndex;
            throw e;
        }
    }

    public int find(char c) {
        for (int i = this.index; i < this.string.length(); ++i) {
            if (this.string.charAt(i) != c) continue;
            return i;
        }
        return -1;
    }

    public String toString() {
        return "currnt = " + this.peek() + "; next = " + this.peek(1);
    }
}

