/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.base.memsearch.gui;

import ghidra.features.base.memsearch.bytesource.SearchRegion;
import ghidra.features.base.memsearch.format.SearchFormat;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.listing.Program;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class SearchSettings {
    private final SearchFormat searchFormat;
    private final Set<SearchRegion> selectedRegions;
    private final int alignment;
    private final boolean bigEndian;
    private final boolean caseSensitive;
    private final boolean useEscapeSequences;
    private final boolean includeInstructions;
    private final boolean includeDefinedData;
    private final boolean includeUndefinedData;
    private final boolean isDecimalUnsigned;
    private final int decimalByteSize;
    private final Charset charset;

    public SearchSettings() {
        this(SearchFormat.HEX, false, false, false, true, true, true, false, 4, 1, new HashSet<SearchRegion>(), StandardCharsets.US_ASCII);
    }

    private SearchSettings(SearchFormat format, boolean bigEndian, boolean caseSensitive, boolean useEscapeSequences, boolean includeInstructions, boolean includeDefinedData, boolean includeUndefinedData, boolean isDecimalUnsigned, int decimalByteSize, int alignment, Set<SearchRegion> selectedRegions, Charset charset) {
        this.searchFormat = format;
        this.bigEndian = bigEndian;
        this.caseSensitive = caseSensitive;
        this.useEscapeSequences = useEscapeSequences;
        this.includeInstructions = includeInstructions;
        this.includeDefinedData = includeDefinedData;
        this.includeUndefinedData = includeUndefinedData;
        this.alignment = alignment;
        this.decimalByteSize = decimalByteSize;
        this.isDecimalUnsigned = isDecimalUnsigned;
        this.selectedRegions = Collections.unmodifiableSet(new HashSet<SearchRegion>(selectedRegions));
        this.charset = charset;
    }

    public SearchFormat getSearchFormat() {
        return this.searchFormat;
    }

    public SearchSettings withSearchFormat(SearchFormat format) {
        if (this.searchFormat == format) {
            return this;
        }
        return new SearchSettings(format, this.bigEndian, this.caseSensitive, this.useEscapeSequences, this.includeInstructions, this.includeDefinedData, this.includeUndefinedData, this.isDecimalUnsigned, this.decimalByteSize, this.alignment, this.selectedRegions, this.charset);
    }

    public boolean isBigEndian() {
        return this.bigEndian;
    }

    public SearchSettings withBigEndian(boolean isBigEndian) {
        if (this.bigEndian == isBigEndian) {
            return this;
        }
        return new SearchSettings(this.searchFormat, isBigEndian, this.caseSensitive, this.useEscapeSequences, this.includeInstructions, this.includeDefinedData, this.includeUndefinedData, this.isDecimalUnsigned, this.decimalByteSize, this.alignment, this.selectedRegions, this.charset);
    }

    public SearchSettings withStringCharset(Charset stringCharset) {
        if (this.charset == stringCharset) {
            return this;
        }
        return new SearchSettings(this.searchFormat, this.bigEndian, this.caseSensitive, this.useEscapeSequences, this.includeInstructions, this.includeDefinedData, this.includeUndefinedData, this.isDecimalUnsigned, this.decimalByteSize, this.alignment, this.selectedRegions, stringCharset);
    }

    public Charset getStringCharset() {
        return this.charset;
    }

    public boolean useEscapeSequences() {
        return this.useEscapeSequences;
    }

    public SearchSettings withUseEscapeSequence(boolean b) {
        if (this.useEscapeSequences == b) {
            return this;
        }
        return new SearchSettings(this.searchFormat, this.bigEndian, this.caseSensitive, b, this.includeInstructions, this.includeDefinedData, this.includeUndefinedData, this.isDecimalUnsigned, this.decimalByteSize, this.alignment, this.selectedRegions, this.charset);
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public SearchSettings withCaseSensitive(boolean b) {
        if (this.caseSensitive == b) {
            return this;
        }
        return new SearchSettings(this.searchFormat, this.bigEndian, b, this.useEscapeSequences, this.includeInstructions, this.includeDefinedData, this.includeUndefinedData, this.isDecimalUnsigned, this.decimalByteSize, this.alignment, this.selectedRegions, this.charset);
    }

    public boolean isDecimalUnsigned() {
        return this.isDecimalUnsigned;
    }

    public SearchSettings withDecimalUnsigned(boolean b) {
        if (this.isDecimalUnsigned == b) {
            return this;
        }
        return new SearchSettings(this.searchFormat, this.bigEndian, this.caseSensitive, this.useEscapeSequences, this.includeInstructions, this.includeDefinedData, this.includeUndefinedData, b, this.decimalByteSize, this.alignment, this.selectedRegions, this.charset);
    }

    public int getDecimalByteSize() {
        return this.decimalByteSize;
    }

    public SearchSettings withDecimalByteSize(int byteSize) {
        if (this.decimalByteSize == byteSize) {
            return this;
        }
        return new SearchSettings(this.searchFormat, this.bigEndian, this.caseSensitive, this.useEscapeSequences, this.includeInstructions, this.includeDefinedData, this.includeUndefinedData, this.isDecimalUnsigned, byteSize, this.alignment, this.selectedRegions, this.charset);
    }

    public boolean includeInstructions() {
        return this.includeInstructions;
    }

    public SearchSettings withIncludeInstructions(boolean b) {
        if (this.includeInstructions == b) {
            return this;
        }
        return new SearchSettings(this.searchFormat, this.bigEndian, this.caseSensitive, this.useEscapeSequences, b, this.includeDefinedData, this.includeUndefinedData, this.isDecimalUnsigned, this.decimalByteSize, this.alignment, this.selectedRegions, this.charset);
    }

    public boolean includeDefinedData() {
        return this.includeDefinedData;
    }

    public SearchSettings withIncludeDefinedData(boolean b) {
        if (this.includeDefinedData == b) {
            return this;
        }
        return new SearchSettings(this.searchFormat, this.bigEndian, this.caseSensitive, this.useEscapeSequences, this.includeInstructions, b, this.includeUndefinedData, this.isDecimalUnsigned, this.decimalByteSize, this.alignment, this.selectedRegions, this.charset);
    }

    public boolean includeUndefinedData() {
        return this.includeUndefinedData;
    }

    public SearchSettings withIncludeUndefinedData(boolean b) {
        if (this.includeUndefinedData == b) {
            return this;
        }
        return new SearchSettings(this.searchFormat, this.bigEndian, this.caseSensitive, this.useEscapeSequences, this.includeInstructions, this.includeDefinedData, b, this.isDecimalUnsigned, this.decimalByteSize, this.alignment, this.selectedRegions, this.charset);
    }

    public int getAlignment() {
        return this.alignment;
    }

    public SearchSettings withAlignment(int newAlignment) {
        if (this.alignment == newAlignment) {
            return this;
        }
        return new SearchSettings(this.searchFormat, this.bigEndian, this.caseSensitive, this.useEscapeSequences, this.includeInstructions, this.includeDefinedData, this.includeUndefinedData, this.isDecimalUnsigned, this.decimalByteSize, newAlignment, this.selectedRegions, this.charset);
    }

    public Set<SearchRegion> getSelectedMemoryRegions() {
        return this.selectedRegions;
    }

    public SearchSettings withSelectedRegions(Set<SearchRegion> regions) {
        if (this.selectedRegions.equals(regions)) {
            return this;
        }
        return new SearchSettings(this.searchFormat, this.bigEndian, this.caseSensitive, this.useEscapeSequences, this.includeInstructions, this.includeDefinedData, this.includeUndefinedData, this.isDecimalUnsigned, this.decimalByteSize, this.alignment, regions, this.charset);
    }

    public boolean isSelectedRegion(SearchRegion region) {
        return this.selectedRegions.contains(region);
    }

    public SearchSettings withSelectedRegion(SearchRegion region, boolean select) {
        return new SearchSettings(this.searchFormat, this.bigEndian, this.caseSensitive, this.useEscapeSequences, this.includeInstructions, this.includeDefinedData, this.includeUndefinedData, this.isDecimalUnsigned, this.decimalByteSize, this.alignment, SearchSettings.createRegionSet(this.selectedRegions, region, select), this.charset);
    }

    public AddressSet getSearchAddresses(Program program) {
        AddressSet set = new AddressSet();
        for (SearchRegion memoryRegion : this.selectedRegions) {
            set.add(memoryRegion.getAddresses(program));
        }
        return set;
    }

    private static Set<SearchRegion> createRegionSet(Set<SearchRegion> regions, SearchRegion region, boolean select) {
        HashSet<SearchRegion> set = new HashSet<SearchRegion>(regions);
        if (select) {
            set.add(region);
        } else {
            set.remove(region);
        }
        return set;
    }
}

