/*
 * Decompiled with CFR 0.152.
 */
package sarif.managers;

import com.contrastsecurity.sarif.Artifact;
import com.contrastsecurity.sarif.Run;
import com.contrastsecurity.sarif.SarifSchema210;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import ghidra.app.util.Option;
import ghidra.app.util.OptionException;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.importer.MessageLog;
import ghidra.framework.Application;
import ghidra.program.model.address.AddressFormatException;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.CompilerSpecID;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.LanguageID;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.util.GhidraProgramUtilities;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sarif.SarifController;
import sarif.SarifProgramOptions;
import sarif.export.SarifObject;
import sarif.io.SarifGsonIO;
import sarif.io.SarifIO;
import sarif.managers.BookmarksSarifMgr;
import sarif.managers.CodeSarifMgr;
import sarif.managers.CommentsSarifMgr;
import sarif.managers.DataTypesSarifMgr;
import sarif.managers.DefinedDataSarifMgr;
import sarif.managers.EquatesSarifMgr;
import sarif.managers.ExtEntryPointSarifMgr;
import sarif.managers.ExternalLibSarifMgr;
import sarif.managers.FunctionsSarifMgr;
import sarif.managers.MarkupSarifMgr;
import sarif.managers.MemoryMapSarifMgr;
import sarif.managers.ProgramInfo;
import sarif.managers.ProgramTreeSarifMgr;
import sarif.managers.PropertiesSarifMgr;
import sarif.managers.RegisterValuesSarifMgr;
import sarif.managers.RelocationTableSarifMgr;
import sarif.managers.SarifMgr;
import sarif.managers.SymbolTableSarifMgr;
import sarif.model.SarifDataFrame;

public class ProgramSarifMgr {
    private static final String SARIF_URL = "https://schemastore.azurewebsites.net/schemas/json/sarif-2.1.0.json";
    private static final String SARIF_VERSION = "2.1.0";
    private static final int N_MANAGERS = 16;
    private ProgramInfo info;
    private File file;
    private File tempFile;
    private String fileContents;
    private SarifSchema210 sarif;
    private SarifController controller;
    private SarifDataFrame df;
    private SarifMgr[] mgrs;
    private Boolean[] opts;
    private Program program;
    private MessageLog log;
    private SarifProgramOptions options;
    private Map<String, Boolean> keys = new HashMap<String, Boolean>();
    private Writer baseWriter;

    public ProgramSarifMgr(Program program, MessageLog log) {
        this.program = program;
        this.log = log;
        this.options = new SarifProgramOptions();
        this.addManagers();
    }

    public ProgramSarifMgr(Program program, File file, MessageLog log) {
        this(program, log);
        this.file = file;
    }

    public ProgramSarifMgr(ByteProvider bp, MessageLog log) {
        this.options = new SarifProgramOptions();
        this.file = bp.getFSRL() != null && bp.getFSRL().getNestingDepth() == 1 ? new File(bp.getFSRL().getPath()) : bp.getFile();
        this.log = log;
    }

    public ProgramInfo getProgramInfo() throws IOException {
        if (this.info != null) {
            return this.info;
        }
        this.info = new ProgramInfo();
        SarifGsonIO io = new SarifGsonIO();
        this.sarif = this.getSarif(io);
        this.controller = new SarifController(this);
        this.df = new SarifDataFrame(this.sarif, this.controller, true);
        List runs = this.sarif.getRuns();
        Set artifacts = ((Run)runs.get(0)).getArtifacts();
        for (Artifact next : artifacts) {
            Map props = next.getProperties().getAdditionalProperties();
            this.info.imageBase = (String)props.get("imageBase");
        }
        this.info.programName = "";
        this.info.exePath = "";
        this.info.exeFormat = "";
        this.info.user = "";
        this.info.setTool("");
        this.info.timestamp = "";
        this.info.version = "";
        this.info.languageID = new LanguageID(this.df.getSourceLanguage());
        this.info.compilerSpecID = new CompilerSpecID(this.df.getCompiler());
        this.info.processorName = "";
        this.info.family = "";
        this.info.addressModel = "";
        this.info.endian = "";
        return this.info;
    }

    private SarifSchema210 getSarif(SarifIO io) throws IOException {
        return this.file != null ? io.readSarif(this.file) : io.readSarif(this.getFileContents());
    }

    private Writer getWriter() throws IOException {
        return this.file != null ? new FileWriter(this.file) : new StringWriter(1000);
    }

    public void addManagers() {
        int mgrCount = 0;
        this.mgrs = new SarifMgr[17];
        this.opts = new Boolean[17];
        this.mgrs[mgrCount] = new DataTypesSarifMgr(this.program, this.log);
        this.opts[mgrCount++] = this.options.isData();
        this.mgrs[mgrCount] = new MemoryMapSarifMgr(this, this.program, this.log);
        this.opts[mgrCount++] = this.options.isMemoryBlocks();
        this.mgrs[mgrCount] = new RegisterValuesSarifMgr(this.program, this.log);
        this.opts[mgrCount++] = this.options.isRegisters();
        this.mgrs[mgrCount] = new CodeSarifMgr(this.program, this.log);
        this.opts[mgrCount++] = this.options.isInstructions();
        this.mgrs[mgrCount] = new DefinedDataSarifMgr(this.program, this.log);
        this.opts[mgrCount++] = this.options.isData();
        this.mgrs[mgrCount] = new EquatesSarifMgr(this.program, this.log);
        this.opts[mgrCount++] = this.options.isEquates();
        this.mgrs[mgrCount] = new CommentsSarifMgr(this.program, this.log);
        this.opts[mgrCount++] = this.options.isComments();
        this.mgrs[mgrCount] = new PropertiesSarifMgr(this.program, this.log);
        this.opts[mgrCount++] = this.options.isProperties();
        this.mgrs[mgrCount] = new BookmarksSarifMgr(this.program, this.log);
        this.opts[mgrCount++] = this.options.isBookmarks();
        this.mgrs[mgrCount] = new ProgramTreeSarifMgr(this.program, this.log);
        this.opts[mgrCount++] = this.options.isTrees();
        this.mgrs[mgrCount] = new ExtEntryPointSarifMgr(this.program, this.log);
        this.opts[mgrCount++] = this.options.isEntryPoints();
        this.mgrs[mgrCount] = new RelocationTableSarifMgr(this.program, this.log);
        this.opts[mgrCount++] = this.options.isRelocationTable();
        this.mgrs[mgrCount] = new SymbolTableSarifMgr(this.program, this.log, true);
        this.opts[mgrCount++] = this.options.isSymbols();
        this.mgrs[mgrCount] = new ExternalLibSarifMgr(this.program, this.log);
        this.opts[mgrCount++] = this.options.isExternalLibraries();
        this.mgrs[mgrCount] = new FunctionsSarifMgr(this.program, this.log);
        this.opts[mgrCount++] = this.options.isFunctions();
        this.mgrs[mgrCount] = new SymbolTableSarifMgr(this.program, this.log, false);
        this.opts[mgrCount++] = this.options.isSymbols();
        this.mgrs[mgrCount] = new MarkupSarifMgr(this.program, this.log);
        this.opts[mgrCount++] = this.options.isReferences();
        assert (mgrCount == 17);
        Map<String, Boolean> columnKeys = SarifMgr.getColumnKeys();
        for (String k : columnKeys.keySet()) {
            this.keys.put(k, columnKeys.get(k));
        }
    }

    public void setOptions(List<Option> optionList, boolean isAddToProgram) throws OptionException {
        this.options.setOptions(optionList);
        this.options.setAddToProgram(isAddToProgram);
        int mgrCount = 0;
        this.opts = new Boolean[17];
        this.opts[mgrCount++] = this.options.isData();
        this.opts[mgrCount++] = this.options.isMemoryBlocks();
        this.opts[mgrCount++] = this.options.isRegisters();
        this.opts[mgrCount++] = this.options.isInstructions();
        this.opts[mgrCount++] = this.options.isData();
        this.opts[mgrCount++] = this.options.isEquates();
        this.opts[mgrCount++] = this.options.isComments();
        this.opts[mgrCount++] = this.options.isProperties();
        this.opts[mgrCount++] = this.options.isBookmarks();
        this.opts[mgrCount++] = this.options.isTrees();
        this.opts[mgrCount++] = this.options.isEntryPoints();
        this.opts[mgrCount++] = this.options.isRelocationTable();
        this.opts[mgrCount++] = this.options.isSymbols();
        this.opts[mgrCount++] = this.options.isExternalLibraries();
        this.opts[mgrCount++] = this.options.isFunctions();
        this.opts[mgrCount++] = this.options.isSymbols();
        this.opts[mgrCount++] = this.options.isReferences();
        assert (mgrCount == 17);
    }

    public Map<String, Boolean> getKeys() {
        return this.keys;
    }

    public MessageLog read(Program program, TaskMonitor monitor) throws IOException, AddressFormatException {
        if (this.mgrs == null || program != this.program) {
            this.program = program;
            this.addManagers();
        }
        if (this.df == null) {
            SarifGsonIO io = new SarifGsonIO();
            this.sarif = this.getSarif(io);
            this.controller = new SarifController(this);
        }
        this.controller.setProgram(program);
        this.df = new SarifDataFrame(this.sarif, this.controller, false);
        Map<String, List<Map<String, Object>>> tableResults = this.getDataFrame().getTableResultsAsMap();
        this.readResults(monitor, this.options, tableResults);
        this.createDefaultTree(program, this.options);
        if (this.options.isInstructions()) {
            GhidraProgramUtilities.markProgramAnalyzed((Program)program);
        }
        return null;
    }

    public void readResults(TaskMonitor monitor, SarifProgramOptions options, Map<String, List<Map<String, Object>>> tableResults) throws IOException {
        try {
            for (int i = 0; i < this.mgrs.length; ++i) {
                if (!this.opts[i].booleanValue()) continue;
                List<Map<String, Object>> list = tableResults.get(this.mgrs[i].getKey());
                this.mgrs[i].readResults(list, options, monitor);
            }
        }
        catch (Exception e) {
            throw new IOException("SARIF Read Cancelled");
        }
    }

    public static String getStandardName(String name) {
        if (name == null) {
            return "Unknown";
        }
        if (name.toLowerCase().indexOf("portable executable") >= 0 && name.toLowerCase().indexOf("(pe)") >= 0) {
            return "Portable Executable (PE)";
        }
        if (name.toLowerCase().indexOf("(elf)") != -1) {
            return "Executable and Linking Format (ELF)";
        }
        if (name.toLowerCase().indexOf("dos executable") >= 0) {
            return "Old-style DOS Executable (MZ)";
        }
        if (name.toLowerCase().indexOf("new executable") >= 0) {
            return "New Executable (NE)";
        }
        return name;
    }

    private void createDefaultTree(Program program, SarifProgramOptions options) {
        if (options.isAddToProgram()) {
            return;
        }
        Listing listing = program.getListing();
        if (listing.getTreeNames().length == 0) {
            try {
                listing.createRootModule("Program Tree");
            }
            catch (DuplicateNameException e) {
                Msg.debug((Object)this, (Object)"Unable to create default module", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageLog write(Program program, AddressSetView addrSet, TaskMonitor monitor, SarifProgramOptions options) throws IOException, CancelledException {
        MessageLog log = new MessageLog();
        this.baseWriter = this.getWriter();
        JsonWriter writer = new JsonWriter(this.getBaseWriter());
        writer.setIndent("  ");
        Gson gson = new GsonBuilder().setPrettyPrinting().excludeFieldsWithoutExposeAnnotation().serializeNulls().disableHtmlEscaping().create();
        try {
            if (SarifObject.SARIF) {
                JsonObject sarif = new JsonObject();
                JsonArray results = new JsonArray();
                this.writeSarifHeader(program, sarif, results);
                this.writeResults(program, addrSet, results, monitor, log, options);
                monitor.setMessage("Results written...exporting to JSON");
                gson.toJson((JsonElement)sarif, writer);
                monitor.setMessage("JSON completed");
            } else {
                JsonObject json = new JsonObject();
                json.addProperty("name", program.getDomainFile().getName());
                json.addProperty("exe_path", program.getExecutablePath());
                json.addProperty("exe_format", program.getExecutableFormat());
                json.addProperty("image_base", program.getImageBase().toString());
                this.writeInfoSource(json, monitor);
                this.writeProcessor(program, json, monitor);
                JsonArray results = new JsonArray();
                json.add("results", (JsonElement)results);
                this.writeResults(program, addrSet, results, monitor, log, options);
                monitor.setMessage("Results written...exporting to JSON");
                gson.toJson((JsonElement)json, writer);
                monitor.setMessage("JSON completed");
            }
        }
        finally {
            writer.flush();
            writer.close();
        }
        return log;
    }

    private void writeSarifHeader(Program program, JsonObject sarif, JsonArray results) {
        sarif.addProperty("$schema", SARIF_URL);
        sarif.addProperty("version", SARIF_VERSION);
        sarif.add("properties", (JsonElement)new JsonObject());
        JsonArray runs = new JsonArray();
        sarif.add("runs", (JsonElement)runs);
        JsonObject run = new JsonObject();
        runs.add((JsonElement)run);
        this.writeToolInfo(program, run);
        run.add("results", (JsonElement)results);
    }

    private void writeToolInfo(Program program, JsonObject run) {
        JsonObject tool = new JsonObject();
        run.add("tool", (JsonElement)tool);
        JsonObject driver = new JsonObject();
        tool.add("driver", (JsonElement)driver);
        driver.addProperty("name", Application.getName());
        driver.addProperty("version", Application.getApplicationVersion());
        driver.addProperty("informationUri", "https://github.com/NationalSecurityAgency/ghidra");
        JsonArray artifacts = new JsonArray();
        run.add("artifacts", (JsonElement)artifacts);
        JsonObject artifact = new JsonObject();
        artifacts.add((JsonElement)artifact);
        JsonObject location = new JsonObject();
        artifact.add("location", (JsonElement)location);
        location.addProperty("uri", program.getExecutablePath());
        JsonObject properties = new JsonObject();
        artifact.add("properties", (JsonElement)properties);
        JsonObject additionalProperties = new JsonObject();
        properties.add("additionalProperties", (JsonElement)additionalProperties);
        additionalProperties.addProperty("imageBase", program.getImageBase().toString());
        artifact.addProperty("sourceLanguage", program.getLanguageID().getIdAsString());
        JsonObject description = new JsonObject();
        artifact.add("description", (JsonElement)description);
        description.addProperty("text", (String)program.getMetadata().get("Compiler ID"));
    }

    private void writeResults(Program program, AddressSetView addrSet, JsonArray results, TaskMonitor monitor, MessageLog log, SarifProgramOptions options) throws IOException, CancelledException {
        this.writeCodeBlocks(program, addrSet, results, monitor, log, options);
        this.writeComments(program, addrSet, results, monitor, log, options);
        this.writeDataTypes(program, addrSet, results, monitor, log, options);
        this.writeMemoryMap(program, addrSet, results, monitor, log, options);
        this.writeRegisters(program, addrSet, results, monitor, log, options);
        this.writeDefinedData(program, addrSet, results, monitor, log, options);
        this.writeEquates(program, addrSet, results, monitor, log, options);
        this.writeProperties(program, addrSet, results, monitor, log, options);
        this.writeBookmarks(program, addrSet, results, monitor, log, options);
        this.writeTrees(program, addrSet, results, monitor, log, options);
        this.writeEntryPoints(program, addrSet, results, monitor, log, options);
        this.writeRelocations(program, addrSet, results, monitor, log, options);
        this.writeFunctions(program, addrSet, results, monitor, log, options);
        this.writeSymbols(program, addrSet, results, monitor, log, options);
        this.writeReferences(program, addrSet, results, monitor, log, options);
        this.writeExtLibraries(program, addrSet, results, monitor, log, options);
    }

    private void writeCodeBlocks(Program program, AddressSetView addrSet, JsonArray results, TaskMonitor monitor, MessageLog log, SarifProgramOptions options) throws IOException, CancelledException {
        if (options.isInstructions()) {
            CodeSarifMgr mgr = new CodeSarifMgr(program, log);
            mgr.write(results, addrSet, monitor);
        }
    }

    private void writeComments(Program program, AddressSetView addrSet, JsonArray results, TaskMonitor monitor, MessageLog log, SarifProgramOptions options) throws IOException, CancelledException {
        if (options.isComments()) {
            CommentsSarifMgr mgr = new CommentsSarifMgr(program, log);
            mgr.write(results, addrSet, monitor);
        }
    }

    private void writeDataTypes(Program program, AddressSetView addrSet, JsonArray results, TaskMonitor monitor, MessageLog log, SarifProgramOptions options) throws IOException, CancelledException {
        if (options.isData()) {
            DataTypesSarifMgr mgr = new DataTypesSarifMgr(program, log);
            mgr.write(results, monitor);
        }
    }

    private void writeMemoryMap(Program program, AddressSetView addrSet, JsonArray results, TaskMonitor monitor, MessageLog log, SarifProgramOptions options) throws IOException, CancelledException {
        if (options.isMemoryBlocks()) {
            MemoryMapSarifMgr mgr = new MemoryMapSarifMgr(this, program, log);
            String path = this.file != null ? this.file.getAbsolutePath() : this.tempFile.getAbsolutePath();
            mgr.write(results, addrSet, monitor, options.isMemoryContents(), path);
        }
    }

    private void writeEquates(Program program, AddressSetView addrSet, JsonArray results, TaskMonitor monitor, MessageLog log, SarifProgramOptions options) throws IOException, CancelledException {
        if (options.isEquates()) {
            EquatesSarifMgr mgr = new EquatesSarifMgr(program, log);
            mgr.write(results, addrSet, monitor);
        }
    }

    private void writeProperties(Program program, AddressSetView addrSet, JsonArray results, TaskMonitor monitor, MessageLog log, SarifProgramOptions options) throws IOException, CancelledException {
        if (options.isProperties()) {
            PropertiesSarifMgr mgr = new PropertiesSarifMgr(program, log);
            mgr.write(results, addrSet, monitor);
        }
    }

    private void writeBookmarks(Program program, AddressSetView addrSet, JsonArray results, TaskMonitor monitor, MessageLog log, SarifProgramOptions options) throws IOException, CancelledException {
        if (options.isBookmarks()) {
            BookmarksSarifMgr mgr = new BookmarksSarifMgr(program, log);
            mgr.write(results, addrSet, monitor);
        }
    }

    private void writeRegisters(Program program, AddressSetView addrSet, JsonArray results, TaskMonitor monitor, MessageLog log, SarifProgramOptions options) throws IOException, CancelledException {
        if (options.isRegisters()) {
            RegisterValuesSarifMgr mgr = new RegisterValuesSarifMgr(program, log);
            mgr.write(results, addrSet, monitor);
        }
    }

    private void writeTrees(Program program, AddressSetView addrSet, JsonArray results, TaskMonitor monitor, MessageLog log, SarifProgramOptions options) throws IOException, CancelledException {
        if (options.isTrees()) {
            ProgramTreeSarifMgr mgr = new ProgramTreeSarifMgr(program, log);
            mgr.write(results, addrSet, monitor);
        }
    }

    private void writeEntryPoints(Program program, AddressSetView addrSet, JsonArray results, TaskMonitor monitor, MessageLog log, SarifProgramOptions options) throws IOException, CancelledException {
        if (options.isEntryPoints()) {
            ExtEntryPointSarifMgr mgr = new ExtEntryPointSarifMgr(program, log);
            mgr.write(results, addrSet, monitor);
        }
    }

    private void writeRelocations(Program program, AddressSetView addrSet, JsonArray results, TaskMonitor monitor, MessageLog log, SarifProgramOptions options) throws IOException, CancelledException {
        if (options.isRelocationTable()) {
            RelocationTableSarifMgr mgr = new RelocationTableSarifMgr(program, log);
            mgr.write(results, monitor);
        }
    }

    private void writeDefinedData(Program program, AddressSetView addrSet, JsonArray results, TaskMonitor monitor, MessageLog log, SarifProgramOptions options) throws IOException, CancelledException {
        if (options.isData()) {
            DefinedDataSarifMgr mgr = new DefinedDataSarifMgr(program, log);
            mgr.write(results, addrSet, monitor);
        }
    }

    private void writeFunctions(Program program, AddressSetView addrSet, JsonArray results, TaskMonitor monitor, MessageLog log, SarifProgramOptions options) throws IOException, CancelledException {
        if (options.isFunctions()) {
            FunctionsSarifMgr mgr = new FunctionsSarifMgr(program, log);
            mgr.write(results, addrSet, monitor);
        }
    }

    private void writeSymbols(Program program, AddressSetView addrSet, JsonArray results, TaskMonitor monitor, MessageLog log, SarifProgramOptions options) throws IOException, CancelledException {
        if (options.isSymbols()) {
            SymbolTableSarifMgr mgr = new SymbolTableSarifMgr(program, log, true);
            mgr.write(results, addrSet, monitor);
        }
    }

    private void writeReferences(Program program, AddressSetView addrSet, JsonArray results, TaskMonitor monitor, MessageLog log, SarifProgramOptions options) throws IOException, CancelledException {
        if (options.isReferences()) {
            MarkupSarifMgr mgr = new MarkupSarifMgr(program, log);
            mgr.write(results, addrSet, monitor);
        }
    }

    private void writeExtLibraries(Program program, AddressSetView addrSet, JsonArray results, TaskMonitor monitor, MessageLog log, SarifProgramOptions options) throws IOException, CancelledException {
        if (options.isExternalLibraries()) {
            ExternalLibSarifMgr mgr = new ExternalLibSarifMgr(program, log);
            mgr.write(results, monitor);
        }
    }

    private void writeInfoSource(JsonObject json, TaskMonitor monitor) {
        monitor.setMessage("Writing INFO SOURCE ...");
        JsonObject attrs = new JsonObject();
        String user = SystemUtilities.getUserName();
        if (user != null) {
            attrs.addProperty("USER", user);
        }
        attrs.addProperty("TOOL", "Ghidra " + Application.getApplicationVersion());
        attrs.addProperty("TIMESTAMP", new Date().toString());
        json.add("INFO_SOURCE", (JsonElement)attrs);
    }

    private void writeProcessor(Program program, JsonObject json, TaskMonitor monitor) {
        monitor.setMessage("Writing PROCESSOR ...");
        JsonObject attrs = new JsonObject();
        Language language = program.getLanguage();
        CompilerSpec compilerSpec = program.getCompilerSpec();
        attrs.addProperty("NAME", language.getProcessor().toString());
        attrs.addProperty("LANGUAGE_PROVIDER", language.getLanguageID().getIdAsString() + ":" + compilerSpec.getCompilerSpecID().getIdAsString());
        attrs.addProperty("ENDIAN", language.isBigEndian() ? "big" : "little");
        json.add("PROCESSOR", (JsonElement)attrs);
    }

    public File getFile() {
        return this.file;
    }

    public String getDirectory() {
        return this.file != null ? this.file.getParent() : this.tempFile.getParent();
    }

    public SarifDataFrame getDataFrame() {
        return this.df;
    }

    public SarifProgramOptions getOptions() {
        return this.options;
    }

    public String getFileContents() {
        return this.fileContents;
    }

    public void setFileContents(String fileContents) {
        this.fileContents = fileContents;
    }

    public Writer getBaseWriter() {
        return this.baseWriter;
    }

    public void useTempFileForBytes(String tempDir) throws IOException {
        File dir = new File(tempDir);
        String fileName = "SARIF_TEST";
        String suffixName = ".sarif.bytes";
        String filename = fileName + ".";
        this.tempFile = File.createTempFile(filename, suffixName, dir);
        this.tempFile.deleteOnExit();
    }
}

