/*
 * Decompiled with CFR 0.152.
 */
package help.validator.location;

import ghidra.util.exception.AssertException;
import help.validator.location.HelpModuleLocation;
import help.validator.model.GhidraTOCFile;
import java.io.File;
import java.nio.file.Path;
import javax.help.HelpSet;

public class DirectoryHelpModuleLocation
extends HelpModuleLocation {
    public DirectoryHelpModuleLocation(File file) {
        super(file.toPath());
    }

    @Override
    public boolean isHelpInputSource() {
        return true;
    }

    @Override
    public HelpSet loadHelpSet() {
        return null;
    }

    @Override
    public GhidraTOCFile loadSourceTOCFile() {
        Path sourceTocPath = this.helpDir.resolve("TOC_Source.xml");
        try {
            return GhidraTOCFile.createGhidraTOCFile(sourceTocPath);
        }
        catch (Exception e) {
            throw new AssertException("Unexpected error loading source TOC file!: " + String.valueOf(sourceTocPath), (Throwable)e);
        }
    }
}

