/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.docking.settings.Settings;
import ghidra.program.model.data.Array;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.TypeDef;
import ghidra.util.exception.DuplicateNameException;

public interface DataTypeComponent {
    public static final String DEFAULT_FIELD_NAME_PREFIX = "field";

    public DataType getDataType();

    public DataType getParent();

    public boolean isBitFieldComponent();

    public boolean isZeroBitFieldComponent();

    public int getOrdinal();

    public int getOffset();

    public int getEndOffset();

    public int getLength();

    public String getComment();

    public Settings getDefaultSettings();

    public void setComment(String var1);

    public String getFieldName();

    public void setFieldName(String var1) throws DuplicateNameException;

    default public String getDefaultFieldName() {
        if (this.isZeroBitFieldComponent()) {
            return null;
        }
        String name = DEFAULT_FIELD_NAME_PREFIX + this.getOrdinal();
        if (this.getParent() instanceof Structure) {
            name = name + "_0x" + Integer.toHexString(this.getOffset());
        }
        return name;
    }

    default public boolean isDefaultFieldName(String s) {
        if (this.isZeroBitFieldComponent()) {
            return false;
        }
        Object offset = "";
        if (this.getParent() instanceof Structure) {
            offset = (String)offset + "_0x" + Integer.toHexString(this.getOffset());
        }
        String newStyleName = DEFAULT_FIELD_NAME_PREFIX + this.getOrdinal() + (String)offset;
        String oldStyleName = DEFAULT_FIELD_NAME_PREFIX + (String)offset;
        return newStyleName.equals(s) || oldStyleName.equals(s);
    }

    public boolean isEquivalent(DataTypeComponent var1);

    public static boolean usesZeroLengthComponent(DataType dataType) {
        if (dataType.isZeroLength()) {
            if (dataType instanceof TypeDef) {
                dataType = ((TypeDef)dataType).getBaseDataType();
            }
            if (dataType instanceof Array) {
                return true;
            }
            return !dataType.isNotYetDefined();
        }
        return false;
    }

    public boolean isUndefined();
}

