/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.lang;

import ghidra.program.model.lang.CompilerSpecDescription;
import ghidra.program.model.lang.CompilerSpecID;
import ghidra.program.model.lang.CompilerSpecNotFoundException;
import ghidra.program.model.lang.Endian;
import ghidra.program.model.lang.LanguageDescription;
import ghidra.program.model.lang.LanguageID;
import ghidra.program.model.lang.Processor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class BasicLanguageDescription
implements LanguageDescription {
    private final LanguageID languageId;
    private final Processor processor;
    private final Endian endian;
    private final Endian instructionEndian;
    private final int size;
    private final String variant;
    private final String description;
    private final int version;
    private final int minorVersion;
    private final boolean deprecated;
    private final LinkedHashMap<CompilerSpecID, CompilerSpecDescription> compatibleCompilerSpecs;
    private final Map<String, List<String>> externalNames;

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.languageId == null ? 0 : this.languageId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LanguageDescription)) {
            return false;
        }
        LanguageDescription other = (LanguageDescription)obj;
        if (this.languageId == null) {
            return other.getLanguageID() == null;
        }
        return this.languageId.equals(other.getLanguageID());
    }

    public BasicLanguageDescription(LanguageID id, Processor processor, Endian endian, Endian instructionEndian, int size, String variant, String description, int version, int minorVersion, boolean deprecated, CompilerSpecDescription compilerSpec, Map<String, List<String>> externalNames) {
        this(id, processor, endian, instructionEndian, size, variant, description, version, minorVersion, deprecated, Collections.singletonList(compilerSpec), externalNames);
    }

    public BasicLanguageDescription(LanguageID id, Processor processor, Endian endian, Endian instructionEndian, int size, String variant, String description, int version, int minorVersion, boolean deprecated, List<CompilerSpecDescription> compilerSpecs, Map<String, List<String>> externalNames) {
        this.description = description;
        this.endian = endian;
        this.minorVersion = minorVersion;
        this.version = version;
        this.processor = processor;
        this.size = size;
        this.variant = variant;
        this.deprecated = deprecated;
        this.languageId = id;
        this.instructionEndian = instructionEndian;
        this.compatibleCompilerSpecs = new LinkedHashMap();
        for (CompilerSpecDescription compilerSpecDescription : compilerSpecs) {
            this.compatibleCompilerSpecs.put(compilerSpecDescription.getCompilerSpecID(), compilerSpecDescription);
        }
        this.externalNames = externalNames;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Endian getEndian() {
        return this.endian;
    }

    @Override
    public Endian getInstructionEndian() {
        return this.instructionEndian;
    }

    @Override
    public LanguageID getLanguageID() {
        return this.languageId;
    }

    @Override
    public int getMinorVersion() {
        return this.minorVersion;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public Processor getProcessor() {
        return this.processor;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public String getVariant() {
        return this.variant;
    }

    @Override
    public boolean isDeprecated() {
        return this.deprecated;
    }

    public List<CompilerSpecDescription> getCompatibleCompilerSpecDescriptions() {
        return new ArrayList<CompilerSpecDescription>(this.compatibleCompilerSpecs.values());
    }

    @Override
    public CompilerSpecDescription getCompilerSpecDescriptionByID(CompilerSpecID compilerSpecID) throws CompilerSpecNotFoundException {
        CompilerSpecDescription compilerSpecDescription = this.compatibleCompilerSpecs.get(compilerSpecID);
        if (compilerSpecDescription == null) {
            throw new CompilerSpecNotFoundException(this.getLanguageID(), compilerSpecID);
        }
        return compilerSpecDescription;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.processor);
        sb.append("/");
        sb.append((Object)this.endian);
        sb.append("/");
        sb.append(this.size);
        sb.append("/");
        sb.append(this.variant);
        return sb.toString();
    }

    @Override
    public List<String> getExternalNames(String key) {
        List<String> localResults;
        ArrayList<String> result = null;
        if (key != null && this.externalNames != null && (localResults = this.externalNames.get(key)) != null) {
            result = new ArrayList<String>(localResults);
        }
        return result;
    }
}

