/*
 * Decompiled with CFR 0.152.
 */
package generic.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;

public class FileChannelLock {
    private final File lockFile;
    private FileOutputStream out;
    private FileChannel fc;
    private FileLock lock;
    private boolean isLocked;

    public FileChannelLock(File lockFile) {
        this.lockFile = new File(lockFile.getAbsolutePath() + "~");
    }

    boolean lock() {
        try {
            this.out = new FileOutputStream(this.lockFile, true);
            this.fc = this.out.getChannel();
            this.lock = this.fc.tryLock();
            boolean bl = this.isLocked = this.lock != null;
            if (!this.isLocked) {
                this.release();
            }
            return this.isLocked;
        }
        catch (IOException | OverlappingFileLockException e) {
            this.release();
            return false;
        }
    }

    void release() {
        if (this.lock != null) {
            try {
                this.lock.release();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.fc != null) {
            try {
                this.fc.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.out != null) {
            try {
                this.out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.isLocked) {
            this.lockFile.delete();
        }
    }
}

