/*
 * Decompiled with CFR 0.152.
 */
package ghidra.net;

import generic.random.SecureRandomFactory;
import ghidra.framework.ModuleInitializer;
import ghidra.net.DefaultKeyManagerFactory;
import ghidra.net.DefaultTrustManagerFactory;
import ghidra.net.HttpClients;
import ghidra.util.Msg;
import java.security.SecureRandom;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.X509ExtendedKeyManager;

public class DefaultSSLContextInitializer
implements ModuleInitializer {
    private static final String DEFAULT_SSL_PROTOCOL = "TLS";
    private static SSLContext sslContext;

    public static synchronized boolean initialize(boolean reset) {
        if (reset) {
            sslContext = null;
            DefaultTrustManagerFactory.invalidateTrustManagers();
            DefaultKeyManagerFactory.invalidateKeyManager();
        }
        return DefaultSSLContextInitializer.initialize();
    }

    public static synchronized boolean initialize() {
        if (sslContext != null) {
            SSLContext.setDefault(sslContext);
            return true;
        }
        Msg.info(DefaultSSLContextInitializer.class, (Object)"Initializing SSL Context");
        X509ExtendedKeyManager keyManager = DefaultKeyManagerFactory.getKeyManager();
        try {
            sslContext = SSLContext.getInstance(DEFAULT_SSL_PROTOCOL);
            SecureRandom random = SecureRandomFactory.getSecureRandom();
            sslContext.init(new KeyManager[]{keyManager}, DefaultTrustManagerFactory.getTrustManagers(), random);
            SSLContext.setDefault(sslContext);
            HostnameVerifier originalVerifier = HttpsURLConnection.getDefaultHostnameVerifier();
            if (!(originalVerifier instanceof HttpsHostnameVerifier)) {
                HttpsURLConnection.setDefaultHostnameVerifier(new HttpsHostnameVerifier());
            }
            HttpsURLConnection.setDefaultSSLSocketFactory(sslContext.getSocketFactory());
            HttpClients.clearHttpClient();
            return true;
        }
        catch (Exception e) {
            Msg.error(DefaultSSLContextInitializer.class, (Object)("SSL Context initialization failed: " + e.getMessage()), (Throwable)e);
            return false;
        }
    }

    @Override
    public void run() {
        DefaultSSLContextInitializer.initialize();
    }

    @Override
    public String getName() {
        return "SSL Context";
    }

    public static class HttpsHostnameVerifier
    implements HostnameVerifier {
        @Override
        public boolean verify(String hostname, SSLSession session) {
            return false;
        }
    }
}

