/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UserSearchUtils {
    public static final String STAR = "*";
    private static final char[] GLOB_CHARACTERS = new char[]{'*', '?'};
    public static final Pattern NON_GLOB_BACKSLASH_PATTERN = Pattern.compile("\\\\(?![\\*\\?])");
    private static final Pattern STAR_PATTERN = Pattern.compile("(?<!\\\\)\\*");
    private static final Pattern QUESTION_PATTERN = Pattern.compile("(?<!\\\\)\\?");
    static final int CASE_SENSITIVE = 0;

    public static Pattern createSearchPattern(String input, boolean caseSensitive) {
        int options = 0;
        if (!caseSensitive) {
            options |= 2;
        }
        Pattern p = UserSearchUtils.createPattern(input, true, options);
        return p;
    }

    public static Pattern createLiteralSearchPattern(String text) {
        Pattern p = UserSearchUtils.createPattern(text, false, 0);
        return p;
    }

    public static Pattern createStartsWithPattern(String input, boolean allowGlobbing, int options) {
        Pattern wildCardPattern = UserSearchUtils.createSingleStarPattern(input, allowGlobbing, options);
        if (wildCardPattern != null) {
            return wildCardPattern;
        }
        String converted = UserSearchUtils.convertUserInputToRegex(input, allowGlobbing);
        Pattern p = Pattern.compile(converted + ".*", options);
        return p;
    }

    public static Pattern createEndsWithPattern(String input, boolean allowGlobbing, int options) {
        Pattern wildCardPattern = UserSearchUtils.createSingleStarPattern(input, allowGlobbing, options);
        if (wildCardPattern != null) {
            return wildCardPattern;
        }
        String converted = UserSearchUtils.convertUserInputToRegex(input, allowGlobbing);
        Pattern p = Pattern.compile(".*" + converted, options);
        return p;
    }

    public static Pattern createContainsPattern(String input, boolean allowGlobbing, int options) {
        Pattern wildCardPattern = UserSearchUtils.createSingleStarPattern(input, allowGlobbing, options);
        if (wildCardPattern != null) {
            return wildCardPattern;
        }
        String converted = UserSearchUtils.convertUserInputToRegex(input, allowGlobbing);
        Pattern p = Pattern.compile(".*" + converted + ".*", options);
        return p;
    }

    public static Pattern createPattern(String input, boolean allowGlobbing, int options) {
        Pattern wildCardPattern = UserSearchUtils.createSingleStarPattern(input, allowGlobbing, options);
        if (wildCardPattern != null) {
            return wildCardPattern;
        }
        String converted = UserSearchUtils.convertUserInputToRegex(input, allowGlobbing);
        Pattern p = Pattern.compile(converted, options);
        return p;
    }

    public static String createPatternString(String input, boolean allowGlobbing) {
        String wildCardPatternString = UserSearchUtils.createSingleStarPatternString(input, allowGlobbing);
        if (wildCardPatternString != null) {
            return wildCardPatternString;
        }
        String converted = UserSearchUtils.convertUserInputToRegex(input, allowGlobbing);
        return converted;
    }

    private static Pattern createSingleStarPattern(String input, boolean allowGlobbing, int options) {
        if (allowGlobbing && input.equals(STAR)) {
            return Pattern.compile(".+", options);
        }
        return null;
    }

    private static String createSingleStarPatternString(String input, boolean allowGlobbing) {
        if (allowGlobbing && input.equals(STAR)) {
            return ".+";
        }
        return null;
    }

    public static String convertUserInputToRegex(String input, boolean allowGlobbing) {
        String escaped = input;
        if (allowGlobbing) {
            escaped = UserSearchUtils.escapeNonGlobbingRegexCharacters(escaped);
            escaped = UserSearchUtils.convertGlobbingCharactersToRegex(escaped);
        } else {
            escaped = UserSearchUtils.escapeAllRegexCharacters(escaped);
        }
        return escaped;
    }

    private static String convertGlobbingCharactersToRegex(String input) {
        Matcher questionMatcher = QUESTION_PATTERN.matcher(input);
        String questionReplaced = questionMatcher.replaceAll(".");
        Matcher starMatcher = STAR_PATTERN.matcher(questionReplaced);
        String starReplaced = starMatcher.replaceAll(".*?");
        return starReplaced;
    }

    static String escapeAllRegexCharacters(String input) {
        return Pattern.quote(input);
    }

    public static String escapeNonGlobbingRegexCharacters(String input) {
        return UserSearchUtils.escapeSomeRegexCharacters(input, GLOB_CHARACTERS);
    }

    static String escapeSomeRegexCharacters(String input, char[] doNotEscape) {
        Matcher backslashMatcher = NON_GLOB_BACKSLASH_PATTERN.matcher(input);
        String updated = backslashMatcher.replaceAll("\\\\\\\\");
        StringBuilder buffy = new StringBuilder();
        block16: for (int i = 0; i < updated.length(); ++i) {
            char c = updated.charAt(i);
            if (UserSearchUtils.contains(doNotEscape, c)) {
                buffy.append(c);
                continue;
            }
            switch (c) {
                case '^': {
                    buffy.append("\\^");
                    continue block16;
                }
                case '.': {
                    buffy.append("\\.");
                    continue block16;
                }
                case '$': {
                    buffy.append("\\$");
                    continue block16;
                }
                case '(': {
                    buffy.append("\\(");
                    continue block16;
                }
                case ')': {
                    buffy.append("\\)");
                    continue block16;
                }
                case '[': {
                    buffy.append("\\[");
                    continue block16;
                }
                case ']': {
                    buffy.append("\\]");
                    continue block16;
                }
                case '+': {
                    buffy.append("\\+");
                    continue block16;
                }
                case '&': {
                    buffy.append("\\&");
                    continue block16;
                }
                case '{': {
                    buffy.append("\\{");
                    continue block16;
                }
                case '}': {
                    buffy.append("\\}");
                    continue block16;
                }
                case '*': {
                    buffy.append("\\*");
                    continue block16;
                }
                case '?': {
                    buffy.append("\\?");
                    continue block16;
                }
                case '|': {
                    buffy.append("\\|");
                    continue block16;
                }
                default: {
                    buffy.append(c);
                }
            }
        }
        return buffy.toString();
    }

    private static boolean contains(char[] array, char c) {
        for (char next : array) {
            if (next != c) continue;
            return true;
        }
        return false;
    }
}

