/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table;

import ghidra.framework.OperatingSystem;
import ghidra.framework.Platform;
import java.awt.Container;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.dnd.Autoscroll;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class AutoscrollAdapter
implements Autoscroll {
    private static final int MARGIN = 30;
    private JComponent component;
    private int scrollIncrement;

    public AutoscrollAdapter(JComponent component, int scrollIncrement) {
        this.component = component;
        this.scrollIncrement = scrollIncrement;
    }

    @Override
    public Insets getAutoscrollInsets() {
        Rectangle outer = this.component.getBounds();
        return new Insets(outer.y + 30, outer.x + 30, outer.height - 30, outer.width - 30);
    }

    @Override
    public void autoscroll(Point p) {
        if (Platform.CURRENT_PLATFORM.getOperatingSystem() != OperatingSystem.WINDOWS) {
            this.autoscrollNonWindows();
            return;
        }
        Rectangle visRect = this.component.getVisibleRect();
        int scrollAmount = 0;
        if (p.y < visRect.y + 30) {
            scrollAmount = -((visRect.y + 30 - p.y) * this.scrollIncrement) / 2;
        } else if (p.y > visRect.y + visRect.height - 30) {
            scrollAmount = (p.y - (visRect.y + visRect.height - 30)) * this.scrollIncrement / 2;
        }
        visRect.y += scrollAmount;
        int compHeight = this.component.getSize().height;
        if (visRect.y < 0) {
            visRect.y = 0;
        } else if (visRect.y >= compHeight - visRect.height) {
            visRect.y = compHeight - visRect.height - 1;
        }
        this.component.scrollRectToVisible(visRect);
    }

    private void autoscrollNonWindows() {
        boolean overLowerAutoScrollArea;
        boolean withinHorizontally;
        Container releativeToComponent = this.component.getParent().getParent();
        PointerInfo pointerInfo = MouseInfo.getPointerInfo();
        if (pointerInfo == null) {
            return;
        }
        Point mouseLocation = pointerInfo.getLocation();
        SwingUtilities.convertPointFromScreen(mouseLocation, releativeToComponent);
        Rectangle bounds = releativeToComponent.getBounds();
        int componentEndX = bounds.x + bounds.width;
        boolean bl = withinHorizontally = mouseLocation.x >= bounds.x && mouseLocation.x <= componentEndX;
        if (!withinHorizontally) {
            return;
        }
        int scrollAmount = 0;
        int upperAutoScrollEndY = bounds.y + 30;
        boolean overUpperAutoScrollArea = mouseLocation.y < upperAutoScrollEndY;
        int lowerScrollAreaStartY = bounds.y + bounds.height - 30;
        boolean bl2 = overLowerAutoScrollArea = mouseLocation.y > lowerScrollAreaStartY;
        if (overUpperAutoScrollArea) {
            int midUpperScrollArea = upperAutoScrollEndY - 15;
            scrollAmount = mouseLocation.y < midUpperScrollArea ? -(this.scrollIncrement * 3) : -this.scrollIncrement;
        } else if (overLowerAutoScrollArea) {
            int midLowerScrollArea = lowerScrollAreaStartY + 15;
            scrollAmount = mouseLocation.y > midLowerScrollArea ? this.scrollIncrement * 3 : this.scrollIncrement;
        }
        Rectangle visRect = this.component.getVisibleRect();
        visRect.y += scrollAmount;
        int compHeight = this.component.getSize().height;
        if (visRect.y < 0) {
            visRect.y = 0;
        } else if (visRect.y >= compHeight - visRect.height) {
            visRect.y = compHeight - visRect.height - 1;
        }
        this.component.scrollRectToVisible(visRect);
    }
}

