/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.functiongraph.action;

import docking.ComponentProvider;
import ghidra.app.context.ListingActionContext;
import ghidra.app.context.RestrictedAddressSetContext;
import ghidra.app.nav.Navigatable;
import ghidra.app.plugin.core.functiongraph.FGProvider;
import ghidra.app.plugin.core.functiongraph.action.FunctionGraphVertexLocationContextIf;
import ghidra.app.plugin.core.functiongraph.action.VertexActionContextInfo;
import ghidra.app.plugin.core.functiongraph.graph.vertex.FGVertex;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class FunctionGraphEditableVertexLocationActionContext
extends ListingActionContext
implements FunctionGraphVertexLocationContextIf,
RestrictedAddressSetContext {
    private final VertexActionContextInfo vertexInfo;

    public FunctionGraphEditableVertexLocationActionContext(FGProvider functionGraphProvider, VertexActionContextInfo vertexInfo) {
        super((ComponentProvider)functionGraphProvider, (Navigatable)functionGraphProvider);
        if (vertexInfo == null) {
            throw new NullPointerException("VertexActionContextInfo cannot be null");
        }
        this.vertexInfo = vertexInfo;
    }

    @Override
    public FGVertex getVertex() {
        return this.vertexInfo.getActiveVertex();
    }

    @Override
    public VertexActionContextInfo getVertexInfo() {
        return this.vertexInfo;
    }

    @Override
    public Set<FGVertex> getSelectedVertices() {
        return this.vertexInfo.getSelectedVertices();
    }

    public boolean hasSelection() {
        FGProvider provider = (FGProvider)this.getComponentProvider();
        String textSelection = provider.getTextSelection();
        if (!StringUtils.isBlank((CharSequence)textSelection)) {
            return true;
        }
        return super.hasSelection();
    }
}

