/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.relocation;

import ghidra.app.util.bin.format.RelocationException;
import ghidra.app.util.bin.format.macho.MachHeader;
import ghidra.app.util.bin.format.macho.RelocationInfo;
import ghidra.app.util.bin.format.macho.Section;
import ghidra.app.util.bin.format.macho.commands.NList;
import ghidra.app.util.bin.format.macho.commands.SymbolTableCommand;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.util.NumericUtilities;

public class MachoRelocation {
    private Program program;
    private AddressSpace space;
    private MachHeader machoHeader;
    private Address relocationAddress;
    private RelocationInfo relocationInfo;
    private Symbol targetSymbol;
    private Section targetSection;
    private Address targetPointer;
    private RelocationInfo relocationInfoExtra;
    private Symbol targetSymbolExtra;
    private Section targetSectionExtra;
    private Address targetPointerExtra;

    public MachoRelocation(Program program, MachHeader machoHeader, Address relocationAddress, RelocationInfo relocationInfo) {
        this.program = program;
        this.space = program.getAddressFactory().getDefaultAddressSpace();
        this.machoHeader = machoHeader;
        this.relocationAddress = relocationAddress;
        this.relocationInfo = relocationInfo;
        if (relocationInfo.isScattered()) {
            this.targetPointer = this.space.getAddress((long)relocationInfo.getValue());
        } else if (relocationInfo.isExternal()) {
            this.targetSymbol = this.findTargetSymbol(relocationInfo);
        } else {
            this.targetSection = this.findTargetSection(relocationInfo);
        }
    }

    public MachoRelocation(Program program, MachHeader machoHeader, Address relocationAddress, RelocationInfo relocationInfo, RelocationInfo relocationInfoExtra) {
        this(program, machoHeader, relocationAddress, relocationInfo);
        this.relocationInfoExtra = relocationInfoExtra;
        if (relocationInfoExtra.isScattered()) {
            this.targetPointerExtra = this.space.getAddress((long)relocationInfoExtra.getValue());
        } else if (relocationInfoExtra.isExternal()) {
            this.targetSymbolExtra = this.findTargetSymbol(relocationInfoExtra);
        } else {
            this.targetSectionExtra = this.findTargetSection(relocationInfoExtra);
        }
    }

    public Program getProgram() {
        return this.program;
    }

    public Address getRelocationAddress() {
        return this.relocationAddress;
    }

    public RelocationInfo getRelocationInfo() {
        return this.relocationInfo;
    }

    public RelocationInfo getRelocationInfoExtra() {
        return this.relocationInfoExtra;
    }

    public Address getTargetAddress() throws RelocationException {
        if (this.targetSymbol != null) {
            return this.targetSymbol.getAddress();
        }
        if (this.targetSection != null) {
            return this.space.getAddress(this.targetSection.getAddress());
        }
        if (this.targetPointer != null) {
            return this.targetPointer;
        }
        throw new RelocationException("Relocation target not found");
    }

    public Address getTargetAddressExtra() throws RelocationException {
        if (this.targetSymbolExtra != null) {
            return this.targetSymbolExtra.getAddress();
        }
        if (this.targetSectionExtra != null) {
            return this.space.getAddress(this.targetSectionExtra.getAddress());
        }
        if (this.targetPointerExtra != null) {
            return this.targetPointerExtra;
        }
        throw new RelocationException("Extra relocation target not found");
    }

    public boolean requiresRelocation() {
        boolean requires;
        boolean bl = requires = this.relocationInfo.isExternal() && !this.relocationInfo.isScattered();
        if (this.relocationInfoExtra != null) {
            requires = requires || this.relocationInfoExtra.isExternal() && !this.relocationInfoExtra.isScattered();
        }
        return requires;
    }

    public String getTargetDescription() {
        StringBuilder sb = new StringBuilder();
        if (this.targetPointer != null) {
            sb.append(this.targetPointer);
        } else if (this.targetSymbol != null) {
            sb.append(this.targetSymbol.getName());
        } else if (this.targetSection != null) {
            sb.append(this.targetSection.getSectionName());
        } else {
            sb.append(NumericUtilities.toHexString((long)this.relocationInfo.getValue()));
        }
        if (this.relocationInfoExtra != null) {
            sb.append(" / ");
            if (this.targetPointerExtra != null) {
                sb.append(this.targetPointerExtra);
            } else if (this.targetSymbolExtra != null) {
                sb.append(this.targetSymbolExtra.getName());
            } else if (this.targetSectionExtra != null) {
                sb.append(this.targetSectionExtra.getSectionName());
            } else {
                sb.append(NumericUtilities.toHexString((long)this.relocationInfoExtra.getValue()));
            }
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("Symbol: %s, Section: %s\n", this.targetSymbol, this.targetSection));
        sb.append(String.valueOf(this.relocationInfo) + "\n");
        if (this.relocationInfoExtra != null) {
            sb.append(String.format("Symbol: %s, Section: %s\n", this.targetSymbolExtra, this.targetSectionExtra));
            sb.append(this.relocationInfoExtra);
        }
        return sb.toString();
    }

    private Symbol findTargetSymbol(RelocationInfo relocInfo) {
        Symbol sym = null;
        NList nlist = this.machoHeader.getFirstLoadCommand(SymbolTableCommand.class).getSymbolAt(relocInfo.getValue());
        if (nlist != null) {
            Address addr = this.space.getAddress(nlist.getValue());
            sym = this.program.getSymbolTable().getSymbol(SymbolUtilities.replaceInvalidChars((String)nlist.getString(), (boolean)true), addr, null);
            if (sym == null) {
                sym = SymbolUtilities.getLabelOrFunctionSymbol((Program)this.program, (String)nlist.getString(), err -> {});
            }
        }
        return sym;
    }

    private Section findTargetSection(RelocationInfo relocInfo) {
        int index = relocInfo.getValue() - 1;
        if (index >= 0 && index < this.machoHeader.getAllSections().size()) {
            return this.machoHeader.getAllSections().get(index);
        }
        return null;
    }
}

