/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.base.replace.items;

import ghidra.app.services.DataTypeManagerService;
import ghidra.features.base.quickfix.QuickFix;
import ghidra.features.base.quickfix.QuickFixStatus;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Enum;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import java.util.Map;

public class UpdateDataTypeDescriptionQuickFix
extends QuickFix {
    private DataType dataType;

    public UpdateDataTypeDescriptionQuickFix(Program program, DataType dataType, String newDescription) {
        super(program, UpdateDataTypeDescriptionQuickFix.getDescription(dataType), newDescription);
        this.dataType = dataType;
    }

    @Override
    public String getItemType() {
        return "Datatype Description";
    }

    @Override
    public Address getAddress() {
        return null;
    }

    @Override
    public String getPath() {
        return this.dataType.getCategoryPath().getPath();
    }

    @Override
    public String doGetCurrent() {
        if (this.dataType.isDeleted()) {
            return null;
        }
        return UpdateDataTypeDescriptionQuickFix.getDescription(this.dataType);
    }

    private static String getDescription(DataType dt) {
        if (dt instanceof Composite) {
            Composite composite = (Composite)dt;
            return composite.getDescription();
        }
        if (dt instanceof Enum) {
            Enum enumDataType = (Enum)dt;
            return enumDataType.getDescription();
        }
        return null;
    }

    @Override
    public void execute() {
        try {
            DataType dataType = this.dataType;
            if (dataType instanceof Composite) {
                Composite composite = (Composite)dataType;
                composite.setDescription(this.replacement);
            } else {
                dataType = this.dataType;
                if (dataType instanceof Enum) {
                    Enum enumDataType = (Enum)dataType;
                    enumDataType.setDescription(this.replacement);
                }
            }
        }
        catch (Exception e) {
            this.setStatus(QuickFixStatus.ERROR, "Rename datatype failed: " + e.getMessage());
        }
    }

    @Override
    public ProgramLocation getProgramLocation() {
        return null;
    }

    @Override
    protected boolean navigateSpecial(ServiceProvider services, boolean fromSelectionChange) {
        DataTypeManagerService dtmService = (DataTypeManagerService)services.getService(DataTypeManagerService.class);
        if (dtmService == null) {
            return false;
        }
        dtmService.setDataTypeSelected(this.dataType);
        if (!fromSelectionChange) {
            dtmService.edit(this.dataType);
        }
        return true;
    }

    @Override
    public Map<String, String> getCustomToolTipData() {
        return Map.of("Category", this.dataType.getCategoryPath().toString());
    }

    @Override
    public String getActionName() {
        return "Update";
    }
}

