/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.type;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.Numeric;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordCategory;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.StringParseType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractCompositeMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.MsProperty;

public class InterfaceMsType
extends AbstractCompositeMsType {
    public static final int PDB_ID = 5401;
    private static final String TYPE_STRING = "interface";

    public InterfaceMsType(AbstractPdb pdb, PdbByteReader reader) throws PdbException {
        super(pdb, reader);
        this.count = reader.parseUnsignedShortVal();
        this.property = new MsProperty(reader);
        this.fieldDescriptorListRecordNumber = RecordNumber.parse(pdb, reader, RecordCategory.TYPE, 32);
        this.derivedFromListRecordNumber = RecordNumber.parse(pdb, reader, RecordCategory.TYPE, 32);
        this.vShapeTableRecordNumber = RecordNumber.parse(pdb, reader, RecordCategory.TYPE, 32);
        Numeric numeric = new Numeric(reader);
        if (!numeric.isIntegral()) {
            throw new PdbException("Expecting integral numeric");
        }
        this.size = numeric.getIntegral();
        if (reader.hasMoreNonPad()) {
            this.name = reader.parseString(pdb, StringParseType.StringNt);
            if (reader.hasMoreNonPad()) {
                this.mangledName = reader.parseString(pdb, StringParseType.StringNt);
            }
        }
        reader.skipPadding();
    }

    @Override
    public int getPdbId() {
        return 5401;
    }

    @Override
    public void emit(StringBuilder builder, AbstractMsType.Bind bind) {
        StringBuilder myBuilder = new StringBuilder();
        myBuilder.append(this.getTypeString());
        myBuilder.append(" ");
        myBuilder.append(this.name);
        myBuilder.append("<");
        myBuilder.append(this.count);
        myBuilder.append(",");
        myBuilder.append(this.property);
        myBuilder.append(">");
        AbstractMsType fieldType = this.getFieldDescriptorListType();
        myBuilder.append(fieldType);
        myBuilder.append(" ");
        builder.insert(0, myBuilder);
    }

    @Override
    protected String getTypeString() {
        return TYPE_STRING;
    }
}

