/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util;

import ghidra.util.BigEndianDataConverter;
import ghidra.util.LittleEndianDataConverter;
import java.io.Serializable;
import java.math.BigInteger;

public interface DataConverter
extends Serializable {
    public static DataConverter getInstance(boolean isBigEndian) {
        return isBigEndian ? BigEndianDataConverter.INSTANCE : LittleEndianDataConverter.INSTANCE;
    }

    default public boolean isBigEndian() {
        return this instanceof BigEndianDataConverter;
    }

    default public short getShort(byte[] b) {
        return this.getShort(b, 0);
    }

    public short getShort(byte[] var1, int var2);

    default public int getInt(byte[] b) {
        return this.getInt(b, 0);
    }

    public int getInt(byte[] var1, int var2);

    default public long getLong(byte[] b) {
        return this.getLong(b, 0);
    }

    public long getLong(byte[] var1, int var2);

    default public long getValue(byte[] b, int size) {
        return this.getValue(b, 0, size);
    }

    public long getValue(byte[] var1, int var2, int var3);

    default public long getSignedValue(byte[] b, int size) {
        return this.getSignedValue(b, 0, size);
    }

    default public long getSignedValue(byte[] b, int offset, int size) {
        long val = this.getValue(b, offset, size);
        int shiftBits = (8 - size) * 8;
        val <<= shiftBits;
        return val >>= shiftBits;
    }

    default public BigInteger getBigInteger(byte[] b, int size, boolean signed) {
        return this.getBigInteger(b, 0, size, signed);
    }

    public BigInteger getBigInteger(byte[] var1, int var2, int var3, boolean var4);

    default public byte[] getBytes(short value) {
        byte[] bytes = new byte[2];
        this.getBytes(value, bytes);
        return bytes;
    }

    default public byte[] getBytes(int value) {
        byte[] bytes = new byte[4];
        this.getBytes(value, bytes);
        return bytes;
    }

    default public byte[] getBytes(long value) {
        byte[] bytes = new byte[8];
        this.getBytes(value, bytes);
        return bytes;
    }

    default public byte[] getBytes(BigInteger value, int size) {
        byte[] bytes = new byte[size];
        this.putBigInteger(bytes, 0, size, value);
        return bytes;
    }

    default public void putShort(byte[] b, short value) {
        this.putShort(b, 0, value);
    }

    public void putShort(byte[] var1, int var2, short var3);

    default public void putInt(byte[] b, int value) {
        this.putInt(b, 0, value);
    }

    public void putInt(byte[] var1, int var2, int var3);

    default public void putLong(byte[] b, long value) {
        this.putLong(b, 0, value);
    }

    default public void putLong(byte[] b, int offset, long value) {
        this.putValue(value, 8, b, offset);
    }

    public void putValue(long var1, int var3, byte[] var4, int var5);

    default public void putBigInteger(byte[] b, int size, BigInteger value) {
        this.putBigInteger(b, 0, size, value);
    }

    public void putBigInteger(byte[] var1, int var2, int var3, BigInteger var4);

    default public void getBytes(short value, byte[] b) {
        this.getBytes(value, b, 0);
    }

    default public void getBytes(short value, byte[] b, int offset) {
        this.putShort(b, offset, value);
    }

    default public void getBytes(int value, byte[] b) {
        this.getBytes(value, b, 0);
    }

    default public void getBytes(int value, byte[] b, int offset) {
        this.putInt(b, offset, value);
    }

    default public void getBytes(long value, byte[] b) {
        this.getBytes(value, b, 0);
    }

    default public void getBytes(long value, byte[] b, int offset) {
        this.putLong(b, offset, value);
    }

    default public void getBytes(long value, int size, byte[] b, int offset) {
        this.putValue(value, size, b, offset);
    }

    default public void getBytes(BigInteger value, int size, byte[] b, int offset) {
        this.putBigInteger(b, offset, size, value);
    }

    public static long swapBytes(long val, int size) {
        long res = 0L;
        while (size > 0) {
            res <<= 8;
            res |= val & 0xFFL;
            val >>>= 8;
            --size;
        }
        return res;
    }
}

