/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.decompiler.component;

import docking.DockingWindowManager;
import docking.Tool;
import docking.widgets.FindDialog;
import docking.widgets.FindDialogSearcher;
import docking.widgets.SearchLocation;
import docking.widgets.button.GButton;
import docking.widgets.fieldpanel.support.FieldLocation;
import docking.widgets.table.AbstractDynamicTableColumnStub;
import docking.widgets.table.DynamicTableColumn;
import docking.widgets.table.GTableCellRenderingData;
import docking.widgets.table.TableColumnDescriptor;
import ghidra.app.decompiler.component.DecompilerPanel;
import ghidra.app.plugin.core.decompile.actions.DecompilerSearchLocation;
import ghidra.app.plugin.core.decompile.actions.DecompilerSearcher;
import ghidra.app.plugin.core.navigation.locationreferences.LocationReferenceContext;
import ghidra.app.plugin.core.table.TableComponentProvider;
import ghidra.app.util.query.TableService;
import ghidra.docking.settings.Settings;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.exception.CancelledException;
import ghidra.util.table.GhidraProgramTableModel;
import ghidra.util.table.GhidraTable;
import ghidra.util.table.GhidraThreadedTablePanel;
import ghidra.util.table.column.AbstractGhidraColumnRenderer;
import ghidra.util.table.column.GColumnRenderer;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JButton;
import javax.swing.ListSelectionModel;

public class DecompilerFindDialog
extends FindDialog {
    private DecompilerPanel decompilerPanel;
    private GButton showAllButton;

    public DecompilerFindDialog(DecompilerPanel decompilerPanel) {
        super("Decompiler Find Text", (FindDialogSearcher)new DecompilerSearcher(decompilerPanel));
        this.decompilerPanel = decompilerPanel;
        this.setHelpLocation(new HelpLocation("DecompilePlugin", "ActionFind"));
        this.showAllButton = new GButton("Search All");
        this.showAllButton.addActionListener(e -> this.showAll());
        this.removeButton(this.dismissButton);
        this.addButton((JButton)this.showAllButton);
        this.addButton(this.dismissButton);
    }

    protected void enableButtons(boolean b) {
        super.enableButtons(b);
        this.showAllButton.setEnabled(b);
    }

    private void showAll() {
        String searchText = this.getSearchText();
        this.close();
        DockingWindowManager dwm = DockingWindowManager.getActiveInstance();
        Tool tool = dwm.getTool();
        TableService tableService = (TableService)tool.getService(TableService.class);
        if (tableService == null) {
            Msg.error((Object)((Object)this), (Object)"Cannot use the Decompiler Search All action without having a TableService installed");
            return;
        }
        List results = this.searcher.searchAll(searchText, this.useRegex());
        if (!results.isEmpty()) {
            this.storeSearchText(this.getSearchText());
        }
        Program program = this.decompilerPanel.getProgram();
        DecompilerFindResultsModel model = new DecompilerFindResultsModel((ServiceProvider)tool, program, results);
        String title = "Decompiler Search '%s'".formatted(this.getSearchText());
        String type = "Decompiler Search Results";
        String subMenuName = "Search";
        TableComponentProvider provider = tableService.showTable(title, type, (GhidraProgramTableModel)model, subMenuName, null);
        provider.removeAllActions();
        provider.installRemoveItemsAction();
        GhidraThreadedTablePanel panel = provider.getThreadedTablePanel();
        GhidraTable table = panel.getTable();
        ListSelectionModel selectionModel = table.getSelectionModel();
        selectionModel.setSelectionMode(0);
        selectionModel.addListSelectionListener(lse -> {
            if (lse.getValueIsAdjusting()) {
                return;
            }
            int row = table.getSelectedRow();
            if (row == -1) {
                this.searcher.highlightSearchResults(null);
                return;
            }
            DecompilerSearchLocation location = (DecompilerSearchLocation)((Object)((Object)model.getRowObject(row)));
            this.notifySearchHit(location);
        });
        provider.setClosedCallback(() -> this.decompilerPanel.setSearchResults(null));
        provider.setTabText("'%s'".formatted(this.getSearchText()));
    }

    private class DecompilerFindResultsModel
    extends GhidraProgramTableModel<DecompilerSearchLocation> {
        private List<DecompilerSearchLocation> searchLocations;

        DecompilerFindResultsModel(ServiceProvider sp, Program program, List<SearchLocation> searchLocations) {
            super("Decompiler Search All Results", sp, program, null);
            this.searchLocations = searchLocations.stream().map(l -> (DecompilerSearchLocation)((Object)l)).collect(Collectors.toList());
        }

        protected TableColumnDescriptor<DecompilerSearchLocation> createTableColumnDescriptor() {
            TableColumnDescriptor descriptor = new TableColumnDescriptor();
            descriptor.addVisibleColumn((DynamicTableColumn)new LineNumberColumn(this), 1, true);
            descriptor.addVisibleColumn((DynamicTableColumn)new ContextColumn(this));
            return descriptor;
        }

        protected void doLoad(Accumulator<DecompilerSearchLocation> accumulator, TaskMonitor monitor) throws CancelledException {
            for (DecompilerSearchLocation location : this.searchLocations) {
                accumulator.add((Object)location);
            }
        }

        public ProgramLocation getProgramLocation(int modelRow, int modelColumn) {
            return null;
        }

        public ProgramSelection getProgramSelection(int[] modelRows) {
            return new ProgramSelection();
        }

        private class LineNumberColumn
        extends AbstractDynamicTableColumnStub<DecompilerSearchLocation, Integer> {
            private LineNumberColumn(DecompilerFindResultsModel decompilerFindResultsModel) {
            }

            public Integer getValue(DecompilerSearchLocation rowObject, Settings settings, ServiceProvider sp) throws IllegalArgumentException {
                FieldLocation fieldLocation = rowObject.getFieldLocation();
                return fieldLocation.getIndex().intValue() + 1;
            }

            public String getColumnName() {
                return "Line";
            }

            public int getColumnPreferredWidth() {
                return 75;
            }
        }

        private class ContextColumn
        extends AbstractDynamicTableColumnStub<DecompilerSearchLocation, LocationReferenceContext> {
            private GColumnRenderer<LocationReferenceContext> renderer = new ContextCellRenderer();

            private ContextColumn(DecompilerFindResultsModel decompilerFindResultsModel) {
            }

            public LocationReferenceContext getValue(DecompilerSearchLocation rowObject, Settings settings, ServiceProvider sp) throws IllegalArgumentException {
                LocationReferenceContext context = rowObject.getContext();
                return context;
            }

            public String getColumnName() {
                return "Context";
            }

            public GColumnRenderer<LocationReferenceContext> getColumnRenderer() {
                return this.renderer;
            }

            private class ContextCellRenderer
            extends AbstractGhidraColumnRenderer<LocationReferenceContext> {
                private ContextCellRenderer() {
                    this.setHTMLRenderingEnabled(true);
                }

                public Component getTableCellRendererComponent(GTableCellRenderingData data) {
                    super.getTableCellRendererComponent(data);
                    DecompilerSearchLocation match = (DecompilerSearchLocation)((Object)data.getRowObject());
                    LocationReferenceContext context = match.getContext();
                    String text = context.getBoldMatchingText();
                    this.setText(text);
                    return this;
                }

                public String getFilterString(LocationReferenceContext context, Settings settings) {
                    return context.getPlainText();
                }
            }
        }
    }
}

