/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.time;

import db.Transaction;
import docking.ActionContext;
import docking.ComponentProvider;
import docking.Tool;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.ToggleDockingAction;
import docking.action.builder.ActionBuilder;
import docking.action.builder.ToggleActionBuilder;
import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.plugin.core.debug.gui.DebuggerSnapActionContext;
import ghidra.app.plugin.core.debug.gui.time.DebuggerSnapshotTablePanel;
import ghidra.app.plugin.core.debug.gui.time.DebuggerTimePlugin;
import ghidra.app.plugin.core.debug.gui.time.DebuggerTimeSelectionDialog;
import ghidra.app.services.DebuggerTraceManagerService;
import ghidra.debug.api.tracemgr.DebuggerCoordinates;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.options.SaveState;
import ghidra.framework.plugintool.AutoConfigState;
import ghidra.framework.plugintool.AutoService;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.annotation.AutoConfigStateField;
import ghidra.framework.plugintool.annotation.AutoServiceConsumed;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceDomainObjectListener;
import ghidra.trace.model.target.TraceObjectValue;
import ghidra.trace.model.target.path.KeyPath;
import ghidra.trace.model.time.TraceSnapshot;
import ghidra.trace.model.time.schedule.TraceSchedule;
import ghidra.trace.util.TraceEvent;
import ghidra.trace.util.TraceEvents;
import ghidra.util.HelpLocation;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.invoke.MethodHandles;
import javax.swing.Icon;
import javax.swing.JComponent;

public class DebuggerTimeProvider
extends ComponentProviderAdapter {
    private static final AutoConfigState.ClassHandler<DebuggerTimeProvider> CONFIG_STATE_HANDLER = AutoConfigState.wireHandler(DebuggerTimeProvider.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final TraceDomainObjectListener forRadixTraceListener = new ForRadixTraceListener();
    protected final DebuggerTimePlugin plugin;
    DebuggerCoordinates current = DebuggerCoordinates.NOWHERE;
    @AutoServiceConsumed
    protected DebuggerTraceManagerService traceManager;
    private final AutoService.Wiring autoServiceWiring;
    final DebuggerSnapshotTablePanel mainPanel;
    protected final DebuggerTimeSelectionDialog timeDialog;
    DockingAction actionGoToTime;
    ToggleDockingAction actionHideScratch;
    ToggleDockingAction actionSetRadixDec;
    ToggleDockingAction actionSetRadixHexUpper;
    ToggleDockingAction actionSetRadixHexLower;
    private DebuggerSnapActionContext myActionContext;
    @AutoConfigStateField
    boolean hideScratch = false;

    public DebuggerTimeProvider(DebuggerTimePlugin plugin) {
        super(plugin.getTool(), "Time", plugin.getName());
        this.plugin = plugin;
        this.autoServiceWiring = AutoService.wireServicesConsumed((Plugin)plugin, (Object)((Object)this));
        this.setTitle("Time");
        this.setIcon(DebuggerResources.ICON_PROVIDER_TIME);
        this.setHelpLocation(DebuggerResources.HELP_PROVIDER_TIME);
        this.setWindowMenuGroup("Debugger");
        this.timeDialog = new DebuggerTimeSelectionDialog(this.tool);
        this.mainPanel = new DebuggerSnapshotTablePanel(this.tool);
        this.buildMainPanel();
        this.myActionContext = new DebuggerSnapActionContext(this.current.getTrace(), this.current.getSnap());
        this.createActions();
        this.contextChanged();
        this.setVisible(true);
    }

    public void addLocalAction(DockingActionIf action) {
        super.addLocalAction(action);
    }

    public JComponent getComponent() {
        return this.mainPanel;
    }

    public ActionContext getActionContext(MouseEvent event) {
        if (this.myActionContext == null) {
            return super.getActionContext(event);
        }
        return this.myActionContext;
    }

    protected void buildMainPanel() {
        this.mainPanel.getSelectionModel().addListSelectionListener(evt -> {
            if (evt.getValueIsAdjusting()) {
                return;
            }
            Long snap = this.mainPanel.getSelectedSnapshot();
            if (snap == null) {
                this.myActionContext = null;
                return;
            }
            if (snap.longValue() == this.current.getSnap()) {
                return;
            }
            this.myActionContext = new DebuggerSnapActionContext(this.current.getTrace(), snap);
            this.contextChanged();
        });
        this.mainPanel.snapshotTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && e.getButton() == 1) {
                    DebuggerTimeProvider.this.activateSelectedSnapshot(e);
                }
            }
        });
        this.mainPanel.snapshotTable.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    DebuggerTimeProvider.this.activateSelectedSnapshot(e);
                    e.consume();
                }
            }
        });
    }

    private TraceSchedule computeSelectedSchedule(InputEvent e, long snap) {
        if ((e.getModifiersEx() & 0x40) != 0) {
            return TraceSchedule.snap((long)snap);
        }
        if (snap >= 0L) {
            return TraceSchedule.snap((long)snap);
        }
        Trace trace = this.current.getTrace();
        if (trace == null) {
            return TraceSchedule.snap((long)snap);
        }
        TraceSnapshot snapshot = trace.getTimeManager().getSnapshot(snap, false);
        if (snapshot == null) {
            return TraceSchedule.snap((long)snap);
        }
        TraceSchedule schedule = snapshot.getSchedule();
        if (schedule == null) {
            return TraceSchedule.snap((long)snap);
        }
        return schedule;
    }

    private void activateSelectedSnapshot(InputEvent e) {
        if (this.traceManager == null) {
            return;
        }
        Long snap = this.mainPanel.getSelectedSnapshot();
        if (snap == null) {
            return;
        }
        this.traceManager.activateTime(this.computeSelectedSchedule(e, snap));
    }

    protected void createActions() {
        this.actionGoToTime = (DockingAction)((ActionBuilder)((ActionBuilder)GoToTimeAction.builder(this.plugin).enabledWhen(c -> this.current.getTrace() != null)).onAction(c -> this.activatedGoToTime())).buildAndInstall((Tool)this.tool);
        this.actionHideScratch = (ToggleDockingAction)((ToggleActionBuilder)DebuggerResources.HideScratchSnapshotsAction.builder(this.plugin).selected(this.hideScratch).onAction(this::activatedHideScratch)).buildAndInstallLocal((ComponentProvider)this);
        this.actionSetRadixDec = (ToggleDockingAction)((ToggleActionBuilder)((ToggleActionBuilder)SetTimeRadixAction.builder("Decimal", this.plugin).enabledWhen(c -> this.current.getTrace() != null && this.current.getTrace().getObjectManager().getRootObject() != null)).onAction(c -> this.activatedSetRadix(TraceSchedule.TimeRadix.DEC))).buildAndInstall((Tool)this.tool);
        this.actionSetRadixHexUpper = (ToggleDockingAction)((ToggleActionBuilder)((ToggleActionBuilder)SetTimeRadixAction.builder("Upper Hex", this.plugin).enabledWhen(c -> this.current.getTrace() != null && this.current.getTrace().getObjectManager().getRootObject() != null)).onAction(c -> this.activatedSetRadix(TraceSchedule.TimeRadix.HEX_UPPER))).buildAndInstall((Tool)this.tool);
        this.actionSetRadixHexLower = (ToggleDockingAction)((ToggleActionBuilder)((ToggleActionBuilder)SetTimeRadixAction.builder("Lower Hex", this.plugin).enabledWhen(c -> this.current.getTrace() != null && this.current.getTrace().getObjectManager().getRootObject() != null)).onAction(c -> this.activatedSetRadix(TraceSchedule.TimeRadix.HEX_LOWER))).buildAndInstall((Tool)this.tool);
    }

    private void activatedGoToTime() {
        TraceSchedule time = this.timeDialog.promptTime(this.current.getTrace(), this.current.getTime());
        if (time == null) {
            return;
        }
        this.traceManager.activateTime(time);
    }

    private void activatedHideScratch(ActionContext ctx) {
        this.hideScratch = !this.hideScratch;
        this.mainPanel.setHideScratchSnapshots(this.hideScratch);
    }

    private void activatedSetRadix(TraceSchedule.TimeRadix radix) {
        try (Transaction tx = this.current.getTrace().openTransaction("Set Time Radix");){
            this.current.getTrace().getTimeManager().setTimeRadix(radix);
        }
    }

    protected void removeTraceListener() {
        if (this.current.getTrace() != null) {
            this.current.getTrace().removeListener((DomainObjectListener)this.forRadixTraceListener);
        }
    }

    protected void addTraceListener() {
        if (this.current.getTrace() != null) {
            this.current.getTrace().addListener((DomainObjectListener)this.forRadixTraceListener);
        }
    }

    public void coordinatesActivated(DebuggerCoordinates coordinates) {
        this.removeTraceListener();
        this.current = coordinates;
        this.addTraceListener();
        this.mainPanel.setTrace(this.current.getTrace());
        this.mainPanel.setCurrent(this.current);
        this.refreshRadixSelection();
    }

    private void refreshRadixSelection() {
        TraceSchedule.TimeRadix radix = this.current.getTrace() == null ? TraceSchedule.TimeRadix.DEFAULT : this.current.getTrace().getTimeManager().getTimeRadix();
        this.actionSetRadixHexLower.setSelected(radix == TraceSchedule.TimeRadix.HEX_LOWER);
        this.actionSetRadixHexUpper.setSelected(radix == TraceSchedule.TimeRadix.HEX_UPPER);
        this.actionSetRadixDec.setSelected(radix == TraceSchedule.TimeRadix.DEC);
    }

    public void writeConfigState(SaveState saveState) {
        CONFIG_STATE_HANDLER.writeConfigState((Object)this, saveState);
    }

    public void readConfigState(SaveState saveState) {
        CONFIG_STATE_HANDLER.readConfigState((Object)this, saveState);
        this.actionHideScratch.setSelected(this.hideScratch);
        this.mainPanel.setHideScratchSnapshots(this.hideScratch);
    }

    protected class ForRadixTraceListener
    extends TraceDomainObjectListener {
        protected ForRadixTraceListener() {
            this.listenFor((TraceEvent)TraceEvents.VALUE_CREATED, this::valueCreated);
            this.listenFor((TraceEvent)TraceEvents.VALUE_DELETED, this::valueDeleted);
        }

        private void valueCreated(TraceObjectValue value) {
            if (value.getCanonicalPath().equals((Object)KeyPath.of((String[])new String[]{"_time_radix"}))) {
                DebuggerTimeProvider.this.refreshRadixSelection();
            }
        }

        private void valueDeleted(TraceObjectValue value) {
            if (value.getCanonicalPath().equals((Object)KeyPath.of((String[])new String[]{"_time_radix"}))) {
                DebuggerTimeProvider.this.refreshRadixSelection();
            }
        }
    }

    static interface GoToTimeAction {
        public static final String NAME = "Go To Time";
        public static final String DESCRIPTION = "Go to a specific time, optionally using emulation";
        public static final String GROUP = "Dbg7. Trace";
        public static final Icon ICON = DebuggerResources.ICON_TIME;
        public static final String HELP_ANCHOR = "goto_time";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).description(DESCRIPTION)).menuPath(new String[]{"Debugger", NAME})).menuGroup(GROUP)).menuIcon(ICON)).keyBinding("CTRL G")).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    static interface SetTimeRadixAction {
        public static final String NAME = "Set Time Radix";
        public static final String DESCRIPTION = "Change the time radix for this trace / target";
        public static final String GROUP = "Dbg7. Trace";
        public static final String HELP_ANCHOR = "radix";

        public static ToggleActionBuilder builder(String title, Plugin owner) {
            String ownerName = owner.getName();
            return (ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)new ToggleActionBuilder("Set Time Radix - " + title, ownerName).description(DESCRIPTION)).menuPath(new String[]{"Debugger", NAME, title})).menuGroup(GROUP)).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }
}

